"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZHSPhoneLoginScript = exports.ZHSUnitLoginScript = void 0;
const utils_1 = require("../../utils");
const script_1 = require("../../script");
exports.ZHSUnitLoginScript = new script_1.PlaywrightScript({
    schoolname: {
        label: '学校',
        value: ''
    },
    id: {
        label: '学号',
        value: ''
    },
    password: {
        label: '密码',
        value: ''
    }
}, {
    name: '智慧树-学校登录',
    run(page, configs, options) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                if (yield isNotLogin(page)) {
                    yield page.click('#qStudentID');
                    // 取消我知道了弹窗
                    yield page.waitForTimeout(1000);
                    yield page.evaluate('userindex.closeStuCodeFirstLoginTip();');
                    yield (0, utils_1.slowType)(page, '#quickSearch', configs.schoolname);
                    // 显示学校列表
                    yield Promise.all([
                        /** 为防止页面未加载学校数据，所以这里即可能为远程加载或者缓存读取学校记录 */
                        Promise.race([
                            /** 等待请求完成 */
                            page.waitForResponse(/getAllSchool/),
                            /** 等待元素出现 */
                            page.waitForSelector('#schoolListCode li')
                        ]),
                        page.evaluate('userindex.selectSchoolByName();')
                    ]);
                    // 单击第一个匹配的学校
                    yield page.click('#schoolListCode li');
                    yield page.fill('#clCode', configs.id);
                    yield page.fill('#clPassword', configs.password);
                    yield page.waitForTimeout(3000);
                    yield page.click('.wall-sub-btn');
                    if ((options === null || options === void 0 ? void 0 : options.ocrApiUrl) && (options === null || options === void 0 ? void 0 : options.detTargetKey) && (options === null || options === void 0 ? void 0 : options.detBackgroundKey)) {
                        let count = 5;
                        while (yield isNotVerified(page)) {
                            if (count > 0) {
                                count--;
                                yield verify(page, {
                                    ocrApiUrl: options.ocrApiUrl,
                                    detTargetKey: options.detTargetKey,
                                    detBackgroundKey: options.detBackgroundKey
                                });
                                yield page.waitForTimeout(2000);
                            }
                            else {
                                throw new Error('滑块识别失败，请手动登录。');
                            }
                        }
                    }
                }
            }
            catch (err) {
                exports.ZHSUnitLoginScript.emit('script-error', String(err));
            }
        });
    }
});
exports.ZHSPhoneLoginScript = new script_1.PlaywrightScript({
    phone: {
        label: '手机号',
        value: ''
    },
    password: {
        label: '密码',
        value: ''
    }
}, {
    name: '智慧树-手机密码登录',
    run(page, configs, options) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                if (yield isNotLogin(page)) {
                    yield page.click('#qSignin');
                    yield page.fill('#lUsername', configs.phone);
                    yield page.fill('#lPassword', configs.password);
                    yield page.waitForTimeout(3000);
                    yield page.click('.wall-sub-btn');
                    if ((options === null || options === void 0 ? void 0 : options.ocrApiUrl) && (options === null || options === void 0 ? void 0 : options.detTargetKey) && (options === null || options === void 0 ? void 0 : options.detBackgroundKey)) {
                        let count = 5;
                        while ((yield isNotVerified(page)) && count > 0) {
                            count--;
                            yield verify(page, {
                                ocrApiUrl: options.ocrApiUrl,
                                detTargetKey: options.detTargetKey,
                                detBackgroundKey: options.detBackgroundKey
                            });
                            yield page.waitForTimeout(2000);
                        }
                    }
                }
            }
            catch (err) {
                exports.ZHSPhoneLoginScript.emit('script-error', String(err));
            }
        });
    }
});
/**
 * 滑块验证
 */
function verify(page, opts) {
    return __awaiter(this, void 0, void 0, function* () {
        // 删除yidun遮挡
        yield page.evaluate(() => document.querySelectorAll('.yidun_cover-frame,.yidun_popup__mask').forEach((el) => el.remove()));
        const det_slider_el = yield page.$('.yidun_slider');
        const det_target_el = yield page.$('[alt="验证码滑块"]');
        const det_bg_el = yield page.$('[alt="验证码背景"]');
        if (det_target_el && det_slider_el && det_bg_el) {
            const det_target_src = yield det_target_el.getAttribute('src');
            const det_bg_src = yield det_bg_el.getAttribute('src');
            if (det_target_src && det_bg_src) {
                yield (0, utils_1.breakSliderVerify)(page, det_slider_el, yield (0, utils_1.getBase64)(det_target_src), yield (0, utils_1.getBase64)(det_bg_src), Object.assign(Object.assign({}, opts), { offset: 10 }));
            }
        }
    });
}
/** 是否未通过验证 */
function isNotVerified(page) {
    return __awaiter(this, void 0, void 0, function* () {
        yield page.waitForTimeout(2000);
        const errors = yield page.evaluate(() => Array.from(document.querySelectorAll('.switch-wrap-signin.active .form-ipt-error.is-visible'))
            .map((e) => e.textContent || '')
            .filter(Boolean));
        if (errors.length) {
            throw new Error(errors.join('\n'));
        }
        return page.url().includes('passport.zhihuishu.com');
    });
}
function isNotLogin(page) {
    return __awaiter(this, void 0, void 0, function* () {
        yield page.goto('https://www.zhihuishu.com/');
        yield page.waitForTimeout(2000);
        const loginBtnNotDisplay = yield page.evaluate(() => { var _a; return ((_a = document.querySelector('#login')) === null || _a === void 0 ? void 0 : _a.style.display) === 'none'; });
        if (loginBtnNotDisplay) {
            yield page.click('#notLogin');
        }
        else {
            yield page.click('#login');
        }
        yield page.waitForTimeout(2000);
        return loginBtnNotDisplay;
    });
}
