"use strict";
// @ts-check
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initStore = void 0;
const electron_1 = require("electron");
const fs_1 = require("fs");
const store_1 = require("../store");
const semver_1 = require("semver");
const defaultsDeep_1 = __importDefault(require("lodash/defaultsDeep"));
const logger_1 = require("../logger");
const path_1 = __importDefault(require("path"));
const logger = (0, logger_1.Logger)('store-init');
/**
 * 初始化配置
 */
function initStore() {
    const version = store_1.store.store.version;
    logger.log('version', version);
    if (typeof version === 'string') {
        // 当前app版本
        const appVersion = parseVersion(electron_1.app.getVersion());
        // 本地存储的app版本
        const originVersion = parseVersion(version);
        // 是否需要更新设置
        if ((0, semver_1.gt)(appVersion, originVersion)) {
            store_1.store.store = (0, defaultsDeep_1.default)(store_1.store.store, store_1.OriginalAppStore);
        }
    }
    //  初始化
    else {
        const render = store_1.store.store.render ? JSON.parse(JSON.stringify(store_1.store.store.render)) : {};
        store_1.OriginalAppStore.render = render;
        // 初始化设置
        store_1.store.store = store_1.OriginalAppStore;
        logger.log('store', store_1.store.store);
    }
    /**
     * 如果浏览器缓存为空，则初始化，如果不为空那就是用户自己设置了
     */
    if (!store_1.store.store.paths.userDataDirsFolder) {
        store_1.OriginalAppStore.paths.userDataDirsFolder = path_1.default.resolve(electron_1.app.getPath('userData'), './userDataDirs');
    }
    else {
        store_1.OriginalAppStore.paths.userDataDirsFolder = store_1.store.store.paths.userDataDirsFolder;
    }
    // 强制更新路径
    store_1.store.set('paths', store_1.OriginalAppStore.paths);
    if (!(0, fs_1.existsSync)(store_1.store.store.paths.userDataDirsFolder)) {
        (0, fs_1.mkdirSync)(store_1.store.store.paths.userDataDirsFolder, { recursive: true });
    }
    if (!(0, fs_1.existsSync)(store_1.store.store.paths.extensionsFolder)) {
        (0, fs_1.mkdirSync)(store_1.store.store.paths.extensionsFolder, { recursive: true });
    }
    if (!(0, fs_1.existsSync)(store_1.store.store.paths.downloadFolder)) {
        (0, fs_1.mkdirSync)(store_1.store.store.paths.downloadFolder, { recursive: true });
    }
}
exports.initStore = initStore;
/** 字符串转换成版本对象 */
function parseVersion(version) {
    return new semver_1.SemVer((0, semver_1.valid)((0, semver_1.coerce)((0, semver_1.clean)(version, { loose: true }))) || '0.0.0');
}
