"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateApp = exports.updater = void 0;
const electron_1 = require("electron");
const semver_1 = require("semver");
const logger_1 = require("../logger");
const adm_zip_1 = __importDefault(require("adm-zip"));
const path_1 = require("path");
const utils_1 = require("../utils");
const common_1 = require("@ocs-desktop/common");
const fs_1 = require("fs");
const logger = (0, logger_1.Logger)('updater');
function updater() {
    return __awaiter(this, void 0, void 0, function* () {
        const infos = yield common_1.OCSApi.getInfos();
        const versions = infos.versions || [];
        const newVersion = versions.find((version) => (0, semver_1.gt)(version.tag, electron_1.app.getVersion()));
        logger.info('updater', { versions, newVersion });
        /**  更新 */
        if (newVersion) {
            (0, utils_1.moveWindowToTop)();
            (0, utils_1.getCurrentWebContents)().send('detect-new-app-version', newVersion);
        }
    });
}
exports.updater = updater;
function updateApp(newVersion) {
    return __awaiter(this, void 0, void 0, function* () {
        logger.info('更新  : ' + JSON.stringify(newVersion));
        const { tag, url } = newVersion;
        const appPath = electron_1.app.getAppPath();
        /** 日志路径 */
        const logPath = (0, path_1.join)(appPath, `../update-${tag}.log`);
        /** 安装路径 */
        const dest = (0, path_1.join)(appPath, `../app-${tag}.zip`);
        /** 解压路径 */
        const unzipDest = (0, path_1.join)(appPath, './');
        /** 添加日志 */
        (0, fs_1.writeFileSync)(logPath, JSON.stringify(Object.assign(newVersion, { dest, unzipDest }), null, 4));
        logger.info('更新文件 : ' + dest);
        logger.info('解压路径 : ' + unzipDest);
        try {
            /** 下载最新版本 */
            yield (0, utils_1.downloadFile)(url, dest, (rate, totalLength, chunkLength) => {
                (0, utils_1.getCurrentWebContents)().send('update-download', rate, totalLength, chunkLength);
            });
            /**
             * 先下载后删除， 防止下载失败导致程序无法启动
             */
            /** 删除app */
            (0, fs_1.rmSync)(unzipDest, { recursive: true, force: true });
            /** 解压缩 */
            const zip = new adm_zip_1.default(dest);
            new Promise((resolve) => {
                zip.extractAllTo(unzipDest, true);
                resolve();
            })
                .then(() => {
                // @ts-ignore
                electron_1.dialog.showMessageBox(null, {
                    title: 'OCS更新程序',
                    message: '更新完毕，即将重启软件...',
                    type: 'warning',
                    noLink: true
                });
                setTimeout(() => {
                    electron_1.app.relaunch();
                    electron_1.app.quit();
                }, 1000);
            })
                .catch((err) => logger.error('更新失败', err));
        }
        catch (e) {
            logger.error('更新失败', e);
            // @ts-ignore
            const { response } = yield electron_1.dialog.showMessageBox(null, {
                title: 'OCS更新程序',
                message: 'OCS更新失败:\n' + e,
                type: 'error',
                noLink: true,
                defaultId: 1,
                buttons: ['继续使用', '复制错误日志']
            });
            if (response === 1) {
                electron_1.clipboard.writeText(String(e));
            }
        }
    });
}
exports.updateApp = updateApp;
