"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.canOCR = exports.det = exports.ocr = void 0;
const fs_1 = require("fs");
const path_1 = __importDefault(require("path"));
const crypto_1 = require("crypto");
const child_process_1 = __importDefault(require("child_process"));
const logger_1 = require("../logger");
const store_1 = require("../store");
const getOcrFolder = () => path_1.default.join(store_1.store.store.paths.downloadFolder, './apps/ocr');
const logger = (0, logger_1.Logger)('ocr');
/**
 * 使用 ddddocr 进行验证码识别
 * @param base64 图片 base64
 */
function ocr(base64) {
    return new Promise((resolve, reject) => {
        const uuid = (0, crypto_1.randomUUID)();
        const img_cache = path_1.default.join(getOcrFolder(), './img_cache');
        if (!(0, fs_1.existsSync)(img_cache)) {
            (0, fs_1.mkdirSync)(img_cache, { recursive: true });
        }
        const img = path_1.default.join(img_cache, uuid + '.png');
        (0, fs_1.writeFile)(img, base64, 'base64', () => {
            // 要使用 "" 去包裹路径，防止出现空格
            const cmd = [`".${path_1.default.join(getOcrFolder(), getOCRFileName())}"`, '--ocr', `"${img}"`].join(' ');
            logger.log('cmd', cmd);
            child_process_1.default.exec(cmd, (err, stdout, stderr) => {
                if (err || stderr) {
                    reject(err || stderr);
                }
                else {
                    resolve(stdout.trim());
                }
                // 删除图片
                if ((0, fs_1.existsSync)(img)) {
                    (0, fs_1.rmSync)(img);
                }
            });
        });
    });
}
exports.ocr = ocr;
/**
 * 使用 ddddocr 进行滑块识别
 *
 * @param det_target_base64 滑块图片
 * @param det_bg_base64 滑块背景图片
 *
 * target_y: 滑块高度
 * target: [x1,y1,x2,y2]
 */
function det(det_target_base64, det_bg_base64) {
    return new Promise((resolve, reject) => {
        const img_cache = path_1.default.join(getOcrFolder(), './img_cache');
        if (!(0, fs_1.existsSync)(img_cache)) {
            (0, fs_1.mkdirSync)(img_cache, { recursive: true });
        }
        const img1 = path_1.default.join(img_cache, (0, crypto_1.randomUUID)() + '.png');
        const img2 = path_1.default.join(img_cache, (0, crypto_1.randomUUID)() + '.png');
        (0, fs_1.writeFileSync)(img1, det_target_base64, 'base64');
        (0, fs_1.writeFileSync)(img2, det_bg_base64, 'base64');
        const cmd = [
            `"${path_1.default.join(getOcrFolder(), getOCRFileName())}"`,
            '--det-target',
            `"${img1}"`,
            '--det-bg',
            `"${img2}"`
        ].join(' ');
        child_process_1.default.exec(cmd, (err, stdout, stderr) => {
            if (err || stderr) {
                reject(err || stderr);
            }
            else {
                resolve(JSON.parse(stdout.trim().replace(/'/g, '"')));
            }
            // 删除图片
            if ((0, fs_1.existsSync)(img1)) {
                (0, fs_1.rmSync)(img1);
            }
            if ((0, fs_1.existsSync)(img2)) {
                (0, fs_1.rmSync)(img2);
            }
        });
    });
}
exports.det = det;
/** 判断是否能够进行验证码识别 */
function canOCR() {
    return (0, fs_1.existsSync)(path_1.default.join(getOcrFolder(), getOCRFileName()));
}
exports.canOCR = canOCR;
function getOCRFileName() {
    return process.platform === 'win32' ? './ocr.exe' : './ocr';
}
