"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWindow = void 0;
// @ts-check
const electron_1 = require("electron");
const path_1 = __importDefault(require("path"));
function createWindow() {
    const win = new electron_1.BrowserWindow({
        title: 'ocs',
        icon: path_1.default.resolve('./public/favicon.ico'),
        minWidth: 700,
        minHeight: 400,
        width: 900,
        height: 600,
        center: true,
        hasShadow: true,
        autoHideMenuBar: true,
        titleBarStyle: 'hidden',
        titleBarOverlay: {
            color: 'white',
            symbolColor: 'black'
        },
        frame: false,
        show: false,
        webPreferences: {
            zoomFactor: 1,
            // 关闭拼写矫正
            spellcheck: false,
            webSecurity: true,
            // 开启node
            nodeIntegration: true,
            contextIsolation: false
        }
    });
    win.webContents.on('will-navigate', (event, url) => {
        event.preventDefault();
        electron_1.shell.openExternal(url);
    });
    win.webContents.setWindowOpenHandler((detail) => {
        electron_1.shell.openExternal(detail.url);
        return {
            action: 'deny'
        };
    });
    return win;
}
exports.createWindow = createWindow;
