"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.launchBrowser = exports.ScriptWorker = void 0;
const chalk_1 = require("chalk");
const logger_core_1 = require("../logger.core");
const path_1 = __importStar(require("path"));
const fs_1 = __importDefault(require("fs"));
const playwright_core_1 = require("playwright-core");
const index_1 = require("../scripts/index");
const get_1 = __importDefault(require("lodash/get"));
const child_process_1 = __importDefault(require("child_process"));
const browser_1 = require("../utils/browser");
const { bgRedBright, bgBlueBright, bgYellowBright, bgGray } = new chalk_1.Instance({ level: 2 });
/** 脚本工作线程 */
class ScriptWorker {
    constructor() {
        this.uid = '';
        /** 拓展路径 */
        this.extensionPaths = [];
        /** 执行的自动化脚本列表 */
        this.playwrightScripts = [];
    }
    init({ store, uid, cachePath, playwrightScripts, browserInfo, config, langs }) {
        this.debug('正在初始化进程...');
        this.store = store;
        ScriptWorker.langs = langs;
        this.uid = uid;
        // 拓展文件夹路径
        this.extensionPaths = (0, browser_1.getExtensionPaths)(store.paths.extensionsFolder);
        // 自动化脚本
        this.playwrightScripts = playwrightScripts;
        // 初始化日志
        this.logger = new logger_core_1.LoggerCore(store.paths['logs-path'], false, 'script', path_1.default.basename(cachePath));
        // 浏览器中软件设置的名字
        this.browserInfo = browserInfo;
        this.config = config;
        this.debug('初始化成功');
    }
    launch(options) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.extensionPaths.length) {
                this.debug('加载拓展：', this.extensionPaths.map((p) => (0, path_1.basename)(p)));
            }
            else {
                this.debug('浏览器拓展为空');
            }
            /** 添加拓展启动参数 */
            options.args = formatExtensionArguments(this.extensionPaths);
            const start_time = Date.now();
            /** =============================== 检测谷歌浏览器是否可用 =============================== */
            if (!fs_1.default.existsSync(options.executablePath)) {
                console.error(ScriptWorker.lang('error_when_executable_not_found', `浏览器可执行文件不存在，请在设置中更换浏览器路径。：${options.executablePath}`, { executablePath: options.executablePath }));
                return yield this.close();
            }
            if (process.platform === 'win32') {
                const major = (0, browser_1.getBrowserMajorVersion)(options.executablePath);
                console.log('major', major);
                if (major && major > 137) {
                    console.error(ScriptWorker.lang('error_when_browser_version_too_high', '当前浏览器版本过高，无法自动加载脚本管理器，请在设置-浏览器路径中切换“软件内置”浏览器，如果没有内置浏览器，请重新在官网下载最新OCS软件并安装'));
                    return yield this.close();
                }
            }
            /** =============================== 检测拓展是否可用 =============================== */
            for (const extensionPath of this.extensionPaths) {
                if (!fs_1.default.existsSync(extensionPath)) {
                    console.error(`拓展不存在：${extensionPath}`);
                    return yield this.close();
                }
                if (!fs_1.default.existsSync(path_1.default.join(extensionPath, 'manifest.json'))) {
                    console.error(`拓展格式不正确，缺少manifest.json：${extensionPath}`);
                    return yield this.close();
                }
                const manifest = JSON.parse(fs_1.default.readFileSync(path_1.default.join(extensionPath, 'manifest.json'), 'utf-8'));
                // 检查是否为 MV2 拓展，如果是则报错
                if ((0, get_1.default)(manifest, 'manifest_version', 2) < 3) {
                    const name = getExtensionName(extensionPath);
                    console.error(ScriptWorker.lang('error_when_extension_version_too_low', `该拓展版本较低：{{name}}，请尝试前往软件左侧-应用中心-卸载并重新安装。`, { name }));
                    return yield this.close();
                }
            }
            /** 启动浏览器 */
            try {
                yield launchBrowser(Object.assign({ onLaunch: (browser) => {
                        var _a;
                        this.browser = browser;
                        /** URL事件解析器 */
                        (_a = this.browser) === null || _a === void 0 ? void 0 : _a.on('page', (page) => {
                            const match = page.url().match(/ocs-action_(.+)/);
                            if (match === null || match === void 0 ? void 0 : match[1]) {
                                const action = match[1];
                                const actions = {
                                    'bring-to-top': () => {
                                        // 通过命令行打开此页面后会置顶浏览器，并自动关闭当前事件页面
                                        page.close();
                                    }
                                };
                                actions[action]();
                            }
                        });
                        // 浏览器启动完成
                        send('launched');
                    }, playwrightScripts: this.playwrightScripts, bookmarksPageUrl: this.store
                        ? `http://localhost:${((_a = this.store) === null || _a === void 0 ? void 0 : _a.server.port) || 15319}/index.html#/bookmarks`
                        : undefined, serverPort: ((_b = this.store) === null || _b === void 0 ? void 0 : _b.server.port) || 15319, closeableExtensionHomepages: [
                        'docs.scriptcat.org',
                        'docs.scriptcat.org/docs/change',
                        'docs.scriptcat.org/docs/use/open-dev',
                        'tampermonkey.net/index.php',
                        'tampermonkey.net/changelog.php'
                    ], authToken: ((_c = this.store) === null || _c === void 0 ? void 0 : _c.server.authToken) || '', browserInfo: this.browserInfo, uid: this.uid, config: this.config }, options));
            }
            catch (err) {
                // 浏览器异常关闭
                if (err instanceof Error) {
                    if (err.message.includes('browser has been closed') ||
                        err.message.includes('Target closed') ||
                        err.message.includes('Browser closed')) {
                        // 5秒内异常关闭，可能是浏览器问题
                        if (Date.now() - start_time < 5 * 1000) {
                            console.error(ScriptWorker.lang('error_when_browser_launch_failed_too_fast', '异常启动，请尝试重启浏览器，或者在设置中更换其他浏览器', {
                                error: err.message.substring(0, 500)
                            }));
                        }
                        else {
                            console.error('异常关闭，请尝试重启浏览器。', err.message.substring(0, 500));
                        }
                        this.close();
                    }
                    else {
                        console.error('错误 : ', err.message.substring(0, 500));
                    }
                }
                else {
                    console.error('未知错误 : ', String(err).substring(0, 500));
                }
            }
            // 浏览器初始化完成
            send('init');
        });
    }
    close() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            yield ((_a = this.browser) === null || _a === void 0 ? void 0 : _a.close());
            this.browser = undefined;
            send('browser-closed');
            process.exit();
        });
    }
    // TODO
    bringToFront() {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            (_b = (_a = this.browser) === null || _a === void 0 ? void 0 : _a.pages().at(-1)) === null || _b === void 0 ? void 0 : _b.bringToFront();
        });
    }
    /** 跳转到特殊图像共享浏览器窗口 */
    gotoWebRTCPage() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const page = yield ((_a = this.browser) === null || _a === void 0 ? void 0 : _a.newPage());
            if (page) {
                yield page
                    .evaluate((uid) => {
                    document.title = uid;
                    document.body.innerHTML = ScriptWorker.lang('webrtc_page_loading_notice', `正在获取图像中，请勿操作...`);
                }, this.uid)
                    .catch(console.error);
                setTimeout(() => {
                    send('webrtc-page-loaded');
                }, 200);
            }
        });
    }
    /** 关闭特殊图像共享浏览器窗口 */
    closeWebRTCPage() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const pages = ((_a = this.browser) === null || _a === void 0 ? void 0 : _a.pages()) || [];
                for (const page of pages) {
                    const title = yield page.title();
                    if (title === this.uid) {
                        yield page.close();
                    }
                }
            }
            catch (_b) { }
            setTimeout(() => {
                send('webrtc-page-closed');
            }, 200);
        });
    }
    kill() {
        process.exit();
    }
    debug(...msg) {
        console.log(bgGray(loggerPrefix()), ...msg);
    }
    warn(...msg) {
        console.log(bgYellowBright(loggerPrefix()), ...msg);
    }
    info(...msg) {
        console.log(bgBlueBright(loggerPrefix()), ...msg);
    }
    error(...msg) {
        console.error(bgRedBright(loggerPrefix()), ...msg);
    }
}
exports.ScriptWorker = ScriptWorker;
ScriptWorker.lang = (key, def, replace) => {
    const result = (0, get_1.default)(ScriptWorker.langs, key, def);
    return (replace ? result === null || result === void 0 ? void 0 : result.replace(/\{\{(\w+)\}\}/g, (_, k) => replace[k] || '') : result);
};
ScriptWorker.getTransformedErrorMessage = (error, extra_placeholder) => {
    if (error.match(/Timeout .+ exceeded/)) {
        return ScriptWorker.lang('error_when_playwright_selector_timeout', '页面元素查找超时，请检查元素是否存在/可见或选择器是否正确。', Object.assign({ error: error }, extra_placeholder));
    }
    return error;
};
/** 格式化浏览器拓展启动参数 */
function formatExtensionArguments(extensionPaths) {
    const paths = extensionPaths.map((p) => p.replace(/\\/g, '/')).join(',');
    return paths.length === 0 ? [] : [`--load-extension=${paths}`];
}
function loggerPrefix() {
    return `[OCS] ${new Date().toLocaleTimeString()}`;
}
/**
 * 运行脚本
 */
function launchBrowser({ executablePath, headless, args, userDataDir, userscripts, playwrightScripts, closeableExtensionHomepages, bookmarksPageUrl, serverPort, authToken, browserInfo, uid, config, onLaunch }) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            playwright_core_1.chromium
                .launchPersistentContext(userDataDir, {
                headless,
                viewport: null,
                executablePath,
                ignoreHTTPSErrors: true,
                acceptDownloads: true,
                ignoreDefaultArgs: ['--disable-extensions', '--enable-automation', '--no-sandbox'],
                args: ['--window-position=0,0', '--no-first-run', '--no-default-browser-check', ...args]
            })
                .then((browser) => __awaiter(this, void 0, void 0, function* () {
                // 处理浏览器初始
                handleBrowserInit(browser, { enable_dialog: config === null || config === void 0 ? void 0 : config.enable_dialog, userDataDir });
                try {
                    /**
                     * 显示步骤提示
                     */
                    const step = (tips, opts) => __awaiter(this, void 0, void 0, function* () {
                        const { loading = true, warn = false } = opts || {};
                        yield blankPage.evaluate((state) => {
                            // @ts-ignore OCS官方导航页自带的方法
                            const setState = window.setBookmarkLoadingState;
                            if (setState) {
                                setState(state);
                            }
                            else {
                                window.document.body.textContent = state.tips.join('\n');
                            }
                        }, { tips: Array.isArray(tips) ? tips : [tips], loading, warn });
                    });
                    const [blankPage] = browser.pages();
                    // 加载浏览器数据
                    blankPage.on('load', (page) => __awaiter(this, void 0, void 0, function* () {
                        if (bookmarksPageUrl && blankPage.url().includes(bookmarksPageUrl)) {
                            yield blankPage.evaluate((info) => {
                                const slot = document.querySelector('#data-slot');
                                if (slot) {
                                    slot.textContent = JSON.stringify(info);
                                }
                            }, Object.assign(browserInfo || {}, { uid: uid }));
                        }
                    }));
                    // 加载本地导航页
                    yield blankPage.goto(bookmarksPageUrl || 'about:blank');
                    // 打开开发者模式
                    yield openExtensionDeveloperMode(browser, executablePath.includes('edge'));
                    // 必须先打开开发者模式，才能关闭额外拓展页，否则打开开发者模式可能会重启插件，导致出现新的额外页面
                    // 关闭拓展加载时弹出的首页
                    waitAndCloseExtensionHomepage({ browser, closeableExtensionHomepages });
                    // 安装用户脚本
                    const warn = yield setupUserScripts({ browser, userscripts, step, config });
                    // 监听网络请求
                    browserNetworkRoute(authToken, browser);
                    // 运行自动化脚本
                    yield runPlaywrightScripts({ browser, playwrightScripts, serverPort, step });
                    yield step(['浏览器初始化完成。'].concat(warn), { loading: false, warn: !!warn.length });
                    // 触发onLaunch事件
                    onLaunch === null || onLaunch === void 0 ? void 0 : onLaunch(browser);
                    // 启动完成
                    resolve();
                }
                catch (err) {
                    reject(err);
                }
            }))
                .catch((err) => {
                reject(err);
            });
        });
    });
}
exports.launchBrowser = launchBrowser;
/**
 * 安装/更新脚本
 *
 */
function initScripts(urls, browser, config) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log('install ', urls);
        let installCont = 0;
        // 触发下载
        yield (() => __awaiter(this, void 0, void 0, function* () {
            for (const url of urls) {
                const page = yield browser.newPage();
                try {
                    yield Promise.race([page.goto(url).catch(() => { }), sleep(3 * 1000).then(() => page.close())]);
                }
                catch (_a) { }
            }
        }))();
        // 检测脚本是否安装/更新完毕
        const tryInstall = () => __awaiter(this, void 0, void 0, function* () {
            if (browser.pages().length !== 0) {
                const installPage = browser.pages().find((p) => /extension:\/\//.test(p.url()));
                if (installPage) {
                    // 置顶页面，防止点击安装失败
                    yield installPage.bringToFront();
                    yield sleep(1000);
                    const closed = yield installPage.evaluate((config) => {
                        const btn = (document.querySelector('[class*="primary"]') ||
                            document.querySelector('[type*="button"]'));
                        if (config === null || config === void 0 ? void 0 : config.force_update_script) {
                            btn === null || btn === void 0 ? void 0 : btn.click();
                        }
                        else {
                            if (['更新', '安装', '添加', '降级', 'install', 'update', 'add', 'downgrade'].some((text) => ((btn === null || btn === void 0 ? void 0 : btn.textContent) || (btn === null || btn === void 0 ? void 0 : btn.getAttribute('value')) || '')
                                .trim()
                                .toLocaleLowerCase()
                                .includes(text.trim().toLocaleLowerCase()))) {
                                btn === null || btn === void 0 ? void 0 : btn.click();
                            }
                            else {
                                return false;
                            }
                        }
                        if (!btn) {
                            return false;
                        }
                    }, config);
                    if (!closed) {
                        yield sleep(1000).then(() => installPage.close());
                    }
                    if (installPage.isClosed()) {
                        installCont++;
                    }
                    if (installCont < urls.length) {
                        yield tryInstall();
                    }
                }
                else if (installCont === urls.length) {
                    //
                }
                else {
                    yield sleep(1000);
                    yield tryInstall();
                }
            }
        });
        yield tryInstall();
    });
}
function send(event, ...args) {
    var _a;
    (_a = process.send) === null || _a === void 0 ? void 0 : _a.call(process, { event, args });
}
function sleep(t) {
    return new Promise((resolve, reject) => setTimeout(resolve, t));
}
/**
 * 将脚本配置转换为可用的对象配置
 * @param configs
 */
function transformScriptConfigToRaw(configs) {
    const raw = Object.create({});
    for (const key in configs) {
        if (Object.prototype.hasOwnProperty.call(configs, key)) {
            Reflect.set(raw, key, configs[key].value);
        }
    }
    return raw;
}
/**
 * 安装用户脚本
 */
function setupUserScripts(opts) {
    return __awaiter(this, void 0, void 0, function* () {
        const { userscripts, browser, step } = opts;
        const warn = [];
        // 安装用户脚本
        if (userscripts.length) {
            yield step('正在安装用户脚本...（如长时间未完成请尝试重启浏览器 ）');
            // 载入本地脚本
            try {
                yield initScripts(userscripts, browser, opts.config);
            }
            catch (e) {
                // @ts-ignore
                console.error('脚本安装失败：', e.message);
                // await html('脚本载入失败，请手动更新，或者忽略。' + e.message);
            }
        }
        else {
            warn.push('检测到您的软件中并未安装任何用户脚本，或者全部脚本处于不加载状态，可能会导致预期脚本不运行。');
        }
        return warn;
    });
}
/**
 * 运行自动化脚本
 */
function runPlaywrightScripts(opts) {
    return __awaiter(this, void 0, void 0, function* () {
        const { playwrightScripts, browser, serverPort, step } = opts;
        if (playwrightScripts.length) {
            // 执行自动化脚本
            for (const ps of playwrightScripts) {
                yield step(`正在执行自动化脚本 - ${ps.name} ...`);
                const configs = transformScriptConfigToRaw(ps.configs);
                for (const script of index_1.scripts) {
                    if (script.name === ps.name) {
                        script.on('script-data', (...msg) => console.log(...msg));
                        script.on('script-error', (...msg) => console.error('自动化脚本错误：', ...msg.map((m) => ScriptWorker.getTransformedErrorMessage(m))));
                        try {
                            yield script.run(yield browser.newPage(), configs, {
                                ocrApiUrl: `http://localhost:${serverPort}/ocr`,
                                ocrApiImageKey: 'image',
                                detBackgroundKey: 'det_bg',
                                detTargetKey: 'det_target'
                            });
                        }
                        catch (err) {
                            console.error('自动化脚本错误：', ScriptWorker.getTransformedErrorMessage(err instanceof Error ? err.message : String(err)));
                        }
                        break;
                    }
                }
            }
        }
    });
}
/**
 * 关闭浏览器拓展主页
 */
function waitAndCloseExtensionHomepage(opts) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            const timeout = setTimeout(() => {
                clearInterval(interval);
                reject(new Error('浏览器拓展加载超时，请尝试重启浏览器，或者查看网络情况。'));
            }, 60 * 1000);
            const interval = setInterval(() => __awaiter(this, void 0, void 0, function* () {
                const includes = [];
                for (const page of opts.browser.pages()) {
                    // 当拓展主页无法访问时，会跳转到chrome-error://chromewebdata/，此时获取的url为chrome-error://chromewebdata/，而不是拓展主页的url，但是title是拓展主页的host
                    const title = page.url() === 'chrome-error://chromewebdata/' ? yield page.title() : '';
                    if (opts.closeableExtensionHomepages.some((homepage) => page.url() === 'chrome-error://chromewebdata/' ? homepage.includes(title) : page.url().includes(homepage))) {
                        includes.push(page);
                    }
                }
                if (includes.length) {
                    clearInterval(interval);
                    clearTimeout(timeout);
                    Promise.all(includes.map((page) => __awaiter(this, void 0, void 0, function* () { return page.close(); })))
                        .then(resolve)
                        .catch(reject);
                }
            }), 1000);
        });
    });
}
function browserNetworkRoute(authToken, browser) {
    browser.route(/ocs-environment/, (route) => __awaiter(this, void 0, void 0, function* () {
        yield route.fulfill({
            status: 200,
            body: JSON.stringify({
                environment: 'playwright'
            })
        });
    }));
    browser.route(/ocs-script-actions/, (route) => __awaiter(this, void 0, void 0, function* () {
        const req = route.request();
        if (req.method().toLocaleUpperCase() !== 'POST') {
            return;
        }
        const headerValue = yield req.headerValue('auth-token');
        if (headerValue !== authToken) {
            return;
        }
        const { page: targetPageUrl, property, args } = req.postDataJSON();
        try {
            const page = browser === null || browser === void 0 ? void 0 : browser.pages().find((p) => p.url().includes(targetPageUrl));
            if (!page) {
                return;
            }
            const targetFunction = (0, get_1.default)(page, property);
            if (typeof targetFunction !== 'function') {
                return;
            }
            if (property === 'waitForResponse' || property === 'waitForRequest') {
                args[0] = new RegExp(args[0]);
            }
            const res = yield targetFunction.apply(property.split('.').length > 1 ? (0, get_1.default)(page, property.split('.')[0]) : page, args);
            if (typeof res === 'object') {
                if (property === 'screenshot') {
                    const buffer = res;
                    yield route.fulfill({
                        status: 200,
                        body: buffer.toString('base64')
                    });
                }
                else if (property === 'waitForResponse') {
                    const response = res;
                    yield route.fulfill({
                        status: 200,
                        body: JSON.stringify({
                            url: response.url(),
                            status: response.status(),
                            headers: response.headers(),
                            body: yield response.body().then((res) => res.toString('utf8'))
                        })
                    });
                }
                else if (property === 'waitForRequest') {
                    const request = res;
                    yield route.fulfill({
                        status: 200,
                        body: JSON.stringify({
                            url: request.url(),
                            method: request.method(),
                            headers: request.headers(),
                            postData: request.postData()
                        })
                    });
                }
                else {
                    yield route.fulfill({ status: 200, body: JSON.stringify(res) });
                }
            }
            else {
                yield route.fulfill({ status: 200, body: res !== null && res !== void 0 ? res : 'OK' });
            }
        }
        catch (err) {
            yield route.continue();
            console.error('脚本软件辅助失败：', ScriptWorker.getTransformedErrorMessage(err instanceof Error ? err.message : String(err), {
                url: targetPageUrl,
                property: property === 'click' ? '点击' : property === 'fill' ? '填写' : property === 'check' ? '选中' : property,
                args: JSON.stringify(args)
            }));
        }
    }));
}
function handleBrowserInit(browser, config) {
    // 防检测
    browser.addInitScript({
        content: 'Object.defineProperty(navigator, "webdriver", { get: () => false });console.log(navigator)'
    });
    // 关闭检测
    const interval = setInterval(() => __awaiter(this, void 0, void 0, function* () {
        if (browser.pages().length === 0) {
            clearInterval(interval);
            yield browser.close({
                reason: 'no pages'
            });
        }
    }), 100);
    browser.once('close', () => {
        send('browser-closed');
        process.exit();
    });
    const pageHandle = (page) => {
        // 按照文档的说法，如果不进行任何处理，则动作会和原版浏览器一致
        // 如果不进行监听 page.on('dialog') playwright 会自动处理弹窗
        page.on('dialog', (dialog) => __awaiter(this, void 0, void 0, function* () {
            if (config === null || config === void 0 ? void 0 : config.enable_dialog) {
                // 不进行任何处理
            }
            else {
                yield dialog.accept(dialog.defaultValue());
            }
        }));
        // 修改下载逻辑
        page.on('download', (download) => __awaiter(this, void 0, void 0, function* () {
            // 不处理脚本安装
            if (download.url().endsWith('.user.js')) {
                return;
            }
            download.cancel();
            // 调用电脑本地浏览器进行文件下载
            openUrl(download.url());
            yield page.evaluate(() => alert('自动化浏览器无法下载文件，已使用本地浏览器进行下载任务。'));
        }));
    };
    for (const page of browser.pages()) {
        pageHandle(page);
    }
    browser.on('page', pageHandle);
}
function openUrl(url) {
    let cmd = 'start';
    if (process.platform === 'darwin') {
        cmd = 'open';
    }
    else if (process.platform === 'linux') {
        cmd = 'xdg-open';
    }
    child_process_1.default.exec(`${cmd} ${url}`);
}
/**
 * 打开浏览器拓展开发者模式（由于 MV3 的限制，运行脚本需要打开开发者模式）
 */
function openExtensionDeveloperMode(browser, edge = false) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const page = yield browser.newPage();
        yield page.goto('chrome://extensions/');
        try {
            yield page.bringToFront();
            yield page.waitForTimeout(200);
            if (edge) {
                const els = yield page.$$('[aria-label="扩展 菜单"]');
                yield ((_a = els[1]) === null || _a === void 0 ? void 0 : _a.click());
                const element = yield page.waitForSelector('#developer-mode', {
                    timeout: 1000
                });
                if (yield element.evaluate((el) => el.checked === false)) {
                    yield element.click();
                }
            }
            else {
                const element = yield page.waitForSelector('#devMode', {
                    timeout: 1000
                });
                // 如果没有开启开发者模式
                if (yield element.evaluate((el) => { var _a; return ((_a = el.getAttribute('aria-pressed')) === null || _a === void 0 ? void 0 : _a.toString()) === 'false'; })) {
                    yield element.click();
                    // 重新加载拓展，否则需要重启浏览器才能使用
                    const extensions = yield page.$$('[id="dev-reload-button"]');
                    for (const ext of extensions) {
                        yield ext.click();
                        yield page.waitForTimeout(200);
                    }
                }
            }
        }
        catch (_b) { }
        yield page.waitForTimeout(500);
        console.log('开发者模式已打开');
        yield page.close();
    });
}
function getExtensionName(filepath) {
    return filepath.toLocaleLowerCase().includes('tampermonkey')
        ? '油猴'
        : filepath.toLocaleLowerCase().includes('scriptcat')
            ? '脚本猫'
            : path_1.default.basename(filepath);
}
