"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringUtils = void 0;
var StringUtils = /** @class */ (function () {
    function StringUtils(_text) {
        this._text = _text;
    }
    /** 删除换行符 */
    StringUtils.nowrap = function (str) {
        return (str === null || str === void 0 ? void 0 : str.replace(/\n/g, '')) || '';
    };
    StringUtils.prototype.nowrap = function () {
        this._text = StringUtils.nowrap(this._text);
        return this;
    };
    /** 删除特殊字符 */
    StringUtils.noSpecialChar = function (str) {
        return (str === null || str === void 0 ? void 0 : str.replace(/[^\w\s]/gi, '')) || '';
    };
    StringUtils.prototype.noSpecialChar = function () {
        this._text = StringUtils.noSpecialChar(this._text);
        return this;
    };
    /** 最大长度，剩余显示省略号 */
    StringUtils.max = function (str, len) {
        return str.length > len ? str.substring(0, len) + '...' : str;
    };
    StringUtils.prototype.max = function (len) {
        this._text = StringUtils.max(this._text, len);
        return this;
    };
    /** 隐藏字符串 */
    StringUtils.hide = function (str, start, end, replacer) {
        if (replacer === void 0) { replacer = '*'; }
        // 从 start 到 end 中间的字符串全部替换成 replacer
        return str.substring(0, start) + str.substring(start, end).replace(/./g, replacer) + str.substring(end);
    };
    StringUtils.prototype.hide = function (start, end, replacer) {
        if (replacer === void 0) { replacer = '*'; }
        this._text = StringUtils.hide(this._text, start, end, replacer);
        return this;
    };
    StringUtils.of = function (text) {
        return new StringUtils(text);
    };
    StringUtils.prototype.toString = function () {
        return this._text;
    };
    return StringUtils;
}());
exports.StringUtils = StringUtils;
