"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValidBrowsers = void 0;
var fs_1 = require("fs");
var path_1 = require("path");
var os_1 = __importDefault(require("os"));
require("electron");
// 获取可用浏览器路径
function getValidBrowsers() {
    switch (os_1.default.platform()) {
        case 'darwin': {
            return [
                {
                    name: '软件内置浏览器-谷歌(Chrome)',
                    path: resolveBrowserPath('bin/chrome/chrome/Google Chrome for Testing.app/Contents/MacOS/Google Chrome for Testing')
                }
            ].filter(function (b) { return b.path; });
        }
        case 'win32': {
            return [
                {
                    name: '软件内置浏览器-谷歌(Chrome)',
                    path: resolveBrowserPath('bin\\chrome\\chrome\\chrome.exe')
                },
                {
                    name: '微软浏览器(Microsoft Edge)',
                    path: resolveBrowserPath('Microsoft\\Edge\\Application\\msedge.exe')
                },
                {
                    name: '谷歌浏览器(Chrome)',
                    path: resolveBrowserPath('Google\\Chrome\\Application\\chrome.exe')
                }
            ].filter(function (b) { return b.path; });
        }
        default: {
            return [];
        }
    }
}
exports.getValidBrowsers = getValidBrowsers;
function resolveBrowserPath(commonPath) {
    return __spreadArray([
        (0, path_1.join)(process.resourcesPath, commonPath)
    ], (process.platform === 'win32'
        ? [
            // @ts-ignore
            (0, path_1.join)(process.env.ProgramFiles, commonPath),
            // @ts-ignore
            (0, path_1.join)(process.env['ProgramFiles(x86)'], commonPath),
            (0, path_1.join)('C:\\Program Files', commonPath),
            (0, path_1.join)('C:\\Program Files (x86)', commonPath)
        ]
        : []), true).find(function (p) { return (0, fs_1.existsSync)(p); });
}
