import { r as ref, a as reactive, i as inject, c as computed, g as getCurrentInstance, b as cloneVNode, d as isVNode, F as Fragment, e as defineComponent, w as watch, o as onMounted, f as onUnmounted, t as toRefs, h as watchEffect, j as resolveComponent, k as openBlock, l as createBlock, m as withCtx, n as createBaseVNode, p as createElementBlock, q as normalizeStyle, s as createCommentVNode, u as normalizeClass, v as createVNode, x as renderSlot, y as createTextVNode, z as toDisplayString, T as Transition, A as onBeforeUnmount, B as provide, C as nextTick, D as toRef, E as mergeProps, G as createSlots, H as withModifiers, I as onUpdated, J as readonly, K as onDeactivated, L as Teleport, M as withDirectives, N as vShow, O as resolveDynamicComponent, P as renderList, Q as createStaticVNode, R as TransitionGroup, S as normalizeProps, U as guardReactiveProps, V as withKeys, W as render, X as h, Y as isRef, Z as Comment$1, _ as createApp, $ as unref, a0 as getCurrentScope, a1 as onScopeDispose, a2 as shallowRef } from "./@vue.10d2ded6.js";
import { i as index } from "./resize-observer-polyfill.375322e1.js";
import { i } from "./compute-scroll-into-view.079a5c71.js";
import { T as Tween } from "./b-tween.3dc4e04f.js";
import { d as dayjs$1, c as customParseFormat, i as isBetween, w as weekOfYear, A as AdvancedFormat, a as weekYear, Q as QuarterOfYear } from "./dayjs.a79bd2ae.js";
import { i as index$1 } from "./number-precision.a111f450.js";
import { s as scrollIntoView } from "./scroll-into-view-if-needed.10a505ff.js";
import { S as Schema } from "./b-validate.edd52b51.js";
const opt = Object.prototype.toString;
function isArray(obj) {
  return opt.call(obj) === "[object Array]";
}
function isNull(obj) {
  return opt.call(obj) === "[object Null]";
}
function isBoolean(obj) {
  return opt.call(obj) === "[object Boolean]";
}
function isObject(obj) {
  return opt.call(obj) === "[object Object]";
}
const isPromise = (obj) => {
  return opt.call(obj) === "[object Promise]";
};
function isString(obj) {
  return opt.call(obj) === "[object String]";
}
function isNumber(obj) {
  return opt.call(obj) === "[object Number]" && obj === obj;
}
function isUndefined(obj) {
  return obj === void 0;
}
function isFunction(obj) {
  return typeof obj === "function";
}
function isEmptyObject(obj) {
  return isObject(obj) && Object.keys(obj).length === 0;
}
function isExist(obj) {
  return obj || obj === 0;
}
function isWindow(el) {
  return el === window;
}
const isComponentInstance = (value) => {
  return (value == null ? void 0 : value.$) !== void 0;
};
const isQuarter = (fromat) => {
  return /\[Q]Q/.test(fromat);
};
function isDayjs(time) {
  return isObject(time) && "$y" in time && "$M" in time && "$D" in time && "$d" in time && "$H" in time && "$m" in time && "$s" in time;
}
const configProviderInjectionKey = Symbol("ArcoConfigProvider");
const calendarLang = {
  formatYear: "YYYY \u5E74",
  formatMonth: "YYYY \u5E74 MM \u6708",
  today: "\u4ECA\u5929",
  view: {
    month: "\u6708",
    year: "\u5E74",
    week: "\u5468",
    day: "\u65E5"
  },
  month: {
    long: {
      January: "\u4E00\u6708",
      February: "\u4E8C\u6708",
      March: "\u4E09\u6708",
      April: "\u56DB\u6708",
      May: "\u4E94\u6708",
      June: "\u516D\u6708",
      July: "\u4E03\u6708",
      August: "\u516B\u6708",
      September: "\u4E5D\u6708",
      October: "\u5341\u6708",
      November: "\u5341\u4E00\u6708",
      December: "\u5341\u4E8C\u6708"
    },
    short: {
      January: "\u4E00\u6708",
      February: "\u4E8C\u6708",
      March: "\u4E09\u6708",
      April: "\u56DB\u6708",
      May: "\u4E94\u6708",
      June: "\u516D\u6708",
      July: "\u4E03\u6708",
      August: "\u516B\u6708",
      September: "\u4E5D\u6708",
      October: "\u5341\u6708",
      November: "\u5341\u4E00\u6708",
      December: "\u5341\u4E8C\u6708"
    }
  },
  week: {
    long: {
      self: "\u5468",
      monday: "\u5468\u4E00",
      tuesday: "\u5468\u4E8C",
      wednesday: "\u5468\u4E09",
      thursday: "\u5468\u56DB",
      friday: "\u5468\u4E94",
      saturday: "\u5468\u516D",
      sunday: "\u5468\u65E5"
    },
    short: {
      self: "\u5468",
      monday: "\u4E00",
      tuesday: "\u4E8C",
      wednesday: "\u4E09",
      thursday: "\u56DB",
      friday: "\u4E94",
      saturday: "\u516D",
      sunday: "\u65E5"
    }
  }
};
const lang = {
  locale: "zh-CN",
  empty: {
    description: "\u6682\u65E0\u6570\u636E"
  },
  drawer: {
    okText: "\u786E\u5B9A",
    cancelText: "\u53D6\u6D88"
  },
  popconfirm: {
    okText: "\u786E\u5B9A",
    cancelText: "\u53D6\u6D88"
  },
  modal: {
    okText: "\u786E\u5B9A",
    cancelText: "\u53D6\u6D88"
  },
  pagination: {
    goto: "\u524D\u5F80",
    page: "\u9875",
    countPerPage: "\u6761/\u9875",
    total: "\u5171 {0} \u6761"
  },
  table: {
    okText: "\u786E\u5B9A",
    resetText: "\u91CD\u7F6E"
  },
  upload: {
    start: "\u5F00\u59CB",
    cancel: "\u53D6\u6D88",
    delete: "\u5220\u9664",
    retry: "\u70B9\u51FB\u91CD\u8BD5",
    buttonText: "\u70B9\u51FB\u4E0A\u4F20",
    preview: "\u9884\u89C8",
    drag: "\u70B9\u51FB\u6216\u62D6\u62FD\u6587\u4EF6\u5230\u6B64\u5904\u4E0A\u4F20",
    dragHover: "\u91CA\u653E\u6587\u4EF6\u5E76\u5F00\u59CB\u4E0A\u4F20",
    error: "\u4E0A\u4F20\u5931\u8D25"
  },
  calendar: calendarLang,
  datePicker: {
    view: calendarLang.view,
    month: calendarLang.month,
    week: calendarLang.week,
    placeholder: {
      date: "\u8BF7\u9009\u62E9\u65E5\u671F",
      week: "\u8BF7\u9009\u62E9\u5468",
      month: "\u8BF7\u9009\u62E9\u6708\u4EFD",
      year: "\u8BF7\u9009\u62E9\u5E74\u4EFD",
      quarter: "\u8BF7\u9009\u62E9\u5B63\u5EA6",
      time: "\u8BF7\u9009\u62E9\u65F6\u95F4"
    },
    rangePlaceholder: {
      date: ["\u5F00\u59CB\u65E5\u671F", "\u7ED3\u675F\u65E5\u671F"],
      week: ["\u5F00\u59CB\u5468", "\u7ED3\u675F\u5468"],
      month: ["\u5F00\u59CB\u6708\u4EFD", "\u7ED3\u675F\u6708\u4EFD"],
      year: ["\u5F00\u59CB\u5E74\u4EFD", "\u7ED3\u675F\u5E74\u4EFD"],
      quarter: ["\u5F00\u59CB\u5B63\u5EA6", "\u7ED3\u675F\u5B63\u5EA6"],
      time: ["\u5F00\u59CB\u65F6\u95F4", "\u7ED3\u675F\u65F6\u95F4"]
    },
    selectTime: "\u9009\u62E9\u65F6\u95F4",
    today: "\u4ECA\u5929",
    now: "\u6B64\u523B",
    ok: "\u786E\u5B9A"
  },
  image: {
    loading: "\u52A0\u8F7D\u4E2D"
  },
  imagePreview: {
    fullScreen: "\u5168\u5C4F",
    rotateRight: "\u5411\u53F3\u65CB\u8F6C",
    rotateLeft: "\u5411\u5DE6\u65CB\u8F6C",
    zoomIn: "\u653E\u5927",
    zoomOut: "\u7F29\u5C0F",
    originalSize: "\u539F\u59CB\u5C3A\u5BF8"
  },
  typography: {
    copied: "\u5DF2\u590D\u5236",
    copy: "\u590D\u5236",
    expand: "\u5C55\u5F00",
    collapse: "\u6298\u53E0",
    edit: "\u7F16\u8F91"
  },
  form: {
    validateMessages: {
      required: "#{field} \u662F\u5FC5\u586B\u9879",
      type: {
        string: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684\u6587\u672C\u7C7B\u578B",
        number: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684\u6570\u5B57\u7C7B\u578B",
        boolean: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684\u5E03\u5C14\u7C7B\u578B",
        array: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684\u6570\u7EC4\u7C7B\u578B",
        object: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684\u5BF9\u8C61\u7C7B\u578B",
        url: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684 url \u5730\u5740",
        email: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684\u90AE\u7BB1\u5730\u5740",
        ip: "#{field} \u4E0D\u662F\u5408\u6CD5\u7684 IP \u5730\u5740"
      },
      number: {
        min: "`#{value}` \u5C0F\u4E8E\u6700\u5C0F\u503C `#{min}`",
        max: "`#{value}` \u5927\u4E8E\u6700\u5927\u503C `#{max}`",
        equal: "`#{value}` \u4E0D\u7B49\u4E8E `#{equal}`",
        range: "`#{value}` \u4E0D\u5728 `#{min} ~ #{max}` \u8303\u56F4\u5185",
        positive: "`#{value}` \u4E0D\u662F\u6B63\u6570",
        negative: "`#{value}` \u4E0D\u662F\u8D1F\u6570"
      },
      array: {
        length: "`#{field}` \u4E2A\u6570\u4E0D\u7B49\u4E8E #{length}",
        minLength: "`#{field}` \u4E2A\u6570\u6700\u5C11\u4E3A #{minLength}",
        maxLength: "`#{field}` \u4E2A\u6570\u6700\u591A\u4E3A #{maxLength}",
        includes: "#{field} \u4E0D\u5305\u542B #{includes}",
        deepEqual: "#{field} \u4E0D\u7B49\u4E8E #{deepEqual}",
        empty: "`#{field}` \u4E0D\u662F\u7A7A\u6570\u7EC4"
      },
      string: {
        minLength: "\u5B57\u7B26\u6570\u6700\u5C11\u4E3A #{minLength}",
        maxLength: "\u5B57\u7B26\u6570\u6700\u591A\u4E3A #{maxLength}",
        length: "\u5B57\u7B26\u6570\u5FC5\u987B\u662F #{length}",
        match: "`#{value}` \u4E0D\u7B26\u5408\u6A21\u5F0F #{pattern}",
        uppercase: "`#{value}` \u5FC5\u987B\u5168\u5927\u5199",
        lowercase: "`#{value}` \u5FC5\u987B\u5168\u5C0F\u5199"
      },
      object: {
        deepEqual: "`#{field}` \u4E0D\u7B49\u4E8E\u671F\u671B\u503C",
        hasKeys: "`#{field}` \u4E0D\u5305\u542B\u5FC5\u987B\u5B57\u6BB5",
        empty: "`#{field}` \u4E0D\u662F\u5BF9\u8C61"
      },
      boolean: {
        true: "\u671F\u671B\u662F `true`",
        false: "\u671F\u671B\u662F `false`"
      }
    }
  },
  colorPicker: {
    history: "\u6700\u8FD1\u4F7F\u7528\u989C\u8272",
    preset: "\u7CFB\u7EDF\u9884\u8BBE\u989C\u8272",
    empty: "\u6682\u65E0"
  }
};
const LOCALE = ref("zh-CN");
const I18N_MESSAGES = reactive({
  "zh-CN": lang
});
const addI18nMessages = (messages, options) => {
  for (const key of Object.keys(messages)) {
    if (!I18N_MESSAGES[key] || (options == null ? void 0 : options.overwrite)) {
      I18N_MESSAGES[key] = messages[key];
    }
  }
};
const useLocale = (locale) => {
  if (!I18N_MESSAGES[locale]) {
    console.warn(`use ${locale} failed! Please add ${locale} first`);
    return;
  }
  LOCALE.value = locale;
};
const getLocale = () => {
  return LOCALE.value;
};
const useI18n = () => {
  const configProvider = inject(configProviderInjectionKey, void 0);
  const i18nMessage = computed(
    () => {
      var _a;
      return (_a = configProvider == null ? void 0 : configProvider.locale) != null ? _a : I18N_MESSAGES[LOCALE.value];
    }
  );
  const locale = computed(() => i18nMessage.value.locale);
  const transform = (key, ...args) => {
    const keyArray = key.split(".");
    let temp = i18nMessage.value;
    for (const keyItem of keyArray) {
      if (!temp[keyItem]) {
        return key;
      }
      temp = temp[keyItem];
    }
    if (isString(temp)) {
      if (args.length > 0) {
        return temp.replace(/{(\d+)}/g, (sub, index2) => {
          var _a;
          return (_a = args[index2]) != null ? _a : sub;
        });
      }
      return temp;
    }
    return temp;
  };
  return {
    i18nMessage,
    locale,
    t: transform
  };
};
const COMPONENT_PREFIX = "A";
const CLASS_PREFIX = "arco";
const GLOBAL_CONFIG_NAME = "$arco";
const getComponentPrefix = (options) => {
  var _a;
  return (_a = options == null ? void 0 : options.componentPrefix) != null ? _a : COMPONENT_PREFIX;
};
const setGlobalConfig = (app, options) => {
  var _a;
  if (options && options.classPrefix) {
    app.config.globalProperties[GLOBAL_CONFIG_NAME] = {
      ...(_a = app.config.globalProperties[GLOBAL_CONFIG_NAME]) != null ? _a : {},
      classPrefix: options.classPrefix
    };
  }
};
const getPrefixCls = (componentName) => {
  var _a, _b, _c;
  const instance = getCurrentInstance();
  const configProvider = inject(configProviderInjectionKey, void 0);
  const prefix = (_c = (_b = configProvider == null ? void 0 : configProvider.prefixCls) != null ? _b : (_a = instance == null ? void 0 : instance.appContext.config.globalProperties[GLOBAL_CONFIG_NAME]) == null ? void 0 : _a.classPrefix) != null ? _c : CLASS_PREFIX;
  if (componentName) {
    return `${prefix}-${componentName}`;
  }
  return prefix;
};
const isElement = (vn) => {
  return Boolean(vn && vn.shapeFlag & 1);
};
const isComponent = (vn, type) => {
  return Boolean(vn && vn.shapeFlag & 6);
};
const isTextChildren = (child, children) => {
  return Boolean(child && child.shapeFlag & 8);
};
const isArrayChildren = (vn, children) => {
  return Boolean(vn && vn.shapeFlag & 16);
};
const isSlotsChildren = (vn, children) => {
  return Boolean(vn && vn.shapeFlag & 32);
};
const getFirstComponent = (children) => {
  var _a, _b;
  if (!children) {
    return void 0;
  }
  for (const child of children) {
    if (isElement(child) || isComponent(child)) {
      return child;
    }
    if (isArrayChildren(child, child.children)) {
      const result = getFirstComponent(child.children);
      if (result)
        return result;
    } else if (isSlotsChildren(child, child.children)) {
      const children2 = (_b = (_a = child.children).default) == null ? void 0 : _b.call(_a);
      if (children2) {
        const result = getFirstComponent(children2);
        if (result)
          return result;
      }
    } else if (isArray(child)) {
      const result = getFirstComponent(child);
      if (result)
        return result;
    }
  }
  return void 0;
};
const isEmptyChildren = (children) => {
  if (!children) {
    return true;
  }
  for (const item of children) {
    if (item.children) {
      return false;
    }
  }
  return true;
};
const mergeFirstChild = (children, extraProps) => {
  if (children && children.length > 0) {
    for (let i2 = 0; i2 < children.length; i2++) {
      const child = children[i2];
      if (isElement(child) || isComponent(child)) {
        const props = isFunction(extraProps) ? extraProps(child) : extraProps;
        children[i2] = cloneVNode(child, props, true);
        return true;
      }
      const _children = getChildrenArray(child);
      if (_children && _children.length > 0) {
        const result = mergeFirstChild(_children, extraProps);
        if (result)
          return true;
      }
    }
  }
  return false;
};
const getChildrenArray = (vn) => {
  if (isArrayChildren(vn, vn.children)) {
    return vn.children;
  }
  if (isArray(vn)) {
    return vn;
  }
  return void 0;
};
const getFirstElementFromVNode = (vn) => {
  var _a, _b;
  if (isElement(vn)) {
    return vn.el;
  }
  if (isComponent(vn)) {
    if (((_a = vn.el) == null ? void 0 : _a.nodeType) === 1) {
      return vn.el;
    }
    if ((_b = vn.component) == null ? void 0 : _b.subTree) {
      const ele = getFirstElementFromVNode(vn.component.subTree);
      if (ele)
        return ele;
    }
  } else {
    const children = getChildrenArray(vn);
    return getFirstElementFromChildren(children);
  }
  return void 0;
};
const getFirstElementFromChildren = (children) => {
  if (children && children.length > 0) {
    for (const child of children) {
      const element = getFirstElementFromVNode(child);
      if (element)
        return element;
    }
  }
  return void 0;
};
const getAllElements = (children, includeText = false) => {
  var _a, _b;
  const results = [];
  for (const item of children != null ? children : []) {
    if (isElement(item) || isComponent(item) || includeText && isTextChildren(item, item.children)) {
      results.push(item);
    } else if (isArrayChildren(item, item.children)) {
      results.push(...getAllElements(item.children, includeText));
    } else if (isSlotsChildren(item, item.children)) {
      results.push(...getAllElements((_b = (_a = item.children).default) == null ? void 0 : _b.call(_a), includeText));
    } else if (isArray(item)) {
      results.push(...getAllElements(item, includeText));
    }
  }
  return results;
};
function unFragment(nodeList) {
  function loop(nodes) {
    const unFragmentNodeList = [];
    nodes.forEach((node) => {
      var _a, _b;
      if (isVNode(node) && node.type === Fragment) {
        if (isSlotsChildren(node, node.children)) {
          unFragmentNodeList.push(...loop(((_b = (_a = node.children).default) == null ? void 0 : _b.call(_a)) || []));
        } else if (isArrayChildren(node, node.children)) {
          unFragmentNodeList.push(...loop(node.children));
        } else if (isString(node.children)) {
          unFragmentNodeList.push(node.children);
        }
      } else {
        unFragmentNodeList.push(node);
      }
    });
    return unFragmentNodeList;
  }
  return loop(nodeList);
}
const getSlotFunction = (param) => {
  if (param) {
    if (isFunction(param))
      return param;
    return () => param;
  }
  return void 0;
};
const getComponentsFromVNode = (vn, name) => {
  var _a;
  const components2 = [];
  if (isComponent(vn, vn.type)) {
    if (vn.type.name === name) {
      if (vn.component) {
        components2.push(vn.component.uid);
      }
    } else if ((_a = vn.component) == null ? void 0 : _a.subTree) {
      components2.push(...getComponentsFromVNode(vn.component.subTree, name));
    }
  } else {
    const children = getChildrenArray(vn);
    if (children) {
      components2.push(...getComponentsFromChildren(children, name));
    }
  }
  return components2;
};
const getComponentsFromChildren = (children, name) => {
  const components2 = [];
  if (children && children.length > 0) {
    for (const child of children) {
      components2.push(...getComponentsFromVNode(child, name));
    }
  }
  return components2;
};
var ResizeObserver$1 = defineComponent({
  name: "ResizeObserver",
  emits: [
    "resize"
  ],
  setup(props, {
    emit,
    slots
  }) {
    let resizeObserver;
    const componentRef = ref();
    const element = computed(() => isComponentInstance(componentRef.value) ? componentRef.value.$el : componentRef.value);
    const createResizeObserver = (target2) => {
      if (!target2)
        return;
      resizeObserver = new index((entries) => {
        const entry = entries[0];
        emit("resize", entry);
      });
      resizeObserver.observe(target2);
    };
    const destroyResizeObserver = () => {
      if (resizeObserver) {
        resizeObserver.disconnect();
        resizeObserver = null;
      }
    };
    watch(element, (_element) => {
      if (resizeObserver)
        destroyResizeObserver();
      if (_element)
        createResizeObserver(_element);
    });
    onMounted(() => {
      if (element.value) {
        createResizeObserver(element.value);
      }
    });
    onUnmounted(() => {
      destroyResizeObserver();
    });
    return () => {
      var _a, _b;
      const firstChild = getFirstComponent((_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _b : []);
      if (firstChild) {
        return cloneVNode(firstChild, {
          ref: componentRef
        }, true);
      }
      return null;
    };
  }
});
const target$1 = typeof window === "undefined" ? global : window;
const raf = target$1.requestAnimationFrame;
const caf = target$1.cancelAnimationFrame;
function throttleByRaf(cb) {
  let timer = 0;
  const throttle = (...args) => {
    if (timer) {
      caf(timer);
    }
    timer = raf(() => {
      cb(...args);
      timer = 0;
    });
  };
  throttle.cancel = () => {
    caf(timer);
    timer = 0;
  };
  return throttle;
}
const NOOP = () => {
  return void 0;
};
const getDocumentSize = () => {
  const { body } = document;
  const html = document.documentElement;
  let topBody;
  try {
    const topWindow = window.top || window.self || window;
    topBody = topWindow.document.body;
  } catch {
  }
  return {
    height: Math.max(
      body.scrollHeight,
      body.offsetHeight,
      html.clientHeight,
      html.scrollHeight,
      html.offsetHeight,
      (topBody == null ? void 0 : topBody.scrollHeight) || 0,
      (topBody == null ? void 0 : topBody.clientHeight) || 0
    ),
    width: Math.max(
      body.scrollWidth,
      body.offsetWidth,
      html.clientWidth,
      html.scrollWidth,
      html.offsetWidth,
      (topBody == null ? void 0 : topBody.scrollWidth) || 0,
      (topBody == null ? void 0 : topBody.clientWidth) || 0
    )
  };
};
const isServerRendering = (() => {
  try {
    return !(typeof window !== "undefined" && document !== void 0);
  } catch (e) {
    return true;
  }
})();
const on = (() => {
  if (isServerRendering) {
    return NOOP;
  }
  return (element, event, handler, options = false) => {
    element.addEventListener(
      event,
      handler,
      options
    );
  };
})();
const off = (() => {
  if (isServerRendering) {
    return NOOP;
  }
  return (element, type, handler, options = false) => {
    element.removeEventListener(
      type,
      handler,
      options
    );
  };
})();
const contains = (root, ele) => {
  if (!root || !ele) {
    return false;
  }
  let node = ele;
  while (node) {
    if (node === root) {
      return true;
    }
    node = node.parentNode;
  }
  return false;
};
const getOverlay = (type) => {
  const popper = document.createElement("div");
  popper.setAttribute("class", `arco-overlay arco-overlay-${type}`);
  return popper;
};
const querySelector = (selectors, container2) => {
  var _a;
  if (isServerRendering) {
    return NOOP();
  }
  return (_a = (container2 != null ? container2 : document).querySelector(selectors)) != null ? _a : void 0;
};
const getElement = (target2, container2) => {
  if (isString(target2)) {
    const selector = target2[0] === "#" ? `[id='${target2.slice(1)}']` : target2;
    return querySelector(selector, container2);
  }
  return target2;
};
const getRelativeRect = (target2, relative) => {
  const targetRect = target2.getBoundingClientRect();
  const relativeRect = relative.getBoundingClientRect();
  return {
    top: targetRect.top - relativeRect.top,
    bottom: relativeRect.bottom - targetRect.bottom,
    left: targetRect.left - relativeRect.left,
    right: relativeRect.right - targetRect.right,
    width: targetRect.width,
    height: targetRect.height
  };
};
const isScroll = (element) => {
  return element.tagName === "BODY" ? document.documentElement.scrollHeight > window.innerHeight : element.scrollHeight > element.offsetHeight;
};
const getScrollBarWidth = (element) => {
  return element.tagName === "BODY" ? window.innerWidth - getDocumentSize().width : element.offsetWidth - element.clientWidth;
};
var _export_sfc = (sfc, props) => {
  for (const [key, val] of props) {
    sfc[key] = val;
  }
  return sfc;
};
function getTargetRect(target2) {
  return isWindow(target2) ? {
    top: 0,
    bottom: window.innerHeight
  } : target2.getBoundingClientRect();
}
const _sfc_main$6A = defineComponent({
  name: "Affix",
  components: {
    ResizeObserver: ResizeObserver$1
  },
  props: {
    offsetTop: {
      type: Number,
      default: 0
    },
    offsetBottom: {
      type: Number
    },
    target: {
      type: [String, Object, Function]
    },
    targetContainer: {
      type: [String, Object, Function]
    }
  },
  emits: {
    change: (fixed) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("affix");
    const { target: target2, targetContainer } = toRefs(props);
    const wrapperRef = ref();
    const targetRef = ref();
    const isFixed = ref(false);
    const placeholderStyles = ref({});
    const fixedStyles = ref({});
    const classNames = computed(() => ({ [prefixCls]: isFixed.value }));
    const updatePositionThrottle = throttleByRaf(() => {
      if (!wrapperRef.value || !targetRef.value)
        return;
      const { offsetTop, offsetBottom } = props;
      const offsetType = isUndefined(offsetBottom) ? "top" : "bottom";
      const wrapperRect = wrapperRef.value.getBoundingClientRect();
      const targetRect = getTargetRect(targetRef.value);
      let newIsFixed = false;
      let newFixedStyles = {};
      const newPlaceholderStyles = {
        width: `${wrapperRef.value.offsetWidth}px`,
        height: `${wrapperRef.value.offsetHeight}px`
      };
      if (offsetType === "top") {
        newIsFixed = wrapperRect.top - targetRect.top < (offsetTop || 0);
        newFixedStyles = newIsFixed ? {
          position: "fixed",
          top: `${targetRect.top + (offsetTop || 0)}px`
        } : {};
      } else {
        newIsFixed = targetRect.bottom - wrapperRect.bottom < (offsetBottom || 0);
        newFixedStyles = newIsFixed ? {
          position: "fixed",
          bottom: `${window.innerHeight - targetRect.bottom + (offsetBottom || 0)}px`
        } : {};
      }
      if (newIsFixed !== isFixed.value) {
        isFixed.value = newIsFixed;
        emit("change", newIsFixed);
      }
      placeholderStyles.value = newPlaceholderStyles;
      fixedStyles.value = {
        ...newFixedStyles,
        ...newIsFixed ? newPlaceholderStyles : {}
      };
    });
    onMounted(() => {
      watchEffect((onInvalidate) => {
        const element = target2 && target2.value !== window && getElement(target2.value) || window;
        targetRef.value = element;
        if (element) {
          on(element, "scroll", updatePositionThrottle);
          on(element, "resize", updatePositionThrottle);
          onInvalidate(() => {
            off(element, "scroll", updatePositionThrottle);
            off(element, "resize", updatePositionThrottle);
          });
        }
      });
      watchEffect((onInvalidate) => {
        if (!targetRef.value)
          return;
        const container2 = targetContainer && targetContainer.value !== window && getElement(targetContainer.value) || window;
        if (container2) {
          on(container2, "scroll", updatePositionThrottle);
          on(container2, "resize", updatePositionThrottle);
          onInvalidate(() => {
            off(container2, "scroll", updatePositionThrottle);
            off(container2, "resize", updatePositionThrottle);
          });
        }
      });
    });
    return {
      wrapperRef,
      isFixed,
      classNames,
      placeholderStyles,
      fixedStyles,
      updatePositionThrottle
    };
  },
  methods: {
    updatePosition() {
      this.updatePositionThrottle();
    }
  }
});
const _hoisted_1$4U = { ref: "wrapperRef" };
function _sfc_render$6z(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  return openBlock(), createBlock(_component_ResizeObserver, { onResize: _ctx.updatePositionThrottle }, {
    default: withCtx(() => [
      createBaseVNode("div", _hoisted_1$4U, [
        _ctx.isFixed ? (openBlock(), createElementBlock("div", {
          key: 0,
          style: normalizeStyle(_ctx.placeholderStyles)
        }, null, 4)) : createCommentVNode("v-if", true),
        createBaseVNode("div", {
          class: normalizeClass(_ctx.classNames),
          style: normalizeStyle(_ctx.fixedStyles)
        }, [
          createVNode(_component_ResizeObserver, { onResize: _ctx.updatePositionThrottle }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 8, ["onResize"])
        ], 6)
      ], 512)
    ]),
    _: 3
  }, 8, ["onResize"]);
}
var _Affix = /* @__PURE__ */ _export_sfc(_sfc_main$6A, [["render", _sfc_render$6z]]);
const Affix = Object.assign(_Affix, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Affix.name, _Affix);
  }
});
const _sfc_main$6z = defineComponent({
  name: "IconHover",
  props: {
    prefix: {
      type: String
    },
    size: {
      type: String,
      default: "medium"
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  setup() {
    const prefixCls = getPrefixCls("icon-hover");
    return {
      prefixCls
    };
  }
});
function _sfc_render$6y(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("span", {
    class: normalizeClass([
      _ctx.prefixCls,
      {
        [`${_ctx.prefix}-icon-hover`]: _ctx.prefix,
        [`${_ctx.prefixCls}-size-${_ctx.size}`]: _ctx.size !== "medium",
        [`${_ctx.prefixCls}-disabled`]: _ctx.disabled
      }
    ])
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var IconHover = /* @__PURE__ */ _export_sfc(_sfc_main$6z, [["render", _sfc_render$6y]]);
const _sfc_main$6y = defineComponent({
  name: "IconClose",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-close`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4T = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6x(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M9.857 9.858 24 24m0 0 14.142 14.142M24 24 38.142 9.858M24 24 9.857 38.142" }, null, -1)
  ]), 14, _hoisted_1$4T);
}
var _IconClose = /* @__PURE__ */ _export_sfc(_sfc_main$6y, [["render", _sfc_render$6x]]);
const IconClose = Object.assign(_IconClose, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconClose.name, _IconClose);
  }
});
const _sfc_main$6x = defineComponent({
  name: "IconInfoCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-info-circle-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4S = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6w(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm2-30a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2Zm0 17h1a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-6a1 1 0 0 1-1-1v-2a1 1 0 0 1 1-1h1v-8a1 1 0 0 1-1-1v-2a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v11Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4S);
}
var _IconInfoCircleFill = /* @__PURE__ */ _export_sfc(_sfc_main$6x, [["render", _sfc_render$6w]]);
const IconInfoCircleFill = Object.assign(_IconInfoCircleFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconInfoCircleFill.name, _IconInfoCircleFill);
  }
});
const _sfc_main$6w = defineComponent({
  name: "IconCheckCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-check-circle-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4R = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6v(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm10.207-24.379a1 1 0 0 0 0-1.414l-1.414-1.414a1 1 0 0 0-1.414 0L22 26.172l-4.878-4.88a1 1 0 0 0-1.415 0l-1.414 1.415a1 1 0 0 0 0 1.414l7 7a1 1 0 0 0 1.414 0l11.5-11.5Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4R);
}
var _IconCheckCircleFill = /* @__PURE__ */ _export_sfc(_sfc_main$6w, [["render", _sfc_render$6v]]);
const IconCheckCircleFill = Object.assign(_IconCheckCircleFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconCheckCircleFill.name, _IconCheckCircleFill);
  }
});
const _sfc_main$6v = defineComponent({
  name: "IconExclamationCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-exclamation-circle-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4Q = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6u(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm-2-11a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v2Zm4-18a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V15Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4Q);
}
var _IconExclamationCircleFill = /* @__PURE__ */ _export_sfc(_sfc_main$6v, [["render", _sfc_render$6u]]);
const IconExclamationCircleFill = Object.assign(_IconExclamationCircleFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconExclamationCircleFill.name, _IconExclamationCircleFill);
  }
});
const _sfc_main$6u = defineComponent({
  name: "IconCloseCircleFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-close-circle-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4P = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6t(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm4.955-27.771-4.95 4.95-4.95-4.95a1 1 0 0 0-1.414 0l-1.414 1.414a1 1 0 0 0 0 1.414l4.95 4.95-4.95 4.95a1 1 0 0 0 0 1.414l1.414 1.414a1 1 0 0 0 1.414 0l4.95-4.95 4.95 4.95a1 1 0 0 0 1.414 0l1.414-1.414a1 1 0 0 0 0-1.414l-4.95-4.95 4.95-4.95a1 1 0 0 0 0-1.414l-1.414-1.414a1 1 0 0 0-1.414 0Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4P);
}
var _IconCloseCircleFill = /* @__PURE__ */ _export_sfc(_sfc_main$6u, [["render", _sfc_render$6t]]);
const IconCloseCircleFill = Object.assign(_IconCloseCircleFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconCloseCircleFill.name, _IconCloseCircleFill);
  }
});
const _sfc_main$6t = defineComponent({
  name: "Alert",
  components: {
    IconHover,
    IconClose,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  props: {
    type: {
      type: String,
      default: "info"
    },
    showIcon: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: false
    },
    title: String,
    banner: {
      type: Boolean,
      default: false
    },
    center: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    close: (ev) => true,
    afterClose: () => true
  },
  setup(props, { slots, emit }) {
    const prefixCls = getPrefixCls("alert");
    const visible = ref(true);
    const handleClose = (ev) => {
      visible.value = false;
      emit("close", ev);
    };
    const handleAfterLeave = () => {
      emit("afterClose");
    };
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-${props.type}`,
      {
        [`${prefixCls}-with-title`]: Boolean(props.title || slots.title),
        [`${prefixCls}-banner`]: props.banner,
        [`${prefixCls}-center`]: props.center
      }
    ]);
    return {
      prefixCls,
      cls,
      visible,
      handleClose,
      handleAfterLeave
    };
  }
});
function _sfc_render$6s(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  return openBlock(), createBlock(Transition, {
    name: "zoom-in-top",
    onAfterLeave: _ctx.handleAfterLeave
  }, {
    default: withCtx(() => [
      _ctx.visible ? (openBlock(), createElementBlock("div", {
        key: 0,
        role: "alert",
        class: normalizeClass(_ctx.cls)
      }, [
        _ctx.showIcon && !(_ctx.type === "normal" && !_ctx.$slots.icon) ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass(`${_ctx.prefixCls}-icon`)
        }, [
          renderSlot(_ctx.$slots, "icon", {}, () => [
            _ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, { key: 0 })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, { key: 1 })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 2 })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, { key: 3 })) : createCommentVNode("v-if", true)
          ])
        ], 2)) : createCommentVNode("v-if", true),
        createBaseVNode("div", {
          class: normalizeClass(`${_ctx.prefixCls}-body`)
        }, [
          _ctx.title || _ctx.$slots.title ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass(`${_ctx.prefixCls}-title`)
          }, [
            renderSlot(_ctx.$slots, "title", {}, () => [
              createTextVNode(toDisplayString(_ctx.title), 1)
            ])
          ], 2)) : createCommentVNode("v-if", true),
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-content`)
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 2)
        ], 2),
        _ctx.$slots.action ? (openBlock(), createElementBlock("div", {
          key: 1,
          class: normalizeClass(`${_ctx.prefixCls}-action`)
        }, [
          renderSlot(_ctx.$slots, "action")
        ], 2)) : createCommentVNode("v-if", true),
        _ctx.closable ? (openBlock(), createElementBlock("div", {
          key: 2,
          tabindex: "-1",
          role: "button",
          "aria-label": "Close",
          class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
          onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
        }, [
          renderSlot(_ctx.$slots, "close-element", {}, () => [
            createVNode(_component_icon_hover, null, {
              default: withCtx(() => [
                createVNode(_component_icon_close)
              ]),
              _: 1
            })
          ])
        ], 2)) : createCommentVNode("v-if", true)
      ], 2)) : createCommentVNode("v-if", true)
    ]),
    _: 3
  }, 8, ["onAfterLeave"]);
}
var _Alert = /* @__PURE__ */ _export_sfc(_sfc_main$6t, [["render", _sfc_render$6s]]);
const Alert = Object.assign(_Alert, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Alert.name, _Alert);
  }
});
function slide(el, top, cb) {
  const tween = new Tween({
    from: {
      scrollTop: el.scrollTop
    },
    to: {
      scrollTop: top
    },
    easing: "quartOut",
    duration: 300,
    onUpdate: (keys) => {
      el.scrollTop = keys.scrollTop;
    },
    onFinish: () => {
      if (isFunction(cb)) {
        cb();
      }
    }
  });
  tween.start();
}
const anchorInjectionKey = Symbol("ArcoAnchor");
const BOUNDARY_POSITIONS = ["start", "end", "center", "nearest"];
const _sfc_main$6s = defineComponent({
  name: "Anchor",
  props: {
    boundary: {
      type: [Number, String],
      default: "start",
      validator: (value) => {
        return isNumber(value) || BOUNDARY_POSITIONS.includes(value);
      }
    },
    lineLess: {
      type: Boolean,
      default: false
    },
    scrollContainer: {
      type: [String, Object]
    },
    changeHash: {
      type: Boolean,
      default: true
    },
    smooth: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    select: (hash, preHash) => true,
    change: (hash) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("anchor");
    const anchorRef = ref();
    const lineSliderRef = ref();
    const links = reactive({});
    const currentLink = ref("");
    const isScrolling = ref(false);
    const scrollContainerEle = ref();
    const containerEle = ref();
    const addLink = (hash, node) => {
      if (!hash)
        return;
      links[hash] = node;
    };
    const removeLink = (hash) => {
      delete links[hash];
    };
    const handleClick = (e, hash) => {
      if (!props.changeHash) {
        e.preventDefault();
      }
      if (hash) {
        scrollIntoView2(hash);
        handleAnchorChange(hash);
      }
      emit("select", hash, currentLink.value);
    };
    const scrollIntoView2 = (hash) => {
      try {
        const element = getElement(hash);
        if (!element)
          return;
        let block;
        let diff = 0;
        if (isNumber(props.boundary)) {
          block = "start";
          diff = props.boundary;
        } else {
          block = props.boundary;
        }
        const actions = i(element, { block });
        if (!actions.length)
          return;
        const { el, top } = actions[0];
        const targetTop = top - diff;
        slide(el, targetTop, () => {
          isScrolling.value = false;
        });
        isScrolling.value = true;
      } catch (e) {
        console.error(e);
      }
    };
    const handleScroll = throttleByRaf(() => {
      if (isScrolling.value)
        return;
      const element = getFirstInViewportEle();
      if (element && element.id) {
        const hash = `#${element.id}`;
        handleAnchorChange(hash);
      }
    });
    const handleAnchorChange = (hash) => {
      if (!links[hash] && anchorRef.value) {
        const element = getElement(`a[data-href='${hash}']`, anchorRef.value);
        if (!element)
          return;
        links[hash] = element;
      }
      if (hash !== currentLink.value) {
        currentLink.value = hash;
        nextTick(() => {
          emit("change", hash);
        });
      }
    };
    const getFirstInViewportEle = () => {
      if (!scrollContainerEle.value || !containerEle.value) {
        return void 0;
      }
      const boundary = isNumber(props.boundary) ? props.boundary : 0;
      const containerRect = containerEle.value.getBoundingClientRect();
      for (const hash of Object.keys(links)) {
        const element = getElement(hash);
        if (element) {
          const { top } = element.getBoundingClientRect();
          const offsetTop = isWindow(scrollContainerEle.value) ? top - boundary : top - containerRect.top - boundary;
          if (offsetTop >= 0 && offsetTop <= containerRect.height / 2) {
            return element;
          }
        }
      }
      return void 0;
    };
    watch(currentLink, () => {
      const link = links[currentLink.value];
      if (!props.lineLess && link && lineSliderRef.value) {
        lineSliderRef.value.style.top = `${link.offsetTop}px`;
      }
    });
    const bindScrollEvent = () => {
      if (scrollContainerEle.value) {
        on(scrollContainerEle.value, "scroll", handleScroll);
      }
    };
    const unbindScrollEvent = () => {
      if (scrollContainerEle.value) {
        off(scrollContainerEle.value, "scroll", handleScroll);
      }
    };
    const getContainer = () => {
      if (props.scrollContainer) {
        scrollContainerEle.value = isWindow(props.scrollContainer) ? window : getElement(props.scrollContainer);
        containerEle.value = isWindow(props.scrollContainer) ? document.documentElement : getElement(props.scrollContainer);
      } else {
        scrollContainerEle.value = window;
        containerEle.value = document.documentElement;
      }
    };
    onMounted(() => {
      getContainer();
      const hash = decodeURIComponent(window.location.hash);
      if (hash) {
        scrollIntoView2(hash);
        handleAnchorChange(hash);
      } else {
        handleScroll();
      }
      bindScrollEvent();
    });
    onBeforeUnmount(() => {
      unbindScrollEvent();
    });
    provide(
      anchorInjectionKey,
      reactive({
        currentLink,
        addLink,
        removeLink,
        handleClick
      })
    );
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-line-less`]: props.lineLess
      }
    ]);
    return {
      prefixCls,
      cls,
      anchorRef,
      lineSliderRef
    };
  }
});
function _sfc_render$6r(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    ref: "anchorRef",
    class: normalizeClass(_ctx.cls)
  }, [
    !_ctx.lineLess ? (openBlock(), createElementBlock("div", {
      key: 0,
      ref: "lineSliderRef",
      class: normalizeClass(`${_ctx.prefixCls}-line-slider`)
    }, null, 2)) : createCommentVNode("v-if", true),
    createBaseVNode("ul", {
      class: normalizeClass(`${_ctx.prefixCls}-list`)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)
  ], 2);
}
var _Anchor = /* @__PURE__ */ _export_sfc(_sfc_main$6s, [["render", _sfc_render$6r]]);
const _sfc_main$6r = defineComponent({
  name: "AnchorLink",
  props: {
    title: String,
    href: String
  },
  setup(props) {
    const prefixCls = getPrefixCls("anchor");
    const linkCls = `${prefixCls}-link`;
    const linkRef = ref();
    const context = inject(anchorInjectionKey, void 0);
    onMounted(() => {
      if (props.href && linkRef.value) {
        context == null ? void 0 : context.addLink(props.href, linkRef.value);
      }
    });
    const cls = computed(() => [
      `${linkCls}-item`,
      {
        [`${linkCls}-active`]: (context == null ? void 0 : context.currentLink) === props.href
      }
    ]);
    const handleClick = (e) => context == null ? void 0 : context.handleClick(e, props.href);
    return {
      prefixCls,
      linkCls,
      cls,
      linkRef,
      handleClick
    };
  }
});
const _hoisted_1$4O = ["href"];
function _sfc_render$6q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    ref: "linkRef",
    class: normalizeClass(_ctx.cls)
  }, [
    createBaseVNode("a", {
      class: normalizeClass(_ctx.linkCls),
      href: _ctx.href,
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
    }, [
      renderSlot(_ctx.$slots, "default", {}, () => [
        createTextVNode(toDisplayString(_ctx.title), 1)
      ])
    ], 10, _hoisted_1$4O),
    _ctx.$slots.sublist ? (openBlock(), createElementBlock("ul", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-sublist`)
    }, [
      renderSlot(_ctx.$slots, "sublist")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var AnchorLink = /* @__PURE__ */ _export_sfc(_sfc_main$6r, [["render", _sfc_render$6q]]);
const Anchor = Object.assign(_Anchor, {
  Link: AnchorLink,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Anchor.name, _Anchor);
    app.component(componentPrefix + AnchorLink.name, AnchorLink);
  }
});
const MESSAGE_TYPES = ["info", "success", "warning", "error"];
const INPUT_EVENTS = [
  "onFocus",
  "onFocusin",
  "onFocusout",
  "onBlur",
  "onChange",
  "onBeforeinput",
  "onInput",
  "onReset",
  "onSubmit",
  "onInvalid",
  "onKeydown",
  "onKeypress",
  "onKeyup",
  "onCopy",
  "onCut",
  "onPaste",
  "onCompositionstart",
  "onCompositionupdate",
  "onCompositionend",
  "onSelect",
  "autocomplete",
  "autofocus",
  "maxlength",
  "minlength",
  "name",
  "pattern",
  "readonly",
  "required"
];
const _sfc_main$6q = defineComponent({
  name: "IconLoading",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-loading`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4N = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6p(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M42 24c0 9.941-8.059 18-18 18S6 33.941 6 24 14.059 6 24 6" }, null, -1)
  ]), 14, _hoisted_1$4N);
}
var _IconLoading = /* @__PURE__ */ _export_sfc(_sfc_main$6q, [["render", _sfc_render$6p]]);
const IconLoading = Object.assign(_IconLoading, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconLoading.name, _IconLoading);
  }
});
const _sfc_main$6p = defineComponent({
  name: "FeedbackIcon",
  components: {
    IconLoading,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  props: {
    type: {
      type: String
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("feedback-icon");
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-status-${props.type}`
    ]);
    return {
      cls
    };
  }
});
function _sfc_render$6o(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_loading = resolveComponent("icon-loading");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass(_ctx.cls)
  }, [
    _ctx.type === "validating" ? (openBlock(), createBlock(_component_icon_loading, { key: 0 })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, { key: 1 })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 2 })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, { key: 3 })) : createCommentVNode("v-if", true)
  ], 2);
}
var FeedbackIcon = /* @__PURE__ */ _export_sfc(_sfc_main$6p, [["render", _sfc_render$6o]]);
const Enter = {
  key: "Enter",
  code: "Enter"
};
const Backspace = {
  key: "Backspace",
  code: "Backspace"
};
const ArrowLeft = {
  key: "ArrowLeft",
  code: "ArrowLeft"
};
const ArrowRight = {
  key: "ArrowRight",
  code: "ArrowRight"
};
const omit = (object, path) => {
  const result = { ...object };
  for (const item of path) {
    if (item in result) {
      delete result[item];
    }
  }
  return result;
};
function pick(obj, keys) {
  const clone = {};
  keys.forEach((key) => {
    const k = key;
    if (key in obj) {
      clone[k] = obj[k];
    }
  });
  return clone;
}
const formItemInjectionKey = Symbol(
  "ArcoFormItemContext"
);
const formInjectionKey = Symbol("ArcoFormContext");
const useFormItem = ({
  size,
  disabled,
  error,
  uninject
} = {}) => {
  const formItemCtx = !uninject ? inject(formItemInjectionKey, {}) : {};
  const mergedSize = computed(() => {
    var _a;
    return (_a = size == null ? void 0 : size.value) != null ? _a : formItemCtx.size;
  });
  const mergedDisabled = computed(
    () => (disabled == null ? void 0 : disabled.value) || formItemCtx.disabled
  );
  const mergedError = computed(() => (error == null ? void 0 : error.value) || formItemCtx.error);
  const feedback = toRef(formItemCtx, "feedback");
  const eventHandlers = toRef(formItemCtx, "eventHandlers");
  return {
    formItemCtx,
    mergedSize,
    mergedDisabled,
    mergedError,
    feedback,
    eventHandlers
  };
};
const useSize$1 = (size, { defaultValue = "medium" } = {}) => {
  const configProviderCtx = inject(configProviderInjectionKey, void 0);
  const mergedSize = computed(
    () => {
      var _a, _b;
      return (_b = (_a = size == null ? void 0 : size.value) != null ? _a : configProviderCtx == null ? void 0 : configProviderCtx.size) != null ? _b : defaultValue;
    }
  );
  return {
    mergedSize
  };
};
function useCursor(input) {
  const selectionRef = ref();
  function recordCursor() {
    if (!input.value)
      return;
    const { selectionStart, selectionEnd, value } = input.value;
    if (selectionStart == null || selectionEnd == null)
      return;
    const beforeTxt = value.slice(0, Math.max(0, selectionStart));
    const afterTxt = value.slice(Math.max(0, selectionEnd));
    selectionRef.value = {
      selectionStart,
      selectionEnd,
      value,
      beforeTxt,
      afterTxt
    };
  }
  function setCursor() {
    if (!input.value || !selectionRef.value)
      return;
    const { value } = input.value;
    const { beforeTxt, afterTxt, selectionStart } = selectionRef.value;
    if (!beforeTxt || !afterTxt || !selectionStart)
      return;
    let startPos = value.length;
    if (value.endsWith(afterTxt)) {
      startPos = value.length - afterTxt.length;
    } else if (value.startsWith(beforeTxt)) {
      startPos = beforeTxt.length;
    } else {
      const beforeLastChar = beforeTxt[selectionStart - 1];
      const newIndex = value.indexOf(beforeLastChar, selectionStart - 1);
      if (newIndex !== -1) {
        startPos = newIndex + 1;
      }
    }
    input.value.setSelectionRange(startPos, startPos);
  }
  return [recordCursor, setCursor];
}
var _Input = defineComponent({
  name: "Input",
  inheritAttrs: false,
  props: {
    modelValue: String,
    defaultValue: {
      type: String,
      default: ""
    },
    size: {
      type: String
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    placeholder: String,
    maxLength: {
      type: [Number, Object],
      default: 0
    },
    showWordLimit: {
      type: Boolean,
      default: false
    },
    wordLength: {
      type: Function
    },
    wordSlice: {
      type: Function
    },
    inputAttrs: {
      type: Object
    },
    type: {
      type: String,
      default: "text"
    },
    prepend: String,
    append: String
  },
  emits: {
    "update:modelValue": (value) => true,
    "input": (value, ev) => true,
    "change": (value, ev) => true,
    "pressEnter": (ev) => true,
    "clear": (ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, {
    emit,
    slots,
    attrs
  }) {
    const {
      size,
      disabled,
      error,
      modelValue
    } = toRefs(props);
    const prefixCls = getPrefixCls("input");
    const inputRef = ref();
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError: _mergedError,
      feedback,
      eventHandlers
    } = useFormItem({
      size,
      disabled,
      error
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const [recordCursor, setCursor] = useCursor(inputRef);
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : _value.value;
    });
    let preValue = computedValue.value;
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = "";
      }
    });
    watch(computedValue, (value, oldValue) => {
      preValue = oldValue;
    });
    const focused = ref(false);
    const showClearBtn = computed(() => props.allowClear && !props.readonly && !mergedDisabled.value && Boolean(computedValue.value));
    const isComposition = ref(false);
    const compositionValue = ref("");
    const getValueLength = (value) => {
      var _a;
      if (isFunction(props.wordLength)) {
        return props.wordLength(value);
      }
      return (_a = value.length) != null ? _a : 0;
    };
    const valueLength = computed(() => getValueLength(computedValue.value));
    const mergedError = computed(() => _mergedError.value || Boolean(isObject(props.maxLength) && props.maxLength.errorOnly && valueLength.value > maxLength.value));
    const maxLengthErrorOnly = computed(() => isObject(props.maxLength) && Boolean(props.maxLength.errorOnly));
    const maxLength = computed(() => {
      if (isObject(props.maxLength)) {
        return props.maxLength.length;
      }
      return props.maxLength;
    });
    const defaultMaxLength = computed(() => {
      const bytePerChar = getValueLength("a");
      return Math.floor(maxLength.value / bytePerChar);
    });
    const updateValue = (value) => {
      var _a, _b;
      if (maxLength.value && !maxLengthErrorOnly.value && getValueLength(value) > maxLength.value) {
        value = (_b = (_a = props.wordSlice) == null ? void 0 : _a.call(props, value, maxLength.value)) != null ? _b : value.slice(0, defaultMaxLength.value);
      }
      _value.value = value;
      emit("update:modelValue", value);
    };
    const handleMousedown = (e) => {
      if (inputRef.value && e.target !== inputRef.value) {
        e.preventDefault();
        inputRef.value.focus();
      }
    };
    const emitChange = (value, ev) => {
      var _a, _b;
      if (value !== preValue) {
        preValue = value;
        emit("change", value, ev);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a, ev);
      }
    };
    const handleFocus = (ev) => {
      var _a, _b;
      focused.value = true;
      emit("focus", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onFocus) == null ? void 0 : _b.call(_a, ev);
    };
    const handleBlur = (ev) => {
      var _a, _b;
      focused.value = false;
      emitChange(computedValue.value, ev);
      emit("blur", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a, ev);
    };
    const handleComposition = (e) => {
      var _a, _b, _c;
      const {
        value,
        selectionStart,
        selectionEnd
      } = e.target;
      if (e.type === "compositionend") {
        isComposition.value = false;
        compositionValue.value = "";
        if (maxLength.value && !maxLengthErrorOnly.value && valueLength.value >= maxLength.value && getValueLength(value) > maxLength.value && selectionStart === selectionEnd) {
          keepControl();
          return;
        }
        updateValue(value);
        emit("input", value, e);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onInput) == null ? void 0 : _b.call(_a, e);
        keepControl();
      } else {
        isComposition.value = true;
        compositionValue.value = computedValue.value + ((_c = e.data) != null ? _c : "");
      }
    };
    const keepControl = () => {
      recordCursor();
      nextTick(() => {
        if (inputRef.value && computedValue.value !== inputRef.value.value) {
          inputRef.value.value = computedValue.value;
          setCursor();
        }
      });
    };
    const handleInput = (e) => {
      var _a, _b;
      const {
        value
      } = e.target;
      if (!isComposition.value) {
        if (maxLength.value && !maxLengthErrorOnly.value && valueLength.value >= maxLength.value && getValueLength(value) > maxLength.value && e.inputType === "insertText") {
          keepControl();
          return;
        }
        updateValue(value);
        emit("input", value, e);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onInput) == null ? void 0 : _b.call(_a, e);
        keepControl();
      }
    };
    const handleClear = (ev) => {
      updateValue("");
      emitChange("", ev);
      emit("clear", ev);
    };
    const handleKeyDown = (e) => {
      const keyCode = e.key || e.code;
      if (!isComposition.value && keyCode === Enter.key) {
        emitChange(computedValue.value, e);
        emit("pressEnter", e);
      }
    };
    const outerCls = computed(() => [`${prefixCls}-outer`, `${prefixCls}-outer-size-${mergedSize.value}`, {
      [`${prefixCls}-outer-has-suffix`]: Boolean(slots.suffix),
      [`${prefixCls}-outer-disabled`]: mergedDisabled.value
    }]);
    const wrapperCls = computed(() => [`${prefixCls}-wrapper`, {
      [`${prefixCls}-error`]: mergedError.value,
      [`${prefixCls}-disabled`]: mergedDisabled.value,
      [`${prefixCls}-focus`]: focused.value
    }]);
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`]);
    const wrapperAttrs = computed(() => omit(attrs, INPUT_EVENTS));
    const inputAttrs = computed(() => pick(attrs, INPUT_EVENTS));
    const mergeInputAttrs = computed(() => {
      const attrs2 = {
        ...inputAttrs.value,
        ...props.inputAttrs
      };
      if (mergedError.value) {
        attrs2["aria-invalid"] = true;
      }
      return attrs2;
    });
    const renderInput = (hasOuter) => {
      var _a;
      return createVNode("span", mergeProps({
        "class": wrapperCls.value,
        "onMousedown": handleMousedown
      }, !hasOuter ? wrapperAttrs.value : void 0), [slots.prefix && createVNode("span", {
        "class": `${prefixCls}-prefix`
      }, [slots.prefix()]), createVNode("input", mergeProps({
        "ref": inputRef,
        "class": cls.value,
        "value": computedValue.value,
        "type": props.type,
        "placeholder": props.placeholder,
        "readonly": props.readonly,
        "disabled": mergedDisabled.value,
        "onInput": handleInput,
        "onKeydown": handleKeyDown,
        "onFocus": handleFocus,
        "onBlur": handleBlur,
        "onCompositionstart": handleComposition,
        "onCompositionupdate": handleComposition,
        "onCompositionend": handleComposition
      }, mergeInputAttrs.value), null), showClearBtn.value && createVNode(IconHover, {
        "prefix": prefixCls,
        "class": `${prefixCls}-clear-btn`,
        "onClick": handleClear
      }, {
        default: () => [createVNode(IconClose, null, null)]
      }), (slots.suffix || Boolean(props.maxLength) && props.showWordLimit || Boolean(feedback.value)) && createVNode("span", {
        "class": [`${prefixCls}-suffix`, {
          [`${prefixCls}-suffix-has-feedback`]: feedback.value
        }]
      }, [Boolean(props.maxLength) && props.showWordLimit && createVNode("span", {
        "class": `${prefixCls}-word-limit`
      }, [valueLength.value, createTextVNode("/"), maxLength.value]), (_a = slots.suffix) == null ? void 0 : _a.call(slots), Boolean(feedback.value) && createVNode(FeedbackIcon, {
        "type": feedback.value
      }, null)])]);
    };
    const render2 = () => {
      if (slots.prepend || slots.append || props.prepend || props.append) {
        return createVNode("span", mergeProps({
          "class": outerCls.value
        }, wrapperAttrs.value), [(slots.prepend || props.prepend) && createVNode("span", {
          "class": `${prefixCls}-prepend`
        }, [slots.prepend ? slots.prepend() : props.prepend]), renderInput(true), (slots.append || props.append) && createVNode("span", {
          "class": `${prefixCls}-append`
        }, [slots.append ? slots.append() : props.append])]);
      }
      return renderInput();
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const _sfc_main$6o = defineComponent({
  name: "IconSearch",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-search`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4M = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6n(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M33.072 33.071c6.248-6.248 6.248-16.379 0-22.627-6.249-6.249-16.38-6.249-22.628 0-6.248 6.248-6.248 16.379 0 22.627 6.248 6.248 16.38 6.248 22.628 0Zm0 0 8.485 8.485" }, null, -1)
  ]), 14, _hoisted_1$4M);
}
var _IconSearch = /* @__PURE__ */ _export_sfc(_sfc_main$6o, [["render", _sfc_render$6n]]);
const IconSearch = Object.assign(_IconSearch, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconSearch.name, _IconSearch);
  }
});
const buttonGroupInjectionKey = Symbol("ArcoButtonGroup");
const _sfc_main$6n = defineComponent({
  name: "Button",
  components: {
    IconLoading
  },
  props: {
    type: {
      type: String
    },
    shape: {
      type: String
    },
    status: {
      type: String
    },
    size: {
      type: String
    },
    long: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean
    },
    htmlType: {
      type: String,
      default: "button"
    },
    autofocus: {
      type: Boolean,
      default: false
    },
    href: String
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const { size, disabled } = toRefs(props);
    const prefixCls = getPrefixCls("btn");
    const groupContext = inject(buttonGroupInjectionKey, void 0);
    const _size = computed(() => {
      var _a;
      return (_a = size.value) != null ? _a : groupContext == null ? void 0 : groupContext.size;
    });
    const _disabled = computed(
      () => Boolean(disabled.value || (groupContext == null ? void 0 : groupContext.disabled))
    );
    const { mergedSize: _mergedSize, mergedDisabled } = useFormItem({
      size: _size,
      disabled: _disabled
    });
    const { mergedSize } = useSize$1(_mergedSize);
    const cls = computed(() => {
      var _a, _b, _c, _d, _e, _f;
      return [
        prefixCls,
        `${prefixCls}-${(_b = (_a = props.type) != null ? _a : groupContext == null ? void 0 : groupContext.type) != null ? _b : "secondary"}`,
        `${prefixCls}-shape-${(_d = (_c = props.shape) != null ? _c : groupContext == null ? void 0 : groupContext.shape) != null ? _d : "square"}`,
        `${prefixCls}-size-${mergedSize.value}`,
        `${prefixCls}-status-${(_f = (_e = props.status) != null ? _e : groupContext == null ? void 0 : groupContext.status) != null ? _f : "normal"}`,
        {
          [`${prefixCls}-long`]: props.long,
          [`${prefixCls}-loading`]: props.loading,
          [`${prefixCls}-disabled`]: mergedDisabled.value,
          [`${prefixCls}-link`]: isString(props.href)
        }
      ];
    });
    const handleClick = (ev) => {
      if (props.disabled || props.loading) {
        ev.preventDefault();
        return;
      }
      emit("click", ev);
    };
    return {
      prefixCls,
      cls,
      mergedDisabled,
      handleClick
    };
  }
});
const _hoisted_1$4L = ["href"];
const _hoisted_2$6 = ["type", "disabled", "autofocus"];
function _sfc_render$6m(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_loading = resolveComponent("icon-loading");
  return _ctx.href ? (openBlock(), createElementBlock("a", {
    key: 0,
    class: normalizeClass([
      _ctx.cls,
      { [`${_ctx.prefixCls}-only-icon`]: _ctx.$slots.icon && !_ctx.$slots.default }
    ]),
    href: _ctx.mergedDisabled || _ctx.loading ? void 0 : _ctx.href,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    _ctx.loading || _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [
      _ctx.loading ? (openBlock(), createBlock(_component_icon_loading, {
        key: 0,
        spin: "true"
      })) : renderSlot(_ctx.$slots, "icon", { key: 1 })
    ], 2)) : createCommentVNode("v-if", true),
    renderSlot(_ctx.$slots, "default")
  ], 10, _hoisted_1$4L)) : (openBlock(), createElementBlock("button", {
    key: 1,
    class: normalizeClass([
      _ctx.cls,
      { [`${_ctx.prefixCls}-only-icon`]: _ctx.$slots.icon && !_ctx.$slots.default }
    ]),
    type: _ctx.htmlType,
    disabled: _ctx.mergedDisabled,
    autofocus: _ctx.autofocus,
    onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    _ctx.loading || _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [
      _ctx.loading ? (openBlock(), createBlock(_component_icon_loading, {
        key: 0,
        spin: true
      })) : renderSlot(_ctx.$slots, "icon", { key: 1 })
    ], 2)) : createCommentVNode("v-if", true),
    renderSlot(_ctx.$slots, "default")
  ], 10, _hoisted_2$6));
}
var _Button = /* @__PURE__ */ _export_sfc(_sfc_main$6n, [["render", _sfc_render$6m]]);
const _sfc_main$6m = defineComponent({
  name: "ButtonGroup",
  props: {
    type: {
      type: String
    },
    status: {
      type: String
    },
    shape: {
      type: String
    },
    size: {
      type: String
    },
    disabled: {
      type: Boolean
    }
  },
  setup(props) {
    const { type, size, status, disabled, shape } = toRefs(props);
    const prefixCls = getPrefixCls("btn-group");
    provide(
      buttonGroupInjectionKey,
      reactive({
        type,
        size,
        shape,
        status,
        disabled
      })
    );
    return {
      prefixCls
    };
  }
});
function _sfc_render$6l(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var ButtonGroup = /* @__PURE__ */ _export_sfc(_sfc_main$6m, [["render", _sfc_render$6l]]);
const Button = Object.assign(_Button, {
  Group: ButtonGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Button.name, _Button);
    app.component(componentPrefix + ButtonGroup.name, ButtonGroup);
  }
});
var InputSearch = defineComponent({
  name: "InputSearch",
  props: {
    searchButton: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    buttonText: {
      type: String
    },
    buttonProps: {
      type: Object
    }
  },
  emits: {
    search: (value, ev) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      size
    } = toRefs(props);
    const prefixCls = getPrefixCls("input-search");
    const {
      mergedSize
    } = useSize$1(size);
    const inputRef = ref();
    const handleClick = (e) => {
      if (inputRef.value.inputRef) {
        emit("search", inputRef.value.inputRef.value, e);
      }
    };
    const renderSuffix = () => {
      var _a;
      return createVNode(Fragment, null, [props.loading ? createVNode(IconLoading, null, null) : createVNode(IconHover, {
        "onClick": handleClick
      }, {
        default: () => [createVNode(IconSearch, null, null)]
      }), (_a = slots.suffix) == null ? void 0 : _a.call(slots)]);
    };
    const renderButton = () => {
      var _a;
      let _slots = {};
      if (props.buttonText || slots["button-default"] || slots["button-icon"]) {
        _slots = {
          default: (_a = slots["button-default"]) != null ? _a : props.buttonText ? () => props.buttonText : void 0,
          icon: slots["button-icon"]
        };
      } else {
        _slots = {
          icon: () => createVNode(IconSearch, null, null)
        };
      }
      return createVNode(Button, mergeProps({
        "type": "primary",
        "class": `${prefixCls}-btn`,
        "disabled": props.disabled,
        "size": mergedSize.value,
        "loading": props.loading
      }, props.buttonProps, {
        "onClick": handleClick
      }), _slots);
    };
    const render2 = () => createVNode(_Input, {
      "ref": inputRef,
      "class": prefixCls,
      "size": mergedSize.value,
      "disabled": props.disabled
    }, {
      prepend: slots.prepend,
      prefix: slots.prefix,
      suffix: props.searchButton ? slots.suffix : renderSuffix,
      append: props.searchButton ? renderButton : slots.append
    });
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const _sfc_main$6l = defineComponent({
  name: "IconEye",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-eye`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4K = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6k(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "clip-rule": "evenodd",
      d: "M24 37c6.627 0 12.627-4.333 18-13-5.373-8.667-11.373-13-18-13-6.627 0-12.627 4.333-18 13 5.373 8.667 11.373 13 18 13Z"
    }, null, -1),
    createBaseVNode("path", { d: "M29 24a5 5 0 1 1-10 0 5 5 0 0 1 10 0Z" }, null, -1)
  ]), 14, _hoisted_1$4K);
}
var _IconEye = /* @__PURE__ */ _export_sfc(_sfc_main$6l, [["render", _sfc_render$6k]]);
const IconEye = Object.assign(_IconEye, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconEye.name, _IconEye);
  }
});
const _sfc_main$6k = defineComponent({
  name: "IconEyeInvisible",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-eye-invisible`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4J = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6j(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M14 14.5c-2.69 2-5.415 5.33-8 9.5 5.373 8.667 11.373 13 18 13 3.325 0 6.491-1.09 9.5-3.271M17.463 12.5C19 11 21.75 11 24 11c6.627 0 12.627 4.333 18 13-1.766 2.848-3.599 5.228-5.5 7.14" }, null, -1),
    createBaseVNode("path", { d: "M29 24a5 5 0 1 1-10 0 5 5 0 0 1 10 0ZM6.852 7.103l34.294 34.294" }, null, -1)
  ]), 14, _hoisted_1$4J);
}
var _IconEyeInvisible = /* @__PURE__ */ _export_sfc(_sfc_main$6k, [["render", _sfc_render$6j]]);
const IconEyeInvisible = Object.assign(_IconEyeInvisible, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconEyeInvisible.name, _IconEyeInvisible);
  }
});
function useState(defaultValue) {
  const value = ref(defaultValue);
  const setValue = (newValue) => {
    value.value = newValue;
  };
  return [value, setValue];
}
function useMergeState(defaultValue, props) {
  const { value } = toRefs(props);
  const [localValue, setLocalValue] = useState(
    !isUndefined(value.value) ? value.value : defaultValue
  );
  watch(value, (newVal) => {
    isUndefined(newVal) && setLocalValue(void 0);
  });
  const mergeValue = computed(
    () => !isUndefined(value.value) ? value.value : localValue.value
  );
  return [mergeValue, setLocalValue, localValue];
}
const _sfc_main$6j = defineComponent({
  name: "InputPassword",
  components: {
    IconEye,
    IconEyeInvisible,
    AIconHover: IconHover,
    AInput: _Input
  },
  props: {
    visibility: {
      type: Boolean,
      default: void 0
    },
    defaultVisibility: {
      type: Boolean,
      default: true
    },
    invisibleButton: {
      type: Boolean,
      default: true
    }
  },
  emits: [
    "visibility-change",
    "update:visibility"
  ],
  setup(props, { emit }) {
    const { visibility, defaultVisibility } = toRefs(props);
    const inputRef = ref();
    const handleInvisible = () => {
      setVisible(!mergedVisible.value);
    };
    const [mergedVisible, setLocalVisible] = useMergeState(
      defaultVisibility.value,
      reactive({
        value: visibility
      })
    );
    const setVisible = (newVisible) => {
      if (newVisible !== mergedVisible.value) {
        emit("visibility-change", newVisible);
        emit("update:visibility", newVisible);
        setLocalVisible(newVisible);
      }
    };
    return {
      inputRef,
      mergedVisible,
      handleInvisible
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  }
});
function _sfc_render$6i(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_eye = resolveComponent("icon-eye");
  const _component_icon_eye_invisible = resolveComponent("icon-eye-invisible");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  const _component_a_input = resolveComponent("a-input");
  return openBlock(), createBlock(_component_a_input, {
    ref: "inputRef",
    type: _ctx.mergedVisible ? "password" : "text"
  }, createSlots({ _: 2 }, [
    _ctx.$slots.prepend ? {
      name: "prepend",
      fn: withCtx(() => [
        renderSlot(_ctx.$slots, "prepend")
      ]),
      key: "0"
    } : void 0,
    _ctx.$slots.prefix ? {
      name: "prefix",
      fn: withCtx(() => [
        renderSlot(_ctx.$slots, "prefix")
      ]),
      key: "1"
    } : void 0,
    _ctx.invisibleButton || _ctx.$slots.suffix ? {
      name: "suffix",
      fn: withCtx(() => [
        _ctx.invisibleButton ? (openBlock(), createBlock(_component_a_icon_hover, {
          key: 0,
          onClick: _ctx.handleInvisible,
          onMousedown: _cache[0] || (_cache[0] = withModifiers(() => {
          }, ["prevent"])),
          onMouseup: _cache[1] || (_cache[1] = withModifiers(() => {
          }, ["prevent"]))
        }, {
          default: withCtx(() => [
            !_ctx.mergedVisible ? (openBlock(), createBlock(_component_icon_eye, { key: 0 })) : (openBlock(), createBlock(_component_icon_eye_invisible, { key: 1 }))
          ]),
          _: 1
        }, 8, ["onClick"])) : createCommentVNode("v-if", true),
        renderSlot(_ctx.$slots, "suffix")
      ]),
      key: "2"
    } : void 0,
    _ctx.$slots.append ? {
      name: "append",
      fn: withCtx(() => [
        renderSlot(_ctx.$slots, "append")
      ]),
      key: "3"
    } : void 0
  ]), 1032, ["type"]);
}
var InputPassword = /* @__PURE__ */ _export_sfc(_sfc_main$6j, [["render", _sfc_render$6i]]);
const _sfc_main$6i = defineComponent({
  name: "InputGroup",
  setup() {
    const prefixCls = getPrefixCls("input-group");
    return {
      prefixCls
    };
  }
});
function _sfc_render$6h(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var InputGroup = /* @__PURE__ */ _export_sfc(_sfc_main$6i, [["render", _sfc_render$6h]]);
const Input = Object.assign(_Input, {
  Search: InputSearch,
  Password: InputPassword,
  Group: InputGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Input.name, _Input);
    app.component(componentPrefix + InputGroup.name, InputGroup);
    app.component(componentPrefix + InputSearch.name, InputSearch);
    app.component(componentPrefix + InputPassword.name, InputPassword);
  }
});
const getViewPortSize = () => {
  const { height, width } = getDocumentSize();
  return {
    width: Math.min(width, window.innerWidth),
    height: Math.min(height, window.innerHeight)
  };
};
const getElementScrollRect = (element, containerRect) => {
  var _a, _b;
  const rect = element.getBoundingClientRect();
  return {
    top: rect.top,
    bottom: rect.bottom,
    left: rect.left,
    right: rect.right,
    scrollTop: rect.top - containerRect.top,
    scrollBottom: rect.bottom - containerRect.top,
    scrollLeft: rect.left - containerRect.left,
    scrollRight: rect.right - containerRect.left,
    width: (_a = element.offsetWidth) != null ? _a : element.clientWidth,
    height: (_b = element.offsetHeight) != null ? _b : element.clientHeight
  };
};
const getBoundaryPosition = (position) => {
  switch (position) {
    case "top":
    case "tl":
    case "tr":
      return "top";
    case "bottom":
    case "bl":
    case "br":
      return "bottom";
    case "left":
    case "lt":
    case "lb":
      return "left";
    case "right":
    case "rt":
    case "rb":
      return "right";
    default:
      return "top";
  }
};
const changePosition = (position, direction) => {
  switch (direction) {
    case "top":
      switch (position) {
        case "bottom":
          return "top";
        case "bl":
          return "tl";
        case "br":
          return "tr";
        default:
          return position;
      }
    case "bottom":
      switch (position) {
        case "top":
          return "bottom";
        case "tl":
          return "bl";
        case "tr":
          return "br";
        default:
          return position;
      }
    case "left":
      switch (position) {
        case "right":
          return "left";
        case "rt":
          return "lt";
        case "rb":
          return "lb";
        default:
          return position;
      }
    case "right":
      switch (position) {
        case "left":
          return "right";
        case "lt":
          return "rt";
        case "lb":
          return "rb";
        default:
          return position;
      }
    default:
      return position;
  }
};
const getFitPosition = (position, popupPosition, {
  containerRect,
  triggerRect,
  popupRect,
  offset,
  translate
}) => {
  const direction = getBoundaryPosition(position);
  const viewPortSize = getViewPortSize();
  const viewPortBoundary = {
    top: containerRect.top + popupPosition.top,
    bottom: viewPortSize.height - (containerRect.top + popupPosition.top + popupRect.height),
    left: containerRect.left + popupPosition.left,
    right: viewPortSize.width - (containerRect.left + popupPosition.left + popupRect.width)
  };
  let finalPosition = position;
  if (direction === "top" && viewPortBoundary.top < 0) {
    if (triggerRect.top > popupRect.height) {
      popupPosition.top = -containerRect.top;
    } else {
      const fitPosition = getPopupOffset("bottom", triggerRect, popupRect, {
        offset,
        translate
      });
      if (viewPortSize.height - (containerRect.top + fitPosition.top + popupRect.height) > 0) {
        finalPosition = changePosition(position, "bottom");
        popupPosition.top = fitPosition.top;
      }
    }
  }
  if (direction === "bottom" && viewPortBoundary.bottom < 0) {
    if (viewPortSize.height - triggerRect.bottom > popupRect.height) {
      popupPosition.top = -containerRect.top + (viewPortSize.height - popupRect.height);
    } else {
      const fitPosition = getPopupOffset("top", triggerRect, popupRect, {
        offset,
        translate
      });
      if (containerRect.top + fitPosition.top > 0) {
        finalPosition = changePosition(position, "top");
        popupPosition.top = fitPosition.top;
      }
    }
  }
  if (direction === "left" && viewPortBoundary.left < 0) {
    if (triggerRect.left > popupRect.width) {
      popupPosition.left = -containerRect.left;
    } else {
      const fitPosition = getPopupOffset("right", triggerRect, popupRect, {
        offset,
        translate
      });
      if (viewPortSize.width - (containerRect.left + fitPosition.left + popupRect.width) > 0) {
        finalPosition = changePosition(position, "right");
        popupPosition.left = fitPosition.left;
      }
    }
  }
  if (direction === "right" && viewPortBoundary.right < 0) {
    if (viewPortSize.width - triggerRect.right > popupRect.width) {
      popupPosition.left = -containerRect.left + (viewPortSize.width - popupRect.width);
    } else {
      const fitPosition = getPopupOffset("left", triggerRect, popupRect, {
        offset,
        translate
      });
      if (containerRect.left + fitPosition.left > 0) {
        finalPosition = changePosition(position, "left");
        popupPosition.left = fitPosition.left;
      }
    }
  }
  if (direction === "top" || direction === "bottom") {
    if (viewPortBoundary.left < 0) {
      popupPosition.left = -containerRect.left;
    } else if (viewPortBoundary.right < 0) {
      popupPosition.left = -containerRect.left + (viewPortSize.width - popupRect.width);
    }
  }
  if (direction === "left" || direction === "right") {
    if (viewPortBoundary.top < 0) {
      popupPosition.top = -containerRect.top;
    } else if (viewPortBoundary.bottom < 0) {
      popupPosition.top = -containerRect.top + (viewPortSize.height - popupRect.height);
    }
  }
  return {
    popupPosition,
    position: finalPosition
  };
};
const getPopupOffset = (position, triggerRect, popupRect, {
  offset = 0,
  translate = [0, 0]
} = {}) => {
  var _a;
  const _translate = (_a = isArray(translate) ? translate : translate[position]) != null ? _a : [0, 0];
  switch (position) {
    case "top":
      return {
        left: triggerRect.scrollLeft + Math.round(triggerRect.width / 2) - Math.round(popupRect.width / 2) + _translate[0],
        top: triggerRect.scrollTop - popupRect.height - offset + _translate[1]
      };
    case "tl":
      return {
        left: triggerRect.scrollLeft + _translate[0],
        top: triggerRect.scrollTop - popupRect.height - offset + _translate[1]
      };
    case "tr":
      return {
        left: triggerRect.scrollRight - popupRect.width + _translate[0],
        top: triggerRect.scrollTop - popupRect.height - offset + _translate[1]
      };
    case "bottom":
      return {
        left: triggerRect.scrollLeft + Math.round(triggerRect.width / 2) - Math.round(popupRect.width / 2) + _translate[0],
        top: triggerRect.scrollBottom + offset + _translate[1]
      };
    case "bl":
      return {
        left: triggerRect.scrollLeft + _translate[0],
        top: triggerRect.scrollBottom + offset + _translate[1]
      };
    case "br":
      return {
        left: triggerRect.scrollRight - popupRect.width + _translate[0],
        top: triggerRect.scrollBottom + offset + _translate[1]
      };
    case "left":
      return {
        left: triggerRect.scrollLeft - popupRect.width - offset + _translate[0],
        top: triggerRect.scrollTop + Math.round(triggerRect.height / 2) - Math.round(popupRect.height / 2) + _translate[1]
      };
    case "lt":
      return {
        left: triggerRect.scrollLeft - popupRect.width - offset + _translate[0],
        top: triggerRect.scrollTop + _translate[1]
      };
    case "lb":
      return {
        left: triggerRect.scrollLeft - popupRect.width - offset + _translate[0],
        top: triggerRect.scrollBottom - popupRect.height + _translate[1]
      };
    case "right":
      return {
        left: triggerRect.scrollRight + offset + _translate[0],
        top: triggerRect.scrollTop + Math.round(triggerRect.height / 2) - Math.round(popupRect.height / 2) + _translate[1]
      };
    case "rt":
      return {
        left: triggerRect.scrollRight + offset + _translate[0],
        top: triggerRect.scrollTop + _translate[1]
      };
    case "rb":
      return {
        left: triggerRect.scrollRight + offset + _translate[0],
        top: triggerRect.scrollBottom - popupRect.height + _translate[1]
      };
    default:
      return {
        left: 0,
        top: 0
      };
  }
};
const getTransformOrigin = (position) => {
  let originX = "0";
  if (["top", "bottom"].includes(position)) {
    originX = "50%";
  } else if (["left", "lt", "lb", "tr", "br"].includes(position)) {
    originX = "100%";
  }
  let originY = "0";
  if (["left", "right"].includes(position)) {
    originY = "50%";
  } else if (["top", "tl", "tr", "lb", "rb"].includes(position)) {
    originY = "100%";
  }
  return `${originX} ${originY}`;
};
const getPopupStyle = (position, containerRect, triggerRect, popupRect, {
  offset = 0,
  translate = [0, 0],
  customStyle = {},
  autoFitPosition = false
} = {}) => {
  let finalPosition = position;
  let popupPosition = getPopupOffset(position, triggerRect, popupRect, {
    offset,
    translate
  });
  if (autoFitPosition) {
    const result = getFitPosition(position, popupPosition, {
      containerRect,
      popupRect,
      triggerRect,
      offset,
      translate
    });
    popupPosition = result.popupPosition;
    finalPosition = result.position;
  }
  const style = {
    left: `${popupPosition.left}px`,
    top: `${popupPosition.top}px`,
    ...customStyle
  };
  return {
    style,
    position: finalPosition
  };
};
const getArrowStyle = (position, triggerRect, popupRect, {
  customStyle = {}
}) => {
  if (["top", "tl", "tr", "bottom", "bl", "br"].includes(position)) {
    let offsetLeft = Math.abs(
      triggerRect.scrollLeft + triggerRect.width / 2 - popupRect.scrollLeft
    );
    if (offsetLeft > popupRect.width - 8) {
      if (triggerRect.width > popupRect.width) {
        offsetLeft = popupRect.width / 2;
      } else {
        offsetLeft = popupRect.width - 8;
      }
    }
    if (["top", "tl", "tr"].includes(position)) {
      return {
        left: `${offsetLeft}px`,
        bottom: "0",
        transform: "translate(-50%,50%) rotate(45deg)",
        ...customStyle
      };
    }
    return {
      left: `${offsetLeft}px`,
      top: "0",
      transform: "translate(-50%,-50%) rotate(45deg)",
      ...customStyle
    };
  }
  let offsetTop = Math.abs(
    triggerRect.scrollTop + triggerRect.height / 2 - popupRect.scrollTop
  );
  if (offsetTop > popupRect.height - 8) {
    if (triggerRect.height > popupRect.height) {
      offsetTop = popupRect.height / 2;
    } else {
      offsetTop = popupRect.height - 8;
    }
  }
  if (["left", "lt", "lb"].includes(position)) {
    return {
      top: `${offsetTop}px`,
      right: "0",
      transform: "translate(50%,-50%) rotate(45deg)",
      ...customStyle
    };
  }
  return {
    top: `${offsetTop}px`,
    left: "0",
    transform: "translate(-50%,-50%) rotate(45deg)",
    ...customStyle
  };
};
const isScrollElement = (element) => {
  return element.scrollHeight > element.offsetHeight || element.scrollWidth > element.offsetWidth;
};
const getScrollElements = (container2) => {
  var _a;
  const scrollElements = [];
  let element = container2;
  while (element && element !== document.documentElement) {
    if (isScrollElement(element)) {
      scrollElements.push(element);
    }
    element = (_a = element.parentElement) != null ? _a : void 0;
  }
  return scrollElements;
};
const useFirstElement = () => {
  const children = {};
  const firstElement = ref();
  const getFirstElement = () => {
    const element = getFirstElementFromChildren(children.value);
    if (element !== firstElement.value) {
      firstElement.value = element;
    }
  };
  onMounted(() => getFirstElement());
  onUpdated(() => getFirstElement());
  return {
    children,
    firstElement
  };
};
var ResizeObserver = defineComponent({
  name: "ResizeObserver",
  props: {
    watchOnUpdated: Boolean
  },
  emits: [
    "resize"
  ],
  setup(props, { emit, slots }) {
    const { children, firstElement } = useFirstElement();
    let resizeObserver;
    const createResizeObserver = (target2) => {
      if (!target2)
        return;
      resizeObserver = new index((entries) => {
        const entry = entries[0];
        emit("resize", entry);
      });
      resizeObserver.observe(target2);
    };
    const destroyResizeObserver = () => {
      if (resizeObserver) {
        resizeObserver.disconnect();
        resizeObserver = null;
      }
    };
    watch(firstElement, (element) => {
      if (resizeObserver)
        destroyResizeObserver();
      if (element) {
        createResizeObserver(element);
      }
    });
    onBeforeUnmount(() => {
      if (resizeObserver)
        destroyResizeObserver();
    });
    return () => {
      var _a;
      children.value = (_a = slots.default) == null ? void 0 : _a.call(slots);
      return children.value;
    };
  }
});
function usePickSlots(slots, slotName) {
  const slot = ref(slots[slotName]);
  onUpdated(() => {
    const newSlot = slots[slotName];
    if (slot.value !== newSlot) {
      slot.value = newSlot;
    }
  });
  return slot;
}
const triggerInjectionKey = Symbol("ArcoTrigger");
const POPUP_BASE_Z_INDEX = 1e3;
const MESSAGE_BASE_Z_INDEX = 5e3;
const Z_INDEX_STEP = 1;
class PopupManager {
  constructor() {
    this.popupStack = {
      popup: /* @__PURE__ */ new Set(),
      dialog: /* @__PURE__ */ new Set(),
      message: /* @__PURE__ */ new Set()
    };
    this.getNextZIndex = (type) => {
      const current = type === "message" ? Array.from(this.popupStack.message).pop() || MESSAGE_BASE_Z_INDEX : Array.from(this.popupStack.popup).pop() || POPUP_BASE_Z_INDEX;
      return current + Z_INDEX_STEP;
    };
    this.add = (type) => {
      const zIndex = this.getNextZIndex(type);
      this.popupStack[type].add(zIndex);
      if (type === "dialog") {
        this.popupStack.popup.add(zIndex);
      }
      return zIndex;
    };
    this.delete = (zIndex, type) => {
      this.popupStack[type].delete(zIndex);
      if (type === "dialog") {
        this.popupStack.popup.delete(zIndex);
      }
    };
    this.isLastDialog = (zIndex) => {
      if (this.popupStack.dialog.size > 1) {
        return zIndex === Array.from(this.popupStack.dialog).pop();
      }
      return true;
    };
  }
}
const popupManager = new PopupManager();
function usePopupManager(type, {
  visible,
  runOnMounted
} = {}) {
  const zIndex = ref(0);
  const open2 = () => {
    zIndex.value = popupManager.add(type);
  };
  const close = () => {
    popupManager.delete(zIndex.value, type);
  };
  const isLastDialog = () => {
    if (type === "dialog") {
      return popupManager.isLastDialog(zIndex.value);
    }
    return false;
  };
  watch(
    () => visible == null ? void 0 : visible.value,
    (visible2) => {
      if (visible2) {
        open2();
      } else {
        close();
      }
    },
    {
      immediate: true
    }
  );
  if (runOnMounted) {
    onMounted(() => {
      open2();
    });
    onBeforeUnmount(() => {
      close();
    });
  }
  return {
    zIndex: readonly(zIndex),
    open: open2,
    close,
    isLastDialog
  };
}
const useResizeObserver = ({
  elementRef,
  onResize
}) => {
  let resizeObserver;
  const createResizeObserver = () => {
    if (!elementRef.value)
      return;
    resizeObserver = new index((entries) => {
      const entry = entries[0];
      isFunction(onResize) && onResize(entry);
    });
    resizeObserver.observe(elementRef.value);
  };
  const destroyResizeObserver = () => {
    if (resizeObserver) {
      resizeObserver.disconnect();
      resizeObserver = null;
    }
  };
  return {
    createResizeObserver,
    destroyResizeObserver
  };
};
var ClientOnly = defineComponent({
  name: "ClientOnly",
  setup(_, {
    slots
  }) {
    const mounted = ref(false);
    onMounted(() => mounted.value = true);
    return () => {
      var _a;
      if (mounted.value) {
        return (_a = slots.default) == null ? void 0 : _a.call(slots);
      }
      return null;
    };
  }
});
const useTeleportContainer = ({
  popupContainer,
  visible,
  defaultContainer = "body",
  documentContainer
}) => {
  const teleportContainer = ref(popupContainer.value);
  const containerRef = ref();
  const getContainer = () => {
    const element = getElement(popupContainer.value);
    const _teleportContainer = element ? popupContainer.value : defaultContainer;
    const _containerElement = element != null ? element : documentContainer ? document.documentElement : getElement(defaultContainer);
    if (_teleportContainer !== teleportContainer.value) {
      teleportContainer.value = _teleportContainer;
    }
    if (_containerElement !== containerRef.value) {
      containerRef.value = _containerElement;
    }
  };
  onMounted(() => getContainer());
  watch(visible, (visible2) => {
    if (teleportContainer.value !== popupContainer.value && visible2) {
      getContainer();
    }
  });
  return {
    teleportContainer,
    containerRef
  };
};
const TRIGGER_EVENTS = ["onClick", "onMouseenter", "onMouseleave", "onFocusin", "onFocusout", "onContextmenu"];
var _Trigger = defineComponent({
  name: "Trigger",
  inheritAttrs: false,
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    trigger: {
      type: [String, Array],
      default: "hover"
    },
    position: {
      type: String,
      default: "bottom"
    },
    disabled: {
      type: Boolean,
      default: false
    },
    popupOffset: {
      type: Number,
      default: 0
    },
    popupTranslate: {
      type: [Array, Object]
    },
    showArrow: {
      type: Boolean,
      default: false
    },
    alignPoint: {
      type: Boolean,
      default: false
    },
    popupHoverStay: {
      type: Boolean,
      default: true
    },
    blurToClose: {
      type: Boolean,
      default: true
    },
    clickToClose: {
      type: Boolean,
      default: true
    },
    clickOutsideToClose: {
      type: Boolean,
      default: true
    },
    unmountOnClose: {
      type: Boolean,
      default: true
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupStyle: {
      type: Object
    },
    animationName: {
      type: String,
      default: "fade-in"
    },
    duration: {
      type: [Number, Object]
    },
    mouseEnterDelay: {
      type: Number,
      default: 100
    },
    mouseLeaveDelay: {
      type: Number,
      default: 100
    },
    focusDelay: {
      type: Number,
      default: 0
    },
    autoFitPopupWidth: {
      type: Boolean,
      default: false
    },
    autoFitPopupMinWidth: {
      type: Boolean,
      default: false
    },
    autoFixPosition: {
      type: Boolean,
      default: true
    },
    popupContainer: {
      type: [String, Object]
    },
    updateAtScroll: {
      type: Boolean,
      default: false
    },
    autoFitTransformOrigin: {
      type: Boolean,
      default: false
    },
    hideEmpty: {
      type: Boolean,
      default: false
    },
    openedClass: {
      type: [String, Array, Object]
    },
    autoFitPosition: {
      type: Boolean,
      default: true
    },
    renderToBody: {
      type: Boolean,
      default: true
    },
    preventFocus: {
      type: Boolean,
      default: false
    },
    scrollToClose: {
      type: Boolean,
      default: false
    },
    scrollToCloseDistance: {
      type: Number,
      default: 0
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true,
    "show": () => true,
    "hide": () => true,
    "resize": () => true
  },
  setup(props, {
    emit,
    slots,
    attrs
  }) {
    const {
      popupContainer
    } = toRefs(props);
    const prefixCls = getPrefixCls("trigger");
    const popupAttrs = computed(() => omit(attrs, TRIGGER_EVENTS));
    const configCtx = inject(configProviderInjectionKey, void 0);
    const triggerMethods = computed(() => [].concat(props.trigger));
    const childrenRefs = /* @__PURE__ */ new Set();
    const triggerCtx = inject(triggerInjectionKey, void 0);
    const {
      children,
      firstElement
    } = useFirstElement();
    const popupRef = ref();
    const popupVisible = ref(props.defaultPopupVisible);
    const popupPosition = ref(props.position);
    const popupStyle = ref({});
    const transformStyle = ref({});
    const arrowStyle = ref({});
    const arrowRef = ref();
    const mousePosition = ref({
      top: 0,
      left: 0
    });
    let scrollPosition = null;
    let windowScrollPosition = null;
    const computedVisible = computed(() => {
      var _a;
      return (_a = props.popupVisible) != null ? _a : popupVisible.value;
    });
    const {
      teleportContainer,
      containerRef
    } = useTeleportContainer({
      popupContainer,
      visible: computedVisible,
      documentContainer: true
    });
    const {
      zIndex
    } = usePopupManager("popup", {
      visible: computedVisible
    });
    let delayTimer = 0;
    let outsideListener = false;
    let windowListener = false;
    const cleanDelayTimer = () => {
      if (delayTimer) {
        window.clearTimeout(delayTimer);
        delayTimer = 0;
      }
    };
    const updateMousePosition = (e) => {
      if (props.alignPoint) {
        const {
          pageX,
          pageY
        } = e;
        mousePosition.value = {
          top: pageY,
          left: pageX
        };
      }
    };
    const updatePopupStyle = () => {
      if (!firstElement.value || !popupRef.value || !containerRef.value) {
        return;
      }
      const containerRect = containerRef.value.getBoundingClientRect();
      const triggerRect = props.alignPoint ? {
        top: mousePosition.value.top,
        bottom: mousePosition.value.top,
        left: mousePosition.value.left,
        right: mousePosition.value.left,
        scrollTop: mousePosition.value.top,
        scrollBottom: mousePosition.value.top,
        scrollLeft: mousePosition.value.left,
        scrollRight: mousePosition.value.left,
        width: 0,
        height: 0
      } : getElementScrollRect(firstElement.value, containerRect);
      const getPopupRect = () => getElementScrollRect(popupRef.value, containerRect);
      const popupRect = getPopupRect();
      const {
        style,
        position
      } = getPopupStyle(props.position, containerRect, triggerRect, popupRect, {
        offset: props.popupOffset,
        translate: props.popupTranslate,
        customStyle: props.popupStyle,
        autoFitPosition: props.autoFitPosition
      });
      if (props.autoFitTransformOrigin) {
        transformStyle.value = {
          transformOrigin: getTransformOrigin(position)
        };
      }
      if (props.autoFitPopupMinWidth) {
        style.minWidth = `${triggerRect.width}px`;
      } else if (props.autoFitPopupWidth) {
        style.width = `${triggerRect.width}px`;
      }
      if (popupPosition.value !== position) {
        popupPosition.value = position;
      }
      popupStyle.value = style;
      if (props.showArrow) {
        nextTick(() => {
          arrowStyle.value = getArrowStyle(position, triggerRect, getPopupRect(), {
            customStyle: props.arrowStyle
          });
        });
      }
    };
    const changeVisible = (visible, delay) => {
      if (visible === computedVisible.value && delayTimer === 0) {
        return;
      }
      const update = () => {
        popupVisible.value = visible;
        emit("update:popupVisible", visible);
        emit("popupVisibleChange", visible);
        if (visible) {
          nextTick(() => {
            updatePopupStyle();
          });
        }
      };
      if (!visible) {
        scrollPosition = null;
        windowScrollPosition = null;
      }
      if (delay) {
        cleanDelayTimer();
        if (visible !== computedVisible.value) {
          delayTimer = window.setTimeout(update, delay);
        }
      } else {
        update();
      }
    };
    const handleClick = (e) => {
      var _a;
      (_a = attrs.onClick) == null ? void 0 : _a.call(attrs, e);
      if (props.disabled || computedVisible.value && !props.clickToClose) {
        return;
      }
      if (triggerMethods.value.includes("click")) {
        updateMousePosition(e);
        changeVisible(!computedVisible.value);
      } else if (triggerMethods.value.includes("contextMenu") && computedVisible.value) {
        changeVisible(false);
      }
    };
    const handleMouseEnter = (e) => {
      var _a;
      (_a = attrs.onMouseenter) == null ? void 0 : _a.call(attrs, e);
      if (props.disabled || !triggerMethods.value.includes("hover")) {
        return;
      }
      updateMousePosition(e);
      changeVisible(true, props.mouseEnterDelay);
    };
    const handleMouseEnterWithContext = (e) => {
      triggerCtx == null ? void 0 : triggerCtx.onMouseenter(e);
      handleMouseEnter(e);
    };
    const handleMouseLeave = (e) => {
      var _a;
      (_a = attrs.onMouseleave) == null ? void 0 : _a.call(attrs, e);
      if (props.disabled || !triggerMethods.value.includes("hover")) {
        return;
      }
      changeVisible(false, props.mouseLeaveDelay);
    };
    const handleMouseLeaveWithContext = (e) => {
      triggerCtx == null ? void 0 : triggerCtx.onMouseleave(e);
      handleMouseLeave(e);
    };
    const handleFocusin = (e) => {
      var _a;
      (_a = attrs.onFocusin) == null ? void 0 : _a.call(attrs, e);
      if (props.disabled || !triggerMethods.value.includes("focus")) {
        return;
      }
      changeVisible(true, props.focusDelay);
    };
    const handleFocusout = (e) => {
      var _a;
      (_a = attrs.onFocusout) == null ? void 0 : _a.call(attrs, e);
      if (props.disabled || !triggerMethods.value.includes("focus")) {
        return;
      }
      if (!props.blurToClose) {
        return;
      }
      changeVisible(false);
    };
    const handleContextmenu = (e) => {
      var _a;
      (_a = attrs.onContextmenu) == null ? void 0 : _a.call(attrs, e);
      if (props.disabled || !triggerMethods.value.includes("contextMenu") || computedVisible.value && !props.clickToClose) {
        return;
      }
      updateMousePosition(e);
      changeVisible(!computedVisible.value);
      e.preventDefault();
    };
    const addChildRef = (ref2) => {
      childrenRefs.add(ref2);
      triggerCtx == null ? void 0 : triggerCtx.addChildRef(ref2);
    };
    const removeChildRef = (ref2) => {
      childrenRefs.delete(ref2);
      triggerCtx == null ? void 0 : triggerCtx.removeChildRef(ref2);
    };
    provide(triggerInjectionKey, reactive({
      onMouseenter: handleMouseEnterWithContext,
      onMouseleave: handleMouseLeaveWithContext,
      addChildRef,
      removeChildRef
    }));
    const removeOutsideListener = () => {
      off(document.documentElement, "mousedown", handleOutsideClick);
      outsideListener = false;
    };
    const contentSlot = usePickSlots(slots, "content");
    const hidePopup = computed(() => {
      var _a;
      return props.hideEmpty && isEmptyChildren((_a = contentSlot.value) == null ? void 0 : _a.call(contentSlot));
    });
    const handleOutsideClick = (e) => {
      var _a, _b, _c;
      if (((_a = firstElement.value) == null ? void 0 : _a.contains(e.target)) || ((_b = popupRef.value) == null ? void 0 : _b.contains(e.target))) {
        return;
      }
      for (const item of childrenRefs) {
        if ((_c = item.value) == null ? void 0 : _c.contains(e.target)) {
          return;
        }
      }
      removeOutsideListener();
      changeVisible(false);
    };
    const isExceedThreshold = (oldPosition, element) => {
      const [scrollTop, scrollLeft] = oldPosition;
      const {
        scrollTop: newScrollTop,
        scrollLeft: newScrollLeft
      } = element;
      return Math.abs(newScrollTop - scrollTop) >= props.scrollToCloseDistance || Math.abs(newScrollLeft - scrollLeft) >= props.scrollToCloseDistance;
    };
    const handleScroll = throttleByRaf((e) => {
      if (computedVisible.value) {
        if (props.scrollToClose || (configCtx == null ? void 0 : configCtx.scrollToClose)) {
          const element = e.target;
          if (!scrollPosition) {
            scrollPosition = [element.scrollTop, element.scrollLeft];
          }
          if (isExceedThreshold(scrollPosition, element)) {
            changeVisible(false);
          } else {
            updatePopupStyle();
          }
        } else {
          updatePopupStyle();
        }
      }
    });
    const removeWindowScroll = () => {
      off(window, "scroll", onWindowScroll);
      windowListener = false;
    };
    const onWindowScroll = throttleByRaf((e) => {
      const element = e.target.documentElement;
      if (!windowScrollPosition) {
        windowScrollPosition = [element.scrollTop, element.scrollLeft];
      }
      if (isExceedThreshold(windowScrollPosition, element)) {
        changeVisible(false);
        removeWindowScroll();
      }
    });
    const handleResize = () => {
      if (computedVisible.value) {
        updatePopupStyle();
      }
    };
    const onTargetResize = () => {
      handleResize();
      emit("resize");
    };
    const handlePopupMouseDown = (e) => {
      if (props.preventFocus) {
        e.preventDefault();
      }
    };
    triggerCtx == null ? void 0 : triggerCtx.addChildRef(popupRef);
    const triggerCls = computed(() => {
      return computedVisible.value ? props.openedClass : void 0;
    });
    let scrollElements;
    watch(computedVisible, (value) => {
      if (props.clickOutsideToClose) {
        if (!value && outsideListener) {
          removeOutsideListener();
        } else if (value && !outsideListener) {
          on(document.documentElement, "mousedown", handleOutsideClick);
          outsideListener = true;
        }
      }
      if (props.scrollToClose || (configCtx == null ? void 0 : configCtx.scrollToClose)) {
        on(window, "scroll", onWindowScroll);
        windowListener = true;
      }
      if (props.updateAtScroll || (configCtx == null ? void 0 : configCtx.updateAtScroll)) {
        if (value) {
          scrollElements = getScrollElements(firstElement.value);
          for (const item of scrollElements) {
            item.addEventListener("scroll", handleScroll);
          }
        } else if (scrollElements) {
          for (const item of scrollElements) {
            item.removeEventListener("scroll", handleScroll);
          }
          scrollElements = void 0;
        }
      }
      if (value) {
        mounted.value = true;
      }
    });
    watch(() => [props.autoFitPopupWidth, props.autoFitPopupMinWidth], () => {
      if (computedVisible.value) {
        updatePopupStyle();
      }
    });
    const {
      createResizeObserver,
      destroyResizeObserver
    } = useResizeObserver({
      elementRef: containerRef,
      onResize: handleResize
    });
    onMounted(() => {
      createResizeObserver();
      if (computedVisible.value) {
        updatePopupStyle();
        if (props.clickOutsideToClose && !outsideListener) {
          on(document.documentElement, "mousedown", handleOutsideClick);
          outsideListener = true;
        }
        if (props.updateAtScroll || (configCtx == null ? void 0 : configCtx.updateAtScroll)) {
          scrollElements = getScrollElements(firstElement.value);
          for (const item of scrollElements) {
            item.addEventListener("scroll", handleScroll);
          }
        }
      }
    });
    onUpdated(() => {
      if (computedVisible.value) {
        updatePopupStyle();
      }
    });
    onDeactivated(() => {
      changeVisible(false);
    });
    onBeforeUnmount(() => {
      triggerCtx == null ? void 0 : triggerCtx.removeChildRef(popupRef);
      destroyResizeObserver();
      if (outsideListener) {
        removeOutsideListener();
      }
      if (windowListener) {
        removeWindowScroll();
      }
      if (scrollElements) {
        for (const item of scrollElements) {
          item.removeEventListener("scroll", handleScroll);
        }
        scrollElements = void 0;
      }
    });
    const mounted = ref(computedVisible.value);
    const isAnimation = ref(false);
    const onAnimationStart = () => {
      isAnimation.value = true;
    };
    const handleShow = () => {
      isAnimation.value = false;
      if (computedVisible.value) {
        emit("show");
      }
    };
    const handleHide = () => {
      isAnimation.value = false;
      if (!computedVisible.value) {
        mounted.value = false;
        emit("hide");
      }
    };
    return () => {
      var _a, _b;
      children.value = (_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _b : [];
      mergeFirstChild(children.value, {
        class: triggerCls.value,
        onClick: handleClick,
        onMouseenter: handleMouseEnter,
        onMouseleave: handleMouseLeave,
        onFocusin: handleFocusin,
        onFocusout: handleFocusout,
        onContextmenu: handleContextmenu
      });
      return createVNode(Fragment, null, [props.autoFixPosition ? createVNode(ResizeObserver, {
        "onResize": onTargetResize
      }, {
        default: () => [children.value]
      }) : children.value, createVNode(ClientOnly, null, {
        default: () => [createVNode(Teleport, {
          "to": teleportContainer.value,
          "disabled": !props.renderToBody
        }, {
          default: () => [(!props.unmountOnClose || computedVisible.value || mounted.value) && !hidePopup.value && createVNode(ResizeObserver, {
            "onResize": handleResize
          }, {
            default: () => [createVNode("div", mergeProps({
              "ref": popupRef,
              "class": [`${prefixCls}-popup`, `${prefixCls}-position-${popupPosition.value}`],
              "style": {
                ...popupStyle.value,
                zIndex: zIndex.value,
                pointerEvents: isAnimation.value ? "none" : "auto"
              },
              "trigger-placement": popupPosition.value,
              "onMouseenter": handleMouseEnterWithContext,
              "onMouseleave": handleMouseLeaveWithContext,
              "onMousedown": handlePopupMouseDown
            }, popupAttrs.value), [createVNode(Transition, {
              "name": props.animationName,
              "duration": props.duration,
              "appear": true,
              "onBeforeEnter": onAnimationStart,
              "onAfterEnter": handleShow,
              "onBeforeLeave": onAnimationStart,
              "onAfterLeave": handleHide
            }, {
              default: () => {
                var _a2;
                return [withDirectives(createVNode("div", {
                  "class": `${prefixCls}-popup-wrapper`,
                  "style": transformStyle.value
                }, [createVNode("div", {
                  "class": [`${prefixCls}-content`, props.contentClass],
                  "style": props.contentStyle
                }, [(_a2 = slots.content) == null ? void 0 : _a2.call(slots)]), props.showArrow && createVNode("div", {
                  "ref": arrowRef,
                  "class": [`${prefixCls}-arrow`, props.arrowClass],
                  "style": arrowStyle.value
                }, null)]), [[vShow, computedVisible.value]])];
              }
            })])]
          })]
        })]
      })]);
    };
  }
});
const Trigger = Object.assign(_Trigger, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Trigger.name, _Trigger);
  }
});
const _sfc_main$6h = defineComponent({
  name: "IconEmpty",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-empty`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4I = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6g(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M24 5v6m7 1 4-4m-18 4-4-4m28.5 22H28s-1 3-4 3-4-3-4-3H6.5M40 41H8a2 2 0 0 1-2-2v-8.46a2 2 0 0 1 .272-1.007l6.15-10.54A2 2 0 0 1 14.148 18H33.85a2 2 0 0 1 1.728.992l6.149 10.541A2 2 0 0 1 42 30.541V39a2 2 0 0 1-2 2Z" }, null, -1)
  ]), 14, _hoisted_1$4I);
}
var _IconEmpty = /* @__PURE__ */ _export_sfc(_sfc_main$6h, [["render", _sfc_render$6g]]);
const IconEmpty = Object.assign(_IconEmpty, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconEmpty.name, _IconEmpty);
  }
});
var Empty$1 = defineComponent({
  name: "Empty",
  inheritAttrs: false,
  props: {
    description: String,
    imgSrc: String,
    inConfigProvider: {
      type: Boolean,
      default: false
    }
  },
  setup(props, {
    slots,
    attrs
  }) {
    const prefixCls = getPrefixCls("empty");
    const {
      t
    } = useI18n();
    const configCtx = inject(configProviderInjectionKey, void 0);
    return () => {
      var _a, _b, _c, _d;
      if (!props.inConfigProvider && (configCtx == null ? void 0 : configCtx.slots.empty) && !(slots.image || props.imgSrc || props.description)) {
        return configCtx.slots.empty({
          component: "empty"
        });
      }
      return createVNode("div", mergeProps({
        "class": prefixCls
      }, attrs), [createVNode("div", {
        "class": `${prefixCls}-image`
      }, [(_b = (_a = slots.image) == null ? void 0 : _a.call(slots)) != null ? _b : props.imgSrc ? createVNode("img", {
        "src": props.imgSrc,
        "alt": props.description || "empty"
      }, null) : createVNode(IconEmpty, null, null)]), createVNode("div", {
        "class": `${prefixCls}-description`
      }, [(_d = (_c = slots.default) == null ? void 0 : _c.call(slots)) != null ? _d : props.description || t("empty.description")])]);
    };
  }
});
const Empty = Object.assign(Empty$1, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + Empty$1.name, Empty$1);
  }
});
const DOT_NUMBER = 5;
var DotLoading = defineComponent({
  name: "DotLoading",
  props: {
    size: {
      type: Number
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("dot-loading");
    return () => {
      const style = props.size ? {
        width: `${props.size}px`,
        height: `${props.size}px`
      } : {};
      return createVNode("div", {
        "class": prefixCls,
        "style": {
          width: props.size ? `${props.size * 7}px` : void 0,
          height: props.size ? `${props.size}px` : void 0
        }
      }, [Array(DOT_NUMBER).fill(1).map((_, index2) => createVNode("div", {
        "class": `${prefixCls}-item`,
        "key": index2,
        "style": style
      }, null))]);
    };
  }
});
var _Spin = defineComponent({
  name: "Spin",
  props: {
    size: {
      type: Number
    },
    loading: Boolean,
    dot: Boolean,
    tip: String,
    hideIcon: {
      type: Boolean,
      default: false
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("spin");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-loading`]: props.loading,
      [`${prefixCls}-with-tip`]: props.tip && !slots.default
    }]);
    const renderIcon = () => {
      if (slots.icon) {
        const iconVNode = getFirstComponent(slots.icon());
        if (iconVNode) {
          return cloneVNode(iconVNode, {
            spin: true
          });
        }
      }
      if (slots.element) {
        return slots.element();
      }
      if (props.dot) {
        return createVNode(DotLoading, {
          "size": props.size
        }, null);
      }
      if (configCtx == null ? void 0 : configCtx.slots.loading) {
        return configCtx.slots.loading();
      }
      return createVNode(IconLoading, {
        "spin": true,
        "size": props.size
      }, null);
    };
    const renderSpinIcon = () => {
      var _a, _b, _c;
      const style = props.size ? {
        fontSize: `${props.size}px`
      } : void 0;
      const hasTip = Boolean((_a = slots.tip) != null ? _a : props.tip);
      return createVNode(Fragment, null, [!props.hideIcon && createVNode("div", {
        "class": `${prefixCls}-icon`,
        "style": style
      }, [renderIcon()]), hasTip && createVNode("div", {
        "class": `${prefixCls}-tip`
      }, [(_c = (_b = slots.tip) == null ? void 0 : _b.call(slots)) != null ? _c : props.tip])]);
    };
    return () => createVNode("div", {
      "class": cls.value
    }, [slots.default ? createVNode(Fragment, null, [slots.default(), props.loading && createVNode("div", {
      "class": `${prefixCls}-mask`
    }, [createVNode("div", {
      "class": `${prefixCls}-mask-icon`
    }, [renderSpinIcon()])])]) : renderSpinIcon()]);
  }
});
const Spin = Object.assign(_Spin, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Spin.name, _Spin);
  }
});
const _sfc_main$6g = defineComponent({
  name: "Thumb",
  props: {
    data: {
      type: Object
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    alwaysShow: {
      type: Boolean,
      default: false
    },
    both: {
      type: Boolean,
      default: false
    }
  },
  emits: ["scroll"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("scrollbar");
    const visible = ref(false);
    const trackRef = ref();
    const thumbRef = ref();
    const thumbMap = computed(() => {
      if (props.direction === "horizontal") {
        return {
          size: "width",
          direction: "left",
          offset: "offsetWidth",
          client: "clientX"
        };
      }
      return {
        size: "height",
        direction: "top",
        offset: "offsetHeight",
        client: "clientY"
      };
    });
    const offset = ref(0);
    const isDragging = ref(false);
    const mouseOffset = ref(0);
    const thumbStyle = computed(() => {
      var _a, _b;
      return {
        [thumbMap.value.size]: `${(_b = (_a = props.data) == null ? void 0 : _a.thumbSize) != null ? _b : 0}px`,
        [thumbMap.value.direction]: `${offset.value}px`
      };
    });
    const handleThumbMouseDown = (ev) => {
      ev.preventDefault();
      if (thumbRef.value) {
        mouseOffset.value = ev[thumbMap.value.client] - thumbRef.value.getBoundingClientRect()[thumbMap.value.direction];
        isDragging.value = true;
        on(window, "mousemove", handleMouseMove);
        on(window, "mouseup", handleMouseUp);
        on(window, "contextmenu", handleMouseUp);
      }
    };
    const handleTrackClick = (ev) => {
      var _a, _b, _c, _d;
      ev.preventDefault();
      if (thumbRef.value) {
        const _offset = getLegalOffset(
          ev[thumbMap.value.client] > thumbRef.value.getBoundingClientRect()[thumbMap.value.direction] ? offset.value + ((_b = (_a = props.data) == null ? void 0 : _a.thumbSize) != null ? _b : 0) : offset.value - ((_d = (_c = props.data) == null ? void 0 : _c.thumbSize) != null ? _d : 0)
        );
        if (_offset !== offset.value) {
          offset.value = _offset;
          emit("scroll", _offset);
        }
      }
    };
    const getLegalOffset = (offset2) => {
      if (offset2 < 0) {
        return 0;
      }
      if (props.data && offset2 > props.data.max) {
        return props.data.max;
      }
      return offset2;
    };
    const handleMouseMove = (ev) => {
      if (trackRef.value && thumbRef.value) {
        const _offset = getLegalOffset(
          ev[thumbMap.value.client] - trackRef.value.getBoundingClientRect()[thumbMap.value.direction] - mouseOffset.value
        );
        if (_offset !== offset.value) {
          offset.value = _offset;
          emit("scroll", _offset);
        }
      }
    };
    const handleMouseUp = () => {
      isDragging.value = false;
      off(window, "mousemove", handleMouseMove);
      off(window, "mouseup", handleMouseUp);
    };
    const setOffset = (_offset) => {
      if (!isDragging.value) {
        _offset = getLegalOffset(_offset);
        if (_offset !== offset.value) {
          offset.value = _offset;
        }
      }
    };
    const thumbCls = computed(() => [
      `${prefixCls}-thumb`,
      `${prefixCls}-thumb-direction-${props.direction}`,
      {
        [`${prefixCls}-thumb-dragging`]: isDragging.value
      }
    ]);
    return {
      visible,
      trackRef,
      thumbRef,
      prefixCls,
      thumbCls,
      thumbStyle,
      handleThumbMouseDown,
      handleTrackClick,
      setOffset
    };
  }
});
function _sfc_render$6f(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, null, {
    default: withCtx(() => [
      createBaseVNode("div", {
        ref: "trackRef",
        class: normalizeClass([
          `${_ctx.prefixCls}-track`,
          `${_ctx.prefixCls}-track-direction-${_ctx.direction}`
        ]),
        onMousedown: _cache[1] || (_cache[1] = withModifiers((...args) => _ctx.handleTrackClick && _ctx.handleTrackClick(...args), ["self"]))
      }, [
        createBaseVNode("div", {
          ref: "thumbRef",
          class: normalizeClass(_ctx.thumbCls),
          style: normalizeStyle(_ctx.thumbStyle),
          onMousedown: _cache[0] || (_cache[0] = (...args) => _ctx.handleThumbMouseDown && _ctx.handleThumbMouseDown(...args))
        }, [
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-thumb-bar`)
          }, null, 2)
        ], 38)
      ], 34)
    ]),
    _: 1
  });
}
var Thumb = /* @__PURE__ */ _export_sfc(_sfc_main$6g, [["render", _sfc_render$6f]]);
const THUMB_MIN_SIZE = 20;
const TRACK_SIZE = 15;
const _sfc_main$6f = defineComponent({
  name: "Scrollbar",
  components: {
    ResizeObserver,
    Thumb
  },
  inheritAttrs: false,
  props: {
    type: {
      type: String,
      default: "embed"
    },
    outerClass: [String, Object, Array],
    outerStyle: {
      type: [String, Object, Array]
    },
    hide: {
      type: Boolean,
      default: false
    },
    disableHorizontal: {
      type: Boolean,
      default: false
    },
    disableVertical: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    scroll: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("scrollbar");
    const containerRef = ref();
    const horizontalData = ref();
    const verticalData = ref();
    const horizontalThumbRef = ref();
    const verticalThumbRef = ref();
    const _hasHorizontalScrollbar = ref(false);
    const _hasVerticalScrollbar = ref(false);
    const hasHorizontalScrollbar = computed(
      () => _hasHorizontalScrollbar.value && !props.disableHorizontal
    );
    const hasVerticalScrollbar = computed(
      () => _hasVerticalScrollbar.value && !props.disableVertical
    );
    const isBoth = ref(false);
    const getContainerSize = () => {
      var _a, _b, _c, _d, _e, _f;
      if (containerRef.value) {
        const {
          clientWidth,
          clientHeight,
          offsetWidth,
          offsetHeight,
          scrollWidth,
          scrollHeight,
          scrollTop,
          scrollLeft
        } = containerRef.value;
        _hasHorizontalScrollbar.value = scrollWidth > clientWidth;
        _hasVerticalScrollbar.value = scrollHeight > clientHeight;
        isBoth.value = hasHorizontalScrollbar.value && hasVerticalScrollbar.value;
        const horizontalTrackWidth = props.type === "embed" && isBoth.value ? offsetWidth - TRACK_SIZE : offsetWidth;
        const verticalTrackHeight = props.type === "embed" && isBoth.value ? offsetHeight - TRACK_SIZE : offsetHeight;
        const horizontalThumbWidth = Math.round(
          horizontalTrackWidth / Math.min(
            scrollWidth / clientWidth,
            horizontalTrackWidth / THUMB_MIN_SIZE
          )
        );
        const maxHorizontalOffset = horizontalTrackWidth - horizontalThumbWidth;
        const horizontalRatio = (scrollWidth - clientWidth) / maxHorizontalOffset;
        const verticalThumbHeight = Math.round(
          verticalTrackHeight / Math.min(
            scrollHeight / clientHeight,
            verticalTrackHeight / THUMB_MIN_SIZE
          )
        );
        const maxVerticalOffset = verticalTrackHeight - verticalThumbHeight;
        const verticalRatio = (scrollHeight - clientHeight) / maxVerticalOffset;
        horizontalData.value = {
          ratio: horizontalRatio,
          thumbSize: horizontalThumbWidth,
          max: maxHorizontalOffset
        };
        verticalData.value = {
          ratio: verticalRatio,
          thumbSize: verticalThumbHeight,
          max: maxVerticalOffset
        };
        if (scrollTop > 0) {
          const verticalOffset = Math.round(
            scrollTop / ((_b = (_a = verticalData.value) == null ? void 0 : _a.ratio) != null ? _b : 1)
          );
          (_c = verticalThumbRef.value) == null ? void 0 : _c.setOffset(verticalOffset);
        }
        if (scrollLeft > 0) {
          const horizontalOffset = Math.round(
            scrollLeft / ((_e = (_d = verticalData.value) == null ? void 0 : _d.ratio) != null ? _e : 1)
          );
          (_f = horizontalThumbRef.value) == null ? void 0 : _f.setOffset(horizontalOffset);
        }
      }
    };
    onMounted(() => {
      getContainerSize();
    });
    const handleResize = () => {
      getContainerSize();
    };
    const handleScroll = (ev) => {
      var _a, _b, _c, _d, _e, _f;
      if (containerRef.value) {
        if (hasHorizontalScrollbar.value && !props.disableHorizontal) {
          const horizontalOffset = Math.round(
            containerRef.value.scrollLeft / ((_b = (_a = horizontalData.value) == null ? void 0 : _a.ratio) != null ? _b : 1)
          );
          (_c = horizontalThumbRef.value) == null ? void 0 : _c.setOffset(horizontalOffset);
        }
        if (hasVerticalScrollbar.value && !props.disableVertical) {
          const verticalOffset = Math.round(
            containerRef.value.scrollTop / ((_e = (_d = verticalData.value) == null ? void 0 : _d.ratio) != null ? _e : 1)
          );
          (_f = verticalThumbRef.value) == null ? void 0 : _f.setOffset(verticalOffset);
        }
      }
      emit("scroll", ev);
    };
    const handleHorizontalScroll = (offset) => {
      var _a, _b;
      if (containerRef.value) {
        containerRef.value.scrollTo({
          left: offset * ((_b = (_a = horizontalData.value) == null ? void 0 : _a.ratio) != null ? _b : 1)
        });
      }
    };
    const handleVerticalScroll = (offset) => {
      var _a, _b;
      if (containerRef.value) {
        containerRef.value.scrollTo({
          top: offset * ((_b = (_a = verticalData.value) == null ? void 0 : _a.ratio) != null ? _b : 1)
        });
      }
    };
    const style = computed(() => {
      const style2 = {};
      if (props.type === "track") {
        if (hasHorizontalScrollbar.value) {
          style2.paddingBottom = `${TRACK_SIZE}px`;
        }
        if (hasVerticalScrollbar.value) {
          style2.paddingRight = `${TRACK_SIZE}px`;
        }
      }
      return [style2, props.outerStyle];
    });
    const cls = computed(() => [
      `${prefixCls}`,
      `${prefixCls}-type-${props.type}`,
      {
        [`${prefixCls}-both`]: isBoth.value
      },
      props.outerClass
    ]);
    return {
      prefixCls,
      cls,
      style,
      containerRef,
      horizontalThumbRef,
      verticalThumbRef,
      horizontalData,
      verticalData,
      isBoth,
      hasHorizontalScrollbar,
      hasVerticalScrollbar,
      handleResize,
      handleScroll,
      handleHorizontalScroll,
      handleVerticalScroll
    };
  },
  methods: {
    scrollTo(options, y) {
      var _a, _b;
      if (isObject(options)) {
        (_a = this.$refs.containerRef) == null ? void 0 : _a.scrollTo(options);
      } else if (options || y) {
        (_b = this.$refs.containerRef) == null ? void 0 : _b.scrollTo(
          options,
          y
        );
      }
    },
    scrollTop(top) {
      var _a;
      (_a = this.$refs.containerRef) == null ? void 0 : _a.scrollTo({
        top
      });
    },
    scrollLeft(left) {
      var _a;
      (_a = this.$refs.containerRef) == null ? void 0 : _a.scrollTo({
        left
      });
    }
  }
});
function _sfc_render$6e(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  const _component_thumb = resolveComponent("thumb");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.style)
  }, [
    createVNode(_component_ResizeObserver, { onResize: _ctx.handleResize }, {
      default: withCtx(() => [
        createBaseVNode("div", mergeProps({
          ref: "containerRef",
          class: `${_ctx.prefixCls}-container`
        }, _ctx.$attrs, {
          onScroll: _cache[0] || (_cache[0] = (...args) => _ctx.handleScroll && _ctx.handleScroll(...args))
        }), [
          createVNode(_component_ResizeObserver, { onResize: _ctx.handleResize }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 8, ["onResize"])
        ], 16)
      ]),
      _: 3
    }, 8, ["onResize"]),
    !_ctx.hide && _ctx.hasHorizontalScrollbar ? (openBlock(), createBlock(_component_thumb, {
      key: 0,
      ref: "horizontalThumbRef",
      data: _ctx.horizontalData,
      direction: "horizontal",
      both: _ctx.isBoth,
      onScroll: _ctx.handleHorizontalScroll
    }, null, 8, ["data", "both", "onScroll"])) : createCommentVNode("v-if", true),
    !_ctx.hide && _ctx.hasVerticalScrollbar ? (openBlock(), createBlock(_component_thumb, {
      key: 1,
      ref: "verticalThumbRef",
      data: _ctx.verticalData,
      direction: "vertical",
      both: _ctx.isBoth,
      onScroll: _ctx.handleVerticalScroll
    }, null, 8, ["data", "both", "onScroll"])) : createCommentVNode("v-if", true)
  ], 6);
}
var _Scrollbar = /* @__PURE__ */ _export_sfc(_sfc_main$6f, [["render", _sfc_render$6e]]);
const Scrollbar = Object.assign(_Scrollbar, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Scrollbar.name, _Scrollbar);
  }
});
const useComponentRef = (name) => {
  const componentRef = ref();
  const getElement2 = () => {
    if (isComponentInstance(componentRef.value)) {
      return componentRef.value.$refs[name];
    }
    return componentRef.value;
  };
  const elementRef = ref();
  onMounted(() => {
    elementRef.value = getElement2();
  });
  watch([componentRef], () => {
    elementRef.value = getElement2();
  });
  return {
    componentRef,
    elementRef
  };
};
const useScrollbar = (scrollbar) => {
  const displayScrollbar = computed(() => Boolean(scrollbar.value));
  const scrollbarProps = computed(() => {
    if (!scrollbar.value)
      return void 0;
    return {
      type: "embed",
      ...isBoolean(scrollbar.value) ? void 0 : scrollbar.value
    };
  });
  return {
    displayScrollbar,
    scrollbarProps
  };
};
const _sfc_main$6e = defineComponent({
  name: "SelectDropdown",
  components: {
    ScrollbarComponent: Scrollbar,
    Empty,
    Spin
  },
  props: {
    loading: Boolean,
    empty: Boolean,
    virtualList: Boolean,
    bottomOffset: {
      type: Number,
      default: 0
    },
    scrollbar: {
      type: [Boolean, Object],
      default: true
    },
    onScroll: {
      type: [Function, Array]
    },
    onReachBottom: {
      type: [Function, Array]
    },
    showHeaderOnEmpty: {
      type: Boolean,
      default: false
    },
    showFooterOnEmpty: {
      type: Boolean,
      default: false
    }
  },
  emits: ["scroll", "reachBottom"],
  setup(props, { emit, slots }) {
    var _a, _b, _c;
    const { scrollbar } = toRefs(props);
    const prefixCls = getPrefixCls("select-dropdown");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const SelectEmpty = (_c = (_b = configCtx == null ? void 0 : (_a = configCtx.slots).empty) == null ? void 0 : _b.call(_a, { component: "select" })) == null ? void 0 : _c[0];
    const { componentRef: wrapperComRef, elementRef: wrapperRef } = useComponentRef("containerRef");
    const { displayScrollbar, scrollbarProps } = useScrollbar(scrollbar);
    const handleScroll = (e) => {
      const { scrollTop, scrollHeight, offsetHeight } = e.target;
      const bottom = scrollHeight - (scrollTop + offsetHeight);
      if (bottom <= props.bottomOffset) {
        emit("reachBottom", e);
      }
      emit("scroll", e);
    };
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-has-header`]: Boolean(slots.header),
        [`${prefixCls}-has-footer`]: Boolean(slots.footer)
      }
    ]);
    return {
      prefixCls,
      SelectEmpty,
      cls,
      wrapperRef,
      wrapperComRef,
      handleScroll,
      displayScrollbar,
      scrollbarProps
    };
  }
});
function _sfc_render$6d(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_spin = resolveComponent("spin");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    _ctx.$slots.header && (!_ctx.empty || _ctx.showHeaderOnEmpty) ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-header`)
    }, [
      renderSlot(_ctx.$slots, "header")
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.loading ? (openBlock(), createBlock(_component_spin, {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-loading`)
    }, null, 8, ["class"])) : _ctx.empty ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(`${_ctx.prefixCls}-empty`)
    }, [
      renderSlot(_ctx.$slots, "empty", {}, () => [
        (openBlock(), createBlock(resolveDynamicComponent(_ctx.SelectEmpty ? _ctx.SelectEmpty : "Empty")))
      ])
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.virtualList && !_ctx.loading && !_ctx.empty ? renderSlot(_ctx.$slots, "virtual-list", { key: 3 }) : createCommentVNode("v-if", true),
    !_ctx.virtualList ? withDirectives((openBlock(), createBlock(resolveDynamicComponent(_ctx.displayScrollbar ? "ScrollbarComponent" : "div"), mergeProps({
      key: 4,
      ref: "wrapperComRef",
      class: `${_ctx.prefixCls}-list-wrapper`
    }, _ctx.scrollbarProps, { onScroll: _ctx.handleScroll }), {
      default: withCtx(() => [
        createBaseVNode("ul", {
          class: normalizeClass(`${_ctx.prefixCls}-list`)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ]),
      _: 3
    }, 16, ["class", "onScroll"])), [
      [vShow, !_ctx.loading && !_ctx.empty]
    ]) : createCommentVNode("v-if", true),
    _ctx.$slots.footer && (!_ctx.empty || _ctx.showFooterOnEmpty) ? (openBlock(), createElementBlock("div", {
      key: 5,
      class: normalizeClass(`${_ctx.prefixCls}-footer`)
    }, [
      renderSlot(_ctx.$slots, "footer")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var SelectDropdown = /* @__PURE__ */ _export_sfc(_sfc_main$6e, [["render", _sfc_render$6d]]);
var IconCheck$1 = defineComponent({
  name: "IconCheck",
  render() {
    return createVNode("svg", {
      "aria-hidden": "true",
      "focusable": "false",
      "viewBox": "0 0 1024 1024",
      "width": "200",
      "height": "200",
      "fill": "currentColor"
    }, [createVNode("path", {
      "d": "M877.44815445 206.10060629a64.72691371 64.72691371 0 0 0-95.14856334 4.01306852L380.73381888 685.46812814 235.22771741 533.48933518a64.72691371 64.72691371 0 0 0-92.43003222-1.03563036l-45.82665557 45.82665443a64.72691371 64.72691371 0 0 0-0.90617629 90.61767965l239.61903446 250.10479331a64.72691371 64.72691371 0 0 0 71.19960405 15.14609778 64.33855261 64.33855261 0 0 0 35.08198741-21.23042702l36.24707186-42.71976334 40.5190474-40.77795556-3.36579926-3.49525333 411.40426297-486.74638962a64.72691371 64.72691371 0 0 0-3.88361443-87.64024149l-45.3088404-45.43829334z",
      "p-id": "840"
    }, null)]);
  }
});
const checkboxGroupKey = Symbol("ArcoCheckboxGroup");
var _Checkbox = defineComponent({
  name: "Checkbox",
  components: {
    IconCheck: IconCheck$1,
    IconHover
  },
  props: {
    modelValue: {
      type: [Boolean, Array],
      default: void 0
    },
    defaultChecked: {
      type: Boolean,
      default: false
    },
    value: {
      type: [String, Number, Boolean]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    indeterminate: {
      type: Boolean,
      default: false
    },
    uninjectGroupContext: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      disabled,
      modelValue
    } = toRefs(props);
    const prefixCls = getPrefixCls("checkbox");
    const checkboxRef = ref();
    const checkboxGroupCtx = !props.uninjectGroupContext ? inject(checkboxGroupKey, void 0) : void 0;
    const isGroup = (checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.name) === "ArcoCheckboxGroup";
    const {
      mergedDisabled: _mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled
    });
    const _checked = ref(props.defaultChecked);
    const computedValue = computed(() => {
      var _a;
      return isGroup ? checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.computedValue : (_a = props.modelValue) != null ? _a : _checked.value;
    });
    const computedChecked = computed(() => {
      var _a;
      return isArray(computedValue.value) ? computedValue.value.includes((_a = props.value) != null ? _a : true) : computedValue.value;
    });
    const mergedDisabled = computed(() => (checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.disabled) || (_mergedDisabled == null ? void 0 : _mergedDisabled.value) || !computedChecked.value && (checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.isMaxed));
    const handleClick = (ev) => {
      ev.stopPropagation();
    };
    const handleChange = (e) => {
      var _a, _b, _c, _d;
      const {
        checked
      } = e.target;
      let newValue = checked;
      if (isArray(computedValue.value)) {
        const set = new Set(computedValue.value);
        if (checked) {
          set.add((_a = props.value) != null ? _a : true);
        } else {
          set.delete((_b = props.value) != null ? _b : true);
        }
        newValue = Array.from(set);
      }
      _checked.value = checked;
      if (isGroup && isArray(newValue)) {
        checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.handleChange(newValue, e);
      } else {
        emit("update:modelValue", newValue);
        emit("change", newValue, e);
        (_d = (_c = eventHandlers.value) == null ? void 0 : _c.onChange) == null ? void 0 : _d.call(_c, e);
      }
      nextTick(() => {
        if (checkboxRef.value && checkboxRef.value.checked !== computedChecked.value) {
          checkboxRef.value.checked = computedChecked.value;
        }
      });
    };
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-checked`]: computedChecked.value,
      [`${prefixCls}-indeterminate`]: props.indeterminate,
      [`${prefixCls}-disabled`]: mergedDisabled.value
    }]);
    const handleFocus = (ev) => {
      var _a, _b;
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onFocus) == null ? void 0 : _b.call(_a, ev);
    };
    const handleBlur = (ev) => {
      var _a, _b;
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a, ev);
    };
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _checked.value = false;
      }
    });
    watch(computedValue, (value) => {
      var _a;
      let checked;
      if (isArray(value)) {
        checked = value.includes((_a = props.value) != null ? _a : true);
      } else {
        checked = value;
      }
      if (_checked.value !== checked) {
        _checked.value = checked;
      }
      if (checkboxRef.value && checkboxRef.value.checked !== checked) {
        checkboxRef.value.checked = checked;
      }
    });
    return () => {
      var _a, _b, _c, _d;
      return createVNode("label", {
        "aria-disabled": mergedDisabled.value,
        "class": cls.value
      }, [createVNode("input", {
        "ref": checkboxRef,
        "type": "checkbox",
        "checked": computedChecked.value,
        "value": props.value,
        "class": `${prefixCls}-target`,
        "disabled": mergedDisabled.value,
        "onClick": handleClick,
        "onChange": handleChange,
        "onFocus": handleFocus,
        "onBlur": handleBlur
      }, null), (_d = (_c = (_b = slots.checkbox) != null ? _b : (_a = checkboxGroupCtx == null ? void 0 : checkboxGroupCtx.slots) == null ? void 0 : _a.checkbox) == null ? void 0 : _c({
        checked: computedChecked.value,
        disabled: mergedDisabled.value
      })) != null ? _d : createVNode(IconHover, {
        "class": `${prefixCls}-icon-hover`,
        "disabled": mergedDisabled.value || computedChecked.value
      }, {
        default: () => [createVNode("div", {
          "class": `${prefixCls}-icon`
        }, [computedChecked.value && createVNode(IconCheck$1, {
          "class": `${prefixCls}-icon-check`
        }, null)])]
      }), slots.default && createVNode("span", {
        "class": `${prefixCls}-label`
      }, [slots.default()])]);
    };
  }
});
var CheckboxGroup = defineComponent({
  name: "CheckboxGroup",
  props: {
    modelValue: {
      type: Array,
      default: void 0
    },
    defaultValue: {
      type: Array,
      default: () => []
    },
    max: {
      type: Number
    },
    options: {
      type: Array
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      disabled
    } = toRefs(props);
    const prefixCls = getPrefixCls("checkbox-group");
    const {
      mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled
    });
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => isArray(props.modelValue) ? props.modelValue : _value.value);
    const isMaxed = computed(() => props.max === void 0 ? false : computedValue.value.length >= props.max);
    const options = computed(() => {
      var _a;
      return ((_a = props.options) != null ? _a : []).map((option) => {
        if (isString(option) || isNumber(option)) {
          return {
            label: option,
            value: option
          };
        }
        return option;
      });
    });
    const handleChange = (value, e) => {
      var _a, _b;
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value, e);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a, e);
    };
    provide(checkboxGroupKey, reactive({
      name: "ArcoCheckboxGroup",
      computedValue,
      disabled: mergedDisabled,
      isMaxed,
      slots,
      handleChange
    }));
    const cls = computed(() => [prefixCls, `${prefixCls}-direction-${props.direction}`]);
    watch(() => props.modelValue, (curValue) => {
      if (isArray(curValue)) {
        _value.value = [...curValue];
      } else {
        _value.value = [];
      }
    });
    const renderOptions = () => {
      return options.value.map((option) => {
        const checked = computedValue.value.includes(option.value);
        return createVNode(_Checkbox, {
          "key": option.value,
          "value": option.value,
          "disabled": option.disabled || !checked && isMaxed.value,
          "indeterminate": option.indeterminate,
          "modelValue": checked
        }, {
          default: () => [slots.label ? slots.label({
            data: option
          }) : isFunction(option.label) ? option.label() : option.label]
        });
      });
    };
    return () => {
      var _a;
      return createVNode("span", {
        "class": cls.value
      }, [options.value.length > 0 ? renderOptions() : (_a = slots.default) == null ? void 0 : _a.call(slots)]);
    };
  }
});
const Checkbox = Object.assign(_Checkbox, {
  Group: CheckboxGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Checkbox.name, _Checkbox);
    app.component(componentPrefix + CheckboxGroup.name, CheckboxGroup);
  }
});
const selectInjectionKey = Symbol("ArcoSelectContext");
const isGroupOption = (option) => {
  return isObject(option) && "isGroup" in option;
};
const isGroupOptionInfo = (option) => {
  return isObject(option) && "isGroup" in option;
};
const getValueString = (value, valueKey = "value") => String(isObject(value) ? value[valueKey] : value);
const getKeyFromValue = (value, valueKey = "value") => {
  if (isObject(value)) {
    return `__arco__option__object__${value[valueKey]}`;
  }
  if (value || isNumber(value) || isString(value) || isBoolean(value)) {
    return `__arco__option__${typeof value}-${value}`;
  }
  return "";
};
const hasEmptyStringKey = (optionInfoMap) => {
  return optionInfoMap.has(`__arco__option__string-`);
};
const createOptionInfo = (option, {
  valueKey,
  fieldNames,
  origin,
  index: index2 = -1
}) => {
  var _a;
  if (isObject(option)) {
    const value = option[fieldNames.value];
    return {
      raw: option,
      index: index2,
      key: getKeyFromValue(value, valueKey),
      origin,
      value,
      label: (_a = option[fieldNames.label]) != null ? _a : getValueString(value, valueKey),
      render: option[fieldNames.render],
      disabled: Boolean(option[fieldNames.disabled]),
      tagProps: option[fieldNames.tagProps]
    };
  }
  const raw = {
    value: option,
    label: String(option),
    disabled: false
  };
  return {
    raw,
    index: index2,
    key: getKeyFromValue(option, valueKey),
    origin,
    ...raw
  };
};
const getOptionInfos$1 = (options, {
  valueKey,
  fieldNames,
  origin,
  optionInfoMap
}) => {
  var _a;
  const infos = [];
  for (const item of options) {
    if (isGroupOption(item)) {
      const options2 = getOptionInfos$1((_a = item.options) != null ? _a : [], {
        valueKey,
        fieldNames,
        origin,
        optionInfoMap
      });
      if (options2.length > 0) {
        infos.push({
          ...item,
          key: `__arco__group__${item.label}`,
          options: options2
        });
      }
    } else {
      const optionInfo = createOptionInfo(item, {
        valueKey,
        fieldNames,
        origin
      });
      infos.push(optionInfo);
      if (!optionInfoMap.get(optionInfo.key)) {
        optionInfoMap.set(optionInfo.key, optionInfo);
      }
    }
  }
  return infos;
};
const getValidOptions = (optionInfos, {
  inputValue,
  filterOption
}) => {
  const travel = (optionInfos2) => {
    var _a;
    const options = [];
    for (const item of optionInfos2) {
      if (isGroupOptionInfo(item)) {
        const _options = travel((_a = item.options) != null ? _a : []);
        if (_options.length > 0) {
          options.push({ ...item, options: _options });
        }
      } else if (isValidOption(item, { inputValue, filterOption })) {
        options.push(item);
      }
    }
    return options;
  };
  return travel(optionInfos);
};
const isValidOption = (optionInfo, {
  inputValue,
  filterOption
}) => {
  if (isFunction(filterOption)) {
    return !inputValue || filterOption(inputValue, optionInfo.raw);
  }
  if (filterOption) {
    return optionInfo.label.toLowerCase().includes((inputValue != null ? inputValue : "").toLowerCase());
  }
  return true;
};
const isEqualObject = (obj, other) => {
  if (!obj || !other) {
    return false;
  }
  if (obj.length !== other.length) {
    return false;
  }
  for (const key of Object.keys(obj)) {
    const result = isEqual(obj[key], other[key]);
    if (!result)
      return false;
  }
  return true;
};
const isEqualArray = (arr, other) => {
  if (!arr || !other) {
    return false;
  }
  const { length } = arr;
  if (length !== other.length) {
    return false;
  }
  for (let i2 = 0; i2 < length; i2++) {
    const result = isEqual(arr[i2], other[i2]);
    if (!result)
      return false;
  }
  return true;
};
const isEqual = (a, b) => {
  const type = Object.prototype.toString.call(a);
  if (type !== Object.prototype.toString.call(b)) {
    return false;
  }
  if (type === "[object Object]") {
    return isEqualObject(
      a,
      b
    );
  }
  if (type === "[object Array]") {
    return isEqualArray(a, b);
  }
  if (type === "[object Function]") {
    if (a === b) {
      return true;
    }
    return a.toString() === b.toString();
  }
  return a === b;
};
const _sfc_main$6d = defineComponent({
  name: "Option",
  components: {
    Checkbox
  },
  props: {
    value: {
      type: [String, Number, Boolean, Object],
      default: void 0
    },
    label: String,
    disabled: Boolean,
    tagProps: {
      type: Object
    },
    extra: {
      type: Object
    },
    index: {
      type: Number
    },
    internal: Boolean
  },
  setup(props) {
    const { disabled, tagProps: _tagProps, index: index2 } = toRefs(props);
    const prefixCls = getPrefixCls("select-option");
    const selectCtx = inject(selectInjectionKey, void 0);
    const instance = getCurrentInstance();
    const itemRef = ref();
    const tagProps = ref(_tagProps.value);
    watch(_tagProps, (cur, pre) => {
      if (!isEqual(cur, pre)) {
        tagProps.value = cur;
      }
    });
    const textContent = ref("");
    const value = computed(
      () => {
        var _a, _b;
        return (_b = (_a = props.value) != null ? _a : props.label) != null ? _b : textContent.value;
      }
    );
    const label = computed(() => {
      var _a;
      return (_a = props.label) != null ? _a : textContent.value;
    });
    const key = computed(
      () => getKeyFromValue(value.value, selectCtx == null ? void 0 : selectCtx.valueKey)
    );
    const component = computed(() => {
      var _a;
      return (_a = selectCtx == null ? void 0 : selectCtx.component) != null ? _a : "li";
    });
    const setTextContent = () => {
      var _a;
      if (!props.label && itemRef.value) {
        const text = (_a = itemRef.value.textContent) != null ? _a : "";
        if (textContent.value !== text) {
          textContent.value = text;
        }
      }
    };
    onMounted(() => setTextContent());
    onUpdated(() => setTextContent());
    const isSelected = computed(
      () => {
        var _a;
        return (_a = selectCtx == null ? void 0 : selectCtx.valueKeys.includes(key.value)) != null ? _a : false;
      }
    );
    const isActive = computed(
      () => (selectCtx == null ? void 0 : selectCtx.activeKey) === key.value
    );
    let isValid = ref(true);
    if (!props.internal) {
      const optionInfo = reactive({
        raw: {
          value,
          label,
          disabled,
          tagProps
        },
        ref: itemRef,
        index: index2,
        key,
        origin: "slot",
        value,
        label,
        disabled,
        tagProps
      });
      isValid = computed(
        () => isValidOption(optionInfo, {
          inputValue: selectCtx == null ? void 0 : selectCtx.inputValue,
          filterOption: selectCtx == null ? void 0 : selectCtx.filterOption
        })
      );
      if (instance) {
        selectCtx == null ? void 0 : selectCtx.addSlotOptionInfo(instance.uid, optionInfo);
      }
      onBeforeUnmount(() => {
        if (instance) {
          selectCtx == null ? void 0 : selectCtx.removeSlotOptionInfo(instance.uid);
        }
      });
    }
    const handleClick = (ev) => {
      if (!props.disabled) {
        selectCtx == null ? void 0 : selectCtx.onSelect(key.value, ev);
      }
    };
    const handleMouseEnter = () => {
      if (!props.disabled) {
        selectCtx == null ? void 0 : selectCtx.setActiveKey(key.value);
      }
    };
    const handleMouseLeave = () => {
      if (!props.disabled) {
        selectCtx == null ? void 0 : selectCtx.setActiveKey();
      }
    };
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-disabled`]: props.disabled,
        [`${prefixCls}-selected`]: isSelected.value,
        [`${prefixCls}-active`]: isActive.value,
        [`${prefixCls}-multiple`]: selectCtx == null ? void 0 : selectCtx.multiple
      }
    ]);
    return {
      prefixCls,
      cls,
      selectCtx,
      itemRef,
      component,
      isSelected,
      isValid,
      handleClick,
      handleMouseEnter,
      handleMouseLeave
    };
  }
});
function _sfc_render$6c(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_checkbox = resolveComponent("checkbox");
  return withDirectives((openBlock(), createBlock(resolveDynamicComponent(_ctx.component), {
    ref: "itemRef",
    class: normalizeClass([_ctx.cls, { [`${_ctx.prefixCls}-has-suffix`]: Boolean(_ctx.$slots.suffix) }]),
    onClick: _ctx.handleClick,
    onMouseenter: _ctx.handleMouseEnter,
    onMouseleave: _ctx.handleMouseLeave
  }, {
    default: withCtx(() => [
      _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-icon`)
      }, [
        renderSlot(_ctx.$slots, "icon")
      ], 2)) : createCommentVNode("v-if", true),
      _ctx.selectCtx && _ctx.selectCtx.multiple ? (openBlock(), createBlock(_component_checkbox, {
        key: 1,
        class: normalizeClass(`${_ctx.prefixCls}-checkbox`),
        "model-value": _ctx.isSelected,
        disabled: _ctx.disabled,
        "uninject-group-context": ""
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(_ctx.label), 1)
          ])
        ]),
        _: 3
      }, 8, ["class", "model-value", "disabled"])) : (openBlock(), createElementBlock("span", {
        key: 2,
        class: normalizeClass(`${_ctx.prefixCls}-content`)
      }, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(_ctx.label), 1)
        ])
      ], 2)),
      _ctx.$slots.suffix ? (openBlock(), createElementBlock("span", {
        key: 3,
        class: normalizeClass(`${_ctx.prefixCls}-suffix`)
      }, [
        renderSlot(_ctx.$slots, "suffix")
      ], 2)) : createCommentVNode("v-if", true)
    ]),
    _: 3
  }, 40, ["class", "onClick", "onMouseenter", "onMouseleave"])), [
    [vShow, _ctx.isValid]
  ]);
}
var Option = /* @__PURE__ */ _export_sfc(_sfc_main$6d, [["render", _sfc_render$6c]]);
const DEFAULT_FIELD_NAMES$2 = {
  value: "value",
  label: "label",
  disabled: "disabled",
  tagProps: "tagProps",
  render: "render"
};
const useOptions = ({
  options,
  extraOptions,
  inputValue,
  filterOption,
  showExtraOptions,
  valueKey,
  fieldNames
}) => {
  const mergedFieldNames = computed(() => ({
    ...DEFAULT_FIELD_NAMES$2,
    ...fieldNames == null ? void 0 : fieldNames.value
  }));
  const slotOptionInfoMap = reactive(/* @__PURE__ */ new Map());
  const sortedSlotOptionInfos = computed(
    () => Array.from(slotOptionInfoMap.values()).sort((a, b) => {
      if (isNumber(a.index) && isNumber(b.index)) {
        return a.index - b.index;
      }
      return 0;
    })
  );
  const propOptionData = computed(() => {
    var _a, _b;
    const optionInfoMap2 = /* @__PURE__ */ new Map();
    const optionInfos = getOptionInfos$1((_a = options == null ? void 0 : options.value) != null ? _a : [], {
      valueKey: (_b = valueKey == null ? void 0 : valueKey.value) != null ? _b : "value",
      fieldNames: mergedFieldNames.value,
      origin: "options",
      optionInfoMap: optionInfoMap2
    });
    return {
      optionInfos,
      optionInfoMap: optionInfoMap2
    };
  });
  const extraOptionData = computed(() => {
    var _a, _b;
    const optionInfoMap2 = /* @__PURE__ */ new Map();
    const optionInfos = getOptionInfos$1((_a = extraOptions == null ? void 0 : extraOptions.value) != null ? _a : [], {
      valueKey: (_b = valueKey == null ? void 0 : valueKey.value) != null ? _b : "value",
      fieldNames: mergedFieldNames.value,
      origin: "extraOptions",
      optionInfoMap: optionInfoMap2
    });
    return {
      optionInfos,
      optionInfoMap: optionInfoMap2
    };
  });
  const optionInfoMap = reactive(/* @__PURE__ */ new Map());
  watch(
    [
      sortedSlotOptionInfos,
      options != null ? options : ref([]),
      extraOptions != null ? extraOptions : ref([]),
      valueKey != null ? valueKey : ref("value")
    ],
    () => {
      optionInfoMap.clear();
      sortedSlotOptionInfos.value.forEach((info, index2) => {
        optionInfoMap.set(info.key, { ...info, index: index2 });
      });
      propOptionData.value.optionInfoMap.forEach((info) => {
        if (!optionInfoMap.has(info.key)) {
          info.index = optionInfoMap.size;
          optionInfoMap.set(info.key, info);
        }
      });
      extraOptionData.value.optionInfoMap.forEach((info) => {
        if (!optionInfoMap.has(info.key)) {
          info.index = optionInfoMap.size;
          optionInfoMap.set(info.key, info);
        }
      });
    },
    { immediate: true, deep: true }
  );
  const validOptions = computed(() => {
    var _a;
    const options2 = getValidOptions(propOptionData.value.optionInfos, {
      inputValue: inputValue == null ? void 0 : inputValue.value,
      filterOption: filterOption == null ? void 0 : filterOption.value
    });
    if ((_a = showExtraOptions == null ? void 0 : showExtraOptions.value) != null ? _a : true) {
      options2.push(
        ...getValidOptions(extraOptionData.value.optionInfos, {
          inputValue: inputValue == null ? void 0 : inputValue.value,
          filterOption: filterOption == null ? void 0 : filterOption.value
        })
      );
    }
    return options2;
  });
  const validOptionInfos = computed(
    () => Array.from(optionInfoMap.values()).filter((optionInfo) => {
      if (optionInfo.origin === "extraOptions" && (showExtraOptions == null ? void 0 : showExtraOptions.value) === false) {
        return false;
      }
      return isValidOption(optionInfo, {
        inputValue: inputValue == null ? void 0 : inputValue.value,
        filterOption: filterOption == null ? void 0 : filterOption.value
      });
    })
  );
  const enabledOptionKeys = computed(
    () => validOptionInfos.value.filter((optionInfo) => !optionInfo.disabled).map((info) => info.key)
  );
  const getNextSlotOptionIndex = () => slotOptionInfoMap.size;
  const addSlotOptionInfo = (id, optionInfo) => {
    slotOptionInfoMap.set(id, optionInfo);
  };
  const removeSlotOptionInfo = (id) => {
    slotOptionInfoMap.delete(id);
  };
  return {
    validOptions,
    optionInfoMap,
    validOptionInfos,
    enabledOptionKeys,
    getNextSlotOptionIndex,
    addSlotOptionInfo,
    removeSlotOptionInfo
  };
};
const KEYBOARD_KEY = {
  ENTER: "Enter",
  ESC: "Escape",
  BACKSPACE: "Backspace",
  TAB: "Tab",
  SPACE: " ",
  ARROW_UP: "ArrowUp",
  ARROW_DOWN: "ArrowDown",
  ARROW_LEFT: "ArrowLeft",
  ARROW_RIGHT: "ArrowRight"
};
const stringifyCodeKey = (k) => {
  return JSON.stringify({
    key: k.key,
    ctrl: Boolean(k.ctrl),
    shift: Boolean(k.shift),
    alt: Boolean(k.alt),
    meta: Boolean(k.meta)
  });
};
const getKeyDownHandler = (codeKeyMap) => {
  const map = {};
  codeKeyMap.forEach((callback, codeKey) => {
    const _codeKey = isString(codeKey) ? { key: codeKey } : codeKey;
    map[stringifyCodeKey(_codeKey)] = callback;
  });
  return (event) => {
    const key = stringifyCodeKey({
      key: event.key,
      ctrl: event.ctrlKey,
      shift: event.shiftKey,
      alt: event.altKey,
      meta: event.metaKey
    });
    const callback = map[key];
    if (callback) {
      event.stopPropagation();
      callback(event);
    }
  };
};
const useSelect = ({
  multiple,
  options,
  extraOptions,
  inputValue,
  filterOption,
  showExtraOptions,
  component,
  valueKey,
  fieldNames,
  loading,
  popupVisible,
  valueKeys,
  dropdownRef,
  optionRefs,
  virtualListRef,
  onSelect,
  onPopupVisibleChange,
  enterToOpen = true,
  defaultActiveFirstOption
}) => {
  const {
    validOptions,
    optionInfoMap,
    validOptionInfos,
    enabledOptionKeys,
    getNextSlotOptionIndex,
    addSlotOptionInfo,
    removeSlotOptionInfo
  } = useOptions({
    options,
    extraOptions,
    inputValue,
    filterOption,
    showExtraOptions,
    valueKey,
    fieldNames
  });
  const activeKey = ref();
  watch(enabledOptionKeys, (enabledKeys) => {
    if (!activeKey.value || !enabledKeys.includes(activeKey.value)) {
      activeKey.value = enabledKeys[0];
    }
  });
  const setActiveKey = (key) => {
    activeKey.value = key;
  };
  const getNextActiveKey = (direction) => {
    const _length = enabledOptionKeys.value.length;
    if (_length === 0) {
      return void 0;
    }
    if (!activeKey.value) {
      if (direction === "down") {
        return enabledOptionKeys.value[0];
      }
      return enabledOptionKeys.value[_length - 1];
    }
    const activeIndex = enabledOptionKeys.value.indexOf(activeKey.value);
    const nextIndex = (_length + activeIndex + (direction === "up" ? -1 : 1)) % _length;
    return enabledOptionKeys.value[nextIndex];
  };
  const scrollIntoView2 = (key) => {
    var _a, _b;
    if (virtualListRef == null ? void 0 : virtualListRef.value) {
      virtualListRef.value.scrollTo({ key });
    }
    const optionInfo = optionInfoMap.get(key);
    const wrapperEle = (_a = dropdownRef == null ? void 0 : dropdownRef.value) == null ? void 0 : _a.wrapperRef;
    const optionEle = (_b = optionRefs == null ? void 0 : optionRefs.value[key]) != null ? _b : optionInfo == null ? void 0 : optionInfo.ref;
    if (!wrapperEle || !optionEle) {
      return;
    }
    if (wrapperEle.scrollHeight === wrapperEle.offsetHeight) {
      return;
    }
    const optionRect = getRelativeRect(optionEle, wrapperEle);
    const wrapperScrollTop = wrapperEle.scrollTop;
    if (optionRect.top < 0) {
      wrapperEle.scrollTo(0, wrapperScrollTop + optionRect.top);
    } else if (optionRect.bottom < 0) {
      wrapperEle.scrollTo(0, wrapperScrollTop - optionRect.bottom);
    }
  };
  watch(popupVisible, (visible) => {
    var _a;
    if (visible) {
      const current = valueKeys.value[valueKeys.value.length - 1];
      let _activeKey = ((_a = defaultActiveFirstOption == null ? void 0 : defaultActiveFirstOption.value) != null ? _a : true) ? enabledOptionKeys.value[0] : void 0;
      if (enabledOptionKeys.value.includes(current)) {
        _activeKey = current;
      }
      if (_activeKey !== activeKey.value) {
        activeKey.value = _activeKey;
      }
      nextTick(() => {
        if (activeKey.value) {
          scrollIntoView2(activeKey.value);
        }
      });
    }
  });
  const handleKeyDown = getKeyDownHandler(
    /* @__PURE__ */ new Map([
      [
        KEYBOARD_KEY.ENTER,
        (e) => {
          if (!(loading == null ? void 0 : loading.value) && !e.isComposing) {
            if (popupVisible.value) {
              if (activeKey.value) {
                onSelect(activeKey.value, e);
                e.preventDefault();
              }
            } else if (enterToOpen) {
              onPopupVisibleChange(true);
              e.preventDefault();
            }
          }
        }
      ],
      [
        KEYBOARD_KEY.ESC,
        (e) => {
          if (popupVisible.value) {
            onPopupVisibleChange(false);
            e.preventDefault();
          }
        }
      ],
      [
        KEYBOARD_KEY.ARROW_DOWN,
        (e) => {
          if (popupVisible.value) {
            const next = getNextActiveKey("down");
            if (next) {
              activeKey.value = next;
              scrollIntoView2(next);
            }
            e.preventDefault();
          }
        }
      ],
      [
        KEYBOARD_KEY.ARROW_UP,
        (e) => {
          if (popupVisible.value) {
            const next = getNextActiveKey("up");
            if (next) {
              activeKey.value = next;
              scrollIntoView2(next);
            }
            e.preventDefault();
          }
        }
      ]
    ])
  );
  provide(
    selectInjectionKey,
    reactive({
      multiple,
      valueKey,
      inputValue,
      filterOption,
      component,
      valueKeys,
      activeKey,
      setActiveKey,
      onSelect,
      getNextSlotOptionIndex,
      addSlotOptionInfo,
      removeSlotOptionInfo
    })
  );
  return {
    validOptions,
    optionInfoMap,
    validOptionInfos,
    enabledOptionKeys,
    activeKey,
    setActiveKey,
    addSlotOptionInfo,
    removeSlotOptionInfo,
    getNextActiveKey,
    scrollIntoView: scrollIntoView2,
    handleKeyDown
  };
};
const useSize = ({
  dataKeys,
  contentRef,
  fixedSize,
  estimatedSize,
  buffer
}) => {
  const firstRangeAverageSize = ref(0);
  const sizeMap = /* @__PURE__ */ new Map();
  const total = computed(() => dataKeys.value.length);
  const start = ref(0);
  const end = computed(() => {
    const _end = start.value + buffer.value * 3;
    if (_end > total.value)
      return total.value;
    return _end;
  });
  const maxStart = computed(() => {
    const max = total.value - buffer.value * 3;
    if (max < 0)
      return 0;
    return max;
  });
  const setStart = (index2) => {
    if (index2 < 0) {
      start.value = 0;
    } else if (index2 > maxStart.value) {
      start.value = maxStart.value;
    } else {
      start.value = index2;
    }
  };
  const isFixed = ref(fixedSize.value);
  const _estimatedSize = computed(() => {
    if (estimatedSize.value !== 30) {
      return estimatedSize.value;
    }
    return firstRangeAverageSize.value || estimatedSize.value;
  });
  const setItemSize = (key, size) => {
    sizeMap.set(key, size);
  };
  const getItemSize = (index2) => {
    var _a;
    if (isFixed.value) {
      return _estimatedSize.value;
    }
    const _key = dataKeys.value[index2];
    return (_a = sizeMap.get(_key)) != null ? _a : _estimatedSize.value;
  };
  const hasItemSize = (key) => {
    return sizeMap.has(key);
  };
  onMounted(() => {
    const firstRangeTotalSize = Array.from(sizeMap.values()).reduce(
      (pre, value) => pre + value,
      0
    );
    if (firstRangeTotalSize > 0) {
      firstRangeAverageSize.value = firstRangeTotalSize / sizeMap.size;
    }
  });
  const getScrollOffset = (index2) => {
    if (isFixed.value) {
      return _estimatedSize.value * index2;
    }
    return getOffset(0, index2);
  };
  const getOffset = (start2, end2) => {
    let offset = 0;
    for (let i2 = start2; i2 < end2; i2++) {
      offset += getItemSize(i2);
    }
    return offset;
  };
  const frontPadding = computed(() => {
    if (isFixed.value) {
      return _estimatedSize.value * start.value;
    }
    return getOffset(0, start.value);
  });
  const getOffsetIndex = (scrollOffset) => {
    const isForward = scrollOffset >= frontPadding.value;
    let offset = Math.abs(scrollOffset - frontPadding.value);
    const _start = isForward ? start.value : start.value - 1;
    let offsetIndex = 0;
    while (offset > 0) {
      offset -= getItemSize(_start + offsetIndex);
      isForward ? offsetIndex++ : offsetIndex--;
    }
    return offsetIndex;
  };
  const getStartByScroll = (scrollOffset) => {
    const offsetIndex = getOffsetIndex(scrollOffset);
    const _start = start.value + offsetIndex - buffer.value;
    if (_start < 0)
      return 0;
    if (_start > maxStart.value)
      return maxStart.value;
    return _start;
  };
  const behindPadding = computed(() => {
    if (isFixed.value) {
      return _estimatedSize.value * (total.value - end.value);
    }
    return getOffset(end.value, total.value);
  });
  return {
    frontPadding,
    behindPadding,
    start,
    end,
    getStartByScroll,
    setItemSize,
    hasItemSize,
    setStart,
    getScrollOffset
  };
};
var VirtualListItem = defineComponent({
  name: "VirtualListItem",
  props: {
    hasItemSize: {
      type: Function,
      required: true
    },
    setItemSize: {
      type: Function,
      required: true
    }
  },
  setup(props, {
    slots
  }) {
    var _a;
    const key = (_a = getCurrentInstance()) == null ? void 0 : _a.vnode.key;
    const itemRef = ref();
    const setItemSize = () => {
      var _a2, _b, _c, _d;
      const ele = (_b = (_a2 = itemRef.value) == null ? void 0 : _a2.$el) != null ? _b : itemRef.value;
      const height = (_d = (_c = ele == null ? void 0 : ele.getBoundingClientRect) == null ? void 0 : _c.call(ele).height) != null ? _d : ele == null ? void 0 : ele.offsetHeight;
      if (height) {
        props.setItemSize(key, height);
      }
    };
    onMounted(() => setItemSize());
    onBeforeUnmount(() => setItemSize());
    return () => {
      var _a2;
      const child = getFirstComponent((_a2 = slots.default) == null ? void 0 : _a2.call(slots));
      if (child) {
        return cloneVNode(child, {
          ref: itemRef
        }, true);
      }
      return null;
    };
  }
});
const _sfc_main$6c = defineComponent({
  name: "VirtualList",
  components: { VirtualListItem },
  props: {
    height: {
      type: [Number, String],
      default: 200
    },
    data: {
      type: Array,
      default: () => []
    },
    threshold: {
      type: Number,
      default: 0
    },
    itemKey: {
      type: String,
      default: "key"
    },
    fixedSize: {
      type: Boolean,
      default: false
    },
    estimatedSize: {
      type: Number,
      default: 30
    },
    buffer: {
      type: Number,
      default: 10
    },
    component: {
      type: [String, Object],
      default: "div"
    },
    listAttrs: {
      type: Object
    },
    contentAttrs: {
      type: Object
    },
    paddingPosition: {
      type: String,
      default: "content"
    }
  },
  emits: {
    scroll: (ev) => true,
    reachBottom: (ev) => true
  },
  setup(props, { emit }) {
    const { data, itemKey, fixedSize, estimatedSize, buffer, height } = toRefs(props);
    const prefixCls = getPrefixCls("virtual-list");
    const mergedComponent = computed(() => {
      if (isObject(props.component)) {
        return {
          container: "div",
          list: "div",
          content: "div",
          ...props.component
        };
      }
      return {
        container: props.component,
        list: "div",
        content: "div"
      };
    });
    const containerRef = ref();
    const contentRef = ref();
    const style = computed(() => {
      return {
        height: isNumber(height.value) ? `${height.value}px` : height.value,
        overflow: "auto"
      };
    });
    const dataKeys = computed(
      () => data.value.map((item, index2) => {
        var _a;
        return (_a = item[itemKey.value]) != null ? _a : index2;
      })
    );
    const {
      frontPadding,
      behindPadding,
      start,
      end,
      getStartByScroll,
      setItemSize,
      hasItemSize,
      setStart,
      getScrollOffset
    } = useSize({
      dataKeys,
      contentRef,
      fixedSize,
      estimatedSize,
      buffer
    });
    const currentList = computed(() => {
      if (props.threshold && data.value.length <= props.threshold) {
        return data.value;
      }
      return data.value.slice(start.value, end.value);
    });
    const onScroll = (ev) => {
      const { scrollTop, scrollHeight, offsetHeight } = ev.target;
      const _start = getStartByScroll(scrollTop);
      if (_start !== start.value) {
        setStart(_start);
        nextTick(() => {
          scrollTo2(scrollTop);
        });
      }
      emit("scroll", ev);
      const bottom = Math.floor(scrollHeight - (scrollTop + offsetHeight));
      if (bottom <= 0) {
        emit("reachBottom", ev);
      }
    };
    const scrollTo2 = (options) => {
      var _a, _b;
      if (containerRef.value) {
        if (isNumber(options)) {
          containerRef.value.scrollTop = options;
        } else {
          const _index = (_b = options.index) != null ? _b : dataKeys.value.indexOf((_a = options.key) != null ? _a : "");
          setStart(_index - buffer.value);
          containerRef.value.scrollTop = getScrollOffset(_index);
          nextTick(() => {
            if (containerRef.value) {
              const _scrollTop = getScrollOffset(_index);
              if (_scrollTop !== containerRef.value.scrollTop) {
                containerRef.value.scrollTop = _scrollTop;
              }
            }
          });
        }
      }
    };
    return {
      prefixCls,
      containerRef,
      contentRef,
      frontPadding,
      currentList,
      behindPadding,
      onScroll,
      setItemSize,
      hasItemSize,
      start,
      scrollTo: scrollTo2,
      style,
      mergedComponent
    };
  }
});
function _sfc_render$6b(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_VirtualListItem = resolveComponent("VirtualListItem");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.mergedComponent.container), {
    ref: "containerRef",
    class: normalizeClass(_ctx.prefixCls),
    style: normalizeStyle(_ctx.style),
    onScroll: _ctx.onScroll
  }, {
    default: withCtx(() => [
      (openBlock(), createBlock(resolveDynamicComponent(_ctx.mergedComponent.list), mergeProps(_ctx.listAttrs, {
        style: _ctx.paddingPosition === "list" ? {
          paddingTop: `${_ctx.frontPadding}px`,
          paddingBottom: `${_ctx.behindPadding}px`
        } : {}
      }), {
        default: withCtx(() => [
          (openBlock(), createBlock(resolveDynamicComponent(_ctx.mergedComponent.content), mergeProps({ ref: "contentRef" }, _ctx.contentAttrs, {
            style: _ctx.paddingPosition === "content" ? {
              paddingTop: `${_ctx.frontPadding}px`,
              paddingBottom: `${_ctx.behindPadding}px`
            } : {}
          }), {
            default: withCtx(() => [
              (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.currentList, (item, index2) => {
                var _a;
                return openBlock(), createBlock(_component_VirtualListItem, {
                  key: (_a = item[_ctx.itemKey]) != null ? _a : _ctx.start + index2,
                  "has-item-size": _ctx.hasItemSize,
                  "set-item-size": _ctx.setItemSize
                }, {
                  default: withCtx(() => [
                    renderSlot(_ctx.$slots, "item", {
                      item,
                      index: _ctx.start + index2
                    })
                  ]),
                  _: 2
                }, 1032, ["has-item-size", "set-item-size"]);
              }), 128))
            ]),
            _: 3
          }, 16, ["style"]))
        ]),
        _: 3
      }, 16, ["style"]))
    ]),
    _: 3
  }, 40, ["class", "style", "onScroll"]);
}
var VirtualList = /* @__PURE__ */ _export_sfc(_sfc_main$6c, [["render", _sfc_render$6b]]);
var _AutoComplete = defineComponent({
  name: "AutoComplete",
  inheritAttrs: false,
  props: {
    modelValue: {
      type: String,
      default: void 0
    },
    defaultValue: {
      type: String,
      default: ""
    },
    disabled: {
      type: Boolean,
      default: false
    },
    data: {
      type: Array,
      default: () => []
    },
    popupContainer: {
      type: [String, Object]
    },
    strict: {
      type: Boolean,
      default: false
    },
    filterOption: {
      type: [Boolean, Function],
      default: true
    },
    triggerProps: {
      type: Object
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    virtualListProps: {
      type: Object
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value) => true,
    "search": (value) => true,
    "select": (value) => true,
    "clear": (ev) => true,
    "dropdownScroll": (ev) => true,
    "dropdownReachBottom": (ev) => true
  },
  setup(props, {
    emit,
    attrs,
    slots
  }) {
    const {
      modelValue
    } = toRefs(props);
    const prefixCls = getPrefixCls("auto-complete");
    const {
      mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled: toRef(props, "disabled")
    });
    const _value = ref(props.defaultValue);
    const inputRef = ref();
    const computedValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : _value.value;
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = "";
      }
    });
    const computedValueKeys = computed(() => computedValue.value ? [getKeyFromValue(computedValue.value)] : []);
    const {
      data
    } = toRefs(props);
    const dropdownRef = ref();
    const optionRefs = ref({});
    const _popupVisible = ref(false);
    const computedPopupVisible = computed(() => _popupVisible.value && validOptionInfos.value.length > 0);
    const virtualListRef = ref();
    const component = computed(() => props.virtualListProps ? "div" : "li");
    const handlePopupVisibleChange = (popupVisible) => {
      _popupVisible.value = popupVisible;
    };
    const strictFilterOption = (inputValue, option) => {
      var _a;
      return Boolean((_a = option.label) == null ? void 0 : _a.includes(inputValue));
    };
    const mergedFilterOption = computed(() => {
      if (isFunction(props.filterOption)) {
        return props.filterOption;
      }
      if (props.filterOption && props.strict) {
        return strictFilterOption;
      }
      return props.filterOption;
    });
    const handleChange = (value) => {
      var _a, _b;
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
    };
    const handleClear = (ev) => {
      var _a, _b;
      _value.value = "";
      emit("update:modelValue", "");
      emit("change", "");
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
      emit("clear", ev);
    };
    const handleSelect = (key, ev) => {
      var _a, _b;
      const value = (_a = optionInfoMap.get(key)) == null ? void 0 : _a.value;
      emit("select", value);
      handleChange(value);
      (_b = inputRef.value) == null ? void 0 : _b.blur();
    };
    const handleInputValueChange = (value) => {
      emit("search", value);
      handleChange(value);
    };
    const handleDropdownScroll = (e) => {
      emit("dropdownScroll", e);
    };
    const handleDropdownReachBottom = (e) => {
      emit("dropdownReachBottom", e);
    };
    const {
      validOptions,
      optionInfoMap,
      validOptionInfos,
      handleKeyDown
    } = useSelect({
      options: data,
      inputValue: computedValue,
      filterOption: mergedFilterOption,
      popupVisible: computedPopupVisible,
      valueKeys: computedValueKeys,
      component,
      dropdownRef,
      optionRefs,
      onSelect: handleSelect,
      onPopupVisibleChange: handlePopupVisibleChange
    });
    const getOptionContentFunc = (item) => {
      if (isFunction(slots.option) && item.value) {
        const optionInfo = optionInfoMap.get(item.key);
        const optionSlot = slots.option;
        return () => optionSlot({
          data: optionInfo
        });
      }
      return () => item.label;
    };
    const renderOption = (item) => {
      return createVNode(Option, {
        "ref": (ref2) => {
          if (ref2 == null ? void 0 : ref2.$el) {
            optionRefs.value[item.key] = ref2.$el;
          }
        },
        "key": item.key,
        "value": item.value,
        "disabled": item.disabled,
        "internal": true
      }, {
        default: getOptionContentFunc(item)
      });
    };
    const renderDropdown = () => {
      return createVNode(SelectDropdown, {
        "ref": dropdownRef,
        "class": `${prefixCls}-dropdown`,
        "virtualList": Boolean(props.virtualListProps),
        "onScroll": handleDropdownScroll,
        "onReachBottom": handleDropdownReachBottom
      }, {
        "default": () => [...validOptions.value.map((info) => renderOption(info))],
        "virtual-list": () => createVNode(VirtualList, mergeProps(props.virtualListProps, {
          "ref": virtualListRef,
          "data": validOptions.value
        }), {
          item: ({
            item
          }) => renderOption(item)
        }),
        "footer": slots.footer
      });
    };
    const render2 = () => createVNode(Trigger, mergeProps({
      "trigger": "focus",
      "position": "bl",
      "animationName": "slide-dynamic-origin",
      "autoFitTransformOrigin": true,
      "popupVisible": computedPopupVisible.value,
      "clickToClose": false,
      "preventFocus": true,
      "popupOffset": 4,
      "disabled": mergedDisabled.value,
      "autoFitPopupWidth": true
    }, props.triggerProps, {
      "onPopupVisibleChange": handlePopupVisibleChange
    }), {
      default: () => [createVNode(Input, mergeProps({
        "ref": inputRef
      }, attrs, {
        "allowClear": props.allowClear,
        "modelValue": computedValue.value,
        "disabled": mergedDisabled.value,
        "onInput": handleInputValueChange,
        "onClear": handleClear,
        "onKeydown": handleKeyDown
      }), slots)],
      content: renderDropdown
    });
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const AutoComplete = Object.assign(_AutoComplete, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _AutoComplete.name, _AutoComplete);
  }
});
const useIndex = ({
  itemRef,
  selector,
  index: index2,
  parentClassName
}) => {
  const _index = ref(-1);
  const computedIndex = computed(() => {
    var _a;
    return (_a = index2 == null ? void 0 : index2.value) != null ? _a : _index.value;
  });
  const parent = ref();
  const getParent = () => {
    var _a, _b, _c;
    let parent2 = (_b = (_a = itemRef.value) == null ? void 0 : _a.parentElement) != null ? _b : void 0;
    if (parentClassName) {
      while (parent2 && !parent2.className.includes(parentClassName)) {
        parent2 = (_c = parent2.parentElement) != null ? _c : void 0;
      }
    }
    return parent2;
  };
  const getIndex = () => {
    if (isUndefined(index2 == null ? void 0 : index2.value) && parent.value && itemRef.value) {
      const index22 = Array.from(parent.value.querySelectorAll(selector)).indexOf(
        itemRef.value
      );
      if (index22 !== _index.value) {
        _index.value = index22;
      }
    }
  };
  watch(itemRef, () => {
    if (itemRef.value && !parent.value) {
      parent.value = getParent();
    }
  });
  onMounted(() => {
    if (itemRef.value) {
      parent.value = getParent();
    }
    getIndex();
  });
  onUpdated(() => getIndex());
  return {
    computedIndex
  };
};
const avatarGroupInjectionKey = Symbol("ArcoAvatarGroup");
const _sfc_main$6b = defineComponent({
  name: "IconImageClose",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-image-close`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4H = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$6a(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createStaticVNode('<path d="M41 26V9a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v30a2 2 0 0 0 2 2h17"></path><path d="m24 33 9-8.5V27s-2 1-3.5 2.5C27.841 31.159 27 33 27 33h-3Zm0 0-3.5-4.5L17 33h7Z"></path><path d="M20.5 28.5 17 33h7l-3.5-4.5ZM33 24.5 24 33h3s.841-1.841 2.5-3.5C31 28 33 27 33 27v-2.5Z" fill="currentColor" stroke="none"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M46 38a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-4.95-4.782 1.74 1.74-3.045 3.046 3.046 3.046-1.74 1.74-3.047-3.045-3.046 3.046-1.74-1.74 3.046-3.047-3.046-3.046 1.74-1.74 3.046 3.046 3.046-3.046Z" fill="currentColor" stroke="none"></path><path d="M17 15h-2v2h2v-2Z"></path>', 5)
  ]), 14, _hoisted_1$4H);
}
var _IconImageClose = /* @__PURE__ */ _export_sfc(_sfc_main$6b, [["render", _sfc_render$6a]]);
const IconImageClose = Object.assign(_IconImageClose, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconImageClose.name, _IconImageClose);
  }
});
const _sfc_main$6a = defineComponent({
  name: "Avatar",
  components: {
    ResizeObserver,
    IconImageClose,
    IconLoading
  },
  props: {
    shape: {
      type: String,
      default: "circle"
    },
    imageUrl: String,
    size: Number,
    autoFixFontSize: {
      type: Boolean,
      default: true
    },
    triggerType: {
      type: String,
      default: "button"
    },
    triggerIconStyle: {
      type: Object
    },
    objectFit: {
      type: String
    }
  },
  emits: {
    click: (ev) => true,
    error: () => true,
    load: () => true
  },
  setup(props, { slots, emit, attrs }) {
    const { shape, size, autoFixFontSize, triggerType, triggerIconStyle } = toRefs(props);
    const prefixCls = getPrefixCls("avatar");
    const groupCtx = inject(avatarGroupInjectionKey, void 0);
    const itemRef = ref();
    const wrapperRef = ref();
    const mergedShape = computed(() => {
      var _a;
      return (_a = groupCtx == null ? void 0 : groupCtx.shape) != null ? _a : shape.value;
    });
    const mergedSize = computed(() => {
      var _a;
      return (_a = groupCtx == null ? void 0 : groupCtx.size) != null ? _a : size.value;
    });
    const mergedAutoFixFontSize = computed(
      () => {
        var _a;
        return (_a = groupCtx == null ? void 0 : groupCtx.autoFixFontSize) != null ? _a : autoFixFontSize.value;
      }
    );
    const isImage2 = ref(false);
    const hasError = ref(false);
    const shouldLoad = ref(true);
    const isLoaded = ref(false);
    const index2 = groupCtx ? useIndex({
      itemRef,
      selector: `.${prefixCls}`
    }).computedIndex : ref(-1);
    const outerStyle = computed(() => {
      var _a;
      const style = isNumber(mergedSize.value) ? {
        width: `${mergedSize.value}px`,
        height: `${mergedSize.value}px`,
        fontSize: `${mergedSize.value / 2}px`
      } : {};
      if (groupCtx) {
        style.zIndex = groupCtx.zIndexAscend ? index2.value + 1 : groupCtx.total - index2.value;
        style.marginLeft = index2.value !== 0 ? `-${((_a = mergedSize.value) != null ? _a : 40) / 4}px` : "0";
      }
      return style;
    });
    const computedTriggerIconStyle = useTriggerIconStyle({
      triggerIconStyle: triggerIconStyle == null ? void 0 : triggerIconStyle.value,
      inlineStyle: attrs.style,
      triggerType: triggerType.value
    });
    const autoFixFontSizeHandler = () => {
      if (!isImage2.value && !props.imageUrl) {
        nextTick(() => {
          var _a;
          if (!wrapperRef.value || !itemRef.value) {
            return;
          }
          const textWidth = wrapperRef.value.clientWidth;
          const avatarWidth = (_a = mergedSize.value) != null ? _a : itemRef.value.offsetWidth;
          const scale = avatarWidth / (textWidth + 8);
          if (avatarWidth && scale < 1) {
            wrapperRef.value.style.transform = `scale(${scale}) translateX(-50%)`;
          }
          shouldLoad.value = true;
        });
      }
    };
    onMounted(() => {
      var _a;
      if (((_a = wrapperRef.value) == null ? void 0 : _a.firstElementChild) && ["IMG", "PICTURE"].includes(wrapperRef.value.firstElementChild.tagName)) {
        isImage2.value = true;
      }
      if (mergedAutoFixFontSize.value) {
        autoFixFontSizeHandler();
      }
    });
    watch(size, () => {
      if (mergedAutoFixFontSize.value) {
        autoFixFontSizeHandler();
      }
    });
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-${mergedShape.value}`
    ]);
    const wrapperCls = computed(
      () => isImage2.value || props.imageUrl ? `${prefixCls}-image` : `${prefixCls}-text`
    );
    const onClick = (e) => {
      emit("click", e);
    };
    const handleResize = () => {
      if (mergedAutoFixFontSize.value) {
        autoFixFontSizeHandler();
      }
    };
    const handleImgLoad = () => {
      isLoaded.value = true;
      emit("load");
    };
    const handleImgError = () => {
      hasError.value = true;
      emit("error");
    };
    return {
      prefixCls,
      itemRef,
      cls,
      outerStyle,
      wrapperRef,
      wrapperCls,
      computedTriggerIconStyle,
      isImage: isImage2,
      shouldLoad,
      isLoaded,
      hasError,
      onClick,
      handleResize,
      handleImgLoad,
      handleImgError
    };
  }
});
const useTriggerIconStyle = ({
  triggerType,
  inlineStyle = {},
  triggerIconStyle = {}
}) => {
  let addon = {};
  if (triggerType === "button" && (!triggerIconStyle || triggerIconStyle && !triggerIconStyle.color) && inlineStyle && inlineStyle.backgroundColor) {
    addon = { color: inlineStyle.backgroundColor };
  }
  return {
    ...triggerIconStyle,
    ...addon
  };
};
const _hoisted_1$4G = ["src"];
function _sfc_render$69(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconImageClose = resolveComponent("IconImageClose");
  const _component_IconLoading = resolveComponent("IconLoading");
  const _component_resize_observer = resolveComponent("resize-observer");
  return openBlock(), createElementBlock("div", {
    ref: "itemRef",
    style: normalizeStyle(_ctx.outerStyle),
    class: normalizeClass([
      _ctx.cls,
      {
        [`${_ctx.prefixCls}-with-trigger-icon`]: Boolean(_ctx.$slots["trigger-icon"])
      }
    ]),
    onClick: _cache[2] || (_cache[2] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, [
    createVNode(_component_resize_observer, { onResize: _ctx.handleResize }, {
      default: withCtx(() => [
        createBaseVNode("span", {
          ref: "wrapperRef",
          class: normalizeClass(_ctx.wrapperCls)
        }, [
          _ctx.imageUrl ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            _ctx.hasError ? renderSlot(_ctx.$slots, "error", { key: 0 }, () => [
              createBaseVNode("div", {
                class: normalizeClass(`${_ctx.prefixCls}-image-icon`)
              }, [
                createVNode(_component_IconImageClose)
              ], 2)
            ]) : createCommentVNode("v-if", true),
            !(_ctx.hasError || !_ctx.shouldLoad) && !_ctx.isLoaded ? renderSlot(_ctx.$slots, "default", { key: 1 }, () => [
              createBaseVNode("div", {
                class: normalizeClass(`${_ctx.prefixCls}-image-icon`)
              }, [
                createVNode(_component_IconLoading)
              ], 2)
            ]) : createCommentVNode("v-if", true),
            !(_ctx.hasError || !_ctx.shouldLoad) ? (openBlock(), createElementBlock("img", {
              key: 2,
              src: _ctx.imageUrl,
              style: normalizeStyle({
                width: _ctx.size + "px",
                height: _ctx.size + "px",
                objectFit: _ctx.objectFit
              }),
              alt: "avatar",
              onLoad: _cache[0] || (_cache[0] = (...args) => _ctx.handleImgLoad && _ctx.handleImgLoad(...args)),
              onError: _cache[1] || (_cache[1] = (...args) => _ctx.handleImgError && _ctx.handleImgError(...args))
            }, null, 44, _hoisted_1$4G)) : createCommentVNode("v-if", true)
          ], 64)) : renderSlot(_ctx.$slots, "default", { key: 1 })
        ], 2)
      ]),
      _: 3
    }, 8, ["onResize"]),
    _ctx.$slots["trigger-icon"] ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-trigger-icon-${_ctx.triggerType}`),
      style: normalizeStyle(_ctx.computedTriggerIconStyle)
    }, [
      renderSlot(_ctx.$slots, "trigger-icon")
    ], 6)) : createCommentVNode("v-if", true)
  ], 6);
}
var _Avatar = /* @__PURE__ */ _export_sfc(_sfc_main$6a, [["render", _sfc_render$69]]);
const _sfc_main$69 = defineComponent({
  name: "Popover",
  components: {
    Trigger
  },
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    title: String,
    content: String,
    trigger: {
      type: [String, Array],
      default: "hover"
    },
    position: {
      type: String,
      default: "top"
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupContainer: {
      type: [String, Object]
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("popover");
    const _popupVisible = ref(props.defaultPopupVisible);
    const computedPopupVisible = computed(
      () => {
        var _a;
        return (_a = props.popupVisible) != null ? _a : _popupVisible.value;
      }
    );
    const handlePopupVisibleChange = (visible) => {
      _popupVisible.value = visible;
      emit("update:popupVisible", visible);
      emit("popupVisibleChange", visible);
    };
    const contentCls = computed(() => [
      `${prefixCls}-popup-content`,
      props.contentClass
    ]);
    const arrowCls = computed(() => [
      `${prefixCls}-popup-arrow`,
      props.arrowClass
    ]);
    return {
      prefixCls,
      computedPopupVisible,
      contentCls,
      arrowCls,
      handlePopupVisibleChange
    };
  }
});
function _sfc_render$68(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_trigger = resolveComponent("trigger");
  return openBlock(), createBlock(_component_trigger, {
    class: normalizeClass(_ctx.prefixCls),
    trigger: _ctx.trigger,
    position: _ctx.position,
    "popup-visible": _ctx.computedPopupVisible,
    "popup-offset": 10,
    "content-class": _ctx.contentCls,
    "content-style": _ctx.contentStyle,
    "arrow-class": _ctx.arrowCls,
    "arrow-style": _ctx.arrowStyle,
    "show-arrow": "",
    "popup-container": _ctx.popupContainer,
    "animation-name": "zoom-in-fade-out",
    "auto-fit-transform-origin": "",
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-title`)
      }, [
        renderSlot(_ctx.$slots, "title", {}, () => [
          createTextVNode(toDisplayString(_ctx.title), 1)
        ])
      ], 2),
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-content`)
      }, [
        renderSlot(_ctx.$slots, "content", {}, () => [
          createTextVNode(toDisplayString(_ctx.content), 1)
        ])
      ], 2)
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 8, ["class", "trigger", "position", "popup-visible", "content-class", "content-style", "arrow-class", "arrow-style", "popup-container", "onPopupVisibleChange"]);
}
var _Popover = /* @__PURE__ */ _export_sfc(_sfc_main$69, [["render", _sfc_render$68]]);
const Popover = Object.assign(_Popover, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Popover.name, _Popover);
  }
});
const AvatarGroup = defineComponent({
  name: "AvatarGroup",
  props: {
    shape: {
      type: String,
      default: "circle"
    },
    size: Number,
    autoFixFontSize: {
      type: Boolean,
      default: true
    },
    maxCount: {
      type: Number,
      default: 0
    },
    zIndexAscend: {
      type: Boolean,
      default: false
    },
    maxStyle: {
      type: Object
    },
    maxPopoverTriggerProps: {
      type: Object
    }
  },
  setup(props, {
    slots
  }) {
    const {
      shape,
      size,
      autoFixFontSize,
      zIndexAscend
    } = toRefs(props);
    const prefixCls = getPrefixCls("avatar-group");
    const total = ref(0);
    provide(avatarGroupInjectionKey, reactive({
      shape,
      size,
      autoFixFontSize,
      zIndexAscend,
      total
    }));
    return () => {
      var _a, _b;
      const children = getAllElements((_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _b : []);
      const avatarsToRender = props.maxCount > 0 ? children.slice(0, props.maxCount) : children;
      const avatarsInPopover = props.maxCount > 0 ? children.slice(props.maxCount) : [];
      if (total.value !== children.length) {
        total.value = children.length;
      }
      return createVNode("div", {
        "class": prefixCls
      }, [avatarsToRender, avatarsInPopover.length > 0 && createVNode(Popover, props.maxPopoverTriggerProps, {
        default: () => [createVNode(_Avatar, {
          "class": `${prefixCls}-max-count-avatar`,
          "style": props.maxStyle
        }, {
          default: () => [createTextVNode("+"), avatarsInPopover.length]
        })],
        content: () => createVNode("div", null, [avatarsInPopover])
      })]);
    };
  }
});
const Avatar = Object.assign(_Avatar, {
  Group: AvatarGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Avatar.name, _Avatar);
    app.component(componentPrefix + AvatarGroup.name, AvatarGroup);
  }
});
const _sfc_main$68 = defineComponent({
  name: "IconToTop",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-to-top`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4F = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$67(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M43 7H5M24 20v23M24 13.96 30.453 21H17.546L24 13.96Zm.736-.804Z" }, null, -1),
    createBaseVNode("path", {
      d: "m24 14-6 7h12l-6-7Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4F);
}
var _IconToTop = /* @__PURE__ */ _export_sfc(_sfc_main$68, [["render", _sfc_render$67]]);
const IconToTop = Object.assign(_IconToTop, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconToTop.name, _IconToTop);
  }
});
const _sfc_main$67 = defineComponent({
  name: "BackTop",
  components: {
    IconToTop
  },
  props: {
    visibleHeight: {
      type: Number,
      default: 200
    },
    targetContainer: {
      type: [String, Object]
    },
    easing: {
      type: String,
      default: "quartOut"
    },
    duration: {
      type: Number,
      default: 200
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("back-top");
    const visible = ref(false);
    const target2 = ref();
    const isWindow2 = !props.targetContainer;
    const scrollHandler = throttleByRaf(() => {
      if (target2.value) {
        const { visibleHeight } = props;
        const { scrollTop } = target2.value;
        visible.value = scrollTop >= visibleHeight;
      }
    });
    const getContainer = (container2) => {
      if (isString(container2)) {
        return document.querySelector(container2);
      }
      return container2;
    };
    onMounted(() => {
      target2.value = isWindow2 ? document == null ? void 0 : document.documentElement : getContainer(props.targetContainer);
      if (target2.value) {
        on(isWindow2 ? window : target2.value, "scroll", scrollHandler);
        scrollHandler();
      }
    });
    onUnmounted(() => {
      scrollHandler.cancel();
      if (target2.value) {
        off(isWindow2 ? window : target2.value, "scroll", scrollHandler);
      }
    });
    const scrollToTop = () => {
      if (target2.value) {
        const { scrollTop } = target2.value;
        const tween = new Tween({
          from: { scrollTop },
          to: { scrollTop: 0 },
          easing: props.easing,
          duration: props.duration,
          onUpdate: (keys) => {
            if (target2.value) {
              target2.value.scrollTop = keys.scrollTop;
            }
          }
        });
        tween.start();
      }
    };
    return {
      prefixCls,
      visible,
      scrollToTop
    };
  }
});
function _sfc_render$66(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_to_top = resolveComponent("icon-to-top");
  return openBlock(), createBlock(Transition, { name: "fade-in" }, {
    default: withCtx(() => [
      _ctx.visible ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(_ctx.prefixCls),
        onClick: _cache[0] || (_cache[0] = (...args) => _ctx.scrollToTop && _ctx.scrollToTop(...args))
      }, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createBaseVNode("button", {
            class: normalizeClass(`${_ctx.prefixCls}-btn`)
          }, [
            createVNode(_component_icon_to_top)
          ], 2)
        ])
      ], 2)) : createCommentVNode("v-if", true)
    ]),
    _: 3
  });
}
var _BackTop = /* @__PURE__ */ _export_sfc(_sfc_main$67, [["render", _sfc_render$66]]);
const BackTop = Object.assign(_BackTop, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _BackTop.name, _BackTop);
  }
});
const COLORS = ["red", "orangered", "orange", "gold", "lime", "green", "cyan", "arcoblue", "purple", "pinkpurple", "magenta", "gray"];
const BADGE_STATUSES = ["normal", "processing", "success", "warning", "danger"];
var _Badge = defineComponent({
  name: "Badge",
  props: {
    text: {
      type: String
    },
    dot: {
      type: Boolean
    },
    dotStyle: {
      type: Object
    },
    maxCount: {
      type: Number,
      default: 99
    },
    offset: {
      type: Array,
      default: () => []
    },
    color: {
      type: String
    },
    status: {
      type: String,
      validator: (value) => {
        return BADGE_STATUSES.includes(value);
      }
    },
    count: {
      type: Number
    }
  },
  setup(props, {
    slots
  }) {
    const {
      status,
      color,
      dotStyle,
      offset,
      text,
      dot,
      maxCount,
      count
    } = toRefs(props);
    const prefixCls = getPrefixCls("badge");
    const wrapperClassName = useWrapperClass(prefixCls, status == null ? void 0 : status.value, slots == null ? void 0 : slots.default);
    const computedStyleRef = computed(() => {
      const computedDotStyle = {
        ...(dotStyle == null ? void 0 : dotStyle.value) || {}
      };
      const [leftOffset, topOffset] = (offset == null ? void 0 : offset.value) || [];
      if (leftOffset) {
        computedDotStyle.marginRight = `${-leftOffset}px`;
      }
      if (topOffset) {
        computedDotStyle.marginTop = `${topOffset}px`;
      }
      const computedColorStyle = !(color == null ? void 0 : color.value) || COLORS.includes(color == null ? void 0 : color.value) ? {} : {
        backgroundColor: color.value
      };
      const mergedStyle = {
        ...computedColorStyle,
        ...computedDotStyle
      };
      return {
        mergedStyle,
        computedDotStyle,
        computedColorStyle
      };
    });
    const getDot = () => {
      const textValue = text == null ? void 0 : text.value;
      const colorValue = color == null ? void 0 : color.value;
      const statusValue = status == null ? void 0 : status.value;
      const dotValue = dot == null ? void 0 : dot.value;
      const countValue = Number(count == null ? void 0 : count.value);
      const hasCount = (count == null ? void 0 : count.value) != null;
      const {
        computedDotStyle,
        mergedStyle
      } = computedStyleRef.value;
      if (slots.content) {
        return createVNode("span", {
          "class": `${prefixCls}-custom-dot`,
          "style": computedDotStyle
        }, [slots.content()]);
      }
      if (textValue && !colorValue && !statusValue) {
        return createVNode("span", {
          "class": `${prefixCls}-text`,
          "style": computedDotStyle
        }, [textValue]);
      }
      if (statusValue || colorValue && !hasCount) {
        return createVNode("span", {
          "class": `${prefixCls}-status-wrapper`
        }, [createVNode("span", {
          "class": [`${prefixCls}-status-dot`, {
            [`${prefixCls}-status-${statusValue}`]: statusValue,
            [`${prefixCls}-color-${colorValue}`]: colorValue
          }],
          "style": mergedStyle
        }, null), textValue && createVNode("span", {
          "class": `${prefixCls}-status-text`
        }, [textValue])]);
      }
      if ((dotValue || colorValue) && countValue > 0) {
        return createVNode("span", {
          "class": [`${prefixCls}-dot`, {
            [`${prefixCls}-color-${colorValue}`]: colorValue
          }],
          "style": mergedStyle
        }, null);
      }
      if (countValue === 0) {
        return null;
      }
      return createVNode("span", {
        "class": `${prefixCls}-number`,
        "style": mergedStyle
      }, [createVNode("span", null, [maxCount.value && countValue > maxCount.value ? `${maxCount.value}+` : countValue])]);
    };
    return () => {
      return createVNode("span", {
        "class": wrapperClassName.value
      }, [slots.default && slots.default(), getDot()]);
    };
  }
});
const useWrapperClass = (prefixCls, status, children) => {
  return computed(() => [prefixCls, {
    [`${prefixCls}-status`]: status,
    [`${prefixCls}-no-children`]: !children
  }]);
};
const Badge = Object.assign(_Badge, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Badge.name, _Badge);
  }
});
const breadcrumbInjectKey = Symbol("ArcoBreadcrumb");
const _sfc_main$66 = defineComponent({
  name: "IconMore",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-more`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4E = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$65(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      d: "M38 25v-2h2v2h-2ZM23 25v-2h2v2h-2ZM8 25v-2h2v2H8Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1),
    createBaseVNode("path", { d: "M38 25v-2h2v2h-2ZM23 25v-2h2v2h-2ZM8 25v-2h2v2H8Z" }, null, -1)
  ]), 14, _hoisted_1$4E);
}
var _IconMore = /* @__PURE__ */ _export_sfc(_sfc_main$66, [["render", _sfc_render$65]]);
const IconMore = Object.assign(_IconMore, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconMore.name, _IconMore);
  }
});
const _sfc_main$65 = defineComponent({
  name: "IconDown",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-down`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4D = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$64(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M39.6 17.443 24.043 33 8.487 17.443" }, null, -1)
  ]), 14, _hoisted_1$4D);
}
var _IconDown = /* @__PURE__ */ _export_sfc(_sfc_main$65, [["render", _sfc_render$64]]);
const IconDown = Object.assign(_IconDown, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconDown.name, _IconDown);
  }
});
const _sfc_main$64 = defineComponent({
  name: "IconObliqueLine",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-oblique-line`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4C = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$63(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M29.506 6.502 18.493 41.498" }, null, -1)
  ]), 14, _hoisted_1$4C);
}
var _IconObliqueLine = /* @__PURE__ */ _export_sfc(_sfc_main$64, [["render", _sfc_render$63]]);
const IconObliqueLine = Object.assign(_IconObliqueLine, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconObliqueLine.name, _IconObliqueLine);
  }
});
const dropdownInjectionKey = Symbol("ArcoDropdown");
const _sfc_main$63 = defineComponent({
  name: "DropdownPanel",
  components: {
    Scrollbar,
    Empty
  },
  props: {
    loading: {
      type: Boolean,
      default: false
    },
    isEmpty: {
      type: Boolean,
      default: false
    },
    bottomOffset: {
      type: Number,
      default: 0
    },
    onScroll: {
      type: [Function, Array]
    },
    onReachBottom: {
      type: [Function, Array]
    }
  },
  emits: ["scroll", "reachBottom"],
  setup(props, { emit, slots }) {
    const prefixCls = getPrefixCls("dropdown");
    const dropdownCtx = inject(
      dropdownInjectionKey,
      {}
    );
    const wrapperRef = ref();
    const handleScroll = (e) => {
      const { scrollTop, scrollHeight, offsetHeight } = e.target;
      const bottom = scrollHeight - (scrollTop + offsetHeight);
      if (bottom <= props.bottomOffset) {
        emit("reachBottom", e);
      }
      emit("scroll", e);
    };
    const style = computed(() => {
      if (isNumber(dropdownCtx.popupMaxHeight)) {
        return {
          maxHeight: `${dropdownCtx.popupMaxHeight}px`
        };
      }
      if (!dropdownCtx.popupMaxHeight) {
        return {
          maxHeight: "none",
          overflowY: "hidden"
        };
      }
      return void 0;
    });
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-has-footer`]: Boolean(slots.footer)
      }
    ]);
    return {
      prefixCls,
      cls,
      style,
      wrapperRef,
      handleScroll
    };
  }
});
function _sfc_render$62(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_empty = resolveComponent("empty");
  const _component_Scrollbar = resolveComponent("Scrollbar");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    _ctx.isEmpty ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-empty`)
    }, [
      renderSlot(_ctx.$slots, "empty", {}, () => [
        createVNode(_component_empty)
      ])
    ], 2)) : createCommentVNode("v-if", true),
    createVNode(_component_Scrollbar, {
      ref: "wrapperRef",
      class: normalizeClass(`${_ctx.prefixCls}-list-wrapper`),
      style: normalizeStyle(_ctx.style),
      onScroll: _ctx.handleScroll
    }, {
      default: withCtx(() => [
        createBaseVNode("ul", {
          class: normalizeClass(`${_ctx.prefixCls}-list`)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2)
      ]),
      _: 3
    }, 8, ["class", "style", "onScroll"]),
    _ctx.$slots.footer && !_ctx.isEmpty ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-footer`)
    }, [
      renderSlot(_ctx.$slots, "footer")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var DropdownPanel = /* @__PURE__ */ _export_sfc(_sfc_main$63, [["render", _sfc_render$62]]);
const useTrigger = ({
  popupVisible,
  defaultPopupVisible,
  emit
}) => {
  var _a;
  const _popupVisible = ref((_a = defaultPopupVisible == null ? void 0 : defaultPopupVisible.value) != null ? _a : false);
  const computedPopupVisible = computed(
    () => {
      var _a2;
      return (_a2 = popupVisible == null ? void 0 : popupVisible.value) != null ? _a2 : _popupVisible.value;
    }
  );
  const handlePopupVisibleChange = (visible) => {
    if (visible !== computedPopupVisible.value) {
      _popupVisible.value = visible;
      emit("update:popupVisible", visible);
      emit("popupVisibleChange", visible);
    }
  };
  watch(computedPopupVisible, (visible) => {
    if (_popupVisible.value !== visible) {
      _popupVisible.value = visible;
    }
  });
  return {
    computedPopupVisible,
    handlePopupVisibleChange
  };
};
const _sfc_main$62 = defineComponent({
  name: "Dropdown",
  components: {
    Trigger,
    DropdownPanel
  },
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    trigger: {
      type: [String, Array],
      default: "click"
    },
    position: {
      type: String,
      default: "bottom"
    },
    popupContainer: {
      type: [String, Object]
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: true
    },
    hideOnSelect: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true,
    "select": (value, ev) => true
  },
  setup(props, { emit }) {
    const { defaultPopupVisible, popupVisible, popupMaxHeight } = toRefs(props);
    const prefixCls = getPrefixCls("dropdown");
    const { computedPopupVisible, handlePopupVisibleChange } = useTrigger({
      defaultPopupVisible,
      popupVisible,
      emit
    });
    const handleOptionClick = (value, ev) => {
      emit("select", value, ev);
      props.hideOnSelect && handlePopupVisibleChange(false);
    };
    provide(
      dropdownInjectionKey,
      reactive({
        popupMaxHeight,
        onOptionClick: handleOptionClick
      })
    );
    return {
      prefixCls,
      computedPopupVisible,
      handlePopupVisibleChange
    };
  }
});
function _sfc_render$61(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_DropdownPanel = resolveComponent("DropdownPanel");
  const _component_Trigger = resolveComponent("Trigger");
  return openBlock(), createBlock(_component_Trigger, {
    "popup-visible": _ctx.computedPopupVisible,
    "animation-name": "slide-dynamic-origin",
    "auto-fit-transform-origin": "",
    trigger: _ctx.trigger,
    position: _ctx.position,
    "popup-offset": 4,
    "popup-container": _ctx.popupContainer,
    "opened-class": `${_ctx.prefixCls}-open`,
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [
      createVNode(_component_DropdownPanel, null, createSlots({
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "content")
        ]),
        _: 2
      }, [
        _ctx.$slots.footer ? {
          name: "footer",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "footer")
          ]),
          key: "0"
        } : void 0
      ]), 1024)
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 8, ["popup-visible", "trigger", "position", "popup-container", "opened-class", "onPopupVisibleChange"]);
}
var _Dropdown = /* @__PURE__ */ _export_sfc(_sfc_main$62, [["render", _sfc_render$61]]);
const _sfc_main$61 = defineComponent({
  name: "Doption",
  props: {
    value: {
      type: [String, Number, Object]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    active: Boolean,
    uninjectContext: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("dropdown-option");
    const liRef = ref();
    const computedValue = computed(
      () => {
        var _a, _b, _c;
        return (_c = (_b = props.value) != null ? _b : (_a = liRef.value) == null ? void 0 : _a.textContent) != null ? _c : void 0;
      }
    );
    const dropdownCtx = !props.uninjectContext ? inject(dropdownInjectionKey, void 0) : void 0;
    const handleClick = (ev) => {
      if (!props.disabled) {
        emit("click", ev);
        dropdownCtx == null ? void 0 : dropdownCtx.onOptionClick(computedValue.value, ev);
      }
    };
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-disabled`]: props.disabled,
        [`${prefixCls}-active`]: props.active
      }
    ]);
    return {
      prefixCls,
      cls,
      liRef,
      handleClick
    };
  }
});
function _sfc_render$60(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    ref: "liRef",
    class: normalizeClass([_ctx.cls, { [`${_ctx.prefixCls}-has-suffix`]: Boolean(_ctx.$slots.suffix) }]),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [
      renderSlot(_ctx.$slots, "icon")
    ], 2)) : createCommentVNode("v-if", true),
    createBaseVNode("span", {
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2),
    _ctx.$slots.suffix ? (openBlock(), createElementBlock("span", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-suffix`)
    }, [
      renderSlot(_ctx.$slots, "suffix")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var Doption = /* @__PURE__ */ _export_sfc(_sfc_main$61, [["render", _sfc_render$60]]);
const _sfc_main$60 = defineComponent({
  name: "Dgroup",
  props: {
    title: String
  },
  setup() {
    const prefixCls = getPrefixCls("dropdown-group");
    return {
      prefixCls
    };
  }
});
function _sfc_render$5$(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock(Fragment, null, [
    createBaseVNode("li", {
      class: normalizeClass(`${_ctx.prefixCls}-title`)
    }, [
      renderSlot(_ctx.$slots, "title", {}, () => [
        createTextVNode(toDisplayString(_ctx.title), 1)
      ])
    ], 2),
    renderSlot(_ctx.$slots, "default")
  ], 64);
}
var Dgroup = /* @__PURE__ */ _export_sfc(_sfc_main$60, [["render", _sfc_render$5$]]);
const _sfc_main$5$ = defineComponent({
  name: "IconRight",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-right`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4B = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5_(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "m16 39.513 15.556-15.557L16 8.4" }, null, -1)
  ]), 14, _hoisted_1$4B);
}
var _IconRight = /* @__PURE__ */ _export_sfc(_sfc_main$5$, [["render", _sfc_render$5_]]);
const IconRight = Object.assign(_IconRight, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconRight.name, _IconRight);
  }
});
const _sfc_main$5_ = defineComponent({
  name: "Dsubmenu",
  components: {
    Trigger,
    DropdownPanel,
    DropdownOption: Doption,
    IconRight
  },
  props: {
    value: {
      type: [String, Number]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    trigger: {
      type: [String, Array],
      default: "click"
    },
    position: {
      type: String,
      default: "rt"
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    optionProps: {
      type: Object
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true
  },
  setup(props, { emit }) {
    const { defaultPopupVisible, popupVisible } = toRefs(props);
    const prefixCls = getPrefixCls("dropdown");
    const { computedPopupVisible, handlePopupVisibleChange } = useTrigger({
      defaultPopupVisible,
      popupVisible,
      emit
    });
    return {
      prefixCls,
      computedPopupVisible,
      handlePopupVisibleChange
    };
  }
});
function _sfc_render$5Z(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconRight = resolveComponent("IconRight");
  const _component_dropdown_option = resolveComponent("dropdown-option");
  const _component_dropdown_panel = resolveComponent("dropdown-panel");
  const _component_Trigger = resolveComponent("Trigger");
  return openBlock(), createBlock(_component_Trigger, {
    "popup-visible": _ctx.computedPopupVisible,
    trigger: _ctx.trigger,
    position: _ctx.position,
    disabled: _ctx.disabled,
    "popup-offset": 4,
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [
      createVNode(_component_dropdown_panel, {
        class: normalizeClass(`${_ctx.prefixCls}-submenu`)
      }, createSlots({
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "content")
        ]),
        _: 2
      }, [
        _ctx.$slots.footer ? {
          name: "footer",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "footer")
          ]),
          key: "0"
        } : void 0
      ]), 1032, ["class"])
    ]),
    default: withCtx(() => [
      createVNode(_component_dropdown_option, mergeProps(_ctx.optionProps, {
        active: _ctx.computedPopupVisible,
        "uninject-context": ""
      }), createSlots({
        suffix: withCtx(() => [
          renderSlot(_ctx.$slots, "suffix", {}, () => [
            createVNode(_component_IconRight)
          ])
        ]),
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 2
      }, [
        _ctx.$slots.icon ? {
          name: "icon",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "icon")
          ]),
          key: "0"
        } : void 0
      ]), 1040, ["active"])
    ]),
    _: 3
  }, 8, ["popup-visible", "trigger", "position", "disabled", "onPopupVisibleChange"]);
}
var Dsubmenu = /* @__PURE__ */ _export_sfc(_sfc_main$5_, [["render", _sfc_render$5Z]]);
const _sfc_main$5Z = defineComponent({
  name: "DropdownButton",
  components: {
    IconMore,
    Button,
    ButtonGroup,
    Dropdown: _Dropdown
  },
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    trigger: {
      type: [String, Array],
      default: "click"
    },
    position: {
      type: String,
      default: "br"
    },
    popupContainer: {
      type: [String, Object]
    },
    disabled: {
      type: Boolean,
      default: false
    },
    type: {
      type: String
    },
    size: {
      type: String
    },
    buttonProps: {
      type: Object
    },
    hideOnSelect: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true,
    "click": (ev) => true,
    "select": (value, ev) => true
  },
  setup(props, { emit }) {
    const { defaultPopupVisible, popupVisible } = toRefs(props);
    const prefixCls = getPrefixCls("dropdown");
    const { computedPopupVisible, handlePopupVisibleChange } = useTrigger({
      defaultPopupVisible,
      popupVisible,
      emit
    });
    const handleClick = (ev) => {
      emit("click", ev);
    };
    const handleSelect = (value, ev) => {
      emit("select", value, ev);
    };
    return {
      prefixCls,
      computedPopupVisible,
      handleClick,
      handleSelect,
      handlePopupVisibleChange
    };
  }
});
function _sfc_render$5Y(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Button = resolveComponent("Button");
  const _component_IconMore = resolveComponent("IconMore");
  const _component_Dropdown = resolveComponent("Dropdown");
  const _component_ButtonGroup = resolveComponent("ButtonGroup");
  return openBlock(), createBlock(_component_ButtonGroup, null, {
    default: withCtx(() => [
      createVNode(_component_Button, mergeProps({
        size: _ctx.size,
        type: _ctx.type,
        disabled: _ctx.disabled
      }, _ctx.buttonProps, { onClick: _ctx.handleClick }), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["size", "type", "disabled", "onClick"]),
      createVNode(_component_Dropdown, {
        "popup-visible": _ctx.computedPopupVisible,
        trigger: _ctx.trigger,
        position: _ctx.position,
        "popup-container": _ctx.popupContainer,
        "hide-on-select": _ctx.hideOnSelect,
        onSelect: _ctx.handleSelect,
        onPopupVisibleChange: _ctx.handlePopupVisibleChange
      }, {
        content: withCtx(() => [
          renderSlot(_ctx.$slots, "content")
        ]),
        default: withCtx(() => [
          createVNode(_component_Button, {
            size: _ctx.size,
            type: _ctx.type,
            disabled: _ctx.disabled
          }, {
            icon: withCtx(() => [
              renderSlot(_ctx.$slots, "icon", { popupVisible: _ctx.computedPopupVisible }, () => [
                createVNode(_component_IconMore)
              ])
            ]),
            _: 3
          }, 8, ["size", "type", "disabled"])
        ]),
        _: 3
      }, 8, ["popup-visible", "trigger", "position", "popup-container", "hide-on-select", "onSelect", "onPopupVisibleChange"])
    ]),
    _: 3
  });
}
var DropdownButton = /* @__PURE__ */ _export_sfc(_sfc_main$5Z, [["render", _sfc_render$5Y]]);
const Dropdown = Object.assign(_Dropdown, {
  Option: Doption,
  Group: Dgroup,
  Submenu: Dsubmenu,
  Button: DropdownButton,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Dropdown.name, _Dropdown);
    app.component(componentPrefix + Doption.name, Doption);
    app.component(componentPrefix + Dgroup.name, Dgroup);
    app.component(componentPrefix + Dsubmenu.name, Dsubmenu);
    app.component(componentPrefix + DropdownButton.name, DropdownButton);
  }
});
var BreadcrumbItem = defineComponent({
  name: "BreadcrumbItem",
  inheritAttrs: false,
  props: {
    separator: {
      type: [String, Number]
    },
    droplist: {
      type: Array
    },
    dropdownProps: {
      type: Object
    },
    index: {
      type: Number,
      default: 0
    }
  },
  setup(props, {
    slots,
    attrs
  }) {
    const prefixCls = getPrefixCls("breadcrumb-item");
    const breadcrumbCtx = inject(breadcrumbInjectKey, void 0);
    const dropdownVisible = ref(false);
    const show = computed(() => {
      if (breadcrumbCtx && breadcrumbCtx.needHide) {
        if (props.index > 1 && props.index <= breadcrumbCtx.total - breadcrumbCtx.maxCount) {
          return false;
        }
      }
      return true;
    });
    const displayMore = computed(() => {
      if (breadcrumbCtx && breadcrumbCtx.needHide) {
        return props.index === 1;
      }
      return false;
    });
    const showSeparator = computed(() => breadcrumbCtx ? props.index < breadcrumbCtx.total - 1 : true);
    const handleVisibleChange = (visible) => {
      dropdownVisible.value = visible;
    };
    const separatorRender = () => {
      var _a, _b, _c, _d, _e, _f, _g;
      if (!showSeparator.value)
        return null;
      const separatorElement = (_g = (_f = (_e = (_b = (_a = slots.separator) == null ? void 0 : _a.call(slots)) != null ? _b : props.separator) != null ? _e : (_d = breadcrumbCtx == null ? void 0 : (_c = breadcrumbCtx.slots).separator) == null ? void 0 : _d.call(_c)) != null ? _f : breadcrumbCtx == null ? void 0 : breadcrumbCtx.separator) != null ? _g : createVNode(IconObliqueLine, null, null);
      return createVNode("div", {
        "aria-hidden": "true",
        "class": `${prefixCls}-separator`
      }, [separatorElement]);
    };
    const renderItem = () => {
      var _a, _b, _c, _d;
      return createVNode("div", mergeProps({
        "role": "listitem",
        "class": [prefixCls, {
          [`${prefixCls}-with-dropdown`]: props.droplist || slots.droplist
        }]
      }, displayMore.value ? {
        "aria-label": "ellipses of breadcrumb items"
      } : void 0, attrs), [displayMore.value ? (_c = (_b = breadcrumbCtx == null ? void 0 : (_a = breadcrumbCtx.slots)["more-icon"]) == null ? void 0 : _b.call(_a)) != null ? _c : createVNode(IconMore, null, null) : (_d = slots.default) == null ? void 0 : _d.call(slots), (props.droplist || slots.droplist) && createVNode("span", {
        "aria-hidden": true,
        "class": [`${prefixCls}-dropdown-icon`, {
          [`${prefixCls}-dropdown-icon-active`]: dropdownVisible.value
        }]
      }, [createVNode(IconDown, null, null)])]);
    };
    const renderDropdownContent = () => {
      var _a, _b, _c;
      return (_c = (_a = slots.droplist) == null ? void 0 : _a.call(slots)) != null ? _c : (_b = props.droplist) == null ? void 0 : _b.map((item) => createVNode(Doption, {
        "value": item.path
      }, {
        default: () => [item.label]
      }));
    };
    const renderDropdown = () => {
      return createVNode(Dropdown, mergeProps({
        "popupVisible": dropdownVisible.value,
        "onPopupVisibleChange": handleVisibleChange
      }, props.dropdownProps), {
        default: () => [renderItem()],
        content: renderDropdownContent
      });
    };
    return () => {
      if (show.value) {
        return createVNode(Fragment, null, [slots.droplist || props.droplist ? renderDropdown() : renderItem(), separatorRender()]);
      }
      return null;
    };
  }
});
var _Breadcrumb = defineComponent({
  name: "Breadcrumb",
  props: {
    maxCount: {
      type: Number,
      default: 0
    },
    routes: {
      type: Array
    },
    separator: {
      type: [String, Number]
    },
    customUrl: {
      type: Function
    }
  },
  setup(props, {
    slots
  }) {
    const {
      maxCount,
      separator,
      routes
    } = toRefs(props);
    const prefixCls = getPrefixCls("breadcrumb");
    const total = ref(0);
    const needHide = computed(() => maxCount.value > 0 && total.value > maxCount.value + 1);
    provide(breadcrumbInjectKey, reactive({
      total,
      maxCount,
      separator,
      needHide,
      slots
    }));
    const defaultItemRender = (route, routes2, paths) => {
      var _a, _b;
      if (routes2.indexOf(route) === routes2.length - 1) {
        return createVNode("span", null, [route.label]);
      }
      const href = (_b = (_a = props.customUrl) == null ? void 0 : _a.call(props, paths)) != null ? _b : `#/${paths.join("/").replace(/^\//, "")}`;
      return createVNode("a", {
        "href": href
      }, [route.label]);
    };
    const renderByRoutes = () => {
      var _a;
      if (!((_a = routes.value) == null ? void 0 : _a.length))
        return null;
      if (total.value !== routes.value.length) {
        total.value = routes.value.length;
      }
      const paths = [];
      return routes.value.map((route, idx, origin) => {
        paths.push((route.path || "").replace(/^\//, ""));
        const currentPaths = [...paths];
        return createVNode(BreadcrumbItem, {
          "key": route.path || route.label,
          "index": idx,
          "droplist": route.children
        }, {
          default: () => {
            var _a2, _b;
            return [(_b = (_a2 = slots["item-render"]) == null ? void 0 : _a2.call(slots, {
              route,
              routes: origin,
              paths: currentPaths
            })) != null ? _b : defaultItemRender(route, origin, currentPaths)];
          }
        });
      });
    };
    const renderByChildren = () => {
      var _a, _b;
      const children = getAllElements((_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _b : []);
      if (total.value !== children.length) {
        total.value = children.length;
      }
      return children.map((child, index2) => {
        var _a2;
        child.props = mergeProps((_a2 = child.props) != null ? _a2 : {}, {
          index: index2
        });
        return child;
      });
    };
    return () => {
      return createVNode("div", {
        "role": "list",
        "class": prefixCls
      }, [slots.default ? renderByChildren() : renderByRoutes()]);
    };
  }
});
const Breadcrumb = Object.assign(_Breadcrumb, {
  Item: BreadcrumbItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Breadcrumb.name, _Breadcrumb);
    app.component(componentPrefix + BreadcrumbItem.name, BreadcrumbItem);
  }
});
const overwriteIsDayjs = (_, Dayjs2, dayjs2) => {
  dayjs2 = function(date, c) {
    if (isDayjs(date)) {
      return date.clone();
    }
    const cfg = typeof c === "object" ? c : {};
    cfg.date = date;
    cfg.args = arguments;
    return new Dayjs2(cfg);
  };
  const proto = Dayjs2.prototype;
  const old$Utils = proto.$utils;
  proto.$utils = () => {
    const newUtils = old$Utils();
    newUtils.i = isDayjs;
    return newUtils;
  };
  dayjs2.isDayjs = isDayjs;
};
dayjs$1.extend(overwriteIsDayjs);
dayjs$1.extend(customParseFormat);
dayjs$1.extend(isBetween);
dayjs$1.extend(weekOfYear);
dayjs$1.extend(AdvancedFormat);
dayjs$1.extend(weekYear);
dayjs$1.extend(QuarterOfYear);
const dayjs = dayjs$1;
const methods = {
  add(time, value, unit) {
    return time.add(value, unit);
  },
  subtract(time, value, unit) {
    return time.subtract(value, unit);
  },
  startOf(time, unit) {
    return time.startOf(unit);
  },
  startOfWeek(time, weekStart) {
    const currentDay = time.day();
    let startOfWeek = time.subtract(currentDay - weekStart, "day");
    if (startOfWeek.isAfter(time)) {
      startOfWeek = startOfWeek.subtract(7, "day");
    }
    return startOfWeek;
  },
  endOf(time, unit) {
    return time.endOf(unit);
  },
  set(time, unit, value) {
    return time.set(unit, value);
  },
  isSameWeek(date1, date2, weekStart) {
    const getWeek = (date) => {
      const day = date.day();
      const diff = day - weekStart + (day < weekStart ? 7 : 0);
      return date.subtract(diff, "day").week();
    };
    return getWeek(date1) === getWeek(date2);
  }
};
function getNow() {
  return dayjs();
}
function getSortedDayjsArray(values) {
  return [...values].sort((a, b) => a.valueOf() - b.valueOf());
}
function isValueChange(prevValue, currentValue) {
  const isDifference = (value1, value2) => {
    if (value1 === void 0 && value2 === void 0) {
      return false;
    }
    if (value1 && !value2 || !value1 && value2) {
      return true;
    }
    return (value1 == null ? void 0 : value1.valueOf()) !== (value2 == null ? void 0 : value2.valueOf());
  };
  if (currentValue === void 0 && prevValue === void 0) {
    return false;
  }
  if (isArray(currentValue) && isArray(prevValue)) {
    return isDifference(currentValue[0], prevValue[0]) || isDifference(currentValue[1], prevValue[1]);
  }
  if (!isArray(currentValue) && !isArray(prevValue)) {
    return isDifference(currentValue, prevValue);
  }
  return true;
}
function getDayjsValue(time, format) {
  const parseQuarterToMonth = (value) => {
    const reg = /(Q1)|(Q2)|(Q3)|(Q4)/;
    const quarter = {
      Q1: "01",
      Q2: "04",
      Q3: "07",
      Q4: "10"
    };
    const [q] = reg.exec(value);
    return value.replace(reg, quarter[q]);
  };
  const formatValue = (value) => {
    if (!value)
      return void 0;
    if (typeof value === "string") {
      if (isQuarter(format)) {
        return dayjs(parseQuarterToMonth(value), format.replace(/\[Q]Q/, "MM"));
      }
      if (dayjs(value, format).isValid()) {
        return dayjs(value, format);
      }
    }
    return dayjs(value);
  };
  if (isArray(time)) {
    return time.map(formatValue);
  }
  return formatValue(time);
}
function getDateValue$1(value) {
  const formatValue = (t) => t ? t.toDate() : void 0;
  if (isArray(value)) {
    return value.map(formatValue);
  }
  return formatValue(value);
}
function initializeDateLocale(localeName, weekStart) {
  dayjs.locale({ ...dayjs.Ls[localeName.toLocaleLowerCase()], weekStart });
}
function pickDataAttributes(obj) {
  const clone = {};
  obj && Object.keys(obj).forEach((key) => {
    const k = String(key);
    if (k.indexOf("data-") === 0) {
      clone[k] = obj[k];
    }
    if (k.indexOf("aria-") === 0) {
      clone[k] = obj[k];
    }
  });
  return clone;
}
function padStart(string, length, char = " ") {
  const s = String(string);
  if (!length) {
    return s;
  }
  const newString = s.length < length ? `${char}${s}` : s;
  return newString.length < length ? padStart(newString, length, char) : newString;
}
var Week = defineComponent({
  name: "Week",
  props: {
    mode: {
      type: String
    },
    dayStartOfWeek: {
      type: Number
    },
    isWeek: {
      type: Boolean
    },
    panel: {
      type: Boolean
    },
    value: {
      type: Object,
      required: true
    },
    selectHandler: {
      type: Function
    },
    pageShowData: {
      type: Object,
      required: true
    },
    pageData: {
      type: Array
    }
  },
  setup(props) {
    const {
      dayStartOfWeek,
      isWeek,
      panel,
      mode
    } = toRefs(props);
    const prefixCls = getPrefixCls("calendar-week-list");
    const {
      t
    } = useI18n();
    const weekList = ["monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];
    if (dayStartOfWeek.value === 0) {
      weekList.unshift("sunday");
    } else {
      weekList.push("sunday");
    }
    if (isWeek.value) {
      weekList.unshift("self");
    }
    return () => createVNode("div", {
      "class": prefixCls
    }, [weekList.map((w) => createVNode("div", {
      "class": `${prefixCls}-item`,
      "key": w
    }, [t(`calendar.week.${panel.value || mode.value === "year" ? "short" : "long"}.${w}`)]))]);
  }
});
function getDateValue(date, index2) {
  if (!date) {
    return void 0;
  }
  if (isArray(date)) {
    return date[index2];
  }
  return void 0;
}
function useClassName({
  prefixCls,
  mergedValue,
  rangeValues,
  hoverRangeValues,
  panel,
  isSameTime,
  innerMode
}) {
  function isInRange(current, startDate, endDate) {
    if (!startDate || !endDate) {
      return false;
    }
    return isSameTime(current, startDate) || isSameTime(current, endDate) || current.isBetween(startDate, endDate, null, "[]");
  }
  return function getCellClassName(cellDateObj, disabled) {
    const rangeStart = getDateValue(rangeValues, 0);
    const rangeEnd = getDateValue(rangeValues, 1);
    const hoverRangeStart = getDateValue(hoverRangeValues, 0);
    const hoverRangeEnd = getDateValue(hoverRangeValues, 1);
    const isInView = !cellDateObj.isPrev && !cellDateObj.isNext;
    const rangeAvailable = isInView && panel;
    const isRangeStart = rangeAvailable && rangeStart && isSameTime(cellDateObj.time, rangeStart);
    const isRangeEnd = rangeAvailable && rangeEnd && isSameTime(cellDateObj.time, rangeEnd);
    const nearRangeStart = hoverRangeStart && rangeStart && hoverRangeStart.isBefore(rangeStart);
    const nearRangeEnd = rangeEnd && hoverRangeEnd && hoverRangeEnd.isAfter(rangeEnd);
    const isHoverNearRange = nearRangeStart && isRangeStart || nearRangeEnd && isRangeEnd;
    let isToday = isSameTime(cellDateObj.time, getNow());
    if (!panel && innerMode === "year") {
      isToday = getNow().isSame(cellDateObj.time, "date");
    }
    return [
      `${prefixCls}-cell`,
      {
        [`${prefixCls}-cell-in-view`]: isInView,
        [`${prefixCls}-cell-today`]: isToday,
        [`${prefixCls}-cell-selected`]: mergedValue && isSameTime(cellDateObj.time, mergedValue),
        [`${prefixCls}-cell-range-start`]: isRangeStart,
        [`${prefixCls}-cell-range-end`]: isRangeEnd,
        [`${prefixCls}-cell-in-range`]: rangeAvailable && isInRange(cellDateObj.time, rangeStart, rangeEnd),
        [`${prefixCls}-cell-in-range-near-hover`]: isHoverNearRange,
        [`${prefixCls}-cell-hover-range-start`]: rangeAvailable && hoverRangeStart && isSameTime(cellDateObj.time, hoverRangeStart),
        [`${prefixCls}-cell-hover-range-end`]: rangeAvailable && hoverRangeEnd && isSameTime(cellDateObj.time, hoverRangeEnd),
        [`${prefixCls}-cell-hover-in-range`]: rangeAvailable && isInRange(cellDateObj.time, hoverRangeStart, hoverRangeEnd),
        [`${prefixCls}-cell-disabled`]: disabled
      }
    ];
  };
}
const allDaysInOnePage = 6 * 7;
const getReturn = (time) => {
  return {
    year: time.year(),
    month: time.month() + 1,
    date: time.date(),
    day: time.day(),
    time
  };
};
const getTimeObj = (time) => {
  return {
    start: getReturn(methods.startOf(time, "month")),
    end: getReturn(methods.endOf(time, "month")),
    days: time.daysInMonth()
  };
};
function getAllDaysByTime(time, {
  dayStartOfWeek = 0,
  isWeek
}) {
  const current = getTimeObj(time);
  const flatRows = Array(allDaysInOnePage).fill(null).map(() => ({}));
  const startIndex = dayStartOfWeek === 0 ? current.start.day : (current.start.day || 7) - 1;
  flatRows[startIndex] = {
    ...current.start,
    isCurrent: true
  };
  for (let i2 = 0; i2 < startIndex; i2++) {
    flatRows[startIndex - i2 - 1] = {
      ...getReturn(methods.subtract(current.start.time, i2 + 1, "day")),
      isPrev: true
    };
  }
  for (let i2 = 0; i2 < allDaysInOnePage - startIndex - 1; i2++) {
    flatRows[startIndex + i2 + 1] = {
      ...getReturn(methods.add(current.start.time, i2 + 1, "day")),
      isCurrent: i2 < current.days,
      isNext: i2 >= current.days - 1
    };
  }
  const rows = Array(6).fill(null).map(() => []);
  for (let i2 = 0; i2 < 6; i2++) {
    rows[i2] = flatRows.slice(i2 * 7, 7 * (i2 + 1));
    if (isWeek) {
      const weekTime = rows[i2][0].time;
      const weekRows = [...rows[i2]];
      rows[i2].unshift({
        weekRows,
        weekOfYear: weekTime.week()
      });
    }
  }
  return rows;
}
var Month = defineComponent({
  name: "Month",
  props: {
    cell: {
      type: Boolean
    },
    pageData: {
      type: Array
    },
    current: {
      type: Number
    },
    value: {
      type: Object,
      required: true
    },
    selectHandler: {
      type: Function,
      required: true
    },
    mode: {
      type: String
    },
    pageShowDate: {
      type: Object,
      required: true
    },
    panel: {
      type: Boolean
    },
    dayStartOfWeek: {
      type: Number,
      required: true
    },
    isWeek: {
      type: Boolean,
      required: true
    }
  },
  setup(props, {
    slots
  }) {
    const {
      pageData
    } = toRefs(props);
    const prefixCls = getPrefixCls("calendar");
    const pageShowDateYear = props.pageShowDate.year();
    const getCellClassName = computed(() => useClassName({
      prefixCls,
      mergedValue: props.value,
      panel: false,
      innerMode: props.mode,
      rangeValues: [],
      hoverRangeValues: [],
      isSameTime: (current, target2) => current.isSame(target2, "day")
    }));
    function renderDays(row) {
      return row.map((col, index2) => {
        var _a;
        if (col.time) {
          const onClickHandler = () => props.selectHandler(col.time, false);
          const tdProps = props.isWeek ? {
            onClick: onClickHandler
          } : {};
          const tdDivProps = !props.isWeek ? {
            onClick: onClickHandler
          } : {};
          return createVNode("div", mergeProps({
            "key": index2,
            "class": getCellClassName.value(col, false)
          }, tdProps), [slots.default ? (_a = slots.default) == null ? void 0 : _a.call(slots, {
            year: col.year,
            month: col.month,
            date: col.date
          }) : createVNode("div", mergeProps({
            "class": `${prefixCls}-date`
          }, tdDivProps), [createVNode("div", {
            "class": `${prefixCls}-date-value`
          }, [props.panel ? col.date : createVNode("div", {
            "class": `${prefixCls}-date-circle`
          }, [col.date])])])]);
        }
        if ("weekOfYear" in col) {
          const rowYear = props.value.year();
          const rowMonth = props.value.month() + 1;
          const rowWeek = props.value.week();
          const selectedWeek = props.value && col.weekRows.find((r) => r.year === rowYear && r.month === rowMonth) && rowWeek === col.weekOfYear;
          return createVNode("div", {
            "key": index2,
            "class": [`${prefixCls}-cell`, `${prefixCls}-cell-week`, {
              [`${prefixCls}-cell-selected-week`]: selectedWeek,
              [`${prefixCls}-cell-in-range`]: selectedWeek
            }]
          }, [createVNode("div", {
            "class": `${prefixCls}-date`
          }, [createVNode("div", {
            "class": `${prefixCls}-date-value`
          }, [col.weekOfYear])])]);
        }
        return null;
      });
    }
    let pd = pageData.value;
    if (typeof props.current === "number") {
      pd = getAllDaysByTime(dayjs(`${pageShowDateYear}-${padStart(props.current + 1, 2, "0")}-01`), {
        dayStartOfWeek: props.dayStartOfWeek,
        isWeek: props.isWeek
      });
    }
    return () => createVNode("div", {
      "class": props.cell ? `${prefixCls}-month-cell` : `${prefixCls}-month`
    }, [createVNode(Week, {
      "value": props.value,
      "selectHandler": props.selectHandler,
      "dayStartOfWeek": props.dayStartOfWeek,
      "isWeek": props.isWeek,
      "panel": props.panel,
      "mode": props.mode,
      "pageShowData": props.pageShowDate,
      "pageData": props.pageData
    }, null), createVNode("div", {
      "class": `${prefixCls}-month-cell-body`
    }, [pd == null ? void 0 : pd.map((row, index2) => createVNode("div", {
      "key": index2,
      "class": [`${prefixCls}-month-row`, {
        [`${prefixCls}-row-week`]: props.isWeek
      }]
    }, [renderDays(row)]))])]);
  }
});
const MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"].map((month, index2) => {
  return {
    name: month,
    value: index2
  };
});
const monthGroup = Array(3);
for (let i2 = 0; i2 < 3; i2++) {
  monthGroup[i2] = MONTHS.slice(i2 * 4, 4 * (i2 + 1));
}
const monthGroupPanel = Array(4);
for (let i2 = 0; i2 < 4; i2++) {
  monthGroupPanel[i2] = MONTHS.slice(i2 * 3, 3 * (i2 + 1));
}
var Year = defineComponent({
  name: "Year",
  props: {
    mode: {
      type: String,
      required: true
    },
    dayStartOfWeek: {
      type: Number,
      required: true
    },
    value: {
      type: Object,
      required: true
    },
    isWeek: {
      type: Boolean
    },
    panel: {
      type: Boolean,
      default: false
    },
    pageShowData: {
      type: Object,
      required: true
    },
    pageData: {
      type: Array
    },
    selectHandler: {
      type: Function,
      required: true
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("calendar");
    const getCellClassName = computed(() => useClassName({
      prefixCls,
      mergedValue: props.value,
      panel: false,
      innerMode: props.mode,
      rangeValues: [],
      hoverRangeValues: [],
      isSameTime: (current, target2) => current.isSame(target2, "month")
    }));
    const {
      t
    } = useI18n();
    const showYear = computed(() => props.pageShowData.year());
    const mg = props.panel ? monthGroupPanel : monthGroup;
    return () => createVNode("div", {
      "class": `${prefixCls}-year`
    }, [mg.map((row, rowIndex) => createVNode("div", {
      "class": `${prefixCls}-year-row`,
      "key": rowIndex
    }, [row.map((col) => {
      const time = dayjs(`${showYear.value}-${padStart(col.value + 1, 2, "0")}-01`);
      const divProps = props.panel ? {
        onClick: () => props.selectHandler(time, false)
      } : {};
      return createVNode("div", {
        "key": col.value,
        "class": getCellClassName.value({
          ...col,
          time
        }, false)
      }, [props.panel ? createVNode("div", mergeProps({
        "class": `${prefixCls}-date`
      }, divProps), [createVNode("div", {
        "class": `${prefixCls}-date-value`
      }, [t(`calendar.month.short.${col.name}`)])]) : createVNode("div", {
        "class": `${prefixCls}-month-with-days`
      }, [createVNode("div", {
        "class": `${prefixCls}-month-title`
      }, [t(`calendar.month.long.${col.name}`)]), createVNode(Month, {
        "pageShowDate": props.pageShowData,
        "pageData": props.pageData,
        "dayStartOfWeek": props.dayStartOfWeek,
        "selectHandler": props.selectHandler,
        "isWeek": props.isWeek,
        "cell": true,
        "current": col.value,
        "value": props.value,
        "mode": props.mode
      }, null)])]);
    })]))]);
  }
});
const useInput = ({
  defaultValue,
  modelValue,
  emit,
  eventName = "input",
  updateEventName = "update:modelValue",
  eventHandlers
}) => {
  var _a;
  const inputRef = ref();
  const _value = ref((_a = defaultValue == null ? void 0 : defaultValue.value) != null ? _a : "");
  const _focused = ref(false);
  const isComposition = ref(false);
  const compositionValue = ref("");
  let initialValue;
  const computedValue = computed(() => {
    var _a2;
    return (_a2 = modelValue == null ? void 0 : modelValue.value) != null ? _a2 : _value.value;
  });
  const updateValue = (value, ev) => {
    _value.value = value;
    emit(updateEventName, value);
    emit(eventName, value, ev);
  };
  const handleInput = (ev) => {
    const { value } = ev.target;
    if (!isComposition.value) {
      updateValue(value, ev);
      nextTick(() => {
        if (inputRef.value && computedValue.value !== inputRef.value.value) {
          inputRef.value.value = computedValue.value;
        }
      });
    }
  };
  const handleChange = (ev) => {
    if (eventName === "input" && computedValue.value !== initialValue) {
      initialValue = computedValue.value;
      emit("change", computedValue.value, ev);
    }
  };
  const handleComposition = (ev) => {
    var _a2;
    const { value } = ev.target;
    if (ev.type === "compositionend") {
      isComposition.value = false;
      compositionValue.value = "";
      updateValue(value, ev);
      nextTick(() => {
        if (inputRef.value && computedValue.value !== inputRef.value.value) {
          inputRef.value.value = computedValue.value;
        }
      });
    } else {
      isComposition.value = true;
      compositionValue.value = computedValue.value + ((_a2 = ev.data) != null ? _a2 : "");
    }
  };
  const handleFocus = (ev) => {
    var _a2, _b;
    _focused.value = true;
    initialValue = computedValue.value;
    emit("focus", ev);
    (_b = (_a2 = eventHandlers == null ? void 0 : eventHandlers.value) == null ? void 0 : _a2.onFocus) == null ? void 0 : _b.call(_a2, ev);
  };
  const handleBlur = (ev) => {
    var _a2, _b;
    _focused.value = false;
    emit("blur", ev);
    (_b = (_a2 = eventHandlers == null ? void 0 : eventHandlers.value) == null ? void 0 : _a2.onBlur) == null ? void 0 : _b.call(_a2, ev);
    handleChange(ev);
  };
  const handleKeyDown = (ev) => {
    const keyCode = ev.key || ev.code;
    if (!isComposition.value && keyCode === Enter.key) {
      emit("pressEnter", ev);
      handleChange(ev);
    }
  };
  const handleMousedown = (ev) => {
    if (inputRef.value && ev.target !== inputRef.value) {
      ev.preventDefault();
      inputRef.value.focus();
    }
  };
  watch(computedValue, (value) => {
    if (inputRef.value && value !== inputRef.value.value) {
      inputRef.value.value = value;
    }
  });
  return {
    inputRef,
    _value,
    _focused,
    isComposition,
    compositionValue,
    computedValue,
    handleInput,
    handleComposition,
    handleFocus,
    handleBlur,
    handleKeyDown,
    handleMousedown
  };
};
var InputLabel = defineComponent({
  name: "InputLabel",
  inheritAttrs: false,
  props: {
    modelValue: Object,
    inputValue: {
      type: String,
      default: ""
    },
    enabledInput: Boolean,
    formatLabel: Function,
    placeholder: String,
    retainInputValue: Boolean,
    disabled: Boolean,
    baseCls: String,
    size: String,
    error: Boolean,
    focused: Boolean,
    uninjectFormItemContext: Boolean
  },
  emits: ["update:inputValue", "inputValueChange", "focus", "blur"],
  setup(props, {
    attrs,
    emit,
    slots
  }) {
    var _a;
    const {
      size,
      disabled,
      error,
      inputValue,
      uninjectFormItemContext
    } = toRefs(props);
    const prefixCls = (_a = props.baseCls) != null ? _a : getPrefixCls("input-label");
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError,
      eventHandlers
    } = useFormItem({
      size,
      disabled,
      error,
      uninject: uninjectFormItemContext == null ? void 0 : uninjectFormItemContext.value
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const {
      inputRef,
      _focused,
      computedValue: computedInputValue,
      handleInput,
      handleComposition,
      handleFocus,
      handleBlur,
      handleMousedown
    } = useInput({
      modelValue: inputValue,
      emit,
      eventName: "inputValueChange",
      updateEventName: "update:inputValue",
      eventHandlers
    });
    const mergedFocused = computed(() => {
      var _a2;
      return (_a2 = props.focused) != null ? _a2 : _focused.value;
    });
    const showInput = computed(() => props.enabledInput && _focused.value || !props.modelValue);
    const formatLabel = () => {
      var _a2, _b;
      if (props.modelValue) {
        return (_b = (_a2 = props.formatLabel) == null ? void 0 : _a2.call(props, props.modelValue)) != null ? _b : props.modelValue.label;
      }
      return "";
    };
    const mergedPlaceholder = computed(() => {
      if (props.enabledInput && props.modelValue) {
        return formatLabel();
      }
      return props.placeholder;
    });
    const renderLabel = () => {
      var _a2, _b;
      if (props.modelValue) {
        return (_b = (_a2 = slots.default) == null ? void 0 : _a2.call(slots, {
          data: props.modelValue
        })) != null ? _b : formatLabel();
      }
      return null;
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-search`]: props.enabledInput,
      [`${prefixCls}-focus`]: mergedFocused.value,
      [`${prefixCls}-disabled`]: mergedDisabled.value,
      [`${prefixCls}-error`]: mergedError.value
    }]);
    const wrapperAttrs = computed(() => omit(attrs, INPUT_EVENTS));
    const inputAttrs = computed(() => pick(attrs, INPUT_EVENTS));
    const render2 = () => createVNode("span", mergeProps(wrapperAttrs.value, {
      "class": cls.value,
      "title": formatLabel(),
      "onMousedown": handleMousedown
    }), [slots.prefix && createVNode("span", {
      "class": `${prefixCls}-prefix`
    }, [slots.prefix()]), createVNode("input", mergeProps(inputAttrs.value, {
      "ref": inputRef,
      "class": [`${prefixCls}-input`, {
        [`${prefixCls}-input-hidden`]: !showInput.value
      }],
      "value": computedInputValue.value,
      "readonly": !props.enabledInput,
      "placeholder": mergedPlaceholder.value,
      "disabled": mergedDisabled.value,
      "onInput": handleInput,
      "onFocus": handleFocus,
      "onBlur": handleBlur,
      "onCompositionstart": handleComposition,
      "onCompositionupdate": handleComposition,
      "onCompositionend": handleComposition
    }), null), createVNode("span", {
      "class": [`${prefixCls}-value`, {
        [`${prefixCls}-value-hidden`]: showInput.value
      }]
    }, [renderLabel()]), slots.suffix && createVNode("span", {
      "class": `${prefixCls}-suffix`
    }, [slots.suffix()])]);
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const getValueData = (value, fieldNames) => {
  const result = [];
  for (const item of value) {
    if (isObject(item)) {
      result.push({
        raw: item,
        value: item[fieldNames.value],
        label: item[fieldNames.label],
        closable: item[fieldNames.closable],
        tagProps: item[fieldNames.tagProps]
      });
    } else if (value || isNumber(value)) {
      const raw = {
        value: item,
        label: String(item),
        closable: true
      };
      result.push({
        raw,
        ...raw
      });
    }
  }
  return result;
};
const TAG_COLORS = [
  "red",
  "orangered",
  "orange",
  "gold",
  "lime",
  "green",
  "cyan",
  "blue",
  "arcoblue",
  "purple",
  "pinkpurple",
  "magenta",
  "gray"
];
const _sfc_main$5Y = defineComponent({
  name: "Tag",
  components: {
    IconHover,
    IconClose,
    IconLoading
  },
  props: {
    color: {
      type: String
    },
    size: {
      type: String
    },
    bordered: {
      type: Boolean,
      default: false
    },
    visible: {
      type: Boolean,
      default: void 0
    },
    defaultVisible: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    closable: {
      type: Boolean,
      default: false
    },
    checkable: {
      type: Boolean,
      default: false
    },
    checked: {
      type: Boolean,
      default: void 0
    },
    defaultChecked: {
      type: Boolean,
      default: true
    },
    nowrap: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:visible": (visible) => true,
    "update:checked": (checked) => true,
    "close": (ev) => true,
    "check": (checked, ev) => true
  },
  setup(props, { emit }) {
    const { size } = toRefs(props);
    const prefixCls = getPrefixCls("tag");
    const isBuiltInColor = computed(
      () => props.color && TAG_COLORS.includes(props.color)
    );
    const isCustomColor = computed(
      () => props.color && !TAG_COLORS.includes(props.color)
    );
    const _visible = ref(props.defaultVisible);
    const _checked = ref(props.defaultChecked);
    const computedVisible = computed(() => {
      var _a;
      return (_a = props.visible) != null ? _a : _visible.value;
    });
    const computedChecked = computed(
      () => {
        var _a;
        return props.checkable ? (_a = props.checked) != null ? _a : _checked.value : true;
      }
    );
    const { mergedSize: _mergedSize } = useSize$1(size);
    const mergedSize = computed(() => {
      if (_mergedSize.value === "mini") {
        return "small";
      }
      return _mergedSize.value;
    });
    const handleClose = (ev) => {
      _visible.value = false;
      emit("update:visible", false);
      emit("close", ev);
    };
    const handleClick = (ev) => {
      if (props.checkable) {
        const newChecked = !computedChecked.value;
        _checked.value = newChecked;
        emit("update:checked", newChecked);
        emit("check", newChecked, ev);
      }
    };
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-size-${mergedSize.value}`,
      {
        [`${prefixCls}-loading`]: props.loading,
        [`${prefixCls}-hide`]: !computedVisible.value,
        [`${prefixCls}-${props.color}`]: isBuiltInColor.value,
        [`${prefixCls}-bordered`]: props.bordered,
        [`${prefixCls}-checkable`]: props.checkable,
        [`${prefixCls}-checked`]: computedChecked.value,
        [`${prefixCls}-custom-color`]: isCustomColor.value
      }
    ]);
    const style = computed(() => {
      if (isCustomColor.value) {
        return {
          backgroundColor: props.color
        };
      }
      return void 0;
    });
    return {
      prefixCls,
      cls,
      style,
      computedVisible,
      computedChecked,
      handleClick,
      handleClose
    };
  }
});
function _sfc_render$5X(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  const _component_icon_loading = resolveComponent("icon-loading");
  return _ctx.computedVisible ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.style),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    _ctx.$slots.icon ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [
      renderSlot(_ctx.$slots, "icon")
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.nowrap ? (openBlock(), createElementBlock("span", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-text`)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)) : renderSlot(_ctx.$slots, "default", { key: 2 }),
    _ctx.closable ? (openBlock(), createBlock(_component_icon_hover, {
      key: 3,
      role: "button",
      "aria-label": "Close",
      prefix: _ctx.prefixCls,
      class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
      onClick: withModifiers(_ctx.handleClose, ["stop"])
    }, {
      default: withCtx(() => [
        renderSlot(_ctx.$slots, "close-icon", {}, () => [
          createVNode(_component_icon_close)
        ])
      ]),
      _: 3
    }, 8, ["prefix", "class", "onClick"])) : createCommentVNode("v-if", true),
    _ctx.loading ? (openBlock(), createElementBlock("span", {
      key: 4,
      class: normalizeClass(`${_ctx.prefixCls}-loading-icon`)
    }, [
      createVNode(_component_icon_loading)
    ], 2)) : createCommentVNode("v-if", true)
  ], 6)) : createCommentVNode("v-if", true);
}
var _Tag = /* @__PURE__ */ _export_sfc(_sfc_main$5Y, [["render", _sfc_render$5X]]);
const Tag = Object.assign(_Tag, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Tag.name, _Tag);
  }
});
const DEFAULT_FIELD_NAMES$1 = {
  value: "value",
  label: "label",
  closable: "closable",
  tagProps: "tagProps"
};
var _InputTag = defineComponent({
  name: "InputTag",
  inheritAttrs: false,
  props: {
    modelValue: {
      type: Array
    },
    defaultValue: {
      type: Array,
      default: () => []
    },
    inputValue: String,
    defaultInputValue: {
      type: String,
      default: ""
    },
    placeholder: String,
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    retainInputValue: {
      type: [Boolean, Object],
      default: false
    },
    formatTag: {
      type: Function
    },
    uniqueValue: {
      type: Boolean,
      default: false
    },
    fieldNames: {
      type: Object
    },
    tagNowrap: {
      type: Boolean,
      default: false
    },
    baseCls: String,
    focused: Boolean,
    disabledInput: Boolean,
    uninjectFormItemContext: Boolean
  },
  emits: {
    "update:modelValue": (value) => true,
    "update:inputValue": (inputValue) => true,
    "change": (value, ev) => true,
    "inputValueChange": (inputValue, ev) => true,
    "pressEnter": (inputValue, ev) => true,
    "remove": (removed, ev) => true,
    "clear": (ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, {
    emit,
    slots,
    attrs
  }) {
    const {
      size,
      disabled,
      error,
      uninjectFormItemContext,
      modelValue
    } = toRefs(props);
    const prefixCls = props.baseCls || getPrefixCls("input-tag");
    const inputRef = ref();
    const mirrorRef = ref();
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError,
      feedback,
      eventHandlers
    } = useFormItem({
      size,
      disabled,
      error,
      uninject: uninjectFormItemContext == null ? void 0 : uninjectFormItemContext.value
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const mergedFieldNames = computed(() => ({
      ...DEFAULT_FIELD_NAMES$1,
      ...props.fieldNames
    }));
    const _focused = ref(false);
    const _value = ref(props.defaultValue);
    const _inputValue = ref(props.defaultInputValue);
    const isComposition = ref(false);
    const compositionValue = ref("");
    const retainInputValue = computed(() => {
      if (isObject(props.retainInputValue)) {
        return {
          create: false,
          blur: false,
          ...props.retainInputValue
        };
      }
      return {
        create: props.retainInputValue,
        blur: props.retainInputValue
      };
    });
    const inputStyle = reactive({
      width: "12px"
    });
    const mergedFocused = computed(() => props.focused || _focused.value);
    const updateInputValue = (value, ev) => {
      _inputValue.value = value;
      emit("update:inputValue", value);
      emit("inputValueChange", value, ev);
    };
    const handleComposition = (ev) => {
      var _a;
      const {
        value
      } = ev.target;
      if (ev.type === "compositionend") {
        isComposition.value = false;
        compositionValue.value = "";
        updateInputValue(value, ev);
        nextTick(() => {
          if (inputRef.value && computedInputValue.value !== inputRef.value.value) {
            inputRef.value.value = computedInputValue.value;
          }
        });
      } else {
        isComposition.value = true;
        compositionValue.value = computedInputValue.value + ((_a = ev.data) != null ? _a : "");
      }
    };
    const computedValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : _value.value;
    });
    const computedInputValue = computed(() => {
      var _a;
      return (_a = props.inputValue) != null ? _a : _inputValue.value;
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = [];
      }
    });
    const handleMousedown = (e) => {
      if (inputRef.value && e.target !== inputRef.value) {
        e.preventDefault();
        inputRef.value.focus();
      }
    };
    const handleInput = (ev) => {
      const {
        value
      } = ev.target;
      if (!isComposition.value) {
        updateInputValue(value, ev);
        nextTick(() => {
          if (inputRef.value && computedInputValue.value !== inputRef.value.value) {
            inputRef.value.value = computedInputValue.value;
          }
        });
      }
    };
    const valueData = computed(() => getValueData(computedValue.value, mergedFieldNames.value));
    const tags = computed(() => {
      if (props.maxTagCount > 0) {
        const invisibleTags = valueData.value.length - props.maxTagCount;
        if (invisibleTags > 0) {
          const result = valueData.value.slice(0, props.maxTagCount);
          const raw = {
            value: "__arco__more",
            label: `+${invisibleTags}...`,
            closable: false
          };
          result.push({
            raw,
            ...raw
          });
          return result;
        }
      }
      return valueData.value;
    });
    const updateValue = (value, ev) => {
      var _a, _b;
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value, ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a, ev);
    };
    const handleRemove = (value, index2, e) => {
      var _a;
      const newValue = (_a = computedValue.value) == null ? void 0 : _a.filter((_, i2) => i2 !== index2);
      updateValue(newValue, e);
      emit("remove", value, e);
    };
    const handleClear = (e) => {
      const newValue = [];
      updateValue(newValue, e);
      emit("clear", e);
    };
    const showClearBtn = computed(() => !mergedDisabled.value && !props.readonly && props.allowClear && Boolean(computedValue.value.length));
    const handlePressEnter = (e) => {
      var _a;
      if (computedInputValue.value) {
        e.preventDefault();
        if (props.uniqueValue && ((_a = computedValue.value) == null ? void 0 : _a.includes(computedInputValue.value))) {
          emit("pressEnter", computedInputValue.value, e);
          return;
        }
        const newValue = computedValue.value.concat(computedInputValue.value);
        updateValue(newValue, e);
        emit("pressEnter", computedInputValue.value, e);
        if (!retainInputValue.value.create) {
          updateInputValue("", e);
        }
      }
    };
    const handleFocus = (ev) => {
      var _a, _b;
      _focused.value = true;
      emit("focus", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onFocus) == null ? void 0 : _b.call(_a, ev);
    };
    const handleBlur = (ev) => {
      var _a, _b;
      _focused.value = false;
      if (!retainInputValue.value.blur && computedInputValue.value) {
        updateInputValue("", ev);
      }
      emit("blur", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a, ev);
    };
    const getLastClosableIndex = () => {
      for (let i2 = valueData.value.length - 1; i2 >= 0; i2--) {
        if (valueData.value[i2].closable) {
          return i2;
        }
      }
      return -1;
    };
    const handleKeyDown = (e) => {
      if (mergedDisabled.value || props.readonly) {
        return;
      }
      const keyCode = e.key || e.code;
      if (!isComposition.value && computedInputValue.value && keyCode === Enter.key) {
        handlePressEnter(e);
      }
      if (!isComposition.value && tags.value.length > 0 && !computedInputValue.value && keyCode === Backspace.key) {
        const lastIndex = getLastClosableIndex();
        if (lastIndex >= 0) {
          handleRemove(valueData.value[lastIndex].value, lastIndex, e);
        }
      }
    };
    const setInputWidth = (width) => {
      if (width > 12) {
        inputStyle.width = `${width}px`;
      } else {
        inputStyle.width = "12px";
      }
    };
    onMounted(() => {
      if (mirrorRef.value) {
        setInputWidth(mirrorRef.value.offsetWidth);
      }
    });
    const handleResize = () => {
      if (mirrorRef.value) {
        setInputWidth(mirrorRef.value.offsetWidth);
      }
    };
    watch(computedInputValue, (value) => {
      if (inputRef.value && !isComposition.value && value !== inputRef.value.value) {
        inputRef.value.value = value;
      }
    });
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-disabled`]: mergedDisabled.value,
      [`${prefixCls}-disabled-input`]: props.disabledInput,
      [`${prefixCls}-error`]: mergedError.value,
      [`${prefixCls}-focus`]: mergedFocused.value,
      [`${prefixCls}-readonly`]: props.readonly,
      [`${prefixCls}-has-tag`]: tags.value.length > 0,
      [`${prefixCls}-has-prefix`]: Boolean(slots.prefix),
      [`${prefixCls}-has-suffix`]: Boolean(slots.suffix) || showClearBtn.value || feedback.value,
      [`${prefixCls}-has-placeholder`]: !computedValue.value.length
    }]);
    const wrapperAttrs = computed(() => omit(attrs, INPUT_EVENTS));
    const inputAttrs = computed(() => pick(attrs, INPUT_EVENTS));
    const render2 = () => {
      var _a;
      return createVNode("span", mergeProps({
        "class": cls.value,
        "onMousedown": handleMousedown
      }, wrapperAttrs.value), [createVNode(ResizeObserver$1, {
        "onResize": handleResize
      }, {
        default: () => [createVNode("span", {
          "ref": mirrorRef,
          "class": `${prefixCls}-mirror`
        }, [tags.value.length > 0 ? compositionValue.value || computedInputValue.value : compositionValue.value || computedInputValue.value || props.placeholder])]
      }), slots.prefix && createVNode("span", {
        "class": `${prefixCls}-prefix`
      }, [slots.prefix()]), createVNode(TransitionGroup, {
        "tag": "span",
        "name": "input-tag-zoom",
        "class": [`${prefixCls}-inner`, {
          [`${prefixCls}-nowrap`]: props.tagNowrap
        }]
      }, {
        default: () => [tags.value.map((item, index2) => createVNode(Tag, mergeProps({
          "key": `tag-${item.value}`,
          "class": `${prefixCls}-tag`,
          "closable": !mergedDisabled.value && !props.readonly && item.closable,
          "visible": true,
          "nowrap": props.tagNowrap
        }, item.tagProps, {
          "onClose": (ev) => handleRemove(item.value, index2, ev)
        }), {
          default: () => {
            var _a2, _b, _c, _d;
            return [(_d = (_c = (_a2 = slots.tag) == null ? void 0 : _a2.call(slots, {
              data: item.raw
            })) != null ? _c : (_b = props.formatTag) == null ? void 0 : _b.call(props, item.raw)) != null ? _d : item.label];
          }
        })), createVNode("input", mergeProps(inputAttrs.value, {
          "ref": inputRef,
          "key": "input-tag-input",
          "class": `${prefixCls}-input`,
          "style": inputStyle,
          "placeholder": tags.value.length === 0 ? props.placeholder : void 0,
          "disabled": mergedDisabled.value,
          "readonly": props.readonly || props.disabledInput,
          "onInput": handleInput,
          "onKeydown": handleKeyDown,
          "onFocus": handleFocus,
          "onBlur": handleBlur,
          "onCompositionstart": handleComposition,
          "onCompositionupdate": handleComposition,
          "onCompositionend": handleComposition
        }), null)]
      }), showClearBtn.value && createVNode(IconHover, {
        "class": `${prefixCls}-clear-btn`,
        "onClick": handleClear,
        "onMousedown": (e) => e.stopPropagation()
      }, {
        default: () => [createVNode(IconClose, null, null)]
      }), (slots.suffix || Boolean(feedback.value)) && createVNode("span", {
        "class": `${prefixCls}-suffix`
      }, [(_a = slots.suffix) == null ? void 0 : _a.call(slots), Boolean(feedback.value) && createVNode(FeedbackIcon, {
        "type": feedback.value
      }, null)])]);
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const InputTag = Object.assign(_InputTag, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _InputTag.name, _InputTag);
  }
});
var SelectView = defineComponent({
  name: "SelectView",
  props: {
    modelValue: {
      type: Array,
      required: true
    },
    inputValue: String,
    placeholder: String,
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    opened: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    bordered: {
      type: Boolean,
      default: true
    },
    multiple: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    allowCreate: {
      type: Boolean,
      default: false
    },
    allowSearch: {
      type: Boolean,
      default: (props) => isArray(props.modelValue)
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    tagNowrap: {
      type: Boolean,
      default: false
    },
    retainInputValue: {
      type: Boolean,
      default: false
    }
  },
  emits: ["remove", "clear", "focus", "blur"],
  setup(props, {
    emit,
    slots
  }) {
    const {
      size,
      disabled,
      error
    } = toRefs(props);
    const prefixCls = getPrefixCls("select-view");
    const {
      feedback,
      eventHandlers,
      mergedDisabled,
      mergedSize: _mergedSize,
      mergedError
    } = useFormItem({
      size,
      disabled,
      error
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const {
      opened
    } = toRefs(props);
    const componentRef = ref();
    const inputRef = computed(
      () => {
        var _a;
        return (_a = componentRef.value) == null ? void 0 : _a.inputRef;
      }
    );
    const isEmptyValue = computed(() => props.modelValue.length === 0);
    const enabledInput = computed(() => props.allowSearch || props.allowCreate);
    const showClearBtn = computed(() => props.allowClear && !props.disabled && !isEmptyValue.value);
    const handleFocus = (ev) => {
      var _a, _b;
      emit("focus", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onFocus) == null ? void 0 : _b.call(_a, ev);
    };
    const handleBlur = (ev) => {
      var _a, _b;
      emit("blur", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a, ev);
    };
    const handleRemove = (tag) => {
      emit("remove", tag);
    };
    const handleClear = (ev) => {
      emit("clear", ev);
    };
    const renderIcon = () => {
      var _a, _b, _c, _d;
      if (props.loading) {
        return (_b = (_a = slots["loading-icon"]) == null ? void 0 : _a.call(slots)) != null ? _b : createVNode(IconLoading, null, null);
      }
      if (props.allowSearch && props.opened) {
        return (_d = (_c = slots["search-icon"]) == null ? void 0 : _c.call(slots)) != null ? _d : createVNode(IconSearch, null, null);
      }
      if (slots["arrow-icon"]) {
        return slots["arrow-icon"]();
      }
      return createVNode(IconDown, {
        "class": `${prefixCls}-arrow-icon`
      }, null);
    };
    const renderSuffix = () => createVNode(Fragment, null, [showClearBtn.value && createVNode(IconHover, {
      "class": `${prefixCls}-clear-btn`,
      "onClick": handleClear,
      "onMousedown": (ev) => ev.stopPropagation()
    }, {
      default: () => [createVNode(IconClose, null, null)]
    }), createVNode("span", {
      "class": `${prefixCls}-icon`
    }, [renderIcon()]), Boolean(feedback.value) && createVNode(FeedbackIcon, {
      "type": feedback.value
    }, null)]);
    watch(opened, (opened2) => {
      if (!opened2 && inputRef.value && inputRef.value.isSameNode(document.activeElement)) {
        inputRef.value.blur();
      }
    });
    const cls = computed(() => [`${prefixCls}-${props.multiple ? "multiple" : "single"}`, {
      [`${prefixCls}-opened`]: props.opened,
      [`${prefixCls}-borderless`]: !props.bordered
    }]);
    const render2 = () => {
      if (props.multiple) {
        return createVNode(InputTag, {
          "ref": componentRef,
          "baseCls": prefixCls,
          "class": cls.value,
          "modelValue": props.modelValue,
          "inputValue": props.inputValue,
          "focused": props.opened,
          "placeholder": props.placeholder,
          "disabled": mergedDisabled.value,
          "size": mergedSize.value,
          "error": mergedError.value,
          "maxTagCount": props.maxTagCount,
          "disabledInput": !props.allowSearch && !props.allowCreate,
          "tagNowrap": props.tagNowrap,
          "retainInputValue": true,
          "uninjectFormItemContext": true,
          "onRemove": handleRemove,
          "onFocus": handleFocus,
          "onBlur": handleBlur
        }, {
          prefix: slots.prefix,
          suffix: renderSuffix,
          tag: slots.label
        });
      }
      return createVNode(InputLabel, {
        "ref": componentRef,
        "baseCls": prefixCls,
        "class": cls.value,
        "modelValue": props.modelValue[0],
        "inputValue": props.inputValue,
        "focused": props.opened,
        "placeholder": props.placeholder,
        "disabled": mergedDisabled.value,
        "size": mergedSize.value,
        "error": mergedError.value,
        "enabledInput": enabledInput.value,
        "uninjectFormItemContext": true,
        "onFocus": handleFocus,
        "onBlur": handleBlur
      }, {
        default: slots.label,
        prefix: slots.prefix,
        suffix: renderSuffix
      });
    };
    return {
      inputRef,
      handleFocus,
      handleBlur,
      render: render2
    };
  },
  methods: {
    focus() {
      if (this.inputRef) {
        this.inputRef.focus();
      }
    },
    blur() {
      if (this.inputRef) {
        this.inputRef.blur();
      }
    }
  },
  render() {
    return this.render();
  }
});
const _sfc_main$5X = defineComponent({
  name: "Optgroup",
  props: {
    label: {
      type: String
    }
  },
  setup() {
    const prefixCls = getPrefixCls("select-group");
    return {
      prefixCls
    };
  }
});
function _sfc_render$5W(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock(Fragment, null, [
    createBaseVNode("li", {
      class: normalizeClass(`${_ctx.prefixCls}-title`)
    }, [
      renderSlot(_ctx.$slots, "label", {}, () => [
        createTextVNode(toDisplayString(_ctx.label), 1)
      ])
    ], 2),
    renderSlot(_ctx.$slots, "default")
  ], 64);
}
var Optgroup = /* @__PURE__ */ _export_sfc(_sfc_main$5X, [["render", _sfc_render$5W]]);
const target = typeof window === "undefined" ? global : window;
function debounce(callback, delay) {
  let timer = 0;
  return (...args) => {
    if (timer) {
      target.clearTimeout(timer);
    }
    timer = target.setTimeout(() => {
      timer = 0;
      callback(...args);
    }, delay);
  };
}
function _isSlot$g(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
const DEFAULT_FIELD_NAMES = {
  value: "value",
  label: "label",
  disabled: "disabled",
  tagProps: "tagProps",
  render: "render"
};
var _Select = defineComponent({
  name: "Select",
  components: {
    Trigger,
    SelectView
  },
  inheritAttrs: false,
  props: {
    multiple: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: [String, Number, Boolean, Object, Array],
      default: void 0
    },
    defaultValue: {
      type: [String, Number, Boolean, Object, Array],
      default: (props) => isUndefined(props.multiple) ? "" : []
    },
    inputValue: {
      type: String
    },
    defaultInputValue: {
      type: String,
      default: ""
    },
    size: {
      type: String
    },
    placeholder: String,
    loading: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    allowSearch: {
      type: [Boolean, Object],
      default: (props) => Boolean(props.multiple)
    },
    allowCreate: {
      type: Boolean,
      default: false
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    popupContainer: {
      type: [String, Object]
    },
    bordered: {
      type: Boolean,
      default: true
    },
    defaultActiveFirstOption: {
      type: Boolean,
      default: true
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    unmountOnClose: {
      type: Boolean,
      default: false
    },
    filterOption: {
      type: [Boolean, Function],
      default: true
    },
    options: {
      type: Array,
      default: () => []
    },
    virtualListProps: {
      type: Object
    },
    triggerProps: {
      type: Object
    },
    formatLabel: {
      type: Function
    },
    fallbackOption: {
      type: [Boolean, Function],
      default: true
    },
    showExtraOptions: {
      type: Boolean,
      default: true
    },
    valueKey: {
      type: String,
      default: "value"
    },
    searchDelay: {
      type: Number,
      default: 500
    },
    limit: {
      type: Number,
      default: 0
    },
    fieldNames: {
      type: Object
    },
    scrollbar: {
      type: [Boolean, Object],
      default: true
    },
    showHeaderOnEmpty: {
      type: Boolean,
      default: false
    },
    showFooterOnEmpty: {
      type: Boolean,
      default: false
    },
    tagNowrap: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "update:inputValue": (inputValue) => true,
    "update:popupVisible": (visible) => true,
    "change": (value) => true,
    "inputValueChange": (inputValue) => true,
    "popupVisibleChange": (visible) => true,
    "clear": (ev) => true,
    "remove": (removed) => true,
    "search": (inputValue) => true,
    "dropdownScroll": (ev) => true,
    "dropdownReachBottom": (ev) => true,
    "exceedLimit": (value, ev) => true
  },
  setup(props, {
    slots,
    emit,
    attrs
  }) {
    const {
      size,
      disabled,
      error,
      options,
      filterOption,
      valueKey,
      multiple,
      popupVisible,
      defaultPopupVisible,
      showExtraOptions,
      modelValue,
      fieldNames,
      loading,
      defaultActiveFirstOption
    } = toRefs(props);
    const prefixCls = getPrefixCls("select");
    const {
      mergedSize,
      mergedDisabled,
      mergedError,
      eventHandlers
    } = useFormItem({
      size,
      disabled,
      error
    });
    const component = computed(() => props.virtualListProps ? "div" : "li");
    const retainInputValue = computed(() => isObject(props.allowSearch) && Boolean(props.allowSearch.retainInputValue));
    computed(() => {
      if (isFunction(props.formatLabel)) {
        return (data) => {
          const optionInfo = optionInfoMap.get(data.value);
          return props.formatLabel(optionInfo);
        };
      }
      return void 0;
    });
    const dropdownRef = ref();
    const optionRefs = ref({});
    const virtualListRef = ref();
    const {
      computedPopupVisible,
      handlePopupVisibleChange
    } = useTrigger({
      popupVisible,
      defaultPopupVisible,
      emit
    });
    const _value = ref(props.defaultValue);
    const computedValueObjects = computed(() => {
      var _a;
      const mergedValue = (_a = props.modelValue) != null ? _a : _value.value;
      const valueArray = isArray(mergedValue) ? mergedValue : mergedValue || isNumber(mergedValue) || isString(mergedValue) || isBoolean(mergedValue) ? [mergedValue] : [];
      return valueArray.map((value) => ({
        value,
        key: getKeyFromValue(value, props.valueKey)
      }));
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = multiple.value ? [] : value;
      }
    });
    const computedValueKeys = computed(() => computedValueObjects.value.map((obj) => obj.key));
    const mergedFieldNames = computed(() => ({
      ...DEFAULT_FIELD_NAMES,
      ...fieldNames == null ? void 0 : fieldNames.value
    }));
    const _selectedOption = ref();
    const getRawOptionFromValueKeys = (valueKeys) => {
      const optionMap = {};
      valueKeys.forEach((key) => {
        optionMap[key] = optionInfoMap.get(key);
      });
      return optionMap;
    };
    const updateSelectedOption = (valueKeys) => {
      _selectedOption.value = getRawOptionFromValueKeys(valueKeys);
    };
    const getFallBackOption = (value) => {
      if (isFunction(props.fallbackOption)) {
        return props.fallbackOption(value);
      }
      return {
        [mergedFieldNames.value.value]: value,
        [mergedFieldNames.value.label]: String(isObject(value) ? value[valueKey == null ? void 0 : valueKey.value] : value)
      };
    };
    const getExtraValueData = () => {
      const valueArray = [];
      const keyArray = [];
      if (props.allowCreate || props.fallbackOption) {
        for (const item of computedValueObjects.value) {
          if (!keyArray.includes(item.key) && item.value !== "") {
            const optionInfo = optionInfoMap.get(item.key);
            if (!optionInfo || optionInfo.origin === "extraOptions") {
              valueArray.push(item);
              keyArray.push(item.key);
            }
          }
        }
      }
      if (props.allowCreate && computedInputValue.value) {
        const key = getKeyFromValue(computedInputValue.value);
        if (!keyArray.includes(key)) {
          const optionInfo = optionInfoMap.get(key);
          if (!optionInfo || optionInfo.origin === "extraOptions") {
            valueArray.push({
              value: computedInputValue.value,
              key
            });
          }
        }
      }
      return valueArray;
    };
    const extraValueObjects = ref([]);
    const extraOptions = computed(() => extraValueObjects.value.map((obj) => {
      var _a;
      let optionInfo = getFallBackOption(obj.value);
      const extraOptionRawInfo = (_a = _selectedOption.value) == null ? void 0 : _a[obj.key];
      if (!isUndefined(extraOptionRawInfo) && !isEmptyObject(extraOptionRawInfo)) {
        optionInfo = {
          ...optionInfo,
          ...extraOptionRawInfo
        };
      }
      return optionInfo;
    }));
    nextTick(() => {
      watchEffect(() => {
        var _a;
        const valueData = getExtraValueData();
        if (valueData.length !== extraValueObjects.value.length) {
          extraValueObjects.value = valueData;
        } else if (valueData.length > 0) {
          for (let i2 = 0; i2 < valueData.length; i2++) {
            if (valueData[i2].key !== ((_a = extraValueObjects.value[i2]) == null ? void 0 : _a.key)) {
              extraValueObjects.value = valueData;
              break;
            }
          }
        }
      });
    });
    const _inputValue = ref("");
    const computedInputValue = computed(() => {
      var _a;
      return (_a = props.inputValue) != null ? _a : _inputValue.value;
    });
    watch(computedPopupVisible, (visible) => {
      if (!visible && !retainInputValue.value && computedInputValue.value) {
        updateInputValue("");
      }
    });
    const getValueFromValueKeys = (valueKeys) => {
      var _a, _b;
      if (!props.multiple) {
        return (_b = (_a = optionInfoMap.get(valueKeys[0])) == null ? void 0 : _a.value) != null ? _b : hasEmptyStringKey(optionInfoMap) ? void 0 : "";
      }
      return valueKeys.map((key) => {
        var _a2, _b2;
        return (_b2 = (_a2 = optionInfoMap.get(key)) == null ? void 0 : _a2.value) != null ? _b2 : "";
      });
    };
    const updateValue = (valueKeys) => {
      var _a, _b;
      const value = getValueFromValueKeys(valueKeys);
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
      updateSelectedOption(valueKeys);
    };
    const updateInputValue = (inputValue) => {
      _inputValue.value = inputValue;
      emit("update:inputValue", inputValue);
      emit("inputValueChange", inputValue);
    };
    const handleSelect = (key, ev) => {
      if (props.multiple) {
        if (!computedValueKeys.value.includes(key)) {
          if (enabledOptionKeys.value.includes(key)) {
            if (props.limit > 0 && computedValueKeys.value.length >= props.limit) {
              const info = optionInfoMap.get(key);
              emit("exceedLimit", info == null ? void 0 : info.value, ev);
            } else {
              const valueKeys = computedValueKeys.value.concat(key);
              updateValue(valueKeys);
            }
          }
        } else {
          const valueKeys = computedValueKeys.value.filter((_key) => _key !== key);
          updateValue(valueKeys);
        }
        if (!retainInputValue.value) {
          updateInputValue("");
        }
      } else {
        if (key !== computedValueKeys.value[0]) {
          updateValue([key]);
        }
        if (retainInputValue.value) {
          const optionInfo = optionInfoMap.get(key);
          if (optionInfo) {
            updateInputValue(optionInfo.label);
          }
        }
        handlePopupVisibleChange(false);
      }
    };
    const handleSearch = debounce((value) => {
      emit("search", value);
    }, props.searchDelay);
    const handleInputValueChange = (inputValue) => {
      if (inputValue !== computedInputValue.value) {
        if (!computedPopupVisible.value) {
          handlePopupVisibleChange(true);
        }
        updateInputValue(inputValue);
        if (props.allowSearch) {
          handleSearch(inputValue);
        }
      }
    };
    const handleRemove = (key) => {
      const optionInfo = optionInfoMap.get(key);
      const newKeys = computedValueKeys.value.filter((_key) => _key !== key);
      updateValue(newKeys);
      emit("remove", optionInfo == null ? void 0 : optionInfo.value);
    };
    const handleClear = (e) => {
      e == null ? void 0 : e.stopPropagation();
      const newKeys = computedValueKeys.value.filter((key) => {
        var _a;
        return (_a = optionInfoMap.get(key)) == null ? void 0 : _a.disabled;
      });
      updateValue(newKeys);
      updateInputValue("");
      emit("clear", e);
    };
    const handleDropdownScroll = (e) => {
      emit("dropdownScroll", e);
    };
    const handleDropdownReachBottom = (e) => {
      emit("dropdownReachBottom", e);
    };
    const {
      validOptions,
      optionInfoMap,
      validOptionInfos,
      enabledOptionKeys,
      handleKeyDown
    } = useSelect({
      multiple,
      options,
      extraOptions,
      inputValue: computedInputValue,
      filterOption,
      showExtraOptions,
      component,
      valueKey,
      fieldNames,
      loading,
      popupVisible: computedPopupVisible,
      valueKeys: computedValueKeys,
      dropdownRef,
      optionRefs,
      virtualListRef,
      defaultActiveFirstOption,
      onSelect: handleSelect,
      onPopupVisibleChange: handlePopupVisibleChange
    });
    const selectViewValue = computed(() => {
      var _a;
      const result = [];
      for (const item of computedValueObjects.value) {
        const optionInfo = optionInfoMap.get(item.key);
        if (optionInfo) {
          result.push({
            ...optionInfo,
            value: item.key,
            label: (_a = optionInfo == null ? void 0 : optionInfo.label) != null ? _a : String(isObject(item.value) ? item.value[valueKey == null ? void 0 : valueKey.value] : item.value),
            closable: !(optionInfo == null ? void 0 : optionInfo.disabled),
            tagProps: optionInfo == null ? void 0 : optionInfo.tagProps
          });
        }
      }
      return result;
    });
    const getOptionContentFunc = (optionInfo) => {
      if (isFunction(slots.option)) {
        const optionSlot = slots.option;
        return () => optionSlot({
          data: optionInfo.raw
        });
      }
      if (isFunction(optionInfo.render)) {
        return optionInfo.render;
      }
      return () => optionInfo.label;
    };
    const renderOption = (optionInfo) => {
      if (isGroupOptionInfo(optionInfo)) {
        let _slot;
        return createVNode(Optgroup, {
          "key": optionInfo.key,
          "label": optionInfo.label
        }, _isSlot$g(_slot = optionInfo.options.map((child) => renderOption(child))) ? _slot : {
          default: () => [_slot]
        });
      }
      if (!isValidOption(optionInfo, {
        inputValue: computedInputValue.value,
        filterOption: filterOption == null ? void 0 : filterOption.value
      })) {
        return null;
      }
      return createVNode(Option, {
        "ref": (ref2) => {
          if (ref2 == null ? void 0 : ref2.$el) {
            optionRefs.value[optionInfo.key] = ref2.$el;
          }
        },
        "key": optionInfo.key,
        "value": optionInfo.value,
        "label": optionInfo.label,
        "disabled": optionInfo.disabled,
        "internal": true
      }, {
        default: getOptionContentFunc(optionInfo)
      });
    };
    const renderDropDown = () => {
      return createVNode(SelectDropdown, {
        "ref": dropdownRef,
        "loading": props.loading,
        "empty": validOptionInfos.value.length === 0,
        "virtualList": Boolean(props.virtualListProps),
        "scrollbar": props.scrollbar,
        "showHeaderOnEmpty": props.showHeaderOnEmpty,
        "showFooterOnEmpty": props.showFooterOnEmpty,
        "onScroll": handleDropdownScroll,
        "onReachBottom": handleDropdownReachBottom
      }, {
        "default": () => {
          var _a, _b;
          return [...(_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _b : [], ...validOptions.value.map(renderOption)];
        },
        "virtual-list": () => createVNode(VirtualList, mergeProps(props.virtualListProps, {
          "ref": virtualListRef,
          "data": validOptions.value
        }), {
          item: ({
            item
          }) => renderOption(item)
        }),
        "empty": slots.empty,
        "header": slots.header,
        "footer": slots.footer
      });
    };
    const renderLabel = ({
      data
    }) => {
      var _a, _b, _c, _d;
      if ((slots.label || isFunction(props.formatLabel)) && data) {
        const optionInfo = optionInfoMap.get(data.value);
        if (optionInfo == null ? void 0 : optionInfo.raw) {
          return (_c = (_a = slots.label) == null ? void 0 : _a.call(slots, {
            data: optionInfo.raw
          })) != null ? _c : (_b = props.formatLabel) == null ? void 0 : _b.call(props, optionInfo.raw);
        }
      }
      return (_d = data == null ? void 0 : data.label) != null ? _d : "";
    };
    return () => createVNode(Trigger, mergeProps({
      "trigger": "click",
      "position": "bl",
      "popupOffset": 4,
      "animationName": "slide-dynamic-origin",
      "hideEmpty": true,
      "preventFocus": true,
      "autoFitPopupWidth": true,
      "autoFitTransformOrigin": true,
      "disabled": mergedDisabled.value,
      "popupVisible": computedPopupVisible.value,
      "unmountOnClose": props.unmountOnClose,
      "clickToClose": !(props.allowSearch || props.allowCreate),
      "popupContainer": props.popupContainer,
      "onPopupVisibleChange": handlePopupVisibleChange
    }, props.triggerProps), {
      default: () => {
        var _a, _b;
        return [(_b = (_a = slots.trigger) == null ? void 0 : _a.call(slots)) != null ? _b : createVNode(SelectView, mergeProps({
          "class": prefixCls,
          "modelValue": selectViewValue.value,
          "inputValue": computedInputValue.value,
          "multiple": props.multiple,
          "disabled": mergedDisabled.value,
          "error": mergedError.value,
          "loading": props.loading,
          "allowClear": props.allowClear,
          "allowCreate": props.allowCreate,
          "allowSearch": Boolean(props.allowSearch),
          "opened": computedPopupVisible.value,
          "maxTagCount": props.maxTagCount,
          "placeholder": props.placeholder,
          "bordered": props.bordered,
          "size": mergedSize.value,
          "tagNowrap": props.tagNowrap,
          "onInputValueChange": handleInputValueChange,
          "onRemove": handleRemove,
          "onClear": handleClear,
          "onKeydown": handleKeyDown
        }, attrs), {
          "label": renderLabel,
          "prefix": slots.prefix,
          "arrow-icon": slots["arrow-icon"],
          "loading-icon": slots["loading-icon"],
          "search-icon": slots["search-icon"]
        })];
      },
      content: renderDropDown
    });
  }
});
const Select = Object.assign(_Select, {
  Option,
  OptGroup: Optgroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Select.name, _Select);
    app.component(componentPrefix + Option.name, Option);
    app.component(componentPrefix + Optgroup.name, Optgroup);
  }
});
const radioGroupKey = Symbol("RadioGroup");
var _Radio = defineComponent({
  name: "Radio",
  components: {
    IconHover
  },
  props: {
    modelValue: {
      type: [String, Number, Boolean],
      default: void 0
    },
    defaultChecked: {
      type: Boolean,
      default: false
    },
    value: {
      type: [String, Number, Boolean],
      default: true
    },
    type: {
      type: String,
      default: "radio"
    },
    disabled: {
      type: Boolean,
      default: false
    },
    uninjectGroupContext: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const prefixCls = getPrefixCls("radio");
    const {
      modelValue
    } = toRefs(props);
    const radioGroupCtx = !props.uninjectGroupContext ? inject(radioGroupKey, void 0) : void 0;
    const {
      mergedDisabled: _mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled: toRef(props, "disabled")
    });
    const inputRef = ref(null);
    const _checked = ref(props.defaultChecked);
    const isGroup = computed(() => (radioGroupCtx == null ? void 0 : radioGroupCtx.name) === "ArcoRadioGroup");
    const mergedType = computed(() => {
      var _a;
      return (_a = radioGroupCtx == null ? void 0 : radioGroupCtx.type) != null ? _a : props.type;
    });
    const mergedDisabled = computed(() => (radioGroupCtx == null ? void 0 : radioGroupCtx.disabled) || _mergedDisabled.value);
    const computedChecked = computed(() => {
      var _a, _b;
      if (isGroup.value) {
        return (radioGroupCtx == null ? void 0 : radioGroupCtx.value) === ((_a = props.value) != null ? _a : true);
      }
      if (!isUndefined(props.modelValue)) {
        return props.modelValue === ((_b = props.value) != null ? _b : true);
      }
      return _checked.value;
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _checked.value = false;
      }
    });
    watch(computedChecked, (curValue, preValue) => {
      if (curValue !== preValue) {
        _checked.value = curValue;
        if (inputRef.value) {
          inputRef.value.checked = curValue;
        }
      }
    });
    const handleFocus = (ev) => {
      var _a, _b;
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onFocus) == null ? void 0 : _b.call(_a, ev);
    };
    const handleBlur = (ev) => {
      var _a, _b;
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a, ev);
    };
    const handleClick = (ev) => {
      ev.stopPropagation();
    };
    const handleChange = (e) => {
      var _a, _b, _c, _d, _e;
      _checked.value = true;
      if (isGroup.value) {
        radioGroupCtx == null ? void 0 : radioGroupCtx.handleChange((_a = props.value) != null ? _a : true, e);
      } else {
        emit("update:modelValue", (_b = props.value) != null ? _b : true);
        emit("change", (_c = props.value) != null ? _c : true, e);
        (_e = (_d = eventHandlers.value) == null ? void 0 : _d.onChange) == null ? void 0 : _e.call(_d, e);
      }
      nextTick(() => {
        if (inputRef.value && inputRef.value.checked !== computedChecked.value) {
          inputRef.value.checked = computedChecked.value;
        }
      });
    };
    const cls = computed(() => [`${mergedType.value === "button" ? `${prefixCls}-button` : prefixCls}`, {
      [`${prefixCls}-checked`]: computedChecked.value,
      [`${prefixCls}-disabled`]: mergedDisabled.value
    }]);
    const defaultRadio = () => createVNode(Fragment, null, [createVNode(resolveComponent("icon-hover"), {
      "class": `${prefixCls}-icon-hover`,
      "disabled": mergedDisabled.value || computedChecked.value
    }, {
      default: () => [createVNode("span", {
        "class": `${prefixCls}-icon`
      }, null)]
    }), slots.default && createVNode("span", {
      "class": `${prefixCls}-label`
    }, [slots.default()])]);
    return () => {
      var _a, _b, _c, _d;
      return createVNode("label", {
        "class": cls.value
      }, [createVNode("input", {
        "ref": inputRef,
        "type": "radio",
        "checked": computedChecked.value,
        "value": props.value,
        "class": `${prefixCls}-target`,
        "disabled": mergedDisabled.value,
        "onClick": handleClick,
        "onChange": handleChange,
        "onFocus": handleFocus,
        "onBlur": handleBlur
      }, null), mergedType.value === "radio" ? (_d = (_c = (_b = slots.radio) != null ? _b : (_a = radioGroupCtx == null ? void 0 : radioGroupCtx.slots) == null ? void 0 : _a.radio) == null ? void 0 : _c({
        checked: computedChecked.value,
        disabled: mergedDisabled.value
      })) != null ? _d : defaultRadio() : createVNode("span", {
        "class": `${prefixCls}-button-content`
      }, [slots.default && slots.default()])]);
    };
  }
});
var RadioGroup = defineComponent({
  name: "RadioGroup",
  props: {
    modelValue: {
      type: [String, Number, Boolean],
      default: void 0
    },
    defaultValue: {
      type: [String, Number, Boolean],
      default: ""
    },
    type: {
      type: String,
      default: "radio"
    },
    size: {
      type: String
    },
    options: {
      type: Array
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const prefixCls = getPrefixCls("radio-group");
    const {
      size,
      type,
      disabled,
      modelValue
    } = toRefs(props);
    const {
      mergedDisabled,
      mergedSize: _mergedSize,
      eventHandlers
    } = useFormItem({
      size,
      disabled
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : _value.value;
    });
    const options = computed(() => {
      var _a;
      return ((_a = props.options) != null ? _a : []).map((option) => {
        if (isString(option) || isNumber(option)) {
          return {
            label: option,
            value: option
          };
        }
        return option;
      });
    });
    const handleChange = (value, e) => {
      var _a, _b;
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value, e);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a, e);
    };
    provide(radioGroupKey, reactive({
      name: "ArcoRadioGroup",
      value: computedValue,
      size: mergedSize,
      type,
      disabled: mergedDisabled,
      slots,
      handleChange
    }));
    watch(computedValue, (cur) => {
      if (_value.value !== cur) {
        _value.value = cur;
      }
    });
    watch(modelValue, (val) => {
      if (isUndefined(val) || isNull(val)) {
        _value.value = "";
      }
    });
    const cls = computed(() => [`${prefixCls}${props.type === "button" ? "-button" : ""}`, `${prefixCls}-size-${mergedSize.value}`, `${prefixCls}-direction-${props.direction}`, {
      [`${prefixCls}-disabled`]: mergedDisabled.value
    }]);
    const renderOptions = () => {
      return options.value.map((option) => createVNode(_Radio, {
        "key": option.value,
        "value": option.value,
        "disabled": option.disabled,
        "modelValue": computedValue.value === option.value
      }, {
        default: () => [slots.label ? slots.label({
          data: option
        }) : isFunction(option.label) ? option.label() : option.label]
      }));
    };
    return () => {
      var _a;
      return createVNode("span", {
        "class": cls.value
      }, [options.value.length > 0 ? renderOptions() : (_a = slots.default) == null ? void 0 : _a.call(slots)]);
    };
  }
});
const Radio = Object.assign(_Radio, {
  Group: RadioGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Radio.name, _Radio);
    app.component(componentPrefix + RadioGroup.name, RadioGroup);
  }
});
const _sfc_main$5W = defineComponent({
  name: "IconLeft",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-left`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4A = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5V(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M32 8.4 16.444 23.956 32 39.513" }, null, -1)
  ]), 14, _hoisted_1$4A);
}
var _IconLeft = /* @__PURE__ */ _export_sfc(_sfc_main$5W, [["render", _sfc_render$5V]]);
const IconLeft = Object.assign(_IconLeft, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconLeft.name, _IconLeft);
  }
});
function _isSlot$f(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
function getPopupContainer(node) {
  return node.parentElement;
}
var Header = defineComponent({
  name: "Header",
  props: {
    mode: {
      type: String
    },
    dayStartOfWeek: {
      type: Number
    },
    isWeek: {
      type: Boolean
    },
    panel: {
      type: Boolean
    },
    modes: {
      type: Array
    },
    headerType: {
      type: String
    },
    pageShowData: {
      type: Object,
      required: true
    },
    move: {
      type: Function,
      required: true
    },
    onYearChange: {
      type: Function,
      required: true
    },
    onMonthChange: {
      type: Function,
      required: true
    },
    changePageShowDate: {
      type: Function,
      required: true
    },
    onModeChange: {
      type: Function,
      required: true
    },
    headerValueFormat: {
      type: String,
      required: true
    }
  },
  emits: ["yearChange", "monthChange"],
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("calendar");
    const {
      t
    } = useI18n();
    const modesOptions = isArray(props.modes) ? props.modes.map((m) => ({
      label: t(`datePicker.view.${m}`),
      value: m
    })) : [];
    const isSelectHeaderType = props.headerType === "select";
    const pageShowDateYear = computed(() => props.pageShowData.year());
    const pageShowDateMonth = computed(() => props.pageShowData.month() + 1);
    const optionsYear = computed(() => {
      const options = [pageShowDateYear.value];
      for (let i2 = 1; i2 <= 10; i2++) {
        options.unshift(pageShowDateYear.value - i2);
      }
      for (let i2 = 1; i2 < 10; i2++) {
        options.push(pageShowDateYear.value + i2);
      }
      return options;
    });
    const optionsMonth = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
    return () => {
      let _slot;
      return createVNode("div", {
        "class": `${prefixCls}-header`
      }, [createVNode("div", {
        "class": `${prefixCls}-header-left`
      }, [isSelectHeaderType ? createVNode(Fragment, null, [createVNode(Select, {
        "size": "small",
        "class": `${prefixCls}-header-value-year`,
        "value": pageShowDateYear,
        "options": optionsYear.value,
        "onChange": props.onYearChange,
        "getPopupContainer": getPopupContainer
      }, null), props.mode === "month" && createVNode(Select, {
        "size": "small",
        "class": `${prefixCls}-header-value-month`,
        "value": pageShowDateMonth,
        "options": optionsMonth,
        "onChange": props.onMonthChange,
        "getPopupContainer": getPopupContainer
      }, null)]) : createVNode(Fragment, null, [createVNode("div", {
        "class": `${prefixCls}-header-icon`,
        "role": "button",
        "tabIndex": 0,
        "onClick": () => props.changePageShowDate("prev", props.mode)
      }, [createVNode(IconLeft, null, null)]), createVNode("div", {
        "class": `${prefixCls}-header-value`
      }, [slots.default ? slots.default({
        year: pageShowDateYear,
        month: pageShowDateMonth
      }) : props.pageShowData.format(props.headerValueFormat)]), createVNode("div", {
        "role": "button",
        "tabIndex": 0,
        "class": `${prefixCls}-header-icon`,
        "onClick": () => props.changePageShowDate("next", props.mode)
      }, [createVNode(IconRight, null, null)])]), createVNode(Button, {
        "size": "small",
        "onClick": () => props.move(getNow())
      }, _isSlot$f(_slot = t(`datePicker.today`)) ? _slot : {
        default: () => [_slot]
      })]), createVNode("div", {
        "class": `${prefixCls}-header-right`
      }, [createVNode(Radio.Group, {
        "size": "small",
        "type": "button",
        "options": modesOptions,
        "onChange": props.onModeChange,
        "modelValue": props.mode
      }, null)])]);
    };
  }
});
function getFormat(mode, panel) {
  return mode === "month" || mode === "year" && !panel ? "YYYY-MM-DD" : "YYYY-MM";
}
var _Calendar = defineComponent({
  name: "Calendar",
  props: {
    modelValue: {
      type: Date,
      default: void 0
    },
    defaultValue: {
      type: Date
    },
    mode: {
      type: String
    },
    defaultMode: {
      type: String,
      default: "month"
    },
    modes: {
      type: Array,
      default: () => ["month", "year"]
    },
    allowSelect: {
      type: Boolean,
      default: true
    },
    panel: {
      type: Boolean,
      default: false
    },
    panelWidth: {
      type: Number
    },
    panelTodayBtn: {
      type: Boolean,
      default: false
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    isWeek: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (date) => true,
    "change": (date) => true,
    "panelChange": (date) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      dayStartOfWeek,
      isWeek
    } = toRefs(props);
    const prefixCls = getPrefixCls("calendar");
    const _mode = ref(props.defaultMode);
    const {
      t
    } = useI18n();
    const computedMode = computed(() => {
      if (props.mode) {
        return props.mode;
      }
      return _mode.value;
    });
    const format = getFormat(computedMode.value, props.panel);
    const _value = ref(getDayjsValue(props.defaultValue || Date.now(), format));
    const computedValue = computed(() => {
      if (props.modelValue) {
        return getDayjsValue(props.modelValue, format);
      }
      return _value.value;
    });
    const pageShowDate = ref(computedValue.value || getNow());
    const pageData = computed(() => {
      return getAllDaysByTime(pageShowDate.value, {
        dayStartOfWeek: dayStartOfWeek.value,
        isWeek: isWeek.value
      });
    });
    function onChangePageDate(time) {
      pageShowDate.value = time;
      emit("panelChange", time.toDate());
    }
    function move(time) {
      _value.value = time;
      emit("change", time.toDate());
      emit("update:modelValue", time.toDate());
      onChangePageDate(time);
    }
    function selectHandler(time, disabled = false) {
      if (!disabled) {
        move(time);
      }
    }
    let headerValueFormat = "";
    if (computedMode.value === "month") {
      headerValueFormat = t("calendar.formatMonth");
    } else if (computedMode.value === "year") {
      headerValueFormat = t("calendar.formatYear");
    }
    function changePageShowDate(type, unit) {
      if (type === "prev") {
        pageShowDate.value = methods.subtract(pageShowDate.value, 1, unit);
      }
      if (type === "next") {
        pageShowDate.value = methods.add(pageShowDate.value, 1, unit);
      }
      emit("panelChange", pageShowDate.value.toDate());
    }
    function onChangeYear(year) {
      const newValue = methods.set(pageShowDate.value, "year", year);
      pageShowDate.value = newValue;
      emit("panelChange", newValue.toDate());
    }
    function onChangeMonth(month) {
      const newValue = methods.set(pageShowDate.value, "month", month - 1);
      pageShowDate.value = newValue;
      emit("panelChange", newValue.toDate());
    }
    function changeMode(mode) {
      _mode.value = mode;
    }
    const cls = computed(() => [prefixCls, computedMode.value === "month" ? `${prefixCls}-mode-month` : `${prefixCls}-mode-year`, {
      [`${prefixCls}-panel`]: props.panel && (computedMode.value === "month" || computedMode.value === "year")
    }]);
    const baseStyle = props.panel ? {
      width: props.panelWidth
    } : {};
    return () => createVNode("div", mergeProps({
      "class": cls.value,
      "style": baseStyle
    }, pickDataAttributes(props)), [createVNode(Header, {
      "move": move,
      "headerValueFormat": headerValueFormat,
      "modes": props.modes,
      "mode": computedMode.value,
      "pageShowData": pageShowDate.value,
      "dayStartOfWeek": props.dayStartOfWeek,
      "isWeek": props.isWeek,
      "onModeChange": changeMode,
      "onYearChange": onChangeYear,
      "onMonthChange": onChangeMonth,
      "changePageShowDate": changePageShowDate
    }, {
      default: slots.header
    }), computedMode.value === "month" && createVNode("div", {
      "class": `${prefixCls}-body`
    }, [createVNode(Month, {
      "key": pageShowDate.value.month(),
      "pageData": pageData.value,
      "value": computedValue.value,
      "mode": computedMode.value,
      "selectHandler": selectHandler,
      "isWeek": props.isWeek,
      "dayStartOfWeek": props.dayStartOfWeek,
      "pageShowDate": pageShowDate.value
    }, {
      default: slots.default
    })]), computedMode.value === "year" && createVNode("div", {
      "class": `${prefixCls}-body`
    }, [createVNode(Year, {
      "key": pageShowDate.value.year(),
      "pageData": pageData.value,
      "pageShowData": pageShowDate.value,
      "mode": computedMode.value,
      "isWeek": props.isWeek,
      "value": computedValue.value,
      "dayStartOfWeek": props.dayStartOfWeek,
      "selectHandler": selectHandler
    }, null)]), props.panel && props.panelTodayBtn && createVNode("div", {
      "class": `${prefixCls}-footer-btn-wrapper`
    }, [t("today")])]);
  }
});
const Calendar = Object.assign(_Calendar, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Calendar.name, _Calendar);
  }
});
const cardInjectionKey = Symbol("ArcoCard");
var _Card = defineComponent({
  name: "Card",
  components: {
    Spin
  },
  props: {
    bordered: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    headerStyle: {
      type: Object,
      default: () => ({})
    },
    bodyStyle: {
      type: Object,
      default: () => ({})
    },
    title: {
      type: String
    },
    extra: {
      type: String
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("card");
    const {
      size
    } = toRefs(props);
    const {
      mergedSize: _mergedSize
    } = useSize$1(size);
    const mergedSize = computed(() => {
      if (_mergedSize.value === "small" || _mergedSize.value === "mini") {
        return "small";
      }
      return "medium";
    });
    const renderActions = (vns) => {
      const actions = getAllElements(vns);
      return createVNode("div", {
        "class": `${prefixCls}-actions`
      }, [createVNode("div", {
        "class": `${prefixCls}-actions-right`
      }, [actions.map((action, index2) => createVNode("span", {
        "key": `action-${index2}`,
        "class": `${prefixCls}-actions-item`
      }, [action]))])]);
    };
    const cardContext = reactive({
      hasMeta: false,
      hasGrid: false,
      slots,
      renderActions
    });
    provide(cardInjectionKey, cardContext);
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-loading`]: props.loading,
      [`${prefixCls}-bordered`]: props.bordered,
      [`${prefixCls}-hoverable`]: props.hoverable,
      [`${prefixCls}-contain-grid`]: cardContext.hasGrid
    }]);
    return () => {
      var _a, _b, _c, _d, _e, _f, _g;
      const hasTitle = Boolean((_a = slots.title) != null ? _a : props.title);
      const hasExtra = Boolean((_b = slots.extra) != null ? _b : props.extra);
      return createVNode("div", {
        "class": cls.value
      }, [(hasTitle || hasExtra) && createVNode("div", {
        "class": [`${prefixCls}-header`, {
          [`${prefixCls}-header-no-title`]: !hasTitle
        }],
        "style": props.headerStyle
      }, [hasTitle && createVNode("div", {
        "class": `${prefixCls}-header-title`
      }, [(_d = (_c = slots.title) == null ? void 0 : _c.call(slots)) != null ? _d : props.title]), hasExtra && createVNode("div", {
        "class": `${prefixCls}-header-extra`
      }, [(_f = (_e = slots.extra) == null ? void 0 : _e.call(slots)) != null ? _f : props.extra])]), slots.cover && createVNode("div", {
        "class": `${prefixCls}-cover`
      }, [slots.cover()]), createVNode("div", {
        "class": `${prefixCls}-body`,
        "style": props.bodyStyle
      }, [props.loading ? createVNode(Spin, null, null) : (_g = slots.default) == null ? void 0 : _g.call(slots), slots.actions && !cardContext.hasMeta && renderActions(slots.actions())])]);
    };
  }
});
var CardMeta = defineComponent({
  name: "CardMeta",
  props: {
    title: {
      type: String
    },
    description: {
      type: String
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("card-meta");
    const context = inject(cardInjectionKey);
    onMounted(() => {
      if (context) {
        context.hasMeta = true;
      }
    });
    return () => {
      var _a, _b, _c, _d, _e, _f;
      const hasTitle = Boolean((_a = slots.title) != null ? _a : props.title);
      const hasDesc = Boolean((_b = slots.description) != null ? _b : props.description);
      return createVNode("div", {
        "class": prefixCls
      }, [(hasTitle || hasDesc) && createVNode("div", {
        "class": `${prefixCls}-content`
      }, [hasTitle && createVNode("div", {
        "class": `${prefixCls}-title`
      }, [(_d = (_c = slots.title) == null ? void 0 : _c.call(slots)) != null ? _d : props.title]), hasDesc && createVNode("div", {
        "class": `${prefixCls}-description`
      }, [(_f = (_e = slots.description) == null ? void 0 : _e.call(slots)) != null ? _f : props.description])]), (slots.avatar || (context == null ? void 0 : context.slots.actions)) && createVNode("div", {
        "class": [`${prefixCls}-footer `, {
          [`${prefixCls}-footer-only-actions`]: !slots.avatar
        }]
      }, [slots.avatar && createVNode("div", {
        "class": `${prefixCls}-avatar`
      }, [slots.avatar()]), context && context.slots.actions && context.renderActions(context.slots.actions())])]);
    };
  }
});
const _sfc_main$5V = defineComponent({
  name: "CardGrid",
  props: {
    hoverable: {
      type: Boolean,
      default: false
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("card-grid");
    const context = inject(cardInjectionKey);
    onMounted(() => {
      if (context) {
        context.hasGrid = true;
      }
    });
    const cls = computed(() => {
      return [
        prefixCls,
        {
          [`${prefixCls}-hoverable`]: props.hoverable
        }
      ];
    });
    return {
      cls
    };
  }
});
function _sfc_render$5U(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var CardGrid = /* @__PURE__ */ _export_sfc(_sfc_main$5V, [["render", _sfc_render$5U]]);
const Card = Object.assign(_Card, {
  Meta: CardMeta,
  Grid: CardGrid,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Card.name, _Card);
    app.component(componentPrefix + CardMeta.name, CardMeta);
    app.component(componentPrefix + CardGrid.name, CardGrid);
  }
});
const _sfc_main$5U = defineComponent({
  name: "Indicator",
  props: {
    count: {
      type: Number,
      default: 2
    },
    activeIndex: {
      type: Number,
      default: 0
    },
    type: {
      type: String,
      default: "line"
    },
    position: {
      type: String,
      default: "bottom"
    },
    trigger: {
      type: String,
      default: "click"
    }
  },
  emits: ["select"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("carousel-indicator");
    const onClick = (event) => {
      var _a;
      event.preventDefault();
      if (props.type === "slider") {
        const x = event.offsetX;
        const width = event.currentTarget.clientWidth;
        if (event.target === event.currentTarget) {
          const index2 = Math.floor(x / width * props.count);
          index2 !== props.activeIndex && emit("select", index2);
        }
      } else {
        const index2 = Number.parseInt(
          (_a = event.target.getAttribute("data-index")) != null ? _a : "",
          10
        );
        if (!Number.isNaN(index2) && index2 !== props.activeIndex) {
          emit("select", index2);
        }
      }
    };
    const eventHandlers = computed(() => {
      return props.trigger === "click" ? { onClick } : { onMouseover: onClick };
    });
    const cls = computed(() => [
      `${prefixCls}`,
      `${prefixCls}-${props.type}`,
      `${prefixCls}-${props.position}`
    ]);
    const sliderStyle = computed(() => {
      const step = 100 / props.count;
      return { width: `${step}%`, left: `${props.activeIndex * step}%` };
    });
    return {
      prefixCls,
      eventHandlers,
      cls,
      sliderStyle
    };
  }
});
const _hoisted_1$4z = ["data-index"];
function _sfc_render$5T(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({ class: _ctx.cls }, _ctx.eventHandlers), [
    _ctx.type === "slider" ? (openBlock(), createElementBlock("span", {
      key: 0,
      style: normalizeStyle(_ctx.sliderStyle),
      class: normalizeClass([`${_ctx.prefixCls}-item`, `${_ctx.prefixCls}-item-active`])
    }, null, 6)) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList(Array(_ctx.count), (_, index2) => {
      return openBlock(), createElementBlock("span", {
        key: index2,
        "data-index": index2,
        class: normalizeClass([
          `${_ctx.prefixCls}-item`,
          { [`${_ctx.prefixCls}-item-active`]: index2 === _ctx.activeIndex }
        ])
      }, null, 10, _hoisted_1$4z);
    }), 128))
  ], 16);
}
var CarouselIndicator = /* @__PURE__ */ _export_sfc(_sfc_main$5U, [["render", _sfc_render$5T]]);
const _sfc_main$5T = defineComponent({
  name: "IconUp",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-up`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4y = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5S(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M39.6 30.557 24.043 15 8.487 30.557" }, null, -1)
  ]), 14, _hoisted_1$4y);
}
var _IconUp = /* @__PURE__ */ _export_sfc(_sfc_main$5T, [["render", _sfc_render$5S]]);
const IconUp = Object.assign(_IconUp, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconUp.name, _IconUp);
  }
});
const _sfc_main$5S = defineComponent({
  name: "Arrow",
  components: {
    IconUp,
    IconDown,
    IconLeft,
    IconRight
  },
  props: {
    direction: {
      type: String,
      default: "horizontal"
    },
    showArrow: {
      type: String,
      default: "always"
    }
  },
  emits: ["previousClick", "nextClick"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("carousel");
    const onPreviousClick = (ev) => {
      emit("previousClick", ev);
    };
    const onNextClick = (ev) => {
      emit("nextClick", ev);
    };
    const cls = computed(() => [
      `${prefixCls}-arrow`,
      {
        [`${prefixCls}-arrow-hover`]: props.showArrow === "hover"
      }
    ]);
    return {
      prefixCls,
      cls,
      onPreviousClick,
      onNextClick
    };
  }
});
function _sfc_render$5R(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconLeft = resolveComponent("IconLeft");
  const _component_IconUp = resolveComponent("IconUp");
  const _component_IconRight = resolveComponent("IconRight");
  const _component_IconDown = resolveComponent("IconDown");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-arrow-${_ctx.direction === "vertical" ? "top" : "left"}`),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onPreviousClick && _ctx.onPreviousClick(...args))
    }, [
      _ctx.direction === "horizontal" ? (openBlock(), createBlock(_component_IconLeft, { key: 0 })) : (openBlock(), createBlock(_component_IconUp, { key: 1 }))
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-arrow-${_ctx.direction === "vertical" ? "bottom" : "right"}`),
      onClick: _cache[1] || (_cache[1] = (...args) => _ctx.onNextClick && _ctx.onNextClick(...args))
    }, [
      _ctx.direction === "horizontal" ? (openBlock(), createBlock(_component_IconRight, { key: 0 })) : (openBlock(), createBlock(_component_IconDown, { key: 1 }))
    ], 2)
  ], 2);
}
var CarouselArrow = /* @__PURE__ */ _export_sfc(_sfc_main$5S, [["render", _sfc_render$5R]]);
const carouselInjectionKey = Symbol("ArcoCarousel");
const useChildrenComponents = (name) => {
  const children = {};
  const components2 = ref([]);
  const getComponents = () => {
    if (children.value) {
      const _components = getComponentsFromChildren(children.value, name);
      if (_components.length !== components2.value.length || _components.toString() !== components2.value.toString()) {
        components2.value = _components;
      }
    }
  };
  onMounted(() => getComponents());
  onUpdated(() => getComponents());
  return {
    children,
    components: components2
  };
};
const DEFAULT_AUTO_PLAY = {
  interval: 3e3,
  hoverToPause: true
};
function getValidIndex(i2, length) {
  const indexNumber = +i2;
  return typeof indexNumber === "number" && !Number.isNaN(indexNumber) ? (indexNumber + length) % length : i2;
}
var _Carousel = defineComponent({
  name: "Carousel",
  props: {
    current: {
      type: Number
    },
    defaultCurrent: {
      type: Number,
      default: 1
    },
    autoPlay: {
      type: [Boolean, Object],
      default: false
    },
    moveSpeed: {
      type: Number,
      default: 500
    },
    animationName: {
      type: String,
      default: "slide"
    },
    trigger: {
      type: String,
      default: "click"
    },
    direction: {
      type: String,
      default: "horizontal"
    },
    showArrow: {
      type: String,
      default: "always"
    },
    arrowClass: {
      type: String,
      default: ""
    },
    indicatorType: {
      type: String,
      default: "dot"
    },
    indicatorPosition: {
      type: String,
      default: "bottom"
    },
    indicatorClass: {
      type: String,
      default: ""
    },
    transitionTimingFunction: {
      type: String,
      default: "cubic-bezier(0.34, 0.69, 0.1, 1)"
    }
  },
  emits: {
    "update:current": (index2) => true,
    "change": (index2, prevIndex, isManual) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      current,
      animationName,
      moveSpeed,
      transitionTimingFunction
    } = toRefs(props);
    const prefixCls = getPrefixCls("carousel");
    const isPause = ref(false);
    const previousIndex = ref();
    const slideDirection = ref();
    const computedAutoPlay = computed(() => {
      if (isObject(props.autoPlay)) {
        return {
          ...DEFAULT_AUTO_PLAY,
          ...props.autoPlay
        };
      }
      return props.autoPlay ? DEFAULT_AUTO_PLAY : {};
    });
    let intervalTimer = 0;
    let animationTimer = 0;
    const {
      children,
      components: components2
    } = useChildrenComponents("CarouselItem");
    const _index = ref(props.defaultCurrent - 1);
    const mergedIndexes = computed(() => {
      const childrenLength = components2.value.length;
      const mergedIndex = isNumber(current.value) ? getValidIndex(current.value - 1, childrenLength) : _index.value;
      const prevIndex = getValidIndex(mergedIndex - 1, childrenLength);
      const nextIndex = getValidIndex(mergedIndex + 1, childrenLength);
      return {
        mergedIndex,
        mergedPrevIndex: prevIndex,
        mergedNextIndex: nextIndex
      };
    });
    const carouselContext = reactive({
      items: components2,
      slideTo,
      mergedIndexes,
      previousIndex,
      animationName,
      slideDirection,
      transitionTimingFunction,
      moveSpeed
    });
    provide(carouselInjectionKey, carouselContext);
    const clearTimer = () => {
      if (intervalTimer) {
        window.clearInterval(intervalTimer);
      }
    };
    watchEffect(() => {
      var _a;
      const {
        interval
      } = computedAutoPlay.value || {};
      const {
        mergedNextIndex
      } = mergedIndexes.value;
      const shouldInterval = ((_a = components2.value) == null ? void 0 : _a.length) > 1 && !isPause.value && Boolean(interval);
      clearTimer();
      if (shouldInterval) {
        intervalTimer = window.setInterval(() => {
          slideTo({
            targetIndex: mergedNextIndex
          });
        }, interval);
      }
    });
    onBeforeUnmount(() => {
      clearTimer();
    });
    function slideTo({
      targetIndex,
      isNegative = false,
      isManual = false
    }) {
      if (!animationTimer && targetIndex !== mergedIndexes.value.mergedIndex) {
        previousIndex.value = _index.value;
        _index.value = targetIndex;
        slideDirection.value = isNegative ? "negative" : "positive";
        animationTimer = window.setTimeout(() => {
          animationTimer = 0;
        }, moveSpeed.value);
        emit("update:current", _index.value + 1);
        emit("change", _index.value + 1, previousIndex.value + 1, isManual);
      }
    }
    const onPreviousClick = () => slideTo({
      targetIndex: mergedIndexes.value.mergedPrevIndex,
      isNegative: true,
      isManual: true
    });
    const onNextClick = () => slideTo({
      targetIndex: mergedIndexes.value.mergedNextIndex,
      isManual: true
    });
    const onSelect = (index2) => slideTo({
      targetIndex: index2,
      isNegative: index2 < mergedIndexes.value.mergedIndex,
      isManual: true
    });
    const eventHandlers = computed(() => {
      return computedAutoPlay.value.hoverToPause ? {
        onMouseenter: () => {
          isPause.value = true;
        },
        onMouseleave: () => {
          isPause.value = false;
        }
      } : {};
    });
    const hasIndicator = computed(() => {
      return props.indicatorType !== "never" && components2.value.length > 1;
    });
    const hasArrow = computed(() => {
      return props.showArrow !== "never" && components2.value.length > 1;
    });
    const cls = computed(() => {
      return [prefixCls, `${prefixCls}-indicator-position-${props.indicatorPosition}`];
    });
    const contentCls = computed(() => {
      return [`${prefixCls}-${props.animationName}`, `${prefixCls}-${props.direction}`, {
        [`${prefixCls}-negative`]: slideDirection.value === "negative"
      }];
    });
    const indicatorCls = computed(() => {
      return [`${prefixCls}-indicator-wrapper`, `${prefixCls}-indicator-wrapper-${props.indicatorPosition}`];
    });
    return () => {
      var _a;
      children.value = (_a = slots.default) == null ? void 0 : _a.call(slots);
      return createVNode("div", mergeProps({
        "class": cls.value
      }, eventHandlers.value), [createVNode("div", {
        "class": contentCls.value
      }, [children.value]), hasIndicator.value && createVNode("div", {
        "class": indicatorCls.value
      }, [createVNode(CarouselIndicator, {
        "class": props.indicatorClass,
        "type": props.indicatorType,
        "count": components2.value.length,
        "activeIndex": mergedIndexes.value.mergedIndex,
        "position": props.indicatorPosition,
        "trigger": props.trigger,
        "onSelect": onSelect
      }, null)]), hasArrow.value && createVNode(CarouselArrow, {
        "class": props.arrowClass,
        "direction": props.direction,
        "showArrow": props.showArrow,
        "onPreviousClick": onPreviousClick,
        "onNextClick": onNextClick
      }, null)]);
    };
  }
});
const _sfc_main$5R = defineComponent({
  name: "CarouselItem",
  setup() {
    const prefixCls = getPrefixCls("carousel-item");
    const instance = getCurrentInstance();
    const context = inject(carouselInjectionKey, {});
    const index2 = computed(
      () => {
        var _a, _b, _c;
        return (_c = (_b = context.items) == null ? void 0 : _b.indexOf((_a = instance == null ? void 0 : instance.uid) != null ? _a : -1)) != null ? _c : -1;
      }
    );
    const isCurrent = computed(
      () => {
        var _a;
        return ((_a = context.mergedIndexes) == null ? void 0 : _a.mergedIndex) === index2.value;
      }
    );
    const cls = computed(() => {
      const { previousIndex, animationName, slideDirection, mergedIndexes } = context;
      return {
        [`${prefixCls}-prev`]: index2.value === (mergedIndexes == null ? void 0 : mergedIndexes.mergedPrevIndex),
        [`${prefixCls}-next`]: index2.value === (mergedIndexes == null ? void 0 : mergedIndexes.mergedNextIndex),
        [`${prefixCls}-current`]: isCurrent.value,
        [`${prefixCls}-slide-in`]: animationName === "slide" && slideDirection && isCurrent.value,
        [`${prefixCls}-slide-out`]: animationName === "slide" && slideDirection && index2.value === previousIndex
      };
    });
    const animationStyle = computed(() => {
      const { transitionTimingFunction, moveSpeed } = context;
      return {
        transitionTimingFunction,
        transitionDuration: `${moveSpeed}ms`,
        animationTimingFunction: transitionTimingFunction,
        animationDuration: `${moveSpeed}ms`
      };
    });
    return {
      cls,
      animationStyle,
      isCurrent
    };
  }
});
const _hoisted_1$4x = ["aria-hidden"];
function _sfc_render$5Q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    "aria-hidden": !_ctx.isCurrent,
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.animationStyle)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 14, _hoisted_1$4x);
}
var CarouselItem = /* @__PURE__ */ _export_sfc(_sfc_main$5R, [["render", _sfc_render$5Q]]);
const Carousel = Object.assign(_Carousel, {
  Item: CarouselItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Carousel.name, _Carousel);
    app.component(componentPrefix + CarouselItem.name, CarouselItem);
  }
});
const getOptionInfos = (options, {
  optionMap,
  leafOptionMap,
  leafOptionSet,
  leafOptionValueMap,
  totalLevel: innerLevel,
  checkStrictly,
  enabledLazyLoad,
  lazyLoadOptions,
  valueKey,
  fieldNames
}) => {
  let totalLevel = 0;
  const travelOptions = (options2, parent, level) => {
    var _a;
    const parentPath = (_a = parent == null ? void 0 : parent.path) != null ? _a : [];
    totalLevel = Math.max(totalLevel, level != null ? level : 1);
    return options2.map((item, index2) => {
      var _a2;
      const value = item[fieldNames.value];
      const data = {
        raw: item,
        value,
        label: (_a2 = item[fieldNames.label]) != null ? _a2 : String(value),
        disabled: Boolean(item[fieldNames.disabled]),
        selectionDisabled: false,
        render: item[fieldNames.render],
        tagProps: item[fieldNames.tagProps],
        isLeaf: item[fieldNames.isLeaf],
        level: parentPath.length,
        index: index2,
        key: "",
        valueKey: String(isObject(value) ? value[valueKey.value] : value),
        parent,
        path: [],
        pathValue: []
      };
      const path = parentPath.concat(data);
      const pathValue = [];
      const key = path.map((item2) => {
        pathValue.push(item2.value);
        return item2.valueKey;
      }).join("-");
      data.path = path;
      data.pathValue = pathValue;
      data.key = key;
      if (item[fieldNames.children]) {
        data.isLeaf = false;
        data.children = travelOptions(
          item[fieldNames.children],
          data,
          (level != null ? level : 1) + 1
        );
      } else if (enabledLazyLoad && !data.isLeaf) {
        data.isLeaf = false;
        if (lazyLoadOptions[key]) {
          data.children = travelOptions(
            lazyLoadOptions[key],
            data,
            (level != null ? level : 1) + 1
          );
        }
      } else {
        data.isLeaf = true;
      }
      if (data.children && !data.disabled) {
        data.totalLeafOptions = data.children.reduce((pre, item2) => {
          if (isNumber(item2.totalLeafOptions)) {
            return pre + item2.totalLeafOptions;
          }
          if (item2.disabled || item2.selectionDisabled) {
            return pre;
          }
          return pre + (item2.isLeaf ? 1 : 0);
        }, 0);
        if (data.totalLeafOptions === 0 && !checkStrictly.value) {
          data.selectionDisabled = true;
        }
      }
      optionMap.set(data.key, data);
      if (data.isLeaf || checkStrictly.value) {
        leafOptionSet.add(data);
        leafOptionMap.set(data.key, data);
        if (!leafOptionValueMap.has(data.valueKey)) {
          leafOptionValueMap.set(data.valueKey, data.key);
        }
      }
      return data;
    });
  };
  const result = travelOptions(options);
  innerLevel.value = totalLevel;
  return result;
};
const getCheckedStatus = (option, valueMap) => {
  var _a, _b;
  let checked = false;
  let indeterminate = false;
  if (option.isLeaf) {
    if (valueMap == null ? void 0 : valueMap.has(option.key)) {
      checked = true;
    }
  } else {
    const reg = new RegExp(`^${option.key}(-|$)`);
    const checkedLeafOptionNumber = Array.from((_a = valueMap == null ? void 0 : valueMap.keys()) != null ? _a : []).reduce(
      (pre, key) => {
        if (reg.test(key)) {
          return pre + 1;
        }
        return pre;
      },
      0
    );
    if (checkedLeafOptionNumber > 0 && checkedLeafOptionNumber >= ((_b = option.totalLeafOptions) != null ? _b : 1)) {
      checked = true;
    } else if (checkedLeafOptionNumber > 0) {
      indeterminate = true;
    }
  }
  return {
    checked,
    indeterminate
  };
};
const getLeafOptionKeys = (option) => {
  const keys = [];
  if (option.isLeaf) {
    keys.push(option.key);
  } else if (option.children) {
    for (const item of option.children) {
      keys.push(...getLeafOptionKeys(item));
    }
  }
  return keys;
};
const getLeafOptionInfos = (option) => {
  const infos = [];
  if (option.disabled || option.selectionDisabled) {
    return infos;
  }
  if (option.isLeaf) {
    infos.push(option);
  } else if (option.children) {
    for (const item of option.children) {
      infos.push(...getLeafOptionInfos(item));
    }
  }
  return infos;
};
const getValueKey = (value, {
  valueKey,
  leafOptionValueMap
}) => {
  var _a;
  if (isArray(value)) {
    return value.map((item) => {
      if (isObject(item))
        return item[valueKey];
      return item;
    }).join("-");
  }
  const _value = isObject(value) ? value[valueKey] : value;
  return (_a = leafOptionValueMap.get(String(_value))) != null ? _a : String(_value);
};
const getValidValues = (value, { multiple, pathMode }) => {
  if (!isArray(value)) {
    return isUndefined(value) || isNull(value) || value === "" ? [] : [value];
  }
  if (pathMode && !multiple && value.length > 0 && !isArray(value[0])) {
    return [value];
  }
  return value;
};
const getOptionLabel = (option) => {
  return option.path.map((item) => item.label).join(" / ");
};
const cascaderInjectionKey = Symbol("ArcoCascader");
var CascaderOption = defineComponent({
  name: "CascaderOption",
  props: {
    option: {
      type: Object,
      required: true
    },
    active: Boolean,
    multiple: Boolean,
    checkStrictly: Boolean,
    searchOption: Boolean,
    pathLabel: Boolean
  },
  setup(props) {
    const prefixCls = getPrefixCls("cascader-option");
    const cascaderCtx = inject(cascaderInjectionKey, {});
    const isLoading = ref(false);
    const events = {};
    const handlePathChange = (ev) => {
      var _a;
      if (isFunction(cascaderCtx.loadMore) && !props.option.isLeaf) {
        const {
          isLeaf,
          children,
          key
        } = props.option;
        if (!isLeaf && !children) {
          isLoading.value = true;
          new Promise((resolve) => {
            var _a2;
            (_a2 = cascaderCtx.loadMore) == null ? void 0 : _a2.call(cascaderCtx, props.option.raw, resolve);
          }).then((children2) => {
            var _a2;
            isLoading.value = false;
            if (children2) {
              (_a2 = cascaderCtx.addLazyLoadOptions) == null ? void 0 : _a2.call(cascaderCtx, children2, key);
            }
          });
        }
      }
      (_a = cascaderCtx.setSelectedPath) == null ? void 0 : _a.call(cascaderCtx, props.option.key);
    };
    if (!props.option.disabled) {
      events.onMouseenter = [() => {
        var _a;
        return (_a = cascaderCtx.setActiveKey) == null ? void 0 : _a.call(cascaderCtx, props.option.key);
      }];
      events.onMouseleave = () => {
        var _a;
        return (_a = cascaderCtx.setActiveKey) == null ? void 0 : _a.call(cascaderCtx);
      };
      events.onClick = [];
      if (cascaderCtx.expandTrigger === "hover") {
        events.onMouseenter.push((ev) => handlePathChange());
      } else {
        events.onClick.push((ev) => handlePathChange());
      }
      if (props.option.isLeaf && !props.multiple) {
        events.onClick.push((ev) => {
          var _a;
          handlePathChange();
          (_a = cascaderCtx.onClickOption) == null ? void 0 : _a.call(cascaderCtx, props.option);
        });
      }
    }
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-active`]: props.active,
      [`${prefixCls}-disabled`]: props.option.disabled
    }]);
    const checkedStatus = computed(() => {
      var _a;
      if (props.checkStrictly) {
        return {
          checked: (_a = cascaderCtx.valueMap) == null ? void 0 : _a.has(props.option.key),
          indeterminate: false
        };
      }
      return getCheckedStatus(props.option, cascaderCtx.valueMap);
    });
    const renderLabelContent = () => {
      var _a, _b, _c;
      if (props.pathLabel) {
        return (_b = (_a = cascaderCtx == null ? void 0 : cascaderCtx.formatLabel) == null ? void 0 : _a.call(cascaderCtx, props.option.path.map((item) => item.raw))) != null ? _b : getOptionLabel(props.option);
      }
      if ((_c = cascaderCtx.slots) == null ? void 0 : _c.option) {
        return cascaderCtx.slots.option({
          data: props.option
        });
      }
      if (isFunction(props.option.render)) {
        return props.option.render();
      }
      return props.option.label;
    };
    const renderIcon = () => {
      if (isLoading.value) {
        return createVNode(IconLoading, null, null);
      }
      if (!props.searchOption && !props.option.isLeaf) {
        return createVNode(IconRight, null, null);
      }
      return null;
    };
    return () => {
      var _a;
      return createVNode("li", mergeProps({
        "tabindex": "0",
        "role": "menuitem",
        "aria-disabled": props.option.disabled,
        "aria-haspopup": !props.option.isLeaf,
        "aria-expanded": !props.option.isLeaf && props.active,
        "title": props.option.label,
        "class": cls.value
      }, events), [props.multiple && createVNode(Checkbox, {
        "modelValue": checkedStatus.value.checked,
        "indeterminate": checkedStatus.value.indeterminate,
        "disabled": props.option.disabled || props.option.selectionDisabled,
        "uninjectGroupContext": true,
        "onChange": (value, ev) => {
          var _a2;
          ev.stopPropagation();
          handlePathChange();
          (_a2 = cascaderCtx.onClickOption) == null ? void 0 : _a2.call(cascaderCtx, props.option, !checkedStatus.value.checked);
        },
        "onClick": (ev) => ev.stopPropagation()
      }, null), props.checkStrictly && !props.multiple && createVNode(Radio, {
        "modelValue": (_a = cascaderCtx.valueMap) == null ? void 0 : _a.has(props.option.key),
        "disabled": props.option.disabled,
        "uninjectGroupContext": true,
        "onChange": (value, ev) => {
          var _a2;
          ev.stopPropagation();
          handlePathChange();
          (_a2 = cascaderCtx.onClickOption) == null ? void 0 : _a2.call(cascaderCtx, props.option, true);
        },
        "onClick": (ev) => ev.stopPropagation()
      }, null), createVNode("div", {
        "class": `${prefixCls}-label`
      }, [renderLabelContent(), renderIcon()])]);
    };
  }
});
var CascaderColumn = defineComponent({
  name: "CascaderColumn",
  props: {
    column: {
      type: Array,
      required: true
    },
    level: {
      type: Number,
      default: 0
    },
    selectedPath: {
      type: Array,
      required: true
    },
    activeKey: String,
    totalLevel: {
      type: Number,
      required: true
    },
    multiple: Boolean,
    checkStrictly: Boolean,
    virtualListProps: {
      type: Object
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("cascader");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const virtualListRef = ref();
    const isVirtual = ref(Boolean(props.virtualListProps));
    const renderEmpty = () => {
      var _a, _b, _c, _d, _e;
      return (_e = (_d = (_a = slots.empty) == null ? void 0 : _a.call(slots)) != null ? _d : (_c = configCtx == null ? void 0 : (_b = configCtx.slots).empty) == null ? void 0 : _c.call(_b, {
        component: "cascader"
      })) != null ? _e : createVNode(Empty, null, null);
    };
    return () => {
      var _a;
      return createVNode("div", {
        "class": `${prefixCls}-panel-column`,
        "style": {
          zIndex: props.totalLevel - props.level
        }
      }, [props.column.length === 0 ? createVNode(Scrollbar, {
        "class": `${prefixCls}-column-content`
      }, {
        default: () => [createVNode("div", {
          "class": `${prefixCls}-list-empty`
        }, [renderEmpty()])]
      }) : isVirtual.value ? createVNode(VirtualList, mergeProps({
        "key": (_a = props.column) == null ? void 0 : _a.length
      }, props.virtualListProps, {
        "ref": virtualListRef,
        "data": props.column
      }), {
        item: ({
          item
        }) => {
          return createVNode(CascaderOption, {
            "key": item.key,
            "option": item,
            "active": props.selectedPath.includes(item.key) || item.key === props.activeKey,
            "multiple": props.multiple,
            "checkStrictly": props.checkStrictly
          }, null);
        }
      }) : createVNode(Scrollbar, {
        "class": `${prefixCls}-column-content`
      }, {
        default: () => [createVNode("ul", {
          "role": "menu",
          "class": [`${prefixCls}-list`, {
            [`${prefixCls}-list-multiple`]: Boolean(props == null ? void 0 : props.multiple),
            [`${prefixCls}-list-strictly`]: Boolean(props == null ? void 0 : props.checkStrictly)
          }]
        }, [props.column.map((item) => {
          return createVNode(CascaderOption, {
            "key": item.key,
            "option": item,
            "active": props.selectedPath.includes(item.key) || item.key === props.activeKey,
            "multiple": props.multiple,
            "checkStrictly": props.checkStrictly
          }, null);
        })])]
      })]);
    };
  }
});
function _isSlot$e(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var BaseCascaderPanel = defineComponent({
  name: "BaseCascaderPanel",
  props: {
    displayColumns: {
      type: Array,
      required: true
    },
    selectedPath: {
      type: Array,
      required: true
    },
    activeKey: String,
    totalLevel: {
      type: Number,
      required: true
    },
    multiple: Boolean,
    checkStrictly: Boolean,
    loading: Boolean,
    dropdown: Boolean,
    virtualListProps: {
      type: Object
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("cascader");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const renderEmpty = () => {
      var _a, _b, _c, _d, _e;
      return (_e = (_d = (_a = slots.empty) == null ? void 0 : _a.call(slots)) != null ? _d : (_c = configCtx == null ? void 0 : (_b = configCtx.slots).empty) == null ? void 0 : _c.call(_b, {
        component: "cascader"
      })) != null ? _e : createVNode(Empty, null, null);
    };
    const renderContent = () => {
      if (props.loading) {
        return createVNode("div", {
          "key": "panel-column-loading",
          "class": [`${prefixCls}-panel-column`, `${prefixCls}-panel-column-loading`]
        }, [createVNode(Spin, null, null)]);
      }
      if (props.displayColumns.length === 0) {
        return createVNode("div", {
          "key": "panel-column-empty",
          "class": `${prefixCls}-panel-column`
        }, [createVNode("div", {
          "class": `${prefixCls}-list-empty`
        }, [renderEmpty()])]);
      }
      return props.displayColumns.map((column, index2) => createVNode(CascaderColumn, {
        "key": `column-${index2}`,
        "column": column,
        "level": index2,
        "selectedPath": props.selectedPath,
        "activeKey": props.activeKey,
        "totalLevel": props.totalLevel,
        "multiple": props.multiple,
        "checkStrictly": props.checkStrictly,
        "virtualListProps": props.virtualListProps
      }, {
        empty: slots.empty
      }));
    };
    return () => {
      let _slot;
      return createVNode(TransitionGroup, {
        "tag": "div",
        "name": "cascader-slide",
        "class": [`${prefixCls}-panel`, {
          [`${prefixCls}-dropdown-panel`]: props.dropdown
        }]
      }, _isSlot$e(_slot = renderContent()) ? _slot : {
        default: () => [_slot]
      });
    };
  }
});
function _isSlot$d(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var CascaderSearchPanel = defineComponent({
  name: "CascaderSearchPanel",
  props: {
    options: {
      type: Array,
      required: true
    },
    loading: Boolean,
    activeKey: String,
    multiple: Boolean,
    checkStrictly: Boolean,
    pathLabel: Boolean
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("cascader");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const renderContent = () => {
      var _a, _b, _c, _d, _e;
      if (props.loading) {
        return createVNode(Spin, null, null);
      }
      if (props.options.length === 0) {
        return createVNode("div", {
          "class": `${prefixCls}-list-empty`
        }, [(_e = (_d = (_a = slots.empty) == null ? void 0 : _a.call(slots)) != null ? _d : (_c = configCtx == null ? void 0 : (_b = configCtx.slots).empty) == null ? void 0 : _c.call(_b, {
          component: "cascader"
        })) != null ? _e : createVNode(Empty, null, null)]);
      }
      return createVNode("ul", {
        "role": "menu",
        "class": [`${prefixCls}-list`, `${prefixCls}-search-list`, {
          [`${prefixCls}-list-multiple`]: props.multiple
        }]
      }, [props.options.map((item) => createVNode(CascaderOption, {
        "key": item.key,
        "class": `${prefixCls}-search-option`,
        "option": item,
        "active": item.key === props.activeKey,
        "multiple": props.multiple,
        "checkStrictly": props.checkStrictly,
        "pathLabel": props.pathLabel,
        "searchOption": true
      }, null))]);
    };
    return () => {
      let _slot;
      return createVNode(Scrollbar, {
        "class": [`${prefixCls}-panel`, `${prefixCls}-search-panel`]
      }, _isSlot$d(_slot = renderContent()) ? _slot : {
        default: () => [_slot]
      });
    };
  }
});
const useSelectedPath = (options, {
  optionMap,
  filteredLeafOptions,
  showSearchPanel,
  expandChild
}) => {
  const activeKey = ref();
  const activeOption = computed(() => {
    if (activeKey.value)
      return optionMap.get(activeKey.value);
    return void 0;
  });
  const selectedPath = ref([]);
  const displayColumns = computed(() => {
    const columns = [options.value];
    for (const key of selectedPath.value) {
      const option = optionMap.get(key);
      if (option == null ? void 0 : option.children) {
        columns.push(option.children);
      }
    }
    return columns;
  });
  const setSelectedPath = (key) => {
    var _a;
    const option = getTargetOption(key);
    selectedPath.value = (_a = option == null ? void 0 : option.path.map((item) => item.key)) != null ? _a : [];
  };
  const setActiveKey = (key) => {
    activeKey.value = key;
  };
  const enabledOptions = computed(() => {
    var _a;
    if (showSearchPanel == null ? void 0 : showSearchPanel.value) {
      return filteredLeafOptions.value.filter((item) => !item.disabled);
    }
    if (activeOption.value && activeOption.value.parent) {
      return (_a = activeOption.value.parent.children) == null ? void 0 : _a.filter(
        (item) => !item.disabled
      );
    }
    return options.value.filter((item) => !item.disabled);
  });
  const getTargetOption = (key) => {
    let target2 = key ? optionMap.get(key) : void 0;
    if (expandChild.value) {
      while (target2 && target2.children && target2.children.length > 0) {
        target2 = target2.children[0];
      }
    }
    return target2;
  };
  const getNextActiveNode = (direction) => {
    var _a, _b, _c, _d, _e, _f, _g;
    const _length = (_b = (_a = enabledOptions.value) == null ? void 0 : _a.length) != null ? _b : 0;
    if (activeKey.value) {
      const enabledIndex = (_d = (_c = enabledOptions.value) == null ? void 0 : _c.findIndex(
        (item) => item.key === activeKey.value
      )) != null ? _d : 0;
      if (direction === "next") {
        return (_e = enabledOptions.value) == null ? void 0 : _e[(_length + enabledIndex + 1) % _length];
      }
      return (_f = enabledOptions.value) == null ? void 0 : _f[(_length + enabledIndex - 1) % _length];
    }
    return (_g = enabledOptions.value) == null ? void 0 : _g[0];
  };
  return {
    activeKey,
    activeOption,
    selectedPath,
    displayColumns,
    setActiveKey,
    setSelectedPath,
    getNextActiveNode
  };
};
const _sfc_main$5Q = defineComponent({
  name: "Cascader",
  components: {
    Trigger,
    SelectView,
    BaseCascaderPanel,
    CascaderSearchPanel
  },
  inheritAttrs: false,
  props: {
    pathMode: {
      type: Boolean,
      default: false
    },
    multiple: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: [String, Number, Object, Array]
    },
    defaultValue: {
      type: [String, Number, Object, Array],
      default: (props) => props.multiple ? [] : props.pathMode ? void 0 : ""
    },
    options: {
      type: Array,
      default: () => []
    },
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    allowSearch: {
      type: Boolean,
      default: (props) => Boolean(props.multiple)
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    inputValue: {
      type: String,
      default: void 0
    },
    defaultInputValue: {
      type: String,
      default: ""
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    expandTrigger: {
      type: String,
      default: "click"
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    placeholder: String,
    filterOption: {
      type: Function
    },
    popupContainer: {
      type: [String, Object]
    },
    maxTagCount: {
      type: Number,
      default: 0
    },
    formatLabel: {
      type: Function
    },
    triggerProps: {
      type: Object
    },
    checkStrictly: {
      type: Boolean,
      default: false
    },
    loadMore: {
      type: Function
    },
    loading: {
      type: Boolean,
      default: false
    },
    searchOptionOnlyLabel: {
      type: Boolean,
      default: false
    },
    searchDelay: {
      type: Number,
      default: 500
    },
    fieldNames: {
      type: Object
    },
    valueKey: {
      type: String,
      default: "value"
    },
    fallback: {
      type: [Boolean, Function],
      default: true
    },
    expandChild: {
      type: Boolean,
      default: false
    },
    virtualListProps: {
      type: Object
    },
    tagNowrap: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "update:popupVisible": (visible) => true,
    "change": (value) => true,
    "inputValueChange": (value) => true,
    "clear": () => true,
    "search": (value) => true,
    "popupVisibleChange": (visible) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, { emit, slots }) {
    const {
      options,
      checkStrictly,
      loadMore,
      formatLabel,
      modelValue,
      disabled,
      valueKey,
      expandTrigger,
      expandChild,
      pathMode,
      multiple
    } = toRefs(props);
    const _value = ref(props.defaultValue);
    const _inputValue = ref(props.defaultInputValue);
    const _popupVisible = ref(props.defaultPopupVisible);
    const { mergedDisabled, eventHandlers } = useFormItem({ disabled });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = props.multiple ? [] : void 0;
      }
    });
    const optionInfos = ref([]);
    const totalLevel = ref(1);
    const optionMap = reactive(/* @__PURE__ */ new Map());
    const leafOptionMap = reactive(/* @__PURE__ */ new Map());
    const leafOptionValueMap = reactive(/* @__PURE__ */ new Map());
    const leafOptionSet = reactive(/* @__PURE__ */ new Set());
    const lazyLoadOptions = reactive({});
    const addLazyLoadOptions = (children, key) => {
      lazyLoadOptions[key] = children;
    };
    const DEFAULT_FIELD_NAMES2 = {
      value: "value",
      label: "label",
      disabled: "disabled",
      children: "children",
      tagProps: "tagProps",
      render: "render",
      isLeaf: "isLeaf"
    };
    const mergedFieldNames = computed(() => ({
      ...DEFAULT_FIELD_NAMES2,
      ...props.fieldNames
    }));
    watch(
      [options, lazyLoadOptions, mergedFieldNames],
      ([_options, _lazyLoadOptions, _fieldNames]) => {
        optionMap.clear();
        leafOptionMap.clear();
        leafOptionValueMap.clear();
        leafOptionSet.clear();
        optionInfos.value = getOptionInfos(_options != null ? _options : [], {
          enabledLazyLoad: Boolean(props.loadMore),
          lazyLoadOptions,
          optionMap,
          leafOptionSet,
          leafOptionMap,
          leafOptionValueMap,
          totalLevel,
          checkStrictly,
          valueKey,
          fieldNames: _fieldNames
        });
      },
      {
        immediate: true,
        deep: true
      }
    );
    const computedValueMap = computed(() => {
      var _a;
      const values = getValidValues((_a = props.modelValue) != null ? _a : _value.value, {
        multiple: props.multiple,
        pathMode: props.pathMode
      });
      return new Map(
        values.map((value) => [
          getValueKey(value, {
            valueKey: props.valueKey,
            leafOptionValueMap
          }),
          value
        ])
      );
    });
    const computedInputValue = computed(
      () => {
        var _a;
        return (_a = props.inputValue) != null ? _a : _inputValue.value;
      }
    );
    const computedPopupVisible = computed(
      () => {
        var _a;
        return (_a = props.popupVisible) != null ? _a : _popupVisible.value;
      }
    );
    const getFilteredStatus = (label) => {
      var _a;
      return label == null ? void 0 : label.toLocaleLowerCase().includes((_a = computedInputValue.value) == null ? void 0 : _a.toLocaleLowerCase());
    };
    const filteredLeafOptions = computed(() => {
      const options2 = props.checkStrictly ? Array.from(optionMap.values()) : Array.from(leafOptionSet);
      return options2.filter((item) => {
        var _a;
        if (isFunction(props.filterOption)) {
          return props.filterOption(computedInputValue.value, item.raw);
        }
        if (props.checkStrictly) {
          return getFilteredStatus(item.label);
        }
        return (_a = item.path) == null ? void 0 : _a.find((leaf) => getFilteredStatus(leaf.label));
      });
    });
    const updateValue = (values) => {
      var _a, _b, _c;
      const value = props.multiple ? values : (_a = values[0]) != null ? _a : "";
      if (values.length === 0) {
        setSelectedPath();
        setActiveKey();
      }
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value);
      (_c = (_b = eventHandlers.value) == null ? void 0 : _b.onChange) == null ? void 0 : _c.call(_b);
    };
    watch([multiple, pathMode], () => {
      const values = [];
      computedValueMap.value.forEach((value, key) => {
        const option = leafOptionMap.get(key);
        if (option) {
          values.push(pathMode.value ? option.pathValue : option.value);
        }
      });
      updateValue(values);
    });
    const handlePopupVisibleChange = (visible) => {
      if (computedPopupVisible.value !== visible) {
        _popupVisible.value = visible;
        emit("popupVisibleChange", visible);
      }
    };
    const handleRemove = (key) => {
      if (props.multiple) {
        const option = leafOptionMap.get(key);
        if (option) {
          selectMultiple(option, false);
        } else {
          const values = [];
          computedValueMap.value.forEach((value, _key) => {
            if (_key !== key) {
              values.push(value);
            }
          });
          updateValue(values);
        }
      }
    };
    const selectSingle = (option) => {
      updateValue([props.pathMode ? option.pathValue : option.value]);
      handlePopupVisibleChange(false);
    };
    const selectMultiple = (option, checked) => {
      if (checked) {
        const leafOptionInfos = props.checkStrictly ? [option] : getLeafOptionInfos(option);
        updateValue([
          ...computedValueMap.value.values(),
          ...leafOptionInfos.filter((item) => !computedValueMap.value.has(item.key)).map((item) => {
            return props.pathMode ? item.pathValue : item.value;
          })
        ]);
      } else {
        const leafOptionKeys = props.checkStrictly ? [option.key] : getLeafOptionKeys(option);
        const values = [];
        computedValueMap.value.forEach((value, key) => {
          if (!leafOptionKeys.includes(key)) {
            values.push(value);
          }
        });
        updateValue(values);
      }
      handleInputValueChange("", "optionChecked");
    };
    const handleClickOption = (option, checked) => {
      if (props.multiple) {
        selectMultiple(option, checked != null ? checked : true);
      } else {
        selectSingle(option);
      }
    };
    const handleSearch = debounce((value) => {
      emit("search", value);
    }, props.searchDelay);
    const handleInputValueChange = (value, reason) => {
      if (value !== computedInputValue.value) {
        if (reason === "manual" && !computedPopupVisible.value) {
          _popupVisible.value = true;
          emit("popupVisibleChange", true);
        }
        _inputValue.value = value;
        emit("inputValueChange", value);
        if (props.allowSearch) {
          handleSearch(value);
        }
      }
    };
    watch(computedPopupVisible, (value) => {
      if (value) {
        if (computedValueMap.value.size > 0) {
          const keys = Array.from(computedValueMap.value.keys());
          const lastKey = keys[keys.length - 1];
          const option = leafOptionMap.get(lastKey);
          if (option && option.key !== activeKey.value) {
            setSelectedPath(option.key);
            setActiveKey(option.key);
          }
        }
      } else {
        if (computedValueMap.value.size === 0) {
          setSelectedPath();
          setActiveKey();
        }
        handleInputValueChange("", "optionListHide");
      }
    });
    const handleClear = (e) => {
      e.stopPropagation();
      if (props.multiple) {
        const newValues = [];
        computedValueMap.value.forEach((value, key) => {
          const option = leafOptionMap.get(key);
          if (option == null ? void 0 : option.disabled) {
            newValues.push(props.pathMode ? option.pathValue : option.value);
          }
        });
        updateValue(newValues);
      } else {
        updateValue([]);
      }
      handleInputValueChange("", "manual");
      emit("clear");
    };
    const showSearchPanel = computed(
      () => props.allowSearch && computedInputValue.value.length > 0
    );
    const handleFocus = (e) => {
      emit("focus", e);
    };
    const handleBlur = (e) => {
      emit("blur", e);
    };
    const {
      activeKey,
      activeOption,
      selectedPath,
      displayColumns,
      setActiveKey,
      setSelectedPath,
      getNextActiveNode
    } = useSelectedPath(optionInfos, {
      optionMap,
      filteredLeafOptions,
      showSearchPanel,
      expandChild
    });
    provide(
      cascaderInjectionKey,
      reactive({
        onClickOption: handleClickOption,
        setActiveKey,
        setSelectedPath,
        loadMore,
        expandTrigger,
        addLazyLoadOptions,
        formatLabel,
        slots,
        valueMap: computedValueMap
      })
    );
    const handleKeyDown = getKeyDownHandler(
      /* @__PURE__ */ new Map([
        [
          KEYBOARD_KEY.ENTER,
          (ev) => {
            if (computedPopupVisible.value) {
              if (activeOption.value) {
                let checked;
                if (props.checkStrictly || activeOption.value.isLeaf) {
                  checked = !computedValueMap.value.has(activeOption.value.key);
                } else {
                  checked = !getCheckedStatus(
                    activeOption.value,
                    computedValueMap.value
                  ).checked;
                }
                setSelectedPath(activeOption.value.key);
                handleClickOption(activeOption.value, checked);
              }
            } else {
              handlePopupVisibleChange(true);
            }
          }
        ],
        [
          KEYBOARD_KEY.ESC,
          (ev) => {
            handlePopupVisibleChange(false);
          }
        ],
        [
          KEYBOARD_KEY.ARROW_DOWN,
          (ev) => {
            ev.preventDefault();
            const activeNode = getNextActiveNode("next");
            setActiveKey(activeNode == null ? void 0 : activeNode.key);
          }
        ],
        [
          KEYBOARD_KEY.ARROW_UP,
          (ev) => {
            ev.preventDefault();
            const activeNode = getNextActiveNode("preview");
            setActiveKey(activeNode == null ? void 0 : activeNode.key);
          }
        ],
        [
          KEYBOARD_KEY.ARROW_RIGHT,
          (ev) => {
            var _a, _b;
            if (!showSearchPanel.value) {
              ev.preventDefault();
              if ((_a = activeOption.value) == null ? void 0 : _a.children) {
                setSelectedPath(activeOption.value.key);
                setActiveKey((_b = activeOption.value.children[0]) == null ? void 0 : _b.key);
              }
            }
          }
        ],
        [
          KEYBOARD_KEY.ARROW_LEFT,
          (ev) => {
            var _a;
            if (!showSearchPanel.value) {
              ev.preventDefault();
              if ((_a = activeOption.value) == null ? void 0 : _a.parent) {
                setSelectedPath(activeOption.value.parent.key);
                setActiveKey(activeOption.value.parent.key);
              }
            }
          }
        ]
      ])
    );
    const selectViewValue = computed(() => {
      const result = [];
      computedValueMap.value.forEach((value, key) => {
        var _a, _b;
        const option = leafOptionMap.get(key);
        if (option) {
          result.push({
            value: key,
            label: (_b = (_a = props.formatLabel) == null ? void 0 : _a.call(props, option.path.map((item) => item.raw))) != null ? _b : getOptionLabel(option),
            closable: !option.disabled,
            tagProps: option.tagProps
          });
        } else if (props.fallback) {
          const label = isFunction(props.fallback) ? props.fallback(value) : isArray(value) ? value.join(" / ") : String(value);
          result.push({
            value: key,
            label,
            closable: true
          });
        }
      });
      return result;
    });
    return {
      optionInfos,
      filteredLeafOptions,
      selectedPath,
      activeKey,
      displayColumns,
      computedInputValue,
      computedPopupVisible,
      handleClear,
      selectViewValue,
      handleInputValueChange,
      showSearchPanel,
      handlePopupVisibleChange,
      handleFocus,
      handleBlur,
      handleRemove,
      mergedDisabled,
      handleKeyDown,
      totalLevel
    };
  }
});
function _sfc_render$5P(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_select_view = resolveComponent("select-view");
  const _component_cascader_search_panel = resolveComponent("cascader-search-panel");
  const _component_base_cascader_panel = resolveComponent("base-cascader-panel");
  const _component_trigger = resolveComponent("trigger");
  return openBlock(), createBlock(_component_trigger, mergeProps(_ctx.triggerProps, {
    trigger: "click",
    "animation-name": "slide-dynamic-origin",
    "auto-fit-transform-origin": "",
    "popup-visible": _ctx.computedPopupVisible,
    position: "bl",
    disabled: _ctx.mergedDisabled,
    "popup-offset": 4,
    "auto-fit-popup-width": _ctx.showSearchPanel,
    "popup-container": _ctx.popupContainer,
    "prevent-focus": true,
    "click-to-close": !_ctx.allowSearch,
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }), {
    content: withCtx(() => [
      _ctx.showSearchPanel ? (openBlock(), createBlock(_component_cascader_search_panel, {
        key: 0,
        options: _ctx.filteredLeafOptions,
        "active-key": _ctx.activeKey,
        multiple: _ctx.multiple,
        "check-strictly": _ctx.checkStrictly,
        loading: _ctx.loading,
        "path-label": !_ctx.searchOptionOnlyLabel
      }, createSlots({ _: 2 }, [
        _ctx.$slots.empty ? {
          name: "empty",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "empty")
          ]),
          key: "0"
        } : void 0
      ]), 1032, ["options", "active-key", "multiple", "check-strictly", "loading", "path-label"])) : (openBlock(), createBlock(_component_base_cascader_panel, {
        key: 1,
        "display-columns": _ctx.displayColumns,
        "selected-path": _ctx.selectedPath,
        "active-key": _ctx.activeKey,
        multiple: _ctx.multiple,
        "total-level": _ctx.totalLevel,
        "check-strictly": _ctx.checkStrictly,
        loading: _ctx.loading,
        "virtual-list-props": _ctx.virtualListProps,
        dropdown: ""
      }, createSlots({ _: 2 }, [
        _ctx.$slots.empty ? {
          name: "empty",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "empty")
          ]),
          key: "0"
        } : void 0
      ]), 1032, ["display-columns", "selected-path", "active-key", "multiple", "total-level", "check-strictly", "loading", "virtual-list-props"]))
    ]),
    default: withCtx(() => [
      createVNode(_component_select_view, mergeProps({
        "model-value": _ctx.selectViewValue,
        "input-value": _ctx.computedInputValue,
        disabled: _ctx.mergedDisabled,
        error: _ctx.error,
        multiple: _ctx.multiple,
        "allow-clear": _ctx.allowClear,
        "allow-search": _ctx.allowSearch,
        size: _ctx.size,
        opened: _ctx.computedPopupVisible,
        placeholder: _ctx.placeholder,
        loading: _ctx.loading,
        "max-tag-count": _ctx.maxTagCount,
        "tag-nowrap": _ctx.tagNowrap
      }, _ctx.$attrs, {
        onInputValueChange: _ctx.handleInputValueChange,
        onClear: _ctx.handleClear,
        onFocus: _ctx.handleFocus,
        onBlur: _ctx.handleBlur,
        onRemove: _ctx.handleRemove,
        onKeydown: _ctx.handleKeyDown
      }), createSlots({ _: 2 }, [
        _ctx.$slots.label ? {
          name: "label",
          fn: withCtx((data) => [
            renderSlot(_ctx.$slots, "label", normalizeProps(guardReactiveProps(data)))
          ]),
          key: "0"
        } : void 0,
        _ctx.$slots.prefix ? {
          name: "prefix",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "prefix")
          ]),
          key: "1"
        } : void 0,
        _ctx.$slots["arrow-icon"] ? {
          name: "arrow-icon",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "arrow-icon")
          ]),
          key: "2"
        } : void 0,
        _ctx.$slots["loading-icon"] ? {
          name: "loading-icon",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "loading-icon")
          ]),
          key: "3"
        } : void 0,
        _ctx.$slots["search-icon"] ? {
          name: "search-icon",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "search-icon")
          ]),
          key: "4"
        } : void 0
      ]), 1040, ["model-value", "input-value", "disabled", "error", "multiple", "allow-clear", "allow-search", "size", "opened", "placeholder", "loading", "max-tag-count", "tag-nowrap", "onInputValueChange", "onClear", "onFocus", "onBlur", "onRemove", "onKeydown"])
    ]),
    _: 3
  }, 16, ["popup-visible", "disabled", "auto-fit-popup-width", "popup-container", "click-to-close", "onPopupVisibleChange"]);
}
var _Cascader = /* @__PURE__ */ _export_sfc(_sfc_main$5Q, [["render", _sfc_render$5P]]);
const _sfc_main$5P = defineComponent({
  name: "CascaderPanel",
  components: {
    BaseCascaderPanel
  },
  props: {
    pathMode: {
      type: Boolean,
      default: false
    },
    multiple: {
      type: Boolean,
      default: false
    },
    modelValue: {
      type: [String, Number, Array]
    },
    defaultValue: {
      type: [String, Number, Array],
      default: (props) => props.multiple ? [] : props.pathMode ? void 0 : ""
    },
    options: {
      type: Array,
      default: () => []
    },
    expandTrigger: {
      type: String,
      default: "click"
    },
    checkStrictly: {
      type: Boolean,
      default: false
    },
    loadMore: {
      type: Function
    },
    fieldNames: {
      type: Object
    },
    valueKey: {
      type: String,
      default: "value"
    },
    expandChild: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value) => true
  },
  setup(props, { emit, slots }) {
    const {
      options,
      checkStrictly,
      loadMore,
      modelValue,
      valueKey,
      expandChild,
      expandTrigger
    } = toRefs(props);
    const _value = ref(props.defaultValue);
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = props.multiple ? [] : void 0;
      }
    });
    const optionInfos = ref([]);
    const totalLevel = ref(1);
    const optionMap = reactive(/* @__PURE__ */ new Map());
    const leafOptionMap = reactive(/* @__PURE__ */ new Map());
    const leafOptionValueMap = reactive(/* @__PURE__ */ new Map());
    const leafOptionSet = reactive(/* @__PURE__ */ new Set());
    const lazyLoadOptions = reactive({});
    const addLazyLoadOptions = (children, key) => {
      lazyLoadOptions[key] = children;
    };
    const DEFAULT_FIELD_NAMES2 = {
      value: "value",
      label: "label",
      disabled: "disabled",
      children: "children",
      tagProps: "tagProps",
      render: "render",
      isLeaf: "isLeaf"
    };
    const mergedFieldNames = computed(() => ({
      ...DEFAULT_FIELD_NAMES2,
      ...props.fieldNames
    }));
    watch(
      [options, lazyLoadOptions, mergedFieldNames],
      ([_options, _lazyLoadOptions, _fieldNames]) => {
        optionMap.clear();
        leafOptionMap.clear();
        leafOptionValueMap.clear();
        leafOptionSet.clear();
        optionInfos.value = getOptionInfos(_options != null ? _options : [], {
          enabledLazyLoad: Boolean(props.loadMore),
          lazyLoadOptions: _lazyLoadOptions,
          optionMap,
          leafOptionSet,
          leafOptionMap,
          leafOptionValueMap,
          totalLevel,
          checkStrictly,
          fieldNames: _fieldNames,
          valueKey
        });
      },
      {
        immediate: true
      }
    );
    const computedValueMap = computed(() => {
      var _a;
      const values = getValidValues((_a = props.modelValue) != null ? _a : _value.value, {
        multiple: props.multiple,
        pathMode: props.pathMode
      });
      return new Map(
        values.map((value) => [
          getValueKey(value, {
            valueKey: props.valueKey,
            leafOptionValueMap
          }),
          value
        ])
      );
    });
    const filteredLeafOptions = computed(
      () => props.checkStrictly ? Array.from(optionMap.values()) : Array.from(leafOptionSet)
    );
    const updateValue = (values) => {
      var _a;
      const value = props.multiple ? values : (_a = values[0]) != null ? _a : "";
      if (values.length === 0) {
        setSelectedPath();
        setActiveKey();
      }
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value);
    };
    const selectSingle = (option) => {
      updateValue([props.pathMode ? option.pathValue : option.value]);
    };
    const selectMultiple = (option, checked) => {
      if (checked) {
        const leafOptionInfos = props.checkStrictly ? [option] : getLeafOptionInfos(option);
        updateValue([
          ...computedValueMap.value.values(),
          ...leafOptionInfos.filter((item) => !computedValueMap.value.has(item.key)).map((item) => {
            return props.pathMode ? item.pathValue : item.value;
          })
        ]);
      } else {
        const leafOptionKeys = props.checkStrictly ? [option.key] : getLeafOptionKeys(option);
        const values = [];
        computedValueMap.value.forEach((value, key) => {
          if (!leafOptionKeys.includes(key)) {
            values.push(value);
          }
        });
        updateValue(values);
      }
    };
    const handleClickOption = (option, checked) => {
      if (props.multiple) {
        selectMultiple(option, checked != null ? checked : true);
      } else {
        selectSingle(option);
      }
    };
    const {
      activeKey,
      activeOption,
      selectedPath,
      displayColumns,
      setActiveKey,
      setSelectedPath,
      getNextActiveNode
    } = useSelectedPath(optionInfos, {
      optionMap,
      filteredLeafOptions,
      expandChild
    });
    provide(
      cascaderInjectionKey,
      reactive({
        onClickOption: handleClickOption,
        setActiveKey,
        setSelectedPath,
        loadMore,
        addLazyLoadOptions,
        slots,
        valueMap: computedValueMap,
        expandTrigger
      })
    );
    const handleKeyDown = getKeyDownHandler(
      /* @__PURE__ */ new Map([
        [
          KEYBOARD_KEY.ENTER,
          (ev) => {
            if (activeOption.value) {
              let checked;
              if (props.checkStrictly || activeOption.value.isLeaf) {
                checked = !computedValueMap.value.has(activeOption.value.key);
              } else {
                checked = !getCheckedStatus(
                  activeOption.value,
                  computedValueMap.value
                ).checked;
              }
              setSelectedPath(activeOption.value.key);
              handleClickOption(activeOption.value, checked);
            }
          }
        ],
        [
          KEYBOARD_KEY.ARROW_DOWN,
          (ev) => {
            ev.preventDefault();
            const activeNode = getNextActiveNode("next");
            setActiveKey(activeNode == null ? void 0 : activeNode.key);
          }
        ],
        [
          KEYBOARD_KEY.ARROW_UP,
          (ev) => {
            ev.preventDefault();
            const activeNode = getNextActiveNode("preview");
            setActiveKey(activeNode == null ? void 0 : activeNode.key);
          }
        ],
        [
          KEYBOARD_KEY.ARROW_RIGHT,
          (ev) => {
            var _a, _b;
            ev.preventDefault();
            if ((_a = activeOption.value) == null ? void 0 : _a.children) {
              setSelectedPath(activeOption.value.key);
              setActiveKey((_b = activeOption.value.children[0]) == null ? void 0 : _b.key);
            }
          }
        ],
        [
          KEYBOARD_KEY.ARROW_LEFT,
          (ev) => {
            var _a;
            ev.preventDefault();
            if ((_a = activeOption.value) == null ? void 0 : _a.parent) {
              setSelectedPath(activeOption.value.parent.key);
              setActiveKey(activeOption.value.parent.key);
            }
          }
        ]
      ])
    );
    return {
      optionInfos,
      filteredLeafOptions,
      selectedPath,
      activeKey,
      displayColumns,
      handleKeyDown,
      totalLevel
    };
  }
});
function _sfc_render$5O(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_base_cascader_panel = resolveComponent("base-cascader-panel");
  return openBlock(), createBlock(_component_base_cascader_panel, {
    "display-columns": _ctx.displayColumns,
    "selected-path": _ctx.selectedPath,
    "active-key": _ctx.activeKey,
    multiple: _ctx.multiple,
    "total-level": _ctx.totalLevel,
    "check-strictly": _ctx.checkStrictly,
    onKeydown: _ctx.handleKeyDown
  }, createSlots({ _: 2 }, [
    _ctx.$slots.empty ? {
      name: "empty",
      fn: withCtx(() => [
        renderSlot(_ctx.$slots, "empty")
      ]),
      key: "0"
    } : void 0
  ]), 1032, ["display-columns", "selected-path", "active-key", "multiple", "total-level", "check-strictly", "onKeydown"]);
}
var CascaderPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5P, [["render", _sfc_render$5O]]);
const Cascader = Object.assign(_Cascader, {
  CascaderPanel,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Cascader.name, _Cascader);
    app.component(componentPrefix + CascaderPanel.name, CascaderPanel);
  }
});
const collapseKey = Symbol("collapseCtx");
const _sfc_main$5O = defineComponent({
  name: "Collapse",
  props: {
    activeKey: {
      type: Array,
      default: void 0
    },
    defaultActiveKey: {
      type: Array,
      default: () => []
    },
    accordion: {
      type: Boolean,
      default: false
    },
    showExpandIcon: {
      type: Boolean,
      default: void 0
    },
    expandIconPosition: {
      type: String,
      default: "left"
    },
    bordered: {
      type: Boolean,
      default: true
    },
    destroyOnHide: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:activeKey": (activeKey) => true,
    "change": (activeKey, ev) => true
  },
  setup(props, { emit, slots }) {
    const { expandIconPosition, destroyOnHide, showExpandIcon } = toRefs(props);
    const prefixCls = getPrefixCls("collapse");
    const _activeKey = ref(props.defaultActiveKey);
    const computedActiveKeys = computed(() => {
      var _a;
      const activeKey = (_a = props.activeKey) != null ? _a : _activeKey.value;
      if (!isArray(activeKey)) {
        return [activeKey];
      }
      return activeKey;
    });
    const handleClick = (key, e) => {
      let newActiveKeys = [];
      if (props.accordion) {
        if (!computedActiveKeys.value.includes(key)) {
          newActiveKeys = [key];
        }
        _activeKey.value = newActiveKeys;
      } else {
        newActiveKeys = [...computedActiveKeys.value];
        const _index = newActiveKeys.indexOf(key);
        if (_index > -1) {
          newActiveKeys.splice(_index, 1);
        } else if (props.accordion) {
          newActiveKeys = [key];
        } else {
          newActiveKeys.push(key);
        }
        _activeKey.value = newActiveKeys;
      }
      emit("update:activeKey", newActiveKeys);
      emit("change", newActiveKeys, e);
    };
    provide(
      collapseKey,
      reactive({
        activeKeys: computedActiveKeys,
        slots,
        showExpandIcon,
        expandIconPosition,
        destroyOnHide,
        handleClick
      })
    );
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-borderless`]: !props.bordered
      }
    ]);
    return {
      prefixCls,
      cls
    };
  }
});
function _sfc_render$5N(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var _Collapse = /* @__PURE__ */ _export_sfc(_sfc_main$5O, [["render", _sfc_render$5N]]);
const _sfc_main$5N = defineComponent({
  name: "IconCaretRight",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-caret-right`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4w = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5M(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      d: "M34.829 23.063c.6.48.6 1.394 0 1.874L17.949 38.44c-.785.629-1.949.07-1.949-.937V10.497c0-1.007 1.164-1.566 1.95-.937l16.879 13.503Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4w);
}
var _IconCaretRight = /* @__PURE__ */ _export_sfc(_sfc_main$5N, [["render", _sfc_render$5M]]);
const IconCaretRight = Object.assign(_IconCaretRight, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconCaretRight.name, _IconCaretRight);
  }
});
const _sfc_main$5M = defineComponent({
  name: "IconCaretLeft",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-caret-left`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4v = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5L(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      d: "M13.171 24.937a1.2 1.2 0 0 1 0-1.874L30.051 9.56c.785-.629 1.949-.07 1.949.937v27.006c0 1.006-1.164 1.566-1.95.937L13.171 24.937Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$4v);
}
var _IconCaretLeft = /* @__PURE__ */ _export_sfc(_sfc_main$5M, [["render", _sfc_render$5L]]);
const IconCaretLeft = Object.assign(_IconCaretLeft, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconCaretLeft.name, _IconCaretLeft);
  }
});
var CollapseItem = defineComponent({
  name: "CollapseItem",
  components: {
    IconHover,
    IconCaretRight,
    IconCaretLeft
  },
  props: {
    header: String,
    disabled: {
      type: Boolean,
      default: false
    },
    showExpandIcon: {
      type: Boolean,
      default: true
    },
    destroyOnHide: {
      type: Boolean,
      default: false
    }
  },
  setup(props, {
    slots
  }) {
    var _a;
    const instance = getCurrentInstance();
    const prefixCls = getPrefixCls("collapse-item");
    const collapseCtx = inject(collapseKey, {});
    const key = instance && isNumber(instance == null ? void 0 : instance.vnode.key) ? instance.vnode.key : String((_a = instance == null ? void 0 : instance.vnode.key) != null ? _a : "");
    const isActive = computed(() => {
      var _a2;
      return (_a2 = collapseCtx.activeKeys) == null ? void 0 : _a2.includes(key);
    });
    const mergedDestroyOnHide = computed(() => collapseCtx.destroyOnHide || props.destroyOnHide);
    const mergedShowExpandIcon = computed(() => {
      var _a2;
      return (_a2 = collapseCtx == null ? void 0 : collapseCtx.showExpandIcon) != null ? _a2 : props.showExpandIcon;
    });
    const mounted = ref(mergedDestroyOnHide.value ? isActive.value : true);
    const expandIconPosition = computed(() => {
      var _a2;
      return (_a2 = collapseCtx == null ? void 0 : collapseCtx.expandIconPosition) != null ? _a2 : "left";
    });
    const handleClick = (e) => {
      var _a2;
      if (!props.disabled) {
        (_a2 = collapseCtx.handleClick) == null ? void 0 : _a2.call(collapseCtx, key, e);
      }
    };
    watch(isActive, (isActive2) => {
      if (isActive2 && !mounted.value) {
        mounted.value = true;
      }
    });
    const transitionEvents = {
      onEnter: (el) => {
        el.style.height = `${el.scrollHeight}px`;
      },
      onAfterEnter: (el) => {
        el.style.height = "auto";
      },
      onBeforeLeave: (el) => {
        el.style.height = `${el.scrollHeight}px`;
      },
      onLeave: (el) => {
        el.style.height = "0";
      },
      onAfterLeave: () => {
        if (mergedDestroyOnHide.value) {
          mounted.value = false;
        }
      }
    };
    const cls = computed(() => [prefixCls, {
      [`${prefixCls}-active`]: isActive.value
    }]);
    const headerCls = computed(() => [`${prefixCls}-header`, `${prefixCls}-header-${collapseCtx == null ? void 0 : collapseCtx.expandIconPosition}`, {
      [`${prefixCls}-header-disabled`]: props.disabled
    }]);
    const iconCls = computed(() => [{
      [`${prefixCls}-icon-right`]: (collapseCtx == null ? void 0 : collapseCtx.expandIconPosition) === "right"
    }]);
    const contentCls = computed(() => [`${prefixCls}-content`, {
      [`${prefixCls}-content-expend`]: isActive.value
    }]);
    const defaultExpandIcon = () => expandIconPosition.value === "right" ? createVNode(resolveComponent("icon-caret-left"), {
      "class": `${prefixCls}-expand-icon`
    }, null) : createVNode(resolveComponent("icon-caret-right"), {
      "class": `${prefixCls}-expand-icon`
    }, null);
    const expandIconRender = () => mergedShowExpandIcon.value && createVNode(resolveComponent("icon-hover"), {
      "prefix": prefixCls,
      "class": iconCls.value,
      "disabled": props.disabled
    }, {
      default: () => {
        var _a2, _b, _c, _d;
        return [(_d = (_c = (_b = slots["expand-icon"]) != null ? _b : (_a2 = collapseCtx == null ? void 0 : collapseCtx.slots) == null ? void 0 : _a2["expand-icon"]) == null ? void 0 : _c({
          active: isActive.value,
          disabled: props.disabled,
          position: expandIconPosition.value
        })) != null ? _d : defaultExpandIcon()];
      }
    });
    return () => {
      var _a2, _b, _c;
      return createVNode("div", {
        "class": cls.value
      }, [createVNode("div", {
        "role": "button",
        "aria-disabled": props.disabled,
        "aria-expanded": isActive.value,
        "tabindex": "0",
        "class": headerCls.value,
        "onClick": handleClick
      }, [expandIconRender(), createVNode("div", {
        "class": `${prefixCls}-header-title`
      }, [(_b = (_a2 = slots.header) == null ? void 0 : _a2.call(slots)) != null ? _b : props.header]), slots.extra && createVNode("div", {
        "class": `${prefixCls}-header-extra`
      }, [(_c = slots.extra) == null ? void 0 : _c.call(slots)])]), createVNode(Transition, mergeProps({
        "name": "collapse-slider"
      }, transitionEvents), {
        default: () => {
          var _a3;
          return [withDirectives(createVNode("div", {
            "role": "region",
            "class": contentCls.value
          }, [mounted.value && createVNode("div", {
            "ref": "contentBoxRef",
            "class": `${prefixCls}-content-box`
          }, [(_a3 = slots.default) == null ? void 0 : _a3.call(slots)])]), [[vShow, isActive.value]])];
        }
      })]);
    };
  }
});
const Collapse = Object.assign(_Collapse, {
  Item: CollapseItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Collapse.name, _Collapse);
    app.component(componentPrefix + CollapseItem.name, CollapseItem);
  }
});
const colors = [
  "#00B42A",
  "#3C7EFF",
  "#FF7D00",
  "#F76965",
  "#F7BA1E",
  "#F5319D",
  "#D91AD9",
  "#9FDB1D",
  "#FADC19",
  "#722ED1",
  "#3491FA",
  "#7BE188",
  "#93BEFF",
  "#FFCF8B",
  "#FBB0A7",
  "#FCE996",
  "#FB9DC7",
  "#F08EE6",
  "#DCF190",
  "#FDFA94",
  "#C396ED",
  "#9FD4FD"
];
const hsvToRgb = (h2, s, v) => {
  const i2 = Math.floor(h2 * 6);
  const f = h2 * 6 - i2;
  const p = v * (1 - s);
  const q = v * (1 - f * s);
  const t = v * (1 - (1 - f) * s);
  const mod = i2 % 6;
  const r = [v, q, p, p, t, v][mod];
  const g = [t, v, v, q, p, p][mod];
  const b = [p, p, t, v, v, q][mod];
  return {
    r: Math.round(r * 255),
    g: Math.round(g * 255),
    b: Math.round(b * 255)
  };
};
const rgbToHsv = (r, g, b) => {
  r /= 255;
  g /= 255;
  b /= 255;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  let h2 = 0;
  const v = max;
  const d = max - min;
  const s = max === 0 ? 0 : d / max;
  if (max === min) {
    h2 = 0;
  } else {
    switch (max) {
      case r:
        h2 = (g - b) / d + (g < b ? 6 : 0);
        break;
      case g:
        h2 = (b - r) / d + 2;
        break;
      case b:
        h2 = (r - g) / d + 4;
        break;
    }
    h2 /= 6;
  }
  return { h: h2, s, v };
};
const CSS_INTEGER = "[-\\+]?\\d+%?";
const CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
const CSS_UNIT = `(?:${CSS_NUMBER})|(?:${CSS_INTEGER})`;
const PERMISSIVE_MATCH3 = `[\\s|\\(]+(${CSS_UNIT})[,|\\s]+(${CSS_UNIT})[,|\\s]+(${CSS_UNIT})\\s*\\)?`;
const PERMISSIVE_MATCH4 = `[\\s|\\(]+(${CSS_UNIT})[,|\\s]+(${CSS_UNIT})[,|\\s]+(${CSS_UNIT})[,|\\s]+(${CSS_UNIT})\\s*\\)?`;
const matchers = {
  rgb: new RegExp(`rgb${PERMISSIVE_MATCH3}`),
  rgba: new RegExp(`rgba${PERMISSIVE_MATCH4}`),
  hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
  hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
  hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
  hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
};
const parseIntFromHex = (val) => {
  return parseInt(val, 16);
};
const convertHexToDecimal = (h2) => {
  return parseIntFromHex(h2) / 255;
};
const formatInputToRgb = (color) => {
  let match = matchers.rgb.exec(color);
  if (match) {
    return {
      r: parseInt(match[1], 10),
      g: parseInt(match[2], 10),
      b: parseInt(match[3], 10)
    };
  }
  match = matchers.rgba.exec(color);
  if (match) {
    return {
      r: parseInt(match[1], 10),
      g: parseInt(match[2], 10),
      b: parseInt(match[3], 10),
      a: parseFloat(match[4])
    };
  }
  match = matchers.hex8.exec(color);
  if (match) {
    return {
      r: parseIntFromHex(match[1]),
      g: parseIntFromHex(match[2]),
      b: parseIntFromHex(match[3]),
      a: convertHexToDecimal(match[4])
    };
  }
  match = matchers.hex6.exec(color);
  if (match) {
    return {
      r: parseIntFromHex(match[1]),
      g: parseIntFromHex(match[2]),
      b: parseIntFromHex(match[3])
    };
  }
  match = matchers.hex4.exec(color);
  if (match) {
    return {
      r: parseIntFromHex(match[1] + match[1]),
      g: parseIntFromHex(match[2] + match[2]),
      b: parseIntFromHex(match[3] + match[3]),
      a: convertHexToDecimal(match[4] + match[4])
    };
  }
  match = matchers.hex3.exec(color);
  if (match) {
    return {
      r: parseIntFromHex(match[1] + match[1]),
      g: parseIntFromHex(match[2] + match[2]),
      b: parseIntFromHex(match[3] + match[3])
    };
  }
  return false;
};
const formatInputToHSVA = (color) => {
  var _a;
  const rgba = formatInputToRgb(color);
  if (rgba) {
    const hsv = rgbToHsv(rgba.r, rgba.g, rgba.b);
    return {
      ...hsv,
      a: (_a = rgba.a) != null ? _a : 1
    };
  }
  return {
    h: 0,
    s: 1,
    v: 1,
    a: 1
  };
};
const hexToRgb = (color) => {
  color = color.trim().toLowerCase();
  if (color.length === 0) {
    return false;
  }
  let match = matchers.hex6.exec(color);
  if (match) {
    return {
      r: parseIntFromHex(match[1]),
      g: parseIntFromHex(match[2]),
      b: parseIntFromHex(match[3])
    };
  }
  match = matchers.hex3.exec(color);
  if (match) {
    return {
      r: parseIntFromHex(match[1] + match[1]),
      g: parseIntFromHex(match[2] + match[2]),
      b: parseIntFromHex(match[3] + match[3])
    };
  }
  return false;
};
const rgbToHex = (r, g, b) => {
  const hex = [
    Math.round(r).toString(16).padStart(2, "0"),
    Math.round(g).toString(16).padStart(2, "0"),
    Math.round(b).toString(16).padStart(2, "0")
  ];
  return hex.join("").toUpperCase();
};
const rgbaToHex = (r, g, b, a) => {
  const hex = [
    Math.round(r).toString(16).padStart(2, "0"),
    Math.round(g).toString(16).padStart(2, "0"),
    Math.round(b).toString(16).padStart(2, "0"),
    Math.round(a * 255).toString(16).padStart(2, "0")
  ];
  return hex.join("").toUpperCase();
};
const useControlBlock = ({ value, onChange }) => {
  const active = ref(false);
  const blockRef = ref();
  const handlerRef = ref();
  const getPercentNumber = (value2, max) => {
    if (value2 < 0)
      return 0;
    if (value2 > max)
      return 1;
    return value2 / max;
  };
  const setCurrentPosition = (ev) => {
    if (!blockRef.value)
      return;
    const { clientX, clientY } = ev;
    const rect = blockRef.value.getBoundingClientRect();
    const newValue = [
      getPercentNumber(clientX - rect.x, rect.width),
      getPercentNumber(clientY - rect.y, rect.height)
    ];
    if (newValue[0] !== value[0] || newValue[1] !== value[1]) {
      onChange == null ? void 0 : onChange(newValue);
    }
  };
  const removeListener = () => {
    active.value = false;
    window.removeEventListener("mousemove", onMouseMove);
    window.removeEventListener("mouseup", removeListener);
    window.removeEventListener("contextmenu", removeListener);
  };
  const onMouseDown = (ev) => {
    active.value = true;
    setCurrentPosition(ev);
    window.addEventListener("mousemove", onMouseMove);
    window.addEventListener("mouseup", removeListener);
    window.addEventListener("contextmenu", removeListener);
  };
  function onMouseMove(ev) {
    ev.preventDefault();
    if (ev.buttons > 0) {
      setCurrentPosition(ev);
    } else {
      removeListener();
    }
  }
  return {
    active,
    blockRef,
    handlerRef,
    onMouseDown
  };
};
var ControlBar = defineComponent({
  name: "ControlBar",
  props: {
    x: {
      type: Number,
      required: true
    },
    color: {
      type: Object,
      required: true
    },
    colorString: String,
    type: String,
    onChange: Function
  },
  setup(props) {
    const prefixCls = getPrefixCls("color-picker");
    const rgb = computed(() => props.color.rgb);
    const {
      blockRef,
      handlerRef,
      onMouseDown
    } = useControlBlock({
      value: [props.x, 0],
      onChange: (pos) => {
        var _a;
        return (_a = props.onChange) == null ? void 0 : _a.call(props, pos[0]);
      }
    });
    const renderHandler = () => {
      return createVNode("div", {
        "ref": handlerRef,
        "class": `${prefixCls}-handler`,
        "style": {
          left: `${props.x * 100}%`,
          color: props.colorString
        }
      }, null);
    };
    return () => {
      if (props.type === "alpha") {
        return createVNode("div", {
          "class": `${prefixCls}-control-bar-bg`
        }, [createVNode("div", {
          "ref": blockRef,
          "class": [`${prefixCls}-control-bar`, `${prefixCls}-control-bar-alpha`],
          "style": {
            background: `linear-gradient(to right, rgba(0, 0, 0, 0), rgb(${rgb.value.r}, ${rgb.value.g}, ${rgb.value.b}))`
          },
          "onMousedown": onMouseDown
        }, [renderHandler()])]);
      }
      return createVNode("div", {
        "ref": blockRef,
        "class": [`${prefixCls}-control-bar`, `${prefixCls}-control-bar-hue`],
        "onMousedown": onMouseDown
      }, [renderHandler()]);
    };
  }
});
var Palette = defineComponent({
  name: "Palette",
  props: {
    color: {
      type: Object,
      required: true
    },
    onChange: Function
  },
  setup(props) {
    const prefixCls = getPrefixCls("color-picker");
    const hsv = computed(() => props.color.hsv);
    const {
      blockRef,
      handlerRef,
      onMouseDown
    } = useControlBlock({
      value: [hsv.value.s, 1 - hsv.value.v],
      onChange: (value) => {
        var _a;
        return (_a = props.onChange) == null ? void 0 : _a.call(props, value[0], 1 - value[1]);
      }
    });
    const hueColor = computed(() => {
      const rgb = hsvToRgb(hsv.value.h, 1, 1);
      return `rgb(${rgb.r}, ${rgb.g}, ${rgb.b})`;
    });
    return () => createVNode("div", {
      "ref": blockRef,
      "class": `${prefixCls}-palette`,
      "style": {
        backgroundColor: hueColor.value
      },
      "onMousedown": onMouseDown
    }, [createVNode("div", {
      "ref": handlerRef,
      "class": `${prefixCls}-handler`,
      "style": {
        top: `${(1 - hsv.value.v) * 100}%`,
        left: `${hsv.value.s * 100}%`
      }
    }, null)]);
  }
});
const _sfc_main$5L = defineComponent({
  name: "IconPlus",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-plus`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4u = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5K(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M5 24h38M24 5v38" }, null, -1)
  ]), 14, _hoisted_1$4u);
}
var _IconPlus = /* @__PURE__ */ _export_sfc(_sfc_main$5L, [["render", _sfc_render$5K]]);
const IconPlus = Object.assign(_IconPlus, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconPlus.name, _IconPlus);
  }
});
const _sfc_main$5K = defineComponent({
  name: "IconMinus",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-minus`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4t = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5J(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M5 24h38" }, null, -1)
  ]), 14, _hoisted_1$4t);
}
var _IconMinus = /* @__PURE__ */ _export_sfc(_sfc_main$5K, [["render", _sfc_render$5J]]);
const IconMinus = Object.assign(_IconMinus, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconMinus.name, _IconMinus);
  }
});
const FIRST_DELAY = 800;
const SPEED = 150;
index$1.enableBoundaryChecking(false);
var _InputNumber = defineComponent({
  name: "InputNumber",
  props: {
    modelValue: Number,
    defaultValue: Number,
    mode: {
      type: String,
      default: "embed"
    },
    precision: Number,
    step: {
      type: Number,
      default: 1
    },
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    max: {
      type: Number,
      default: Infinity
    },
    min: {
      type: Number,
      default: -Infinity
    },
    formatter: {
      type: Function
    },
    parser: {
      type: Function
    },
    placeholder: String,
    hideButton: {
      type: Boolean,
      default: false
    },
    size: {
      type: String
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    modelEvent: {
      type: String,
      default: "change"
    },
    readOnly: {
      type: Boolean,
      default: false
    },
    inputAttrs: {
      type: Object
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value, ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true,
    "clear": (ev) => true,
    "input": (value, inputValue, ev) => true,
    "keydown": (ev) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    var _a;
    const {
      size,
      disabled
    } = toRefs(props);
    const prefixCls = getPrefixCls("input-number");
    const inputRef = ref();
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      eventHandlers
    } = useFormItem({
      size,
      disabled
    });
    const {
      mergedSize
    } = useSize$1(_mergedSize);
    const mergedPrecision = computed(() => {
      if (isNumber(props.precision)) {
        const decimal = `${props.step}`.split(".")[1];
        const stepPrecision = decimal && decimal.length || 0;
        return Math.max(stepPrecision, props.precision);
      }
      return void 0;
    });
    const getStringValue = (number) => {
      var _a2, _b;
      if (!isNumber(number)) {
        return "";
      }
      const numString = mergedPrecision.value ? number.toFixed(mergedPrecision.value) : String(number);
      return (_b = (_a2 = props.formatter) == null ? void 0 : _a2.call(props, numString)) != null ? _b : numString;
    };
    const _value = ref(getStringValue((_a = props.modelValue) != null ? _a : props.defaultValue));
    const valueNumber = computed(() => {
      var _a2, _b;
      if (!_value.value) {
        return void 0;
      }
      const number = Number((_b = (_a2 = props.parser) == null ? void 0 : _a2.call(props, _value.value)) != null ? _b : _value.value);
      return Number.isNaN(number) ? void 0 : number;
    });
    const isMin = ref(isNumber(valueNumber.value) && valueNumber.value <= props.min);
    const isMax = ref(isNumber(valueNumber.value) && valueNumber.value >= props.max);
    let repeatTimer = 0;
    const clearRepeatTimer = () => {
      if (repeatTimer) {
        window.clearTimeout(repeatTimer);
        repeatTimer = 0;
      }
    };
    const getLegalValue = (value) => {
      if (isUndefined(value)) {
        return void 0;
      }
      if (isNumber(props.min) && value < props.min) {
        value = props.min;
      }
      if (isNumber(props.max) && value > props.max) {
        value = props.max;
      }
      return isNumber(mergedPrecision.value) ? index$1.round(value, mergedPrecision.value) : value;
    };
    const updateNumberStatus = (number) => {
      let _isMin = false;
      let _isMax = false;
      if (isNumber(number)) {
        if (number <= props.min) {
          _isMin = true;
        }
        if (number >= props.max) {
          _isMax = true;
        }
      }
      if (isMax.value !== _isMax) {
        isMax.value = _isMax;
      }
      if (isMin.value !== _isMin) {
        isMin.value = _isMin;
      }
    };
    const handleExceedRange = () => {
      const finalValue = getLegalValue(valueNumber.value);
      const stringValue = getStringValue(finalValue);
      if (finalValue !== valueNumber.value || _value.value !== stringValue) {
        _value.value = stringValue;
      }
      emit("update:modelValue", finalValue);
    };
    watch(() => [props.max, props.min], () => {
      handleExceedRange();
      updateNumberStatus(valueNumber.value);
    });
    const nextStep = (method, event) => {
      if (mergedDisabled.value || method === "plus" && isMax.value || method === "minus" && isMin.value) {
        return;
      }
      let nextValue;
      if (isNumber(valueNumber.value)) {
        nextValue = getLegalValue(index$1[method](valueNumber.value, props.step));
      } else {
        nextValue = props.min === -Infinity ? 0 : props.min;
      }
      _value.value = getStringValue(nextValue);
      updateNumberStatus(nextValue);
      emit("update:modelValue", nextValue);
      emit("change", nextValue, event);
    };
    const handleStepButton = (event, method, needRepeat = false) => {
      var _a2;
      event.preventDefault();
      if (props.readOnly)
        return;
      (_a2 = inputRef.value) == null ? void 0 : _a2.focus();
      nextStep(method, event);
      if (needRepeat) {
        repeatTimer = window.setTimeout(() => event.target.dispatchEvent(event), repeatTimer ? SPEED : FIRST_DELAY);
      }
    };
    const handleInput = (value, ev) => {
      var _a2, _b, _c, _d;
      value = value.trim().replace(/。/g, ".");
      value = (_b = (_a2 = props.parser) == null ? void 0 : _a2.call(props, value)) != null ? _b : value;
      if (isNumber(Number(value)) || /^(\.|-)$/.test(value)) {
        _value.value = (_d = (_c = props.formatter) == null ? void 0 : _c.call(props, value)) != null ? _d : value;
        updateNumberStatus(valueNumber.value);
        emit("input", valueNumber.value, _value.value, ev);
        if (props.modelEvent === "input") {
          emit("update:modelValue", valueNumber.value);
          emit("change", valueNumber.value, ev);
        }
      }
    };
    const handleFocus = (ev) => {
      emit("focus", ev);
    };
    const handleChange = (value, ev) => {
      if (ev instanceof MouseEvent && !value) {
        return;
      }
      handleExceedRange();
      emit("change", valueNumber.value, ev);
    };
    const handleBlur = (ev) => {
      emit("blur", ev);
    };
    const handleClear = (ev) => {
      var _a2, _b;
      _value.value = "";
      emit("update:modelValue", void 0);
      emit("change", void 0, ev);
      (_b = (_a2 = eventHandlers.value) == null ? void 0 : _a2.onChange) == null ? void 0 : _b.call(_a2, ev);
      emit("clear", ev);
    };
    const keyDownHandler = getKeyDownHandler(/* @__PURE__ */ new Map([[KEYBOARD_KEY.ARROW_UP, (ev) => {
      ev.preventDefault();
      !props.readOnly && nextStep("plus", ev);
    }], [KEYBOARD_KEY.ARROW_DOWN, (ev) => {
      ev.preventDefault();
      !props.readOnly && nextStep("minus", ev);
    }]]));
    const onKeyDown = (event) => {
      emit("keydown", event);
      if (!event.defaultPrevented) {
        keyDownHandler(event);
      }
    };
    watch(() => props.modelValue, (value) => {
      if (value !== valueNumber.value) {
        _value.value = getStringValue(value);
        updateNumberStatus(value);
      }
    });
    const renderSuffix = () => {
      var _a2, _b, _c;
      if (props.readOnly) {
        return null;
      }
      return createVNode(Fragment, null, [slots.suffix && createVNode("div", {
        "class": `${prefixCls}-suffix`
      }, [(_a2 = slots.suffix) == null ? void 0 : _a2.call(slots)]), createVNode("div", {
        "class": `${prefixCls}-step`
      }, [createVNode("button", {
        "class": [`${prefixCls}-step-button`, {
          [`${prefixCls}-step-button-disabled`]: mergedDisabled.value || isMax.value
        }],
        "type": "button",
        "tabindex": "-1",
        "disabled": mergedDisabled.value || isMax.value,
        "onMousedown": (e) => handleStepButton(e, "plus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, [slots.plus ? (_b = slots.plus) == null ? void 0 : _b.call(slots) : createVNode(IconUp, null, null)]), createVNode("button", {
        "class": [`${prefixCls}-step-button`, {
          [`${prefixCls}-step-button-disabled`]: mergedDisabled.value || isMin.value
        }],
        "type": "button",
        "tabindex": "-1",
        "disabled": mergedDisabled.value || isMin.value,
        "onMousedown": (e) => handleStepButton(e, "minus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, [slots.minus ? (_c = slots.minus) == null ? void 0 : _c.call(slots) : createVNode(IconDown, null, null)])])]);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-mode-${props.mode}`, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-readonly`]: props.readOnly
    }]);
    const renderPrependButton = () => {
      return createVNode(Button, {
        "size": mergedSize.value,
        "tabindex": "-1",
        "class": `${prefixCls}-step-button`,
        "disabled": mergedDisabled.value || isMin.value,
        "onMousedown": (ev) => handleStepButton(ev, "minus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, {
        icon: () => createVNode(IconMinus, null, null)
      });
    };
    const renderAppendButton = () => {
      return createVNode(Button, {
        "size": mergedSize.value,
        "tabindex": "-1",
        "class": `${prefixCls}-step-button`,
        "disabled": mergedDisabled.value || isMax.value,
        "onMousedown": (ev) => handleStepButton(ev, "plus", true),
        "onMouseup": clearRepeatTimer,
        "onMouseleave": clearRepeatTimer
      }, {
        icon: () => createVNode(IconPlus, null, null)
      });
    };
    const render2 = () => {
      const _slots = props.mode === "embed" ? {
        prepend: slots.prepend,
        prefix: slots.prefix,
        suffix: props.hideButton ? slots.suffix : renderSuffix,
        append: slots.append
      } : {
        prepend: props.hideButton ? slots.prepend : renderPrependButton,
        prefix: slots.prefix,
        suffix: slots.suffix,
        append: props.hideButton ? slots.append : renderAppendButton
      };
      return createVNode(Input, {
        "key": `__arco__${props.mode}`,
        "ref": inputRef,
        "class": cls.value,
        "type": "text",
        "allowClear": props.allowClear,
        "size": mergedSize.value,
        "modelValue": _value.value,
        "placeholder": props.placeholder,
        "disabled": mergedDisabled.value,
        "readonly": props.readOnly,
        "error": props.error,
        "inputAttrs": {
          "role": "spinbutton",
          "aria-valuemax": props.max,
          "aria-valuemin": props.min,
          "aria-valuenow": _value.value,
          ...props.inputAttrs
        },
        "onInput": handleInput,
        "onFocus": handleFocus,
        "onBlur": handleBlur,
        "onClear": handleClear,
        "onChange": handleChange,
        "onKeydown": onKeyDown
      }, _slots);
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const InputNumber = Object.assign(_InputNumber, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _InputNumber.name, _InputNumber);
  }
});
var InputAlpha = defineComponent({
  name: "InputAlpha",
  props: {
    value: {
      type: Number,
      required: true
    },
    disabled: Boolean,
    onChange: Function
  },
  setup(props) {
    const prefixCls = getPrefixCls("color-picker");
    return () => createVNode(InputNumber, {
      "class": `${prefixCls}-input-alpha`,
      "size": "mini",
      "min": 0,
      "max": 100,
      "disabled": props.disabled,
      "modelValue": Math.round(props.value * 100),
      "onChange": (a = 100) => {
        var _a;
        return (_a = props.onChange) == null ? void 0 : _a.call(props, a / 100);
      }
    }, {
      suffix: () => "%"
    });
  }
});
var InputRgb = defineComponent({
  name: "InputRgb",
  props: {
    color: {
      type: Object,
      required: true
    },
    alpha: {
      type: Number,
      required: true
    },
    disabled: Boolean,
    disabledAlpha: Boolean,
    onHsvChange: Function,
    onAlphaChange: Function
  },
  setup(props) {
    const prefixCls = getPrefixCls("color-picker");
    const {
      color
    } = toRefs(props);
    const handleChange = (value) => {
      var _a;
      const newRGB = {
        ...color.value.rgb,
        ...value
      };
      const hsv = rgbToHsv(newRGB.r, newRGB.g, newRGB.b);
      (_a = props.onHsvChange) == null ? void 0 : _a.call(props, hsv);
    };
    return () => createVNode(InputGroup, {
      "class": `${prefixCls}-input-group`
    }, {
      default: () => [["r", "g", "b"].map((channel) => createVNode(InputNumber, {
        "key": channel,
        "size": "mini",
        "min": 0,
        "max": 255,
        "disabled": props.disabled,
        "modelValue": color.value.rgb[channel],
        "hideButton": true,
        "onChange": (val = 0) => handleChange({
          [channel]: val
        })
      }, null)), !props.disabledAlpha && createVNode(InputAlpha, {
        "disabled": props.disabled,
        "value": props.alpha,
        "onChange": props.onAlphaChange
      }, null)]
    });
  }
});
var InputHex = defineComponent({
  name: "InputHex",
  props: {
    color: {
      type: Object,
      required: true
    },
    alpha: {
      type: Number,
      required: true
    },
    disabled: Boolean,
    disabledAlpha: Boolean,
    onHsvChange: Function,
    onAlphaChange: Function
  },
  setup(props) {
    const prefixCls = getPrefixCls("color-picker");
    const {
      color
    } = toRefs(props);
    const [hex, setHex] = useState(color.value.hex);
    const handlerChange = (value) => {
      var _a;
      const _rgb = hexToRgb(value) || {
        r: 255,
        g: 0,
        b: 0
      };
      const hsv = rgbToHsv(_rgb.r, _rgb.g, _rgb.b);
      (_a = props.onHsvChange) == null ? void 0 : _a.call(props, hsv);
    };
    const onInputChange = (value) => {
      var _a, _b;
      const matchValue = (_b = (_a = value.match(/[a-fA-F0-9]*/g)) == null ? void 0 : _a.join("")) != null ? _b : "";
      if (matchValue !== color.value.hex) {
        handlerChange(matchValue.toUpperCase());
      }
    };
    const onPaste = (ev) => {
      if (!ev.clipboardData)
        return;
      let text = ev.clipboardData.getData("Text");
      if (text.startsWith("#")) {
        text = text.slice(1);
      }
      onInputChange(text);
      ev.preventDefault();
    };
    watch(color, () => {
      if (color.value.hex !== hex.value) {
        setHex(color.value.hex);
      }
    });
    return () => createVNode(InputGroup, {
      "class": `${prefixCls}-input-group`
    }, {
      default: () => [createVNode(Input, {
        "class": `${prefixCls}-input-hex`,
        "size": "mini",
        "maxLength": 6,
        "disabled": props.disabled,
        "modelValue": hex.value,
        "onInput": setHex,
        "onChange": onInputChange,
        "onBlur": () => handlerChange,
        "onPressEnter": () => handlerChange,
        "onPaste": onPaste
      }, {
        prefix: () => "#"
      }), !props.disabledAlpha && createVNode(InputAlpha, {
        "disabled": props.disabled,
        "value": props.alpha,
        "onChange": props.onAlphaChange
      }, null)]
    });
  }
});
var Panel$2 = defineComponent({
  name: "Panel",
  props: {
    color: {
      type: Object,
      required: true
    },
    alpha: {
      type: Number,
      required: true
    },
    colorString: String,
    disabled: Boolean,
    disabledAlpha: Boolean,
    showHistory: Boolean,
    showPreset: Boolean,
    format: String,
    historyColors: Array,
    presetColors: Array,
    onAlphaChange: Function,
    onHsvChange: Function
  },
  setup(props) {
    const {
      t
    } = useI18n();
    const prefixCls = getPrefixCls("color-picker");
    const hsv = computed(() => props.color.hsv);
    const [format, setFormat] = useState(props.format || "hex");
    const onChange = (value) => {
      setFormat(value);
    };
    ref(false);
    const onHexInputChange = (value) => {
      var _a;
      const _rgb = hexToRgb(value) || {
        r: 255,
        g: 0,
        b: 0
      };
      const _hsv = rgbToHsv(_rgb.r, _rgb.g, _rgb.b);
      (_a = props.onHsvChange) == null ? void 0 : _a.call(props, _hsv);
    };
    const renderInput = () => {
      const commonProps = {
        color: props.color,
        alpha: props.alpha,
        disabled: props.disabled,
        disabledAlpha: props.disabledAlpha,
        onHsvChange: props.onHsvChange,
        onAlphaChange: props.onAlphaChange
      };
      if (format.value === "rgb") {
        return createVNode(InputRgb, commonProps, null);
      }
      return createVNode(InputHex, commonProps, null);
    };
    const renderColorBlock = (color) => {
      return createVNode("div", {
        "key": color,
        "class": `${prefixCls}-color-block`,
        "style": {
          backgroundColor: color
        },
        "onClick": () => onHexInputChange(color)
      }, [createVNode("div", {
        "class": `${prefixCls}-block`,
        "style": {
          backgroundColor: color
        }
      }, null)]);
    };
    const renderColorSection = (text, colors2) => createVNode("div", {
      "class": `${prefixCls}-colors-section`
    }, [createVNode("div", {
      "class": `${prefixCls}-colors-text`
    }, [text]), createVNode("div", {
      "class": `${prefixCls}-colors-wrapper`
    }, [(colors2 == null ? void 0 : colors2.length) ? createVNode("div", {
      "class": `${prefixCls}-colors-list`
    }, [colors2.map(renderColorBlock)]) : createVNode("span", {
      "class": `${prefixCls}-colors-empty`
    }, [t("colorPicker.empty")])])]);
    const renderColorSec = () => {
      if (props.showHistory || props.showPreset) {
        return createVNode("div", {
          "class": `${prefixCls}-panel-colors`
        }, [props.showHistory && renderColorSection(t("colorPicker.history"), props.historyColors), props.showPreset && renderColorSection(t("colorPicker.preset"), props.presetColors)]);
      }
      return null;
    };
    return () => createVNode("div", {
      "class": {
        [`${prefixCls}-panel`]: true,
        [`${prefixCls}-panel-disabled`]: props.disabled
      }
    }, [createVNode(Palette, {
      "color": props.color,
      "onChange": (s, v) => {
        var _a;
        return (_a = props.onHsvChange) == null ? void 0 : _a.call(props, {
          h: hsv.value.h,
          s,
          v
        });
      }
    }, null), createVNode("div", {
      "class": `${prefixCls}-panel-control`
    }, [createVNode("div", {
      "class": `${prefixCls}-control-wrapper`
    }, [createVNode("div", null, [createVNode(ControlBar, {
      "type": "hue",
      "x": hsv.value.h,
      "color": props.color,
      "colorString": props.colorString,
      "onChange": (h2) => {
        var _a;
        return (_a = props.onHsvChange) == null ? void 0 : _a.call(props, {
          h: h2,
          s: hsv.value.s,
          v: hsv.value.v
        });
      }
    }, null), !props.disabledAlpha && createVNode(ControlBar, {
      "type": "alpha",
      "x": props.alpha,
      "color": props.color,
      "colorString": props.colorString,
      "onChange": props.onAlphaChange
    }, null)]), createVNode("div", {
      "class": `${prefixCls}-preview`,
      "style": {
        backgroundColor: props.colorString
      }
    }, null)]), createVNode("div", {
      "class": `${prefixCls}-input-wrapper`
    }, [createVNode(Select, {
      "class": `${prefixCls}-select`,
      "size": "mini",
      "trigger-props": {
        class: `${prefixCls}-select-popup`
      },
      "options": [{
        value: "hex",
        label: "Hex"
      }, {
        value: "rgb",
        label: "RGB"
      }],
      "modelValue": format.value,
      "onChange": onChange
    }, null), createVNode("div", {
      "class": `${prefixCls}-group-wrapper`
    }, [renderInput()])])]), renderColorSec()]);
  }
});
var _ColorPicker = defineComponent({
  name: "ColorPicker",
  props: {
    modelValue: String,
    defaultValue: {
      type: String
    },
    format: {
      type: String
    },
    size: {
      type: String,
      default: "medium"
    },
    showText: {
      type: Boolean,
      default: false
    },
    showHistory: {
      type: Boolean,
      default: false
    },
    showPreset: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    disabledAlpha: {
      type: Boolean,
      default: false
    },
    hideTrigger: {
      type: Boolean
    },
    triggerProps: {
      type: Object
    },
    historyColors: {
      type: Array
    },
    presetColors: {
      type: Array,
      default: () => colors
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value) => true,
    "popup-visible-change": (visible, value) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const prefixCls = getPrefixCls("color-picker");
    const mergeValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : props.defaultValue;
    });
    const formatInput = computed(() => {
      return formatInputToHSVA(mergeValue.value || "");
    });
    const [alpha, setAlpha] = useState(formatInput.value.a);
    const [hsv, setHsv] = useState({
      h: formatInput.value.h,
      s: formatInput.value.s,
      v: formatInput.value.v
    });
    watch(() => formatInput.value, (value) => {
      if (mergeValue.value !== formatValue.value) {
        setAlpha(value.a);
        setHsv({
          h: value.h,
          s: value.s,
          v: value.v
        });
      }
    });
    const color = computed(() => {
      const rgb = hsvToRgb(hsv.value.h, hsv.value.s, hsv.value.v);
      const hex = rgbToHex(rgb.r, rgb.g, rgb.b);
      return {
        hsv: hsv.value,
        rgb,
        hex
      };
    });
    const colorString = computed(() => {
      const {
        r,
        g,
        b
      } = color.value.rgb;
      return `rgba(${r}, ${g}, ${b}, ${alpha.value.toFixed(2)})`;
    });
    const formatValue = computed(() => {
      const {
        r,
        g,
        b
      } = color.value.rgb;
      if (props.format === "rgb") {
        return alpha.value < 1 && !props.disabledAlpha ? `rgba(${r}, ${g}, ${b}, ${alpha.value.toFixed(2)})` : `rgb(${r}, ${g}, ${b})`;
      }
      return alpha.value < 1 && !props.disabledAlpha ? `#${rgbaToHex(r, g, b, alpha.value)}` : `#${rgbToHex(r, g, b)}`;
    });
    watch(formatValue, (value) => {
      emit("update:modelValue", value);
      emit("change", value);
    });
    const onHsvChange = (_value) => {
      !props.disabled && setHsv(_value);
    };
    const onAlphaChange = (_value) => {
      !props.disabled && setAlpha(_value);
    };
    const onPopupVisibleChange = (visible) => {
      emit("popup-visible-change", visible, formatValue.value);
    };
    const renderInput = () => {
      return createVNode("div", {
        "class": {
          [prefixCls]: true,
          [`${prefixCls}-size-${props.size}`]: props.size,
          [`${prefixCls}-disabled`]: props.disabled
        }
      }, [createVNode("div", {
        "class": `${prefixCls}-preview`,
        "style": {
          backgroundColor: formatValue.value
        }
      }, null), props.showText && createVNode("div", {
        "class": `${prefixCls}-value`
      }, [formatValue.value]), createVNode("input", {
        "class": `${prefixCls}-input`,
        "value": formatValue.value,
        "disabled": props.disabled
      }, null)]);
    };
    const renderPanel = () => {
      return createVNode(Panel$2, {
        "color": color.value,
        "alpha": alpha.value,
        "colorString": colorString.value,
        "historyColors": props.historyColors,
        "presetColors": props.presetColors,
        "showHistory": props.showHistory,
        "showPreset": props.showPreset,
        "disabled": props.disabled,
        "disabledAlpha": props.disabledAlpha,
        "format": props.format,
        "onHsvChange": onHsvChange,
        "onAlphaChange": onAlphaChange
      }, null);
    };
    return () => {
      return props.hideTrigger ? renderPanel() : createVNode(Trigger, mergeProps({
        "trigger": "click",
        "position": "bl",
        "animationName": "slide-dynamic-origin",
        "popupOffset": 4,
        "disabled": props.disabled,
        "onPopupVisibleChange": onPopupVisibleChange
      }, props.triggerProps), {
        default: () => [slots.default ? slots.default() : renderInput()],
        content: renderPanel
      });
    };
  }
});
const ColorPicker = Object.assign(_ColorPicker, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _ColorPicker.name, _ColorPicker);
  }
});
function hasPropOrSlot(props, slots, propName) {
  return computed(() => Boolean(props[propName] || slots[propName]));
}
const _sfc_main$5J = defineComponent({
  name: "Comment",
  props: {
    author: {
      type: String
    },
    avatar: {
      type: String
    },
    content: {
      type: String
    },
    datetime: {
      type: String
    },
    align: {
      type: [String, Object],
      default: "left"
    }
  },
  setup(props, { slots }) {
    const prefixCls = getPrefixCls("comment");
    const [hasAuthor, hasAvatar, hasContent, hasDatetime] = [
      "author",
      "avatar",
      "content",
      "datetime"
    ].map((propName) => hasPropOrSlot(props, slots, propName));
    const computedAlign = computed(() => {
      const { align } = props;
      return {
        ...isString(align) ? {
          datetime: align,
          actions: align
        } : align
      };
    });
    return {
      prefixCls,
      hasAuthor,
      hasAvatar,
      hasContent,
      hasDatetime,
      computedAlign
    };
  }
});
const _hoisted_1$4s = ["src"];
const _hoisted_2$5 = { key: 0 };
const _hoisted_3$1 = { key: 0 };
const _hoisted_4$1 = { key: 0 };
function _sfc_render$5I(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    _ctx.hasAvatar ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-avatar`)
    }, [
      _ctx.avatar ? (openBlock(), createElementBlock("img", {
        key: 0,
        src: _ctx.avatar,
        alt: "comment-avatar"
      }, null, 8, _hoisted_1$4s)) : renderSlot(_ctx.$slots, "avatar", { key: 1 })
    ], 2)) : createCommentVNode("v-if", true),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-inner`)
    }, [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-inner-content`)
      }, [
        _ctx.hasAuthor || _ctx.hasDatetime ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass(`${_ctx.prefixCls}-title ${_ctx.prefixCls}-title-align-${_ctx.computedAlign.datetime}`)
        }, [
          _ctx.hasAuthor ? (openBlock(), createElementBlock("span", {
            key: 0,
            class: normalizeClass(`${_ctx.prefixCls}-author`)
          }, [
            _ctx.author ? (openBlock(), createElementBlock("span", _hoisted_2$5, toDisplayString(_ctx.author), 1)) : renderSlot(_ctx.$slots, "author", { key: 1 })
          ], 2)) : createCommentVNode("v-if", true),
          _ctx.hasDatetime ? (openBlock(), createElementBlock("span", {
            key: 1,
            class: normalizeClass(`${_ctx.prefixCls}-datetime`)
          }, [
            _ctx.datetime ? (openBlock(), createElementBlock("span", _hoisted_3$1, toDisplayString(_ctx.datetime), 1)) : renderSlot(_ctx.$slots, "datetime", { key: 1 })
          ], 2)) : createCommentVNode("v-if", true)
        ], 2)) : createCommentVNode("v-if", true),
        _ctx.hasContent ? (openBlock(), createElementBlock("div", {
          key: 1,
          class: normalizeClass(`${_ctx.prefixCls}-content`)
        }, [
          _ctx.content ? (openBlock(), createElementBlock("span", _hoisted_4$1, toDisplayString(_ctx.content), 1)) : renderSlot(_ctx.$slots, "content", { key: 1 })
        ], 2)) : createCommentVNode("v-if", true),
        _ctx.$slots.actions ? (openBlock(), createElementBlock("div", {
          key: 2,
          class: normalizeClass(`${_ctx.prefixCls}-actions ${_ctx.prefixCls}-actions-align-${_ctx.computedAlign.actions}`)
        }, [
          renderSlot(_ctx.$slots, "actions")
        ], 2)) : createCommentVNode("v-if", true)
      ], 2),
      _ctx.$slots.default ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-inner-comment`)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2)) : createCommentVNode("v-if", true)
    ], 2)
  ], 2);
}
var _Comment = /* @__PURE__ */ _export_sfc(_sfc_main$5J, [["render", _sfc_render$5I]]);
const Comment = Object.assign(_Comment, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Comment.name, _Comment);
  }
});
const _sfc_main$5I = defineComponent({
  name: "ConfigProvider",
  props: {
    prefixCls: {
      type: String,
      default: "arco"
    },
    locale: {
      type: Object
    },
    size: {
      type: String
    },
    global: {
      type: Boolean,
      default: false
    },
    updateAtScroll: {
      type: Boolean,
      default: false
    },
    scrollToClose: {
      type: Boolean,
      default: false
    },
    exchangeTime: {
      type: Boolean,
      default: true
    }
  },
  setup(props, { slots }) {
    const {
      prefixCls,
      locale,
      size,
      updateAtScroll,
      scrollToClose,
      exchangeTime
    } = toRefs(props);
    const config = reactive({
      slots,
      prefixCls,
      locale,
      size,
      updateAtScroll,
      scrollToClose,
      exchangeTime
    });
    if (props.global) {
      const instance = getCurrentInstance();
      if (instance) {
        instance.appContext.app.provide(configProviderInjectionKey, config);
      }
    } else {
      provide(configProviderInjectionKey, config);
    }
  }
});
function _sfc_render$5H(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var _ConfigProvider = /* @__PURE__ */ _export_sfc(_sfc_main$5I, [["render", _sfc_render$5H]]);
const ConfigProvider = Object.assign(_ConfigProvider, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _ConfigProvider.name, _ConfigProvider);
  }
});
function usePickerState(props) {
  const { modelValue, defaultValue, format } = toRefs(props);
  const computedModelValue = computed(() => {
    return getDayjsValue(modelValue.value, format.value);
  });
  const computedDefaultValue = computed(() => {
    return getDayjsValue(defaultValue.value, format.value);
  });
  const [localValue, setLocalValue] = useState(
    !isUndefined(computedModelValue.value) ? computedModelValue.value : !isUndefined(computedDefaultValue.value) ? computedDefaultValue.value : void 0
  );
  watch(computedModelValue, () => {
    if (isUndefined(computedModelValue.value)) {
      setLocalValue(void 0);
    }
  });
  const mergeValue = computed(
    () => computedModelValue.value || localValue.value
  );
  return {
    value: mergeValue,
    setValue: setLocalValue
  };
}
const _sfc_main$5H = defineComponent({
  name: "DateInput",
  components: {
    IconHover,
    IconClose,
    FeedbackIcon
  },
  props: {
    size: {
      type: String
    },
    focused: {
      type: Boolean
    },
    disabled: {
      type: Boolean
    },
    readonly: {
      type: Boolean
    },
    error: {
      type: Boolean
    },
    allowClear: {
      type: Boolean
    },
    placeholder: {
      type: String
    },
    inputValue: {
      type: String
    },
    value: {
      type: Object
    },
    format: {
      type: [String, Function],
      required: true
    }
  },
  emits: ["clear", "press-enter", "change", "blur"],
  setup(props, { emit, slots }) {
    const { error, focused, disabled, size, value, format, inputValue } = toRefs(props);
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError,
      feedback
    } = useFormItem({ size, disabled, error });
    const { mergedSize } = useSize$1(_mergedSize);
    const prefixCls = getPrefixCls("picker");
    const classNames = computed(() => [
      prefixCls,
      `${prefixCls}-size-${mergedSize.value}`,
      {
        [`${prefixCls}-focused`]: focused.value,
        [`${prefixCls}-disabled`]: mergedDisabled.value,
        [`${prefixCls}-error`]: mergedError.value,
        [`${prefixCls}-has-prefix`]: slots.prefix
      }
    ]);
    const displayValue = computed(() => {
      if (inputValue == null ? void 0 : inputValue.value)
        return inputValue == null ? void 0 : inputValue.value;
      if ((value == null ? void 0 : value.value) && isDayjs(value.value)) {
        return isFunction(format.value) ? format.value(value.value) : value.value.format(format.value);
      }
      return void 0;
    });
    const refInput = ref();
    return {
      feedback,
      prefixCls,
      classNames,
      displayValue,
      mergedDisabled,
      refInput,
      onPressEnter() {
        emit("press-enter");
      },
      onChange(e) {
        emit("change", e);
      },
      onClear(e) {
        emit("clear", e);
      },
      onBlur(e) {
        emit("blur", e);
      }
    };
  },
  methods: {
    focus() {
      this.refInput && this.refInput.focus && this.refInput.focus();
    },
    blur() {
      this.refInput && this.refInput.blur && this.refInput.blur();
    }
  }
});
const _hoisted_1$4r = ["disabled", "placeholder", "value"];
function _sfc_render$5G(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconClose = resolveComponent("IconClose");
  const _component_IconHover = resolveComponent("IconHover");
  const _component_FeedbackIcon = resolveComponent("FeedbackIcon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    _ctx.$slots.prefix ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-prefix`)
    }, [
      renderSlot(_ctx.$slots, "prefix")
    ], 2)) : createCommentVNode("v-if", true),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-input`)
    }, [
      createBaseVNode("input", mergeProps({
        ref: "refInput",
        disabled: _ctx.mergedDisabled,
        placeholder: _ctx.placeholder,
        class: `${_ctx.prefixCls}-start-time`,
        value: _ctx.displayValue
      }, _ctx.readonly ? { readonly: true } : {}, {
        onKeydown: _cache[0] || (_cache[0] = withKeys((...args) => _ctx.onPressEnter && _ctx.onPressEnter(...args), ["enter"])),
        onInput: _cache[1] || (_cache[1] = (...args) => _ctx.onChange && _ctx.onChange(...args)),
        onBlur: _cache[2] || (_cache[2] = (...args) => _ctx.onBlur && _ctx.onBlur(...args))
      }), null, 16, _hoisted_1$4r)
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-suffix`)
    }, [
      _ctx.allowClear && !_ctx.mergedDisabled && _ctx.displayValue ? (openBlock(), createBlock(_component_IconHover, {
        key: 0,
        prefix: _ctx.prefixCls,
        class: normalizeClass(`${_ctx.prefixCls}-clear-icon`),
        onClick: _ctx.onClear
      }, {
        default: withCtx(() => [
          createVNode(_component_IconClose)
        ]),
        _: 1
      }, 8, ["prefix", "class", "onClick"])) : createCommentVNode("v-if", true),
      createBaseVNode("span", {
        class: normalizeClass(`${_ctx.prefixCls}-suffix-icon`)
      }, [
        renderSlot(_ctx.$slots, "suffix-icon")
      ], 2),
      _ctx.feedback ? (openBlock(), createBlock(_component_FeedbackIcon, {
        key: 1,
        type: _ctx.feedback
      }, null, 8, ["type"])) : createCommentVNode("v-if", true)
    ], 2)
  ], 2);
}
var DateInput = /* @__PURE__ */ _export_sfc(_sfc_main$5H, [["render", _sfc_render$5G]]);
function getColumnsFromFormat(format) {
  const units2 = ["H", "h", "m", "s", "a", "A"];
  const list = [];
  let use12Hours = false;
  units2.forEach((unit) => {
    if (format.indexOf(unit) !== -1) {
      list.push(unit);
      if (unit === "a" || unit === "A") {
        use12Hours = true;
      }
    }
  });
  return {
    list,
    use12Hours
  };
}
const scrollIds = /* @__PURE__ */ new Map();
function scrollTo(element, to, duration) {
  const scrollId = scrollIds.get(element);
  if (!isUndefined(scrollId)) {
    cancelAnimationFrame(scrollId);
  }
  if (duration <= 0) {
    element.scrollTop = to;
  }
  scrollIds.set(
    element,
    requestAnimationFrame(() => {
      const tween = new Tween({
        from: { scrollTop: element.scrollTop },
        to: { scrollTop: to },
        duration,
        onUpdate: (keys) => {
          element.scrollTop = keys.scrollTop;
        }
      });
      tween.start();
    })
  );
}
function getFormattedValue(time, format) {
  const formatValue = (time2) => {
    if (isArray(time2)) {
      return time2.map((t) => formatValue(t));
    }
    if (isUndefined(time2))
      return void 0;
    return time2.format(format);
  };
  return formatValue(time);
}
function isValidRangeValue$1(value) {
  if (isUndefined(value))
    return true;
  if (!isArray(value))
    return false;
  return value.length === 0 || value.length === 2 && isDayjs(value[0]) && isDayjs(value[1]);
}
function isValidInputValue(time, format) {
  if (!time)
    return false;
  return typeof time === "string" && dayjs(time, format).format(format) === time;
}
function isDisabledTime(value, {
  disabledHours,
  disabledMinutes,
  disabledSeconds
}) {
  if (!value)
    return false;
  const hour = value.hour();
  const minute = value.minute();
  const second = value.second();
  const disabledHourList = (disabledHours == null ? void 0 : disabledHours()) || [];
  const disabledMinuteList = (disabledMinutes == null ? void 0 : disabledMinutes(hour)) || [];
  const disabledSecondList = (disabledSeconds == null ? void 0 : disabledSeconds(hour, minute)) || [];
  const isDisabledItem = (num, disabledList) => {
    return !isUndefined(num) && disabledList.includes(num);
  };
  return isDisabledItem(hour, disabledHourList) || isDisabledItem(minute, disabledMinuteList) || isDisabledItem(second, disabledSecondList);
}
var RenderFunction = defineComponent({
  name: "RenderFunction",
  props: {
    renderFunc: {
      type: Function,
      required: true
    }
  },
  render() {
    return this.renderFunc(this.$attrs);
  }
});
const PickerInjectionKey = Symbol("PickerInjectionKey");
function useDatePickerTransform$1() {
  const { datePickerT } = inject(PickerInjectionKey) || {};
  return datePickerT || ((key, ...args) => key);
}
const _sfc_main$5G = defineComponent({
  name: "PanelShortcuts",
  components: {
    Button,
    RenderFunction
  },
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    showNowBtn: {
      type: Boolean
    }
  },
  emits: ["item-click", "item-mouse-enter", "item-mouse-leave", "now-click"],
  setup(props, { emit }) {
    const datePickerT = useDatePickerTransform$1();
    return {
      datePickerT,
      onItemClick: (item) => {
        emit("item-click", item);
      },
      onItemMouseEnter: (item) => {
        emit("item-mouse-enter", item);
      },
      onItemMouseLeave: (item) => {
        emit("item-mouse-leave", item);
      },
      onNowClick: () => {
        emit("now-click");
      },
      isFunction
    };
  }
});
function _sfc_render$5F(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Button = resolveComponent("Button");
  const _component_RenderFunction = resolveComponent("RenderFunction");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(`${_ctx.prefixCls}-shortcuts`)
  }, [
    _ctx.showNowBtn ? (openBlock(), createBlock(_component_Button, {
      key: 0,
      size: "mini",
      onClick: _cache[0] || (_cache[0] = () => _ctx.onNowClick())
    }, {
      default: withCtx(() => [
        createTextVNode(toDisplayString(_ctx.datePickerT("datePicker.now")), 1)
      ]),
      _: 1
    })) : createCommentVNode("v-if", true),
    (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.shortcuts, (item, index2) => {
      return openBlock(), createBlock(_component_Button, {
        key: index2,
        size: "mini",
        onClick: () => _ctx.onItemClick(item),
        onMouseenter: () => _ctx.onItemMouseEnter(item),
        onMouseleave: () => _ctx.onItemMouseLeave(item)
      }, {
        default: withCtx(() => [
          _ctx.isFunction(item.label) ? (openBlock(), createBlock(_component_RenderFunction, {
            key: 0,
            "render-func": item.label
          }, null, 8, ["render-func"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            createTextVNode(toDisplayString(item.label), 1)
          ], 64))
        ]),
        _: 2
      }, 1032, ["onClick", "onMouseenter", "onMouseleave"]);
    }), 128))
  ], 2);
}
var PanelShortcuts = /* @__PURE__ */ _export_sfc(_sfc_main$5G, [["render", _sfc_render$5F]]);
function newArray(length) {
  return [...Array(length)];
}
function normalizeRangeValue(value) {
  if (isUndefined(value)) {
    return void 0;
  }
  return isArray(value) ? value : [value, void 0];
}
function isCompleteRangeValue(value) {
  return !!value && isDayjs(value[0]) && isDayjs(value[1]);
}
function isValidRangeValue(value) {
  return isUndefined(value) || value.length === 0 || isCompleteRangeValue(value);
}
function mergeValueWithTime(defaultValue, dateValue, timeValue) {
  const dateVal = dateValue || defaultValue;
  const timeVal = timeValue || defaultValue;
  return timeVal.set("year", dateVal.year()).set("month", dateVal.month()).set("date", dateVal.date());
}
const _sfc_main$5F = defineComponent({
  name: "IconDoubleLeft",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-double-left`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4q = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5E(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M36.857 9.9 22.715 24.042l14.142 14.142M25.544 9.9 11.402 24.042l14.142 14.142" }, null, -1)
  ]), 14, _hoisted_1$4q);
}
var _IconDoubleLeft = /* @__PURE__ */ _export_sfc(_sfc_main$5F, [["render", _sfc_render$5E]]);
const IconDoubleLeft = Object.assign(_IconDoubleLeft, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconDoubleLeft.name, _IconDoubleLeft);
  }
});
const _sfc_main$5E = defineComponent({
  name: "IconDoubleRight",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-double-right`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4p = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5D(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "m11.143 38.1 14.142-14.142L11.143 9.816M22.456 38.1l14.142-14.142L22.456 9.816" }, null, -1)
  ]), 14, _hoisted_1$4p);
}
var _IconDoubleRight = /* @__PURE__ */ _export_sfc(_sfc_main$5E, [["render", _sfc_render$5D]]);
const IconDoubleRight = Object.assign(_IconDoubleRight, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconDoubleRight.name, _IconDoubleRight);
  }
});
const _sfc_main$5D = defineComponent({
  name: "PanelHeader",
  components: {
    IconLeft,
    IconRight,
    IconDoubleLeft,
    IconDoubleRight,
    RenderFunction
  },
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    title: {
      type: String,
      required: true
    },
    mode: {
      type: String,
      default: "date"
    },
    value: {
      type: Object
    },
    icons: {
      type: Object
    },
    onPrev: {
      type: Function
    },
    onSuperPrev: {
      type: Function
    },
    onNext: {
      type: Function
    },
    onSuperNext: {
      type: Function
    },
    onLabelClick: {
      type: Function
    }
  },
  emits: ["label-click"],
  setup(props) {
    return {
      showPrev: computed(() => isFunction(props.onPrev)),
      showSuperPrev: computed(() => isFunction(props.onSuperPrev)),
      showNext: computed(() => isFunction(props.onNext)),
      showSuperNext: computed(() => isFunction(props.onSuperNext)),
      year: computed(
        () => ["date", "quarter", "month", "week"].includes(props.mode) && props.value ? props.value.format("YYYY") : ""
      ),
      month: computed(
        () => ["date", "week"].includes(props.mode) && props.value ? props.value.format("MM") : ""
      ),
      getIconClassName: (show) => [
        `${props.prefixCls}-header-icon`,
        {
          [`${props.prefixCls}-header-icon-hidden`]: !show
        }
      ]
    };
  }
});
const _hoisted_1$4o = { key: 1 };
function _sfc_render$5C(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_RenderFunction = resolveComponent("RenderFunction");
  const _component_IconDoubleLeft = resolveComponent("IconDoubleLeft");
  const _component_IconLeft = resolveComponent("IconLeft");
  const _component_IconRight = resolveComponent("IconRight");
  const _component_IconDoubleRight = resolveComponent("IconDoubleRight");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(`${_ctx.prefixCls}-header`)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(_ctx.getIconClassName(_ctx.showSuperPrev)),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onSuperPrev && _ctx.onSuperPrev(...args))
    }, [
      _ctx.showSuperPrev ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        _ctx.icons && _ctx.icons.prevDouble ? (openBlock(), createBlock(_component_RenderFunction, {
          key: 0,
          "render-func": _ctx.icons && _ctx.icons.prevDouble
        }, null, 8, ["render-func"])) : (openBlock(), createBlock(_component_IconDoubleLeft, { key: 1 }))
      ], 64)) : createCommentVNode("v-if", true)
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(_ctx.getIconClassName(_ctx.showPrev)),
      onClick: _cache[1] || (_cache[1] = (...args) => _ctx.onPrev && _ctx.onPrev(...args))
    }, [
      _ctx.showPrev ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        _ctx.icons && _ctx.icons.prev ? (openBlock(), createBlock(_component_RenderFunction, {
          key: 0,
          "render-func": _ctx.icons && _ctx.icons.prev
        }, null, 8, ["render-func"])) : (openBlock(), createBlock(_component_IconLeft, { key: 1 }))
      ], 64)) : createCommentVNode("v-if", true)
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-header-title`)
    }, [
      _ctx.onLabelClick && (_ctx.year || _ctx.month) ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        _ctx.year ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass(`${_ctx.prefixCls}-header-label`),
          onClick: _cache[2] || (_cache[2] = () => _ctx.onLabelClick && _ctx.onLabelClick("year"))
        }, toDisplayString(_ctx.year), 3)) : createCommentVNode("v-if", true),
        _ctx.year && _ctx.month ? (openBlock(), createElementBlock("span", _hoisted_1$4o, "-")) : createCommentVNode("v-if", true),
        _ctx.month ? (openBlock(), createElementBlock("span", {
          key: 2,
          class: normalizeClass(`${_ctx.prefixCls}-header-label`),
          onClick: _cache[3] || (_cache[3] = () => _ctx.onLabelClick && _ctx.onLabelClick("month"))
        }, toDisplayString(_ctx.month), 3)) : createCommentVNode("v-if", true)
      ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
        createTextVNode(toDisplayString(_ctx.title), 1)
      ], 64))
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(_ctx.getIconClassName(_ctx.showNext)),
      onClick: _cache[4] || (_cache[4] = (...args) => _ctx.onNext && _ctx.onNext(...args))
    }, [
      _ctx.showNext ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        _ctx.icons && _ctx.icons.next ? (openBlock(), createBlock(_component_RenderFunction, {
          key: 0,
          "render-func": _ctx.icons && _ctx.icons.next
        }, null, 8, ["render-func"])) : (openBlock(), createBlock(_component_IconRight, { key: 1 }))
      ], 64)) : createCommentVNode("v-if", true)
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(_ctx.getIconClassName(_ctx.showSuperNext)),
      onClick: _cache[5] || (_cache[5] = (...args) => _ctx.onSuperNext && _ctx.onSuperNext(...args))
    }, [
      _ctx.showSuperNext ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        _ctx.icons && _ctx.icons.nextDouble ? (openBlock(), createBlock(_component_RenderFunction, {
          key: 0,
          "render-func": _ctx.icons && _ctx.icons.nextDouble
        }, null, 8, ["render-func"])) : (openBlock(), createBlock(_component_IconDoubleRight, { key: 1 }))
      ], 64)) : createCommentVNode("v-if", true)
    ], 2)
  ], 2);
}
var PanelHeader = /* @__PURE__ */ _export_sfc(_sfc_main$5D, [["render", _sfc_render$5C]]);
function useCellClassName(props) {
  const { rangeValues } = toRefs(props);
  const sortedRangeValues = computed(
    () => (rangeValues == null ? void 0 : rangeValues.value) && rangeValues.value.every(isDayjs) ? getSortedDayjsArray(rangeValues.value) : rangeValues == null ? void 0 : rangeValues.value
  );
  const rangeStart = computed(() => {
    var _a;
    return (_a = sortedRangeValues.value) == null ? void 0 : _a[0];
  });
  const rangeEnd = computed(() => {
    var _a;
    return (_a = sortedRangeValues.value) == null ? void 0 : _a[1];
  });
  return {
    getCellClassName: (cellData, disabled) => {
      const { value, isSameTime, mode, prefixCls } = props;
      const isInView = !cellData.isPrev && !cellData.isNext;
      const isSelected = value && isSameTime(cellData.value, value);
      let isToday = isSameTime(cellData.value, getNow());
      if (mode === "week") {
        isToday = getNow().isSame(cellData.value, "date");
      }
      const isRangeStart = isInView && rangeStart.value && isSameTime(cellData.value, rangeStart.value);
      const isRangeEnd = isInView && rangeEnd.value && isSameTime(cellData.value, rangeEnd.value);
      const isInRange = isInView && rangeStart.value && rangeEnd.value && (isRangeStart || isRangeEnd || cellData.value.isBetween(
        rangeStart.value,
        rangeEnd.value,
        null,
        "[]"
      ));
      return [
        `${prefixCls}-cell`,
        {
          [`${prefixCls}-cell-in-view`]: isInView,
          [`${prefixCls}-cell-today`]: isToday,
          [`${prefixCls}-cell-selected`]: isSelected,
          [`${prefixCls}-cell-range-start`]: isRangeStart,
          [`${prefixCls}-cell-range-end`]: isRangeEnd,
          [`${prefixCls}-cell-in-range`]: isInRange,
          [`${prefixCls}-cell-disabled`]: disabled
        },
        cellData.classNames
      ];
    }
  };
}
const _sfc_main$5C = defineComponent({
  name: "PanelBody",
  components: {
    RenderFunction
  },
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    rows: {
      type: Array,
      default: () => []
    },
    value: {
      type: Object
    },
    disabledDate: {
      type: Function
    },
    isSameTime: {
      type: Function,
      required: true
    },
    mode: {
      type: String
    },
    rangeValues: {
      type: Array
    },
    dateRender: {
      type: Function
    }
  },
  emits: ["cell-click", "cell-mouse-enter"],
  setup(props, { emit }) {
    const { prefixCls, value, disabledDate, isSameTime, mode, rangeValues } = toRefs(props);
    const { getCellClassName } = useCellClassName(
      reactive({
        prefixCls,
        value,
        isSameTime,
        mode,
        rangeValues
      })
    );
    const isCellDisabled = (cellData) => !!(isFunction(disabledDate == null ? void 0 : disabledDate.value) && (disabledDate == null ? void 0 : disabledDate.value(getDateValue$1(cellData.value))));
    return {
      isWeek: computed(() => (mode == null ? void 0 : mode.value) === "week"),
      getCellClassName: (cellData) => {
        const disabled = isCellDisabled(cellData);
        return getCellClassName(cellData, disabled);
      },
      onCellClick: (cellData) => {
        const disabled = isCellDisabled(cellData);
        if (disabled)
          return;
        emit("cell-click", cellData);
      },
      onCellMouseEnter: (cellData) => {
        const disabled = isCellDisabled(cellData);
        if (disabled)
          return;
        emit("cell-mouse-enter", cellData);
      },
      onCellMouseLeave: (cellData) => {
        const disabled = isCellDisabled(cellData);
        if (disabled)
          return;
        emit("cell-mouse-enter", cellData);
      },
      getDateValue: getDateValue$1
    };
  }
});
const _hoisted_1$4n = ["onMouseenter", "onMouseleave", "onClick"];
function _sfc_render$5B(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_RenderFunction = resolveComponent("RenderFunction");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(`${_ctx.prefixCls}-body`)
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.rows, (row, rowIndex) => {
      return openBlock(), createElementBlock("div", {
        key: rowIndex,
        class: normalizeClass([
          `${_ctx.prefixCls}-row`,
          {
            [`${_ctx.prefixCls}-row-week`]: _ctx.isWeek
          }
        ])
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(row, (cell, colIndex) => {
          return openBlock(), createElementBlock(Fragment, null, [
            createCommentVNode(" \u4E00\u5E74\u4E2D\u7684\u7B2C\u51E0\u5468\uFF0C\u53EA\u5728 week \u6A21\u5F0F\u4E0B\u663E\u793A "),
            _ctx.isWeek && colIndex === 0 ? (openBlock(), createElementBlock("div", {
              key: colIndex,
              class: normalizeClass([`${_ctx.prefixCls}-cell`, `${_ctx.prefixCls}-cell-week`])
            }, [
              createBaseVNode("div", {
                class: normalizeClass(`${_ctx.prefixCls}-date`)
              }, [
                createBaseVNode("div", {
                  class: normalizeClass(`${_ctx.prefixCls}-date-value`)
                }, toDisplayString(cell.label), 3)
              ], 2)
            ], 2)) : (openBlock(), createElementBlock("div", {
              key: colIndex,
              class: normalizeClass(_ctx.getCellClassName(cell)),
              onMouseenter: () => {
                _ctx.onCellMouseEnter(cell);
              },
              onMouseleave: () => {
                _ctx.onCellMouseLeave(cell);
              },
              onClick: () => {
                _ctx.onCellClick(cell);
              }
            }, [
              _ctx.dateRender ? (openBlock(), createBlock(_component_RenderFunction, {
                key: 0,
                "render-func": _ctx.dateRender,
                date: _ctx.getDateValue(cell.value)
              }, null, 8, ["render-func", "date"])) : (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass(`${_ctx.prefixCls}-date`)
              }, [
                createBaseVNode("div", {
                  class: normalizeClass(`${_ctx.prefixCls}-date-value`)
                }, toDisplayString(cell.label), 3)
              ], 2))
            ], 42, _hoisted_1$4n))
          ], 64);
        }), 256))
      ], 2);
    }), 128))
  ], 2);
}
var PanelBody = /* @__PURE__ */ _export_sfc(_sfc_main$5C, [["render", _sfc_render$5B]]);
const _sfc_main$5B = defineComponent({
  name: "PanelWeekList",
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    weekList: {
      type: Array,
      required: true
    }
  },
  setup() {
    const datePickerT = useDatePickerTransform$1();
    const labelList = computed(() => {
      return [
        "sunday",
        "monday",
        "tuesday",
        "wednesday",
        "thursday",
        "friday",
        "saturday"
      ].map((i2) => datePickerT(`datePicker.week.short.${i2}`));
    });
    return {
      labelList
    };
  }
});
function _sfc_render$5A(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(`${_ctx.prefixCls}-week-list`)
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.weekList, (key) => {
      return openBlock(), createElementBlock("div", {
        key,
        class: normalizeClass(`${_ctx.prefixCls}-week-list-item`)
      }, toDisplayString(_ctx.labelList[key] || ""), 3);
    }), 128))
  ], 2);
}
var PanelWeekList = /* @__PURE__ */ _export_sfc(_sfc_main$5B, [["render", _sfc_render$5A]]);
const _sfc_main$5A = defineComponent({
  name: "TimePickerColumn",
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    list: {
      type: Array,
      required: true
    },
    value: {
      type: [Number, String]
    },
    visible: {
      type: Boolean
    }
  },
  emits: ["select"],
  setup(props, { emit }) {
    const { visible, value } = toRefs(props);
    const refMap = ref(/* @__PURE__ */ new Map());
    const refWrapper = ref();
    function scrollToTop(easing = false) {
      if (!refWrapper.value || isUndefined(value == null ? void 0 : value.value) || !(visible == null ? void 0 : visible.value)) {
        return;
      }
      const refSelected = refMap.value.get(value.value);
      if (refSelected) {
        scrollTo(refWrapper.value, refSelected.offsetTop, easing ? 100 : 0);
      }
    }
    watch([value, visible], (_, [, preVisible]) => {
      if (visible.value !== preVisible) {
        nextTick(() => {
          scrollToTop();
        });
      } else {
        scrollToTop(true);
      }
    });
    onMounted(() => {
      scrollToTop();
    });
    return {
      refWrapper,
      refMap,
      onItemRef(el, item) {
        refMap.value.set(item.value, el);
      },
      onItemClick(item) {
        if (!item.disabled) {
          emit("select", item.value);
        }
      }
    };
  }
});
const _hoisted_1$4m = ["onClick"];
function _sfc_render$5z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    ref: "refWrapper",
    class: normalizeClass(`${_ctx.prefixCls}-column`)
  }, [
    createBaseVNode("ul", null, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.list, (item) => {
        return openBlock(), createElementBlock("li", {
          key: item.value,
          ref_for: true,
          ref: (el) => {
            _ctx.onItemRef(el, item);
          },
          class: normalizeClass([
            `${_ctx.prefixCls}-cell`,
            {
              [`${_ctx.prefixCls}-cell-disabled`]: item.disabled,
              [`${_ctx.prefixCls}-cell-selected`]: item.selected
            }
          ]),
          onClick: () => {
            _ctx.onItemClick(item);
          }
        }, [
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-cell-inner`)
          }, toDisplayString(item.label), 3)
        ], 10, _hoisted_1$4m);
      }), 128))
    ])
  ], 2);
}
var TimeColumn = /* @__PURE__ */ _export_sfc(_sfc_main$5A, [["render", _sfc_render$5z]]);
function useTimeList(props) {
  const {
    format,
    step,
    use12Hours,
    hideDisabledOptions,
    disabledHours,
    disabledMinutes,
    disabledSeconds,
    selectedHour,
    selectedMinute,
    selectedSecond,
    selectedAmpm,
    disabled
  } = toRefs(props);
  const hours = computed(() => {
    var _a;
    const { hour: hourStep = 1 } = (step == null ? void 0 : step.value) || {};
    const disabledList = ((_a = disabledHours == null ? void 0 : disabledHours.value) == null ? void 0 : _a.call(disabledHours)) || [];
    let list = [];
    for (let i2 = 0; i2 < (use12Hours.value ? 12 : 24); i2 += hourStep) {
      list.push(i2);
    }
    if (use12Hours.value) {
      list[0] = 12;
    }
    if (hideDisabledOptions.value && disabledList.length) {
      list = list.filter((h2) => disabledList.indexOf(h2) < 0);
    }
    return list.map((h2) => ({
      label: padStart(h2, 2, "0"),
      value: h2,
      selected: selectedHour.value === h2,
      disabled: (disabled == null ? void 0 : disabled.value) || disabledList.includes(h2)
    }));
  });
  const minutes = computed(() => {
    var _a;
    const { minute: minuteStep = 1 } = (step == null ? void 0 : step.value) || {};
    const disabledList = ((_a = disabledMinutes == null ? void 0 : disabledMinutes.value) == null ? void 0 : _a.call(disabledMinutes, selectedHour.value)) || [];
    let list = [];
    for (let i2 = 0; i2 < 60; i2 += minuteStep) {
      list.push(i2);
    }
    if (hideDisabledOptions.value && disabledList.length) {
      list = list.filter((m) => disabledList.indexOf(m) < 0);
    }
    return list.map((m) => ({
      label: padStart(m, 2, "0"),
      value: m,
      selected: selectedMinute.value === m,
      disabled: (disabled == null ? void 0 : disabled.value) || disabledList.includes(m)
    }));
  });
  const seconds = computed(() => {
    var _a;
    const { second: secondStep = 1 } = (step == null ? void 0 : step.value) || {};
    const disabledList = ((_a = disabledSeconds == null ? void 0 : disabledSeconds.value) == null ? void 0 : _a.call(disabledSeconds, selectedHour.value, selectedMinute.value)) || [];
    let list = [];
    for (let i2 = 0; i2 < 60; i2 += secondStep) {
      list.push(i2);
    }
    if (hideDisabledOptions.value && disabledList.length) {
      list = list.filter((s) => disabledList.indexOf(s) < 0);
    }
    return list.map((s) => ({
      label: padStart(s, 2, "0"),
      value: s,
      selected: selectedSecond.value === s,
      disabled: (disabled == null ? void 0 : disabled.value) || disabledList.includes(s)
    }));
  });
  const AMPM = ["am", "pm"];
  const ampmList = computed(() => {
    const isUpperCase = getColumnsFromFormat(format.value).list.includes("A");
    return AMPM.map((a) => ({
      label: isUpperCase ? a.toUpperCase() : a,
      value: a,
      selected: selectedAmpm.value === a,
      disabled: disabled == null ? void 0 : disabled.value
    }));
  });
  return {
    hours,
    minutes,
    seconds,
    ampmList
  };
}
function useTimeFormat(props) {
  const {
    format: propFormat,
    use12Hours: propUse12Hours,
    defaultFormat
  } = toRefs(props);
  const format = computed(() => {
    let res = (propFormat == null ? void 0 : propFormat.value) || (defaultFormat == null ? void 0 : defaultFormat.value);
    if (!res || !getColumnsFromFormat(res).list.length) {
      res = (propUse12Hours == null ? void 0 : propUse12Hours.value) ? "hh:mm:ss a" : "HH:mm:ss";
    }
    return res;
  });
  const configFromFormat = computed(() => getColumnsFromFormat(format.value));
  const list = computed(() => configFromFormat.value.list);
  const formatUse12Hours = computed(() => configFromFormat.value.use12Hours);
  const computedUse12Hours = computed(
    () => !!((propUse12Hours == null ? void 0 : propUse12Hours.value) || formatUse12Hours.value)
  );
  return {
    columns: list,
    use12Hours: computedUse12Hours,
    format
  };
}
function useIsDisabledTime(props) {
  const isDisabled = (value) => {
    return isDisabledTime(value, {
      disabledHours: props.disabledHours,
      disabledMinutes: props.disabledMinutes,
      disabledSeconds: props.disabledSeconds
    });
  };
  return (value) => {
    return isArray(value) ? value.some((i2) => isDisabled(i2)) : isDisabled(value);
  };
}
const _sfc_main$5z = defineComponent({
  name: "TimePickerPanel",
  components: {
    TimeColumn,
    Button
  },
  props: {
    value: {
      type: Object
    },
    visible: {
      type: Boolean
    },
    format: {
      type: String,
      default: "HH:mm:ss"
    },
    use12Hours: {
      type: Boolean
    },
    step: {
      type: Object
    },
    disabledHours: {
      type: Function
    },
    disabledMinutes: {
      type: Function
    },
    disabledSeconds: {
      type: Function
    },
    hideDisabledOptions: {
      type: Boolean
    },
    hideFooter: {
      type: Boolean
    },
    isRange: {
      type: Boolean
    },
    disabled: {
      type: Boolean
    }
  },
  emits: {
    select: (value) => isDayjs(value),
    confirm: (value) => isDayjs(value)
  },
  setup(props, { emit }) {
    const {
      value,
      visible,
      format,
      step,
      use12Hours,
      hideDisabledOptions,
      disabledHours,
      disabledMinutes,
      disabledSeconds,
      disabled
    } = toRefs(props);
    const prefixCls = getPrefixCls("timepicker");
    const { t } = useI18n();
    const {
      columns,
      use12Hours: computedUse12Hours,
      format: computedFormat
    } = useTimeFormat(
      reactive({
        format,
        use12Hours
      })
    );
    const selectedValue = ref(value == null ? void 0 : value.value);
    const setSelectedValue = (value2) => {
      selectedValue.value = value2;
    };
    watch([visible, value], () => {
      if (!visible.value)
        return;
      setSelectedValue(value == null ? void 0 : value.value);
    });
    const selectedHour = computed(() => {
      var _a;
      const _hour = (_a = selectedValue.value) == null ? void 0 : _a.hour();
      if (isUndefined(_hour) || !computedUse12Hours.value)
        return _hour;
      if (_hour > 12)
        return _hour - 12;
      if (_hour === 0)
        return 12;
      return _hour;
    });
    const selectedMinute = computed(() => {
      var _a;
      return (_a = selectedValue.value) == null ? void 0 : _a.minute();
    });
    const selectedSecond = computed(() => {
      var _a;
      return (_a = selectedValue.value) == null ? void 0 : _a.second();
    });
    const selectedAmpm = computed(() => {
      var _a;
      const _hour = (_a = selectedValue.value) == null ? void 0 : _a.hour();
      return !isUndefined(_hour) && _hour >= 12 ? "pm" : "am";
    });
    const { hours, minutes, seconds, ampmList } = useTimeList(
      reactive({
        format: computedFormat,
        step,
        use12Hours: computedUse12Hours,
        hideDisabledOptions,
        disabledHours,
        disabledMinutes,
        disabledSeconds,
        selectedHour,
        selectedMinute,
        selectedSecond,
        selectedAmpm,
        disabled
      })
    );
    const isDisabledTime2 = useIsDisabledTime(
      reactive({
        disabledHours,
        disabledMinutes,
        disabledSeconds
      })
    );
    const confirmBtnDisabled = computed(
      () => isDisabledTime2(selectedValue.value)
    );
    function emitConfirm(value2) {
      if (isUndefined(value2))
        return;
      emit("confirm", value2);
    }
    function emitSelect(value2) {
      setSelectedValue(value2);
      emit("select", value2);
    }
    function onSelect(value2, type = "hour") {
      let newValue;
      const hour = selectedHour.value || "00";
      const minute = selectedMinute.value || "00";
      const second = selectedSecond.value || "00";
      const ampm = selectedAmpm.value || "am";
      switch (type) {
        case "hour":
          newValue = `${value2}:${minute}:${second}`;
          break;
        case "minute":
          newValue = `${hour}:${value2}:${second}`;
          break;
        case "second":
          newValue = `${hour}:${minute}:${value2}`;
          break;
        case "ampm":
          newValue = `${hour}:${minute}:${second} ${value2}`;
          break;
        default:
          newValue = "00:00:00";
      }
      let valueFormat = "HH:mm:ss";
      if (computedUse12Hours.value) {
        valueFormat = "HH:mm:ss a";
        if (type !== "ampm") {
          newValue = `${newValue} ${ampm}`;
        }
      }
      newValue = dayjs(newValue, valueFormat);
      emitSelect(newValue);
    }
    return {
      prefixCls,
      t,
      hours,
      minutes,
      seconds,
      ampmList,
      selectedValue,
      selectedHour,
      selectedMinute,
      selectedSecond,
      selectedAmpm,
      computedUse12Hours,
      confirmBtnDisabled,
      columns,
      onSelect,
      onSelectNow() {
        const newValue = dayjs(new Date());
        emitSelect(newValue);
      },
      onConfirm() {
        emitConfirm(selectedValue.value);
      }
    };
  }
});
function _sfc_render$5y(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_TimeColumn = resolveComponent("TimeColumn");
  const _component_Button = resolveComponent("Button");
  return openBlock(), createElementBlock(Fragment, null, [
    createBaseVNode("div", {
      class: normalizeClass(_ctx.prefixCls)
    }, [
      _ctx.columns.includes("H") || _ctx.columns.includes("h") ? (openBlock(), createBlock(_component_TimeColumn, {
        key: 0,
        value: _ctx.selectedHour,
        list: _ctx.hours,
        "prefix-cls": _ctx.prefixCls,
        visible: _ctx.visible,
        onSelect: _cache[0] || (_cache[0] = (value) => {
          _ctx.onSelect(value, "hour");
        })
      }, null, 8, ["value", "list", "prefix-cls", "visible"])) : createCommentVNode("v-if", true),
      _ctx.columns.includes("m") ? (openBlock(), createBlock(_component_TimeColumn, {
        key: 1,
        value: _ctx.selectedMinute,
        list: _ctx.minutes,
        "prefix-cls": _ctx.prefixCls,
        visible: _ctx.visible,
        onSelect: _cache[1] || (_cache[1] = (value) => {
          _ctx.onSelect(value, "minute");
        })
      }, null, 8, ["value", "list", "prefix-cls", "visible"])) : createCommentVNode("v-if", true),
      _ctx.columns.includes("s") ? (openBlock(), createBlock(_component_TimeColumn, {
        key: 2,
        value: _ctx.selectedSecond,
        list: _ctx.seconds,
        "prefix-cls": _ctx.prefixCls,
        visible: _ctx.visible,
        onSelect: _cache[2] || (_cache[2] = (value) => {
          _ctx.onSelect(value, "second");
        })
      }, null, 8, ["value", "list", "prefix-cls", "visible"])) : createCommentVNode("v-if", true),
      _ctx.computedUse12Hours ? (openBlock(), createBlock(_component_TimeColumn, {
        key: 3,
        value: _ctx.selectedAmpm,
        list: _ctx.ampmList,
        "prefix-cls": _ctx.prefixCls,
        visible: _ctx.visible,
        onSelect: _cache[3] || (_cache[3] = (value) => {
          _ctx.onSelect(value, "ampm");
        })
      }, null, 8, ["value", "list", "prefix-cls", "visible"])) : createCommentVNode("v-if", true)
    ], 2),
    _ctx.$slots["extra-footer"] ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-footer-extra-wrapper`)
    }, [
      renderSlot(_ctx.$slots, "extra-footer")
    ], 2)) : createCommentVNode("v-if", true),
    !_ctx.hideFooter ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-footer-btn-wrapper`)
    }, [
      !_ctx.isRange ? (openBlock(), createBlock(_component_Button, {
        key: 0,
        size: "mini",
        onClick: _ctx.onSelectNow
      }, {
        default: withCtx(() => [
          createTextVNode(toDisplayString(_ctx.t("datePicker.now")), 1)
        ]),
        _: 1
      }, 8, ["onClick"])) : createCommentVNode("v-if", true),
      createVNode(_component_Button, {
        type: "primary",
        size: "mini",
        disabled: _ctx.confirmBtnDisabled || !_ctx.selectedValue,
        onClick: _ctx.onConfirm
      }, {
        default: withCtx(() => [
          createTextVNode(toDisplayString(_ctx.t("datePicker.ok")), 1)
        ]),
        _: 1
      }, 8, ["disabled", "onClick"])
    ], 2)) : createCommentVNode("v-if", true)
  ], 64);
}
var Panel$1 = /* @__PURE__ */ _export_sfc(_sfc_main$5z, [["render", _sfc_render$5y]]);
const _sfc_main$5y = defineComponent({
  name: "IconCalendar",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-calendar`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4l = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5x(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M7 22h34M14 5v8m20-8v8M8 41h32a1 1 0 0 0 1-1V10a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v30a1 1 0 0 0 1 1Z" }, null, -1)
  ]), 14, _hoisted_1$4l);
}
var _IconCalendar = /* @__PURE__ */ _export_sfc(_sfc_main$5y, [["render", _sfc_render$5x]]);
const IconCalendar = Object.assign(_IconCalendar, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconCalendar.name, _IconCalendar);
  }
});
const _sfc_main$5x = defineComponent({
  name: "IconClockCircle",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-clock-circle`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4k = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5w(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M24 14v10h9.5m8.5 0c0 9.941-8.059 18-18 18S6 33.941 6 24 14.059 6 24 6s18 8.059 18 18Z" }, null, -1)
  ]), 14, _hoisted_1$4k);
}
var _IconClockCircle = /* @__PURE__ */ _export_sfc(_sfc_main$5x, [["render", _sfc_render$5w]]);
const IconClockCircle = Object.assign(_IconClockCircle, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconClockCircle.name, _IconClockCircle);
  }
});
const ROW_COUNT$2 = 6;
const COL_COUNT$2 = 7;
const CELL_COUNT$2 = ROW_COUNT$2 * COL_COUNT$2;
function getCellData(time) {
  return {
    label: time.date(),
    value: time
  };
}
const _sfc_main$5w = defineComponent({
  name: "DatePanel",
  components: {
    PanelHeader,
    PanelBody,
    PanelWeekList,
    TimePanel: Panel$1,
    IconCalendar,
    IconClockCircle
  },
  props: {
    isRange: {
      type: Boolean
    },
    value: {
      type: Object
    },
    rangeValues: {
      type: Array
    },
    headerValue: {
      type: Object,
      required: true
    },
    footerValue: {
      type: Object
    },
    timePickerValue: {
      type: Object
    },
    headerOperations: {
      type: Object,
      default: () => ({})
    },
    headerIcons: {
      type: Object,
      default: () => ({})
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    disabledDate: {
      type: Function
    },
    disabledTime: {
      type: Function
    },
    isSameTime: {
      type: Function
    },
    mode: {
      type: String,
      default: "date"
    },
    showTime: {
      type: Boolean
    },
    timePickerProps: {
      type: Object
    },
    currentView: {
      type: String
    },
    dateRender: {
      type: Function
    },
    disabled: {
      type: Boolean
    },
    onHeaderLabelClick: {
      type: Function
    }
  },
  emits: [
    "select",
    "time-picker-select",
    "cell-mouse-enter",
    "current-view-change",
    "update:currentView"
  ],
  setup(props, { emit }) {
    const {
      isRange,
      headerValue,
      footerValue,
      dayStartOfWeek,
      isSameTime,
      mode,
      showTime,
      currentView,
      disabledTime
    } = toRefs(props);
    const datePickerT = useDatePickerTransform$1();
    const isWeek = computed(() => (mode == null ? void 0 : mode.value) === "week");
    const prefixCls = computed(
      () => getPrefixCls(isWeek.value ? "panel-week" : "panel-date")
    );
    const pickerPrefixCls = getPrefixCls("picker");
    const [localCurrentView, setLocalCurrentView] = useMergeState(
      "date",
      reactive({ value: currentView })
    );
    const showViewTabs = computed(() => showTime.value && isRange.value);
    const showDateView = computed(
      () => !showTime.value || !showViewTabs.value || localCurrentView.value === "date"
    );
    const showTimeView = computed(
      () => showTime.value && (!showViewTabs.value || localCurrentView.value === "time")
    );
    const classNames = computed(() => [
      prefixCls.value,
      {
        [`${prefixCls.value}-with-view-tabs`]: showViewTabs.value
      }
    ]);
    const headerTitle = computed(() => headerValue.value.format("YYYY-MM"));
    const disabledTimeProps = computed(
      () => {
        var _a;
        return showTime.value && ((_a = disabledTime == null ? void 0 : disabledTime.value) == null ? void 0 : _a.call(
          disabledTime,
          getDateValue$1((footerValue == null ? void 0 : footerValue.value) || getNow())
        )) || {};
      }
    );
    const weekList = computed(() => {
      const list = [0, 1, 2, 3, 4, 5, 6];
      const index2 = Math.max(dayStartOfWeek.value % 7, 0);
      return [...list.slice(index2), ...list.slice(0, index2)];
    });
    const rows = computed(() => {
      const startDate = methods.startOf(headerValue.value, "month");
      const startDay = startDate.day();
      const days = startDate.daysInMonth();
      const startIndex = weekList.value.indexOf(startDay);
      const flatData = newArray(CELL_COUNT$2);
      for (let i2 = 0; i2 < flatData.length; i2++) {
        flatData[i2] = {
          ...getCellData(methods.add(startDate, i2 - startIndex, "day")),
          isPrev: i2 < startIndex,
          isNext: i2 > startIndex + days - 1
        };
      }
      const rows2 = newArray(ROW_COUNT$2).map((_, index2) => {
        const row = flatData.slice(index2 * COL_COUNT$2, (index2 + 1) * COL_COUNT$2);
        if (isWeek.value) {
          const valueOfWeek = row[0].value;
          row.unshift({
            label: valueOfWeek.week(),
            value: valueOfWeek
          });
        }
        return row;
      });
      return rows2;
    });
    const mergedIsSameTime = computed(
      () => (isSameTime == null ? void 0 : isSameTime.value) || ((current, target2) => {
        return current.isSame(target2, "day");
      })
    );
    function onCellClick(cellData) {
      emit("select", cellData.value);
    }
    function onTimePanelSelect(time) {
      emit("time-picker-select", time);
    }
    function onCellMouseEnter(cellData) {
      emit("cell-mouse-enter", cellData.value);
    }
    return {
      prefixCls,
      classNames,
      pickerPrefixCls,
      headerTitle,
      rows,
      weekList: computed(
        () => isWeek.value ? [-1, ...weekList.value] : weekList.value
      ),
      mergedIsSameTime,
      disabledTimeProps,
      onCellClick,
      onCellMouseEnter,
      onTimePanelSelect,
      showViewTabs,
      showDateView,
      showTimeView,
      changeViewTo: (newView) => {
        emit("current-view-change", newView);
        emit("update:currentView", newView);
        setLocalCurrentView(newView);
      },
      datePickerT
    };
  }
});
function _sfc_render$5v(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PanelHeader = resolveComponent("PanelHeader");
  const _component_PanelWeekList = resolveComponent("PanelWeekList");
  const _component_PanelBody = resolveComponent("PanelBody");
  const _component_TimePanel = resolveComponent("TimePanel");
  const _component_IconCalendar = resolveComponent("IconCalendar");
  const _component_IconClockCircle = resolveComponent("IconClockCircle");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    _ctx.showDateView ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-inner`)
    }, [
      createVNode(_component_PanelHeader, mergeProps({
        ..._ctx.headerOperations,
        icons: _ctx.headerIcons
      }, {
        "prefix-cls": _ctx.pickerPrefixCls,
        title: _ctx.headerTitle,
        mode: _ctx.mode,
        value: _ctx.headerValue,
        "on-label-click": _ctx.onHeaderLabelClick
      }), null, 16, ["prefix-cls", "title", "mode", "value", "on-label-click"]),
      createVNode(_component_PanelWeekList, {
        "prefix-cls": _ctx.pickerPrefixCls,
        "week-list": _ctx.weekList
      }, null, 8, ["prefix-cls", "week-list"]),
      createVNode(_component_PanelBody, {
        mode: _ctx.mode,
        "prefix-cls": _ctx.pickerPrefixCls,
        rows: _ctx.rows,
        value: _ctx.isRange ? void 0 : _ctx.value,
        "range-values": _ctx.rangeValues,
        "disabled-date": _ctx.disabledDate,
        "is-same-time": _ctx.mergedIsSameTime,
        "date-render": _ctx.dateRender,
        onCellClick: _ctx.onCellClick,
        onCellMouseEnter: _ctx.onCellMouseEnter
      }, null, 8, ["mode", "prefix-cls", "rows", "value", "range-values", "disabled-date", "is-same-time", "date-render", "onCellClick", "onCellMouseEnter"])
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.showTimeView ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-timepicker`)
    }, [
      createBaseVNode("header", {
        class: normalizeClass(`${_ctx.prefixCls}-timepicker-title`)
      }, toDisplayString(_ctx.datePickerT("datePicker.selectTime")), 3),
      createVNode(_component_TimePanel, mergeProps({
        ..._ctx.timePickerProps,
        ..._ctx.disabledTimeProps
      }, {
        "hide-footer": "",
        value: _ctx.value || _ctx.isRange ? _ctx.timePickerValue : void 0,
        disabled: _ctx.disabled,
        onSelect: _ctx.onTimePanelSelect
      }), null, 16, ["value", "disabled", "onSelect"])
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.showViewTabs ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(`${_ctx.prefixCls}-footer`)
    }, [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-view-tabs`)
      }, [
        createBaseVNode("div", {
          class: normalizeClass([
            `${_ctx.prefixCls}-view-tab-pane`,
            { [`${_ctx.prefixCls}-view-tab-pane-active`]: _ctx.showDateView }
          ]),
          onClick: _cache[0] || (_cache[0] = () => _ctx.changeViewTo("date"))
        }, [
          createVNode(_component_IconCalendar),
          createBaseVNode("span", {
            class: normalizeClass(`${_ctx.prefixCls}-view-tab-pane-text`)
          }, toDisplayString(_ctx.footerValue && _ctx.footerValue.format("YYYY-MM-DD")), 3)
        ], 2),
        createBaseVNode("div", {
          class: normalizeClass([
            `${_ctx.prefixCls}-view-tab-pane`,
            { [`${_ctx.prefixCls}-view-tab-pane-active`]: _ctx.showTimeView }
          ]),
          onClick: _cache[1] || (_cache[1] = () => _ctx.changeViewTo("time"))
        }, [
          createVNode(_component_IconClockCircle),
          createBaseVNode("span", {
            class: normalizeClass(`${_ctx.prefixCls}-view-tab-pane-text`)
          }, toDisplayString(_ctx.timePickerValue && _ctx.timePickerValue.format("HH:mm:ss")), 3)
        ], 2)
      ], 2)
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var DatePanel = /* @__PURE__ */ _export_sfc(_sfc_main$5w, [["render", _sfc_render$5v]]);
const _sfc_main$5v = defineComponent({
  name: "WeekPanel",
  components: {
    DatePanel
  },
  props: {
    dayStartOfWeek: {
      type: Number,
      default: 0
    }
  },
  emits: ["select", "cell-mouse-enter"],
  setup(props, { emit }) {
    useI18n();
    const isSameTime = (current, target2) => {
      return methods.isSameWeek(current, target2, props.dayStartOfWeek);
    };
    return {
      isSameTime,
      onSelect: (value) => {
        const startDateOfWeek = methods.startOfWeek(
          value,
          props.dayStartOfWeek
        );
        emit("select", startDateOfWeek);
      },
      onCellMouseEnter: (value) => {
        const startDateOfWeek = methods.startOfWeek(
          value,
          props.dayStartOfWeek
        );
        emit("cell-mouse-enter", startDateOfWeek);
      }
    };
  }
});
function _sfc_render$5u(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_DatePanel = resolveComponent("DatePanel");
  return openBlock(), createBlock(_component_DatePanel, mergeProps(_ctx.$attrs, {
    mode: "week",
    "is-week": "",
    "day-start-of-week": _ctx.dayStartOfWeek,
    "is-same-time": _ctx.isSameTime,
    onSelect: _ctx.onSelect,
    onCellMouseEnter: _ctx.onCellMouseEnter
  }), null, 16, ["day-start-of-week", "is-same-time", "onSelect", "onCellMouseEnter"]);
}
var WeekPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5v, [["render", _sfc_render$5u]]);
const MONTH_LIST = [
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
];
const CELL_COUNT$1 = 12;
const ROW_COUNT$1 = 4;
const COL_COUNT$1 = 3;
const _sfc_main$5u = defineComponent({
  name: "MonthPanel",
  components: {
    PanelHeader,
    PanelBody
  },
  props: {
    headerValue: {
      type: Object,
      required: true
    },
    headerOperations: {
      type: Object,
      default: () => ({})
    },
    headerIcons: {
      type: Object,
      default: () => ({})
    },
    value: {
      type: Object
    },
    disabledDate: {
      type: Function
    },
    rangeValues: {
      type: Array
    },
    dateRender: {
      type: Function
    },
    onHeaderLabelClick: {
      type: Function
    },
    abbreviation: {
      type: Boolean,
      default: true
    }
  },
  emits: ["select", "cell-mouse-enter"],
  setup(props, { emit }) {
    const datePickerT = useDatePickerTransform$1();
    const { headerValue } = toRefs(props);
    const prefixCls = computed(() => getPrefixCls("panel-month"));
    const pickerPrefixCls = getPrefixCls("picker");
    const headerTitle = computed(() => headerValue.value.format("YYYY"));
    const rows = computed(() => {
      const year = headerValue.value.year();
      const isAbbr = props.abbreviation ? "short" : "long";
      const flatData = newArray(CELL_COUNT$1).map((_, index2) => ({
        label: datePickerT(`datePicker.month.${isAbbr}.${MONTH_LIST[index2]}`),
        value: dayjs(`${year}-${index2 + 1}`, "YYYY-M")
      }));
      const rows2 = newArray(ROW_COUNT$1).map(
        (_, index2) => flatData.slice(index2 * COL_COUNT$1, (index2 + 1) * COL_COUNT$1)
      );
      return rows2;
    });
    const isSameTime = (current, target2) => current.isSame(target2, "month");
    function onCellClick(cellData) {
      emit("select", cellData.value);
    }
    function onCellMouseEnter(cellData) {
      emit("cell-mouse-enter", cellData.value);
    }
    return {
      prefixCls,
      pickerPrefixCls,
      headerTitle,
      rows,
      isSameTime,
      onCellClick,
      onCellMouseEnter
    };
  }
});
function _sfc_render$5t(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PanelHeader = resolveComponent("PanelHeader");
  const _component_PanelBody = resolveComponent("PanelBody");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-inner`)
    }, [
      createVNode(_component_PanelHeader, mergeProps({
        ..._ctx.headerOperations,
        icons: _ctx.headerIcons
      }, {
        "prefix-cls": _ctx.pickerPrefixCls,
        title: _ctx.headerTitle,
        mode: "month",
        value: _ctx.headerValue,
        "on-label-click": _ctx.onHeaderLabelClick
      }), null, 16, ["prefix-cls", "title", "value", "on-label-click"]),
      createVNode(_component_PanelBody, {
        mode: "month",
        "prefix-cls": _ctx.pickerPrefixCls,
        rows: _ctx.rows,
        value: _ctx.value,
        "range-values": _ctx.rangeValues,
        "disabled-date": _ctx.disabledDate,
        "is-same-time": _ctx.isSameTime,
        "date-render": _ctx.dateRender,
        onCellClick: _ctx.onCellClick,
        onCellMouseEnter: _ctx.onCellMouseEnter
      }, null, 8, ["prefix-cls", "rows", "value", "range-values", "disabled-date", "is-same-time", "date-render", "onCellClick", "onCellMouseEnter"])
    ], 2)
  ], 2);
}
var MonthPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5u, [["render", _sfc_render$5t]]);
const ROW_COUNT = 4;
const COL_COUNT = 3;
const CELL_COUNT = ROW_COUNT * COL_COUNT;
const SPAN = 10;
const _sfc_main$5t = defineComponent({
  name: "YearPanel",
  components: {
    PanelHeader,
    PanelBody
  },
  props: {
    headerValue: {
      type: Object,
      required: true
    },
    headerOperations: {
      type: Object,
      default: () => ({})
    },
    headerIcons: {
      type: Object,
      default: () => ({})
    },
    value: {
      type: Object
    },
    disabledDate: {
      type: Function
    },
    rangeValues: {
      type: Array
    },
    dateRender: {
      type: Function
    }
  },
  emits: ["select", "cell-mouse-enter"],
  setup(props, { emit }) {
    const { headerValue } = toRefs(props);
    const prefixCls = computed(() => getPrefixCls("panel-year"));
    const pickerPrefixCls = getPrefixCls("picker");
    const rows = computed(() => {
      const startYear = Math.floor(headerValue.value.year() / SPAN) * SPAN - 1;
      const flatData = newArray(CELL_COUNT).map((_, index2) => ({
        label: startYear + index2,
        value: dayjs(`${startYear + index2}`, "YYYY"),
        isPrev: index2 < 1,
        isNext: index2 > SPAN
      }));
      const rows2 = newArray(ROW_COUNT).map(
        (_, index2) => flatData.slice(index2 * COL_COUNT, (index2 + 1) * COL_COUNT)
      );
      return rows2;
    });
    const headerTitle = computed(
      () => `${rows.value[0][1].label}-${rows.value[ROW_COUNT - 1][COL_COUNT - 1].label}`
    );
    const isSameTime = (current, target2) => current.isSame(target2, "year");
    function onCellClick(cellData) {
      emit("select", cellData.value);
    }
    function onCellMouseEnter(cellData) {
      emit("cell-mouse-enter", cellData.value);
    }
    return {
      prefixCls,
      pickerPrefixCls,
      headerTitle,
      rows,
      isSameTime,
      onCellClick,
      onCellMouseEnter
    };
  }
});
function _sfc_render$5s(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PanelHeader = resolveComponent("PanelHeader");
  const _component_PanelBody = resolveComponent("PanelBody");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-inner`)
    }, [
      createVNode(_component_PanelHeader, mergeProps({
        ..._ctx.headerOperations,
        icons: _ctx.headerIcons
      }, {
        "prefix-cls": _ctx.pickerPrefixCls,
        title: _ctx.headerTitle
      }), null, 16, ["prefix-cls", "title"]),
      createVNode(_component_PanelBody, {
        mode: "year",
        "prefix-cls": _ctx.pickerPrefixCls,
        rows: _ctx.rows,
        value: _ctx.value,
        "range-values": _ctx.rangeValues,
        "disabled-date": _ctx.disabledDate,
        "is-same-time": _ctx.isSameTime,
        "date-render": _ctx.dateRender,
        onCellClick: _ctx.onCellClick,
        onCellMouseEnter: _ctx.onCellMouseEnter
      }, null, 8, ["prefix-cls", "rows", "value", "range-values", "disabled-date", "is-same-time", "date-render", "onCellClick", "onCellMouseEnter"])
    ], 2)
  ], 2);
}
var YearPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5t, [["render", _sfc_render$5s]]);
const _sfc_main$5s = defineComponent({
  name: "QuarterPanel",
  components: {
    PanelHeader,
    PanelBody
  },
  props: {
    headerValue: {
      type: Object,
      required: true
    },
    headerOperations: {
      type: Object,
      default: () => ({})
    },
    headerIcons: {
      type: Object,
      default: () => ({})
    },
    value: {
      type: Object
    },
    disabledDate: {
      type: Function
    },
    rangeValues: {
      type: Array
    },
    dateRender: {
      type: Function
    },
    onHeaderLabelClick: {
      type: Function
    }
  },
  emits: ["select", "cell-mouse-enter"],
  setup(props, { emit }) {
    const { headerValue } = toRefs(props);
    const prefixCls = computed(() => getPrefixCls("panel-quarter"));
    const pickerPrefixCls = getPrefixCls("picker");
    const headerTitle = computed(() => headerValue.value.format("YYYY"));
    const rows = computed(() => {
      const year = headerValue.value.year();
      return [
        [1, 2, 3, 4].map((q) => ({
          label: `Q${q}`,
          value: dayjs(`${year}-${padStart((q - 1) * 3 + 1, 2, "0")}-01`)
        }))
      ];
    });
    const isSameTime = (current, target2) => current.isSame(target2, "month") || current.isSame(target2, "year") && Math.floor(current.month() / 3) === Math.floor(target2.month() / 3);
    function onCellClick(cellData) {
      emit("select", cellData.value);
    }
    function onCellMouseEnter(cellData) {
      emit("cell-mouse-enter", cellData.value);
    }
    return {
      prefixCls,
      pickerPrefixCls,
      headerTitle,
      rows,
      isSameTime,
      onCellClick,
      onCellMouseEnter
    };
  }
});
function _sfc_render$5r(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PanelHeader = resolveComponent("PanelHeader");
  const _component_PanelBody = resolveComponent("PanelBody");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-inner`)
    }, [
      createVNode(_component_PanelHeader, mergeProps({
        ..._ctx.headerOperations,
        icons: _ctx.headerIcons
      }, {
        "prefix-cls": _ctx.pickerPrefixCls,
        title: _ctx.headerTitle,
        mode: "quarter",
        value: _ctx.headerValue,
        "on-label-click": _ctx.onHeaderLabelClick
      }), null, 16, ["prefix-cls", "title", "value", "on-label-click"]),
      createVNode(_component_PanelBody, {
        mode: "quarter",
        "prefix-cls": _ctx.pickerPrefixCls,
        rows: _ctx.rows,
        value: _ctx.value,
        "range-values": _ctx.rangeValues,
        "disabled-date": _ctx.disabledDate,
        "is-same-time": _ctx.isSameTime,
        "date-render": _ctx.dateRender,
        onCellClick: _ctx.onCellClick,
        onCellMouseEnter: _ctx.onCellMouseEnter
      }, null, 8, ["prefix-cls", "rows", "value", "range-values", "disabled-date", "is-same-time", "date-render", "onCellClick", "onCellMouseEnter"])
    ], 2)
  ], 2);
}
var QuarterPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5s, [["render", _sfc_render$5r]]);
const _sfc_main$5r = defineComponent({
  name: "IconLink",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-link`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4j = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "m14.1 25.414-4.95 4.95a6 6 0 0 0 8.486 8.485l8.485-8.485a6 6 0 0 0 0-8.485m7.779.707 4.95-4.95a6 6 0 1 0-8.486-8.485l-8.485 8.485a6 6 0 0 0 0 8.485" }, null, -1)
  ]), 14, _hoisted_1$4j);
}
var _IconLink = /* @__PURE__ */ _export_sfc(_sfc_main$5r, [["render", _sfc_render$5q]]);
const IconLink = Object.assign(_IconLink, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconLink.name, _IconLink);
  }
});
const _sfc_main$5q = defineComponent({
  name: "Link",
  components: { IconLink, IconLoading },
  props: {
    href: String,
    status: {
      type: String,
      default: "normal"
    },
    hoverable: {
      type: Boolean,
      default: true
    },
    icon: Boolean,
    loading: Boolean,
    disabled: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { slots, emit }) {
    const prefixCls = getPrefixCls("link");
    const showIcon = hasPropOrSlot(props, slots, "icon");
    const handleClick = (ev) => {
      if (props.disabled || props.loading) {
        ev.preventDefault();
        return;
      }
      emit("click", ev);
    };
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-status-${props.status}`,
      {
        [`${prefixCls}-disabled`]: props.disabled,
        [`${prefixCls}-loading`]: props.loading,
        [`${prefixCls}-hoverless`]: !props.hoverable,
        [`${prefixCls}-with-icon`]: props.loading || showIcon.value
      }
    ]);
    return {
      cls,
      prefixCls,
      showIcon,
      handleClick
    };
  }
});
const _hoisted_1$4i = ["href"];
function _sfc_render$5p(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_loading = resolveComponent("icon-loading");
  const _component_icon_link = resolveComponent("icon-link");
  return openBlock(), createElementBlock("a", {
    href: _ctx.disabled ? void 0 : _ctx.href,
    class: normalizeClass(_ctx.cls),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    _ctx.loading || _ctx.showIcon ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [
      _ctx.loading ? (openBlock(), createBlock(_component_icon_loading, { key: 0 })) : renderSlot(_ctx.$slots, "icon", { key: 1 }, () => [
        createVNode(_component_icon_link)
      ])
    ], 2)) : createCommentVNode("v-if", true),
    renderSlot(_ctx.$slots, "default")
  ], 10, _hoisted_1$4i);
}
var _Link = /* @__PURE__ */ _export_sfc(_sfc_main$5q, [["render", _sfc_render$5p]]);
const Link = Object.assign(_Link, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Link.name, _Link);
  }
});
const _sfc_main$5p = defineComponent({
  name: "PanelFooter",
  components: {
    Link,
    Button
  },
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    showTodayBtn: {
      type: Boolean
    },
    showConfirmBtn: {
      type: Boolean
    },
    confirmBtnDisabled: {
      type: Boolean
    }
  },
  emits: ["today-btn-click", "confirm-btn-click"],
  setup(_, { emit }) {
    const datePickerT = useDatePickerTransform$1();
    return {
      datePickerT,
      onTodayClick: () => {
        emit("today-btn-click");
      },
      onConfirmBtnClick: () => {
        emit("confirm-btn-click");
      }
    };
  }
});
function _sfc_render$5o(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Link = resolveComponent("Link");
  const _component_Button = resolveComponent("Button");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(`${_ctx.prefixCls}-footer`)
  }, [
    _ctx.$slots.extra ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-footer-extra-wrapper`)
    }, [
      renderSlot(_ctx.$slots, "extra")
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.showTodayBtn ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-footer-now-wrapper`)
    }, [
      createVNode(_component_Link, { onClick: _ctx.onTodayClick }, {
        default: withCtx(() => [
          createTextVNode(toDisplayString(_ctx.datePickerT("datePicker.today")), 1)
        ]),
        _: 1
      }, 8, ["onClick"])
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.$slots.btn || _ctx.showConfirmBtn ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(`${_ctx.prefixCls}-footer-btn-wrapper`)
    }, [
      renderSlot(_ctx.$slots, "btn"),
      _ctx.showConfirmBtn ? (openBlock(), createBlock(_component_Button, {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-btn-confirm`),
        type: "primary",
        size: "mini",
        disabled: _ctx.confirmBtnDisabled,
        onClick: _ctx.onConfirmBtnClick
      }, {
        default: withCtx(() => [
          createTextVNode(toDisplayString(_ctx.datePickerT("datePicker.ok")), 1)
        ]),
        _: 1
      }, 8, ["class", "disabled", "onClick"])) : createCommentVNode("v-if", true)
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var PanelFooter = /* @__PURE__ */ _export_sfc(_sfc_main$5p, [["render", _sfc_render$5o]]);
function usePanelSpan(props) {
  const { mode } = toRefs(props);
  const span = computed(
    () => ({ date: 1, week: 1, year: 10 * 12, quarter: 12, month: 12 })[mode.value]
  );
  const superSpan = computed(
    () => ["year"].includes(mode.value) ? 10 * 12 : 12
  );
  return {
    span,
    superSpan
  };
}
function useHeaderValue(props) {
  const { mode, value, defaultValue, selectedValue, format, onChange } = toRefs(props);
  const computedMode = computed(() => (mode == null ? void 0 : mode.value) || "date");
  const { span, superSpan } = usePanelSpan(
    reactive({
      mode: computedMode
    })
  );
  const isSame = (current, target2) => {
    const unit = computedMode.value === "date" || computedMode.value === "week" ? "M" : "y";
    return current.isSame(target2, unit);
  };
  const computedValue = computed(
    () => getDayjsValue(value == null ? void 0 : value.value, format.value)
  );
  const computedDefaultValue = computed(
    () => getDayjsValue(defaultValue == null ? void 0 : defaultValue.value, format.value)
  );
  const localValue = ref(computedDefaultValue.value || getNow());
  const headerValue = computed(() => computedValue.value || localValue.value);
  const setLocalValue = (newVal) => {
    if (!newVal)
      return;
    localValue.value = newVal;
  };
  const setHeaderValue = (newVal, emitChange = true) => {
    var _a;
    if (!newVal)
      return;
    if (emitChange && !isSame(headerValue.value, newVal)) {
      (_a = onChange == null ? void 0 : onChange.value) == null ? void 0 : _a.call(onChange, newVal);
    }
    setLocalValue(newVal);
  };
  if (selectedValue == null ? void 0 : selectedValue.value) {
    setLocalValue(selectedValue.value);
  }
  watch(
    () => selectedValue == null ? void 0 : selectedValue.value,
    (newVal) => {
      setHeaderValue(newVal);
    }
  );
  function getDefaultLocalValue() {
    return (selectedValue == null ? void 0 : selectedValue.value) || computedDefaultValue.value || getNow();
  }
  function resetHeaderValue(emitChange = true) {
    const defaultLocalValue = getDefaultLocalValue();
    if (emitChange) {
      setHeaderValue(defaultLocalValue);
    } else {
      setLocalValue(defaultLocalValue);
    }
  }
  const showSingleBtn = computed(() => span.value !== superSpan.value);
  const headerOperations = computed(() => ({
    onSuperPrev: () => {
      setHeaderValue(methods.subtract(headerValue.value, superSpan.value, "M"));
    },
    onPrev: showSingleBtn.value ? () => {
      setHeaderValue(methods.subtract(headerValue.value, span.value, "M"));
    } : void 0,
    onNext: showSingleBtn.value ? () => {
      setHeaderValue(methods.add(headerValue.value, span.value, "M"));
    } : void 0,
    onSuperNext: () => {
      setHeaderValue(methods.add(headerValue.value, superSpan.value, "M"));
    }
  }));
  return {
    headerValue,
    setHeaderValue,
    headerOperations,
    resetHeaderValue,
    getDefaultLocalValue
  };
}
const _sfc_main$5o = defineComponent({
  name: "DatePikerPanel",
  components: {
    DatePanel,
    PanelShortcuts,
    PanelFooter,
    WeekPanel,
    MonthPanel,
    YearPanel,
    QuarterPanel,
    RenderFunction
  },
  props: {
    mode: {
      type: String
    },
    headerMode: {
      type: String
    },
    prefixCls: {
      type: String,
      required: true
    },
    value: {
      type: Object
    },
    headerValue: {
      type: Object,
      required: true
    },
    timePickerValue: {
      type: Object
    },
    showTime: {
      type: Boolean
    },
    showConfirmBtn: {
      type: Boolean
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    shortcutsPosition: {
      type: String,
      default: "bottom"
    },
    format: {
      type: String,
      required: true
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    disabledDate: {
      type: Function
    },
    disabledTime: {
      type: Function
    },
    timePickerProps: {
      type: Object
    },
    extra: {
      type: Function
    },
    dateRender: {
      type: Function
    },
    hideTrigger: {
      type: Boolean
    },
    confirmBtnDisabled: {
      type: Boolean
    },
    showNowBtn: {
      type: Boolean
    },
    headerIcons: {
      type: Object,
      default: () => ({})
    },
    headerOperations: {
      type: Object
    },
    abbreviation: {
      type: Boolean
    }
  },
  emits: [
    "cell-click",
    "time-picker-select",
    "shortcut-click",
    "shortcut-mouse-enter",
    "shortcut-mouse-leave",
    "confirm",
    "today-btn-click",
    "header-label-click",
    "header-select",
    "month-header-click"
  ],
  setup(props, { emit }) {
    const {
      prefixCls,
      shortcuts,
      shortcutsPosition,
      format,
      value,
      disabledDate,
      hideTrigger,
      showNowBtn,
      dateRender,
      showConfirmBtn,
      headerValue,
      headerIcons,
      headerOperations,
      headerMode
    } = toRefs(props);
    const hasShortcuts = computed(
      () => Boolean(shortcuts.value && shortcuts.value.length)
    );
    const showShortcutsNowBtn = computed(
      () => showNowBtn.value && showConfirmBtn.value && !hasShortcuts.value
    );
    const showShortcuts = computed(
      () => showShortcutsNowBtn.value || hasShortcuts.value
    );
    const showShortcutsInLeft = computed(
      () => showShortcuts.value && shortcutsPosition.value === "left"
    );
    const showShortcutsInRight = computed(
      () => showShortcuts.value && shortcutsPosition.value === "right"
    );
    const showShortcutsInBottom = computed(
      () => showShortcuts.value && shortcutsPosition.value === "bottom"
    );
    const classNames = computed(() => [
      `${prefixCls.value}-container`,
      {
        [`${prefixCls.value}-container-panel-only`]: hideTrigger.value,
        [`${prefixCls.value}-container-shortcuts-placement-left`]: showShortcutsInLeft.value,
        [`${prefixCls.value}-container-shortcuts-placement-right`]: showShortcutsInRight.value
      }
    ]);
    const footerValue = computed(() => (value == null ? void 0 : value.value) || getNow());
    const {
      headerValue: headerPanelHeaderValue,
      setHeaderValue: setHeaderPanelHeaderValue,
      headerOperations: headerPanelHeaderOperations
    } = useHeaderValue(
      reactive({
        mode: headerMode,
        format
      })
    );
    watch(headerValue, (val) => {
      setHeaderPanelHeaderValue(val);
    });
    function getShortcutValue(shortcut) {
      const { value: value2 } = shortcut;
      return getDayjsValue(
        isFunction(value2) ? value2() : value2,
        shortcut.format || format.value
      );
    }
    function onShortcutClick(shortcut) {
      emit("shortcut-click", getShortcutValue(shortcut), shortcut);
    }
    function onShortcutMouseEnter(shortcut) {
      emit("shortcut-mouse-enter", getShortcutValue(shortcut));
    }
    function onShortcutMouseLeave(shortcut) {
      emit("shortcut-mouse-leave", getShortcutValue(shortcut));
    }
    function onPanelSelect(date) {
      emit("cell-click", date);
    }
    function onTimePickerSelect(time) {
      emit("time-picker-select", time);
    }
    function onTodayBtnClick() {
      emit("today-btn-click", getNow());
    }
    function onConfirmBtnClick() {
      emit("confirm");
    }
    function onPanelHeaderLabelClick(type) {
      emit("header-label-click", type);
    }
    function onHeaderPanelSelect(date) {
      emit("header-select", date);
    }
    function onMonthHeaderLabelClick() {
      emit("month-header-click");
    }
    const shortcutsProps = reactive({
      prefixCls,
      shortcuts,
      showNowBtn: showShortcutsNowBtn,
      onItemClick: onShortcutClick,
      onItemMouseEnter: onShortcutMouseEnter,
      onItemMouseLeave: onShortcutMouseLeave,
      onNowClick: onTodayBtnClick
    });
    const commonPanelProps = reactive({
      value,
      headerValue,
      headerIcons,
      headerOperations,
      disabledDate,
      dateRender,
      onSelect: onPanelSelect,
      onHeaderLabelClick: onPanelHeaderLabelClick
    });
    return {
      classNames,
      showShortcutsInLeft,
      showShortcutsInRight,
      showShortcutsInBottom,
      shortcutsProps,
      commonPanelProps,
      footerValue,
      onTodayBtnClick,
      onConfirmBtnClick,
      onTimePickerSelect,
      onHeaderPanelSelect,
      headerPanelHeaderValue,
      headerPanelHeaderOperations,
      onMonthHeaderLabelClick
    };
  }
});
function _sfc_render$5n(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PanelShortcuts = resolveComponent("PanelShortcuts");
  const _component_YearPanel = resolveComponent("YearPanel");
  const _component_MonthPanel = resolveComponent("MonthPanel");
  const _component_WeekPanel = resolveComponent("WeekPanel");
  const _component_QuarterPanel = resolveComponent("QuarterPanel");
  const _component_DatePanel = resolveComponent("DatePanel");
  const _component_RenderFunction = resolveComponent("RenderFunction");
  const _component_PanelFooter = resolveComponent("PanelFooter");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    _ctx.showShortcutsInLeft ? (openBlock(), createBlock(_component_PanelShortcuts, normalizeProps(mergeProps({ key: 0 }, _ctx.shortcutsProps)), null, 16)) : createCommentVNode("v-if", true),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-panel-wrapper`)
    }, [
      _ctx.headerMode ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        _ctx.headerMode === "year" ? (openBlock(), createBlock(_component_YearPanel, {
          key: 0,
          "header-value": _ctx.headerPanelHeaderValue,
          "header-icons": _ctx.headerIcons,
          "header-operations": _ctx.headerPanelHeaderOperations,
          onSelect: _ctx.onHeaderPanelSelect
        }, null, 8, ["header-value", "header-icons", "header-operations", "onSelect"])) : _ctx.headerMode === "month" ? (openBlock(), createBlock(_component_MonthPanel, {
          key: 1,
          "header-value": _ctx.headerPanelHeaderValue,
          "header-icons": _ctx.headerIcons,
          "header-operations": _ctx.headerPanelHeaderOperations,
          abbreviation: _ctx.abbreviation,
          onSelect: _ctx.onHeaderPanelSelect,
          onHeaderLabelClick: _ctx.onMonthHeaderLabelClick
        }, null, 8, ["header-value", "header-icons", "header-operations", "abbreviation", "onSelect", "onHeaderLabelClick"])) : createCommentVNode("v-if", true)
      ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
        _ctx.mode === "week" ? (openBlock(), createBlock(_component_WeekPanel, mergeProps({ key: 0 }, _ctx.commonPanelProps, { "day-start-of-week": _ctx.dayStartOfWeek }), null, 16, ["day-start-of-week"])) : _ctx.mode === "month" ? (openBlock(), createBlock(_component_MonthPanel, mergeProps({
          key: 1,
          abbreviation: _ctx.abbreviation
        }, _ctx.commonPanelProps), null, 16, ["abbreviation"])) : _ctx.mode === "year" ? (openBlock(), createBlock(_component_YearPanel, normalizeProps(mergeProps({ key: 2 }, _ctx.commonPanelProps)), null, 16)) : _ctx.mode === "quarter" ? (openBlock(), createBlock(_component_QuarterPanel, normalizeProps(mergeProps({ key: 3 }, _ctx.commonPanelProps)), null, 16)) : (openBlock(), createBlock(_component_DatePanel, mergeProps({ key: 4 }, _ctx.commonPanelProps, {
          mode: "date",
          "show-time": _ctx.showTime,
          "time-picker-props": _ctx.timePickerProps,
          "day-start-of-week": _ctx.dayStartOfWeek,
          "footer-value": _ctx.footerValue,
          "time-picker-value": _ctx.timePickerValue,
          "disabled-time": _ctx.disabledTime,
          onTimePickerSelect: _ctx.onTimePickerSelect
        }), null, 16, ["show-time", "time-picker-props", "day-start-of-week", "footer-value", "time-picker-value", "disabled-time", "onTimePickerSelect"])),
        createVNode(_component_PanelFooter, {
          "prefix-cls": _ctx.prefixCls,
          "show-today-btn": _ctx.showNowBtn && !(_ctx.showConfirmBtn || _ctx.showShortcutsInBottom),
          "show-confirm-btn": _ctx.showConfirmBtn,
          "confirm-btn-disabled": _ctx.confirmBtnDisabled,
          onTodayBtnClick: _ctx.onTodayBtnClick,
          onConfirmBtnClick: _ctx.onConfirmBtnClick
        }, createSlots({ _: 2 }, [
          _ctx.extra ? {
            name: "extra",
            fn: withCtx(() => [
              _ctx.extra ? (openBlock(), createBlock(_component_RenderFunction, {
                key: 0,
                "render-func": _ctx.extra
              }, null, 8, ["render-func"])) : createCommentVNode("v-if", true)
            ]),
            key: "0"
          } : void 0,
          _ctx.showShortcutsInBottom ? {
            name: "btn",
            fn: withCtx(() => [
              createVNode(_component_PanelShortcuts, normalizeProps(guardReactiveProps(_ctx.shortcutsProps)), null, 16)
            ]),
            key: "1"
          } : void 0
        ]), 1032, ["prefix-cls", "show-today-btn", "show-confirm-btn", "confirm-btn-disabled", "onTodayBtnClick", "onConfirmBtnClick"])
      ], 64))
    ], 2),
    _ctx.showShortcutsInRight ? (openBlock(), createBlock(_component_PanelShortcuts, normalizeProps(mergeProps({ key: 1 }, _ctx.shortcutsProps)), null, 16)) : createCommentVNode("v-if", true)
  ], 2);
}
var PickerPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5o, [["render", _sfc_render$5n]]);
function getDefaultFormat(mode = "date", showTime = false) {
  switch (mode) {
    case "date":
      return showTime ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD";
    case "month":
      return "YYYY-MM";
    case "year":
      return "YYYY";
    case "week":
      return "gggg-wo";
    case "quarter":
      return "YYYY-[Q]Q";
    default:
      return "YYYY-MM-DD";
  }
}
function getDefaultValueFormat(mode = "date", showTime = false) {
  switch (mode) {
    case "date":
      return showTime ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD";
    case "month":
      return "YYYY-MM";
    case "year":
      return "YYYY";
    case "week":
      return "YYYY-MM-DD";
    case "quarter":
      return "YYYY-MM";
    default:
      return "YYYY-MM-DD";
  }
}
function useFormat(props) {
  const {
    format: propFormat,
    mode,
    showTime,
    valueFormat: propValueFormat
  } = toRefs(props);
  const format = computed(
    () => !isFunction(propFormat == null ? void 0 : propFormat.value) && (propFormat == null ? void 0 : propFormat.value) || getDefaultFormat(mode == null ? void 0 : mode.value, showTime == null ? void 0 : showTime.value)
  );
  const valueFormat = computed(
    () => (propValueFormat == null ? void 0 : propValueFormat.value) || getDefaultValueFormat(mode == null ? void 0 : mode.value, showTime == null ? void 0 : showTime.value)
  );
  const parseValueFormat = computed(
    () => ["timestamp", "Date"].includes(valueFormat.value) ? format.value : valueFormat.value
  );
  return {
    format,
    valueFormat,
    parseValueFormat
  };
}
function useIsDisabledDate(props) {
  const { mode, showTime, disabledDate, disabledTime, isRange } = toRefs(props);
  const needCheckTime = computed(
    () => (mode == null ? void 0 : mode.value) === "date" && (showTime == null ? void 0 : showTime.value)
  );
  const isDisabledDate = computed(() => {
    return (current, type) => {
      if (!(disabledDate == null ? void 0 : disabledDate.value))
        return false;
      const dateValue = getDateValue$1(current);
      if (isRange == null ? void 0 : isRange.value)
        return disabledDate.value(dateValue, type);
      return disabledDate.value(dateValue);
    };
  });
  const isDisabledItem = (num, getDisabledList) => {
    const list = (getDisabledList == null ? void 0 : getDisabledList()) || [];
    return list.includes(num);
  };
  const isDisabledTime2 = computed(() => {
    return (current, type) => {
      if (!needCheckTime.value)
        return false;
      if (!(disabledTime == null ? void 0 : disabledTime.value))
        return false;
      const dateValue = getDateValue$1(current);
      const disabledTimeProps = (isRange == null ? void 0 : isRange.value) ? disabledTime.value(dateValue, type) : disabledTime.value(dateValue);
      return isDisabledItem(current.hour(), disabledTimeProps.disabledHours) || isDisabledItem(current.minute(), disabledTimeProps.disabledMinutes) || isDisabledItem(current.second(), disabledTimeProps.disabledSeconds);
    };
  });
  return function isDisabled(value, type) {
    return value && (isDisabledDate.value(value, type || "start") || isDisabledTime2.value(value, type || "start"));
  };
}
const getValueByPath = (obj, path) => {
  if (!obj || !path) {
    return void 0;
  }
  path = path.replace(/\[(\w+)\]/g, ".$1");
  const keys = path.split(".");
  if (keys.length === 0) {
    return void 0;
  }
  let temp = obj;
  for (let i2 = 0; i2 < keys.length; i2++) {
    if (!isObject(temp) && !isArray(temp) || !keys[i2]) {
      return void 0;
    }
    if (i2 !== keys.length - 1) {
      temp = temp[keys[i2]];
    } else {
      return temp[keys[i2]];
    }
  }
  return void 0;
};
const setValueByPath = (obj, path, value, { addPath } = {}) => {
  if (!obj || !path) {
    return;
  }
  path = path.replace(/\[(\w+)\]/g, ".$1");
  const keys = path.split(".");
  if (keys.length === 0) {
    return;
  }
  let temp = obj;
  for (let i2 = 0; i2 < keys.length; i2++) {
    if (!isObject(temp) && !isArray(temp) || !keys[i2]) {
      return;
    }
    if (i2 !== keys.length - 1) {
      if (addPath && isUndefined(temp[keys[i2]])) {
        temp[keys[i2]] = {};
      }
      temp = temp[keys[i2]];
    } else {
      temp[keys[i2]] = value;
    }
  }
};
function useDatePickerTransform(props) {
  const { locale } = toRefs(props);
  const { locale: i18nLocale, t } = useI18n();
  dayjs.locale(i18nLocale.value.toLowerCase());
  const datePickerT = (key, ...args) => {
    const keyForLocale = key.startsWith("datePicker.") ? key.split(".").slice(1).join(".") : key;
    return getValueByPath((locale == null ? void 0 : locale.value) || {}, keyForLocale) || t(key, ...args);
  };
  provide(PickerInjectionKey, {
    datePickerT
  });
  return datePickerT;
}
function useTimePickerValue(props) {
  const { timePickerProps, selectedValue } = toRefs(props);
  const timePickerPropsFormat = computed(() => {
    var _a;
    return (_a = timePickerProps == null ? void 0 : timePickerProps.value) == null ? void 0 : _a.format;
  });
  const timePickerPropsUse12Hours = computed(
    () => {
      var _a;
      return !!((_a = timePickerProps == null ? void 0 : timePickerProps.value) == null ? void 0 : _a.use12Hours);
    }
  );
  const { format } = useTimeFormat(
    reactive({
      format: timePickerPropsFormat,
      use12Hours: timePickerPropsUse12Hours
    })
  );
  const defaultTimePickerValue = computed(
    () => {
      var _a;
      return getDayjsValue(
        (_a = timePickerProps == null ? void 0 : timePickerProps.value) == null ? void 0 : _a.defaultValue,
        format.value
      );
    }
  );
  const getDefaultValue = () => (selectedValue == null ? void 0 : selectedValue.value) || defaultTimePickerValue.value || getNow();
  const timePickerValue = ref(getDefaultValue());
  function setTimePickerValue(val) {
    if (val) {
      timePickerValue.value = val;
    }
  }
  function resetTimePickerValue() {
    timePickerValue.value = getDefaultValue();
  }
  watch(selectedValue, (newVal) => {
    setTimePickerValue(newVal);
  });
  return [timePickerValue, setTimePickerValue, resetTimePickerValue];
}
function getReturnValue(date, format) {
  if (format === "timestamp") {
    return date.toDate().getTime();
  }
  if (format === "Date") {
    return date.toDate();
  }
  return date.format(format);
}
function useReturnValue(props) {
  const { format } = toRefs(props);
  return (date) => getReturnValue(date, format.value);
}
function getReturnRangeValue(dates, format) {
  return dates.map((date) => date ? getReturnValue(date, format) : void 0);
}
const _sfc_main$5n = defineComponent({
  name: "Picker",
  components: {
    DateInput,
    Trigger,
    PickerPanel,
    IconCalendar
  },
  inheritAttrs: false,
  props: {
    locale: {
      type: Object
    },
    hideTrigger: {
      type: Boolean
    },
    allowClear: {
      type: Boolean,
      default: true
    },
    readonly: {
      type: Boolean
    },
    error: {
      type: Boolean
    },
    size: {
      type: String
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    shortcutsPosition: {
      type: String,
      default: "bottom"
    },
    position: {
      type: String,
      default: "bl"
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    triggerProps: {
      type: Object
    },
    unmountOnClose: {
      type: Boolean
    },
    placeholder: {
      type: String
    },
    disabled: {
      type: Boolean
    },
    disabledDate: {
      type: Function
    },
    disabledTime: {
      type: Function
    },
    pickerValue: {
      type: [Object, String, Number]
    },
    defaultPickerValue: {
      type: [Object, String, Number]
    },
    popupContainer: {
      type: [String, Object]
    },
    mode: {
      type: String,
      default: "date"
    },
    format: {
      type: [String, Function]
    },
    valueFormat: {
      type: String
    },
    previewShortcut: {
      type: Boolean,
      default: true
    },
    showConfirmBtn: {
      type: Boolean
    },
    showTime: {
      type: Boolean
    },
    timePickerProps: {
      type: Object
    },
    showNowBtn: {
      type: Boolean,
      default: true
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    modelValue: {
      type: [Object, String, Number]
    },
    defaultValue: {
      type: [Object, String, Number]
    },
    disabledInput: {
      type: Boolean,
      default: false
    },
    abbreviation: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "change": (value, date, dateString) => true,
    "update:modelValue": (value) => true,
    "select": (value, date, dateString) => true,
    "popup-visible-change": (visible) => true,
    "update:popupVisible": (visible) => true,
    "ok": (value, date, dateString) => true,
    "clear": () => true,
    "select-shortcut": (shortcut) => true,
    "picker-value-change": (value, date, dateString) => true,
    "update:pickerValue": (value) => true
  },
  setup(props, { emit, slots }) {
    const {
      mode,
      modelValue,
      defaultValue,
      format,
      valueFormat,
      placeholder,
      popupVisible,
      defaultPopupVisible,
      disabled,
      showTime,
      timePickerProps,
      disabledDate,
      disabledTime,
      readonly: readonly2,
      locale,
      pickerValue,
      defaultPickerValue,
      dayStartOfWeek,
      previewShortcut,
      showConfirmBtn
    } = toRefs(props);
    const { locale: globalLocal } = useI18n();
    watchEffect(() => {
      initializeDateLocale(globalLocal.value, dayStartOfWeek.value);
    });
    const { mergedDisabled, eventHandlers } = useFormItem({ disabled });
    const datePickerT = useDatePickerTransform(
      reactive({
        locale
      })
    );
    const prefixCls = getPrefixCls("picker");
    const refInput = ref();
    const computedPlaceholder = computed(
      () => (placeholder == null ? void 0 : placeholder.value) || {
        date: datePickerT("datePicker.placeholder.date"),
        month: datePickerT("datePicker.placeholder.month"),
        year: datePickerT("datePicker.placeholder.year"),
        week: datePickerT("datePicker.placeholder.week"),
        quarter: datePickerT("datePicker.placeholder.quarter")
      }[mode.value] || datePickerT("datePicker.placeholder.date")
    );
    const {
      format: computedFormat,
      valueFormat: returnValueFormat,
      parseValueFormat
    } = useFormat(reactive({ format, mode, showTime, valueFormat }));
    const inputFormat = computed(
      () => format && isFunction(format.value) ? (value) => {
        var _a;
        return (_a = format.value) == null ? void 0 : _a.call(format, getDateValue$1(value));
      } : computedFormat.value
    );
    const getReturnValue2 = useReturnValue(
      reactive({
        format: returnValueFormat
      })
    );
    const isDisabledDate = useIsDisabledDate(
      reactive({
        mode,
        disabledDate,
        disabledTime,
        showTime
      })
    );
    const needConfirm = computed(() => showTime.value || showConfirmBtn.value);
    const confirmBtnDisabled = computed(
      () => needConfirm.value && (!forSelectedValue.value || isDisabledDate(forSelectedValue.value))
    );
    const isDateTime = computed(() => mode.value === "date" && showTime.value);
    const { value: selectedValue, setValue: setSelectedValue } = usePickerState(
      reactive({
        modelValue,
        defaultValue,
        format: parseValueFormat
      })
    );
    const [processValue, setProcessValue] = useState();
    const [previewValue, setPreviewValue] = useState();
    const forSelectedValue = computed(
      () => {
        var _a;
        return (_a = processValue.value) != null ? _a : selectedValue.value;
      }
    );
    const panelValue = computed(
      () => {
        var _a, _b;
        return (_b = (_a = previewValue.value) != null ? _a : processValue.value) != null ? _b : selectedValue.value;
      }
    );
    const [inputValue, setInputValue] = useState();
    const [panelVisible, setLocalPanelVisible] = useMergeState(
      defaultPopupVisible.value,
      reactive({ value: popupVisible })
    );
    const setPanelVisible = (newVisible) => {
      if (panelVisible.value !== newVisible) {
        setLocalPanelVisible(newVisible);
        emit("popup-visible-change", newVisible);
        emit("update:popupVisible", newVisible);
      }
    };
    const { headerValue, setHeaderValue, headerOperations, resetHeaderValue } = useHeaderValue(
      reactive({
        mode,
        value: pickerValue,
        defaultValue: defaultPickerValue,
        selectedValue: panelValue,
        format: parseValueFormat,
        onChange: (newVal) => {
          const returnValue = getReturnValue2(newVal);
          const formattedValue = getFormattedValue(
            newVal,
            parseValueFormat.value
          );
          const dateValue = getDateValue$1(newVal);
          emit("picker-value-change", returnValue, dateValue, formattedValue);
          emit("update:pickerValue", returnValue);
        }
      })
    );
    const [timePickerValue, , resetTimePickerValue] = useTimePickerValue(
      reactive({
        timePickerProps,
        selectedValue: panelValue
      })
    );
    const inputEditable = computed(
      () => !readonly2.value && !isFunction(inputFormat.value)
    );
    const headerMode = ref();
    watch(panelVisible, (newVisible) => {
      setProcessValue(void 0);
      setPreviewValue(void 0);
      headerMode.value = void 0;
      if (newVisible) {
        resetHeaderValue();
        resetTimePickerValue();
      }
      if (!newVisible) {
        setInputValue(void 0);
      }
    });
    function emitChange(value, emitOk) {
      var _a, _b;
      const returnValue = value ? getReturnValue2(value) : void 0;
      const formattedValue = getFormattedValue(value, parseValueFormat.value);
      const dateValue = getDateValue$1(value);
      if (isValueChange(value, selectedValue.value)) {
        emit("update:modelValue", returnValue);
        emit("change", returnValue, dateValue, formattedValue);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
      }
      if (emitOk) {
        emit("ok", returnValue, dateValue, formattedValue);
      }
    }
    function confirm(value, showPanel, emitOk) {
      if (isDisabledDate(value)) {
        return;
      }
      emitChange(value, emitOk);
      setSelectedValue(value);
      setProcessValue(void 0);
      setPreviewValue(void 0);
      setInputValue(void 0);
      headerMode.value = void 0;
      if (isBoolean(showPanel)) {
        setPanelVisible(showPanel);
      }
    }
    function select(value, emitSelect) {
      setProcessValue(value);
      setPreviewValue(void 0);
      setInputValue(void 0);
      headerMode.value = void 0;
      if (emitSelect) {
        const returnValue = value ? getReturnValue2(value) : void 0;
        const formattedValue = getFormattedValue(value, parseValueFormat.value);
        const dateValue = getDateValue$1(value);
        emit("select", returnValue, dateValue, formattedValue);
      }
    }
    function focusInput(index2) {
      refInput.value && refInput.value.focus && refInput.value.focus(index2);
    }
    function getMergedOpValue(date, time) {
      if (!isDateTime.value && !timePickerProps.value)
        return date;
      return mergeValueWithTime(getNow(), date, time);
    }
    function onPanelVisibleChange(visible) {
      if (mergedDisabled.value)
        return;
      setPanelVisible(visible);
    }
    function onInputClear(e) {
      e.stopPropagation();
      confirm(void 0);
      emit("clear");
    }
    function onInputBlur() {
      var _a, _b;
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a);
    }
    function onInputChange(e) {
      setPanelVisible(true);
      const targetValue = e.target.value;
      setInputValue(targetValue);
      if (!isValidInputValue(targetValue, computedFormat.value))
        return;
      const newValue = dayjs(targetValue, computedFormat.value);
      if (isDisabledDate(newValue))
        return;
      if (needConfirm.value) {
        select(newValue);
      } else {
        confirm(newValue, true);
      }
    }
    function onInputPressEnter() {
      confirm(panelValue.value, false);
    }
    function onPanelSelect(value) {
      if (needConfirm.value) {
        select(value, true);
      } else {
        confirm(value, false);
      }
    }
    function onPanelCellClick(value) {
      const newValue = getMergedOpValue(value, timePickerValue.value);
      onPanelSelect(newValue);
    }
    function onTimePickerSelect(time) {
      const newValue = getMergedOpValue(panelValue.value || getNow(), time);
      onPanelSelect(newValue);
    }
    function onPanelConfirm() {
      confirm(panelValue.value, false, true);
    }
    function onPanelClick() {
      if (props.disabledInput) {
        focusInput();
      }
    }
    let clearPreviewTimer;
    onUnmounted(() => {
      clearTimeout(clearPreviewTimer);
    });
    function onPanelShortcutMouseEnter(value) {
      clearTimeout(clearPreviewTimer);
      setPreviewValue(value);
      setInputValue(void 0);
    }
    function onPanelShortcutMouseLeave() {
      clearTimeout(clearPreviewTimer);
      clearPreviewTimer = setTimeout(() => {
        setPreviewValue(void 0);
      }, 100);
    }
    function onPanelShortcutClick(value, shortcut) {
      emit("select-shortcut", shortcut);
      confirm(value, false);
    }
    function onPanelHeaderLabelClick(type) {
      headerMode.value = type;
    }
    function onMonthHeaderClick() {
      headerMode.value = "year";
    }
    function onPanelHeaderSelect(date) {
      let newValue = headerValue.value;
      newValue = newValue.set("year", date.year());
      if (headerMode.value === "month") {
        newValue = newValue.set("month", date.month());
      }
      setHeaderValue(newValue);
      if (mode.value === "quarter" || mode.value === "month") {
        headerMode.value = void 0;
        return;
      }
      headerMode.value = headerMode.value === "year" ? "month" : void 0;
    }
    const computedTimePickerProps = computed(() => ({
      format: computedFormat.value,
      ...omit((timePickerProps == null ? void 0 : timePickerProps.value) || {}, ["defaultValue"]),
      visible: panelVisible.value
    }));
    const panelProps = computed(() => ({
      ...pick(props, [
        "mode",
        "shortcuts",
        "shortcutsPosition",
        "dayStartOfWeek",
        "disabledDate",
        "disabledTime",
        "showTime",
        "hideTrigger",
        "abbreviation"
      ]),
      showNowBtn: props.showNowBtn && mode.value === "date",
      prefixCls,
      format: parseValueFormat.value,
      value: panelValue.value,
      visible: panelVisible.value,
      showConfirmBtn: needConfirm.value,
      confirmBtnDisabled: confirmBtnDisabled.value,
      timePickerProps: computedTimePickerProps.value,
      extra: slots.extra,
      dateRender: slots.cell,
      headerValue: headerValue.value,
      headerIcons: {
        prev: slots["icon-prev"],
        prevDouble: slots["icon-prev-double"],
        next: slots["icon-next"],
        nextDouble: slots["icon-next-double"]
      },
      headerOperations: headerOperations.value,
      timePickerValue: timePickerValue.value,
      headerMode: headerMode.value,
      onCellClick: onPanelCellClick,
      onTimePickerSelect,
      onConfirm: onPanelConfirm,
      onShortcutClick: onPanelShortcutClick,
      onShortcutMouseEnter: previewShortcut.value ? onPanelShortcutMouseEnter : void 0,
      onShortcutMouseLeave: previewShortcut.value ? onPanelShortcutMouseLeave : void 0,
      onTodayBtnClick: onPanelSelect,
      onHeaderLabelClick: onPanelHeaderLabelClick,
      onHeaderSelect: onPanelHeaderSelect,
      onMonthHeaderClick
    }));
    return {
      prefixCls,
      refInput,
      panelProps,
      panelValue,
      inputValue,
      selectedValue,
      inputFormat,
      computedPlaceholder,
      panelVisible,
      inputEditable,
      needConfirm,
      mergedDisabled,
      onPanelVisibleChange,
      onInputClear,
      onInputChange,
      onInputPressEnter,
      onInputBlur,
      onPanelClick
    };
  }
});
function _sfc_render$5m(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconCalendar = resolveComponent("IconCalendar");
  const _component_DateInput = resolveComponent("DateInput");
  const _component_PickerPanel = resolveComponent("PickerPanel");
  const _component_Trigger = resolveComponent("Trigger");
  return !_ctx.hideTrigger ? (openBlock(), createBlock(_component_Trigger, mergeProps({
    key: 0,
    trigger: "click",
    "animation-name": "slide-dynamic-origin",
    "auto-fit-transform-origin": "",
    "click-to-close": false,
    "popup-offset": 4
  }, _ctx.triggerProps, {
    position: _ctx.position,
    disabled: _ctx.mergedDisabled || _ctx.readonly,
    "prevent-focus": true,
    "popup-visible": _ctx.panelVisible,
    "unmount-on-close": _ctx.unmountOnClose,
    "popup-container": _ctx.popupContainer,
    onPopupVisibleChange: _ctx.onPanelVisibleChange
  }), {
    content: withCtx(() => [
      createVNode(_component_PickerPanel, mergeProps(_ctx.panelProps, { onClick: _ctx.onPanelClick }), null, 16, ["onClick"])
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default", {}, () => [
        createVNode(_component_DateInput, mergeProps(_ctx.$attrs, {
          ref: "refInput",
          size: _ctx.size,
          focused: _ctx.panelVisible,
          visible: _ctx.panelVisible,
          error: _ctx.error,
          disabled: _ctx.mergedDisabled,
          readonly: !_ctx.inputEditable || _ctx.disabledInput,
          "allow-clear": _ctx.allowClear && !_ctx.readonly,
          placeholder: _ctx.computedPlaceholder,
          "input-value": _ctx.inputValue,
          value: _ctx.needConfirm ? _ctx.panelValue : _ctx.selectedValue,
          format: _ctx.inputFormat,
          onClear: _ctx.onInputClear,
          onChange: _ctx.onInputChange,
          onPressEnter: _ctx.onInputPressEnter,
          onBlur: _ctx.onInputBlur
        }), createSlots({
          "suffix-icon": withCtx(() => [
            renderSlot(_ctx.$slots, "suffix-icon", {}, () => [
              createVNode(_component_IconCalendar)
            ])
          ]),
          _: 2
        }, [
          _ctx.$slots.prefix ? {
            name: "prefix",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "prefix")
            ]),
            key: "0"
          } : void 0
        ]), 1040, ["size", "focused", "visible", "error", "disabled", "readonly", "allow-clear", "placeholder", "input-value", "value", "format", "onClear", "onChange", "onPressEnter", "onBlur"])
      ])
    ]),
    _: 3
  }, 16, ["position", "disabled", "popup-visible", "unmount-on-close", "popup-container", "onPopupVisibleChange"])) : (openBlock(), createBlock(_component_PickerPanel, normalizeProps(mergeProps({ key: 1 }, { ..._ctx.$attrs, ..._ctx.panelProps })), null, 16));
}
var Picker = /* @__PURE__ */ _export_sfc(_sfc_main$5n, [["render", _sfc_render$5m]]);
var _DatePicker = defineComponent({
  name: "DatePicker",
  props: {
    modelValue: {
      type: [Object, String, Number]
    },
    defaultValue: {
      type: [Object, String, Number]
    },
    format: {
      type: [String, Function]
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    showTime: {
      type: Boolean
    },
    timePickerProps: {
      type: Object
    },
    disabled: {
      type: Boolean
    },
    disabledDate: {
      type: Function
    },
    disabledTime: {
      type: Function
    },
    showNowBtn: {
      type: Boolean,
      default: true
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    return () => createVNode(Picker, mergeProps(props, attrs, {
      "mode": "date"
    }), slots);
  }
});
var WeekPicker = defineComponent({
  name: "WeekPicker",
  props: {
    modelValue: {
      type: [Object, String, Number]
    },
    defaultValue: {
      type: [Object, String, Number]
    },
    format: {
      type: String,
      default: "gggg-wo"
    },
    valueFormat: {
      type: String,
      default: "YYYY-MM-DD"
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    return () => createVNode(Picker, mergeProps(props, attrs, {
      "mode": "week"
    }), slots);
  }
});
var MonthPicker = defineComponent({
  name: "MonthPicker",
  props: {
    modelValue: {
      type: [Object, String, Number]
    },
    defaultValue: {
      type: [Object, String, Number]
    },
    format: {
      type: String,
      default: "YYYY-MM"
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    return () => createVNode(Picker, mergeProps(props, attrs, {
      "mode": "month"
    }), slots);
  }
});
var YearPicker = defineComponent({
  name: "YearPicker",
  props: {
    modelValue: {
      type: [Object, String, Number]
    },
    defaultValue: {
      type: [Object, String, Number]
    },
    format: {
      type: String,
      default: "YYYY"
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    return () => createVNode(Picker, mergeProps(props, attrs, {
      "mode": "year"
    }), slots);
  }
});
var QuarterPicker = defineComponent({
  name: "QuarterPicker",
  props: {
    modelValue: {
      type: [Object, String, Number]
    },
    defaultValue: {
      type: [Object, String, Number]
    },
    format: {
      type: String,
      default: "YYYY-[Q]Q"
    },
    valueFormat: {
      type: String,
      default: "YYYY-MM"
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    return () => createVNode(Picker, mergeProps(props, attrs, {
      "mode": "quarter"
    }), slots);
  }
});
function useRangePickerState(props) {
  const { modelValue, defaultValue, format } = toRefs(props);
  const computedModelValue = computed(() => {
    return getDayjsValue(normalizeRangeValue(modelValue.value), format.value);
  });
  const computedDefaultValue = computed(() => {
    return getDayjsValue(normalizeRangeValue(defaultValue.value), format.value);
  });
  const [localValue, setLocalValue] = useState(
    !isUndefined(computedModelValue.value) ? computedModelValue.value : !isUndefined(computedDefaultValue.value) ? computedDefaultValue.value : []
  );
  watch(computedModelValue, () => {
    if (isUndefined(computedModelValue.value)) {
      setLocalValue([]);
    }
  });
  const mergeValue = computed(
    () => computedModelValue.value || localValue.value
  );
  return {
    value: mergeValue,
    setValue: setLocalValue
  };
}
function useRangeHeaderValue(props) {
  const {
    startHeaderMode,
    endHeaderMode,
    mode,
    value,
    defaultValue,
    selectedValue,
    format,
    onChange
  } = toRefs(props);
  const isDateOrWeek = computed(() => ["date", "week"].includes(mode.value));
  const unit = computed(() => isDateOrWeek.value ? "M" : "y");
  const isSame = (current, target2) => current.isSame(target2, unit.value);
  const { span, superSpan } = usePanelSpan(
    reactive({
      mode
    })
  );
  const startMode = computed(() => (startHeaderMode == null ? void 0 : startHeaderMode.value) || mode.value);
  const endMode = computed(() => (endHeaderMode == null ? void 0 : endHeaderMode.value) || mode.value);
  const startValue = computed(() => {
    var _a;
    return (_a = value.value) == null ? void 0 : _a[0];
  });
  const endValue = computed(() => {
    var _a;
    return (_a = value.value) == null ? void 0 : _a[1];
  });
  const startDefaultValue = computed(() => {
    var _a;
    return (_a = defaultValue.value) == null ? void 0 : _a[0];
  });
  const endDefaultValue = computed(() => {
    var _a;
    return (_a = defaultValue.value) == null ? void 0 : _a[1];
  });
  const emitChange = (newVal) => {
    (onChange == null ? void 0 : onChange.value) && onChange.value(newVal);
  };
  const {
    headerValue: startHeaderValue,
    setHeaderValue: setStartHeaderValue,
    headerOperations: startHeaderOperations,
    getDefaultLocalValue: getDefaultStartHeaderValue
  } = useHeaderValue(
    reactive({
      mode: startMode,
      value: startValue,
      defaultValue: startDefaultValue,
      selectedValue: void 0,
      format,
      onChange: (newVal) => {
        emitChange([newVal, endHeaderValue.value]);
      }
    })
  );
  const {
    headerValue: endHeaderValue,
    setHeaderValue: setEndHeaderValue,
    headerOperations: endHeaderOperations,
    getDefaultLocalValue: getDefaultEndHeaderValue
  } = useHeaderValue(
    reactive({
      mode: endMode,
      value: endValue,
      defaultValue: endDefaultValue,
      selectedValue: void 0,
      format,
      onChange: (newVal) => {
        emitChange([startHeaderValue.value, newVal]);
      }
    })
  );
  const setHeaderValue = (newVal) => {
    const isSameStartValue = isSame(startHeaderValue.value, newVal[0]);
    const isSameEndValue = isSame(endHeaderValue.value, newVal[1]);
    setStartHeaderValue(newVal[0], false);
    setEndHeaderValue(newVal[1], false);
    if (!isSameStartValue || !isSameEndValue) {
      (onChange == null ? void 0 : onChange.value) && (onChange == null ? void 0 : onChange.value(newVal));
    }
  };
  function getFixedValue(values) {
    let [header02, header12] = getSortedDayjsArray(values);
    const nextHeader = methods.add(header02, span.value, "M");
    if (header12.isBefore(nextHeader, unit.value)) {
      header12 = nextHeader;
    }
    return [header02, header12];
  }
  function getFormSelectedValue() {
    var _a, _b;
    let selected02 = (_a = selectedValue.value) == null ? void 0 : _a[0];
    let selected12 = (_b = selectedValue.value) == null ? void 0 : _b[1];
    if (selected02 && selected12) {
      [selected02, selected12] = getSortedDayjsArray([selected02, selected12]);
    }
    return [selected02, selected12];
  }
  const [selected0, selected1] = getFormSelectedValue();
  const [header0, header1] = getFixedValue([
    selected0 || startHeaderValue.value,
    selected1 || endHeaderValue.value
  ]);
  setStartHeaderValue(header0, false);
  setEndHeaderValue(header1, false);
  const resetHeaderValue = () => {
    const defaultStartHeaderValue = getDefaultStartHeaderValue();
    const defaultEndHeaderValue = getDefaultEndHeaderValue();
    nextTick(() => {
      const [selected02, selected12] = getFormSelectedValue();
      const [header02, header12] = getFixedValue([
        selected02 || defaultStartHeaderValue,
        selected12 || defaultEndHeaderValue
      ]);
      setHeaderValue([header02, header12]);
    });
  };
  const canShortenMonth = computed(
    () => methods.add(startHeaderValue.value, span.value, "M").isBefore(endHeaderValue.value, unit.value)
  );
  const canShortenYear = computed(
    () => methods.add(startHeaderValue.value, superSpan.value, "M").isBefore(endHeaderValue.value, unit.value)
  );
  const computedStartHeaderOperations = computed(() => {
    const operations = ["onSuperPrev"];
    if (isDateOrWeek.value)
      operations.push("onPrev");
    if (canShortenMonth.value && isDateOrWeek)
      operations.push("onNext");
    if (canShortenYear.value)
      operations.push("onSuperNext");
    return pick(startHeaderOperations.value, operations);
  });
  const computedEndHeaderOperations = computed(() => {
    const operations = ["onSuperNext"];
    if (isDateOrWeek.value)
      operations.push("onNext");
    if (canShortenMonth.value && isDateOrWeek.value)
      operations.push("onPrev");
    if (canShortenYear.value)
      operations.push("onSuperPrev");
    return pick(endHeaderOperations.value, operations);
  });
  return {
    startHeaderValue,
    endHeaderValue,
    startHeaderOperations: computedStartHeaderOperations,
    endHeaderOperations: computedEndHeaderOperations,
    setHeaderValue,
    resetHeaderValue
  };
}
const _sfc_main$5m = defineComponent({
  name: "DateInputRange",
  components: {
    IconHover,
    IconClose,
    FeedbackIcon
  },
  props: {
    size: {
      type: String
    },
    focused: {
      type: Boolean
    },
    focusedIndex: {
      type: Number
    },
    error: {
      type: Boolean
    },
    disabled: {
      type: [Boolean, Array],
      default: false
    },
    readonly: {
      type: Boolean
    },
    allowClear: {
      type: Boolean
    },
    placeholder: {
      type: Array,
      default: () => []
    },
    inputValue: {
      type: Array
    },
    value: {
      type: Array,
      default: () => []
    },
    format: {
      type: [String, Function],
      required: true
    }
  },
  emits: [
    "focused-index-change",
    "update:focusedIndex",
    "change",
    "clear",
    "press-enter"
  ],
  setup(props, { emit, slots }) {
    const {
      error,
      focused,
      disabled,
      size,
      value,
      format,
      focusedIndex,
      inputValue
    } = toRefs(props);
    const {
      mergedSize: _mergedSize,
      mergedDisabled,
      mergedError,
      feedback
    } = useFormItem({ size, error });
    const { mergedSize } = useSize$1(_mergedSize);
    const refInput0 = ref();
    const refInput1 = ref();
    const getDisabled = (index2) => {
      if (mergedDisabled.value) {
        return mergedDisabled.value;
      }
      return isArray(disabled.value) ? disabled.value[index2] : disabled.value;
    };
    const disabled0 = computed(() => getDisabled(0));
    const disabled1 = computed(() => getDisabled(1));
    const prefixCls = getPrefixCls("picker");
    const classNames = computed(() => [
      prefixCls,
      `${prefixCls}-range`,
      `${prefixCls}-size-${mergedSize.value}`,
      {
        [`${prefixCls}-focused`]: focused.value,
        [`${prefixCls}-disabled`]: disabled0.value && disabled1.value,
        [`${prefixCls}-error`]: mergedError.value,
        [`${prefixCls}-has-prefix`]: slots.prefix
      }
    ]);
    function getInputWrapClassName(index2) {
      return [
        `${prefixCls}-input`,
        {
          [`${prefixCls}-input-active`]: index2 === (focusedIndex == null ? void 0 : focusedIndex.value)
        }
      ];
    }
    function getDisplayValue(index2) {
      var _a, _b;
      if (inputValue == null ? void 0 : inputValue.value) {
        return (_a = inputValue == null ? void 0 : inputValue.value) == null ? void 0 : _a[index2];
      }
      const targetValue = (_b = value == null ? void 0 : value.value) == null ? void 0 : _b[index2];
      if (targetValue && isDayjs(targetValue)) {
        return isFunction(format.value) ? format.value(targetValue) : targetValue.format(format.value);
      }
      return void 0;
    }
    const displayValue0 = computed(() => getDisplayValue(0));
    const displayValue1 = computed(() => getDisplayValue(1));
    function changeFocusedInput(index2) {
      emit("focused-index-change", index2);
      emit("update:focusedIndex", index2);
    }
    function onChange(e) {
      e.stopPropagation();
      emit("change", e);
    }
    function onPressEnter() {
      emit("press-enter");
    }
    function onPressTab(e) {
      e.preventDefault();
    }
    function onClear(e) {
      emit("clear", e);
    }
    return {
      prefixCls,
      classNames,
      refInput0,
      refInput1,
      disabled0,
      disabled1,
      mergedDisabled,
      getDisabled,
      getInputWrapClassName,
      displayValue0,
      displayValue1,
      changeFocusedInput,
      onChange,
      onPressEnter,
      onPressTab,
      onClear,
      feedback
    };
  },
  methods: {
    focus(index2) {
      const targetIndex = isNumber(index2) ? index2 : this.focusedIndex;
      const targetElement = targetIndex === 0 ? this.refInput0 : this.refInput1;
      !isUndefined(targetIndex) && !this.getDisabled(targetIndex) && targetElement && targetElement.focus && targetElement.focus();
    },
    blur() {
      const targetElement = this.focusedIndex === 0 ? this.refInput0 : this.refInput1;
      targetElement && targetElement.blur && targetElement.blur();
    }
  }
});
const _hoisted_1$4h = ["disabled", "placeholder", "value"];
const _hoisted_2$4 = ["disabled", "placeholder", "value"];
function _sfc_render$5l(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconClose = resolveComponent("IconClose");
  const _component_IconHover = resolveComponent("IconHover");
  const _component_FeedbackIcon = resolveComponent("FeedbackIcon");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    _ctx.$slots.prefix ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-prefix`)
    }, [
      renderSlot(_ctx.$slots, "prefix")
    ], 2)) : createCommentVNode("v-if", true),
    createBaseVNode("div", {
      class: normalizeClass(_ctx.getInputWrapClassName(0))
    }, [
      createBaseVNode("input", mergeProps({
        ref: "refInput0",
        disabled: _ctx.disabled0,
        placeholder: _ctx.placeholder[0],
        value: _ctx.displayValue0
      }, _ctx.readonly ? { readonly: true } : {}, {
        onInput: _cache[0] || (_cache[0] = (...args) => _ctx.onChange && _ctx.onChange(...args)),
        onKeydown: [
          _cache[1] || (_cache[1] = withKeys((...args) => _ctx.onPressEnter && _ctx.onPressEnter(...args), ["enter"])),
          _cache[2] || (_cache[2] = withKeys((...args) => _ctx.onPressTab && _ctx.onPressTab(...args), ["tab"]))
        ],
        onClick: _cache[3] || (_cache[3] = () => _ctx.changeFocusedInput(0))
      }), null, 16, _hoisted_1$4h)
    ], 2),
    createBaseVNode("span", {
      class: normalizeClass(`${_ctx.prefixCls}-separator`)
    }, [
      renderSlot(_ctx.$slots, "separator", {}, () => [
        _cache[8] || (_cache[8] = createTextVNode(" - "))
      ])
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(_ctx.getInputWrapClassName(1))
    }, [
      createBaseVNode("input", mergeProps({
        ref: "refInput1",
        disabled: _ctx.disabled1,
        placeholder: _ctx.placeholder[1],
        value: _ctx.displayValue1
      }, _ctx.readonly ? { readonly: true } : {}, {
        onInput: _cache[4] || (_cache[4] = (...args) => _ctx.onChange && _ctx.onChange(...args)),
        onKeydown: [
          _cache[5] || (_cache[5] = withKeys((...args) => _ctx.onPressEnter && _ctx.onPressEnter(...args), ["enter"])),
          _cache[6] || (_cache[6] = withKeys((...args) => _ctx.onPressTab && _ctx.onPressTab(...args), ["tab"]))
        ],
        onClick: _cache[7] || (_cache[7] = () => _ctx.changeFocusedInput(1))
      }), null, 16, _hoisted_2$4)
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-suffix`)
    }, [
      _ctx.allowClear && !_ctx.mergedDisabled && _ctx.value.length === 2 ? (openBlock(), createBlock(_component_IconHover, {
        key: 0,
        prefix: _ctx.prefixCls,
        class: normalizeClass(`${_ctx.prefixCls}-clear-icon`),
        onClick: _ctx.onClear
      }, {
        default: withCtx(() => [
          createVNode(_component_IconClose)
        ]),
        _: 1
      }, 8, ["prefix", "class", "onClick"])) : createCommentVNode("v-if", true),
      createBaseVNode("span", {
        class: normalizeClass(`${_ctx.prefixCls}-suffix-icon`)
      }, [
        renderSlot(_ctx.$slots, "suffix-icon")
      ], 2),
      _ctx.feedback ? (openBlock(), createBlock(_component_FeedbackIcon, {
        key: 1,
        type: _ctx.feedback
      }, null, 8, ["type"])) : createCommentVNode("v-if", true)
    ], 2)
  ], 2);
}
var DateRangeInput = /* @__PURE__ */ _export_sfc(_sfc_main$5m, [["render", _sfc_render$5l]]);
const _sfc_main$5l = defineComponent({
  name: "DateRangePikerPanel",
  components: {
    PanelShortcuts,
    PanelFooter,
    RenderFunction,
    DatePanel,
    WeekPanel,
    MonthPanel,
    YearPanel,
    QuarterPanel
  },
  props: {
    mode: {
      type: String,
      default: "date"
    },
    value: {
      type: Array,
      default: () => []
    },
    footerValue: {
      type: Array
    },
    timePickerValue: {
      type: Array
    },
    showTime: {
      type: Boolean
    },
    showConfirmBtn: {
      type: Boolean
    },
    prefixCls: {
      type: String,
      required: true
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    shortcutsPosition: {
      type: String,
      default: "bottom"
    },
    format: {
      type: String,
      required: true
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    disabledDate: {
      type: Function
    },
    disabledTime: {
      type: Function
    },
    timePickerProps: {
      type: Object
    },
    extra: {
      type: Function
    },
    dateRender: {
      type: Function
    },
    hideTrigger: {
      type: Boolean
    },
    startHeaderProps: {
      type: Object,
      default: () => ({})
    },
    endHeaderProps: {
      type: Object,
      default: () => ({})
    },
    confirmBtnDisabled: {
      type: Boolean
    },
    disabled: {
      type: Array,
      default: () => [false, false]
    },
    visible: {
      type: Boolean
    },
    startHeaderMode: {
      type: String
    },
    endHeaderMode: {
      type: String
    },
    abbreviation: {
      type: Boolean
    }
  },
  emits: [
    "cell-click",
    "cell-mouse-enter",
    "time-picker-select",
    "shortcut-click",
    "shortcut-mouse-enter",
    "shortcut-mouse-leave",
    "confirm",
    "start-header-label-click",
    "end-header-label-click",
    "start-header-select",
    "end-header-select"
  ],
  setup(props, { emit }) {
    const {
      prefixCls,
      shortcuts,
      shortcutsPosition,
      format,
      hideTrigger,
      value,
      disabledDate,
      disabledTime,
      startHeaderProps,
      endHeaderProps,
      dateRender,
      visible,
      startHeaderMode,
      endHeaderMode
    } = toRefs(props);
    const showShortcuts = computed(
      () => isArray(shortcuts.value) && shortcuts.value.length
    );
    const classNames = computed(() => [
      `${prefixCls.value}-range-container`,
      {
        [`${prefixCls.value}-range-container-panel-only`]: hideTrigger.value,
        [`${prefixCls.value}-range-container-shortcuts-placement-left`]: showShortcuts.value && shortcutsPosition.value === "left",
        [`${prefixCls.value}-range-container-shortcuts-placement-right`]: showShortcuts.value && shortcutsPosition.value === "right"
      }
    ]);
    const currentDateView = ref("date");
    watch(visible, (newVal, oldVal) => {
      if (newVal && !oldVal) {
        currentDateView.value = "date";
      }
    });
    function getShortcutValue(shortcut) {
      return getDayjsValue(
        normalizeRangeValue(
          isFunction(shortcut.value) ? shortcut.value() : shortcut.value
        ),
        shortcut.format || format.value
      );
    }
    function onShortcutClick(shortcut) {
      emit("shortcut-click", getShortcutValue(shortcut), shortcut);
    }
    function onShortcutMouseEnter(shortcut) {
      emit("shortcut-mouse-enter", getShortcutValue(shortcut));
    }
    function onShortcutMouseLeave(shortcut) {
      emit("shortcut-mouse-leave", getShortcutValue(shortcut));
    }
    function onPanelCellClick(date) {
      emit("cell-click", date);
    }
    function onPanelCellMouseEnter(date) {
      emit("cell-mouse-enter", date);
    }
    function onConfirmBtnClick() {
      emit("confirm");
    }
    function onStartTimePickerSelect(time) {
      emit("time-picker-select", time, "start");
    }
    function onEndTimePickerSelect(time) {
      emit("time-picker-select", time, "end");
    }
    function onStartPanelHeaderLabelClick(type) {
      emit("start-header-label-click", type);
    }
    function onEndPanelHeaderLabelClick(type) {
      emit("end-header-label-click", type);
    }
    function onStartHeaderPanelSelect(date) {
      emit("start-header-select", date);
    }
    function onEndHeaderPanelSelect(date) {
      emit("end-header-select", date);
    }
    function getDisabledDateFunc(index2) {
      return isFunction(disabledDate == null ? void 0 : disabledDate.value) ? (current) => {
        var _a;
        return ((_a = disabledDate == null ? void 0 : disabledDate.value) == null ? void 0 : _a.call(disabledDate, current, index2 === 0 ? "start" : "end")) || false;
      } : void 0;
    }
    function getDisabledTimeFunc(index2) {
      return isFunction(disabledTime == null ? void 0 : disabledTime.value) ? (current) => {
        var _a;
        return ((_a = disabledTime == null ? void 0 : disabledTime.value) == null ? void 0 : _a.call(disabledTime, current, index2 === 0 ? "start" : "end")) || false;
      } : void 0;
    }
    function getDateRenderFunc(index2) {
      return isFunction(dateRender == null ? void 0 : dateRender.value) ? (props2) => {
        var _a;
        const mergeProps2 = {
          ...props2,
          type: index2 === 0 ? "start" : "end"
        };
        return (_a = dateRender == null ? void 0 : dateRender.value) == null ? void 0 : _a.call(dateRender, mergeProps2);
      } : void 0;
    }
    const shortcutsProps = reactive({
      prefixCls,
      shortcuts,
      onItemClick: onShortcutClick,
      onItemMouseEnter: onShortcutMouseEnter,
      onItemMouseLeave: onShortcutMouseLeave
    });
    const startPanelProps = computed(() => ({
      ...startHeaderProps.value,
      rangeValues: value.value,
      disabledDate: getDisabledDateFunc(0),
      dateRender: getDateRenderFunc(0),
      onSelect: startHeaderMode.value ? onStartHeaderPanelSelect : onPanelCellClick,
      onCellMouseEnter: onPanelCellMouseEnter,
      onHeaderLabelClick: onStartPanelHeaderLabelClick
    }));
    const endPanelProps = computed(() => ({
      ...endHeaderProps.value,
      rangeValues: value.value,
      disabledDate: getDisabledDateFunc(1),
      dateRender: getDateRenderFunc(1),
      onSelect: endHeaderMode.value ? onEndHeaderPanelSelect : onPanelCellClick,
      onCellMouseEnter: onPanelCellMouseEnter,
      onHeaderLabelClick: onEndPanelHeaderLabelClick
    }));
    return {
      pick,
      classNames,
      showShortcuts,
      shortcutsProps,
      startPanelProps,
      endPanelProps,
      getDisabledTimeFunc,
      onConfirmBtnClick,
      currentDateView,
      onStartTimePickerSelect,
      onEndTimePickerSelect,
      onStartHeaderPanelSelect,
      onEndHeaderPanelSelect
    };
  }
});
function _sfc_render$5k(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PanelShortcuts = resolveComponent("PanelShortcuts");
  const _component_YearPanel = resolveComponent("YearPanel");
  const _component_MonthPanel = resolveComponent("MonthPanel");
  const _component_WeekPanel = resolveComponent("WeekPanel");
  const _component_QuarterPanel = resolveComponent("QuarterPanel");
  const _component_DatePanel = resolveComponent("DatePanel");
  const _component_RenderFunction = resolveComponent("RenderFunction");
  const _component_PanelFooter = resolveComponent("PanelFooter");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    _ctx.showShortcuts && _ctx.shortcutsPosition === "left" ? (openBlock(), createBlock(_component_PanelShortcuts, normalizeProps(mergeProps({ key: 0 }, _ctx.shortcutsProps)), null, 16)) : createCommentVNode("v-if", true),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-range-panel-wrapper`)
    }, [
      createCommentVNode(" panel "),
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-range`)
      }, [
        createBaseVNode("div", {
          class: normalizeClass(`${_ctx.prefixCls}-range-wrapper`)
        }, [
          _ctx.startHeaderMode || _ctx.endHeaderMode ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            _ctx.startHeaderMode === "year" ? (openBlock(), createBlock(_component_YearPanel, normalizeProps(mergeProps({ key: 0 }, _ctx.startPanelProps)), null, 16)) : createCommentVNode("v-if", true),
            _ctx.endHeaderMode === "year" ? (openBlock(), createBlock(_component_YearPanel, normalizeProps(mergeProps({ key: 1 }, _ctx.endPanelProps)), null, 16)) : _ctx.startHeaderMode === "month" ? (openBlock(), createBlock(_component_MonthPanel, mergeProps({ key: 2 }, _ctx.startPanelProps, { abbreviation: _ctx.abbreviation }), null, 16, ["abbreviation"])) : _ctx.endHeaderMode === "month" ? (openBlock(), createBlock(_component_MonthPanel, mergeProps({ key: 3 }, _ctx.endPanelProps, { abbreviation: _ctx.abbreviation }), null, 16, ["abbreviation"])) : createCommentVNode("v-if", true)
          ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            createCommentVNode(" week "),
            _ctx.mode === "week" ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createVNode(_component_WeekPanel, mergeProps(_ctx.startPanelProps, { "day-start-of-week": _ctx.dayStartOfWeek }), null, 16, ["day-start-of-week"]),
              createVNode(_component_WeekPanel, mergeProps(_ctx.endPanelProps, { "day-start-of-week": _ctx.dayStartOfWeek }), null, 16, ["day-start-of-week"])
            ], 64)) : _ctx.mode === "month" ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createCommentVNode(" month "),
              createVNode(_component_MonthPanel, mergeProps(_ctx.startPanelProps, { abbreviation: _ctx.abbreviation }), null, 16, ["abbreviation"]),
              createVNode(_component_MonthPanel, mergeProps(_ctx.endPanelProps, { abbreviation: _ctx.abbreviation }), null, 16, ["abbreviation"])
            ], 64)) : _ctx.mode === "year" ? (openBlock(), createElementBlock(Fragment, { key: 2 }, [
              createCommentVNode(" year "),
              createVNode(_component_YearPanel, normalizeProps(guardReactiveProps(_ctx.startPanelProps)), null, 16),
              createVNode(_component_YearPanel, normalizeProps(guardReactiveProps(_ctx.endPanelProps)), null, 16)
            ], 64)) : _ctx.mode === "quarter" ? (openBlock(), createElementBlock(Fragment, { key: 3 }, [
              createCommentVNode(" quarter "),
              createVNode(_component_QuarterPanel, normalizeProps(guardReactiveProps(_ctx.startPanelProps)), null, 16),
              createVNode(_component_QuarterPanel, normalizeProps(guardReactiveProps(_ctx.endPanelProps)), null, 16)
            ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 4 }, [
              createCommentVNode(" date "),
              createVNode(_component_DatePanel, mergeProps({
                currentView: _ctx.currentDateView,
                "onUpdate:currentView": _cache[0] || (_cache[0] = ($event) => _ctx.currentDateView = $event)
              }, _ctx.startPanelProps, {
                "is-range": "",
                value: _ctx.value && _ctx.value[0],
                "footer-value": _ctx.footerValue && _ctx.footerValue[0],
                "time-picker-value": _ctx.timePickerValue && _ctx.timePickerValue[0],
                "day-start-of-week": _ctx.dayStartOfWeek,
                "show-time": _ctx.showTime,
                "time-picker-props": _ctx.timePickerProps,
                "disabled-time": _ctx.getDisabledTimeFunc(0),
                disabled: _ctx.disabled[0],
                onTimePickerSelect: _ctx.onStartTimePickerSelect
              }), null, 16, ["currentView", "value", "footer-value", "time-picker-value", "day-start-of-week", "show-time", "time-picker-props", "disabled-time", "disabled", "onTimePickerSelect"]),
              createVNode(_component_DatePanel, mergeProps({
                currentView: _ctx.currentDateView,
                "onUpdate:currentView": _cache[1] || (_cache[1] = ($event) => _ctx.currentDateView = $event)
              }, _ctx.endPanelProps, {
                "is-range": "",
                value: _ctx.value && _ctx.value[1],
                "footer-value": _ctx.footerValue && _ctx.footerValue[1],
                "time-picker-value": _ctx.timePickerValue && _ctx.timePickerValue[1],
                "day-start-of-week": _ctx.dayStartOfWeek,
                "show-time": _ctx.showTime,
                "time-picker-props": _ctx.timePickerProps,
                "disabled-time": _ctx.getDisabledTimeFunc(1),
                disabled: _ctx.disabled[1],
                onTimePickerSelect: _ctx.onEndTimePickerSelect
              }), null, 16, ["currentView", "value", "footer-value", "time-picker-value", "day-start-of-week", "show-time", "time-picker-props", "disabled-time", "disabled", "onTimePickerSelect"])
            ], 64))
          ], 64))
        ], 2)
      ], 2),
      createCommentVNode(" footer "),
      createVNode(_component_PanelFooter, {
        "prefix-cls": _ctx.prefixCls,
        "show-today-btn": false,
        "show-confirm-btn": _ctx.showConfirmBtn,
        "confirm-btn-disabled": _ctx.confirmBtnDisabled,
        onConfirmBtnClick: _ctx.onConfirmBtnClick
      }, createSlots({ _: 2 }, [
        _ctx.extra || _ctx.$slots.extra ? {
          name: "extra",
          fn: withCtx(() => [
            _ctx.$slots.extra ? renderSlot(_ctx.$slots, "extra", { key: 0 }) : (openBlock(), createBlock(_component_RenderFunction, {
              key: 1,
              "render-func": _ctx.extra
            }, null, 8, ["render-func"]))
          ]),
          key: "0"
        } : void 0,
        _ctx.showShortcuts && _ctx.shortcutsPosition === "bottom" ? {
          name: "btn",
          fn: withCtx(() => [
            createVNode(_component_PanelShortcuts, normalizeProps(guardReactiveProps(_ctx.shortcutsProps)), null, 16)
          ]),
          key: "1"
        } : void 0
      ]), 1032, ["prefix-cls", "show-confirm-btn", "confirm-btn-disabled", "onConfirmBtnClick"])
    ], 2),
    _ctx.showShortcuts && _ctx.shortcutsPosition === "right" ? (openBlock(), createBlock(_component_PanelShortcuts, normalizeProps(mergeProps({ key: 1 }, _ctx.shortcutsProps)), null, 16)) : createCommentVNode("v-if", true)
  ], 2);
}
var RangePickerPanel = /* @__PURE__ */ _export_sfc(_sfc_main$5l, [["render", _sfc_render$5k]]);
function useRangeTimePickerValue(props) {
  const { timePickerProps, selectedValue } = toRefs(props);
  const startValue = computed(() => {
    var _a;
    return (_a = selectedValue == null ? void 0 : selectedValue.value) == null ? void 0 : _a[0];
  });
  const endValue = computed(() => {
    var _a;
    return (_a = selectedValue == null ? void 0 : selectedValue.value) == null ? void 0 : _a[1];
  });
  const timePickerDefaultValue = computed(
    () => {
      var _a;
      return (_a = timePickerProps == null ? void 0 : timePickerProps.value) == null ? void 0 : _a.defaultValue;
    }
  );
  const startTimePickerProps = computed(
    () => isArray(timePickerDefaultValue.value) ? {
      ...timePickerProps == null ? void 0 : timePickerProps.value,
      defaultValue: timePickerDefaultValue.value[0]
    } : timePickerProps == null ? void 0 : timePickerProps.value
  );
  const endTimePickerProps = computed(
    () => isArray(timePickerDefaultValue.value) ? {
      ...timePickerProps == null ? void 0 : timePickerProps.value,
      defaultValue: timePickerDefaultValue.value[1]
    } : timePickerProps == null ? void 0 : timePickerProps.value
  );
  const [startTimeValue, setStartTimeValue, resetStartTimeValue] = useTimePickerValue(
    reactive({
      timePickerProps: startTimePickerProps,
      selectedValue: startValue
    })
  );
  const [endTimeValue, setEndTimeValue, resetEndTimeValue] = useTimePickerValue(
    reactive({
      timePickerProps: endTimePickerProps,
      selectedValue: endValue
    })
  );
  const rangeTimePickerValue = computed(() => [
    startTimeValue.value,
    endTimeValue.value
  ]);
  function setTimeValue(val) {
    if (!val)
      return;
    setStartTimeValue(val[0]);
    setEndTimeValue(val[1]);
  }
  function resetTimeValue() {
    resetStartTimeValue();
    resetEndTimeValue();
  }
  return [rangeTimePickerValue, setTimeValue, resetTimeValue];
}
const _sfc_main$5k = defineComponent({
  name: "RangePicker",
  components: {
    RangePickerPanel,
    DateRangeInput,
    Trigger,
    IconCalendar
  },
  inheritAttrs: false,
  props: {
    mode: {
      type: String,
      default: "date"
    },
    modelValue: {
      type: Array
    },
    defaultValue: {
      type: Array
    },
    pickerValue: {
      type: Array
    },
    defaultPickerValue: {
      type: Array
    },
    disabled: {
      type: [Boolean, Array],
      default: false
    },
    dayStartOfWeek: {
      type: Number,
      default: 0
    },
    format: {
      type: String
    },
    valueFormat: {
      type: String
    },
    showTime: {
      type: Boolean
    },
    timePickerProps: {
      type: Object
    },
    placeholder: {
      type: Array
    },
    disabledDate: {
      type: Function
    },
    disabledTime: {
      type: Function
    },
    separator: {
      type: String
    },
    exchangeTime: {
      type: Boolean,
      default: true
    },
    popupContainer: {
      type: [String, Object]
    },
    locale: {
      type: Object
    },
    hideTrigger: {
      type: Boolean
    },
    allowClear: {
      type: Boolean,
      default: true
    },
    readonly: {
      type: Boolean
    },
    error: {
      type: Boolean
    },
    size: {
      type: String
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    shortcutsPosition: {
      type: String,
      default: "bottom"
    },
    position: {
      type: String,
      default: "bl"
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean
    },
    triggerProps: {
      type: Object
    },
    unmountOnClose: {
      type: Boolean
    },
    previewShortcut: {
      type: Boolean,
      default: true
    },
    showConfirmBtn: {
      type: Boolean
    },
    disabledInput: {
      type: Boolean,
      default: false
    },
    abbreviation: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "change": (value, date, dateString) => {
      return true;
    },
    "update:modelValue": (value) => {
      return true;
    },
    "select": (value, date, dateString) => {
      return true;
    },
    "popup-visible-change": (visible) => {
      return true;
    },
    "update:popupVisible": (visible) => {
      return true;
    },
    "ok": (value, date, dateString) => {
      return true;
    },
    "clear": () => {
      return true;
    },
    "select-shortcut": (shortcut) => {
      return true;
    },
    "picker-value-change": (value, date, dateString) => {
      return true;
    },
    "update:pickerValue": (value) => {
      return true;
    }
  },
  setup(props, { emit, slots }) {
    const {
      mode,
      showTime,
      format,
      modelValue,
      defaultValue,
      popupVisible,
      defaultPopupVisible,
      placeholder,
      timePickerProps,
      disabled,
      disabledDate,
      disabledTime,
      locale,
      pickerValue,
      defaultPickerValue,
      valueFormat,
      size,
      error,
      dayStartOfWeek,
      exchangeTime,
      previewShortcut,
      showConfirmBtn
    } = toRefs(props);
    const { locale: globalLocal } = useI18n();
    const configCtx = inject(configProviderInjectionKey, void 0);
    watchEffect(() => {
      initializeDateLocale(globalLocal.value, dayStartOfWeek.value);
    });
    const mergedExchangeTime = computed(() => {
      var _a;
      return !(!exchangeTime.value || !((_a = configCtx == null ? void 0 : configCtx.exchangeTime) != null ? _a : true));
    });
    const {
      mergedSize,
      mergedDisabled: formDisabled,
      mergedError,
      eventHandlers
    } = useFormItem({
      size,
      error
    });
    const datePickerT = useDatePickerTransform(
      reactive({
        locale
      })
    );
    const prefixCls = getPrefixCls("picker");
    const computedPlaceholder = computed(
      () => (placeholder == null ? void 0 : placeholder.value) || {
        date: datePickerT("datePicker.rangePlaceholder.date"),
        month: datePickerT("datePicker.rangePlaceholder.month"),
        year: datePickerT("datePicker.rangePlaceholder.year"),
        week: datePickerT("datePicker.rangePlaceholder.week"),
        quarter: datePickerT("datePicker.rangePlaceholder.quarter")
      }[mode.value] || datePickerT("datePicker.rangePlaceholder.date")
    );
    const {
      format: computedFormat,
      valueFormat: returnValueFormat,
      parseValueFormat
    } = useFormat(
      reactive({
        mode,
        format,
        showTime,
        valueFormat
      })
    );
    const disabledArray = computed(() => {
      const disabled0 = disabled.value === true || formDisabled.value || isArray(disabled.value) && disabled.value[0] === true;
      const disabled1 = disabled.value === true || formDisabled.value || isArray(disabled.value) && disabled.value[1] === true;
      return [disabled0, disabled1];
    });
    const triggerDisabled = computed(
      () => disabledArray.value[0] && disabledArray.value[1]
    );
    function getFocusedIndex(cur = 0) {
      return disabledArray.value[cur] ? cur ^ 1 : cur;
    }
    const refInput = ref();
    const focusedIndex = ref(getFocusedIndex());
    const nextFocusedIndex = computed(() => {
      const cur = focusedIndex.value;
      const next = cur ^ 1;
      return disabledArray.value[next] ? cur : next;
    });
    const isNextDisabled = computed(
      () => disabledArray.value[focusedIndex.value ^ 1]
    );
    const { value: selectedValue, setValue: setSelectedValue } = useRangePickerState(
      reactive({
        modelValue,
        defaultValue,
        format: parseValueFormat
      })
    );
    const [processValue, setProcessValue] = useState();
    const [previewValue, setPreviewValue] = useState();
    const forSelectedValue = computed(
      () => {
        var _a;
        return (_a = processValue.value) != null ? _a : selectedValue.value;
      }
    );
    const panelValue = computed(
      () => {
        var _a, _b;
        return (_b = (_a = previewValue.value) != null ? _a : processValue.value) != null ? _b : selectedValue.value;
      }
    );
    const [inputValue, setInputValue] = useState();
    const startHeaderMode = ref();
    const endHeaderMode = ref();
    const [panelVisible, setLocalPanelVisible] = useMergeState(
      defaultPopupVisible.value,
      reactive({ value: popupVisible })
    );
    const setPanelVisible = (newVisible) => {
      if (panelVisible.value !== newVisible) {
        setLocalPanelVisible(newVisible);
        emit("popup-visible-change", newVisible);
        emit("update:popupVisible", newVisible);
      }
    };
    const {
      startHeaderValue,
      endHeaderValue,
      startHeaderOperations,
      endHeaderOperations,
      resetHeaderValue,
      setHeaderValue
    } = useRangeHeaderValue(
      reactive({
        mode,
        startHeaderMode,
        endHeaderMode,
        value: pickerValue,
        defaultValue: defaultPickerValue,
        selectedValue: panelValue,
        format: parseValueFormat,
        onChange: (newVal) => {
          const returnValue = getReturnRangeValue(
            newVal,
            returnValueFormat.value
          );
          const formattedValue = getFormattedValue(
            newVal,
            parseValueFormat.value
          );
          const dateValue = getDateValue$1(newVal);
          emit("picker-value-change", returnValue, dateValue, formattedValue);
          emit("update:pickerValue", returnValue);
        }
      })
    );
    function onStartPanelHeaderLabelClick(type) {
      startHeaderMode.value = type;
    }
    function onEndPanelHeaderLabelClick(type) {
      endHeaderMode.value = type;
    }
    function onStartPanelHeaderSelect(date) {
      let newStartValue = startHeaderValue.value;
      newStartValue = newStartValue.set("year", date.year());
      if (startHeaderMode.value === "month") {
        newStartValue = newStartValue.set("month", date.month());
      }
      setHeaderValue([newStartValue, endHeaderValue.value]);
      startHeaderMode.value = void 0;
    }
    function onEndPanelHeaderSelect(date) {
      let newEndValue = endHeaderValue.value;
      newEndValue = newEndValue.set("year", date.year());
      if (endHeaderMode.value === "month") {
        newEndValue = newEndValue.set("month", date.month());
      }
      setHeaderValue([startHeaderValue.value, newEndValue]);
      endHeaderMode.value = void 0;
    }
    const footerValue = ref([
      panelValue.value[0] || getNow(),
      panelValue.value[1] || getNow()
    ]);
    watch(panelValue, () => {
      const [value0, value1] = panelValue.value;
      footerValue.value[0] = value0 || footerValue.value[0];
      footerValue.value[1] = value1 || footerValue.value[1];
    });
    const [timePickerValue, setTimePickerValue, resetTimePickerValue] = useRangeTimePickerValue(
      reactive({
        timePickerProps,
        selectedValue: panelValue
      })
    );
    const isDateTime = computed(() => mode.value === "date" && showTime.value);
    const hasTime = computed(() => isDateTime.value || timePickerProps.value);
    const isDisabledDate = useIsDisabledDate(
      reactive({
        mode,
        isRange: true,
        showTime,
        disabledDate,
        disabledTime
      })
    );
    const needConfirm = computed(
      () => isDateTime.value || showConfirmBtn.value
    );
    const confirmBtnDisabled = computed(
      () => needConfirm.value && (!isCompleteRangeValue(forSelectedValue.value) || isDisabledDate(forSelectedValue.value[0], "start") || isDisabledDate(forSelectedValue.value[1], "end"))
    );
    watch(panelVisible, (newVisible) => {
      startHeaderMode.value = void 0;
      endHeaderMode.value = void 0;
      setProcessValue(void 0);
      setPreviewValue(void 0);
      if (newVisible) {
        resetHeaderValue();
        resetTimePickerValue();
        focusedIndex.value = getFocusedIndex(focusedIndex.value);
        nextTick(() => focusInput(focusedIndex.value));
      }
      if (!newVisible) {
        setInputValue(void 0);
      }
    });
    watch(focusedIndex, () => {
      if (props.disabledInput) {
        focusInput(focusedIndex.value);
        setInputValue(void 0);
      }
    });
    function emitChange(value, emitOk) {
      var _a, _b;
      const returnValue = value ? getReturnRangeValue(value, returnValueFormat.value) : void 0;
      const formattedValue = getFormattedValue(value, parseValueFormat.value);
      const dateValue = getDateValue$1(value);
      if (isValueChange(value, selectedValue.value)) {
        emit("update:modelValue", returnValue);
        emit("change", returnValue, dateValue, formattedValue);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
      }
      if (emitOk) {
        emit("ok", returnValue, dateValue, formattedValue);
      }
    }
    function getSortedDayjsArrayByExchangeTimeOrNot(newValue) {
      let sortedValue = getSortedDayjsArray(newValue);
      if (hasTime.value && !mergedExchangeTime.value) {
        sortedValue = [
          getMergedOpValue(sortedValue[0], newValue[0]),
          getMergedOpValue(sortedValue[1], newValue[1])
        ];
      }
      return sortedValue;
    }
    function confirm(value, showPanel, emitOk) {
      if (isDisabledDate(value == null ? void 0 : value[0], "start") || isDisabledDate(value == null ? void 0 : value[1], "end")) {
        return;
      }
      let newValue = value ? [...value] : void 0;
      if (isCompleteRangeValue(newValue)) {
        newValue = getSortedDayjsArrayByExchangeTimeOrNot(newValue);
      }
      emitChange(newValue, emitOk);
      setSelectedValue(newValue || []);
      setProcessValue(void 0);
      setPreviewValue(void 0);
      setInputValue(void 0);
      startHeaderMode.value = void 0;
      endHeaderMode.value = void 0;
      if (isBoolean(showPanel)) {
        setPanelVisible(showPanel);
      }
    }
    function emitSelectEvent(value) {
      const returnValue = getReturnRangeValue(value, returnValueFormat.value);
      const formattedValue = getFormattedValue(value, parseValueFormat.value);
      const dateValue = getDateValue$1(value);
      emit("select", returnValue, dateValue, formattedValue);
    }
    function select(value, options) {
      const { emitSelect = false, updateHeader = false } = options || {};
      let newValue = [...value];
      if (isCompleteRangeValue(newValue)) {
        newValue = getSortedDayjsArrayByExchangeTimeOrNot(newValue);
      }
      setProcessValue(newValue);
      setPreviewValue(void 0);
      setInputValue(void 0);
      startHeaderMode.value = void 0;
      endHeaderMode.value = void 0;
      if (emitSelect) {
        emitSelectEvent(newValue);
      }
      if (updateHeader) {
        resetHeaderValue();
      }
    }
    function preview(value, options) {
      const { updateHeader = false } = options || {};
      setPreviewValue(value);
      setInputValue(void 0);
      if (updateHeader) {
        resetHeaderValue();
      }
    }
    function focusInput(index2) {
      refInput.value && refInput.value.focus && refInput.value.focus(index2);
    }
    function getMergedOpValue(date, time) {
      if (!hasTime.value)
        return date;
      return mergeValueWithTime(getNow(), date, time);
    }
    function onPanelVisibleChange(visible) {
      setPanelVisible(visible);
    }
    function onPanelCellMouseEnter(date) {
      if (processValue.value && panelValue.value[nextFocusedIndex.value] && (!needConfirm.value || !isCompleteRangeValue(processValue.value))) {
        const newValue = [...panelValue.value];
        const mergedOpValue = getMergedOpValue(
          date,
          timePickerValue.value[focusedIndex.value]
        );
        newValue[focusedIndex.value] = mergedOpValue;
        preview(newValue);
      }
    }
    function getValueToModify(isTime = false) {
      if (isNextDisabled.value)
        return [...selectedValue.value];
      if (processValue.value) {
        return isTime || !isCompleteRangeValue(processValue.value) ? [...processValue.value] : [];
      }
      return isTime ? [...selectedValue.value] : [];
    }
    function onPanelCellClick(date) {
      const newValue = getValueToModify();
      const mergedOpValue = getMergedOpValue(
        date,
        timePickerValue.value[focusedIndex.value]
      );
      newValue[focusedIndex.value] = mergedOpValue;
      emitSelectEvent(newValue);
      if (!needConfirm.value && isCompleteRangeValue(newValue)) {
        confirm(newValue, false);
      } else {
        select(newValue);
        if (!isCompleteRangeValue(newValue)) {
          focusedIndex.value = nextFocusedIndex.value;
        } else {
          focusedIndex.value = 0;
        }
      }
    }
    function onTimePickerSelect(time, type) {
      const updateIndex = type === "start" ? 0 : 1;
      const mergedOpValue = getMergedOpValue(
        timePickerValue.value[updateIndex],
        time
      );
      const newTimeValue = [...timePickerValue.value];
      newTimeValue[updateIndex] = mergedOpValue;
      setTimePickerValue(newTimeValue);
      const newValue = getValueToModify(true);
      if (newValue[updateIndex]) {
        newValue[updateIndex] = mergedOpValue;
        select(newValue, { emitSelect: true });
      }
    }
    let clearShortcutPreviewTimer;
    onUnmounted(() => {
      clearTimeout(clearShortcutPreviewTimer);
    });
    function onPanelShortcutMouseEnter(value) {
      clearTimeout(clearShortcutPreviewTimer);
      preview(value, { updateHeader: true });
    }
    function onPanelShortcutMouseLeave() {
      clearTimeout(clearShortcutPreviewTimer);
      clearShortcutPreviewTimer = setTimeout(() => {
        setPreviewValue(void 0);
        setInputValue(void 0);
        resetHeaderValue();
      }, 100);
    }
    function onPanelShortcutClick(value, shortcut) {
      emit("select-shortcut", shortcut);
      confirm(value, false);
    }
    function onPanelConfirm() {
      confirm(panelValue.value, false, true);
    }
    function onInputClear(e) {
      e.stopPropagation();
      confirm(void 0);
      emit("clear");
    }
    function onInputChange(e) {
      setPanelVisible(true);
      const targetValue = e.target.value;
      if (!targetValue) {
        setInputValue(void 0);
        return;
      }
      const formattedPanelValue = getFormattedValue(
        panelValue.value,
        computedFormat.value
      );
      const newInputValue = isArray(inputValue.value) ? [...inputValue.value] : formattedPanelValue || [];
      newInputValue[focusedIndex.value] = targetValue;
      setInputValue(newInputValue);
      if (!isValidInputValue(targetValue, computedFormat.value))
        return;
      const targetValueDayjs = dayjs(targetValue, computedFormat.value);
      if (isDisabledDate(
        targetValueDayjs,
        focusedIndex.value === 0 ? "start" : "end"
      ))
        return;
      const newValue = isArray(panelValue.value) ? [...panelValue.value] : [];
      newValue[focusedIndex.value] = targetValueDayjs;
      select(newValue, { updateHeader: true });
    }
    function onInputPressEnter() {
      if (isValidRangeValue(panelValue.value)) {
        confirm(panelValue.value, false);
      } else {
        focusedIndex.value = nextFocusedIndex.value;
      }
    }
    const computedTimePickerProps = computed(() => ({
      format: computedFormat.value,
      ...omit((timePickerProps == null ? void 0 : timePickerProps.value) || {}, ["defaultValue"]),
      visible: panelVisible.value
    }));
    const headerIcons = computed(() => ({
      prev: slots["icon-prev"],
      prevDouble: slots["icon-prev-double"],
      next: slots["icon-next"],
      nextDouble: slots["icon-next-double"]
    }));
    const startHeaderProps = reactive({
      headerValue: startHeaderValue,
      headerOperations: startHeaderOperations,
      headerIcons
    });
    const endHeaderProps = reactive({
      headerValue: endHeaderValue,
      headerOperations: endHeaderOperations,
      headerIcons
    });
    const rangePanelProps = computed(() => ({
      ...pick(props, [
        "mode",
        "showTime",
        "shortcuts",
        "shortcutsPosition",
        "dayStartOfWeek",
        "disabledDate",
        "disabledTime",
        "hideTrigger",
        "abbreviation"
      ]),
      prefixCls,
      format: parseValueFormat.value,
      value: panelValue.value,
      showConfirmBtn: needConfirm.value,
      confirmBtnDisabled: confirmBtnDisabled.value,
      timePickerValue: timePickerValue.value,
      timePickerProps: computedTimePickerProps.value,
      extra: slots.extra,
      dateRender: slots.cell,
      startHeaderProps,
      endHeaderProps,
      footerValue: footerValue.value,
      disabled: disabledArray.value,
      visible: panelVisible.value,
      onCellClick: onPanelCellClick,
      onCellMouseEnter: onPanelCellMouseEnter,
      onShortcutClick: onPanelShortcutClick,
      onShortcutMouseEnter: previewShortcut.value ? onPanelShortcutMouseEnter : void 0,
      onShortcutMouseLeave: previewShortcut.value ? onPanelShortcutMouseLeave : void 0,
      onConfirm: onPanelConfirm,
      onTimePickerSelect,
      startHeaderMode: startHeaderMode.value,
      endHeaderMode: endHeaderMode.value,
      onStartHeaderLabelClick: onStartPanelHeaderLabelClick,
      onEndHeaderLabelClick: onEndPanelHeaderLabelClick,
      onStartHeaderSelect: onStartPanelHeaderSelect,
      onEndHeaderSelect: onEndPanelHeaderSelect
    }));
    return {
      prefixCls,
      refInput,
      computedFormat,
      computedPlaceholder,
      panelVisible,
      panelValue,
      inputValue,
      focusedIndex,
      triggerDisabled,
      mergedSize,
      mergedError,
      onPanelVisibleChange,
      onInputClear,
      onInputChange,
      onInputPressEnter,
      rangePanelProps
    };
  }
});
function _sfc_render$5j(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconCalendar = resolveComponent("IconCalendar");
  const _component_DateRangeInput = resolveComponent("DateRangeInput");
  const _component_RangePickerPanel = resolveComponent("RangePickerPanel");
  const _component_Trigger = resolveComponent("Trigger");
  return !_ctx.hideTrigger ? (openBlock(), createBlock(_component_Trigger, mergeProps({
    key: 0,
    trigger: "click",
    "animation-name": "slide-dynamic-origin",
    "auto-fit-transform-origin": "",
    "click-to-close": false,
    "popup-offset": 4
  }, _ctx.triggerProps, {
    "unmount-on-close": _ctx.unmountOnClose,
    position: _ctx.position,
    disabled: _ctx.triggerDisabled || _ctx.readonly,
    "popup-visible": _ctx.panelVisible,
    "popup-container": _ctx.popupContainer,
    onPopupVisibleChange: _ctx.onPanelVisibleChange
  }), {
    content: withCtx(() => [
      createVNode(_component_RangePickerPanel, normalizeProps(guardReactiveProps(_ctx.rangePanelProps)), null, 16)
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default", {}, () => [
        createVNode(_component_DateRangeInput, mergeProps({ ref: "refInput" }, _ctx.$attrs, {
          focusedIndex: _ctx.focusedIndex,
          "onUpdate:focusedIndex": _cache[0] || (_cache[0] = ($event) => _ctx.focusedIndex = $event),
          size: _ctx.size,
          focused: _ctx.panelVisible,
          visible: _ctx.panelVisible,
          error: _ctx.error,
          disabled: _ctx.disabled,
          readonly: _ctx.readonly || _ctx.disabledInput,
          "allow-clear": _ctx.allowClear && !_ctx.readonly,
          placeholder: _ctx.computedPlaceholder,
          "input-value": _ctx.inputValue,
          value: _ctx.panelValue,
          format: _ctx.computedFormat,
          onClear: _ctx.onInputClear,
          onChange: _ctx.onInputChange,
          onPressEnter: _ctx.onInputPressEnter
        }), createSlots({
          "suffix-icon": withCtx(() => [
            renderSlot(_ctx.$slots, "suffix-icon", {}, () => [
              createVNode(_component_IconCalendar)
            ])
          ]),
          separator: withCtx(() => [
            renderSlot(_ctx.$slots, "separator", {}, () => [
              createTextVNode(toDisplayString(_ctx.separator || "-"), 1)
            ])
          ]),
          _: 2
        }, [
          _ctx.$slots.prefix ? {
            name: "prefix",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "prefix")
            ]),
            key: "0"
          } : void 0
        ]), 1040, ["focusedIndex", "size", "focused", "visible", "error", "disabled", "readonly", "allow-clear", "placeholder", "input-value", "value", "format", "onClear", "onChange", "onPressEnter"])
      ])
    ]),
    _: 3
  }, 16, ["unmount-on-close", "position", "disabled", "popup-visible", "popup-container", "onPopupVisibleChange"])) : (openBlock(), createBlock(_component_RangePickerPanel, normalizeProps(mergeProps({ key: 1 }, { ..._ctx.$attrs, ..._ctx.rangePanelProps })), null, 16));
}
var RangePicker = /* @__PURE__ */ _export_sfc(_sfc_main$5k, [["render", _sfc_render$5j]]);
const DatePicker = Object.assign(_DatePicker, {
  WeekPicker,
  MonthPicker,
  YearPicker,
  QuarterPicker,
  RangePicker,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _DatePicker.name, _DatePicker);
    app.component(componentPrefix + YearPicker.name, YearPicker);
    app.component(componentPrefix + QuarterPicker.name, QuarterPicker);
    app.component(componentPrefix + MonthPicker.name, MonthPicker);
    app.component(componentPrefix + WeekPicker.name, WeekPicker);
    app.component(componentPrefix + RangePicker.name, RangePicker);
  }
});
const responsiveArray = [
  "xxl",
  "xl",
  "lg",
  "md",
  "sm",
  "xs"
];
const responsiveMap = {
  xs: "(max-width: 575px)",
  sm: "(min-width: 576px)",
  md: "(min-width: 768px)",
  lg: "(min-width: 992px)",
  xl: "(min-width: 1200px)",
  xxl: "(min-width: 1600px)"
};
let subscribers = [];
let subUid = -1;
let screens = {};
const responsiveObserve = {
  matchHandlers: {},
  dispatch(pointMap, breakpointChecked) {
    screens = pointMap;
    if (subscribers.length < 1) {
      return false;
    }
    subscribers.forEach((item) => {
      item.func(screens, breakpointChecked);
    });
    return true;
  },
  subscribe(func) {
    if (subscribers.length === 0) {
      this.register();
    }
    const token = (++subUid).toString();
    subscribers.push({
      token,
      func
    });
    func(screens, null);
    return token;
  },
  unsubscribe(token) {
    subscribers = subscribers.filter((item) => item.token !== token);
    if (subscribers.length === 0) {
      this.unregister();
    }
  },
  unregister() {
    Object.keys(responsiveMap).forEach(
      (screen) => {
        const matchMediaQuery = responsiveMap[screen];
        if (!matchMediaQuery)
          return;
        const handler = this.matchHandlers[matchMediaQuery];
        if (handler && handler.mql && handler.listener) {
          if (handler.mql.removeEventListener) {
            handler.mql.removeEventListener("change", handler.listener);
          } else {
            handler.mql.removeListener(handler.listener);
          }
        }
      }
    );
  },
  register() {
    Object.keys(responsiveMap).forEach(
      (screen) => {
        const matchMediaQuery = responsiveMap[screen];
        if (!matchMediaQuery)
          return;
        const listener = ({ matches }) => {
          this.dispatch(
            {
              ...screens,
              [screen]: matches
            },
            screen
          );
        };
        const mql = window.matchMedia(matchMediaQuery);
        if (mql.addEventListener) {
          mql.addEventListener("change", listener);
        } else {
          mql.addListener(listener);
        }
        this.matchHandlers[matchMediaQuery] = {
          mql,
          listener
        };
        listener(mql);
      }
    );
  }
};
function isResponsiveValue(val) {
  return isObject(val);
}
function useResponsiveState(val, defaultVal, fallbackToXs = false) {
  const screens2 = ref({
    xs: true,
    sm: true,
    md: true,
    lg: true,
    xl: true,
    xxl: true
  });
  const result = computed(() => {
    let res = defaultVal;
    if (isResponsiveValue(val.value)) {
      for (let i2 = 0; i2 < responsiveArray.length; i2++) {
        const breakpoint = responsiveArray[i2];
        if ((screens2.value[breakpoint] || breakpoint === "xs" && fallbackToXs) && val.value[breakpoint] !== void 0) {
          res = val.value[breakpoint];
          break;
        }
      }
    } else {
      res = val.value;
    }
    return res;
  });
  let subscribeToken = "";
  onMounted(() => {
    subscribeToken = responsiveObserve.subscribe((screensVal) => {
      if (isResponsiveValue(val.value)) {
        screens2.value = screensVal;
      }
    });
  });
  onUnmounted(() => {
    if (subscribeToken) {
      responsiveObserve.unsubscribe(subscribeToken);
    }
  });
  return result;
}
var _Descriptions = defineComponent({
  name: "Descriptions",
  props: {
    data: {
      type: Array,
      default: () => []
    },
    column: {
      type: [Number, Object],
      default: 3
    },
    title: String,
    layout: {
      type: String,
      default: "horizontal"
    },
    align: {
      type: [String, Object],
      default: "left"
    },
    size: {
      type: String
    },
    bordered: {
      type: Boolean,
      default: false
    },
    labelStyle: {
      type: Object
    },
    valueStyle: {
      type: Object
    },
    tableLayout: {
      type: String,
      default: "auto"
    }
  },
  setup(props, {
    slots
  }) {
    const {
      column,
      size
    } = toRefs(props);
    const prefixCls = getPrefixCls("descriptions");
    const {
      mergedSize
    } = useSize$1(size);
    const computedColumn = useResponsiveState(column, 3, true);
    const labelAlign = computed(() => {
      var _a;
      return (_a = isObject(props.align) ? props.align.label : props.align) != null ? _a : "left";
    });
    const valueAlign = computed(() => {
      var _a;
      return (_a = isObject(props.align) ? props.align.value : props.align) != null ? _a : "left";
    });
    const labelStyle = computed(() => ({
      textAlign: labelAlign.value,
      ...props.labelStyle
    }));
    const valueStyle = computed(() => ({
      textAlign: valueAlign.value,
      ...props.valueStyle
    }));
    const getGroupedData = (data) => {
      const groupedData2 = [];
      let currentRow = [];
      let currentSpan = 0;
      const addRow = () => {
        if (currentRow.length) {
          const restSpan = computedColumn.value - currentSpan;
          currentRow[currentRow.length - 1].span += restSpan;
          groupedData2.push(currentRow);
        }
      };
      data.forEach((item) => {
        var _a, _b;
        const itemSpan = Math.min((_b = isVNode(item) ? (_a = item.props) == null ? void 0 : _a.span : item.span) != null ? _b : 1, computedColumn.value);
        if (currentSpan + itemSpan > computedColumn.value) {
          addRow();
          currentRow = [];
          currentSpan = 0;
        }
        currentRow.push({
          data: item,
          span: itemSpan
        });
        currentSpan += itemSpan;
      });
      addRow();
      return groupedData2;
    };
    const groupedData = computed(() => {
      var _a;
      return getGroupedData((_a = props.data) != null ? _a : []);
    });
    const renderLabel = (item, index2) => {
      var _a, _b, _c, _d, _e;
      if (isVNode(item)) {
        return isSlotsChildren(item, item.children) && ((_b = (_a = item.children).label) == null ? void 0 : _b.call(_a)) || ((_c = item.props) == null ? void 0 : _c.label);
      }
      return (_e = (_d = slots.label) == null ? void 0 : _d.call(slots, {
        label: item.label,
        index: index2,
        data: item
      })) != null ? _e : isFunction(item.label) ? item.label() : item.label;
    };
    const renderValue = (item, index2) => {
      var _a, _b;
      if (isVNode(item)) {
        return item;
      }
      return (_b = (_a = slots.value) == null ? void 0 : _a.call(slots, {
        value: item.value,
        index: index2,
        data: item
      })) != null ? _b : isFunction(item.value) ? item.value() : item.value;
    };
    const renderVerticalItems = (data) => createVNode(Fragment, null, [createVNode("tr", {
      "class": `${prefixCls}-row`
    }, [data.map((item, index2) => createVNode("td", {
      "key": `label-${index2}`,
      "class": [`${prefixCls}-item-label`, `${prefixCls}-item-label-block`],
      "style": labelStyle.value,
      "colspan": item.span
    }, [renderLabel(item.data, index2)]))]), createVNode("tr", {
      "class": `${prefixCls}-row`
    }, [data.map((item, index2) => createVNode("td", {
      "key": `value-${index2}`,
      "class": [`${prefixCls}-item-value`, `${prefixCls}-item-value-block`],
      "style": valueStyle.value,
      "colspan": item.span
    }, [renderValue(item.data, index2)]))])]);
    const renderHorizontalItems = (data, index2) => createVNode("tr", {
      "class": `${prefixCls}-row`,
      "key": `tr-${index2}`
    }, [data.map((item) => createVNode(Fragment, null, [createVNode("td", {
      "class": [`${prefixCls}-item-label`, `${prefixCls}-item-label-block`],
      "style": labelStyle.value
    }, [renderLabel(item.data, index2)]), createVNode("td", {
      "class": [`${prefixCls}-item-value`, `${prefixCls}-item-value-block`],
      "style": valueStyle.value,
      "colspan": item.span * 2 - 1
    }, [renderValue(item.data, index2)])]))]);
    const renderInlineItems = (data, index2) => createVNode("tr", {
      "class": `${prefixCls}-row`,
      "key": `inline-${index2}`
    }, [data.map((item, index22) => createVNode("td", {
      "key": `item-${index22}`,
      "class": `${prefixCls}-item`,
      "colspan": item.span
    }, [createVNode("div", {
      "class": [`${prefixCls}-item-label`, `${prefixCls}-item-label-inline`],
      "style": labelStyle.value
    }, [renderLabel(item.data, index22)]), createVNode("div", {
      "class": [`${prefixCls}-item-value`, `${prefixCls}-item-value-inline`],
      "style": valueStyle.value
    }, [renderValue(item.data, index22)])]))]);
    const renderItems = (data, index2) => {
      if (["inline-horizontal", "inline-vertical"].includes(props.layout)) {
        return renderInlineItems(data, index2);
      }
      if (props.layout === "vertical") {
        return renderVerticalItems(data);
      }
      return renderHorizontalItems(data, index2);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-layout-${props.layout}`, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-border`]: props.bordered
    }, {
      [`${prefixCls}-table-layout-fixed`]: props.tableLayout === "fixed"
    }]);
    const renderTitle = () => {
      var _a, _b;
      const title = (_b = (_a = slots.title) == null ? void 0 : _a.call(slots)) != null ? _b : props.title;
      if (title) {
        return createVNode("div", {
          "class": `${prefixCls}-title`
        }, [title]);
      }
      return null;
    };
    return () => {
      const _groupedData = slots.default ? getGroupedData(getAllElements(slots.default())) : groupedData.value;
      return createVNode("div", {
        "class": cls.value
      }, [renderTitle(), createVNode("div", {
        "class": `${prefixCls}-body`
      }, [createVNode("table", {
        "class": `${prefixCls}-table`
      }, [createVNode("tbody", null, [_groupedData.map((data, index2) => renderItems(data, index2))])])])]);
    };
  }
});
const _sfc_main$5j = defineComponent({
  name: "DescriptionsItem",
  props: {
    span: {
      type: Number,
      default: 1
    },
    label: String
  },
  setup() {
    const prefixCls = getPrefixCls("descriptions");
    return {
      prefixCls
    };
  }
});
function _sfc_render$5i(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var DescriptionsItem = /* @__PURE__ */ _export_sfc(_sfc_main$5j, [["render", _sfc_render$5i]]);
const Descriptions = Object.assign(_Descriptions, {
  DescriptionsItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Descriptions.name, _Descriptions);
    app.component(componentPrefix + DescriptionsItem.name, DescriptionsItem);
  }
});
var _Divider = defineComponent({
  name: "Divider",
  props: {
    direction: {
      type: String,
      default: "horizontal"
    },
    orientation: {
      type: String,
      default: "center"
    },
    type: {
      type: String
    },
    size: {
      type: Number
    },
    margin: {
      type: [Number, String]
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("divider");
    const isHorizontal2 = computed(() => props.direction === "horizontal");
    const mergedStyles = computed(() => {
      const styles = {};
      if (props.size) {
        styles[isHorizontal2.value ? "border-bottom-width" : "border-left-width"] = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.type) {
        styles[isHorizontal2.value ? "border-bottom-style" : "border-left-style"] = props.type;
      }
      if (!isUndefined(props.margin)) {
        const margin = isNumber(props.margin) ? `${props.margin}px` : props.margin;
        styles.margin = isHorizontal2.value ? `${margin} 0` : `0 ${margin}`;
      }
      return styles;
    });
    return () => {
      var _a;
      const children = (_a = slots.default) == null ? void 0 : _a.call(slots);
      const classNames = [prefixCls, `${prefixCls}-${props.direction}`, {
        [`${prefixCls}-with-text`]: children
      }];
      return createVNode("div", {
        "role": "separator",
        "class": classNames,
        "style": mergedStyles.value
      }, [children && props.direction === "horizontal" && createVNode("span", {
        "class": [`${prefixCls}-text`, `${prefixCls}-text-${props.orientation}`]
      }, [children])]);
    };
  }
});
const Divider = Object.assign(_Divider, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Divider.name, _Divider);
  }
});
const useOverflow = (elementRef) => {
  const isSetOverflow = ref(false);
  const originStyle = {
    overflow: "",
    width: "",
    boxSizing: ""
  };
  const setOverflowHidden = () => {
    if (elementRef.value) {
      const element = elementRef.value;
      if (!isSetOverflow.value && element.style.overflow !== "hidden") {
        const scrollBarWidth = getScrollBarWidth(element);
        if (scrollBarWidth > 0 || isScroll(element)) {
          originStyle.overflow = element.style.overflow;
          originStyle.width = element.style.width;
          originStyle.boxSizing = element.style.boxSizing;
          element.style.overflow = "hidden";
          element.style.width = `${element.offsetWidth - scrollBarWidth}px`;
          element.style.boxSizing = "border-box";
          isSetOverflow.value = true;
        }
      }
    }
  };
  const resetOverflow = () => {
    if (elementRef.value && isSetOverflow.value) {
      const element = elementRef.value;
      element.style.overflow = originStyle.overflow;
      element.style.width = originStyle.width;
      element.style.boxSizing = originStyle.boxSizing;
      isSetOverflow.value = false;
    }
  };
  return {
    setOverflowHidden,
    resetOverflow
  };
};
const DRAWER_PLACEMENTS = ["top", "right", "bottom", "left"];
const _sfc_main$5i = defineComponent({
  name: "Drawer",
  components: {
    ClientOnly,
    ArcoButton: Button,
    IconHover,
    IconClose
  },
  inheritAttrs: false,
  props: {
    visible: {
      type: Boolean,
      default: false
    },
    defaultVisible: {
      type: Boolean,
      default: false
    },
    placement: {
      type: String,
      default: "right",
      validator: (value) => DRAWER_PLACEMENTS.includes(value)
    },
    title: String,
    mask: {
      type: Boolean,
      default: true
    },
    maskClosable: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: true
    },
    okText: String,
    cancelText: String,
    okLoading: {
      type: Boolean,
      default: false
    },
    okButtonProps: {
      type: Object
    },
    cancelButtonProps: {
      type: Object
    },
    unmountOnClose: Boolean,
    width: {
      type: [Number, String],
      default: 250
    },
    height: {
      type: [Number, String],
      default: 250
    },
    popupContainer: {
      type: [String, Object],
      default: "body"
    },
    drawerStyle: {
      type: Object
    },
    bodyClass: {
      type: [String, Array]
    },
    bodyStyle: {
      type: [String, Object, Array]
    },
    onBeforeOk: {
      type: Function
    },
    onBeforeCancel: {
      type: Function
    },
    escToClose: {
      type: Boolean,
      default: true
    },
    renderToBody: {
      type: Boolean,
      default: true
    },
    header: {
      type: Boolean,
      default: true
    },
    footer: {
      type: Boolean,
      default: true
    },
    hideCancel: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:visible": (visible) => true,
    "ok": (e) => true,
    "cancel": (e) => true,
    "open": () => true,
    "close": () => true,
    "beforeOpen": () => true,
    "beforeClose": () => true
  },
  setup(props, { emit }) {
    const { popupContainer } = toRefs(props);
    const prefixCls = getPrefixCls("drawer");
    const { t } = useI18n();
    const _visible = ref(props.defaultVisible);
    const computedVisible = computed(() => {
      var _a;
      return (_a = props.visible) != null ? _a : _visible.value;
    });
    const _okLoading = ref(false);
    const mergedOkLoading = computed(() => props.okLoading || _okLoading.value);
    const { teleportContainer, containerRef } = useTeleportContainer({
      popupContainer,
      visible: computedVisible
    });
    const mounted = ref(computedVisible.value);
    let globalKeyDownListener = false;
    const handleGlobalKeyDown = (ev) => {
      if (props.escToClose && ev.key === KEYBOARD_KEY.ESC && isLastDialog()) {
        handleCancel(ev);
      }
    };
    const addGlobalKeyDownListener = () => {
      if (props.escToClose && !globalKeyDownListener) {
        globalKeyDownListener = true;
        on(document.documentElement, "keydown", handleGlobalKeyDown);
      }
    };
    const removeGlobalKeyDownListener = () => {
      if (globalKeyDownListener) {
        globalKeyDownListener = false;
        off(document.documentElement, "keydown", handleGlobalKeyDown);
      }
    };
    const { zIndex, isLastDialog } = usePopupManager("dialog", {
      visible: computedVisible
    });
    const isFixed = computed(() => {
      return (containerRef == null ? void 0 : containerRef.value) === document.body;
    });
    let promiseNumber = 0;
    const close = () => {
      promiseNumber++;
      if (_okLoading.value) {
        _okLoading.value = false;
      }
      _visible.value = false;
      emit("update:visible", false);
    };
    const handleOk = async (e) => {
      const currentPromiseNumber = promiseNumber;
      const closed = await new Promise(
        async (resolve) => {
          var _a;
          if (isFunction(props.onBeforeOk)) {
            let result = props.onBeforeOk((closed2 = true) => resolve(closed2));
            if (isPromise(result) || !isBoolean(result)) {
              _okLoading.value = true;
            }
            if (isPromise(result)) {
              try {
                result = (_a = await result) != null ? _a : true;
              } catch (error) {
                result = false;
                throw error;
              }
            }
            if (isBoolean(result)) {
              resolve(result);
            }
          } else {
            resolve(true);
          }
        }
      );
      if (currentPromiseNumber === promiseNumber) {
        if (closed) {
          emit("ok", e);
          close();
        } else if (_okLoading.value) {
          _okLoading.value = false;
        }
      }
    };
    const handleCancel = (e) => {
      var _a;
      let result = true;
      if (isFunction(props.onBeforeCancel)) {
        result = (_a = props.onBeforeCancel()) != null ? _a : false;
      }
      if (result) {
        emit("cancel", e);
        close();
      }
    };
    const handleMask = (e) => {
      if (props.maskClosable) {
        handleCancel(e);
      }
    };
    const handleOpen = () => {
      if (computedVisible.value) {
        emit("open");
      }
    };
    const handleClose = () => {
      if (!computedVisible.value) {
        mounted.value = false;
        resetOverflow();
        emit("close");
      }
    };
    const { setOverflowHidden, resetOverflow } = useOverflow(containerRef);
    onMounted(() => {
      if (computedVisible.value) {
        mounted.value = true;
        setOverflowHidden();
        addGlobalKeyDownListener();
      }
    });
    onBeforeUnmount(() => {
      resetOverflow();
      removeGlobalKeyDownListener();
    });
    watch(computedVisible, (visible) => {
      if (_visible.value !== visible) {
        _visible.value = visible;
      }
      if (visible) {
        emit("beforeOpen");
        mounted.value = true;
        setOverflowHidden();
        addGlobalKeyDownListener();
      } else {
        emit("beforeClose");
        removeGlobalKeyDownListener();
      }
    });
    const style = computed(() => {
      var _a;
      const style2 = {
        [props.placement]: 0,
        ...(_a = props.drawerStyle) != null ? _a : {}
      };
      if (["right", "left"].includes(props.placement)) {
        style2.width = isNumber(props.width) ? `${props.width}px` : props.width;
      } else {
        style2.height = isNumber(props.height) ? `${props.height}px` : props.height;
      }
      return style2;
    });
    return {
      prefixCls,
      style,
      t,
      mounted,
      computedVisible,
      mergedOkLoading,
      zIndex,
      handleOk,
      handleCancel,
      handleOpen,
      handleClose,
      handleMask,
      isFixed,
      teleportContainer
    };
  }
});
function _sfc_render$5h(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  const _component_arco_button = resolveComponent("arco-button");
  const _component_client_only = resolveComponent("client-only");
  return openBlock(), createBlock(_component_client_only, null, {
    default: withCtx(() => [
      (openBlock(), createBlock(Teleport, {
        to: _ctx.teleportContainer,
        disabled: !_ctx.renderToBody
      }, [
        !_ctx.unmountOnClose || _ctx.computedVisible || _ctx.mounted ? withDirectives((openBlock(), createElementBlock("div", mergeProps({
          key: 0,
          class: `${_ctx.prefixCls}-container`,
          style: _ctx.isFixed ? { zIndex: _ctx.zIndex } : { zIndex: "inherit", position: "absolute" }
        }, _ctx.$attrs), [
          createVNode(Transition, {
            name: "fade-drawer",
            appear: ""
          }, {
            default: withCtx(() => [
              _ctx.mask ? withDirectives((openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass(`${_ctx.prefixCls}-mask`),
                onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleMask && _ctx.handleMask(...args))
              }, null, 2)), [
                [vShow, _ctx.computedVisible]
              ]) : createCommentVNode("v-if", true)
            ]),
            _: 1
          }),
          createVNode(Transition, {
            name: `slide-${_ctx.placement}-drawer`,
            appear: "",
            onAfterEnter: _ctx.handleOpen,
            onAfterLeave: _ctx.handleClose,
            persisted: ""
          }, {
            default: withCtx(() => [
              withDirectives(createBaseVNode("div", {
                class: normalizeClass(_ctx.prefixCls),
                style: normalizeStyle(_ctx.style)
              }, [
                _ctx.header ? (openBlock(), createElementBlock("div", {
                  key: 0,
                  class: normalizeClass(`${_ctx.prefixCls}-header`)
                }, [
                  renderSlot(_ctx.$slots, "header", {}, () => [
                    _ctx.$slots.title || _ctx.title ? (openBlock(), createElementBlock("div", {
                      key: 0,
                      class: normalizeClass(`${_ctx.prefixCls}-title`)
                    }, [
                      renderSlot(_ctx.$slots, "title", {}, () => [
                        createTextVNode(toDisplayString(_ctx.title), 1)
                      ])
                    ], 2)) : createCommentVNode("v-if", true),
                    _ctx.closable ? (openBlock(), createElementBlock("div", {
                      key: 1,
                      tabindex: "-1",
                      role: "button",
                      "aria-label": "Close",
                      class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
                      onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleCancel && _ctx.handleCancel(...args))
                    }, [
                      createVNode(_component_icon_hover, null, {
                        default: withCtx(() => [
                          createVNode(_component_icon_close)
                        ]),
                        _: 1
                      })
                    ], 2)) : createCommentVNode("v-if", true)
                  ])
                ], 2)) : createCommentVNode("v-if", true),
                createBaseVNode("div", {
                  class: normalizeClass([`${_ctx.prefixCls}-body`, _ctx.bodyClass]),
                  style: normalizeStyle(_ctx.bodyStyle)
                }, [
                  renderSlot(_ctx.$slots, "default")
                ], 6),
                _ctx.footer ? (openBlock(), createElementBlock("div", {
                  key: 1,
                  class: normalizeClass(`${_ctx.prefixCls}-footer`)
                }, [
                  renderSlot(_ctx.$slots, "footer", {}, () => [
                    !_ctx.hideCancel ? (openBlock(), createBlock(_component_arco_button, mergeProps({ key: 0 }, _ctx.cancelButtonProps, { onClick: _ctx.handleCancel }), {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.cancelText || _ctx.t("drawer.cancelText")), 1)
                      ]),
                      _: 1
                    }, 16, ["onClick"])) : createCommentVNode("v-if", true),
                    createVNode(_component_arco_button, mergeProps({
                      type: "primary",
                      loading: _ctx.mergedOkLoading
                    }, _ctx.okButtonProps, { onClick: _ctx.handleOk }), {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.okText || _ctx.t("drawer.okText")), 1)
                      ]),
                      _: 1
                    }, 16, ["loading", "onClick"])
                  ])
                ], 2)) : createCommentVNode("v-if", true)
              ], 6), [
                [vShow, _ctx.computedVisible]
              ])
            ]),
            _: 3
          }, 8, ["name", "onAfterEnter", "onAfterLeave"])
        ], 16)), [
          [vShow, _ctx.computedVisible || _ctx.mounted]
        ]) : createCommentVNode("v-if", true)
      ], 8, ["to", "disabled"]))
    ]),
    _: 3
  });
}
var _Drawer = /* @__PURE__ */ _export_sfc(_sfc_main$5i, [["render", _sfc_render$5h]]);
const open$1 = (config, appContext) => {
  let container2 = getOverlay("drawer");
  const handleOk = () => {
    if (vm.component) {
      vm.component.props.visible = false;
    }
    if (isFunction(config.onOk)) {
      config.onOk();
    }
  };
  const handleCancel = () => {
    if (vm.component) {
      vm.component.props.visible = false;
    }
    if (isFunction(config.onCancel)) {
      config.onCancel();
    }
  };
  const handleClose = async () => {
    await nextTick();
    if (container2) {
      render(null, container2);
      document.body.removeChild(container2);
    }
    container2 = null;
    if (isFunction(config.onClose)) {
      config.onClose();
    }
  };
  const handleReturnClose = () => {
    if (vm.component) {
      vm.component.props.visible = false;
    }
  };
  const handleUpdateConfig = (config2) => {
    if (vm.component) {
      Object.entries(config2).forEach(([key, value]) => {
        vm.component.props[key] = value;
      });
    }
  };
  const defaultConfig = {
    visible: true,
    renderToBody: false,
    unmountOnClose: true,
    onOk: handleOk,
    onCancel: handleCancel,
    onClose: handleClose
  };
  const vm = createVNode(
    _Drawer,
    {
      ...defaultConfig,
      ...omit(config, [
        "content",
        "title",
        "footer",
        "visible",
        "unmountOnClose",
        "onOk",
        "onCancel",
        "onClose"
      ]),
      ...{
        header: typeof config.header === "boolean" ? config.header : void 0,
        footer: typeof config.footer === "boolean" ? config.footer : void 0
      }
    },
    {
      default: getSlotFunction(config.content),
      header: typeof config.header !== "boolean" ? getSlotFunction(config.header) : void 0,
      title: getSlotFunction(config.title),
      footer: typeof config.footer !== "boolean" ? getSlotFunction(config.footer) : void 0
    }
  );
  if (appContext != null ? appContext : Drawer._context) {
    vm.appContext = appContext != null ? appContext : Drawer._context;
  }
  render(vm, container2);
  document.body.appendChild(container2);
  return {
    close: handleReturnClose,
    update: handleUpdateConfig
  };
};
const Drawer = Object.assign(_Drawer, {
  open: open$1,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Drawer.name, _Drawer);
    const drawerWithContext = {
      open: (config, appContext = app._context) => open$1(config, appContext)
    };
    app.config.globalProperties.$drawer = drawerWithContext;
  },
  _context: null
});
const VALIDATE_STATUSES = [
  "success",
  "warning",
  "error",
  "validating"
];
const getFinalValidateStatus = (validateStatus) => {
  let status = "";
  for (const key of Object.keys(validateStatus)) {
    const _status = validateStatus[key];
    if (_status) {
      if (!status || VALIDATE_STATUSES.indexOf(_status) > VALIDATE_STATUSES.indexOf(status)) {
        status = validateStatus[key];
      }
    }
  }
  return status;
};
const getFinalValidateMessage = (validateMessage) => {
  const messages = [];
  for (const key of Object.keys(validateMessage)) {
    const _message = validateMessage[key];
    if (_message) {
      messages.push(_message);
    }
  }
  return messages;
};
const getFormElementId = (prefix, field) => {
  const id = field.replace(/[[.]/g, "_").replace(/\]/g, "");
  return prefix ? `${prefix}-${id}` : `${id}`;
};
const _sfc_main$5h = defineComponent({
  name: "Form",
  props: {
    model: {
      type: Object,
      required: true
    },
    layout: {
      type: String,
      default: "horizontal"
    },
    size: {
      type: String
    },
    labelColProps: {
      type: Object,
      default: () => ({ span: 5, offset: 0 })
    },
    wrapperColProps: {
      type: Object,
      default: () => ({ span: 19, offset: 0 })
    },
    labelColStyle: Object,
    wrapperColStyle: Object,
    labelAlign: {
      type: String,
      default: "right"
    },
    disabled: {
      type: Boolean,
      default: void 0
    },
    rules: {
      type: Object
    },
    autoLabelWidth: {
      type: Boolean,
      default: false
    },
    id: {
      type: String
    },
    scrollToFirstError: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    submit: (data, ev) => true,
    submitSuccess: (values, ev) => true,
    submitFailed: (data, ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("form");
    const formRef = ref();
    const {
      id,
      model,
      layout,
      disabled,
      labelAlign,
      labelColProps,
      wrapperColProps,
      labelColStyle,
      wrapperColStyle,
      size,
      rules
    } = toRefs(props);
    const { mergedSize } = useSize$1(size);
    const autoLabelWidth = computed(
      () => props.layout === "horizontal" && props.autoLabelWidth
    );
    const fields = [];
    const touchedFields = [];
    const labelWidth = reactive({});
    const maxLabelWidth = computed(
      () => Math.max(...Object.values(labelWidth))
    );
    const addField = (formItemInfo) => {
      if (formItemInfo && formItemInfo.field) {
        fields.push(formItemInfo);
      }
    };
    const removeField = (formItemInfo) => {
      if (formItemInfo && formItemInfo.field) {
        fields.splice(fields.indexOf(formItemInfo), 1);
      }
    };
    const setFields = (data) => {
      fields.forEach((field) => {
        if (data[field.field]) {
          field.setField(data[field.field]);
        }
      });
    };
    const setLabelWidth = (width, uid) => {
      if (uid && labelWidth[uid] !== width) {
        labelWidth[uid] = width;
      }
    };
    const removeLabelWidth = (uid) => {
      if (uid) {
        delete labelWidth[uid];
      }
    };
    const resetFields = (field) => {
      const _fields = field ? [].concat(field) : [];
      fields.forEach((field2) => {
        if (_fields.length === 0 || _fields.includes(field2.field)) {
          field2.resetField();
        }
      });
    };
    const clearValidate = (field) => {
      const _fields = field ? [].concat(field) : [];
      fields.forEach((field2) => {
        if (_fields.length === 0 || _fields.includes(field2.field)) {
          field2.clearValidate();
        }
      });
    };
    const scrollToField = (field, options) => {
      const node = formRef.value || document.body;
      const fieldNode = node.querySelector(
        `#${getFormElementId(props.id, field)}`
      );
      if (fieldNode) {
        scrollIntoView(fieldNode, {
          behavior: "smooth",
          block: "nearest",
          scrollMode: "if-needed",
          ...options
        });
      }
    };
    const scrollToFirstError = (field) => {
      const options = !isBoolean(props.scrollToFirstError) ? props.scrollToFirstError : void 0;
      scrollToField(field, options);
    };
    const validate = (callback) => {
      const list = [];
      fields.forEach((field) => {
        list.push(field.validate());
      });
      return Promise.all(list).then((result) => {
        const errors = {};
        let hasError = false;
        result.forEach((item) => {
          if (item) {
            hasError = true;
            errors[item.field] = item;
          }
        });
        if (hasError && props.scrollToFirstError) {
          scrollToFirstError(Object.keys(errors)[0]);
        }
        if (isFunction(callback)) {
          callback(hasError ? errors : void 0);
        }
        return hasError ? errors : void 0;
      });
    };
    const validateField = (field, callback) => {
      const list = [];
      for (const ctx of fields) {
        if (isArray(field) && field.includes(ctx.field) || field === ctx.field) {
          list.push(ctx.validate());
        }
      }
      return Promise.all(list).then((result) => {
        const errors = {};
        let hasError = false;
        result.forEach((item) => {
          if (item) {
            hasError = true;
            errors[item.field] = item;
          }
        });
        if (hasError && props.scrollToFirstError) {
          scrollToFirstError(Object.keys(errors)[0]);
        }
        if (isFunction(callback)) {
          callback(hasError ? errors : void 0);
        }
        return hasError ? errors : void 0;
      });
    };
    const handleSubmit = (e) => {
      const list = [];
      fields.forEach((field) => {
        list.push(field.validate());
      });
      Promise.all(list).then((result) => {
        const errors = {};
        let hasError = false;
        result.forEach((item) => {
          if (item) {
            hasError = true;
            errors[item.field] = item;
          }
        });
        if (hasError) {
          props.scrollToFirstError && scrollToFirstError(Object.keys(errors)[0]);
          emit("submitFailed", { values: model.value, errors }, e);
        } else {
          emit("submitSuccess", model.value, e);
        }
        emit(
          "submit",
          { values: model.value, errors: hasError ? errors : void 0 },
          e
        );
      });
    };
    provide(
      formInjectionKey,
      reactive({
        id,
        layout,
        disabled,
        labelAlign,
        labelColProps,
        wrapperColProps,
        labelColStyle,
        wrapperColStyle,
        model,
        size: mergedSize,
        rules,
        fields,
        touchedFields,
        addField,
        removeField,
        validateField,
        setLabelWidth,
        removeLabelWidth,
        maxLabelWidth,
        autoLabelWidth
      })
    );
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-layout-${props.layout}`,
      `${prefixCls}-size-${mergedSize.value}`,
      {
        [`${prefixCls}-auto-label-width`]: props.autoLabelWidth
      }
    ]);
    return {
      cls,
      formRef,
      handleSubmit,
      innerValidate: validate,
      innerValidateField: validateField,
      innerResetFields: resetFields,
      innerClearValidate: clearValidate,
      innerSetFields: setFields,
      innerScrollToField: scrollToField
    };
  },
  methods: {
    validate(callback) {
      return this.innerValidate(callback);
    },
    validateField(field, callback) {
      return this.innerValidateField(field, callback);
    },
    resetFields(field) {
      return this.innerResetFields(field);
    },
    clearValidate(field) {
      return this.innerClearValidate(field);
    },
    setFields(data) {
      return this.innerSetFields(data);
    },
    scrollToField(field) {
      return this.innerScrollToField(field);
    }
  }
});
const _hoisted_1$4g = ["id"];
function _sfc_render$5g(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("form", {
    id: _ctx.id,
    ref: "formRef",
    class: normalizeClass(_ctx.cls),
    onSubmit: _cache[0] || (_cache[0] = withModifiers((...args) => _ctx.handleSubmit && _ctx.handleSubmit(...args), ["prevent"]))
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 42, _hoisted_1$4g);
}
var _Form = /* @__PURE__ */ _export_sfc(_sfc_main$5h, [["render", _sfc_render$5g]]);
const RowContextInjectionKey = Symbol(
  "RowContextInjectionKey"
);
const GridContextInjectionKey = Symbol(
  "GridContextInjectionKey"
);
const GridDataCollectorInjectionKey = Symbol("GridDataCollectorInjectionKey");
const _sfc_main$5g = defineComponent({
  name: "Row",
  props: {
    gutter: {
      type: [Number, Object, Array],
      default: 0
    },
    justify: {
      type: String,
      default: "start"
    },
    align: {
      type: String,
      default: "start"
    },
    div: {
      type: Boolean
    },
    wrap: {
      type: Boolean,
      default: true
    }
  },
  setup(props) {
    const { gutter, align, justify, div, wrap } = toRefs(props);
    const prefixCls = getPrefixCls("row");
    const classNames = computed(() => {
      return {
        [`${prefixCls}`]: !div.value,
        [`${prefixCls}-nowrap`]: !wrap.value,
        [`${prefixCls}-align-${align.value}`]: align.value,
        [`${prefixCls}-justify-${justify.value}`]: justify.value
      };
    });
    const propGutterHorizontal = computed(
      () => Array.isArray(gutter.value) ? gutter.value[0] : gutter.value
    );
    const propGutterVertical = computed(
      () => Array.isArray(gutter.value) ? gutter.value[1] : 0
    );
    const gutterHorizontal = useResponsiveState(propGutterHorizontal, 0);
    const gutterVertical = useResponsiveState(propGutterVertical, 0);
    const styles = computed(() => {
      const result = {};
      if ((gutterHorizontal.value || gutterVertical.value) && !div.value) {
        const marginHorizontal = -gutterHorizontal.value / 2;
        const marginVertical = -gutterVertical.value / 2;
        if (marginHorizontal) {
          result.marginLeft = `${marginHorizontal}px`;
          result.marginRight = `${marginHorizontal}px`;
        }
        if (marginVertical) {
          result.marginTop = `${marginVertical}px`;
          result.marginBottom = `${marginVertical}px`;
        }
      }
      return result;
    });
    const resultGutter = computed(() => [
      gutterHorizontal.value,
      gutterVertical.value
    ]);
    provide(
      RowContextInjectionKey,
      reactive({
        gutter: resultGutter,
        div
      })
    );
    return {
      classNames,
      styles
    };
  }
});
function _sfc_render$5f(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle(_ctx.styles)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var Row = /* @__PURE__ */ _export_sfc(_sfc_main$5g, [["render", _sfc_render$5f]]);
function useResponsiveValue(props) {
  const value = computed(() => {
    const { val, key, xs, sm, md, lg, xl, xxl } = props.value;
    if (!xs && !sm && !md && !lg && !xl && !xxl) {
      return val;
    }
    const result = {};
    responsiveArray.forEach((breakpoint) => {
      const config = props.value[breakpoint];
      if (isNumber(config)) {
        result[breakpoint] = config;
      } else if (isObject(config) && isNumber(config[key])) {
        result[breakpoint] = config[key];
      }
    });
    return result;
  });
  return value;
}
function getAllowableFlexValue(flexValue) {
  if (isString(flexValue) && (["initial", "auto", "none"].includes(flexValue) || /^\d+$/.test(flexValue)) || isNumber(flexValue)) {
    return flexValue;
  }
  if (isString(flexValue) && /^\d+(px|em|rem|%)$/.test(flexValue)) {
    return `0 0 ${flexValue}`;
  }
  return void 0;
}
const _sfc_main$5f = defineComponent({
  name: "Col",
  props: {
    span: {
      type: Number,
      default: 24
    },
    offset: {
      type: Number
    },
    order: {
      type: Number
    },
    xs: {
      type: [Number, Object]
    },
    sm: {
      type: [Number, Object]
    },
    md: {
      type: [Number, Object]
    },
    lg: {
      type: [Number, Object]
    },
    xl: {
      type: [Number, Object]
    },
    xxl: {
      type: [Number, Object]
    },
    flex: {
      type: [Number, String]
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("col");
    const rowContext = inject(RowContextInjectionKey, {});
    const flexValue = computed(() => getAllowableFlexValue(props.flex));
    const mergeClassName = computed(() => {
      const { div } = rowContext;
      const { span: span2, offset, order, xs, sm, md, lg, xl, xxl } = props;
      const result = {
        [`${prefixCls}`]: !div,
        [`${prefixCls}-order-${order}`]: order,
        [`${prefixCls}-${span2}`]: !div && !xs && !sm && !md && !lg && !xl && !xxl,
        [`${prefixCls}-offset-${offset}`]: offset && offset > 0
      };
      const screenList = { xs, sm, md, lg, xl, xxl };
      Object.keys(screenList).forEach((screen) => {
        const screenValue = screenList[screen];
        if (screenValue && isNumber(screenValue)) {
          result[`${prefixCls}-${screen}-${screenValue}`] = true;
        } else if (screenValue && isObject(screenValue)) {
          result[`${prefixCls}-${screen}-${screenValue.span}`] = screenValue.span;
          result[`${prefixCls}-${screen}-offset-${screenValue.offset}`] = screenValue.offset;
          result[`${prefixCls}-${screen}-order-${screenValue.order}`] = screenValue.order;
        }
      });
      return result;
    });
    const classNames = computed(() => {
      return flexValue.value ? prefixCls : mergeClassName.value;
    });
    const paddingStyles = computed(() => {
      const { gutter, div } = rowContext;
      const result = {};
      if (Array.isArray(gutter) && !div) {
        const paddingHorizontal = gutter[0] && gutter[0] / 2 || 0;
        const paddingVertical = gutter[1] && gutter[1] / 2 || 0;
        if (paddingHorizontal) {
          result.paddingLeft = `${paddingHorizontal}px`;
          result.paddingRight = `${paddingHorizontal}px`;
        }
        if (paddingVertical) {
          result.paddingTop = `${paddingVertical}px`;
          result.paddingBottom = `${paddingVertical}px`;
        }
      }
      return result;
    });
    const flexStyles = computed(
      () => flexValue.value ? { flex: flexValue.value } : {}
    );
    const responsiveConfig = computed(() => pick(props, responsiveArray));
    const propSpan = useResponsiveValue(
      computed(() => ({
        val: props.span,
        key: "span",
        ...responsiveConfig.value
      }))
    );
    const span = useResponsiveState(propSpan, 24, true);
    return {
      visible: computed(() => !!span.value),
      classNames,
      styles: computed(() => ({ ...paddingStyles.value, ...flexStyles.value }))
    };
  }
});
function _sfc_render$5e(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.visible ? (openBlock(), createElementBlock("div", {
    key: 0,
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle(_ctx.styles)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6)) : createCommentVNode("v-if", true);
}
var Col = /* @__PURE__ */ _export_sfc(_sfc_main$5f, [["render", _sfc_render$5e]]);
function resolveItemData(cols, props) {
  var _a, _b;
  const originSpan = (_a = props.span) != null ? _a : 1;
  const originOffset = (_b = props.offset) != null ? _b : 0;
  const offset = Math.min(originOffset, cols);
  const span = Math.min(
    offset > 0 ? originSpan + originOffset : originSpan,
    cols
  );
  return {
    span,
    offset,
    suffix: "suffix" in props ? props.suffix !== false : false
  };
}
function setItemVisible({
  cols,
  collapsed,
  collapsedRows,
  itemDataList
}) {
  let overflow = false;
  let displayIndexList = [];
  function isOverflow(span) {
    return Math.ceil(span / cols) > collapsedRows;
  }
  if (collapsed) {
    let spanSum = 0;
    for (let i2 = 0; i2 < itemDataList.length; i2++) {
      if (itemDataList[i2].suffix) {
        spanSum += itemDataList[i2].span;
        displayIndexList.push(i2);
      }
    }
    if (!isOverflow(spanSum)) {
      let current = 0;
      while (current < itemDataList.length) {
        const item = itemDataList[current];
        if (!item.suffix) {
          spanSum += item.span;
          if (isOverflow(spanSum)) {
            break;
          }
          displayIndexList.push(current);
        }
        current++;
      }
    }
    overflow = itemDataList.some(
      (item, index2) => !item.suffix && !displayIndexList.includes(index2)
    );
  } else {
    displayIndexList = itemDataList.map((_, index2) => index2);
  }
  return {
    overflow,
    displayIndexList
  };
}
const _sfc_main$5e = defineComponent({
  name: "Grid",
  props: {
    cols: {
      type: [Number, Object],
      default: 24
    },
    rowGap: {
      type: [Number, Object],
      default: 0
    },
    colGap: {
      type: [Number, Object],
      default: 0
    },
    collapsed: {
      type: Boolean,
      default: false
    },
    collapsedRows: {
      type: Number,
      default: 1
    }
  },
  setup(props) {
    const {
      cols: propCols,
      rowGap: propRowGap,
      colGap: propColGap,
      collapsedRows,
      collapsed
    } = toRefs(props);
    const cols = useResponsiveState(propCols, 24);
    const colGap = useResponsiveState(propColGap, 0);
    const rowGap = useResponsiveState(propRowGap, 0);
    const prefixCls = getPrefixCls("grid");
    const classNames = computed(() => [prefixCls]);
    const style = computed(() => [
      {
        "gap": `${rowGap.value}px ${colGap.value}px`,
        "grid-template-columns": `repeat(${cols.value}, minmax(0px, 1fr))`
      }
    ]);
    const itemDataMap = reactive(/* @__PURE__ */ new Map());
    const itemDataList = computed(() => {
      const list = [];
      for (const [index2, itemData] of itemDataMap.entries()) {
        list[index2] = itemData;
      }
      return list;
    });
    const gridContext = reactive({
      overflow: false,
      displayIndexList: [],
      cols: cols.value,
      colGap: colGap.value
    });
    watchEffect(() => {
      gridContext.cols = cols.value;
      gridContext.colGap = colGap.value;
    });
    watchEffect(() => {
      const displayInfo = setItemVisible({
        cols: cols.value,
        collapsed: collapsed.value,
        collapsedRows: collapsedRows.value,
        itemDataList: itemDataList.value
      });
      gridContext.overflow = displayInfo.overflow;
      gridContext.displayIndexList = displayInfo.displayIndexList;
    });
    provide(GridContextInjectionKey, gridContext);
    provide(GridDataCollectorInjectionKey, {
      collectItemData(index2, itemData) {
        itemDataMap.set(index2, itemData);
      },
      removeItemData(index2) {
        itemDataMap.delete(index2);
      }
    });
    return {
      classNames,
      style
    };
  }
});
function _sfc_render$5d(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle(_ctx.style)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var _Grid = /* @__PURE__ */ _export_sfc(_sfc_main$5e, [["render", _sfc_render$5d]]);
const _sfc_main$5d = defineComponent({
  name: "GridItem",
  props: {
    span: {
      type: [Number, Object],
      default: 1
    },
    offset: {
      type: [Number, Object],
      default: 0
    },
    suffix: {
      type: Boolean,
      default: false
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("grid-item");
    const domRef = ref();
    const { computedIndex } = useIndex({
      itemRef: domRef,
      selector: `.${prefixCls}`
    });
    const gridContext = inject(GridContextInjectionKey, {
      overflow: false,
      displayIndexList: [],
      cols: 24,
      colGap: 0
    });
    const gridDataCollector = inject(GridDataCollectorInjectionKey);
    const visible = computed(
      () => {
        var _a;
        return (_a = gridContext == null ? void 0 : gridContext.displayIndexList) == null ? void 0 : _a.includes(computedIndex.value);
      }
    );
    const { span: propSpan, offset: propOffset } = toRefs(props);
    const rSpan = useResponsiveState(propSpan, 1);
    const rOffset = useResponsiveState(propOffset, 0);
    const itemData = computed(
      () => resolveItemData(gridContext.cols, {
        ...props,
        span: rSpan.value,
        offset: rOffset.value
      })
    );
    const classNames = computed(() => [prefixCls]);
    const offsetStyle = computed(() => {
      const { offset, span } = itemData.value;
      const { colGap } = gridContext;
      if (offset > 0) {
        const oneSpan = `(100% - ${colGap * (span - 1)}px) / ${span}`;
        return {
          "margin-left": `calc((${oneSpan} * ${offset}) + ${colGap * offset}px)`
        };
      }
      return {};
    });
    const columnStart = computed(() => {
      const { suffix, span } = itemData.value;
      const { cols } = gridContext;
      if (suffix) {
        return `${cols - span + 1}`;
      }
      return `span ${span}`;
    });
    const style = computed(() => {
      const { span } = itemData.value;
      if (domRef.value) {
        return [
          {
            "grid-column": `${columnStart.value} / span ${span}`
          },
          offsetStyle.value,
          !visible.value || span === 0 ? { display: "none" } : {}
        ];
      }
      return [];
    });
    watchEffect(() => {
      if (computedIndex.value !== -1) {
        gridDataCollector == null ? void 0 : gridDataCollector.collectItemData(computedIndex.value, itemData.value);
      }
    });
    onUnmounted(() => {
      if (computedIndex.value !== -1) {
        gridDataCollector == null ? void 0 : gridDataCollector.removeItemData(computedIndex.value);
      }
    });
    return {
      classNames,
      style,
      domRef,
      overflow: computed(() => gridContext.overflow)
    };
  }
});
function _sfc_render$5c(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    ref: "domRef",
    class: normalizeClass(_ctx.classNames),
    style: normalizeStyle(_ctx.style)
  }, [
    renderSlot(_ctx.$slots, "default", { overflow: _ctx.overflow })
  ], 6);
}
var GridItem = /* @__PURE__ */ _export_sfc(_sfc_main$5d, [["render", _sfc_render$5c]]);
const Grid = Object.assign(_Grid, {
  Row,
  Col,
  Item: GridItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + Row.name, Row);
    app.component(componentPrefix + Col.name, Col);
    app.component(componentPrefix + _Grid.name, _Grid);
    app.component(componentPrefix + GridItem.name, GridItem);
  }
});
const _sfc_main$5c = defineComponent({
  name: "Tooltip",
  components: {
    Trigger
  },
  props: {
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    content: String,
    position: {
      type: String,
      default: "top"
    },
    mini: {
      type: Boolean,
      default: false
    },
    backgroundColor: {
      type: String
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupContainer: {
      type: [String, Object]
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("tooltip");
    const _popupVisible = ref(props.defaultPopupVisible);
    const computedPopupVisible = computed(
      () => {
        var _a;
        return (_a = props.popupVisible) != null ? _a : _popupVisible.value;
      }
    );
    const handlePopupVisibleChange = (visible) => {
      _popupVisible.value = visible;
      emit("update:popupVisible", visible);
      emit("popupVisibleChange", visible);
    };
    const contentCls = computed(() => [
      `${prefixCls}-content`,
      props.contentClass,
      { [`${prefixCls}-mini`]: props.mini }
    ]);
    const computedContentStyle = computed(() => {
      if (props.backgroundColor || props.contentStyle) {
        return {
          backgroundColor: props.backgroundColor,
          ...props.contentStyle
        };
      }
      return void 0;
    });
    const arrowCls = computed(() => [
      `${prefixCls}-popup-arrow`,
      props.arrowClass
    ]);
    const computedArrowStyle = computed(() => {
      if (props.backgroundColor || props.arrowStyle) {
        return {
          backgroundColor: props.backgroundColor,
          ...props.arrowStyle
        };
      }
      return void 0;
    });
    return {
      prefixCls,
      computedPopupVisible,
      contentCls,
      computedContentStyle,
      arrowCls,
      computedArrowStyle,
      handlePopupVisibleChange
    };
  }
});
function _sfc_render$5b(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Trigger = resolveComponent("Trigger");
  return openBlock(), createBlock(_component_Trigger, {
    class: normalizeClass(_ctx.prefixCls),
    trigger: "hover",
    position: _ctx.position,
    "popup-visible": _ctx.computedPopupVisible,
    "popup-offset": 10,
    "show-arrow": "",
    "content-class": _ctx.contentCls,
    "content-style": _ctx.computedContentStyle,
    "arrow-class": _ctx.arrowCls,
    "arrow-style": _ctx.computedArrowStyle,
    "popup-container": _ctx.popupContainer,
    "animation-name": "zoom-in-fade-out",
    "auto-fit-transform-origin": "",
    role: "tooltip",
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [
      renderSlot(_ctx.$slots, "content", {}, () => [
        createTextVNode(toDisplayString(_ctx.content), 1)
      ])
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 8, ["class", "position", "popup-visible", "content-class", "content-style", "arrow-class", "arrow-style", "popup-container", "onPopupVisibleChange"]);
}
var _Tooltip = /* @__PURE__ */ _export_sfc(_sfc_main$5c, [["render", _sfc_render$5b]]);
const Tooltip = Object.assign(_Tooltip, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Tooltip.name, _Tooltip);
  }
});
const _sfc_main$5b = defineComponent({
  name: "IconQuestionCircle",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-question-circle`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4f = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$5a(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M42 24c0 9.941-8.059 18-18 18S6 33.941 6 24 14.059 6 24 6s18 8.059 18 18Z" }, null, -1),
    createBaseVNode("path", { d: "M24.006 31v4.008m0-6.008L24 28c0-3 3-4 4.78-6.402C30.558 19.195 28.288 15 23.987 15c-4.014 0-5.382 2.548-5.388 4.514v.465" }, null, -1)
  ]), 14, _hoisted_1$4f);
}
var _IconQuestionCircle = /* @__PURE__ */ _export_sfc(_sfc_main$5b, [["render", _sfc_render$5a]]);
const IconQuestionCircle = Object.assign(_IconQuestionCircle, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconQuestionCircle.name, _IconQuestionCircle);
  }
});
const _sfc_main$5a = defineComponent({
  name: "FormItemLabel",
  components: {
    ResizeObserver,
    Tooltip,
    IconQuestionCircle
  },
  props: {
    required: {
      type: Boolean,
      default: false
    },
    showColon: {
      type: Boolean,
      default: false
    },
    component: {
      type: String,
      default: "label"
    },
    asteriskPosition: {
      type: String,
      default: "start"
    },
    tooltip: {
      type: String
    },
    attrs: Object
  },
  setup() {
    const prefixCls = getPrefixCls("form-item-label");
    const formCtx = inject(formInjectionKey, void 0);
    const instance = getCurrentInstance();
    const labelRef = ref();
    const handleResize = () => {
      if (labelRef.value && isNumber(labelRef.value.offsetWidth)) {
        formCtx == null ? void 0 : formCtx.setLabelWidth(labelRef.value.offsetWidth, instance == null ? void 0 : instance.uid);
      }
    };
    onMounted(() => {
      if (labelRef.value && isNumber(labelRef.value.offsetWidth)) {
        formCtx == null ? void 0 : formCtx.setLabelWidth(labelRef.value.offsetWidth, instance == null ? void 0 : instance.uid);
      }
    });
    onBeforeUnmount(() => {
      formCtx == null ? void 0 : formCtx.removeLabelWidth(instance == null ? void 0 : instance.uid);
    });
    return {
      prefixCls,
      labelRef,
      handleResize
    };
  }
});
function _sfc_render$59(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_question_circle = resolveComponent("icon-question-circle");
  const _component_Tooltip = resolveComponent("Tooltip");
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  return openBlock(), createBlock(_component_ResizeObserver, { onResize: _ctx.handleResize }, {
    default: withCtx(() => [
      (openBlock(), createBlock(resolveDynamicComponent(_ctx.component), mergeProps({
        ref: "labelRef",
        class: _ctx.prefixCls
      }, _ctx.attrs), {
        default: withCtx(() => [
          _ctx.required && _ctx.asteriskPosition === "start" ? (openBlock(), createElementBlock("strong", {
            key: 0,
            class: normalizeClass(`${_ctx.prefixCls}-required-symbol`)
          }, _cache[0] || (_cache[0] = [
            createBaseVNode("svg", {
              fill: "currentColor",
              viewBox: "0 0 1024 1024",
              width: "1em",
              height: "1em"
            }, [
              createBaseVNode("path", { d: "M583.338667 17.066667c18.773333 0 34.133333 15.36 34.133333 34.133333v349.013333l313.344-101.888a34.133333 34.133333 0 0 1 43.008 22.016l42.154667 129.706667a34.133333 34.133333 0 0 1-21.845334 43.178667l-315.733333 102.4 208.896 287.744a34.133333 34.133333 0 0 1-7.509333 47.786666l-110.421334 80.213334a34.133333 34.133333 0 0 1-47.786666-7.509334L505.685333 706.218667 288.426667 1005.226667a34.133333 34.133333 0 0 1-47.786667 7.509333l-110.421333-80.213333a34.133333 34.133333 0 0 1-7.509334-47.786667l214.186667-295.253333L29.013333 489.813333a34.133333 34.133333 0 0 1-22.016-43.008l42.154667-129.877333a34.133333 34.133333 0 0 1 43.008-22.016l320.512 104.106667L412.672 51.2c0-18.773333 15.36-34.133333 34.133333-34.133333h136.533334z" })
            ], -1)
          ]), 2)) : createCommentVNode("v-if", true),
          renderSlot(_ctx.$slots, "default"),
          _ctx.tooltip ? (openBlock(), createBlock(_component_Tooltip, {
            key: 1,
            content: _ctx.tooltip
          }, {
            default: withCtx(() => [
              createVNode(_component_icon_question_circle, {
                class: normalizeClass(`${_ctx.prefixCls}-tooltip`)
              }, null, 8, ["class"])
            ]),
            _: 1
          }, 8, ["content"])) : createCommentVNode("v-if", true),
          _ctx.required && _ctx.asteriskPosition === "end" ? (openBlock(), createElementBlock("strong", {
            key: 2,
            class: normalizeClass(`${_ctx.prefixCls}-required-symbol`)
          }, _cache[1] || (_cache[1] = [
            createBaseVNode("svg", {
              fill: "currentColor",
              viewBox: "0 0 1024 1024",
              width: "1em",
              height: "1em"
            }, [
              createBaseVNode("path", { d: "M583.338667 17.066667c18.773333 0 34.133333 15.36 34.133333 34.133333v349.013333l313.344-101.888a34.133333 34.133333 0 0 1 43.008 22.016l42.154667 129.706667a34.133333 34.133333 0 0 1-21.845334 43.178667l-315.733333 102.4 208.896 287.744a34.133333 34.133333 0 0 1-7.509333 47.786666l-110.421334 80.213334a34.133333 34.133333 0 0 1-47.786666-7.509334L505.685333 706.218667 288.426667 1005.226667a34.133333 34.133333 0 0 1-47.786667 7.509333l-110.421333-80.213333a34.133333 34.133333 0 0 1-7.509334-47.786667l214.186667-295.253333L29.013333 489.813333a34.133333 34.133333 0 0 1-22.016-43.008l42.154667-129.877333a34.133333 34.133333 0 0 1 43.008-22.016l320.512 104.106667L412.672 51.2c0-18.773333 15.36-34.133333 34.133333-34.133333h136.533334z" })
            ], -1)
          ]), 2)) : createCommentVNode("v-if", true),
          createTextVNode(" " + toDisplayString(_ctx.showColon ? ":" : ""), 1)
        ]),
        _: 3
      }, 16, ["class"]))
    ]),
    _: 3
  }, 8, ["onResize"]);
}
var FormItemLabel = /* @__PURE__ */ _export_sfc(_sfc_main$5a, [["render", _sfc_render$59]]);
const _sfc_main$59 = defineComponent({
  name: "FormItemMessage",
  props: {
    error: {
      type: Array,
      default: () => []
    },
    help: String
  },
  setup() {
    const prefixCls = getPrefixCls("form-item-message");
    return {
      prefixCls
    };
  }
});
function _sfc_render$58(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.error.length > 0 ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList(_ctx.error, (item) => {
    return openBlock(), createBlock(Transition, {
      key: item,
      name: "form-blink",
      appear: ""
    }, {
      default: withCtx(() => [
        createBaseVNode("div", {
          role: "alert",
          class: normalizeClass([_ctx.prefixCls])
        }, toDisplayString(item), 3)
      ]),
      _: 2
    }, 1024);
  }), 128)) : _ctx.help || _ctx.$slots.help ? (openBlock(), createBlock(Transition, {
    key: 1,
    name: "form-blink",
    appear: ""
  }, {
    default: withCtx(() => [
      createBaseVNode("div", {
        class: normalizeClass([_ctx.prefixCls, `${_ctx.prefixCls}-help`])
      }, [
        renderSlot(_ctx.$slots, "help", {}, () => [
          createTextVNode(toDisplayString(_ctx.help), 1)
        ])
      ], 2)
    ]),
    _: 3
  })) : createCommentVNode("v-if", true);
}
var FormItemMessage = /* @__PURE__ */ _export_sfc(_sfc_main$59, [["render", _sfc_render$58]]);
const _sfc_main$58 = defineComponent({
  name: "FormItem",
  components: {
    ArcoRow: Row,
    ArcoCol: Col,
    FormItemLabel,
    FormItemMessage
  },
  props: {
    field: {
      type: String,
      default: ""
    },
    label: String,
    tooltip: {
      type: String
    },
    showColon: {
      type: Boolean,
      default: false
    },
    noStyle: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: void 0
    },
    help: String,
    extra: String,
    required: {
      type: Boolean,
      default: false
    },
    asteriskPosition: {
      type: String,
      default: "start"
    },
    rules: {
      type: [Object, Array]
    },
    validateStatus: {
      type: String
    },
    validateTrigger: {
      type: [String, Array],
      default: "change"
    },
    labelColProps: Object,
    wrapperColProps: Object,
    hideLabel: {
      type: Boolean,
      default: false
    },
    hideAsterisk: {
      type: Boolean,
      default: false
    },
    labelColStyle: Object,
    wrapperColStyle: Object,
    rowProps: Object,
    rowClass: [String, Array, Object],
    contentClass: [String, Array, Object],
    contentFlex: {
      type: Boolean,
      default: true
    },
    mergeProps: {
      type: [Boolean, Function],
      default: true
    },
    labelColFlex: {
      type: [Number, String]
    },
    feedback: {
      type: Boolean,
      default: false
    },
    labelComponent: {
      type: String,
      default: "label"
    },
    labelAttrs: Object
  },
  setup(props) {
    const prefixCls = getPrefixCls("form-item");
    const { field } = toRefs(props);
    const formCtx = inject(formInjectionKey, {});
    const { autoLabelWidth, layout } = toRefs(formCtx);
    const { i18nMessage } = useI18n();
    const mergedLabelCol = computed(() => {
      var _a;
      const colProps = { ...(_a = props.labelColProps) != null ? _a : formCtx.labelColProps };
      if (props.labelColFlex) {
        colProps.flex = props.labelColFlex;
      } else if (formCtx.autoLabelWidth) {
        colProps.flex = `${formCtx.maxLabelWidth}px`;
      }
      return colProps;
    });
    const mergedWrapperCol = computed(() => {
      var _a;
      const colProps = {
        ...(_a = props.wrapperColProps) != null ? _a : formCtx.wrapperColProps
      };
      if (field.value) {
        colProps.id = getFormElementId(formCtx.id, field.value);
      }
      if (props.labelColFlex || formCtx.autoLabelWidth) {
        colProps.flex = "auto";
      }
      return colProps;
    });
    const mergedLabelStyle = computed(
      () => {
        var _a;
        return (_a = props.labelColStyle) != null ? _a : formCtx.labelColStyle;
      }
    );
    const mergedWrapperStyle = computed(
      () => {
        var _a;
        return (_a = props.wrapperColStyle) != null ? _a : formCtx.wrapperColStyle;
      }
    );
    const initialValue = getValueByPath(formCtx.model, props.field);
    const validateStatus = reactive({});
    const validateMessage = reactive({});
    const finalStatus = computed(() => getFinalValidateStatus(validateStatus));
    const finalMessage = computed(
      () => getFinalValidateMessage(validateMessage)
    );
    const validateDisabled = ref(false);
    const fieldValue = computed(
      () => getValueByPath(formCtx.model, props.field)
    );
    const computedDisabled = computed(
      () => {
        var _a;
        return Boolean((_a = props.disabled) != null ? _a : formCtx == null ? void 0 : formCtx.disabled);
      }
    );
    const computedValidateStatus = computed(
      () => {
        var _a;
        return (_a = props.validateStatus) != null ? _a : finalStatus.value;
      }
    );
    const isError = computed(() => computedValidateStatus.value === "error");
    const mergedRules = computed(() => {
      var _a, _b, _c;
      const baseRules = [].concat(
        (_c = (_b = props.rules) != null ? _b : (_a = formCtx == null ? void 0 : formCtx.rules) == null ? void 0 : _a[props.field]) != null ? _c : []
      );
      const hasRequiredRule = baseRules.some((item) => item.required);
      if (props.required && !hasRequiredRule) {
        return [{ required: true }].concat(baseRules);
      }
      return baseRules;
    });
    const isRequired = computed(
      () => mergedRules.value.some((item) => item.required)
    );
    const formItemCtx = props.noStyle ? inject(formItemInjectionKey, void 0) : void 0;
    const updateValidateState = (field2, { status, message: message2 }) => {
      validateStatus[field2] = status;
      validateMessage[field2] = message2;
      if (props.noStyle) {
        formItemCtx == null ? void 0 : formItemCtx.updateValidateState(field2, { status, message: message2 });
      }
    };
    const computedFeedback = computed(
      () => props.feedback && computedValidateStatus.value ? computedValidateStatus.value : void 0
    );
    const validateField = () => {
      var _a;
      if (validateDisabled.value) {
        return Promise.resolve();
      }
      const rules = mergedRules.value;
      if (!field.value || rules.length === 0) {
        if (finalStatus.value) {
          clearValidate();
        }
        return Promise.resolve();
      }
      const _field = field.value;
      const _value = fieldValue.value;
      updateValidateState(_field, {
        status: "",
        message: ""
      });
      const schema = new Schema(
        {
          [_field]: rules.map(({ ...rule }) => {
            if (!rule.type && !rule.validator) {
              rule.type = "string";
            }
            return rule;
          })
        },
        {
          ignoreEmptyString: true,
          validateMessages: (_a = i18nMessage.value.form) == null ? void 0 : _a.validateMessages
        }
      );
      return new Promise((resolve) => {
        schema.validate({ [_field]: _value }, (err) => {
          var _a2;
          const isError2 = Boolean(err == null ? void 0 : err[_field]);
          updateValidateState(_field, {
            status: isError2 ? "error" : "",
            message: (_a2 = err == null ? void 0 : err[_field].message) != null ? _a2 : ""
          });
          const error = isError2 ? {
            label: props.label,
            field: field.value,
            value: err[_field].value,
            type: err[_field].type,
            isRequiredError: Boolean(err[_field].requiredError),
            message: err[_field].message
          } : void 0;
          resolve(error);
        });
      });
    };
    const validateTriggers = computed(
      () => [].concat(props.validateTrigger)
    );
    const eventHandlers = computed(
      () => validateTriggers.value.reduce((event, trigger) => {
        switch (trigger) {
          case "change":
            event.onChange = () => {
              validateField();
            };
            return event;
          case "input":
            event.onInput = () => {
              nextTick(() => {
                validateField();
              });
            };
            return event;
          case "focus":
            event.onFocus = () => {
              validateField();
            };
            return event;
          case "blur":
            event.onBlur = () => {
              validateField();
            };
            return event;
          default:
            return event;
        }
      }, {})
    );
    provide(
      formItemInjectionKey,
      reactive({
        eventHandlers,
        size: formCtx && toRef(formCtx, "size"),
        disabled: computedDisabled,
        error: isError,
        feedback: computedFeedback,
        updateValidateState
      })
    );
    const clearValidate = () => {
      if (field.value) {
        updateValidateState(field.value, {
          status: "",
          message: ""
        });
      }
    };
    const setField = (data) => {
      var _a, _b;
      if (field.value) {
        validateDisabled.value = true;
        if ("value" in data && (formCtx == null ? void 0 : formCtx.model) && field.value) {
          setValueByPath(formCtx.model, field.value, data.value);
        }
        if (data.status || data.message) {
          updateValidateState(field.value, {
            status: (_a = data.status) != null ? _a : "",
            message: (_b = data.message) != null ? _b : ""
          });
        }
        nextTick(() => {
          validateDisabled.value = false;
        });
      }
    };
    const resetField = () => {
      clearValidate();
      validateDisabled.value = true;
      if ((formCtx == null ? void 0 : formCtx.model) && field.value) {
        setValueByPath(formCtx.model, field.value, initialValue);
      }
      nextTick(() => {
        validateDisabled.value = false;
      });
    };
    const formItemInfo = reactive({
      field,
      disabled: computedDisabled,
      error: isError,
      validate: validateField,
      clearValidate,
      resetField,
      setField
    });
    onMounted(() => {
      var _a;
      if (formItemInfo.field) {
        (_a = formCtx.addField) == null ? void 0 : _a.call(formCtx, formItemInfo);
      }
    });
    onBeforeUnmount(() => {
      var _a;
      if (formItemInfo.field) {
        (_a = formCtx.removeField) == null ? void 0 : _a.call(formCtx, formItemInfo);
      }
    });
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-layout-${formCtx.layout}`,
      {
        [`${prefixCls}-error`]: isError.value,
        [`${prefixCls}-status-${computedValidateStatus.value}`]: Boolean(
          computedValidateStatus.value
        )
      },
      props.rowClass
    ]);
    const labelColCls = computed(() => [
      `${prefixCls}-label-col`,
      {
        [`${prefixCls}-label-col-left`]: formCtx.labelAlign === "left",
        [`${prefixCls}-label-col-flex`]: formCtx.autoLabelWidth || props.labelColFlex
      }
    ]);
    const wrapperColCls = computed(() => [
      `${prefixCls}-wrapper-col`,
      {
        [`${prefixCls}-wrapper-col-flex`]: !mergedWrapperCol.value
      }
    ]);
    return {
      prefixCls,
      cls,
      isRequired,
      isError,
      finalMessage,
      mergedLabelCol,
      mergedWrapperCol,
      labelColCls,
      autoLabelWidth,
      layout,
      mergedLabelStyle,
      wrapperColCls,
      mergedWrapperStyle
    };
  }
});
function _sfc_render$57(_ctx, _cache, $props, $setup, $data, $options) {
  var _a;
  const _component_FormItemLabel = resolveComponent("FormItemLabel");
  const _component_ArcoCol = resolveComponent("ArcoCol");
  const _component_FormItemMessage = resolveComponent("FormItemMessage");
  const _component_ArcoRow = resolveComponent("ArcoRow");
  return _ctx.noStyle ? renderSlot(_ctx.$slots, "default", { key: 0 }) : (openBlock(), createBlock(_component_ArcoRow, mergeProps({
    key: 1,
    class: [
      _ctx.cls,
      {
        [`${_ctx.prefixCls}-has-help`]: Boolean((_a = _ctx.$slots.help) != null ? _a : _ctx.help)
      }
    ],
    wrap: !(_ctx.labelColFlex || _ctx.autoLabelWidth),
    div: _ctx.layout !== "horizontal" || _ctx.hideLabel
  }, _ctx.rowProps), {
    default: withCtx(() => [
      !_ctx.hideLabel ? (openBlock(), createBlock(_component_ArcoCol, mergeProps({
        key: 0,
        class: _ctx.labelColCls,
        style: _ctx.mergedLabelStyle
      }, _ctx.mergedLabelCol), {
        default: withCtx(() => [
          createVNode(_component_FormItemLabel, {
            required: _ctx.hideAsterisk ? false : _ctx.isRequired,
            "show-colon": _ctx.showColon,
            "asterisk-position": _ctx.asteriskPosition,
            component: _ctx.labelComponent,
            attrs: _ctx.labelAttrs,
            tooltip: _ctx.tooltip
          }, {
            default: withCtx(() => [
              _ctx.$slots.label || _ctx.label ? renderSlot(_ctx.$slots, "label", { key: 0 }, () => [
                createTextVNode(toDisplayString(_ctx.label), 1)
              ]) : createCommentVNode("v-if", true)
            ]),
            _: 3
          }, 8, ["required", "show-colon", "asterisk-position", "component", "attrs", "tooltip"])
        ]),
        _: 3
      }, 16, ["class", "style"])) : createCommentVNode("v-if", true),
      createVNode(_component_ArcoCol, mergeProps({
        class: _ctx.wrapperColCls,
        style: _ctx.mergedWrapperStyle
      }, _ctx.mergedWrapperCol), {
        default: withCtx(() => [
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-content-wrapper`)
          }, [
            createBaseVNode("div", {
              class: normalizeClass([
                `${_ctx.prefixCls}-content`,
                {
                  [`${_ctx.prefixCls}-content-flex`]: _ctx.contentFlex
                },
                _ctx.contentClass
              ])
            }, [
              renderSlot(_ctx.$slots, "default")
            ], 2)
          ], 2),
          _ctx.isError || _ctx.$slots.help || _ctx.help ? (openBlock(), createBlock(_component_FormItemMessage, {
            key: 0,
            error: _ctx.finalMessage,
            help: _ctx.help
          }, createSlots({ _: 2 }, [
            _ctx.$slots.help ? {
              name: "help",
              fn: withCtx(() => [
                renderSlot(_ctx.$slots, "help")
              ]),
              key: "0"
            } : void 0
          ]), 1032, ["error", "help"])) : createCommentVNode("v-if", true),
          _ctx.$slots.extra || _ctx.extra ? (openBlock(), createElementBlock("div", {
            key: 1,
            class: normalizeClass(`${_ctx.prefixCls}-extra`)
          }, [
            renderSlot(_ctx.$slots, "extra", {}, () => [
              createTextVNode(toDisplayString(_ctx.extra), 1)
            ])
          ], 2)) : createCommentVNode("v-if", true)
        ]),
        _: 3
      }, 16, ["class", "style"])
    ]),
    _: 3
  }, 16, ["class", "wrap", "div"]));
}
var FormItem = /* @__PURE__ */ _export_sfc(_sfc_main$58, [["render", _sfc_render$57]]);
const Form = Object.assign(_Form, {
  Item: FormItem,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Form.name, _Form);
    app.component(componentPrefix + FormItem.name, FormItem);
  }
});
const _sfc_main$57 = defineComponent({
  name: "Icon",
  props: {
    type: String,
    size: [Number, String],
    rotate: Number,
    spin: Boolean
  },
  setup(props) {
    const prefixCls = getPrefixCls("icon");
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-loading`]: props.spin
      },
      props.type
    ]);
    return {
      cls,
      innerStyle
    };
  }
});
function _sfc_render$56(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    fill: "currentColor"
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 6);
}
var _Icon = /* @__PURE__ */ _export_sfc(_sfc_main$57, [["render", _sfc_render$56]]);
function _isSlot$c(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
const scriptUrlCache = [];
const addFromIconFontCn = (options) => {
  const {
    src,
    extraProps = {}
  } = options;
  if (!isServerRendering && (src == null ? void 0 : src.length) && !scriptUrlCache.includes(src)) {
    const script = document.createElement("script");
    script.setAttribute("src", src);
    script.setAttribute("data-namespace", src);
    scriptUrlCache.push(src);
    document.body.appendChild(script);
  }
  return defineComponent({
    name: "IconFont",
    props: {
      type: String,
      size: [Number, String],
      rotate: Number,
      spin: Boolean
    },
    setup(props, {
      slots
    }) {
      return () => {
        var _a;
        const children = props.type ? createVNode("use", {
          "xlink:href": `#${props.type}`
        }, null) : (_a = slots.default) == null ? void 0 : _a.call(slots);
        return createVNode(_Icon, mergeProps(props, extraProps), _isSlot$c(children) ? children : {
          default: () => [children]
        });
      };
    }
  });
};
const Icon = Object.assign(_Icon, {
  addFromIconFontCn,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Icon.name, _Icon);
  }
});
const _sfc_main$56 = defineComponent({
  name: "ImageFooter",
  props: {
    title: {
      type: String
    },
    description: {
      type: String
    }
  },
  setup() {
    const prefixCls = getPrefixCls("image-footer");
    return {
      prefixCls
    };
  }
});
const _hoisted_1$4e = ["title"];
const _hoisted_2$3 = ["title"];
function _sfc_render$55(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    _ctx.title || _ctx.description ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-caption`)
    }, [
      _ctx.title ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-caption-title`),
        title: _ctx.title
      }, toDisplayString(_ctx.title), 11, _hoisted_1$4e)) : createCommentVNode("v-if", true),
      _ctx.description ? (openBlock(), createElementBlock("div", {
        key: 1,
        class: normalizeClass(`${_ctx.prefixCls}-caption-description`),
        title: _ctx.description
      }, toDisplayString(_ctx.description), 11, _hoisted_2$3)) : createCommentVNode("v-if", true)
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.$slots.extra ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-extra`)
    }, [
      renderSlot(_ctx.$slots, "extra")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var ImageFooter = /* @__PURE__ */ _export_sfc(_sfc_main$56, [["render", _sfc_render$55]]);
const _sfc_main$55 = defineComponent({
  name: "ImagePreviewArrow",
  components: {
    IconLeft,
    IconRight
  },
  props: {
    onPrev: {
      type: Function
    },
    onNext: {
      type: Function
    }
  },
  setup() {
    const prefixCls = getPrefixCls("image-preview-arrow");
    return {
      prefixCls
    };
  }
});
function _sfc_render$54(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_left = resolveComponent("icon-left");
  const _component_icon_right = resolveComponent("icon-right");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    createBaseVNode("div", {
      class: normalizeClass([
        `${_ctx.prefixCls}-left`,
        {
          [`${_ctx.prefixCls}-disabled`]: !_ctx.onPrev
        }
      ]),
      onClick: _cache[0] || (_cache[0] = (e) => {
        e.preventDefault();
        _ctx.onPrev && _ctx.onPrev();
      })
    }, [
      createVNode(_component_icon_left)
    ], 2),
    createBaseVNode("div", {
      class: normalizeClass([
        `${_ctx.prefixCls}-right`,
        {
          [`${_ctx.prefixCls}-disabled`]: !_ctx.onNext
        }
      ]),
      onClick: _cache[1] || (_cache[1] = (e) => {
        e.preventDefault();
        _ctx.onNext && _ctx.onNext();
      })
    }, [
      createVNode(_component_icon_right)
    ], 2)
  ], 2);
}
var PreviewArrow = /* @__PURE__ */ _export_sfc(_sfc_main$55, [["render", _sfc_render$54]]);
function _isSlot$b(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var ImagePreviewAction = defineComponent({
  name: "ImagePreviewAction",
  components: {
    Tooltip
  },
  inheritAttrs: false,
  props: {
    name: {
      type: String
    },
    disabled: {
      type: Boolean
    }
  },
  setup(props, {
    slots,
    attrs
  }) {
    const prefixCls = getPrefixCls("image-preview-toolbar-action");
    return () => {
      var _a;
      const {
        name,
        disabled
      } = props;
      const children = (_a = slots.default) == null ? void 0 : _a.call(slots);
      if (!children || !children.length)
        return null;
      const content = createVNode("div", mergeProps({
        "class": [`${prefixCls}`, {
          [`${prefixCls}-disabled`]: disabled
        }],
        "onMousedown": (e) => {
          e.preventDefault();
        }
      }, attrs), [createVNode("span", {
        "class": `${prefixCls}-content`
      }, [children])]);
      return name ? createVNode(Tooltip, {
        "class": `${prefixCls}-tooltip`,
        "content": name
      }, _isSlot$b(content) ? content : {
        default: () => [content]
      }) : content;
    };
  }
});
var _sfc_main$54 = defineComponent({
  name: "ImagePreviewToolbar",
  components: {
    RenderFunction,
    PreviewAction: ImagePreviewAction
  },
  props: {
    actions: {
      type: Array,
      default: () => []
    },
    actionsLayout: {
      type: Array,
      default: () => []
    }
  },
  setup(props) {
    const {
      actions,
      actionsLayout
    } = toRefs(props);
    const prefixCls = getPrefixCls("image-preview-toolbar");
    const resultActions = computed(() => {
      const actionsLayoutSet = new Set(actionsLayout.value);
      const filterWithLayout = (item) => actionsLayoutSet.has(item.key);
      const filteredActions = actions.value.filter(filterWithLayout);
      return filteredActions.sort((pre, cur) => {
        const preIndex = actionsLayout.value.indexOf(pre.key);
        const curIndex = actionsLayout.value.indexOf(cur.key);
        return preIndex > curIndex ? 1 : -1;
      });
    });
    return {
      prefixCls,
      resultActions
    };
  }
});
function _sfc_render$53(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_RenderFunction = resolveComponent("RenderFunction");
  const _component_PreviewAction = resolveComponent("PreviewAction");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.resultActions, (action) => {
      return openBlock(), createBlock(_component_PreviewAction, {
        key: action.key,
        name: action.name,
        disabled: action.disabled,
        onClick: action.onClick
      }, {
        default: withCtx(() => [
          createVNode(_component_RenderFunction, {
            "render-func": action.content
          }, null, 8, ["render-func"])
        ]),
        _: 2
      }, 1032, ["name", "disabled", "onClick"]);
    }), 128)),
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var PreviewToolbar = /* @__PURE__ */ _export_sfc(_sfc_main$54, [["render", _sfc_render$53]]);
function useImageLoadStatus(defaultValue) {
  const status = ref(defaultValue || "beforeLoad");
  const isBeforeLoad = computed(() => status.value === "beforeLoad");
  const isLoading = computed(() => status.value === "loading");
  const isError = computed(() => status.value === "error");
  const isLoaded = computed(() => status.value === "loaded");
  return {
    status,
    isBeforeLoad,
    isLoading,
    isError,
    isLoaded,
    setLoadStatus: (newStatus) => {
      status.value = newStatus;
    }
  };
}
function getFixTranslate(wrapperRect, imgRect, translateX, translateY, scale) {
  let fixTranslateX = translateX;
  let fixTranslateY = translateY;
  if (translateX) {
    if (wrapperRect.width > imgRect.width) {
      fixTranslateX = 0;
    } else {
      if (imgRect.left > wrapperRect.left) {
        fixTranslateX -= Math.abs(wrapperRect.left - imgRect.left) / scale;
      }
      if (imgRect.right < wrapperRect.right) {
        fixTranslateX += Math.abs(wrapperRect.right - imgRect.right) / scale;
      }
    }
  }
  if (translateY) {
    if (wrapperRect.height > imgRect.height) {
      fixTranslateY = 0;
    } else {
      if (imgRect.top > wrapperRect.top) {
        fixTranslateY -= Math.abs(wrapperRect.top - imgRect.top) / scale;
      }
      if (imgRect.bottom < wrapperRect.bottom) {
        fixTranslateY += Math.abs(wrapperRect.bottom - imgRect.bottom) / scale;
      }
    }
  }
  return [fixTranslateX, fixTranslateY];
}
function useImageDrag(props) {
  const { wrapperEl, imageEl, scale } = toRefs(props);
  const translate = ref([0, 0]);
  const moving = ref(false);
  let startPageX = 0;
  let startPageY = 0;
  let startTranslate = [0, 0];
  const checkAndFixTranslate = () => {
    if (!wrapperEl.value || !imageEl.value)
      return;
    const wrapperRect = wrapperEl.value.getBoundingClientRect();
    const imgRect = imageEl.value.getBoundingClientRect();
    const [x, y] = getFixTranslate(
      wrapperRect,
      imgRect,
      translate.value[0],
      translate.value[1],
      scale.value
    );
    if (x !== translate.value[0] || y !== translate.value[1]) {
      translate.value = [x, y];
    }
  };
  const onMoving = (e) => {
    e.preventDefault && e.preventDefault();
    const nextX = startTranslate[0] + (e.pageX - startPageX) / scale.value;
    const nextY = startTranslate[1] + (e.pageY - startPageY) / scale.value;
    translate.value = [nextX, nextY];
  };
  const onMoveEnd = (e) => {
    e.preventDefault && e.preventDefault();
    moving.value = false;
    checkAndFixTranslate();
    offEvents();
  };
  const onMoveStart = (e) => {
    if (e.target !== e.currentTarget)
      return;
    e.preventDefault && e.preventDefault();
    moving.value = true;
    startPageX = e.pageX;
    startPageY = e.pageY;
    startTranslate = [...translate.value];
    on(window, "mousemove", onMoving, false);
    on(window, "mouseup", onMoveEnd, false);
  };
  function offEvents() {
    off(window, "mousemove", onMoving, false);
    off(window, "mouseup", onMoveEnd, false);
  }
  watchEffect((onInvalidate) => {
    imageEl.value && on(imageEl.value, "mousedown", onMoveStart);
    onInvalidate(() => {
      imageEl.value && off(imageEl.value, "mousedown", onMoveStart);
      offEvents();
    });
  });
  watch([scale], () => {
    nextTick(() => checkAndFixTranslate());
  });
  return {
    translate,
    moving,
    resetTranslate() {
      translate.value = [0, 0];
    }
  };
}
const _sfc_main$53 = defineComponent({
  name: "IconZoomOut",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-zoom-out`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4d = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$52(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M32.607 32.607A14.953 14.953 0 0 0 37 22c0-8.284-6.716-15-15-15-8.284 0-15 6.716-15 15 0 8.284 6.716 15 15 15 4.142 0 7.892-1.679 10.607-4.393Zm0 0L41.5 41.5M29 22H15" }, null, -1)
  ]), 14, _hoisted_1$4d);
}
var _IconZoomOut = /* @__PURE__ */ _export_sfc(_sfc_main$53, [["render", _sfc_render$52]]);
const IconZoomOut = Object.assign(_IconZoomOut, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconZoomOut.name, _IconZoomOut);
  }
});
const _sfc_main$52 = defineComponent({
  name: "IconZoomIn",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-zoom-in`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4c = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$51(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M32.607 32.607A14.953 14.953 0 0 0 37 22c0-8.284-6.716-15-15-15-8.284 0-15 6.716-15 15 0 8.284 6.716 15 15 15 4.142 0 7.892-1.679 10.607-4.393Zm0 0L41.5 41.5M29 22H15m7 7V15" }, null, -1)
  ]), 14, _hoisted_1$4c);
}
var _IconZoomIn = /* @__PURE__ */ _export_sfc(_sfc_main$52, [["render", _sfc_render$51]]);
const IconZoomIn = Object.assign(_IconZoomIn, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconZoomIn.name, _IconZoomIn);
  }
});
const _sfc_main$51 = defineComponent({
  name: "IconFullscreen",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-fullscreen`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4b = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$50(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M42 17V9a1 1 0 0 0-1-1h-8M6 17V9a1 1 0 0 1 1-1h8m27 23v8a1 1 0 0 1-1 1h-8M6 31v8a1 1 0 0 0 1 1h8" }, null, -1)
  ]), 14, _hoisted_1$4b);
}
var _IconFullscreen = /* @__PURE__ */ _export_sfc(_sfc_main$51, [["render", _sfc_render$50]]);
const IconFullscreen = Object.assign(_IconFullscreen, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconFullscreen.name, _IconFullscreen);
  }
});
const _sfc_main$50 = defineComponent({
  name: "IconRotateLeft",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-rotate-left`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$4a = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4$(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M10 22a1 1 0 0 1 1-1h20a1 1 0 0 1 1 1v16a1 1 0 0 1-1 1H11a1 1 0 0 1-1-1V22ZM23 11h11a6 6 0 0 1 6 6v6M22.5 12.893 19.587 11 22.5 9.107v3.786Z" }, null, -1)
  ]), 14, _hoisted_1$4a);
}
var _IconRotateLeft = /* @__PURE__ */ _export_sfc(_sfc_main$50, [["render", _sfc_render$4$]]);
const IconRotateLeft = Object.assign(_IconRotateLeft, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconRotateLeft.name, _IconRotateLeft);
  }
});
const _sfc_main$4$ = defineComponent({
  name: "IconRotateRight",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-rotate-right`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$49 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4_(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M38 22a1 1 0 0 0-1-1H17a1 1 0 0 0-1 1v16a1 1 0 0 0 1 1h20a1 1 0 0 0 1-1V22ZM25 11H14a6 6 0 0 0-6 6v6M25.5 12.893 28.413 11 25.5 9.107v3.786Z" }, null, -1)
  ]), 14, _hoisted_1$49);
}
var _IconRotateRight = /* @__PURE__ */ _export_sfc(_sfc_main$4$, [["render", _sfc_render$4_]]);
const IconRotateRight = Object.assign(_IconRotateRight, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconRotateRight.name, _IconRotateRight);
  }
});
const _sfc_main$4_ = defineComponent({
  name: "IconOriginalSize",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-original-size`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$48 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4Z(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "m5.5 11.5 5-2.5h1v32M34 11.5 39 9h1v32" }, null, -1),
    createBaseVNode("path", {
      d: "M24 17h1v1h-1v-1ZM24 30h1v1h-1v-1Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1),
    createBaseVNode("path", { d: "M24 17h1v1h-1v-1ZM24 30h1v1h-1v-1Z" }, null, -1)
  ]), 14, _hoisted_1$48);
}
var _IconOriginalSize = /* @__PURE__ */ _export_sfc(_sfc_main$4_, [["render", _sfc_render$4Z]]);
const IconOriginalSize = Object.assign(_IconOriginalSize, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconOriginalSize.name, _IconOriginalSize);
  }
});
function usePopupOverflowHidden(props) {
  const { container: container2, hidden } = toRefs(props);
  let needResetContainerStyle = false;
  let originContainerStyle = {};
  const getScrollBarWidth2 = (element) => {
    return element.tagName === "BODY" ? window.innerWidth - (document.body.clientWidth || document.documentElement.clientWidth) : element.offsetWidth - element.clientWidth;
  };
  const setContainerStyle = () => {
    if (container2.value && container2.value.style.overflow !== "hidden") {
      const originStyle = container2.value.style;
      needResetContainerStyle = true;
      const containerScrollBarWidth = getScrollBarWidth2(container2.value);
      if (containerScrollBarWidth) {
        originContainerStyle.width = originStyle.width;
        container2.value.style.width = `calc(${container2.value.style.width || "100%"} - ${containerScrollBarWidth}px)`;
      }
      originContainerStyle.overflow = originStyle.overflow;
      container2.value.style.overflow = "hidden";
    }
  };
  const resetContainerStyle = () => {
    if (container2.value && needResetContainerStyle) {
      const originStyle = originContainerStyle;
      Object.keys(originStyle).forEach((i2) => {
        container2.value.style[i2] = originStyle[i2];
      });
    }
    needResetContainerStyle = false;
    originContainerStyle = {};
  };
  watchEffect((onInvalidate) => {
    hidden.value ? setContainerStyle() : resetContainerStyle();
    onInvalidate(() => {
      resetContainerStyle();
    });
  });
  return [resetContainerStyle, setContainerStyle];
}
function usePopupContainer(defaultPopupContainer, props) {
  const { popupContainer } = toRefs(props);
  const container2 = computed(
    () => (isString(popupContainer.value) ? querySelector(popupContainer.value) : popupContainer.value) || defaultPopupContainer
  );
  return container2;
}
const scaleAttr = [
  25,
  33,
  50,
  67,
  75,
  80,
  90,
  100,
  110,
  125,
  150,
  175,
  200,
  250,
  300,
  400,
  500
].map((item) => +(item / 100).toFixed(2));
const minScale = scaleAttr[0];
const maxScale = scaleAttr[scaleAttr.length - 1];
function getScale(cur = 1, type = "zoomIn") {
  let index2 = scaleAttr.indexOf(cur);
  if (index2 === -1) {
    index2 = findClosestIndex(cur);
  }
  if (type === "zoomIn") {
    return index2 === scaleAttr.length - 1 ? cur : scaleAttr[index2 + 1];
  }
  return index2 === 0 ? cur : scaleAttr[index2 - 1];
}
function getScaleByRate(scale, rate = 1.1, type = "zoomIn") {
  const scaleFactor = type === "zoomIn" ? rate : 1 / rate;
  const newScale = Number.parseFloat((scale * scaleFactor).toFixed(3));
  return Math.min(maxScale, Math.max(minScale, newScale));
}
function findClosestIndex(scale) {
  let closestIndex = scaleAttr.length - 1;
  for (let i2 = 0; i2 < scaleAttr.length; i2++) {
    const current = scaleAttr[i2];
    if (scale === current) {
      closestIndex = i2;
      break;
    }
    if (scale < current) {
      const pre = scaleAttr[i2 - 1];
      closestIndex = pre === void 0 || Math.abs(pre - scale) <= Math.abs(current - scale) ? i2 - 1 : i2;
      break;
    }
  }
  return closestIndex;
}
const ROTATE_STEP = 90;
var _sfc_main$4Z = defineComponent({
  name: "ImagePreview",
  components: {
    PreviewArrow,
    PreviewToolbar,
    IconLoading,
    IconClose
  },
  props: {
    renderToBody: {
      type: Boolean,
      default: true
    },
    src: {
      type: String
    },
    visible: {
      type: Boolean,
      default: void 0
    },
    defaultVisible: {
      type: Boolean,
      default: false
    },
    maskClosable: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: true
    },
    actionsLayout: {
      type: Array,
      default: () => ["fullScreen", "rotateRight", "rotateLeft", "zoomIn", "zoomOut", "originalSize"]
    },
    popupContainer: {
      type: [Object, String]
    },
    inGroup: {
      type: Boolean,
      default: false
    },
    groupArrowProps: {
      type: Object,
      default: () => ({})
    },
    escToClose: {
      type: Boolean,
      default: true
    },
    wheelZoom: {
      type: Boolean,
      default: true
    },
    keyboard: {
      type: Boolean,
      default: true
    },
    defaultScale: {
      type: Number,
      default: 1
    },
    zoomRate: {
      type: Number,
      default: 1.1
    }
  },
  emits: [
    "close",
    "update:visible"
  ],
  setup(props, {
    emit
  }) {
    const {
      t
    } = useI18n();
    const {
      src,
      popupContainer,
      visible,
      defaultVisible,
      maskClosable,
      actionsLayout,
      defaultScale,
      zoomRate
    } = toRefs(props);
    const refWrapper = ref();
    const refImage = ref();
    const prefixCls = getPrefixCls("image-preview");
    const [mergedVisible, setVisible] = useMergeState(defaultVisible.value, reactive({
      value: visible
    }));
    const classNames = computed(() => [prefixCls, {
      [`${prefixCls}-hide`]: !mergedVisible.value
    }]);
    const container2 = usePopupContainer(document.body, reactive({
      popupContainer
    }));
    const isFixed = computed(() => container2.value === document.body);
    const {
      zIndex
    } = usePopupManager("dialog", {
      visible: mergedVisible
    });
    const wrapperStyles = computed(() => {
      const positionStyles = isFixed.value ? {
        zIndex: zIndex.value,
        position: "fixed"
      } : {
        zIndex: "inherit",
        position: "absolute"
      };
      return {
        ...positionStyles
      };
    });
    const {
      isLoading,
      isLoaded,
      setLoadStatus
    } = useImageLoadStatus();
    const rotate = ref(0);
    const scale = ref(defaultScale.value);
    const {
      translate,
      moving,
      resetTranslate
    } = useImageDrag(reactive({
      wrapperEl: refWrapper,
      imageEl: refImage,
      visible: mergedVisible,
      scale
    }));
    const scaleValueVisible = ref(false);
    let hideScaleTimer = null;
    const showScaleValue = () => {
      !scaleValueVisible.value && (scaleValueVisible.value = true);
      hideScaleTimer && clearTimeout(hideScaleTimer);
      hideScaleTimer = setTimeout(() => {
        scaleValueVisible.value = false;
      }, 1e3);
    };
    usePopupOverflowHidden(reactive({
      container: container2,
      hidden: mergedVisible
    }));
    function reset() {
      rotate.value = 0;
      scale.value = defaultScale.value;
      resetTranslate();
    }
    const isIncludes = (action) => actionsLayout.value.includes(action);
    const handleKeyDown = (ev) => {
      ev.stopPropagation();
      ev.preventDefault();
      switch (ev.key) {
        case KEYBOARD_KEY.ESC:
          props.escToClose && close();
          break;
        case KEYBOARD_KEY.ARROW_LEFT:
          props.groupArrowProps.onPrev && props.groupArrowProps.onPrev();
          break;
        case KEYBOARD_KEY.ARROW_RIGHT:
          props.groupArrowProps.onNext && props.groupArrowProps.onNext();
          break;
        case KEYBOARD_KEY.ARROW_UP:
          isIncludes("zoomIn") && handleScale("zoomIn");
          break;
        case KEYBOARD_KEY.ARROW_DOWN:
          isIncludes("zoomOut") && handleScale("zoomOut");
          break;
        case KEYBOARD_KEY.SPACE:
          isIncludes("originalSize") && changeScale(1);
          break;
      }
    };
    const onWheel = throttleByRaf((e) => {
      e.preventDefault();
      e.stopPropagation();
      if (!props.wheelZoom)
        return;
      const delta = e.deltaY || e.deltaX;
      const action = delta > 0 ? "zoomOut" : "zoomIn";
      const newScale = getScaleByRate(scale.value, zoomRate.value, action);
      changeScale(newScale);
    });
    let globalKeyDownListener = false;
    const addGlobalKeyDownListener = () => {
      nextTick(() => {
        var _a;
        (_a = refWrapper == null ? void 0 : refWrapper.value) == null ? void 0 : _a.focus();
      });
      if (props.keyboard && !globalKeyDownListener) {
        globalKeyDownListener = true;
        on(container2.value, "keydown", handleKeyDown);
      }
    };
    const removeGlobalKeyDownListener = () => {
      if (globalKeyDownListener) {
        globalKeyDownListener = false;
        off(container2.value, "keydown", handleKeyDown);
      }
    };
    watch([src, mergedVisible], () => {
      if (mergedVisible.value) {
        reset();
        setLoadStatus("loading");
        addGlobalKeyDownListener();
      } else {
        removeGlobalKeyDownListener();
      }
    });
    function close() {
      if (mergedVisible.value) {
        emit("close");
        emit("update:visible", false);
        setVisible(false);
      }
    }
    function onMaskClick(e) {
      var _a;
      (_a = refWrapper == null ? void 0 : refWrapper.value) == null ? void 0 : _a.focus();
      if (maskClosable.value && e.target === e.currentTarget) {
        close();
      }
    }
    function changeScale(newScale) {
      if (scale.value !== newScale) {
        scale.value = newScale;
        showScaleValue();
      }
    }
    function fullScreen() {
      const wrapperRect = refWrapper.value.getBoundingClientRect();
      const imgRect = refImage.value.getBoundingClientRect();
      const newHeightScale = wrapperRect.height / (imgRect.height / scale.value);
      const newWidthScale = wrapperRect.width / (imgRect.width / scale.value);
      const newScale = Math.max(newHeightScale, newWidthScale);
      changeScale(newScale);
    }
    function handleRotate(direction) {
      const isClockwise = direction === "clockwise";
      const newRotate = isClockwise ? (rotate.value + ROTATE_STEP) % 360 : rotate.value === 0 ? 360 - ROTATE_STEP : rotate.value - ROTATE_STEP;
      rotate.value = newRotate;
    }
    function handleScale(action) {
      const newScale = getScale(scale.value, action);
      changeScale(newScale);
    }
    onBeforeUnmount(() => {
      removeGlobalKeyDownListener();
    });
    return {
      prefixCls,
      classNames,
      container: container2,
      wrapperStyles,
      scale,
      translate,
      rotate,
      moving,
      mergedVisible,
      isLoading,
      isLoaded,
      scaleValueVisible,
      refWrapper,
      refImage,
      onWheel,
      onMaskClick,
      onCloseClick: close,
      onImgLoad() {
        setLoadStatus("loaded");
      },
      onImgError() {
        setLoadStatus("error");
      },
      actions: computed(() => [
        {
          key: "fullScreen",
          name: t("imagePreview.fullScreen"),
          content: () => h(IconFullscreen),
          onClick: () => fullScreen()
        },
        {
          key: "rotateRight",
          name: t("imagePreview.rotateRight"),
          content: () => h(IconRotateRight),
          onClick: () => handleRotate("clockwise")
        },
        {
          key: "rotateLeft",
          name: t("imagePreview.rotateLeft"),
          content: () => h(IconRotateLeft),
          onClick: () => handleRotate("counterclockwise")
        },
        {
          key: "zoomIn",
          name: t("imagePreview.zoomIn"),
          content: () => h(IconZoomIn),
          onClick: () => handleScale("zoomIn"),
          disabled: scale.value === maxScale
        },
        {
          key: "zoomOut",
          name: t("imagePreview.zoomOut"),
          content: () => h(IconZoomOut),
          onClick: () => handleScale("zoomOut"),
          disabled: scale.value === minScale
        },
        {
          key: "originalSize",
          name: t("imagePreview.originalSize"),
          content: () => h(IconOriginalSize),
          onClick: () => changeScale(1)
        }
      ])
    };
  }
});
const _hoisted_1$47 = ["src"];
function _sfc_render$4Y(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconLoading = resolveComponent("IconLoading");
  const _component_PreviewToolbar = resolveComponent("PreviewToolbar");
  const _component_IconClose = resolveComponent("IconClose");
  const _component_PreviewArrow = resolveComponent("PreviewArrow");
  return openBlock(), createBlock(Teleport, {
    to: _ctx.container,
    disabled: !_ctx.renderToBody
  }, [
    createBaseVNode("div", {
      class: normalizeClass(_ctx.classNames),
      style: normalizeStyle(_ctx.wrapperStyles)
    }, [
      createVNode(Transition, {
        name: "image-fade",
        onBeforeEnter: _cache[0] || (_cache[0] = (el) => el.parentElement && (el.parentElement.style.display = "block")),
        onAfterLeave: _cache[1] || (_cache[1] = (el) => el.parentElement && (el.parentElement.style.display = "")),
        persisted: ""
      }, {
        default: withCtx(() => [
          withDirectives(createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-mask`)
          }, null, 2), [
            [vShow, _ctx.mergedVisible]
          ])
        ]),
        _: 1
      }),
      _ctx.mergedVisible ? (openBlock(), createElementBlock("div", {
        key: 0,
        ref: "refWrapper",
        tabindex: "0",
        class: normalizeClass(`${_ctx.prefixCls}-wrapper`),
        onClick: _cache[6] || (_cache[6] = (...args) => _ctx.onMaskClick && _ctx.onMaskClick(...args)),
        onWheel: _cache[7] || (_cache[7] = withModifiers((...args) => _ctx.onWheel && _ctx.onWheel(...args), ["prevent", "stop"]))
      }, [
        createCommentVNode(" img "),
        createBaseVNode("div", {
          class: normalizeClass(`${_ctx.prefixCls}-img-container`),
          style: normalizeStyle({ transform: `scale(${_ctx.scale}, ${_ctx.scale})` }),
          onClick: _cache[4] || (_cache[4] = (...args) => _ctx.onMaskClick && _ctx.onMaskClick(...args))
        }, [
          (openBlock(), createElementBlock("img", {
            ref: "refImage",
            key: _ctx.src,
            src: _ctx.src,
            class: normalizeClass([
              `${_ctx.prefixCls}-img`,
              {
                [`${_ctx.prefixCls}-img-moving`]: _ctx.moving
              }
            ]),
            style: normalizeStyle({
              transform: `translate(${_ctx.translate[0]}px, ${_ctx.translate[1]}px) rotate(${_ctx.rotate}deg)`
            }),
            onLoad: _cache[2] || (_cache[2] = (...args) => _ctx.onImgLoad && _ctx.onImgLoad(...args)),
            onError: _cache[3] || (_cache[3] = (...args) => _ctx.onImgError && _ctx.onImgError(...args))
          }, null, 46, _hoisted_1$47))
        ], 6),
        createCommentVNode(" loading "),
        _ctx.isLoading ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass(`${_ctx.prefixCls}-loading`)
        }, [
          createVNode(_component_IconLoading)
        ], 2)) : createCommentVNode("v-if", true),
        createCommentVNode(" scale value "),
        createVNode(Transition, { name: "image-fade" }, {
          default: withCtx(() => [
            _ctx.scaleValueVisible ? (openBlock(), createElementBlock("div", {
              key: 0,
              class: normalizeClass(`${_ctx.prefixCls}-scale-value`)
            }, toDisplayString((_ctx.scale * 100).toFixed(0)) + "% ", 3)) : createCommentVNode("v-if", true)
          ]),
          _: 1
        }),
        createCommentVNode(" toolbar "),
        _ctx.isLoaded && _ctx.actionsLayout.length ? (openBlock(), createBlock(_component_PreviewToolbar, {
          key: 1,
          actions: _ctx.actions,
          "actions-layout": _ctx.actionsLayout
        }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "actions")
          ]),
          _: 3
        }, 8, ["actions", "actions-layout"])) : createCommentVNode("v-if", true),
        createCommentVNode(" close btn "),
        _ctx.closable ? (openBlock(), createElementBlock("div", {
          key: 2,
          class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
          onClick: _cache[5] || (_cache[5] = (...args) => _ctx.onCloseClick && _ctx.onCloseClick(...args))
        }, [
          createVNode(_component_IconClose)
        ], 2)) : createCommentVNode("v-if", true),
        createCommentVNode(" group arrow "),
        _ctx.inGroup ? (openBlock(), createBlock(_component_PreviewArrow, normalizeProps(mergeProps({ key: 3 }, _ctx.groupArrowProps)), null, 16)) : createCommentVNode("v-if", true)
      ], 34)) : createCommentVNode("v-if", true)
    ], 6)
  ], 8, ["to", "disabled"]);
}
var ImagePreview = /* @__PURE__ */ _export_sfc(_sfc_main$4Z, [["render", _sfc_render$4Y]]);
function normalizeImageSizeProp(size) {
  if (isUndefined(size))
    return void 0;
  if (!isNumber(size) && /^\d+(%)$/.test(size))
    return size;
  const num = parseInt(size, 10);
  return isNumber(num) ? `${num}px` : void 0;
}
const PreviewGroupInjectionKey = Symbol("PreviewGroupInjectionKey");
let uuid = 0;
const _sfc_main$4Y = defineComponent({
  name: "Image",
  components: {
    IconImageClose,
    IconLoading,
    ImageFooter,
    ImagePreview
  },
  inheritAttrs: false,
  props: {
    renderToBody: {
      type: Boolean,
      default: true
    },
    src: {
      type: String
    },
    width: {
      type: [String, Number]
    },
    height: {
      type: [String, Number]
    },
    title: {
      type: String
    },
    description: {
      type: String
    },
    fit: {
      type: String
    },
    alt: {
      type: String
    },
    hideFooter: {
      type: [Boolean, String],
      default: false
    },
    footerPosition: {
      type: String,
      default: "inner"
    },
    showLoader: {
      type: Boolean,
      default: false
    },
    preview: {
      type: Boolean,
      default: true
    },
    previewVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPreviewVisible: {
      type: Boolean,
      default: false
    },
    previewProps: {
      type: Object
    },
    footerClass: {
      type: [String, Array, Object]
    }
  },
  emits: [
    "preview-visible-change",
    "update:previewVisible"
  ],
  setup(props, { attrs, slots, emit }) {
    const { t } = useI18n();
    const {
      height,
      width,
      hideFooter,
      title,
      description,
      src,
      footerPosition,
      defaultPreviewVisible,
      previewVisible,
      preview,
      previewProps
    } = toRefs(props);
    const groupContext = inject(PreviewGroupInjectionKey, void 0);
    const prefixCls = getPrefixCls("image");
    const refImg = ref();
    const { isLoaded, isError, isLoading, setLoadStatus } = useImageLoadStatus();
    const sizeStyle = computed(() => ({
      width: normalizeImageSizeProp(width == null ? void 0 : width.value),
      height: normalizeImageSizeProp(height == null ? void 0 : height.value)
    }));
    const fitStyle = computed(() => {
      if (props.fit) {
        return { objectFit: props.fit };
      }
      return {};
    });
    const wrapperClassNames = computed(() => [
      `${prefixCls}`,
      {
        [`${prefixCls}-loading`]: isLoading.value,
        [`${prefixCls}-loading-error`]: isError.value,
        [`${prefixCls}-with-footer-inner`]: isLoaded && showFooter && footerPosition.value === "inner",
        [`${prefixCls}-with-footer-outer`]: isLoaded && showFooter && footerPosition.value === "outer"
      },
      attrs.class
    ]);
    const wrapperStyles = computed(() => [
      sizeStyle.value,
      attrs.style
    ]);
    const showFooter = computed(() => {
      if (!((title == null ? void 0 : title.value) || (description == null ? void 0 : description.value) || slots.extra)) {
        return false;
      }
      if (isBoolean(hideFooter.value))
        return !hideFooter.value && isLoaded.value;
      return hideFooter.value === "never";
    });
    const imgProps = computed(() => omit(attrs, ["class", "style"]));
    const [mergedPreviewVisible, setPreviewVisible] = useMergeState(
      defaultPreviewVisible.value,
      reactive({
        value: previewVisible
      })
    );
    const mergePreview = computed(
      () => !(groupContext == null ? void 0 : groupContext.preview) && preview.value
    );
    watchEffect(() => {
      if (isServerRendering || !refImg.value)
        return;
      refImg.value.src = src == null ? void 0 : src.value;
      setLoadStatus("loading");
    });
    const imageId = uuid++;
    watchEffect((onInvalidate) => {
      var _a, _b, _c;
      const unRegister = (_c = groupContext == null ? void 0 : groupContext.registerImageUrl) == null ? void 0 : _c.call(
        groupContext,
        imageId,
        ((_b = (_a = previewProps == null ? void 0 : previewProps.value) == null ? void 0 : _a.src) != null ? _b : src == null ? void 0 : src.value) || "",
        preview.value
      );
      onInvalidate(() => {
        unRegister == null ? void 0 : unRegister();
      });
    });
    function onImgLoaded() {
      setLoadStatus("loaded");
    }
    function onImgLoadError() {
      setLoadStatus("error");
    }
    function onImgClick() {
      if (!preview.value)
        return;
      if (groupContext == null ? void 0 : groupContext.preview) {
        groupContext.preview(imageId);
      } else {
        emit("preview-visible-change", true);
        setPreviewVisible(true);
      }
    }
    function onPreviewClose() {
      emit("preview-visible-change", false);
      setPreviewVisible(false);
    }
    return {
      t,
      refImg,
      prefixCls,
      wrapperClassNames,
      wrapperStyles,
      showFooter,
      imgProps,
      imgStyle: sizeStyle,
      isLoaded,
      isError,
      isLoading,
      mergedPreviewVisible,
      mergePreview,
      onImgLoaded,
      onImgLoadError,
      onImgClick,
      onPreviewClose,
      fitStyle
    };
  }
});
const _hoisted_1$46 = ["title", "alt"];
function _sfc_render$4X(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconImageClose = resolveComponent("IconImageClose");
  const _component_IconLoading = resolveComponent("IconLoading");
  const _component_ImageFooter = resolveComponent("ImageFooter");
  const _component_ImagePreview = resolveComponent("ImagePreview");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.wrapperClassNames),
    style: normalizeStyle(_ctx.wrapperStyles)
  }, [
    createBaseVNode("img", mergeProps({
      ref: "refImg",
      class: `${_ctx.prefixCls}-img`
    }, _ctx.imgProps, {
      style: { ..._ctx.imgStyle, ..._ctx.fitStyle },
      title: _ctx.title,
      alt: _ctx.alt,
      onLoad: _cache[0] || (_cache[0] = (...args) => _ctx.onImgLoaded && _ctx.onImgLoaded(...args)),
      onError: _cache[1] || (_cache[1] = (...args) => _ctx.onImgLoadError && _ctx.onImgLoadError(...args)),
      onClick: _cache[2] || (_cache[2] = (...args) => _ctx.onImgClick && _ctx.onImgClick(...args))
    }), null, 16, _hoisted_1$46),
    !_ctx.isLoaded ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-overlay`)
    }, [
      _ctx.isError ? renderSlot(_ctx.$slots, "error", { key: 0 }, () => [
        createBaseVNode("div", {
          class: normalizeClass(`${_ctx.prefixCls}-error`)
        }, [
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-error-icon`)
          }, [
            renderSlot(_ctx.$slots, "error-icon", {}, () => [
              createVNode(_component_IconImageClose)
            ])
          ], 2),
          _ctx.alt || _ctx.description ? (openBlock(), createElementBlock("div", {
            key: 0,
            class: normalizeClass(`${_ctx.prefixCls}-error-alt`)
          }, toDisplayString(_ctx.alt || _ctx.description), 3)) : createCommentVNode("v-if", true)
        ], 2)
      ]) : createCommentVNode("v-if", true),
      _ctx.isLoading && (_ctx.showLoader || _ctx.$slots.loader) ? renderSlot(_ctx.$slots, "loader", { key: 1 }, () => [
        createBaseVNode("div", {
          class: normalizeClass([`${_ctx.prefixCls}-loader`])
        }, [
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-loader-spin`)
          }, [
            createVNode(_component_IconLoading),
            createBaseVNode("div", {
              class: normalizeClass(`${_ctx.prefixCls}-loader-spin-text`)
            }, toDisplayString(_ctx.t("image.loading")), 3)
          ], 2)
        ], 2)
      ]) : createCommentVNode("v-if", true)
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.showFooter ? (openBlock(), createBlock(_component_ImageFooter, {
      key: 1,
      class: normalizeClass(_ctx.footerClass),
      "prefix-cls": _ctx.prefixCls,
      title: _ctx.title,
      description: _ctx.description
    }, createSlots({ _: 2 }, [
      _ctx.$slots.extra ? {
        name: "extra",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "extra")
        ]),
        key: "0"
      } : void 0
    ]), 1032, ["class", "prefix-cls", "title", "description"])) : createCommentVNode("v-if", true),
    _ctx.isLoaded && _ctx.mergePreview ? (openBlock(), createBlock(_component_ImagePreview, mergeProps({
      key: 2,
      src: _ctx.src
    }, _ctx.previewProps, {
      visible: _ctx.mergedPreviewVisible,
      "render-to-body": _ctx.renderToBody,
      onClose: _ctx.onPreviewClose
    }), {
      actions: withCtx(() => [
        renderSlot(_ctx.$slots, "preview-actions")
      ]),
      _: 3
    }, 16, ["src", "visible", "render-to-body", "onClose"])) : createCommentVNode("v-if", true)
  ], 6);
}
var _Image = /* @__PURE__ */ _export_sfc(_sfc_main$4Y, [["render", _sfc_render$4X]]);
var _sfc_main$4X = defineComponent({
  name: "ImagePreviewGroup",
  components: {
    ImagePreview
  },
  inheritAttrs: false,
  props: {
    renderToBody: {
      type: Boolean,
      default: true
    },
    srcList: {
      type: Array
    },
    current: {
      type: Number
    },
    defaultCurrent: {
      type: Number,
      default: 0
    },
    infinite: {
      type: Boolean,
      default: false
    },
    visible: {
      type: Boolean,
      default: void 0
    },
    defaultVisible: {
      type: Boolean,
      default: false
    },
    maskClosable: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: true
    },
    actionsLayout: {
      type: Array,
      default: () => ["fullScreen", "rotateRight", "rotateLeft", "zoomIn", "zoomOut", "originalSize"]
    },
    popupContainer: {
      type: [String, Object]
    }
  },
  emits: [
    "change",
    "update:current",
    "visible-change",
    "update:visible"
  ],
  setup(props, {
    emit
  }) {
    const {
      srcList,
      visible,
      defaultVisible,
      current,
      defaultCurrent,
      infinite
    } = toRefs(props);
    const [mergedVisible, setLocalVisible] = useMergeState(defaultVisible.value, reactive({
      value: visible
    }));
    const setVisible = (newVisible) => {
      if (newVisible !== mergedVisible.value) {
        emit("visible-change", newVisible);
        emit("update:visible", newVisible);
        setLocalVisible(newVisible);
      }
    };
    const propImageUrlMap = computed(() => new Map(isArray(srcList == null ? void 0 : srcList.value) ? srcList == null ? void 0 : srcList.value.map((url, index2) => [index2, {
      url,
      canPreview: true
    }]) : []));
    const imageUrlMap = ref(new Map(propImageUrlMap.value || []));
    const imageIdList = computed(() => Array.from(imageUrlMap.value.keys()));
    const imageCount = computed(() => imageIdList.value.length);
    function registerImageUrl(id, url, canPreview) {
      if (!propImageUrlMap.value.has(id))
        imageUrlMap.value.set(id, {
          url,
          canPreview
        });
      return function unRegisterPreviewUrl() {
        if (!propImageUrlMap.value.has(id)) {
          imageUrlMap.value.delete(id);
        }
      };
    }
    watch(propImageUrlMap, () => {
      imageUrlMap.value = new Map(propImageUrlMap.value || []);
    });
    const [currentIndex, setLocalCurrentIndex] = useMergeState(defaultCurrent.value, reactive({
      value: current
    }));
    const setCurrentIndex = (index2) => {
      if (index2 !== currentIndex.value) {
        emit("change", index2);
        emit("update:current", index2);
        setLocalCurrentIndex(index2);
      }
    };
    const currentId = computed(() => imageIdList.value[currentIndex.value]);
    const setCurrentId = (nextId) => {
      const nextIndex2 = imageIdList.value.indexOf(nextId);
      if (nextIndex2 !== currentIndex.value) {
        setCurrentIndex(nextIndex2);
      }
    };
    const currentUrl = computed(() => {
      var _a;
      return (_a = imageUrlMap.value.get(currentId.value)) == null ? void 0 : _a.url;
    });
    provide(PreviewGroupInjectionKey, reactive({
      registerImageUrl,
      preview: (imageId) => {
        setVisible(true);
        setCurrentId(imageId);
      }
    }));
    const nextIndex = computed(() => {
      const findNext = (start, end) => {
        var _a;
        for (let i2 = start; i2 <= end; i2++) {
          const id = imageIdList.value[i2];
          if ((_a = imageUrlMap.value.get(id)) == null ? void 0 : _a.canPreview) {
            return i2;
          }
        }
        return void 0;
      };
      const next = findNext(currentIndex.value + 1, imageCount.value - 1);
      return isUndefined(next) && infinite.value ? findNext(0, currentIndex.value - 1) : next;
    });
    const prevIndex = computed(() => {
      const findPrev = (start, end) => {
        var _a;
        for (let i2 = start; i2 >= end; i2--) {
          const id = imageIdList.value[i2];
          if ((_a = imageUrlMap.value.get(id)) == null ? void 0 : _a.canPreview) {
            return i2;
          }
        }
        return void 0;
      };
      const prev = findPrev(currentIndex.value - 1, 0);
      return isUndefined(prev) && infinite.value ? findPrev(imageCount.value - 1, currentIndex.value + 1) : prev;
    });
    const onPrev = computed(() => !isUndefined(prevIndex.value) ? () => {
      !isUndefined(prevIndex.value) && setCurrentIndex(prevIndex.value);
    } : void 0);
    const onNext = computed(() => !isUndefined(nextIndex.value) ? () => {
      !isUndefined(nextIndex.value) && setCurrentIndex(nextIndex.value);
    } : void 0);
    return {
      mergedVisible,
      currentUrl,
      prevIndex,
      nextIndex,
      onClose() {
        setVisible(false);
      },
      groupArrowProps: reactive({
        onPrev,
        onNext
      })
    };
  }
});
function _sfc_render$4W(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ImagePreview = resolveComponent("ImagePreview");
  return openBlock(), createElementBlock(Fragment, null, [
    renderSlot(_ctx.$slots, "default"),
    createVNode(_component_ImagePreview, mergeProps({ ..._ctx.$attrs, groupArrowProps: _ctx.groupArrowProps }, {
      "in-group": "",
      src: _ctx.currentUrl,
      visible: _ctx.mergedVisible,
      "mask-closable": _ctx.maskClosable,
      closable: _ctx.closable,
      "actions-layout": _ctx.actionsLayout,
      "popup-container": _ctx.popupContainer,
      "render-to-body": _ctx.renderToBody,
      onClose: _ctx.onClose
    }), createSlots({ _: 2 }, [
      _ctx.$slots.actions ? {
        name: "actions",
        fn: withCtx(() => [
          renderSlot(_ctx.$slots, "actions", { url: _ctx.currentUrl })
        ]),
        key: "0"
      } : void 0
    ]), 1040, ["src", "visible", "mask-closable", "closable", "actions-layout", "popup-container", "render-to-body", "onClose"])
  ], 64);
}
var ImagePreviewGroup = /* @__PURE__ */ _export_sfc(_sfc_main$4X, [["render", _sfc_render$4W]]);
const Image$1 = Object.assign(_Image, {
  Preview: ImagePreview,
  PreviewGroup: ImagePreviewGroup,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Image.name, _Image);
    app.component(componentPrefix + ImagePreview.name, ImagePreview);
    app.component(
      componentPrefix + ImagePreviewGroup.name,
      ImagePreviewGroup
    );
    app.component(
      componentPrefix + ImagePreviewAction.name,
      ImagePreviewAction
    );
  }
});
const LayoutSiderInjectionKey = Symbol(
  "LayoutSiderInjectionKey"
);
const SiderInjectionKey = Symbol("SiderInjectionKey");
var _sfc_main$4W = defineComponent({
  name: "Layout",
  props: {
    hasSider: {
      type: Boolean
    }
  },
  setup(props) {
    const siderIds = ref([]);
    const prefixCls = getPrefixCls("layout");
    const classNames = computed(() => [prefixCls, {
      [`${prefixCls}-has-sider`]: props.hasSider || siderIds.value.length
    }]);
    provide(LayoutSiderInjectionKey, {
      onSiderMount: (id) => siderIds.value.push(id),
      onSiderUnMount: (id) => {
        siderIds.value = siderIds.value.filter((_id) => _id !== id);
      }
    });
    return {
      classNames
    };
  }
});
function _sfc_render$4V(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("section", {
    class: normalizeClass(_ctx.classNames)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var _Layout = /* @__PURE__ */ _export_sfc(_sfc_main$4W, [["render", _sfc_render$4V]]);
const _sfc_main$4V = defineComponent({
  name: "LayoutHeader",
  setup() {
    const prefixCls = getPrefixCls("layout-header");
    const classNames = [prefixCls];
    return {
      classNames
    };
  }
});
function _sfc_render$4U(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("header", {
    class: normalizeClass(_ctx.classNames)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var LayoutHeader = /* @__PURE__ */ _export_sfc(_sfc_main$4V, [["render", _sfc_render$4U]]);
const _sfc_main$4U = defineComponent({
  name: "LayoutContent",
  setup() {
    const prefixCls = getPrefixCls("layout-content");
    const classNames = [prefixCls];
    return {
      classNames
    };
  }
});
function _sfc_render$4T(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("main", {
    class: normalizeClass(_ctx.classNames)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var LayoutContent = /* @__PURE__ */ _export_sfc(_sfc_main$4U, [["render", _sfc_render$4T]]);
const _sfc_main$4T = defineComponent({
  name: "LayoutFooter",
  setup() {
    const prefixCls = getPrefixCls("layout-footer");
    const classNames = [prefixCls];
    return {
      classNames
    };
  }
});
function _sfc_render$4S(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("footer", {
    class: normalizeClass(_ctx.classNames)
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var LayoutFooter = /* @__PURE__ */ _export_sfc(_sfc_main$4T, [["render", _sfc_render$4S]]);
const _sfc_main$4S = defineComponent({
  name: "IconDragDot",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-drag-dot`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$45 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4R(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      d: "M40 17v2h-2v-2h2ZM25 17v2h-2v-2h2ZM10 17v2H8v-2h2ZM40 29v2h-2v-2h2ZM25 29v2h-2v-2h2ZM10 29v2H8v-2h2Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1),
    createBaseVNode("path", { d: "M40 17v2h-2v-2h2ZM25 17v2h-2v-2h2ZM10 17v2H8v-2h2ZM40 29v2h-2v-2h2ZM25 29v2h-2v-2h2ZM10 29v2H8v-2h2Z" }, null, -1)
  ]), 14, _hoisted_1$45);
}
var _IconDragDot = /* @__PURE__ */ _export_sfc(_sfc_main$4S, [["render", _sfc_render$4R]]);
const IconDragDot = Object.assign(_IconDragDot, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconDragDot.name, _IconDragDot);
  }
});
const _sfc_main$4R = defineComponent({
  name: "IconDragDotVertical",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-drag-dot-vertical`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$44 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4Q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      d: "M17 8h2v2h-2V8ZM17 23h2v2h-2v-2ZM17 38h2v2h-2v-2ZM29 8h2v2h-2V8ZM29 23h2v2h-2v-2ZM29 38h2v2h-2v-2Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1),
    createBaseVNode("path", { d: "M17 8h2v2h-2V8ZM17 23h2v2h-2v-2ZM17 38h2v2h-2v-2ZM29 8h2v2h-2V8ZM29 23h2v2h-2v-2ZM29 38h2v2h-2v-2Z" }, null, -1)
  ]), 14, _hoisted_1$44);
}
var _IconDragDotVertical = /* @__PURE__ */ _export_sfc(_sfc_main$4R, [["render", _sfc_render$4Q]]);
const IconDragDotVertical = Object.assign(_IconDragDotVertical, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconDragDotVertical.name, _IconDragDotVertical);
  }
});
var _sfc_main$4Q = defineComponent({
  name: "ResizeTrigger",
  components: {
    ResizeObserver: ResizeObserver$1,
    IconDragDot,
    IconDragDotVertical
  },
  props: {
    prefixCls: {
      type: String,
      required: true
    },
    direction: {
      type: String,
      default: "horizontal"
    }
  },
  emits: ["resize"],
  setup(props, {
    emit
  }) {
    const {
      direction,
      prefixCls
    } = toRefs(props);
    const isHorizontal2 = computed(() => (direction == null ? void 0 : direction.value) === "horizontal");
    const classNames = computed(() => [prefixCls.value, {
      [`${prefixCls.value}-horizontal`]: isHorizontal2.value,
      [`${prefixCls.value}-vertical`]: !isHorizontal2.value
    }]);
    const onResize = (entry) => {
      emit("resize", entry);
    };
    return {
      classNames,
      onResize,
      isHorizontal: isHorizontal2
    };
  }
});
function _sfc_render$4P(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconDragDot = resolveComponent("IconDragDot");
  const _component_IconDragDotVertical = resolveComponent("IconDragDotVertical");
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  return openBlock(), createBlock(_component_ResizeObserver, { onResize: _ctx.onResize }, {
    default: withCtx(() => [
      createBaseVNode("div", {
        class: normalizeClass(_ctx.classNames)
      }, [
        createCommentVNode(" @slot \u81EA\u5B9A\u4E49\u5185\u5BB9 "),
        renderSlot(_ctx.$slots, "default", {}, () => [
          createBaseVNode("div", {
            class: normalizeClass(`${_ctx.prefixCls}-icon-wrapper`)
          }, [
            createCommentVNode(" @slot \u81EA\u5B9A\u4E49 icon "),
            renderSlot(_ctx.$slots, "icon", {}, () => [
              _ctx.isHorizontal ? (openBlock(), createBlock(_component_IconDragDot, {
                key: 0,
                class: normalizeClass(`${_ctx.prefixCls}-icon`)
              }, null, 8, ["class"])) : (openBlock(), createBlock(_component_IconDragDotVertical, {
                key: 1,
                class: normalizeClass(`${_ctx.prefixCls}-icon`)
              }, null, 8, ["class"]))
            ])
          ], 2)
        ])
      ], 2)
    ]),
    _: 3
  }, 8, ["onResize"]);
}
var ResizeTrigger = /* @__PURE__ */ _export_sfc(_sfc_main$4Q, [["render", _sfc_render$4P]]);
const DIRECTION_LEFT = "left";
const DIRECTION_RIGHT = "right";
const DIRECTION_TOP = "top";
const DIRECTION_BOTTOM = "bottom";
const allDirections = [
  DIRECTION_LEFT,
  DIRECTION_RIGHT,
  DIRECTION_TOP,
  DIRECTION_BOTTOM
];
function getRealSize(pageSize, padding) {
  if (pageSize === 0)
    return 0;
  const res = pageSize - padding;
  return res <= 0 ? 0 : res;
}
function isHorizontal(direction) {
  return [DIRECTION_TOP, DIRECTION_BOTTOM].indexOf(direction) > -1;
}
const _sfc_main$4P = defineComponent({
  name: "ResizeBox",
  components: {
    ResizeTrigger
  },
  inheritAttrs: false,
  props: {
    width: {
      type: Number
    },
    height: {
      type: Number
    },
    component: {
      type: String,
      default: "div"
    },
    directions: {
      type: Array,
      default: () => ["right"]
    }
  },
  emits: {
    "update:width": (width) => true,
    "update:height": (height) => true,
    "movingStart": (ev) => true,
    "moving": (size, ev) => true,
    "movingEnd": (ev) => true
  },
  setup(props, { emit }) {
    const { height: propHeight, width: propWidth, directions } = toRefs(props);
    const [width, setWidth] = useMergeState(
      null,
      reactive({
        value: propWidth
      })
    );
    const [height, setHeight] = useMergeState(
      null,
      reactive({
        value: propHeight
      })
    );
    const wrapperRef = ref();
    const paddingStyles = reactive({});
    const prefixCls = getPrefixCls("resizebox");
    const classNames = computed(() => [prefixCls]);
    const styles = computed(() => {
      return {
        ...isNumber(width.value) ? { width: `${width.value}px` } : {},
        ...isNumber(height.value) ? { height: `${height.value}px` } : {},
        ...paddingStyles
      };
    });
    const allowDirections = computed(
      () => directions.value.filter((direction) => allDirections.includes(direction))
    );
    const record = {
      direction: "",
      startPageX: 0,
      startPageY: 0,
      startWidth: 0,
      startHeight: 0,
      moving: false,
      padding: {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
      }
    };
    function onMoving(e) {
      if (!record.moving)
        return;
      const { startPageX, startPageY, startWidth, startHeight, direction } = record;
      let newWidth = startWidth;
      let newHeight = startHeight;
      const offsetX = e.pageX - startPageX;
      const offsetY = e.pageY - startPageY;
      switch (direction) {
        case DIRECTION_LEFT:
          newWidth = startWidth - offsetX;
          setWidth(newWidth);
          emit("update:width", newWidth);
          break;
        case DIRECTION_RIGHT:
          newWidth = startWidth + offsetX;
          setWidth(newWidth);
          emit("update:width", newWidth);
          break;
        case DIRECTION_TOP:
          newHeight = startHeight - offsetY;
          setHeight(newHeight);
          emit("update:height", newHeight);
          break;
        case DIRECTION_BOTTOM:
          newHeight = startHeight + offsetY;
          setHeight(newHeight);
          emit("update:height", newHeight);
          break;
      }
      emit(
        "moving",
        {
          width: newWidth,
          height: newHeight
        },
        e
      );
    }
    function onMoveEnd(e) {
      record.moving = false;
      off(window, "mousemove", onMoving);
      off(window, "mouseup", onMoveEnd);
      off(window, "contextmenu", onMoveEnd);
      document.body.style.cursor = "default";
      emit("movingEnd", e);
    }
    function onMoveStart(direction, e) {
      var _a, _b;
      emit("movingStart", e);
      record.moving = true;
      record.startPageX = e.pageX;
      record.startPageY = e.pageY;
      record.direction = direction;
      const { top, left, right, bottom } = record.padding;
      record.startWidth = getRealSize(
        ((_a = wrapperRef.value) == null ? void 0 : _a.clientWidth) || 0,
        left + right
      );
      record.startHeight = getRealSize(
        ((_b = wrapperRef.value) == null ? void 0 : _b.clientHeight) || 0,
        top + bottom
      );
      on(window, "mousemove", onMoving);
      on(window, "mouseup", onMoveEnd);
      on(window, "contextmenu", onMoveEnd);
      document.body.style.cursor = isHorizontal(direction) ? "row-resize" : "col-resize";
    }
    function onTiggerResize(direction, entry) {
      const { width: width2, height: height2 } = entry.contentRect;
      const size = isHorizontal(direction) ? height2 : width2;
      record.padding[direction] = size;
      paddingStyles[`padding-${direction}`] = `${size}px`;
    }
    return {
      prefixCls,
      classNames,
      styles,
      wrapperRef,
      onMoveStart,
      isHorizontal,
      allowDirections,
      onTiggerResize
    };
  }
});
function _sfc_render$4O(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ResizeTrigger = resolveComponent("ResizeTrigger");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.component), mergeProps({
    ref: "wrapperRef",
    class: _ctx.classNames
  }, _ctx.$attrs, { style: _ctx.styles }), {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default"),
      (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.allowDirections, (direction) => {
        return openBlock(), createBlock(_component_ResizeTrigger, {
          key: direction,
          "prefix-cls": `${_ctx.prefixCls}-trigger`,
          class: normalizeClass(`${_ctx.prefixCls}-direction-${direction}`),
          direction: _ctx.isHorizontal(direction) ? "horizontal" : "vertical",
          onMousedown: (e) => {
            _ctx.onMoveStart(direction, e);
          },
          onResize: (entry) => {
            _ctx.onTiggerResize(direction, entry);
          }
        }, createSlots({
          default: withCtx(() => [
            _ctx.$slots["resize-trigger"] ? renderSlot(_ctx.$slots, "resize-trigger", {
              key: 0,
              direction
            }) : createCommentVNode("v-if", true)
          ]),
          _: 2
        }, [
          _ctx.$slots["resize-trigger-icon"] ? {
            name: "icon",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "resize-trigger-icon", { direction })
            ]),
            key: "0"
          } : void 0
        ]), 1032, ["prefix-cls", "class", "direction", "onMousedown", "onResize"]);
      }), 128))
    ]),
    _: 3
  }, 16, ["class", "style"]);
}
var _ResizeBox = /* @__PURE__ */ _export_sfc(_sfc_main$4P, [["render", _sfc_render$4O]]);
const ResizeBox = Object.assign(_ResizeBox, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _ResizeBox.name, _ResizeBox);
  }
});
function useResponsive(breakpoint, callback) {
  const resultBreakpoint = computed(
    () => isRef(breakpoint) ? breakpoint.value : breakpoint
  );
  let subscribeToken = "";
  onMounted(() => {
    subscribeToken = responsiveObserve.subscribe(
      (screens2, breakpointChecked) => {
        if (!resultBreakpoint.value)
          return;
        if (!breakpointChecked || breakpointChecked === resultBreakpoint.value) {
          callback(!!screens2[resultBreakpoint.value]);
        }
      }
    );
  });
  onUnmounted(() => {
    if (subscribeToken) {
      responsiveObserve.unsubscribe(subscribeToken);
    }
  });
}
const generateId$1 = (() => {
  let i2 = 0;
  return (prefix = "") => {
    i2 += 1;
    return `${prefix}${i2}`;
  };
})();
var _sfc_main$4O = defineComponent({
  name: "LayoutSider",
  components: {
    IconLeft,
    IconRight,
    ResizeBox
  },
  props: {
    theme: {
      type: String,
      default: "light"
    },
    collapsed: {
      type: Boolean,
      default: void 0
    },
    defaultCollapsed: {
      type: Boolean
    },
    collapsible: {
      type: Boolean
    },
    width: {
      type: Number,
      default: 200
    },
    collapsedWidth: {
      type: Number,
      default: 48
    },
    reverseArrow: {
      type: Boolean
    },
    breakpoint: {
      type: String
    },
    resizeDirections: {
      type: Array,
      default: void 0
    },
    hideTrigger: {
      type: Boolean
    }
  },
  emits: [
    "collapse",
    "update:collapsed",
    "breakpoint"
  ],
  setup(props, {
    emit
  }) {
    const {
      theme,
      collapsed,
      defaultCollapsed,
      collapsible,
      hideTrigger,
      breakpoint,
      collapsedWidth,
      resizeDirections
    } = toRefs(props);
    const [localCollapsed, setLocalCollapsed] = useMergeState(defaultCollapsed.value, reactive({
      value: collapsed
    }));
    const componentTag = computed(() => resizeDirections.value ? "ResizeBox" : "div");
    const showTrigger = computed(() => collapsible.value && !hideTrigger.value);
    const prefixCls = getPrefixCls("layout-sider");
    const classNames = computed(() => [prefixCls, {
      [`${prefixCls}-light`]: theme.value === "light",
      [`${prefixCls}-has-trigger`]: showTrigger.value,
      [`${prefixCls}-collapsed`]: collapsed.value
    }]);
    const siderWidth = computed(() => {
      const {
        width,
        collapsedWidth: collapsedWidth2
      } = props;
      const rawWidth = localCollapsed.value ? collapsedWidth2 : width;
      return isNumber(rawWidth) ? `${rawWidth}px` : String(rawWidth);
    });
    const triggerClassNames = computed(() => [`${prefixCls}-trigger`, {
      [`${prefixCls}-trigger-light`]: theme.value === "light"
    }]);
    const toggleTrigger = () => {
      const newCollapsed = !localCollapsed.value;
      setLocalCollapsed(newCollapsed);
      emit("update:collapsed", newCollapsed);
      emit("collapse", newCollapsed, "clickTrigger");
    };
    useResponsive(breakpoint, (checked) => {
      const newCollapsed = !checked;
      if (newCollapsed !== localCollapsed.value) {
        setLocalCollapsed(newCollapsed);
        emit("update:collapsed", newCollapsed);
        emit("collapse", newCollapsed, "responsive");
        emit("breakpoint", newCollapsed);
      }
    });
    const uniqueId = generateId$1("__arco_layout_sider");
    const siderHook = inject(LayoutSiderInjectionKey, void 0);
    onMounted(() => {
      var _a;
      (_a = siderHook == null ? void 0 : siderHook.onSiderMount) == null ? void 0 : _a.call(siderHook, uniqueId);
    });
    onUnmounted(() => {
      var _a;
      (_a = siderHook == null ? void 0 : siderHook.onSiderUnMount) == null ? void 0 : _a.call(siderHook, uniqueId);
    });
    provide(SiderInjectionKey, reactive({
      theme,
      collapsed: localCollapsed,
      collapsedWidth
    }));
    return {
      componentTag,
      prefixCls,
      classNames,
      triggerClassNames,
      localCollapsed,
      siderWidth,
      showTrigger,
      toggleTrigger
    };
  }
});
const _hoisted_1$43 = { key: 0 };
const _hoisted_2$2 = { key: 1 };
function _sfc_render$4N(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconLeft = resolveComponent("IconLeft");
  const _component_IconRight = resolveComponent("IconRight");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.componentTag), mergeProps({
    class: _ctx.classNames,
    style: { width: _ctx.siderWidth }
  }, _ctx.resizeDirections ? { directions: _ctx.resizeDirections } : {}), {
    default: withCtx(() => [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-children`)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2),
      _ctx.showTrigger ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(_ctx.triggerClassNames),
        style: normalizeStyle({ width: _ctx.siderWidth }),
        onClick: _cache[0] || (_cache[0] = (...args) => _ctx.toggleTrigger && _ctx.toggleTrigger(...args))
      }, [
        renderSlot(_ctx.$slots, "trigger", { collapsed: _ctx.localCollapsed }, () => [
          !_ctx.reverseArrow ? (openBlock(), createElementBlock("div", _hoisted_1$43, [
            !_ctx.localCollapsed ? (openBlock(), createBlock(_component_IconLeft, { key: 0 })) : (openBlock(), createBlock(_component_IconRight, { key: 1 }))
          ])) : (openBlock(), createElementBlock("div", _hoisted_2$2, [
            _ctx.localCollapsed ? (openBlock(), createBlock(_component_IconLeft, { key: 0 })) : (openBlock(), createBlock(_component_IconRight, { key: 1 }))
          ]))
        ])
      ], 6)) : createCommentVNode("v-if", true)
    ]),
    _: 3
  }, 16, ["class", "style"]);
}
var LayoutSider = /* @__PURE__ */ _export_sfc(_sfc_main$4O, [["render", _sfc_render$4N]]);
const Layout = Object.assign(_Layout, {
  Header: LayoutHeader,
  Content: LayoutContent,
  Footer: LayoutFooter,
  Sider: LayoutSider,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Layout.name, _Layout);
    app.component(componentPrefix + LayoutHeader.name, LayoutHeader);
    app.component(componentPrefix + LayoutContent.name, LayoutContent);
    app.component(componentPrefix + LayoutFooter.name, LayoutFooter);
    app.component(componentPrefix + LayoutSider.name, LayoutSider);
  }
});
const _sfc_main$4N = defineComponent({
  name: "Pager",
  props: {
    pageNumber: {
      type: Number
    },
    current: {
      type: Number
    },
    disabled: {
      type: Boolean,
      default: false
    },
    style: {
      type: Object
    },
    activeStyle: {
      type: Object
    }
  },
  emits: ["click"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("pagination-item");
    const isActive = computed(() => props.current === props.pageNumber);
    const handleClick = (e) => {
      if (!props.disabled) {
        emit("click", props.pageNumber, e);
      }
    };
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-active`]: isActive.value
      }
    ]);
    const mergedStyle = computed(() => {
      return isActive.value ? props.activeStyle : props.style;
    });
    return {
      prefixCls,
      cls,
      mergedStyle,
      handleClick
    };
  }
});
function _sfc_render$4M(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("li", {
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.mergedStyle),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    renderSlot(_ctx.$slots, "default", { page: _ctx.pageNumber }, () => [
      createTextVNode(toDisplayString(_ctx.pageNumber), 1)
    ])
  ], 6);
}
var Pager = /* @__PURE__ */ _export_sfc(_sfc_main$4N, [["render", _sfc_render$4M]]);
const getLegalPage = (page, { min, max }) => {
  if (page < min) {
    return min;
  }
  if (page > max) {
    return max;
  }
  return page;
};
const _sfc_main$4M = defineComponent({
  name: "StepPager",
  components: {
    IconLeft,
    IconRight
  },
  props: {
    pages: {
      type: Number,
      required: true
    },
    current: {
      type: Number,
      required: true
    },
    type: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      default: false
    },
    simple: {
      type: Boolean,
      default: false
    }
  },
  emits: ["click"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("pagination-item");
    const isNext = props.type === "next";
    const mergedDisabled = computed(() => {
      if (props.disabled) {
        return props.disabled;
      }
      if (!props.pages) {
        return true;
      }
      if (isNext && props.current === props.pages) {
        return true;
      }
      return !isNext && props.current <= 1;
    });
    const nextPage = computed(
      () => getLegalPage(props.current + (isNext ? 1 : -1), {
        min: 1,
        max: props.pages
      })
    );
    const handleClick = (e) => {
      if (!mergedDisabled.value) {
        emit("click", nextPage.value);
      }
    };
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-${props.type}`,
      {
        [`${prefixCls}-disabled`]: mergedDisabled.value
      }
    ]);
    return {
      prefixCls,
      cls,
      isNext,
      handleClick
    };
  }
});
function _sfc_render$4L(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_right = resolveComponent("icon-right");
  const _component_icon_left = resolveComponent("icon-left");
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.simple ? "span" : "li"), {
    class: normalizeClass(_ctx.cls),
    onClick: _ctx.handleClick
  }, {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default", {
        type: _ctx.isNext ? "next" : "previous"
      }, () => [
        _ctx.isNext ? (openBlock(), createBlock(_component_icon_right, { key: 0 })) : (openBlock(), createBlock(_component_icon_left, { key: 1 }))
      ])
    ]),
    _: 3
  }, 8, ["class", "onClick"]);
}
var StepPager = /* @__PURE__ */ _export_sfc(_sfc_main$4M, [["render", _sfc_render$4L]]);
const _sfc_main$4L = defineComponent({
  name: "EllipsisPager",
  components: {
    IconMore
  },
  props: {
    current: {
      type: Number,
      required: true
    },
    step: {
      type: Number,
      default: 5
    },
    pages: {
      type: Number,
      required: true
    }
  },
  emits: ["click"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("pagination-item");
    const nextPage = computed(
      () => getLegalPage(props.current + props.step, {
        min: 1,
        max: props.pages
      })
    );
    const handleClick = (e) => {
      emit("click", nextPage.value);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-ellipsis`]);
    return {
      prefixCls,
      cls,
      handleClick
    };
  }
});
function _sfc_render$4K(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_more = resolveComponent("icon-more");
  return openBlock(), createElementBlock("li", {
    class: normalizeClass(_ctx.cls),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createVNode(_component_icon_more)
    ])
  ], 2);
}
var EllipsisPager = /* @__PURE__ */ _export_sfc(_sfc_main$4L, [["render", _sfc_render$4K]]);
const _sfc_main$4K = defineComponent({
  name: "PageJumper",
  components: {
    InputNumber
  },
  props: {
    current: {
      type: Number,
      required: true
    },
    simple: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    pages: {
      type: Number,
      required: true
    },
    size: {
      type: String
    },
    onChange: {
      type: Function
    }
  },
  emits: ["change"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("pagination-jumper");
    const { t } = useI18n();
    const inputValue = ref(props.simple ? props.current : void 0);
    const handleFormatter = (value) => {
      const parseIntVal = parseInt(value.toString(), 10);
      return Number.isNaN(parseIntVal) ? void 0 : String(parseIntVal);
    };
    const handleChange = (value) => {
      emit("change", inputValue.value);
      nextTick(() => {
        if (!props.simple) {
          inputValue.value = void 0;
        }
      });
    };
    watch(
      () => props.current,
      (value) => {
        if (props.simple && value !== inputValue.value) {
          inputValue.value = value;
        }
      }
    );
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-simple`]: props.simple
      }
    ]);
    return {
      prefixCls,
      cls,
      t,
      inputValue,
      handleChange,
      handleFormatter
    };
  }
});
function _sfc_render$4J(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_input_number = resolveComponent("input-number");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass(_ctx.cls)
  }, [
    !_ctx.simple ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass([`${_ctx.prefixCls}-prepend`, `${_ctx.prefixCls}-text-goto`])
    }, [
      renderSlot(_ctx.$slots, "jumper-prepend", {}, () => [
        createTextVNode(toDisplayString(_ctx.t("pagination.goto")), 1)
      ])
    ], 2)) : createCommentVNode("v-if", true),
    createVNode(_component_input_number, {
      modelValue: _ctx.inputValue,
      "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.inputValue = $event),
      class: normalizeClass(`${_ctx.prefixCls}-input`),
      min: 1,
      max: _ctx.pages,
      size: _ctx.size,
      disabled: _ctx.disabled,
      "hide-button": "",
      formatter: _ctx.handleFormatter,
      onChange: _ctx.handleChange
    }, null, 8, ["modelValue", "class", "max", "size", "disabled", "formatter", "onChange"]),
    _ctx.$slots["jumper-append"] ? (openBlock(), createElementBlock("span", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-append`)
    }, [
      renderSlot(_ctx.$slots, "jumper-append")
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.simple ? (openBlock(), createElementBlock(Fragment, { key: 2 }, [
      createBaseVNode("span", {
        class: normalizeClass(`${_ctx.prefixCls}-separator`)
      }, "/", 2),
      createBaseVNode("span", {
        class: normalizeClass(`${_ctx.prefixCls}-total-page`)
      }, toDisplayString(_ctx.pages), 3)
    ], 64)) : createCommentVNode("v-if", true)
  ], 2);
}
var PageJumper = /* @__PURE__ */ _export_sfc(_sfc_main$4K, [["render", _sfc_render$4J]]);
const _sfc_main$4J = defineComponent({
  name: "PageOptions",
  components: {
    ArcoSelect: Select
  },
  props: {
    sizeOptions: {
      type: Array,
      required: true
    },
    pageSize: Number,
    disabled: Boolean,
    size: {
      type: String
    },
    onChange: {
      type: Function
    },
    selectProps: {
      type: Object
    }
  },
  emits: ["change"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("pagination-options");
    const { t } = useI18n();
    const options = computed(
      () => props.sizeOptions.map((value) => ({
        value,
        label: `${value} ${t("pagination.countPerPage")}`
      }))
    );
    const handleChange = (value) => {
      emit("change", value);
    };
    return {
      prefixCls,
      options,
      handleChange
    };
  }
});
function _sfc_render$4I(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_arco_select = resolveComponent("arco-select");
  return openBlock(), createElementBlock("span", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    createVNode(_component_arco_select, mergeProps({
      "model-value": _ctx.pageSize,
      options: _ctx.options,
      size: _ctx.size,
      disabled: _ctx.disabled
    }, _ctx.selectProps, { onChange: _ctx.handleChange }), null, 16, ["model-value", "options", "size", "disabled", "onChange"])
  ], 2);
}
var PageOptions = /* @__PURE__ */ _export_sfc(_sfc_main$4J, [["render", _sfc_render$4I]]);
var _Pagination = defineComponent({
  name: "Pagination",
  props: {
    total: {
      type: Number,
      required: true
    },
    current: Number,
    defaultCurrent: {
      type: Number,
      default: 1
    },
    pageSize: Number,
    defaultPageSize: {
      type: Number,
      default: 10
    },
    disabled: {
      type: Boolean,
      default: false
    },
    hideOnSinglePage: {
      type: Boolean,
      default: false
    },
    simple: {
      type: Boolean,
      default: false
    },
    showTotal: {
      type: Boolean,
      default: false
    },
    showMore: {
      type: Boolean,
      default: false
    },
    showJumper: {
      type: Boolean,
      default: false
    },
    showPageSize: {
      type: Boolean,
      default: false
    },
    pageSizeOptions: {
      type: Array,
      default: () => [10, 20, 30, 40, 50]
    },
    pageSizeProps: {
      type: Object
    },
    size: {
      type: String
    },
    pageItemStyle: {
      type: Object
    },
    activePageItemStyle: {
      type: Object
    },
    baseSize: {
      type: Number,
      default: 6
    },
    bufferSize: {
      type: Number,
      default: 2
    },
    autoAdjust: {
      type: Boolean,
      default: true
    }
  },
  emits: {
    "update:current": (current) => true,
    "update:pageSize": (pageSize) => true,
    "change": (current) => true,
    "pageSizeChange": (pageSize) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const prefixCls = getPrefixCls("pagination");
    const {
      t
    } = useI18n();
    const {
      disabled,
      pageItemStyle,
      activePageItemStyle,
      size
    } = toRefs(props);
    const {
      mergedSize
    } = useSize$1(size);
    const _current = ref(props.defaultCurrent);
    const _pageSize = ref(props.defaultPageSize);
    const computedCurrent = computed(() => {
      var _a;
      return (_a = props.current) != null ? _a : _current.value;
    });
    const computedPageSize = computed(() => {
      var _a;
      return (_a = props.pageSize) != null ? _a : _pageSize.value;
    });
    const pages = computed(() => Math.ceil(props.total / computedPageSize.value));
    const handleClick = (page) => {
      if (page !== computedCurrent.value && isNumber(page) && !props.disabled) {
        _current.value = page;
        emit("update:current", page);
        emit("change", page);
      }
    };
    const handlePageSizeChange = (pageSize) => {
      _pageSize.value = pageSize;
      emit("update:pageSize", pageSize);
      emit("pageSizeChange", pageSize);
    };
    const pagerProps = reactive({
      current: computedCurrent,
      pages,
      disabled,
      style: pageItemStyle,
      activeStyle: activePageItemStyle,
      onClick: handleClick
    });
    const getPageItemElement = (type, props2 = {}) => {
      if (type === "more") {
        return createVNode(EllipsisPager, mergeProps(props2, pagerProps), {
          default: slots["page-item-ellipsis"]
        });
      }
      if (type === "previous") {
        return createVNode(StepPager, mergeProps({
          "type": "previous"
        }, props2, pagerProps), {
          default: slots["page-item-step"]
        });
      }
      if (type === "next") {
        return createVNode(StepPager, mergeProps({
          "type": "next"
        }, props2, pagerProps), {
          default: slots["page-item-step"]
        });
      }
      return createVNode(Pager, mergeProps(props2, pagerProps), {
        default: slots["page-item"]
      });
    };
    const pageList = computed(() => {
      const pageList2 = [];
      if (pages.value < props.baseSize + props.bufferSize * 2) {
        for (let i2 = 1; i2 <= pages.value; i2++) {
          pageList2.push(getPageItemElement("page", {
            key: i2,
            pageNumber: i2
          }));
        }
      } else {
        let left = 1;
        let right = pages.value;
        let hasLeftEllipsis = false;
        let hasRightEllipsis = false;
        if (computedCurrent.value > 2 + props.bufferSize) {
          hasLeftEllipsis = true;
          left = Math.min(computedCurrent.value - props.bufferSize, pages.value - 2 * props.bufferSize);
        }
        if (computedCurrent.value < pages.value - (props.bufferSize + 1)) {
          hasRightEllipsis = true;
          right = Math.max(computedCurrent.value + props.bufferSize, 2 * props.bufferSize + 1);
        }
        if (hasLeftEllipsis) {
          pageList2.push(getPageItemElement("page", {
            key: 1,
            pageNumber: 1
          }));
          pageList2.push(getPageItemElement("more", {
            key: "left-ellipsis-pager",
            step: -(props.bufferSize * 2 + 1)
          }));
        }
        for (let i2 = left; i2 <= right; i2++) {
          pageList2.push(getPageItemElement("page", {
            key: i2,
            pageNumber: i2
          }));
        }
        if (hasRightEllipsis) {
          pageList2.push(getPageItemElement("more", {
            key: "right-ellipsis-pager",
            step: props.bufferSize * 2 + 1
          }));
          pageList2.push(getPageItemElement("page", {
            key: pages.value,
            pageNumber: pages.value
          }));
        }
      }
      return pageList2;
    });
    const renderPager = () => {
      if (props.simple) {
        return createVNode("span", {
          "class": `${prefixCls}-simple`
        }, [getPageItemElement("previous", {
          simple: true
        }), createVNode(PageJumper, {
          "disabled": props.disabled,
          "current": computedCurrent.value,
          "size": mergedSize.value,
          "pages": pages.value,
          "simple": true,
          "onChange": handleClick
        }, null), getPageItemElement("next", {
          simple: true
        })]);
      }
      return createVNode("ul", {
        "class": `${prefixCls}-list`
      }, [getPageItemElement("previous", {
        simple: true
      }), pageList.value, props.showMore && getPageItemElement("more", {
        key: "more",
        step: props.bufferSize * 2 + 1
      }), getPageItemElement("next", {
        simple: true
      })]);
    };
    watch(computedPageSize, (curPageSize, prePageSize) => {
      if (props.autoAdjust && curPageSize !== prePageSize && computedCurrent.value > 1) {
        const index2 = prePageSize * (computedCurrent.value - 1) + 1;
        const newPage = Math.ceil(index2 / curPageSize);
        if (newPage !== computedCurrent.value) {
          _current.value = newPage;
          emit("update:current", newPage);
          emit("change", newPage);
        }
      }
    });
    watch(pages, (curPages, prePages) => {
      if (props.autoAdjust && curPages !== prePages && computedCurrent.value > 1 && computedCurrent.value > curPages) {
        const newCurrent = Math.max(curPages, 1);
        _current.value = newCurrent;
        emit("update:current", newCurrent);
        emit("change", newCurrent);
      }
    });
    const cls = computed(() => [prefixCls, `${prefixCls}-size-${mergedSize.value}`, {
      [`${prefixCls}-simple`]: props.simple,
      [`${prefixCls}-disabled`]: props.disabled
    }]);
    return () => {
      var _a, _b;
      if (props.hideOnSinglePage && pages.value <= 1) {
        return null;
      }
      return createVNode("div", {
        "class": cls.value
      }, [props.showTotal && createVNode("span", {
        "class": `${prefixCls}-total`
      }, [(_b = (_a = slots.total) == null ? void 0 : _a.call(slots, {
        total: props.total
      })) != null ? _b : t("pagination.total", props.total)]), renderPager(), props.showPageSize && createVNode(PageOptions, {
        "disabled": props.disabled,
        "sizeOptions": props.pageSizeOptions,
        "pageSize": computedPageSize.value,
        "size": mergedSize.value,
        "onChange": handlePageSizeChange,
        "selectProps": props.pageSizeProps
      }, null), !props.simple && props.showJumper && createVNode(PageJumper, {
        "disabled": props.disabled,
        "current": computedCurrent.value,
        "pages": pages.value,
        "size": mergedSize.value,
        "onChange": handleClick
      }, {
        "jumper-prepend": slots["jumper-prepend"],
        "jumper-append": slots["jumper-append"]
      })]);
    };
  }
});
const Pagination = Object.assign(_Pagination, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Pagination.name, _Pagination);
  }
});
const usePagination$1 = (props, { emit }) => {
  var _a, _b;
  const _current = ref(
    isObject(props.paginationProps) ? (_a = props.paginationProps.defaultCurrent) != null ? _a : 1 : 1
  );
  const _pageSize = ref(
    isObject(props.paginationProps) ? (_b = props.paginationProps.defaultPageSize) != null ? _b : 10 : 10
  );
  const current = computed(
    () => {
      var _a2;
      return isObject(props.paginationProps) ? (_a2 = props.paginationProps.current) != null ? _a2 : _current.value : _current.value;
    }
  );
  const pageSize = computed(
    () => {
      var _a2;
      return isObject(props.paginationProps) ? (_a2 = props.paginationProps.pageSize) != null ? _a2 : _pageSize.value : _pageSize.value;
    }
  );
  const handlePageChange = (page) => {
    _current.value = page;
    emit("pageChange", page);
  };
  const handlePageSizeChange = (pageSize2) => {
    _pageSize.value = pageSize2;
    emit("pageSizeChange", pageSize2);
  };
  return {
    current,
    pageSize,
    handlePageChange,
    handlePageSizeChange
  };
};
function _isSlot$a(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var _List = defineComponent({
  name: "List",
  props: {
    data: {
      type: Array
    },
    size: {
      type: String,
      default: "medium"
    },
    bordered: {
      type: Boolean,
      default: true
    },
    split: {
      type: Boolean,
      default: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    paginationProps: {
      type: Object
    },
    gridProps: {
      type: Object
    },
    maxHeight: {
      type: [String, Number],
      default: 0
    },
    bottomOffset: {
      type: Number,
      default: 0
    },
    virtualListProps: {
      type: Object
    },
    scrollbar: {
      type: [Object, Boolean],
      default: true
    }
  },
  emits: {
    scroll: () => true,
    reachBottom: () => true,
    pageChange: (page) => true,
    pageSizeChange: (pageSize) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      scrollbar
    } = toRefs(props);
    const prefixCls = getPrefixCls("list");
    const configCtx = inject(configProviderInjectionKey, void 0);
    const {
      componentRef,
      elementRef: listRef
    } = useComponentRef("containerRef");
    const isVirtualList = computed(() => props.virtualListProps);
    const {
      displayScrollbar,
      scrollbarProps
    } = useScrollbar(scrollbar);
    let preScrollTop = 0;
    const handleScroll = (e) => {
      const {
        scrollTop,
        scrollHeight,
        offsetHeight
      } = e.target;
      const bottom = Math.floor(scrollHeight - (scrollTop + offsetHeight));
      if (scrollTop > preScrollTop && bottom <= props.bottomOffset) {
        emit("reachBottom");
      }
      emit("scroll");
      preScrollTop = scrollTop;
    };
    onMounted(() => {
      if (listRef.value) {
        const {
          scrollTop,
          scrollHeight,
          offsetHeight
        } = listRef.value;
        if (scrollHeight <= scrollTop + offsetHeight) {
          emit("reachBottom");
        }
      }
    });
    const {
      current,
      pageSize,
      handlePageChange,
      handlePageSizeChange
    } = usePagination$1(props, {
      emit
    });
    const getCurrentPageItems = (data) => {
      if (!props.paginationProps) {
        return data;
      }
      if (props.paginationProps && data.length > pageSize.value) {
        const startIndex = (current.value - 1) * pageSize.value;
        return data.slice(startIndex, startIndex + pageSize.value);
      }
      return data;
    };
    const renderGridItems = (data) => {
      let _slot2;
      if (!props.gridProps) {
        return null;
      }
      const currentPageItems = getCurrentPageItems(data);
      if (props.gridProps.span) {
        const items = [];
        const rowSize = 24 / props.gridProps.span;
        for (let i2 = 0; i2 < currentPageItems.length; i2 += rowSize) {
          let _slot;
          const nextIndex = i2 + rowSize;
          const rowIndex = Math.floor(i2 / rowSize);
          items.push(createVNode(Grid.Row, {
            "key": rowIndex,
            "class": `${prefixCls}-row`,
            "gutter": props.gridProps.gutter
          }, _isSlot$a(_slot = currentPageItems.slice(i2, nextIndex).map((item, index2) => {
            var _a;
            return createVNode(Grid.Col, {
              "key": `${rowIndex}-${index2}`,
              "class": `${prefixCls}-col`,
              "span": (_a = props.gridProps) == null ? void 0 : _a.span
            }, {
              default: () => {
                var _a2;
                return [isVNode(item) ? item : (_a2 = slots.item) == null ? void 0 : _a2.call(slots, {
                  item,
                  index: index2
                })];
              }
            });
          })) ? _slot : {
            default: () => [_slot]
          }));
        }
        return items;
      }
      return createVNode(Grid.Row, {
        "class": `${prefixCls}-row`,
        "gutter": props.gridProps.gutter
      }, _isSlot$a(_slot2 = currentPageItems.map((item, index2) => createVNode(Grid.Col, mergeProps({
        "key": index2,
        "class": `${prefixCls}-col`
      }, omit(props.gridProps, ["gutter"])), {
        default: () => {
          var _a;
          return [isVNode(item) ? item : (_a = slots.item) == null ? void 0 : _a.call(slots, {
            item,
            index: index2
          })];
        }
      }))) ? _slot2 : {
        default: () => [_slot2]
      });
    };
    const renderListItems = (data) => {
      const currentPageItems = getCurrentPageItems(data);
      return currentPageItems.map((item, index2) => {
        var _a;
        return isVNode(item) ? item : (_a = slots.item) == null ? void 0 : _a.call(slots, {
          item,
          index: index2
        });
      });
    };
    const renderItems = () => {
      const data = slots.default ? getAllElements(slots.default()) : props.data;
      if (data && data.length > 0) {
        return props.gridProps ? renderGridItems(data) : renderListItems(data);
      }
      return renderEmpty();
    };
    const renderPagination = () => {
      if (!props.paginationProps) {
        return null;
      }
      const paginationProps = omit(props.paginationProps, ["current", "pageSize", "defaultCurrent", "defaultPageSize"]);
      return createVNode(Pagination, mergeProps({
        "class": `${prefixCls}-pagination`
      }, paginationProps, {
        "current": current.value,
        "pageSize": pageSize.value,
        "onChange": handlePageChange,
        "onPageSizeChange": handlePageSizeChange
      }), null);
    };
    const cls = computed(() => [prefixCls, `${prefixCls}-${props.size}`, {
      [`${prefixCls}-bordered`]: props.bordered,
      [`${prefixCls}-split`]: props.split,
      [`${prefixCls}-hover`]: props.hoverable
    }]);
    const contentStyle = computed(() => {
      if (props.maxHeight) {
        const maxHeight = isNumber(props.maxHeight) ? `${props.maxHeight}px` : props.maxHeight;
        return {
          maxHeight,
          overflowY: "auto"
        };
      }
      return void 0;
    });
    const contentCls = computed(() => [`${prefixCls}-content`, {
      [`${prefixCls}-virtual`]: isVirtualList.value
    }]);
    const virtualListRef = ref();
    const renderVirtualList = () => {
      var _a;
      const currentPageItems = getCurrentPageItems((_a = props.data) != null ? _a : []);
      return currentPageItems.length ? createVNode(VirtualList, mergeProps({
        "ref": virtualListRef,
        "class": contentCls.value,
        "data": currentPageItems
      }, props.virtualListProps, {
        "onScroll": handleScroll
      }), {
        item: ({
          item,
          index: index2
        }) => {
          var _a2;
          return (_a2 = slots.item) == null ? void 0 : _a2.call(slots, {
            item,
            index: index2
          });
        }
      }) : renderEmpty();
    };
    const renderScrollLoading = () => {
      if (slots["scroll-loading"]) {
        return createVNode("div", {
          "class": [`${prefixCls}-item`, `${prefixCls}-scroll-loading`]
        }, [slots["scroll-loading"]()]);
      }
      return null;
    };
    const renderEmpty = () => {
      var _a, _b, _c, _d, _e;
      if (slots["scroll-loading"]) {
        return null;
      }
      return (_e = (_d = (_a = slots.empty) == null ? void 0 : _a.call(slots)) != null ? _d : (_c = configCtx == null ? void 0 : (_b = configCtx.slots).empty) == null ? void 0 : _c.call(_b, {
        component: "list"
      })) != null ? _e : createVNode(Empty, null, null);
    };
    const render2 = () => {
      const Component = displayScrollbar.value ? Scrollbar : "div";
      return createVNode("div", {
        "class": `${prefixCls}-wrapper`
      }, [createVNode(Spin, {
        "class": `${prefixCls}-spin`,
        "loading": props.loading
      }, {
        default: () => [createVNode(Component, mergeProps({
          "ref": componentRef,
          "class": cls.value,
          "style": contentStyle.value
        }, scrollbarProps.value, {
          "onScroll": handleScroll
        }), {
          default: () => [createVNode("div", {
            "class": `${prefixCls}-content-wrapper`
          }, [slots.header && createVNode("div", {
            "class": `${prefixCls}-header`
          }, [slots.header()]), isVirtualList.value && !props.gridProps ? createVNode(Fragment, null, [renderVirtualList(), renderScrollLoading()]) : createVNode("div", {
            "role": "list",
            "class": contentCls.value
          }, [renderItems(), renderScrollLoading()]), slots.footer && createVNode("div", {
            "class": `${prefixCls}-footer`
          }, [slots.footer()])])]
        }), renderPagination()]
      })]);
    };
    return {
      virtualListRef,
      render: render2
    };
  },
  methods: {
    scrollIntoView(options) {
      if (this.virtualListRef) {
        this.virtualListRef.scrollTo(options);
      }
    }
  },
  render() {
    return this.render();
  }
});
var ListItem = defineComponent({
  name: "ListItem",
  props: {
    actionLayout: {
      type: String,
      default: "horizontal"
    }
  },
  setup(props, {
    slots
  }) {
    const prefixCls = getPrefixCls("list-item");
    const renderAction = () => {
      var _a;
      const actions = (_a = slots.actions) == null ? void 0 : _a.call(slots);
      if (!actions || !actions.length) {
        return null;
      }
      return createVNode("ul", {
        "class": `${prefixCls}-action`
      }, [actions.map((item, index2) => createVNode("li", {
        "key": `${prefixCls}-action-${index2}`
      }, [item]))]);
    };
    return () => {
      var _a, _b;
      return createVNode("div", {
        "role": "listitem",
        "class": prefixCls
      }, [createVNode("div", {
        "class": `${prefixCls}-main`
      }, [(_a = slots.meta) == null ? void 0 : _a.call(slots), createVNode("div", {
        "class": `${prefixCls}-content`
      }, [(_b = slots.default) == null ? void 0 : _b.call(slots)]), props.actionLayout === "vertical" && renderAction()]), props.actionLayout === "horizontal" && renderAction(), slots.extra && createVNode("div", {
        "class": `${prefixCls}-extra`
      }, [slots.extra()])]);
    };
  }
});
const _sfc_main$4I = defineComponent({
  name: "ListItemMeta",
  props: {
    title: String,
    description: String
  },
  setup(props, { slots }) {
    const prefixCls = getPrefixCls("list-item-meta");
    const hasContent = Boolean(
      props.title || props.description || slots.title || slots.description
    );
    return {
      prefixCls,
      hasContent
    };
  }
});
function _sfc_render$4H(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.prefixCls)
  }, [
    _ctx.$slots.avatar ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-avatar`)
    }, [
      renderSlot(_ctx.$slots, "avatar")
    ], 2)) : createCommentVNode("v-if", true),
    _ctx.hasContent ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [
      _ctx.$slots.title || _ctx.title ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-title`)
      }, [
        renderSlot(_ctx.$slots, "title", {}, () => [
          createTextVNode(toDisplayString(_ctx.title), 1)
        ])
      ], 2)) : createCommentVNode("v-if", true),
      _ctx.$slots.description || _ctx.description ? (openBlock(), createElementBlock("div", {
        key: 1,
        class: normalizeClass(`${_ctx.prefixCls}-description`)
      }, [
        renderSlot(_ctx.$slots, "description", {}, () => [
          createTextVNode(toDisplayString(_ctx.description), 1)
        ])
      ], 2)) : createCommentVNode("v-if", true)
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var ListItemMeta = /* @__PURE__ */ _export_sfc(_sfc_main$4I, [["render", _sfc_render$4H]]);
const List = Object.assign(_List, {
  Item: Object.assign(ListItem, {
    Meta: ListItemMeta
  }),
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _List.name, _List);
    app.component(componentPrefix + ListItem.name, ListItem);
    app.component(componentPrefix + ListItemMeta.name, ListItemMeta);
  }
});
const sizeStyles = [
  "border-width",
  "box-sizing",
  "font-family",
  "font-weight",
  "font-size",
  "font-variant",
  "letter-spacing",
  "line-height",
  "padding-top",
  "padding-bottom",
  "padding-left",
  "padding-right",
  "text-indent",
  "text-rendering",
  "text-transform",
  "white-space",
  "overflow-wrap",
  "width"
];
const getSizeStyles = (styleDeclaration) => {
  const styles = {};
  sizeStyles.forEach((item) => {
    styles[item] = styleDeclaration.getPropertyValue(item);
  });
  return styles;
};
const _sfc_main$4H = defineComponent({
  name: "Textarea",
  components: { ResizeObserver: ResizeObserver$1, IconHover, IconClose },
  inheritAttrs: false,
  props: {
    modelValue: String,
    defaultValue: {
      type: String,
      default: ""
    },
    placeholder: String,
    disabled: {
      type: Boolean,
      default: false
    },
    error: {
      type: Boolean,
      default: false
    },
    maxLength: {
      type: [Number, Object],
      default: 0
    },
    showWordLimit: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    autoSize: {
      type: [Boolean, Object],
      default: false
    },
    wordLength: {
      type: Function
    },
    wordSlice: {
      type: Function
    },
    textareaAttrs: {
      type: Object
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "input": (value, ev) => true,
    "change": (value, ev) => true,
    "clear": (ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, { emit, attrs }) {
    const { disabled, error, modelValue } = toRefs(props);
    const prefixCls = getPrefixCls("textarea");
    const {
      mergedDisabled,
      mergedError: _mergedError,
      eventHandlers
    } = useFormItem({ disabled, error });
    const textareaRef = ref();
    const textareaStyle = ref();
    const mirrorRef = ref();
    const mirrorStyle = ref();
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => {
      var _a;
      return (_a = modelValue.value) != null ? _a : _value.value;
    });
    const [recordCursor, setCursor] = useCursor(textareaRef);
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = "";
      }
    });
    const maxLengthErrorOnly = computed(
      () => isObject(props.maxLength) && Boolean(props.maxLength.errorOnly)
    );
    const computedMaxLength = computed(() => {
      if (isObject(props.maxLength)) {
        return props.maxLength.length;
      }
      return props.maxLength;
    });
    const getValueLength = (value) => {
      var _a;
      if (isFunction(props.wordLength)) {
        return props.wordLength(value);
      }
      return (_a = value.length) != null ? _a : 0;
    };
    const valueLength = computed(() => getValueLength(computedValue.value));
    const mergedError = computed(
      () => _mergedError.value || Boolean(
        computedMaxLength.value && maxLengthErrorOnly.value && valueLength.value > computedMaxLength.value
      )
    );
    const isScroll2 = ref(false);
    const focused = ref(false);
    const showClearBtn = computed(
      () => props.allowClear && !mergedDisabled.value && computedValue.value
    );
    const isComposition = ref(false);
    const compositionValue = ref("");
    const keepControl = () => {
      recordCursor();
      nextTick(() => {
        if (textareaRef.value && computedValue.value !== textareaRef.value.value) {
          textareaRef.value.value = computedValue.value;
          setCursor();
        }
      });
    };
    const updateValue = (value, inner = true) => {
      var _a, _b;
      if (computedMaxLength.value && !maxLengthErrorOnly.value && getValueLength(value) > computedMaxLength.value) {
        value = (_b = (_a = props.wordSlice) == null ? void 0 : _a.call(props, value, computedMaxLength.value)) != null ? _b : value.slice(0, computedMaxLength.value);
      }
      _value.value = value;
      if (inner) {
        emit("update:modelValue", value);
      }
      keepControl();
    };
    let preValue = computedValue.value;
    const emitChange = (value, ev) => {
      var _a, _b;
      if (value !== preValue) {
        preValue = value;
        emit("change", value, ev);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a, ev);
      }
    };
    const handleFocus = (ev) => {
      var _a, _b;
      focused.value = true;
      preValue = computedValue.value;
      emit("focus", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onFocus) == null ? void 0 : _b.call(_a, ev);
    };
    const handleBlur = (ev) => {
      var _a, _b;
      focused.value = false;
      emit("blur", ev);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onBlur) == null ? void 0 : _b.call(_a, ev);
      emitChange(computedValue.value, ev);
    };
    const handleComposition = (e) => {
      var _a, _b;
      const { value } = e.target;
      if (e.type === "compositionend") {
        isComposition.value = false;
        compositionValue.value = "";
        if (computedMaxLength.value && !maxLengthErrorOnly.value && computedValue.value.length >= computedMaxLength.value && getValueLength(value) > computedMaxLength.value) {
          keepControl();
          return;
        }
        emit("input", value, e);
        updateValue(value);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onInput) == null ? void 0 : _b.call(_a, e);
      } else {
        isComposition.value = true;
      }
    };
    const handleInput = (e) => {
      var _a, _b;
      const { value } = e.target;
      if (!isComposition.value) {
        if (computedMaxLength.value && !maxLengthErrorOnly.value && computedValue.value.length >= computedMaxLength.value && getValueLength(value) > computedMaxLength.value && e.inputType === "insertText") {
          keepControl();
          return;
        }
        emit("input", value, e);
        updateValue(value);
        (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onInput) == null ? void 0 : _b.call(_a, e);
      } else {
        compositionValue.value = value;
      }
    };
    const handleClear = (ev) => {
      updateValue("");
      emitChange("", ev);
      emit("clear", ev);
    };
    watch(modelValue, (value) => {
      if (value !== computedValue.value) {
        updateValue(value != null ? value : "", false);
      }
    });
    const getWrapperAttrs = (attr) => omit(attrs, INPUT_EVENTS);
    const getTextareaAttrs = (attr) => pick(attrs, INPUT_EVENTS);
    const textareaAttrs = getTextareaAttrs();
    const mergeTextareaAttrs = computed(() => {
      const attrs2 = {
        ...textareaAttrs,
        ...props.textareaAttrs
      };
      if (mergedError.value) {
        attrs2["aria-invalid"] = true;
      }
      return attrs2;
    });
    const wrapperCls = computed(() => [
      `${prefixCls}-wrapper`,
      {
        [`${prefixCls}-focus`]: focused.value,
        [`${prefixCls}-disabled`]: mergedDisabled.value,
        [`${prefixCls}-error`]: mergedError.value,
        [`${prefixCls}-scroll`]: isScroll2.value
      }
    ]);
    let styleDeclaration;
    const lineHeight = ref(0);
    const outerHeight = ref(0);
    const minHeight = computed(() => {
      if (!isObject(props.autoSize) || !props.autoSize.minRows) {
        return 0;
      }
      return props.autoSize.minRows * lineHeight.value + outerHeight.value;
    });
    const maxHeight = computed(() => {
      if (!isObject(props.autoSize) || !props.autoSize.maxRows) {
        return 0;
      }
      return props.autoSize.maxRows * lineHeight.value + outerHeight.value;
    });
    const getMirrorStyle = () => {
      const styles = getSizeStyles(styleDeclaration);
      lineHeight.value = Number.parseInt(styles["line-height"] || 0, 10);
      outerHeight.value = Number.parseInt(styles["border-width"] || 0, 10) * 2 + Number.parseInt(styles["padding-top"] || 0, 10) + Number.parseInt(styles["padding-bottom"] || 0, 10);
      mirrorStyle.value = styles;
      nextTick(() => {
        var _a;
        const mirrorHeight = (_a = mirrorRef.value) == null ? void 0 : _a.offsetHeight;
        let height = mirrorHeight != null ? mirrorHeight : 0;
        let overflow = "hidden";
        if (minHeight.value && height < minHeight.value) {
          height = minHeight.value;
        }
        if (maxHeight.value && height > maxHeight.value) {
          height = maxHeight.value;
          overflow = "auto";
        }
        textareaStyle.value = {
          height: `${height}px`,
          resize: "none",
          overflow
        };
      });
    };
    onMounted(() => {
      if (textareaRef.value) {
        styleDeclaration = window.getComputedStyle(textareaRef.value);
        if (props.autoSize) {
          getMirrorStyle();
        }
      }
      computeIsScroll();
    });
    const handleResize = () => {
      if (props.autoSize && mirrorRef.value) {
        getMirrorStyle();
      }
      computeIsScroll();
    };
    const handleMousedown = (e) => {
      if (textareaRef.value && e.target !== textareaRef.value) {
        e.preventDefault();
        textareaRef.value.focus();
      }
    };
    const computeIsScroll = () => {
      if (textareaRef.value) {
        if (textareaRef.value.scrollHeight > textareaRef.value.offsetHeight) {
          if (!isScroll2.value)
            isScroll2.value = true;
        } else if (isScroll2.value) {
          isScroll2.value = false;
        }
      }
    };
    watch(computedValue, () => {
      if (props.autoSize && mirrorRef.value) {
        getMirrorStyle();
      }
      computeIsScroll();
    });
    return {
      prefixCls,
      wrapperCls,
      textareaRef,
      textareaStyle,
      mirrorRef,
      mirrorStyle,
      computedValue,
      showClearBtn,
      valueLength,
      computedMaxLength,
      mergedDisabled,
      mergeTextareaAttrs,
      getWrapperAttrs,
      getTextareaAttrs,
      handleInput,
      handleFocus,
      handleBlur,
      handleComposition,
      handleClear,
      handleResize,
      handleMousedown
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.$refs.textareaRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.$refs.textareaRef) == null ? void 0 : _a.blur();
    }
  }
});
const _hoisted_1$42 = ["disabled", "value", "placeholder"];
function _sfc_render$4G(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_resize_observer = resolveComponent("resize-observer");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  return openBlock(), createElementBlock("div", mergeProps(_ctx.getWrapperAttrs(_ctx.$attrs), {
    class: _ctx.wrapperCls,
    onMousedown: _cache[7] || (_cache[7] = (...args) => _ctx.handleMousedown && _ctx.handleMousedown(...args))
  }), [
    _ctx.autoSize ? (openBlock(), createElementBlock("div", {
      key: 0,
      ref: "mirrorRef",
      class: normalizeClass(`${_ctx.prefixCls}-mirror`),
      style: normalizeStyle(_ctx.mirrorStyle)
    }, toDisplayString(`${_ctx.computedValue}
`), 7)) : createCommentVNode("v-if", true),
    createVNode(_component_resize_observer, { onResize: _ctx.handleResize }, {
      default: withCtx(() => [
        createBaseVNode("textarea", mergeProps({ ref: "textareaRef" }, _ctx.mergeTextareaAttrs, {
          disabled: _ctx.mergedDisabled,
          class: _ctx.prefixCls,
          style: _ctx.textareaStyle,
          value: _ctx.computedValue,
          placeholder: _ctx.placeholder,
          onInput: _cache[0] || (_cache[0] = (...args) => _ctx.handleInput && _ctx.handleInput(...args)),
          onFocus: _cache[1] || (_cache[1] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
          onBlur: _cache[2] || (_cache[2] = (...args) => _ctx.handleBlur && _ctx.handleBlur(...args)),
          onCompositionstart: _cache[3] || (_cache[3] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
          onCompositionupdate: _cache[4] || (_cache[4] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
          onCompositionend: _cache[5] || (_cache[5] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args))
        }), null, 16, _hoisted_1$42)
      ]),
      _: 1
    }, 8, ["onResize"]),
    renderSlot(_ctx.$slots, "suffix"),
    _ctx.computedMaxLength && _ctx.showWordLimit ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-word-limit`)
    }, toDisplayString(_ctx.valueLength) + "/" + toDisplayString(_ctx.computedMaxLength), 3)) : createCommentVNode("v-if", true),
    _ctx.showClearBtn ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(`${_ctx.prefixCls}-clear-btn`),
      onClick: _cache[6] || (_cache[6] = (...args) => _ctx.handleClear && _ctx.handleClear(...args))
    }, [
      createVNode(_component_icon_hover, null, {
        default: withCtx(() => [
          createVNode(_component_icon_close)
        ]),
        _: 1
      })
    ], 2)) : createCommentVNode("v-if", true)
  ], 16);
}
var _Textarea = /* @__PURE__ */ _export_sfc(_sfc_main$4H, [["render", _sfc_render$4G]]);
const Textarea = Object.assign(_Textarea, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Textarea.name, _Textarea);
  }
});
const getTextBeforeSelection = (element) => {
  const { value, selectionStart } = element;
  return value.slice(0, selectionStart);
};
const getLastMeasureIndex = (text, prefix) => {
  const _prefix = [].concat(prefix);
  return _prefix.reduce(
    (pre, value) => {
      const lastIndex = text.lastIndexOf(value);
      if (lastIndex > pre.location) {
        return {
          location: lastIndex,
          prefix: value
        };
      }
      return pre;
    },
    {
      location: -1,
      prefix: ""
    }
  );
};
const isValidSearch = (text, split) => {
  return !split || !text.includes(split);
};
function _isSlot$9(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var _Mention = defineComponent({
  name: "Mention",
  inheritAttrs: false,
  props: {
    modelValue: String,
    defaultValue: {
      type: String,
      default: ""
    },
    data: {
      type: Array,
      default: () => []
    },
    prefix: {
      type: [String, Array],
      default: "@"
    },
    split: {
      type: String,
      default: " "
    },
    type: {
      type: String,
      default: "input"
    },
    disabled: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value) => true,
    "search": (value, prefix) => true,
    "select": (value) => true,
    "clear": (ev) => true,
    "focus": (ev) => true,
    "blur": (ev) => true
  },
  setup(props, {
    emit,
    attrs,
    slots
  }) {
    const prefixCls = getPrefixCls("mention");
    let styleDeclaration;
    const {
      mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled: toRef(props, "disabled")
    });
    const {
      data,
      modelValue
    } = toRefs(props);
    const dropdownRef = ref();
    const optionRefs = ref({});
    const _value = ref(props.defaultValue);
    const computedValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : _value.value;
    });
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = "";
      }
    });
    const computedValueKeys = computed(() => computedValue.value ? [getKeyFromValue(computedValue.value)] : []);
    const measureInfo = ref({
      measuring: false,
      location: -1,
      prefix: "",
      text: ""
    });
    const resetMeasureInfo = () => {
      measureInfo.value = {
        measuring: false,
        location: -1,
        prefix: "",
        text: ""
      };
    };
    const inputRef = ref();
    const measureText = computed(() => measureInfo.value.text);
    const filterOption = ref(true);
    const handleInput = (value, e) => {
      var _a, _b;
      const text = getTextBeforeSelection(e.target);
      const lastMeasure = getLastMeasureIndex(text, props.prefix);
      if (lastMeasure.location > -1) {
        const measureText2 = text.slice(lastMeasure.location + lastMeasure.prefix.length);
        if (isValidSearch(measureText2, props.split)) {
          _popupVisible.value = true;
          measureInfo.value = {
            measuring: true,
            text: measureText2,
            ...lastMeasure
          };
          emit("search", measureText2, lastMeasure.prefix);
        } else if (measureInfo.value.location > -1) {
          resetMeasureInfo();
        }
      } else if (measureInfo.value.location > -1) {
        resetMeasureInfo();
      }
      _value.value = value;
      emit("update:modelValue", value);
      emit("change", value);
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
    };
    const handleClear = (ev) => {
      var _a, _b;
      _value.value = "";
      emit("update:modelValue", "");
      emit("change", "");
      (_b = (_a = eventHandlers.value) == null ? void 0 : _a.onChange) == null ? void 0 : _b.call(_a);
      emit("clear", ev);
    };
    const _popupVisible = ref(false);
    const computedPopupVisible = computed(() => _popupVisible.value && measureInfo.value.measuring && validOptionInfos.value.length > 0);
    const handleResize = () => {
      mirrorStyle.value = getSizeStyles(styleDeclaration);
    };
    const handlePopupVisibleChange = (popupVisible) => {
      _popupVisible.value = popupVisible;
    };
    const handleSelect = (key, e) => {
      var _a, _b, _c;
      const {
        value
      } = (_a = optionInfoMap.get(key)) != null ? _a : {};
      const measureStart = measureInfo.value.location;
      const measureEnd = measureInfo.value.location + measureInfo.value.text.length;
      let head = _value.value.slice(0, measureStart);
      let tail = _value.value.slice(measureEnd + 1);
      head += !head || head.endsWith(props.split) || head.endsWith("\n") ? "" : props.split;
      tail = (!tail || tail.startsWith(props.split) || tail.startsWith("\n") ? "" : props.split) + tail;
      const match = `${measureInfo.value.prefix}${value}`;
      const nextValue = `${head}${match}${tail}`;
      _value.value = nextValue;
      emit("select", value);
      emit("update:modelValue", nextValue);
      emit("change", nextValue);
      resetMeasureInfo();
      (_c = (_b = eventHandlers.value) == null ? void 0 : _b.onChange) == null ? void 0 : _c.call(_b);
    };
    const {
      validOptions,
      optionInfoMap,
      validOptionInfos,
      handleKeyDown
    } = useSelect({
      options: data,
      inputValue: measureText,
      filterOption,
      popupVisible: computedPopupVisible,
      valueKeys: computedValueKeys,
      dropdownRef,
      optionRefs,
      onSelect: handleSelect,
      onPopupVisibleChange: handlePopupVisibleChange,
      enterToOpen: false
    });
    const mirrorStyle = ref();
    onMounted(() => {
      var _a;
      if (props.type === "textarea" && ((_a = inputRef.value) == null ? void 0 : _a.textareaRef)) {
        styleDeclaration = window.getComputedStyle(inputRef.value.textareaRef);
        mirrorStyle.value = getSizeStyles(styleDeclaration);
      }
    });
    const getOptionContentFunc = (item) => {
      if (isFunction(slots.option) && item.value) {
        const optionInfo = optionInfoMap.get(item.key);
        const optionSlot = slots.option;
        return () => optionSlot({
          data: optionInfo
        });
      }
      return () => item.label;
    };
    const renderOption = (item) => {
      return createVNode(Option, {
        "ref": (ref2) => {
          if (ref2 == null ? void 0 : ref2.$el) {
            optionRefs.value[item.key] = ref2.$el;
          }
        },
        "key": item.key,
        "value": item.value,
        "disabled": item.disabled,
        "internal": true
      }, {
        default: getOptionContentFunc(item)
      });
    };
    const renderDropdown = () => {
      let _slot;
      return createVNode(SelectDropdown, {
        "ref": dropdownRef
      }, _isSlot$9(_slot = validOptions.value.map((info) => renderOption(info))) ? _slot : {
        default: () => [_slot]
      });
    };
    const mirrorRef = ref();
    watch(computedPopupVisible, (visible) => {
      if (props.type === "textarea" && visible) {
        nextTick(() => {
          var _a, _b;
          if (((_a = inputRef.value) == null ? void 0 : _a.textareaRef) && inputRef.value.textareaRef.scrollTop > 0) {
            (_b = mirrorRef.value) == null ? void 0 : _b.scrollTo(0, inputRef.value.textareaRef.scrollTop);
          }
        });
      }
    });
    const onFocus = (ev) => {
      emit("focus", ev);
    };
    const onBlur = (ev) => {
      emit("blur", ev);
    };
    const render2 = () => {
      var _a;
      if (props.type === "textarea") {
        return createVNode("div", {
          "class": prefixCls
        }, [createVNode(ResizeObserver$1, {
          "onResize": handleResize
        }, {
          default: () => [createVNode(Textarea, mergeProps(attrs, {
            "ref": inputRef,
            "allowClear": props.allowClear,
            "modelValue": computedValue.value,
            "disabled": mergedDisabled.value,
            "onInput": handleInput,
            "onClear": handleClear,
            "onFocus": onFocus,
            "onBlur": onBlur,
            "onKeydown": handleKeyDown
          }), null)]
        }), measureInfo.value.measuring && validOptionInfos.value.length > 0 && createVNode("div", {
          "ref": mirrorRef,
          "style": mirrorStyle.value,
          "class": `${prefixCls}-measure`
        }, [(_a = computedValue.value) == null ? void 0 : _a.slice(0, measureInfo.value.location), createVNode(Trigger, {
          "trigger": "focus",
          "position": "bl",
          "popupOffset": 4,
          "preventFocus": true,
          "popupVisible": computedPopupVisible.value,
          "clickToClose": false,
          "onPopupVisibleChange": handlePopupVisibleChange
        }, {
          default: () => [createVNode("span", null, [createTextVNode("@")])],
          content: renderDropdown
        })])]);
      }
      return createVNode(Trigger, {
        "trigger": "focus",
        "position": "bl",
        "animationName": "slide-dynamic-origin",
        "popupOffset": 4,
        "preventFocus": true,
        "popupVisible": computedPopupVisible.value,
        "clickToClose": false,
        "autoFitPopupWidth": true,
        "autoFitTransformOrigin": true,
        "disabled": mergedDisabled.value,
        "onPopupVisibleChange": handlePopupVisibleChange
      }, {
        default: () => [createVNode(Input, mergeProps(attrs, {
          "ref": inputRef,
          "allowClear": props.allowClear,
          "modelValue": computedValue.value,
          "disabled": mergedDisabled.value,
          "onInput": handleInput,
          "onClear": handleClear,
          "onFocus": onFocus,
          "onBlur": onBlur,
          "onKeydown": handleKeyDown
        }), slots)],
        content: renderDropdown
      });
    };
    return {
      inputRef,
      render: render2
    };
  },
  methods: {
    focus() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.focus();
    },
    blur() {
      var _a;
      (_a = this.inputRef) == null ? void 0 : _a.blur();
    }
  },
  render() {
    return this.render();
  }
});
const Mention = Object.assign(_Mention, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Mention.name, _Mention);
  }
});
const MenuInjectionKey = Symbol("MenuInjectionKey");
const LevelInjectionKey = Symbol("LevelInjectionKey");
const DataCollectorInjectionKey = Symbol("DataCollectorInjectionKey");
const _sfc_main$4G = defineComponent({
  name: "IconMenuFold",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-menu-fold`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$41 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4F(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M42 11H6M42 24H22M42 37H6M13.66 26.912l-4.82-3.118 4.82-3.118v6.236Z" }, null, -1)
  ]), 14, _hoisted_1$41);
}
var _IconMenuFold = /* @__PURE__ */ _export_sfc(_sfc_main$4G, [["render", _sfc_render$4F]]);
const IconMenuFold = Object.assign(_IconMenuFold, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconMenuFold.name, _IconMenuFold);
  }
});
const _sfc_main$4F = defineComponent({
  name: "IconMenuUnfold",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-menu-unfold`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$40 = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4E(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M6 11h36M22 24h20M6 37h36M8 20.882 12.819 24 8 27.118v-6.236Z" }, null, -1)
  ]), 14, _hoisted_1$40);
}
var _IconMenuUnfold = /* @__PURE__ */ _export_sfc(_sfc_main$4F, [["render", _sfc_render$4E]]);
const IconMenuUnfold = Object.assign(_IconMenuUnfold, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconMenuUnfold.name, _IconMenuUnfold);
  }
});
function provideLevel(level) {
  const computedLevel = computed(() => isRef(level) ? level.value : level);
  provide(
    LevelInjectionKey,
    reactive({
      level: computedLevel
    })
  );
}
function useLevel(props) {
  const { provideNextLevel } = props || {};
  const levelContext = inject(LevelInjectionKey);
  const level = computed(() => (levelContext == null ? void 0 : levelContext.level) || 1);
  if (provideNextLevel) {
    const nextLevel = computed(() => level.value + 1);
    provideLevel(nextLevel);
  }
  return {
    level
  };
}
function getKeys$1(data, condition) {
  const keys = [];
  const loop = (list) => {
    list.forEach((item) => {
      if (condition(item)) {
        keys.push(item.key);
      }
      if (item.children) {
        loop(item.children);
      }
    });
  };
  loop(data);
  return keys;
}
function useMenuDataCollectorContext(isRoot = false) {
  const menuContext = isRoot ? void 0 : inject(DataCollectorInjectionKey);
  return menuContext;
}
function useMenuDataCollector(props) {
  const { key, type } = props;
  const data = ref([]);
  const menuContext = useMenuDataCollectorContext(type === "menu");
  const provideContext = {
    collectSubMenu(key2, children, isReport = false) {
      const item = {
        key: key2,
        children
      };
      if (isReport) {
        const oldOne = data.value.find((i2) => i2.key === key2);
        if (oldOne) {
          oldOne.children = children;
        } else {
          data.value.push(item);
        }
      } else {
        data.value = [...data.value, item];
      }
      if (isReport) {
        if (type === "popupMenu") {
          menuContext == null ? void 0 : menuContext.reportMenuData(data.value);
        } else if (type === "subMenu" && !isUndefined(key2)) {
          menuContext == null ? void 0 : menuContext.collectSubMenu(key2, data.value, true);
        }
      }
    },
    removeSubMenu(key2) {
      data.value = data.value.filter((item) => item.key !== key2);
    },
    collectMenuItem(key2) {
      data.value.push({ key: key2 });
    },
    removeMenuItem(key2) {
      data.value = data.value.filter((item) => item.key !== key2);
    },
    reportMenuData(reportData) {
      data.value = reportData;
      if (type === "subMenu" && !isUndefined(key)) {
        menuContext == null ? void 0 : menuContext.collectSubMenu(key, data.value, true);
      }
    }
  };
  provide(DataCollectorInjectionKey, provideContext);
  if (type === "subMenu" && !isUndefined(key)) {
    onMounted(() => {
      menuContext == null ? void 0 : menuContext.collectSubMenu(key, data.value);
    });
    onUnmounted(() => {
      menuContext == null ? void 0 : menuContext.removeSubMenu(key);
    });
  } else if (type === "popupMenu") {
    onMounted(() => {
      menuContext == null ? void 0 : menuContext.reportMenuData(data.value);
    });
  }
  return {
    menuData: data,
    subMenuKeys: computed(() => getKeys$1(data.value, (item) => !!item.children)),
    menuItemKeys: computed(() => getKeys$1(data.value, (item) => !item.children))
  };
}
function getPath(data, key) {
  const path = [];
  const loop = (list) => {
    for (let i2 = 0; i2 < list.length; i2++) {
      const item = list[i2];
      if (item.key === key) {
        return true;
      }
      if (item.children) {
        path.push(item.key);
        const matched = loop(item.children);
        if (matched) {
          return true;
        }
        path.pop();
      }
    }
    return false;
  };
  loop(data);
  return path;
}
function isSameKeys(keys1, keys2) {
  if (keys1.length !== keys2.length)
    return false;
  return keys1.toString() === keys2.toString();
}
function useMenuOpenState(props) {
  const {
    modelValue,
    defaultValue,
    autoOpen,
    autoOpenSelected,
    subMenuKeys,
    selectedKeys,
    menuData,
    accordion
  } = toRefs(props);
  const localValue = ref(
    !isUndefined(modelValue.value) ? modelValue.value : !isUndefined(defaultValue.value) ? defaultValue.value : []
  );
  const setLocalValue = (val) => {
    localValue.value = val;
  };
  watch(modelValue, () => {
    if (isUndefined(modelValue.value)) {
      setLocalValue([]);
    }
  });
  let mountedSubMenuKeys = [];
  onMounted(() => {
    mountedSubMenuKeys = [...subMenuKeys.value];
    let newOpenKeys = [];
    if (autoOpen.value) {
      newOpenKeys = accordion.value ? subMenuKeys.value.slice(0, 1) : [...subMenuKeys.value];
    }
    if (autoOpenSelected.value) {
      const pathList = selectedKeys.value.map(
        (key) => getPath(menuData.value, key)
      );
      if (pathList.length && (!autoOpen.value || accordion.value)) {
        newOpenKeys = accordion.value ? pathList[0] : [...new Set([].concat(...pathList))];
      }
    }
    if (newOpenKeys.length) {
      setLocalValue(newOpenKeys);
    }
  });
  let hasTriggered = false;
  watch(subMenuKeys, (currentKeys, prevKeys = []) => {
    if (hasTriggered || !isSameKeys(currentKeys, mountedSubMenuKeys)) {
      const newOpenKeys = openKeys.value.filter(
        (key) => currentKeys.includes(key)
      );
      if (autoOpen.value) {
        const keysAdded = currentKeys.filter((key) => !prevKeys.includes(key));
        newOpenKeys.push(...keysAdded);
      }
      setLocalValue(accordion.value ? newOpenKeys.slice(0, 1) : newOpenKeys);
    }
    hasTriggered = true;
  });
  const openKeys = computed(() => modelValue.value || localValue.value);
  return {
    openKeys,
    localOpenKeys: localValue,
    setOpenKeys: setLocalValue,
    open(key, level) {
      let newOpenKeys = [];
      if (openKeys.value.indexOf(key) > -1) {
        if (accordion.value && level === 1) {
          newOpenKeys = [];
        } else {
          newOpenKeys = openKeys.value.filter((i2) => i2 !== key);
        }
      } else if (accordion.value && level === 1) {
        newOpenKeys = [key];
      } else {
        newOpenKeys = openKeys.value.concat([key]);
      }
      setLocalValue(newOpenKeys);
      return newOpenKeys;
    }
  };
}
const _sfc_main$4E = defineComponent({
  name: "BaseMenu",
  components: {
    IconMenuFold,
    IconMenuUnfold
  },
  inheritAttrs: false,
  props: {
    style: {
      type: Object
    },
    theme: {
      type: String,
      default: "light"
    },
    mode: {
      type: String,
      default: "vertical"
    },
    levelIndent: {
      type: Number
    },
    autoOpen: {
      type: Boolean
    },
    collapsed: {
      type: Boolean,
      default: void 0
    },
    defaultCollapsed: {
      type: Boolean
    },
    collapsedWidth: {
      type: Number
    },
    accordion: {
      type: Boolean
    },
    autoScrollIntoView: {
      type: Boolean
    },
    showCollapseButton: {
      type: Boolean
    },
    selectedKeys: {
      type: Array
    },
    defaultSelectedKeys: {
      type: Array,
      default: () => []
    },
    openKeys: {
      type: Array
    },
    defaultOpenKeys: {
      type: Array,
      default: () => []
    },
    scrollConfig: {
      type: Object
    },
    triggerProps: {
      type: Object
    },
    tooltipProps: {
      type: Object
    },
    autoOpenSelected: {
      type: Boolean
    },
    breakpoint: {
      type: String
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: true
    },
    prefixCls: {
      type: String
    },
    inTrigger: {
      type: Boolean
    },
    siderCollapsed: {
      type: Boolean
    },
    isRoot: {
      type: Boolean
    }
  },
  emits: [
    "update:collapsed",
    "update:selectedKeys",
    "update:openKeys",
    "collapse",
    "menu-item-click",
    "sub-menu-click"
  ],
  setup(props, { emit, slots }) {
    const {
      style,
      mode,
      theme,
      levelIndent,
      accordion,
      showCollapseButton,
      scrollConfig,
      autoScrollIntoView,
      collapsedWidth,
      autoOpen,
      collapsed: propCollapsed,
      defaultCollapsed,
      selectedKeys: propSelectedKeys,
      defaultSelectedKeys,
      openKeys: propOpenKeys,
      defaultOpenKeys,
      triggerProps,
      tooltipProps,
      autoOpenSelected,
      breakpoint,
      popupMaxHeight,
      prefixCls,
      inTrigger,
      siderCollapsed,
      isRoot
    } = toRefs(props);
    const { subMenuKeys, menuData } = useMenuDataCollector({
      type: isRoot.value ? "menu" : "popupMenu"
    });
    const [selectedKeys, setSelectedKeys] = useMergeState(
      defaultSelectedKeys.value,
      reactive({
        value: propSelectedKeys
      })
    );
    const { openKeys, setOpenKeys, open: open2 } = useMenuOpenState(
      reactive({
        modelValue: propOpenKeys,
        defaultValue: defaultOpenKeys,
        autoOpen,
        autoOpenSelected,
        selectedKeys,
        subMenuKeys,
        menuData,
        accordion
      })
    );
    const [collapsed, setCollapsed] = useMergeState(
      defaultCollapsed.value,
      reactive({
        value: propCollapsed
      })
    );
    const computedCollapsed = computed(
      () => siderCollapsed.value || collapsed.value || mode.value === "popButton"
    );
    const computedHasCollapseButton = computed(
      () => ["horizontal", "popButton"].indexOf(mode.value) < 0 && !inTrigger.value && showCollapseButton.value
    );
    const changeCollapsed = (newVal, type) => {
      if (newVal === collapsed.value)
        return;
      setCollapsed(newVal);
      emit("update:collapsed", newVal);
      emit("collapse", newVal, type);
    };
    const onCollapseBtnClick = () => {
      changeCollapsed(!collapsed.value, "clickTrigger");
    };
    useResponsive(breakpoint, (checked) => {
      changeCollapsed(!checked, "responsive");
    });
    const computedPrefixCls = computed(
      () => (prefixCls == null ? void 0 : prefixCls.value) || getPrefixCls("menu")
    );
    const classNames = computed(() => [
      computedPrefixCls.value,
      `${computedPrefixCls.value}-${theme == null ? void 0 : theme.value}`,
      {
        [`${computedPrefixCls.value}-horizontal`]: mode.value === "horizontal",
        [`${computedPrefixCls.value}-vertical`]: mode.value !== "horizontal",
        [`${computedPrefixCls.value}-collapsed`]: computedCollapsed.value,
        [`${computedPrefixCls.value}-pop`]: mode.value === "pop" || computedCollapsed.value,
        [`${computedPrefixCls.value}-pop-button`]: mode.value === "popButton"
      }
    ]);
    const computedStyle = computed(() => {
      const pxCollapsedWidth = isNumber(collapsedWidth.value) ? `${collapsedWidth.value}px` : void 0;
      const objectStyle = isObject(style.value) ? style.value : void 0;
      const width = computedCollapsed.value ? pxCollapsedWidth : objectStyle == null ? void 0 : objectStyle.width;
      return [
        objectStyle ? omit(objectStyle, ["width"]) : style.value,
        { width }
      ];
    });
    const expandIconDown = usePickSlots(slots, "expand-icon-down");
    const expandIconRight = usePickSlots(slots, "expand-icon-right");
    const menuContext = reactive({
      theme,
      mode,
      levelIndent,
      autoScrollIntoView,
      selectedKeys,
      openKeys,
      prefixCls: computedPrefixCls,
      scrollConfig,
      inTrigger,
      collapsed: computedCollapsed,
      triggerProps,
      tooltipProps,
      popupMaxHeight,
      expandIconDown,
      expandIconRight,
      onMenuItemClick: (key) => {
        setSelectedKeys([key]);
        emit("update:selectedKeys", [key]);
        emit("menu-item-click", key);
      },
      onSubMenuClick: (key, level) => {
        const newOpenKeys = open2(key, level);
        setOpenKeys(newOpenKeys);
        emit("update:openKeys", newOpenKeys);
        emit("sub-menu-click", key, newOpenKeys);
      }
    });
    provide(MenuInjectionKey, menuContext);
    provideLevel(1);
    return {
      computedPrefixCls,
      classNames,
      computedStyle,
      computedCollapsed,
      computedHasCollapseButton,
      onCollapseBtnClick
    };
  }
});
function _sfc_render$4D(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_IconMenuUnfold = resolveComponent("IconMenuUnfold");
  const _component_IconMenuFold = resolveComponent("IconMenuFold");
  return openBlock(), createElementBlock("div", mergeProps({ class: _ctx.classNames }, _ctx.$attrs, { style: _ctx.computedStyle }), [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.computedPrefixCls}-inner`)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2),
    _ctx.computedHasCollapseButton ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.computedPrefixCls}-collapse-button`),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onCollapseBtnClick && _ctx.onCollapseBtnClick(...args))
    }, [
      renderSlot(_ctx.$slots, "collapse-icon", { collapsed: _ctx.computedCollapsed }, () => [
        _ctx.computedCollapsed ? (openBlock(), createBlock(_component_IconMenuUnfold, { key: 0 })) : (openBlock(), createBlock(_component_IconMenuFold, { key: 1 }))
      ])
    ], 2)) : createCommentVNode("v-if", true)
  ], 16);
}
var BaseMenu = /* @__PURE__ */ _export_sfc(_sfc_main$4E, [["render", _sfc_render$4D]]);
function getStyle$1(element, prop) {
  if (!element || !prop)
    return null;
  let styleName = prop;
  if (styleName === "float") {
    styleName = "cssFloat";
  }
  try {
    if (document.defaultView) {
      const computed2 = document.defaultView.getComputedStyle(element, "");
      return element.style[styleName] || computed2 ? computed2[styleName] : "";
    }
  } catch (e) {
    return element.style[styleName];
  }
  return null;
}
function useMenuContext() {
  const menuContext = inject(MenuInjectionKey);
  return menuContext || {};
}
const generateId = (() => {
  let i2 = 0;
  return (prefix = "") => {
    i2 += 1;
    return `${prefix}${i2}`;
  };
})();
function useMenu() {
  const instance = getCurrentInstance();
  const key = computed(
    () => (instance == null ? void 0 : instance.vnode.key) || generateId("__arco_menu")
  );
  return {
    key
  };
}
const _sfc_main$4D = defineComponent({
  name: "MenuIndent",
  props: {
    level: {
      type: Number,
      default: 1
    }
  },
  setup() {
    const prefixCls = getPrefixCls("menu");
    const menuContext = useMenuContext();
    return {
      prefixCls,
      levelIndent: toRef(menuContext, "levelIndent")
    };
  }
});
function _sfc_render$4C(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.level > 1 ? (openBlock(), createElementBlock("span", {
    key: 0,
    class: normalizeClass(`${_ctx.prefixCls}-indent-list`)
  }, [
    (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.level - 1, (index2) => {
      return openBlock(), createElementBlock("span", {
        key: index2,
        class: normalizeClass(`${_ctx.prefixCls}-indent`),
        style: normalizeStyle(`width: ${_ctx.levelIndent}px`)
      }, null, 6);
    }), 128))
  ], 2)) : createCommentVNode("v-if", true);
}
var MenuIndent = /* @__PURE__ */ _export_sfc(_sfc_main$4D, [["render", _sfc_render$4C]]);
const _sfc_main$4C = defineComponent({
  name: "ExpandTransition",
  setup() {
    return {
      onBeforeEnter(el) {
        el.style.height = "0";
      },
      onEnter(el) {
        el.style.height = `${el.scrollHeight}px`;
      },
      onAfterEnter(el) {
        el.style.height = "";
      },
      onBeforeLeave(el) {
        el.style.height = `${el.scrollHeight}px`;
      },
      onLeave(el) {
        el.style.height = `0`;
      },
      onAfterLeave(el) {
        el.style.height = ``;
      }
    };
  }
});
function _sfc_render$4B(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(Transition, {
    onBeforeEnter: _ctx.onBeforeEnter,
    onEnter: _ctx.onEnter,
    onAfterEnter: _ctx.onAfterEnter,
    onBeforeLeave: _ctx.onBeforeLeave,
    onLeave: _ctx.onLeave,
    onAfterLeave: _ctx.onAfterLeave
  }, {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 8, ["onBeforeEnter", "onEnter", "onAfterEnter", "onBeforeLeave", "onLeave", "onAfterLeave"]);
}
var ExpandTransition$1 = /* @__PURE__ */ _export_sfc(_sfc_main$4C, [["render", _sfc_render$4B]]);
const _sfc_main$4B = defineComponent({
  name: "SubMenuInline",
  components: {
    MenuIndent,
    ExpandTransition: ExpandTransition$1
  },
  props: {
    title: {
      type: String
    },
    isChildrenSelected: {
      type: Boolean
    }
  },
  setup(props) {
    const { key } = useMenu();
    const { level } = useLevel({
      provideNextLevel: true
    });
    const menuContext = useMenuContext();
    const menuPrefixCls = computed(() => menuContext.prefixCls);
    const prefixCls = computed(() => `${menuPrefixCls.value}-inline`);
    const classNames = computed(() => [prefixCls.value]);
    const isSelected = computed(() => props.isChildrenSelected);
    const isOpen = computed(
      () => (menuContext.openKeys || []).indexOf(key.value) > -1
    );
    return {
      prefixCls,
      menuPrefixCls,
      classNames,
      level,
      isSelected,
      isOpen,
      onHeaderClick: () => {
        menuContext.onSubMenuClick && menuContext.onSubMenuClick(key.value, level.value);
      }
    };
  }
});
function _sfc_render$4A(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_MenuIndent = resolveComponent("MenuIndent");
  const _component_ExpandTransition = resolveComponent("ExpandTransition");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    createBaseVNode("div", {
      class: normalizeClass([
        `${_ctx.prefixCls}-header`,
        {
          [`${_ctx.menuPrefixCls}-selected`]: _ctx.isSelected,
          [`${_ctx.menuPrefixCls}-has-icon`]: _ctx.$slots.icon
        }
      ]),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onHeaderClick && _ctx.onHeaderClick(...args))
    }, [
      createVNode(_component_MenuIndent, { level: _ctx.level }, null, 8, ["level"]),
      _ctx.$slots.icon ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
        createBaseVNode("span", {
          class: normalizeClass(`${_ctx.menuPrefixCls}-icon`)
        }, [
          renderSlot(_ctx.$slots, "icon")
        ], 2),
        createBaseVNode("span", {
          class: normalizeClass(`${_ctx.menuPrefixCls}-title`)
        }, [
          renderSlot(_ctx.$slots, "title", {}, () => [
            createTextVNode(toDisplayString(_ctx.title), 1)
          ])
        ], 2)
      ], 64)) : renderSlot(_ctx.$slots, "title", { key: 1 }, () => [
        createTextVNode(toDisplayString(_ctx.title), 1)
      ]),
      createBaseVNode("span", {
        class: normalizeClass([
          `${_ctx.menuPrefixCls}-icon-suffix`,
          {
            [`is-open`]: _ctx.isOpen
          }
        ])
      }, [
        renderSlot(_ctx.$slots, "expand-icon-down")
      ], 2)
    ], 2),
    createVNode(_component_ExpandTransition, null, {
      default: withCtx(() => [
        withDirectives(createBaseVNode("div", {
          class: normalizeClass(`${_ctx.prefixCls}-content`)
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 2), [
          [vShow, _ctx.isOpen]
        ])
      ]),
      _: 3
    })
  ], 2);
}
var SubMenuInline = /* @__PURE__ */ _export_sfc(_sfc_main$4B, [["render", _sfc_render$4A]]);
const _sfc_main$4A = defineComponent({
  name: "SubMenuPop",
  components: {
    Menu: BaseMenu,
    Trigger,
    MenuIndent,
    RenderFunction
  },
  inheritAttrs: false,
  props: {
    title: {
      type: String
    },
    selectable: {
      type: Boolean
    },
    isChildrenSelected: {
      type: Boolean
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: void 0
    }
  },
  setup(props) {
    const { key } = useMenu();
    const { level } = useLevel();
    const { selectable, isChildrenSelected, popupMaxHeight } = toRefs(props);
    const menuContext = useMenuContext();
    const { onSubMenuClick, onMenuItemClick } = menuContext;
    const menuPrefixCls = computed(() => menuContext.prefixCls);
    const mode = computed(() => menuContext.mode);
    const selectedKeys = computed(() => menuContext.selectedKeys || []);
    const prefixCls = computed(() => `${menuPrefixCls.value}-pop`);
    const isSelected = computed(
      () => selectable.value && selectedKeys.value.includes(key.value) || isChildrenSelected.value
    );
    const classNames = computed(() => [
      `${prefixCls.value}`,
      `${prefixCls.value}-header`,
      {
        [`${menuPrefixCls.value}-selected`]: isSelected.value
      }
    ]);
    const needPopOnBottom = computed(
      () => mode.value === "horizontal" && !menuContext.inTrigger
    );
    const popVisible = ref(false);
    const setPopVisible = (val) => {
      popVisible.value = val;
    };
    const triggerPrefixCls = getPrefixCls("trigger");
    const triggerClassNames = computed(() => {
      var _a;
      return [
        `${prefixCls.value}-trigger`,
        {
          [`${prefixCls.value}-trigger-dark`]: menuContext.theme === "dark"
        },
        (_a = menuContext.triggerProps) == null ? void 0 : _a.class
      ];
    });
    const triggerProps = computed(
      () => omit(menuContext.triggerProps || {}, ["class"])
    );
    return {
      menuPrefixCls,
      mode,
      level,
      classNames,
      isSelected,
      selectedKeys,
      needPopOnBottom,
      popVisible,
      triggerPrefixCls,
      triggerClassNames,
      triggerProps,
      menuContext,
      popupMenuStyles: computed(() => {
        var _a;
        const maxHeight = (_a = popupMaxHeight.value) != null ? _a : menuContext.popupMaxHeight;
        if (isNumber(maxHeight))
          return { maxHeight: `${maxHeight}px` };
        return maxHeight ? {} : { maxHeight: "unset" };
      }),
      onClick: () => {
        onSubMenuClick && onSubMenuClick(key.value, level.value);
        selectable.value && onMenuItemClick && onMenuItemClick(key.value);
      },
      onMenuItemClick: (key2) => {
        onMenuItemClick && onMenuItemClick(key2);
        setPopVisible(false);
      },
      onVisibleChange: (visible) => {
        setPopVisible(visible);
      }
    };
  }
});
function _sfc_render$4z(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_MenuIndent = resolveComponent("MenuIndent");
  const _component_RenderFunction = resolveComponent("RenderFunction");
  const _component_Menu = resolveComponent("Menu");
  const _component_Trigger = resolveComponent("Trigger");
  return openBlock(), createBlock(_component_Trigger, mergeProps({
    trigger: "hover",
    class: _ctx.triggerClassNames,
    position: _ctx.needPopOnBottom ? "bl" : "rt",
    "show-arrow": "",
    "animation-class": "fade-in",
    "mouse-enter-delay": 50,
    "mouse-leave-delay": 50,
    "popup-offset": 4,
    "auto-fit-popup-min-width": true,
    duration: 100
  }, _ctx.triggerProps, {
    "unmount-on-close": false,
    "popup-visible": _ctx.popVisible,
    onPopupVisibleChange: _ctx.onVisibleChange
  }), {
    content: withCtx(() => [
      createVNode(_component_Menu, {
        "in-trigger": "",
        "prefix-cls": `${_ctx.triggerPrefixCls}-menu`,
        "selected-keys": _ctx.selectedKeys,
        theme: _ctx.menuContext.theme,
        "trigger-props": _ctx.menuContext.triggerProps,
        style: normalizeStyle(_ctx.popupMenuStyles),
        onMenuItemClick: _ctx.onMenuItemClick
      }, createSlots({
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 2
      }, [
        _ctx.menuContext.expandIconDown ? {
          name: "expand-icon-down",
          fn: withCtx(() => [
            createVNode(_component_RenderFunction, {
              "render-func": _ctx.menuContext.expandIconDown
            }, null, 8, ["render-func"])
          ]),
          key: "0"
        } : void 0,
        _ctx.menuContext.expandIconRight ? {
          name: "expand-icon-right",
          fn: withCtx(() => [
            createVNode(_component_RenderFunction, {
              "render-func": _ctx.menuContext.expandIconRight
            }, null, 8, ["render-func"])
          ]),
          key: "1"
        } : void 0
      ]), 1032, ["prefix-cls", "selected-keys", "theme", "trigger-props", "style", "onMenuItemClick"])
    ]),
    default: withCtx(() => [
      createBaseVNode("div", mergeProps({
        class: [
          _ctx.classNames,
          {
            [`${_ctx.menuPrefixCls}-has-icon`]: _ctx.$slots.icon
          }
        ],
        "aria-haspopup": "true"
      }, _ctx.$attrs, {
        onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
      }), [
        createCommentVNode(" header "),
        createVNode(_component_MenuIndent, { level: _ctx.level }, null, 8, ["level"]),
        _ctx.$slots.icon ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createBaseVNode("span", {
            class: normalizeClass(`${_ctx.menuPrefixCls}-icon`)
          }, [
            renderSlot(_ctx.$slots, "icon")
          ], 2),
          createBaseVNode("span", {
            class: normalizeClass(`${_ctx.menuPrefixCls}-title`)
          }, [
            renderSlot(_ctx.$slots, "title", {}, () => [
              createTextVNode(toDisplayString(_ctx.title), 1)
            ])
          ], 2)
        ], 64)) : renderSlot(_ctx.$slots, "title", { key: 1 }, () => [
          createTextVNode(toDisplayString(_ctx.title), 1)
        ]),
        createCommentVNode(" suffix "),
        createBaseVNode("span", {
          class: normalizeClass(`${_ctx.menuPrefixCls}-icon-suffix`)
        }, [
          _ctx.needPopOnBottom ? renderSlot(_ctx.$slots, "expand-icon-down", { key: 0 }) : renderSlot(_ctx.$slots, "expand-icon-right", { key: 1 })
        ], 2),
        _ctx.isSelected && _ctx.mode === "horizontal" ? (openBlock(), createElementBlock("div", {
          key: 2,
          class: normalizeClass(`${_ctx.menuPrefixCls}-selected-label`)
        }, null, 2)) : createCommentVNode("v-if", true)
      ], 16)
    ]),
    _: 3
  }, 16, ["class", "position", "popup-visible", "onPopupVisibleChange"]);
}
var SubMenuPop = /* @__PURE__ */ _export_sfc(_sfc_main$4A, [["render", _sfc_render$4z]]);
var SubMenu = defineComponent({
  name: "SubMenu",
  props: {
    title: {
      type: String
    },
    selectable: {
      type: Boolean
    },
    popup: {
      type: [Boolean, Function],
      default: false
    },
    popupMaxHeight: {
      type: [Boolean, Number],
      default: void 0
    }
  },
  setup(props, {
    attrs
  }) {
    const {
      key
    } = useMenu();
    const {
      level
    } = useLevel();
    const {
      popup
    } = toRefs(props);
    const menuContext = useMenuContext();
    const computedPopup = computed(() => {
      const {
        mode,
        collapsed,
        inTrigger
      } = menuContext;
      const forcePopup = !!(typeof popup.value === "function" ? popup.value(level.value) : popup.value);
      return forcePopup || collapsed || inTrigger || mode !== "vertical";
    });
    const {
      subMenuKeys,
      menuItemKeys
    } = useMenuDataCollector({
      key: key.value,
      type: "subMenu"
    });
    const isChildrenSelected = computed(() => {
      const selectedKeys = menuContext.selectedKeys || [];
      const checkSelected = (menuKeys) => {
        for (let i2 = 0; i2 < selectedKeys.length; i2++) {
          const selectedKey = selectedKeys[i2];
          if (menuKeys.includes(selectedKey)) {
            return true;
          }
        }
        return false;
      };
      return checkSelected(subMenuKeys.value) || checkSelected(menuItemKeys.value);
    });
    return {
      subMenuKeys,
      menuItemKeys,
      isChildrenSelected,
      props,
      attrs,
      computedKey: key,
      computedPopup,
      expandIconDown: toRef(menuContext, "expandIconDown"),
      expandIconRight: toRef(menuContext, "expandIconRight")
    };
  },
  render() {
    const {
      props,
      attrs,
      computedKey,
      computedPopup,
      expandIconDown,
      expandIconRight,
      isChildrenSelected
    } = this;
    const _slots = {
      ...this.$slots,
      "expand-icon-down": this.$slots["expand-icon-down"] || expandIconDown || (() => [createVNode(IconDown, null, null)]),
      "expand-icon-right": this.$slots["expand-icon-right"] || expandIconRight || (() => [createVNode(IconRight, null, null)])
    };
    return computedPopup ? createVNode(SubMenuPop, mergeProps({
      "key": computedKey,
      "title": props.title,
      "selectable": props.selectable,
      "isChildrenSelected": isChildrenSelected,
      "popupMaxHeight": props.popupMaxHeight
    }, attrs), _slots) : createVNode(SubMenuInline, mergeProps({
      "key": computedKey,
      "title": props.title,
      "isChildrenSelected": isChildrenSelected
    }, attrs), _slots);
  }
});
const OVERFLOW_THRESHOLD = 10;
function getNodeWidth(el) {
  return el && +el.getBoundingClientRect().width.toFixed(2);
}
function translatePxToNumber(str) {
  const result = Number(str.replace("px", ""));
  return Number.isNaN(result) ? 0 : result;
}
var OverflowWrap = defineComponent({
  name: "MenuOverflowWrap",
  setup(_, {
    slots
  }) {
    const menuContext = useMenuContext();
    const overflowPrefixCls = `${menuContext.prefixCls}-overflow`;
    const overflowSubMenuClass = `${overflowPrefixCls}-sub-menu`;
    const overflowMenuItemClass = `${overflowPrefixCls}-hidden-menu-item`;
    const overflowSubMenuMirrorClass = `${overflowPrefixCls}-sub-menu-mirror`;
    const refWrapper = ref();
    const lastVisibleIndex = ref(null);
    const refResizeObserver = ref();
    function computeLastVisibleIndex() {
      const wrapperElement = refWrapper.value;
      const wrapperWidth = getNodeWidth(wrapperElement);
      const childNodeList = [].slice.call(wrapperElement.children);
      let menuItemIndex = 0;
      let currentRightWidth = 0;
      let overflowSubMenuWidth = 0;
      for (let i2 = 0; i2 < childNodeList.length; i2++) {
        const node = childNodeList[i2];
        const classNames = node.className.split(" ");
        const isOverflowSubMenu = classNames.indexOf(overflowSubMenuClass) > -1;
        const isOverflowSubMenuMirror = classNames.indexOf(overflowSubMenuMirrorClass) > -1;
        if (isOverflowSubMenu) {
          continue;
        }
        const nodeWidth = getNodeWidth(node) + translatePxToNumber(getStyle$1(node, "marginLeft")) + translatePxToNumber(getStyle$1(node, "marginRight"));
        if (isOverflowSubMenuMirror) {
          overflowSubMenuWidth = nodeWidth;
          continue;
        }
        currentRightWidth += nodeWidth;
        if (currentRightWidth + overflowSubMenuWidth + OVERFLOW_THRESHOLD > wrapperWidth) {
          lastVisibleIndex.value = menuItemIndex - 1;
          return;
        }
        menuItemIndex++;
      }
      lastVisibleIndex.value = null;
    }
    onMounted(() => {
      computeLastVisibleIndex();
      refResizeObserver.value = new index((entries) => {
        entries.forEach(computeLastVisibleIndex);
      });
      if (refWrapper.value) {
        refResizeObserver.value.observe(refWrapper.value);
      }
    });
    onUnmounted(() => {
      refResizeObserver.value && refResizeObserver.value.disconnect();
    });
    return () => {
      const renderSubMenu = (children, options) => {
        const {
          isMirror = false,
          props = {}
        } = options || {};
        return createVNode(SubMenu, mergeProps({
          "key": `__arco-menu-overflow-sub-menu${isMirror ? "-mirror" : ""}`,
          "class": isMirror ? overflowSubMenuMirrorClass : overflowSubMenuClass
        }, props), {
          title: () => createVNode("span", null, [createTextVNode("...")]),
          default: () => children
        });
      };
      const renderChildren = () => {
        var _a;
        const originChildren = ((_a = slots.default) == null ? void 0 : _a.call(slots)) || [];
        const children = unFragment(originChildren);
        let overflowSubMenu = null;
        const overflowSubMenuMirror = renderSubMenu(null, {
          isMirror: true
        });
        const menuItems = children.map((child, index2) => {
          const item = cloneVNode(child, lastVisibleIndex.value !== null && index2 > lastVisibleIndex.value ? {
            class: overflowMenuItemClass
          } : {
            class: ""
          });
          if (lastVisibleIndex.value !== null && index2 === lastVisibleIndex.value + 1) {
            const overflowMenuItems = children.slice(index2).map((child2) => cloneVNode(child2));
            overflowSubMenu = renderSubMenu(overflowMenuItems);
          }
          return item;
        });
        return [overflowSubMenuMirror, ...menuItems, overflowSubMenu];
      };
      return createVNode("div", {
        "class": `${overflowPrefixCls}-wrap`,
        "ref": refWrapper
      }, [renderChildren()]);
    };
  }
});
var _Menu = defineComponent({
  name: "Menu",
  components: {
    BaseMenu
  },
  inheritAttrs: false,
  props: {
    theme: {
      type: String
    },
    mode: {
      type: String,
      default: "vertical"
    }
  },
  setup(props, {
    attrs,
    slots
  }) {
    const {
      theme: propTheme,
      mode
    } = toRefs(props);
    const siderContext = inject(SiderInjectionKey, void 0);
    const siderCollapsed = computed(() => (siderContext == null ? void 0 : siderContext.collapsed) || false);
    const theme = computed(() => (propTheme == null ? void 0 : propTheme.value) || (siderContext == null ? void 0 : siderContext.theme) || "light");
    provide(MenuInjectionKey, void 0);
    provide(LevelInjectionKey, void 0);
    return () => createVNode(BaseMenu, mergeProps(props, attrs, {
      "theme": theme.value,
      "inTrigger": false,
      "siderCollapsed": siderCollapsed.value,
      "isRoot": true
    }), {
      ...slots,
      default: mode.value === "horizontal" && slots.default ? () => createVNode(OverflowWrap, null, {
        default: () => {
          var _a;
          return [(_a = slots.default) == null ? void 0 : _a.call(slots)];
        }
      }) : slots.default
    });
  }
});
var MenuItem = defineComponent({
  name: "MenuItem",
  inheritAttrs: false,
  props: {
    disabled: {
      type: Boolean,
      default: false
    }
  },
  emits: ["click"],
  setup(props, {
    emit
  }) {
    const {
      key
    } = useMenu();
    const {
      level
    } = useLevel();
    const menuContext = useMenuContext();
    const refItemElement = ref();
    const isSelected = computed(() => (menuContext.selectedKeys || []).indexOf(key.value) > -1);
    const menuDataCollector = useMenuDataCollectorContext();
    onMounted(() => {
      menuDataCollector == null ? void 0 : menuDataCollector.collectMenuItem(key.value);
    });
    onUnmounted(() => {
      menuDataCollector == null ? void 0 : menuDataCollector.removeMenuItem(key.value);
    });
    function scrollTo2() {
      if (menuContext.autoScrollIntoView && refItemElement.value && isSelected.value) {
        scrollIntoView(refItemElement.value, {
          behavior: "smooth",
          block: "nearest",
          scrollMode: "if-needed",
          boundary: document.documentElement,
          ...menuContext.scrollConfig || {}
        });
      }
    }
    let timer;
    onMounted(() => {
      timer = setTimeout(() => {
        scrollTo2();
      }, 500);
    });
    onUnmounted(() => {
      clearTimeout(timer);
    });
    watch([isSelected], () => {
      scrollTo2();
    });
    return {
      menuContext,
      level,
      isSelected,
      refItemElement,
      onClick(e) {
        if (props.disabled)
          return;
        menuContext.onMenuItemClick && menuContext.onMenuItemClick(key.value);
        emit("click", e);
      }
    };
  },
  render() {
    var _a, _b;
    const {
      level,
      menuContext,
      disabled,
      isSelected,
      onClick
    } = this;
    const {
      prefixCls,
      collapsed,
      inTrigger,
      mode,
      tooltipProps
    } = menuContext;
    const needTooltip = collapsed && !inTrigger && level === 1;
    const needTextIndent = mode === "vertical" && level > 1;
    const children = ((_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a)) || [];
    const showIndent = needTextIndent && !inTrigger && !collapsed;
    const iconElement = this.$slots.icon && this.$slots.icon();
    const content = [showIndent && createVNode(MenuIndent, {
      "level": level
    }, null), iconElement && createVNode("span", {
      "class": `${prefixCls}-icon`
    }, [iconElement]), showIndent || iconElement ? createVNode("span", {
      "class": [`${prefixCls}-item-inner`, {
        [`${prefixCls}-title`]: iconElement
      }]
    }, [children]) : children].filter(Boolean);
    const itemElement = createVNode("div", mergeProps({
      "ref": "refItemElement",
      "class": [`${prefixCls}-item`, {
        [`${prefixCls}-disabled`]: disabled,
        [`${prefixCls}-selected`]: isSelected,
        [`${prefixCls}-has-icon`]: iconElement
      }]
    }, this.$attrs, {
      "onClick": onClick
    }), [content, isSelected && mode === "horizontal" && createVNode("div", {
      "class": `${prefixCls}-selected-label`
    }, null)]);
    if (needTooltip) {
      const tooltipClassNames = [`${prefixCls}-item-tooltip`, tooltipProps == null ? void 0 : tooltipProps.class];
      return createVNode(Tooltip, mergeProps({
        "trigger": "hover",
        "position": "right",
        "class": tooltipClassNames
      }, omit(tooltipProps || {}, ["class"])), {
        default: () => itemElement,
        content: () => children
      });
    }
    return itemElement;
  }
});
const _sfc_main$4z = defineComponent({
  name: "MenuItemGroup",
  components: {
    MenuIndent
  },
  props: {
    title: {
      type: String
    }
  },
  setup() {
    const { level } = useLevel();
    const nextLevel = computed(
      () => level.value === 1 ? level.value + 1 : level.value
    );
    provideLevel(nextLevel);
    const menuContext = useMenuContext();
    const prefixCls = computed(() => menuContext.prefixCls);
    const classNames = computed(() => [`${prefixCls.value}-group`]);
    return {
      prefixCls,
      classNames,
      level
    };
  }
});
function _sfc_render$4y(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_MenuIndent = resolveComponent("MenuIndent");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.classNames)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-group-title`)
    }, [
      createVNode(_component_MenuIndent, { level: _ctx.level }, null, 8, ["level"]),
      renderSlot(_ctx.$slots, "title", {}, () => [
        createTextVNode(toDisplayString(_ctx.title), 1)
      ])
    ], 2),
    renderSlot(_ctx.$slots, "default")
  ], 2);
}
var MenuItemGroup = /* @__PURE__ */ _export_sfc(_sfc_main$4z, [["render", _sfc_render$4y]]);
const Menu = Object.assign(_Menu, {
  Item: MenuItem,
  ItemGroup: MenuItemGroup,
  SubMenu,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Menu.name, _Menu);
    app.component(componentPrefix + MenuItem.name, MenuItem);
    app.component(componentPrefix + MenuItemGroup.name, MenuItemGroup);
    app.component(componentPrefix + SubMenu.name, SubMenu);
  }
});
const _sfc_main$4y = defineComponent({
  name: "Message",
  components: {
    AIconHover: IconHover,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill,
    IconClose,
    IconLoading
  },
  props: {
    type: {
      type: String,
      default: "info"
    },
    closable: {
      type: Boolean,
      default: false
    },
    showIcon: {
      type: Boolean,
      default: true
    },
    duration: {
      type: Number,
      default: 3e3
    },
    resetOnUpdate: {
      type: Boolean,
      default: false
    },
    resetOnHover: {
      type: Boolean,
      default: false
    }
  },
  emits: ["close"],
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("message");
    let timer = 0;
    const handleClose = () => {
      emit("close");
    };
    const startTimer = () => {
      if (props.duration > 0) {
        timer = window.setTimeout(handleClose, props.duration);
      }
    };
    const clearTimer = () => {
      if (timer) {
        window.clearTimeout(timer);
        timer = 0;
      }
    };
    onMounted(() => {
      startTimer();
    });
    onUpdated(() => {
      if (props.resetOnUpdate) {
        clearTimer();
        startTimer();
      }
    });
    onUnmounted(() => {
      clearTimer();
    });
    const handleMouseEnter = () => {
      if (props.resetOnHover) {
        clearTimer();
      }
    };
    const handleMouseLeave = () => {
      if (props.resetOnHover) {
        startTimer();
      }
    };
    return {
      handleMouseEnter,
      handleMouseLeave,
      prefixCls,
      handleClose
    };
  }
});
function _sfc_render$4x(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_loading = resolveComponent("icon-loading");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  return openBlock(), createElementBlock("li", {
    role: "alert",
    class: normalizeClass([
      _ctx.prefixCls,
      `${_ctx.prefixCls}-${_ctx.type}`,
      { [`${_ctx.prefixCls}-closable`]: _ctx.closable }
    ]),
    onMouseenter: _cache[1] || (_cache[1] = (...args) => _ctx.handleMouseEnter && _ctx.handleMouseEnter(...args)),
    onMouseleave: _cache[2] || (_cache[2] = (...args) => _ctx.handleMouseLeave && _ctx.handleMouseLeave(...args))
  }, [
    _ctx.showIcon && !(_ctx.type === "normal" && !_ctx.$slots.icon) ? (openBlock(), createElementBlock("span", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-icon`)
    }, [
      renderSlot(_ctx.$slots, "icon", {}, () => [
        _ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, { key: 0 })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, { key: 1 })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 2 })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, { key: 3 })) : _ctx.type === "loading" ? (openBlock(), createBlock(_component_icon_loading, { key: 4 })) : createCommentVNode("v-if", true)
      ])
    ], 2)) : createCommentVNode("v-if", true),
    createBaseVNode("span", {
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2),
    _ctx.closable ? (openBlock(), createElementBlock("span", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
    }, [
      createVNode(_component_a_icon_hover, null, {
        default: withCtx(() => [
          createVNode(_component_icon_close)
        ]),
        _: 1
      })
    ], 2)) : createCommentVNode("v-if", true)
  ], 34);
}
var Message$1 = /* @__PURE__ */ _export_sfc(_sfc_main$4y, [["render", _sfc_render$4x]]);
function _isSlot$8(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var MessageList = defineComponent({
  name: "MessageList",
  props: {
    messages: {
      type: Array,
      default: () => []
    },
    position: {
      type: String,
      default: "top"
    }
  },
  emits: ["close", "afterClose"],
  setup(props, context) {
    const prefixCls = getPrefixCls("message-list");
    const {
      zIndex
    } = usePopupManager("message", {
      runOnMounted: true
    });
    return () => {
      let _slot;
      return createVNode(TransitionGroup, {
        "class": [prefixCls, `${prefixCls}-${props.position}`],
        "name": "fade-message",
        "tag": "ul",
        "style": {
          zIndex: zIndex.value
        },
        "onAfterLeave": () => context.emit("afterClose")
      }, _isSlot$8(_slot = props.messages.map((item) => {
        const slots = {
          default: getSlotFunction(item.content),
          icon: getSlotFunction(item.icon)
        };
        return createVNode(Message$1, {
          "key": item.id,
          "type": item.type,
          "duration": item.duration,
          "closable": item.closable,
          "resetOnUpdate": item.resetOnUpdate,
          "resetOnHover": item.resetOnHover,
          "onClose": () => context.emit("close", item.id)
        }, slots);
      })) ? _slot : {
        default: () => [_slot]
      });
    };
  }
});
class MessageManger {
  constructor(config, appContext) {
    this.messageCount = 0;
    this.add = (config2) => {
      var _a;
      this.messageCount++;
      const id = (_a = config2.id) != null ? _a : `__arco_message_${this.messageCount}`;
      if (this.messageIds.has(id)) {
        return this.update(id, config2);
      }
      const message2 = reactive({ id, ...config2 });
      this.messages.value.push(message2);
      this.messageIds.add(id);
      return {
        close: () => this.remove(id)
      };
    };
    this.update = (id, config2) => {
      for (let i2 = 0; i2 < this.messages.value.length; i2++) {
        if (this.messages.value[i2].id === id) {
          const resetOnUpdate = !isUndefined(config2.duration);
          Object.assign(this.messages.value[i2], { ...config2, id, resetOnUpdate });
          break;
        }
      }
      return {
        close: () => this.remove(id)
      };
    };
    this.remove = (id) => {
      for (let i2 = 0; i2 < this.messages.value.length; i2++) {
        const item = this.messages.value[i2];
        if (item.id === id) {
          if (isFunction(item.onClose)) {
            item.onClose(id);
          }
          this.messages.value.splice(i2, 1);
          this.messageIds.delete(id);
          break;
        }
      }
    };
    this.clear = () => {
      this.messages.value.splice(0);
    };
    this.destroy = () => {
      if (this.messages.value.length === 0 && this.container) {
        render(null, this.container);
        document.body.removeChild(this.container);
        this.container = null;
        messageInstance[this.position] = void 0;
      }
    };
    const { position = "top" } = config;
    this.container = getOverlay("message");
    this.messageIds = /* @__PURE__ */ new Set();
    this.messages = ref([]);
    this.position = position;
    const vm = createVNode(MessageList, {
      messages: this.messages.value,
      position,
      onClose: this.remove,
      onAfterClose: this.destroy
    });
    if (appContext != null ? appContext : Message._context) {
      vm.appContext = appContext != null ? appContext : Message._context;
    }
    render(vm, this.container);
    document.body.appendChild(this.container);
  }
}
const messageInstance = {};
const types = [...MESSAGE_TYPES, "loading", "normal"];
const message = types.reduce((pre, value) => {
  pre[value] = (config, appContext) => {
    if (isString(config)) {
      config = { content: config };
    }
    const _config = { type: value, ...config };
    const { position = "top" } = _config;
    if (!messageInstance[position]) {
      messageInstance[position] = new MessageManger(_config, appContext);
    }
    return messageInstance[position].add(_config);
  };
  return pre;
}, {});
message.clear = (position) => {
  var _a;
  if (position) {
    (_a = messageInstance[position]) == null ? void 0 : _a.clear();
  } else {
    Object.values(messageInstance).forEach((item) => item == null ? void 0 : item.clear());
  }
};
const Message = {
  ...message,
  install: (app) => {
    const _message = {
      clear: message.clear
    };
    for (const key of types) {
      _message[key] = (config, appContext = app._context) => message[key](config, appContext);
    }
    app.config.globalProperties.$message = _message;
  },
  _context: null
};
const useDraggable$1 = ({
  modalRef,
  wrapperRef,
  draggable,
  alignCenter
}) => {
  const isDragging = ref(false);
  const startMouse = ref([0, 0]);
  const initialPosition = ref([0, 0]);
  const position = ref();
  const minPosition = ref([0, 0]);
  const maxPosition = ref([0, 0]);
  const getInitialPosition = () => {
    var _a, _b, _c;
    if (wrapperRef.value && modalRef.value) {
      const { top: wrapperTop, left: wrapperLeft } = wrapperRef.value.getBoundingClientRect();
      const { clientWidth: wrapperWidth, clientHeight: wrapperHeight } = wrapperRef.value;
      const { top, left, width, height } = modalRef.value.getBoundingClientRect();
      const offsetTop = alignCenter.value ? 0 : (_a = modalRef.value) == null ? void 0 : _a.offsetTop;
      const initialX = left - wrapperLeft;
      const initialY = top - wrapperTop - offsetTop;
      if (initialX !== ((_b = initialPosition.value) == null ? void 0 : _b[0]) || initialY !== ((_c = initialPosition.value) == null ? void 0 : _c[1])) {
        initialPosition.value = [initialX, initialY];
      }
      const maxX = wrapperWidth > width ? wrapperWidth - width : 0;
      const maxY = wrapperHeight > height ? wrapperHeight - height - offsetTop : 0;
      if (maxX !== maxPosition.value[0] || maxY !== maxPosition.value[1]) {
        maxPosition.value = [maxX, maxY];
      }
      if (offsetTop) {
        minPosition.value = [0, 0 - offsetTop];
      }
    }
  };
  const handleMoveDown = (ev) => {
    if (draggable.value) {
      ev.preventDefault();
      isDragging.value = true;
      getInitialPosition();
      startMouse.value = [ev.x, ev.y];
      on(window, "mousemove", handleMouseMove);
      on(window, "mouseup", handleMouseUp);
      on(window, "contextmenu", handleMouseUp);
    }
  };
  const handleMouseMove = (ev) => {
    if (isDragging.value) {
      const diffX = ev.x - startMouse.value[0];
      const diffY = ev.y - startMouse.value[1];
      let x = initialPosition.value[0] + diffX;
      let y = initialPosition.value[1] + diffY;
      if (x < minPosition.value[0])
        x = minPosition.value[0];
      if (x > maxPosition.value[0])
        x = maxPosition.value[0];
      if (y < minPosition.value[1])
        y = minPosition.value[1];
      if (y > maxPosition.value[1])
        y = maxPosition.value[1];
      position.value = [x, y];
    }
  };
  const handleMouseUp = () => {
    isDragging.value = false;
    off(window, "mousemove", handleMouseMove);
    off(window, "mouseup", handleMouseUp);
  };
  return {
    position,
    handleMoveDown
  };
};
var _sfc_main$4x = defineComponent({
  name: "Modal",
  components: {
    ClientOnly,
    ArcoButton: Button,
    IconHover,
    IconClose,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  inheritAttrs: false,
  props: {
    visible: {
      type: Boolean,
      default: void 0
    },
    defaultVisible: {
      type: Boolean,
      default: false
    },
    width: {
      type: [Number, String]
    },
    top: {
      type: [Number, String]
    },
    mask: {
      type: Boolean,
      default: true
    },
    title: {
      type: String
    },
    titleAlign: {
      type: String,
      default: "center"
    },
    alignCenter: {
      type: Boolean,
      default: true
    },
    unmountOnClose: Boolean,
    maskClosable: {
      type: Boolean,
      default: true
    },
    hideCancel: {
      type: Boolean,
      default: false
    },
    simple: {
      type: Boolean,
      default: (props) => {
        return props.notice;
      }
    },
    closable: {
      type: Boolean,
      default: true
    },
    okText: String,
    cancelText: String,
    okLoading: {
      type: Boolean,
      default: false
    },
    okButtonProps: {
      type: Object
    },
    cancelButtonProps: {
      type: Object
    },
    footer: {
      type: Boolean,
      default: true
    },
    renderToBody: {
      type: Boolean,
      default: true
    },
    popupContainer: {
      type: [String, Object],
      default: "body"
    },
    maskStyle: {
      type: Object
    },
    modalClass: {
      type: [String, Array]
    },
    modalStyle: {
      type: Object
    },
    onBeforeOk: {
      type: Function
    },
    onBeforeCancel: {
      type: Function
    },
    escToClose: {
      type: Boolean,
      default: true
    },
    draggable: {
      type: Boolean,
      default: false
    },
    fullscreen: {
      type: Boolean,
      default: false
    },
    maskAnimationName: {
      type: String,
      default: (props) => {
        if (props.fullscreen) {
          return "fade-in-standard";
        }
        return "fade-modal";
      }
    },
    modalAnimationName: {
      type: String,
      default: (props) => {
        if (props.fullscreen) {
          return "zoom-in";
        }
        return "zoom-modal";
      }
    },
    bodyClass: {
      type: [String, Array]
    },
    bodyStyle: {
      type: [String, Object, Array]
    },
    messageType: {
      type: String
    },
    hideTitle: {
      type: Boolean,
      default: false
    }
  },
  emits: {
    "update:visible": (visible) => true,
    "ok": (e) => true,
    "cancel": (e) => true,
    "open": () => true,
    "close": () => true,
    "beforeOpen": () => true,
    "beforeClose": () => true
  },
  setup(props, {
    emit
  }) {
    const {
      fullscreen,
      popupContainer,
      alignCenter
    } = toRefs(props);
    const prefixCls = getPrefixCls("modal");
    const {
      t
    } = useI18n();
    const wrapperRef = ref();
    const modalRef = ref();
    const _visible = ref(props.defaultVisible);
    const computedVisible = computed(() => {
      var _a;
      return (_a = props.visible) != null ? _a : _visible.value;
    });
    const _okLoading = ref(false);
    const mergedOkLoading = computed(() => props.okLoading || _okLoading.value);
    const mergedDraggable = computed(() => props.draggable && !props.fullscreen);
    const {
      teleportContainer,
      containerRef
    } = useTeleportContainer({
      popupContainer,
      visible: computedVisible
    });
    const mounted = ref(computedVisible.value);
    const okDisplayText = computed(() => props.okText || t("modal.okText"));
    const cancelDisplayText = computed(() => props.cancelText || t("modal.cancelText"));
    const {
      zIndex,
      isLastDialog
    } = usePopupManager("dialog", {
      visible: computedVisible
    });
    let globalKeyDownListener = false;
    const handleGlobalKeyDown = (ev) => {
      if (props.escToClose && ev.key === KEYBOARD_KEY.ESC && isLastDialog()) {
        handleCancel(ev);
      }
    };
    const addGlobalKeyDownListener = () => {
      if (props.escToClose && !globalKeyDownListener) {
        globalKeyDownListener = true;
        on(document.documentElement, "keydown", handleGlobalKeyDown);
      }
    };
    const removeGlobalKeyDownListener = () => {
      globalKeyDownListener = false;
      off(document.documentElement, "keydown", handleGlobalKeyDown);
    };
    let promiseNumber = 0;
    const {
      position,
      handleMoveDown
    } = useDraggable$1({
      wrapperRef,
      modalRef,
      draggable: mergedDraggable,
      alignCenter
    });
    const close = () => {
      promiseNumber++;
      if (_okLoading.value) {
        _okLoading.value = false;
      }
      _visible.value = false;
      emit("update:visible", false);
    };
    const handleOk = async (e) => {
      const currentPromiseNumber = promiseNumber;
      const closed = await new Promise(
        async (resolve) => {
          var _a;
          if (isFunction(props.onBeforeOk)) {
            let result = props.onBeforeOk((closed2 = true) => resolve(closed2));
            if (isPromise(result) || !isBoolean(result)) {
              _okLoading.value = true;
            }
            if (isPromise(result)) {
              try {
                result = (_a = await result) != null ? _a : true;
              } catch (error) {
                result = false;
                throw error;
              }
            }
            if (isBoolean(result)) {
              resolve(result);
            }
          } else {
            resolve(true);
          }
        }
      );
      if (currentPromiseNumber === promiseNumber) {
        if (closed) {
          emit("ok", e);
          close();
        } else if (_okLoading.value) {
          _okLoading.value = false;
        }
      }
    };
    const handleCancel = (e) => {
      var _a;
      let result = true;
      if (isFunction(props.onBeforeCancel)) {
        result = (_a = props.onBeforeCancel()) != null ? _a : false;
      }
      if (result) {
        emit("cancel", e);
        close();
      }
    };
    const currentIsMask = ref(false);
    const handleMaskMouseDown = (ev) => {
      if (ev.target === wrapperRef.value) {
        currentIsMask.value = true;
      }
    };
    const handleMaskClick = (e) => {
      if (props.mask && props.maskClosable && currentIsMask.value) {
        handleCancel(e);
      }
    };
    const handleOpen = () => {
      if (computedVisible.value) {
        if (!contains(wrapperRef.value, document.activeElement) && document.activeElement instanceof HTMLElement) {
          document.activeElement.blur();
        }
        emit("open");
      }
    };
    const handleClose = () => {
      if (!computedVisible.value) {
        if (mergedDraggable.value) {
          position.value = void 0;
        }
        mounted.value = false;
        resetOverflow();
        emit("close");
      }
    };
    const {
      setOverflowHidden,
      resetOverflow
    } = useOverflow(containerRef);
    onMounted(() => {
      containerRef.value = getElement(props.popupContainer);
      if (computedVisible.value) {
        setOverflowHidden();
        if (props.escToClose) {
          addGlobalKeyDownListener();
        }
      }
    });
    onBeforeUnmount(() => {
      resetOverflow();
      removeGlobalKeyDownListener();
    });
    watch(computedVisible, (value) => {
      if (_visible.value !== value) {
        _visible.value = value;
      }
      if (value) {
        emit("beforeOpen");
        mounted.value = true;
        currentIsMask.value = false;
        setOverflowHidden();
        addGlobalKeyDownListener();
      } else {
        emit("beforeClose");
        removeGlobalKeyDownListener();
      }
    });
    watch(fullscreen, () => {
      if (position.value) {
        position.value = void 0;
      }
    });
    const wrapperCls = computed(() => [`${prefixCls}-wrapper`, {
      [`${prefixCls}-wrapper-align-center`]: props.alignCenter && !props.fullscreen,
      [`${prefixCls}-wrapper-moved`]: Boolean(position.value)
    }]);
    const modalCls = computed(() => [`${prefixCls}`, props.modalClass, {
      [`${prefixCls}-simple`]: props.simple,
      [`${prefixCls}-draggable`]: mergedDraggable.value,
      [`${prefixCls}-fullscreen`]: props.fullscreen
    }]);
    const mergedModalStyle = computed(() => {
      var _a;
      const style = {
        ...(_a = props.modalStyle) != null ? _a : {}
      };
      if (props.width && !props.fullscreen) {
        style.width = isNumber(props.width) ? `${props.width}px` : props.width;
      }
      if (!props.alignCenter && props.top) {
        style.top = isNumber(props.top) ? `${props.top}px` : props.top;
      }
      if (position.value) {
        style.transform = `translate(${position.value[0]}px, ${position.value[1]}px)`;
      }
      return style;
    });
    return {
      prefixCls,
      mounted,
      computedVisible,
      containerRef,
      wrapperRef,
      mergedModalStyle,
      okDisplayText,
      cancelDisplayText,
      zIndex,
      handleOk,
      handleCancel,
      handleMaskClick,
      handleMaskMouseDown,
      handleOpen,
      handleClose,
      mergedOkLoading,
      modalRef,
      wrapperCls,
      modalCls,
      teleportContainer,
      handleMoveDown
    };
  }
});
function _sfc_render$4w(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_icon_hover = resolveComponent("icon-hover");
  const _component_arco_button = resolveComponent("arco-button");
  const _component_client_only = resolveComponent("client-only");
  return openBlock(), createBlock(_component_client_only, null, {
    default: withCtx(() => [
      (openBlock(), createBlock(Teleport, {
        to: _ctx.teleportContainer,
        disabled: !_ctx.renderToBody
      }, [
        !_ctx.unmountOnClose || _ctx.computedVisible || _ctx.mounted ? withDirectives((openBlock(), createElementBlock("div", mergeProps({
          key: 0,
          class: `${_ctx.prefixCls}-container`,
          style: { zIndex: _ctx.zIndex }
        }, _ctx.$attrs), [
          createVNode(Transition, {
            name: _ctx.maskAnimationName,
            appear: ""
          }, {
            default: withCtx(() => [
              _ctx.mask ? withDirectives((openBlock(), createElementBlock("div", {
                key: 0,
                ref: "maskRef",
                class: normalizeClass(`${_ctx.prefixCls}-mask`),
                style: normalizeStyle(_ctx.maskStyle)
              }, null, 6)), [
                [vShow, _ctx.computedVisible]
              ]) : createCommentVNode("v-if", true)
            ]),
            _: 1
          }, 8, ["name"]),
          createBaseVNode("div", {
            ref: "wrapperRef",
            class: normalizeClass(_ctx.wrapperCls),
            onClick: _cache[2] || (_cache[2] = withModifiers((...args) => _ctx.handleMaskClick && _ctx.handleMaskClick(...args), ["self"])),
            onMousedown: _cache[3] || (_cache[3] = withModifiers((...args) => _ctx.handleMaskMouseDown && _ctx.handleMaskMouseDown(...args), ["self"]))
          }, [
            createVNode(Transition, {
              name: _ctx.modalAnimationName,
              appear: "",
              onAfterEnter: _ctx.handleOpen,
              onAfterLeave: _ctx.handleClose,
              persisted: ""
            }, {
              default: withCtx(() => [
                withDirectives(createBaseVNode("div", {
                  ref: "modalRef",
                  class: normalizeClass(_ctx.modalCls),
                  style: normalizeStyle(_ctx.mergedModalStyle)
                }, [
                  !_ctx.hideTitle && (_ctx.$slots.title || _ctx.title || _ctx.closable) ? (openBlock(), createElementBlock("div", {
                    key: 0,
                    class: normalizeClass(`${_ctx.prefixCls}-header`),
                    onMousedown: _cache[1] || (_cache[1] = (...args) => _ctx.handleMoveDown && _ctx.handleMoveDown(...args))
                  }, [
                    _ctx.$slots.title || _ctx.title ? (openBlock(), createElementBlock("div", {
                      key: 0,
                      class: normalizeClass([
                        `${_ctx.prefixCls}-title`,
                        `${_ctx.prefixCls}-title-align-${_ctx.titleAlign}`
                      ])
                    }, [
                      _ctx.messageType ? (openBlock(), createElementBlock("div", {
                        key: 0,
                        class: normalizeClass(`${_ctx.prefixCls}-title-icon`)
                      }, [
                        _ctx.messageType === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, { key: 0 })) : createCommentVNode("v-if", true),
                        _ctx.messageType === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, { key: 1 })) : createCommentVNode("v-if", true),
                        _ctx.messageType === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 2 })) : createCommentVNode("v-if", true),
                        _ctx.messageType === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, { key: 3 })) : createCommentVNode("v-if", true)
                      ], 2)) : createCommentVNode("v-if", true),
                      renderSlot(_ctx.$slots, "title", {}, () => [
                        createTextVNode(toDisplayString(_ctx.title), 1)
                      ])
                    ], 2)) : createCommentVNode("v-if", true),
                    !_ctx.simple && _ctx.closable ? (openBlock(), createElementBlock("div", {
                      key: 1,
                      tabindex: "-1",
                      role: "button",
                      "aria-label": "Close",
                      class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
                      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleCancel && _ctx.handleCancel(...args))
                    }, [
                      createVNode(_component_icon_hover, null, {
                        default: withCtx(() => [
                          createVNode(_component_icon_close)
                        ]),
                        _: 1
                      })
                    ], 2)) : createCommentVNode("v-if", true)
                  ], 34)) : createCommentVNode("v-if", true),
                  createBaseVNode("div", {
                    class: normalizeClass([`${_ctx.prefixCls}-body`, _ctx.bodyClass]),
                    style: normalizeStyle(_ctx.bodyStyle)
                  }, [
                    renderSlot(_ctx.$slots, "default")
                  ], 6),
                  _ctx.footer ? (openBlock(), createElementBlock("div", {
                    key: 1,
                    class: normalizeClass(`${_ctx.prefixCls}-footer`)
                  }, [
                    renderSlot(_ctx.$slots, "footer", {}, () => [
                      !_ctx.hideCancel ? (openBlock(), createBlock(_component_arco_button, mergeProps({ key: 0 }, _ctx.cancelButtonProps, { onClick: _ctx.handleCancel }), {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.cancelDisplayText), 1)
                        ]),
                        _: 1
                      }, 16, ["onClick"])) : createCommentVNode("v-if", true),
                      createVNode(_component_arco_button, mergeProps({ type: "primary" }, _ctx.okButtonProps, {
                        loading: _ctx.mergedOkLoading,
                        onClick: _ctx.handleOk
                      }), {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.okDisplayText), 1)
                        ]),
                        _: 1
                      }, 16, ["loading", "onClick"])
                    ])
                  ], 2)) : createCommentVNode("v-if", true)
                ], 6), [
                  [vShow, _ctx.computedVisible]
                ])
              ]),
              _: 3
            }, 8, ["name", "onAfterEnter", "onAfterLeave"])
          ], 34)
        ], 16)), [
          [vShow, _ctx.computedVisible || _ctx.mounted]
        ]) : createCommentVNode("v-if", true)
      ], 8, ["to", "disabled"]))
    ]),
    _: 3
  });
}
var _Modal = /* @__PURE__ */ _export_sfc(_sfc_main$4x, [["render", _sfc_render$4w]]);
const open = (config, appContext) => {
  let container2 = getOverlay("modal");
  const handleOk = () => {
    if (vm.component) {
      vm.component.props.visible = false;
    }
    if (isFunction(config.onOk)) {
      config.onOk();
    }
  };
  const handleCancel = () => {
    if (vm.component) {
      vm.component.props.visible = false;
    }
    if (isFunction(config.onCancel)) {
      config.onCancel();
    }
  };
  const handleClose = async () => {
    await nextTick();
    if (container2) {
      render(null, container2);
      document.body.removeChild(container2);
    }
    container2 = null;
    if (isFunction(config.onClose)) {
      config.onClose();
    }
  };
  const handleReturnClose = () => {
    if (vm.component) {
      vm.component.props.visible = false;
    }
  };
  const handleUpdateConfig = (config2) => {
    if (vm.component) {
      Object.entries(config2).forEach(([key, value]) => {
        vm.component.props[key] = value;
      });
    }
  };
  const defaultConfig = {
    visible: true,
    renderToBody: false,
    unmountOnClose: true,
    onOk: handleOk,
    onCancel: handleCancel,
    onClose: handleClose
  };
  const vm = createVNode(_Modal, {
    ...defaultConfig,
    ...omit(config, ["content", "title", "footer", "visible", "unmountOnClose", "onOk", "onCancel", "onClose"]),
    ...{
      footer: typeof config.footer === "boolean" ? config.footer : void 0
    }
  }, {
    default: getSlotFunction(config.content),
    title: getSlotFunction(config.title),
    footer: typeof config.footer !== "boolean" ? getSlotFunction(config.footer) : void 0
  });
  if (appContext != null ? appContext : Modal._context) {
    vm.appContext = appContext != null ? appContext : Modal._context;
  }
  render(vm, container2);
  document.body.appendChild(container2);
  return {
    close: handleReturnClose,
    update: handleUpdateConfig
  };
};
const modal = {
  open,
  confirm: (config, appContext) => {
    const _config = {
      simple: true,
      messageType: "warning",
      ...config
    };
    return open(_config, appContext);
  },
  ...MESSAGE_TYPES.reduce((pre, value) => {
    pre[value] = (config, appContext) => {
      const _config = {
        simple: true,
        hideCancel: true,
        messageType: value,
        ...config
      };
      return open(_config, appContext);
    };
    return pre;
  }, {})
};
const Modal = Object.assign(_Modal, {
  ...modal,
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Modal.name, _Modal);
    const modalWithContext = {};
    for (const key of Object.keys(modal)) {
      modalWithContext[key] = (config, appContext = app._context) => modal[key](config, appContext);
    }
    app.config.globalProperties.$modal = modalWithContext;
  },
  _context: null
});
const toKebabCase = (string) => {
  return string.replace(/\B([A-Z])/g, "-$1").toLowerCase();
};
const _sfc_main$4w = defineComponent({
  name: "Notification",
  components: {
    AIconHover: IconHover,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill,
    IconClose
  },
  props: {
    type: {
      type: String,
      default: "info"
    },
    showIcon: {
      type: Boolean,
      default: true
    },
    closable: {
      type: Boolean,
      default: false
    },
    duration: {
      type: Number,
      default: 3e3
    },
    resetOnUpdate: {
      type: Boolean,
      default: false
    }
  },
  emits: ["close"],
  setup(props, context) {
    const prefixCls = getPrefixCls("notification");
    let timer = 0;
    const handleClose = () => {
      context.emit("close");
    };
    onMounted(() => {
      if (props.duration > 0) {
        timer = window.setTimeout(handleClose, props.duration);
      }
    });
    onUpdated(() => {
      if (props.resetOnUpdate) {
        if (timer) {
          window.clearTimeout(timer);
          timer = 0;
        }
        if (props.duration > 0) {
          timer = window.setTimeout(handleClose, props.duration);
        }
      }
    });
    onUnmounted(() => {
      if (timer) {
        window.clearTimeout(timer);
      }
    });
    return {
      prefixCls,
      handleClose
    };
  }
});
function _sfc_render$4v(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_icon_close = resolveComponent("icon-close");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  return openBlock(), createElementBlock("li", {
    role: "alert",
    class: normalizeClass([
      _ctx.prefixCls,
      `${_ctx.prefixCls}-${_ctx.type}`,
      { [`${_ctx.prefixCls}-closable`]: _ctx.closable }
    ])
  }, [
    _ctx.showIcon ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-left`)
    }, [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-icon`)
      }, [
        renderSlot(_ctx.$slots, "icon", {}, () => [
          _ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, { key: 0 })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, { key: 1 })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 2 })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, { key: 3 })) : createCommentVNode("v-if", true)
        ])
      ], 2)
    ], 2)) : createCommentVNode("v-if", true),
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-right`)
    }, [
      _ctx.$slots.default ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-title`)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2)) : createCommentVNode("v-if", true),
      _ctx.$slots.content ? (openBlock(), createElementBlock("div", {
        key: 1,
        class: normalizeClass(`${_ctx.prefixCls}-content`)
      }, [
        renderSlot(_ctx.$slots, "content")
      ], 2)) : createCommentVNode("v-if", true),
      _ctx.$slots.footer ? (openBlock(), createElementBlock("div", {
        key: 2,
        class: normalizeClass(`${_ctx.prefixCls}-footer`)
      }, [
        renderSlot(_ctx.$slots, "footer")
      ], 2)) : createCommentVNode("v-if", true)
    ], 2),
    _ctx.closable ? (openBlock(), createElementBlock("div", {
      key: 1,
      class: normalizeClass(`${_ctx.prefixCls}-close-btn`),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
    }, [
      renderSlot(_ctx.$slots, "closeIconElement", {}, () => [
        createVNode(_component_a_icon_hover, null, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "closeIcon", {}, () => [
              createVNode(_component_icon_close)
            ])
          ]),
          _: 3
        })
      ])
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var Notification$1 = /* @__PURE__ */ _export_sfc(_sfc_main$4w, [["render", _sfc_render$4v]]);
const NOTIFICATION_POSITION = [
  "topLeft",
  "topRight",
  "bottomLeft",
  "bottomRight"
];
function _isSlot$7(s) {
  return typeof s === "function" || Object.prototype.toString.call(s) === "[object Object]" && !isVNode(s);
}
var NotificationList = defineComponent({
  name: "NotificationList",
  props: {
    notifications: {
      type: Array,
      default: () => []
    },
    position: {
      type: String,
      default: "topRight",
      validator: (value) => {
        return NOTIFICATION_POSITION.includes(value);
      }
    }
  },
  emits: ["close", "afterClose"],
  setup(props, context) {
    const prefixCls = getPrefixCls("notification-list");
    const kebabPosition = toKebabCase(props.position);
    const {
      zIndex
    } = usePopupManager("message", {
      runOnMounted: true
    });
    const isRight = props.position.includes("Right");
    return () => {
      let _slot;
      return createVNode(TransitionGroup, {
        "class": [prefixCls, `${prefixCls}-${kebabPosition}`],
        "style": {
          zIndex: zIndex.value
        },
        "name": `slide-${isRight ? "right" : "left"}-notification`,
        "onAfterLeave": () => context.emit("afterClose"),
        "tag": "ul"
      }, _isSlot$7(_slot = props.notifications.map((item) => {
        const slots = {
          default: getSlotFunction(item.title),
          content: getSlotFunction(item.content),
          icon: getSlotFunction(item.icon),
          footer: getSlotFunction(item.footer),
          closeIcon: getSlotFunction(item.closeIcon),
          closeIconElement: getSlotFunction(item.closeIconElement)
        };
        return createVNode(Notification$1, {
          "key": item.id,
          "type": item.type,
          "style": item.style,
          "class": item.class,
          "duration": item.duration,
          "closable": item.closable,
          "showIcon": item.showIcon,
          "resetOnUpdate": item.resetOnUpdate,
          "onClose": () => context.emit("close", item.id)
        }, slots);
      })) ? _slot : {
        default: () => [_slot]
      });
    };
  }
});
class NotificationManger {
  constructor(config, appContext) {
    this.notificationCount = 0;
    this.add = (config2) => {
      var _a;
      this.notificationCount++;
      const id = (_a = config2.id) != null ? _a : `__arco_notification_${this.notificationCount}`;
      if (this.notificationIds.has(id)) {
        return this.update(id, config2);
      }
      const notification2 = reactive({ id, ...config2 });
      this.notifications.value.push(notification2);
      this.notificationIds.add(id);
      return {
        close: () => this.remove(id)
      };
    };
    this.update = (id, config2) => {
      for (let i2 = 0; i2 < this.notifications.value.length; i2++) {
        if (this.notifications.value[i2].id === id) {
          const resetOnUpdate = !isUndefined(config2.duration);
          Object.assign(this.notifications.value[i2], {
            ...config2,
            id,
            resetOnUpdate
          });
          break;
        }
      }
      return {
        close: () => this.remove(id)
      };
    };
    this.remove = (id) => {
      for (let i2 = 0; i2 < this.notifications.value.length; i2++) {
        const item = this.notifications.value[i2];
        if (item.id === id) {
          if (isFunction(item.onClose)) {
            item.onClose(id);
          }
          this.notifications.value.splice(i2, 1);
          this.notificationIds.delete(id);
          break;
        }
      }
    };
    this.clear = () => {
      this.notifications.value.splice(0);
    };
    this.destroy = () => {
      if (this.notifications.value.length === 0 && this.container) {
        render(null, this.container);
        document.body.removeChild(this.container);
        this.container = null;
        notificationInstance[this.position] = void 0;
      }
    };
    const { position = "topRight" } = config;
    this.container = getOverlay("notification");
    this.notificationIds = /* @__PURE__ */ new Set();
    this.notifications = ref([]);
    this.position = position;
    const vm = createVNode(NotificationList, {
      notifications: this.notifications.value,
      position,
      onClose: this.remove,
      onAfterClose: this.destroy
    });
    if (appContext != null ? appContext : Notification._context) {
      vm.appContext = appContext != null ? appContext : Notification._context;
    }
    render(vm, this.container);
    document.body.appendChild(this.container);
  }
}
const notificationInstance = {};
const notification = MESSAGE_TYPES.reduce((pre, value) => {
  pre[value] = (config, appContext) => {
    if (isString(config)) {
      config = { content: config };
    }
    const _config = { type: value, ...config };
    const { position = "topRight" } = _config;
    if (!notificationInstance[position]) {
      notificationInstance[position] = new NotificationManger(
        _config,
        appContext
      );
    }
    return notificationInstance[position].add(_config);
  };
  return pre;
}, {});
notification.remove = (id) => {
  if (id) {
    Object.values(notificationInstance).forEach((item) => item == null ? void 0 : item.remove(id));
  }
};
notification.clear = (position) => {
  var _a;
  if (position) {
    (_a = notificationInstance[position]) == null ? void 0 : _a.clear();
  } else {
    Object.values(notificationInstance).forEach((item) => item == null ? void 0 : item.clear());
  }
};
const Notification = {
  ...notification,
  install: (app) => {
    const _notification = {
      clear: notification.clear
    };
    for (const key of MESSAGE_TYPES) {
      _notification[key] = (config, appContext = app._context) => notification[key](config, appContext);
    }
    app.config.globalProperties.$notification = _notification;
  },
  _context: null
};
const _sfc_main$4v = defineComponent({
  name: "PageHeader",
  components: { AIconHover: IconHover, IconLeft },
  props: {
    title: String,
    subtitle: String,
    showBack: {
      type: Boolean,
      default: true
    }
  },
  emits: [
    "back"
  ],
  setup(props, { emit, slots }) {
    const prefixCls = getPrefixCls("page-header");
    const handleBack = (e) => {
      emit("back", e);
    };
    const cls = computed(() => [
      prefixCls,
      {
        [`${prefixCls}-with-breadcrumb`]: Boolean(slots.breadcrumb),
        [`${prefixCls}-with-content`]: Boolean(slots.default)
      }
    ]);
    return {
      prefixCls,
      cls,
      handleBack
    };
  }
});
function _sfc_render$4u(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_left = resolveComponent("icon-left");
  const _component_a_icon_hover = resolveComponent("a-icon-hover");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(`${_ctx.prefixCls}-wrapper`)
    }, [
      _ctx.$slots.breadcrumb ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(`${_ctx.prefixCls}-breadcrumb`)
      }, [
        renderSlot(_ctx.$slots, "breadcrumb")
      ], 2)) : createCommentVNode("v-if", true),
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-header`)
      }, [
        createBaseVNode("span", {
          class: normalizeClass(`${_ctx.prefixCls}-main`)
        }, [
          _ctx.showBack ? (openBlock(), createBlock(_component_a_icon_hover, {
            key: 0,
            class: normalizeClass(`${_ctx.prefixCls}-back-btn`),
            prefix: _ctx.prefixCls,
            onClick: _ctx.handleBack
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "back-icon", {}, () => [
                createVNode(_component_icon_left)
              ])
            ]),
            _: 3
          }, 8, ["class", "prefix", "onClick"])) : createCommentVNode("v-if", true),
          createBaseVNode("span", {
            class: normalizeClass(`${_ctx.prefixCls}-title`)
          }, [
            renderSlot(_ctx.$slots, "title", {}, () => [
              createTextVNode(toDisplayString(_ctx.title), 1)
            ])
          ], 2),
          _ctx.$slots.subtitle || _ctx.subtitle ? (openBlock(), createElementBlock("span", {
            key: 1,
            class: normalizeClass(`${_ctx.prefixCls}-divider`)
          }, null, 2)) : createCommentVNode("v-if", true),
          _ctx.$slots.subtitle || _ctx.subtitle ? (openBlock(), createElementBlock("span", {
            key: 2,
            class: normalizeClass(`${_ctx.prefixCls}-subtitle`)
          }, [
            renderSlot(_ctx.$slots, "subtitle", {}, () => [
              createTextVNode(toDisplayString(_ctx.subtitle), 1)
            ])
          ], 2)) : createCommentVNode("v-if", true)
        ], 2),
        _ctx.$slots.extra ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: normalizeClass(`${_ctx.prefixCls}-extra`)
        }, [
          renderSlot(_ctx.$slots, "extra")
        ], 2)) : createCommentVNode("v-if", true)
      ], 2)
    ], 2),
    _ctx.$slots.default ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-content`)
    }, [
      renderSlot(_ctx.$slots, "default")
    ], 2)) : createCommentVNode("v-if", true)
  ], 2);
}
var _PageHeader = /* @__PURE__ */ _export_sfc(_sfc_main$4v, [["render", _sfc_render$4u]]);
const PageHeader = Object.assign(_PageHeader, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _PageHeader.name, _PageHeader);
  }
});
const _sfc_main$4u = defineComponent({
  name: "Popconfirm",
  components: {
    ArcoButton: Button,
    Trigger,
    IconInfoCircleFill,
    IconCheckCircleFill,
    IconExclamationCircleFill,
    IconCloseCircleFill
  },
  props: {
    content: String,
    position: {
      type: String,
      default: "top"
    },
    popupVisible: {
      type: Boolean,
      default: void 0
    },
    defaultPopupVisible: {
      type: Boolean,
      default: false
    },
    type: {
      type: String,
      default: "info"
    },
    okText: String,
    cancelText: String,
    okLoading: {
      type: Boolean,
      default: false
    },
    okButtonProps: {
      type: Object
    },
    cancelButtonProps: {
      type: Object
    },
    contentClass: {
      type: [String, Array, Object]
    },
    contentStyle: {
      type: Object
    },
    arrowClass: {
      type: [String, Array, Object]
    },
    arrowStyle: {
      type: Object
    },
    popupContainer: {
      type: [String, Object]
    },
    onBeforeOk: {
      type: Function
    },
    onBeforeCancel: {
      type: Function
    }
  },
  emits: {
    "update:popupVisible": (visible) => true,
    "popupVisibleChange": (visible) => true,
    "ok": () => true,
    "cancel": () => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("popconfirm");
    const { t } = useI18n();
    const _popupVisible = ref(props.defaultPopupVisible);
    const computedPopupVisible = computed(
      () => {
        var _a;
        return (_a = props.popupVisible) != null ? _a : _popupVisible.value;
      }
    );
    const _okLoading = ref(false);
    const mergedOkLoading = computed(() => props.okLoading || _okLoading.value);
    let promiseNumber = 0;
    const close = () => {
      promiseNumber++;
      if (_okLoading.value) {
        _okLoading.value = false;
      }
      _popupVisible.value = false;
      emit("update:popupVisible", false);
      emit("popupVisibleChange", false);
    };
    const handlePopupVisibleChange = (visible) => {
      if (!visible) {
        close();
      } else {
        _popupVisible.value = visible;
        emit("update:popupVisible", visible);
        emit("popupVisibleChange", visible);
      }
    };
    const handleOk = async () => {
      const currentPromiseNumber = promiseNumber;
      const closed = await new Promise(
        async (resolve) => {
          var _a;
          if (isFunction(props.onBeforeOk)) {
            let result = props.onBeforeOk((closed2 = true) => resolve(closed2));
            if (isPromise(result) || !isBoolean(result)) {
              _okLoading.value = true;
            }
            if (isPromise(result)) {
              try {
                result = (_a = await result) != null ? _a : true;
              } catch (error) {
                result = false;
                throw error;
              }
            }
            if (isBoolean(result)) {
              resolve(result);
            }
          } else {
            resolve(true);
          }
        }
      );
      if (currentPromiseNumber === promiseNumber) {
        if (closed) {
          emit("ok");
          close();
        } else if (_okLoading.value) {
          _okLoading.value = false;
        }
      }
    };
    const handleCancel = () => {
      var _a;
      let result = true;
      if (isFunction(props.onBeforeCancel)) {
        result = (_a = props.onBeforeCancel()) != null ? _a : false;
      }
      if (result) {
        emit("cancel");
        close();
      }
    };
    const contentCls = computed(() => [
      `${prefixCls}-popup-content`,
      props.contentClass
    ]);
    const arrowCls = computed(() => [
      `${prefixCls}-popup-arrow`,
      props.arrowClass
    ]);
    return {
      prefixCls,
      contentCls,
      arrowCls,
      computedPopupVisible,
      mergedOkLoading,
      handlePopupVisibleChange,
      handleOk,
      handleCancel,
      t
    };
  }
});
function _sfc_render$4t(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_info_circle_fill = resolveComponent("icon-info-circle-fill");
  const _component_icon_check_circle_fill = resolveComponent("icon-check-circle-fill");
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  const _component_icon_close_circle_fill = resolveComponent("icon-close-circle-fill");
  const _component_arco_button = resolveComponent("arco-button");
  const _component_trigger = resolveComponent("trigger");
  return openBlock(), createBlock(_component_trigger, {
    class: normalizeClass(_ctx.prefixCls),
    trigger: "click",
    position: _ctx.position,
    "show-arrow": "",
    "popup-visible": _ctx.computedPopupVisible,
    "popup-offset": 10,
    "popup-container": _ctx.popupContainer,
    "content-class": _ctx.contentCls,
    "content-style": _ctx.contentStyle,
    "arrow-class": _ctx.arrowCls,
    "arrow-style": _ctx.arrowStyle,
    "animation-name": "zoom-in-fade-out",
    "auto-fit-transform-origin": "",
    onPopupVisibleChange: _ctx.handlePopupVisibleChange
  }, {
    content: withCtx(() => [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-body`)
      }, [
        createBaseVNode("span", {
          class: normalizeClass(`${_ctx.prefixCls}-icon`)
        }, [
          renderSlot(_ctx.$slots, "icon", {}, () => [
            _ctx.type === "info" ? (openBlock(), createBlock(_component_icon_info_circle_fill, { key: 0 })) : _ctx.type === "success" ? (openBlock(), createBlock(_component_icon_check_circle_fill, { key: 1 })) : _ctx.type === "warning" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 2 })) : _ctx.type === "error" ? (openBlock(), createBlock(_component_icon_close_circle_fill, { key: 3 })) : createCommentVNode("v-if", true)
          ])
        ], 2),
        createBaseVNode("span", {
          class: normalizeClass(`${_ctx.prefixCls}-content`)
        }, [
          renderSlot(_ctx.$slots, "content", {}, () => [
            createTextVNode(toDisplayString(_ctx.content), 1)
          ])
        ], 2)
      ], 2),
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-footer`)
      }, [
        createVNode(_component_arco_button, mergeProps({ size: "mini" }, _ctx.cancelButtonProps, { onClick: _ctx.handleCancel }), {
          default: withCtx(() => [
            createTextVNode(toDisplayString(_ctx.cancelText || _ctx.t("popconfirm.cancelText")), 1)
          ]),
          _: 1
        }, 16, ["onClick"]),
        createVNode(_component_arco_button, mergeProps({
          type: "primary",
          size: "mini"
        }, _ctx.okButtonProps, {
          loading: _ctx.mergedOkLoading,
          onClick: _ctx.handleOk
        }), {
          default: withCtx(() => [
            createTextVNode(toDisplayString(_ctx.okText || _ctx.t("popconfirm.okText")), 1)
          ]),
          _: 1
        }, 16, ["loading", "onClick"])
      ], 2)
    ]),
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 8, ["class", "position", "popup-visible", "popup-container", "content-class", "content-style", "arrow-class", "arrow-style", "onPopupVisibleChange"]);
}
var _Popconfirm = /* @__PURE__ */ _export_sfc(_sfc_main$4u, [["render", _sfc_render$4t]]);
const Popconfirm = Object.assign(_Popconfirm, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Popconfirm.name, _Popconfirm);
  }
});
const DEFAULT_STROKE_WIDTH$1 = {
  small: 3,
  medium: 4,
  large: 8
};
const getBackground = (color) => {
  if (!color) {
    return void 0;
  }
  if (isObject(color)) {
    const val = Object.keys(color).map((key) => `${color[key]} ${key}`).join(",");
    return {
      backgroundImage: `linear-gradient(to right, ${val})`
    };
  }
  return {
    backgroundColor: color
  };
};
const _sfc_main$4t = defineComponent({
  name: "ProgressLine",
  components: {
    IconExclamationCircleFill
  },
  props: {
    percent: {
      type: Number,
      default: 0
    },
    animation: {
      type: Boolean,
      default: false
    },
    size: {
      type: String,
      default: "medium"
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    width: {
      type: [Number, String],
      default: "100%"
    },
    color: {
      type: [String, Object],
      default: void 0
    },
    trackColor: String,
    formatText: {
      type: Function,
      default: void 0
    },
    status: {
      type: String
    },
    showText: Boolean
  },
  setup(props) {
    const prefixCls = getPrefixCls("progress-line");
    const strokeWidth = computed(() => {
      if (props.strokeWidth !== 4) {
        return props.strokeWidth;
      }
      return DEFAULT_STROKE_WIDTH$1[props.size];
    });
    const text = computed(() => `${index$1.times(props.percent, 100)}%`);
    const style = computed(() => ({
      width: props.width,
      height: `${strokeWidth.value}px`,
      backgroundColor: props.trackColor
    }));
    const barStyle = computed(() => ({
      width: `${props.percent * 100}%`,
      ...getBackground(props.color)
    }));
    return {
      prefixCls,
      style,
      barStyle,
      text
    };
  }
});
const _hoisted_1$3$ = ["aria-valuenow"];
function _sfc_render$4s(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  return openBlock(), createElementBlock("div", {
    role: "progressbar",
    "aria-valuemin": "0",
    "aria-valuemax": "100",
    "aria-valuenow": _ctx.percent,
    class: normalizeClass(`${_ctx.prefixCls}-wrapper`)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(_ctx.prefixCls),
      style: normalizeStyle(_ctx.style)
    }, [
      createBaseVNode("div", {
        class: normalizeClass(`${_ctx.prefixCls}-bar-buffer`)
      }, null, 2),
      createBaseVNode("div", {
        class: normalizeClass([`${_ctx.prefixCls}-bar`]),
        style: normalizeStyle(_ctx.barStyle)
      }, null, 6)
    ], 6),
    _ctx.showText ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-text`)
    }, [
      renderSlot(_ctx.$slots, "text", { percent: _ctx.percent }, () => [
        createTextVNode(toDisplayString(_ctx.text) + " ", 1),
        _ctx.status === "danger" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 0 })) : createCommentVNode("v-if", true)
      ])
    ], 2)) : createCommentVNode("v-if", true)
  ], 10, _hoisted_1$3$);
}
var ProgressLine = /* @__PURE__ */ _export_sfc(_sfc_main$4t, [["render", _sfc_render$4s]]);
const _sfc_main$4s = defineComponent({
  name: "IconExclamation",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-exclamation`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$3_ = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4r(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M23 9h2v21h-2z" }, null, -1),
    createBaseVNode("path", {
      fill: "currentColor",
      stroke: "none",
      d: "M23 9h2v21h-2z"
    }, null, -1),
    createBaseVNode("path", { d: "M23 37h2v2h-2z" }, null, -1),
    createBaseVNode("path", {
      fill: "currentColor",
      stroke: "none",
      d: "M23 37h2v2h-2z"
    }, null, -1)
  ]), 14, _hoisted_1$3_);
}
var _IconExclamation = /* @__PURE__ */ _export_sfc(_sfc_main$4s, [["render", _sfc_render$4r]]);
const IconExclamation = Object.assign(_IconExclamation, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconExclamation.name, _IconExclamation);
  }
});
const _sfc_main$4r = defineComponent({
  name: "IconCheck",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-check`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$3Z = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4q(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", { d: "M41.678 11.05 19.05 33.678 6.322 20.95" }, null, -1)
  ]), 14, _hoisted_1$3Z);
}
var _IconCheck = /* @__PURE__ */ _export_sfc(_sfc_main$4r, [["render", _sfc_render$4q]]);
const IconCheck = Object.assign(_IconCheck, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconCheck.name, _IconCheck);
  }
});
let __ARCO_PROGRESS_SEED = 0;
const DEFAULT_WIDTH = {
  mini: 16,
  small: 48,
  medium: 64,
  large: 80
};
const DEFAULT_STROKE_WIDTH = {
  mini: 4,
  small: 3,
  medium: 4,
  large: 4
};
const _sfc_main$4q = defineComponent({
  name: "ProgressCircle",
  components: {
    IconExclamation,
    IconCheck
  },
  props: {
    percent: {
      type: Number,
      default: 0
    },
    type: {
      type: String
    },
    size: {
      type: String,
      default: "medium"
    },
    strokeWidth: {
      type: Number
    },
    width: {
      type: Number,
      default: void 0
    },
    color: {
      type: [String, Object],
      default: void 0
    },
    trackColor: String,
    status: {
      type: String,
      default: void 0
    },
    showText: {
      type: Boolean,
      default: true
    },
    pathStrokeWidth: {
      type: Number
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("progress-circle");
    const isLinearGradient = isObject(props.color);
    const mergedWidth = computed(() => {
      var _a;
      return (_a = props.width) != null ? _a : DEFAULT_WIDTH[props.size];
    });
    const mergedStrokeWidth = computed(
      () => {
        var _a;
        return (_a = props.strokeWidth) != null ? _a : props.size === "mini" ? mergedWidth.value / 2 : DEFAULT_STROKE_WIDTH[props.size];
      }
    );
    const mergedPathStrokeWidth = computed(
      () => {
        var _a;
        return (_a = props.pathStrokeWidth) != null ? _a : props.size === "mini" ? mergedStrokeWidth.value : Math.max(2, mergedStrokeWidth.value - 2);
      }
    );
    const radius = computed(
      () => (mergedWidth.value - mergedStrokeWidth.value) / 2
    );
    const perimeter = computed(() => Math.PI * 2 * radius.value);
    const center = computed(() => mergedWidth.value / 2);
    const linearGradientId = computed(() => {
      __ARCO_PROGRESS_SEED += 1;
      return `${prefixCls}-linear-gradient-${__ARCO_PROGRESS_SEED}`;
    });
    const text = computed(() => `${index$1.times(props.percent, 100)}%`);
    return {
      prefixCls,
      isLinearGradient,
      radius,
      text,
      perimeter,
      center,
      mergedWidth,
      mergedStrokeWidth,
      mergedPathStrokeWidth,
      linearGradientId
    };
  }
});
const _hoisted_1$3Y = ["aria-valuenow"];
const _hoisted_2$1 = ["viewBox"];
const _hoisted_3 = { key: 0 };
const _hoisted_4 = ["id"];
const _hoisted_5 = ["offset", "stop-color"];
const _hoisted_6 = ["cx", "cy", "r", "stroke-width"];
const _hoisted_7 = ["cx", "cy", "r", "stroke-width"];
function _sfc_render$4p(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_check = resolveComponent("icon-check");
  const _component_icon_exclamation = resolveComponent("icon-exclamation");
  return openBlock(), createElementBlock("div", {
    role: "progressbar",
    "aria-valuemin": "0",
    "aria-valuemax": "100",
    "aria-valuenow": _ctx.percent,
    class: normalizeClass(`${_ctx.prefixCls}-wrapper`),
    style: normalizeStyle({ width: `${_ctx.mergedWidth}px`, height: `${_ctx.mergedWidth}px` })
  }, [
    _ctx.type === "circle" && _ctx.size === "mini" && _ctx.status === "success" ? (openBlock(), createBlock(_component_icon_check, {
      key: 0,
      style: normalizeStyle({ fontSize: _ctx.mergedWidth - 2, color: _ctx.color })
    }, null, 8, ["style"])) : (openBlock(), createElementBlock("svg", {
      key: 1,
      viewBox: `0 0 ${_ctx.mergedWidth} ${_ctx.mergedWidth}`,
      class: normalizeClass(`${_ctx.prefixCls}-svg`)
    }, [
      _ctx.isLinearGradient ? (openBlock(), createElementBlock("defs", _hoisted_3, [
        createBaseVNode("linearGradient", {
          id: _ctx.linearGradientId,
          x1: "0",
          y1: "1",
          x2: "0",
          y2: "0"
        }, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(Object.keys(_ctx.color), (key) => {
            return openBlock(), createElementBlock("stop", {
              key,
              offset: key,
              "stop-color": _ctx.color[key]
            }, null, 8, _hoisted_5);
          }), 128))
        ], 8, _hoisted_4)
      ])) : createCommentVNode("v-if", true),
      createBaseVNode("circle", {
        class: normalizeClass(`${_ctx.prefixCls}-bg`),
        fill: "none",
        cx: _ctx.center,
        cy: _ctx.center,
        r: _ctx.radius,
        "stroke-width": _ctx.mergedPathStrokeWidth,
        style: normalizeStyle({
          stroke: _ctx.trackColor
        })
      }, null, 14, _hoisted_6),
      createBaseVNode("circle", {
        class: normalizeClass(`${_ctx.prefixCls}-bar`),
        fill: "none",
        cx: _ctx.center,
        cy: _ctx.center,
        r: _ctx.radius,
        "stroke-width": _ctx.mergedStrokeWidth,
        style: normalizeStyle({
          stroke: _ctx.isLinearGradient ? `url(#${_ctx.linearGradientId})` : _ctx.color,
          strokeDasharray: _ctx.perimeter,
          strokeDashoffset: (_ctx.percent >= 1 ? 0 : 1 - _ctx.percent) * _ctx.perimeter
        })
      }, null, 14, _hoisted_7)
    ], 10, _hoisted_2$1)),
    _ctx.showText && _ctx.size !== "mini" ? (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass(`${_ctx.prefixCls}-text`)
    }, [
      renderSlot(_ctx.$slots, "text", { percent: _ctx.percent }, () => [
        _ctx.status === "danger" ? (openBlock(), createBlock(_component_icon_exclamation, { key: 0 })) : _ctx.status === "success" ? (openBlock(), createBlock(_component_icon_check, { key: 1 })) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
          createTextVNode(toDisplayString(_ctx.text), 1)
        ], 64))
      ])
    ], 2)) : createCommentVNode("v-if", true)
  ], 14, _hoisted_1$3Y);
}
var ProgressCircle = /* @__PURE__ */ _export_sfc(_sfc_main$4q, [["render", _sfc_render$4p]]);
const _sfc_main$4p = defineComponent({
  name: "ProgressSteps",
  components: {
    IconExclamationCircleFill
  },
  props: {
    steps: {
      type: Number,
      default: 0
    },
    percent: {
      type: Number,
      default: 0
    },
    size: {
      type: String
    },
    color: {
      type: [String, Object],
      default: void 0
    },
    trackColor: String,
    strokeWidth: {
      type: Number
    },
    status: {
      type: String,
      default: void 0
    },
    showText: {
      type: Boolean,
      default: true
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("progress-steps");
    const mergedStrokeWidth = computed(
      () => {
        var _a;
        return ((_a = props.strokeWidth) != null ? _a : props.size === "small") ? 8 : 4;
      }
    );
    const stepList = computed(
      () => [...Array(props.steps)].map((_, index2) => {
        return props.percent > 0 && props.percent > 1 / props.steps * index2;
      })
    );
    const text = computed(() => `${index$1.times(props.percent, 100)}%`);
    return {
      prefixCls,
      stepList,
      mergedStrokeWidth,
      text
    };
  }
});
const _hoisted_1$3X = ["aria-valuenow"];
function _sfc_render$4o(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_icon_exclamation_circle_fill = resolveComponent("icon-exclamation-circle-fill");
  return openBlock(), createElementBlock("div", {
    role: "progressbar",
    "aria-valuemin": "0",
    "aria-valuemax": "100",
    "aria-valuenow": _ctx.percent,
    class: normalizeClass(`${_ctx.prefixCls}-wrapper`)
  }, [
    createBaseVNode("div", {
      class: normalizeClass(_ctx.prefixCls),
      style: normalizeStyle({ height: `${_ctx.mergedStrokeWidth}px` })
    }, [
      (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.stepList, (active, index2) => {
        return openBlock(), createElementBlock("div", {
          key: index2,
          class: normalizeClass([
            `${_ctx.prefixCls}-item`,
            {
              [`${_ctx.prefixCls}-item-active`]: active
            }
          ]),
          style: normalizeStyle({
            backgroundColor: active ? _ctx.color : _ctx.trackColor
          })
        }, null, 6);
      }), 128))
    ], 6),
    _ctx.showText ? (openBlock(), createElementBlock("div", {
      key: 0,
      class: normalizeClass(`${_ctx.prefixCls}-text`)
    }, [
      renderSlot(_ctx.$slots, "text", { percent: _ctx.percent }, () => [
        createTextVNode(toDisplayString(_ctx.text) + " ", 1),
        _ctx.status === "danger" ? (openBlock(), createBlock(_component_icon_exclamation_circle_fill, { key: 0 })) : createCommentVNode("v-if", true)
      ])
    ], 2)) : createCommentVNode("v-if", true)
  ], 10, _hoisted_1$3X);
}
var ProgressSteps = /* @__PURE__ */ _export_sfc(_sfc_main$4p, [["render", _sfc_render$4o]]);
const _sfc_main$4o = defineComponent({
  name: "Progress",
  components: {
    ProgressLine,
    ProgressCircle,
    ProgressSteps
  },
  props: {
    type: {
      type: String,
      default: "line"
    },
    size: {
      type: String
    },
    percent: {
      type: Number,
      default: 0
    },
    steps: {
      type: Number,
      default: 0
    },
    animation: {
      type: Boolean,
      default: false
    },
    strokeWidth: {
      type: Number
    },
    width: {
      type: [Number, String]
    },
    color: {
      type: [String, Object]
    },
    trackColor: String,
    bufferColor: {
      type: [String, Object]
    },
    showText: {
      type: Boolean,
      default: true
    },
    status: {
      type: String
    }
  },
  setup(props) {
    const prefixCls = getPrefixCls("progress");
    const { size } = toRefs(props);
    const type = computed(() => props.steps > 0 ? "steps" : props.type);
    const computedStatus = computed(() => {
      return props.status || (props.percent >= 1 ? "success" : "normal");
    });
    const { mergedSize } = useSize$1(size);
    const cls = computed(() => [
      prefixCls,
      `${prefixCls}-type-${type.value}`,
      `${prefixCls}-size-${mergedSize.value}`,
      `${prefixCls}-status-${computedStatus.value}`
    ]);
    return {
      cls,
      computedStatus,
      mergedSize
    };
  }
});
function _sfc_render$4n(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_progress_steps = resolveComponent("progress-steps");
  const _component_progress_line = resolveComponent("progress-line");
  const _component_progress_circle = resolveComponent("progress-circle");
  return openBlock(), createElementBlock("div", {
    class: normalizeClass(_ctx.cls)
  }, [
    _ctx.steps > 0 ? (openBlock(), createBlock(_component_progress_steps, {
      key: 0,
      "stroke-width": _ctx.strokeWidth,
      percent: _ctx.percent,
      color: _ctx.color,
      "track-color": _ctx.trackColor,
      width: _ctx.width,
      steps: _ctx.steps,
      size: _ctx.mergedSize,
      "show-text": _ctx.showText
    }, createSlots({ _: 2 }, [
      _ctx.$slots.text ? {
        name: "text",
        fn: withCtx((scope) => [
          renderSlot(_ctx.$slots, "text", normalizeProps(guardReactiveProps(scope)))
        ]),
        key: "0"
      } : void 0
    ]), 1032, ["stroke-width", "percent", "color", "track-color", "width", "steps", "size", "show-text"])) : _ctx.type === "line" && _ctx.mergedSize !== "mini" ? (openBlock(), createBlock(_component_progress_line, {
      key: 1,
      "stroke-width": _ctx.strokeWidth,
      animation: _ctx.animation,
      percent: _ctx.percent,
      color: _ctx.color,
      "track-color": _ctx.trackColor,
      size: _ctx.mergedSize,
      "buffer-color": _ctx.bufferColor,
      width: _ctx.width,
      "show-text": _ctx.showText,
      status: _ctx.computedStatus
    }, createSlots({ _: 2 }, [
      _ctx.$slots.text ? {
        name: "text",
        fn: withCtx((scope) => [
          renderSlot(_ctx.$slots, "text", normalizeProps(guardReactiveProps(scope)))
        ]),
        key: "0"
      } : void 0
    ]), 1032, ["stroke-width", "animation", "percent", "color", "track-color", "size", "buffer-color", "width", "show-text", "status"])) : (openBlock(), createBlock(_component_progress_circle, {
      key: 2,
      type: _ctx.type,
      "stroke-width": _ctx.type === "line" ? _ctx.strokeWidth || 4 : _ctx.strokeWidth,
      "path-stroke-width": _ctx.type === "line" ? _ctx.strokeWidth || 4 : _ctx.strokeWidth,
      width: _ctx.width,
      percent: _ctx.percent,
      color: _ctx.color,
      "track-color": _ctx.trackColor,
      size: _ctx.mergedSize,
      "show-text": _ctx.showText,
      status: _ctx.computedStatus
    }, createSlots({ _: 2 }, [
      _ctx.$slots.text ? {
        name: "text",
        fn: withCtx((scope) => [
          renderSlot(_ctx.$slots, "text", normalizeProps(guardReactiveProps(scope)))
        ]),
        key: "0"
      } : void 0
    ]), 1032, ["type", "stroke-width", "path-stroke-width", "width", "percent", "color", "track-color", "size", "show-text", "status"]))
  ], 2);
}
var _Progress = /* @__PURE__ */ _export_sfc(_sfc_main$4o, [["render", _sfc_render$4n]]);
const Progress = Object.assign(_Progress, {
  install: (app, options) => {
    setGlobalConfig(app, options);
    const componentPrefix = getComponentPrefix(options);
    app.component(componentPrefix + _Progress.name, _Progress);
  }
});
const _sfc_main$4n = defineComponent({
  name: "IconStarFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-star-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$3W = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4m(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      d: "M22.683 5.415c.568-1.043 2.065-1.043 2.634 0l5.507 10.098a1.5 1.5 0 0 0 1.04.756l11.306 2.117c1.168.219 1.63 1.642.814 2.505l-7.902 8.359a1.5 1.5 0 0 0-.397 1.223l1.48 11.407c.153 1.177-1.058 2.057-2.131 1.548l-10.391-4.933a1.5 1.5 0 0 0-1.287 0l-10.39 4.933c-1.073.51-2.284-.37-2.131-1.548l1.48-11.407a1.5 1.5 0 0 0-.398-1.223L4.015 20.89c-.816-.863-.353-2.286.814-2.505l11.306-2.117a1.5 1.5 0 0 0 1.04-.756l5.508-10.098Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$3W);
}
var _IconStarFill = /* @__PURE__ */ _export_sfc(_sfc_main$4n, [["render", _sfc_render$4m]]);
const IconStarFill = Object.assign(_IconStarFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconStarFill.name, _IconStarFill);
  }
});
const _sfc_main$4m = defineComponent({
  name: "IconFaceMehFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-face-meh-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$3V = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4l(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm7.321-26.873a2.625 2.625 0 1 1 0 5.25 2.625 2.625 0 0 1 0-5.25Zm-14.646 0a2.625 2.625 0 1 1 0 5.25 2.625 2.625 0 0 1 0-5.25ZM15.999 30a2 2 0 0 1 2-2h12a2 2 0 1 1 0 4H18a2 2 0 0 1-2-2Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$3V);
}
var _IconFaceMehFill = /* @__PURE__ */ _export_sfc(_sfc_main$4m, [["render", _sfc_render$4l]]);
const IconFaceMehFill = Object.assign(_IconFaceMehFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconFaceMehFill.name, _IconFaceMehFill);
  }
});
const _sfc_main$4l = defineComponent({
  name: "IconFaceSmileFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-face-smile-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$3U = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4k(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm7.321-26.873a2.625 2.625 0 1 1 0 5.25 2.625 2.625 0 0 1 0-5.25Zm-14.646 0a2.625 2.625 0 1 1 0 5.25 2.625 2.625 0 0 1 0-5.25Zm-.355 9.953a1.91 1.91 0 0 1 2.694.177 6.66 6.66 0 0 0 5.026 2.279c1.918 0 3.7-.81 4.961-2.206a1.91 1.91 0 0 1 2.834 2.558 10.476 10.476 0 0 1-7.795 3.466 10.477 10.477 0 0 1-7.897-3.58 1.91 1.91 0 0 1 .177-2.694Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$3U);
}
var _IconFaceSmileFill = /* @__PURE__ */ _export_sfc(_sfc_main$4l, [["render", _sfc_render$4k]]);
const IconFaceSmileFill = Object.assign(_IconFaceSmileFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconFaceSmileFill.name, _IconFaceSmileFill);
  }
});
const _sfc_main$4k = defineComponent({
  name: "IconFaceFrownFill",
  props: {
    size: {
      type: [Number, String]
    },
    strokeWidth: {
      type: Number,
      default: 4
    },
    strokeLinecap: {
      type: String,
      default: "butt",
      validator: (value) => {
        return ["butt", "round", "square"].includes(value);
      }
    },
    strokeLinejoin: {
      type: String,
      default: "miter",
      validator: (value) => {
        return ["arcs", "bevel", "miter", "miter-clip", "round"].includes(value);
      }
    },
    rotate: Number,
    spin: Boolean
  },
  emits: {
    click: (ev) => true
  },
  setup(props, { emit }) {
    const prefixCls = getPrefixCls("icon");
    const cls = computed(() => [prefixCls, `${prefixCls}-face-frown-fill`, { [`${prefixCls}-spin`]: props.spin }]);
    const innerStyle = computed(() => {
      const styles = {};
      if (props.size) {
        styles.fontSize = isNumber(props.size) ? `${props.size}px` : props.size;
      }
      if (props.rotate) {
        styles.transform = `rotate(${props.rotate}deg)`;
      }
      return styles;
    });
    const onClick = (ev) => {
      emit("click", ev);
    };
    return {
      cls,
      innerStyle,
      onClick
    };
  }
});
const _hoisted_1$3T = ["stroke-width", "stroke-linecap", "stroke-linejoin"];
function _sfc_render$4j(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("svg", {
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    stroke: "currentColor",
    class: normalizeClass(_ctx.cls),
    style: normalizeStyle(_ctx.innerStyle),
    "stroke-width": _ctx.strokeWidth,
    "stroke-linecap": _ctx.strokeLinecap,
    "stroke-linejoin": _ctx.strokeLinejoin,
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.onClick && _ctx.onClick(...args))
  }, _cache[1] || (_cache[1] = [
    createBaseVNode("path", {
      "fill-rule": "evenodd",
      "clip-rule": "evenodd",
      d: "M24 44c11.046 0 20-8.954 20-20S35.046 4 24 4 4 12.954 4 24s8.954 20 20 20Zm7.322-26.873a2.625 2.625 0 1 1 0 5.25 2.625 2.625 0 0 1 0-5.25Zm-14.646 0a2.625 2.625 0 1 1 0 5.25 2.625 2.625 0 0 1 0-5.25ZM31.68 32.88a1.91 1.91 0 0 1-2.694-.176 6.66 6.66 0 0 0-5.026-2.28c-1.918 0-3.701.81-4.962 2.207a1.91 1.91 0 0 1-2.834-2.559 10.476 10.476 0 0 1 7.796-3.465c3.063 0 5.916 1.321 7.896 3.58a1.909 1.909 0 0 1-.176 2.693Z",
      fill: "currentColor",
      stroke: "none"
    }, null, -1)
  ]), 14, _hoisted_1$3T);
}
var _IconFaceFrownFill = /* @__PURE__ */ _export_sfc(_sfc_main$4k, [["render", _sfc_render$4j]]);
const IconFaceFrownFill = Object.assign(_IconFaceFrownFill, {
  install: (app, options) => {
    var _a;
    const iconPrefix = (_a = options == null ? void 0 : options.iconPrefix) != null ? _a : "";
    app.component(iconPrefix + _IconFaceFrownFill.name, _IconFaceFrownFill);
  }
});
var _Rate = defineComponent({
  name: "Rate",
  props: {
    count: {
      type: Number,
      default: 5
    },
    modelValue: {
      type: Number,
      default: void 0
    },
    defaultValue: {
      type: Number,
      default: 0
    },
    allowHalf: {
      type: Boolean,
      default: false
    },
    allowClear: {
      type: Boolean,
      default: false
    },
    grading: {
      type: Boolean,
      default: false
    },
    readonly: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    color: {
      type: [String, Object]
    }
  },
  emits: {
    "update:modelValue": (value) => true,
    "change": (value) => true,
    "hoverChange": (value) => true
  },
  setup(props, {
    emit,
    slots
  }) {
    const {
      modelValue
    } = toRefs(props);
    const prefixCls = getPrefixCls("rate");
    const {
      mergedDisabled: _mergedDisabled,
      eventHandlers
    } = useFormItem({
      disabled: toRef(props, "disabled")
    });
    const _value = ref(props.defaultValue);
    const animation = ref(false);
    watch(modelValue, (value) => {
      if (isUndefined(value) || isNull(value)) {
        _value.value = 0;
      }
    });
    const hoverIndex = ref(0);
    const computedValue = computed(() => {
      var _a;
      return (_a = props.modelValue) != null ? _a : _value.value;
    });
    const displayIndex = computed(() => {
      const fixedValue = props.allowHalf ? index$1.times(index$1.round(index$1.divide(computedValue.value, 0.5), 0), 0.5) : Math.round(computedValue.value);
      return hoverIndex.value || fixedValue;
    });
    const mergedDisabled = computed(() => _mergedDisabled.value || props.readonly);
    const indexArray = computed(() => [...Array(props.grading ? 5 : props.count)]);
    const customColor = computed(() => {
      var _a;
      if (isString(props.color)) {
        return indexArray.value.map(() => props.color);
      }
      if (isObject(props.color)) {
        const sortedKeys = Object.keys(props.color).map((key) => Number(key)).sort((a, b) => b - a);
        let threshold = (_a = sortedKeys.pop()) != null ? _a : indexArray.value.length;
        return indexArray.value.map((_, index2) => {
          var _a2;
          if (index2 + 1 > threshold) {
            threshold = (_a2 = sortedKeys.pop()) != null ? _a2 : threshold;
          }
          return props.color[String(threshold)];
        });
      }
      return void 0;
    });
    const resetHoverIndex = () => {
      if (hoverIndex.value) {
        hoverIndex.value = 0;
        emit("hoverChange", 0);
      }
    };
    const handleMouseEnter = (index2, isHalf) => {
      const newHoverIndex = isHalf && props.allowHalf ? index2 + 0.5 : index2 + 1;
      if (newHoverIndex !== hoverIndex.value) {
        hoverIndex.value = newHoverIndex;
        emit("hoverChange", newHover