import { w as window_1 } from "./global.dfc622c4.js";
import { r as require$$1 } from "./@babel.dac5e1c0.js";
import { i as isFunction_1 } from "./is-function.1b723eb5.js";
var lib = { exports: {} };
function _createForOfIteratorHelperLoose(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (it)
    return (it = it.call(o)).next.bind(it);
  if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
    if (it)
      o = it;
    var i = 0;
    return function() {
      if (i >= o.length)
        return { done: true };
      return { done: false, value: o[i++] };
    };
  }
  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor)
    n = o.constructor.name;
  if (n === "Map" || n === "Set")
    return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }
  return arr2;
}
var InterceptorsStorage$1 = /* @__PURE__ */ function() {
  function InterceptorsStorage2() {
    this.typeToInterceptorsMap_ = /* @__PURE__ */ new Map();
    this.enabled_ = false;
  }
  var _proto = InterceptorsStorage2.prototype;
  _proto.getIsEnabled = function getIsEnabled() {
    return this.enabled_;
  };
  _proto.enable = function enable() {
    this.enabled_ = true;
  };
  _proto.disable = function disable() {
    this.enabled_ = false;
  };
  _proto.reset = function reset() {
    this.typeToInterceptorsMap_ = /* @__PURE__ */ new Map();
    this.enabled_ = false;
  };
  _proto.addInterceptor = function addInterceptor(type, interceptor) {
    if (!this.typeToInterceptorsMap_.has(type)) {
      this.typeToInterceptorsMap_.set(type, /* @__PURE__ */ new Set());
    }
    var interceptorsSet = this.typeToInterceptorsMap_.get(type);
    if (interceptorsSet.has(interceptor)) {
      return false;
    }
    interceptorsSet.add(interceptor);
    return true;
  };
  _proto.removeInterceptor = function removeInterceptor(type, interceptor) {
    var interceptorsSet = this.typeToInterceptorsMap_.get(type);
    if (interceptorsSet && interceptorsSet.has(interceptor)) {
      interceptorsSet.delete(interceptor);
      return true;
    }
    return false;
  };
  _proto.clearInterceptorsByType = function clearInterceptorsByType(type) {
    var interceptorsSet = this.typeToInterceptorsMap_.get(type);
    if (!interceptorsSet) {
      return false;
    }
    this.typeToInterceptorsMap_.delete(type);
    this.typeToInterceptorsMap_.set(type, /* @__PURE__ */ new Set());
    return true;
  };
  _proto.clear = function clear() {
    if (!this.typeToInterceptorsMap_.size) {
      return false;
    }
    this.typeToInterceptorsMap_ = /* @__PURE__ */ new Map();
    return true;
  };
  _proto.getForType = function getForType(type) {
    return this.typeToInterceptorsMap_.get(type) || /* @__PURE__ */ new Set();
  };
  _proto.execute = function execute(type, payload) {
    var interceptors2 = this.getForType(type);
    for (var _iterator = _createForOfIteratorHelperLoose(interceptors2), _step; !(_step = _iterator()).done; ) {
      var interceptor = _step.value;
      try {
        payload = interceptor(payload);
      } catch (e) {
      }
    }
    return payload;
  };
  return InterceptorsStorage2;
}();
var interceptors = InterceptorsStorage$1;
var RetryManager$1 = /* @__PURE__ */ function() {
  function RetryManager2() {
    this.maxAttempts_ = 1;
    this.delayFactor_ = 0.1;
    this.fuzzFactor_ = 0.1;
    this.initialDelay_ = 1e3;
    this.enabled_ = false;
  }
  var _proto = RetryManager2.prototype;
  _proto.getIsEnabled = function getIsEnabled() {
    return this.enabled_;
  };
  _proto.enable = function enable() {
    this.enabled_ = true;
  };
  _proto.disable = function disable() {
    this.enabled_ = false;
  };
  _proto.reset = function reset() {
    this.maxAttempts_ = 1;
    this.delayFactor_ = 0.1;
    this.fuzzFactor_ = 0.1;
    this.initialDelay_ = 1e3;
    this.enabled_ = false;
  };
  _proto.getMaxAttempts = function getMaxAttempts() {
    return this.maxAttempts_;
  };
  _proto.setMaxAttempts = function setMaxAttempts(maxAttempts) {
    this.maxAttempts_ = maxAttempts;
  };
  _proto.getDelayFactor = function getDelayFactor() {
    return this.delayFactor_;
  };
  _proto.setDelayFactor = function setDelayFactor(delayFactor) {
    this.delayFactor_ = delayFactor;
  };
  _proto.getFuzzFactor = function getFuzzFactor() {
    return this.fuzzFactor_;
  };
  _proto.setFuzzFactor = function setFuzzFactor(fuzzFactor) {
    this.fuzzFactor_ = fuzzFactor;
  };
  _proto.getInitialDelay = function getInitialDelay() {
    return this.initialDelay_;
  };
  _proto.setInitialDelay = function setInitialDelay(initialDelay) {
    this.initialDelay_ = initialDelay;
  };
  _proto.createRetry = function createRetry(_temp) {
    var _ref = _temp === void 0 ? {} : _temp, maxAttempts = _ref.maxAttempts, delayFactor = _ref.delayFactor, fuzzFactor = _ref.fuzzFactor, initialDelay = _ref.initialDelay;
    return new Retry({
      maxAttempts: maxAttempts || this.maxAttempts_,
      delayFactor: delayFactor || this.delayFactor_,
      fuzzFactor: fuzzFactor || this.fuzzFactor_,
      initialDelay: initialDelay || this.initialDelay_
    });
  };
  return RetryManager2;
}();
var Retry = /* @__PURE__ */ function() {
  function Retry2(options) {
    this.maxAttempts_ = options.maxAttempts;
    this.delayFactor_ = options.delayFactor;
    this.fuzzFactor_ = options.fuzzFactor;
    this.currentDelay_ = options.initialDelay;
    this.currentAttempt_ = 1;
  }
  var _proto2 = Retry2.prototype;
  _proto2.moveToNextAttempt = function moveToNextAttempt() {
    this.currentAttempt_++;
    var delayDelta = this.currentDelay_ * this.delayFactor_;
    this.currentDelay_ = this.currentDelay_ + delayDelta;
  };
  _proto2.shouldRetry = function shouldRetry() {
    return this.currentAttempt_ < this.maxAttempts_;
  };
  _proto2.getCurrentDelay = function getCurrentDelay() {
    return this.currentDelay_;
  };
  _proto2.getCurrentMinPossibleDelay = function getCurrentMinPossibleDelay() {
    return (1 - this.fuzzFactor_) * this.currentDelay_;
  };
  _proto2.getCurrentMaxPossibleDelay = function getCurrentMaxPossibleDelay() {
    return (1 + this.fuzzFactor_) * this.currentDelay_;
  };
  _proto2.getCurrentFuzzedDelay = function getCurrentFuzzedDelay() {
    var lowValue = this.getCurrentMinPossibleDelay();
    var highValue = this.getCurrentMaxPossibleDelay();
    return lowValue + Math.random() * (highValue - lowValue);
  };
  return Retry2;
}();
var retry = RetryManager$1;
var window$1 = window_1;
var httpResponseHandler = function httpResponseHandler2(callback, decodeResponseBody) {
  if (decodeResponseBody === void 0) {
    decodeResponseBody = false;
  }
  return function(err, response, responseBody) {
    if (err) {
      callback(err);
      return;
    }
    if (response.statusCode >= 400 && response.statusCode <= 599) {
      var cause = responseBody;
      if (decodeResponseBody) {
        if (window$1.TextDecoder) {
          var charset = getCharset(response.headers && response.headers["content-type"]);
          try {
            cause = new TextDecoder(charset).decode(responseBody);
          } catch (e) {
          }
        } else {
          cause = String.fromCharCode.apply(null, new Uint8Array(responseBody));
        }
      }
      callback({
        cause
      });
      return;
    }
    callback(null, responseBody);
  };
};
function getCharset(contentTypeHeader) {
  if (contentTypeHeader === void 0) {
    contentTypeHeader = "";
  }
  return contentTypeHeader.toLowerCase().split(";").reduce(function(charset, contentType) {
    var _contentType$split = contentType.split("="), type = _contentType$split[0], value = _contentType$split[1];
    if (type.trim() === "charset") {
      return value.trim();
    }
    return charset;
  }, "utf-8");
}
var httpHandler = httpResponseHandler;
var window = window_1;
var _extends = require$$1;
var isFunction = isFunction_1;
var InterceptorsStorage = interceptors;
var RetryManager = retry;
createXHR.httpHandler = httpHandler;
createXHR.requestInterceptorsStorage = new InterceptorsStorage();
createXHR.responseInterceptorsStorage = new InterceptorsStorage();
createXHR.retryManager = new RetryManager();
/**
 * @license
 * slighly modified parse-headers 2.0.2 <https://github.com/kesla/parse-headers/>
 * Copyright (c) 2014 David Björklund
 * Available under the MIT license
 * <https://github.com/kesla/parse-headers/blob/master/LICENCE>
 */
var parseHeaders = function parseHeaders2(headers) {
  var result = {};
  if (!headers) {
    return result;
  }
  headers.trim().split("\n").forEach(function(row) {
    var index = row.indexOf(":");
    var key = row.slice(0, index).trim().toLowerCase();
    var value = row.slice(index + 1).trim();
    if (typeof result[key] === "undefined") {
      result[key] = value;
    } else if (Array.isArray(result[key])) {
      result[key].push(value);
    } else {
      result[key] = [result[key], value];
    }
  });
  return result;
};
lib.exports = createXHR;
lib.exports.default = createXHR;
createXHR.XMLHttpRequest = window.XMLHttpRequest || noop;
createXHR.XDomainRequest = "withCredentials" in new createXHR.XMLHttpRequest() ? createXHR.XMLHttpRequest : window.XDomainRequest;
forEachArray(["get", "put", "post", "patch", "head", "delete"], function(method) {
  createXHR[method === "delete" ? "del" : method] = function(uri, options, callback) {
    options = initParams(uri, options, callback);
    options.method = method.toUpperCase();
    return _createXHR(options);
  };
});
function forEachArray(array, iterator) {
  for (var i = 0; i < array.length; i++) {
    iterator(array[i]);
  }
}
function isEmpty(obj) {
  for (var i in obj) {
    if (obj.hasOwnProperty(i))
      return false;
  }
  return true;
}
function initParams(uri, options, callback) {
  var params = uri;
  if (isFunction(options)) {
    callback = options;
    if (typeof uri === "string") {
      params = {
        uri
      };
    }
  } else {
    params = _extends({}, options, {
      uri
    });
  }
  params.callback = callback;
  return params;
}
function createXHR(uri, options, callback) {
  options = initParams(uri, options, callback);
  return _createXHR(options);
}
function _createXHR(options) {
  if (typeof options.callback === "undefined") {
    throw new Error("callback argument missing");
  }
  if (options.requestType && createXHR.requestInterceptorsStorage.getIsEnabled()) {
    var requestInterceptorPayload = {
      uri: options.uri || options.url,
      headers: options.headers || {},
      body: options.body,
      metadata: options.metadata || {},
      retry: options.retry,
      timeout: options.timeout
    };
    var updatedPayload = createXHR.requestInterceptorsStorage.execute(options.requestType, requestInterceptorPayload);
    options.uri = updatedPayload.uri;
    options.headers = updatedPayload.headers;
    options.body = updatedPayload.body;
    options.metadata = updatedPayload.metadata;
    options.retry = updatedPayload.retry;
    options.timeout = updatedPayload.timeout;
  }
  var called = false;
  var callback = function cbOnce(err, response, body2) {
    if (!called) {
      called = true;
      options.callback(err, response, body2);
    }
  };
  function readystatechange() {
    if (xhr.readyState === 4 && !createXHR.responseInterceptorsStorage.getIsEnabled()) {
      setTimeout(loadFunc, 0);
    }
  }
  function getBody() {
    var body2 = void 0;
    if (xhr.response) {
      body2 = xhr.response;
    } else {
      body2 = xhr.responseText || getXml(xhr);
    }
    if (isJson) {
      try {
        body2 = JSON.parse(body2);
      } catch (e) {
      }
    }
    return body2;
  }
  function errorFunc(evt) {
    clearTimeout(timeoutTimer);
    clearTimeout(options.retryTimeout);
    if (!(evt instanceof Error)) {
      evt = new Error("" + (evt || "Unknown XMLHttpRequest Error"));
    }
    evt.statusCode = 0;
    if (!aborted && createXHR.retryManager.getIsEnabled() && options.retry && options.retry.shouldRetry()) {
      options.retryTimeout = setTimeout(function() {
        options.retry.moveToNextAttempt();
        options.xhr = xhr;
        _createXHR(options);
      }, options.retry.getCurrentFuzzedDelay());
      return;
    }
    if (options.requestType && createXHR.responseInterceptorsStorage.getIsEnabled()) {
      var responseInterceptorPayload = {
        headers: failureResponse.headers || {},
        body: failureResponse.body,
        responseUrl: xhr.responseURL,
        responseType: xhr.responseType
      };
      var _updatedPayload = createXHR.responseInterceptorsStorage.execute(options.requestType, responseInterceptorPayload);
      failureResponse.body = _updatedPayload.body;
      failureResponse.headers = _updatedPayload.headers;
    }
    return callback(evt, failureResponse);
  }
  function loadFunc() {
    if (aborted)
      return;
    var status;
    clearTimeout(timeoutTimer);
    clearTimeout(options.retryTimeout);
    if (options.useXDR && xhr.status === void 0) {
      status = 200;
    } else {
      status = xhr.status === 1223 ? 204 : xhr.status;
    }
    var response = failureResponse;
    var err = null;
    if (status !== 0) {
      response = {
        body: getBody(),
        statusCode: status,
        method,
        headers: {},
        url: uri,
        rawRequest: xhr
      };
      if (xhr.getAllResponseHeaders) {
        response.headers = parseHeaders(xhr.getAllResponseHeaders());
      }
    } else {
      err = new Error("Internal XMLHttpRequest Error");
    }
    if (options.requestType && createXHR.responseInterceptorsStorage.getIsEnabled()) {
      var responseInterceptorPayload = {
        headers: response.headers || {},
        body: response.body,
        responseUrl: xhr.responseURL,
        responseType: xhr.responseType
      };
      var _updatedPayload2 = createXHR.responseInterceptorsStorage.execute(options.requestType, responseInterceptorPayload);
      response.body = _updatedPayload2.body;
      response.headers = _updatedPayload2.headers;
    }
    return callback(err, response, response.body);
  }
  var xhr = options.xhr || null;
  if (!xhr) {
    if (options.cors || options.useXDR) {
      xhr = new createXHR.XDomainRequest();
    } else {
      xhr = new createXHR.XMLHttpRequest();
    }
  }
  var key;
  var aborted;
  var uri = xhr.url = options.uri || options.url;
  var method = xhr.method = options.method || "GET";
  var body = options.body || options.data;
  var headers = xhr.headers = options.headers || {};
  var sync = !!options.sync;
  var isJson = false;
  var timeoutTimer;
  var failureResponse = {
    body: void 0,
    headers: {},
    statusCode: 0,
    method,
    url: uri,
    rawRequest: xhr
  };
  if ("json" in options && options.json !== false) {
    isJson = true;
    headers["accept"] || headers["Accept"] || (headers["Accept"] = "application/json");
    if (method !== "GET" && method !== "HEAD") {
      headers["content-type"] || headers["Content-Type"] || (headers["Content-Type"] = "application/json");
      body = JSON.stringify(options.json === true ? body : options.json);
    }
  }
  xhr.onreadystatechange = readystatechange;
  xhr.onload = loadFunc;
  xhr.onerror = errorFunc;
  xhr.onprogress = function() {
  };
  xhr.onabort = function() {
    aborted = true;
    clearTimeout(options.retryTimeout);
  };
  xhr.ontimeout = errorFunc;
  xhr.open(method, uri, !sync, options.username, options.password);
  if (!sync) {
    xhr.withCredentials = !!options.withCredentials;
  }
  if (!sync && options.timeout > 0) {
    timeoutTimer = setTimeout(function() {
      if (aborted)
        return;
      aborted = true;
      xhr.abort("timeout");
      var e = new Error("XMLHttpRequest timeout");
      e.code = "ETIMEDOUT";
      errorFunc(e);
    }, options.timeout);
  }
  if (xhr.setRequestHeader) {
    for (key in headers) {
      if (headers.hasOwnProperty(key)) {
        xhr.setRequestHeader(key, headers[key]);
      }
    }
  } else if (options.headers && !isEmpty(options.headers)) {
    throw new Error("Headers cannot be set on an XDomainRequest object");
  }
  if ("responseType" in options) {
    xhr.responseType = options.responseType;
  }
  if ("beforeSend" in options && typeof options.beforeSend === "function") {
    options.beforeSend(xhr);
  }
  xhr.send(body || null);
  return xhr;
}
function getXml(xhr) {
  try {
    if (xhr.responseType === "document") {
      return xhr.responseXML;
    }
    var firefoxBugTakenEffect = xhr.responseXML && xhr.responseXML.documentElement.nodeName === "parsererror";
    if (xhr.responseType === "" && !firefoxBugTakenEffect) {
      return xhr.responseXML;
    }
  } catch (e) {
  }
  return null;
}
function noop() {
}
var DEFAULT_LOCATION = "https://example.com";
var resolveUrl = function resolveUrl2(baseUrl, relativeUrl) {
  if (/^[a-z]+:/i.test(relativeUrl)) {
    return relativeUrl;
  }
  if (/^data:/.test(baseUrl)) {
    baseUrl = window_1.location && window_1.location.href || "";
  }
  var protocolLess = /^\/\//.test(baseUrl);
  var removeLocation = !window_1.location && !/\/\//i.test(baseUrl);
  baseUrl = new window_1.URL(baseUrl, window_1.location || DEFAULT_LOCATION);
  var newUrl = new URL(relativeUrl, baseUrl);
  if (removeLocation) {
    return newUrl.href.slice(DEFAULT_LOCATION.length);
  } else if (protocolLess) {
    return newUrl.href.slice(newUrl.protocol.length);
  }
  return newUrl.href;
};
var Stream = /* @__PURE__ */ function() {
  function Stream2() {
    this.listeners = {};
  }
  var _proto = Stream2.prototype;
  _proto.on = function on(type, listener) {
    if (!this.listeners[type]) {
      this.listeners[type] = [];
    }
    this.listeners[type].push(listener);
  };
  _proto.off = function off(type, listener) {
    if (!this.listeners[type]) {
      return false;
    }
    var index = this.listeners[type].indexOf(listener);
    this.listeners[type] = this.listeners[type].slice(0);
    this.listeners[type].splice(index, 1);
    return index > -1;
  };
  _proto.trigger = function trigger(type) {
    var callbacks = this.listeners[type];
    if (!callbacks) {
      return;
    }
    if (arguments.length === 2) {
      var length = callbacks.length;
      for (var i = 0; i < length; ++i) {
        callbacks[i].call(this, arguments[1]);
      }
    } else {
      var args = Array.prototype.slice.call(arguments, 1);
      var _length = callbacks.length;
      for (var _i = 0; _i < _length; ++_i) {
        callbacks[_i].apply(this, args);
      }
    }
  };
  _proto.dispose = function dispose() {
    this.listeners = {};
  };
  _proto.pipe = function pipe(destination) {
    this.on("data", function(data) {
      destination.push(data);
    });
  };
  return Stream2;
}();
var atob = function atob2(s) {
  return window_1.atob ? window_1.atob(s) : Buffer.from(s, "base64").toString("binary");
};
function decodeB64ToUint8Array(b64Text) {
  var decodedString = atob(b64Text);
  var array = new Uint8Array(decodedString.length);
  for (var i = 0; i < decodedString.length; i++) {
    array[i] = decodedString.charCodeAt(i);
  }
  return array;
}
var regexs = {
  mp4: /^(av0?1|avc0?[1234]|vp0?9|flac|opus|mp3|mp4a|mp4v|stpp.ttml.im1t)/,
  webm: /^(vp0?[89]|av0?1|opus|vorbis)/,
  ogg: /^(vp0?[89]|theora|flac|opus|vorbis)/,
  video: /^(av0?1|avc0?[1234]|vp0?[89]|hvc1|hev1|theora|mp4v)/,
  audio: /^(mp4a|flac|vorbis|opus|ac-[34]|ec-3|alac|mp3|speex|aac)/,
  text: /^(stpp.ttml.im1t)/,
  muxerVideo: /^(avc0?1)/,
  muxerAudio: /^(mp4a)/,
  muxerText: /a^/
};
var mediaTypes = ["video", "audio", "text"];
var upperMediaTypes = ["Video", "Audio", "Text"];
var translateLegacyCodec = function translateLegacyCodec2(codec) {
  if (!codec) {
    return codec;
  }
  return codec.replace(/avc1\.(\d+)\.(\d+)/i, function(orig, profile, avcLevel) {
    var profileHex = ("00" + Number(profile).toString(16)).slice(-2);
    var avcLevelHex = ("00" + Number(avcLevel).toString(16)).slice(-2);
    return "avc1." + profileHex + "00" + avcLevelHex;
  });
};
var parseCodecs = function parseCodecs2(codecString) {
  if (codecString === void 0) {
    codecString = "";
  }
  var codecs = codecString.split(",");
  var result = [];
  codecs.forEach(function(codec) {
    codec = codec.trim();
    var codecType;
    mediaTypes.forEach(function(name) {
      var match = regexs[name].exec(codec.toLowerCase());
      if (!match || match.length <= 1) {
        return;
      }
      codecType = name;
      var type = codec.substring(0, match[1].length);
      var details = codec.replace(type, "");
      result.push({
        type,
        details,
        mediaType: name
      });
    });
    if (!codecType) {
      result.push({
        type: codec,
        details: "",
        mediaType: "unknown"
      });
    }
  });
  return result;
};
var codecsFromDefault = function codecsFromDefault2(master, audioGroupId) {
  if (!master.mediaGroups.AUDIO || !audioGroupId) {
    return null;
  }
  var audioGroup = master.mediaGroups.AUDIO[audioGroupId];
  if (!audioGroup) {
    return null;
  }
  for (var name in audioGroup) {
    var audioType = audioGroup[name];
    if (audioType.default && audioType.playlists) {
      return parseCodecs(audioType.playlists[0].attributes.CODECS);
    }
  }
  return null;
};
var isAudioCodec = function isAudioCodec2(codec) {
  if (codec === void 0) {
    codec = "";
  }
  return regexs.audio.test(codec.trim().toLowerCase());
};
var isTextCodec = function isTextCodec2(codec) {
  if (codec === void 0) {
    codec = "";
  }
  return regexs.text.test(codec.trim().toLowerCase());
};
var getMimeForCodec = function getMimeForCodec2(codecString) {
  if (!codecString || typeof codecString !== "string") {
    return;
  }
  var codecs = codecString.toLowerCase().split(",").map(function(c) {
    return translateLegacyCodec(c.trim());
  });
  var type = "video";
  if (codecs.length === 1 && isAudioCodec(codecs[0])) {
    type = "audio";
  } else if (codecs.length === 1 && isTextCodec(codecs[0])) {
    type = "application";
  }
  var container = "mp4";
  if (codecs.every(function(c) {
    return regexs.mp4.test(c);
  })) {
    container = "mp4";
  } else if (codecs.every(function(c) {
    return regexs.webm.test(c);
  })) {
    container = "webm";
  } else if (codecs.every(function(c) {
    return regexs.ogg.test(c);
  })) {
    container = "ogg";
  }
  return type + "/" + container + ';codecs="' + codecString + '"';
};
var browserSupportsCodec = function browserSupportsCodec2(codecString, withMMS) {
  if (codecString === void 0) {
    codecString = "";
  }
  if (withMMS === void 0) {
    withMMS = false;
  }
  return window_1.MediaSource && window_1.MediaSource.isTypeSupported && window_1.MediaSource.isTypeSupported(getMimeForCodec(codecString)) || withMMS && window_1.ManagedMediaSource && window_1.ManagedMediaSource.isTypeSupported && window_1.ManagedMediaSource.isTypeSupported(getMimeForCodec(codecString)) || false;
};
var muxerSupportsCodec = function muxerSupportsCodec2(codecString) {
  if (codecString === void 0) {
    codecString = "";
  }
  return codecString.toLowerCase().split(",").every(function(codec) {
    codec = codec.trim();
    for (var i = 0; i < upperMediaTypes.length; i++) {
      var type = upperMediaTypes[i];
      if (regexs["muxer" + type].test(codec)) {
        return true;
      }
    }
    return false;
  });
};
var DEFAULT_AUDIO_CODEC = "mp4a.40.2";
var DEFAULT_VIDEO_CODEC = "avc1.4d400d";
var MPEGURL_REGEX = /^(audio|video|application)\/(x-|vnd\.apple\.)?mpegurl/i;
var DASH_REGEX = /^application\/dash\+xml/i;
var simpleTypeFromSourceType = function simpleTypeFromSourceType2(type) {
  if (MPEGURL_REGEX.test(type)) {
    return "hls";
  }
  if (DASH_REGEX.test(type)) {
    return "dash";
  }
  if (type === "application/vnd.videojs.vhs+json") {
    return "vhs-json";
  }
  return null;
};
var countBits = function countBits2(x) {
  return x.toString(2).length;
};
var countBytes = function countBytes2(x) {
  return Math.ceil(countBits(x) / 8);
};
var isArrayBufferView = function isArrayBufferView2(obj) {
  if (ArrayBuffer.isView === "function") {
    return ArrayBuffer.isView(obj);
  }
  return obj && obj.buffer instanceof ArrayBuffer;
};
var isTypedArray = function isTypedArray2(obj) {
  return isArrayBufferView(obj);
};
var toUint8 = function toUint82(bytes) {
  if (bytes instanceof Uint8Array) {
    return bytes;
  }
  if (!Array.isArray(bytes) && !isTypedArray(bytes) && !(bytes instanceof ArrayBuffer)) {
    if (typeof bytes !== "number" || typeof bytes === "number" && bytes !== bytes) {
      bytes = 0;
    } else {
      bytes = [bytes];
    }
  }
  return new Uint8Array(bytes && bytes.buffer || bytes, bytes && bytes.byteOffset || 0, bytes && bytes.byteLength || 0);
};
var BigInt = window_1.BigInt || Number;
var BYTE_TABLE = [BigInt("0x1"), BigInt("0x100"), BigInt("0x10000"), BigInt("0x1000000"), BigInt("0x100000000"), BigInt("0x10000000000"), BigInt("0x1000000000000"), BigInt("0x100000000000000"), BigInt("0x10000000000000000")];
(function() {
  var a = new Uint16Array([65484]);
  var b = new Uint8Array(a.buffer, a.byteOffset, a.byteLength);
  if (b[0] === 255) {
    return "big";
  }
  if (b[0] === 204) {
    return "little";
  }
  return "unknown";
})();
var bytesToNumber = function bytesToNumber2(bytes, _temp) {
  var _ref = _temp === void 0 ? {} : _temp, _ref$signed = _ref.signed, signed = _ref$signed === void 0 ? false : _ref$signed, _ref$le = _ref.le, le = _ref$le === void 0 ? false : _ref$le;
  bytes = toUint8(bytes);
  var fn = le ? "reduce" : "reduceRight";
  var obj = bytes[fn] ? bytes[fn] : Array.prototype[fn];
  var number = obj.call(bytes, function(total, byte, i) {
    var exponent = le ? i : Math.abs(i + 1 - bytes.length);
    return total + BigInt(byte) * BYTE_TABLE[exponent];
  }, BigInt(0));
  if (signed) {
    var max = BYTE_TABLE[bytes.length] / BigInt(2) - BigInt(1);
    number = BigInt(number);
    if (number > max) {
      number -= max;
      number -= max;
      number -= BigInt(2);
    }
  }
  return Number(number);
};
var numberToBytes = function numberToBytes2(number, _temp2) {
  var _ref2 = _temp2 === void 0 ? {} : _temp2, _ref2$le = _ref2.le, le = _ref2$le === void 0 ? false : _ref2$le;
  if (typeof number !== "bigint" && typeof number !== "number" || typeof number === "number" && number !== number) {
    number = 0;
  }
  number = BigInt(number);
  var byteCount = countBytes(number);
  var bytes = new Uint8Array(new ArrayBuffer(byteCount));
  for (var i = 0; i < byteCount; i++) {
    var byteIndex = le ? i : Math.abs(i + 1 - bytes.length);
    bytes[byteIndex] = Number(number / BYTE_TABLE[i] & BigInt(255));
    if (number < 0) {
      bytes[byteIndex] = Math.abs(~bytes[byteIndex]);
      bytes[byteIndex] -= i === 0 ? 1 : 2;
    }
  }
  return bytes;
};
var stringToBytes = function stringToBytes2(string, stringIsBytes) {
  if (typeof string !== "string" && string && typeof string.toString === "function") {
    string = string.toString();
  }
  if (typeof string !== "string") {
    return new Uint8Array();
  }
  if (!stringIsBytes) {
    string = unescape(encodeURIComponent(string));
  }
  var view = new Uint8Array(string.length);
  for (var i = 0; i < string.length; i++) {
    view[i] = string.charCodeAt(i);
  }
  return view;
};
var concatTypedArrays = function concatTypedArrays2() {
  for (var _len = arguments.length, buffers = new Array(_len), _key = 0; _key < _len; _key++) {
    buffers[_key] = arguments[_key];
  }
  buffers = buffers.filter(function(b) {
    return b && (b.byteLength || b.length) && typeof b !== "string";
  });
  if (buffers.length <= 1) {
    return toUint8(buffers[0]);
  }
  var totalLen = buffers.reduce(function(total, buf, i) {
    return total + (buf.byteLength || buf.length);
  }, 0);
  var tempBuffer = new Uint8Array(totalLen);
  var offset = 0;
  buffers.forEach(function(buf) {
    buf = toUint8(buf);
    tempBuffer.set(buf, offset);
    offset += buf.byteLength;
  });
  return tempBuffer;
};
var bytesMatch = function bytesMatch2(a, b, _temp3) {
  var _ref3 = _temp3 === void 0 ? {} : _temp3, _ref3$offset = _ref3.offset, offset = _ref3$offset === void 0 ? 0 : _ref3$offset, _ref3$mask = _ref3.mask, mask = _ref3$mask === void 0 ? [] : _ref3$mask;
  a = toUint8(a);
  b = toUint8(b);
  var fn = b.every ? b.every : Array.prototype.every;
  return b.length && a.length - offset >= b.length && fn.call(b, function(bByte, i) {
    var aByte = mask[i] ? mask[i] & a[offset + i] : a[offset + i];
    return bByte === aByte;
  });
};
var forEachMediaGroup = function forEachMediaGroup2(master, groups, callback) {
  groups.forEach(function(mediaType) {
    for (var groupKey in master.mediaGroups[mediaType]) {
      for (var labelKey in master.mediaGroups[mediaType][groupKey]) {
        var mediaProperties = master.mediaGroups[mediaType][groupKey][labelKey];
        callback(mediaProperties, mediaType, groupKey, labelKey);
      }
    }
  });
};
var ID3 = toUint8([73, 68, 51]);
var getId3Size = function getId3Size2(bytes, offset) {
  if (offset === void 0) {
    offset = 0;
  }
  bytes = toUint8(bytes);
  var flags = bytes[offset + 5];
  var returnSize = bytes[offset + 6] << 21 | bytes[offset + 7] << 14 | bytes[offset + 8] << 7 | bytes[offset + 9];
  var footerPresent = (flags & 16) >> 4;
  if (footerPresent) {
    return returnSize + 20;
  }
  return returnSize + 10;
};
var getId3Offset = function getId3Offset2(bytes, offset) {
  if (offset === void 0) {
    offset = 0;
  }
  bytes = toUint8(bytes);
  if (bytes.length - offset < 10 || !bytesMatch(bytes, ID3, {
    offset
  })) {
    return offset;
  }
  offset += getId3Size(bytes, offset);
  return getId3Offset2(bytes, offset);
};
var normalizePath$1 = function normalizePath(path) {
  if (typeof path === "string") {
    return stringToBytes(path);
  }
  if (typeof path === "number") {
    return path;
  }
  return path;
};
var normalizePaths$1 = function normalizePaths(paths) {
  if (!Array.isArray(paths)) {
    return [normalizePath$1(paths)];
  }
  return paths.map(function(p) {
    return normalizePath$1(p);
  });
};
var findBox = function findBox2(bytes, paths, complete) {
  if (complete === void 0) {
    complete = false;
  }
  paths = normalizePaths$1(paths);
  bytes = toUint8(bytes);
  var results = [];
  if (!paths.length) {
    return results;
  }
  var i = 0;
  while (i < bytes.length) {
    var size = (bytes[i] << 24 | bytes[i + 1] << 16 | bytes[i + 2] << 8 | bytes[i + 3]) >>> 0;
    var type = bytes.subarray(i + 4, i + 8);
    if (size === 0) {
      break;
    }
    var end = i + size;
    if (end > bytes.length) {
      if (complete) {
        break;
      }
      end = bytes.length;
    }
    var data = bytes.subarray(i + 8, end);
    if (bytesMatch(type, paths[0])) {
      if (paths.length === 1) {
        results.push(data);
      } else {
        results.push.apply(results, findBox2(data, paths.slice(1), complete));
      }
    }
    i = end;
  }
  return results;
};
var EBML_TAGS = {
  EBML: toUint8([26, 69, 223, 163]),
  DocType: toUint8([66, 130]),
  Segment: toUint8([24, 83, 128, 103]),
  SegmentInfo: toUint8([21, 73, 169, 102]),
  Tracks: toUint8([22, 84, 174, 107]),
  Track: toUint8([174]),
  TrackNumber: toUint8([215]),
  DefaultDuration: toUint8([35, 227, 131]),
  TrackEntry: toUint8([174]),
  TrackType: toUint8([131]),
  FlagDefault: toUint8([136]),
  CodecID: toUint8([134]),
  CodecPrivate: toUint8([99, 162]),
  VideoTrack: toUint8([224]),
  AudioTrack: toUint8([225]),
  Cluster: toUint8([31, 67, 182, 117]),
  Timestamp: toUint8([231]),
  TimestampScale: toUint8([42, 215, 177]),
  BlockGroup: toUint8([160]),
  BlockDuration: toUint8([155]),
  Block: toUint8([161]),
  SimpleBlock: toUint8([163])
};
var LENGTH_TABLE = [128, 64, 32, 16, 8, 4, 2, 1];
var getLength = function getLength2(byte) {
  var len = 1;
  for (var i = 0; i < LENGTH_TABLE.length; i++) {
    if (byte & LENGTH_TABLE[i]) {
      break;
    }
    len++;
  }
  return len;
};
var getvint = function getvint2(bytes, offset, removeLength, signed) {
  if (removeLength === void 0) {
    removeLength = true;
  }
  if (signed === void 0) {
    signed = false;
  }
  var length = getLength(bytes[offset]);
  var valueBytes = bytes.subarray(offset, offset + length);
  if (removeLength) {
    valueBytes = Array.prototype.slice.call(bytes, offset, offset + length);
    valueBytes[0] ^= LENGTH_TABLE[length - 1];
  }
  return {
    length,
    value: bytesToNumber(valueBytes, {
      signed
    }),
    bytes: valueBytes
  };
};
var normalizePath2 = function normalizePath3(path) {
  if (typeof path === "string") {
    return path.match(/.{1,2}/g).map(function(p) {
      return normalizePath3(p);
    });
  }
  if (typeof path === "number") {
    return numberToBytes(path);
  }
  return path;
};
var normalizePaths2 = function normalizePaths3(paths) {
  if (!Array.isArray(paths)) {
    return [normalizePath2(paths)];
  }
  return paths.map(function(p) {
    return normalizePath2(p);
  });
};
var getInfinityDataSize = function getInfinityDataSize2(id, bytes, offset) {
  if (offset >= bytes.length) {
    return bytes.length;
  }
  var innerid = getvint(bytes, offset, false);
  if (bytesMatch(id.bytes, innerid.bytes)) {
    return offset;
  }
  var dataHeader = getvint(bytes, offset + innerid.length);
  return getInfinityDataSize2(id, bytes, offset + dataHeader.length + dataHeader.value + innerid.length);
};
var findEbml = function findEbml2(bytes, paths) {
  paths = normalizePaths2(paths);
  bytes = toUint8(bytes);
  var results = [];
  if (!paths.length) {
    return results;
  }
  var i = 0;
  while (i < bytes.length) {
    var id = getvint(bytes, i, false);
    var dataHeader = getvint(bytes, i + id.length);
    var dataStart = i + id.length + dataHeader.length;
    if (dataHeader.value === 127) {
      dataHeader.value = getInfinityDataSize(id, bytes, dataStart);
      if (dataHeader.value !== bytes.length) {
        dataHeader.value -= dataStart;
      }
    }
    var dataEnd = dataStart + dataHeader.value > bytes.length ? bytes.length : dataStart + dataHeader.value;
    var data = bytes.subarray(dataStart, dataEnd);
    if (bytesMatch(paths[0], id.bytes)) {
      if (paths.length === 1) {
        results.push(data);
      } else {
        results = results.concat(findEbml2(data, paths.slice(1)));
      }
    }
    var totalLength = id.length + dataHeader.length + data.length;
    i += totalLength;
  }
  return results;
};
var NAL_TYPE_ONE = toUint8([0, 0, 0, 1]);
var NAL_TYPE_TWO = toUint8([0, 0, 1]);
var EMULATION_PREVENTION = toUint8([0, 0, 3]);
var discardEmulationPreventionBytes = function discardEmulationPreventionBytes2(bytes) {
  var positions = [];
  var i = 1;
  while (i < bytes.length - 2) {
    if (bytesMatch(bytes.subarray(i, i + 3), EMULATION_PREVENTION)) {
      positions.push(i + 2);
      i++;
    }
    i++;
  }
  if (positions.length === 0) {
    return bytes;
  }
  var newLength = bytes.length - positions.length;
  var newData = new Uint8Array(newLength);
  var sourceIndex = 0;
  for (i = 0; i < newLength; sourceIndex++, i++) {
    if (sourceIndex === positions[0]) {
      sourceIndex++;
      positions.shift();
    }
    newData[i] = bytes[sourceIndex];
  }
  return newData;
};
var findNal = function findNal2(bytes, dataType, types, nalLimit) {
  if (nalLimit === void 0) {
    nalLimit = Infinity;
  }
  bytes = toUint8(bytes);
  types = [].concat(types);
  var i = 0;
  var nalStart;
  var nalsFound = 0;
  while (i < bytes.length && (nalsFound < nalLimit || nalStart)) {
    var nalOffset = void 0;
    if (bytesMatch(bytes.subarray(i), NAL_TYPE_ONE)) {
      nalOffset = 4;
    } else if (bytesMatch(bytes.subarray(i), NAL_TYPE_TWO)) {
      nalOffset = 3;
    }
    if (!nalOffset) {
      i++;
      continue;
    }
    nalsFound++;
    if (nalStart) {
      return discardEmulationPreventionBytes(bytes.subarray(nalStart, i));
    }
    var nalType = void 0;
    if (dataType === "h264") {
      nalType = bytes[i + nalOffset] & 31;
    } else if (dataType === "h265") {
      nalType = bytes[i + nalOffset] >> 1 & 63;
    }
    if (types.indexOf(nalType) !== -1) {
      nalStart = i + nalOffset;
    }
    i += nalOffset + (dataType === "h264" ? 1 : 2);
  }
  return bytes.subarray(0, 0);
};
var findH264Nal = function findH264Nal2(bytes, type, nalLimit) {
  return findNal(bytes, "h264", type, nalLimit);
};
var findH265Nal = function findH265Nal2(bytes, type, nalLimit) {
  return findNal(bytes, "h265", type, nalLimit);
};
var CONSTANTS = {
  "webm": toUint8([119, 101, 98, 109]),
  "matroska": toUint8([109, 97, 116, 114, 111, 115, 107, 97]),
  "flac": toUint8([102, 76, 97, 67]),
  "ogg": toUint8([79, 103, 103, 83]),
  "ac3": toUint8([11, 119]),
  "riff": toUint8([82, 73, 70, 70]),
  "avi": toUint8([65, 86, 73]),
  "wav": toUint8([87, 65, 86, 69]),
  "3gp": toUint8([102, 116, 121, 112, 51, 103]),
  "mp4": toUint8([102, 116, 121, 112]),
  "fmp4": toUint8([115, 116, 121, 112]),
  "mov": toUint8([102, 116, 121, 112, 113, 116]),
  "moov": toUint8([109, 111, 111, 118]),
  "moof": toUint8([109, 111, 111, 102])
};
var _isLikely = {
  aac: function aac(bytes) {
    var offset = getId3Offset(bytes);
    return bytesMatch(bytes, [255, 16], {
      offset,
      mask: [255, 22]
    });
  },
  mp3: function mp3(bytes) {
    var offset = getId3Offset(bytes);
    return bytesMatch(bytes, [255, 2], {
      offset,
      mask: [255, 6]
    });
  },
  webm: function webm(bytes) {
    var docType = findEbml(bytes, [EBML_TAGS.EBML, EBML_TAGS.DocType])[0];
    return bytesMatch(docType, CONSTANTS.webm);
  },
  mkv: function mkv(bytes) {
    var docType = findEbml(bytes, [EBML_TAGS.EBML, EBML_TAGS.DocType])[0];
    return bytesMatch(docType, CONSTANTS.matroska);
  },
  mp4: function mp4(bytes) {
    if (_isLikely["3gp"](bytes) || _isLikely.mov(bytes)) {
      return false;
    }
    if (bytesMatch(bytes, CONSTANTS.mp4, {
      offset: 4
    }) || bytesMatch(bytes, CONSTANTS.fmp4, {
      offset: 4
    })) {
      return true;
    }
    if (bytesMatch(bytes, CONSTANTS.moof, {
      offset: 4
    }) || bytesMatch(bytes, CONSTANTS.moov, {
      offset: 4
    })) {
      return true;
    }
  },
  mov: function mov(bytes) {
    return bytesMatch(bytes, CONSTANTS.mov, {
      offset: 4
    });
  },
  "3gp": function gp(bytes) {
    return bytesMatch(bytes, CONSTANTS["3gp"], {
      offset: 4
    });
  },
  ac3: function ac3(bytes) {
    var offset = getId3Offset(bytes);
    return bytesMatch(bytes, CONSTANTS.ac3, {
      offset
    });
  },
  ts: function ts(bytes) {
    if (bytes.length < 189 && bytes.length >= 1) {
      return bytes[0] === 71;
    }
    var i = 0;
    while (i + 188 < bytes.length && i < 188) {
      if (bytes[i] === 71 && bytes[i + 188] === 71) {
        return true;
      }
      i += 1;
    }
    return false;
  },
  flac: function flac(bytes) {
    var offset = getId3Offset(bytes);
    return bytesMatch(bytes, CONSTANTS.flac, {
      offset
    });
  },
  ogg: function ogg(bytes) {
    return bytesMatch(bytes, CONSTANTS.ogg);
  },
  avi: function avi(bytes) {
    return bytesMatch(bytes, CONSTANTS.riff) && bytesMatch(bytes, CONSTANTS.avi, {
      offset: 8
    });
  },
  wav: function wav(bytes) {
    return bytesMatch(bytes, CONSTANTS.riff) && bytesMatch(bytes, CONSTANTS.wav, {
      offset: 8
    });
  },
  "h264": function h264(bytes) {
    return findH264Nal(bytes, 7, 3).length;
  },
  "h265": function h265(bytes) {
    return findH265Nal(bytes, [32, 33], 3).length;
  }
};
var isLikelyTypes = Object.keys(_isLikely).filter(function(t) {
  return t !== "ts" && t !== "h264" && t !== "h265";
}).concat(["ts", "h264", "h265"]);
isLikelyTypes.forEach(function(type) {
  var isLikelyFn = _isLikely[type];
  _isLikely[type] = function(bytes) {
    return isLikelyFn(toUint8(bytes));
  };
});
var isLikely = _isLikely;
var detectContainerForBytes = function detectContainerForBytes2(bytes) {
  bytes = toUint8(bytes);
  for (var i = 0; i < isLikelyTypes.length; i++) {
    var type = isLikelyTypes[i];
    if (isLikely[type](bytes)) {
      return type;
    }
  }
  return "";
};
var isLikelyFmp4MediaSegment = function isLikelyFmp4MediaSegment2(bytes) {
  return findBox(bytes, ["moof"]).length > 0;
};
export {
  DEFAULT_VIDEO_CODEC as D,
  Stream as S,
  DEFAULT_AUDIO_CODEC as a,
  browserSupportsCodec as b,
  codecsFromDefault as c,
  decodeB64ToUint8Array as d,
  isArrayBufferView as e,
  forEachMediaGroup as f,
  getMimeForCodec as g,
  concatTypedArrays as h,
  isAudioCodec as i,
  stringToBytes as j,
  getId3Offset as k,
  lib as l,
  muxerSupportsCodec as m,
  detectContainerForBytes as n,
  toUint8 as o,
  parseCodecs as p,
  isLikelyFmp4MediaSegment as q,
  resolveUrl as r,
  simpleTypeFromSourceType as s,
  translateLegacyCodec as t
};
