import { B as Browser, F as Folder, I as Icon } from "./index.c87a5b08.js";
import { e as defineComponent, j as resolveComponent, $ as unref, k as openBlock, l as createBlock, m as withCtx, x as renderSlot, v as createVNode, y as createTextVNode, s as createCommentVNode } from "./@vue.10d2ded6.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "EntityOperator",
  props: {
    entity: {},
    permissions: { default: () => ["edit", "remove", "rename"] }
  },
  setup(__props) {
    const props = __props;
    const instance = props.entity.type === "browser" ? Browser.from(props.entity.uid) : Folder.from(props.entity.uid);
    function hasPermissions(p) {
      return props.permissions.some((per) => per === p);
    }
    return (_ctx, _cache) => {
      const _component_a_doption = resolveComponent("a-doption");
      const _component_a_dropdown = resolveComponent("a-dropdown");
      return unref(instance) ? (openBlock(), createBlock(_component_a_dropdown, {
        key: 0,
        trigger: ["hover"]
      }, {
        content: withCtx(() => [
          renderSlot(_ctx.$slots, "dropdown"),
          hasPermissions("edit") ? (openBlock(), createBlock(_component_a_doption, {
            key: 0,
            onClick: _cache[0] || (_cache[0] = ($event) => {
              var _a;
              return (_a = unref(instance)) == null ? void 0 : _a.select();
            })
          }, {
            default: withCtx(() => [
              createVNode(Icon, { type: "edit" }, {
                default: withCtx(() => [..._cache[4] || (_cache[4] = [
                  createTextVNode("\u7F16\u8F91", -1)
                ])]),
                _: 1
              })
            ]),
            _: 1
          })) : createCommentVNode("", true),
          hasPermissions("rename") ? (openBlock(), createBlock(_component_a_doption, {
            key: 1,
            onClick: _cache[1] || (_cache[1] = ($event) => unref(instance) && (unref(instance).renaming = true))
          }, {
            default: withCtx(() => [
              createVNode(Icon, { type: "text_format" }, {
                default: withCtx(() => [..._cache[5] || (_cache[5] = [
                  createTextVNode("\u91CD\u547D\u540D", -1)
                ])]),
                _: 1
              })
            ]),
            _: 1
          })) : createCommentVNode("", true),
          hasPermissions("remove") ? (openBlock(), createBlock(_component_a_doption, {
            key: 2,
            onClick: _cache[2] || (_cache[2] = ($event) => {
              var _a;
              return (_a = unref(instance)) == null ? void 0 : _a.remove();
            })
          }, {
            default: withCtx(() => [
              createVNode(Icon, {
                style: { "color": "red" },
                type: "delete"
              }, {
                default: withCtx(() => [..._cache[6] || (_cache[6] = [
                  createTextVNode(" \u5220\u9664 ", -1)
                ])]),
                _: 1
              })
            ]),
            _: 1
          })) : createCommentVNode("", true),
          hasPermissions("location") ? (openBlock(), createBlock(_component_a_doption, {
            key: 3,
            onClick: _cache[3] || (_cache[3] = ($event) => {
              var _a;
              return (_a = unref(instance)) == null ? void 0 : _a.location();
            })
          }, {
            default: withCtx(() => [
              createVNode(Icon, { type: "location_on" }, {
                default: withCtx(() => [..._cache[7] || (_cache[7] = [
                  createTextVNode(" \u8DF3\u8F6C\u5230\u6587\u4EF6\u6240\u5728\u4F4D\u7F6E ", -1)
                ])]),
                _: 1
              })
            ]),
            _: 1
          })) : createCommentVNode("", true)
        ]),
        default: withCtx(() => [
          createVNode(Icon, {
            type: "menu",
            style: { "cursor": "pointer" },
            class: "fs-6"
          })
        ]),
        _: 3
      })) : createCommentVNode("", true);
    };
  }
});
export {
  _sfc_main as _
};
