import { e as defineComponent, r as ref, a as reactive, w as watch, c as computed, a3 as resolveDirective, M as withDirectives, k as openBlock, p as createElementBlock, n as createBaseVNode, q as normalizeStyle, F as Fragment, P as renderList, $ as unref, a4 as vModelText, y as createTextVNode, z as toDisplayString, s as createCommentVNode, u as normalizeClass, a5 as pushScopeId, a6 as popScopeId } from "./@vue.10d2ded6.js";
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const isClient = typeof window !== "undefined";
const nodeList = [];
const ctx = "@@clickContext";
let startClick;
let seed = 0;
if (isClient) {
  document.addEventListener("mousedown", (e) => startClick = e);
  document.addEventListener("mouseup", (e) => {
    nodeList.forEach((node) => node[ctx].documentHandler(e, startClick));
  });
}
function createDocumentHandler(el, binding, vnode) {
  return function(mouseup = {}, mousedown = {}) {
    if (!vnode || !mouseup.target || !mousedown.target || el.contains(mouseup.target) || el.contains(mousedown.target) || el === mouseup.target)
      return;
    if (binding.expression && el[ctx].methodName && vnode.context[el[ctx].methodName]) {
      vnode.context[el[ctx].methodName]();
    } else {
      el[ctx].bindingFn && el[ctx].bindingFn();
    }
  };
}
var clickoutside = {
  mounted(el, binding, vnode) {
    nodeList.push(el);
    const id = seed++;
    el[ctx] = {
      id,
      documentHandler: createDocumentHandler(el, binding, vnode),
      methodName: binding.expression,
      bindingFn: binding.value
    };
  },
  updated(el, binding, vnode) {
    el[ctx].documentHandler = createDocumentHandler(el, binding, vnode);
    el[ctx].methodName = binding.expression;
    el[ctx].bindingFn = binding.value;
  },
  unmounted(el) {
    let len = nodeList.length;
    for (let i = 0; i < len; i++) {
      if (nodeList[i][ctx].id === el[ctx].id) {
        nodeList.splice(i, 1);
        break;
      }
    }
    delete el[ctx];
  }
};
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _withScopeId = (n) => (pushScopeId("data-v-87d63fa8"), n = n(), popScopeId(), n);
const _hoisted_1 = { class: "panel-header" };
const _hoisted_2 = { class: "color-view-bg" };
const _hoisted_3 = { class: "panel-main" };
const _hoisted_4 = /* @__PURE__ */ _withScopeId(() => /* @__PURE__ */ createBaseVNode("h3", null, "\u4E3B\u9898\u989C\u8272", -1));
const _hoisted_5 = { class: "theme-color" };
const _hoisted_6 = ["onMouseover", "onClick"];
const _hoisted_7 = { class: "standard-color" };
const _hoisted_8 = ["onMouseover", "onClick"];
const _hoisted_9 = /* @__PURE__ */ _withScopeId(() => /* @__PURE__ */ createBaseVNode("h3", null, "\u6807\u51C6\u989C\u8272", -1));
const _hoisted_10 = { class: "theme-color" };
const _hoisted_11 = ["onMouseover", "onClick"];
const _hoisted_12 = /* @__PURE__ */ _withScopeId(() => /* @__PURE__ */ createBaseVNode("h3", null, "\u900F\u660E\u5EA6", -1));
const __default__ = defineComponent({
  name: "colorPicker",
  directives: { clickoutside }
});
const _sfc_main = /* @__PURE__ */ defineComponent(__spreadProps(__spreadValues({}, __default__), {
  props: {
    hex: {
      type: [String, void 0]
    },
    modelValue: {
      type: String
    },
    rgba: {
      type: String
    },
    defaultColor: {
      type: String,
      default: "#000000"
    },
    btnStyle: {
      type: [Object]
    },
    opacity: {
      type: [Number, String],
      default() {
        return 1;
      }
    },
    showOpacity: {
      type: Boolean,
      default() {
        return true;
      }
    },
    standardColor: {
      type: Array,
      default() {
        return [
          "#c21401",
          "#ff1e02",
          "#ffc12a",
          "#ffff3a",
          "#90cf5b",
          "#00af57",
          "#00afee",
          "#0071be",
          "#00215f",
          "#72349d"
        ];
      }
    },
    themeColor: {
      type: Array,
      default() {
        return [
          "#000000",
          "#ffffff",
          "#eeece1",
          "#1e497b",
          "#4e81bb",
          "#e2534d",
          "#9aba60",
          "#8165a0",
          "#47acc5",
          "#f9974c"
        ];
      }
    }
  },
  emits: ["input", "change", "finish", "update:hex", "update:rgba", "close", "update:modelValue"],
  setup(__props, { emit: emits }) {
    const props = __props;
    const colorPanelVisible = ref(false);
    const hoveColor = ref("");
    const html5ColorRef = ref(null);
    const opacity = ref(Number(props.opacity));
    const bColor = ref(props.standardColor);
    const colorReactive = reactive({
      visible: false,
      html5Color: props.hex,
      tColor: props.themeColor,
      colorConfig: [
        ["#7f7f7f", "#f2f2f2"],
        ["#0d0d0d", "#808080"],
        ["#1c1a10", "#ddd8c3"],
        ["#0e243d", "#c6d9f0"],
        ["#233f5e", "#dae5f0"],
        ["#632623", "#f2dbdb"],
        ["#4d602c", "#eaf1de"],
        ["#3f3150", "#e6e0ec"],
        ["#1e5867", "#d9eef3"],
        ["#99490f", "#fee9da"]
      ]
    });
    const showPanelColor = ref(hexToRgbaStr(props.hex !== "" && props.hex ? props.hex : props.defaultColor, opacity.value));
    if (props.rgba && props.rgba.length) {
      showPanelColor.value = props.rgba;
    }
    watch(hoveColor, () => {
      if (hoveColor.value) {
        showPanelColor.value = hoveColor.value;
      } else {
        showPanelColor.value = showColor.value;
      }
    });
    watch(() => props.hex, (newValue, _) => {
      if ((/^#?[0-9a-fA-F]{3}$/.test(newValue) || /^#?[0-9a-fA-F]{4}$/.test(newValue) || /^#?[0-9a-fA-F]{5}$/.test(newValue) || /^#?[0-9a-fA-F]{6}$/.test(newValue) || /^#?[0-9a-fA-F]{8}$/.test(newValue)) && newValue.trim().length <= 9 && newValue.trim().length != 6 && newValue.trim().length != 8) {
        showColor.value = hexToRgbaStr(newValue, 1);
        showPanelColor.value = hexToRgbaStr(newValue, 1);
      }
      if (newValue.length === 0 || newValue == "") {
        showColor.value = "";
        showPanelColor.value = "";
      }
    });
    function checkColorRgba(bgVal) {
      let type;
      if (/^rgb\(/.test(bgVal)) {
        type = "^[rR][gG][Bb][(]([\\s]*(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?)[\\s]*,){2}[\\s]*(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)[\\s]*[)]{1}$";
      } else if (/^rgba\(/.test(bgVal)) {
        type = "^[rR][gG][Bb][Aa][(]([\\s]*(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?)[\\s]*,){3}[\\s]*(1|1.0|0|0.[0-9])[\\s]*[)]{1}$";
      }
      const re = new RegExp(type);
      if (bgVal.match(re)) {
        return true;
      }
      return false;
    }
    watch(() => props.rgba, (newValue, _) => {
      if (checkColorRgba(newValue)) {
        showPanelColor.value = newValue;
        showColor.value = newValue;
      }
      if (newValue.length === 0 || newValue == "") {
        showColor.value = "";
        showPanelColor.value = "";
      }
    });
    const colorValue = ref(props.hex !== "" && props.hex ? props.hex : props.defaultColor);
    const showColor = ref(hexToRgbaStr(props.hex !== "" && props.hex ? props.hex : props.defaultColor, opacity.value));
    if (props.rgba && props.rgba.length) {
      showColor.value = props.rgba;
    }
    const colorPanel = computed(() => {
      const colorArr = [];
      for (let color of colorReactive.colorConfig) {
        colorArr.push(gradientValue(color[1], color[0], 5));
      }
      return colorArr;
    });
    const parseColor = (hexStr) => {
      if (hexStr.length === 4) {
        hexStr = "#" + hexStr[1] + hexStr[1] + hexStr[2] + hexStr[2] + hexStr[3] + hexStr[3];
      } else {
        return hexStr;
      }
    };
    const hexToRgb = (hex) => {
      hex = parseColor(hex);
      const rgb = [];
      for (let i = 1; i < 7; i += 2) {
        rgb.push(parseInt("0x" + hex.slice(i, i + 2)));
      }
      return rgb;
    };
    function hex2rgbaObj(s) {
      if (/^#?[0-9a-fA-F]{3}$/.test(s)) {
        let b = s.substring(s.length - 1, s.length);
        let g = s.substring(s.length - 2, s.length - 1);
        let r = s.substring(s.length - 3, s.length - 2);
        return hex2rgbaObj(`${r + r}${g + g}${b + b}`);
      }
      if (/^#?[0-9a-fA-F]{4}$/.test(s)) {
        let a = s.substring(s.length - 1, s.length);
        let b = s.substring(s.length - 2, s.length - 1);
        let g = s.substring(s.length - 3, s.length - 2);
        let r = s.substring(s.length - 4, s.length - 3);
        return hex2rgbaObj(`${r + r}${g + g}${b + b}${a + a}`);
      }
      if (/^#?[0-9a-fA-F]{6}$/.test(s)) {
        let b = parseInt("0x" + s.substring(s.length - 2, s.length));
        let g = parseInt("0x" + s.substring(s.length - 4, s.length - 2));
        let r = parseInt("0x" + s.substring(s.length - 6, s.length - 4));
        return { r, g, b, a: 1 };
      }
      if (/^#?[0-9a-fA-F]{8}$/.test(s)) {
        let a = parseInt("0x" + s.substring(s.length - 2, s.length));
        a = a / 255;
        let b = parseInt("0x" + s.substring(s.length - 4, s.length - 2));
        let g = parseInt("0x" + s.substring(s.length - 6, s.length - 4));
        let r = parseInt("0x" + s.substring(s.length - 8, s.length - 6));
        return { r, g, b, a };
      }
    }
    function hexToRgbaStr(hex, opacity2) {
      const { r, g, b, a } = hex2rgbaObj(hex);
      let alpha = a;
      if (a === 1 && opacity2 === 1) {
        alpha = 1;
      } else if (a !== 1 && opacity2 === 1) {
        alpha = a;
      } else if (a === 1 && opacity2 !== 1) {
        alpha = opacity2;
      }
      return `rgba(${r},${g},${b},${alpha})`;
    }
    const updataValue = (hex) => {
      colorValue.value = hex;
      showColor.value = hexToRgbaStr(hex, opacity.value);
      showPanelColor.value = hexToRgbaStr(hex, opacity.value);
      emits("input", hex);
      emits("update:hex", hex);
      emits("update:rgba", hexToRgbaStr(hex, opacity.value));
      emits("change", { hex, rgba: hexToRgbaStr(hex, opacity.value) });
    };
    const rgbToHex = (r, g, b) => {
      const hex = (r << 16 | g << 8 | b).toString(16);
      return "#" + new Array(Math.abs(hex.length - 7)).join("0") + hex;
    };
    const openPanel = () => {
      colorPanelVisible.value = !colorPanelVisible.value;
    };
    const gradientValue = (startColor, endColor, step) => {
      const sColor = hexToRgb(startColor);
      const eColor = hexToRgb(endColor);
      const rStep = (eColor[0] - sColor[0]) / step;
      const gStep = (eColor[1] - sColor[1]) / step;
      const bStep = (eColor[2] - sColor[2]) / step;
      const gradientColorArr = [];
      for (let i = 0; i < step; i++) {
        gradientColorArr.push(rgbToHex(parseInt(rStep * i + sColor[0]), parseInt(gStep * i + sColor[1]), parseInt(bStep * i + sColor[2])));
      }
      return gradientColorArr;
    };
    const closePanel = () => {
      colorPanelVisible.value = false;
      emits("close", { hex: colorValue.value, rgba: hexToRgbaStr(colorValue.value, opacity.value) });
    };
    const hoverChangeColor = (color) => {
      hoveColor.value = hexToRgbaStr(color, opacity.value);
    };
    const triggerHtml5Color = () => {
      html5ColorRef.value.click();
    };
    const handleDefaultColor = () => {
      updataValue(props.defaultColor);
    };
    const changeH5Color = (e) => {
      updataValue(html5ColorRef.value.value);
    };
    const opacityChange = () => {
      updataValue(colorValue.value);
    };
    const cllickFinsh = () => {
      colorPanelVisible.value = false;
      emits("finish", { hex: colorValue.value, rgba: hexToRgbaStr(colorValue.value, opacity.value) });
    };
    return (_ctx, _cache) => {
      const _directive_clickoutside = resolveDirective("clickoutside");
      return withDirectives((openBlock(), createElementBlock("div", {
        class: "zs-color-picker",
        ref: "colorPicker",
        onClick: _cache[7] || (_cache[7] = (e) => e.stopPropagation())
      }, [
        createBaseVNode("div", {
          class: "zs-color-picker-btn",
          style: normalizeStyle(__spreadValues({}, __props.btnStyle)),
          onClick: openPanel
        }, [
          createBaseVNode("div", {
            class: "zs-color-picker-btn-color",
            style: normalizeStyle({ backgroundColor: showColor.value })
          }, null, 4)
        ], 4),
        createBaseVNode("div", {
          class: normalizeClass([
            "zs-color-picker-panel",
            colorPanelVisible.value ? "zs-color-picker-panel__visible" : ""
          ])
        }, [
          createBaseVNode("div", _hoisted_1, [
            createBaseVNode("div", _hoisted_2, [
              createBaseVNode("div", {
                class: "color-view",
                style: normalizeStyle(`background-color: ${showPanelColor.value}`)
              }, null, 4)
            ]),
            createBaseVNode("div", {
              class: "default-color",
              onMouseover: _cache[0] || (_cache[0] = ($event) => hoveColor.value = __props.defaultColor),
              onMouseout: _cache[1] || (_cache[1] = ($event) => hoveColor.value = null),
              onClick: handleDefaultColor
            }, "\u9ED8\u8BA4\u989C\u8272", 32)
          ]),
          createBaseVNode("div", _hoisted_3, [
            _hoisted_4,
            createBaseVNode("ul", _hoisted_5, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(unref(colorReactive).tColor, (color, index) => {
                return openBlock(), createElementBlock("li", {
                  key: index,
                  style: normalizeStyle({ backgroundColor: color }),
                  onMouseover: ($event) => hoverChangeColor(color),
                  onMouseout: _cache[2] || (_cache[2] = ($event) => hoveColor.value = null),
                  onClick: ($event) => updataValue(color)
                }, null, 44, _hoisted_6);
              }), 128))
            ]),
            createBaseVNode("ul", _hoisted_7, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(unref(colorPanel), (item, index) => {
                return openBlock(), createElementBlock("li", { key: index }, [
                  createBaseVNode("ul", null, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(item, (color, cindex) => {
                      return openBlock(), createElementBlock("li", {
                        key: cindex,
                        style: normalizeStyle({ backgroundColor: color }),
                        onMouseover: ($event) => hoverChangeColor(color),
                        onMouseout: _cache[3] || (_cache[3] = ($event) => hoveColor.value = null),
                        onClick: ($event) => updataValue(color)
                      }, null, 44, _hoisted_8);
                    }), 128))
                  ])
                ]);
              }), 128))
            ]),
            _hoisted_9,
            createBaseVNode("ul", _hoisted_10, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(bColor.value, (color, index) => {
                return openBlock(), createElementBlock("li", {
                  key: index,
                  style: normalizeStyle({ backgroundColor: color }),
                  onMouseover: ($event) => hoverChangeColor(color),
                  onMouseout: _cache[4] || (_cache[4] = ($event) => hoveColor.value = null),
                  onClick: ($event) => updataValue(color)
                }, null, 44, _hoisted_11);
              }), 128))
            ]),
            __props.showOpacity ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              _hoisted_12,
              withDirectives(createBaseVNode("input", {
                type: "range",
                max: "1",
                min: "0",
                step: "0.0001",
                "onUpdate:modelValue": _cache[5] || (_cache[5] = ($event) => opacity.value = $event),
                class: "gradient",
                onInput: opacityChange
              }, null, 544), [
                [vModelText, opacity.value]
              ]),
              createTextVNode(" " + toDisplayString(opacity.value), 1)
            ], 64)) : createCommentVNode("", true),
            createBaseVNode("div", { class: "bottom-btn" }, [
              createBaseVNode("h3", {
                onClick: triggerHtml5Color,
                style: { "cursor": "pointer" }
              }, "\u66F4\u591A\u989C\u8272"),
              createBaseVNode("div", {
                class: "finsh",
                onClick: cllickFinsh
              }, "\u5B8C\u6210")
            ]),
            withDirectives(createBaseVNode("input", {
              class: "color-input",
              type: "color",
              ref_key: "html5ColorRef",
              ref: html5ColorRef,
              "onUpdate:modelValue": _cache[6] || (_cache[6] = ($event) => unref(colorReactive).html5Color = $event),
              onChange: changeH5Color,
              onInput: changeH5Color
            }, null, 544), [
              [vModelText, unref(colorReactive).html5Color]
            ])
          ])
        ], 2)
      ])), [
        [_directive_clickoutside, closePanel]
      ]);
    };
  }
}));
var ColorPicker = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-87d63fa8"]]);
ColorPicker.install = (Vue) => Vue.component(ColorPicker.name, ColorPicker);
if (typeof window !== "undefined" && window.Vue) {
  install(window.Vue);
}
const style = "";
export {
  ColorPicker as C
};
