import { c as commonjsGlobal } from "./@babel.dac5e1c0.js";
import { e as events } from "./events.7cc16d47.js";
import { d as debounce_1 } from "./lodash.4ddd9dd3.js";
var lib = {};
var start = {};
var customWindow = {};
var interfaces = {};
var common$1 = {};
var __importDefault$1 = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
  return mod && mod.__esModule ? mod : { "default": mod };
};
Object.defineProperty(common$1, "__esModule", { value: true });
common$1.CommonEventEmitter = void 0;
const events_1$1 = __importDefault$1(events.exports);
class CommonEventEmitter extends events_1$1.default {
  on(eventName, listener) {
    return super.on(eventName.toString(), listener);
  }
  once(eventName, listener) {
    return super.once(eventName.toString(), listener);
  }
  emit(eventName, ...args) {
    return super.emit(eventName.toString(), ...args);
  }
  off(eventName, listener) {
    return super.off(eventName.toString(), listener);
  }
}
common$1.CommonEventEmitter = CommonEventEmitter;
var config$1 = {};
Object.defineProperty(config$1, "__esModule", { value: true });
var cors = {};
var utils = {};
var common = {};
var store = {};
var store_provider = {};
var _const = {};
Object.defineProperty(_const, "__esModule", { value: true });
_const.$const = void 0;
_const.$const = {
  TAB_UID: "_uid_",
  TAB_URLS: "_urls_",
  TAB_CURRENT_PANEL_NAME: "_current_panel_name_"
};
var __awaiter$1 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
Object.defineProperty(store_provider, "__esModule", { value: true });
store_provider.GMStoreProvider = store_provider.MemoryStoreProvider = store_provider.LocalStoreChangeEvent = void 0;
const const_1 = _const;
class LocalStoreChangeEvent extends Event {
  constructor() {
    super(...arguments);
    this.key = "";
  }
}
store_provider.LocalStoreChangeEvent = LocalStoreChangeEvent;
class MemoryStoreProvider {
  get(key, defaultValue) {
    var _a;
    return (_a = Reflect.get(MemoryStoreProvider._source.store, key)) !== null && _a !== void 0 ? _a : defaultValue;
  }
  set(key, value) {
    var _a;
    const pre = Reflect.get(MemoryStoreProvider._source.store, key);
    Reflect.set(MemoryStoreProvider._source.store, key, value);
    (_a = MemoryStoreProvider.storeListeners.get(key)) === null || _a === void 0 ? void 0 : _a.forEach((lis) => lis(value, pre));
  }
  delete(key) {
    Reflect.deleteProperty(MemoryStoreProvider._source.store, key);
  }
  list() {
    return Object.keys(MemoryStoreProvider._source.store);
  }
  getTab(key) {
    return __awaiter$1(this, void 0, void 0, function* () {
      return Reflect.get(MemoryStoreProvider._source.tab, key);
    });
  }
  setTab(key, value) {
    var _a;
    return __awaiter$1(this, void 0, void 0, function* () {
      Reflect.set(MemoryStoreProvider._source.tab, key, value);
      (_a = MemoryStoreProvider.tabListeners.get(key)) === null || _a === void 0 ? void 0 : _a.forEach((lis) => lis(value, this.getTab(key)));
    });
  }
  addChangeListener(key, listener) {
    const listeners = MemoryStoreProvider.storeListeners.get(key) || [];
    listeners.push(listener);
    MemoryStoreProvider.storeListeners.set(key, listeners);
  }
  removeChangeListener(listener) {
    MemoryStoreProvider.tabListeners.forEach((lis, key) => {
      const index = lis.findIndex((l) => l === listener);
      if (index !== -1) {
        lis.splice(index, 1);
        MemoryStoreProvider.tabListeners.set(key, lis);
      }
    });
  }
  addTabChangeListener(key, listener) {
    const listeners = MemoryStoreProvider.tabListeners.get(key) || [];
    listeners.push(listener);
    MemoryStoreProvider.tabListeners.set(key, listeners);
  }
  removeTabChangeListener(key, listener) {
    const listeners = MemoryStoreProvider.tabListeners.get(key) || [];
    const index = listeners.findIndex((l) => l === listener);
    if (index !== -1) {
      listeners.splice(index, 1);
      MemoryStoreProvider.tabListeners.set(key, listeners);
    }
  }
}
MemoryStoreProvider._source = { store: {}, tab: {} };
MemoryStoreProvider.storeListeners = /* @__PURE__ */ new Map();
MemoryStoreProvider.tabListeners = /* @__PURE__ */ new Map();
store_provider.MemoryStoreProvider = MemoryStoreProvider;
class GMStoreProvider {
  constructor() {
    if (self === top && typeof globalThis.GM_listValues !== "undefined") {
      for (const val of GM_listValues()) {
        if (val.startsWith("_tab_change_")) {
          GM_deleteValue(val);
        }
      }
    }
  }
  getTabChangeHandleKey(tabUid, key) {
    return `_tab_change_${tabUid}_${key}`;
  }
  get(key, defaultValue) {
    return GM_getValue(key, defaultValue);
  }
  set(key, value) {
    GM_setValue(key, value);
  }
  delete(key) {
    GM_deleteValue(key);
  }
  list() {
    return GM_listValues();
  }
  getTab(key) {
    return new Promise((resolve, reject) => {
      GM_getTab((tab = {}) => resolve(Reflect.get(tab, key)));
    });
  }
  setTab(key, value) {
    return new Promise((resolve, reject) => {
      GM_getTab((tab = {}) => {
        Reflect.set(tab, key, value);
        GM_saveTab(tab);
        this.set(this.getTabChangeHandleKey(Reflect.get(tab, const_1.$const.TAB_UID), key), value);
        resolve();
      });
    });
  }
  addChangeListener(key, listener) {
    return GM_addValueChangeListener(key, (_, pre, curr, remote) => {
      listener(pre, curr, remote);
    });
  }
  removeChangeListener(listenerId) {
    if (typeof listenerId === "number") {
      GM_removeValueChangeListener(listenerId);
    }
  }
  addTabChangeListener(key, listener) {
    return __awaiter$1(this, void 0, void 0, function* () {
      const uid = yield this.getTab(const_1.$const.TAB_UID);
      return GM_addValueChangeListener(this.getTabChangeHandleKey(uid, key), (_, pre, curr) => {
        listener(curr, pre);
      });
    });
  }
  removeTabChangeListener(key, listener) {
    return this.removeChangeListener(listener);
  }
}
store_provider.GMStoreProvider = GMStoreProvider;
(function(exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.$store = exports.MemoryStoreProvider = exports.GMStoreProvider = void 0;
  const store_provider_1 = store_provider;
  var store_provider_2 = store_provider;
  Object.defineProperty(exports, "GMStoreProvider", { enumerable: true, get: function() {
    return store_provider_2.GMStoreProvider;
  } });
  Object.defineProperty(exports, "MemoryStoreProvider", { enumerable: true, get: function() {
    return store_provider_2.MemoryStoreProvider;
  } });
  exports.$store = typeof globalThis.unsafeWindow === "undefined" ? new store_provider_1.MemoryStoreProvider() : new store_provider_1.GMStoreProvider();
})(store);
(function(exports) {
  var __awaiter2 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve) {
        resolve(value);
      });
    }
    return new (P || (P = Promise))(function(resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var __rest = commonjsGlobal && commonjsGlobal.__rest || function(s, e) {
    var t = {};
    for (var p in s)
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
          t[p[i]] = s[p[i]];
      }
    return t;
  };
  var __importDefault2 = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { "default": mod };
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.resolveCustomElementName = exports.$ = void 0;
  const debounce_1$1 = __importDefault2(debounce_1);
  const store_12 = store;
  exports.$ = {
    createConfigProxy(script2) {
      var _a, _b;
      const proxy = new Proxy(script2.cfg, {
        set(target, propertyKey, value) {
          const key = exports.$.namespaceKey(script2.namespace, propertyKey);
          store_12.$store.set(key, value);
          return Reflect.set(target, propertyKey, value);
        },
        get(target, propertyKey) {
          const value = store_12.$store.get(exports.$.namespaceKey(script2.namespace, propertyKey));
          Reflect.set(target, propertyKey, value);
          return value;
        }
      });
      for (const key in script2.configs) {
        if (Object.prototype.hasOwnProperty.call(script2.configs, key)) {
          const element = Reflect.get(script2.configs, key);
          Reflect.set(proxy, key, store_12.$store.get(exports.$.namespaceKey(script2.namespace, key), element.defaultValue));
        }
      }
      if (script2.namespace) {
        proxy.notes = (_b = (_a = script2.configs) === null || _a === void 0 ? void 0 : _a.notes) === null || _b === void 0 ? void 0 : _b.defaultValue;
      }
      return proxy;
    },
    getAllRawConfigs(scripts) {
      const object = {};
      for (const script2 of scripts) {
        for (const key in script2.configs) {
          if (Object.prototype.hasOwnProperty.call(script2.configs, key)) {
            const _a = script2.configs[key], element = __rest(_a, ["label"]);
            Reflect.set(object, exports.$.namespaceKey(script2.namespace, key), Object.assign({ label: exports.$.namespaceKey(script2.namespace, key) }, element));
          }
        }
      }
      return object;
    },
    getMatchedScripts(projects, urls) {
      const scripts = [];
      for (const project2 of projects) {
        for (const key in project2.scripts) {
          if (Object.prototype.hasOwnProperty.call(project2.scripts, key)) {
            const script2 = project2.scripts[key];
            const script_matches_urls = script2.matches.map((u) => Array.isArray(u) ? u[1] : u);
            const script_excludes_urls = (script2.excludes || []).map((u) => Array.isArray(u) ? u[1] : u);
            if (project2.domains === void 0 || project2.domains.length === 0 || project2.domains.some((d) => urls.some((url) => new URL(url).origin.includes(d)))) {
              if (script_excludes_urls.some((u) => urls.some((url) => RegExp(u).test(url)))) {
                continue;
              }
              if (script_matches_urls.some((u) => urls.some((url) => RegExp(u).test(url)))) {
                scripts.push(script2);
              }
            }
          }
        }
      }
      return scripts;
    },
    namespaceKey(namespace, key) {
      return namespace ? namespace + "." + key.toString() : key.toString();
    },
    uuid() {
      return "xxxxxxxxxxxx4xxxyxxxxxxxxxxxxxxx".replace(/[xy]/g, function(c) {
        const r = Math.random() * 16 | 0;
        const v = c === "x" ? r : r & 3 | 8;
        return v.toString(16);
      });
    },
    random(min, max) {
      return Math.round(Math.random() * (max - min)) + min;
    },
    sleep(period) {
      return __awaiter2(this, void 0, void 0, function* () {
        return new Promise((resolve) => {
          setTimeout(resolve, period);
        });
      });
    },
    isInBrowser() {
      return typeof window !== "undefined" && typeof window.document !== "undefined";
    },
    onresize(el, handler) {
      const resize = (0, debounce_1$1.default)(() => {
        if (el.parentNode === null) {
          window.removeEventListener("resize", resize);
        } else {
          handler(el);
        }
      }, 200);
      resize();
      window.addEventListener("resize", resize);
    },
    loadCustomElements(elements2) {
      for (const element of elements2) {
        const name = resolveCustomElementName(element, "-");
        if (customElements.get(name) === void 0) {
          customElements.define(name, element);
        }
      }
    },
    isInTopWindow() {
      return self === top;
    },
    createCenteredPopupWindow(url, winName, opts) {
      const { width, height, scrollbars, resizable } = opts;
      const LeftPosition = screen.width ? (screen.width - width) / 2 : 0;
      const TopPosition = screen.height ? (screen.height - height) / 2 : 0;
      const settings = "height=" + height + ",width=" + width + ",top=" + TopPosition + ",left=" + LeftPosition + ",scrollbars=" + (scrollbars ? "yes" : "no") + ",resizable=" + (resizable ? "yes" : "no");
      return window.open(url, winName, settings);
    }
  };
  function resolveCustomElementName(el, target) {
    return el.name.replace(/([A-Z])/g, target + "$1").toLowerCase().split(target).slice(1).join(target);
  }
  exports.resolveCustomElementName = resolveCustomElementName;
})(common);
var ui = {};
var dom = {};
Object.defineProperty(dom, "__esModule", { value: true });
dom.enableElementDraggable = dom.$$el = dom.$el = dom.h = void 0;
const common_1$4 = common;
function h(element, attrsOrChildren, childrenOrHandler) {
  let name = "";
  if (typeof element === "function") {
    name = (0, common_1$4.resolveCustomElementName)(element, "-");
  } else {
    name = element;
  }
  const el = document.createElement(name);
  if (attrsOrChildren) {
    if (Array.isArray(attrsOrChildren)) {
      for (const child of attrsOrChildren) {
        if (typeof child === "function") {
          el.append(document.createElement(child.name));
        } else {
          el.append(child);
        }
      }
    } else if (typeof attrsOrChildren === "string") {
      el.append(attrsOrChildren);
    } else {
      const attrs = attrsOrChildren;
      for (const key in attrs) {
        if (Object.prototype.hasOwnProperty.call(attrs, key)) {
          if (key === "style") {
            Object.assign(el.style, attrs[key]);
          } else {
            const value = attrs[key];
            Reflect.set(el, key, value);
          }
        }
      }
    }
  }
  if (childrenOrHandler) {
    if (typeof childrenOrHandler === "function") {
      childrenOrHandler.call(el, el);
    } else if (Array.isArray(childrenOrHandler)) {
      for (const child of childrenOrHandler) {
        if (typeof child === "function") {
          el.append(document.createElement(child.name));
        } else {
          el.append(child);
        }
      }
    } else if (typeof childrenOrHandler === "string") {
      el.append(childrenOrHandler);
    }
  }
  return el;
}
dom.h = h;
function $el(selector, root = window.document) {
  const el = root.querySelector(selector);
  return el === null ? void 0 : el;
}
dom.$el = $el;
function $$el(selector, root = window.document) {
  return Array.from(root.querySelectorAll(selector));
}
dom.$$el = $$el;
function enableElementDraggable(header2, target, ondrag) {
  let pos1 = 0;
  let pos2 = 0;
  let pos3 = 0;
  let pos4 = 0;
  header2.onmousedown = dragMouseDown;
  function dragMouseDown(e) {
    e = e || window.event;
    pos3 = e.clientX;
    pos4 = e.clientY;
    document.onmouseup = closeDragElement;
    document.onmousemove = elementDrag;
  }
  function elementDrag(e) {
    e = e || window.event;
    pos1 = pos3 - e.clientX;
    pos2 = pos4 - e.clientY;
    pos3 = e.clientX;
    pos4 = e.clientY;
    target.style.top = Math.max(target.offsetTop - pos2, 10) + "px";
    target.style.left = target.offsetLeft - pos1 + "px";
  }
  function closeDragElement() {
    ondrag === null || ondrag === void 0 ? void 0 : ondrag();
    document.onmouseup = null;
    document.onmousemove = null;
  }
}
dom.enableElementDraggable = enableElementDraggable;
var elements$1 = {};
Object.defineProperty(elements$1, "__esModule", { value: true });
elements$1.$elements = void 0;
elements$1.$elements = {
  tooltipContainer: void 0,
  root: void 0
};
var tampermonkey = {};
(function(exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.$gm = void 0;
  exports.$gm = {
    unsafeWindow: typeof globalThis.unsafeWindow === "undefined" ? globalThis.window : globalThis.unsafeWindow,
    isInGMContext() {
      return typeof GM_info !== "undefined";
    },
    getInfos() {
      return typeof GM_info === "undefined" ? void 0 : GM_info;
    },
    getTab(callback) {
      return typeof GM_getTab === "undefined" ? void 0 : GM_getTab(callback);
    },
    notification(content, options) {
      var _a;
      const { onclick, ondone, important, duration = 30, silent = true, extraTitle = "" } = options || {};
      const { icon, name } = ((_a = exports.$gm.getInfos()) === null || _a === void 0 ? void 0 : _a.script) || {};
      GM_notification({
        title: name + (extraTitle ? "-" + extraTitle : ""),
        text: content,
        image: icon || "",
        highlight: important,
        onclick,
        ondone,
        silent,
        timeout: duration * 1e3
      });
    },
    getMetadataFromScriptHead(key) {
      var _a, _b;
      const metadataString = (_a = this.getInfos()) === null || _a === void 0 ? void 0 : _a.scriptMetaStr;
      if (!metadataString) {
        return [];
      } else {
        const metadata = ((_b = metadataString.match(/\/\/\s+==UserScript==([\s\S]+)\/\/\s+==\/UserScript==/)) === null || _b === void 0 ? void 0 : _b[1]) || "";
        const metadataList = (metadata.match(/\/\/\s+@(.+?)\s+(.*?)(?:\n|$)/g) || []).map((line) => {
          const words = line.match(/[\S]+/g) || [];
          return {
            key: (words[1] || "").replace("@", ""),
            value: words.slice(2).join(" ")
          };
        });
        return metadataList.filter((l) => l.key === key).map((l) => l.value);
      }
    }
  };
})(tampermonkey);
Object.defineProperty(ui, "__esModule", { value: true });
ui.$ui = void 0;
const common_1$3 = common;
const dom_1$6 = dom;
const elements_1 = elements$1;
const tampermonkey_1$1 = tampermonkey;
ui.$ui = {
  tooltip(target) {
    target.setAttribute("data-title", target.title);
    if (tampermonkey_1$1.$gm.isInGMContext()) {
      target.removeAttribute("title");
    }
    const onMouseMove = (e) => {
      if (elements_1.$elements.tooltipContainer && elements_1.$elements.tooltipContainer.style.display !== "none") {
        elements_1.$elements.tooltipContainer.style.top = e.y + "px";
        elements_1.$elements.tooltipContainer.style.left = e.x + "px";
      }
    };
    const showTitle = (e) => {
      const dataTitle = target.getAttribute("data-title");
      if (elements_1.$elements.tooltipContainer) {
        if (dataTitle) {
          elements_1.$elements.tooltipContainer.innerHTML = dataTitle.split("\n").join("<br>") || "";
          elements_1.$elements.tooltipContainer.style.top = e.y + "px";
          elements_1.$elements.tooltipContainer.style.left = e.x + "px";
          elements_1.$elements.tooltipContainer.style.display = "block";
        } else {
          elements_1.$elements.tooltipContainer.style.display = "none";
        }
      }
      window.addEventListener("mousemove", onMouseMove);
    };
    const hideTitle = () => {
      if (elements_1.$elements.tooltipContainer) {
        elements_1.$elements.tooltipContainer.style.display = "none";
      }
      window.removeEventListener("mousemove", onMouseMove);
    };
    hideTitle();
    target.addEventListener("mouseenter", showTitle);
    target.addEventListener("click", showTitle);
    target.addEventListener("mouseout", hideTitle);
    target.addEventListener("mouseleave", hideTitle);
    target.addEventListener("blur", hideTitle);
    return target;
  },
  scriptPanel(script2, store2, opts) {
    var _a, _b;
    const scriptPanel = (0, dom_1$6.h)("script-panel-element", { name: script2.name });
    script2.onConfigChange("notes", (pre, curr) => {
      scriptPanel.notesContainer.innerHTML = script2.cfg.notes || "";
    });
    script2.panel = scriptPanel;
    scriptPanel.notesContainer.innerHTML = ((_b = (_a = script2.configs) === null || _a === void 0 ? void 0 : _a.notes) === null || _b === void 0 ? void 0 : _b.defaultValue) || "";
    let configs = /* @__PURE__ */ Object.create({});
    const elList = [];
    for (const key in script2.configs) {
      if (Object.prototype.hasOwnProperty.call(script2.configs, key)) {
        const cfg = script2.configs[key];
        if (cfg.separator) {
          elList.push(this.configsArea(this.configs(script2.namespace, store2, configs || {}, opts === null || opts === void 0 ? void 0 : opts.onload)));
          elList.push((0, dom_1$6.h)("div", { className: "separator", style: { margin: "0px 8px" } }, cfg.separator));
          configs = /* @__PURE__ */ Object.create({});
        }
        configs[key] = cfg;
      }
    }
    if (Object.keys(configs).length > 0) {
      elList.push(this.configsArea(this.configs(script2.namespace, store2, configs || {}, opts === null || opts === void 0 ? void 0 : opts.onload)));
    }
    scriptPanel.configsContainer.replaceChildren(...elList);
    return scriptPanel;
  },
  configsArea(configElements) {
    const configsContainer = (0, dom_1$6.h)("div", { className: "configs card" });
    const configsBody = (0, dom_1$6.h)("div", { className: "configs-body" });
    configsBody.append(...Object.entries(configElements).map(([key, el]) => el));
    configsContainer.append(configsBody);
    return configsContainer;
  },
  configs(namespace, store2, configs, onload) {
    const elements2 = /* @__PURE__ */ Object.create({});
    for (const key in configs) {
      if (Object.prototype.hasOwnProperty.call(configs, key)) {
        const config2 = configs[key];
        if (config2.label !== void 0) {
          const element = (0, dom_1$6.h)("config-element", {
            key: common_1$3.$.namespaceKey(namespace, key),
            tag: config2.tag,
            sync: config2.sync,
            attrs: config2.attrs,
            _onload: function(el) {
              var _a;
              (_a = config2.onload) === null || _a === void 0 ? void 0 : _a.call(this, el);
              onload === null || onload === void 0 ? void 0 : onload(el);
            },
            defaultValue: config2.defaultValue,
            options: config2.options,
            showIf: config2.showIf,
            elementClassName: config2.elementClassName
          });
          element.store = store2;
          element.label.textContent = config2.label;
          elements2[key] = element;
        }
      }
    }
    return elements2;
  },
  notes(lines, tag = "ul") {
    return (0, dom_1$6.h)(tag, lines.map((line) => (0, dom_1$6.h)("li", Array.isArray(line) ? line.map((node) => typeof node === "string" ? (0, dom_1$6.h)("div", { innerHTML: node }) : node) : [typeof line === "string" ? (0, dom_1$6.h)("div", { innerHTML: line }) : line])));
  },
  copy(name, value) {
    return (0, dom_1$6.h)("span", "\u{1F4C4}" + name, (btn) => {
      btn.className = "copy";
      btn.addEventListener("click", () => {
        btn.innerText = "\u5DF2\u590D\u5236\u221A";
        navigator.clipboard.writeText(value);
        setTimeout(() => {
          btn.innerText = "\u{1F4C4}" + name;
        }, 500);
      });
    });
  },
  preventText(opts) {
    const { name, delay = 3, autoRemove = true, ondefault, onprevent } = opts;
    const span = (0, dom_1$6.h)("span", name);
    span.style.textDecoration = "underline";
    span.style.cursor = "pointer";
    span.onclick = () => {
      clearTimeout(id);
      if (autoRemove) {
        span.remove();
      }
      onprevent === null || onprevent === void 0 ? void 0 : onprevent(span);
    };
    const id = setTimeout(() => {
      if (autoRemove) {
        span.remove();
      }
      ondefault(span);
    }, delay * 1e3);
    return span;
  },
  space(children, options) {
    return (0, dom_1$6.h)("div", { className: "space" }, (div) => {
      var _a, _b, _c;
      for (let index = 0; index < children.length; index++) {
        const child = (0, dom_1$6.h)("span", { className: "space-item" }, [children[index]]);
        child.style.display = "inline-block";
        const x = (_a = options === null || options === void 0 ? void 0 : options.x) !== null && _a !== void 0 ? _a : 12;
        const y = (_b = options === null || options === void 0 ? void 0 : options.y) !== null && _b !== void 0 ? _b : 0;
        if (index > 0) {
          child.style.marginLeft = x / 2 + "px";
          child.style.marginRight = x / 2 + "px";
          child.style.marginTop = y / 2 + "px";
          child.style.marginBottom = y / 2 + "px";
        } else {
          child.style.marginRight = x / 2 + "px";
          child.style.marginBottom = y / 2 + "px";
        }
        div.append(child);
        if (index !== children.length - 1) {
          div.append((0, dom_1$6.h)("span", [(_c = options === null || options === void 0 ? void 0 : options.separator) !== null && _c !== void 0 ? _c : " "]));
        }
      }
    });
  },
  button(text, attrs, handler) {
    return (0, dom_1$6.h)("input", Object.assign({ type: "button" }, attrs), function(btn) {
      btn.value = text || "";
      btn.classList.add("base-style-button");
      handler === null || handler === void 0 ? void 0 : handler.apply(this, [btn]);
    });
  }
};
(function(exports) {
  var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === void 0)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === void 0)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  __exportStar(common, exports);
  __exportStar(ui, exports);
  __exportStar(dom, exports);
  __exportStar(elements$1, exports);
  __exportStar(tampermonkey, exports);
  __exportStar(store, exports);
  __exportStar(_const, exports);
})(utils);
(function(exports) {
  var __awaiter2 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve) {
        resolve(value);
      });
    }
    return new (P || (P = Promise))(function(resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.cors = exports.CorsEventEmitter = void 0;
  const utils_1 = utils;
  const common_12 = common;
  const const_12 = _const;
  const store_12 = store;
  class CorsEventEmitter {
    constructor() {
      this.eventMap = /* @__PURE__ */ new Map();
    }
    eventKey(name) {
      return "cors.events." + name;
    }
    tempKey(...args) {
      return ["_temp_", ...args].join(".");
    }
    keyOfReturn(id) {
      return this.tempKey("event", id, "return");
    }
    keyOfArguments(id) {
      return this.tempKey("event", id, "arguments");
    }
    keyOfState(id) {
      return this.tempKey("event", id, "state");
    }
    emit(name, args = [], callback) {
      store_12.$store.getTab(const_12.$const.TAB_UID).then((uid) => {
        const id = common_12.$.uuid().replace(/-/g, "");
        const key = uid + "." + this.eventKey(name);
        store_12.$store.set(this.keyOfState(id), 0);
        store_12.$store.set(this.keyOfArguments(id), args);
        setTimeout(() => {
          const listenerId = store_12.$store.addChangeListener(this.keyOfState(id), (pre, curr) => {
            store_12.$store.removeChangeListener(listenerId);
            callback === null || callback === void 0 ? void 0 : callback(store_12.$store.get(this.keyOfReturn(id)));
            store_12.$store.delete(this.keyOfState(id));
            store_12.$store.delete(this.keyOfReturn(id));
            store_12.$store.delete(this.keyOfArguments(id));
          }) || 0;
          store_12.$store.set(key, (store_12.$store.get(key) ? String(store_12.$store.get(key)).split(",") : []).concat(id).join(","));
        }, 100);
      }).catch(console.error);
    }
    on(name, handler) {
      return new Promise((resolve) => {
        store_12.$store.getTab(const_12.$const.TAB_UID).then((uid) => {
          const key = uid + "." + this.eventKey(name);
          const originId = this.eventMap.get(key);
          if (originId) {
            resolve(originId);
          } else {
            const id = store_12.$store.addChangeListener(key, (pre, curr, remote) => __awaiter2(this, void 0, void 0, function* () {
              if (remote) {
                if (curr === void 0) {
                  return;
                }
                const list = String(curr).split(",");
                const id2 = list.pop();
                if (id2) {
                  store_12.$store.set(this.keyOfReturn(id2), yield handler(store_12.$store.get(this.keyOfArguments(id2))));
                  setTimeout(() => {
                    store_12.$store.set(this.keyOfState(id2), 1);
                    store_12.$store.set(key, list.join(","));
                  }, 100);
                }
              }
            })) || 0;
            this.eventMap.set(key, id);
            resolve(id);
          }
        }).catch(console.error);
      });
    }
    off(name) {
      const key = this.eventKey(name);
      const originId = this.eventMap.get(key);
      if (originId) {
        this.eventMap.delete(key);
        store_12.$store.removeChangeListener(originId);
      }
    }
    defineTopFunction(id, func) {
      if (utils_1.$gm.isInGMContext() === false) {
        return () => {
        };
      }
      const event_name = "_top_function_." + id;
      if (self === top) {
        exports.cors.on(event_name, (args) => {
          return func(...args);
        });
      }
      return (...args) => __awaiter2(this, void 0, void 0, function* () {
        const res = yield new Promise((resolve, reject) => {
          try {
            exports.cors.emit(event_name, args, (val) => {
              resolve(val);
            });
          } catch (e) {
            reject(e);
          }
        });
        return res;
      });
    }
  }
  exports.CorsEventEmitter = CorsEventEmitter;
  if (typeof GM_listValues !== "undefined" && self === top) {
    window.onload = () => {
      store_12.$store.list().forEach((key) => {
        if (/_temp_.event.[0-9a-z]{32}.(state|return|arguments)/.test(key)) {
          store_12.$store.delete(key);
        }
        if (/_top_function_.*/.test(key)) {
          store_12.$store.delete(key);
        }
        if (/[0-9a-z]{32}.cors.events/.test(key)) {
          store_12.$store.delete(key);
        }
      });
    };
  }
  exports.cors = new CorsEventEmitter();
})(cors);
var project = {};
Object.defineProperty(project, "__esModule", { value: true });
project.Project = void 0;
class Project {
  constructor({ name, domains, scripts }) {
    this.name = name;
    this.domains = domains;
    for (const key in scripts) {
      if (Object.prototype.hasOwnProperty.call(scripts, key)) {
        const element = scripts[key];
        element.projectName = name;
      }
    }
    this.scripts = scripts;
  }
  static create(opts) {
    return new Project(opts);
  }
}
project.Project = Project;
var script = {};
var __importDefault = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
  return mod && mod.__esModule ? mod : { "default": mod };
};
Object.defineProperty(script, "__esModule", { value: true });
script.Script = script.BaseScript = void 0;
const common_1$2 = common;
const store_1 = store;
const common_2 = common$1;
const events_1 = __importDefault(events.exports);
class BaseScript extends common_2.CommonEventEmitter {
}
script.BaseScript = BaseScript;
class Script extends BaseScript {
  get configs() {
    if (!this._resolvedConfigs) {
      this._resolvedConfigs = typeof this._configs === "function" ? this._configs() : this._configs;
    }
    return this._resolvedConfigs;
  }
  set configs(c) {
    this._configs = c;
  }
  constructor({ name, namespace, matches, excludes, configs, hideInPanel, onstart, onactive, oncomplete, onbeforeunload, onrender, onhistorychange, methods, priority }) {
    super();
    this.excludes = [];
    this.cfg = {};
    this.methods = /* @__PURE__ */ Object.create({});
    this.event = new events_1.default();
    this.name = name;
    this.namespace = namespace;
    this.matches = matches;
    this.excludes = excludes;
    this._configs = configs;
    this.hideInPanel = hideInPanel;
    this.onstart = this.errorHandler(onstart);
    this.onactive = this.errorHandler(onactive);
    this.oncomplete = this.errorHandler(oncomplete);
    this.onbeforeunload = this.errorHandler(onbeforeunload);
    this.onrender = this.errorHandler(onrender);
    this.onhistorychange = this.errorHandler(onhistorychange);
    this.methods = (methods === null || methods === void 0 ? void 0 : methods.bind(this)()) || /* @__PURE__ */ Object.create({});
    this.priority = priority !== null && priority !== void 0 ? priority : 0;
    if (this.methods) {
      for (const key in methods) {
        if (Reflect.has(this.methods, key) && typeof this.methods[key] !== "function") {
          Reflect.set(this.methods, key, this.errorHandler(this.methods[key]));
        }
      }
    }
  }
  onConfigChange(key, handler) {
    const _key = common_1$2.$.namespaceKey(this.namespace, key.toString());
    return store_1.$store.addChangeListener(_key, (pre, curr, remote) => {
      handler(curr, pre, !!remote);
    });
  }
  offConfigChange(listener) {
    store_1.$store.removeChangeListener(listener);
  }
  fullName() {
    return this.projectName ? `${this.projectName}-${this.name}` : this.name;
  }
  errorHandler(func) {
    return (...args) => {
      try {
        return func === null || func === void 0 ? void 0 : func.apply(this, args);
      } catch (err) {
        console.error(err);
        if (err instanceof Error) {
          this.emit("scripterror", err.message);
        } else {
          this.emit("scripterror", String(err));
        }
      }
    };
  }
}
script.Script = Script;
(function(exports) {
  var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === void 0)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === void 0)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  __exportStar(common$1, exports);
  __exportStar(config$1, exports);
  __exportStar(cors, exports);
  __exportStar(project, exports);
  __exportStar(script, exports);
  __exportStar(store_provider, exports);
})(interfaces);
var elements = {};
var config = {};
var _interface = {};
Object.defineProperty(_interface, "__esModule", { value: true });
_interface.IElement = void 0;
class IElement extends HTMLElement {
  connectedCallback() {
  }
  disconnectedCallback() {
  }
  adoptedCallback() {
  }
  attributeChangedCallback(name, oldValue, newValue) {
  }
}
_interface.IElement = IElement;
Object.defineProperty(config, "__esModule", { value: true });
config.ConfigElement = void 0;
const ui_1$1 = ui;
const dom_1$5 = dom;
const interface_1$6 = _interface;
class ConfigElement extends interface_1$6.IElement {
  constructor(store2) {
    super();
    this.label = (0, dom_1$5.h)("label");
    this.wrapper = (0, dom_1$5.h)("div", { className: "config-wrapper" });
    this.key = "";
    this.store = store2;
  }
  get value() {
    return this.store.get(this.key, this.defaultValue);
  }
  set value(value) {
    this.provider.value = value;
    this.store.set(this.key, value);
  }
  connectedCallback() {
    var _a, _b, _c;
    switch (this.tag) {
      case "select": {
        this.provider = (0, dom_1$5.h)("select");
        const value = this.store.get(this.key, this.defaultValue);
        for (const item of this.options || []) {
          const option = (0, dom_1$5.h)("option");
          if (Array.isArray(item)) {
            option.value = item[0];
            option.textContent = (_a = item[1]) !== null && _a !== void 0 ? _a : item[0];
            if (item[2]) {
              option.title = item[2];
            }
            if (String(item[0]) === String(value)) {
              option.selected = true;
              option.toggleAttribute("selected");
            }
            this.provider.add(option);
          } else {
            option.value = item.value;
            option.textContent = (_b = item.label) !== null && _b !== void 0 ? _b : item.value;
            if (item.title) {
              option.title = item.title;
            }
            if (String(item.value) === String(value)) {
              option.selected = true;
              option.toggleAttribute("selected");
            }
            this.provider.add(option);
          }
        }
        this.provider.onchange = () => {
          this.store.set(this.key, this.provider.value);
        };
        break;
      }
      case "textarea": {
        this.provider = (0, dom_1$5.h)("textarea");
        this.provider.value = this.store.get(this.key, this.defaultValue);
        this.provider.onchange = () => {
          this.store.set(this.key, this.provider.value);
        };
        break;
      }
      default: {
        this.provider = (0, dom_1$5.h)("input");
        if (["checkbox", "radio"].some((t) => {
          var _a2;
          return t === ((_a2 = this.attrs) === null || _a2 === void 0 ? void 0 : _a2.type);
        })) {
          this.provider.checked = this.store.get(this.key, this.defaultValue);
          const provider = this.provider;
          provider.onchange = () => {
            this.store.set(this.key, provider.checked);
          };
        } else {
          this.provider.value = this.store.get(this.key, this.defaultValue);
          this.provider.setAttribute("value", this.provider.value);
          this.provider.onchange = () => {
            const { min, max, type } = this.attrs || {};
            if (type === "number") {
              if (this.provider.value.trim() === "") {
                this.provider.value = this.defaultValue;
                this.store.set(this.key, this.defaultValue);
                return;
              }
              const val = parseFloat(this.provider.value);
              const _min = min ? parseFloat(min) : void 0;
              const _max = max ? parseFloat(max) : void 0;
              if (_min && val < _min) {
                this.provider.value = _min.toString();
                this.store.set(this.key, parseFloat(this.provider.value));
              } else if (_max && val > _max) {
                this.provider.value = _max.toString();
                this.store.set(this.key, parseFloat(this.provider.value));
              } else {
                this.store.set(this.key, val);
              }
            } else {
              this.store.set(this.key, this.provider.value);
            }
          };
        }
        break;
      }
    }
    this.wrapper.replaceChildren(this.provider);
    this.append(this.label, this.wrapper);
    if (this.elementClassName) {
      this.className = this.elementClassName;
    }
    for (const key in this.attrs) {
      if (key === "style") {
        Object.assign(this.provider.style, this.attrs[key]);
        continue;
      }
      if (Object.prototype.hasOwnProperty.call(this.attrs, key)) {
        Reflect.set(this.provider, key, Reflect.get(this.attrs, key));
      }
    }
    if (this.sync) {
      this.store.addChangeListener(this.key, (curr, pre, remote) => {
        this.provider.value = curr;
      });
    }
    ui_1$1.$ui.tooltip(this.provider);
    if (this.showIf) {
      const showIf = this.store.get(this.showIf, false) || false;
      if (showIf) {
        this.style.display = "";
      } else {
        this.style.display = "none";
      }
      this.store.addChangeListener(this.showIf, (curr, pre, remote) => {
        if (this.isConnected) {
          if (curr) {
            this.style.display = "";
          } else {
            this.style.display = "none";
          }
        }
      });
    }
    (_c = this._onload) === null || _c === void 0 ? void 0 : _c.call(this.provider, this);
  }
}
config.ConfigElement = ConfigElement;
var container = {};
Object.defineProperty(container, "__esModule", { value: true });
container.ContainerElement = void 0;
const common_1$1 = common;
const ui_1 = ui;
const dom_1$4 = dom;
const interface_1$5 = _interface;
class ContainerElement extends interface_1$5.IElement {
  constructor() {
    super(...arguments);
    this.header = ui_1.$ui.tooltip((0, dom_1$4.h)("header-element", { title: "\u83DC\u5355\u680F-\u53EF\u62D6\u52A8\u533A\u57DF" }));
    this.body = (0, dom_1$4.h)("div", { className: "body", clientHeight: window.innerHeight / 2 });
    this.footer = (0, dom_1$4.h)("div", { className: "footer" });
  }
  connectedCallback() {
    this.append(this.header, this.body, this.footer);
    common_1$1.$.onresize(this, (cont) => {
      cont.body.style.maxHeight = window.innerHeight - this.header.clientHeight - 100 + "px";
      cont.body.style.maxWidth = window.innerWidth - 50 + "px";
    });
  }
}
container.ContainerElement = ContainerElement;
var dropdown = {};
Object.defineProperty(dropdown, "__esModule", { value: true });
dropdown.DropdownElement = void 0;
const interface_1$4 = _interface;
const dom_1$3 = dom;
class DropdownElement extends interface_1$4.IElement {
  constructor() {
    super(...arguments);
    this.triggerElement = (0, dom_1$3.h)("button");
    this.content = (0, dom_1$3.h)("div", { className: "dropdown-content" });
    this.trigger = "hover";
  }
  connectedCallback() {
    this.append(this.triggerElement, this.content);
    this.classList.add("dropdown");
    if (this.trigger === "click") {
      this.triggerElement.onclick = () => {
        this.content.classList.toggle("show");
      };
    } else {
      this.triggerElement.onmouseover = () => {
        this.content.classList.add("show");
      };
      this.triggerElement.onmouseout = () => {
        this.content.classList.remove("show");
      };
      this.content.onmouseover = () => {
        this.content.classList.add("show");
      };
      this.content.onmouseout = () => {
        this.content.classList.remove("show");
      };
    }
    this.content.onclick = () => {
      this.content.classList.remove("show");
    };
  }
}
dropdown.DropdownElement = DropdownElement;
var header = {};
Object.defineProperty(header, "__esModule", { value: true });
header.HeaderElement = void 0;
const interface_1$3 = _interface;
class HeaderElement extends interface_1$3.IElement {
  connectedCallback() {
    this.append(this.visualSwitcher || "");
  }
}
header.HeaderElement = HeaderElement;
var message = {};
Object.defineProperty(message, "__esModule", { value: true });
message.MessageElement = void 0;
const dom_1$2 = dom;
const interface_1$2 = _interface;
class MessageElement extends interface_1$2.IElement {
  constructor() {
    super(...arguments);
    this.closer = (0, dom_1$2.h)("span", { className: "message-closer" }, "x");
    this.contentContainer = (0, dom_1$2.h)("span", { className: "message-content-container" });
    this.type = "info";
    this.content = "";
    this.closeable = true;
  }
  connectedCallback() {
    var _a;
    this.classList.add(this.type);
    if (typeof this.content === "string") {
      this.contentContainer.innerHTML = this.content;
    } else {
      this.contentContainer.append(this.content);
    }
    this.duration = Math.max((_a = this.duration) !== null && _a !== void 0 ? _a : 5, 0);
    this.append(this.contentContainer);
    if (this.closeable) {
      this.append(this.closer);
      this.closer.addEventListener("click", () => {
        var _a2;
        (_a2 = this.onClose) === null || _a2 === void 0 ? void 0 : _a2.call(this);
        this.remove();
      });
    }
    if (this.duration) {
      setTimeout(() => {
        var _a2;
        (_a2 = this.onClose) === null || _a2 === void 0 ? void 0 : _a2.call(this);
        this.remove();
      }, this.duration * 1e3);
    }
  }
}
message.MessageElement = MessageElement;
var modal = {};
var __awaiter = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
Object.defineProperty(modal, "__esModule", { value: true });
modal.ModalElement = void 0;
const common_1 = common;
const dom_1$1 = dom;
const tampermonkey_1 = tampermonkey;
const interface_1$1 = _interface;
class ModalElement extends interface_1$1.IElement {
  constructor() {
    super(...arguments);
    this._title = (0, dom_1$1.h)("div", { className: "modal-title" });
    this.body = (0, dom_1$1.h)("div", { className: "modal-body" });
    this.footerContainer = (0, dom_1$1.h)("div", { className: "modal-footer" });
    this.modalInput = (0, dom_1$1.h)("input", { className: "modal-input" });
    this.modalInputType = "input";
    this.type = "alert";
    this.content = "";
    this.inputDefaultValue = "";
    this.placeholder = "";
    this.modalStyle = {};
  }
  connectedCallback() {
    var _a;
    this.classList.add(this.type);
    Object.assign(this.style, this.modalStyle || {});
    const profile = (0, dom_1$1.h)("div", {
      innerText: this.profile || "\u5F39\u7A97\u6765\u81EA: OCS " + (((_a = tampermonkey_1.$gm.getInfos()) === null || _a === void 0 ? void 0 : _a.script.version) || ""),
      className: "modal-profile"
    });
    this._title.innerText = this.title;
    this.body.append(typeof this.content === "string" ? (0, dom_1$1.h)("div", { innerHTML: this.content }) : this.content);
    if (this.modalInputType === "textarea") {
      this.modalInput = (0, dom_1$1.h)("textarea", { className: "modal-input", style: { height: "100px" } });
    }
    this.modalInput.placeholder = this.placeholder || "";
    this.modalInput.value = this.inputDefaultValue || "";
    this.append(profile, this._title, this.body, this.footerContainer);
    this.style.width = (this.width || 400) + "px";
    if (this.footer === void 0) {
      this.footerContainer.append(this.modalInput);
      if (this.cancelButton === void 0) {
        this.cancelButton = (0, dom_1$1.h)("button", { className: "modal-cancel-button" });
        this.cancelButton.innerText = this.cancelButtonText || "\u53D6\u6D88";
        this.cancelButton.onclick = () => {
          var _a2, _b;
          (_a2 = this.onCancel) === null || _a2 === void 0 ? void 0 : _a2.call(this);
          (_b = this.onClose) === null || _b === void 0 ? void 0 : _b.call(this);
          this.remove();
        };
      }
      if (this.confirmButton === void 0) {
        this.confirmButton = (0, dom_1$1.h)("button", { className: "modal-confirm-button" });
        this.confirmButton.innerText = this.confirmButtonText || "\u786E\u5B9A";
        this.confirmButton.onclick = () => __awaiter(this, void 0, void 0, function* () {
          var _b, _c;
          if ((yield (_b = this.onConfirm) === null || _b === void 0 ? void 0 : _b.call(this, this.modalInput.value)) !== false) {
            this.remove();
            (_c = this.onClose) === null || _c === void 0 ? void 0 : _c.call(this, this.modalInput.value);
          }
        });
      }
      this.cancelButton && this.footerContainer.append(this.cancelButton);
      this.confirmButton && this.footerContainer.append(this.confirmButton);
      if (this.type === "simple") {
        this.footerContainer.remove();
      } else if (this.type === "prompt") {
        this.modalInput.focus();
      }
    } else {
      this.footerContainer.append(this.footer);
    }
    common_1.$.onresize(this.body, (modal2) => {
      this.body.style.maxHeight = window.innerHeight - 100 + "px";
      this.body.style.maxWidth = window.innerWidth - 50 + "px";
    });
  }
}
modal.ModalElement = ModalElement;
var script_panel = {};
Object.defineProperty(script_panel, "__esModule", { value: true });
script_panel.ScriptPanelElement = void 0;
const dom_1 = dom;
const interface_1 = _interface;
class ScriptPanelElement extends interface_1.IElement {
  constructor() {
    super(...arguments);
    this.separator = (0, dom_1.h)("div", { className: "separator" });
    this.notesContainer = (0, dom_1.h)("div", { className: "notes card" });
    this.configsContainer = (0, dom_1.h)("div", { className: "configs-container card" });
    this.body = (0, dom_1.h)("div", { className: "script-panel-body" });
    this.lockWrapper = (0, dom_1.h)("div", { className: "lock-wrapper" });
  }
  connectedCallback() {
    this.separator.innerText = this.name || "";
    this.append(this.separator);
    this.append(this.notesContainer);
    this.append(this.configsContainer);
    this.append(this.body);
  }
}
script_panel.ScriptPanelElement = ScriptPanelElement;
(function(exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.definedCustomElements = exports.ScriptPanelElement = exports.ModalElement = exports.MessageElement = exports.HeaderElement = exports.ContainerElement = exports.ConfigElement = void 0;
  const config_1 = config;
  const container_1 = container;
  const dropdown_1 = dropdown;
  const header_1 = header;
  const message_1 = message;
  const modal_1 = modal;
  const script_panel_1 = script_panel;
  var config_2 = config;
  Object.defineProperty(exports, "ConfigElement", { enumerable: true, get: function() {
    return config_2.ConfigElement;
  } });
  var container_2 = container;
  Object.defineProperty(exports, "ContainerElement", { enumerable: true, get: function() {
    return container_2.ContainerElement;
  } });
  var header_2 = header;
  Object.defineProperty(exports, "HeaderElement", { enumerable: true, get: function() {
    return header_2.HeaderElement;
  } });
  var message_2 = message;
  Object.defineProperty(exports, "MessageElement", { enumerable: true, get: function() {
    return message_2.MessageElement;
  } });
  var modal_2 = modal;
  Object.defineProperty(exports, "ModalElement", { enumerable: true, get: function() {
    return modal_2.ModalElement;
  } });
  var script_panel_2 = script_panel;
  Object.defineProperty(exports, "ScriptPanelElement", { enumerable: true, get: function() {
    return script_panel_2.ScriptPanelElement;
  } });
  exports.definedCustomElements = [
    config_1.ConfigElement,
    container_1.ContainerElement,
    header_1.HeaderElement,
    modal_1.ModalElement,
    message_1.MessageElement,
    script_panel_1.ScriptPanelElement,
    dropdown_1.DropdownElement
  ];
})(elements);
var hasRequiredCustomWindow;
function requireCustomWindow() {
  if (hasRequiredCustomWindow)
    return customWindow;
  hasRequiredCustomWindow = 1;
  var __awaiter2 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve) {
        resolve(value);
      });
    }
    return new (P || (P = Promise))(function(resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var __rest = commonjsGlobal && commonjsGlobal.__rest || function(s, e) {
    var t = {};
    for (var p in s)
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
          t[p[i]] = s[p[i]];
      }
    return t;
  };
  Object.defineProperty(customWindow, "__esModule", { value: true });
  customWindow.modal = customWindow.CustomWindow = void 0;
  const _1 = interfaces;
  const elements_12 = elements;
  const utils_1 = utils;
  const start_1 = requireStart();
  const minimizeSvg = '<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 13H5v-2h14v2z"/></svg>';
  const expandSvg = '<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H6V6h12v12z"/></svg>';
  class CustomWindow {
    constructor(projects, inputStoreProvider, config2) {
      this.messageContainer = (0, utils_1.h)("div", { className: "message-container" });
      this.extraMenuBar = (0, utils_1.h)("div", { className: "extra-menu-bar" });
      this.defaults = {
        urls: (urls) => urls && urls.length ? urls : [location.href],
        panelName: (name) => name || this.config.render.defaultPanelName || ""
      };
      this.projects = projects;
      this.inputStoreProvider = inputStoreProvider;
      this.config = config2;
      handleLowLevelBrowser();
      utils_1.$.loadCustomElements(elements_12.definedCustomElements);
      this.wrapper = (0, utils_1.h)("div");
      this.root = this.wrapper.attachShadow({ mode: "closed" });
      this.container = (0, utils_1.h)("container-element");
      this.root.append(this.container);
      const styles = config2.render.styles.map((s) => (0, utils_1.h)("style", s));
      this.container.append(...styles, this.messageContainer);
      const handlePosition = () => {
        const pos = config2.store.getPosition();
        if (pos.x > document.documentElement.clientWidth || pos.x < 0) {
          config2.store.setPosition(10, 10);
        }
        if (pos.y > document.documentElement.clientHeight || pos.y < 0) {
          config2.store.setPosition(10, 10);
        }
        this.container.style.left = pos.x + "px";
        this.container.style.top = pos.y + "px";
        const positionHandler = () => {
          config2.store.setPosition(this.container.offsetLeft, this.container.offsetTop);
        };
        (0, utils_1.enableElementDraggable)(this.container.header, this.container, positionHandler);
      };
      const handleVisible = () => {
        window.addEventListener("click", (e) => {
          if (e.detail === Math.max(config2.render.switchPoint, 3)) {
            this.container.style.top = e.y + "px";
            this.container.style.left = e.x + "px";
            config2.store.setPosition(e.x, e.y);
            this.setVisual("normal");
          }
        });
      };
      const initCorsModalSystem = () => {
        _1.cors.on("modal", (args) => __awaiter2(this, void 0, void 0, function* () {
          const [type, _attrs] = args || [];
          return new Promise((resolve, reject) => {
            const attrs = _attrs;
            attrs.onCancel = () => resolve("");
            attrs.onConfirm = resolve;
            attrs.onClose = resolve;
            modal2(type, attrs);
          });
        }));
      };
      const initCorsMessageSystem = () => {
        _1.cors.on("message", (args) => __awaiter2(this, void 0, void 0, function* () {
          const [type, attrs] = args || [];
          console.log("message", type, attrs);
          this.message(type, attrs);
        }));
      };
      window.addEventListener("keydown", (e) => {
        if (e.ctrlKey && e.key === config2.render.switchKey) {
          e.stopPropagation();
          e.preventDefault();
          this.setVisual(config2.store.getVisual() === "close" ? "normal" : "close");
        }
      }, { capture: true });
      handleVisible();
      this.setVisual(config2.store.getVisual());
      (() => __awaiter2(this, void 0, void 0, function* () {
        const urls = yield config2.store.getRenderURLs();
        const currentPanelName = yield config2.store.getCurrentPanelName();
        yield this.rerender(this.defaults.urls(urls), this.defaults.panelName(currentPanelName));
      }))();
      initCorsModalSystem();
      initCorsMessageSystem();
      handlePosition();
      this.setFontSize(config2.render.fontsize);
    }
    rerender(urls, currentPanelName) {
      return __awaiter2(this, void 0, void 0, function* () {
        this.initHeader(urls, currentPanelName);
        yield this.renderBody(currentPanelName);
      });
    }
    initHeader(urls, currentPanelName) {
      const profile = utils_1.$ui.tooltip((0, utils_1.h)("div", { className: "profile", title: "\u83DC\u5355\u680F\uFF08\u53EF\u62D6\u52A8\u533A\u57DF\uFF09" }, this.config.render.title || "\u65E0\u6807\u9898"));
      const scriptDropdowns = [];
      for (const project2 of this.projects) {
        const dropdown2 = (0, utils_1.h)("dropdown-element");
        let selected = false;
        const options = [];
        const scripts = utils_1.$.getMatchedScripts([project2], urls).filter((s) => !s.hideInPanel);
        if (scripts.length) {
          for (const key in project2.scripts) {
            if (Object.prototype.hasOwnProperty.call(project2.scripts, key)) {
              const script2 = project2.scripts[key];
              if (!script2.hideInPanel) {
                const optionSelected = isCurrentPanel(project2.name, script2, currentPanelName);
                const option = (0, utils_1.h)("div", { className: "dropdown-option" }, script2.name);
                if (optionSelected) {
                  option.classList.add("active");
                }
                if (selected !== true && optionSelected) {
                  selected = true;
                }
                option.onclick = () => __awaiter2(this, void 0, void 0, function* () {
                  yield this.config.store.setCurrentPanelName(project2.name + "-" + script2.name);
                });
                options.push(option);
              }
            }
          }
          if (selected) {
            dropdown2.classList.add("active");
          }
          dropdown2.triggerElement = (0, utils_1.h)("div", { className: "dropdown-trigger-element " }, project2.name);
          dropdown2.triggerElement.style.padding = "0px 8px";
          dropdown2.content.append(...options);
          scriptDropdowns.push(dropdown2);
        }
      }
      const isMinimize = () => this.config.store.getVisual() === "minimize";
      const visualSwitcher = utils_1.$ui.tooltip((0, utils_1.h)("div", {
        className: "switch ",
        title: isMinimize() ? "\u70B9\u51FB\u5C55\u5F00\u7A97\u53E3" : "\u70B9\u51FB\u6700\u5C0F\u5316\u7A97\u53E3",
        innerHTML: isMinimize() ? expandSvg : minimizeSvg,
        onclick: () => {
          this.setVisual(isMinimize() ? "normal" : "minimize");
          visualSwitcher.title = isMinimize() ? "\u70B9\u51FB\u5C55\u5F00\u7A97\u53E3" : "\u70B9\u51FB\u6700\u5C0F\u5316\u7A97\u53E3";
          visualSwitcher.innerHTML = isMinimize() ? expandSvg : minimizeSvg;
        }
      }));
      this.container.header.visualSwitcher = visualSwitcher;
      this.container.header.replaceChildren();
      this.container.header.append((0, utils_1.h)("div", { style: { width: "100%" } }, [
        (0, utils_1.h)("div", { style: { display: "flex", width: "100%" } }, [
          profile,
          ...scriptDropdowns,
          this.container.header.visualSwitcher || ""
        ]),
        (0, utils_1.h)("div", { style: { display: "flex", width: "100%" } }, [this.extraMenuBar])
      ]));
    }
    renderBody(currentPanelName) {
      var _a;
      return __awaiter2(this, void 0, void 0, function* () {
        for (const project2 of this.projects) {
          for (const key in project2.scripts) {
            if (Object.prototype.hasOwnProperty.call(project2.scripts, key)) {
              const script2 = project2.scripts[key];
              if (isCurrentPanel(project2.name, script2, currentPanelName)) {
                const panel = utils_1.$ui.scriptPanel(script2, this.inputStoreProvider);
                script2.projectName = project2.name;
                script2.panel = panel;
                script2.header = this.container.header;
                this.container.body.replaceChildren(panel);
                (_a = script2.onrender) === null || _a === void 0 ? void 0 : _a.call(script2, { panel, header: this.container.header });
                script2.emit("render", { panel, header: this.container.header });
              }
            }
          }
        }
      });
    }
    setFontSize(fontsize) {
      this.container.style.font = `${fontsize}px  Menlo, Monaco, Consolas, 'Courier New', monospace`;
    }
    setVisual(value) {
      this.container.className = "";
      if (value === "minimize") {
        this.container.classList.add("minimize");
      } else if (value === "close") {
        this.container.classList.add("close");
      } else {
        this.container.classList.add("normal");
      }
      this.config.store.setVisual(value);
    }
    changeRenderURLs(urls) {
      return __awaiter2(this, void 0, void 0, function* () {
        const currentPanelName = yield this.config.store.getCurrentPanelName();
        yield this.rerender(this.defaults.urls(urls), this.defaults.panelName(currentPanelName));
      });
    }
    changePanel(currentPanelName) {
      return __awaiter2(this, void 0, void 0, function* () {
        const urls = (yield this.config.store.getRenderURLs()) || [location.href];
        yield this.rerender(this.defaults.urls(urls), this.defaults.panelName(currentPanelName));
      });
    }
    pin(script2) {
      return __awaiter2(this, void 0, void 0, function* () {
        if (script2.projectName) {
          yield this.config.store.setCurrentPanelName(`${script2.projectName}-${script2.name}`);
        } else if (script2.namespace) {
          yield this.config.store.setCurrentPanelName(script2.namespace);
        } else {
          console.warn("[ERROR]", `${script2.name} \u65E0\u6CD5\u7F6E\u9876\uFF0C projectName \u4E0E namespace \u90FD\u4E3A undefined`);
        }
      });
    }
    minimize() {
      this.setVisual("minimize");
    }
    normal() {
      this.setVisual("normal");
    }
    message(type, attrs) {
      if (typeof attrs === "string") {
        attrs = { content: attrs };
      }
      const message2 = (0, utils_1.h)("message-element", Object.assign({ type }, attrs));
      this.messageContainer.append(message2);
      return message2;
    }
    menu(label, config2) {
      this.extraMenuBar.style.display = "flex";
      const btn = (0, utils_1.h)("button", label);
      btn.addEventListener("click", () => {
        if (config2.scriptPanelLink) {
          this.pin(config2.scriptPanelLink).then(() => {
            this.normal();
          }).catch(console.error);
        }
      });
      if (config2.scriptPanelLink) {
        const full_name = (config2.scriptPanelLink.projectName ? config2.scriptPanelLink.projectName + " -> " : "") + config2.scriptPanelLink.name;
        btn.title = "\u5FEB\u6377\u8DF3\u8F6C\uFF1A" + full_name;
        btn.classList.add("script-panel-link");
      }
      this.extraMenuBar.append(btn);
      return btn;
    }
    mount(parent) {
      parent.children[utils_1.$.random(0, parent.children.length - 1)].after(this.wrapper);
    }
  }
  customWindow.CustomWindow = CustomWindow;
  function isCurrentPanel(projectName, script2, currentPanelName) {
    return projectName + "-" + script2.name === currentPanelName || script2.namespace === currentPanelName;
  }
  function handleLowLevelBrowser() {
    if (typeof Element.prototype.replaceChildren === "undefined") {
      Element.prototype.replaceChildren = function(...nodes) {
        this.innerHTML = "";
        for (const node of nodes) {
          this.append(node);
        }
      };
    }
  }
  function modal2(type, attrs, parent = (start_1.$win === null || start_1.$win === void 0 ? void 0 : start_1.$win.container) || utils_1.$elements.root || document.body) {
    const { maskCloseable = true, onConfirm, onCancel, onClose, notification: notify, notificationOptions, duration } = attrs, _attrs = __rest(attrs, ["maskCloseable", "onConfirm", "onCancel", "onClose", "notification", "notificationOptions", "duration"]);
    if (notify) {
      utils_1.$gm.notification(typeof _attrs.content === "string" ? _attrs.content : _attrs.content.textContent || "", notificationOptions);
    }
    const wrapper = (0, utils_1.h)("div", { className: "modal-wrapper" }, (wrapper2) => {
      const modal3 = (0, utils_1.h)("modal-element", Object.assign({
        onConfirm(val) {
          return __awaiter2(this, void 0, void 0, function* () {
            const isClose = yield onConfirm === null || onConfirm === void 0 ? void 0 : onConfirm.apply(modal3, [val]);
            if (isClose !== false) {
              wrapper2.remove();
            }
            return isClose;
          });
        },
        onCancel() {
          onCancel === null || onCancel === void 0 ? void 0 : onCancel.apply(modal3);
          wrapper2.remove();
        },
        onClose(val) {
          onClose === null || onClose === void 0 ? void 0 : onClose.apply(modal3, [val]);
          wrapper2.remove();
        },
        type
      }, _attrs));
      wrapper2.append(modal3);
      modal3.addEventListener("click", (e) => {
        e.stopPropagation();
      });
      if (maskCloseable) {
        wrapper2.addEventListener("click", () => {
          onClose === null || onClose === void 0 ? void 0 : onClose.apply(modal3);
          wrapper2.remove();
        });
      }
    });
    if (duration) {
      setTimeout(() => {
        wrapper.remove();
      }, duration * 1e3);
    }
    parent.append(wrapper);
    return wrapper;
  }
  customWindow.modal = modal2;
  return customWindow;
}
var hasRequiredStart;
function requireStart() {
  if (hasRequiredStart)
    return start;
  hasRequiredStart = 1;
  var __awaiter2 = commonjsGlobal && commonjsGlobal.__awaiter || function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve) {
        resolve(value);
      });
    }
    return new (P || (P = Promise))(function(resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var __importDefault2 = commonjsGlobal && commonjsGlobal.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { "default": mod };
  };
  Object.defineProperty(start, "__esModule", { value: true });
  start.addFunctionEventListener = start.start = start.$win = void 0;
  const custom_window_1 = requireCustomWindow();
  const common_12 = common;
  const const_12 = _const;
  const dom_12 = dom;
  const elements_12 = elements$1;
  const store_12 = store;
  const debounce_1$1 = __importDefault2(debounce_1);
  let mounted = false;
  function start$1(startConfig) {
    return __awaiter2(this, void 0, void 0, function* () {
      const uid = yield store_12.$store.getTab(const_12.$const.TAB_UID);
      if (uid === void 0) {
        yield store_12.$store.setTab(const_12.$const.TAB_UID, common_12.$.uuid());
      }
      startConfig.projects = startConfig.projects.map((p) => {
        for (const key in p.scripts) {
          if (Object.prototype.hasOwnProperty.call(p.scripts, key)) {
            p.scripts[key].cfg = common_12.$.createConfigProxy(p.scripts[key]);
          }
        }
        return p;
      });
      const scripts = common_12.$.getMatchedScripts(startConfig.projects, [location.href]).sort((a, b) => b.priority - a.priority);
      scripts.forEach((script2) => {
        var _a;
        script2.startConfig = startConfig;
        script2.emit("start", startConfig);
        (_a = script2.onstart) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
      });
      let active = false;
      if (document.readyState === "interactive") {
        active = true;
        mount(startConfig);
        scripts.forEach((script2) => {
          var _a;
          return (_a = script2.onactive) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
        });
      } else if (document.readyState === "complete") {
        mount(startConfig);
        scripts.forEach((script2) => {
          var _a;
          return (_a = script2.onactive) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
        });
        scripts.forEach((script2) => {
          var _a;
          return (_a = script2.oncomplete) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
        });
      }
      document.addEventListener("readystatechange", () => {
        mount(startConfig);
        if (document.readyState === "interactive" && active === false) {
          scripts.forEach((script2) => {
            var _a;
            script2.emit("active", startConfig);
            (_a = script2.onactive) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
          });
        }
        if (document.readyState === "complete") {
          scripts.forEach((script2) => {
            var _a;
            script2.emit("complete");
            (_a = script2.oncomplete) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
          });
          store_12.$store.getTab(const_12.$const.TAB_URLS).then((urls) => {
            store_12.$store.setTab(const_12.$const.TAB_URLS, Array.from(new Set(urls || [])).concat(location.href));
          });
        }
      });
      window.addEventListener("hashchange", () => {
        scripts.forEach((script2) => {
          var _a;
          script2.emit("hashchange", startConfig);
          (_a = script2.onhashchange) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig);
        });
      });
      history.pushState = addFunctionEventListener(history, "pushState");
      history.replaceState = addFunctionEventListener(history, "replaceState");
      window.addEventListener("pushState", () => {
        scripts.forEach((script2) => {
          var _a;
          script2.emit("historychange", "push", startConfig);
          (_a = script2.onhistorychange) === null || _a === void 0 ? void 0 : _a.call(script2, "push", startConfig);
        });
      });
      window.addEventListener("replaceState", () => {
        scripts.forEach((script2) => {
          var _a;
          script2.emit("historychange", "replace", startConfig);
          (_a = script2.onhistorychange) === null || _a === void 0 ? void 0 : _a.call(script2, "replace", startConfig);
        });
      });
      window.addEventListener("beforeunload", (e) => {
        var _a;
        let prevent;
        for (const script2 of scripts) {
          script2.emit("beforeunload");
          if ((_a = script2.onbeforeunload) === null || _a === void 0 ? void 0 : _a.call(script2, startConfig)) {
            prevent = true;
          }
        }
        if (prevent) {
          e.preventDefault();
          e.returnValue = true;
          return true;
        }
      });
    });
  }
  start.start = start$1;
  function addFunctionEventListener(obj, type) {
    const origin = obj[type];
    return function(...args) {
      const res = origin.apply(this, args);
      const e = new Event(type.toString());
      e.arguments = args;
      window.dispatchEvent(e);
      return res;
    };
  }
  start.addFunctionEventListener = addFunctionEventListener;
  function mount(startConfig) {
    if (mounted === true) {
      return;
    }
    mounted = true;
    if (startConfig === void 0 || startConfig.renderConfig === void 0) {
      console.warn("the script will not have ui because the renderConfig is not defined.");
      return;
    }
    store_12.$store.setTab(const_12.$const.TAB_URLS, []);
    if (self === top) {
      const { projects, renderConfig } = startConfig;
      if (typeof renderConfig.renderScript === "undefined") {
        console.warn("the script will not have ui because the RenderScript is not defined.");
        return;
      }
      const scripts = common_12.$.getMatchedScripts(projects, [location.href]).filter((s) => !!s.hideInPanel === false);
      if (scripts.length <= 0) {
        return;
      }
      const RenderScript = renderConfig.renderScript;
      const win = new custom_window_1.CustomWindow(startConfig.projects, store_12.$store, {
        render: {
          title: renderConfig.title,
          styles: renderConfig.styles,
          defaultPanelName: renderConfig.defaultPanelName,
          fontsize: RenderScript.cfg.fontsize,
          switchPoint: RenderScript.cfg.switchPoint,
          switchKey: "o"
        },
        store: {
          getPosition: () => {
            return { x: RenderScript.cfg.x, y: RenderScript.cfg.y };
          },
          setPosition: (x, y) => {
            RenderScript.cfg.x = x;
            RenderScript.cfg.y = y;
          },
          getVisual: () => {
            return RenderScript.cfg.visual;
          },
          setVisual: (size) => {
            RenderScript.cfg.visual = size;
          },
          getRenderURLs() {
            return __awaiter2(this, void 0, void 0, function* () {
              return yield store_12.$store.getTab(const_12.$const.TAB_URLS);
            });
          },
          setRenderURLs(urls) {
            return __awaiter2(this, void 0, void 0, function* () {
              return yield store_12.$store.setTab(const_12.$const.TAB_URLS, urls);
            });
          },
          getCurrentPanelName() {
            return __awaiter2(this, void 0, void 0, function* () {
              return yield store_12.$store.getTab(const_12.$const.TAB_CURRENT_PANEL_NAME);
            });
          },
          setCurrentPanelName(name) {
            return __awaiter2(this, void 0, void 0, function* () {
              return yield store_12.$store.setTab(const_12.$const.TAB_CURRENT_PANEL_NAME, name);
            });
          }
        }
      });
      RenderScript.onConfigChange("fontsize", (fs) => {
        win.setFontSize(fs);
      });
      RenderScript.onConfigChange("visual", (v) => {
        win.setVisual(v);
      });
      store_12.$store.addTabChangeListener(const_12.$const.TAB_URLS, (0, debounce_1$1.default)((urls) => {
        win.changeRenderURLs(urls);
      }, 2e3));
      store_12.$store.addTabChangeListener(const_12.$const.TAB_CURRENT_PANEL_NAME, (name) => {
        win.changePanel(name);
      });
      win.mount(document.body);
      elements_12.$elements.tooltipContainer = (0, dom_12.h)("div", { className: "tooltip-container" });
      elements_12.$elements.root = win.root;
      win.container.append(elements_12.$elements.tooltipContainer);
      start.$win = win;
    }
  }
  return start;
}
var render = {};
(function(exports) {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.$menu = exports.$message = exports.$modal = exports.createRenderScript = void 0;
  const script_1 = script;
  const ui_12 = ui;
  const dom_12 = dom;
  const custom_window_1 = requireCustomWindow();
  const start_1 = requireStart();
  const interfaces_1 = interfaces;
  const createRenderScript = (config2) => new script_1.Script({
    name: (config2 === null || config2 === void 0 ? void 0 : config2.name) || "\u7A97\u53E3\u8BBE\u7F6E",
    matches: (config2 === null || config2 === void 0 ? void 0 : config2.matches) || [["\u6240\u6709", /.*/]],
    namespace: "render.panel",
    configs: {
      notes: {
        defaultValue: ui_12.$ui.notes([
          [
            "\u5982\u679C\u9700\u8981\u9690\u85CF\u6574\u4E2A\u7A97\u53E3\uFF0C\u53EF\u4EE5\u70B9\u51FB\u4E0B\u65B9\u9690\u85CF\u6309\u94AE\uFF0C",
            "\u9690\u85CF\u540E\u53EF\u4EE5\u5FEB\u901F\u4E09\u51FB\u5C4F\u5E55\u4E2D\u7684\u4EFB\u610F\u5730\u65B9",
            "\u6765\u91CD\u65B0\u5728\u9F20\u6807\u4F4D\u7F6E\u663E\u793A\u7A97\u53E3\u3002"
          ],
          "\u7A97\u53E3\u8FDE\u7EED\u70B9\u51FB\u663E\u793A\u7684\u6B21\u6570\u53EF\u4EE5\u81EA\u5B9A\u4E49\uFF0C\u9ED8\u8BA4\u4E3A\u4E09\u6B21",
          ["\u7A97\u53E3\u5FEB\u6377\u952E\u5217\u8868\uFF1A", "ctrl + o : \u9690\u85CF/\u6253\u5F00 \u9762\u677F"]
        ]).outerHTML
      },
      x: { defaultValue: window.innerWidth * 0.1 },
      y: { defaultValue: window.innerWidth * 0.1 },
      visual: { defaultValue: "normal" },
      firstCloseAlert: {
        defaultValue: true
      },
      fontsize: {
        label: "\u5B57\u4F53\u5927\u5C0F\uFF08\u50CF\u7D20\uFF09",
        attrs: { type: "number", min: 12, max: 24, step: 1 },
        defaultValue: 14
      },
      switchPoint: {
        label: "\u7A97\u53E3\u663E\u793A\u8FDE\u70B9\uFF08\u6B21\u6570\uFF09",
        attrs: {
          type: "number",
          min: 3,
          max: 10,
          step: 1,
          title: "\u8BBE\u7F6E\u5F53\u8FDE\u7EED\u70B9\u51FB\u5C4F\u5E55 N \u6B21\u65F6\uFF0C\u53EF\u4EE5\u8FDB\u884C\u9762\u677F\u7684 \u9690\u85CF/\u663E\u793A \u5207\u6362\uFF0C\u9ED8\u8BA4\u8FDE\u7EED\u70B9\u51FB\u5C4F\u5E55\u4E09\u4E0B"
        },
        defaultValue: 3
      }
    },
    methods() {
      return {
        pin: (script2) => start_1.$win === null || start_1.$win === void 0 ? void 0 : start_1.$win.pin(script2),
        minimize: () => start_1.$win === null || start_1.$win === void 0 ? void 0 : start_1.$win.minimize(),
        setPosition: (x, y) => {
          if (start_1.$win) {
            start_1.$win.config.store.setPosition(x, y);
            start_1.$win.container.style.left = x + "px";
            start_1.$win.container.style.top = y + "px";
          }
        },
        normal: () => {
          start_1.$win === null || start_1.$win === void 0 ? void 0 : start_1.$win.normal();
        }
      };
    },
    onrender({ panel }) {
      const closeBtn = (0, dom_12.h)("button", { className: "base-style-button" }, "\u9690\u85CF\u7A97\u53E3");
      closeBtn.onclick = () => {
        if (this.cfg.firstCloseAlert) {
          exports.$modal.confirm({
            content: ui_12.$ui.notes([
              "\u9690\u85CF\u811A\u672C\u9875\u9762\u540E\uFF0C\u5FEB\u901F\u70B9\u51FB\u9875\u9762\u4E09\u4E0B\uFF08\u53EF\u4EE5\u5728\u60AC\u6D6E\u7A97\u8BBE\u7F6E\u4E2D\u8C03\u6574\u6B21\u6570\uFF09\u5373\u53EF\u91CD\u65B0\u663E\u793A\u811A\u672C\u3002\u5982\u679C\u4E09\u4E0B\u65E0\u6548\uFF0C\u53EF\u4EE5\u5C1D\u8BD5\u5220\u9664\u811A\u672C\u91CD\u65B0\u5B89\u88C5\u3002",
              "\u8BF7\u786E\u8BA4\u662F\u5426\u5173\u95ED\u3002\uFF08\u6B64\u540E\u4E0D\u518D\u663E\u793A\u6B64\u5F39\u7A97\uFF09"
            ]),
            onConfirm: () => {
              this.cfg.visual = "close";
              this.cfg.firstCloseAlert = false;
            }
          });
        } else {
          this.cfg.visual = "close";
        }
      };
      panel.body.replaceChildren((0, dom_12.h)("hr"), closeBtn);
    }
  });
  exports.createRenderScript = createRenderScript;
  function _modal(type, attrs, parent) {
    if (self === top) {
      return (0, custom_window_1.modal)(type, attrs, parent);
    } else {
      interfaces_1.cors.emit("modal", [type, attrs], (args) => {
        var _a, _b, _c;
        if (args) {
          (_a = attrs.onConfirm) === null || _a === void 0 ? void 0 : _a.call(attrs, args);
        } else {
          (_b = attrs.onCancel) === null || _b === void 0 ? void 0 : _b.call(attrs);
        }
        (_c = attrs.onClose) === null || _c === void 0 ? void 0 : _c.call(attrs, args);
      });
    }
  }
  exports.$modal = {
    confirm: (attrs, parent) => _modal("confirm", attrs, parent),
    alert: (attrs, parent) => _modal("alert", attrs, parent),
    prompt: (attrs, parent) => _modal("prompt", attrs, parent),
    simple: (attrs, parent) => _modal("simple", attrs, parent)
  };
  function _message(type, attrs) {
    if (self === top) {
      return start_1.$win === null || start_1.$win === void 0 ? void 0 : start_1.$win.message(type, attrs);
    } else {
      if (typeof attrs === "string") {
        attrs = { content: attrs };
      } else if (typeof attrs.content !== "string") {
        attrs.content = attrs.content.innerHTML;
      }
      interfaces_1.cors.emit("message", [type, attrs]);
    }
  }
  exports.$message = {
    info: (attrs) => _message("info", attrs),
    success: (attrs) => _message("success", attrs),
    warn: (attrs) => _message("warn", attrs),
    error: (attrs) => _message("error", attrs)
  };
  function $menu(label, config2) {
    if (self !== top) {
      return;
    }
    return start_1.$win === null || start_1.$win === void 0 ? void 0 : start_1.$win.menu(label, config2);
  }
  exports.$menu = $menu;
})(render);
(function(exports) {
  var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === void 0)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === void 0)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.start = void 0;
  var start_1 = requireStart();
  Object.defineProperty(exports, "start", { enumerable: true, get: function() {
    return start_1.start;
  } });
  __exportStar(utils, exports);
  __exportStar(render, exports);
  __exportStar(elements, exports);
  __exportStar(interfaces, exports);
})(lib);
export {
  lib as l
};
