import { l as lang, I as Icon, t as getRemoteInfos, u as resourceLoader, r as remote, v as child_process, s as store, w as electron } from "./index.c87a5b08.js";
import { a as Message } from "./@arco-design.3c56df6b.js";
import { e as defineComponent, r as ref, a as reactive, aa as onActivated, p as createElementBlock, n as createBaseVNode, $ as unref, v as createVNode, m as withCtx, l as createBlock, s as createCommentVNode, F as Fragment, P as renderList, j as resolveComponent, k as openBlock, y as createTextVNode, z as toDisplayString } from "./@vue.10d2ded6.js";
import "./vue-router.1b6385d9.js";
import "./lodash.4ddd9dd3.js";
import "./@babel.dac5e1c0.js";
import "./dayjs.a79bd2ae.js";
import "./video.js.be22f6f6.js";
import "./global.dfc622c4.js";
import "./@videojs.e887769e.js";
import "./is-function.1b723eb5.js";
import "./videojs-vtt.js.a6c4ef9e.js";
import "./m3u8-parser.427a5d14.js";
import "./mpd-parser.9d338e3c.js";
import "./@xmldom.63d5d2ec.js";
import "./mux.js.f617263a.js";
import "./markdown-it.a39105cb.js";
import "./entities.9efde8b5.js";
import "./uc.micro.428571ea.js";
import "./mdurl.b48c0e08.js";
import "./linkify-it.91515adc.js";
import "./punycode.768648d9.js";
import "./markdown-it-emoji.14324b8a.js";
import "./markdown-it-container.9b7103eb.js";
import "./axios.1e37c3a4.js";
import "./events.7cc16d47.js";
import "./colorpicker-v3.2c723672.js";
import "./xterm.9fe37c82.js";
import "./xterm-addon-fit.1029e58f.js";
/* empty css                         */import "./resize-observer-polyfill.375322e1.js";
import "./compute-scroll-into-view.079a5c71.js";
import "./b-tween.3dc4e04f.js";
import "./number-precision.a111f450.js";
import "./scroll-into-view-if-needed.10a505ff.js";
import "./b-validate.edd52b51.js";
const _hoisted_1 = { class: "p-3" };
const _hoisted_2 = ["innerHTML"];
const _hoisted_3 = ["innerHTML"];
const _hoisted_4 = { class: "mb-2" };
const _hoisted_5 = { style: { "flex": "0 0 48px" } };
const _hoisted_6 = ["src"];
const _hoisted_7 = {
  key: 1,
  class: "d-flex align-items-center"
};
const _hoisted_8 = { style: { "flex": "1 1 auto" } };
const _hoisted_9 = ["href"];
const _hoisted_10 = { key: 1 };
const _hoisted_11 = { key: 2 };
const _hoisted_12 = {
  key: 0,
  style: { "flex": "0 0 64px" },
  class: "d-flex justify-content-center"
};
const _hoisted_13 = { key: 1 };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  setup(__props) {
    const { ipcRenderer } = electron;
    const resourceGroups = ref([]);
    const fileStatus = reactive({});
    const downloadingExtensionsFiles = ref([]);
    const state = reactive({
      loading: true,
      modal: {
        other_extensions_add: false
      }
    });
    onActivated(() => {
      state.loading = true;
      getRemoteInfos().then(async (result) => {
        resourceGroups.value = result.resourceGroups.filter((g) => g.showInResourcePage);
        for (const group of result.resourceGroups) {
          for (const file of group.files) {
            fileStatus[file.url] = {
              exists: resourceLoader.isZipFile(file) ? await resourceLoader.isZipFileExists(group.name, file) : await resourceLoader.isExists(group.name, file),
              downloading: false,
              unzipping: false,
              downloadRate: 0
            };
          }
        }
      }).catch((err) => {
        Message.error("\u52A0\u8F7D\u8D44\u6E90\u5931\u8D25 " + err.message);
      }).finally(() => {
        state.loading = false;
      });
    });
    async function download(group_name, file) {
      if (group_name === "extensions") {
        const group = resourceGroups.value.filter((g) => g.name === "extensions");
        if (group[0].files.some((f) => fileStatus[f.url].exists)) {
          Message.warning("\u811A\u672C\u7BA1\u7406\u5668\u53EA\u80FD\u5B89\u88C5\u4E00\u4E2A\u3002\u5982\u9700\u5207\u6362\u8BF7\u628A\u53E6\u5916\u7684\u5220\u9664\u540E\u518D\u5B89\u88C5\u3002");
          return;
        }
        downloadingExtensionsFiles.value.push(file);
      }
      try {
        const files = await resourceLoader.list();
        for (const localFile of files) {
          if (localFile.filename.startsWith(file.id) && localFile.filename.replace(file.id, "").trim() !== "") {
            await remote.fs.call("rmSync", localFile.path, {
              recursive: true
            });
          }
        }
        const listener = (e, channel, rate) => {
          fileStatus[file.url].downloadRate = rate;
        };
        ipcRenderer.on("download", listener);
        try {
          fileStatus[file.url].downloading = true;
          await resourceLoader.download(group_name, file);
          fileStatus[file.url].downloading = false;
          fileStatus[file.url].downloadRate = 0;
          if (resourceLoader.isZipFile(file)) {
            fileStatus[file.url].unzipping = true;
            Message.info(`\u6B63\u5728\u89E3\u538B\uFF1A${file.name}`);
            await resourceLoader.unzip(group_name, file);
            fileStatus[file.url].unzipping = false;
          }
          fileStatus[file.url].exists = true;
        } catch (err) {
          Message.error("\u4E0B\u8F7D\u9519\u8BEF " + err.message);
        }
        Message.success(`${file.name} \u4E0B\u8F7D\u5B8C\u6210`);
        ipcRenderer.removeListener("download", listener);
      } catch (err) {
        Message.error("\u4E0B\u8F7D\u9519\u8BEF " + err.message);
      }
      downloadingExtensionsFiles.value = downloadingExtensionsFiles.value.filter((f) => f.url !== file.url);
    }
    async function remove(group_name, file) {
      try {
        await resourceLoader.remove(group_name, file);
        fileStatus[file.url].exists = false;
      } catch (err) {
        Message.error("\u5220\u9664\u9519\u8BEF " + err.message);
      }
    }
    function openDownloadFolder() {
      if (process.platform === "win32") {
        child_process.exec(`explorer.exe "${store.paths.downloadFolder}"`);
      } else {
        electron.shell.openPath(store.paths.downloadFolder);
      }
    }
    return (_ctx, _cache) => {
      const _component_a_modal = resolveComponent("a-modal");
      const _component_icon_folder = resolveComponent("icon-folder");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_button = resolveComponent("a-button");
      const _component_icon_question_circle = resolveComponent("icon-question-circle");
      const _component_icon_loading = resolveComponent("icon-loading");
      const _component_a_col = resolveComponent("a-col");
      const _component_a_row = resolveComponent("a-row");
      const _component_a_empty = resolveComponent("a-empty");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_a_progress = resolveComponent("a-progress");
      const _component_a_card = resolveComponent("a-card");
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createBaseVNode("div", {
          class: "text-secondary markdown mb-2",
          innerHTML: unref(lang)("notice_resources_page_usage", "")
        }, null, 8, _hoisted_2),
        createVNode(_component_a_modal, {
          visible: state.modal.other_extensions_add,
          "onUpdate:visible": _cache[0] || (_cache[0] = ($event) => state.modal.other_extensions_add = $event),
          title: "\u5176\u4ED6\u62D3\u5C55\u52A0\u8F7D\u65B9\u6CD5",
          footer: false,
          closable: true
        }, {
          default: withCtx(() => [
            createBaseVNode("div", {
              class: "text-secondary mb-2",
              innerHTML: unref(lang)("notice_resources_page_other_extensions_add", "")
            }, null, 8, _hoisted_3)
          ]),
          _: 1
        }, 8, ["visible"]),
        createBaseVNode("div", _hoisted_4, [
          createVNode(_component_a_space, null, {
            default: withCtx(() => [
              createVNode(_component_a_button, {
                size: "mini",
                onClick: openDownloadFolder
              }, {
                default: withCtx(() => [
                  createVNode(_component_a_space, null, {
                    default: withCtx(() => [
                      createVNode(_component_icon_folder),
                      _cache[2] || (_cache[2] = createTextVNode(" \u6253\u5F00\u8D44\u6E90\u6587\u4EF6\u5939 ", -1))
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              }),
              createVNode(_component_a_button, {
                size: "mini",
                onClick: _cache[1] || (_cache[1] = () => state.modal.other_extensions_add = !state.modal.other_extensions_add)
              }, {
                default: withCtx(() => [
                  createVNode(_component_a_space, null, {
                    default: withCtx(() => [
                      createVNode(_component_icon_question_circle),
                      _cache[3] || (_cache[3] = createTextVNode(" \u5982\u4F55\u52A0\u8F7D\u5176\u4ED6\u62D3\u5C55\uFF1F ", -1))
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ]),
            _: 1
          })
        ]),
        state.loading ? (openBlock(), createBlock(_component_a_row, {
          key: 0,
          class: "text-center mt-5"
        }, {
          default: withCtx(() => [
            createVNode(_component_a_col, null, {
              default: withCtx(() => [
                createVNode(_component_icon_loading, { spin: "" }),
                _cache[4] || (_cache[4] = createTextVNode(" \u52A0\u8F7D\u8D44\u6E90\u4E2D... ", -1))
              ]),
              _: 1
            })
          ]),
          _: 1
        })) : resourceGroups.value.length === 0 ? (openBlock(), createBlock(_component_a_empty, {
          key: 1,
          description: "\u6682\u65E0\u8D44\u6E90\uFF0C\u8BF7\u5C1D\u8BD5\u91CD\u542F\u8F6F\u4EF6\u91CD\u65B0\u52A0\u8F7D"
        })) : createCommentVNode("", true),
        (openBlock(true), createElementBlock(Fragment, null, renderList(resourceGroups.value, (group, index) => {
          return openBlock(), createBlock(_component_a_card, {
            key: index,
            title: group.description,
            class: "rounded mb-3"
          }, {
            default: withCtx(() => [
              (openBlock(true), createElementBlock(Fragment, null, renderList(group.files, (file, i) => {
                return openBlock(), createElementBlock("div", {
                  key: i,
                  class: "d-flex mb-2 align-items-center"
                }, [
                  createBaseVNode("div", _hoisted_5, [
                    file.icon ? (openBlock(), createElementBlock("img", {
                      key: 0,
                      width: "32",
                      height: "32",
                      src: file.icon
                    }, null, 8, _hoisted_6)) : (openBlock(), createElementBlock("div", _hoisted_7, [
                      createVNode(Icon, {
                        class: "fs-1",
                        type: "grid_4x4"
                      })
                    ]))
                  ]),
                  createBaseVNode("div", _hoisted_8, [
                    createVNode(_component_a_space, null, {
                      default: withCtx(() => [
                        file.homepage ? (openBlock(), createElementBlock("a", {
                          key: 0,
                          href: file.homepage,
                          target: "_blank"
                        }, toDisplayString(file.name), 9, _hoisted_9)) : (openBlock(), createElementBlock("span", _hoisted_10, toDisplayString(file.name), 1)),
                        file.description ? (openBlock(), createElementBlock("span", _hoisted_11, [
                          file.description.length > 50 ? (openBlock(), createBlock(_component_a_tooltip, {
                            key: 0,
                            content: file.description
                          }, {
                            default: withCtx(() => [
                              createBaseVNode("span", null, toDisplayString(file.description.slice(0, 50)) + "...", 1)
                            ]),
                            _: 2
                          }, 1032, ["content"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                            createTextVNode(toDisplayString(file.description), 1)
                          ], 64))
                        ])) : createCommentVNode("", true)
                      ]),
                      _: 2
                    }, 1024)
                  ]),
                  fileStatus[file.url] ? (openBlock(), createElementBlock("div", _hoisted_12, [
                    createVNode(_component_a_space, null, {
                      default: withCtx(() => [
                        fileStatus[file.url].exists || fileStatus[file.url].downloadRate === 100 ? (openBlock(), createBlock(_component_a_button, {
                          key: 0,
                          size: "medium",
                          type: "outline",
                          status: "danger",
                          onClick: ($event) => remove(group.name, file)
                        }, {
                          default: withCtx(() => [..._cache[5] || (_cache[5] = [
                            createTextVNode(" \u5378\u8F7D ", -1)
                          ])]),
                          _: 1
                        }, 8, ["onClick"])) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                          fileStatus[file.url].downloadRate !== 0 ? (openBlock(), createBlock(_component_a_progress, {
                            key: 0,
                            size: "mini",
                            status: "normal",
                            percent: fileStatus[file.url].downloadRate
                          }, null, 8, ["percent"])) : fileStatus[file.url].unzipping ? (openBlock(), createElementBlock("span", _hoisted_13, " \u89E3\u538B\u4E2D... ")) : (openBlock(), createBlock(_component_a_button, {
                            key: 2,
                            disabled: group.name === "extensions" && downloadingExtensionsFiles.value.length !== 0,
                            size: "medium",
                            type: "outline",
                            onClick: ($event) => download(group.name, file)
                          }, {
                            default: withCtx(() => [..._cache[6] || (_cache[6] = [
                              createTextVNode(" \u5B89\u88C5 ", -1)
                            ])]),
                            _: 1
                          }, 8, ["disabled", "onClick"]))
                        ], 64))
                      ]),
                      _: 2
                    }, 1024)
                  ])) : createCommentVNode("", true)
                ]);
              }), 128))
            ]),
            _: 2
          }, 1032, ["title"]);
        }), 128))
      ]);
    };
  }
});
export {
  _sfc_main as default
};
