import { e as defineComponent, t as toRefs, p as createElementBlock, n as createBaseVNode, $ as unref, z as toDisplayString, s as createCommentVNode, x as renderSlot, k as openBlock, j as resolveComponent, l as createBlock, m as withCtx, v as createVNode, y as createTextVNode, u as normalizeClass, r as ref, o as onMounted, H as withModifiers, a as reactive, P as renderList, F as Fragment, w as watch, C as nextTick, aa as onActivated, K as onDeactivated, M as withDirectives, N as vShow } from "./@vue.10d2ded6.js";
import { _ as _export_sfc, s as store, r as remote, I as Icon, w as electron, l as lang, x as processes, y as forceClearBrowserCache, z as changeTheme, F as Folder } from "./index.c87a5b08.js";
import { M as Modal, a as Message } from "./@arco-design.3c56df6b.js";
import { l as lib } from "./easy-us.d8908933.js";
import "./vue-router.1b6385d9.js";
import "./lodash.4ddd9dd3.js";
import "./@babel.dac5e1c0.js";
import "./dayjs.a79bd2ae.js";
import "./video.js.be22f6f6.js";
import "./global.dfc622c4.js";
import "./@videojs.e887769e.js";
import "./is-function.1b723eb5.js";
import "./videojs-vtt.js.a6c4ef9e.js";
import "./m3u8-parser.427a5d14.js";
import "./mpd-parser.9d338e3c.js";
import "./@xmldom.63d5d2ec.js";
import "./mux.js.f617263a.js";
import "./markdown-it.a39105cb.js";
import "./entities.9efde8b5.js";
import "./uc.micro.428571ea.js";
import "./mdurl.b48c0e08.js";
import "./linkify-it.91515adc.js";
import "./punycode.768648d9.js";
import "./markdown-it-emoji.14324b8a.js";
import "./markdown-it-container.9b7103eb.js";
import "./axios.1e37c3a4.js";
import "./events.7cc16d47.js";
import "./colorpicker-v3.2c723672.js";
import "./xterm.9fe37c82.js";
import "./xterm-addon-fit.1029e58f.js";
/* empty css                         */import "./resize-observer-polyfill.375322e1.js";
import "./compute-scroll-into-view.079a5c71.js";
import "./b-tween.3dc4e04f.js";
import "./number-precision.a111f450.js";
import "./scroll-into-view-if-needed.10a505ff.js";
import "./b-validate.edd52b51.js";
const _hoisted_1$3 = { class: "text-start" };
const _hoisted_2$2 = { class: "rounded pt-1" };
const _hoisted_3$2 = {
  key: 0,
  class: "mb-2 title fw-bold border-bottom"
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "Card",
  props: {
    title: { default: "" },
    badge: { default: "gray" }
  },
  setup(__props) {
    const props = __props;
    const { title } = toRefs(props);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$3, [
        createBaseVNode("div", _hoisted_2$2, [
          unref(title) ? (openBlock(), createElementBlock("p", _hoisted_3$2, toDisplayString(unref(title)), 1)) : createCommentVNode("", true),
          renderSlot(_ctx.$slots, "default", {}, void 0, true)
        ])
      ]);
    };
  }
});
const Card_vue_vue_type_style_index_0_scoped_0a350798_lang = "";
const Card = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["__scopeId", "data-v-0a350798"]]);
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "Description",
  props: {
    label: {},
    desc: { default: "" },
    textClass: { default: "" }
  },
  setup(__props) {
    const props = __props;
    const { label, desc, textClass } = toRefs(props);
    return (_ctx, _cache) => {
      const _component_a_col = resolveComponent("a-col");
      const _component_a_row = resolveComponent("a-row");
      return openBlock(), createBlock(_component_a_row, { class: "row flex-nowrap mb-2" }, {
        default: withCtx(() => [
          createVNode(_component_a_col, {
            flex: "160px",
            class: "desc-label"
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString(unref(label)) + " : ", 1)
            ]),
            _: 1
          }),
          createVNode(_component_a_col, {
            flex: "auto",
            class: "d-inline-flex align-items-center"
          }, {
            default: withCtx(() => [
              unref(desc) ? (openBlock(), createElementBlock("span", {
                key: 0,
                class: normalizeClass(["desc", unref(textClass)])
              }, toDisplayString(String(unref(desc))), 3)) : createCommentVNode("", true),
              renderSlot(_ctx.$slots, "default", {}, void 0, true)
            ]),
            _: 3
          })
        ]),
        _: 3
      });
    };
  }
});
const Description_vue_vue_type_style_index_0_scoped_bb42927b_lang = "";
const Description = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["__scopeId", "data-v-bb42927b"]]);
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "Path",
  props: {
    name: {},
    label: {},
    setting: { type: Boolean, default: false }
  },
  emits: ["onPathChange"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emits = __emit;
    const { label, name, setting } = toRefs(props);
    const { shell } = electron;
    const realPath = ref("");
    onMounted(async () => {
      realPath.value = store.paths[name.value] ? await remote.path.call("resolve", store.paths[name.value]) : "\u65E0";
    });
    async function change(name2) {
      if (setting.value) {
        const res = await remote.dialog.call("showOpenDialogSync", {
          properties: ["openDirectory"],
          defaultPath: realPath.value
        });
        if (res) {
          const original = store.paths[name2];
          realPath.value = res[0];
          store.paths[name2] = res[0];
          emits("onPathChange", original, res[0]);
        }
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", null, [
        createVNode(Description, {
          label: unref(label),
          desc: realPath.value,
          "text-class": "pointer",
          onClick: _cache[1] || (_cache[1] = ($event) => unref(shell).showItemInFolder(realPath.value))
        }, {
          default: withCtx(() => [
            unref(setting) ? (openBlock(), createBlock(Icon, {
              key: 0,
              class: "ms-3",
              type: "settings",
              onClick: _cache[0] || (_cache[0] = withModifiers(($event) => change(unref(name)), ["stop"]))
            })) : createCommentVNode("", true)
          ]),
          _: 1
        }, 8, ["label", "desc"])
      ]);
    };
  }
});
const _hoisted_1$2 = { class: "d-flex align-items-center flex-wrap gap-2 w-100" };
const _hoisted_2$1 = ["innerHTML"];
const _hoisted_3$1 = { class: "d-flex align-items-center w-100" };
const _hoisted_4$1 = {
  key: 1,
  class: "w-100"
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BrowserPath",
  setup(__props) {
    const state = reactive({
      validBrowsers: [],
      tempExecutablePath: store.render.setting.launchOptions.executablePath || ""
    });
    onMounted(async () => {
      state.validBrowsers = await remote.methods.call("getValidBrowsers");
      console.log(state.validBrowsers);
    });
    async function onDiy(new_path) {
      if (new_path) {
        if (new_path === store.render.setting.launchOptions.executablePath) {
          return;
        }
        if (processes.length) {
          return Modal.warning({
            title: "\u8B66\u544A",
            content: "\u68C0\u6D4B\u5230\u6709\u6D4F\u89C8\u5668\u6B63\u5728\u8FD0\u884C\uFF0C\u8BF7\u5148\u5173\u95ED\u6240\u6709\u6D4F\u89C8\u5668\uFF0C\u5426\u5219\u65E0\u6CD5\u4FEE\u6539\u6D4F\u89C8\u5668\u8DEF\u5F84\u3002",
            okText: "\u6211\u77E5\u9053\u4E86"
          });
        }
        state.tempExecutablePath = new_path.trim();
        store.render.setting.launchOptions.executablePath = new_path.trim();
        const exists = await remote.fs.call("existsSync", new_path.trim());
        if (!exists) {
          Message.error("\u6D4F\u89C8\u5668\u8DEF\u5F84\u4E0D\u5B58\u5728, \u8BF7\u70B9\u51FB\u53F3\u4FA7\u6309\u94AE\u67E5\u770B\u6559\u7A0B\u3002");
        } else {
          try {
            await forceClearBrowserCache(
              "\u68C0\u6D4B\u5230\u60A8\u66F4\u6362\u6D4F\u89C8\u5668\u8DEF\u5F84\uFF0C\u6B63\u5728\u5220\u9664\u5168\u90E8\u6D4F\u89C8\u5668\u7F13\u5B58\uFF0C\u5426\u5219\u65E0\u6CD5\u8FD0\u884C...",
              store.paths.userDataDirsFolder
            );
          } catch (e) {
            console.error(e);
          }
          Message.success("\u914D\u7F6E\u6D4F\u89C8\u5668\u8DEF\u5F84\u6210\u529F");
        }
      }
    }
    return (_ctx, _cache) => {
      const _component_a_switch = resolveComponent("a-switch");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_icon_down = resolveComponent("icon-down");
      const _component_a_button = resolveComponent("a-button");
      const _component_a_popover = resolveComponent("a-popover");
      const _component_a_input = resolveComponent("a-input");
      const _component_a_doption = resolveComponent("a-doption");
      const _component_a_dropdown = resolveComponent("a-dropdown");
      return openBlock(), createBlock(Description, { label: "\u6D4F\u89C8\u5668\u8DEF\u5F84" }, {
        default: withCtx(() => [
          createBaseVNode("div", _hoisted_1$2, [
            createBaseVNode("div", null, [
              createVNode(_component_a_tooltip, { position: "rt" }, {
                content: withCtx(() => [
                  createBaseVNode("div", {
                    innerHTML: unref(lang)("setting_browser_path_custom_tip", "")
                  }, null, 8, _hoisted_2$1)
                ]),
                default: withCtx(() => [
                  createVNode(_component_a_switch, {
                    modelValue: unref(store).render.setting.launchOptions.custom,
                    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => unref(store).render.setting.launchOptions.custom = $event),
                    style: { "width": "84px" }
                  }, {
                    checked: withCtx(() => [..._cache[2] || (_cache[2] = [
                      createTextVNode("\u81EA\u5B9A\u4E49", -1)
                    ])]),
                    unchecked: withCtx(() => [..._cache[3] || (_cache[3] = [
                      createTextVNode("\u81EA\u5B9A\u4E49", -1)
                    ])]),
                    _: 1
                  }, 8, ["modelValue"])
                ]),
                _: 1
              })
            ]),
            unref(store).render.setting.launchOptions.custom ? (openBlock(), createBlock(_component_a_dropdown, {
              key: 0,
              trigger: "hover",
              position: "bl"
            }, {
              content: withCtx(() => [
                (openBlock(true), createElementBlock(Fragment, null, renderList(state.validBrowsers, (item) => {
                  return openBlock(), createBlock(_component_a_doption, {
                    key: item.path,
                    onClick: () => onDiy(item.path)
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(item.name) + toDisplayString(item.path === state.tempExecutablePath ? " (\u5F53\u524D)" : ""), 1)
                    ]),
                    _: 2
                  }, 1032, ["onClick"]);
                }), 128))
              ]),
              default: withCtx(() => [
                createBaseVNode("span", _hoisted_3$1, [
                  createVNode(_component_a_button, {
                    class: "me-1",
                    size: "small"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(state.validBrowsers.length) + " \u4E2A\u53EF\u7528\u8DEF\u5F84 ", 1),
                      createVNode(_component_icon_down)
                    ]),
                    _: 1
                  }),
                  createVNode(_component_a_input, {
                    modelValue: state.tempExecutablePath,
                    "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => state.tempExecutablePath = $event),
                    size: "small",
                    placeholder: "\u8F93\u5165\u60A8\u7684\u6D4F\u89C8\u5668\u8DEF\u5F84\uFF0C\u5426\u5219\u65E0\u6CD5\u6B63\u5E38\u542F\u52A8\uFF0C\u8DEF\u5F84\u83B7\u53D6\u6559\u7A0B\u70B9\u51FB\u53F3\u4FA7\u95EE\u53F7\u67E5\u770B\u3002",
                    class: "w-100",
                    onChange: onDiy
                  }, {
                    suffix: withCtx(() => [
                      createVNode(_component_a_popover, null, {
                        title: withCtx(() => [..._cache[4] || (_cache[4] = [
                          createBaseVNode("b", null, "\u6D4F\u89C8\u5668\u8DEF\u5F84\u83B7\u53D6\u65B9\u5F0F", -1)
                        ])]),
                        content: withCtx(() => [..._cache[5] || (_cache[5] = [
                          createBaseVNode("div", null, [
                            createBaseVNode("b", null, "- \u8C37\u6B4C\u6D4F\u89C8\u5668"),
                            createTextVNode(" : \u6253\u5F00\u8C37\u6B4C\u6D4F\u89C8\u5668 "),
                            createBaseVNode("br"),
                            createTextVNode(" \u5728\u5730\u5740\u680F\u8F93\u5165 "),
                            createBaseVNode("b", null, "chrome://version"),
                            createTextVNode(" \u5E76\u56DE\u8F66\uFF0C \u627E\u5230 "),
                            createBaseVNode("b", null, "\u53EF\u6267\u884C\u6587\u4EF6\u8DEF\u5F84"),
                            createTextVNode(" \u590D\u5236\u7C98\u8D34\u5373\u53EF ")
                          ], -1),
                          createBaseVNode("div", null, [
                            createBaseVNode("b", null, "- Edge\u6D4F\u89C8\u5668"),
                            createTextVNode(" : \u6253\u5F00Edge\u6D4F\u89C8\u5668"),
                            createBaseVNode("br"),
                            createTextVNode(" \u5728\u5730\u5740\u680F\u8F93\u5165 "),
                            createBaseVNode("b", null, "edge://version"),
                            createTextVNode(" \u5E76\u56DE\u8F66\uFF0C \u627E\u5230 "),
                            createBaseVNode("b", null, "\u53EF\u6267\u884C\u6587\u4EF6\u8DEF\u5F84"),
                            createTextVNode(" \u590D\u5236\u7C98\u8D34\u5373\u53EF ")
                          ], -1)
                        ])]),
                        default: withCtx(() => [
                          createVNode(Icon, {
                            type: "help_outline",
                            style: { "cursor": "pointer" }
                          })
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  }, 8, ["modelValue"])
                ])
              ]),
              _: 1
            })) : (openBlock(), createElementBlock("div", _hoisted_4$1, [
              createVNode(_component_a_input, {
                "default-value": state.tempExecutablePath,
                disabled: "",
                size: "small",
                class: "w-100"
              }, null, 8, ["default-value"])
            ]))
          ])
        ]),
        _: 1
      });
    };
  }
});
const _hoisted_1$1 = { class: "h-100" };
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "OCSConfigs",
  props: {
    store: {}
  },
  emits: ["update:store", "update:project", "loading", "loaded", "error"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const store$1 = ref(props.store);
    const emits = __emit;
    const state = reactive({
      css: "",
      loading: false,
      err: "",
      projects: [],
      watchStopHandle: void 0
    });
    watch(
      () => [store.render.setting.ocs.currentProjectName],
      () => {
        nextTick(renderOCS);
      }
    );
    state.watchStopHandle = watch(store$1, () => {
      emits("update:store", store$1.value);
    });
    const wrapper = lib.h("div");
    const root = wrapper.attachShadow({ mode: "closed" });
    function renderOCS() {
      var _a, _b, _c;
      try {
        const project = state.projects.find((p) => p.name === store.render.setting.ocs.currentProjectName);
        root.replaceChildren();
        loadCustomElements(lib.definedCustomElements);
        root.append(lib.h("style", state.css));
        root.append(lib.h("style", `script-panel-element {box-shadow: none;resize: none;color:#2e2e2e}`));
        if (project) {
          for (const key in project.scripts) {
            if (Object.prototype.hasOwnProperty.call(project.scripts, key)) {
              const script = project.scripts[key];
              script.cfg = Object.keys(script.cfg).length === 0 ? lib.$.createConfigProxy(script) : script.cfg;
              const { notes, ...otherConfigs } = script.configs || {};
              if (script.namespace && Object.keys(otherConfigs).filter((k) => otherConfigs[k].label !== void 0).length && script.hideInPanel !== false) {
                const panel = lib.$ui.scriptPanel(script, lib.$store);
                root.append(panel);
                try {
                  (_b = (_a = script.onrender) == null ? void 0 : _a.call(script, { panel, header: lib.h("header-element") })) == null ? void 0 : _b.catch((err) => {
                    console.error(err);
                  });
                } catch (err) {
                  console.error(err);
                }
              }
            }
          }
          (_c = document.querySelector("#ocs-browser-configs")) == null ? void 0 : _c.replaceChildren(wrapper);
        }
      } catch (err) {
        state.err = String(err);
        console.error(err);
        emits("error", state.err);
      }
    }
    async function loadOCS() {
      state.loading = true;
      emits("loading");
      try {
        if (global.OCS === void 0) {
          const code = await remote.methods.call("get", "https://cdn.ocsjs.com/index.js");
          await remote.webContents.call("executeJavaScript", code);
        }
        if (state.css === "") {
          state.css = await remote.methods.call("get", "https://cdn.ocsjs.com/style.css");
        }
        const OCS = global.OCS;
        OCS.$elements.root = root;
        lib.$elements.root = root;
        console.log(OCS);
        lib.MemoryStoreProvider._source.store = store$1.value;
        state.projects = OCS.definedProjects();
        emits("update:project", state.projects);
        if (!store.render.setting.ocs.currentProjectName) {
          store.render.setting.ocs.currentProjectName = state.projects[0].name;
        }
      } catch (err) {
        state.err = String(err);
        console.error(err);
        emits("error", state.err);
      }
      state.loading = false;
      emits("loaded");
    }
    onMounted(() => {
      nextTick(async () => {
        await loadOCS();
        renderOCS();
      });
    });
    onActivated(() => {
      nextTick(async () => {
        await loadOCS();
        renderOCS();
      });
    });
    onDeactivated(() => {
      var _a;
      (_a = state.watchStopHandle) == null ? void 0 : _a.call(state);
    });
    function loadCustomElements(elements) {
      for (const element of elements) {
        const name = resolveCustomElementName(element, "-");
        if (customElements.get(name) === void 0) {
          customElements.define(name, element);
        }
      }
    }
    function resolveCustomElementName(el, target) {
      return el.name.replace(/([A-Z])/g, target + "$1").toLowerCase().split(target).slice(1).join(target);
    }
    return (_ctx, _cache) => {
      const _component_a_radio = resolveComponent("a-radio");
      const _component_a_radio_group = resolveComponent("a-radio-group");
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        createVNode(_component_a_radio_group, {
          modelValue: unref(store).render.setting.ocs.currentProjectName,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => unref(store).render.setting.ocs.currentProjectName = $event),
          type: "button"
        }, {
          default: withCtx(() => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(state.projects, (project) => {
              return openBlock(), createBlock(_component_a_radio, {
                key: project.name,
                value: project.name
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(project.name), 1)
                ]),
                _: 2
              }, 1032, ["value"]);
            }), 128))
          ]),
          _: 1
        }, 8, ["modelValue"]),
        _cache[1] || (_cache[1] = createBaseVNode("div", {
          id: "ocs-browser-configs",
          class: "mt-3"
        }, null, -1))
      ]);
    };
  }
});
const OCSConfigs_vue_vue_type_style_index_0_scoped_4ee3d969_lang = "";
const OCSConfigs = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-4ee3d969"]]);
const _hoisted_1 = { class: "w-100" };
const _hoisted_2 = { class: "setting text-center p-2 col-12 col-lg-10" };
const _hoisted_3 = ["title"];
const _hoisted_4 = {
  id: "ocs-global-configs",
  class: "m-2"
};
const _hoisted_5 = { class: "mt-4" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  setup(__props) {
    const state = reactive({
      loading: false,
      err: "",
      show: false
    });
    async function reset() {
      store.version = void 0;
      remote.app.call("relaunch");
      remote.app.call("exit", 0);
    }
    async function onUserDataDirsFolderChange(previous, current) {
      const browsers = Folder.from(store.render.browser.root.uid).findAll((e) => e.type === "browser");
      if (browsers.length > 0) {
        for (const browser of browsers) {
          browser.cachePath = await remote.path.call("join", current, browser.uid);
        }
      }
      await forceClearBrowserCache("\u68C0\u6D4B\u5230\u6D4F\u89C8\u5668\u7F13\u5B58\u8DEF\u5F84\uFF0C\u6B63\u5728\u6E05\u7A7A\u4E4B\u524D\u7684\u7F13\u5B58\u6570\u636E...", previous);
    }
    function onChangeEncryption() {
      if (store.app.data_encryption) {
        Modal.info({
          title: "\u63D0\u793A",
          content: "\u6570\u636E\u52A0\u5BC6\u529F\u80FD\u9700\u8981\u91CD\u542F\u8F6F\u4EF6\u624D\u80FD\u751F\u6548"
        });
      }
    }
    return (_ctx, _cache) => {
      const _component_icon_loading = resolveComponent("icon-loading");
      const _component_a_switch = resolveComponent("a-switch");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_a_divider = resolveComponent("a-divider");
      const _component_a_button = resolveComponent("a-button");
      const _component_a_modal = resolveComponent("a-modal");
      const _component_a_popover = resolveComponent("a-popover");
      const _component_a_input_number = resolveComponent("a-input-number");
      const _component_a_popconfirm = resolveComponent("a-popconfirm");
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createBaseVNode("div", _hoisted_2, [
          createVNode(Card, { title: "\u901A\u7528\u8BBE\u7F6E" }, {
            default: withCtx(() => [
              createVNode(_sfc_main$2),
              createVNode(Description, { label: "OCS\u914D\u7F6E" }, {
                default: withCtx(() => [
                  withDirectives(createBaseVNode("div", {
                    style: { "color": "red" },
                    title: state.err
                  }, " \u89E3\u6790\u9519\u8BEF\uFF01\uFF0C\u8BF7\u5C1D\u8BD5\u91CD\u542F\u8F6F\u4EF6 ", 8, _hoisted_3), [
                    [vShow, state.loading === false && state.err !== ""]
                  ]),
                  withDirectives(createBaseVNode("div", null, [
                    createVNode(_component_icon_loading),
                    _cache[16] || (_cache[16] = createTextVNode(" \u6B63\u5728\u83B7\u53D6\u6700\u65B0OCS\u914D\u7F6E", -1))
                  ], 512), [
                    [vShow, state.loading === true && state.err === ""]
                  ]),
                  createVNode(_component_a_tooltip, {
                    content: unref(lang)("setting_browser_ocs_config_sync_tip", "\u5F00\u542F\u540E\uFF0C\u4FEE\u6539OCS\u914D\u7F6E\u540E\u4F1A\u540C\u6B65\u5230\u5168\u90E8\u7531OCS\u684C\u9762\u7AEF\u542F\u52A8\u7684\u6D4F\u89C8\u5668\u4E2D")
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_a_switch, {
                        modelValue: unref(store).render.setting.ocs.openSync,
                        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => unref(store).render.setting.ocs.openSync = $event)
                      }, {
                        checked: withCtx(() => [..._cache[17] || (_cache[17] = [
                          createTextVNode(" \u540C\u6B65\u914D\u7F6E ", -1)
                        ])]),
                        unchecked: withCtx(() => [..._cache[18] || (_cache[18] = [
                          createTextVNode(" \u540C\u6B65\u914D\u7F6E ", -1)
                        ])]),
                        _: 1
                      }, 8, ["modelValue"])
                    ]),
                    _: 1
                  }, 8, ["content"]),
                  createVNode(_component_a_divider, {
                    class: "mt-2 mb-2",
                    direction: "vertical"
                  }),
                  state.loading === false && state.err === "" ? (openBlock(), createBlock(_component_a_button, {
                    key: 0,
                    onClick: _cache[1] || (_cache[1] = ($event) => state.show = true)
                  }, {
                    default: withCtx(() => [..._cache[19] || (_cache[19] = [
                      createTextVNode(" \u70B9\u51FB\u914D\u7F6E ", -1)
                    ])]),
                    _: 1
                  })) : createCommentVNode("", true),
                  createVNode(_component_a_modal, {
                    visible: state.show,
                    "onUpdate:visible": _cache[6] || (_cache[6] = ($event) => state.show = $event),
                    title: "OCS\u914D\u7F6E",
                    footer: false,
                    width: "auto",
                    "modal-class": "p-0 m-0",
                    "mask-closable": false,
                    "body-style": "padding: 0",
                    onClose: _cache[7] || (_cache[7] = () => {
                      if (unref(store).render.setting.ocs.openSync === false) {
                        unref(Message).info({
                          content: "\u4FEE\u6539\u5168\u5C40\u8BBE\u7F6E\u540E\uFF0C\u5F00\u542F\u53F3\u4FA7\u7684\u540C\u6B65\u529F\u80FD\u624D\u53EF\u751F\u6548\u54E6\u3002",
                          duration: 10 * 1e3
                        });
                      }
                    })
                  }, {
                    default: withCtx(() => [
                      createBaseVNode("div", _hoisted_4, [
                        withDirectives(createVNode(OCSConfigs, {
                          store: unref(store).render.setting.ocs.store,
                          "onUpdate:store": _cache[2] || (_cache[2] = ($event) => unref(store).render.setting.ocs.store = $event),
                          onError: _cache[3] || (_cache[3] = (err) => state.err = err),
                          onLoaded: _cache[4] || (_cache[4] = () => state.loading = false),
                          onLoading: _cache[5] || (_cache[5] = () => state.loading = true)
                        }, null, 8, ["store"]), [
                          [vShow, state.loading === false]
                        ])
                      ])
                    ]),
                    _: 1
                  }, 8, ["visible"])
                ]),
                _: 1
              })
            ]),
            _: 1
          }),
          createVNode(Card, { title: "\u6D4F\u89C8\u5668\u8BBE\u7F6E" }, {
            default: withCtx(() => [
              createVNode(Description, { label: "\u539F\u751F\u5F39\u7A97" }, {
                default: withCtx(() => [
                  createVNode(_component_a_tooltip, { content: "\u542F\u7528\u540E\uFF0C\u6D4F\u89C8\u5668\u4E2D\u7684\u539F\u7248\u5F39\u7A97\u53EF\u80FD\u4F1A\u5F71\u54CD\u811A\u672C\u8FD0\u884C" }, {
                    default: withCtx(() => [
                      createVNode(_component_a_switch, {
                        modelValue: unref(store).render.setting.browser.enableDialog,
                        "onUpdate:modelValue": _cache[8] || (_cache[8] = ($event) => unref(store).render.setting.browser.enableDialog = $event),
                        size: "small"
                      }, null, 8, ["modelValue"])
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              }),
              createVNode(Description, { label: "\u5F3A\u5236\u66F4\u65B0\u811A\u672C" }, {
                default: withCtx(() => [
                  createVNode(_component_a_tooltip, { content: "\u542F\u7528\u540E\uFF0C\u5B89\u88C5\u811A\u672C\u65F6\u679C\u7248\u672C\u6CA1\u6709\u66F4\u65B0\u4F9D\u7136\u4F1A\u5F3A\u5236\u91CD\u65B0\u5B89\u88C5" }, {
                    default: withCtx(() => [
                      createVNode(_component_a_switch, {
                        modelValue: unref(store).render.setting.browser.forceUpdateScript,
                        "onUpdate:modelValue": _cache[9] || (_cache[9] = ($event) => unref(store).render.setting.browser.forceUpdateScript = $event),
                        size: "small"
                      }, null, 8, ["modelValue"])
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ]),
            _: 1
          }),
          createVNode(Card, { title: "\u57FA\u672C\u8BBE\u7F6E" }, {
            default: withCtx(() => [
              createVNode(Description, { label: "\u5F00\u673A\u81EA\u542F" }, {
                default: withCtx(() => [
                  createVNode(_component_a_switch, {
                    modelValue: unref(store).window.autoLaunch,
                    "onUpdate:modelValue": _cache[10] || (_cache[10] = ($event) => unref(store).window.autoLaunch = $event),
                    size: "small"
                  }, null, 8, ["modelValue"])
                ]),
                _: 1
              }),
              createVNode(Description, { label: "\u7A97\u53E3\u7F6E\u9876" }, {
                default: withCtx(() => [
                  createVNode(_component_a_switch, {
                    modelValue: unref(store).window.alwaysOnTop,
                    "onUpdate:modelValue": _cache[11] || (_cache[11] = ($event) => unref(store).window.alwaysOnTop = $event),
                    size: "small"
                  }, null, 8, ["modelValue"])
                ]),
                _: 1
              }),
              createVNode(Description, { label: "\u591C\u95F4\u6A21\u5F0F" }, {
                default: withCtx(() => [
                  createVNode(_component_a_switch, {
                    modelValue: unref(store).render.setting.theme.dark,
                    "onUpdate:modelValue": _cache[12] || (_cache[12] = ($event) => unref(store).render.setting.theme.dark = $event),
                    size: "small",
                    onClick: unref(changeTheme)
                  }, null, 8, ["modelValue", "onClick"])
                ]),
                _: 1
              }),
              createVNode(Description, { label: "\u663E\u793A\u4FA7\u8FB9\u680F\u6587\u5B57" }, {
                default: withCtx(() => [
                  createVNode(_component_a_switch, {
                    modelValue: unref(store).render.setting.showSideBarText,
                    "onUpdate:modelValue": _cache[13] || (_cache[13] = ($event) => unref(store).render.setting.showSideBarText = $event),
                    size: "small",
                    onClick: unref(changeTheme)
                  }, null, 8, ["modelValue", "onClick"])
                ]),
                _: 1
              }),
              createVNode(Description, { label: "\u6570\u636E\u52A0\u5BC6" }, {
                default: withCtx(() => [
                  createVNode(_component_a_tooltip, { content: "\u542F\u7528\u540E\uFF0C\u5BF9\u8F6F\u4EF6\u6570\u636E\uFF08\u6D4F\u89C8\u5668\u8D26\u53F7\u5BC6\u7801\uFF0C\u5907\u6CE8\uFF0C\u6807\u7B7E\u7B49\u4FE1\u606F\uFF09\u8FDB\u884C\u52A0\u5BC6\u5B58\u50A8\uFF0C\u9632\u6B62\u5176\u4ED6\u8F6F\u4EF6\u8BFB\u53D6\u548C\u6570\u636E\u6CC4\u9732\uFF0C\u542F\u7528\u540E\u9700\u8981\u91CD\u542F\u8F6F\u4EF6\u624D\u80FD\u751F\u6548" }, {
                    default: withCtx(() => [
                      createVNode(_component_a_switch, {
                        modelValue: unref(store).app.data_encryption,
                        "onUpdate:modelValue": _cache[14] || (_cache[14] = ($event) => unref(store).app.data_encryption = $event),
                        size: "small",
                        onChange: onChangeEncryption
                      }, null, 8, ["modelValue"])
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ]),
            _: 1
          }),
          createVNode(Card, { title: "\u5176\u4ED6\u8BBE\u7F6E" }, {
            default: withCtx(() => [
              createVNode(Description, { label: "\u6D4F\u89C8\u5668\u7F13\u5B58\u9884\u8B66\u9608\u503C" }, {
                default: withCtx(() => [
                  createVNode(_component_a_input_number, {
                    modelValue: unref(store).render.setting.browser.cachesSizeWarningPoint,
                    "onUpdate:modelValue": _cache[15] || (_cache[15] = ($event) => unref(store).render.setting.browser.cachesSizeWarningPoint = $event),
                    style: { "width": "200px" },
                    size: "small"
                  }, {
                    append: withCtx(() => [..._cache[20] || (_cache[20] = [
                      createTextVNode(" GB ", -1)
                    ])]),
                    suffix: withCtx(() => [
                      createVNode(_component_a_popover, null, {
                        content: withCtx(() => [..._cache[21] || (_cache[21] = [
                          createBaseVNode("div", null, "\u5F53\u524D\u6D4F\u89C8\u5668\u7F13\u5B58\u603B\u5927\u5C0F\u8D85\u8FC7\u6B64\u6570\u5B57\u65F6\u5219\u4F1A\u5F39\u51FA\u8B66\u544A\u5F39\u7A97\u3002", -1),
                          createBaseVNode("div", null, '\u4E5F\u53EF\u5728\u5DE6\u4E0A\u89D2\u5DE5\u5177\u4E2D\u627E\u5230 "\u6E05\u9664\u6D4F\u89C8\u5668\u7F13\u5B58" \u529F\u80FD', -1)
                        ])]),
                        default: withCtx(() => [
                          createVNode(Icon, { type: "help_outline" })
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  }, 8, ["modelValue"])
                ]),
                _: 1
              })
            ]),
            _: 1
          }),
          createVNode(Card, { title: "\u8DEF\u5F84\u8BBE\u7F6E" }, {
            default: withCtx(() => [
              createVNode(_sfc_main$3, {
                label: "\u6D4F\u89C8\u5668\u7F13\u5B58\u8DEF\u5F84",
                name: "userDataDirsFolder",
                setting: true,
                onOnPathChange: onUserDataDirsFolderChange
              }),
              createVNode(_sfc_main$3, {
                label: "\u6587\u4EF6\u4E0B\u8F7D\u8DEF\u5F84",
                name: "downloadFolder"
              }),
              createVNode(_sfc_main$3, {
                label: "\u8F6F\u4EF6\u5B58\u50A8",
                name: "user-data-path"
              }),
              createVNode(_sfc_main$3, {
                label: "\u8F6F\u4EF6\u8DEF\u5F84",
                name: "exe-path"
              })
            ]),
            _: 1
          }),
          createBaseVNode("div", _hoisted_5, [
            createVNode(_component_a_popconfirm, {
              content: "\u786E\u8BA4\u91CD\u7F6E\u60A8\u7684\u8BBE\u7F6E\uFF0C\u5E76\u91CD\u65B0\u542F\u52A8\u8F6F\u4EF6\u5417\uFF1F",
              "ok-text": "\u786E\u8BA4",
              "cancel-text": "\u53D6\u6D88",
              onOk: reset
            }, {
              default: withCtx(() => [
                createVNode(_component_a_button, {
                  size: "small",
                  status: "danger"
                }, {
                  default: withCtx(() => [..._cache[22] || (_cache[22] = [
                    createTextVNode(" \u91CD\u7F6E\u8BBE\u7F6E ", -1)
                  ])]),
                  _: 1
                })
              ]),
              _: 1
            })
          ])
        ])
      ]);
    };
  }
});
const index_vue_vue_type_style_index_0_scoped_2853b7a1_lang = "";
const index = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-2853b7a1"]]);
export {
  index as default
};
