import { e as defineComponent, a as reactive, c as computed, w as watch, aa as onActivated, K as onDeactivated, o as onMounted, p as createElementBlock, n as createBaseVNode, $ as unref, v as createVNode, m as withCtx, l as createBlock, F as Fragment, M as withDirectives, N as vShow, P as renderList, q as normalizeStyle, j as resolveComponent, k as openBlock, y as createTextVNode, z as toDisplayString, s as createCommentVNode } from "./@vue.10d2ded6.js";
import { s as store, x as processes, r as remote, l as lang, e as BrowserOperators, T as Tags, f as Process, _ as _export_sfc } from "./index.c87a5b08.js";
import { _ as _sfc_main$1 } from "./EntityOperator.vue_vue_type_script_setup_true_lang.26d0c230.js";
import { M as Modal } from "./@arco-design.3c56df6b.js";
import "./vue-router.1b6385d9.js";
import "./lodash.4ddd9dd3.js";
import "./@babel.dac5e1c0.js";
import "./dayjs.a79bd2ae.js";
import "./video.js.be22f6f6.js";
import "./global.dfc622c4.js";
import "./@videojs.e887769e.js";
import "./is-function.1b723eb5.js";
import "./videojs-vtt.js.a6c4ef9e.js";
import "./m3u8-parser.427a5d14.js";
import "./mpd-parser.9d338e3c.js";
import "./@xmldom.63d5d2ec.js";
import "./mux.js.f617263a.js";
import "./markdown-it.a39105cb.js";
import "./entities.9efde8b5.js";
import "./uc.micro.428571ea.js";
import "./mdurl.b48c0e08.js";
import "./linkify-it.91515adc.js";
import "./punycode.768648d9.js";
import "./markdown-it-emoji.14324b8a.js";
import "./markdown-it-container.9b7103eb.js";
import "./axios.1e37c3a4.js";
import "./events.7cc16d47.js";
import "./colorpicker-v3.2c723672.js";
import "./xterm.9fe37c82.js";
import "./xterm-addon-fit.1029e58f.js";
/* empty css                         */import "./resize-observer-polyfill.375322e1.js";
import "./compute-scroll-into-view.079a5c71.js";
import "./b-tween.3dc4e04f.js";
import "./number-precision.a111f450.js";
import "./scroll-into-view-if-needed.10a505ff.js";
import "./b-validate.edd52b51.js";
const _hoisted_1 = { class: "col-12 p-2 m-auto" };
const _hoisted_2 = ["innerHTML"];
const _hoisted_3 = { class: "d-flex mb-1 align-items-center" };
const _hoisted_4 = {
  key: 0,
  class: "d-flex",
  style: { "height": "50vh" }
};
const _hoisted_5 = { class: "browser-title" };
const _hoisted_6 = {
  class: "text-secondary",
  style: { "font-size": "12px" }
};
const _hoisted_7 = ["onClick"];
const _hoisted_8 = ["id"];
const _hoisted_9 = { key: 0 };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  setup(__props) {
    const state = reactive({
      show: false,
      loading: false
    });
    const launchedProcesses = computed(() => processes.filter((p) => p.status === "launched"));
    const aspectRatio = [
      [0, "\u9ED8\u8BA4"],
      [4 / 3, "4:3"],
      [16 / 9, "16:9"]
    ].map(
      (i) => ({ selected: i[0] === store.render.dashboard.video.aspectRatio, value: i[0], label: i[1] })
    );
    watch(
      () => launchedProcesses.value.length,
      (curr, pre) => {
        if (launchedProcesses.value.length === 0) {
          state.show = false;
        } else {
          if (state.show && curr > pre) {
            refreshVideo();
          }
        }
      }
    );
    watch(
      () => store.app.video_frame_rate,
      () => {
        Modal.info({
          content: "\u4FEE\u6539\u5E27\u7387\u540E\u8BF7 \u91CD\u542F\u8F6F\u4EF6 \u624D\u53EF\u751F\u6548\u3002"
        });
      }
    );
    watch(() => [store.render.dashboard.video.aspectRatio], refreshVideo);
    watch(
      () => state.show,
      () => {
        state.show ? refreshVideo() : closeVideo();
      }
    );
    onActivated(() => {
      var _a;
      for (const process of launchedProcesses.value) {
        (_a = process.video) == null ? void 0 : _a.play();
      }
    });
    onDeactivated(() => {
      var _a;
      for (const process of launchedProcesses.value) {
        (_a = process.video) == null ? void 0 : _a.pause();
      }
    });
    onMounted(() => {
      setInterval(() => {
        for (const process of processes) {
          mountVideo(process);
        }
      }, 3e3);
    });
    async function closeVideo() {
      var _a;
      for (const process of processes) {
        (_a = process.stream) == null ? void 0 : _a.getTracks().forEach((track) => {
          track.stop();
        });
      }
    }
    async function refreshVideo() {
      try {
        state.loading = true;
        await Promise.all(
          processes.map(
            (process) => new Promise((resolve) => {
              var _a;
              process.once("webrtc-page-loaded", resolve);
              (_a = process.worker) == null ? void 0 : _a.call(process, "gotoWebRTCPage");
            })
          )
        );
        const processStatus = /* @__PURE__ */ new Map();
        for (const process of processes) {
          processStatus.set(process.uid, false);
        }
        let retryCount = 20;
        async function loop() {
          retryCount--;
          console.log("looping", retryCount);
          const sources = await remote.methods.call("captureDesktopScreen");
          console.log("sources", sources);
          await Promise.all(
            processes.filter((p) => processStatus.get(p.uid) === false).map((process) => {
              return new Promise((resolve, reject) => {
                getBrowserVideo(process.uid, sources).then((res) => {
                  var _a;
                  if (!res) {
                    return resolve();
                  }
                  process.stream = res.stream;
                  (_a = process.stream) == null ? void 0 : _a.getTracks().forEach((track) => {
                    var _a2;
                    track.applyConstraints({
                      frameRate: (_a2 = store.app.video_frame_rate) != null ? _a2 : 1,
                      aspectRatio: store.render.dashboard.video.aspectRatio === 0 ? void 0 : store.render.dashboard.video.aspectRatio
                    });
                  });
                  process.video = res.video;
                  mountVideo(process);
                  processStatus.set(process.uid, true);
                  resolve();
                }).catch((err) => {
                  console.error(err);
                  resolve();
                });
              });
            })
          );
          await Promise.all(
            processes.filter((p) => processStatus.get(p.uid) === true).map(
              (process) => new Promise((resolve) => {
                var _a;
                process.once("webrtc-page-closed", resolve);
                (_a = process.worker) == null ? void 0 : _a.call(process, "closeWebRTCPage");
              })
            )
          );
          if (processes.filter((p) => processStatus.get(p.uid) === false).length !== 0 && retryCount > 0) {
            await new Promise((resolve) => setTimeout(resolve, 3e3));
            await loop();
          }
        }
        await loop();
      } catch (e) {
        Modal.error({
          content: "\u83B7\u53D6\u6570\u636E\u9519\u8BEF\uFF0C\u8BF7\u68C0\u67E5\u8F6F\u4EF6\u662F\u5426\u6709\u5F55\u5236\u5E94\u7528\u6743\u9650\uFF1A" + e,
          title: "\u9519\u8BEF"
        });
      }
      state.loading = false;
    }
    async function getBrowserVideo(uid, sources) {
      const source = sources.find((s) => RegExp(uid).test(s.name));
      if (!source) {
        return;
      }
      try {
        const stream = await navigator.mediaDevices.getUserMedia({
          audio: false,
          video: {
            mandatory: {
              chromeMediaSource: "desktop",
              chromeMediaSourceId: source.id
            }
          }
        });
        const video = document.createElement("video");
        video.srcObject = stream;
        video.style.display = "block";
        video.style.width = "100%";
        video.poster = source.thumbnail.toDataURL();
        video.onloadedmetadata = (e) => video.play();
        return { video, stream };
      } catch (e) {
        console.log(e);
      }
    }
    function mountVideo(process) {
      const slot = document.querySelector(`#video-${process.uid}`);
      if (slot && slot.children.length === 0 && process.video) {
        slot.replaceChildren(process.video);
      }
    }
    function openBrowser(uid) {
      var _a;
      (_a = Process.from(uid)) == null ? void 0 : _a.bringToFront();
    }
    return (_ctx, _cache) => {
      const _component_a_divider = resolveComponent("a-divider");
      const _component_a_button = resolveComponent("a-button");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_a_switch = resolveComponent("a-switch");
      const _component_a_select = resolveComponent("a-select");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_empty = resolveComponent("a-empty");
      const _component_a_col = resolveComponent("a-col");
      const _component_a_row = resolveComponent("a-row");
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createBaseVNode("div", {
          class: "text-secondary markdown mb-2",
          innerHTML: unref(lang)("notice_dashboard_monitor_page_usage", "")
        }, null, 8, _hoisted_2),
        createBaseVNode("div", _hoisted_3, [
          createVNode(_component_a_space, { size: 0 }, {
            split: withCtx(() => [
              createVNode(_component_a_divider, {
                class: "ms-1 me-1",
                direction: "vertical"
              })
            ]),
            default: withCtx(() => [
              createVNode(_component_a_tooltip, {
                content: launchedProcesses.value.length === 0 ? "\u6682\u65E0\u8FD0\u884C\u6D4F\u89C8\u5668\uFF0C\u65E0\u6CD5\u5F00\u59CB\u76D1\u63A7" : "\u663E\u793A\u6BCF\u4E2A\u6D4F\u89C8\u5668\u7684\u56FE\u50CF\uFF0C\u5982\u679C\u592A\u591A\u6D4F\u89C8\u5668\u53EF\u80FD\u4F1A\u9020\u6210\u7535\u8111\u5361\u987F",
                position: "bl"
              }, {
                default: withCtx(() => [
                  createBaseVNode("div", null, [
                    createVNode(_component_a_button, {
                      size: "mini",
                      type: "outline",
                      disabled: launchedProcesses.value.length === 0 || state.loading,
                      onClick: _cache[0] || (_cache[0] = ($event) => state.show = !state.show)
                    }, {
                      default: withCtx(() => [
                        state.loading ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                          createTextVNode(" \u52A0\u8F7D\u4E2D... ")
                        ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                          createTextVNode(toDisplayString(state.show ? "\u6682\u505C" : "\u5F00\u59CB") + "\u76D1\u63A7 ", 1)
                        ], 64))
                      ]),
                      _: 1
                    }, 8, ["disabled"])
                  ])
                ]),
                _: 1
              }, 8, ["content"]),
              createVNode(_component_a_switch, {
                modelValue: unref(store).render.dashboard.details.tags,
                "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => unref(store).render.dashboard.details.tags = $event)
              }, {
                checked: withCtx(() => [..._cache[6] || (_cache[6] = [
                  createTextVNode(" \u663E\u793A\u6807\u7B7E ", -1)
                ])]),
                unchecked: withCtx(() => [..._cache[7] || (_cache[7] = [
                  createTextVNode(" \u663E\u793A\u6807\u7B7E ", -1)
                ])]),
                _: 1
              }, 8, ["modelValue"]),
              createVNode(_component_a_switch, {
                modelValue: unref(store).render.dashboard.details.notes,
                "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => unref(store).render.dashboard.details.notes = $event)
              }, {
                checked: withCtx(() => [..._cache[8] || (_cache[8] = [
                  createTextVNode(" \u663E\u793A\u5907\u6CE8 ", -1)
                ])]),
                unchecked: withCtx(() => [..._cache[9] || (_cache[9] = [
                  createTextVNode(" \u663E\u793A\u5907\u6CE8 ", -1)
                ])]),
                _: 1
              }, 8, ["modelValue"]),
              createVNode(_component_a_select, {
                modelValue: unref(store).render.dashboard.num,
                "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => unref(store).render.dashboard.num = $event),
                size: "mini",
                style: { "width": "96px" },
                options: [1, 2, 4, 6, 8].map((i) => ({ value: i, label: `\u663E\u793A${i}\u5217` }))
              }, null, 8, ["modelValue", "options"]),
              createVNode(_component_a_select, {
                modelValue: unref(store).render.dashboard.video.aspectRatio,
                "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => unref(store).render.dashboard.video.aspectRatio = $event),
                size: "mini",
                style: { "width": "130px" },
                options: unref(aspectRatio)
              }, {
                prefix: withCtx(() => [..._cache[10] || (_cache[10] = [
                  createTextVNode(" \u6A2A\u7EB5\u6BD4 ", -1)
                ])]),
                _: 1
              }, 8, ["modelValue", "options"]),
              createVNode(_component_a_select, {
                modelValue: unref(store).app.video_frame_rate,
                "onUpdate:modelValue": _cache[5] || (_cache[5] = ($event) => unref(store).app.video_frame_rate = $event),
                size: "mini",
                style: { "width": "140px" },
                options: [
                  { label: "\u8282\u80FD", value: 1 },
                  { label: "\u6D41\u7545", value: 4 },
                  { label: "\u9AD8\u5E27\uFF08\u6D88\u8017CPU\uFF09", value: 20 },
                  { label: "\u6700\u9AD8\uFF08\u5F88\u8017CPU\uFF09", value: 100 }
                ]
              }, {
                prefix: withCtx(() => [..._cache[11] || (_cache[11] = [
                  createTextVNode(" \u5E27\u7387 ", -1)
                ])]),
                _: 1
              }, 8, ["modelValue"])
            ]),
            _: 1
          })
        ]),
        unref(processes).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_4, [
          createVNode(_component_a_empty, {
            class: "m-auto",
            description: "\u6CA1\u6709\u8FD0\u884C\u4E2D\u7684\u6D4F\u89C8\u5668"
          })
        ])) : state.show === false ? (openBlock(), createBlock(_component_a_empty, {
          key: 1,
          class: "pt-5",
          description: "\u5F53\u524D\u76D1\u63A7\u5DF2\u6682\u505C\uFF0C\u8BF7\u70B9\u51FB\u76D1\u63A7\u6309\u94AE\u91CD\u65B0\u76D1\u63A7"
        })) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
          withDirectives(createVNode(_component_a_empty, {
            class: "pt-5",
            description: "\u52A0\u8F7D\u4E2D..."
          }, null, 512), [
            [vShow, state.loading === true]
          ]),
          withDirectives(createBaseVNode("div", {
            class: "dashboard mt-2",
            style: normalizeStyle({
              "grid-template-columns": `repeat(${unref(store).render.dashboard.num}, 1fr)`
            })
          }, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(launchedProcesses.value, (pro) => {
              return openBlock(), createElementBlock("div", {
                key: pro.uid,
                class: "browser"
              }, [
                createBaseVNode("div", _hoisted_5, [
                  createVNode(_component_a_row, {
                    style: { "overflow": "overlay" },
                    class: "flex-nowrap"
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_a_col, { flex: "auto" }, {
                        default: withCtx(() => [
                          createBaseVNode("span", _hoisted_6, toDisplayString(pro.browser.name), 1)
                        ]),
                        _: 2
                      }, 1024),
                      createVNode(_component_a_col, {
                        flex: "120px",
                        class: "d-flex align-content-center justify-content-end text-end"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_a_space, {
                            size: 0,
                            class: "justify-content-end"
                          }, {
                            split: withCtx(() => [
                              createVNode(_component_a_divider, {
                                direction: "vertical",
                                class: "ms-1 me-1"
                              })
                            ]),
                            default: withCtx(() => [
                              createVNode(BrowserOperators, {
                                space: false,
                                browser: pro.browser
                              }, {
                                split: withCtx(() => [
                                  createVNode(_component_a_divider, {
                                    direction: "vertical",
                                    class: "ms-1 me-1"
                                  })
                                ]),
                                _: 1
                              }, 8, ["browser"]),
                              createVNode(_sfc_main$1, {
                                type: "browser",
                                entity: pro.browser,
                                permissions: ["location", "edit"]
                              }, null, 8, ["entity"])
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1024)
                    ]),
                    _: 2
                  }, 1024)
                ]),
                createBaseVNode("div", {
                  class: "browser-video",
                  onClick: ($event) => openBrowser(pro.uid)
                }, [
                  createVNode(_component_a_tooltip, { content: "\u70B9\u51FB\u64CD\u63A7\u6D4F\u89C8\u5668" }, {
                    default: withCtx(() => [
                      createBaseVNode("div", {
                        id: "video-" + pro.uid
                      }, null, 8, _hoisted_8)
                    ]),
                    _: 2
                  }, 1024),
                  pro.video === void 0 ? (openBlock(), createElementBlock("span", _hoisted_9, [
                    pro.status === "launching" ? (openBlock(), createBlock(_component_a_empty, {
                      key: 0,
                      description: "\u7B49\u5F85\u6D4F\u89C8\u5668\u542F\u52A8..."
                    })) : pro.status === "launched" ? (openBlock(), createBlock(_component_a_empty, {
                      key: 1,
                      description: "\u7B49\u5F85\u56FE\u50CF\u521D\u59CB\u5316..."
                    })) : createCommentVNode("", true)
                  ])) : createCommentVNode("", true)
                ], 8, _hoisted_7),
                unref(store).render.dashboard.details.notes || unref(store).render.dashboard.details.tags ? (openBlock(), createBlock(_component_a_row, {
                  key: 0,
                  class: "align-items-center"
                }, {
                  default: withCtx(() => [
                    unref(store).render.dashboard.details.tags ? (openBlock(), createBlock(_component_a_col, {
                      key: 0,
                      style: { "width": "100px" },
                      flex: "100px"
                    }, {
                      default: withCtx(() => [
                        createVNode(Tags, {
                          tags: pro.browser.tags,
                          "read-only": true,
                          size: "small"
                        }, null, 8, ["tags"])
                      ]),
                      _: 2
                    }, 1024)) : createCommentVNode("", true),
                    unref(store).render.dashboard.details.notes ? (openBlock(), createBlock(_component_a_col, {
                      key: 1,
                      style: { "width": "100px" },
                      flex: "100px",
                      class: "text-secondary notes"
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_a_tooltip, {
                          content: "\u5907\u6CE8\u63CF\u8FF0",
                          position: "tl"
                        }, {
                          content: withCtx(() => [
                            _cache[12] || (_cache[12] = createBaseVNode("div", null, "\u5907\u6CE8\u63CF\u8FF0", -1)),
                            createVNode(_component_a_divider, { class: "mt-1 mb-1" }),
                            createBaseVNode("div", null, toDisplayString(pro.browser.notes), 1)
                          ]),
                          default: withCtx(() => [
                            createBaseVNode("span", null, toDisplayString(pro.browser.notes), 1)
                          ]),
                          _: 2
                        }, 1024)
                      ]),
                      _: 2
                    }, 1024)) : createCommentVNode("", true)
                  ]),
                  _: 2
                }, 1024)) : createCommentVNode("", true)
              ]);
            }), 128))
          ], 4), [
            [vShow, state.loading === false]
          ])
        ], 64))
      ]);
    };
  }
});
const index_vue_vue_type_style_index_0_scoped_c582ecfe_lang = "";
const index = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-c582ecfe"]]);
export {
  index as default
};
