import { o as openScriptSource, s as store, I as Icon, _ as _export_sfc, m as config, r as remote, l as lang, p as addScriptFromFile, C as CommonSelector, q as addScriptFromUrl } from "./index.c87a5b08.js";
import { e as defineComponent, t as toRefs, r as ref, j as resolveComponent, k as openBlock, p as createElementBlock, P as renderList, u as normalizeClass, n as createBaseVNode, v as createVNode, m as withCtx, $ as unref, x as renderSlot, z as toDisplayString, F as Fragment, l as createBlock, y as createTextVNode, s as createCommentVNode, a as reactive, o as onMounted, X as h } from "./@vue.10d2ded6.js";
import { a as Message, M as Modal, h as Input } from "./@arco-design.3c56df6b.js";
import "./vue-router.1b6385d9.js";
import "./lodash.4ddd9dd3.js";
import "./@babel.dac5e1c0.js";
import "./dayjs.a79bd2ae.js";
import "./video.js.be22f6f6.js";
import "./global.dfc622c4.js";
import "./@videojs.e887769e.js";
import "./is-function.1b723eb5.js";
import "./videojs-vtt.js.a6c4ef9e.js";
import "./m3u8-parser.427a5d14.js";
import "./mpd-parser.9d338e3c.js";
import "./@xmldom.63d5d2ec.js";
import "./mux.js.f617263a.js";
import "./markdown-it.a39105cb.js";
import "./entities.9efde8b5.js";
import "./uc.micro.428571ea.js";
import "./mdurl.b48c0e08.js";
import "./linkify-it.91515adc.js";
import "./punycode.768648d9.js";
import "./markdown-it-emoji.14324b8a.js";
import "./markdown-it-container.9b7103eb.js";
import "./axios.1e37c3a4.js";
import "./events.7cc16d47.js";
import "./colorpicker-v3.2c723672.js";
import "./xterm.9fe37c82.js";
import "./xterm-addon-fit.1029e58f.js";
/* empty css                         */import "./resize-observer-polyfill.375322e1.js";
import "./compute-scroll-into-view.079a5c71.js";
import "./b-tween.3dc4e04f.js";
import "./number-precision.a111f450.js";
import "./scroll-into-view-if-needed.10a505ff.js";
import "./b-validate.edd52b51.js";
const _hoisted_1$1 = ["onMouseover"];
const _hoisted_2$1 = {
  key: 0,
  class: "col-12"
};
const _hoisted_3$1 = {
  class: "row",
  style: { "align-items": "flex-start" }
};
const _hoisted_4$1 = {
  style: { "flex": "1" },
  class: "user-script-name"
};
const _hoisted_5$1 = ["onClick"];
const _hoisted_6$1 = {
  style: { "flex": "0" },
  class: "user-script-actions"
};
const _hoisted_7$1 = ["title"];
const _hoisted_8$1 = ["href"];
const _hoisted_9$1 = ["src"];
const _hoisted_10$1 = { class: "ms-1" };
const _hoisted_11$1 = { class: "row flex-wrap gap-1 gap-lg-0" };
const _hoisted_12$1 = { class: "col-12 col-lg-8" };
const _hoisted_13$1 = { class: "user-script-infos" };
const _hoisted_14$1 = {
  key: 1,
  class: "col-12"
};
const _hoisted_15$1 = { class: "user-script-name" };
const _hoisted_16$1 = ["href"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ScriptList",
  props: {
    scripts: {}
  },
  setup(__props) {
    const props = __props;
    const { scripts } = toRefs(props);
    const selectedScript = ref(0);
    function getElapsedTime(t) {
      const now = Date.now();
      const elapsed = now - t;
      let result = "";
      const second = 1e3;
      const minute = 60 * second;
      const hours = 60 * minute;
      const day = 24 * hours;
      const months = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
      const nowYear = new Date(now).getFullYear();
      const nowMonth = new Date(now).getMonth();
      if (nowYear % 4 === 0 && nowYear % 100 !== 0 || nowYear % 400 === 0)
        months[1] = 29;
      const month = Math.abs(new Date(t).getMonth() - nowMonth);
      const year = nowYear - new Date(t).getFullYear();
      if (year !== 0 && month >= 12)
        result = year + "\u5E74";
      else if (month !== 0 && Math.floor(elapsed / day) >= months[nowMonth])
        return month + "\u4E2A\u6708";
      else if (parse(day) !== 0)
        result = parse(day) + "\u5929";
      else if (parse(hours) !== 0)
        result = parse(hours) + "\u5C0F\u65F6";
      else if (parse(minute) !== 0)
        result = parse(minute) + "\u5206\u949F";
      else
        result = "\u521A\u521A";
      function parse(time) {
        return Math.floor(elapsed / time);
      }
      return result;
    }
    function isAlreadyInstalled(sc) {
      return store.render.scripts.find((s) => s.id === sc.id) !== void 0;
    }
    function unit(num) {
      if (num === 0)
        return "\u65E0";
      const mapping = [
        ["\u4EBF", 1e8],
        ["\u4E07", 1e4],
        ["", 1]
      ];
      const index2 = mapping.map((i) => Math.floor(num / i[1])).findIndex((i) => i > 0);
      return !mapping[index2][0] ? num : (num / mapping[index2][1]).toFixed(2) + " " + mapping[index2][0];
    }
    function getUrlVersion(url) {
      if (!url)
        return "";
      const match = url.match(/version=([\d.]+)/);
      return match ? match[1] : "";
    }
    return (_ctx, _cache) => {
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_a_tag = resolveComponent("a-tag");
      const _component_a_space = resolveComponent("a-space");
      return openBlock(true), createElementBlock(Fragment, null, renderList(unref(scripts), (script, _index) => {
        return openBlock(), createElementBlock("div", {
          key: _index,
          class: normalizeClass(["user-script d-flex", { "user-script-active": script.id === selectedScript.value }]),
          onMouseleave: _cache[0] || (_cache[0] = ($event) => selectedScript.value = 0),
          onMouseover: ($event) => selectedScript.value = script.id
        }, [
          script.info ? (openBlock(), createElementBlock("div", _hoisted_2$1, [
            createBaseVNode("div", _hoisted_3$1, [
              createBaseVNode("div", _hoisted_4$1, [
                createBaseVNode("div", null, [
                  createVNode(_component_a_tooltip, { content: "\u6253\u5F00\u811A\u672C\u6E90\u7AD9" }, {
                    default: withCtx(() => [
                      createBaseVNode("a", {
                        target: "_blank",
                        href: "javascript:void(0)",
                        style: { "text-decoration": "none" },
                        onClick: ($event) => unref(openScriptSource)(script)
                      }, [
                        renderSlot(_ctx.$slots, "script-name-prefix", { script }, void 0, true),
                        createBaseVNode("span", null, toDisplayString(script.info.name), 1)
                      ], 8, _hoisted_5$1)
                    ]),
                    _: 2
                  }, 1024)
                ])
              ]),
              createBaseVNode("div", _hoisted_6$1, [
                renderSlot(_ctx.$slots, "actions", {
                  script,
                  alreadyInstalled: isAlreadyInstalled(script)
                }, void 0, true)
              ])
            ]),
            createBaseVNode("div", {
              class: "user-script-descriptions",
              title: script.info.description
            }, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(script.info.authors, (author, i) => {
                return openBlock(), createElementBlock("a", {
                  key: i,
                  href: author.url,
                  class: "user-script-author",
                  target: "_blank"
                }, [
                  author.avatar ? (openBlock(), createElementBlock("img", {
                    key: 0,
                    src: author.avatar,
                    class: "user-script-icon"
                  }, null, 8, _hoisted_9$1)) : (openBlock(), createBlock(Icon, {
                    key: 1,
                    type: "account_circle",
                    style: { "margin-top": "4px" },
                    class: "user-script-icon"
                  })),
                  createBaseVNode("span", _hoisted_10$1, toDisplayString(author.name), 1)
                ], 8, _hoisted_8$1);
              }), 128)),
              createTextVNode(" \uFF1A " + toDisplayString(script.info.description), 1)
            ], 8, _hoisted_7$1),
            createBaseVNode("div", _hoisted_11$1, [
              createBaseVNode("div", _hoisted_12$1, [
                createBaseVNode("div", _hoisted_13$1, [
                  createVNode(_component_a_space, { size: "mini" }, {
                    default: withCtx(() => [
                      renderSlot(_ctx.$slots, "infos", { script }, void 0, true),
                      createVNode(_component_a_tooltip, { content: "\u6700\u65B0\u7248\u672C" }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, { color: "red" }, {
                            default: withCtx(() => [
                              _cache[1] || (_cache[1] = createTextVNode(" v", -1)),
                              createBaseVNode("b", null, toDisplayString(script.info.version), 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1024),
                      getUrlVersion(script.info.code_url) ? (openBlock(), createBlock(_component_a_tooltip, {
                        key: 0,
                        content: "\u5F53\u524D\u7248\u672C"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, { color: "blue" }, {
                            default: withCtx(() => [
                              _cache[2] || (_cache[2] = createTextVNode(" v", -1)),
                              createBaseVNode("b", null, toDisplayString(getUrlVersion(script.info.code_url)), 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1024)) : createCommentVNode("", true),
                      createVNode(_component_a_tooltip, {
                        content: `\u4ECA\u65E5\u5B89\u88C5 - ${script.info.daily_installs}`
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, { color: "blue" }, {
                            default: withCtx(() => [
                              _cache[3] || (_cache[3] = createTextVNode(" \u2B07\uFE0F", -1)),
                              createBaseVNode("b", null, toDisplayString(unit(script.info.daily_installs)), 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1032, ["content"]),
                      createVNode(_component_a_tooltip, {
                        content: `\u603B\u5B89\u88C5 - ${script.info.total_installs}`
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, { color: "green" }, {
                            default: withCtx(() => [
                              _cache[4] || (_cache[4] = createTextVNode(" \u{1F4E6}", -1)),
                              createBaseVNode("b", null, toDisplayString(unit(script.info.total_installs)), 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1032, ["content"]),
                      createVNode(_component_a_tooltip, { content: "\u8BC4\u5206\uFF0C\u6EE1\u52065\u5206" }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, { color: "orange" }, {
                            default: withCtx(() => [
                              _cache[5] || (_cache[5] = createTextVNode(" \u2B50", -1)),
                              createBaseVNode("b", null, toDisplayString(script.info.ratings ? script.info.ratings.toFixed(2) : "\u65E0"), 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1024),
                      script.info.create_time > 0 ? (openBlock(), createBlock(_component_a_tooltip, {
                        key: 1,
                        content: `\u521B\u5EFA\u65F6\u95F4 ${new Date(script.info.create_time).toLocaleString("zh-cn")}`
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, null, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(new Date(script.info.create_time).toLocaleDateString("zh-cn")) + " \u521B\u5EFA ", 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1032, ["content"])) : createCommentVNode("", true),
                      script.info.create_time > 0 ? (openBlock(), createBlock(_component_a_tooltip, {
                        key: 2,
                        content: `\u66F4\u65B0\u65F6\u95F4 ${new Date(script.info.update_time).toLocaleString("zh-cn")}`
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_a_tag, null, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(getElapsedTime(script.info.update_time)) + " \u524D\u66F4\u65B0 ", 1)
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1032, ["content"])) : createCommentVNode("", true)
                    ]),
                    _: 2
                  }, 1024)
                ])
              ])
            ])
          ])) : (openBlock(), createElementBlock("div", _hoisted_14$1, [
            createBaseVNode("div", _hoisted_15$1, [
              createBaseVNode("a", {
                target: "_blank",
                href: `file://${script.url}`
              }, [
                createBaseVNode("span", null, toDisplayString(script.url), 1)
              ], 8, _hoisted_16$1)
            ])
          ]))
        ], 42, _hoisted_1$1);
      }), 128);
    };
  }
});
const ScriptList_vue_vue_type_style_index_0_scoped_1621ea7f_lang = "";
const ScriptList = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-1621ea7f"]]);
const _hoisted_1 = { class: "col-12 p-2 m-auto h-100" };
const _hoisted_2 = ["innerHTML"];
const _hoisted_3 = { class: "mb-2" };
const _hoisted_4 = {
  key: 0,
  style: { "height": "50vh" },
  class: "d-flex"
};
const _hoisted_5 = {
  key: 1,
  class: "pb-3 ms-1 me-1"
};
const _hoisted_6 = { key: 0 };
const _hoisted_7 = { key: 1 };
const _hoisted_8 = { key: 2 };
const _hoisted_9 = { key: 3 };
const _hoisted_10 = { class: "large-text" };
const _hoisted_11 = ["onClick"];
const _hoisted_12 = { key: 0 };
const _hoisted_13 = { key: 1 };
const _hoisted_14 = { style: { "color": "white", "font-weight": "bold" } };
const _hoisted_15 = {
  key: 0,
  style: { "color": "white" }
};
const _hoisted_16 = {
  key: 1,
  style: { "color": "white" }
};
const _hoisted_17 = { class: "user-script-page" };
const _hoisted_18 = { class: "col-12 actions d-flex" };
const _hoisted_19 = { class: "col-12" };
const _hoisted_20 = { key: 0 };
const _hoisted_21 = { key: 1 };
const _hoisted_22 = { key: 2 };
const _hoisted_23 = {
  key: 3,
  class: "user-script-list pt-0 p-2"
};
const _hoisted_24 = { class: "row" };
const _hoisted_25 = { class: "col-6 d-flex flex-wrap gap-2" };
const _hoisted_26 = { class: "text-secondary col-6 text-end" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  setup(__props) {
    const engineSearchList = ref(config.scriptSearchEngines.map((engine) => ({ engine, list: [] })));
    const state = reactive({
      activeKey: "web",
      engineKey: config.scriptSearchEngines[0].name,
      searchValue: "",
      versionSelector: {
        currentScriptId: void 0,
        loading: false,
        visible: false,
        list: []
      },
      script_status: {}
    });
    onMounted(() => {
      updateAllInfo();
    });
    function onSearch(value) {
      engineSearchList.value.forEach(async (item) => {
        item.loading = true;
        item.error = false;
        try {
          const commonScripts = await item.engine.search(value, 1, 10);
          item.list = commonScripts.map((s) => ({
            id: s.id,
            url: s.code_url,
            enable: true,
            info: s,
            isLocalScript: false,
            isInternetLinkScript: false
          }));
        } catch (err) {
          console.log(err);
          item.list = [];
          item.error = true;
        }
        item.loading = false;
      });
    }
    function onAddScript(script) {
      store.render.scripts.push(script);
    }
    function onRemoveScript(script) {
      store.render.scripts.splice(store.render.scripts.indexOf(script), 1);
    }
    function enableAll() {
      store.render.scripts.forEach((val) => {
        val.enable = true;
      });
    }
    function closeAll() {
      store.render.scripts.forEach((val) => {
        val.enable = false;
      });
    }
    function addScriptFromURL() {
      const url = ref("");
      Modal.confirm({
        title: "\u52A0\u8F7D\u7F51\u7EDC\u811A\u672C",
        simple: false,
        content: () => h("div", [
          h(Input, {
            placeholder: "\u8F93\u5165\u811A\u672C\u94FE\u63A5\uFF08\u901A\u5E38\u4EE5http\u5F00\u5934\uFF0C\u5E76\u4EE5 .user.js \u7ED3\u5C3E\u7684\u94FE\u63A5\uFF09",
            onChange(value) {
              url.value = value;
            }
          })
        ]),
        async onOk() {
          Message.info("\u6B63\u5728\u4E0B\u8F7D\u811A\u672C\uFF0C\u8BF7\u7A0D\u540E...");
          if (await addScriptFromUrl(url.value)) {
            Message.success("\u811A\u672C\u4E0B\u8F7D\u5B8C\u6210");
          }
        }
      });
    }
    function getSourceType(script) {
      if (!script.url)
        return "unknown";
      const host = new URL(script.url).host;
      if (host.includes("ocsjs.com")) {
        return "official";
      } else if (host.includes("greasyfork")) {
        return "greasyfork";
      } else if (host.includes("scriptcat")) {
        return "scriptcat";
      }
      return "unknown";
    }
    function translateSourceType(type) {
      switch (type) {
        case "official":
          return "\u5B98\u65B9\u811A\u672C";
        case "unknown":
          return "\u672A\u77E5\u6765\u6E90";
        case "greasyfork":
          return "GreasyFork-\u6CB9\u53C9";
        case "scriptcat":
          return "ScriptCat-\u811A\u672C\u732B";
        default:
          return "\u672A\u77E5\u6765\u6E90";
      }
    }
    async function showScriptVersionList(script) {
      state.versionSelector.loading = true;
      function error() {
        state.versionSelector.loading = false;
        state.versionSelector.currentScriptId = void 0;
      }
      try {
        state.versionSelector.currentScriptId = script.id;
        const info = script.info;
        const source_type = getSourceType(script);
        if (!info || source_type === "unknown") {
          error();
          return Message.error("\u811A\u672C\u6765\u6E90\u672A\u77E5\uFF0C\u65E0\u6CD5\u5207\u6362\u7248\u672C");
        }
        if (script.isLocalScript || script.isInternetLinkScript || source_type === "official") {
          error();
          return Message.error("\u53EA\u6709\u901A\u8FC7\u811A\u672C\u641C\u7D22\u5E76\u5B89\u88C5\u7684\u7F51\u7EDC\u811A\u672C\u624D\u5177\u6709\u5207\u6362\u7248\u672C\u7684\u529F\u80FD\uFF0C\uFF08\u6765\u6E90\u7F51\u7AD9\u5FC5\u987B\u8981\u6709\u7248\u672C\u63A7\u5236\u529F\u80FD\uFF09");
        }
        const engine = config.scriptSearchEngines.find((engine2) => engine2.type === source_type);
        if (!engine || engine.versionProvider === void 0) {
          error();
          return Message.error("\u6B64\u811A\u672C\u6CA1\u6709\u63D0\u4F9B\u7248\u672C\u5207\u6362\u529F\u80FD");
        }
        const versions = await engine.versionProvider(script);
        console.log(versions);
        state.versionSelector.list = versions;
        state.versionSelector.visible = true;
      } catch (err) {
        console.log(err);
        state.versionSelector.currentScriptId = void 0;
      }
      state.versionSelector.loading = false;
    }
    function changeScriptVersion(id, select_version) {
      const latest_version = state.versionSelector.list[0];
      for (const script of store.render.scripts) {
        if (script.id === id && script.info !== void 0) {
          const script_version = getUrlVersion(script.info.code_url);
          if (script_version) {
            if (latest_version.version === select_version.version) {
              const url = new URL(latest_version.code_url);
              url.searchParams.delete("version");
              script.info.code_url = decodeURIComponent(url.toString());
              script.info.create_time = latest_version.create_time;
              Message.success("\u5DF2\u7ECF\u5207\u6362\u5230\u6700\u65B0\u7248\u672C\uFF0C\u6BCF\u6B21\u542F\u52A8\u5C06\u81EA\u52A8\u66F4\u65B0\u3002");
              break;
            }
          } else {
            if (latest_version.version === select_version.version) {
              Message.warning("\u5F53\u524D\u5DF2\u7ECF\u662F\u6700\u65B0\u7248\u672C\uFF0C\u65E0\u9700\u5207\u6362");
              return;
            }
          }
          if (script_version === select_version.version) {
            return Message.warning("\u9009\u62E9\u7684\u7248\u672C\u4E0E\u5F53\u524D\u7248\u672C\u76F8\u540C!");
          }
          script.info.code_url = decodeURIComponent(select_version.code_url);
          script.info.create_time = select_version.create_time;
        }
      }
      Message.success("\u5207\u6362\u7248\u672C\u6210\u529F");
      state.versionSelector.currentScriptId = void 0;
      state.versionSelector.visible = false;
      state.versionSelector.list = [];
      state.versionSelector.loading = false;
    }
    function getVersionSelectorCurrentScriptVersion() {
      var _a, _b;
      const url = (_b = (_a = store.render.scripts.find((s) => s.id === state.versionSelector.currentScriptId)) == null ? void 0 : _a.info) == null ? void 0 : _b.code_url;
      if (!url)
        return "";
      const match = url.match(/version=([\d.]+)/);
      return match ? match[1] : "";
    }
    function getUrlVersion(url) {
      const match = url.match(/version=([\d.]+)/);
      return match ? match[1] : "";
    }
    async function updateAllInfo() {
      await Promise.all(
        store.render.scripts.map(async (script) => {
          var _a, _b;
          if (script.isLocalScript) {
            const exists = remote.fs.callSync("existsSync", script.url);
            if (!exists) {
              Message.warning(`\u672C\u5730\u811A\u672C ${(_a = script.info) == null ? void 0 : _a.name} \uFF08${(_b = script.info) == null ? void 0 : _b.code_url}\uFF09\u5DF2\u4E0D\u5B58\u5728\uFF0C\u8BF7\u68C0\u67E5\u6587\u4EF6\u8DEF\u5F84`);
              state.script_status[script.id] = "not_found";
            }
            return;
          }
          if (script.isInternetLinkScript) {
            return;
          }
          if (script.info) {
            const source_type = getSourceType(script);
            if (source_type === "unknown") {
              return;
            }
            const engine = config.scriptSearchEngines.find((engine2) => engine2.type === source_type);
            if (!engine || engine.infoGetter === void 0) {
              return;
            }
            state.script_status[script.id] = "loading";
            try {
              const info = await engine.infoGetter(script.info);
              console.log(info);
              if (!script.info)
                return;
              const current_script_version = getUrlVersion(script.info.code_url);
              script.info = engine.transformToCommonByInfo(script.info, info);
              if (current_script_version) {
                const url = new URL(script.info.code_url);
                url.searchParams.set("version", current_script_version);
                script.info.code_url = decodeURIComponent(url.toString());
              }
              state.script_status[script.id] = "done";
              setTimeout(() => {
                delete state.script_status[script.id];
              }, 1e3);
            } catch (err) {
              console.log(err);
              state.script_status[script.id] = "error";
            }
          }
        })
      );
      Message.success("\u811A\u672C\u4FE1\u606F\u66F4\u65B0\u5B8C\u6210");
    }
    return (_ctx, _cache) => {
      const _component_a_button = resolveComponent("a-button");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_icon_apps = resolveComponent("icon-apps");
      const _component_a_doption = resolveComponent("a-doption");
      const _component_a_dropdown = resolveComponent("a-dropdown");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_empty = resolveComponent("a-empty");
      const _component_icon_refresh = resolveComponent("icon-refresh");
      const _component_icon_check = resolveComponent("icon-check");
      const _component_icon_close = resolveComponent("icon-close");
      const _component_icon_exclamation = resolveComponent("icon-exclamation");
      const _component_a_tag = resolveComponent("a-tag");
      const _component_a_descriptions_item = resolveComponent("a-descriptions-item");
      const _component_a_descriptions = resolveComponent("a-descriptions");
      const _component_a_popover = resolveComponent("a-popover");
      const _component_icon_loading = resolveComponent("icon-loading");
      const _component_icon_swap = resolveComponent("icon-swap");
      const _component_a_divider = resolveComponent("a-divider");
      const _component_a_switch = resolveComponent("a-switch");
      const _component_a_popconfirm = resolveComponent("a-popconfirm");
      const _component_a_tab_pane = resolveComponent("a-tab-pane");
      const _component_a_input_search = resolveComponent("a-input-search");
      const _component_a_skeleton_line = resolveComponent("a-skeleton-line");
      const _component_a_skeleton = resolveComponent("a-skeleton");
      const _component_a_tabs = resolveComponent("a-tabs");
      const _component_a_modal = resolveComponent("a-modal");
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_a_tabs, {
          "active-key": state.activeKey,
          "onUpdate:activeKey": _cache[3] || (_cache[3] = ($event) => state.activeKey = $event),
          class: "overflow-auto h-100"
        }, {
          default: withCtx(() => [
            createVNode(_component_a_tab_pane, {
              key: "web",
              title: "\u811A\u672C\u5217\u8868"
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: "text-secondary markdown mb-2",
                  innerHTML: unref(lang)("notice_user_scripts_page_usage", "")
                }, null, 8, _hoisted_2),
                createBaseVNode("div", _hoisted_3, [
                  createVNode(_component_a_space, null, {
                    default: withCtx(() => [
                      createVNode(_component_a_tooltip, { content: "\u4ECE\u672C\u5730\u6587\u4EF6\u6DFB\u52A0\u811A\u672C\uFF0C\u5FC5\u987B\u662F\u4EE5 .user.js \u7ED3\u5C3E\u7684\u6587\u4EF6" }, {
                        default: withCtx(() => [
                          createVNode(_component_a_button, {
                            size: "mini",
                            type: "outline",
                            onClick: unref(addScriptFromFile)
                          }, {
                            default: withCtx(() => [..._cache[5] || (_cache[5] = [
                              createTextVNode(" + \u6DFB\u52A0\u672C\u5730\u811A\u672C ", -1)
                            ])]),
                            _: 1
                          }, 8, ["onClick"])
                        ]),
                        _: 1
                      }),
                      createVNode(_component_a_tooltip, { content: "\u4F7F\u7528\u7F51\u7EDC\u94FE\u63A5\u6DFB\u52A0\u811A\u672C\uFF0C\u901A\u5E38\u4EE5 http \u5F00\u5934\uFF0C\u5E76\u4EE5 .user.js \u7ED3\u5C3E\u7684\u94FE\u63A5" }, {
                        default: withCtx(() => [
                          createVNode(_component_a_button, {
                            size: "mini",
                            type: "outline",
                            onClick: addScriptFromURL
                          }, {
                            default: withCtx(() => [..._cache[6] || (_cache[6] = [
                              createTextVNode(" + \u6DFB\u52A0\u7F51\u7EDC\u811A\u672C ", -1)
                            ])]),
                            _: 1
                          })
                        ]),
                        _: 1
                      }),
                      createVNode(_component_a_button, {
                        size: "mini",
                        type: "outline",
                        onClick: _cache[0] || (_cache[0] = ($event) => state.activeKey = "search")
                      }, {
                        default: withCtx(() => [
                          createVNode(Icon, { type: "search" }, {
                            default: withCtx(() => [..._cache[7] || (_cache[7] = [
                              createTextVNode("\u641C\u7D22\u7F51\u7EDC\u811A\u672C", -1)
                            ])]),
                            _: 1
                          })
                        ]),
                        _: 1
                      }),
                      createVNode(_component_a_dropdown, { trigger: "hover" }, {
                        content: withCtx(() => [
                          createVNode(_component_a_doption, {
                            size: "mini",
                            onClick: updateAllInfo
                          }, {
                            default: withCtx(() => [..._cache[9] || (_cache[9] = [
                              createTextVNode(" \u66F4\u65B0\u5168\u90E8\u811A\u672C\u4FE1\u606F ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, {
                            size: "mini",
                            onClick: enableAll
                          }, {
                            default: withCtx(() => [..._cache[10] || (_cache[10] = [
                              createTextVNode(" \u5168\u90E8\u5F00\u542F-\u81EA\u52A8\u5B89\u88C5 ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, {
                            size: "mini",
                            onClick: closeAll
                          }, {
                            default: withCtx(() => [..._cache[11] || (_cache[11] = [
                              createTextVNode(" \u5168\u90E8\u5173\u95ED-\u81EA\u52A8\u5B89\u88C5 ", -1)
                            ])]),
                            _: 1
                          })
                        ]),
                        default: withCtx(() => [
                          createVNode(_component_a_button, { size: "mini" }, {
                            default: withCtx(() => [
                              createVNode(_component_icon_apps, { class: "me-1" }),
                              _cache[8] || (_cache[8] = createTextVNode(" \u5FEB\u6377\u64CD\u4F5C ", -1))
                            ]),
                            _: 1
                          })
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  })
                ]),
                unref(store).render.scripts.length === 0 ? (openBlock(), createElementBlock("div", _hoisted_4, [
                  createVNode(_component_a_empty, {
                    class: "m-auto",
                    description: "\u6682\u65E0\u6570\u636E, \u8BF7\u5728\u4E0A\u65B9\u201C\u641C\u7D22\u811A\u672C\u201D\u4E2D\u9009\u62E9\u559C\u6B22\u7684\u811A\u672C\u8FDB\u884C\u6DFB\u52A0\u54E6~"
                  })
                ])) : (openBlock(), createElementBlock("div", _hoisted_5, [
                  createVNode(ScriptList, {
                    scripts: unref(store).render.scripts
                  }, {
                    "script-name-prefix": withCtx(({ script }) => [
                      state.script_status[script.id] ? (openBlock(), createBlock(_component_a_tooltip, { key: 0 }, {
                        content: withCtx(() => [
                          state.script_status[script.id] === "loading" ? (openBlock(), createElementBlock("div", _hoisted_6, "\u6B63\u5728\u66F4\u65B0\u811A\u672C\u4FE1\u606F...")) : state.script_status[script.id] === "done" ? (openBlock(), createElementBlock("div", _hoisted_7, "\u811A\u672C\u4FE1\u606F\u66F4\u65B0\u5B8C\u6210")) : state.script_status[script.id] === "error" ? (openBlock(), createElementBlock("div", _hoisted_8, "\u811A\u672C\u4FE1\u606F\u66F4\u65B0\u5931\u8D25\uFF0C\u53EF\u80FD\u662F\u7F51\u7EDC\u95EE\u9898")) : state.script_status[script.id] === "not_found" ? (openBlock(), createElementBlock("div", _hoisted_9, "\u672C\u5730\u811A\u672C\u5DF2\u4E0D\u5B58\u5728\uFF0C\u8BF7\u68C0\u67E5\u6587\u4EF6\u8DEF\u5F84")) : createCommentVNode("", true)
                        ]),
                        default: withCtx(() => [
                          createVNode(_component_a_tag, {
                            class: "me-2",
                            color: state.script_status[script.id] === "loading" ? "blue" : state.script_status[script.id] === "done" ? "green" : "red"
                          }, {
                            default: withCtx(() => [
                              state.script_status[script.id] === "loading" ? (openBlock(), createBlock(_component_icon_refresh, {
                                key: 0,
                                spin: ""
                              }, {
                                default: withCtx(() => [..._cache[12] || (_cache[12] = [
                                  createTextVNode(" \u6B63\u5728\u66F4\u65B0\u811A\u672C\u4FE1\u606F... ", -1)
                                ])]),
                                _: 1
                              })) : state.script_status[script.id] === "done" ? (openBlock(), createBlock(_component_icon_check, { key: 1 })) : state.script_status[script.id] === "error" ? (openBlock(), createBlock(_component_icon_close, { key: 2 })) : state.script_status[script.id] === "not_found" ? (openBlock(), createBlock(_component_icon_exclamation, { key: 3 })) : createCommentVNode("", true)
                            ]),
                            _: 2
                          }, 1032, ["color"])
                        ]),
                        _: 2
                      }, 1024)) : createCommentVNode("", true)
                    ]),
                    infos: withCtx(({ script }) => [
                      createVNode(_component_a_popover, {
                        position: "rt",
                        "content-style": { maxWidth: "400px" }
                      }, {
                        content: withCtx(() => [
                          createVNode(_component_a_descriptions, {
                            size: "mini",
                            "label-style": { verticalAlign: "top" },
                            "value-style": {},
                            column: 1
                          }, {
                            default: withCtx(() => {
                              var _a;
                              return [
                                createVNode(_component_a_descriptions_item, { label: "\u811A\u672C\u540D" }, {
                                  default: withCtx(() => {
                                    var _a2;
                                    return [
                                      createTextVNode(toDisplayString(((_a2 = script.info) == null ? void 0 : _a2.name) || ""), 1)
                                    ];
                                  }),
                                  _: 2
                                }, 1024),
                                createVNode(_component_a_descriptions_item, { label: "\u811A\u672C\u7B80\u4ECB" }, {
                                  default: withCtx(() => {
                                    var _a2;
                                    return [
                                      createVNode(_component_a_tooltip, {
                                        content: ((_a2 = script.info) == null ? void 0 : _a2.description) || ""
                                      }, {
                                        default: withCtx(() => {
                                          var _a3;
                                          return [
                                            createBaseVNode("div", _hoisted_10, toDisplayString(((_a3 = script.info) == null ? void 0 : _a3.description) || ""), 1)
                                          ];
                                        }),
                                        _: 2
                                      }, 1032, ["content"])
                                    ];
                                  }),
                                  _: 2
                                }, 1024),
                                ((_a = script.info) == null ? void 0 : _a.url) ? (openBlock(), createBlock(_component_a_descriptions_item, {
                                  key: 0,
                                  label: "\u811A\u672C\u4E3B\u9875"
                                }, {
                                  default: withCtx(() => [
                                    createBaseVNode("a", {
                                      href: "javascript:void(0)",
                                      onClick: ($event) => unref(openScriptSource)(script)
                                    }, toDisplayString(script.info.url), 9, _hoisted_11)
                                  ]),
                                  _: 2
                                }, 1024)) : createCommentVNode("", true),
                                createVNode(_component_a_descriptions_item, { label: "\u811A\u672C\u94FE\u63A5" }, {
                                  default: withCtx(() => {
                                    var _a2;
                                    return [
                                      createTextVNode(toDisplayString(((_a2 = script.info) == null ? void 0 : _a2.code_url) || ""), 1)
                                    ];
                                  }),
                                  _: 2
                                }, 1024)
                              ];
                            }),
                            _: 2
                          }, 1024)
                        ]),
                        default: withCtx(() => [
                          createVNode(_component_a_tag, null, {
                            default: withCtx(() => [
                              createVNode(Icon, { type: "info" })
                            ]),
                            _: 1
                          })
                        ]),
                        _: 2
                      }, 1024),
                      createVNode(_component_a_tooltip, null, {
                        content: withCtx(() => [
                          _cache[13] || (_cache[13] = createTextVNode(" \u811A\u672C\u6765\u6E90 ", -1)),
                          script.isLocalScript ? (openBlock(), createElementBlock("div", _hoisted_12, " \u672C\u5730\u811A\u672C\uFF1A\u5F53\u524D\u811A\u672C\u5904\u4E8E\u60A8\u8BA1\u7B97\u673A\u672C\u5730\uFF0C\u56E0\u6B64\u4E0D\u80FD\u5B9E\u65F6\u83B7\u53D6\u7F51\u7EDC\u6570\u636E\u8FDB\u884C\u66F4\u65B0\uFF0C\u4F46\u8F6F\u4EF6\u4F9D\u7136\u4F1A\u5C1D\u8BD5\u91CD\u590D\u52A0\u8F7D\u4EE5\u4FDD\u8BC1\u60A8\u7684\u6587\u4EF6\u4FEE\u6539\u540E\u7684\u4EE3\u7801\u4ECD\u80FD\u540C\u6B65\u5230\u6D4F\u89C8\u5668\u4E2D\uFF0C\u4E0D\u5177\u5907\u7248\u672C\u5207\u6362\u529F\u80FD\u3002 ")) : script.isInternetLinkScript ? (openBlock(), createElementBlock("div", _hoisted_13, " \u7F51\u7EDC\u811A\u672C\uFF1A\u901A\u8FC7\u7F51\u7EDC\u94FE\u63A5\u76F4\u63A5\u52A0\u8F7D\u5230\u8F6F\u4EF6\u4E2D\u7684\u811A\u672C\uFF0C\u4E0D\u5177\u5907\u7248\u672C\u5207\u6362\u529F\u80FD\u3002 ")) : createCommentVNode("", true)
                        ]),
                        default: withCtx(() => [
                          createVNode(_component_a_tag, null, {
                            default: withCtx(() => [
                              script.isLocalScript ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                                createTextVNode("\u672C\u5730\u811A\u672C")
                              ], 64)) : script.isInternetLinkScript ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                                createTextVNode("\u7F51\u7EDC\u811A\u672C")
                              ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                                createTextVNode(toDisplayString(translateSourceType(getSourceType(script))), 1)
                              ], 64))
                            ]),
                            _: 2
                          }, 1024)
                        ]),
                        _: 2
                      }, 1024)
                    ]),
                    actions: withCtx(({ script }) => [
                      !script.isLocalScript && !script.isInternetLinkScript && ["greasyfork", "scriptcat"].includes(getSourceType(script)) ? (openBlock(), createBlock(_component_a_button, {
                        key: 0,
                        size: "mini",
                        type: "outline",
                        class: "user-script-action",
                        style: { "background": "white" },
                        disabled: state.versionSelector.loading,
                        onClick: ($event) => showScriptVersionList(script)
                      }, {
                        default: withCtx(() => [
                          state.versionSelector.currentScriptId === script.id && state.versionSelector.loading ? (openBlock(), createBlock(_component_icon_loading, { key: 0 })) : (openBlock(), createBlock(_component_a_tooltip, { key: 1 }, {
                            content: withCtx(() => [..._cache[14] || (_cache[14] = [
                              createTextVNode(" \u5207\u6362\u811A\u672C\u7248\u672C\uFF0C\u542F\u52A8\u6D4F\u89C8\u5668\u540E\u4F1A\u5F3A\u5236\u5B89\u88C5\u6B64\u7248\u672C", -1),
                              createBaseVNode("br", null, null, -1),
                              createTextVNode(" \u5982\u679C\u9009\u62E9\u6700\u65B0\u7248\u672C\uFF0C\u90A3\u4E48\u6BCF\u6B21\u90FD\u4F1A\u540C\u6B65\u6700\u65B0\u7248\u672C ", -1)
                            ])]),
                            default: withCtx(() => [
                              createBaseVNode("span", null, [
                                createVNode(_component_icon_swap),
                                _cache[15] || (_cache[15] = createTextVNode(" \u7248\u672C ", -1))
                              ])
                            ]),
                            _: 1
                          }))
                        ]),
                        _: 2
                      }, 1032, ["disabled", "onClick"])) : createCommentVNode("", true),
                      createVNode(_component_a_tooltip, null, {
                        content: withCtx(() => [
                          createBaseVNode("div", _hoisted_14, [
                            script.enable ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                              createTextVNode(" \u5173\u95ED\u811A\u672C\u81EA\u52A8\u5B89\u88C5 ")
                            ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                              createTextVNode("\u5F00\u542F\u811A\u672C\u81EA\u52A8\u5B89\u88C5 ")
                            ], 64))
                          ]),
                          createVNode(_component_a_divider, { class: "mt-1 mb-1" }),
                          script.enable ? (openBlock(), createElementBlock("div", _hoisted_15, " \u5982\u679C\u60F3\u7981\u6B62\u811A\u672C\u8FD0\u884C\uFF0C\u8BF7\u5728\u6D4F\u89C8\u5668\u62D3\u5C55\u4E2D\u7981\u6B62\u3002 ")) : (openBlock(), createElementBlock("div", _hoisted_16, [..._cache[16] || (_cache[16] = [
                            createBaseVNode("div", null, "\u6D4F\u89C8\u5668\u542F\u52A8\u540E\u4F1A\u81EA\u52A8\u5B89\u88C5\u6B64\u811A\u672C\uFF0C", -1),
                            createBaseVNode("div", null, "\u5982\u679C\u6B64\u811A\u672C\u6CA1\u6709\u5728\u6D4F\u89C8\u5668\u4E2D\u5B89\u88C5\uFF0C\u5219\u4F1A\u81EA\u52A8\u5B89\u88C5\uFF0C", -1),
                            createBaseVNode("div", null, "\u5982\u679C\u5DF2\u5B89\u88C5\u5219\u4F1A\u81EA\u52A8\u66F4\u65B0\u4EE5\u53CA\u91CD\u65B0\u5B89\u88C5", -1)
                          ])]))
                        ]),
                        default: withCtx(() => [
                          createVNode(_component_a_switch, {
                            modelValue: script.enable,
                            "onUpdate:modelValue": ($event) => script.enable = $event,
                            style: { "width": "84px" },
                            class: "user-script-action"
                          }, {
                            checked: withCtx(() => [..._cache[17] || (_cache[17] = [
                              createTextVNode(" \u81EA\u52A8\u5B89\u88C5 ", -1)
                            ])]),
                            unchecked: withCtx(() => [..._cache[18] || (_cache[18] = [
                              createTextVNode(" \u81EA\u52A8\u5B89\u88C5 ", -1)
                            ])]),
                            _: 1
                          }, 8, ["modelValue", "onUpdate:modelValue"])
                        ]),
                        _: 2
                      }, 1024),
                      createVNode(_component_a_tooltip, { content: "\u79FB\u9664\u811A\u672C" }, {
                        default: withCtx(() => [
                          createVNode(_component_a_popconfirm, {
                            onOk: ($event) => onRemoveScript(script)
                          }, {
                            content: withCtx(() => [..._cache[19] || (_cache[19] = [
                              createBaseVNode("div", null, "\u5220\u9664\u540E\u5C06\u4E0D\u80FD\u6062\u590D\u6570\u636E\uFF01", -1),
                              createBaseVNode("div", null, "\u8BF7\u60A8\u8BB0\u4F4F\u6B64\u811A\u672C\u540D\uFF0C\u65B9\u4FBF\u540E\u7EED\u67E5\u627E\u3002", -1)
                            ])]),
                            default: withCtx(() => [
                              createVNode(_component_a_button, {
                                size: "mini",
                                status: "danger",
                                class: "user-script-action"
                              }, {
                                default: withCtx(() => [
                                  createVNode(Icon, { type: "delete" })
                                ]),
                                _: 1
                              })
                            ]),
                            _: 1
                          }, 8, ["onOk"])
                        ]),
                        _: 2
                      }, 1024)
                    ]),
                    _: 1
                  }, 8, ["scripts"])
                ]))
              ]),
              _: 1
            }),
            createVNode(_component_a_tab_pane, {
              key: "search",
              title: "\u811A\u672C\u641C\u7D22"
            }, {
              default: withCtx(() => [
                createBaseVNode("div", _hoisted_17, [
                  createBaseVNode("div", _hoisted_18, [
                    createVNode(_component_a_input_search, {
                      value: state.searchValue,
                      "onUpdate:value": _cache[1] || (_cache[1] = ($event) => state.searchValue = $event),
                      placeholder: "\u8F93\u5165\u811A\u672C\u540D\u8FDB\u884C\u641C\u7D22",
                      "search-button": "",
                      onChange: onSearch
                    }, null, 8, ["value"])
                  ]),
                  createBaseVNode("div", _hoisted_19, [
                    createVNode(_component_a_tabs, {
                      "active-key": state.engineKey,
                      "onUpdate:activeKey": _cache[2] || (_cache[2] = ($event) => state.engineKey = $event)
                    }, {
                      default: withCtx(() => [
                        (openBlock(true), createElementBlock(Fragment, null, renderList(engineSearchList.value, (item) => {
                          return openBlock(), createBlock(_component_a_tab_pane, {
                            key: item.engine.name,
                            title: item.engine.name
                          }, {
                            default: withCtx(() => [
                              item.loading ? (openBlock(), createElementBlock("div", _hoisted_20, [
                                createVNode(_component_a_skeleton, { animation: "" }, {
                                  default: withCtx(() => [
                                    createVNode(_component_a_skeleton_line, { rows: 3 })
                                  ]),
                                  _: 1
                                })
                              ])) : item.error ? (openBlock(), createElementBlock("div", _hoisted_21, [
                                createVNode(_component_a_empty, { description: "\u8BF7\u6C42\u51FA\u9519\uFF0C\u53EF\u80FD\u662F\u670D\u52A1\u5668\u95EE\u9898\uFF0C\u6216\u8005\u7F51\u7EDC\u95EE\u9898\uFF0C\u8BF7\u91CD\u65B0\u5C1D\u8BD5\u3002" })
                              ])) : item.list.length === 0 ? (openBlock(), createElementBlock("div", _hoisted_22, [
                                createVNode(_component_a_empty, { description: "\u6682\u65E0\u6570\u636E" })
                              ])) : (openBlock(), createElementBlock("div", _hoisted_23, [
                                _cache[20] || (_cache[20] = createBaseVNode("div", { class: "text-secondary markdown mb-1" }, "\u641C\u7D22\u7684\u811A\u672C\u6570\u636E\u5747\u6765\u81EA\u4E92\u8054\u7F51", -1)),
                                createVNode(ScriptList, {
                                  scripts: item.list
                                }, {
                                  actions: withCtx((data) => [
                                    createVNode(_component_a_button, {
                                      size: "mini",
                                      class: "user-script-action",
                                      disabled: data.alreadyInstalled,
                                      type: data.alreadyInstalled ? void 0 : "outline",
                                      onClick: ($event) => onAddScript(data.script)
                                    }, {
                                      default: withCtx(() => [
                                        createVNode(Icon, { type: "add" }),
                                        createTextVNode(" " + toDisplayString(data.alreadyInstalled ? "\u5DF2\u6DFB\u52A0" : "\u6DFB\u52A0"), 1)
                                      ]),
                                      _: 2
                                    }, 1032, ["disabled", "type", "onClick"])
                                  ]),
                                  _: 1
                                }, 8, ["scripts"])
                              ]))
                            ]),
                            _: 2
                          }, 1032, ["title"]);
                        }), 128))
                      ]),
                      _: 1
                    }, 8, ["active-key"])
                  ])
                ])
              ]),
              _: 1
            })
          ]),
          _: 1
        }, 8, ["active-key"]),
        createVNode(_component_a_modal, {
          visible: state.versionSelector.visible,
          "onUpdate:visible": _cache[4] || (_cache[4] = ($event) => state.versionSelector.visible = $event),
          title: "\u7248\u672C\u5207\u6362",
          footer: false
        }, {
          default: withCtx(() => [
            createVNode(CommonSelector, {
              list: state.versionSelector.list.map((i) => ({ key: i.version, ...i })),
              "on-select": (items) => {
                changeScriptVersion(state.versionSelector.currentScriptId, items[0]);
              },
              multiple: false
            }, {
              content: withCtx(({ item }) => {
                var _a;
                return [
                  createBaseVNode("div", _hoisted_24, [
                    createBaseVNode("div", _hoisted_25, [
                      createTextVNode(toDisplayString(item.version) + " ", 1),
                      item.version === ((_a = state.versionSelector.list[0]) == null ? void 0 : _a.version) ? (openBlock(), createBlock(_component_a_tag, {
                        key: 0,
                        size: "small",
                        color: "red"
                      }, {
                        default: withCtx(() => [..._cache[21] || (_cache[21] = [
                          createTextVNode(" \u6700\u65B0\u7248\u672C ", -1)
                        ])]),
                        _: 1
                      })) : createCommentVNode("", true),
                      item.version === getVersionSelectorCurrentScriptVersion() ? (openBlock(), createBlock(_component_a_tag, {
                        key: 1,
                        size: "small",
                        color: "blue"
                      }, {
                        default: withCtx(() => [..._cache[22] || (_cache[22] = [
                          createTextVNode(" \u5F53\u524D\u7248\u672C ", -1)
                        ])]),
                        _: 1
                      })) : createCommentVNode("", true)
                    ]),
                    createBaseVNode("div", _hoisted_26, [
                      createBaseVNode("div", null, "\u521B\u5EFA\u4E8E\uFF1A" + toDisplayString(new Date(item.create_time).toLocaleString()), 1)
                    ])
                  ])
                ];
              }),
              _: 1
            }, 8, ["list", "on-select"])
          ]),
          _: 1
        }, 8, ["visible"])
      ]);
    };
  }
});
const index_vue_vue_type_style_index_0_scoped_f7363a42_lang = "";
const index = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-f7363a42"]]);
export {
  index as default
};
