import { e as defineComponent, j as resolveComponent, k as openBlock, p as createElementBlock, v as createVNode, m as withCtx, F as Fragment, P as renderList, $ as unref, l as createBlock, y as createTextVNode, z as toDisplayString, n as createBaseVNode, s as createCommentVNode, t as toRefs, c as computed, a as reactive, r as ref, w as watch, o as onMounted, K as onDeactivated, q as normalizeStyle, X as h, a9 as useSlots, C as nextTick, x as renderSlot, M as withDirectives, N as vShow, H as withModifiers, u as normalizeClass, G as createSlots, aa as onActivated } from "./@vue.10d2ded6.js";
import { s as store, F as Folder, c as currentFolder, _ as _export_sfc, I as Icon, r as remote, n as newFolder, a as newBrowser, P as PlaywrightScriptSelector, b as root, B as Browser, d as currentSearchedEntities, T as Tags, e as BrowserOperators, f as Process, E as Entity$1, i as inBrowser, g as Environment, l as lang, S as Setup, h as resetSearch, j as currentEntities, k as about } from "./index.c87a5b08.js";
import { u as uniqueId_1 } from "./lodash.4ddd9dd3.js";
import { x as xlsx } from "./xlsx.5d3c15f8.js";
import { M as Modal, d as Tag, a as Message, R as Row, e as Col, f as Select, T as Tooltip, g as InputNumber, I as IconSync } from "./@arco-design.3c56df6b.js";
import { _ as _sfc_main$8 } from "./EntityOperator.vue_vue_type_script_setup_true_lang.26d0c230.js";
import "./vue-router.1b6385d9.js";
import "./dayjs.a79bd2ae.js";
import "./@babel.dac5e1c0.js";
import "./video.js.be22f6f6.js";
import "./global.dfc622c4.js";
import "./@videojs.e887769e.js";
import "./is-function.1b723eb5.js";
import "./videojs-vtt.js.a6c4ef9e.js";
import "./m3u8-parser.427a5d14.js";
import "./mpd-parser.9d338e3c.js";
import "./@xmldom.63d5d2ec.js";
import "./mux.js.f617263a.js";
import "./markdown-it.a39105cb.js";
import "./entities.9efde8b5.js";
import "./uc.micro.428571ea.js";
import "./mdurl.b48c0e08.js";
import "./linkify-it.91515adc.js";
import "./punycode.768648d9.js";
import "./markdown-it-emoji.14324b8a.js";
import "./markdown-it-container.9b7103eb.js";
import "./axios.1e37c3a4.js";
import "./events.7cc16d47.js";
import "./colorpicker-v3.2c723672.js";
import "./xterm.9fe37c82.js";
import "./xterm-addon-fit.1029e58f.js";
/* empty css                         */import "./resize-observer-polyfill.375322e1.js";
import "./compute-scroll-into-view.079a5c71.js";
import "./b-tween.3dc4e04f.js";
import "./number-precision.a111f450.js";
import "./scroll-into-view-if-needed.10a505ff.js";
import "./b-validate.edd52b51.js";
const _hoisted_1$7 = { style: { "float": "right" } };
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "FileFilters",
  setup(__props) {
    const object = Object;
    return (_ctx, _cache) => {
      const _component_a_tag = resolveComponent("a-tag");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_option = resolveComponent("a-option");
      const _component_a_select = resolveComponent("a-select");
      const _component_a_input_search = resolveComponent("a-input-search");
      return openBlock(), createElementBlock(Fragment, null, [
        createVNode(_component_a_select, {
          modelValue: unref(store).render.browser.search.tags,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => unref(store).render.browser.search.tags = $event),
          size: "mini",
          multiple: "",
          placeholder: "\u4F7F\u7528\u6807\u7B7E\u641C\u7D22",
          style: { "width": "200px" }
        }, {
          default: withCtx(() => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(object).keys(unref(store).render.browser.tags), (key) => {
              return openBlock(), createElementBlock(Fragment, { key }, [
                unref(store).render.browser.tags[key] ? (openBlock(), createBlock(_component_a_option, {
                  key: 0,
                  value: key,
                  label: key
                }, {
                  default: withCtx(() => [
                    createVNode(_component_a_space, null, {
                      default: withCtx(() => [
                        createVNode(_component_a_tag, {
                          color: unref(store).render.browser.tags[key].color
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(key), 1)
                          ]),
                          _: 2
                        }, 1032, ["color"]),
                        createBaseVNode("span", _hoisted_1$7, toDisplayString(unref(store).render.browser.tags[key].count), 1)
                      ]),
                      _: 2
                    }, 1024)
                  ]),
                  _: 2
                }, 1032, ["value", "label"])) : createCommentVNode("", true)
              ], 64);
            }), 128))
          ]),
          _: 1
        }, 8, ["modelValue"]),
        createVNode(_component_a_input_search, {
          modelValue: unref(store).render.browser.search.value,
          "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => unref(store).render.browser.search.value = $event),
          size: "mini",
          placeholder: "\u8F93\u5165\u540D\u5B57,\u5907\u6CE8\u641C\u7D22",
          style: { "width": "240px" }
        }, null, 8, ["modelValue"])
      ], 64);
    };
  }
});
const _hoisted_1$6 = { class: "breadcrumb" };
const _hoisted_2$5 = { class: "path-item" };
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "FileBreadcrumb",
  setup(__props) {
    return (_ctx, _cache) => {
      const _component_a_breadcrumb_item = resolveComponent("a-breadcrumb-item");
      const _component_a_breadcrumb = resolveComponent("a-breadcrumb");
      return openBlock(), createElementBlock("span", _hoisted_1$6, [
        createVNode(_component_a_breadcrumb, null, {
          default: withCtx(() => {
            var _a;
            return [
              (openBlock(true), createElementBlock(Fragment, null, renderList(unref(currentFolder) ? (_a = unref(Folder).from(unref(currentFolder).uid)) == null ? void 0 : _a.flatParents() : [], (folder) => {
                return openBlock(), createBlock(_component_a_breadcrumb_item, {
                  key: folder.uid,
                  onClick: ($event) => {
                    var _a2;
                    return (_a2 = unref(Folder).from(folder.uid)) == null ? void 0 : _a2.location();
                  }
                }, {
                  default: withCtx(() => [
                    createBaseVNode("span", _hoisted_2$5, toDisplayString(folder.name), 1)
                  ]),
                  _: 2
                }, 1032, ["onClick"]);
              }), 128)),
              createVNode(_component_a_breadcrumb_item)
            ];
          }),
          _: 1
        })
      ]);
    };
  }
});
const FileBreadcrumb_vue_vue_type_style_index_0_scoped_6d5d59a9_lang = "";
const FileBreadcrumb = /* @__PURE__ */ _export_sfc(_sfc_main$6, [["__scopeId", "data-v-6d5d59a9"]]);
const _hoisted_1$5 = { class: "ps-3 pe-3" };
const _hoisted_2$4 = { class: "text-nowrap" };
const _hoisted_3$3 = { class: "mt-3" };
const _hoisted_4$3 = { class: "float-end" };
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "PlaywrightScriptTable",
  props: {
    rawPlaywrightScript: {}
  },
  emits: ["confirm", "cancel"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emits = __emit;
    const { rawPlaywrightScript } = toRefs(props);
    const arrayLikeConfigs = computed(
      () => Object.keys(rawPlaywrightScript.value.configs).filter((k) => !rawPlaywrightScript.value.configs[k].hide).map((k) => ({ ...rawPlaywrightScript.value.configs[k], key: k }))
    );
    const state = reactive({
      pagination: {
        total: 1e3,
        current: 1,
        pageSize: 100
      },
      validDataIndex: /* @__PURE__ */ new Set(),
      browserNameFields: arrayLikeConfigs.value.map((c) => c.key)
    });
    const data = ref(createData());
    const columns = ref();
    const tableRef = ref();
    watch(rawPlaywrightScript, () => {
      data.value = createData();
      initColumns();
      state.browserNameFields = arrayLikeConfigs.value.map((c) => c.key);
    });
    onMounted(() => {
      initColumns();
    });
    onDeactivated(() => {
      state.browserNameFields = [];
      data.value = [];
      columns.value = [
        {
          title: "#",
          dataIndex: "index",
          slotName: "index",
          width: 70
        }
      ];
    });
    function initColumns() {
      columns.value = [
        {
          title: "",
          dataIndex: "index",
          slotName: "index",
          width: 42,
          bodyCellClass: "ps-table-index"
        },
        {
          title: "\u6D4F\u89C8\u5668\u540D",
          dataIndex: "browserName",
          slotName: "browserName",
          width: 120
        }
      ];
      for (const config of arrayLikeConfigs.value) {
        columns.value.push({
          title: config.label,
          dataIndex: config.key,
          slotName: "data",
          bodyCellClass: "ps-body-cell"
        });
      }
    }
    function createData() {
      return new Array(1e3).fill(1).map((item, index2) => {
        item = /* @__PURE__ */ Object.create({});
        item.index = index2;
        item.key = uniqueId_1();
        return item;
      });
    }
    function onRecordInput(index2) {
      state.validDataIndex.add(index2);
    }
    function getValidData() {
      const validData = [];
      for (const index2 of Array.from(state.validDataIndex).sort((a, b) => a - b)) {
        validData.push(data.value[index2]);
      }
      return validData;
    }
    function onConfirm() {
      var _a, _b;
      const validData = getValidData();
      const configsList = [];
      for (const obj of validData) {
        const configs = /* @__PURE__ */ Object.create({});
        const object = JSON.parse(JSON.stringify(obj));
        Reflect.deleteProperty(object, "index");
        Reflect.deleteProperty(object, "key");
        for (const key in object) {
          if (Object.prototype.hasOwnProperty.call(object, key)) {
            Reflect.set(configs, key, {
              hide: !!((_a = rawPlaywrightScript.value.configs[key]) == null ? void 0 : _a.hide),
              label: (_b = rawPlaywrightScript.value.configs[key]) == null ? void 0 : _b.label,
              value: object[key]
            });
          }
        }
        configs.browserName = object.browserName || state.browserNameFields.map((f) => {
          var _a2;
          return ((_a2 = configs[f]) == null ? void 0 : _a2.value) || "";
        }).join(" ");
        configsList.push(configs);
      }
      emits("confirm", props.rawPlaywrightScript, configsList);
    }
    function exportTemplateExcel() {
      const template = /* @__PURE__ */ Object.create({});
      template.\u6D4F\u89C8\u5668\u540D = "";
      for (const config of arrayLikeConfigs.value) {
        template[config.label] = "";
      }
      remote.methods.call(
        "exportExcel",
        [
          {
            sheetName: "Sheet1",
            list: [template]
          }
        ],
        `${props.rawPlaywrightScript.name} \u521B\u5EFA\u6A21\u677F.xlsx`
      );
    }
    function importTemplateExcelConfirm() {
      if (getValidData().length > 0) {
        Modal.warning({
          content: "\u5F53\u524D\u5B58\u5728\u5DF2\u7ECF\u7F16\u8F91\u7684\u6570\u636E\uFF0C\u5BFC\u5165\u540E\u5C06\u8986\u76D6\u6570\u636E\uFF0C\u662F\u5426\u786E\u8BA4\u5BFC\u5165\u3002",
          onOk: importTemplateExcel,
          simple: true,
          cancelText: "\u53D6\u6D88",
          okText: "\u786E\u8BA4\u5BFC\u5165"
        });
      } else {
        importTemplateExcel();
      }
    }
    function importTemplateExcel() {
      remote.dialog.call("showOpenDialog", {
        title: "\u9009\u62E9\u8868\u683C\u8FDB\u884C\u5BFC\u5165",
        buttonLabel: "\u5BFC\u5165",
        filters: [{ extensions: ["xlsx", "csv", "xls"], name: "excel\u8868\u683C" }]
      }).then(async ({ canceled, filePaths }) => {
        if (canceled === false && filePaths.length) {
          const text = await remote.fs.call("readFileSync", filePaths[0]);
          const book = xlsx.read(text, { type: "array" });
          const excel = book.SheetNames.map((name) => ({
            SheetName: name,
            data: xlsx.utils.sheet_to_json(book.Sheets[name])
          }));
          const list = excel.map((s) => s.data).flat();
          for (let index2 = 0; index2 < list.length; index2++) {
            const item = list[index2];
            const row = /* @__PURE__ */ Object.create({});
            for (const key in item) {
              if (Object.prototype.hasOwnProperty.call(item, key)) {
                const val = String(item[key] || "");
                const config = arrayLikeConfigs.value.find((c) => c.label === key);
                if (config) {
                  Reflect.set(row, config.key, val);
                }
                if (key === "\u6D4F\u89C8\u5668\u540D") {
                  Reflect.set(row, "browserName", val);
                }
              }
            }
            state.validDataIndex.add(index2);
            data.value[index2] = row;
          }
        }
      });
    }
    return (_ctx, _cache) => {
      const _component_a_input = resolveComponent("a-input");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_a_table = resolveComponent("a-table");
      const _component_a_option = resolveComponent("a-option");
      const _component_a_select = resolveComponent("a-select");
      const _component_icon_file = resolveComponent("icon-file");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_button = resolveComponent("a-button");
      return openBlock(), createElementBlock("div", {
        ref_key: "tableRef",
        ref: tableRef,
        class: "ps-table",
        style: normalizeStyle({ height: unref(store).render.state.height - 160 + "px", overflow: "overlay" })
      }, [
        createBaseVNode("div", _hoisted_1$5, [
          createVNode(_component_a_table, {
            pagination: state.pagination,
            "onUpdate:pagination": _cache[0] || (_cache[0] = ($event) => state.pagination = $event),
            size: "small",
            columns: columns.value,
            data: data.value,
            scroll: {
              y: unref(store).render.state.height - 280
            },
            onPageChange: _cache[1] || (_cache[1] = (page) => state.pagination.current = page),
            onPageSizeChange: _cache[2] || (_cache[2] = (size) => state.pagination.pageSize = size)
          }, {
            index: withCtx(({ record }) => [
              createBaseVNode("span", _hoisted_2$4, toDisplayString(record.index), 1)
            ]),
            browserName: withCtx(({ record, column }) => [
              createVNode(_component_a_tooltip, null, {
                content: withCtx(() => [
                  _cache[4] || (_cache[4] = createTextVNode(" \u5982\u679C\u7559\u7A7A\uFF0C\u5219\u9ED8\u8BA4\u4F7F\u7528\u81EA\u52A8\u89C4\u5219\u8FDB\u884C\u586B\u5145\uFF1A", -1)),
                  _cache[5] || (_cache[5] = createBaseVNode("br", null, null, -1)),
                  createTextVNode(" " + toDisplayString(state.browserNameFields.join("+")), 1)
                ]),
                default: withCtx(() => [
                  createVNode(_component_a_input, {
                    modelValue: record[column.dataIndex],
                    "onUpdate:modelValue": ($event) => record[column.dataIndex] = $event,
                    size: "mini",
                    placeholder: "\u81EA\u52A8\u586B\u5145"
                  }, null, 8, ["modelValue", "onUpdate:modelValue"])
                ]),
                _: 2
              }, 1024)
            ]),
            data: withCtx(({ record, rowIndex, column }) => [
              createVNode(_component_a_input, {
                modelValue: record[column.dataIndex],
                "onUpdate:modelValue": ($event) => record[column.dataIndex] = $event,
                size: "mini",
                onInput: () => onRecordInput(rowIndex)
              }, null, 8, ["modelValue", "onUpdate:modelValue", "onInput"])
            ]),
            _: 1
          }, 8, ["pagination", "columns", "data", "scroll"])
        ]),
        createBaseVNode("div", _hoisted_3$3, [
          createBaseVNode("div", _hoisted_4$3, [
            createVNode(_component_a_space, null, {
              default: withCtx(() => [
                _cache[9] || (_cache[9] = createBaseVNode("span", null, " \u6D4F\u89C8\u5668\u540D\u751F\u6210\u89C4\u5219\uFF1A ", -1)),
                createVNode(_component_a_select, {
                  modelValue: state.browserNameFields,
                  "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => state.browserNameFields = $event),
                  size: "mini",
                  multiple: "",
                  style: { "width": "200px", "overflow-x": "auto", "white-space": "nowrap" }
                }, {
                  default: withCtx(() => [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(arrayLikeConfigs.value, (config) => {
                      return openBlock(), createBlock(_component_a_option, {
                        key: config.key,
                        label: config.label,
                        value: config.key
                      }, null, 8, ["label", "value"]);
                    }), 128))
                  ]),
                  _: 1
                }, 8, ["modelValue"]),
                createVNode(_component_a_tooltip, { content: "\u5BFC\u51FA\u56FA\u5B9A\u683C\u5F0F\u7684\u6279\u91CF\u521B\u5EFA\u6A21\u677F\u8868\u683C\uFF0C\u7F16\u8F91\u597D\u6A21\u677F\u8868\u683C\u540E\u53EF\u4EE5\u5BFC\u5165\u3002" }, {
                  default: withCtx(() => [
                    createVNode(_component_a_button, {
                      size: "mini",
                      onClick: exportTemplateExcel
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_a_space, null, {
                          default: withCtx(() => [
                            createVNode(_component_icon_file),
                            _cache[6] || (_cache[6] = createTextVNode(" \u5BFC\u51FA\u8868\u683C\u6A21\u677F ", -1))
                          ]),
                          _: 1
                        })
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                }),
                createVNode(_component_a_tooltip, { content: "\u5BFC\u5165\u4E0E\u4E0A\u9762\u683C\u5F0F\u76F8\u540C\u7684\u8868\u683C\u6570\u636E" }, {
                  default: withCtx(() => [
                    createVNode(_component_a_button, {
                      size: "mini",
                      onClick: importTemplateExcelConfirm
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_a_space, null, {
                          default: withCtx(() => [
                            createVNode(_component_icon_file),
                            _cache[7] || (_cache[7] = createTextVNode(" \u5BFC\u5165\u8868\u683C ", -1))
                          ]),
                          _: 1
                        })
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                }),
                createVNode(_component_a_button, {
                  size: "mini",
                  type: "outline",
                  onClick: onConfirm
                }, {
                  default: withCtx(() => [
                    createVNode(Icon, { type: "web" }, {
                      default: withCtx(() => [..._cache[8] || (_cache[8] = [
                        createTextVNode(" \u6279\u91CF\u521B\u5EFA ", -1)
                      ])]),
                      _: 1
                    })
                  ]),
                  _: 1
                })
              ]),
              _: 1
            })
          ])
        ])
      ], 4);
    };
  }
});
const PlaywrightScriptTable_vue_vue_type_style_index_0_scoped_2758aa14_lang = "";
const PlaywrightScriptTable = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["__scopeId", "data-v-2758aa14"]]);
const _hoisted_1$4 = { style: { "max-width": "400px" } };
const _hoisted_2$3 = { style: { "float": "right" } };
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "FileOperators",
  setup(__props) {
    const state = reactive({
      showPlaywrightScriptSelector: false,
      showPlaywrightScriptTable: false,
      playwrightScripts: [],
      selectedPS: void 0,
      remove_tags_modal: {
        visible: false,
        tags: []
      }
    });
    function showMultipleCreateTable() {
      state.showPlaywrightScriptTable = true;
      state.selectedPS = state.playwrightScripts[0];
    }
    async function multipleCreate(raw, configsList) {
      for (const configs of configsList) {
        newBrowser({
          name: configs.browserName,
          playwrightScripts: [
            {
              name: raw.name,
              configs
            }
          ]
        });
      }
      state.showPlaywrightScriptTable = false;
    }
    function removeTags() {
      Modal.confirm({
        title: "\u786E\u8BA4\u5220\u9664\u8FD9\u4E9B\u6807\u7B7E\u5417\uFF1F",
        content: () => h("div", [
          `\u6807\u7B7E\uFF1A`,
          ...state.remove_tags_modal.tags.map((tag) => {
            const tag_info = store.render.browser.tags[tag];
            return h(Tag, { color: tag_info.color }, tag);
          }),
          h("br"),
          `\u5C06\u4ECE\u6BCF\u4E2A\u6D4F\u89C8\u5668\u4E2D\u79FB\u9664\uFF0C\u5220\u9664\u540E\u5C06\u65E0\u6CD5\u6062\u590D\uFF0C\u8BF7\u8C28\u614E\u64CD\u4F5C\uFF01`
        ]),
        onOk: () => {
          try {
            const tags = state.remove_tags_modal.tags;
            if (tags.length === 0) {
              return;
            }
            for (const child of root().findAll((e) => e.type === "browser")) {
              child.tags = child.tags.filter((t) => !tags.includes(t.name));
            }
            for (const tag of tags) {
              Reflect.deleteProperty(store.render.browser.tags, tag);
            }
            state.remove_tags_modal.tags = [];
            Message.success("\u6807\u7B7E\u5220\u9664\u6210\u529F");
          } catch (e) {
            Message.error("\u6807\u7B7E\u5220\u9664\u5931\u8D25");
            console.error(e);
          }
        }
      });
    }
    return (_ctx, _cache) => {
      const _component_a_button = resolveComponent("a-button");
      const _component_a_doption = resolveComponent("a-doption");
      const _component_a_dropdown = resolveComponent("a-dropdown");
      const _component_a_modal = resolveComponent("a-modal");
      const _component_a_empty = resolveComponent("a-empty");
      const _component_a_tag = resolveComponent("a-tag");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_option = resolveComponent("a-option");
      const _component_a_select = resolveComponent("a-select");
      return openBlock(), createBlock(_component_a_space, null, {
        default: withCtx(() => [
          createVNode(_component_a_dropdown, { trigger: "hover" }, {
            content: withCtx(() => [
              createVNode(_component_a_doption, { onClick: unref(newFolder) }, {
                default: withCtx(() => [
                  createVNode(Icon, { type: "folder" }, {
                    default: withCtx(() => [..._cache[11] || (_cache[11] = [
                      createTextVNode("\u65B0\u5EFA\u6587\u4EF6\u5939", -1)
                    ])]),
                    _: 1
                  })
                ]),
                _: 1
              }, 8, ["onClick"]),
              createVNode(_component_a_doption, {
                onClick: _cache[0] || (_cache[0] = ($event) => state.showPlaywrightScriptSelector = true)
              }, {
                default: withCtx(() => [
                  createVNode(Icon, { type: "add" }, {
                    default: withCtx(() => [..._cache[12] || (_cache[12] = [
                      createTextVNode(" \u6279\u91CF\u521B\u5EFA-\u81EA\u52A8\u5316\u811A\u672C\u6D4F\u89C8\u5668", -1)
                    ])]),
                    _: 1
                  })
                ]),
                _: 1
              }),
              createVNode(_component_a_doption, {
                onClick: _cache[1] || (_cache[1] = ($event) => state.remove_tags_modal.visible = true)
              }, {
                default: withCtx(() => [
                  createVNode(Icon, { type: "delete" }, {
                    default: withCtx(() => [..._cache[13] || (_cache[13] = [
                      createTextVNode("\u6279\u91CF\u5220\u9664\u6807\u7B7E", -1)
                    ])]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ]),
            default: withCtx(() => [
              createVNode(_component_a_button, { size: "mini" }, {
                default: withCtx(() => [
                  createVNode(Icon, { type: "more_horiz" }, {
                    default: withCtx(() => [..._cache[10] || (_cache[10] = [
                      createTextVNode(" \u66F4\u591A ", -1)
                    ])]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ]),
            _: 1
          }),
          createVNode(_component_a_button, {
            size: "mini",
            type: "outline",
            onClick: _cache[2] || (_cache[2] = ($event) => unref(newBrowser)())
          }, {
            default: withCtx(() => [
              createVNode(Icon, { type: "web" }, {
                default: withCtx(() => [..._cache[14] || (_cache[14] = [
                  createTextVNode(" \u65B0\u5EFA\u6D4F\u89C8\u5668 ", -1)
                ])]),
                _: 1
              })
            ]),
            _: 1
          }),
          createVNode(_component_a_modal, {
            visible: state.showPlaywrightScriptSelector,
            "onUpdate:visible": _cache[5] || (_cache[5] = ($event) => state.showPlaywrightScriptSelector = $event),
            footer: false
          }, {
            title: withCtx(() => [..._cache[15] || (_cache[15] = [
              createTextVNode(" \u9009\u62E9\u6A21\u677F\u8FDB\u884C\u6279\u91CF\u521B\u5EFA ", -1)
            ])]),
            default: withCtx(() => [
              createVNode(PlaywrightScriptSelector, {
                "playwright-scripts": state.playwrightScripts,
                "onUpdate:playwrightScripts": _cache[3] || (_cache[3] = ($event) => state.playwrightScripts = $event),
                style: { "max-height": "70vh", "overflow": "overlay" },
                multiple: false,
                onConfirm: _cache[4] || (_cache[4] = ($event) => (state.showPlaywrightScriptSelector = false, showMultipleCreateTable()))
              }, null, 8, ["playwright-scripts"])
            ]),
            _: 1
          }, 8, ["visible"]),
          createVNode(_component_a_modal, {
            visible: state.showPlaywrightScriptTable,
            "onUpdate:visible": _cache[7] || (_cache[7] = ($event) => state.showPlaywrightScriptTable = $event),
            footer: false,
            closable: true,
            "mask-closable": false,
            width: "auto"
          }, {
            title: withCtx(() => {
              var _a;
              return [
                createTextVNode(" \u6279\u91CF\u521B\u5EFA\uFF1A" + toDisplayString((_a = state.selectedPS) == null ? void 0 : _a.name), 1)
              ];
            }),
            default: withCtx(() => [
              state.selectedPS ? (openBlock(), createBlock(PlaywrightScriptTable, {
                key: 0,
                style: { "max-width": "800px" },
                "raw-playwright-script": state.selectedPS,
                onCancel: _cache[6] || (_cache[6] = ($event) => state.showPlaywrightScriptTable = false),
                onConfirm: multipleCreate
              }, null, 8, ["raw-playwright-script"])) : (openBlock(), createBlock(_component_a_empty, {
                key: 1,
                description: "\u8BF7\u9009\u62E9\u6A21\u677F"
              }))
            ]),
            _: 1
          }, 8, ["visible"]),
          createVNode(_component_a_modal, {
            visible: state.remove_tags_modal.visible,
            "onUpdate:visible": _cache[9] || (_cache[9] = ($event) => state.remove_tags_modal.visible = $event),
            title: "\u6279\u91CF\u5220\u9664\u6807\u7B7E",
            "mask-closable": false,
            onOk: removeTags
          }, {
            default: withCtx(() => [
              createBaseVNode("div", _hoisted_1$4, [
                _cache[16] || (_cache[16] = createTextVNode(" \u9009\u62E9\u6807\u7B7E\u8FDB\u884C\u5220\u9664\uFF1A ", -1)),
                createVNode(_component_a_select, {
                  modelValue: state.remove_tags_modal.tags,
                  "onUpdate:modelValue": _cache[8] || (_cache[8] = ($event) => state.remove_tags_modal.tags = $event),
                  size: "mini",
                  multiple: "",
                  placeholder: "\u9009\u62E9...",
                  style: { "width": "200px" }
                }, {
                  default: withCtx(() => [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(Object.keys(unref(store).render.browser.tags), (key) => {
                      return openBlock(), createElementBlock(Fragment, { key }, [
                        unref(store).render.browser.tags[key] ? (openBlock(), createBlock(_component_a_option, {
                          key: 0,
                          value: key,
                          label: key
                        }, {
                          default: withCtx(() => [
                            createVNode(_component_a_space, null, {
                              default: withCtx(() => [
                                createVNode(_component_a_tag, {
                                  color: unref(store).render.browser.tags[key].color
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(toDisplayString(key), 1)
                                  ]),
                                  _: 2
                                }, 1032, ["color"]),
                                createBaseVNode("span", _hoisted_2$3, toDisplayString(unref(store).render.browser.tags[key].count), 1)
                              ]),
                              _: 2
                            }, 1024)
                          ]),
                          _: 2
                        }, 1032, ["value", "label"])) : createCommentVNode("", true)
                      ], 64);
                    }), 128))
                  ]),
                  _: 1
                }, 8, ["modelValue"])
              ])
            ]),
            _: 1
          }, 8, ["visible"])
        ]),
        _: 1
      });
    };
  }
});
const _hoisted_1$3 = {
  style: { "cursor": "pointer", "flex": "auto" },
  class: "text-secondary entity-name align-items-center d-flex"
};
const _hoisted_2$2 = {
  key: 0,
  style: { "cursor": "pointer", "flex": "0 0 auto" }
};
const _hoisted_3$2 = { class: "ms-2" };
const _hoisted_4$2 = { style: { "flex": "1 1 auto" } };
const _hoisted_5$1 = {
  key: 0,
  class: "d-flex align-items-center",
  style: { "margin-left": "32px" }
};
const _hoisted_6$1 = {
  key: 0,
  style: { "flex": "0 0 auto" },
  class: "text-secondary text-nowrap d-flex justify-content-end ps-1 pe-2"
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "Entity",
  props: {
    entity: {}
  },
  setup(__props) {
    const slots = useSlots();
    const props = __props;
    const renameInput = ref();
    const renameValue = ref(props.entity.name);
    const instance = props.entity.type === "browser" ? Browser.from(props.entity.uid) : Folder.from(props.entity.uid);
    watch(
      () => props.entity.renaming,
      () => {
        if (props.entity.renaming) {
          nextTick(active);
        }
      }
    );
    onMounted(() => {
      nextTick(active);
    });
    function active() {
      const input = renameInput.value.$el.querySelector("input");
      input.focus();
      input.select();
    }
    return (_ctx, _cache) => {
      const _component_a_input = resolveComponent("a-input");
      const _component_a_doption = resolveComponent("a-doption");
      const _component_a_dropdown = resolveComponent("a-dropdown");
      const _component_a_divider = resolveComponent("a-divider");
      const _component_a_space = resolveComponent("a-space");
      return unref(instance) ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: normalizeClass(["entity align-items-center d-flex", { active: unref(store).render.browser.currentBrowserUid === unref(instance).uid }])
      }, [
        createBaseVNode("div", {
          style: { "cursor": "pointer", "flex": "auto" },
          onClick: _cache[5] || (_cache[5] = ($event) => {
            var _a;
            return (_a = unref(instance)) == null ? void 0 : _a.select();
          })
        }, [
          createBaseVNode("div", _hoisted_1$3, [
            unref(slots).prefix ? (openBlock(), createElementBlock("div", _hoisted_2$2, [
              renderSlot(_ctx.$slots, "prefix", {}, void 0, true)
            ])) : createCommentVNode("", true),
            unref(slots).icon ? (openBlock(), createElementBlock("span", {
              key: 1,
              class: "d-inline-flex align-items-center",
              style: { "cursor": "pointer", "padding": "0px 4px", "font-size": "16px" },
              onClick: _cache[0] || (_cache[0] = ($event) => {
                var _a;
                return (_a = unref(instance)) == null ? void 0 : _a.select();
              })
            }, [
              renderSlot(_ctx.$slots, "icon", {}, void 0, true)
            ])) : createCommentVNode("", true),
            createVNode(_component_a_dropdown, {
              trigger: ["hover"],
              position: "rt"
            }, {
              content: withCtx(() => [
                createVNode(_component_a_doption, {
                  onClick: _cache[4] || (_cache[4] = ($event) => unref(instance) && (unref(instance).renaming = true))
                }, {
                  default: withCtx(() => [
                    createVNode(Icon, { type: "text_format" }, {
                      default: withCtx(() => [..._cache[6] || (_cache[6] = [
                        createTextVNode("\u91CD\u547D\u540D", -1)
                      ])]),
                      _: 1
                    })
                  ]),
                  _: 1
                })
              ]),
              default: withCtx(() => [
                createBaseVNode("span", _hoisted_3$2, [
                  withDirectives(createVNode(_component_a_input, {
                    ref_key: "renameInput",
                    ref: renameInput,
                    modelValue: renameValue.value,
                    "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => renameValue.value = $event),
                    size: "mini",
                    onClick: _cache[2] || (_cache[2] = withModifiers(() => {
                    }, ["stop"])),
                    onBlur: _cache[3] || (_cache[3] = ($event) => {
                      var _a;
                      return (_a = unref(instance)) == null ? void 0 : _a.rename(renameValue.value);
                    })
                  }, null, 8, ["modelValue"]), [
                    [vShow, unref(instance).renaming]
                  ]),
                  withDirectives(createBaseVNode("span", null, toDisplayString(unref(instance).name), 513), [
                    [vShow, !unref(instance).renaming]
                  ])
                ])
              ]),
              _: 1
            }),
            createBaseVNode("div", _hoisted_4$2, [
              renderSlot(_ctx.$slots, "suffix", {}, void 0, true)
            ])
          ]),
          unref(slots).extra ? (openBlock(), createElementBlock("div", _hoisted_5$1, [
            renderSlot(_ctx.$slots, "extra", {}, void 0, true)
          ])) : createCommentVNode("", true)
        ]),
        unref(slots).actions ? (openBlock(), createElementBlock("div", _hoisted_6$1, [
          createVNode(_component_a_space, {
            size: 0,
            class: "actions justify-content-end"
          }, {
            split: withCtx(() => [
              createVNode(_component_a_divider, {
                class: "ms-1 me-1",
                direction: "vertical"
              })
            ]),
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "actions", {}, void 0, true)
            ]),
            _: 3
          })
        ])) : createCommentVNode("", true)
      ], 2)) : createCommentVNode("", true);
    };
  }
});
const Entity_vue_vue_type_style_index_0_scoped_43772c09_lang = "";
const Entity = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["__scopeId", "data-v-43772c09"]]);
const _hoisted_1$2 = { class: "d-flex align-items-center" };
const _hoisted_2$1 = {
  key: 0,
  class: "text-secondary tags",
  style: { "flex": "0 0 auto" }
};
const _hoisted_3$1 = {
  style: { "flex": "1 1 auto", "overflow": "auto", "max-width": "700px" },
  class: "d-flex align-items-center"
};
const _hoisted_4$1 = {
  key: 0,
  class: "text-secondary notes flex-wrap",
  style: { "flex": "1 1 auto" }
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BrowserList",
  props: {
    entities: {}
  },
  setup(__props) {
    return (_ctx, _cache) => {
      const _component_a_checkbox = resolveComponent("a-checkbox");
      const _component_a_divider = resolveComponent("a-divider");
      return openBlock(), createElementBlock("div", null, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(__props.entities, (child) => {
          return openBlock(), createElementBlock(Fragment, null, [
            child.type !== "browser" ? (openBlock(), createBlock(Entity, {
              key: child.uid,
              class: "entity",
              entity: child
            }, {
              icon: withCtx(() => [
                createVNode(Icon, {
                  theme: "filled",
                  type: "folder"
                })
              ]),
              actions: withCtx(() => [
                createVNode(_sfc_main$8, {
                  "icon-class": "fs-5",
                  type: "folder",
                  entity: child,
                  permissions: unref(currentSearchedEntities) ? ["location"] : ["rename", "remove"]
                }, null, 8, ["entity", "permissions"])
              ]),
              _: 2
            }, 1032, ["entity"])) : createCommentVNode("", true)
          ], 64);
        }), 256)),
        (openBlock(true), createElementBlock(Fragment, null, renderList(__props.entities, (child) => {
          return openBlock(), createElementBlock(Fragment, null, [
            child.type === "browser" ? (openBlock(), createBlock(Entity, {
              key: child.uid,
              class: "entity",
              entity: child
            }, createSlots({
              prefix: withCtx(() => [
                createBaseVNode("div", _hoisted_1$2, [
                  createVNode(_component_a_checkbox, {
                    modelValue: child.checked,
                    "onUpdate:modelValue": ($event) => child.checked = $event,
                    class: "ps-1 pe-1",
                    style: { "width": "24px" },
                    onClick: _cache[0] || (_cache[0] = withModifiers(() => {
                    }, ["stop"]))
                  }, null, 8, ["modelValue", "onUpdate:modelValue"])
                ])
              ]),
              suffix: withCtx(() => [
                child.tags.length ? (openBlock(), createElementBlock("div", _hoisted_2$1, [
                  createVNode(_component_a_divider, {
                    class: "m-1",
                    direction: "vertical"
                  }),
                  createVNode(Tags, {
                    tags: child.tags,
                    "read-only": true,
                    size: "small"
                  }, null, 8, ["tags"])
                ])) : createCommentVNode("", true)
              ]),
              actions: withCtx(() => [
                createVNode(BrowserOperators, {
                  browser: child,
                  "icon-class": "fs-5"
                }, {
                  split: withCtx(() => [
                    createVNode(_component_a_divider, { direction: "vertical" })
                  ]),
                  _: 1
                }, 8, ["browser"]),
                createVNode(_sfc_main$8, {
                  type: "browser",
                  entity: child
                }, null, 8, ["entity"])
              ]),
              _: 2
            }, [
              child.tags.length || child.notes ? {
                name: "extra",
                fn: withCtx(() => {
                  var _a;
                  return [
                    createBaseVNode("div", _hoisted_3$1, [
                      ((_a = child.notes) == null ? void 0 : _a.trim()) ? (openBlock(), createElementBlock("div", _hoisted_4$1, [
                        createBaseVNode("span", null, toDisplayString(child.notes), 1)
                      ])) : createCommentVNode("", true)
                    ])
                  ];
                }),
                key: "0"
              } : void 0
            ]), 1032, ["entity"])) : createCommentVNode("", true)
          ], 64);
        }), 256))
      ]);
    };
  }
});
const BrowserList_vue_vue_type_style_index_0_scoped_0ba78717_lang = "";
const BrowserList = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["__scopeId", "data-v-0ba78717"]]);
const _hoisted_1$1 = {
  key: 0,
  class: "d-inline-flex align-items-center"
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "FileMultipleOperators",
  setup(__props) {
    const state = reactive({
      showChecked: false,
      selectBrowsers: [],
      pasteType: "copy",
      selectedAll: false,
      windowWidth: window.innerWidth
    });
    window.addEventListener("resize", () => {
      state.windowWidth = window.innerWidth;
    });
    const currentSources = computed(
      () => Object.keys(currentFolder.value.children).map((key) => currentFolder.value.children[key]).filter((e) => e.type === "browser")
    );
    const allSources = computed(
      () => currentSearchedEntities.value ? currentSearchedEntities.value.filter((e) => e.type === "browser") : root().findAll((e) => e.type === "browser")
    );
    const currentCheckedBrowsers = computed(() => allSources.value.filter((e) => e.checked));
    function selectAllBrowserOfCurrentFolder() {
      for (const child of currentSources.value) {
        if (child.type === "browser") {
          child.checked = true;
        }
      }
    }
    function cancelAllBrowserCheck() {
      for (const child of root().findAll((e) => e.type === "browser" && e.checked === true)) {
        if (child.type === "browser") {
          child.checked = false;
        }
      }
    }
    async function launchAll() {
      const type = ref("\u987A\u5E8F\u542F\u52A8");
      const time = ref(3);
      Modal.confirm({
        title: "\u6279\u91CF\u542F\u52A8",
        simple: false,
        okText: "\u5F00\u59CB\u6279\u91CF\u542F\u52A8",
        cancelText: "\u53D6\u6D88",
        content: () => h("div", [
          h(Row, { gutter: [24, 24] }, [
            h(Col, [
              h(Row, [
                h(Col, { flex: "140px", style: { lineHeight: "32px" } }, "\u542F\u52A8\u7C7B\u578B\uFF1A"),
                h(Col, { flex: "auto" }, [
                  h(Select, {
                    modelValue: type.value,
                    options: ["\u987A\u5E8F\u542F\u52A8", "\u5EF6\u65F6\u542F\u52A8"],
                    onChange: (value) => {
                      type.value = value.toString();
                    }
                  })
                ])
              ])
            ]),
            type.value === "\u5EF6\u65F6\u542F\u52A8" ? h(Col, [
              h(Row, [
                h(Col, { flex: "140px", style: { lineHeight: "32px" } }, "\u5EF6\u65F6\u542F\u52A8\u95F4\u9694(\u79D2)\uFF1A"),
                h(Col, { flex: "auto" }, [
                  h(Tooltip, { content: "\u6BCF\u9694\u4E00\u6BB5\u65F6\u95F4\u542F\u52A8\u6D4F\u89C8\u5668" }, [
                    h(InputNumber, {
                      modelValue: time.value,
                      placeholder: "\u8BF7\u8F93\u5165\u5EF6\u65F6\u65F6\u95F4(\u79D2)"
                    })
                  ])
                ])
              ])
            ]) : void 0
          ])
        ]),
        onOk() {
          multipleOperationRegister("\u6279\u91CF\u542F\u52A8", async (canRun) => {
            const browsers = currentCheckedBrowsers.value.map((e) => {
              if (Process.from(e.uid) === void 0) {
                return e;
              } else {
                return void 0;
              }
            }).filter((e) => e !== void 0);
            if (type.value === "\u5EF6\u65F6\u542F\u52A8") {
              for (const browser of browsers) {
                if (canRun()) {
                  browser.launch();
                  await new Promise((resolve) => setTimeout(resolve, time.value * 1e3));
                }
              }
            } else {
              for (const browser of browsers) {
                if (canRun()) {
                  await browser.launch();
                }
              }
            }
          });
        },
        maskClosable: false
      });
    }
    async function closeAll() {
      if (currentCheckedBrowsers.value.every((b) => Process.from(b.uid) === void 0)) {
        Message.warning("\u6CA1\u6709\u6D4F\u89C8\u5668\u6B63\u5728\u8FD0\u884C");
        return;
      }
      multipleOperationRegister("\u6279\u91CF\u5173\u95ED", async (canRun) => {
        for (const browser of currentCheckedBrowsers.value) {
          if (canRun()) {
            await browser.close();
          }
        }
      });
    }
    async function deleteAll() {
      Modal.warning({
        title: "\u8B66\u544A",
        simple: true,
        content: "\u662F\u5426\u8981\u5220\u9664\u6240\u9009\u7684\u6D4F\u89C8\u5668\uFF1F\u5220\u9664\u540E\u5C06\u65E0\u6CD5\u627E\u56DE\u3002",
        onOk() {
          multipleOperationRegister("\u6279\u91CF\u5220\u9664", async (canRun) => {
            var _a;
            for (const browser of currentCheckedBrowsers.value) {
              if (canRun()) {
                await ((_a = Browser.from(browser.uid)) == null ? void 0 : _a.remove());
                await new Promise((resolve) => setTimeout(resolve, 200));
              }
            }
          });
        }
      });
    }
    function copy() {
      state.selectBrowsers = currentCheckedBrowsers.value;
      state.pasteType = "copy";
    }
    function cut() {
      state.selectBrowsers = currentCheckedBrowsers.value;
      state.pasteType = "cut";
    }
    async function paste() {
      const browsers = JSON.parse(JSON.stringify(state.selectBrowsers));
      state.selectBrowsers = [];
      for (const browser of browsers) {
        const id = await Entity$1.uuid();
        browser.uid = id;
        browser.cachePath = inBrowser ? "" : await remote.path.call("join", store.paths.userDataDirsFolder, id);
        browser.parent = currentFolder.value.uid;
        browser.checked = false;
        currentFolder.value.children[id] = new Browser(browser);
      }
      if (state.pasteType === "cut") {
        for (const source of allSources.value) {
          if (source.type === "browser" && source.checked) {
            await source.remove();
          }
        }
      }
      cancelAllBrowserCheck();
    }
    async function multipleOperationRegister(name, runner) {
      let canRun = true;
      const modal = Modal.info({
        title: "\u6279\u91CF\u5316\u64CD\u4F5C",
        content: () => h("div", [h(IconSync, { spin: true }), " \u6B63\u5728\u6267\u884C\u6279\u91CF\u5316\u64CD\u4F5C\u4E2D\uFF1A " + name]),
        maskClosable: false,
        closable: false,
        simple: false,
        okText: "\u6682\u505C\u64CD\u4F5C",
        okButtonProps: {
          type: "secondary"
        },
        onOk() {
          canRun = false;
          modal.close();
        }
      });
      await runner(() => canRun);
      canRun = false;
      modal.close();
    }
    return (_ctx, _cache) => {
      const _component_a_divider = resolveComponent("a-divider");
      const _component_a_button = resolveComponent("a-button");
      const _component_a_tooltip = resolveComponent("a-tooltip");
      const _component_icon_down = resolveComponent("icon-down");
      const _component_a_doption = resolveComponent("a-doption");
      const _component_a_dropdown = resolveComponent("a-dropdown");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_col = resolveComponent("a-col");
      const _component_a_drawer = resolveComponent("a-drawer");
      const _component_a_row = resolveComponent("a-row");
      return openBlock(), createBlock(_component_a_row, { class: "col-12 p-1 ps-2 pe-2" }, {
        default: withCtx(() => [
          createVNode(_component_a_col, { flex: "auto" }, {
            default: withCtx(() => [
              createVNode(_component_a_space, { size: 0 }, {
                split: withCtx(() => [
                  createVNode(_component_a_divider, { direction: "vertical" })
                ]),
                default: withCtx(() => [
                  createBaseVNode("span", null, [
                    createVNode(_component_a_tooltip, {
                      content: `\u5171\u6709 ${currentSources.value.length} \u4E2A\u6587\u4EF6`,
                      position: "top",
                      mini: ""
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_a_button, {
                          size: "mini",
                          disabled: currentSources.value.length === 0,
                          onClick: _cache[0] || (_cache[0] = () => {
                            if (currentSources.value.length) {
                              state.selectedAll = true;
                              selectAllBrowserOfCurrentFolder();
                            }
                          })
                        }, {
                          default: withCtx(() => [..._cache[5] || (_cache[5] = [
                            createTextVNode(" \u5168\u9009 ", -1)
                          ])]),
                          _: 1
                        }, 8, ["disabled"])
                      ]),
                      _: 1
                    }, 8, ["content"]),
                    createVNode(_component_a_tooltip, {
                      content: `\u5171\u9009\u4E2D${currentCheckedBrowsers.value.length}\u4E2A\u6587\u4EF6`,
                      position: "top",
                      mini: ""
                    }, {
                      default: withCtx(() => [
                        state.selectedAll || currentCheckedBrowsers.value.length ? (openBlock(), createBlock(_component_a_button, {
                          key: 0,
                          size: "mini",
                          class: "ms-2",
                          onClick: _cache[1] || (_cache[1] = () => {
                            state.selectedAll = false;
                            cancelAllBrowserCheck();
                          })
                        }, {
                          default: withCtx(() => [..._cache[6] || (_cache[6] = [
                            createTextVNode(" \u53D6\u6D88 ", -1)
                          ])]),
                          _: 1
                        })) : createCommentVNode("", true)
                      ]),
                      _: 1
                    }, 8, ["content"])
                  ]),
                  currentCheckedBrowsers.value.length ? (openBlock(), createBlock(_component_a_tooltip, {
                    key: 0,
                    content: `\u5171\u9009\u4E2D${currentCheckedBrowsers.value.length}\u4E2A\u6587\u4EF6`,
                    position: "top",
                    mini: ""
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_a_dropdown, null, {
                        content: withCtx(() => [
                          createVNode(_component_a_doption, {
                            class: "border-bottom",
                            size: "mini",
                            type: "text",
                            onClick: _cache[2] || (_cache[2] = ($event) => state.showChecked = true)
                          }, {
                            default: withCtx(() => [..._cache[8] || (_cache[8] = [
                              createTextVNode(" \u67E5\u770B ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, {
                            style: { "width": "100px" },
                            onClick: copy
                          }, {
                            default: withCtx(() => [..._cache[9] || (_cache[9] = [
                              createTextVNode(" \u590D\u5236 ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, { onClick: cut }, {
                            default: withCtx(() => [..._cache[10] || (_cache[10] = [
                              createTextVNode(" \u526A\u5207 ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, {
                            class: "border-bottom",
                            disabled: state.selectBrowsers.length === 0,
                            onClick: paste
                          }, {
                            default: withCtx(() => [..._cache[11] || (_cache[11] = [
                              createTextVNode(" \u7C98\u8D34 ", -1)
                            ])]),
                            _: 1
                          }, 8, ["disabled"]),
                          createVNode(_component_a_doption, { onClick: launchAll }, {
                            default: withCtx(() => [..._cache[12] || (_cache[12] = [
                              createTextVNode(" \u6279\u91CF\u8FD0\u884C ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, { onClick: closeAll }, {
                            default: withCtx(() => [..._cache[13] || (_cache[13] = [
                              createTextVNode(" \u6279\u91CF\u5173\u95ED ", -1)
                            ])]),
                            _: 1
                          }),
                          createVNode(_component_a_doption, { onClick: deleteAll }, {
                            default: withCtx(() => [..._cache[14] || (_cache[14] = [
                              createTextVNode(" \u6279\u91CF\u5220\u9664 ", -1)
                            ])]),
                            _: 1
                          })
                        ]),
                        default: withCtx(() => [
                          createVNode(_component_a_button, { size: "mini" }, {
                            default: withCtx(() => [
                              _cache[7] || (_cache[7] = createTextVNode(" \u6279\u91CF\u64CD\u4F5C ", -1)),
                              createVNode(_component_icon_down)
                            ]),
                            _: 1
                          })
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  }, 8, ["content"])) : createCommentVNode("", true)
                ]),
                _: 1
              }),
              unref(currentFolder).parent ? (openBlock(), createElementBlock("div", _hoisted_1$1, [
                createBaseVNode("div", null, [
                  createVNode(_component_a_divider, { direction: "vertical" })
                ]),
                createVNode(_component_a_button, {
                  type: "outline",
                  size: "mini",
                  onClick: _cache[3] || (_cache[3] = () => {
                    var _a;
                    (_a = unref(currentFolder).flatParents().at(-2)) == null ? void 0 : _a.select();
                  })
                }, {
                  default: withCtx(() => [
                    createTextVNode(" \u8FD4\u56DE\u4E0A\u4E00\u7EA7 " + toDisplayString(), 1)
                  ]),
                  _: 1
                })
              ])) : createCommentVNode("", true)
            ]),
            _: 1
          }),
          unref(currentSearchedEntities) === void 0 ? (openBlock(), createBlock(_sfc_main$4, { key: 0 })) : createCommentVNode("", true),
          createVNode(_component_a_drawer, {
            visible: state.showChecked,
            "onUpdate:visible": _cache[4] || (_cache[4] = ($event) => state.showChecked = $event),
            title: `\u5DF2\u9009\u4E2D ${currentCheckedBrowsers.value.length} \u4E2A\u6587\u4EF6`,
            width: state.windowWidth * 0.8,
            footer: false
          }, {
            default: withCtx(() => [
              createVNode(BrowserList, { entities: currentCheckedBrowsers.value }, null, 8, ["entities"])
            ]),
            _: 1
          }, 8, ["visible", "title", "width"])
        ]),
        _: 1
      });
    };
  }
});
const FileMultipleOperators_vue_vue_type_style_index_0_scoped_eb1418b9_lang = "";
const FileMultipleOperators = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-eb1418b9"]]);
const _hoisted_1 = {
  id: "browsers",
  class: "h-100"
};
const _hoisted_2 = { class: "shadow" };
const _hoisted_3 = { key: 0 };
const _hoisted_4 = { key: 1 };
const _hoisted_5 = { key: 2 };
const _hoisted_6 = { class: "col-12 p-1 ps-2 pe-2 operations" };
const _hoisted_7 = {
  key: 1,
  class: "d-flex",
  style: { "height": "50vh" }
};
const _hoisted_8 = {
  key: 3,
  class: "col-12 p-2 pt-1 entities-container"
};
const _hoisted_9 = { class: "entities" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  setup(__props) {
    const state = reactive({
      isCurrentBrowserSupported: true,
      supportedBrowser: null,
      supportedExtension: null,
      validUserScript: null,
      setupVisible: false
    });
    watch(
      () => [store.render.state.setup, state.setupVisible],
      () => {
        updateEnvironmentDetect();
      }
    );
    onActivated(() => {
      updateEnvironmentDetect();
    });
    async function updateEnvironmentDetect() {
      await Environment.init();
      const [isCurrentBrowserSupported, supportedBrowser, supportedExtension, validUserScript] = await Promise.all([
        Environment.isCurrentBrowserSupported(),
        Environment.getSupportedBrowser(),
        Environment.getSupportedExtension(),
        Environment.getValidUserScript()
      ]);
      state.isCurrentBrowserSupported = isCurrentBrowserSupported;
      state.supportedBrowser = supportedBrowser;
      state.supportedExtension = supportedExtension;
      state.validUserScript = validUserScript;
    }
    return (_ctx, _cache) => {
      const _component_a_button = resolveComponent("a-button");
      const _component_a_alert = resolveComponent("a-alert");
      const _component_a_space = resolveComponent("a-space");
      const _component_a_empty = resolveComponent("a-empty");
      const _component_a_spin = resolveComponent("a-spin");
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_a_spin, {
          class: "w-100 h-100",
          loading: !state.isCurrentBrowserSupported || state.supportedBrowser === void 0 || state.supportedExtension === void 0 || state.validUserScript === void 0
        }, {
          icon: withCtx(() => [
            createBaseVNode("div", _hoisted_2, [
              createVNode(_component_a_alert, {
                title: "\u8F6F\u4EF6\u5F02\u5E38",
                style: { "width": "600px" },
                class: "rounded",
                type: "error",
                "show-icon": ""
              }, {
                default: withCtx(() => [
                  createBaseVNode("div", null, toDisplayString(unref(lang)("browser_page_environment_error_notice", "\u8F6F\u4EF6\u73AF\u5883\u5B58\u5728\u95EE\u9898\uFF0C\u5C06\u4F1A\u5F71\u54CD\u6D4F\u89C8\u5668\u7684\u6B63\u5E38\u542F\u52A8")), 1),
                  !state.isCurrentBrowserSupported ? (openBlock(), createElementBlock("div", _hoisted_3, " \u539F\u56E0\uFF1A" + toDisplayString(unref(lang)("browser_page_environment_error_current_browser_not_supported", "\u5F53\u524D\u6D4F\u89C8\u5668\u7248\u672C\u4E0D\u53D7\u652F\u6301")), 1)) : !state.supportedBrowser ? (openBlock(), createElementBlock("div", _hoisted_4, "\u539F\u56E0\uFF1A" + toDisplayString(unref(lang)("browser_page_environment_error_no_browser_detected", "\u672A\u68C0\u6D4B\u5230\u53EF\u7528\u7684\u6D4F\u89C8\u5668")), 1)) : !state.supportedExtension ? (openBlock(), createElementBlock("div", _hoisted_5, "\u539F\u56E0\uFF1A" + toDisplayString(unref(lang)("browser_page_environment_error_no_extension_detected", "\u672A\u5B89\u88C5\u811A\u672C\u7BA1\u7406\u5668")), 1)) : createCommentVNode("", true),
                  createVNode(_component_a_button, {
                    class: "mt-2",
                    size: "mini",
                    type: "primary",
                    onClick: _cache[0] || (_cache[0] = ($event) => state.setupVisible = true)
                  }, {
                    default: withCtx(() => [..._cache[4] || (_cache[4] = [
                      createTextVNode(" \u4E00\u952E\u4FEE\u590D ", -1)
                    ])]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ])
          ]),
          default: withCtx(() => [
            state.setupVisible ? (openBlock(), createBlock(Setup, {
              key: 0,
              visible: state.setupVisible,
              "onUpdate:visible": _cache[1] || (_cache[1] = ($event) => state.setupVisible = $event),
              "confirm-text": "\u73AF\u5883\u4FEE\u590D",
              "cancel-text": "\u7A0D\u540E\u518D\u8BF4",
              "create-new-browser": false,
              onClose: _cache[2] || (_cache[2] = async () => {
                state.setupVisible = false;
                await updateEnvironmentDetect();
              })
            }, null, 8, ["visible"])) : createCommentVNode("", true),
            createBaseVNode("div", _hoisted_6, [
              withDirectives(createVNode(FileBreadcrumb, null, null, 512), [
                [vShow, unref(currentSearchedEntities) === void 0]
              ]),
              createVNode(_sfc_main$7),
              unref(currentSearchedEntities) ? (openBlock(), createBlock(_component_a_button, {
                key: 0,
                size: "mini",
                onClick: unref(resetSearch)
              }, {
                default: withCtx(() => [
                  createVNode(Icon, { type: "restart_alt" }, {
                    default: withCtx(() => [..._cache[5] || (_cache[5] = [
                      createTextVNode(" \u91CD\u7F6E ", -1)
                    ])]),
                    _: 1
                  })
                ]),
                _: 1
              }, 8, ["onClick"])) : createCommentVNode("", true)
            ]),
            createVNode(FileMultipleOperators),
            unref(currentEntities).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_7, [
              createVNode(_component_a_empty, { class: "p-3 m-auto" }, {
                default: withCtx(() => [
                  _cache[8] || (_cache[8] = createBaseVNode("div", { class: "mb-3" }, "\u6682\u65E0\u6D4F\u89C8\u5668", -1)),
                  createVNode(_component_a_space, null, {
                    default: withCtx(() => [
                      createVNode(_component_a_button, {
                        type: "outline",
                        size: "mini",
                        onClick: unref(about)
                      }, {
                        default: withCtx(() => [
                          createVNode(Icon, { type: "book" }, {
                            default: withCtx(() => [..._cache[6] || (_cache[6] = [
                              createTextVNode("\u70B9\u51FB\u67E5\u770B\u4F7F\u7528\u6559\u7A0B", -1)
                            ])]),
                            _: 1
                          })
                        ]),
                        _: 1
                      }, 8, ["onClick"]),
                      createVNode(_component_a_button, {
                        type: "outline",
                        size: "mini",
                        onClick: _cache[3] || (_cache[3] = ($event) => unref(newBrowser)())
                      }, {
                        default: withCtx(() => [
                          createVNode(Icon, { type: "web" }, {
                            default: withCtx(() => [..._cache[7] || (_cache[7] = [
                              createTextVNode("\u65B0\u5EFA\u6D4F\u89C8\u5668", -1)
                            ])]),
                            _: 1
                          })
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ])) : unref(currentSearchedEntities) !== void 0 && unref(currentSearchedEntities).length === 0 ? (openBlock(), createBlock(_component_a_empty, {
              key: 2,
              class: "p-3",
              description: "\u6682\u65E0\u6D4F\u89C8\u5668\u641C\u7D22\u7ED3\u679C"
            })) : (openBlock(), createElementBlock("div", _hoisted_8, [
              createBaseVNode("div", _hoisted_9, [
                createVNode(BrowserList, {
                  entities: unref(currentSearchedEntities) ? unref(currentSearchedEntities) : unref(currentEntities)
                }, null, 8, ["entities"])
              ])
            ]))
          ]),
          _: 1
        }, 8, ["loading"])
      ]);
    };
  }
});
const index_vue_vue_type_style_index_0_scoped_fb6714d9_lang = "";
const index = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-fb6714d9"]]);
export {
  index as default
};
