var MAX_UINT32 = Math.pow(2, 32);
var getUint64$1 = function(uint8) {
  var dv = new DataView(uint8.buffer, uint8.byteOffset, uint8.byteLength);
  var value;
  if (dv.getBigUint64) {
    value = dv.getBigUint64(0);
    if (value < Number.MAX_SAFE_INTEGER) {
      return Number(value);
    }
    return value;
  }
  return dv.getUint32(0) * MAX_UINT32 + dv.getUint32(4);
};
var numbers = {
  getUint64: getUint64$1,
  MAX_UINT32
};
var getUint64 = numbers.getUint64;
var parseSidx = function(data) {
  var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
    version: data[0],
    flags: new Uint8Array(data.subarray(1, 4)),
    references: [],
    referenceId: view.getUint32(4),
    timescale: view.getUint32(8)
  }, i = 12;
  if (result.version === 0) {
    result.earliestPresentationTime = view.getUint32(i);
    result.firstOffset = view.getUint32(i + 4);
    i += 8;
  } else {
    result.earliestPresentationTime = getUint64(data.subarray(i));
    result.firstOffset = getUint64(data.subarray(i + 8));
    i += 16;
  }
  i += 2;
  var referenceCount = view.getUint16(i);
  i += 2;
  for (; referenceCount > 0; i += 12, referenceCount--) {
    result.references.push({
      referenceType: (data[i] & 128) >>> 7,
      referencedSize: view.getUint32(i) & 2147483647,
      subsegmentDuration: view.getUint32(i + 4),
      startsWithSap: !!(data[i + 8] & 128),
      sapType: (data[i + 8] & 112) >>> 4,
      sapDeltaTime: view.getUint32(i + 8) & 268435455
    });
  }
  return result;
};
var parseSidx_1 = parseSidx;
var ONE_SECOND_IN_TS = 9e4, secondsToVideoTs, secondsToAudioTs, videoTsToSeconds, audioTsToSeconds, audioTsToVideoTs, videoTsToAudioTs, metadataTsToSeconds;
secondsToVideoTs = function(seconds) {
  return seconds * ONE_SECOND_IN_TS;
};
secondsToAudioTs = function(seconds, sampleRate) {
  return seconds * sampleRate;
};
videoTsToSeconds = function(timestamp) {
  return timestamp / ONE_SECOND_IN_TS;
};
audioTsToSeconds = function(timestamp, sampleRate) {
  return timestamp / sampleRate;
};
audioTsToVideoTs = function(timestamp, sampleRate) {
  return secondsToVideoTs(audioTsToSeconds(timestamp, sampleRate));
};
videoTsToAudioTs = function(timestamp, sampleRate) {
  return secondsToAudioTs(videoTsToSeconds(timestamp), sampleRate);
};
metadataTsToSeconds = function(timestamp, timelineStartPts, keepOriginalTimestamps) {
  return videoTsToSeconds(keepOriginalTimestamps ? timestamp : timestamp - timelineStartPts);
};
var clock = {
  ONE_SECOND_IN_TS,
  secondsToVideoTs,
  secondsToAudioTs,
  videoTsToSeconds,
  audioTsToSeconds,
  audioTsToVideoTs,
  videoTsToAudioTs,
  metadataTsToSeconds
};
export {
  clock as c,
  parseSidx_1 as p
};
