import { d as document_1, w as window_1 } from "./global.dfc622c4.js";
import { l as lib, D as DEFAULT_VIDEO_CODEC, a as DEFAULT_AUDIO_CODEC, p as parseCodecs, m as muxerSupportsCodec, b as browserSupportsCodec, r as resolveUrl$1, t as translateLegacyCodec, c as codecsFromDefault, s as simpleTypeFromSourceType, i as isAudioCodec, g as getMimeForCodec, e as isArrayBufferView, h as concatTypedArrays, j as stringToBytes, k as getId3Offset, n as detectContainerForBytes, o as toUint8, q as isLikelyFmp4MediaSegment } from "./@videojs.e887769e.js";
import { b as browserIndex } from "./videojs-vtt.js.a6c4ef9e.js";
import { _ as _extends } from "./@babel.dac5e1c0.js";
import { P as Parser } from "./m3u8-parser.427a5d14.js";
import { g as generateSidxKey, p as parseUTCTiming, a as parse, b as addSidxSegmentsToPlaylist$1 } from "./mpd-parser.9d338e3c.js";
import { c as clock, p as parseSidx_1 } from "./mux.js.f617263a.js";
const videoJs = "";
/**
 * @license
 * Video.js 8.23.4 <http://videojs.com/>
 * Copyright Brightcove, Inc. <https://www.brightcove.com/>
 * Available under Apache License Version 2.0
 * <https://github.com/videojs/video.js/blob/main/LICENSE>
 *
 * Includes vtt.js <https://github.com/mozilla/vtt.js>
 * Available under Apache License Version 2.0
 * <https://github.com/mozilla/vtt.js/blob/main/LICENSE>
 */
var version$6 = "8.23.4";
const hooks_ = {};
const hooks = function(type, fn) {
  hooks_[type] = hooks_[type] || [];
  if (fn) {
    hooks_[type] = hooks_[type].concat(fn);
  }
  return hooks_[type];
};
const hook = function(type, fn) {
  hooks(type, fn);
};
const removeHook = function(type, fn) {
  const index = hooks(type).indexOf(fn);
  if (index <= -1) {
    return false;
  }
  hooks_[type] = hooks_[type].slice();
  hooks_[type].splice(index, 1);
  return true;
};
const hookOnce = function(type, fn) {
  hooks(type, [].concat(fn).map((original) => {
    const wrapper = (...args) => {
      removeHook(type, wrapper);
      return original(...args);
    };
    return wrapper;
  }));
};
const FullscreenApi = {
  prefixed: true
};
const apiMap = [
  ["requestFullscreen", "exitFullscreen", "fullscreenElement", "fullscreenEnabled", "fullscreenchange", "fullscreenerror", "fullscreen"],
  ["webkitRequestFullscreen", "webkitExitFullscreen", "webkitFullscreenElement", "webkitFullscreenEnabled", "webkitfullscreenchange", "webkitfullscreenerror", "-webkit-full-screen"]
];
const specApi = apiMap[0];
let browserApi;
for (let i = 0; i < apiMap.length; i++) {
  if (apiMap[i][1] in document_1) {
    browserApi = apiMap[i];
    break;
  }
}
if (browserApi) {
  for (let i = 0; i < browserApi.length; i++) {
    FullscreenApi[specApi[i]] = browserApi[i];
  }
  FullscreenApi.prefixed = browserApi[0] !== specApi[0];
}
let history = [];
const LogByTypeFactory = (name, log2, styles) => (type, level, args) => {
  const lvl = log2.levels[level];
  const lvlRegExp = new RegExp(`^(${lvl})$`);
  let resultName = name;
  if (type !== "log") {
    args.unshift(type.toUpperCase() + ":");
  }
  if (styles) {
    resultName = `%c${name}`;
    args.unshift(styles);
  }
  args.unshift(resultName + ":");
  if (history) {
    history.push([].concat(args));
    const splice = history.length - 1e3;
    history.splice(0, splice > 0 ? splice : 0);
  }
  if (!window_1.console) {
    return;
  }
  let fn = window_1.console[type];
  if (!fn && type === "debug") {
    fn = window_1.console.info || window_1.console.log;
  }
  if (!fn || !lvl || !lvlRegExp.test(type)) {
    return;
  }
  fn[Array.isArray(args) ? "apply" : "call"](window_1.console, args);
};
function createLogger$1(name, delimiter = ":", styles = "") {
  let level = "info";
  let logByType;
  function log2(...args) {
    logByType("log", level, args);
  }
  logByType = LogByTypeFactory(name, log2, styles);
  log2.createLogger = (subName, subDelimiter, subStyles) => {
    const resultDelimiter = subDelimiter !== void 0 ? subDelimiter : delimiter;
    const resultStyles = subStyles !== void 0 ? subStyles : styles;
    const resultName = `${name} ${resultDelimiter} ${subName}`;
    return createLogger$1(resultName, resultDelimiter, resultStyles);
  };
  log2.createNewLogger = (newName, newDelimiter, newStyles) => {
    return createLogger$1(newName, newDelimiter, newStyles);
  };
  log2.levels = {
    all: "debug|log|warn|error",
    off: "",
    debug: "debug|log|warn|error",
    info: "log|warn|error",
    warn: "warn|error",
    error: "error",
    DEFAULT: level
  };
  log2.level = (lvl) => {
    if (typeof lvl === "string") {
      if (!log2.levels.hasOwnProperty(lvl)) {
        throw new Error(`"${lvl}" in not a valid log level`);
      }
      level = lvl;
    }
    return level;
  };
  log2.history = () => history ? [].concat(history) : [];
  log2.history.filter = (fname) => {
    return (history || []).filter((historyItem) => {
      return new RegExp(`.*${fname}.*`).test(historyItem[0]);
    });
  };
  log2.history.clear = () => {
    if (history) {
      history.length = 0;
    }
  };
  log2.history.disable = () => {
    if (history !== null) {
      history.length = 0;
      history = null;
    }
  };
  log2.history.enable = () => {
    if (history === null) {
      history = [];
    }
  };
  log2.error = (...args) => logByType("error", level, args);
  log2.warn = (...args) => logByType("warn", level, args);
  log2.debug = (...args) => logByType("debug", level, args);
  return log2;
}
const log$1 = createLogger$1("VIDEOJS");
const createLogger = log$1.createLogger;
const toString = Object.prototype.toString;
const keys = function(object) {
  return isObject(object) ? Object.keys(object) : [];
};
function each(object, fn) {
  keys(object).forEach((key) => fn(object[key], key));
}
function reduce(object, fn, initial = 0) {
  return keys(object).reduce((accum, key) => fn(accum, object[key], key), initial);
}
function isObject(value) {
  return !!value && typeof value === "object";
}
function isPlain(value) {
  return isObject(value) && toString.call(value) === "[object Object]" && value.constructor === Object;
}
function merge$1(...sources) {
  const result = {};
  sources.forEach((source) => {
    if (!source) {
      return;
    }
    each(source, (value, key) => {
      if (!isPlain(value)) {
        result[key] = value;
        return;
      }
      if (!isPlain(result[key])) {
        result[key] = {};
      }
      result[key] = merge$1(result[key], value);
    });
  });
  return result;
}
function values(source = {}) {
  const result = [];
  for (const key in source) {
    if (source.hasOwnProperty(key)) {
      const value = source[key];
      result.push(value);
    }
  }
  return result;
}
function defineLazyProperty(obj, key, getValue, setter = true) {
  const set2 = (value) => Object.defineProperty(obj, key, {
    value,
    enumerable: true,
    writable: true
  });
  const options = {
    configurable: true,
    enumerable: true,
    get() {
      const value = getValue();
      set2(value);
      return value;
    }
  };
  if (setter) {
    options.set = set2;
  }
  return Object.defineProperty(obj, key, options);
}
var Obj = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  each,
  reduce,
  isObject,
  isPlain,
  merge: merge$1,
  values,
  defineLazyProperty
});
let IS_IPOD = false;
let IOS_VERSION = null;
let IS_ANDROID = false;
let ANDROID_VERSION;
let IS_FIREFOX = false;
let IS_EDGE = false;
let IS_CHROMIUM = false;
let IS_CHROME = false;
let CHROMIUM_VERSION = null;
let CHROME_VERSION = null;
const IS_CHROMECAST_RECEIVER = Boolean(window_1.cast && window_1.cast.framework && window_1.cast.framework.CastReceiverContext);
let IE_VERSION = null;
let IS_SAFARI = false;
let IS_WINDOWS = false;
let IS_IPAD = false;
let IS_IPHONE = false;
let IS_TIZEN = false;
let IS_WEBOS = false;
let IS_SMART_TV = false;
const TOUCH_ENABLED = Boolean(isReal() && ("ontouchstart" in window_1 || window_1.navigator.maxTouchPoints || window_1.DocumentTouch && window_1.document instanceof window_1.DocumentTouch));
const UAD = window_1.navigator && window_1.navigator.userAgentData;
if (UAD && UAD.platform && UAD.brands) {
  IS_ANDROID = UAD.platform === "Android";
  IS_EDGE = Boolean(UAD.brands.find((b) => b.brand === "Microsoft Edge"));
  IS_CHROMIUM = Boolean(UAD.brands.find((b) => b.brand === "Chromium"));
  IS_CHROME = !IS_EDGE && IS_CHROMIUM;
  CHROMIUM_VERSION = CHROME_VERSION = (UAD.brands.find((b) => b.brand === "Chromium") || {}).version || null;
  IS_WINDOWS = UAD.platform === "Windows";
}
if (!IS_CHROMIUM) {
  const USER_AGENT = window_1.navigator && window_1.navigator.userAgent || "";
  IS_IPOD = /iPod/i.test(USER_AGENT);
  IOS_VERSION = function() {
    const match = USER_AGENT.match(/OS (\d+)_/i);
    if (match && match[1]) {
      return match[1];
    }
    return null;
  }();
  IS_ANDROID = /Android/i.test(USER_AGENT);
  ANDROID_VERSION = function() {
    const match = USER_AGENT.match(/Android (\d+)(?:\.(\d+))?(?:\.(\d+))*/i);
    if (!match) {
      return null;
    }
    const major = match[1] && parseFloat(match[1]);
    const minor = match[2] && parseFloat(match[2]);
    if (major && minor) {
      return parseFloat(match[1] + "." + match[2]);
    } else if (major) {
      return major;
    }
    return null;
  }();
  IS_FIREFOX = /Firefox/i.test(USER_AGENT);
  IS_EDGE = /Edg/i.test(USER_AGENT);
  IS_CHROMIUM = /Chrome/i.test(USER_AGENT) || /CriOS/i.test(USER_AGENT);
  IS_CHROME = !IS_EDGE && IS_CHROMIUM;
  CHROMIUM_VERSION = CHROME_VERSION = function() {
    const match = USER_AGENT.match(/(Chrome|CriOS)\/(\d+)/);
    if (match && match[2]) {
      return parseFloat(match[2]);
    }
    return null;
  }();
  IE_VERSION = function() {
    const result = /MSIE\s(\d+)\.\d/.exec(USER_AGENT);
    let version2 = result && parseFloat(result[1]);
    if (!version2 && /Trident\/7.0/i.test(USER_AGENT) && /rv:11.0/.test(USER_AGENT)) {
      version2 = 11;
    }
    return version2;
  }();
  IS_TIZEN = /Tizen/i.test(USER_AGENT);
  IS_WEBOS = /Web0S/i.test(USER_AGENT);
  IS_SMART_TV = IS_TIZEN || IS_WEBOS;
  IS_SAFARI = /Safari/i.test(USER_AGENT) && !IS_CHROME && !IS_ANDROID && !IS_EDGE && !IS_SMART_TV;
  IS_WINDOWS = /Windows/i.test(USER_AGENT);
  IS_IPAD = /iPad/i.test(USER_AGENT) || IS_SAFARI && TOUCH_ENABLED && !/iPhone/i.test(USER_AGENT);
  IS_IPHONE = /iPhone/i.test(USER_AGENT) && !IS_IPAD;
}
const IS_IOS = IS_IPHONE || IS_IPAD || IS_IPOD;
const IS_ANY_SAFARI = (IS_SAFARI || IS_IOS) && !IS_CHROME;
var browser = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  get IS_IPOD() {
    return IS_IPOD;
  },
  get IOS_VERSION() {
    return IOS_VERSION;
  },
  get IS_ANDROID() {
    return IS_ANDROID;
  },
  get ANDROID_VERSION() {
    return ANDROID_VERSION;
  },
  get IS_FIREFOX() {
    return IS_FIREFOX;
  },
  get IS_EDGE() {
    return IS_EDGE;
  },
  get IS_CHROMIUM() {
    return IS_CHROMIUM;
  },
  get IS_CHROME() {
    return IS_CHROME;
  },
  get CHROMIUM_VERSION() {
    return CHROMIUM_VERSION;
  },
  get CHROME_VERSION() {
    return CHROME_VERSION;
  },
  IS_CHROMECAST_RECEIVER,
  get IE_VERSION() {
    return IE_VERSION;
  },
  get IS_SAFARI() {
    return IS_SAFARI;
  },
  get IS_WINDOWS() {
    return IS_WINDOWS;
  },
  get IS_IPAD() {
    return IS_IPAD;
  },
  get IS_IPHONE() {
    return IS_IPHONE;
  },
  get IS_TIZEN() {
    return IS_TIZEN;
  },
  get IS_WEBOS() {
    return IS_WEBOS;
  },
  get IS_SMART_TV() {
    return IS_SMART_TV;
  },
  TOUCH_ENABLED,
  IS_IOS,
  IS_ANY_SAFARI
});
function isNonBlankString(str) {
  return typeof str === "string" && Boolean(str.trim());
}
function throwIfWhitespace(str) {
  if (str.indexOf(" ") >= 0) {
    throw new Error("class has illegal whitespace characters");
  }
}
function isReal() {
  return document_1 === window_1.document;
}
function isEl(value) {
  return isObject(value) && value.nodeType === 1;
}
function isInFrame() {
  try {
    return window_1.parent !== window_1.self;
  } catch (x) {
    return true;
  }
}
function createQuerier(method) {
  return function(selector, context) {
    if (!isNonBlankString(selector)) {
      return document_1[method](null);
    }
    if (isNonBlankString(context)) {
      context = document_1.querySelector(context);
    }
    const ctx = isEl(context) ? context : document_1;
    return ctx[method] && ctx[method](selector);
  };
}
function createEl(tagName = "div", properties = {}, attributes = {}, content) {
  const el = document_1.createElement(tagName);
  Object.getOwnPropertyNames(properties).forEach(function(propName) {
    const val = properties[propName];
    if (propName === "textContent") {
      textContent(el, val);
    } else if (el[propName] !== val || propName === "tabIndex") {
      el[propName] = val;
    }
  });
  Object.getOwnPropertyNames(attributes).forEach(function(attrName) {
    el.setAttribute(attrName, attributes[attrName]);
  });
  if (content) {
    appendContent(el, content);
  }
  return el;
}
function textContent(el, text) {
  if (typeof el.textContent === "undefined") {
    el.innerText = text;
  } else {
    el.textContent = text;
  }
  return el;
}
function prependTo(child, parent) {
  if (parent.firstChild) {
    parent.insertBefore(child, parent.firstChild);
  } else {
    parent.appendChild(child);
  }
}
function hasClass(element, classToCheck) {
  throwIfWhitespace(classToCheck);
  return element.classList.contains(classToCheck);
}
function addClass(element, ...classesToAdd) {
  element.classList.add(...classesToAdd.reduce((prev, current) => prev.concat(current.split(/\s+/)), []));
  return element;
}
function removeClass(element, ...classesToRemove) {
  if (!element) {
    log$1.warn("removeClass was called with an element that doesn't exist");
    return null;
  }
  element.classList.remove(...classesToRemove.reduce((prev, current) => prev.concat(current.split(/\s+/)), []));
  return element;
}
function toggleClass(element, classToToggle, predicate) {
  if (typeof predicate === "function") {
    predicate = predicate(element, classToToggle);
  }
  if (typeof predicate !== "boolean") {
    predicate = void 0;
  }
  classToToggle.split(/\s+/).forEach((className) => element.classList.toggle(className, predicate));
  return element;
}
function setAttributes(el, attributes) {
  Object.getOwnPropertyNames(attributes).forEach(function(attrName) {
    const attrValue = attributes[attrName];
    if (attrValue === null || typeof attrValue === "undefined" || attrValue === false) {
      el.removeAttribute(attrName);
    } else {
      el.setAttribute(attrName, attrValue === true ? "" : attrValue);
    }
  });
}
function getAttributes(tag) {
  const obj = {};
  const knownBooleans = ["autoplay", "controls", "playsinline", "loop", "muted", "default", "defaultMuted"];
  if (tag && tag.attributes && tag.attributes.length > 0) {
    const attrs = tag.attributes;
    for (let i = attrs.length - 1; i >= 0; i--) {
      const attrName = attrs[i].name;
      let attrVal = attrs[i].value;
      if (knownBooleans.includes(attrName)) {
        attrVal = attrVal !== null ? true : false;
      }
      obj[attrName] = attrVal;
    }
  }
  return obj;
}
function getAttribute(el, attribute) {
  return el.getAttribute(attribute);
}
function setAttribute(el, attribute, value) {
  el.setAttribute(attribute, value);
}
function removeAttribute(el, attribute) {
  el.removeAttribute(attribute);
}
function blockTextSelection() {
  document_1.body.focus();
  document_1.onselectstart = function() {
    return false;
  };
}
function unblockTextSelection() {
  document_1.onselectstart = function() {
    return true;
  };
}
function getBoundingClientRect(el) {
  if (el && el.getBoundingClientRect && el.parentNode) {
    const rect = el.getBoundingClientRect();
    const result = {};
    ["bottom", "height", "left", "right", "top", "width"].forEach((k) => {
      if (rect[k] !== void 0) {
        result[k] = rect[k];
      }
    });
    if (!result.height) {
      result.height = parseFloat(computedStyle(el, "height"));
    }
    if (!result.width) {
      result.width = parseFloat(computedStyle(el, "width"));
    }
    return result;
  }
}
function findPosition(el) {
  if (!el || el && !el.offsetParent) {
    return {
      left: 0,
      top: 0,
      width: 0,
      height: 0
    };
  }
  const width = el.offsetWidth;
  const height = el.offsetHeight;
  let left = 0;
  let top = 0;
  while (el.offsetParent && el !== document_1[FullscreenApi.fullscreenElement]) {
    left += el.offsetLeft;
    top += el.offsetTop;
    el = el.offsetParent;
  }
  return {
    left,
    top,
    width,
    height
  };
}
function getPointerPosition(el, event) {
  const translated = {
    x: 0,
    y: 0
  };
  if (IS_IOS) {
    let item = el;
    while (item && item.nodeName.toLowerCase() !== "html") {
      const transform2 = computedStyle(item, "transform");
      if (/^matrix/.test(transform2)) {
        const values2 = transform2.slice(7, -1).split(/,\s/).map(Number);
        translated.x += values2[4];
        translated.y += values2[5];
      } else if (/^matrix3d/.test(transform2)) {
        const values2 = transform2.slice(9, -1).split(/,\s/).map(Number);
        translated.x += values2[12];
        translated.y += values2[13];
      }
      if (item.assignedSlot && item.assignedSlot.parentElement && window_1.WebKitCSSMatrix) {
        const transformValue = window_1.getComputedStyle(item.assignedSlot.parentElement).transform;
        const matrix = new window_1.WebKitCSSMatrix(transformValue);
        translated.x += matrix.m41;
        translated.y += matrix.m42;
      }
      item = item.parentNode || item.host;
    }
  }
  const position = {};
  const boxTarget = findPosition(event.target);
  const box = findPosition(el);
  const boxW = box.width;
  const boxH = box.height;
  let offsetY = event.offsetY - (box.top - boxTarget.top);
  let offsetX = event.offsetX - (box.left - boxTarget.left);
  if (event.changedTouches) {
    offsetX = event.changedTouches[0].pageX - box.left;
    offsetY = event.changedTouches[0].pageY + box.top;
    if (IS_IOS) {
      offsetX -= translated.x;
      offsetY -= translated.y;
    }
  }
  position.y = 1 - Math.max(0, Math.min(1, offsetY / boxH));
  position.x = Math.max(0, Math.min(1, offsetX / boxW));
  return position;
}
function isTextNode(value) {
  return isObject(value) && value.nodeType === 3;
}
function emptyEl(el) {
  while (el.firstChild) {
    el.removeChild(el.firstChild);
  }
  return el;
}
function normalizeContent(content) {
  if (typeof content === "function") {
    content = content();
  }
  return (Array.isArray(content) ? content : [content]).map((value) => {
    if (typeof value === "function") {
      value = value();
    }
    if (isEl(value) || isTextNode(value)) {
      return value;
    }
    if (typeof value === "string" && /\S/.test(value)) {
      return document_1.createTextNode(value);
    }
  }).filter((value) => value);
}
function appendContent(el, content) {
  normalizeContent(content).forEach((node) => el.appendChild(node));
  return el;
}
function insertContent(el, content) {
  return appendContent(emptyEl(el), content);
}
function isSingleLeftClick(event) {
  if (event.button === void 0 && event.buttons === void 0) {
    return true;
  }
  if (event.button === 0 && event.buttons === void 0) {
    return true;
  }
  if (event.type === "mouseup" && event.button === 0 && event.buttons === 0) {
    return true;
  }
  if (event.type === "mousedown" && event.button === 0 && event.buttons === 0) {
    return true;
  }
  if (event.button !== 0 || event.buttons !== 1) {
    return false;
  }
  return true;
}
const $ = createQuerier("querySelector");
const $$ = createQuerier("querySelectorAll");
function computedStyle(el, prop) {
  if (!el || !prop) {
    return "";
  }
  if (typeof window_1.getComputedStyle === "function") {
    let computedStyleValue;
    try {
      computedStyleValue = window_1.getComputedStyle(el);
    } catch (e) {
      return "";
    }
    return computedStyleValue ? computedStyleValue.getPropertyValue(prop) || computedStyleValue[prop] : "";
  }
  return "";
}
function copyStyleSheetsToWindow(win) {
  [...document_1.styleSheets].forEach((styleSheet) => {
    try {
      const cssRules = [...styleSheet.cssRules].map((rule) => rule.cssText).join("");
      const style = document_1.createElement("style");
      style.textContent = cssRules;
      win.document.head.appendChild(style);
    } catch (e) {
      const link = document_1.createElement("link");
      link.rel = "stylesheet";
      link.type = styleSheet.type;
      link.media = styleSheet.media.mediaText;
      link.href = styleSheet.href;
      win.document.head.appendChild(link);
    }
  });
}
var Dom = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  isReal,
  isEl,
  isInFrame,
  createEl,
  textContent,
  prependTo,
  hasClass,
  addClass,
  removeClass,
  toggleClass,
  setAttributes,
  getAttributes,
  getAttribute,
  setAttribute,
  removeAttribute,
  blockTextSelection,
  unblockTextSelection,
  getBoundingClientRect,
  findPosition,
  getPointerPosition,
  isTextNode,
  emptyEl,
  normalizeContent,
  appendContent,
  insertContent,
  isSingleLeftClick,
  $,
  $$,
  computedStyle,
  copyStyleSheetsToWindow
});
let _windowLoaded = false;
let videojs$1;
const autoSetup = function() {
  if (videojs$1.options.autoSetup === false) {
    return;
  }
  const vids = Array.prototype.slice.call(document_1.getElementsByTagName("video"));
  const audios = Array.prototype.slice.call(document_1.getElementsByTagName("audio"));
  const divs = Array.prototype.slice.call(document_1.getElementsByTagName("video-js"));
  const mediaEls = vids.concat(audios, divs);
  if (mediaEls && mediaEls.length > 0) {
    for (let i = 0, e = mediaEls.length; i < e; i++) {
      const mediaEl = mediaEls[i];
      if (mediaEl && mediaEl.getAttribute) {
        if (mediaEl.player === void 0) {
          const options = mediaEl.getAttribute("data-setup");
          if (options !== null) {
            videojs$1(mediaEl);
          }
        }
      } else {
        autoSetupTimeout(1);
        break;
      }
    }
  } else if (!_windowLoaded) {
    autoSetupTimeout(1);
  }
};
function autoSetupTimeout(wait, vjs) {
  if (!isReal()) {
    return;
  }
  if (vjs) {
    videojs$1 = vjs;
  }
  window_1.setTimeout(autoSetup, wait);
}
function setWindowLoaded() {
  _windowLoaded = true;
  window_1.removeEventListener("load", setWindowLoaded);
}
if (isReal()) {
  if (document_1.readyState === "complete") {
    setWindowLoaded();
  } else {
    window_1.addEventListener("load", setWindowLoaded);
  }
}
const createStyleElement = function(className) {
  const style = document_1.createElement("style");
  style.className = className;
  return style;
};
const setTextContent = function(el, content) {
  if (el.styleSheet) {
    el.styleSheet.cssText = content;
  } else {
    el.textContent = content;
  }
};
var DomData = /* @__PURE__ */ new WeakMap();
const _initialGuid = 3;
let _guid = _initialGuid;
function newGUID() {
  return _guid++;
}
function _cleanUpEvents(elem, type) {
  if (!DomData.has(elem)) {
    return;
  }
  const data = DomData.get(elem);
  if (data.handlers[type].length === 0) {
    delete data.handlers[type];
    if (elem.removeEventListener) {
      elem.removeEventListener(type, data.dispatcher, false);
    } else if (elem.detachEvent) {
      elem.detachEvent("on" + type, data.dispatcher);
    }
  }
  if (Object.getOwnPropertyNames(data.handlers).length <= 0) {
    delete data.handlers;
    delete data.dispatcher;
    delete data.disabled;
  }
  if (Object.getOwnPropertyNames(data).length === 0) {
    DomData.delete(elem);
  }
}
function _handleMultipleEvents(fn, elem, types, callback) {
  types.forEach(function(type) {
    fn(elem, type, callback);
  });
}
function fixEvent(event) {
  if (event.fixed_) {
    return event;
  }
  function returnTrue() {
    return true;
  }
  function returnFalse() {
    return false;
  }
  if (!event || !event.isPropagationStopped || !event.isImmediatePropagationStopped) {
    const old = event || window_1.event;
    event = {};
    const deprecatedProps = ["layerX", "layerY", "keyLocation", "path", "webkitMovementX", "webkitMovementY", "mozPressure", "mozInputSource"];
    for (const key in old) {
      if (!deprecatedProps.includes(key)) {
        if (!(key === "returnValue" && old.preventDefault)) {
          event[key] = old[key];
        }
      }
    }
    if (!event.target) {
      event.target = event.srcElement || document_1;
    }
    if (!event.relatedTarget) {
      event.relatedTarget = event.fromElement === event.target ? event.toElement : event.fromElement;
    }
    event.preventDefault = function() {
      if (old.preventDefault) {
        old.preventDefault();
      }
      event.returnValue = false;
      old.returnValue = false;
      event.defaultPrevented = true;
    };
    event.defaultPrevented = false;
    event.stopPropagation = function() {
      if (old.stopPropagation) {
        old.stopPropagation();
      }
      event.cancelBubble = true;
      old.cancelBubble = true;
      event.isPropagationStopped = returnTrue;
    };
    event.isPropagationStopped = returnFalse;
    event.stopImmediatePropagation = function() {
      if (old.stopImmediatePropagation) {
        old.stopImmediatePropagation();
      }
      event.isImmediatePropagationStopped = returnTrue;
      event.stopPropagation();
    };
    event.isImmediatePropagationStopped = returnFalse;
    if (event.clientX !== null && event.clientX !== void 0) {
      const doc = document_1.documentElement;
      const body = document_1.body;
      event.pageX = event.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
      event.pageY = event.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
    }
    event.which = event.charCode || event.keyCode;
    if (event.button !== null && event.button !== void 0) {
      event.button = event.button & 1 ? 0 : event.button & 4 ? 1 : event.button & 2 ? 2 : 0;
    }
  }
  event.fixed_ = true;
  return event;
}
let _supportsPassive;
const supportsPassive = function() {
  if (typeof _supportsPassive !== "boolean") {
    _supportsPassive = false;
    try {
      const opts = Object.defineProperty({}, "passive", {
        get() {
          _supportsPassive = true;
        }
      });
      window_1.addEventListener("test", null, opts);
      window_1.removeEventListener("test", null, opts);
    } catch (e) {
    }
  }
  return _supportsPassive;
};
const passiveEvents = ["touchstart", "touchmove"];
function on(elem, type, fn) {
  if (Array.isArray(type)) {
    return _handleMultipleEvents(on, elem, type, fn);
  }
  if (!DomData.has(elem)) {
    DomData.set(elem, {});
  }
  const data = DomData.get(elem);
  if (!data.handlers) {
    data.handlers = {};
  }
  if (!data.handlers[type]) {
    data.handlers[type] = [];
  }
  if (!fn.guid) {
    fn.guid = newGUID();
  }
  data.handlers[type].push(fn);
  if (!data.dispatcher) {
    data.disabled = false;
    data.dispatcher = function(event, hash) {
      if (data.disabled) {
        return;
      }
      event = fixEvent(event);
      const handlers = data.handlers[event.type];
      if (handlers) {
        const handlersCopy = handlers.slice(0);
        for (let m = 0, n = handlersCopy.length; m < n; m++) {
          if (event.isImmediatePropagationStopped()) {
            break;
          } else {
            try {
              handlersCopy[m].call(elem, event, hash);
            } catch (e) {
              log$1.error(e);
            }
          }
        }
      }
    };
  }
  if (data.handlers[type].length === 1) {
    if (elem.addEventListener) {
      let options = false;
      if (supportsPassive() && passiveEvents.indexOf(type) > -1) {
        options = {
          passive: true
        };
      }
      elem.addEventListener(type, data.dispatcher, options);
    } else if (elem.attachEvent) {
      elem.attachEvent("on" + type, data.dispatcher);
    }
  }
}
function off(elem, type, fn) {
  if (!DomData.has(elem)) {
    return;
  }
  const data = DomData.get(elem);
  if (!data.handlers) {
    return;
  }
  if (Array.isArray(type)) {
    return _handleMultipleEvents(off, elem, type, fn);
  }
  const removeType = function(el, t) {
    data.handlers[t] = [];
    _cleanUpEvents(el, t);
  };
  if (type === void 0) {
    for (const t in data.handlers) {
      if (Object.prototype.hasOwnProperty.call(data.handlers || {}, t)) {
        removeType(elem, t);
      }
    }
    return;
  }
  const handlers = data.handlers[type];
  if (!handlers) {
    return;
  }
  if (!fn) {
    removeType(elem, type);
    return;
  }
  if (fn.guid) {
    for (let n = 0; n < handlers.length; n++) {
      if (handlers[n].guid === fn.guid) {
        handlers.splice(n--, 1);
      }
    }
  }
  _cleanUpEvents(elem, type);
}
function trigger(elem, event, hash) {
  const elemData = DomData.has(elem) ? DomData.get(elem) : {};
  const parent = elem.parentNode || elem.ownerDocument;
  if (typeof event === "string") {
    event = {
      type: event,
      target: elem
    };
  } else if (!event.target) {
    event.target = elem;
  }
  event = fixEvent(event);
  if (elemData.dispatcher) {
    elemData.dispatcher.call(elem, event, hash);
  }
  if (parent && !event.isPropagationStopped() && event.bubbles === true) {
    trigger.call(null, parent, event, hash);
  } else if (!parent && !event.defaultPrevented && event.target && event.target[event.type]) {
    if (!DomData.has(event.target)) {
      DomData.set(event.target, {});
    }
    const targetData = DomData.get(event.target);
    if (event.target[event.type]) {
      targetData.disabled = true;
      if (typeof event.target[event.type] === "function") {
        event.target[event.type]();
      }
      targetData.disabled = false;
    }
  }
  return !event.defaultPrevented;
}
function one(elem, type, fn) {
  if (Array.isArray(type)) {
    return _handleMultipleEvents(one, elem, type, fn);
  }
  const func = function() {
    off(elem, type, func);
    fn.apply(this, arguments);
  };
  func.guid = fn.guid = fn.guid || newGUID();
  on(elem, type, func);
}
function any(elem, type, fn) {
  const func = function() {
    off(elem, type, func);
    fn.apply(this, arguments);
  };
  func.guid = fn.guid = fn.guid || newGUID();
  on(elem, type, func);
}
var Events = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  fixEvent,
  on,
  off,
  trigger,
  one,
  any
});
const UPDATE_REFRESH_INTERVAL = 30;
const bind_ = function(context, fn, uid) {
  if (!fn.guid) {
    fn.guid = newGUID();
  }
  const bound = fn.bind(context);
  bound.guid = uid ? uid + "_" + fn.guid : fn.guid;
  return bound;
};
const throttle = function(fn, wait) {
  let last = window_1.performance.now();
  const throttled = function(...args) {
    const now = window_1.performance.now();
    if (now - last >= wait) {
      fn(...args);
      last = now;
    }
  };
  return throttled;
};
const debounce$1 = function(func, wait, immediate, context = window_1) {
  let timeout;
  const cancel = () => {
    context.clearTimeout(timeout);
    timeout = null;
  };
  const debounced = function() {
    const self2 = this;
    const args = arguments;
    let later = function() {
      timeout = null;
      later = null;
      if (!immediate) {
        func.apply(self2, args);
      }
    };
    if (!timeout && immediate) {
      func.apply(self2, args);
    }
    context.clearTimeout(timeout);
    timeout = context.setTimeout(later, wait);
  };
  debounced.cancel = cancel;
  return debounced;
};
var Fn = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  UPDATE_REFRESH_INTERVAL,
  bind_,
  throttle,
  debounce: debounce$1
});
let EVENT_MAP;
class EventTarget$2 {
  on(type, fn) {
    const ael = this.addEventListener;
    this.addEventListener = () => {
    };
    on(this, type, fn);
    this.addEventListener = ael;
  }
  off(type, fn) {
    off(this, type, fn);
  }
  one(type, fn) {
    const ael = this.addEventListener;
    this.addEventListener = () => {
    };
    one(this, type, fn);
    this.addEventListener = ael;
  }
  any(type, fn) {
    const ael = this.addEventListener;
    this.addEventListener = () => {
    };
    any(this, type, fn);
    this.addEventListener = ael;
  }
  trigger(event) {
    const type = event.type || event;
    if (typeof event === "string") {
      event = {
        type
      };
    }
    event = fixEvent(event);
    if (this.allowedEvents_[type] && this["on" + type]) {
      this["on" + type](event);
    }
    trigger(this, event);
  }
  queueTrigger(event) {
    if (!EVENT_MAP) {
      EVENT_MAP = /* @__PURE__ */ new Map();
    }
    const type = event.type || event;
    let map = EVENT_MAP.get(this);
    if (!map) {
      map = /* @__PURE__ */ new Map();
      EVENT_MAP.set(this, map);
    }
    const oldTimeout = map.get(type);
    map.delete(type);
    window_1.clearTimeout(oldTimeout);
    const timeout = window_1.setTimeout(() => {
      map.delete(type);
      if (map.size === 0) {
        map = null;
        EVENT_MAP.delete(this);
      }
      this.trigger(event);
    }, 0);
    map.set(type, timeout);
  }
}
EventTarget$2.prototype.allowedEvents_ = {};
EventTarget$2.prototype.addEventListener = EventTarget$2.prototype.on;
EventTarget$2.prototype.removeEventListener = EventTarget$2.prototype.off;
EventTarget$2.prototype.dispatchEvent = EventTarget$2.prototype.trigger;
const objName = (obj) => {
  if (typeof obj.name === "function") {
    return obj.name();
  }
  if (typeof obj.name === "string") {
    return obj.name;
  }
  if (obj.name_) {
    return obj.name_;
  }
  if (obj.constructor && obj.constructor.name) {
    return obj.constructor.name;
  }
  return typeof obj;
};
const isEvented = (object) => object instanceof EventTarget$2 || !!object.eventBusEl_ && ["on", "one", "off", "trigger"].every((k) => typeof object[k] === "function");
const addEventedCallback = (target, callback) => {
  if (isEvented(target)) {
    callback();
  } else {
    if (!target.eventedCallbacks) {
      target.eventedCallbacks = [];
    }
    target.eventedCallbacks.push(callback);
  }
};
const isValidEventType = (type) => typeof type === "string" && /\S/.test(type) || Array.isArray(type) && !!type.length;
const validateTarget = (target, obj, fnName) => {
  if (!target || !target.nodeName && !isEvented(target)) {
    throw new Error(`Invalid target for ${objName(obj)}#${fnName}; must be a DOM node or evented object.`);
  }
};
const validateEventType = (type, obj, fnName) => {
  if (!isValidEventType(type)) {
    throw new Error(`Invalid event type for ${objName(obj)}#${fnName}; must be a non-empty string or array.`);
  }
};
const validateListener = (listener, obj, fnName) => {
  if (typeof listener !== "function") {
    throw new Error(`Invalid listener for ${objName(obj)}#${fnName}; must be a function.`);
  }
};
const normalizeListenArgs = (self2, args, fnName) => {
  const isTargetingSelf = args.length < 3 || args[0] === self2 || args[0] === self2.eventBusEl_;
  let target;
  let type;
  let listener;
  if (isTargetingSelf) {
    target = self2.eventBusEl_;
    if (args.length >= 3) {
      args.shift();
    }
    [type, listener] = args;
  } else {
    target = args[0];
    type = args[1];
    listener = args[2];
  }
  validateTarget(target, self2, fnName);
  validateEventType(type, self2, fnName);
  validateListener(listener, self2, fnName);
  listener = bind_(self2, listener);
  return {
    isTargetingSelf,
    target,
    type,
    listener
  };
};
const listen = (target, method, type, listener) => {
  validateTarget(target, target, method);
  if (target.nodeName) {
    Events[method](target, type, listener);
  } else {
    target[method](type, listener);
  }
};
const EventedMixin = {
  on(...args) {
    const {
      isTargetingSelf,
      target,
      type,
      listener
    } = normalizeListenArgs(this, args, "on");
    listen(target, "on", type, listener);
    if (!isTargetingSelf) {
      const removeListenerOnDispose = () => this.off(target, type, listener);
      removeListenerOnDispose.guid = listener.guid;
      const removeRemoverOnTargetDispose = () => this.off("dispose", removeListenerOnDispose);
      removeRemoverOnTargetDispose.guid = listener.guid;
      listen(this, "on", "dispose", removeListenerOnDispose);
      listen(target, "on", "dispose", removeRemoverOnTargetDispose);
    }
  },
  one(...args) {
    const {
      isTargetingSelf,
      target,
      type,
      listener
    } = normalizeListenArgs(this, args, "one");
    if (isTargetingSelf) {
      listen(target, "one", type, listener);
    } else {
      const wrapper = (...largs) => {
        this.off(target, type, wrapper);
        listener.apply(null, largs);
      };
      wrapper.guid = listener.guid;
      listen(target, "one", type, wrapper);
    }
  },
  any(...args) {
    const {
      isTargetingSelf,
      target,
      type,
      listener
    } = normalizeListenArgs(this, args, "any");
    if (isTargetingSelf) {
      listen(target, "any", type, listener);
    } else {
      const wrapper = (...largs) => {
        this.off(target, type, wrapper);
        listener.apply(null, largs);
      };
      wrapper.guid = listener.guid;
      listen(target, "any", type, wrapper);
    }
  },
  off(targetOrType, typeOrListener, listener) {
    if (!targetOrType || isValidEventType(targetOrType)) {
      off(this.eventBusEl_, targetOrType, typeOrListener);
    } else {
      const target = targetOrType;
      const type = typeOrListener;
      validateTarget(target, this, "off");
      validateEventType(type, this, "off");
      validateListener(listener, this, "off");
      listener = bind_(this, listener);
      this.off("dispose", listener);
      if (target.nodeName) {
        off(target, type, listener);
        off(target, "dispose", listener);
      } else if (isEvented(target)) {
        target.off(type, listener);
        target.off("dispose", listener);
      }
    }
  },
  trigger(event, hash) {
    validateTarget(this.eventBusEl_, this, "trigger");
    const type = event && typeof event !== "string" ? event.type : event;
    if (!isValidEventType(type)) {
      throw new Error(`Invalid event type for ${objName(this)}#trigger; must be a non-empty string or object with a type key that has a non-empty value.`);
    }
    return trigger(this.eventBusEl_, event, hash);
  }
};
function evented(target, options = {}) {
  const {
    eventBusKey
  } = options;
  if (eventBusKey) {
    if (!target[eventBusKey].nodeName) {
      throw new Error(`The eventBusKey "${eventBusKey}" does not refer to an element.`);
    }
    target.eventBusEl_ = target[eventBusKey];
  } else {
    target.eventBusEl_ = createEl("span", {
      className: "vjs-event-bus"
    });
  }
  Object.assign(target, EventedMixin);
  if (target.eventedCallbacks) {
    target.eventedCallbacks.forEach((callback) => {
      callback();
    });
  }
  target.on("dispose", () => {
    target.off();
    [target, target.el_, target.eventBusEl_].forEach(function(val) {
      if (val && DomData.has(val)) {
        DomData.delete(val);
      }
    });
    window_1.setTimeout(() => {
      target.eventBusEl_ = null;
    }, 0);
  });
  return target;
}
const StatefulMixin = {
  state: {},
  setState(stateUpdates) {
    if (typeof stateUpdates === "function") {
      stateUpdates = stateUpdates();
    }
    let changes;
    each(stateUpdates, (value, key) => {
      if (this.state[key] !== value) {
        changes = changes || {};
        changes[key] = {
          from: this.state[key],
          to: value
        };
      }
      this.state[key] = value;
    });
    if (changes && isEvented(this)) {
      this.trigger({
        changes,
        type: "statechanged"
      });
    }
    return changes;
  }
};
function stateful(target, defaultState) {
  Object.assign(target, StatefulMixin);
  target.state = Object.assign({}, target.state, defaultState);
  if (typeof target.handleStateChanged === "function" && isEvented(target)) {
    target.on("statechanged", target.handleStateChanged);
  }
  return target;
}
const toLowerCase = function(string) {
  if (typeof string !== "string") {
    return string;
  }
  return string.replace(/./, (w) => w.toLowerCase());
};
const toTitleCase$1 = function(string) {
  if (typeof string !== "string") {
    return string;
  }
  return string.replace(/./, (w) => w.toUpperCase());
};
const titleCaseEquals = function(str1, str2) {
  return toTitleCase$1(str1) === toTitleCase$1(str2);
};
var Str = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  toLowerCase,
  toTitleCase: toTitleCase$1,
  titleCaseEquals
});
class Component$1 {
  constructor(player, options, ready) {
    if (!player && this.play) {
      this.player_ = player = this;
    } else {
      this.player_ = player;
    }
    this.isDisposed_ = false;
    this.parentComponent_ = null;
    this.options_ = merge$1({}, this.options_);
    options = this.options_ = merge$1(this.options_, options);
    this.id_ = options.id || options.el && options.el.id;
    if (!this.id_) {
      const id = player && player.id && player.id() || "no_player";
      this.id_ = `${id}_component_${newGUID()}`;
    }
    this.name_ = options.name || null;
    if (options.el) {
      this.el_ = options.el;
    } else if (options.createEl !== false) {
      this.el_ = this.createEl();
    }
    if (options.className && this.el_) {
      options.className.split(" ").forEach((c) => this.addClass(c));
    }
    ["on", "off", "one", "any", "trigger"].forEach((fn) => {
      this[fn] = void 0;
    });
    if (options.evented !== false) {
      evented(this, {
        eventBusKey: this.el_ ? "el_" : null
      });
      this.handleLanguagechange = this.handleLanguagechange.bind(this);
      this.on(this.player_, "languagechange", this.handleLanguagechange);
    }
    stateful(this, this.constructor.defaultState);
    this.children_ = [];
    this.childIndex_ = {};
    this.childNameIndex_ = {};
    this.setTimeoutIds_ = /* @__PURE__ */ new Set();
    this.setIntervalIds_ = /* @__PURE__ */ new Set();
    this.rafIds_ = /* @__PURE__ */ new Set();
    this.namedRafs_ = /* @__PURE__ */ new Map();
    this.clearingTimersOnDispose_ = false;
    if (options.initChildren !== false) {
      this.initChildren();
    }
    this.ready(ready);
    if (options.reportTouchActivity !== false) {
      this.enableTouchActivity();
    }
  }
  dispose(options = {}) {
    if (this.isDisposed_) {
      return;
    }
    if (this.readyQueue_) {
      this.readyQueue_.length = 0;
    }
    this.trigger({
      type: "dispose",
      bubbles: false
    });
    this.isDisposed_ = true;
    if (this.children_) {
      for (let i = this.children_.length - 1; i >= 0; i--) {
        if (this.children_[i].dispose) {
          this.children_[i].dispose();
        }
      }
    }
    this.children_ = null;
    this.childIndex_ = null;
    this.childNameIndex_ = null;
    this.parentComponent_ = null;
    if (this.el_) {
      if (this.el_.parentNode) {
        if (options.restoreEl) {
          this.el_.parentNode.replaceChild(options.restoreEl, this.el_);
        } else {
          this.el_.parentNode.removeChild(this.el_);
        }
      }
      this.el_ = null;
    }
    this.player_ = null;
  }
  isDisposed() {
    return Boolean(this.isDisposed_);
  }
  player() {
    return this.player_;
  }
  options(obj) {
    if (!obj) {
      return this.options_;
    }
    this.options_ = merge$1(this.options_, obj);
    return this.options_;
  }
  el() {
    return this.el_;
  }
  createEl(tagName, properties, attributes) {
    return createEl(tagName, properties, attributes);
  }
  localize(string, tokens, defaultValue = string) {
    const code = this.player_.language && this.player_.language();
    const languages = this.player_.languages && this.player_.languages();
    const language = languages && languages[code];
    const primaryCode = code && code.split("-")[0];
    const primaryLang = languages && languages[primaryCode];
    let localizedString = defaultValue;
    if (language && language[string]) {
      localizedString = language[string];
    } else if (primaryLang && primaryLang[string]) {
      localizedString = primaryLang[string];
    }
    if (tokens) {
      localizedString = localizedString.replace(/\{(\d+)\}/g, function(match, index) {
        const value = tokens[index - 1];
        let ret = value;
        if (typeof value === "undefined") {
          ret = match;
        }
        return ret;
      });
    }
    return localizedString;
  }
  handleLanguagechange() {
  }
  contentEl() {
    return this.contentEl_ || this.el_;
  }
  id() {
    return this.id_;
  }
  name() {
    return this.name_;
  }
  children() {
    return this.children_;
  }
  getChildById(id) {
    return this.childIndex_[id];
  }
  getChild(name) {
    if (!name) {
      return;
    }
    return this.childNameIndex_[name];
  }
  getDescendant(...names) {
    names = names.reduce((acc, n) => acc.concat(n), []);
    let currentChild = this;
    for (let i = 0; i < names.length; i++) {
      currentChild = currentChild.getChild(names[i]);
      if (!currentChild || !currentChild.getChild) {
        return;
      }
    }
    return currentChild;
  }
  setIcon(iconName, el = this.el()) {
    if (!this.player_.options_.experimentalSvgIcons) {
      return;
    }
    const xmlnsURL = "http://www.w3.org/2000/svg";
    const iconContainer = createEl("span", {
      className: "vjs-icon-placeholder vjs-svg-icon"
    }, {
      "aria-hidden": "true"
    });
    const svgEl = document_1.createElementNS(xmlnsURL, "svg");
    svgEl.setAttributeNS(null, "viewBox", "0 0 512 512");
    const useEl = document_1.createElementNS(xmlnsURL, "use");
    svgEl.appendChild(useEl);
    useEl.setAttributeNS(null, "href", `#vjs-icon-${iconName}`);
    iconContainer.appendChild(svgEl);
    if (this.iconIsSet_) {
      el.replaceChild(iconContainer, el.querySelector(".vjs-icon-placeholder"));
    } else {
      el.appendChild(iconContainer);
    }
    this.iconIsSet_ = true;
    return iconContainer;
  }
  addChild(child, options = {}, index = this.children_.length) {
    let component;
    let componentName;
    if (typeof child === "string") {
      componentName = toTitleCase$1(child);
      const componentClassName = options.componentClass || componentName;
      options.name = componentName;
      const ComponentClass = Component$1.getComponent(componentClassName);
      if (!ComponentClass) {
        throw new Error(`Component ${componentClassName} does not exist`);
      }
      if (typeof ComponentClass !== "function") {
        return null;
      }
      component = new ComponentClass(this.player_ || this, options);
    } else {
      component = child;
    }
    if (component.parentComponent_) {
      component.parentComponent_.removeChild(component);
    }
    this.children_.splice(index, 0, component);
    component.parentComponent_ = this;
    if (typeof component.id === "function") {
      this.childIndex_[component.id()] = component;
    }
    componentName = componentName || component.name && toTitleCase$1(component.name());
    if (componentName) {
      this.childNameIndex_[componentName] = component;
      this.childNameIndex_[toLowerCase(componentName)] = component;
    }
    if (typeof component.el === "function" && component.el()) {
      let refNode = null;
      if (this.children_[index + 1]) {
        if (this.children_[index + 1].el_) {
          refNode = this.children_[index + 1].el_;
        } else if (isEl(this.children_[index + 1])) {
          refNode = this.children_[index + 1];
        }
      }
      this.contentEl().insertBefore(component.el(), refNode);
    }
    return component;
  }
  removeChild(component) {
    if (typeof component === "string") {
      component = this.getChild(component);
    }
    if (!component || !this.children_) {
      return;
    }
    let childFound = false;
    for (let i = this.children_.length - 1; i >= 0; i--) {
      if (this.children_[i] === component) {
        childFound = true;
        this.children_.splice(i, 1);
        break;
      }
    }
    if (!childFound) {
      return;
    }
    component.parentComponent_ = null;
    this.childIndex_[component.id()] = null;
    this.childNameIndex_[toTitleCase$1(component.name())] = null;
    this.childNameIndex_[toLowerCase(component.name())] = null;
    const compEl = component.el();
    if (compEl && compEl.parentNode === this.contentEl()) {
      this.contentEl().removeChild(component.el());
    }
  }
  initChildren() {
    const children = this.options_.children;
    if (children) {
      const parentOptions = this.options_;
      const handleAdd = (child) => {
        const name = child.name;
        let opts = child.opts;
        if (parentOptions[name] !== void 0) {
          opts = parentOptions[name];
        }
        if (opts === false) {
          return;
        }
        if (opts === true) {
          opts = {};
        }
        opts.playerOptions = this.options_.playerOptions;
        const newChild = this.addChild(name, opts);
        if (newChild) {
          this[name] = newChild;
        }
      };
      let workingChildren;
      const Tech2 = Component$1.getComponent("Tech");
      if (Array.isArray(children)) {
        workingChildren = children;
      } else {
        workingChildren = Object.keys(children);
      }
      workingChildren.concat(Object.keys(this.options_).filter(function(child) {
        return !workingChildren.some(function(wchild) {
          if (typeof wchild === "string") {
            return child === wchild;
          }
          return child === wchild.name;
        });
      })).map((child) => {
        let name;
        let opts;
        if (typeof child === "string") {
          name = child;
          opts = children[name] || this.options_[name] || {};
        } else {
          name = child.name;
          opts = child;
        }
        return {
          name,
          opts
        };
      }).filter((child) => {
        const c = Component$1.getComponent(child.opts.componentClass || toTitleCase$1(child.name));
        return c && !Tech2.isTech(c);
      }).forEach(handleAdd);
    }
  }
  buildCSSClass() {
    return "";
  }
  ready(fn, sync = false) {
    if (!fn) {
      return;
    }
    if (!this.isReady_) {
      this.readyQueue_ = this.readyQueue_ || [];
      this.readyQueue_.push(fn);
      return;
    }
    if (sync) {
      fn.call(this);
    } else {
      this.setTimeout(fn, 1);
    }
  }
  triggerReady() {
    this.isReady_ = true;
    this.setTimeout(function() {
      const readyQueue = this.readyQueue_;
      this.readyQueue_ = [];
      if (readyQueue && readyQueue.length > 0) {
        readyQueue.forEach(function(fn) {
          fn.call(this);
        }, this);
      }
      this.trigger("ready");
    }, 1);
  }
  $(selector, context) {
    return $(selector, context || this.contentEl());
  }
  $$(selector, context) {
    return $$(selector, context || this.contentEl());
  }
  hasClass(classToCheck) {
    return hasClass(this.el_, classToCheck);
  }
  addClass(...classesToAdd) {
    addClass(this.el_, ...classesToAdd);
  }
  removeClass(...classesToRemove) {
    removeClass(this.el_, ...classesToRemove);
  }
  toggleClass(classToToggle, predicate) {
    toggleClass(this.el_, classToToggle, predicate);
  }
  show() {
    this.removeClass("vjs-hidden");
  }
  hide() {
    this.addClass("vjs-hidden");
  }
  lockShowing() {
    this.addClass("vjs-lock-showing");
  }
  unlockShowing() {
    this.removeClass("vjs-lock-showing");
  }
  getAttribute(attribute) {
    return getAttribute(this.el_, attribute);
  }
  setAttribute(attribute, value) {
    setAttribute(this.el_, attribute, value);
  }
  removeAttribute(attribute) {
    removeAttribute(this.el_, attribute);
  }
  width(num, skipListeners) {
    return this.dimension("width", num, skipListeners);
  }
  height(num, skipListeners) {
    return this.dimension("height", num, skipListeners);
  }
  dimensions(width, height) {
    this.width(width, true);
    this.height(height);
  }
  dimension(widthOrHeight, num, skipListeners) {
    if (num !== void 0) {
      if (num === null || num !== num) {
        num = 0;
      }
      if (("" + num).indexOf("%") !== -1 || ("" + num).indexOf("px") !== -1) {
        this.el_.style[widthOrHeight] = num;
      } else if (num === "auto") {
        this.el_.style[widthOrHeight] = "";
      } else {
        this.el_.style[widthOrHeight] = num + "px";
      }
      if (!skipListeners) {
        this.trigger("componentresize");
      }
      return;
    }
    if (!this.el_) {
      return 0;
    }
    const val = this.el_.style[widthOrHeight];
    const pxIndex = val.indexOf("px");
    if (pxIndex !== -1) {
      return parseInt(val.slice(0, pxIndex), 10);
    }
    return parseInt(this.el_["offset" + toTitleCase$1(widthOrHeight)], 10);
  }
  currentDimension(widthOrHeight) {
    let computedWidthOrHeight = 0;
    if (widthOrHeight !== "width" && widthOrHeight !== "height") {
      throw new Error("currentDimension only accepts width or height value");
    }
    computedWidthOrHeight = computedStyle(this.el_, widthOrHeight);
    computedWidthOrHeight = parseFloat(computedWidthOrHeight);
    if (computedWidthOrHeight === 0 || isNaN(computedWidthOrHeight)) {
      const rule = `offset${toTitleCase$1(widthOrHeight)}`;
      computedWidthOrHeight = this.el_[rule];
    }
    return computedWidthOrHeight;
  }
  currentDimensions() {
    return {
      width: this.currentDimension("width"),
      height: this.currentDimension("height")
    };
  }
  currentWidth() {
    return this.currentDimension("width");
  }
  currentHeight() {
    return this.currentDimension("height");
  }
  getPositions() {
    const rect = this.el_.getBoundingClientRect();
    const boundingClientRect = {
      x: rect.x,
      y: rect.y,
      width: rect.width,
      height: rect.height,
      top: rect.top,
      right: rect.right,
      bottom: rect.bottom,
      left: rect.left
    };
    const center = {
      x: rect.left + rect.width / 2,
      y: rect.top + rect.height / 2,
      width: 0,
      height: 0,
      top: rect.top + rect.height / 2,
      right: rect.left + rect.width / 2,
      bottom: rect.top + rect.height / 2,
      left: rect.left + rect.width / 2
    };
    return {
      boundingClientRect,
      center
    };
  }
  focus() {
    this.el_.focus();
  }
  blur() {
    this.el_.blur();
  }
  handleKeyDown(event) {
    if (this.player_) {
      if (event.key !== "Tab" && !(this.player_.options_.playerOptions.spatialNavigation && this.player_.options_.playerOptions.spatialNavigation.enabled)) {
        event.stopPropagation();
      }
      this.player_.handleKeyDown(event);
    }
  }
  handleKeyPress(event) {
    this.handleKeyDown(event);
  }
  emitTapEvents() {
    let touchStart = 0;
    let firstTouch = null;
    const tapMovementThreshold = 10;
    const touchTimeThreshold = 200;
    let couldBeTap;
    this.on("touchstart", function(event) {
      if (event.touches.length === 1) {
        firstTouch = {
          pageX: event.touches[0].pageX,
          pageY: event.touches[0].pageY
        };
        touchStart = window_1.performance.now();
        couldBeTap = true;
      }
    });
    this.on("touchmove", function(event) {
      if (event.touches.length > 1) {
        couldBeTap = false;
      } else if (firstTouch) {
        const xdiff = event.touches[0].pageX - firstTouch.pageX;
        const ydiff = event.touches[0].pageY - firstTouch.pageY;
        const touchDistance = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        if (touchDistance > tapMovementThreshold) {
          couldBeTap = false;
        }
      }
    });
    const noTap = function() {
      couldBeTap = false;
    };
    this.on("touchleave", noTap);
    this.on("touchcancel", noTap);
    this.on("touchend", function(event) {
      firstTouch = null;
      if (couldBeTap === true) {
        const touchTime = window_1.performance.now() - touchStart;
        if (touchTime < touchTimeThreshold) {
          event.preventDefault();
          this.trigger("tap");
        }
      }
    });
  }
  enableTouchActivity() {
    if (!this.player() || !this.player().reportUserActivity) {
      return;
    }
    const report = bind_(this.player(), this.player().reportUserActivity);
    let touchHolding;
    this.on("touchstart", function() {
      report();
      this.clearInterval(touchHolding);
      touchHolding = this.setInterval(report, 250);
    });
    const touchEnd = function(event) {
      report();
      this.clearInterval(touchHolding);
    };
    this.on("touchmove", report);
    this.on("touchend", touchEnd);
    this.on("touchcancel", touchEnd);
  }
  setTimeout(fn, timeout) {
    var timeoutId;
    fn = bind_(this, fn);
    this.clearTimersOnDispose_();
    timeoutId = window_1.setTimeout(() => {
      if (this.setTimeoutIds_.has(timeoutId)) {
        this.setTimeoutIds_.delete(timeoutId);
      }
      fn();
    }, timeout);
    this.setTimeoutIds_.add(timeoutId);
    return timeoutId;
  }
  clearTimeout(timeoutId) {
    if (this.setTimeoutIds_.has(timeoutId)) {
      this.setTimeoutIds_.delete(timeoutId);
      window_1.clearTimeout(timeoutId);
    }
    return timeoutId;
  }
  setInterval(fn, interval) {
    fn = bind_(this, fn);
    this.clearTimersOnDispose_();
    const intervalId = window_1.setInterval(fn, interval);
    this.setIntervalIds_.add(intervalId);
    return intervalId;
  }
  clearInterval(intervalId) {
    if (this.setIntervalIds_.has(intervalId)) {
      this.setIntervalIds_.delete(intervalId);
      window_1.clearInterval(intervalId);
    }
    return intervalId;
  }
  requestAnimationFrame(fn) {
    this.clearTimersOnDispose_();
    var id;
    fn = bind_(this, fn);
    id = window_1.requestAnimationFrame(() => {
      if (this.rafIds_.has(id)) {
        this.rafIds_.delete(id);
      }
      fn();
    });
    this.rafIds_.add(id);
    return id;
  }
  requestNamedAnimationFrame(name, fn) {
    if (this.namedRafs_.has(name)) {
      this.cancelNamedAnimationFrame(name);
    }
    this.clearTimersOnDispose_();
    fn = bind_(this, fn);
    const id = this.requestAnimationFrame(() => {
      fn();
      if (this.namedRafs_.has(name)) {
        this.namedRafs_.delete(name);
      }
    });
    this.namedRafs_.set(name, id);
    return name;
  }
  cancelNamedAnimationFrame(name) {
    if (!this.namedRafs_.has(name)) {
      return;
    }
    this.cancelAnimationFrame(this.namedRafs_.get(name));
    this.namedRafs_.delete(name);
  }
  cancelAnimationFrame(id) {
    if (this.rafIds_.has(id)) {
      this.rafIds_.delete(id);
      window_1.cancelAnimationFrame(id);
    }
    return id;
  }
  clearTimersOnDispose_() {
    if (this.clearingTimersOnDispose_) {
      return;
    }
    this.clearingTimersOnDispose_ = true;
    this.one("dispose", () => {
      [["namedRafs_", "cancelNamedAnimationFrame"], ["rafIds_", "cancelAnimationFrame"], ["setTimeoutIds_", "clearTimeout"], ["setIntervalIds_", "clearInterval"]].forEach(([idName, cancelName]) => {
        this[idName].forEach((val, key) => this[cancelName](key));
      });
      this.clearingTimersOnDispose_ = false;
    });
  }
  getIsDisabled() {
    return Boolean(this.el_.disabled);
  }
  getIsExpresslyInert() {
    return this.el_.inert && !this.el_.ownerDocument.documentElement.inert;
  }
  getIsFocusable(el) {
    const element = el || this.el_;
    return element.tabIndex >= 0 && !(this.getIsDisabled() || this.getIsExpresslyInert());
  }
  getIsAvailableToBeFocused(el) {
    function isVisibleStyleProperty(element) {
      const elementStyle = window_1.getComputedStyle(element, null);
      const thisVisibility = elementStyle.getPropertyValue("visibility");
      const thisDisplay = elementStyle.getPropertyValue("display");
      const invisibleStyle = ["hidden", "collapse"];
      return thisDisplay !== "none" && !invisibleStyle.includes(thisVisibility);
    }
    function isBeingRendered(element) {
      if (!isVisibleStyleProperty(element.parentElement)) {
        return false;
      }
      if (!isVisibleStyleProperty(element) || element.style.opacity === "0" || window_1.getComputedStyle(element).height === "0px" || window_1.getComputedStyle(element).width === "0px") {
        return false;
      }
      return true;
    }
    function isVisible(element) {
      if (element.offsetWidth + element.offsetHeight + element.getBoundingClientRect().height + element.getBoundingClientRect().width === 0) {
        return false;
      }
      const elementCenter = {
        x: element.getBoundingClientRect().left + element.offsetWidth / 2,
        y: element.getBoundingClientRect().top + element.offsetHeight / 2
      };
      if (elementCenter.x < 0) {
        return false;
      }
      if (elementCenter.x > (document_1.documentElement.clientWidth || window_1.innerWidth)) {
        return false;
      }
      if (elementCenter.y < 0) {
        return false;
      }
      if (elementCenter.y > (document_1.documentElement.clientHeight || window_1.innerHeight)) {
        return false;
      }
      let pointContainer = document_1.elementFromPoint(elementCenter.x, elementCenter.y);
      while (pointContainer) {
        if (pointContainer === element) {
          return true;
        }
        if (pointContainer.parentNode) {
          pointContainer = pointContainer.parentNode;
        } else {
          return false;
        }
      }
    }
    if (!el) {
      el = this.el();
    }
    if (isVisible(el) && isBeingRendered(el) && (!el.parentElement || el.tabIndex >= 0)) {
      return true;
    }
    return false;
  }
  static registerComponent(name, ComponentToRegister) {
    if (typeof name !== "string" || !name) {
      throw new Error(`Illegal component name, "${name}"; must be a non-empty string.`);
    }
    const Tech2 = Component$1.getComponent("Tech");
    const isTech = Tech2 && Tech2.isTech(ComponentToRegister);
    const isComp = Component$1 === ComponentToRegister || Component$1.prototype.isPrototypeOf(ComponentToRegister.prototype);
    if (isTech || !isComp) {
      let reason;
      if (isTech) {
        reason = "techs must be registered using Tech.registerTech()";
      } else {
        reason = "must be a Component subclass";
      }
      throw new Error(`Illegal component, "${name}"; ${reason}.`);
    }
    name = toTitleCase$1(name);
    if (!Component$1.components_) {
      Component$1.components_ = {};
    }
    const Player2 = Component$1.getComponent("Player");
    if (name === "Player" && Player2 && Player2.players) {
      const players = Player2.players;
      const playerNames = Object.keys(players);
      if (players && playerNames.length > 0) {
        for (let i = 0; i < playerNames.length; i++) {
          if (players[playerNames[i]] !== null) {
            throw new Error("Can not register Player component after player has been created.");
          }
        }
      }
    }
    Component$1.components_[name] = ComponentToRegister;
    Component$1.components_[toLowerCase(name)] = ComponentToRegister;
    return ComponentToRegister;
  }
  static getComponent(name) {
    if (!name || !Component$1.components_) {
      return;
    }
    return Component$1.components_[name];
  }
}
Component$1.registerComponent("Component", Component$1);
function rangeCheck(fnName, index, maxIndex) {
  if (typeof index !== "number" || index < 0 || index > maxIndex) {
    throw new Error(`Failed to execute '${fnName}' on 'TimeRanges': The index provided (${index}) is non-numeric or out of bounds (0-${maxIndex}).`);
  }
}
function getRange(fnName, valueIndex, ranges, rangeIndex) {
  rangeCheck(fnName, rangeIndex, ranges.length - 1);
  return ranges[rangeIndex][valueIndex];
}
function createTimeRangesObj(ranges) {
  let timeRangesObj;
  if (ranges === void 0 || ranges.length === 0) {
    timeRangesObj = {
      length: 0,
      start() {
        throw new Error("This TimeRanges object is empty");
      },
      end() {
        throw new Error("This TimeRanges object is empty");
      }
    };
  } else {
    timeRangesObj = {
      length: ranges.length,
      start: getRange.bind(null, "start", 0, ranges),
      end: getRange.bind(null, "end", 1, ranges)
    };
  }
  if (window_1.Symbol && window_1.Symbol.iterator) {
    timeRangesObj[window_1.Symbol.iterator] = () => (ranges || []).values();
  }
  return timeRangesObj;
}
function createTimeRanges$1(start, end) {
  if (Array.isArray(start)) {
    return createTimeRangesObj(start);
  } else if (start === void 0 || end === void 0) {
    return createTimeRangesObj();
  }
  return createTimeRangesObj([[start, end]]);
}
const defaultImplementation = function(seconds, guide) {
  seconds = seconds < 0 ? 0 : seconds;
  let s = Math.floor(seconds % 60);
  let m = Math.floor(seconds / 60 % 60);
  let h = Math.floor(seconds / 3600);
  const gm = Math.floor(guide / 60 % 60);
  const gh = Math.floor(guide / 3600);
  if (isNaN(seconds) || seconds === Infinity) {
    h = m = s = "-";
  }
  h = h > 0 || gh > 0 ? h + ":" : "";
  m = ((h || gm >= 10) && m < 10 ? "0" + m : m) + ":";
  s = s < 10 ? "0" + s : s;
  return h + m + s;
};
let implementation = defaultImplementation;
function setFormatTime(customImplementation) {
  implementation = customImplementation;
}
function resetFormatTime() {
  implementation = defaultImplementation;
}
function formatTime(seconds, guide = seconds) {
  return implementation(seconds, guide);
}
var Time = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  createTimeRanges: createTimeRanges$1,
  createTimeRange: createTimeRanges$1,
  setFormatTime,
  resetFormatTime,
  formatTime
});
function bufferedPercent(buffered, duration2) {
  let bufferedDuration = 0;
  let start;
  let end;
  if (!duration2) {
    return 0;
  }
  if (!buffered || !buffered.length) {
    buffered = createTimeRanges$1(0, 0);
  }
  for (let i = 0; i < buffered.length; i++) {
    start = buffered.start(i);
    end = buffered.end(i);
    if (end > duration2) {
      end = duration2;
    }
    bufferedDuration += end - start;
  }
  return bufferedDuration / duration2;
}
function MediaError(value) {
  if (value instanceof MediaError) {
    return value;
  }
  if (typeof value === "number") {
    this.code = value;
  } else if (typeof value === "string") {
    this.message = value;
  } else if (isObject(value)) {
    if (typeof value.code === "number") {
      this.code = value.code;
    }
    Object.assign(this, value);
  }
  if (!this.message) {
    this.message = MediaError.defaultMessages[this.code] || "";
  }
}
MediaError.prototype.code = 0;
MediaError.prototype.message = "";
MediaError.prototype.status = null;
MediaError.prototype.metadata = null;
MediaError.errorTypes = ["MEDIA_ERR_CUSTOM", "MEDIA_ERR_ABORTED", "MEDIA_ERR_NETWORK", "MEDIA_ERR_DECODE", "MEDIA_ERR_SRC_NOT_SUPPORTED", "MEDIA_ERR_ENCRYPTED"];
MediaError.defaultMessages = {
  1: "You aborted the media playback",
  2: "A network error caused the media download to fail part-way.",
  3: "The media playback was aborted due to a corruption problem or because the media used features your browser did not support.",
  4: "The media could not be loaded, either because the server or network failed or because the format is not supported.",
  5: "The media is encrypted and we do not have the keys to decrypt it."
};
MediaError.MEDIA_ERR_CUSTOM = 0;
MediaError.prototype.MEDIA_ERR_CUSTOM = 0;
MediaError.MEDIA_ERR_ABORTED = 1;
MediaError.prototype.MEDIA_ERR_ABORTED = 1;
MediaError.MEDIA_ERR_NETWORK = 2;
MediaError.prototype.MEDIA_ERR_NETWORK = 2;
MediaError.MEDIA_ERR_DECODE = 3;
MediaError.prototype.MEDIA_ERR_DECODE = 3;
MediaError.MEDIA_ERR_SRC_NOT_SUPPORTED = 4;
MediaError.prototype.MEDIA_ERR_SRC_NOT_SUPPORTED = 4;
MediaError.MEDIA_ERR_ENCRYPTED = 5;
MediaError.prototype.MEDIA_ERR_ENCRYPTED = 5;
function isPromise(value) {
  return value !== void 0 && value !== null && typeof value.then === "function";
}
function silencePromise(value) {
  if (isPromise(value)) {
    value.then(null, (e) => {
    });
  }
}
const trackToJson = function(track) {
  const ret = ["kind", "label", "language", "id", "inBandMetadataTrackDispatchType", "mode", "src"].reduce((acc, prop, i) => {
    if (track[prop]) {
      acc[prop] = track[prop];
    }
    return acc;
  }, {
    cues: track.cues && Array.prototype.map.call(track.cues, function(cue) {
      return {
        startTime: cue.startTime,
        endTime: cue.endTime,
        text: cue.text,
        id: cue.id
      };
    })
  });
  return ret;
};
const textTracksToJson = function(tech) {
  const trackEls = tech.$$("track");
  const trackObjs = Array.prototype.map.call(trackEls, (t) => t.track);
  const tracks = Array.prototype.map.call(trackEls, function(trackEl) {
    const json = trackToJson(trackEl.track);
    if (trackEl.src) {
      json.src = trackEl.src;
    }
    return json;
  });
  return tracks.concat(Array.prototype.filter.call(tech.textTracks(), function(track) {
    return trackObjs.indexOf(track) === -1;
  }).map(trackToJson));
};
const jsonToTextTracks = function(json, tech) {
  json.forEach(function(track) {
    const addedTrack = tech.addRemoteTextTrack(track).track;
    if (!track.src && track.cues) {
      track.cues.forEach((cue) => addedTrack.addCue(cue));
    }
  });
  return tech.textTracks();
};
var textTrackConverter = {
  textTracksToJson,
  jsonToTextTracks,
  trackToJson
};
const MODAL_CLASS_NAME = "vjs-modal-dialog";
class ModalDialog extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.handleKeyDown_ = (e) => this.handleKeyDown(e);
    this.close_ = (e) => this.close(e);
    this.opened_ = this.hasBeenOpened_ = this.hasBeenFilled_ = false;
    this.closeable(!this.options_.uncloseable);
    this.content(this.options_.content);
    this.contentEl_ = createEl("div", {
      className: `${MODAL_CLASS_NAME}-content`
    }, {
      role: "document"
    });
    this.descEl_ = createEl("p", {
      className: `${MODAL_CLASS_NAME}-description vjs-control-text`,
      id: this.el().getAttribute("aria-describedby")
    });
    textContent(this.descEl_, this.description());
    this.el_.appendChild(this.descEl_);
    this.el_.appendChild(this.contentEl_);
  }
  createEl() {
    return super.createEl("div", {
      className: this.buildCSSClass(),
      tabIndex: -1
    }, {
      "aria-describedby": `${this.id()}_description`,
      "aria-hidden": "true",
      "aria-label": this.label(),
      "role": "dialog",
      "aria-live": "polite"
    });
  }
  dispose() {
    this.contentEl_ = null;
    this.descEl_ = null;
    this.previouslyActiveEl_ = null;
    super.dispose();
  }
  buildCSSClass() {
    return `${MODAL_CLASS_NAME} vjs-hidden ${super.buildCSSClass()}`;
  }
  label() {
    return this.localize(this.options_.label || "Modal Window");
  }
  description() {
    let desc = this.options_.description || this.localize("This is a modal window.");
    if (this.closeable()) {
      desc += " " + this.localize("This modal can be closed by pressing the Escape key or activating the close button.");
    }
    return desc;
  }
  open() {
    if (this.opened_) {
      if (this.options_.fillAlways) {
        this.fill();
      }
      return;
    }
    const player = this.player();
    this.trigger("beforemodalopen");
    this.opened_ = true;
    if (this.options_.fillAlways || !this.hasBeenOpened_ && !this.hasBeenFilled_) {
      this.fill();
    }
    this.wasPlaying_ = !player.paused();
    if (this.options_.pauseOnOpen && this.wasPlaying_) {
      player.pause();
    }
    this.on("keydown", this.handleKeyDown_);
    this.hadControls_ = player.controls();
    player.controls(false);
    this.show();
    this.conditionalFocus_();
    this.el().setAttribute("aria-hidden", "false");
    this.trigger("modalopen");
    this.hasBeenOpened_ = true;
  }
  opened(value) {
    if (typeof value === "boolean") {
      this[value ? "open" : "close"]();
    }
    return this.opened_;
  }
  close() {
    if (!this.opened_) {
      return;
    }
    const player = this.player();
    this.trigger("beforemodalclose");
    this.opened_ = false;
    if (this.wasPlaying_ && this.options_.pauseOnOpen) {
      player.play();
    }
    this.off("keydown", this.handleKeyDown_);
    if (this.hadControls_) {
      player.controls(true);
    }
    this.hide();
    this.el().setAttribute("aria-hidden", "true");
    this.trigger({
      type: "modalclose",
      bubbles: true
    });
    this.conditionalBlur_();
    if (this.options_.temporary) {
      this.dispose();
    }
  }
  closeable(value) {
    if (typeof value === "boolean") {
      const closeable = this.closeable_ = !!value;
      let close = this.getChild("closeButton");
      if (closeable && !close) {
        const temp = this.contentEl_;
        this.contentEl_ = this.el_;
        close = this.addChild("closeButton", {
          controlText: "Close Modal Dialog"
        });
        this.contentEl_ = temp;
        this.on(close, "close", this.close_);
      }
      if (!closeable && close) {
        this.off(close, "close", this.close_);
        this.removeChild(close);
        close.dispose();
      }
    }
    return this.closeable_;
  }
  fill() {
    this.fillWith(this.content());
  }
  fillWith(content) {
    const contentEl = this.contentEl();
    const parentEl = contentEl.parentNode;
    const nextSiblingEl = contentEl.nextSibling;
    this.trigger("beforemodalfill");
    this.hasBeenFilled_ = true;
    parentEl.removeChild(contentEl);
    this.empty();
    insertContent(contentEl, content);
    this.trigger("modalfill");
    if (nextSiblingEl) {
      parentEl.insertBefore(contentEl, nextSiblingEl);
    } else {
      parentEl.appendChild(contentEl);
    }
    const closeButton = this.getChild("closeButton");
    if (closeButton) {
      parentEl.appendChild(closeButton.el_);
    }
    this.trigger("aftermodalfill");
  }
  empty() {
    this.trigger("beforemodalempty");
    emptyEl(this.contentEl());
    this.trigger("modalempty");
  }
  content(value) {
    if (typeof value !== "undefined") {
      this.content_ = value;
    }
    return this.content_;
  }
  conditionalFocus_() {
    const activeEl = document_1.activeElement;
    const playerEl = this.player_.el_;
    this.previouslyActiveEl_ = null;
    if (playerEl.contains(activeEl) || playerEl === activeEl) {
      this.previouslyActiveEl_ = activeEl;
      this.focus();
    }
  }
  conditionalBlur_() {
    if (this.previouslyActiveEl_) {
      this.previouslyActiveEl_.focus();
      this.previouslyActiveEl_ = null;
    }
  }
  handleKeyDown(event) {
    this.trigger({
      type: "modalKeydown",
      originalEvent: event,
      target: this,
      bubbles: true
    });
    event.stopPropagation();
    if (event.key === "Escape" && this.closeable()) {
      event.preventDefault();
      this.close();
      return;
    }
    if (event.key !== "Tab") {
      return;
    }
    const focusableEls = this.focusableEls_();
    const activeEl = this.el_.querySelector(":focus");
    let focusIndex;
    for (let i = 0; i < focusableEls.length; i++) {
      if (activeEl === focusableEls[i]) {
        focusIndex = i;
        break;
      }
    }
    if (document_1.activeElement === this.el_) {
      focusIndex = 0;
    }
    if (event.shiftKey && focusIndex === 0) {
      focusableEls[focusableEls.length - 1].focus();
      event.preventDefault();
    } else if (!event.shiftKey && focusIndex === focusableEls.length - 1) {
      focusableEls[0].focus();
      event.preventDefault();
    }
  }
  focusableEls_() {
    const allChildren = this.el_.querySelectorAll("*");
    return Array.prototype.filter.call(allChildren, (child) => {
      return (child instanceof window_1.HTMLAnchorElement || child instanceof window_1.HTMLAreaElement) && child.hasAttribute("href") || (child instanceof window_1.HTMLInputElement || child instanceof window_1.HTMLSelectElement || child instanceof window_1.HTMLTextAreaElement || child instanceof window_1.HTMLButtonElement) && !child.hasAttribute("disabled") || child instanceof window_1.HTMLIFrameElement || child instanceof window_1.HTMLObjectElement || child instanceof window_1.HTMLEmbedElement || child.hasAttribute("tabindex") && child.getAttribute("tabindex") !== -1 || child.hasAttribute("contenteditable");
    });
  }
}
ModalDialog.prototype.options_ = {
  pauseOnOpen: true,
  temporary: true
};
Component$1.registerComponent("ModalDialog", ModalDialog);
class TrackList extends EventTarget$2 {
  constructor(tracks = []) {
    super();
    this.tracks_ = [];
    Object.defineProperty(this, "length", {
      get() {
        return this.tracks_.length;
      }
    });
    for (let i = 0; i < tracks.length; i++) {
      this.addTrack(tracks[i]);
    }
  }
  addTrack(track) {
    const index = this.tracks_.length;
    if (!("" + index in this)) {
      Object.defineProperty(this, index, {
        get() {
          return this.tracks_[index];
        }
      });
    }
    if (this.tracks_.indexOf(track) === -1) {
      this.tracks_.push(track);
      this.trigger({
        track,
        type: "addtrack",
        target: this
      });
    }
    track.labelchange_ = () => {
      this.trigger({
        track,
        type: "labelchange",
        target: this
      });
    };
    if (isEvented(track)) {
      track.addEventListener("labelchange", track.labelchange_);
    }
  }
  removeTrack(rtrack) {
    let track;
    for (let i = 0, l = this.length; i < l; i++) {
      if (this[i] === rtrack) {
        track = this[i];
        if (track.off) {
          track.off();
        }
        this.tracks_.splice(i, 1);
        break;
      }
    }
    if (!track) {
      return;
    }
    this.trigger({
      track,
      type: "removetrack",
      target: this
    });
  }
  getTrackById(id) {
    let result = null;
    for (let i = 0, l = this.length; i < l; i++) {
      const track = this[i];
      if (track.id === id) {
        result = track;
        break;
      }
    }
    return result;
  }
}
TrackList.prototype.allowedEvents_ = {
  change: "change",
  addtrack: "addtrack",
  removetrack: "removetrack",
  labelchange: "labelchange"
};
for (const event in TrackList.prototype.allowedEvents_) {
  TrackList.prototype["on" + event] = null;
}
const disableOthers$1 = function(list, track) {
  for (let i = 0; i < list.length; i++) {
    if (!Object.keys(list[i]).length || track.id === list[i].id) {
      continue;
    }
    list[i].enabled = false;
  }
};
class AudioTrackList extends TrackList {
  constructor(tracks = []) {
    for (let i = tracks.length - 1; i >= 0; i--) {
      if (tracks[i].enabled) {
        disableOthers$1(tracks, tracks[i]);
        break;
      }
    }
    super(tracks);
    this.changing_ = false;
  }
  addTrack(track) {
    if (track.enabled) {
      disableOthers$1(this, track);
    }
    super.addTrack(track);
    if (!track.addEventListener) {
      return;
    }
    track.enabledChange_ = () => {
      if (this.changing_) {
        return;
      }
      this.changing_ = true;
      disableOthers$1(this, track);
      this.changing_ = false;
      this.trigger("change");
    };
    track.addEventListener("enabledchange", track.enabledChange_);
  }
  removeTrack(rtrack) {
    super.removeTrack(rtrack);
    if (rtrack.removeEventListener && rtrack.enabledChange_) {
      rtrack.removeEventListener("enabledchange", rtrack.enabledChange_);
      rtrack.enabledChange_ = null;
    }
  }
}
const disableOthers = function(list, track) {
  for (let i = 0; i < list.length; i++) {
    if (!Object.keys(list[i]).length || track.id === list[i].id) {
      continue;
    }
    list[i].selected = false;
  }
};
class VideoTrackList extends TrackList {
  constructor(tracks = []) {
    for (let i = tracks.length - 1; i >= 0; i--) {
      if (tracks[i].selected) {
        disableOthers(tracks, tracks[i]);
        break;
      }
    }
    super(tracks);
    this.changing_ = false;
    Object.defineProperty(this, "selectedIndex", {
      get() {
        for (let i = 0; i < this.length; i++) {
          if (this[i].selected) {
            return i;
          }
        }
        return -1;
      },
      set() {
      }
    });
  }
  addTrack(track) {
    if (track.selected) {
      disableOthers(this, track);
    }
    super.addTrack(track);
    if (!track.addEventListener) {
      return;
    }
    track.selectedChange_ = () => {
      if (this.changing_) {
        return;
      }
      this.changing_ = true;
      disableOthers(this, track);
      this.changing_ = false;
      this.trigger("change");
    };
    track.addEventListener("selectedchange", track.selectedChange_);
  }
  removeTrack(rtrack) {
    super.removeTrack(rtrack);
    if (rtrack.removeEventListener && rtrack.selectedChange_) {
      rtrack.removeEventListener("selectedchange", rtrack.selectedChange_);
      rtrack.selectedChange_ = null;
    }
  }
}
class TextTrackList extends TrackList {
  addTrack(track) {
    super.addTrack(track);
    if (!this.queueChange_) {
      this.queueChange_ = () => this.queueTrigger("change");
    }
    if (!this.triggerSelectedlanguagechange) {
      this.triggerSelectedlanguagechange_ = () => this.trigger("selectedlanguagechange");
    }
    track.addEventListener("modechange", this.queueChange_);
    const nonLanguageTextTrackKind = ["metadata", "chapters"];
    if (nonLanguageTextTrackKind.indexOf(track.kind) === -1) {
      track.addEventListener("modechange", this.triggerSelectedlanguagechange_);
    }
  }
  removeTrack(rtrack) {
    super.removeTrack(rtrack);
    if (rtrack.removeEventListener) {
      if (this.queueChange_) {
        rtrack.removeEventListener("modechange", this.queueChange_);
      }
      if (this.selectedlanguagechange_) {
        rtrack.removeEventListener("modechange", this.triggerSelectedlanguagechange_);
      }
    }
  }
  toJSON() {
    return this.tracks_.map((track) => track.toJSON());
  }
}
class HtmlTrackElementList {
  constructor(trackElements = []) {
    this.trackElements_ = [];
    Object.defineProperty(this, "length", {
      get() {
        return this.trackElements_.length;
      }
    });
    for (let i = 0, length = trackElements.length; i < length; i++) {
      this.addTrackElement_(trackElements[i]);
    }
  }
  addTrackElement_(trackElement) {
    const index = this.trackElements_.length;
    if (!("" + index in this)) {
      Object.defineProperty(this, index, {
        get() {
          return this.trackElements_[index];
        }
      });
    }
    if (this.trackElements_.indexOf(trackElement) === -1) {
      this.trackElements_.push(trackElement);
    }
  }
  getTrackElementByTrack_(track) {
    let trackElement_;
    for (let i = 0, length = this.trackElements_.length; i < length; i++) {
      if (track === this.trackElements_[i].track) {
        trackElement_ = this.trackElements_[i];
        break;
      }
    }
    return trackElement_;
  }
  removeTrackElement_(trackElement) {
    for (let i = 0, length = this.trackElements_.length; i < length; i++) {
      if (trackElement === this.trackElements_[i]) {
        if (this.trackElements_[i].track && typeof this.trackElements_[i].track.off === "function") {
          this.trackElements_[i].track.off();
        }
        if (typeof this.trackElements_[i].off === "function") {
          this.trackElements_[i].off();
        }
        this.trackElements_.splice(i, 1);
        break;
      }
    }
  }
}
class TextTrackCueList {
  constructor(cues) {
    TextTrackCueList.prototype.setCues_.call(this, cues);
    Object.defineProperty(this, "length", {
      get() {
        return this.length_;
      }
    });
  }
  setCues_(cues) {
    const oldLength = this.length || 0;
    let i = 0;
    const l = cues.length;
    this.cues_ = cues;
    this.length_ = cues.length;
    const defineProp = function(index) {
      if (!("" + index in this)) {
        Object.defineProperty(this, "" + index, {
          get() {
            return this.cues_[index];
          }
        });
      }
    };
    if (oldLength < l) {
      i = oldLength;
      for (; i < l; i++) {
        defineProp.call(this, i);
      }
    }
  }
  getCueById(id) {
    let result = null;
    for (let i = 0, l = this.length; i < l; i++) {
      const cue = this[i];
      if (cue.id === id) {
        result = cue;
        break;
      }
    }
    return result;
  }
}
const VideoTrackKind = {
  alternative: "alternative",
  captions: "captions",
  main: "main",
  sign: "sign",
  subtitles: "subtitles",
  commentary: "commentary"
};
const AudioTrackKind = {
  "alternative": "alternative",
  "descriptions": "descriptions",
  "main": "main",
  "main-desc": "main-desc",
  "translation": "translation",
  "commentary": "commentary"
};
const TextTrackKind = {
  subtitles: "subtitles",
  captions: "captions",
  descriptions: "descriptions",
  chapters: "chapters",
  metadata: "metadata"
};
const TextTrackMode = {
  disabled: "disabled",
  hidden: "hidden",
  showing: "showing"
};
class Track extends EventTarget$2 {
  constructor(options = {}) {
    super();
    const trackProps = {
      id: options.id || "vjs_track_" + newGUID(),
      kind: options.kind || "",
      language: options.language || ""
    };
    let label = options.label || "";
    for (const key in trackProps) {
      Object.defineProperty(this, key, {
        get() {
          return trackProps[key];
        },
        set() {
        }
      });
    }
    Object.defineProperty(this, "label", {
      get() {
        return label;
      },
      set(newLabel) {
        if (newLabel !== label) {
          label = newLabel;
          this.trigger("labelchange");
        }
      }
    });
  }
}
const parseUrl = function(url) {
  return new URL(url, document_1.baseURI);
};
const getAbsoluteURL = function(url) {
  return new URL(url, document_1.baseURI).href;
};
const getFileExtension = function(path) {
  if (typeof path === "string") {
    const cleanPath = path.split("?")[0].replace(/\/+$/, "");
    const match = cleanPath.match(/\.([^.\/]+)$/);
    return match ? match[1].toLowerCase() : "";
  }
  return "";
};
const isCrossOrigin = function(url, winLoc = window_1.location) {
  return parseUrl(url).origin !== winLoc.origin;
};
var Url = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  parseUrl,
  getAbsoluteURL,
  getFileExtension,
  isCrossOrigin
});
const parseCues = function(srcContent, track) {
  const parser = new window_1.WebVTT.Parser(window_1, window_1.vttjs, window_1.WebVTT.StringDecoder());
  const errors = [];
  parser.oncue = function(cue) {
    track.addCue(cue);
  };
  parser.onparsingerror = function(error) {
    errors.push(error);
  };
  parser.onflush = function() {
    track.trigger({
      type: "loadeddata",
      target: track
    });
  };
  parser.parse(srcContent);
  if (errors.length > 0) {
    if (window_1.console && window_1.console.groupCollapsed) {
      window_1.console.groupCollapsed(`Text Track parsing errors for ${track.src}`);
    }
    errors.forEach((error) => log$1.error(error));
    if (window_1.console && window_1.console.groupEnd) {
      window_1.console.groupEnd();
    }
  }
  parser.flush();
};
const loadTrack = function(src, track) {
  const opts = {
    uri: src
  };
  const crossOrigin = isCrossOrigin(src);
  if (crossOrigin) {
    opts.cors = crossOrigin;
  }
  const withCredentials = track.tech_.crossOrigin() === "use-credentials";
  if (withCredentials) {
    opts.withCredentials = withCredentials;
  }
  lib.exports(opts, bind_(this, function(err, response, responseBody) {
    if (err) {
      return log$1.error(err, response);
    }
    track.loaded_ = true;
    if (typeof window_1.WebVTT !== "function") {
      if (track.tech_) {
        track.tech_.any(["vttjsloaded", "vttjserror"], (event) => {
          if (event.type === "vttjserror") {
            log$1.error(`vttjs failed to load, stopping trying to process ${track.src}`);
            return;
          }
          return parseCues(responseBody, track);
        });
      }
    } else {
      parseCues(responseBody, track);
    }
  }));
};
class TextTrack extends Track {
  constructor(options = {}) {
    if (!options.tech) {
      throw new Error("A tech was not provided.");
    }
    const settings = merge$1(options, {
      kind: TextTrackKind[options.kind] || "subtitles",
      language: options.language || options.srclang || ""
    });
    let mode = TextTrackMode[settings.mode] || "disabled";
    const default_ = settings.default;
    if (settings.kind === "metadata" || settings.kind === "chapters") {
      mode = "hidden";
    }
    super(settings);
    this.tech_ = settings.tech;
    this.cues_ = [];
    this.activeCues_ = [];
    this.preload_ = this.tech_.preloadTextTracks !== false;
    const cues = new TextTrackCueList(this.cues_);
    const activeCues = new TextTrackCueList(this.activeCues_);
    let changed = false;
    this.timeupdateHandler = bind_(this, function(event = {}) {
      if (this.tech_.isDisposed()) {
        return;
      }
      if (!this.tech_.isReady_) {
        if (event.type !== "timeupdate") {
          this.rvf_ = this.tech_.requestVideoFrameCallback(this.timeupdateHandler);
        }
        return;
      }
      this.activeCues = this.activeCues;
      if (changed) {
        this.trigger("cuechange");
        changed = false;
      }
      if (event.type !== "timeupdate") {
        this.rvf_ = this.tech_.requestVideoFrameCallback(this.timeupdateHandler);
      }
    });
    const disposeHandler = () => {
      this.stopTracking();
    };
    this.tech_.one("dispose", disposeHandler);
    if (mode !== "disabled") {
      this.startTracking();
    }
    Object.defineProperties(this, {
      default: {
        get() {
          return default_;
        },
        set() {
        }
      },
      mode: {
        get() {
          return mode;
        },
        set(newMode) {
          if (!TextTrackMode[newMode]) {
            return;
          }
          if (mode === newMode) {
            return;
          }
          mode = newMode;
          if (!this.preload_ && mode !== "disabled" && this.cues.length === 0) {
            loadTrack(this.src, this);
          }
          this.stopTracking();
          if (mode !== "disabled") {
            this.startTracking();
          }
          this.trigger("modechange");
        }
      },
      cues: {
        get() {
          if (!this.loaded_) {
            return null;
          }
          return cues;
        },
        set() {
        }
      },
      activeCues: {
        get() {
          if (!this.loaded_) {
            return null;
          }
          if (this.cues.length === 0) {
            return activeCues;
          }
          const ct = this.tech_.currentTime();
          const active = [];
          for (let i = 0, l = this.cues.length; i < l; i++) {
            const cue = this.cues[i];
            if (cue.startTime <= ct && cue.endTime >= ct) {
              active.push(cue);
            }
          }
          changed = false;
          if (active.length !== this.activeCues_.length) {
            changed = true;
          } else {
            for (let i = 0; i < active.length; i++) {
              if (this.activeCues_.indexOf(active[i]) === -1) {
                changed = true;
              }
            }
          }
          this.activeCues_ = active;
          activeCues.setCues_(this.activeCues_);
          return activeCues;
        },
        set() {
        }
      }
    });
    if (settings.src) {
      this.src = settings.src;
      if (!this.preload_) {
        this.loaded_ = true;
      }
      if (this.preload_ || settings.kind !== "subtitles" && settings.kind !== "captions") {
        loadTrack(this.src, this);
      }
    } else {
      this.loaded_ = true;
    }
  }
  startTracking() {
    this.rvf_ = this.tech_.requestVideoFrameCallback(this.timeupdateHandler);
    this.tech_.on("timeupdate", this.timeupdateHandler);
  }
  stopTracking() {
    if (this.rvf_) {
      this.tech_.cancelVideoFrameCallback(this.rvf_);
      this.rvf_ = void 0;
    }
    this.tech_.off("timeupdate", this.timeupdateHandler);
  }
  addCue(originalCue) {
    let cue = originalCue;
    if (!("getCueAsHTML" in cue)) {
      cue = new window_1.vttjs.VTTCue(originalCue.startTime, originalCue.endTime, originalCue.text);
      for (const prop in originalCue) {
        if (!(prop in cue)) {
          cue[prop] = originalCue[prop];
        }
      }
      cue.id = originalCue.id;
      cue.originalCue_ = originalCue;
    }
    const tracks = this.tech_.textTracks();
    for (let i = 0; i < tracks.length; i++) {
      if (tracks[i] !== this) {
        tracks[i].removeCue(cue);
      }
    }
    this.cues_.push(cue);
    this.cues.setCues_(this.cues_);
  }
  toJSON() {
    return textTrackConverter.trackToJson(this);
  }
  removeCue(removeCue) {
    let i = this.cues_.length;
    while (i--) {
      const cue = this.cues_[i];
      if (cue === removeCue || cue.originalCue_ && cue.originalCue_ === removeCue) {
        this.cues_.splice(i, 1);
        this.cues.setCues_(this.cues_);
        break;
      }
    }
  }
}
TextTrack.prototype.allowedEvents_ = {
  cuechange: "cuechange"
};
class AudioTrack extends Track {
  constructor(options = {}) {
    const settings = merge$1(options, {
      kind: AudioTrackKind[options.kind] || ""
    });
    super(settings);
    let enabled = false;
    Object.defineProperty(this, "enabled", {
      get() {
        return enabled;
      },
      set(newEnabled) {
        if (typeof newEnabled !== "boolean" || newEnabled === enabled) {
          return;
        }
        enabled = newEnabled;
        this.trigger("enabledchange");
      }
    });
    if (settings.enabled) {
      this.enabled = settings.enabled;
    }
    this.loaded_ = true;
  }
}
class VideoTrack extends Track {
  constructor(options = {}) {
    const settings = merge$1(options, {
      kind: VideoTrackKind[options.kind] || ""
    });
    super(settings);
    let selected = false;
    Object.defineProperty(this, "selected", {
      get() {
        return selected;
      },
      set(newSelected) {
        if (typeof newSelected !== "boolean" || newSelected === selected) {
          return;
        }
        selected = newSelected;
        this.trigger("selectedchange");
      }
    });
    if (settings.selected) {
      this.selected = settings.selected;
    }
  }
}
class HTMLTrackElement extends EventTarget$2 {
  constructor(options = {}) {
    super();
    let readyState;
    const track = new TextTrack(options);
    this.kind = track.kind;
    this.src = track.src;
    this.srclang = track.language;
    this.label = track.label;
    this.default = track.default;
    Object.defineProperties(this, {
      readyState: {
        get() {
          return readyState;
        }
      },
      track: {
        get() {
          return track;
        }
      }
    });
    readyState = HTMLTrackElement.NONE;
    track.addEventListener("loadeddata", () => {
      readyState = HTMLTrackElement.LOADED;
      this.trigger({
        type: "load",
        target: this
      });
    });
  }
}
HTMLTrackElement.prototype.allowedEvents_ = {
  load: "load"
};
HTMLTrackElement.NONE = 0;
HTMLTrackElement.LOADING = 1;
HTMLTrackElement.LOADED = 2;
HTMLTrackElement.ERROR = 3;
const NORMAL = {
  audio: {
    ListClass: AudioTrackList,
    TrackClass: AudioTrack,
    capitalName: "Audio"
  },
  video: {
    ListClass: VideoTrackList,
    TrackClass: VideoTrack,
    capitalName: "Video"
  },
  text: {
    ListClass: TextTrackList,
    TrackClass: TextTrack,
    capitalName: "Text"
  }
};
Object.keys(NORMAL).forEach(function(type) {
  NORMAL[type].getterName = `${type}Tracks`;
  NORMAL[type].privateName = `${type}Tracks_`;
});
const REMOTE = {
  remoteText: {
    ListClass: TextTrackList,
    TrackClass: TextTrack,
    capitalName: "RemoteText",
    getterName: "remoteTextTracks",
    privateName: "remoteTextTracks_"
  },
  remoteTextEl: {
    ListClass: HtmlTrackElementList,
    TrackClass: HTMLTrackElement,
    capitalName: "RemoteTextTrackEls",
    getterName: "remoteTextTrackEls",
    privateName: "remoteTextTrackEls_"
  }
};
const ALL = Object.assign({}, NORMAL, REMOTE);
REMOTE.names = Object.keys(REMOTE);
NORMAL.names = Object.keys(NORMAL);
ALL.names = [].concat(REMOTE.names).concat(NORMAL.names);
function createTrackHelper(self2, kind, label, language, options = {}) {
  const tracks = self2.textTracks();
  options.kind = kind;
  if (label) {
    options.label = label;
  }
  if (language) {
    options.language = language;
  }
  options.tech = self2;
  const track = new ALL.text.TrackClass(options);
  tracks.addTrack(track);
  return track;
}
class Tech extends Component$1 {
  constructor(options = {}, ready = function() {
  }) {
    options.reportTouchActivity = false;
    super(null, options, ready);
    this.onDurationChange_ = (e) => this.onDurationChange(e);
    this.trackProgress_ = (e) => this.trackProgress(e);
    this.trackCurrentTime_ = (e) => this.trackCurrentTime(e);
    this.stopTrackingCurrentTime_ = (e) => this.stopTrackingCurrentTime(e);
    this.disposeSourceHandler_ = (e) => this.disposeSourceHandler(e);
    this.queuedHanders_ = /* @__PURE__ */ new Set();
    this.hasStarted_ = false;
    this.on("playing", function() {
      this.hasStarted_ = true;
    });
    this.on("loadstart", function() {
      this.hasStarted_ = false;
    });
    ALL.names.forEach((name) => {
      const props = ALL[name];
      if (options && options[props.getterName]) {
        this[props.privateName] = options[props.getterName];
      }
    });
    if (!this.featuresProgressEvents) {
      this.manualProgressOn();
    }
    if (!this.featuresTimeupdateEvents) {
      this.manualTimeUpdatesOn();
    }
    ["Text", "Audio", "Video"].forEach((track) => {
      if (options[`native${track}Tracks`] === false) {
        this[`featuresNative${track}Tracks`] = false;
      }
    });
    if (options.nativeCaptions === false || options.nativeTextTracks === false) {
      this.featuresNativeTextTracks = false;
    } else if (options.nativeCaptions === true || options.nativeTextTracks === true) {
      this.featuresNativeTextTracks = true;
    }
    if (!this.featuresNativeTextTracks) {
      this.emulateTextTracks();
    }
    this.preloadTextTracks = options.preloadTextTracks !== false;
    this.autoRemoteTextTracks_ = new ALL.text.ListClass();
    this.initTrackListeners();
    if (!options.nativeControlsForTouch) {
      this.emitTapEvents();
    }
    if (this.constructor) {
      this.name_ = this.constructor.name || "Unknown Tech";
    }
  }
  triggerSourceset(src) {
    if (!this.isReady_) {
      this.one("ready", () => this.setTimeout(() => this.triggerSourceset(src), 1));
    }
    this.trigger({
      src,
      type: "sourceset"
    });
  }
  manualProgressOn() {
    this.on("durationchange", this.onDurationChange_);
    this.manualProgress = true;
    this.one("ready", this.trackProgress_);
  }
  manualProgressOff() {
    this.manualProgress = false;
    this.stopTrackingProgress();
    this.off("durationchange", this.onDurationChange_);
  }
  trackProgress(event) {
    this.stopTrackingProgress();
    this.progressInterval = this.setInterval(bind_(this, function() {
      const numBufferedPercent = this.bufferedPercent();
      if (this.bufferedPercent_ !== numBufferedPercent) {
        this.trigger("progress");
      }
      this.bufferedPercent_ = numBufferedPercent;
      if (numBufferedPercent === 1) {
        this.stopTrackingProgress();
      }
    }), 500);
  }
  onDurationChange(event) {
    this.duration_ = this.duration();
  }
  buffered() {
    return createTimeRanges$1(0, 0);
  }
  bufferedPercent() {
    return bufferedPercent(this.buffered(), this.duration_);
  }
  stopTrackingProgress() {
    this.clearInterval(this.progressInterval);
  }
  manualTimeUpdatesOn() {
    this.manualTimeUpdates = true;
    this.on("play", this.trackCurrentTime_);
    this.on("pause", this.stopTrackingCurrentTime_);
  }
  manualTimeUpdatesOff() {
    this.manualTimeUpdates = false;
    this.stopTrackingCurrentTime();
    this.off("play", this.trackCurrentTime_);
    this.off("pause", this.stopTrackingCurrentTime_);
  }
  trackCurrentTime() {
    if (this.currentTimeInterval) {
      this.stopTrackingCurrentTime();
    }
    this.currentTimeInterval = this.setInterval(function() {
      this.trigger({
        type: "timeupdate",
        target: this,
        manuallyTriggered: true
      });
    }, 250);
  }
  stopTrackingCurrentTime() {
    this.clearInterval(this.currentTimeInterval);
    this.trigger({
      type: "timeupdate",
      target: this,
      manuallyTriggered: true
    });
  }
  dispose() {
    this.clearTracks(NORMAL.names);
    if (this.manualProgress) {
      this.manualProgressOff();
    }
    if (this.manualTimeUpdates) {
      this.manualTimeUpdatesOff();
    }
    super.dispose();
  }
  clearTracks(types) {
    types = [].concat(types);
    types.forEach((type) => {
      const list = this[`${type}Tracks`]() || [];
      let i = list.length;
      while (i--) {
        const track = list[i];
        if (type === "text") {
          this.removeRemoteTextTrack(track);
        }
        list.removeTrack(track);
      }
    });
  }
  cleanupAutoTextTracks() {
    const list = this.autoRemoteTextTracks_ || [];
    let i = list.length;
    while (i--) {
      const track = list[i];
      this.removeRemoteTextTrack(track);
    }
  }
  reset() {
  }
  crossOrigin() {
  }
  setCrossOrigin() {
  }
  error(err) {
    if (err !== void 0) {
      this.error_ = new MediaError(err);
      this.trigger("error");
    }
    return this.error_;
  }
  played() {
    if (this.hasStarted_) {
      return createTimeRanges$1(0, 0);
    }
    return createTimeRanges$1();
  }
  play() {
  }
  setScrubbing(_isScrubbing) {
  }
  scrubbing() {
  }
  setCurrentTime(_seconds) {
    if (this.manualTimeUpdates) {
      this.trigger({
        type: "timeupdate",
        target: this,
        manuallyTriggered: true
      });
    }
  }
  initTrackListeners() {
    NORMAL.names.forEach((name) => {
      const props = NORMAL[name];
      const trackListChanges = () => {
        this.trigger(`${name}trackchange`);
      };
      const tracks = this[props.getterName]();
      tracks.addEventListener("removetrack", trackListChanges);
      tracks.addEventListener("addtrack", trackListChanges);
      this.on("dispose", () => {
        tracks.removeEventListener("removetrack", trackListChanges);
        tracks.removeEventListener("addtrack", trackListChanges);
      });
    });
  }
  addWebVttScript_() {
    if (window_1.WebVTT) {
      return;
    }
    if (document_1.body.contains(this.el())) {
      if (!this.options_["vtt.js"] && isPlain(browserIndex.exports) && Object.keys(browserIndex.exports).length > 0) {
        this.trigger("vttjsloaded");
        return;
      }
      const script = document_1.createElement("script");
      script.src = this.options_["vtt.js"] || "https://vjs.zencdn.net/vttjs/0.14.1/vtt.min.js";
      script.onload = () => {
        this.trigger("vttjsloaded");
      };
      script.onerror = () => {
        this.trigger("vttjserror");
      };
      this.on("dispose", () => {
        script.onload = null;
        script.onerror = null;
      });
      window_1.WebVTT = true;
      this.el().parentNode.appendChild(script);
    } else {
      this.ready(this.addWebVttScript_);
    }
  }
  emulateTextTracks() {
    const tracks = this.textTracks();
    const remoteTracks = this.remoteTextTracks();
    const handleAddTrack = (e) => tracks.addTrack(e.track);
    const handleRemoveTrack = (e) => tracks.removeTrack(e.track);
    remoteTracks.on("addtrack", handleAddTrack);
    remoteTracks.on("removetrack", handleRemoveTrack);
    this.addWebVttScript_();
    const updateDisplay = () => this.trigger("texttrackchange");
    const textTracksChanges = () => {
      updateDisplay();
      for (let i = 0; i < tracks.length; i++) {
        const track = tracks[i];
        track.removeEventListener("cuechange", updateDisplay);
        if (track.mode === "showing") {
          track.addEventListener("cuechange", updateDisplay);
        }
      }
    };
    textTracksChanges();
    tracks.addEventListener("change", textTracksChanges);
    tracks.addEventListener("addtrack", textTracksChanges);
    tracks.addEventListener("removetrack", textTracksChanges);
    this.on("dispose", function() {
      remoteTracks.off("addtrack", handleAddTrack);
      remoteTracks.off("removetrack", handleRemoveTrack);
      tracks.removeEventListener("change", textTracksChanges);
      tracks.removeEventListener("addtrack", textTracksChanges);
      tracks.removeEventListener("removetrack", textTracksChanges);
      for (let i = 0; i < tracks.length; i++) {
        const track = tracks[i];
        track.removeEventListener("cuechange", updateDisplay);
      }
    });
  }
  addTextTrack(kind, label, language) {
    if (!kind) {
      throw new Error("TextTrack kind is required but was not provided");
    }
    return createTrackHelper(this, kind, label, language);
  }
  createRemoteTextTrack(options) {
    const track = merge$1(options, {
      tech: this
    });
    return new REMOTE.remoteTextEl.TrackClass(track);
  }
  addRemoteTextTrack(options = {}, manualCleanup) {
    const htmlTrackElement = this.createRemoteTextTrack(options);
    if (typeof manualCleanup !== "boolean") {
      manualCleanup = false;
    }
    this.remoteTextTrackEls().addTrackElement_(htmlTrackElement);
    this.remoteTextTracks().addTrack(htmlTrackElement.track);
    if (manualCleanup === false) {
      this.ready(() => this.autoRemoteTextTracks_.addTrack(htmlTrackElement.track));
    }
    return htmlTrackElement;
  }
  removeRemoteTextTrack(track) {
    const trackElement = this.remoteTextTrackEls().getTrackElementByTrack_(track);
    this.remoteTextTrackEls().removeTrackElement_(trackElement);
    this.remoteTextTracks().removeTrack(track);
    this.autoRemoteTextTracks_.removeTrack(track);
  }
  getVideoPlaybackQuality() {
    return {};
  }
  requestPictureInPicture() {
    return Promise.reject();
  }
  disablePictureInPicture() {
    return true;
  }
  setDisablePictureInPicture() {
  }
  requestVideoFrameCallback(cb) {
    const id = newGUID();
    if (!this.isReady_ || this.paused()) {
      this.queuedHanders_.add(id);
      this.one("playing", () => {
        if (this.queuedHanders_.has(id)) {
          this.queuedHanders_.delete(id);
          cb();
        }
      });
    } else {
      this.requestNamedAnimationFrame(id, cb);
    }
    return id;
  }
  cancelVideoFrameCallback(id) {
    if (this.queuedHanders_.has(id)) {
      this.queuedHanders_.delete(id);
    } else {
      this.cancelNamedAnimationFrame(id);
    }
  }
  setPoster() {
  }
  playsinline() {
  }
  setPlaysinline() {
  }
  overrideNativeAudioTracks(override) {
  }
  overrideNativeVideoTracks(override) {
  }
  canPlayType(_type) {
    return "";
  }
  static canPlayType(_type) {
    return "";
  }
  static canPlaySource(srcObj, options) {
    return Tech.canPlayType(srcObj.type);
  }
  static isTech(component) {
    return component.prototype instanceof Tech || component instanceof Tech || component === Tech;
  }
  static registerTech(name, tech) {
    if (!Tech.techs_) {
      Tech.techs_ = {};
    }
    if (!Tech.isTech(tech)) {
      throw new Error(`Tech ${name} must be a Tech`);
    }
    if (!Tech.canPlayType) {
      throw new Error("Techs must have a static canPlayType method on them");
    }
    if (!Tech.canPlaySource) {
      throw new Error("Techs must have a static canPlaySource method on them");
    }
    name = toTitleCase$1(name);
    Tech.techs_[name] = tech;
    Tech.techs_[toLowerCase(name)] = tech;
    if (name !== "Tech") {
      Tech.defaultTechOrder_.push(name);
    }
    return tech;
  }
  static getTech(name) {
    if (!name) {
      return;
    }
    if (Tech.techs_ && Tech.techs_[name]) {
      return Tech.techs_[name];
    }
    name = toTitleCase$1(name);
    if (window_1 && window_1.videojs && window_1.videojs[name]) {
      log$1.warn(`The ${name} tech was added to the videojs object when it should be registered using videojs.registerTech(name, tech)`);
      return window_1.videojs[name];
    }
  }
}
ALL.names.forEach(function(name) {
  const props = ALL[name];
  Tech.prototype[props.getterName] = function() {
    this[props.privateName] = this[props.privateName] || new props.ListClass();
    return this[props.privateName];
  };
});
Tech.prototype.featuresVolumeControl = true;
Tech.prototype.featuresMuteControl = true;
Tech.prototype.featuresFullscreenResize = false;
Tech.prototype.featuresPlaybackRate = false;
Tech.prototype.featuresProgressEvents = false;
Tech.prototype.featuresSourceset = false;
Tech.prototype.featuresTimeupdateEvents = false;
Tech.prototype.featuresNativeTextTracks = false;
Tech.prototype.featuresVideoFrameCallback = false;
Tech.withSourceHandlers = function(_Tech) {
  _Tech.registerSourceHandler = function(handler, index) {
    let handlers = _Tech.sourceHandlers;
    if (!handlers) {
      handlers = _Tech.sourceHandlers = [];
    }
    if (index === void 0) {
      index = handlers.length;
    }
    handlers.splice(index, 0, handler);
  };
  _Tech.canPlayType = function(type) {
    const handlers = _Tech.sourceHandlers || [];
    let can;
    for (let i = 0; i < handlers.length; i++) {
      can = handlers[i].canPlayType(type);
      if (can) {
        return can;
      }
    }
    return "";
  };
  _Tech.selectSourceHandler = function(source, options) {
    const handlers = _Tech.sourceHandlers || [];
    let can;
    for (let i = 0; i < handlers.length; i++) {
      can = handlers[i].canHandleSource(source, options);
      if (can) {
        return handlers[i];
      }
    }
    return null;
  };
  _Tech.canPlaySource = function(srcObj, options) {
    const sh = _Tech.selectSourceHandler(srcObj, options);
    if (sh) {
      return sh.canHandleSource(srcObj, options);
    }
    return "";
  };
  const deferrable = ["seekable", "seeking", "duration"];
  deferrable.forEach(function(fnName) {
    const originalFn = this[fnName];
    if (typeof originalFn !== "function") {
      return;
    }
    this[fnName] = function() {
      if (this.sourceHandler_ && this.sourceHandler_[fnName]) {
        return this.sourceHandler_[fnName].apply(this.sourceHandler_, arguments);
      }
      return originalFn.apply(this, arguments);
    };
  }, _Tech.prototype);
  _Tech.prototype.setSource = function(source) {
    let sh = _Tech.selectSourceHandler(source, this.options_);
    if (!sh) {
      if (_Tech.nativeSourceHandler) {
        sh = _Tech.nativeSourceHandler;
      } else {
        log$1.error("No source handler found for the current source.");
      }
    }
    this.disposeSourceHandler();
    this.off("dispose", this.disposeSourceHandler_);
    if (sh !== _Tech.nativeSourceHandler) {
      this.currentSource_ = source;
    }
    this.sourceHandler_ = sh.handleSource(source, this, this.options_);
    this.one("dispose", this.disposeSourceHandler_);
  };
  _Tech.prototype.disposeSourceHandler = function() {
    if (this.currentSource_) {
      this.clearTracks(["audio", "video"]);
      this.currentSource_ = null;
    }
    this.cleanupAutoTextTracks();
    if (this.sourceHandler_) {
      if (this.sourceHandler_.dispose) {
        this.sourceHandler_.dispose();
      }
      this.sourceHandler_ = null;
    }
  };
};
Component$1.registerComponent("Tech", Tech);
Tech.registerTech("Tech", Tech);
Tech.defaultTechOrder_ = [];
const middlewares = {};
const middlewareInstances = {};
const TERMINATOR = {};
function use(type, middleware) {
  middlewares[type] = middlewares[type] || [];
  middlewares[type].push(middleware);
}
function setSource(player, src, next) {
  player.setTimeout(() => setSourceHelper(src, middlewares[src.type], next, player), 1);
}
function setTech(middleware, tech) {
  middleware.forEach((mw) => mw.setTech && mw.setTech(tech));
}
function get(middleware, tech, method) {
  return middleware.reduceRight(middlewareIterator(method), tech[method]());
}
function set(middleware, tech, method, arg) {
  return tech[method](middleware.reduce(middlewareIterator(method), arg));
}
function mediate(middleware, tech, method, arg = null) {
  const callMethod = "call" + toTitleCase$1(method);
  const middlewareValue = middleware.reduce(middlewareIterator(callMethod), arg);
  const terminated = middlewareValue === TERMINATOR;
  const returnValue = terminated ? null : tech[method](middlewareValue);
  executeRight(middleware, method, returnValue, terminated);
  return returnValue;
}
const allowedGetters = {
  buffered: 1,
  currentTime: 1,
  duration: 1,
  muted: 1,
  played: 1,
  paused: 1,
  seekable: 1,
  volume: 1,
  ended: 1
};
const allowedSetters = {
  setCurrentTime: 1,
  setMuted: 1,
  setVolume: 1
};
const allowedMediators = {
  play: 1,
  pause: 1
};
function middlewareIterator(method) {
  return (value, mw) => {
    if (value === TERMINATOR) {
      return TERMINATOR;
    }
    if (mw[method]) {
      return mw[method](value);
    }
    return value;
  };
}
function executeRight(mws, method, value, terminated) {
  for (let i = mws.length - 1; i >= 0; i--) {
    const mw = mws[i];
    if (mw[method]) {
      mw[method](terminated, value);
    }
  }
}
function clearCacheForPlayer(player) {
  if (middlewareInstances.hasOwnProperty(player.id())) {
    delete middlewareInstances[player.id()];
  }
}
function getOrCreateFactory(player, mwFactory) {
  const mws = middlewareInstances[player.id()];
  let mw = null;
  if (mws === void 0 || mws === null) {
    mw = mwFactory(player);
    middlewareInstances[player.id()] = [[mwFactory, mw]];
    return mw;
  }
  for (let i = 0; i < mws.length; i++) {
    const [mwf, mwi] = mws[i];
    if (mwf !== mwFactory) {
      continue;
    }
    mw = mwi;
  }
  if (mw === null) {
    mw = mwFactory(player);
    mws.push([mwFactory, mw]);
  }
  return mw;
}
function setSourceHelper(src = {}, middleware = [], next, player, acc = [], lastRun = false) {
  const [mwFactory, ...mwrest] = middleware;
  if (typeof mwFactory === "string") {
    setSourceHelper(src, middlewares[mwFactory], next, player, acc, lastRun);
  } else if (mwFactory) {
    const mw = getOrCreateFactory(player, mwFactory);
    if (!mw.setSource) {
      acc.push(mw);
      return setSourceHelper(src, mwrest, next, player, acc, lastRun);
    }
    mw.setSource(Object.assign({}, src), function(err, _src) {
      if (err) {
        return setSourceHelper(src, mwrest, next, player, acc, lastRun);
      }
      acc.push(mw);
      setSourceHelper(_src, src.type === _src.type ? mwrest : middlewares[_src.type], next, player, acc, lastRun);
    });
  } else if (mwrest.length) {
    setSourceHelper(src, mwrest, next, player, acc, lastRun);
  } else if (lastRun) {
    next(src, acc);
  } else {
    setSourceHelper(src, middlewares["*"], next, player, acc, true);
  }
}
const MimetypesKind = {
  opus: "video/ogg",
  ogv: "video/ogg",
  mp4: "video/mp4",
  mov: "video/mp4",
  m4v: "video/mp4",
  mkv: "video/x-matroska",
  m4a: "audio/mp4",
  mp3: "audio/mpeg",
  aac: "audio/aac",
  caf: "audio/x-caf",
  flac: "audio/flac",
  oga: "audio/ogg",
  wav: "audio/wav",
  m3u8: "application/x-mpegURL",
  mpd: "application/dash+xml",
  jpg: "image/jpeg",
  jpeg: "image/jpeg",
  gif: "image/gif",
  png: "image/png",
  svg: "image/svg+xml",
  webp: "image/webp"
};
const getMimetype = function(src = "") {
  const ext = getFileExtension(src);
  const mimetype = MimetypesKind[ext.toLowerCase()];
  return mimetype || "";
};
const findMimetype = (player, src) => {
  if (!src) {
    return "";
  }
  if (player.cache_.source.src === src && player.cache_.source.type) {
    return player.cache_.source.type;
  }
  const matchingSources = player.cache_.sources.filter((s) => s.src === src);
  if (matchingSources.length) {
    return matchingSources[0].type;
  }
  const sources = player.$$("source");
  for (let i = 0; i < sources.length; i++) {
    const s = sources[i];
    if (s.type && s.src && s.src === src) {
      return s.type;
    }
  }
  return getMimetype(src);
};
const filterSource = function(src) {
  if (Array.isArray(src)) {
    let newsrc = [];
    src.forEach(function(srcobj) {
      srcobj = filterSource(srcobj);
      if (Array.isArray(srcobj)) {
        newsrc = newsrc.concat(srcobj);
      } else if (isObject(srcobj)) {
        newsrc.push(srcobj);
      }
    });
    src = newsrc;
  } else if (typeof src === "string" && src.trim()) {
    src = [fixSource({
      src
    })];
  } else if (isObject(src) && typeof src.src === "string" && src.src && src.src.trim()) {
    src = [fixSource(src)];
  } else {
    src = [];
  }
  return src;
};
function fixSource(src) {
  if (!src.type) {
    const mimetype = getMimetype(src.src);
    if (mimetype) {
      src.type = mimetype;
    }
  }
  return src;
}
var icons = '<svg xmlns="http://www.w3.org/2000/svg">\n  <defs>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-play">\n      <path d="M16 10v28l22-14z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-pause">\n      <path d="M12 38h8V10h-8v28zm16-28v28h8V10h-8z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-audio">\n      <path d="M24 2C14.06 2 6 10.06 6 20v14c0 3.31 2.69 6 6 6h6V24h-8v-4c0-7.73 6.27-14 14-14s14 6.27 14 14v4h-8v16h6c3.31 0 6-2.69 6-6V20c0-9.94-8.06-18-18-18z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-captions">\n      <path d="M38 8H10c-2.21 0-4 1.79-4 4v24c0 2.21 1.79 4 4 4h28c2.21 0 4-1.79 4-4V12c0-2.21-1.79-4-4-4zM22 22h-3v-1h-4v6h4v-1h3v2a2 2 0 0 1-2 2h-6a2 2 0 0 1-2-2v-8a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v2zm14 0h-3v-1h-4v6h4v-1h3v2a2 2 0 0 1-2 2h-6a2 2 0 0 1-2-2v-8a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v2z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-subtitles">\n      <path d="M40 8H8c-2.21 0-4 1.79-4 4v24c0 2.21 1.79 4 4 4h32c2.21 0 4-1.79 4-4V12c0-2.21-1.79-4-4-4zM8 24h8v4H8v-4zm20 12H8v-4h20v4zm12 0h-8v-4h8v4zm0-8H20v-4h20v4z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-fullscreen-enter">\n      <path d="M14 28h-4v10h10v-4h-6v-6zm-4-8h4v-6h6v-4H10v10zm24 14h-6v4h10V28h-4v6zm-6-24v4h6v6h4V10H28z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-fullscreen-exit">\n      <path d="M10 32h6v6h4V28H10v4zm6-16h-6v4h10V10h-4v6zm12 22h4v-6h6v-4H28v10zm4-22v-6h-4v10h10v-4h-6z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-play-circle">\n      <path d="M20 33l12-9-12-9v18zm4-29C12.95 4 4 12.95 4 24s8.95 20 20 20 20-8.95 20-20S35.05 4 24 4zm0 36c-8.82 0-16-7.18-16-16S15.18 8 24 8s16 7.18 16 16-7.18 16-16 16z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-volume-mute">\n      <path d="M33 24c0-3.53-2.04-6.58-5-8.05v4.42l4.91 4.91c.06-.42.09-.85.09-1.28zm5 0c0 1.88-.41 3.65-1.08 5.28l3.03 3.03C41.25 29.82 42 27 42 24c0-8.56-5.99-15.72-14-17.54v4.13c5.78 1.72 10 7.07 10 13.41zM8.55 6L6 8.55 15.45 18H6v12h8l10 10V26.55l8.51 8.51c-1.34 1.03-2.85 1.86-4.51 2.36v4.13a17.94 17.94 0 0 0 7.37-3.62L39.45 42 42 39.45l-18-18L8.55 6zM24 8l-4.18 4.18L24 16.36V8z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-volume-low">\n      <path d="M14 18v12h8l10 10V8L22 18h-8z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-volume-medium">\n      <path d="M37 24c0-3.53-2.04-6.58-5-8.05v16.11c2.96-1.48 5-4.53 5-8.06zm-27-6v12h8l10 10V8L18 18h-8z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-volume-high">\n      <path d="M6 18v12h8l10 10V8L14 18H6zm27 6c0-3.53-2.04-6.58-5-8.05v16.11c2.96-1.48 5-4.53 5-8.06zM28 6.46v4.13c5.78 1.72 10 7.07 10 13.41s-4.22 11.69-10 13.41v4.13c8.01-1.82 14-8.97 14-17.54S36.01 8.28 28 6.46z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-spinner">\n      <path d="M18.8 21l9.53-16.51C26.94 4.18 25.49 4 24 4c-4.8 0-9.19 1.69-12.64 4.51l7.33 12.69.11-.2zm24.28-3c-1.84-5.85-6.3-10.52-11.99-12.68L23.77 18h19.31zm.52 2H28.62l.58 1 9.53 16.5C41.99 33.94 44 29.21 44 24c0-1.37-.14-2.71-.4-4zm-26.53 4l-7.8-13.5C6.01 14.06 4 18.79 4 24c0 1.37.14 2.71.4 4h14.98l-2.31-4zM4.92 30c1.84 5.85 6.3 10.52 11.99 12.68L24.23 30H4.92zm22.54 0l-7.8 13.51c1.4.31 2.85.49 4.34.49 4.8 0 9.19-1.69 12.64-4.51L29.31 26.8 27.46 30z"></path>\n    </symbol>\n    <symbol viewBox="0 0 24 24" id="vjs-icon-hd">\n      <path d="M19 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-8 12H9.5v-2h-2v2H6V9h1.5v2.5h2V9H11v6zm2-6h4c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1h-4V9zm1.5 4.5h2v-3h-2v3z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-chapters">\n      <path d="M6 26h4v-4H6v4zm0 8h4v-4H6v4zm0-16h4v-4H6v4zm8 8h28v-4H14v4zm0 8h28v-4H14v4zm0-20v4h28v-4H14z"></path>\n    </symbol>\n    <symbol viewBox="0 0 40 40" id="vjs-icon-downloading">\n      <path d="M18.208 36.875q-3.208-.292-5.979-1.729-2.771-1.438-4.812-3.729-2.042-2.292-3.188-5.229-1.146-2.938-1.146-6.23 0-6.583 4.334-11.416 4.333-4.834 10.833-5.5v3.166q-5.167.75-8.583 4.646Q6.25 14.75 6.25 19.958q0 5.209 3.396 9.104 3.396 3.896 8.562 4.646zM20 28.417L11.542 20l2.083-2.083 4.917 4.916v-11.25h2.916v11.25l4.875-4.916L28.417 20zm1.792 8.458v-3.167q1.833-.25 3.541-.958 1.709-.708 3.167-1.875l2.333 2.292q-1.958 1.583-4.25 2.541-2.291.959-4.791 1.167zm6.791-27.792q-1.541-1.125-3.25-1.854-1.708-.729-3.541-1.021V3.042q2.5.25 4.77 1.208 2.271.958 4.271 2.5zm4.584 21.584l-2.25-2.25q1.166-1.5 1.854-3.209.687-1.708.937-3.541h3.209q-.292 2.5-1.229 4.791-.938 2.292-2.521 4.209zm.541-12.417q-.291-1.833-.958-3.562-.667-1.73-1.833-3.188l2.375-2.208q1.541 1.916 2.458 4.208.917 2.292 1.167 4.75z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-file-download">\n      <path d="M10.8 40.55q-1.35 0-2.375-1T7.4 37.15v-7.7h3.4v7.7h26.35v-7.7h3.4v7.7q0 1.4-1 2.4t-2.4 1zM24 32.1L13.9 22.05l2.45-2.45 5.95 5.95V7.15h3.4v18.4l5.95-5.95 2.45 2.45z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-file-download-done">\n      <path d="M9.8 40.5v-3.45h28.4v3.45zm9.2-9.05L7.4 19.85l2.45-2.35L19 26.65l19.2-19.2 2.4 2.4z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-file-download-off">\n      <path d="M4.9 4.75L43.25 43.1 41 45.3l-4.75-4.75q-.05.05-.075.025-.025-.025-.075-.025H10.8q-1.35 0-2.375-1T7.4 37.15v-7.7h3.4v7.7h22.05l-7-7-1.85 1.8L13.9 21.9l1.85-1.85L2.7 7zm26.75 14.7l2.45 2.45-3.75 3.8-2.45-2.5zM25.7 7.15V21.1l-3.4-3.45V7.15z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-share">\n      <path d="M36 32.17c-1.52 0-2.89.59-3.93 1.54L17.82 25.4c.11-.45.18-.92.18-1.4s-.07-.95-.18-1.4l14.1-8.23c1.07 1 2.5 1.62 4.08 1.62 3.31 0 6-2.69 6-6s-2.69-6-6-6-6 2.69-6 6c0 .48.07.95.18 1.4l-14.1 8.23c-1.07-1-2.5-1.62-4.08-1.62-3.31 0-6 2.69-6 6s2.69 6 6 6c1.58 0 3.01-.62 4.08-1.62l14.25 8.31c-.1.42-.16.86-.16 1.31A5.83 5.83 0 1 0 36 32.17z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-cog">\n      <path d="M38.86 25.95c.08-.64.14-1.29.14-1.95s-.06-1.31-.14-1.95l4.23-3.31c.38-.3.49-.84.24-1.28l-4-6.93c-.25-.43-.77-.61-1.22-.43l-4.98 2.01c-1.03-.79-2.16-1.46-3.38-1.97L29 4.84c-.09-.47-.5-.84-1-.84h-8c-.5 0-.91.37-.99.84l-.75 5.3a14.8 14.8 0 0 0-3.38 1.97L9.9 10.1a1 1 0 0 0-1.22.43l-4 6.93c-.25.43-.14.97.24 1.28l4.22 3.31C9.06 22.69 9 23.34 9 24s.06 1.31.14 1.95l-4.22 3.31c-.38.3-.49.84-.24 1.28l4 6.93c.25.43.77.61 1.22.43l4.98-2.01c1.03.79 2.16 1.46 3.38 1.97l.75 5.3c.08.47.49.84.99.84h8c.5 0 .91-.37.99-.84l.75-5.3a14.8 14.8 0 0 0 3.38-1.97l4.98 2.01a1 1 0 0 0 1.22-.43l4-6.93c.25-.43.14-.97-.24-1.28l-4.22-3.31zM24 31c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-square">\n      <path d="M36 8H12c-2.21 0-4 1.79-4 4v24c0 2.21 1.79 4 4 4h24c2.21 0 4-1.79 4-4V12c0-2.21-1.79-4-4-4zm0 28H12V12h24v24z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-circle">\n      <circle cx="24" cy="24" r="20"></circle>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-circle-outline">\n      <path d="M24 4C12.95 4 4 12.95 4 24s8.95 20 20 20 20-8.95 20-20S35.05 4 24 4zm0 36c-8.82 0-16-7.18-16-16S15.18 8 24 8s16 7.18 16 16-7.18 16-16 16z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-circle-inner-circle">\n      <path d="M24 4C12.97 4 4 12.97 4 24s8.97 20 20 20 20-8.97 20-20S35.03 4 24 4zm0 36c-8.82 0-16-7.18-16-16S15.18 8 24 8s16 7.18 16 16-7.18 16-16 16zm6-16c0 3.31-2.69 6-6 6s-6-2.69-6-6 2.69-6 6-6 6 2.69 6 6z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-cancel">\n      <path d="M24 4C12.95 4 4 12.95 4 24s8.95 20 20 20 20-8.95 20-20S35.05 4 24 4zm10 27.17L31.17 34 24 26.83 16.83 34 14 31.17 21.17 24 14 16.83 16.83 14 24 21.17 31.17 14 34 16.83 26.83 24 34 31.17z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-replay">\n      <path d="M24 10V2L14 12l10 10v-8c6.63 0 12 5.37 12 12s-5.37 12-12 12-12-5.37-12-12H8c0 8.84 7.16 16 16 16s16-7.16 16-16-7.16-16-16-16z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-repeat">\n      <path d="M14 14h20v6l8-8-8-8v6H10v12h4v-8zm20 20H14v-6l-8 8 8 8v-6h24V26h-4v8z"></path>\n    </symbol>\n    <symbol viewBox="0 96 48 48" id="vjs-icon-replay-5">\n      <path d="M17.689 98l-8.697 8.696 8.697 8.697 2.486-2.485-4.32-4.319h1.302c4.93 0 9.071 1.722 12.424 5.165 3.352 3.443 5.029 7.638 5.029 12.584h3.55c0-2.958-.553-5.73-1.658-8.313-1.104-2.583-2.622-4.841-4.555-6.774-1.932-1.932-4.19-3.45-6.773-4.555-2.584-1.104-5.355-1.657-8.313-1.657H15.5l4.615-4.615zm-8.08 21.659v13.861h11.357v5.008H9.609V143h12.7c.834 0 1.55-.298 2.146-.894.596-.597.895-1.31.895-2.145v-7.781c0-.835-.299-1.55-.895-2.147a2.929 2.929 0 0 0-2.147-.894h-8.227v-5.096H25.35v-4.384z"></path>\n    </symbol>\n    <symbol viewBox="0 96 48 48" id="vjs-icon-replay-10">\n      <path d="M42.315 125.63c0-4.997-1.694-9.235-5.08-12.713-3.388-3.479-7.571-5.218-12.552-5.218h-1.315l4.363 4.363-2.51 2.51-8.787-8.786L25.221 97l2.45 2.45-4.662 4.663h1.375c2.988 0 5.788.557 8.397 1.673 2.61 1.116 4.892 2.65 6.844 4.602 1.953 1.953 3.487 4.234 4.602 6.844 1.116 2.61 1.674 5.41 1.674 8.398zM8.183 142v-19.657H3.176V117.8h9.643V142zm13.63 0c-1.156 0-2.127-.393-2.912-1.178-.778-.778-1.168-1.746-1.168-2.902v-16.04c0-1.156.393-2.127 1.178-2.912.779-.779 1.746-1.168 2.902-1.168h7.696c1.156 0 2.126.392 2.911 1.177.779.78 1.168 1.747 1.168 2.903v16.04c0 1.156-.392 2.127-1.177 2.912-.779.779-1.746 1.168-2.902 1.168zm.556-4.636h6.583v-15.02H22.37z"></path>\n    </symbol>\n    <symbol viewBox="0 96 48 48" id="vjs-icon-replay-30">\n      <path d="M26.047 97l-8.733 8.732 8.733 8.733 2.496-2.494-4.336-4.338h1.307c4.95 0 9.108 1.73 12.474 5.187 3.367 3.458 5.051 7.668 5.051 12.635h3.565c0-2.97-.556-5.751-1.665-8.346-1.109-2.594-2.633-4.862-4.574-6.802-1.94-1.941-4.208-3.466-6.803-4.575-2.594-1.109-5.375-1.664-8.345-1.664H23.85l4.634-4.634zM2.555 117.531v4.688h10.297v5.25H5.873v4.687h6.979v5.156H2.555V142H13.36c1.061 0 1.95-.395 2.668-1.186.718-.79 1.076-1.772 1.076-2.94v-16.218c0-1.168-.358-2.149-1.076-2.94-.717-.79-1.607-1.185-2.668-1.185zm22.482.14c-1.149 0-2.11.39-2.885 1.165-.78.78-1.172 1.744-1.172 2.893v15.943c0 1.149.388 2.11 1.163 2.885.78.78 1.745 1.172 2.894 1.172h7.649c1.148 0 2.11-.388 2.884-1.163.78-.78 1.17-1.745 1.17-2.894v-15.943c0-1.15-.386-2.111-1.16-2.885-.78-.78-1.746-1.172-2.894-1.172zm.553 4.518h6.545v14.93H25.59z"></path>\n    </symbol>\n    <symbol viewBox="0 96 48 48" id="vjs-icon-forward-5">\n      <path d="M29.508 97l-2.431 2.43 4.625 4.625h-1.364c-2.965 0-5.742.554-8.332 1.66-2.589 1.107-4.851 2.629-6.788 4.566-1.937 1.937-3.458 4.2-4.565 6.788-1.107 2.59-1.66 5.367-1.66 8.331h3.557c0-4.957 1.68-9.16 5.04-12.611 3.36-3.45 7.51-5.177 12.451-5.177h1.304l-4.326 4.33 2.49 2.49 8.715-8.716zm-9.783 21.61v13.89h11.382v5.018H19.725V142h12.727a2.93 2.93 0 0 0 2.15-.896 2.93 2.93 0 0 0 .896-2.15v-7.798c0-.837-.299-1.554-.896-2.152a2.93 2.93 0 0 0-2.15-.896h-8.245V123h11.29v-4.392z"></path>\n    </symbol>\n    <symbol viewBox="0 96 48 48" id="vjs-icon-forward-10">\n      <path d="M23.119 97l-2.386 2.383 4.538 4.538h-1.339c-2.908 0-5.633.543-8.173 1.63-2.54 1.085-4.76 2.577-6.66 4.478-1.9 1.9-3.392 4.12-4.478 6.66-1.085 2.54-1.629 5.264-1.629 8.172h3.49c0-4.863 1.648-8.986 4.944-12.372 3.297-3.385 7.368-5.078 12.216-5.078h1.279l-4.245 4.247 2.443 2.442 8.55-8.55zm-9.52 21.45v4.42h4.871V142h4.513v-23.55zm18.136 0c-1.125 0-2.066.377-2.824 1.135-.764.764-1.148 1.709-1.148 2.834v15.612c0 1.124.38 2.066 1.139 2.824.764.764 1.708 1.145 2.833 1.145h7.489c1.125 0 2.066-.378 2.824-1.136.764-.764 1.145-1.709 1.145-2.833v-15.612c0-1.125-.378-2.067-1.136-2.825-.764-.764-1.708-1.145-2.833-1.145zm.54 4.42h6.408v14.617h-6.407z"></path>\n    </symbol>\n    <symbol viewBox="0 96 48 48" id="vjs-icon-forward-30">\n      <path d="M25.549 97l-2.437 2.434 4.634 4.635H26.38c-2.97 0-5.753.555-8.347 1.664-2.594 1.109-4.861 2.633-6.802 4.574-1.94 1.94-3.465 4.207-4.574 6.802-1.109 2.594-1.664 5.377-1.664 8.347h3.565c0-4.967 1.683-9.178 5.05-12.636 3.366-3.458 7.525-5.187 12.475-5.187h1.307l-4.335 4.338 2.495 2.494 8.732-8.732zm-11.553 20.53v4.689h10.297v5.249h-6.978v4.688h6.978v5.156H13.996V142h10.808c1.06 0 1.948-.395 2.666-1.186.718-.79 1.077-1.771 1.077-2.94v-16.217c0-1.169-.36-2.15-1.077-2.94-.718-.79-1.605-1.186-2.666-1.186zm21.174.168c-1.149 0-2.11.389-2.884 1.163-.78.78-1.172 1.745-1.172 2.894v15.942c0 1.15.388 2.11 1.162 2.885.78.78 1.745 1.17 2.894 1.17h7.649c1.149 0 2.11-.386 2.885-1.16.78-.78 1.17-1.746 1.17-2.895v-15.942c0-1.15-.387-2.11-1.161-2.885-.78-.78-1.745-1.172-2.894-1.172zm.552 4.516h6.542v14.931h-6.542z"></path>\n    </symbol>\n    <symbol viewBox="0 0 512 512" id="vjs-icon-audio-description">\n      <g fill-rule="evenodd"><path d="M227.29 381.351V162.993c50.38-1.017 89.108-3.028 117.631 17.126 27.374 19.342 48.734 56.965 44.89 105.325-4.067 51.155-41.335 94.139-89.776 98.475-24.085 2.155-71.972 0-71.972 0s-.84-1.352-.773-2.568m48.755-54.804c31.43 1.26 53.208-16.633 56.495-45.386 4.403-38.51-21.188-63.552-58.041-60.796v103.612c-.036 1.466.575 2.22 1.546 2.57"></path><path d="M383.78 381.328c13.336 3.71 17.387-11.06 23.215-21.408 12.722-22.571 22.294-51.594 22.445-84.774.221-47.594-18.343-82.517-35.6-106.182h-8.51c-.587 3.874 2.226 7.315 3.865 10.276 13.166 23.762 25.367 56.553 25.54 94.194.2 43.176-14.162 79.278-30.955 107.894"></path><path d="M425.154 381.328c13.336 3.71 17.384-11.061 23.215-21.408 12.721-22.571 22.291-51.594 22.445-84.774.221-47.594-18.343-82.517-35.6-106.182h-8.511c-.586 3.874 2.226 7.315 3.866 10.276 13.166 23.762 25.367 56.553 25.54 94.194.2 43.176-14.162 79.278-30.955 107.894"></path><path d="M466.26 381.328c13.337 3.71 17.385-11.061 23.216-21.408 12.722-22.571 22.292-51.594 22.445-84.774.221-47.594-18.343-82.517-35.6-106.182h-8.51c-.587 3.874 2.225 7.315 3.865 10.276 13.166 23.762 25.367 56.553 25.54 94.194.2 43.176-14.162 79.278-30.955 107.894M4.477 383.005H72.58l18.573-28.484 64.169-.135s.065 19.413.065 28.62h48.756V160.307h-58.816c-5.653 9.537-140.85 222.697-140.85 222.697zm152.667-145.282v71.158l-40.453-.27 40.453-70.888z"></path></g>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-next-item">\n      <path d="M12 36l17-12-17-12v24zm20-24v24h4V12h-4z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-previous-item">\n      <path d="M12 12h4v24h-4zm7 12l17 12V12z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-shuffle">\n      <path d="M21.17 18.34L10.83 8 8 10.83l10.34 10.34 2.83-2.83zM29 8l4.09 4.09L8 37.17 10.83 40l25.09-25.09L40 19V8H29zm.66 18.83l-2.83 2.83 6.26 6.26L29 40h11V29l-4.09 4.09-6.25-6.26z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-cast">\n      <path d="M42 6H6c-2.21 0-4 1.79-4 4v6h4v-6h36v28H28v4h14c2.21 0 4-1.79 4-4V10c0-2.21-1.79-4-4-4zM2 36v6h6c0-3.31-2.69-6-6-6zm0-8v4c5.52 0 10 4.48 10 10h4c0-7.73-6.27-14-14-14zm0-8v4c9.94 0 18 8.06 18 18h4c0-12.15-9.85-22-22-22z"></path>\n    </symbol>\n    <symbol viewBox="0 0 48 48" id="vjs-icon-picture-in-picture-enter">\n      <path d="M38 22H22v11.99h16V22zm8 16V9.96C46 7.76 44.2 6 42 6H6C3.8 6 2 7.76 2 9.96V38c0 2.2 1.8 4 4 4h36c2.2 0 4-1.8 4-4zm-4 .04H6V9.94h36v28.1z"></path>\n    </symbol>\n    <symbol viewBox="0 0 22 18" id="vjs-icon-picture-in-picture-exit">\n      <path d="M18 4H4v10h14V4zm4 12V1.98C22 .88 21.1 0 20 0H2C.9 0 0 .88 0 1.98V16c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2zm-2 .02H2V1.97h18v14.05z"></path>\n      <path fill="none" d="M-1-3h24v24H-1z"></path>\n    </symbol>\n    <symbol viewBox="0 0 1792 1792" id="vjs-icon-facebook">\n      <path d="M1343 12v264h-157q-86 0-116 36t-30 108v189h293l-39 296h-254v759H734V905H479V609h255V391q0-186 104-288.5T1115 0q147 0 228 12z"></path>\n    </symbol>\n    <symbol viewBox="0 0 1792 1792" id="vjs-icon-linkedin">\n      <path d="M477 625v991H147V625h330zm21-306q1 73-50.5 122T312 490h-2q-82 0-132-49t-50-122q0-74 51.5-122.5T314 148t133 48.5T498 319zm1166 729v568h-329v-530q0-105-40.5-164.5T1168 862q-63 0-105.5 34.5T999 982q-11 30-11 81v553H659q2-399 2-647t-1-296l-1-48h329v144h-2q20-32 41-56t56.5-52 87-43.5T1285 602q171 0 275 113.5t104 332.5z"></path>\n    </symbol>\n    <symbol viewBox="0 0 1200 1227" id="vjs-icon-twitter">\n      <path d="M714.163 519.284L1160.89 0H1055.03L667.137 450.887L357.328 0H0L468.492 681.821L0 1226.37H105.866L515.491 750.218L842.672 1226.37H1200L714.137 519.284H714.163ZM569.165 687.828L521.697 619.934L144.011 79.6944H306.615L611.412 515.685L658.88 583.579L1055.08 1150.3H892.476L569.165 687.854V687.828Z"/>\n    </symbol>\n    <symbol viewBox="0 0 1792 1792" id="vjs-icon-tumblr">\n      <path d="M1328 1329l80 237q-23 35-111 66t-177 32q-104 2-190.5-26T787 1564t-95-106-55.5-120-16.5-118V676H452V461q72-26 129-69.5t91-90 58-102 34-99T779 12q1-5 4.5-8.5T791 0h244v424h333v252h-334v518q0 30 6.5 56t22.5 52.5 49.5 41.5 81.5 14q78-2 134-29z"></path>\n    </symbol>\n    <symbol viewBox="0 0 1792 1792" id="vjs-icon-pinterest">\n      <path d="M1664 896q0 209-103 385.5T1281.5 1561 896 1664q-111 0-218-32 59-93 78-164 9-34 54-211 20 39 73 67.5t114 28.5q121 0 216-68.5t147-188.5 52-270q0-114-59.5-214T1180 449t-255-63q-105 0-196 29t-154.5 77-109 110.5-67 129.5T377 866q0 104 40 183t117 111q30 12 38-20 2-7 8-31t8-30q6-23-11-43-51-61-51-151 0-151 104.5-259.5T904 517q151 0 235.5 82t84.5 213q0 170-68.5 289T980 1220q-61 0-98-43.5T859 1072q8-35 26.5-93.5t30-103T927 800q0-50-27-83t-77-33q-62 0-105 57t-43 142q0 73 25 122l-99 418q-17 70-13 177-206-91-333-281T128 896q0-209 103-385.5T510.5 231 896 128t385.5 103T1561 510.5 1664 896z"></path>\n    </symbol>\n  </defs>\n</svg>';
const backKeyCode = IS_TIZEN ? 10009 : IS_WEBOS ? 461 : 8;
const SpatialNavKeyCodes = {
  codes: {
    play: 415,
    pause: 19,
    ff: 417,
    rw: 412,
    back: backKeyCode
  },
  names: {
    415: "play",
    19: "pause",
    417: "ff",
    412: "rw",
    [backKeyCode]: "back"
  },
  isEventKey(event, keyName) {
    keyName = keyName.toLowerCase();
    if (this.names[event.keyCode] && this.names[event.keyCode] === keyName) {
      return true;
    }
    return false;
  },
  getEventName(event) {
    if (this.names[event.keyCode]) {
      return this.names[event.keyCode];
    } else if (this.codes[event.code]) {
      const code = this.codes[event.code];
      return this.names[code];
    }
    return null;
  }
};
const STEP_SECONDS = 5;
class SpatialNavigation extends EventTarget$2 {
  constructor(player) {
    super();
    this.player_ = player;
    this.focusableComponents = [];
    this.isListening_ = false;
    this.isPaused_ = false;
    this.onKeyDown_ = this.onKeyDown_.bind(this);
    this.lastFocusedComponent_ = null;
  }
  start() {
    if (this.isListening_) {
      return;
    }
    this.player_.on("keydown", this.onKeyDown_);
    this.player_.on("modalKeydown", this.onKeyDown_);
    this.player_.on("loadedmetadata", () => {
      this.focus(this.updateFocusableComponents()[0]);
    });
    this.player_.on("modalclose", () => {
      this.refocusComponent();
    });
    this.player_.on("focusin", this.handlePlayerFocus_.bind(this));
    this.player_.on("focusout", this.handlePlayerBlur_.bind(this));
    this.isListening_ = true;
    if (this.player_.errorDisplay) {
      this.player_.errorDisplay.on("aftermodalfill", () => {
        this.updateFocusableComponents();
        if (this.focusableComponents.length) {
          if (this.focusableComponents.length > 1) {
            this.focusableComponents[1].focus();
          } else {
            this.focusableComponents[0].focus();
          }
        }
      });
    }
  }
  stop() {
    this.player_.off("keydown", this.onKeyDown_);
    this.isListening_ = false;
  }
  onKeyDown_(event) {
    const actualEvent = event.originalEvent ? event.originalEvent : event;
    if (["ArrowLeft", "ArrowRight", "ArrowUp", "ArrowDown"].includes(actualEvent.key)) {
      if (this.isPaused_) {
        return;
      }
      actualEvent.preventDefault();
      const direction = actualEvent.key.substring(5).toLowerCase();
      this.move(direction);
    } else if (SpatialNavKeyCodes.isEventKey(actualEvent, "play") || SpatialNavKeyCodes.isEventKey(actualEvent, "pause") || SpatialNavKeyCodes.isEventKey(actualEvent, "ff") || SpatialNavKeyCodes.isEventKey(actualEvent, "rw")) {
      actualEvent.preventDefault();
      const action = SpatialNavKeyCodes.getEventName(actualEvent);
      this.performMediaAction_(action);
    } else if (SpatialNavKeyCodes.isEventKey(actualEvent, "Back") && event.target && typeof event.target.closeable === "function" && event.target.closeable()) {
      actualEvent.preventDefault();
      event.target.close();
    }
  }
  performMediaAction_(key) {
    if (this.player_) {
      switch (key) {
        case "play":
          if (this.player_.paused()) {
            this.player_.play();
          }
          break;
        case "pause":
          if (!this.player_.paused()) {
            this.player_.pause();
          }
          break;
        case "ff":
          this.userSeek_(this.player_.currentTime() + STEP_SECONDS);
          break;
        case "rw":
          this.userSeek_(this.player_.currentTime() - STEP_SECONDS);
          break;
      }
    }
  }
  userSeek_(ct) {
    if (this.player_.liveTracker && this.player_.liveTracker.isLive()) {
      this.player_.liveTracker.nextSeekedFromUser();
    }
    this.player_.currentTime(ct);
  }
  pause() {
    this.isPaused_ = true;
  }
  resume() {
    this.isPaused_ = false;
  }
  handlePlayerBlur_(event) {
    const nextFocusedElement = event.relatedTarget;
    let isChildrenOfPlayer = null;
    const currentComponent = this.getCurrentComponent(event.target);
    if (nextFocusedElement) {
      isChildrenOfPlayer = Boolean(nextFocusedElement.closest(".video-js"));
      if (nextFocusedElement.classList.contains("vjs-text-track-settings") && !this.isPaused_) {
        this.searchForTrackSelect_();
      }
    }
    if (!event.currentTarget.contains(event.relatedTarget) && !isChildrenOfPlayer || !nextFocusedElement) {
      if (currentComponent && currentComponent.name() === "CloseButton") {
        this.refocusComponent();
      } else {
        this.pause();
        if (currentComponent && currentComponent.el()) {
          this.lastFocusedComponent_ = currentComponent;
        }
      }
    }
  }
  handlePlayerFocus_() {
    if (this.getCurrentComponent() && this.getCurrentComponent().getIsFocusable()) {
      this.resume();
    }
  }
  updateFocusableComponents() {
    const player = this.player_;
    const focusableComponents = [];
    function searchForChildrenCandidates(componentsArray) {
      for (const i of componentsArray) {
        if (i.hasOwnProperty("el_") && i.getIsFocusable() && i.getIsAvailableToBeFocused(i.el())) {
          focusableComponents.push(i);
        }
        if (i.hasOwnProperty("children_") && i.children_.length > 0) {
          searchForChildrenCandidates(i.children_);
        }
      }
    }
    player.children_.forEach((value) => {
      if (value.hasOwnProperty("el_")) {
        if (value.getIsFocusable && value.getIsAvailableToBeFocused && value.getIsFocusable() && value.getIsAvailableToBeFocused(value.el())) {
          focusableComponents.push(value);
          return;
        } else if (value.hasOwnProperty("children_") && value.children_.length > 0) {
          searchForChildrenCandidates(value.children_);
        } else if (value.hasOwnProperty("items") && value.items.length > 0) {
          searchForChildrenCandidates(value.items);
        } else if (this.findSuitableDOMChild(value)) {
          focusableComponents.push(value);
        }
      }
      if (value.name_ === "ErrorDisplay" && value.opened_) {
        const buttonContainer = value.el_.querySelector(".vjs-errors-ok-button-container");
        if (buttonContainer) {
          const modalButtons = buttonContainer.querySelectorAll("button");
          modalButtons.forEach((element, index) => {
            focusableComponents.push({
              name: () => {
                return "ModalButton" + (index + 1);
              },
              el: () => element,
              getPositions: () => {
                const rect = element.getBoundingClientRect();
                const boundingClientRect = {
                  x: rect.x,
                  y: rect.y,
                  width: rect.width,
                  height: rect.height,
                  top: rect.top,
                  right: rect.right,
                  bottom: rect.bottom,
                  left: rect.left
                };
                const center = {
                  x: rect.left + rect.width / 2,
                  y: rect.top + rect.height / 2,
                  width: 0,
                  height: 0,
                  top: rect.top + rect.height / 2,
                  right: rect.left + rect.width / 2,
                  bottom: rect.top + rect.height / 2,
                  left: rect.left + rect.width / 2
                };
                return {
                  boundingClientRect,
                  center
                };
              },
              getIsAvailableToBeFocused: () => true,
              getIsFocusable: (el) => true,
              focus: () => element.focus()
            });
          });
        }
      }
    });
    this.focusableComponents = focusableComponents;
    return this.focusableComponents;
  }
  findSuitableDOMChild(component) {
    function searchForSuitableChild(node) {
      if (component.getIsFocusable(node) && component.getIsAvailableToBeFocused(node)) {
        return node;
      }
      for (let i = 0; i < node.children.length; i++) {
        const child = node.children[i];
        const suitableChild = searchForSuitableChild(child);
        if (suitableChild) {
          return suitableChild;
        }
      }
      return null;
    }
    if (component.el()) {
      return searchForSuitableChild(component.el());
    }
    return null;
  }
  getCurrentComponent(target) {
    this.updateFocusableComponents();
    const curComp = target || document.activeElement;
    if (this.focusableComponents.length) {
      for (const i of this.focusableComponents) {
        if (i.el() === curComp) {
          return i;
        }
      }
    }
  }
  add(component) {
    const focusableComponents = [...this.focusableComponents];
    if (component.hasOwnProperty("el_") && component.getIsFocusable() && component.getIsAvailableToBeFocused(component.el())) {
      focusableComponents.push(component);
    }
    this.focusableComponents = focusableComponents;
    this.trigger({
      type: "focusableComponentsChanged",
      focusableComponents: this.focusableComponents
    });
  }
  remove(component) {
    for (let i = 0; i < this.focusableComponents.length; i++) {
      if (this.focusableComponents[i].name() === component.name()) {
        this.focusableComponents.splice(i, 1);
        this.trigger({
          type: "focusableComponentsChanged",
          focusableComponents: this.focusableComponents
        });
        return;
      }
    }
  }
  clear() {
    if (this.focusableComponents.length > 0) {
      this.focusableComponents = [];
      this.trigger({
        type: "focusableComponentsChanged",
        focusableComponents: this.focusableComponents
      });
    }
  }
  move(direction) {
    const currentFocusedComponent = this.getCurrentComponent();
    if (!currentFocusedComponent) {
      return;
    }
    const currentPositions = currentFocusedComponent.getPositions();
    const candidates = this.focusableComponents.filter((component) => component !== currentFocusedComponent && this.isInDirection_(currentPositions.boundingClientRect, component.getPositions().boundingClientRect, direction));
    const bestCandidate = this.findBestCandidate_(currentPositions.center, candidates, direction);
    if (bestCandidate) {
      this.focus(bestCandidate);
    } else {
      this.trigger({
        type: "endOfFocusableComponents",
        direction,
        focusedComponent: currentFocusedComponent
      });
    }
  }
  findBestCandidate_(currentCenter, candidates, direction) {
    let minDistance = Infinity;
    let bestCandidate = null;
    for (const candidate of candidates) {
      const candidateCenter = candidate.getPositions().center;
      const distance = this.calculateDistance_(currentCenter, candidateCenter, direction);
      if (distance < minDistance) {
        minDistance = distance;
        bestCandidate = candidate;
      }
    }
    return bestCandidate;
  }
  isInDirection_(srcRect, targetRect, direction) {
    switch (direction) {
      case "right":
        return targetRect.left >= srcRect.right;
      case "left":
        return targetRect.right <= srcRect.left;
      case "down":
        return targetRect.top >= srcRect.bottom;
      case "up":
        return targetRect.bottom <= srcRect.top;
      default:
        return false;
    }
  }
  refocusComponent() {
    if (this.lastFocusedComponent_) {
      if (!this.player_.userActive()) {
        this.player_.userActive(true);
      }
      this.updateFocusableComponents();
      for (let i = 0; i < this.focusableComponents.length; i++) {
        if (this.focusableComponents[i].name() === this.lastFocusedComponent_.name()) {
          this.focus(this.focusableComponents[i]);
          return;
        }
      }
    } else {
      this.focus(this.updateFocusableComponents()[0]);
    }
  }
  focus(component) {
    if (typeof component !== "object") {
      return;
    }
    if (component.getIsAvailableToBeFocused(component.el())) {
      component.focus();
    } else if (this.findSuitableDOMChild(component)) {
      this.findSuitableDOMChild(component).focus();
    }
  }
  calculateDistance_(center1, center2, direction) {
    const dx = Math.abs(center1.x - center2.x);
    const dy = Math.abs(center1.y - center2.y);
    let distance;
    switch (direction) {
      case "right":
      case "left":
        distance = dx + dy * 100;
        break;
      case "up":
        distance = dy * 2 + dx * 0.5;
        break;
      case "down":
        distance = dy * 5 + dx;
        break;
      default:
        distance = dx + dy;
    }
    return distance;
  }
  searchForTrackSelect_() {
    const spatialNavigation = this;
    for (const component of spatialNavigation.updateFocusableComponents()) {
      if (component.constructor.name === "TextTrackSelect") {
        spatialNavigation.focus(component);
        break;
      }
    }
  }
}
class MediaLoader extends Component$1 {
  constructor(player, options, ready) {
    const options_ = merge$1({
      createEl: false
    }, options);
    super(player, options_, ready);
    if (!options.playerOptions.sources || options.playerOptions.sources.length === 0) {
      for (let i = 0, j = options.playerOptions.techOrder; i < j.length; i++) {
        const techName = toTitleCase$1(j[i]);
        let tech = Tech.getTech(techName);
        if (!techName) {
          tech = Component$1.getComponent(techName);
        }
        if (tech && tech.isSupported()) {
          player.loadTech_(techName);
          break;
        }
      }
    } else {
      player.src(options.playerOptions.sources);
    }
  }
}
Component$1.registerComponent("MediaLoader", MediaLoader);
class ClickableComponent extends Component$1 {
  constructor(player, options) {
    super(player, options);
    if (this.options_.controlText) {
      this.controlText(this.options_.controlText);
    }
    this.handleMouseOver_ = (e) => this.handleMouseOver(e);
    this.handleMouseOut_ = (e) => this.handleMouseOut(e);
    this.handleClick_ = (e) => this.handleClick(e);
    this.handleKeyDown_ = (e) => this.handleKeyDown(e);
    this.emitTapEvents();
    this.enable();
  }
  createEl(tag = "div", props = {}, attributes = {}) {
    props = Object.assign({
      className: this.buildCSSClass(),
      tabIndex: 0
    }, props);
    if (tag === "button") {
      log$1.error(`Creating a ClickableComponent with an HTML element of ${tag} is not supported; use a Button instead.`);
    }
    attributes = Object.assign({
      role: "button"
    }, attributes);
    this.tabIndex_ = props.tabIndex;
    const el = createEl(tag, props, attributes);
    if (!this.player_.options_.experimentalSvgIcons) {
      el.appendChild(createEl("span", {
        className: "vjs-icon-placeholder"
      }, {
        "aria-hidden": true
      }));
    }
    this.createControlTextEl(el);
    return el;
  }
  dispose() {
    this.controlTextEl_ = null;
    super.dispose();
  }
  createControlTextEl(el) {
    this.controlTextEl_ = createEl("span", {
      className: "vjs-control-text"
    }, {
      "aria-live": "polite"
    });
    if (el) {
      el.appendChild(this.controlTextEl_);
    }
    this.controlText(this.controlText_, el);
    return this.controlTextEl_;
  }
  controlText(text, el = this.el()) {
    if (text === void 0) {
      return this.controlText_ || "Need Text";
    }
    const localizedText = this.localize(text);
    this.controlText_ = text;
    textContent(this.controlTextEl_, localizedText);
    if (!this.nonIconControl && !this.player_.options_.noUITitleAttributes) {
      el.setAttribute("title", localizedText);
    }
  }
  buildCSSClass() {
    return `vjs-control vjs-button ${super.buildCSSClass()}`;
  }
  enable() {
    if (!this.enabled_) {
      this.enabled_ = true;
      this.removeClass("vjs-disabled");
      this.el_.setAttribute("aria-disabled", "false");
      if (typeof this.tabIndex_ !== "undefined") {
        this.el_.setAttribute("tabIndex", this.tabIndex_);
      }
      this.on(["tap", "click"], this.handleClick_);
      this.on("keydown", this.handleKeyDown_);
    }
  }
  disable() {
    this.enabled_ = false;
    this.addClass("vjs-disabled");
    this.el_.setAttribute("aria-disabled", "true");
    if (typeof this.tabIndex_ !== "undefined") {
      this.el_.removeAttribute("tabIndex");
    }
    this.off("mouseover", this.handleMouseOver_);
    this.off("mouseout", this.handleMouseOut_);
    this.off(["tap", "click"], this.handleClick_);
    this.off("keydown", this.handleKeyDown_);
  }
  handleLanguagechange() {
    this.controlText(this.controlText_);
  }
  handleClick(event) {
    if (this.options_.clickHandler) {
      this.options_.clickHandler.call(this, arguments);
    }
  }
  handleKeyDown(event) {
    if (event.key === " " || event.key === "Enter") {
      event.preventDefault();
      event.stopPropagation();
      this.trigger("click");
    } else {
      super.handleKeyDown(event);
    }
  }
}
Component$1.registerComponent("ClickableComponent", ClickableComponent);
class PosterImage extends ClickableComponent {
  constructor(player, options) {
    super(player, options);
    this.update();
    this.update_ = (e) => this.update(e);
    player.on("posterchange", this.update_);
  }
  dispose() {
    this.player().off("posterchange", this.update_);
    super.dispose();
  }
  createEl() {
    return createEl("div", {
      className: "vjs-poster"
    });
  }
  crossOrigin(value) {
    if (typeof value === "undefined") {
      if (this.$("img")) {
        return this.$("img").crossOrigin;
      } else if (this.player_.tech_ && this.player_.tech_.isReady_) {
        return this.player_.crossOrigin();
      }
      return this.player_.options_.crossOrigin || this.player_.options_.crossorigin || null;
    }
    if (value !== null && value !== "anonymous" && value !== "use-credentials") {
      this.player_.log.warn(`crossOrigin must be null,  "anonymous" or "use-credentials", given "${value}"`);
      return;
    }
    if (this.$("img")) {
      this.$("img").crossOrigin = value;
    }
    return;
  }
  update(event) {
    const url = this.player().poster();
    this.setSrc(url);
    if (url) {
      this.show();
    } else {
      this.hide();
    }
  }
  setSrc(url) {
    if (!url) {
      this.el_.textContent = "";
      return;
    }
    if (!this.$("img")) {
      this.el_.appendChild(createEl("picture", {
        className: "vjs-poster",
        tabIndex: -1
      }, {}, createEl("img", {
        loading: "lazy",
        crossOrigin: this.crossOrigin()
      }, {
        alt: ""
      })));
    }
    this.$("img").src = url;
  }
  handleClick(event) {
    if (!this.player_.controls()) {
      return;
    }
    if (this.player_.tech(true)) {
      this.player_.tech(true).focus();
    }
    if (this.player_.paused()) {
      silencePromise(this.player_.play());
    } else {
      this.player_.pause();
    }
  }
}
PosterImage.prototype.crossorigin = PosterImage.prototype.crossOrigin;
Component$1.registerComponent("PosterImage", PosterImage);
const darkGray = "#222";
const lightGray = "#ccc";
const fontMap = {
  monospace: "monospace",
  sansSerif: "sans-serif",
  serif: "serif",
  monospaceSansSerif: '"Andale Mono", "Lucida Console", monospace',
  monospaceSerif: '"Courier New", monospace',
  proportionalSansSerif: "sans-serif",
  proportionalSerif: "serif",
  casual: '"Comic Sans MS", Impact, fantasy',
  script: '"Monotype Corsiva", cursive',
  smallcaps: '"Andale Mono", "Lucida Console", monospace, sans-serif'
};
function constructColor(color, opacity) {
  let hex;
  if (color.length === 4) {
    hex = color[1] + color[1] + color[2] + color[2] + color[3] + color[3];
  } else if (color.length === 7) {
    hex = color.slice(1);
  } else {
    throw new Error("Invalid color code provided, " + color + "; must be formatted as e.g. #f0e or #f604e2.");
  }
  return "rgba(" + parseInt(hex.slice(0, 2), 16) + "," + parseInt(hex.slice(2, 4), 16) + "," + parseInt(hex.slice(4, 6), 16) + "," + opacity + ")";
}
function tryUpdateStyle(el, style, rule) {
  try {
    el.style[style] = rule;
  } catch (e) {
    return;
  }
}
function getCSSPositionValue(position) {
  return position ? `${position}px` : "";
}
class TextTrackDisplay extends Component$1 {
  constructor(player, options, ready) {
    super(player, options, ready);
    const updateDisplayTextHandler = (e) => this.updateDisplay(e);
    const updateDisplayHandler = (e) => {
      this.updateDisplayOverlay();
      this.updateDisplay(e);
    };
    player.on("loadstart", (e) => this.toggleDisplay(e));
    player.on("useractive", updateDisplayTextHandler);
    player.on("userinactive", updateDisplayTextHandler);
    player.on("texttrackchange", updateDisplayTextHandler);
    player.on("loadedmetadata", (e) => {
      this.updateDisplayOverlay();
      this.preselectTrack(e);
    });
    player.ready(bind_(this, function() {
      if (player.tech_ && player.tech_.featuresNativeTextTracks) {
        this.hide();
        return;
      }
      player.on("fullscreenchange", updateDisplayHandler);
      player.on("playerresize", updateDisplayHandler);
      const screenOrientation = window_1.screen.orientation || window_1;
      const changeOrientationEvent = window_1.screen.orientation ? "change" : "orientationchange";
      screenOrientation.addEventListener(changeOrientationEvent, updateDisplayHandler);
      player.on("dispose", () => screenOrientation.removeEventListener(changeOrientationEvent, updateDisplayHandler));
      const tracks = this.options_.playerOptions.tracks || [];
      for (let i = 0; i < tracks.length; i++) {
        this.player_.addRemoteTextTrack(tracks[i], true);
      }
      this.preselectTrack();
    }));
  }
  preselectTrack() {
    const modes = {
      captions: 1,
      subtitles: 1
    };
    const trackList = this.player_.textTracks();
    const userPref = this.player_.cache_.selectedLanguage;
    let firstDesc;
    let firstCaptions;
    let preferredTrack;
    for (let i = 0; i < trackList.length; i++) {
      const track = trackList[i];
      if (userPref && userPref.enabled && userPref.language && userPref.language === track.language && track.kind in modes) {
        if (track.kind === userPref.kind) {
          preferredTrack = track;
        } else if (!preferredTrack) {
          preferredTrack = track;
        }
      } else if (userPref && !userPref.enabled) {
        preferredTrack = null;
        firstDesc = null;
        firstCaptions = null;
      } else if (track.default) {
        if (track.kind === "descriptions" && !firstDesc) {
          firstDesc = track;
        } else if (track.kind in modes && !firstCaptions) {
          firstCaptions = track;
        }
      }
    }
    if (preferredTrack) {
      preferredTrack.mode = "showing";
    } else if (firstCaptions) {
      firstCaptions.mode = "showing";
    } else if (firstDesc) {
      firstDesc.mode = "showing";
    }
  }
  toggleDisplay() {
    if (this.player_.tech_ && this.player_.tech_.featuresNativeTextTracks) {
      this.hide();
    } else {
      this.show();
    }
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-text-track-display"
    }, {
      "translate": "yes",
      "aria-live": "off",
      "aria-atomic": "true"
    });
  }
  clearDisplay() {
    if (typeof window_1.WebVTT === "function") {
      window_1.WebVTT.processCues(window_1, [], this.el_);
    }
  }
  updateDisplay() {
    const tracks = this.player_.textTracks();
    const allowMultipleShowingTracks = this.options_.allowMultipleShowingTracks;
    this.clearDisplay();
    if (allowMultipleShowingTracks) {
      const showingTracks = [];
      for (let i2 = 0; i2 < tracks.length; ++i2) {
        const track = tracks[i2];
        if (track.mode !== "showing") {
          continue;
        }
        showingTracks.push(track);
      }
      this.updateForTrack(showingTracks);
      return;
    }
    let descriptionsTrack = null;
    let captionsSubtitlesTrack = null;
    let i = tracks.length;
    while (i--) {
      const track = tracks[i];
      if (track.mode === "showing") {
        if (track.kind === "descriptions") {
          descriptionsTrack = track;
        } else {
          captionsSubtitlesTrack = track;
        }
      }
    }
    if (captionsSubtitlesTrack) {
      if (this.getAttribute("aria-live") !== "off") {
        this.setAttribute("aria-live", "off");
      }
      this.updateForTrack(captionsSubtitlesTrack);
    } else if (descriptionsTrack) {
      if (this.getAttribute("aria-live") !== "assertive") {
        this.setAttribute("aria-live", "assertive");
      }
      this.updateForTrack(descriptionsTrack);
    }
    if (!window_1.CSS.supports("inset", "10px")) {
      const textTrackDisplay = this.el_;
      const vjsTextTrackCues = textTrackDisplay.querySelectorAll(".vjs-text-track-cue");
      const controlBarHeight = this.player_.controlBar.el_.getBoundingClientRect().height;
      const playerHeight = this.player_.el_.getBoundingClientRect().height;
      textTrackDisplay.style = "";
      tryUpdateStyle(textTrackDisplay, "position", "relative");
      tryUpdateStyle(textTrackDisplay, "height", playerHeight - controlBarHeight + "px");
      tryUpdateStyle(textTrackDisplay, "top", "unset");
      if (IS_SMART_TV) {
        tryUpdateStyle(textTrackDisplay, "bottom", playerHeight + "px");
      } else {
        tryUpdateStyle(textTrackDisplay, "bottom", "0px");
      }
      if (vjsTextTrackCues.length > 0) {
        vjsTextTrackCues.forEach((vjsTextTrackCue) => {
          if (vjsTextTrackCue.style.inset) {
            const insetStyles = vjsTextTrackCue.style.inset.split(" ");
            if (insetStyles.length === 3) {
              Object.assign(vjsTextTrackCue.style, {
                top: insetStyles[0],
                right: insetStyles[1],
                bottom: insetStyles[2],
                left: "unset"
              });
            }
          }
        });
      }
    }
  }
  updateDisplayOverlay() {
    if (!this.player_.videoHeight() || !window_1.CSS.supports("inset-inline: 10px")) {
      return;
    }
    const playerWidth = this.player_.currentWidth();
    const playerHeight = this.player_.currentHeight();
    const playerAspectRatio = playerWidth / playerHeight;
    const videoAspectRatio = this.player_.videoWidth() / this.player_.videoHeight();
    let insetInlineMatch = 0;
    let insetBlockMatch = 0;
    if (Math.abs(playerAspectRatio - videoAspectRatio) > 0.1) {
      if (playerAspectRatio > videoAspectRatio) {
        insetInlineMatch = Math.round((playerWidth - playerHeight * videoAspectRatio) / 2);
      } else {
        insetBlockMatch = Math.round((playerHeight - playerWidth / videoAspectRatio) / 2);
      }
    }
    tryUpdateStyle(this.el_, "insetInline", getCSSPositionValue(insetInlineMatch));
    tryUpdateStyle(this.el_, "insetBlock", getCSSPositionValue(insetBlockMatch));
  }
  updateDisplayState(track) {
    const overrides = this.player_.textTrackSettings.getValues();
    const cues = track.activeCues;
    let i = cues.length;
    while (i--) {
      const cue = cues[i];
      if (!cue) {
        continue;
      }
      const cueDiv = cue.displayState;
      if (overrides.color) {
        cueDiv.firstChild.style.color = overrides.color;
      }
      if (overrides.textOpacity) {
        tryUpdateStyle(cueDiv.firstChild, "color", constructColor(overrides.color || "#fff", overrides.textOpacity));
      }
      if (overrides.backgroundColor) {
        cueDiv.firstChild.style.backgroundColor = overrides.backgroundColor;
      }
      if (overrides.backgroundOpacity) {
        tryUpdateStyle(cueDiv.firstChild, "backgroundColor", constructColor(overrides.backgroundColor || "#000", overrides.backgroundOpacity));
      }
      if (overrides.windowColor) {
        if (overrides.windowOpacity) {
          tryUpdateStyle(cueDiv, "backgroundColor", constructColor(overrides.windowColor, overrides.windowOpacity));
        } else {
          cueDiv.style.backgroundColor = overrides.windowColor;
        }
      }
      if (overrides.edgeStyle) {
        if (overrides.edgeStyle === "dropshadow") {
          cueDiv.firstChild.style.textShadow = `2px 2px 3px ${darkGray}, 2px 2px 4px ${darkGray}, 2px 2px 5px ${darkGray}`;
        } else if (overrides.edgeStyle === "raised") {
          cueDiv.firstChild.style.textShadow = `1px 1px ${darkGray}, 2px 2px ${darkGray}, 3px 3px ${darkGray}`;
        } else if (overrides.edgeStyle === "depressed") {
          cueDiv.firstChild.style.textShadow = `1px 1px ${lightGray}, 0 1px ${lightGray}, -1px -1px ${darkGray}, 0 -1px ${darkGray}`;
        } else if (overrides.edgeStyle === "uniform") {
          cueDiv.firstChild.style.textShadow = `0 0 4px ${darkGray}, 0 0 4px ${darkGray}, 0 0 4px ${darkGray}, 0 0 4px ${darkGray}`;
        }
      }
      if (overrides.fontPercent && overrides.fontPercent !== 1) {
        const fontSize = window_1.parseFloat(cueDiv.style.fontSize);
        cueDiv.style.fontSize = fontSize * overrides.fontPercent + "px";
        cueDiv.style.height = "auto";
        cueDiv.style.top = "auto";
      }
      if (overrides.fontFamily && overrides.fontFamily !== "default") {
        if (overrides.fontFamily === "small-caps") {
          cueDiv.firstChild.style.fontVariant = "small-caps";
        } else {
          cueDiv.firstChild.style.fontFamily = fontMap[overrides.fontFamily];
        }
      }
    }
  }
  updateForTrack(tracks) {
    if (!Array.isArray(tracks)) {
      tracks = [tracks];
    }
    if (typeof window_1.WebVTT !== "function" || tracks.every((track) => {
      return !track.activeCues;
    })) {
      return;
    }
    const cues = [];
    for (let i = 0; i < tracks.length; ++i) {
      const track = tracks[i];
      for (let j = 0; j < track.activeCues.length; ++j) {
        cues.push(track.activeCues[j]);
      }
    }
    window_1.WebVTT.processCues(window_1, cues, this.el_);
    for (let i = 0; i < tracks.length; ++i) {
      const track = tracks[i];
      for (let j = 0; j < track.activeCues.length; ++j) {
        const cueEl = track.activeCues[j].displayState;
        addClass(cueEl, "vjs-text-track-cue", "vjs-text-track-cue-" + (track.language ? track.language : i));
        if (track.language) {
          setAttribute(cueEl, "lang", track.language);
        }
      }
      if (this.player_.textTrackSettings) {
        this.updateDisplayState(track);
      }
    }
  }
}
Component$1.registerComponent("TextTrackDisplay", TextTrackDisplay);
class LoadingSpinner extends Component$1 {
  createEl() {
    const isAudio = this.player_.isAudio();
    const playerType = this.localize(isAudio ? "Audio Player" : "Video Player");
    const controlText = createEl("span", {
      className: "vjs-control-text",
      textContent: this.localize("{1} is loading.", [playerType])
    });
    const el = super.createEl("div", {
      className: "vjs-loading-spinner",
      dir: "ltr"
    });
    el.appendChild(controlText);
    return el;
  }
  handleLanguagechange() {
    this.$(".vjs-control-text").textContent = this.localize("{1} is loading.", [this.player_.isAudio() ? "Audio Player" : "Video Player"]);
  }
}
Component$1.registerComponent("LoadingSpinner", LoadingSpinner);
class Button extends ClickableComponent {
  createEl(tag, props = {}, attributes = {}) {
    tag = "button";
    props = Object.assign({
      className: this.buildCSSClass()
    }, props);
    attributes = Object.assign({
      type: "button"
    }, attributes);
    const el = createEl(tag, props, attributes);
    if (!this.player_.options_.experimentalSvgIcons) {
      el.appendChild(createEl("span", {
        className: "vjs-icon-placeholder"
      }, {
        "aria-hidden": true
      }));
    }
    this.createControlTextEl(el);
    return el;
  }
  addChild(child, options = {}) {
    const className = this.constructor.name;
    log$1.warn(`Adding an actionable (user controllable) child to a Button (${className}) is not supported; use a ClickableComponent instead.`);
    return Component$1.prototype.addChild.call(this, child, options);
  }
  enable() {
    super.enable();
    this.el_.removeAttribute("disabled");
  }
  disable() {
    super.disable();
    this.el_.setAttribute("disabled", "disabled");
  }
  handleKeyDown(event) {
    if (event.key === " " || event.key === "Enter") {
      event.stopPropagation();
      return;
    }
    super.handleKeyDown(event);
  }
}
Component$1.registerComponent("Button", Button);
class BigPlayButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.mouseused_ = false;
    this.setIcon("play");
    this.on("mousedown", (e) => this.handleMouseDown(e));
  }
  buildCSSClass() {
    return "vjs-big-play-button";
  }
  handleClick(event) {
    const playPromise = this.player_.play();
    if (event.type === "tap" || this.mouseused_ && "clientX" in event && "clientY" in event) {
      silencePromise(playPromise);
      if (this.player_.tech(true)) {
        this.player_.tech(true).focus();
      }
      return;
    }
    const cb = this.player_.getChild("controlBar");
    const playToggle = cb && cb.getChild("playToggle");
    if (!playToggle) {
      this.player_.tech(true).focus();
      return;
    }
    const playFocus = () => playToggle.focus();
    if (isPromise(playPromise)) {
      playPromise.then(playFocus, () => {
      });
    } else {
      this.setTimeout(playFocus, 1);
    }
  }
  handleKeyDown(event) {
    this.mouseused_ = false;
    super.handleKeyDown(event);
  }
  handleMouseDown(event) {
    this.mouseused_ = true;
  }
}
BigPlayButton.prototype.controlText_ = "Play Video";
Component$1.registerComponent("BigPlayButton", BigPlayButton);
class CloseButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.setIcon("cancel");
    this.controlText(options && options.controlText || this.localize("Close"));
  }
  buildCSSClass() {
    return `vjs-close-button ${super.buildCSSClass()}`;
  }
  handleClick(event) {
    this.trigger({
      type: "close",
      bubbles: false
    });
  }
  handleKeyDown(event) {
    if (event.key === "Escape") {
      event.preventDefault();
      event.stopPropagation();
      this.trigger("click");
    } else {
      super.handleKeyDown(event);
    }
  }
}
Component$1.registerComponent("CloseButton", CloseButton);
class PlayToggle extends Button {
  constructor(player, options = {}) {
    super(player, options);
    options.replay = options.replay === void 0 || options.replay;
    this.setIcon("play");
    this.on(player, "play", (e) => this.handlePlay(e));
    this.on(player, "pause", (e) => this.handlePause(e));
    if (options.replay) {
      this.on(player, "ended", (e) => this.handleEnded(e));
    }
  }
  buildCSSClass() {
    return `vjs-play-control ${super.buildCSSClass()}`;
  }
  handleClick(event) {
    if (this.player_.paused()) {
      silencePromise(this.player_.play());
    } else {
      this.player_.pause();
    }
  }
  handleSeeked(event) {
    this.removeClass("vjs-ended");
    if (this.player_.paused()) {
      this.handlePause(event);
    } else {
      this.handlePlay(event);
    }
  }
  handlePlay(event) {
    this.removeClass("vjs-ended", "vjs-paused");
    this.addClass("vjs-playing");
    this.setIcon("pause");
    this.controlText("Pause");
  }
  handlePause(event) {
    this.removeClass("vjs-playing");
    this.addClass("vjs-paused");
    this.setIcon("play");
    this.controlText("Play");
  }
  handleEnded(event) {
    this.removeClass("vjs-playing");
    this.addClass("vjs-ended");
    this.setIcon("replay");
    this.controlText("Replay");
    this.one(this.player_, "seeked", (e) => this.handleSeeked(e));
  }
}
PlayToggle.prototype.controlText_ = "Play";
Component$1.registerComponent("PlayToggle", PlayToggle);
class TimeDisplay extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.on(player, ["timeupdate", "ended", "seeking"], (e) => this.update(e));
    this.updateTextNode_();
  }
  createEl() {
    const className = this.buildCSSClass();
    const el = super.createEl("div", {
      className: `${className} vjs-time-control vjs-control`
    });
    const span = createEl("span", {
      className: "vjs-control-text",
      textContent: `${this.localize(this.labelText_)}\xA0`
    }, {
      role: "presentation"
    });
    el.appendChild(span);
    this.contentEl_ = createEl("span", {
      className: `${className}-display`
    }, {
      role: "presentation"
    });
    el.appendChild(this.contentEl_);
    return el;
  }
  dispose() {
    this.contentEl_ = null;
    this.textNode_ = null;
    super.dispose();
  }
  update(event) {
    if (!this.player_.options_.enableSmoothSeeking && event.type === "seeking") {
      return;
    }
    this.updateContent(event);
  }
  updateTextNode_(time = 0) {
    time = formatTime(time);
    if (this.formattedTime_ === time) {
      return;
    }
    this.formattedTime_ = time;
    this.requestNamedAnimationFrame("TimeDisplay#updateTextNode_", () => {
      if (!this.contentEl_) {
        return;
      }
      let oldNode = this.textNode_;
      if (oldNode && this.contentEl_.firstChild !== oldNode) {
        oldNode = null;
        log$1.warn("TimeDisplay#updateTextnode_: Prevented replacement of text node element since it was no longer a child of this node. Appending a new node instead.");
      }
      this.textNode_ = document_1.createTextNode(this.formattedTime_);
      if (!this.textNode_) {
        return;
      }
      if (oldNode) {
        this.contentEl_.replaceChild(this.textNode_, oldNode);
      } else {
        this.contentEl_.appendChild(this.textNode_);
      }
    });
  }
  updateContent(event) {
  }
}
TimeDisplay.prototype.labelText_ = "Time";
TimeDisplay.prototype.controlText_ = "Time";
Component$1.registerComponent("TimeDisplay", TimeDisplay);
class CurrentTimeDisplay extends TimeDisplay {
  buildCSSClass() {
    return "vjs-current-time";
  }
  updateContent(event) {
    let time;
    if (this.player_.ended()) {
      time = this.player_.duration();
    } else if (event && event.target && typeof event.target.pendingSeekTime === "function") {
      time = event.target.pendingSeekTime();
    } else {
      time = this.player_.scrubbing() ? this.player_.getCache().currentTime : this.player_.currentTime();
    }
    this.updateTextNode_(time);
  }
}
CurrentTimeDisplay.prototype.labelText_ = "Current Time";
CurrentTimeDisplay.prototype.controlText_ = "Current Time";
Component$1.registerComponent("CurrentTimeDisplay", CurrentTimeDisplay);
class DurationDisplay extends TimeDisplay {
  constructor(player, options) {
    super(player, options);
    const updateContent = (e) => this.updateContent(e);
    this.on(player, "durationchange", updateContent);
    this.on(player, "loadstart", updateContent);
    this.on(player, "loadedmetadata", updateContent);
  }
  buildCSSClass() {
    return "vjs-duration";
  }
  updateContent(event) {
    const duration2 = this.player_.duration();
    this.updateTextNode_(duration2);
  }
}
DurationDisplay.prototype.labelText_ = "Duration";
DurationDisplay.prototype.controlText_ = "Duration";
Component$1.registerComponent("DurationDisplay", DurationDisplay);
class TimeDivider extends Component$1 {
  createEl() {
    const el = super.createEl("div", {
      className: "vjs-time-control vjs-time-divider"
    }, {
      "aria-hidden": true
    });
    const div = super.createEl("div");
    const span = super.createEl("span", {
      textContent: "/"
    });
    div.appendChild(span);
    el.appendChild(div);
    return el;
  }
}
Component$1.registerComponent("TimeDivider", TimeDivider);
class RemainingTimeDisplay extends TimeDisplay {
  constructor(player, options) {
    super(player, options);
    this.on(player, "durationchange", (e) => this.updateContent(e));
  }
  buildCSSClass() {
    return "vjs-remaining-time";
  }
  createEl() {
    const el = super.createEl();
    if (this.options_.displayNegative !== false) {
      el.insertBefore(createEl("span", {}, {
        "aria-hidden": true
      }, "-"), this.contentEl_);
    }
    return el;
  }
  updateContent(event) {
    if (typeof this.player_.duration() !== "number") {
      return;
    }
    let time;
    if (this.player_.ended()) {
      time = 0;
    } else if (this.player_.remainingTimeDisplay) {
      time = this.player_.remainingTimeDisplay();
    } else {
      time = this.player_.remainingTime();
    }
    this.updateTextNode_(time);
  }
}
RemainingTimeDisplay.prototype.labelText_ = "Remaining Time";
RemainingTimeDisplay.prototype.controlText_ = "Remaining Time";
Component$1.registerComponent("RemainingTimeDisplay", RemainingTimeDisplay);
class LiveDisplay extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.updateShowing();
    this.on(this.player(), "durationchange", (e) => this.updateShowing(e));
  }
  createEl() {
    const el = super.createEl("div", {
      className: "vjs-live-control vjs-control"
    });
    this.contentEl_ = createEl("div", {
      className: "vjs-live-display"
    }, {
      "aria-live": "off"
    });
    this.contentEl_.appendChild(createEl("span", {
      className: "vjs-control-text",
      textContent: `${this.localize("Stream Type")}\xA0`
    }));
    this.contentEl_.appendChild(document_1.createTextNode(this.localize("LIVE")));
    el.appendChild(this.contentEl_);
    return el;
  }
  dispose() {
    this.contentEl_ = null;
    super.dispose();
  }
  updateShowing(event) {
    if (this.player().duration() === Infinity) {
      this.show();
    } else {
      this.hide();
    }
  }
}
Component$1.registerComponent("LiveDisplay", LiveDisplay);
class SeekToLive extends Button {
  constructor(player, options) {
    super(player, options);
    this.updateLiveEdgeStatus();
    if (this.player_.liveTracker) {
      this.updateLiveEdgeStatusHandler_ = (e) => this.updateLiveEdgeStatus(e);
      this.on(this.player_.liveTracker, "liveedgechange", this.updateLiveEdgeStatusHandler_);
    }
  }
  createEl() {
    const el = super.createEl("button", {
      className: "vjs-seek-to-live-control vjs-control"
    });
    this.setIcon("circle", el);
    this.textEl_ = createEl("span", {
      className: "vjs-seek-to-live-text",
      textContent: this.localize("LIVE")
    }, {
      "aria-hidden": "true"
    });
    el.appendChild(this.textEl_);
    return el;
  }
  updateLiveEdgeStatus() {
    if (!this.player_.liveTracker || this.player_.liveTracker.atLiveEdge()) {
      this.setAttribute("aria-disabled", true);
      this.addClass("vjs-at-live-edge");
      this.controlText("Seek to live, currently playing live");
    } else {
      this.setAttribute("aria-disabled", false);
      this.removeClass("vjs-at-live-edge");
      this.controlText("Seek to live, currently behind live");
    }
  }
  handleClick() {
    this.player_.liveTracker.seekToLiveEdge();
  }
  dispose() {
    if (this.player_.liveTracker) {
      this.off(this.player_.liveTracker, "liveedgechange", this.updateLiveEdgeStatusHandler_);
    }
    this.textEl_ = null;
    super.dispose();
  }
}
SeekToLive.prototype.controlText_ = "Seek to live, currently playing live";
Component$1.registerComponent("SeekToLive", SeekToLive);
function clamp(number, min, max) {
  number = Number(number);
  return Math.min(max, Math.max(min, isNaN(number) ? min : number));
}
var Num = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  clamp
});
class Slider extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.handleMouseDown_ = (e) => this.handleMouseDown(e);
    this.handleMouseUp_ = (e) => this.handleMouseUp(e);
    this.handleKeyDown_ = (e) => this.handleKeyDown(e);
    this.handleClick_ = (e) => this.handleClick(e);
    this.handleMouseMove_ = (e) => this.handleMouseMove(e);
    this.update_ = (e) => this.update(e);
    this.bar = this.getChild(this.options_.barName);
    this.vertical(!!this.options_.vertical);
    this.enable();
  }
  enabled() {
    return this.enabled_;
  }
  enable() {
    if (this.enabled()) {
      return;
    }
    this.on("mousedown", this.handleMouseDown_);
    this.on("touchstart", this.handleMouseDown_);
    this.on("keydown", this.handleKeyDown_);
    this.on("click", this.handleClick_);
    this.on(this.player_, "controlsvisible", this.update);
    if (this.playerEvent) {
      this.on(this.player_, this.playerEvent, this.update);
    }
    this.removeClass("disabled");
    this.setAttribute("tabindex", 0);
    this.enabled_ = true;
  }
  disable() {
    if (!this.enabled()) {
      return;
    }
    const doc = this.bar.el_.ownerDocument;
    this.off("mousedown", this.handleMouseDown_);
    this.off("touchstart", this.handleMouseDown_);
    this.off("keydown", this.handleKeyDown_);
    this.off("click", this.handleClick_);
    this.off(this.player_, "controlsvisible", this.update_);
    this.off(doc, "mousemove", this.handleMouseMove_);
    this.off(doc, "mouseup", this.handleMouseUp_);
    this.off(doc, "touchmove", this.handleMouseMove_);
    this.off(doc, "touchend", this.handleMouseUp_);
    this.removeAttribute("tabindex");
    this.addClass("disabled");
    if (this.playerEvent) {
      this.off(this.player_, this.playerEvent, this.update);
    }
    this.enabled_ = false;
  }
  createEl(type, props = {}, attributes = {}) {
    props.className = props.className + " vjs-slider";
    props = Object.assign({
      tabIndex: 0
    }, props);
    attributes = Object.assign({
      "role": "slider",
      "aria-valuenow": 0,
      "aria-valuemin": 0,
      "aria-valuemax": 100
    }, attributes);
    return super.createEl(type, props, attributes);
  }
  handleMouseDown(event) {
    const doc = this.bar.el_.ownerDocument;
    if (event.type === "mousedown") {
      event.preventDefault();
    }
    if (event.type === "touchstart" && !IS_CHROME) {
      event.preventDefault();
    }
    blockTextSelection();
    this.addClass("vjs-sliding");
    this.trigger("slideractive");
    this.on(doc, "mousemove", this.handleMouseMove_);
    this.on(doc, "mouseup", this.handleMouseUp_);
    this.on(doc, "touchmove", this.handleMouseMove_);
    this.on(doc, "touchend", this.handleMouseUp_);
    this.handleMouseMove(event, true);
  }
  handleMouseMove(event) {
  }
  handleMouseUp(event) {
    const doc = this.bar.el_.ownerDocument;
    unblockTextSelection();
    this.removeClass("vjs-sliding");
    this.trigger("sliderinactive");
    this.off(doc, "mousemove", this.handleMouseMove_);
    this.off(doc, "mouseup", this.handleMouseUp_);
    this.off(doc, "touchmove", this.handleMouseMove_);
    this.off(doc, "touchend", this.handleMouseUp_);
    this.update();
  }
  update() {
    if (!this.el_ || !this.bar) {
      return;
    }
    const progress = this.getProgress();
    if (progress === this.progress_) {
      return progress;
    }
    this.progress_ = progress;
    this.requestNamedAnimationFrame("Slider#update", () => {
      const sizeKey = this.vertical() ? "height" : "width";
      this.bar.el().style[sizeKey] = (progress * 100).toFixed(2) + "%";
    });
    return progress;
  }
  getProgress() {
    return Number(clamp(this.getPercent(), 0, 1).toFixed(4));
  }
  calculateDistance(event) {
    const position = getPointerPosition(this.el_, event);
    if (this.vertical()) {
      return position.y;
    }
    return position.x;
  }
  handleKeyDown(event) {
    const spatialNavOptions = this.options_.playerOptions.spatialNavigation;
    const spatialNavEnabled = spatialNavOptions && spatialNavOptions.enabled;
    const horizontalSeek = spatialNavOptions && spatialNavOptions.horizontalSeek;
    if (spatialNavEnabled) {
      if (horizontalSeek && event.key === "ArrowLeft" || !horizontalSeek && event.key === "ArrowDown") {
        event.preventDefault();
        event.stopPropagation();
        this.stepBack();
      } else if (horizontalSeek && event.key === "ArrowRight" || !horizontalSeek && event.key === "ArrowUp") {
        event.preventDefault();
        event.stopPropagation();
        this.stepForward();
      } else {
        if (this.pendingSeekTime()) {
          this.pendingSeekTime(null);
          this.userSeek_(this.player_.currentTime());
        }
        super.handleKeyDown(event);
      }
    } else if (event.key === "ArrowLeft" || event.key === "ArrowDown") {
      event.preventDefault();
      event.stopPropagation();
      this.stepBack();
    } else if (event.key === "ArrowUp" || event.key === "ArrowRight") {
      event.preventDefault();
      event.stopPropagation();
      this.stepForward();
    } else {
      super.handleKeyDown(event);
    }
  }
  handleClick(event) {
    event.stopPropagation();
    event.preventDefault();
  }
  vertical(bool) {
    if (bool === void 0) {
      return this.vertical_ || false;
    }
    this.vertical_ = !!bool;
    if (this.vertical_) {
      this.addClass("vjs-slider-vertical");
    } else {
      this.addClass("vjs-slider-horizontal");
    }
  }
}
Component$1.registerComponent("Slider", Slider);
const percentify = (time, end) => clamp(time / end * 100, 0, 100).toFixed(2) + "%";
class LoadProgressBar extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.partEls_ = [];
    this.on(player, "progress", (e) => this.update(e));
  }
  createEl() {
    const el = super.createEl("div", {
      className: "vjs-load-progress"
    });
    const wrapper = createEl("span", {
      className: "vjs-control-text"
    });
    const loadedText = createEl("span", {
      textContent: this.localize("Loaded")
    });
    const separator = document_1.createTextNode(": ");
    this.percentageEl_ = createEl("span", {
      className: "vjs-control-text-loaded-percentage",
      textContent: "0%"
    });
    el.appendChild(wrapper);
    wrapper.appendChild(loadedText);
    wrapper.appendChild(separator);
    wrapper.appendChild(this.percentageEl_);
    return el;
  }
  dispose() {
    this.partEls_ = null;
    this.percentageEl_ = null;
    super.dispose();
  }
  update(event) {
    this.requestNamedAnimationFrame("LoadProgressBar#update", () => {
      const liveTracker = this.player_.liveTracker;
      const buffered = this.player_.buffered();
      const duration2 = liveTracker && liveTracker.isLive() ? liveTracker.seekableEnd() : this.player_.duration();
      const bufferedEnd = this.player_.bufferedEnd();
      const children = this.partEls_;
      const percent = percentify(bufferedEnd, duration2);
      if (this.percent_ !== percent) {
        this.el_.style.width = percent;
        textContent(this.percentageEl_, percent);
        this.percent_ = percent;
      }
      for (let i = 0; i < buffered.length; i++) {
        const start = buffered.start(i);
        const end = buffered.end(i);
        let part = children[i];
        if (!part) {
          part = this.el_.appendChild(createEl());
          children[i] = part;
        }
        if (part.dataset.start === start && part.dataset.end === end) {
          continue;
        }
        part.dataset.start = start;
        part.dataset.end = end;
        part.style.left = percentify(start, bufferedEnd);
        part.style.width = percentify(end - start, bufferedEnd);
      }
      for (let i = children.length; i > buffered.length; i--) {
        this.el_.removeChild(children[i - 1]);
      }
      children.length = buffered.length;
    });
  }
}
Component$1.registerComponent("LoadProgressBar", LoadProgressBar);
class TimeTooltip extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.update = throttle(bind_(this, this.update), UPDATE_REFRESH_INTERVAL);
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-time-tooltip"
    }, {
      "aria-hidden": "true"
    });
  }
  update(seekBarRect, seekBarPoint, content) {
    const tooltipRect = findPosition(this.el_);
    const playerRect = getBoundingClientRect(this.player_.el());
    const seekBarPointPx = seekBarRect.width * seekBarPoint;
    if (!playerRect || !tooltipRect) {
      return;
    }
    let spaceLeftOfPoint = seekBarRect.left - playerRect.left + seekBarPointPx;
    let spaceRightOfPoint = seekBarRect.width - seekBarPointPx + (playerRect.right - seekBarRect.right);
    if (!spaceRightOfPoint) {
      spaceRightOfPoint = seekBarRect.width - seekBarPointPx;
      spaceLeftOfPoint = seekBarPointPx;
    }
    let pullTooltipBy = tooltipRect.width / 2;
    if (spaceLeftOfPoint < pullTooltipBy) {
      pullTooltipBy += pullTooltipBy - spaceLeftOfPoint;
    } else if (spaceRightOfPoint < pullTooltipBy) {
      pullTooltipBy = spaceRightOfPoint;
    }
    if (pullTooltipBy < 0) {
      pullTooltipBy = 0;
    } else if (pullTooltipBy > tooltipRect.width) {
      pullTooltipBy = tooltipRect.width;
    }
    pullTooltipBy = Math.round(pullTooltipBy);
    this.el_.style.right = `-${pullTooltipBy}px`;
    this.write(content);
  }
  write(content) {
    textContent(this.el_, content);
  }
  updateTime(seekBarRect, seekBarPoint, time, cb) {
    this.requestNamedAnimationFrame("TimeTooltip#updateTime", () => {
      let content;
      const duration2 = this.player_.duration();
      if (this.player_.liveTracker && this.player_.liveTracker.isLive()) {
        const liveWindow = this.player_.liveTracker.liveWindow();
        const secondsBehind = liveWindow - seekBarPoint * liveWindow;
        content = (secondsBehind < 1 ? "" : "-") + formatTime(secondsBehind, liveWindow);
      } else {
        content = formatTime(time, duration2);
      }
      this.update(seekBarRect, seekBarPoint, content);
      if (cb) {
        cb();
      }
    });
  }
}
Component$1.registerComponent("TimeTooltip", TimeTooltip);
class PlayProgressBar extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.setIcon("circle");
    this.update = throttle(bind_(this, this.update), UPDATE_REFRESH_INTERVAL);
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-play-progress vjs-slider-bar"
    }, {
      "aria-hidden": "true"
    });
  }
  update(seekBarRect, seekBarPoint, event) {
    const timeTooltip = this.getChild("timeTooltip");
    if (!timeTooltip) {
      return;
    }
    const time = event && event.target && typeof event.target.pendingSeekTime === "function" ? event.target.pendingSeekTime() : this.player_.scrubbing() ? this.player_.getCache().currentTime : this.player_.currentTime();
    timeTooltip.updateTime(seekBarRect, seekBarPoint, time);
  }
}
PlayProgressBar.prototype.options_ = {
  children: []
};
if (!IS_IOS && !IS_ANDROID) {
  PlayProgressBar.prototype.options_.children.push("timeTooltip");
}
Component$1.registerComponent("PlayProgressBar", PlayProgressBar);
class MouseTimeDisplay extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.update = throttle(bind_(this, this.update), UPDATE_REFRESH_INTERVAL);
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-mouse-display"
    });
  }
  update(seekBarRect, seekBarPoint) {
    const time = seekBarPoint * this.player_.duration();
    this.getChild("timeTooltip").updateTime(seekBarRect, seekBarPoint, time, () => {
      this.el_.style.left = `${seekBarRect.width * seekBarPoint}px`;
    });
  }
}
MouseTimeDisplay.prototype.options_ = {
  children: ["timeTooltip"]
};
Component$1.registerComponent("MouseTimeDisplay", MouseTimeDisplay);
class SeekBar extends Slider {
  constructor(player, options) {
    options = merge$1(SeekBar.prototype.options_, options);
    options.children = [...options.children];
    const shouldDisableSeekWhileScrubbing = player.options_.disableSeekWhileScrubbingOnMobile && (IS_IOS || IS_ANDROID) || player.options_.disableSeekWhileScrubbingOnSTV;
    if (!IS_IOS && !IS_ANDROID || shouldDisableSeekWhileScrubbing) {
      options.children.splice(1, 0, "mouseTimeDisplay");
    }
    super(player, options);
    this.shouldDisableSeekWhileScrubbing_ = shouldDisableSeekWhileScrubbing;
    this.pendingSeekTime_ = null;
    this.setEventHandlers_();
  }
  setEventHandlers_() {
    this.update_ = bind_(this, this.update);
    this.update = throttle(this.update_, UPDATE_REFRESH_INTERVAL);
    this.on(this.player_, ["durationchange", "timeupdate"], this.update);
    this.on(this.player_, ["ended"], this.update_);
    if (this.player_.liveTracker) {
      this.on(this.player_.liveTracker, "liveedgechange", this.update);
    }
    this.updateInterval = null;
    this.enableIntervalHandler_ = (e) => this.enableInterval_(e);
    this.disableIntervalHandler_ = (e) => this.disableInterval_(e);
    this.on(this.player_, ["playing"], this.enableIntervalHandler_);
    this.on(this.player_, ["ended", "pause", "waiting"], this.disableIntervalHandler_);
    if ("hidden" in document_1 && "visibilityState" in document_1) {
      this.on(document_1, "visibilitychange", this.toggleVisibility_);
    }
  }
  toggleVisibility_(e) {
    if (document_1.visibilityState === "hidden") {
      this.cancelNamedAnimationFrame("SeekBar#update");
      this.cancelNamedAnimationFrame("Slider#update");
      this.disableInterval_(e);
    } else {
      if (!this.player_.ended() && !this.player_.paused()) {
        this.enableInterval_();
      }
      this.update();
    }
  }
  enableInterval_() {
    if (this.updateInterval) {
      return;
    }
    this.updateInterval = this.setInterval(this.update, UPDATE_REFRESH_INTERVAL);
  }
  disableInterval_(e) {
    if (this.player_.liveTracker && this.player_.liveTracker.isLive() && e && e.type !== "ended") {
      return;
    }
    if (!this.updateInterval) {
      return;
    }
    this.clearInterval(this.updateInterval);
    this.updateInterval = null;
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-progress-holder"
    }, {
      "aria-label": this.localize("Progress Bar")
    });
  }
  update(event) {
    if (document_1.visibilityState === "hidden") {
      return;
    }
    const percent = super.update();
    this.requestNamedAnimationFrame("SeekBar#update", () => {
      const currentTime = this.player_.ended() ? this.player_.duration() : this.getCurrentTime_();
      const liveTracker = this.player_.liveTracker;
      let duration2 = this.player_.duration();
      if (liveTracker && liveTracker.isLive()) {
        duration2 = this.player_.liveTracker.liveCurrentTime();
      }
      if (this.percent_ !== percent) {
        this.el_.setAttribute("aria-valuenow", (percent * 100).toFixed(2));
        this.percent_ = percent;
      }
      if (this.currentTime_ !== currentTime || this.duration_ !== duration2) {
        this.el_.setAttribute("aria-valuetext", this.localize("progress bar timing: currentTime={1} duration={2}", [formatTime(currentTime, duration2), formatTime(duration2, duration2)], "{1} of {2}"));
        this.currentTime_ = currentTime;
        this.duration_ = duration2;
      }
      if (this.bar) {
        this.bar.update(getBoundingClientRect(this.el()), this.getProgress(), event);
      }
    });
    return percent;
  }
  userSeek_(ct) {
    if (this.player_.liveTracker && this.player_.liveTracker.isLive()) {
      this.player_.liveTracker.nextSeekedFromUser();
    }
    this.player_.currentTime(ct);
  }
  getCurrentTime_() {
    return this.player_.scrubbing() ? this.player_.getCache().currentTime : this.player_.currentTime();
  }
  pendingSeekTime(time) {
    if (time !== void 0) {
      if (time !== null) {
        const duration2 = this.player_.duration();
        this.pendingSeekTime_ = Math.max(0, Math.min(time, duration2));
      } else {
        this.pendingSeekTime_ = null;
      }
    }
    return this.pendingSeekTime_;
  }
  getPercent() {
    if (this.pendingSeekTime() !== null) {
      return this.pendingSeekTime() / this.player_.duration();
    }
    const currentTime = this.getCurrentTime_();
    let percent;
    const liveTracker = this.player_.liveTracker;
    if (liveTracker && liveTracker.isLive()) {
      percent = (currentTime - liveTracker.seekableStart()) / liveTracker.liveWindow();
      if (liveTracker.atLiveEdge()) {
        percent = 1;
      }
    } else {
      percent = currentTime / this.player_.duration();
    }
    return percent;
  }
  handleMouseDown(event) {
    if (!isSingleLeftClick(event)) {
      return;
    }
    event.stopPropagation();
    this.videoWasPlaying = !this.player_.paused();
    if (!this.shouldDisableSeekWhileScrubbing_) {
      this.player_.pause();
    }
    super.handleMouseDown(event);
  }
  handleMouseMove(event, mouseDown = false) {
    if (!isSingleLeftClick(event) || isNaN(this.player_.duration())) {
      return;
    }
    if (!mouseDown && !this.player_.scrubbing()) {
      this.player_.scrubbing(true);
    }
    let newTime;
    const distance = this.calculateDistance(event);
    const liveTracker = this.player_.liveTracker;
    if (!liveTracker || !liveTracker.isLive()) {
      newTime = distance * this.player_.duration();
      if (newTime === this.player_.duration()) {
        newTime = newTime - 0.1;
      }
    } else {
      if (distance >= 0.99) {
        liveTracker.seekToLiveEdge();
        return;
      }
      const seekableStart = liveTracker.seekableStart();
      const seekableEnd = liveTracker.liveCurrentTime();
      newTime = seekableStart + distance * liveTracker.liveWindow();
      if (newTime >= seekableEnd) {
        newTime = seekableEnd;
      }
      if (newTime <= seekableStart) {
        newTime = seekableStart + 0.1;
      }
      if (newTime === Infinity) {
        return;
      }
    }
    if (this.shouldDisableSeekWhileScrubbing_) {
      this.pendingSeekTime(newTime);
    } else {
      this.userSeek_(newTime);
    }
    if (this.player_.options_.enableSmoothSeeking) {
      this.update();
    }
  }
  enable() {
    super.enable();
    const mouseTimeDisplay = this.getChild("mouseTimeDisplay");
    if (!mouseTimeDisplay) {
      return;
    }
    mouseTimeDisplay.show();
  }
  disable() {
    super.disable();
    const mouseTimeDisplay = this.getChild("mouseTimeDisplay");
    if (!mouseTimeDisplay) {
      return;
    }
    mouseTimeDisplay.hide();
  }
  handleMouseUp(event) {
    super.handleMouseUp(event);
    if (event) {
      event.stopPropagation();
    }
    this.player_.scrubbing(false);
    if (this.pendingSeekTime() !== null) {
      this.userSeek_(this.pendingSeekTime());
      this.pendingSeekTime(null);
    }
    this.player_.trigger({
      type: "timeupdate",
      target: this,
      manuallyTriggered: true
    });
    if (this.videoWasPlaying) {
      silencePromise(this.player_.play());
    } else {
      this.update_();
    }
  }
  handlePendingSeek_(stepAmount) {
    if (!this.player_.paused()) {
      this.player_.pause();
    }
    const currentPos = this.pendingSeekTime() !== null ? this.pendingSeekTime() : this.player_.currentTime();
    this.pendingSeekTime(currentPos + stepAmount);
    this.player_.trigger({
      type: "timeupdate",
      target: this,
      manuallyTriggered: true
    });
  }
  stepForward() {
    if (this.shouldDisableSeekWhileScrubbing_) {
      this.handlePendingSeek_(this.options().stepSeconds);
    } else {
      this.userSeek_(this.player_.currentTime() + this.options().stepSeconds);
    }
  }
  stepBack() {
    if (this.shouldDisableSeekWhileScrubbing_) {
      this.handlePendingSeek_(-this.options().stepSeconds);
    } else {
      this.userSeek_(this.player_.currentTime() - this.options().stepSeconds);
    }
  }
  handleAction(event) {
    if (this.pendingSeekTime() !== null) {
      this.userSeek_(this.pendingSeekTime());
      this.pendingSeekTime(null);
    }
    if (this.player_.paused()) {
      this.player_.play();
    } else {
      this.player_.pause();
    }
  }
  handleKeyDown(event) {
    const liveTracker = this.player_.liveTracker;
    if (event.key === " " || event.key === "Enter") {
      event.preventDefault();
      event.stopPropagation();
      this.handleAction(event);
    } else if (event.key === "Home") {
      event.preventDefault();
      event.stopPropagation();
      this.userSeek_(0);
    } else if (event.key === "End") {
      event.preventDefault();
      event.stopPropagation();
      if (liveTracker && liveTracker.isLive()) {
        this.userSeek_(liveTracker.liveCurrentTime());
      } else {
        this.userSeek_(this.player_.duration());
      }
    } else if (/^[0-9]$/.test(event.key)) {
      event.preventDefault();
      event.stopPropagation();
      const gotoFraction = parseInt(event.key, 10) * 0.1;
      if (liveTracker && liveTracker.isLive()) {
        this.userSeek_(liveTracker.seekableStart() + liveTracker.liveWindow() * gotoFraction);
      } else {
        this.userSeek_(this.player_.duration() * gotoFraction);
      }
    } else if (event.key === "PageDown") {
      event.preventDefault();
      event.stopPropagation();
      this.userSeek_(this.player_.currentTime() - this.options().stepSeconds * this.options().pageMultiplier);
    } else if (event.key === "PageUp") {
      event.preventDefault();
      event.stopPropagation();
      this.userSeek_(this.player_.currentTime() + this.options().stepSeconds * this.options().pageMultiplier);
    } else {
      super.handleKeyDown(event);
    }
  }
  dispose() {
    this.disableInterval_();
    this.off(this.player_, ["durationchange", "timeupdate"], this.update);
    this.off(this.player_, ["ended"], this.update_);
    if (this.player_.liveTracker) {
      this.off(this.player_.liveTracker, "liveedgechange", this.update);
    }
    this.off(this.player_, ["playing"], this.enableIntervalHandler_);
    this.off(this.player_, ["ended", "pause", "waiting"], this.disableIntervalHandler_);
    if ("hidden" in document_1 && "visibilityState" in document_1) {
      this.off(document_1, "visibilitychange", this.toggleVisibility_);
    }
    super.dispose();
  }
}
SeekBar.prototype.options_ = {
  children: ["loadProgressBar", "playProgressBar"],
  barName: "playProgressBar",
  stepSeconds: 5,
  pageMultiplier: 12
};
Component$1.registerComponent("SeekBar", SeekBar);
class ProgressControl extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.handleMouseMove = throttle(bind_(this, this.handleMouseMove), UPDATE_REFRESH_INTERVAL);
    this.throttledHandleMouseSeek = throttle(bind_(this, this.handleMouseSeek), UPDATE_REFRESH_INTERVAL);
    this.handleMouseUpHandler_ = (e) => this.handleMouseUp(e);
    this.handleMouseDownHandler_ = (e) => this.handleMouseDown(e);
    this.enable();
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-progress-control vjs-control"
    });
  }
  handleMouseMove(event) {
    const seekBar = this.getChild("seekBar");
    if (!seekBar) {
      return;
    }
    const playProgressBar = seekBar.getChild("playProgressBar");
    const mouseTimeDisplay = seekBar.getChild("mouseTimeDisplay");
    if (!playProgressBar && !mouseTimeDisplay) {
      return;
    }
    const seekBarEl = seekBar.el();
    const seekBarRect = findPosition(seekBarEl);
    let seekBarPoint = getPointerPosition(seekBarEl, event).x;
    seekBarPoint = clamp(seekBarPoint, 0, 1);
    if (mouseTimeDisplay) {
      mouseTimeDisplay.update(seekBarRect, seekBarPoint);
    }
    if (playProgressBar) {
      playProgressBar.update(seekBarRect, seekBar.getProgress());
    }
  }
  handleMouseSeek(event) {
    const seekBar = this.getChild("seekBar");
    if (seekBar) {
      seekBar.handleMouseMove(event);
    }
  }
  enabled() {
    return this.enabled_;
  }
  disable() {
    this.children().forEach((child) => child.disable && child.disable());
    if (!this.enabled()) {
      return;
    }
    this.off(["mousedown", "touchstart"], this.handleMouseDownHandler_);
    this.off(this.el_, ["mousemove", "touchmove"], this.handleMouseMove);
    this.removeListenersAddedOnMousedownAndTouchstart();
    this.addClass("disabled");
    this.enabled_ = false;
    if (this.player_.scrubbing()) {
      const seekBar = this.getChild("seekBar");
      this.player_.scrubbing(false);
      if (seekBar.videoWasPlaying) {
        silencePromise(this.player_.play());
      }
    }
  }
  enable() {
    this.children().forEach((child) => child.enable && child.enable());
    if (this.enabled()) {
      return;
    }
    this.on(["mousedown", "touchstart"], this.handleMouseDownHandler_);
    this.on(this.el_, ["mousemove", "touchmove"], this.handleMouseMove);
    this.removeClass("disabled");
    this.enabled_ = true;
  }
  removeListenersAddedOnMousedownAndTouchstart() {
    const doc = this.el_.ownerDocument;
    this.off(doc, "mousemove", this.throttledHandleMouseSeek);
    this.off(doc, "touchmove", this.throttledHandleMouseSeek);
    this.off(doc, "mouseup", this.handleMouseUpHandler_);
    this.off(doc, "touchend", this.handleMouseUpHandler_);
  }
  handleMouseDown(event) {
    const doc = this.el_.ownerDocument;
    const seekBar = this.getChild("seekBar");
    if (seekBar) {
      seekBar.handleMouseDown(event);
    }
    this.on(doc, "mousemove", this.throttledHandleMouseSeek);
    this.on(doc, "touchmove", this.throttledHandleMouseSeek);
    this.on(doc, "mouseup", this.handleMouseUpHandler_);
    this.on(doc, "touchend", this.handleMouseUpHandler_);
  }
  handleMouseUp(event) {
    const seekBar = this.getChild("seekBar");
    if (seekBar) {
      seekBar.handleMouseUp(event);
    }
    this.removeListenersAddedOnMousedownAndTouchstart();
  }
}
ProgressControl.prototype.options_ = {
  children: ["seekBar"]
};
Component$1.registerComponent("ProgressControl", ProgressControl);
class PictureInPictureToggle extends Button {
  constructor(player, options) {
    super(player, options);
    this.setIcon("picture-in-picture-enter");
    this.on(player, ["enterpictureinpicture", "leavepictureinpicture"], (e) => this.handlePictureInPictureChange(e));
    this.on(player, ["disablepictureinpicturechanged", "loadedmetadata"], (e) => this.handlePictureInPictureEnabledChange(e));
    this.on(player, ["loadedmetadata", "audioonlymodechange", "audiopostermodechange"], () => this.handlePictureInPictureAudioModeChange());
    this.disable();
  }
  buildCSSClass() {
    return `vjs-picture-in-picture-control vjs-hidden ${super.buildCSSClass()}`;
  }
  handlePictureInPictureAudioModeChange() {
    const isSourceAudio = this.player_.currentType().substring(0, 5) === "audio";
    const isAudioMode = isSourceAudio || this.player_.audioPosterMode() || this.player_.audioOnlyMode();
    if (!isAudioMode) {
      this.show();
      return;
    }
    if (this.player_.isInPictureInPicture()) {
      this.player_.exitPictureInPicture();
    }
    this.hide();
  }
  handlePictureInPictureEnabledChange() {
    if (document_1.pictureInPictureEnabled && this.player_.disablePictureInPicture() === false || this.player_.options_.enableDocumentPictureInPicture && "documentPictureInPicture" in window_1) {
      this.enable();
    } else {
      this.disable();
    }
  }
  handlePictureInPictureChange(event) {
    if (this.player_.isInPictureInPicture()) {
      this.setIcon("picture-in-picture-exit");
      this.controlText("Exit Picture-in-Picture");
    } else {
      this.setIcon("picture-in-picture-enter");
      this.controlText("Picture-in-Picture");
    }
    this.handlePictureInPictureEnabledChange();
  }
  handleClick(event) {
    if (!this.player_.isInPictureInPicture()) {
      this.player_.requestPictureInPicture();
    } else {
      this.player_.exitPictureInPicture();
    }
  }
  show() {
    if (typeof document_1.exitPictureInPicture !== "function") {
      return;
    }
    super.show();
  }
}
PictureInPictureToggle.prototype.controlText_ = "Picture-in-Picture";
Component$1.registerComponent("PictureInPictureToggle", PictureInPictureToggle);
class FullscreenToggle extends Button {
  constructor(player, options) {
    super(player, options);
    this.setIcon("fullscreen-enter");
    this.on(player, "fullscreenchange", (e) => this.handleFullscreenChange(e));
    if (document_1[player.fsApi_.fullscreenEnabled] === false) {
      this.disable();
    }
  }
  buildCSSClass() {
    return `vjs-fullscreen-control ${super.buildCSSClass()}`;
  }
  handleFullscreenChange(event) {
    if (this.player_.isFullscreen()) {
      this.controlText("Exit Fullscreen");
      this.setIcon("fullscreen-exit");
    } else {
      this.controlText("Fullscreen");
      this.setIcon("fullscreen-enter");
    }
  }
  handleClick(event) {
    if (!this.player_.isFullscreen()) {
      this.player_.requestFullscreen();
    } else {
      this.player_.exitFullscreen();
    }
  }
}
FullscreenToggle.prototype.controlText_ = "Fullscreen";
Component$1.registerComponent("FullscreenToggle", FullscreenToggle);
const checkVolumeSupport = function(self2, player) {
  if (player.tech_ && !player.tech_.featuresVolumeControl) {
    self2.addClass("vjs-hidden");
  }
  self2.on(player, "loadstart", function() {
    if (!player.tech_.featuresVolumeControl) {
      self2.addClass("vjs-hidden");
    } else {
      self2.removeClass("vjs-hidden");
    }
  });
};
class VolumeLevel extends Component$1 {
  createEl() {
    const el = super.createEl("div", {
      className: "vjs-volume-level"
    });
    this.setIcon("circle", el);
    el.appendChild(super.createEl("span", {
      className: "vjs-control-text"
    }));
    return el;
  }
}
Component$1.registerComponent("VolumeLevel", VolumeLevel);
class VolumeLevelTooltip extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.update = throttle(bind_(this, this.update), UPDATE_REFRESH_INTERVAL);
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-volume-tooltip"
    }, {
      "aria-hidden": "true"
    });
  }
  update(rangeBarRect, rangeBarPoint, vertical, content) {
    if (!vertical) {
      const tooltipRect = getBoundingClientRect(this.el_);
      const playerRect = getBoundingClientRect(this.player_.el());
      const volumeBarPointPx = rangeBarRect.width * rangeBarPoint;
      if (!playerRect || !tooltipRect) {
        return;
      }
      const spaceLeftOfPoint = rangeBarRect.left - playerRect.left + volumeBarPointPx;
      const spaceRightOfPoint = rangeBarRect.width - volumeBarPointPx + (playerRect.right - rangeBarRect.right);
      let pullTooltipBy = tooltipRect.width / 2;
      if (spaceLeftOfPoint < pullTooltipBy) {
        pullTooltipBy += pullTooltipBy - spaceLeftOfPoint;
      } else if (spaceRightOfPoint < pullTooltipBy) {
        pullTooltipBy = spaceRightOfPoint;
      }
      if (pullTooltipBy < 0) {
        pullTooltipBy = 0;
      } else if (pullTooltipBy > tooltipRect.width) {
        pullTooltipBy = tooltipRect.width;
      }
      this.el_.style.right = `-${pullTooltipBy}px`;
    }
    this.write(`${content}%`);
  }
  write(content) {
    textContent(this.el_, content);
  }
  updateVolume(rangeBarRect, rangeBarPoint, vertical, volume, cb) {
    this.requestNamedAnimationFrame("VolumeLevelTooltip#updateVolume", () => {
      this.update(rangeBarRect, rangeBarPoint, vertical, volume.toFixed(0));
      if (cb) {
        cb();
      }
    });
  }
}
Component$1.registerComponent("VolumeLevelTooltip", VolumeLevelTooltip);
class MouseVolumeLevelDisplay extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.update = throttle(bind_(this, this.update), UPDATE_REFRESH_INTERVAL);
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-mouse-display"
    });
  }
  update(rangeBarRect, rangeBarPoint, vertical) {
    const volume = 100 * rangeBarPoint;
    this.getChild("volumeLevelTooltip").updateVolume(rangeBarRect, rangeBarPoint, vertical, volume, () => {
      if (vertical) {
        this.el_.style.bottom = `${rangeBarRect.height * rangeBarPoint}px`;
      } else {
        this.el_.style.left = `${rangeBarRect.width * rangeBarPoint}px`;
      }
    });
  }
}
MouseVolumeLevelDisplay.prototype.options_ = {
  children: ["volumeLevelTooltip"]
};
Component$1.registerComponent("MouseVolumeLevelDisplay", MouseVolumeLevelDisplay);
class VolumeBar extends Slider {
  constructor(player, options) {
    super(player, options);
    this.on("slideractive", (e) => this.updateLastVolume_(e));
    this.on(player, "volumechange", (e) => this.updateARIAAttributes(e));
    player.ready(() => this.updateARIAAttributes());
  }
  createEl() {
    return super.createEl("div", {
      className: "vjs-volume-bar vjs-slider-bar"
    }, {
      "aria-label": this.localize("Volume Level"),
      "aria-live": "polite"
    });
  }
  handleMouseDown(event) {
    if (!isSingleLeftClick(event)) {
      return;
    }
    super.handleMouseDown(event);
  }
  handleMouseMove(event) {
    const mouseVolumeLevelDisplay = this.getChild("mouseVolumeLevelDisplay");
    if (mouseVolumeLevelDisplay) {
      const volumeBarEl = this.el();
      const volumeBarRect = getBoundingClientRect(volumeBarEl);
      const vertical = this.vertical();
      let volumeBarPoint = getPointerPosition(volumeBarEl, event);
      volumeBarPoint = vertical ? volumeBarPoint.y : volumeBarPoint.x;
      volumeBarPoint = clamp(volumeBarPoint, 0, 1);
      mouseVolumeLevelDisplay.update(volumeBarRect, volumeBarPoint, vertical);
    }
    if (!isSingleLeftClick(event)) {
      return;
    }
    this.checkMuted();
    this.player_.volume(this.calculateDistance(event));
  }
  checkMuted() {
    if (this.player_.muted()) {
      this.player_.muted(false);
    }
  }
  getPercent() {
    if (this.player_.muted()) {
      return 0;
    }
    return this.player_.volume();
  }
  stepForward() {
    this.checkMuted();
    this.player_.volume(this.player_.volume() + 0.1);
  }
  stepBack() {
    this.checkMuted();
    this.player_.volume(this.player_.volume() - 0.1);
  }
  updateARIAAttributes(event) {
    const ariaValue = this.player_.muted() ? 0 : this.volumeAsPercentage_();
    this.el_.setAttribute("aria-valuenow", ariaValue);
    this.el_.setAttribute("aria-valuetext", ariaValue + "%");
  }
  volumeAsPercentage_() {
    return Math.round(this.player_.volume() * 100);
  }
  updateLastVolume_() {
    const volumeBeforeDrag = this.player_.volume();
    this.one("sliderinactive", () => {
      if (this.player_.volume() === 0) {
        this.player_.lastVolume_(volumeBeforeDrag);
      }
    });
  }
}
VolumeBar.prototype.options_ = {
  children: ["volumeLevel"],
  barName: "volumeLevel"
};
if (!IS_IOS && !IS_ANDROID) {
  VolumeBar.prototype.options_.children.splice(0, 0, "mouseVolumeLevelDisplay");
}
VolumeBar.prototype.playerEvent = "volumechange";
Component$1.registerComponent("VolumeBar", VolumeBar);
class VolumeControl extends Component$1 {
  constructor(player, options = {}) {
    options.vertical = options.vertical || false;
    if (typeof options.volumeBar === "undefined" || isPlain(options.volumeBar)) {
      options.volumeBar = options.volumeBar || {};
      options.volumeBar.vertical = options.vertical;
    }
    super(player, options);
    checkVolumeSupport(this, player);
    this.throttledHandleMouseMove = throttle(bind_(this, this.handleMouseMove), UPDATE_REFRESH_INTERVAL);
    this.handleMouseUpHandler_ = (e) => this.handleMouseUp(e);
    this.on("mousedown", (e) => this.handleMouseDown(e));
    this.on("touchstart", (e) => this.handleMouseDown(e));
    this.on("mousemove", (e) => this.handleMouseMove(e));
    this.on(this.volumeBar, ["focus", "slideractive"], () => {
      this.volumeBar.addClass("vjs-slider-active");
      this.addClass("vjs-slider-active");
      this.trigger("slideractive");
    });
    this.on(this.volumeBar, ["blur", "sliderinactive"], () => {
      this.volumeBar.removeClass("vjs-slider-active");
      this.removeClass("vjs-slider-active");
      this.trigger("sliderinactive");
    });
  }
  createEl() {
    let orientationClass = "vjs-volume-horizontal";
    if (this.options_.vertical) {
      orientationClass = "vjs-volume-vertical";
    }
    return super.createEl("div", {
      className: `vjs-volume-control vjs-control ${orientationClass}`
    });
  }
  handleMouseDown(event) {
    const doc = this.el_.ownerDocument;
    this.on(doc, "mousemove", this.throttledHandleMouseMove);
    this.on(doc, "touchmove", this.throttledHandleMouseMove);
    this.on(doc, "mouseup", this.handleMouseUpHandler_);
    this.on(doc, "touchend", this.handleMouseUpHandler_);
  }
  handleMouseUp(event) {
    const doc = this.el_.ownerDocument;
    this.off(doc, "mousemove", this.throttledHandleMouseMove);
    this.off(doc, "touchmove", this.throttledHandleMouseMove);
    this.off(doc, "mouseup", this.handleMouseUpHandler_);
    this.off(doc, "touchend", this.handleMouseUpHandler_);
  }
  handleMouseMove(event) {
    this.volumeBar.handleMouseMove(event);
  }
}
VolumeControl.prototype.options_ = {
  children: ["volumeBar"]
};
Component$1.registerComponent("VolumeControl", VolumeControl);
const checkMuteSupport = function(self2, player) {
  if (player.tech_ && !player.tech_.featuresMuteControl) {
    self2.addClass("vjs-hidden");
  }
  self2.on(player, "loadstart", function() {
    if (!player.tech_.featuresMuteControl) {
      self2.addClass("vjs-hidden");
    } else {
      self2.removeClass("vjs-hidden");
    }
  });
};
class MuteToggle extends Button {
  constructor(player, options) {
    super(player, options);
    checkMuteSupport(this, player);
    this.on(player, ["loadstart", "volumechange"], (e) => this.update(e));
  }
  buildCSSClass() {
    return `vjs-mute-control ${super.buildCSSClass()}`;
  }
  handleClick(event) {
    const vol = this.player_.volume();
    const lastVolume = this.player_.lastVolume_();
    if (vol === 0) {
      const volumeToSet = lastVolume < 0.1 ? 0.1 : lastVolume;
      this.player_.volume(volumeToSet);
      this.player_.muted(false);
    } else {
      this.player_.muted(this.player_.muted() ? false : true);
    }
  }
  update(event) {
    this.updateIcon_();
    this.updateControlText_();
  }
  updateIcon_() {
    const vol = this.player_.volume();
    let level = 3;
    this.setIcon("volume-high");
    if (IS_IOS && this.player_.tech_ && this.player_.tech_.el_) {
      this.player_.muted(this.player_.tech_.el_.muted);
    }
    if (vol === 0 || this.player_.muted()) {
      this.setIcon("volume-mute");
      level = 0;
    } else if (vol < 0.33) {
      this.setIcon("volume-low");
      level = 1;
    } else if (vol < 0.67) {
      this.setIcon("volume-medium");
      level = 2;
    }
    removeClass(this.el_, [0, 1, 2, 3].reduce((str, i) => str + `${i ? " " : ""}vjs-vol-${i}`, ""));
    addClass(this.el_, `vjs-vol-${level}`);
  }
  updateControlText_() {
    const soundOff = this.player_.muted() || this.player_.volume() === 0;
    const text = soundOff ? "Unmute" : "Mute";
    if (this.controlText() !== text) {
      this.controlText(text);
    }
  }
}
MuteToggle.prototype.controlText_ = "Mute";
Component$1.registerComponent("MuteToggle", MuteToggle);
class VolumePanel extends Component$1 {
  constructor(player, options = {}) {
    if (typeof options.inline !== "undefined") {
      options.inline = options.inline;
    } else {
      options.inline = true;
    }
    if (typeof options.volumeControl === "undefined" || isPlain(options.volumeControl)) {
      options.volumeControl = options.volumeControl || {};
      options.volumeControl.vertical = !options.inline;
    }
    super(player, options);
    this.handleKeyPressHandler_ = (e) => this.handleKeyPress(e);
    this.on(player, ["loadstart"], (e) => this.volumePanelState_(e));
    this.on(this.muteToggle, "keyup", (e) => this.handleKeyPress(e));
    this.on(this.volumeControl, "keyup", (e) => this.handleVolumeControlKeyUp(e));
    this.on("keydown", (e) => this.handleKeyPress(e));
    this.on("mouseover", (e) => this.handleMouseOver(e));
    this.on("mouseout", (e) => this.handleMouseOut(e));
    this.on(this.volumeControl, ["slideractive"], this.sliderActive_);
    this.on(this.volumeControl, ["sliderinactive"], this.sliderInactive_);
  }
  sliderActive_() {
    this.addClass("vjs-slider-active");
  }
  sliderInactive_() {
    this.removeClass("vjs-slider-active");
  }
  volumePanelState_() {
    if (this.volumeControl.hasClass("vjs-hidden") && this.muteToggle.hasClass("vjs-hidden")) {
      this.addClass("vjs-hidden");
    }
    if (this.volumeControl.hasClass("vjs-hidden") && !this.muteToggle.hasClass("vjs-hidden")) {
      this.addClass("vjs-mute-toggle-only");
    }
  }
  createEl() {
    let orientationClass = "vjs-volume-panel-horizontal";
    if (!this.options_.inline) {
      orientationClass = "vjs-volume-panel-vertical";
    }
    return super.createEl("div", {
      className: `vjs-volume-panel vjs-control ${orientationClass}`
    });
  }
  dispose() {
    this.handleMouseOut();
    super.dispose();
  }
  handleVolumeControlKeyUp(event) {
    if (event.key === "Escape") {
      this.muteToggle.focus();
    }
  }
  handleMouseOver(event) {
    this.addClass("vjs-hover");
    on(document_1, "keyup", this.handleKeyPressHandler_);
  }
  handleMouseOut(event) {
    this.removeClass("vjs-hover");
    off(document_1, "keyup", this.handleKeyPressHandler_);
  }
  handleKeyPress(event) {
    if (event.key === "Escape") {
      this.handleMouseOut();
    }
  }
}
VolumePanel.prototype.options_ = {
  children: ["muteToggle", "volumeControl"]
};
Component$1.registerComponent("VolumePanel", VolumePanel);
class SkipForward extends Button {
  constructor(player, options) {
    super(player, options);
    this.validOptions = [5, 10, 30];
    this.skipTime = this.getSkipForwardTime();
    if (this.skipTime && this.validOptions.includes(this.skipTime)) {
      this.setIcon(`forward-${this.skipTime}`);
      this.controlText(this.localize("Skip forward {1} seconds", [this.skipTime.toLocaleString(player.language())]));
      this.show();
    } else {
      this.hide();
    }
  }
  getSkipForwardTime() {
    const playerOptions = this.options_.playerOptions;
    return playerOptions.controlBar && playerOptions.controlBar.skipButtons && playerOptions.controlBar.skipButtons.forward;
  }
  buildCSSClass() {
    return `vjs-skip-forward-${this.getSkipForwardTime()} ${super.buildCSSClass()}`;
  }
  handleClick(event) {
    if (isNaN(this.player_.duration())) {
      return;
    }
    const currentVideoTime = this.player_.currentTime();
    const liveTracker = this.player_.liveTracker;
    const duration2 = liveTracker && liveTracker.isLive() ? liveTracker.seekableEnd() : this.player_.duration();
    let newTime;
    if (currentVideoTime + this.skipTime <= duration2) {
      newTime = currentVideoTime + this.skipTime;
    } else {
      newTime = duration2;
    }
    this.player_.currentTime(newTime);
  }
  handleLanguagechange() {
    this.controlText(this.localize("Skip forward {1} seconds", [this.skipTime]));
  }
}
SkipForward.prototype.controlText_ = "Skip Forward";
Component$1.registerComponent("SkipForward", SkipForward);
class SkipBackward extends Button {
  constructor(player, options) {
    super(player, options);
    this.validOptions = [5, 10, 30];
    this.skipTime = this.getSkipBackwardTime();
    if (this.skipTime && this.validOptions.includes(this.skipTime)) {
      this.setIcon(`replay-${this.skipTime}`);
      this.controlText(this.localize("Skip backward {1} seconds", [this.skipTime.toLocaleString(player.language())]));
      this.show();
    } else {
      this.hide();
    }
  }
  getSkipBackwardTime() {
    const playerOptions = this.options_.playerOptions;
    return playerOptions.controlBar && playerOptions.controlBar.skipButtons && playerOptions.controlBar.skipButtons.backward;
  }
  buildCSSClass() {
    return `vjs-skip-backward-${this.getSkipBackwardTime()} ${super.buildCSSClass()}`;
  }
  handleClick(event) {
    const currentVideoTime = this.player_.currentTime();
    const liveTracker = this.player_.liveTracker;
    const seekableStart = liveTracker && liveTracker.isLive() && liveTracker.seekableStart();
    let newTime;
    if (seekableStart && currentVideoTime - this.skipTime <= seekableStart) {
      newTime = seekableStart;
    } else if (currentVideoTime >= this.skipTime) {
      newTime = currentVideoTime - this.skipTime;
    } else {
      newTime = 0;
    }
    this.player_.currentTime(newTime);
  }
  handleLanguagechange() {
    this.controlText(this.localize("Skip backward {1} seconds", [this.skipTime]));
  }
}
SkipBackward.prototype.controlText_ = "Skip Backward";
Component$1.registerComponent("SkipBackward", SkipBackward);
class Menu extends Component$1 {
  constructor(player, options) {
    super(player, options);
    if (options) {
      this.menuButton_ = options.menuButton;
    }
    this.focusedChild_ = -1;
    this.on("keydown", (e) => this.handleKeyDown(e));
    this.boundHandleBlur_ = (e) => this.handleBlur(e);
    this.boundHandleTapClick_ = (e) => this.handleTapClick(e);
  }
  addEventListenerForItem(component) {
    if (!(component instanceof Component$1)) {
      return;
    }
    this.on(component, "blur", this.boundHandleBlur_);
    this.on(component, ["tap", "click"], this.boundHandleTapClick_);
  }
  removeEventListenerForItem(component) {
    if (!(component instanceof Component$1)) {
      return;
    }
    this.off(component, "blur", this.boundHandleBlur_);
    this.off(component, ["tap", "click"], this.boundHandleTapClick_);
  }
  removeChild(component) {
    if (typeof component === "string") {
      component = this.getChild(component);
    }
    this.removeEventListenerForItem(component);
    super.removeChild(component);
  }
  addItem(component) {
    const childComponent = this.addChild(component);
    if (childComponent) {
      this.addEventListenerForItem(childComponent);
    }
  }
  createEl() {
    const contentElType = this.options_.contentElType || "ul";
    this.contentEl_ = createEl(contentElType, {
      className: "vjs-menu-content"
    });
    this.contentEl_.setAttribute("role", "menu");
    const el = super.createEl("div", {
      append: this.contentEl_,
      className: "vjs-menu"
    });
    el.appendChild(this.contentEl_);
    on(el, "click", function(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
    });
    return el;
  }
  dispose() {
    this.contentEl_ = null;
    this.boundHandleBlur_ = null;
    this.boundHandleTapClick_ = null;
    super.dispose();
  }
  handleBlur(event) {
    const relatedTarget = event.relatedTarget || document_1.activeElement;
    if (!this.children().some((element) => {
      return element.el() === relatedTarget;
    })) {
      const btn = this.menuButton_;
      if (btn && btn.buttonPressed_ && relatedTarget !== btn.el().firstChild) {
        btn.unpressButton();
      }
    }
  }
  handleTapClick(event) {
    if (this.menuButton_) {
      this.menuButton_.unpressButton();
      const childComponents = this.children();
      if (!Array.isArray(childComponents)) {
        return;
      }
      const foundComponent = childComponents.filter((component) => component.el() === event.target)[0];
      if (!foundComponent) {
        return;
      }
      if (foundComponent.name() !== "CaptionSettingsMenuItem") {
        this.menuButton_.focus();
      }
    }
  }
  handleKeyDown(event) {
    if (event.key === "ArrowLeft" || event.key === "ArrowDown") {
      event.preventDefault();
      event.stopPropagation();
      this.stepForward();
    } else if (event.key === "ArrowRight" || event.key === "ArrowUp") {
      event.preventDefault();
      event.stopPropagation();
      this.stepBack();
    }
  }
  stepForward() {
    let stepChild = 0;
    if (this.focusedChild_ !== void 0) {
      stepChild = this.focusedChild_ + 1;
    }
    this.focus(stepChild);
  }
  stepBack() {
    let stepChild = 0;
    if (this.focusedChild_ !== void 0) {
      stepChild = this.focusedChild_ - 1;
    }
    this.focus(stepChild);
  }
  focus(item = 0) {
    const children = this.children().slice();
    const haveTitle = children.length && children[0].hasClass("vjs-menu-title");
    if (haveTitle) {
      children.shift();
    }
    if (children.length > 0) {
      if (item < 0) {
        item = 0;
      } else if (item >= children.length) {
        item = children.length - 1;
      }
      this.focusedChild_ = item;
      children[item].el_.focus();
    }
  }
}
Component$1.registerComponent("Menu", Menu);
class MenuButton extends Component$1 {
  constructor(player, options = {}) {
    super(player, options);
    this.menuButton_ = new Button(player, options);
    this.menuButton_.controlText(this.controlText_);
    this.menuButton_.el_.setAttribute("aria-haspopup", "true");
    const buttonClass = Button.prototype.buildCSSClass();
    this.menuButton_.el_.className = this.buildCSSClass() + " " + buttonClass;
    this.menuButton_.removeClass("vjs-control");
    this.addChild(this.menuButton_);
    this.update();
    this.enabled_ = true;
    const handleClick = (e) => this.handleClick(e);
    this.handleMenuKeyUp_ = (e) => this.handleMenuKeyUp(e);
    this.on(this.menuButton_, "tap", handleClick);
    this.on(this.menuButton_, "click", handleClick);
    this.on(this.menuButton_, "keydown", (e) => this.handleKeyDown(e));
    this.on(this.menuButton_, "mouseenter", () => {
      this.addClass("vjs-hover");
      this.menu.show();
      on(document_1, "keyup", this.handleMenuKeyUp_);
    });
    this.on("mouseleave", (e) => this.handleMouseLeave(e));
    this.on("keydown", (e) => this.handleSubmenuKeyDown(e));
  }
  update() {
    const menu = this.createMenu();
    if (this.menu) {
      this.menu.dispose();
      this.removeChild(this.menu);
    }
    this.menu = menu;
    this.addChild(menu);
    this.buttonPressed_ = false;
    this.menuButton_.el_.setAttribute("aria-expanded", "false");
    if (this.items && this.items.length <= this.hideThreshold_) {
      this.hide();
      this.menu.contentEl_.removeAttribute("role");
    } else {
      this.show();
      this.menu.contentEl_.setAttribute("role", "menu");
    }
  }
  createMenu() {
    const menu = new Menu(this.player_, {
      menuButton: this
    });
    this.hideThreshold_ = 0;
    if (this.options_.title) {
      const titleEl = createEl("li", {
        className: "vjs-menu-title",
        textContent: toTitleCase$1(this.options_.title),
        tabIndex: -1
      });
      const titleComponent = new Component$1(this.player_, {
        el: titleEl
      });
      menu.addItem(titleComponent);
    }
    this.items = this.createItems();
    if (this.items) {
      for (let i = 0; i < this.items.length; i++) {
        menu.addItem(this.items[i]);
      }
    }
    return menu;
  }
  createItems() {
  }
  createEl() {
    return super.createEl("div", {
      className: this.buildWrapperCSSClass()
    }, {});
  }
  setIcon(name) {
    super.setIcon(name, this.menuButton_.el_);
  }
  buildWrapperCSSClass() {
    let menuButtonClass = "vjs-menu-button";
    if (this.options_.inline === true) {
      menuButtonClass += "-inline";
    } else {
      menuButtonClass += "-popup";
    }
    const buttonClass = Button.prototype.buildCSSClass();
    return `vjs-menu-button ${menuButtonClass} ${buttonClass} ${super.buildCSSClass()}`;
  }
  buildCSSClass() {
    let menuButtonClass = "vjs-menu-button";
    if (this.options_.inline === true) {
      menuButtonClass += "-inline";
    } else {
      menuButtonClass += "-popup";
    }
    return `vjs-menu-button ${menuButtonClass} ${super.buildCSSClass()}`;
  }
  controlText(text, el = this.menuButton_.el()) {
    return this.menuButton_.controlText(text, el);
  }
  dispose() {
    this.handleMouseLeave();
    super.dispose();
  }
  handleClick(event) {
    if (this.buttonPressed_) {
      this.unpressButton();
    } else {
      this.pressButton();
    }
  }
  handleMouseLeave(event) {
    this.removeClass("vjs-hover");
    off(document_1, "keyup", this.handleMenuKeyUp_);
  }
  focus() {
    this.menuButton_.focus();
  }
  blur() {
    this.menuButton_.blur();
  }
  handleKeyDown(event) {
    if (event.key === "Escape" || event.key === "Tab") {
      if (this.buttonPressed_) {
        this.unpressButton();
      }
      if (!event.key === "Tab") {
        event.preventDefault();
        this.menuButton_.focus();
      }
    } else if (event.key === "Up" || event.key === "Down" && !(this.player_.options_.playerOptions.spatialNavigation && this.player_.options_.playerOptions.spatialNavigation.enabled)) {
      if (!this.buttonPressed_) {
        event.preventDefault();
        this.pressButton();
      }
    }
  }
  handleMenuKeyUp(event) {
    if (event.key === "Escape" || event.key === "Tab") {
      this.removeClass("vjs-hover");
    }
  }
  handleSubmenuKeyPress(event) {
    this.handleSubmenuKeyDown(event);
  }
  handleSubmenuKeyDown(event) {
    if (event.key === "Escape" || event.key === "Tab") {
      if (this.buttonPressed_) {
        this.unpressButton();
      }
      if (!event.key === "Tab") {
        event.preventDefault();
        this.menuButton_.focus();
      }
    }
  }
  pressButton() {
    if (this.enabled_) {
      this.buttonPressed_ = true;
      this.menu.show();
      this.menu.lockShowing();
      this.menuButton_.el_.setAttribute("aria-expanded", "true");
      if (IS_IOS && isInFrame()) {
        return;
      }
      this.menu.focus();
    }
  }
  unpressButton() {
    if (this.enabled_) {
      this.buttonPressed_ = false;
      this.menu.unlockShowing();
      this.menu.hide();
      this.menuButton_.el_.setAttribute("aria-expanded", "false");
    }
  }
  disable() {
    this.unpressButton();
    this.enabled_ = false;
    this.addClass("vjs-disabled");
    this.menuButton_.disable();
  }
  enable() {
    this.enabled_ = true;
    this.removeClass("vjs-disabled");
    this.menuButton_.enable();
  }
}
Component$1.registerComponent("MenuButton", MenuButton);
class TrackButton extends MenuButton {
  constructor(player, options) {
    const tracks = options.tracks;
    super(player, options);
    if (this.items.length <= 1) {
      this.hide();
    }
    if (!tracks) {
      return;
    }
    const updateHandler = bind_(this, this.update);
    tracks.addEventListener("removetrack", updateHandler);
    tracks.addEventListener("addtrack", updateHandler);
    tracks.addEventListener("labelchange", updateHandler);
    this.player_.on("ready", updateHandler);
    this.player_.on("dispose", function() {
      tracks.removeEventListener("removetrack", updateHandler);
      tracks.removeEventListener("addtrack", updateHandler);
      tracks.removeEventListener("labelchange", updateHandler);
    });
  }
}
Component$1.registerComponent("TrackButton", TrackButton);
class MenuItem extends ClickableComponent {
  constructor(player, options) {
    super(player, options);
    this.selectable = options.selectable;
    this.isSelected_ = options.selected || false;
    this.multiSelectable = options.multiSelectable;
    this.selected(this.isSelected_);
    if (this.selectable) {
      if (this.multiSelectable) {
        this.el_.setAttribute("role", "menuitemcheckbox");
      } else {
        this.el_.setAttribute("role", "menuitemradio");
      }
    } else {
      this.el_.setAttribute("role", "menuitem");
    }
  }
  createEl(type, props, attrs) {
    this.nonIconControl = true;
    const el = super.createEl("li", Object.assign({
      className: "vjs-menu-item",
      tabIndex: -1
    }, props), attrs);
    const menuItemEl = createEl("span", {
      className: "vjs-menu-item-text",
      textContent: this.localize(this.options_.label)
    });
    if (this.player_.options_.experimentalSvgIcons) {
      el.appendChild(menuItemEl);
    } else {
      el.replaceChild(menuItemEl, el.querySelector(".vjs-icon-placeholder"));
    }
    return el;
  }
  handleKeyDown(event) {
    if (!["Tab", "Escape", "ArrowUp", "ArrowLeft", "ArrowRight", "ArrowDown"].includes(event.key)) {
      super.handleKeyDown(event);
    }
  }
  handleClick(event) {
    this.selected(true);
  }
  selected(selected) {
    if (this.selectable) {
      if (selected) {
        this.addClass("vjs-selected");
        this.el_.setAttribute("aria-checked", "true");
        this.controlText(", selected");
        this.isSelected_ = true;
      } else {
        this.removeClass("vjs-selected");
        this.el_.setAttribute("aria-checked", "false");
        this.controlText("");
        this.isSelected_ = false;
      }
    }
  }
}
Component$1.registerComponent("MenuItem", MenuItem);
class TextTrackMenuItem extends MenuItem {
  constructor(player, options) {
    const track = options.track;
    const tracks = player.textTracks();
    options.label = track.label || track.language || "Unknown";
    options.selected = track.mode === "showing";
    super(player, options);
    this.track = track;
    this.kinds = (options.kinds || [options.kind || this.track.kind]).filter(Boolean);
    const changeHandler = (...args) => {
      this.handleTracksChange.apply(this, args);
    };
    const selectedLanguageChangeHandler = (...args) => {
      this.handleSelectedLanguageChange.apply(this, args);
    };
    player.on(["loadstart", "texttrackchange"], changeHandler);
    tracks.addEventListener("change", changeHandler);
    tracks.addEventListener("selectedlanguagechange", selectedLanguageChangeHandler);
    this.on("dispose", function() {
      player.off(["loadstart", "texttrackchange"], changeHandler);
      tracks.removeEventListener("change", changeHandler);
      tracks.removeEventListener("selectedlanguagechange", selectedLanguageChangeHandler);
    });
    if (tracks.onchange === void 0) {
      let event;
      this.on(["tap", "click"], function() {
        if (typeof window_1.Event !== "object") {
          try {
            event = new window_1.Event("change");
          } catch (err) {
          }
        }
        if (!event) {
          event = document_1.createEvent("Event");
          event.initEvent("change", true, true);
        }
        tracks.dispatchEvent(event);
      });
    }
    this.handleTracksChange();
  }
  handleClick(event) {
    const referenceTrack = this.track;
    const tracks = this.player_.textTracks();
    super.handleClick(event);
    if (!tracks) {
      return;
    }
    for (let i = 0; i < tracks.length; i++) {
      const track = tracks[i];
      if (this.kinds.indexOf(track.kind) === -1) {
        continue;
      }
      if (track === referenceTrack) {
        if (track.mode !== "showing") {
          track.mode = "showing";
        }
      } else if (track.mode !== "disabled") {
        track.mode = "disabled";
      }
    }
  }
  handleTracksChange(event) {
    const shouldBeSelected = this.track.mode === "showing";
    if (shouldBeSelected !== this.isSelected_) {
      this.selected(shouldBeSelected);
    }
  }
  handleSelectedLanguageChange(event) {
    if (this.track.mode === "showing") {
      const selectedLanguage = this.player_.cache_.selectedLanguage;
      if (selectedLanguage && selectedLanguage.enabled && selectedLanguage.language === this.track.language && selectedLanguage.kind !== this.track.kind) {
        return;
      }
      this.player_.cache_.selectedLanguage = {
        enabled: true,
        language: this.track.language,
        kind: this.track.kind
      };
    }
  }
  dispose() {
    this.track = null;
    super.dispose();
  }
}
Component$1.registerComponent("TextTrackMenuItem", TextTrackMenuItem);
class OffTextTrackMenuItem extends TextTrackMenuItem {
  constructor(player, options) {
    options.track = {
      player,
      kind: options.kind,
      kinds: options.kinds,
      default: false,
      mode: "disabled"
    };
    if (!options.kinds) {
      options.kinds = [options.kind];
    }
    if (options.label) {
      options.track.label = options.label;
    } else {
      options.track.label = options.kinds.join(" and ") + " off";
    }
    options.selectable = true;
    options.multiSelectable = false;
    super(player, options);
  }
  handleTracksChange(event) {
    const tracks = this.player().textTracks();
    let shouldBeSelected = true;
    for (let i = 0, l = tracks.length; i < l; i++) {
      const track = tracks[i];
      if (this.options_.kinds.indexOf(track.kind) > -1 && track.mode === "showing") {
        shouldBeSelected = false;
        break;
      }
    }
    if (shouldBeSelected !== this.isSelected_) {
      this.selected(shouldBeSelected);
    }
  }
  handleSelectedLanguageChange(event) {
    const tracks = this.player().textTracks();
    let allHidden = true;
    for (let i = 0, l = tracks.length; i < l; i++) {
      const track = tracks[i];
      if (["captions", "descriptions", "subtitles"].indexOf(track.kind) > -1 && track.mode === "showing") {
        allHidden = false;
        break;
      }
    }
    if (allHidden) {
      this.player_.cache_.selectedLanguage = {
        enabled: false
      };
    }
  }
  handleLanguagechange() {
    this.$(".vjs-menu-item-text").textContent = this.player_.localize(this.options_.label);
    super.handleLanguagechange();
  }
}
Component$1.registerComponent("OffTextTrackMenuItem", OffTextTrackMenuItem);
class TextTrackButton extends TrackButton {
  constructor(player, options = {}) {
    options.tracks = player.textTracks();
    super(player, options);
  }
  createItems(items = [], TrackMenuItem = TextTrackMenuItem) {
    let label;
    if (this.label_) {
      label = `${this.label_} off`;
    }
    items.push(new OffTextTrackMenuItem(this.player_, {
      kinds: this.kinds_,
      kind: this.kind_,
      label
    }));
    this.hideThreshold_ += 1;
    const tracks = this.player_.textTracks();
    if (!Array.isArray(this.kinds_)) {
      this.kinds_ = [this.kind_];
    }
    for (let i = 0; i < tracks.length; i++) {
      const track = tracks[i];
      if (this.kinds_.indexOf(track.kind) > -1) {
        const item = new TrackMenuItem(this.player_, {
          track,
          kinds: this.kinds_,
          kind: this.kind_,
          selectable: true,
          multiSelectable: false
        });
        item.addClass(`vjs-${track.kind}-menu-item`);
        items.push(item);
      }
    }
    return items;
  }
}
Component$1.registerComponent("TextTrackButton", TextTrackButton);
class ChaptersTrackMenuItem extends MenuItem {
  constructor(player, options) {
    const track = options.track;
    const cue = options.cue;
    const currentTime = player.currentTime();
    options.selectable = true;
    options.multiSelectable = false;
    options.label = cue.text;
    options.selected = cue.startTime <= currentTime && currentTime < cue.endTime;
    super(player, options);
    this.track = track;
    this.cue = cue;
  }
  handleClick(event) {
    super.handleClick();
    this.player_.currentTime(this.cue.startTime);
  }
}
Component$1.registerComponent("ChaptersTrackMenuItem", ChaptersTrackMenuItem);
class ChaptersButton extends TextTrackButton {
  constructor(player, options, ready) {
    super(player, options, ready);
    this.setIcon("chapters");
    this.selectCurrentItem_ = () => {
      this.items.forEach((item) => {
        item.selected(this.track_.activeCues[0] === item.cue);
      });
    };
  }
  buildCSSClass() {
    return `vjs-chapters-button ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-chapters-button ${super.buildWrapperCSSClass()}`;
  }
  update(event) {
    if (event && event.track && event.track.kind !== "chapters") {
      return;
    }
    const track = this.findChaptersTrack();
    if (track !== this.track_) {
      this.setTrack(track);
      super.update();
    } else if (!this.items || track && track.cues && track.cues.length !== this.items.length) {
      super.update();
    }
  }
  setTrack(track) {
    if (this.track_ === track) {
      return;
    }
    if (!this.updateHandler_) {
      this.updateHandler_ = this.update.bind(this);
    }
    if (this.track_) {
      const remoteTextTrackEl = this.player_.remoteTextTrackEls().getTrackElementByTrack_(this.track_);
      if (remoteTextTrackEl) {
        remoteTextTrackEl.removeEventListener("load", this.updateHandler_);
      }
      this.track_.removeEventListener("cuechange", this.selectCurrentItem_);
      this.track_ = null;
    }
    this.track_ = track;
    if (this.track_) {
      this.track_.mode = "hidden";
      const remoteTextTrackEl = this.player_.remoteTextTrackEls().getTrackElementByTrack_(this.track_);
      if (remoteTextTrackEl) {
        remoteTextTrackEl.addEventListener("load", this.updateHandler_);
      }
      this.track_.addEventListener("cuechange", this.selectCurrentItem_);
    }
  }
  findChaptersTrack() {
    const tracks = this.player_.textTracks() || [];
    for (let i = tracks.length - 1; i >= 0; i--) {
      const track = tracks[i];
      if (track.kind === this.kind_) {
        return track;
      }
    }
  }
  getMenuCaption() {
    if (this.track_ && this.track_.label) {
      return this.track_.label;
    }
    return this.localize(toTitleCase$1(this.kind_));
  }
  createMenu() {
    this.options_.title = this.getMenuCaption();
    return super.createMenu();
  }
  createItems() {
    const items = [];
    if (!this.track_) {
      return items;
    }
    const cues = this.track_.cues;
    if (!cues) {
      return items;
    }
    for (let i = 0, l = cues.length; i < l; i++) {
      const cue = cues[i];
      const mi = new ChaptersTrackMenuItem(this.player_, {
        track: this.track_,
        cue
      });
      items.push(mi);
    }
    return items;
  }
}
ChaptersButton.prototype.kind_ = "chapters";
ChaptersButton.prototype.controlText_ = "Chapters";
Component$1.registerComponent("ChaptersButton", ChaptersButton);
class DescriptionsButton extends TextTrackButton {
  constructor(player, options, ready) {
    super(player, options, ready);
    this.setIcon("audio-description");
    const tracks = player.textTracks();
    const changeHandler = bind_(this, this.handleTracksChange);
    tracks.addEventListener("change", changeHandler);
    this.on("dispose", function() {
      tracks.removeEventListener("change", changeHandler);
    });
  }
  handleTracksChange(event) {
    const tracks = this.player().textTracks();
    let disabled = false;
    for (let i = 0, l = tracks.length; i < l; i++) {
      const track = tracks[i];
      if (track.kind !== this.kind_ && track.mode === "showing") {
        disabled = true;
        break;
      }
    }
    if (disabled) {
      this.disable();
    } else {
      this.enable();
    }
  }
  buildCSSClass() {
    return `vjs-descriptions-button ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-descriptions-button ${super.buildWrapperCSSClass()}`;
  }
}
DescriptionsButton.prototype.kind_ = "descriptions";
DescriptionsButton.prototype.controlText_ = "Descriptions";
Component$1.registerComponent("DescriptionsButton", DescriptionsButton);
class SubtitlesButton extends TextTrackButton {
  constructor(player, options, ready) {
    super(player, options, ready);
    this.setIcon("subtitles");
  }
  buildCSSClass() {
    return `vjs-subtitles-button ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-subtitles-button ${super.buildWrapperCSSClass()}`;
  }
}
SubtitlesButton.prototype.kind_ = "subtitles";
SubtitlesButton.prototype.controlText_ = "Subtitles";
Component$1.registerComponent("SubtitlesButton", SubtitlesButton);
class CaptionSettingsMenuItem extends TextTrackMenuItem {
  constructor(player, options) {
    options.track = {
      player,
      kind: options.kind,
      label: options.kind + " settings",
      selectable: false,
      default: false,
      mode: "disabled"
    };
    options.selectable = false;
    options.name = "CaptionSettingsMenuItem";
    super(player, options);
    this.addClass("vjs-texttrack-settings");
    this.controlText(", opens " + options.kind + " settings dialog");
  }
  handleClick(event) {
    this.player().getChild("textTrackSettings").open();
  }
  handleLanguagechange() {
    this.$(".vjs-menu-item-text").textContent = this.player_.localize(this.options_.kind + " settings");
    super.handleLanguagechange();
  }
}
Component$1.registerComponent("CaptionSettingsMenuItem", CaptionSettingsMenuItem);
class CaptionsButton extends TextTrackButton {
  constructor(player, options, ready) {
    super(player, options, ready);
    this.setIcon("captions");
  }
  buildCSSClass() {
    return `vjs-captions-button ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-captions-button ${super.buildWrapperCSSClass()}`;
  }
  createItems() {
    const items = [];
    if (!(this.player().tech_ && this.player().tech_.featuresNativeTextTracks) && this.player().getChild("textTrackSettings")) {
      items.push(new CaptionSettingsMenuItem(this.player_, {
        kind: this.kind_
      }));
      this.hideThreshold_ += 1;
    }
    return super.createItems(items);
  }
}
CaptionsButton.prototype.kind_ = "captions";
CaptionsButton.prototype.controlText_ = "Captions";
Component$1.registerComponent("CaptionsButton", CaptionsButton);
class SubsCapsMenuItem extends TextTrackMenuItem {
  createEl(type, props, attrs) {
    const el = super.createEl(type, props, attrs);
    const parentSpan = el.querySelector(".vjs-menu-item-text");
    if (this.options_.track.kind === "captions") {
      if (this.player_.options_.experimentalSvgIcons) {
        this.setIcon("captions", el);
      } else {
        parentSpan.appendChild(createEl("span", {
          className: "vjs-icon-placeholder"
        }, {
          "aria-hidden": true
        }));
      }
      parentSpan.appendChild(createEl("span", {
        className: "vjs-control-text",
        textContent: ` ${this.localize("Captions")}`
      }));
    }
    return el;
  }
}
Component$1.registerComponent("SubsCapsMenuItem", SubsCapsMenuItem);
class SubsCapsButton extends TextTrackButton {
  constructor(player, options = {}) {
    super(player, options);
    this.label_ = "subtitles";
    this.setIcon("subtitles");
    if (["en", "en-us", "en-ca", "fr-ca"].indexOf(this.player_.language_) > -1) {
      this.label_ = "captions";
      this.setIcon("captions");
    }
    this.menuButton_.controlText(toTitleCase$1(this.label_));
  }
  buildCSSClass() {
    return `vjs-subs-caps-button ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-subs-caps-button ${super.buildWrapperCSSClass()}`;
  }
  createItems() {
    let items = [];
    if (!(this.player().tech_ && this.player().tech_.featuresNativeTextTracks) && this.player().getChild("textTrackSettings")) {
      items.push(new CaptionSettingsMenuItem(this.player_, {
        kind: this.label_
      }));
      this.hideThreshold_ += 1;
    }
    items = super.createItems(items, SubsCapsMenuItem);
    return items;
  }
}
SubsCapsButton.prototype.kinds_ = ["captions", "subtitles"];
SubsCapsButton.prototype.controlText_ = "Subtitles";
Component$1.registerComponent("SubsCapsButton", SubsCapsButton);
class AudioTrackMenuItem extends MenuItem {
  constructor(player, options) {
    const track = options.track;
    const tracks = player.audioTracks();
    options.label = track.label || track.language || "Unknown";
    options.selected = track.enabled;
    super(player, options);
    this.track = track;
    this.addClass(`vjs-${track.kind}-menu-item`);
    const changeHandler = (...args) => {
      this.handleTracksChange.apply(this, args);
    };
    tracks.addEventListener("change", changeHandler);
    this.on("dispose", () => {
      tracks.removeEventListener("change", changeHandler);
    });
  }
  createEl(type, props, attrs) {
    const el = super.createEl(type, props, attrs);
    const parentSpan = el.querySelector(".vjs-menu-item-text");
    if (["main-desc", "descriptions"].indexOf(this.options_.track.kind) >= 0) {
      parentSpan.appendChild(createEl("span", {
        className: "vjs-icon-placeholder"
      }, {
        "aria-hidden": true
      }));
      parentSpan.appendChild(createEl("span", {
        className: "vjs-control-text",
        textContent: " " + this.localize("Descriptions")
      }));
    }
    return el;
  }
  handleClick(event) {
    super.handleClick(event);
    this.track.enabled = true;
    if (this.player_.tech_.featuresNativeAudioTracks) {
      const tracks = this.player_.audioTracks();
      for (let i = 0; i < tracks.length; i++) {
        const track = tracks[i];
        if (track === this.track) {
          continue;
        }
        track.enabled = track === this.track;
      }
    }
  }
  handleTracksChange(event) {
    this.selected(this.track.enabled);
  }
}
Component$1.registerComponent("AudioTrackMenuItem", AudioTrackMenuItem);
class AudioTrackButton extends TrackButton {
  constructor(player, options = {}) {
    options.tracks = player.audioTracks();
    super(player, options);
    this.setIcon("audio");
  }
  buildCSSClass() {
    return `vjs-audio-button ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-audio-button ${super.buildWrapperCSSClass()}`;
  }
  createItems(items = []) {
    this.hideThreshold_ = 1;
    const tracks = this.player_.audioTracks();
    for (let i = 0; i < tracks.length; i++) {
      const track = tracks[i];
      items.push(new AudioTrackMenuItem(this.player_, {
        track,
        selectable: true,
        multiSelectable: false
      }));
    }
    return items;
  }
}
AudioTrackButton.prototype.controlText_ = "Audio Track";
Component$1.registerComponent("AudioTrackButton", AudioTrackButton);
class PlaybackRateMenuItem extends MenuItem {
  constructor(player, options) {
    const label = options.rate;
    const rate = parseFloat(label, 10);
    options.label = label;
    options.selected = rate === player.playbackRate();
    options.selectable = true;
    options.multiSelectable = false;
    super(player, options);
    this.label = label;
    this.rate = rate;
    this.on(player, "ratechange", (e) => this.update(e));
  }
  handleClick(event) {
    super.handleClick();
    this.player().playbackRate(this.rate);
  }
  update(event) {
    this.selected(this.player().playbackRate() === this.rate);
  }
}
PlaybackRateMenuItem.prototype.contentElType = "button";
Component$1.registerComponent("PlaybackRateMenuItem", PlaybackRateMenuItem);
class PlaybackRateMenuButton extends MenuButton {
  constructor(player, options) {
    super(player, options);
    this.menuButton_.el_.setAttribute("aria-describedby", this.labelElId_);
    this.updateVisibility();
    this.updateLabel();
    this.on(player, "loadstart", (e) => this.updateVisibility(e));
    this.on(player, "ratechange", (e) => this.updateLabel(e));
    this.on(player, "playbackrateschange", (e) => this.handlePlaybackRateschange(e));
  }
  createEl() {
    const el = super.createEl();
    this.labelElId_ = "vjs-playback-rate-value-label-" + this.id_;
    this.labelEl_ = createEl("div", {
      className: "vjs-playback-rate-value",
      id: this.labelElId_,
      textContent: "1x"
    });
    el.appendChild(this.labelEl_);
    return el;
  }
  dispose() {
    this.labelEl_ = null;
    super.dispose();
  }
  buildCSSClass() {
    return `vjs-playback-rate ${super.buildCSSClass()}`;
  }
  buildWrapperCSSClass() {
    return `vjs-playback-rate ${super.buildWrapperCSSClass()}`;
  }
  createItems() {
    const rates = this.playbackRates();
    const items = [];
    for (let i = rates.length - 1; i >= 0; i--) {
      items.push(new PlaybackRateMenuItem(this.player(), {
        rate: rates[i] + "x"
      }));
    }
    return items;
  }
  handlePlaybackRateschange(event) {
    this.update();
  }
  playbackRates() {
    const player = this.player();
    return player.playbackRates && player.playbackRates() || [];
  }
  playbackRateSupported() {
    return this.player().tech_ && this.player().tech_.featuresPlaybackRate && this.playbackRates() && this.playbackRates().length > 0;
  }
  updateVisibility(event) {
    if (this.playbackRateSupported()) {
      this.removeClass("vjs-hidden");
    } else {
      this.addClass("vjs-hidden");
    }
  }
  updateLabel(event) {
    if (this.playbackRateSupported()) {
      this.labelEl_.textContent = this.player().playbackRate() + "x";
    }
  }
}
PlaybackRateMenuButton.prototype.controlText_ = "Playback Rate";
Component$1.registerComponent("PlaybackRateMenuButton", PlaybackRateMenuButton);
class Spacer extends Component$1 {
  buildCSSClass() {
    return `vjs-spacer ${super.buildCSSClass()}`;
  }
  createEl(tag = "div", props = {}, attributes = {}) {
    if (!props.className) {
      props.className = this.buildCSSClass();
    }
    return super.createEl(tag, props, attributes);
  }
}
Component$1.registerComponent("Spacer", Spacer);
class CustomControlSpacer extends Spacer {
  buildCSSClass() {
    return `vjs-custom-control-spacer ${super.buildCSSClass()}`;
  }
  createEl() {
    return super.createEl("div", {
      className: this.buildCSSClass(),
      textContent: "\xA0"
    });
  }
}
Component$1.registerComponent("CustomControlSpacer", CustomControlSpacer);
class ControlBar extends Component$1 {
  createEl() {
    return super.createEl("div", {
      className: "vjs-control-bar",
      dir: "ltr"
    });
  }
}
ControlBar.prototype.options_ = {
  children: ["playToggle", "skipBackward", "skipForward", "volumePanel", "currentTimeDisplay", "timeDivider", "durationDisplay", "progressControl", "liveDisplay", "seekToLive", "remainingTimeDisplay", "customControlSpacer", "playbackRateMenuButton", "chaptersButton", "descriptionsButton", "subsCapsButton", "audioTrackButton", "pictureInPictureToggle", "fullscreenToggle"]
};
Component$1.registerComponent("ControlBar", ControlBar);
class ErrorDisplay extends ModalDialog {
  constructor(player, options) {
    super(player, options);
    this.on(player, "error", (e) => {
      this.open(e);
    });
  }
  buildCSSClass() {
    return `vjs-error-display ${super.buildCSSClass()}`;
  }
  content() {
    const error = this.player().error();
    return error ? this.localize(error.message) : "";
  }
}
ErrorDisplay.prototype.options_ = Object.assign({}, ModalDialog.prototype.options_, {
  pauseOnOpen: false,
  fillAlways: true,
  temporary: false,
  uncloseable: true
});
Component$1.registerComponent("ErrorDisplay", ErrorDisplay);
class TextTrackSelect extends Component$1 {
  constructor(player, options = {}) {
    super(player, options);
    this.el_.setAttribute("aria-labelledby", this.selectLabelledbyIds);
  }
  createEl() {
    this.selectLabelledbyIds = [this.options_.legendId, this.options_.labelId].join(" ").trim();
    const selectoptions = createEl("select", {
      id: this.options_.id
    }, {}, this.options_.SelectOptions.map((optionText) => {
      const optionId = (this.options_.labelId ? this.options_.labelId : `vjs-track-option-${newGUID()}`) + "-" + optionText[1].replace(/\W+/g, "");
      const option = createEl("option", {
        id: optionId,
        value: this.localize(optionText[0]),
        textContent: this.localize(optionText[1])
      });
      option.setAttribute("aria-labelledby", `${this.selectLabelledbyIds} ${optionId}`);
      return option;
    }));
    return selectoptions;
  }
}
Component$1.registerComponent("TextTrackSelect", TextTrackSelect);
class TextTrackFieldset extends Component$1 {
  constructor(player, options = {}) {
    super(player, options);
    const legendElement = createEl("legend", {
      textContent: this.localize(this.options_.legendText),
      id: this.options_.legendId
    });
    this.el().appendChild(legendElement);
    const selects = this.options_.selects;
    for (const i of selects) {
      const selectConfig = this.options_.selectConfigs[i];
      const selectClassName = selectConfig.className;
      const id = selectConfig.id.replace("%s", this.options_.id_);
      let span = null;
      const guid = `vjs_select_${newGUID()}`;
      if (this.options_.type === "colors") {
        span = createEl("span", {
          className: selectClassName
        });
        const label = createEl("label", {
          id,
          className: "vjs-label",
          textContent: this.localize(selectConfig.label)
        });
        label.setAttribute("for", guid);
        span.appendChild(label);
      }
      const textTrackSelect = new TextTrackSelect(player, {
        SelectOptions: selectConfig.options,
        legendId: this.options_.legendId,
        id: guid,
        labelId: id
      });
      this.addChild(textTrackSelect);
      if (this.options_.type === "colors") {
        span.appendChild(textTrackSelect.el());
        this.el().appendChild(span);
      }
    }
  }
  createEl() {
    const el = createEl("fieldset", {
      className: this.options_.className
    });
    return el;
  }
}
Component$1.registerComponent("TextTrackFieldset", TextTrackFieldset);
class TextTrackSettingsColors extends Component$1 {
  constructor(player, options = {}) {
    super(player, options);
    const id_ = this.options_.textTrackComponentid;
    const ElFgColorFieldset = new TextTrackFieldset(player, {
      id_,
      legendId: `captions-text-legend-${id_}`,
      legendText: this.localize("Text"),
      className: "vjs-fg vjs-track-setting",
      selects: this.options_.fieldSets[0],
      selectConfigs: this.options_.selectConfigs,
      type: "colors"
    });
    this.addChild(ElFgColorFieldset);
    const ElBgColorFieldset = new TextTrackFieldset(player, {
      id_,
      legendId: `captions-background-${id_}`,
      legendText: this.localize("Text Background"),
      className: "vjs-bg vjs-track-setting",
      selects: this.options_.fieldSets[1],
      selectConfigs: this.options_.selectConfigs,
      type: "colors"
    });
    this.addChild(ElBgColorFieldset);
    const ElWinColorFieldset = new TextTrackFieldset(player, {
      id_,
      legendId: `captions-window-${id_}`,
      legendText: this.localize("Caption Area Background"),
      className: "vjs-window vjs-track-setting",
      selects: this.options_.fieldSets[2],
      selectConfigs: this.options_.selectConfigs,
      type: "colors"
    });
    this.addChild(ElWinColorFieldset);
  }
  createEl() {
    const el = createEl("div", {
      className: "vjs-track-settings-colors"
    });
    return el;
  }
}
Component$1.registerComponent("TextTrackSettingsColors", TextTrackSettingsColors);
class TextTrackSettingsFont extends Component$1 {
  constructor(player, options = {}) {
    super(player, options);
    const id_ = this.options_.textTrackComponentid;
    const ElFgColorFieldset = new TextTrackFieldset(player, {
      id_,
      legendId: `captions-font-size-${id_}`,
      legendText: "Font Size",
      className: "vjs-font-percent vjs-track-setting",
      selects: this.options_.fieldSets[0],
      selectConfigs: this.options_.selectConfigs,
      type: "font"
    });
    this.addChild(ElFgColorFieldset);
    const ElBgColorFieldset = new TextTrackFieldset(player, {
      id_,
      legendId: `captions-edge-style-${id_}`,
      legendText: this.localize("Text Edge Style"),
      className: "vjs-edge-style vjs-track-setting",
      selects: this.options_.fieldSets[1],
      selectConfigs: this.options_.selectConfigs,
      type: "font"
    });
    this.addChild(ElBgColorFieldset);
    const ElWinColorFieldset = new TextTrackFieldset(player, {
      id_,
      legendId: `captions-font-family-${id_}`,
      legendText: this.localize("Font Family"),
      className: "vjs-font-family vjs-track-setting",
      selects: this.options_.fieldSets[2],
      selectConfigs: this.options_.selectConfigs,
      type: "font"
    });
    this.addChild(ElWinColorFieldset);
  }
  createEl() {
    const el = createEl("div", {
      className: "vjs-track-settings-font"
    });
    return el;
  }
}
Component$1.registerComponent("TextTrackSettingsFont", TextTrackSettingsFont);
class TrackSettingsControls extends Component$1 {
  constructor(player, options = {}) {
    super(player, options);
    const resetButton = new Button(player, {
      controlText: this.localize("restore all settings to the default values"),
      className: "vjs-default-button"
    });
    resetButton.el().classList.remove("vjs-control", "vjs-button");
    resetButton.el().textContent = this.localize("Reset");
    this.addChild(resetButton);
    const doneText = this.localize("Done");
    const doneButton = new Button(player, {
      controlText: doneText,
      className: "vjs-done-button"
    });
    doneButton.el().classList.remove("vjs-control", "vjs-button");
    doneButton.el().textContent = doneText;
    this.addChild(doneButton);
  }
  createEl() {
    const el = createEl("div", {
      className: "vjs-track-settings-controls"
    });
    return el;
  }
}
Component$1.registerComponent("TrackSettingsControls", TrackSettingsControls);
const LOCAL_STORAGE_KEY$1 = "vjs-text-track-settings";
const COLOR_BLACK = ["#000", "Black"];
const COLOR_BLUE = ["#00F", "Blue"];
const COLOR_CYAN = ["#0FF", "Cyan"];
const COLOR_GREEN = ["#0F0", "Green"];
const COLOR_MAGENTA = ["#F0F", "Magenta"];
const COLOR_RED = ["#F00", "Red"];
const COLOR_WHITE = ["#FFF", "White"];
const COLOR_YELLOW = ["#FF0", "Yellow"];
const OPACITY_OPAQUE = ["1", "Opaque"];
const OPACITY_SEMI = ["0.5", "Semi-Transparent"];
const OPACITY_TRANS = ["0", "Transparent"];
const selectConfigs = {
  backgroundColor: {
    selector: ".vjs-bg-color > select",
    id: "captions-background-color-%s",
    label: "Color",
    options: [COLOR_BLACK, COLOR_WHITE, COLOR_RED, COLOR_GREEN, COLOR_BLUE, COLOR_YELLOW, COLOR_MAGENTA, COLOR_CYAN],
    className: "vjs-bg-color"
  },
  backgroundOpacity: {
    selector: ".vjs-bg-opacity > select",
    id: "captions-background-opacity-%s",
    label: "Opacity",
    options: [OPACITY_OPAQUE, OPACITY_SEMI, OPACITY_TRANS],
    className: "vjs-bg-opacity vjs-opacity"
  },
  color: {
    selector: ".vjs-text-color > select",
    id: "captions-foreground-color-%s",
    label: "Color",
    options: [COLOR_WHITE, COLOR_BLACK, COLOR_RED, COLOR_GREEN, COLOR_BLUE, COLOR_YELLOW, COLOR_MAGENTA, COLOR_CYAN],
    className: "vjs-text-color"
  },
  edgeStyle: {
    selector: ".vjs-edge-style > select",
    id: "",
    label: "Text Edge Style",
    options: [["none", "None"], ["raised", "Raised"], ["depressed", "Depressed"], ["uniform", "Uniform"], ["dropshadow", "Drop shadow"]]
  },
  fontFamily: {
    selector: ".vjs-font-family > select",
    id: "",
    label: "Font Family",
    options: [["proportionalSansSerif", "Proportional Sans-Serif"], ["monospaceSansSerif", "Monospace Sans-Serif"], ["proportionalSerif", "Proportional Serif"], ["monospaceSerif", "Monospace Serif"], ["casual", "Casual"], ["script", "Script"], ["small-caps", "Small Caps"]]
  },
  fontPercent: {
    selector: ".vjs-font-percent > select",
    id: "",
    label: "Font Size",
    options: [["0.50", "50%"], ["0.75", "75%"], ["1.00", "100%"], ["1.25", "125%"], ["1.50", "150%"], ["1.75", "175%"], ["2.00", "200%"], ["3.00", "300%"], ["4.00", "400%"]],
    default: 2,
    parser: (v) => v === "1.00" ? null : Number(v)
  },
  textOpacity: {
    selector: ".vjs-text-opacity > select",
    id: "captions-foreground-opacity-%s",
    label: "Opacity",
    options: [OPACITY_OPAQUE, OPACITY_SEMI],
    className: "vjs-text-opacity vjs-opacity"
  },
  windowColor: {
    selector: ".vjs-window-color > select",
    id: "captions-window-color-%s",
    label: "Color",
    className: "vjs-window-color"
  },
  windowOpacity: {
    selector: ".vjs-window-opacity > select",
    id: "captions-window-opacity-%s",
    label: "Opacity",
    options: [OPACITY_TRANS, OPACITY_SEMI, OPACITY_OPAQUE],
    className: "vjs-window-opacity vjs-opacity"
  }
};
selectConfigs.windowColor.options = selectConfigs.backgroundColor.options;
function parseOptionValue(value, parser) {
  if (parser) {
    value = parser(value);
  }
  if (value && value !== "none") {
    return value;
  }
}
function getSelectedOptionValue(el, parser) {
  const value = el.options[el.options.selectedIndex].value;
  return parseOptionValue(value, parser);
}
function setSelectedOption(el, value, parser) {
  if (!value) {
    return;
  }
  for (let i = 0; i < el.options.length; i++) {
    if (parseOptionValue(el.options[i].value, parser) === value) {
      el.selectedIndex = i;
      break;
    }
  }
}
class TextTrackSettings extends ModalDialog {
  constructor(player, options) {
    options.temporary = false;
    super(player, options);
    this.updateDisplay = this.updateDisplay.bind(this);
    this.fill();
    this.hasBeenOpened_ = this.hasBeenFilled_ = true;
    this.renderModalComponents(player);
    this.endDialog = createEl("p", {
      className: "vjs-control-text",
      textContent: this.localize("End of dialog window.")
    });
    this.el().appendChild(this.endDialog);
    this.setDefaults();
    if (options.persistTextTrackSettings === void 0) {
      this.options_.persistTextTrackSettings = this.options_.playerOptions.persistTextTrackSettings;
    }
    this.bindFunctionsToSelectsAndButtons();
    if (this.options_.persistTextTrackSettings) {
      this.restoreSettings();
    }
  }
  renderModalComponents(player) {
    const textTrackSettingsColors = new TextTrackSettingsColors(player, {
      textTrackComponentid: this.id_,
      selectConfigs,
      fieldSets: [["color", "textOpacity"], ["backgroundColor", "backgroundOpacity"], ["windowColor", "windowOpacity"]]
    });
    this.addChild(textTrackSettingsColors);
    const textTrackSettingsFont = new TextTrackSettingsFont(player, {
      textTrackComponentid: this.id_,
      selectConfigs,
      fieldSets: [["fontPercent"], ["edgeStyle"], ["fontFamily"]]
    });
    this.addChild(textTrackSettingsFont);
    const trackSettingsControls = new TrackSettingsControls(player);
    this.addChild(trackSettingsControls);
  }
  bindFunctionsToSelectsAndButtons() {
    this.on(this.$(".vjs-done-button"), ["click", "tap"], () => {
      this.saveSettings();
      this.close();
    });
    this.on(this.$(".vjs-default-button"), ["click", "tap"], () => {
      this.setDefaults();
      this.updateDisplay();
    });
    each(selectConfigs, (config) => {
      this.on(this.$(config.selector), "change", this.updateDisplay);
    });
  }
  dispose() {
    this.endDialog = null;
    super.dispose();
  }
  label() {
    return this.localize("Caption Settings Dialog");
  }
  description() {
    return this.localize("Beginning of dialog window. Escape will cancel and close the window.");
  }
  buildCSSClass() {
    return super.buildCSSClass() + " vjs-text-track-settings";
  }
  getValues() {
    return reduce(selectConfigs, (accum, config, key) => {
      const value = getSelectedOptionValue(this.$(config.selector), config.parser);
      if (value !== void 0) {
        accum[key] = value;
      }
      return accum;
    }, {});
  }
  setValues(values2) {
    each(selectConfigs, (config, key) => {
      setSelectedOption(this.$(config.selector), values2[key], config.parser);
    });
  }
  setDefaults() {
    each(selectConfigs, (config) => {
      const index = config.hasOwnProperty("default") ? config.default : 0;
      this.$(config.selector).selectedIndex = index;
    });
  }
  restoreSettings() {
    let values2;
    try {
      values2 = JSON.parse(window_1.localStorage.getItem(LOCAL_STORAGE_KEY$1));
    } catch (err) {
      log$1.warn(err);
    }
    if (values2) {
      this.setValues(values2);
    }
  }
  saveSettings() {
    if (!this.options_.persistTextTrackSettings) {
      return;
    }
    const values2 = this.getValues();
    try {
      if (Object.keys(values2).length) {
        window_1.localStorage.setItem(LOCAL_STORAGE_KEY$1, JSON.stringify(values2));
      } else {
        window_1.localStorage.removeItem(LOCAL_STORAGE_KEY$1);
      }
    } catch (err) {
      log$1.warn(err);
    }
  }
  updateDisplay() {
    const ttDisplay = this.player_.getChild("textTrackDisplay");
    if (ttDisplay) {
      ttDisplay.updateDisplay();
    }
  }
  handleLanguagechange() {
    this.fill();
    this.renderModalComponents(this.player_);
    this.bindFunctionsToSelectsAndButtons();
  }
}
Component$1.registerComponent("TextTrackSettings", TextTrackSettings);
class ResizeManager extends Component$1 {
  constructor(player, options) {
    let RESIZE_OBSERVER_AVAILABLE = options.ResizeObserver || window_1.ResizeObserver;
    if (options.ResizeObserver === null) {
      RESIZE_OBSERVER_AVAILABLE = false;
    }
    const options_ = merge$1({
      createEl: !RESIZE_OBSERVER_AVAILABLE,
      reportTouchActivity: false
    }, options);
    super(player, options_);
    this.ResizeObserver = options.ResizeObserver || window_1.ResizeObserver;
    this.loadListener_ = null;
    this.resizeObserver_ = null;
    this.debouncedHandler_ = debounce$1(() => {
      this.resizeHandler();
    }, 100, false, this);
    if (RESIZE_OBSERVER_AVAILABLE) {
      this.resizeObserver_ = new this.ResizeObserver(this.debouncedHandler_);
      this.resizeObserver_.observe(player.el());
    } else {
      this.loadListener_ = () => {
        if (!this.el_ || !this.el_.contentWindow) {
          return;
        }
        const debouncedHandler_ = this.debouncedHandler_;
        let unloadListener_ = this.unloadListener_ = function() {
          off(this, "resize", debouncedHandler_);
          off(this, "unload", unloadListener_);
          unloadListener_ = null;
        };
        on(this.el_.contentWindow, "unload", unloadListener_);
        on(this.el_.contentWindow, "resize", debouncedHandler_);
      };
      this.one("load", this.loadListener_);
    }
  }
  createEl() {
    return super.createEl("iframe", {
      className: "vjs-resize-manager",
      tabIndex: -1,
      title: this.localize("No content")
    }, {
      "aria-hidden": "true"
    });
  }
  resizeHandler() {
    if (!this.player_ || !this.player_.trigger) {
      return;
    }
    this.player_.trigger("playerresize");
  }
  dispose() {
    if (this.debouncedHandler_) {
      this.debouncedHandler_.cancel();
    }
    if (this.resizeObserver_) {
      if (this.player_.el()) {
        this.resizeObserver_.unobserve(this.player_.el());
      }
      this.resizeObserver_.disconnect();
    }
    if (this.loadListener_) {
      this.off("load", this.loadListener_);
    }
    if (this.el_ && this.el_.contentWindow && this.unloadListener_) {
      this.unloadListener_.call(this.el_.contentWindow);
    }
    this.ResizeObserver = null;
    this.resizeObserver = null;
    this.debouncedHandler_ = null;
    this.loadListener_ = null;
    super.dispose();
  }
}
Component$1.registerComponent("ResizeManager", ResizeManager);
const defaults$1 = {
  trackingThreshold: 20,
  liveTolerance: 15
};
class LiveTracker extends Component$1 {
  constructor(player, options) {
    const options_ = merge$1(defaults$1, options, {
      createEl: false
    });
    super(player, options_);
    this.trackLiveHandler_ = () => this.trackLive_();
    this.handlePlay_ = (e) => this.handlePlay(e);
    this.handleFirstTimeupdate_ = (e) => this.handleFirstTimeupdate(e);
    this.handleSeeked_ = (e) => this.handleSeeked(e);
    this.seekToLiveEdge_ = (e) => this.seekToLiveEdge(e);
    this.reset_();
    this.on(this.player_, "durationchange", (e) => this.handleDurationchange(e));
    this.on(this.player_, "canplay", () => this.toggleTracking());
  }
  trackLive_() {
    const seekable2 = this.player_.seekable();
    if (!seekable2 || !seekable2.length) {
      return;
    }
    const newTime = Number(window_1.performance.now().toFixed(4));
    const deltaTime = this.lastTime_ === -1 ? 0 : (newTime - this.lastTime_) / 1e3;
    this.lastTime_ = newTime;
    this.pastSeekEnd_ = this.pastSeekEnd() + deltaTime;
    const liveCurrentTime = this.liveCurrentTime();
    const currentTime = this.player_.currentTime();
    let isBehind = this.player_.paused() || this.seekedBehindLive_ || Math.abs(liveCurrentTime - currentTime) > this.options_.liveTolerance;
    if (!this.timeupdateSeen_ || liveCurrentTime === Infinity) {
      isBehind = false;
    }
    if (isBehind !== this.behindLiveEdge_) {
      this.behindLiveEdge_ = isBehind;
      this.trigger("liveedgechange");
    }
  }
  handleDurationchange() {
    this.toggleTracking();
  }
  toggleTracking() {
    if (this.player_.duration() === Infinity && this.liveWindow() >= this.options_.trackingThreshold) {
      if (this.player_.options_.liveui) {
        this.player_.addClass("vjs-liveui");
      }
      this.startTracking();
    } else {
      this.player_.removeClass("vjs-liveui");
      this.stopTracking();
    }
  }
  startTracking() {
    if (this.isTracking()) {
      return;
    }
    if (!this.timeupdateSeen_) {
      this.timeupdateSeen_ = this.player_.hasStarted();
    }
    this.trackingInterval_ = this.setInterval(this.trackLiveHandler_, UPDATE_REFRESH_INTERVAL);
    this.trackLive_();
    this.on(this.player_, ["play", "pause"], this.trackLiveHandler_);
    if (!this.timeupdateSeen_) {
      this.one(this.player_, "play", this.handlePlay_);
      this.one(this.player_, "timeupdate", this.handleFirstTimeupdate_);
    } else {
      this.on(this.player_, "seeked", this.handleSeeked_);
    }
  }
  handleFirstTimeupdate() {
    this.timeupdateSeen_ = true;
    this.on(this.player_, "seeked", this.handleSeeked_);
  }
  handleSeeked() {
    const timeDiff = Math.abs(this.liveCurrentTime() - this.player_.currentTime());
    this.seekedBehindLive_ = this.nextSeekedFromUser_ && timeDiff > 2;
    this.nextSeekedFromUser_ = false;
    this.trackLive_();
  }
  handlePlay() {
    this.one(this.player_, "timeupdate", this.seekToLiveEdge_);
  }
  reset_() {
    this.lastTime_ = -1;
    this.pastSeekEnd_ = 0;
    this.lastSeekEnd_ = -1;
    this.behindLiveEdge_ = true;
    this.timeupdateSeen_ = false;
    this.seekedBehindLive_ = false;
    this.nextSeekedFromUser_ = false;
    this.clearInterval(this.trackingInterval_);
    this.trackingInterval_ = null;
    this.off(this.player_, ["play", "pause"], this.trackLiveHandler_);
    this.off(this.player_, "seeked", this.handleSeeked_);
    this.off(this.player_, "play", this.handlePlay_);
    this.off(this.player_, "timeupdate", this.handleFirstTimeupdate_);
    this.off(this.player_, "timeupdate", this.seekToLiveEdge_);
  }
  nextSeekedFromUser() {
    this.nextSeekedFromUser_ = true;
  }
  stopTracking() {
    if (!this.isTracking()) {
      return;
    }
    this.reset_();
    this.trigger("liveedgechange");
  }
  seekableEnd() {
    const seekable2 = this.player_.seekable();
    const seekableEnds = [];
    let i = seekable2 ? seekable2.length : 0;
    while (i--) {
      seekableEnds.push(seekable2.end(i));
    }
    return seekableEnds.length ? seekableEnds.sort()[seekableEnds.length - 1] : Infinity;
  }
  seekableStart() {
    const seekable2 = this.player_.seekable();
    const seekableStarts = [];
    let i = seekable2 ? seekable2.length : 0;
    while (i--) {
      seekableStarts.push(seekable2.start(i));
    }
    return seekableStarts.length ? seekableStarts.sort()[0] : 0;
  }
  liveWindow() {
    const liveCurrentTime = this.liveCurrentTime();
    if (liveCurrentTime === Infinity) {
      return 0;
    }
    return liveCurrentTime - this.seekableStart();
  }
  isLive() {
    return this.isTracking();
  }
  atLiveEdge() {
    return !this.behindLiveEdge();
  }
  liveCurrentTime() {
    return this.pastSeekEnd() + this.seekableEnd();
  }
  pastSeekEnd() {
    const seekableEnd = this.seekableEnd();
    if (this.lastSeekEnd_ !== -1 && seekableEnd !== this.lastSeekEnd_) {
      this.pastSeekEnd_ = 0;
    }
    this.lastSeekEnd_ = seekableEnd;
    return this.pastSeekEnd_;
  }
  behindLiveEdge() {
    return this.behindLiveEdge_;
  }
  isTracking() {
    return typeof this.trackingInterval_ === "number";
  }
  seekToLiveEdge() {
    this.seekedBehindLive_ = false;
    if (this.atLiveEdge()) {
      return;
    }
    this.nextSeekedFromUser_ = false;
    this.player_.currentTime(this.liveCurrentTime());
  }
  dispose() {
    this.stopTracking();
    super.dispose();
  }
}
Component$1.registerComponent("LiveTracker", LiveTracker);
class TitleBar extends Component$1 {
  constructor(player, options) {
    super(player, options);
    this.on("statechanged", (e) => this.updateDom_());
    this.updateDom_();
  }
  createEl() {
    this.els = {
      title: createEl("div", {
        className: "vjs-title-bar-title",
        id: `vjs-title-bar-title-${newGUID()}`
      }),
      description: createEl("div", {
        className: "vjs-title-bar-description",
        id: `vjs-title-bar-description-${newGUID()}`
      })
    };
    return createEl("div", {
      className: "vjs-title-bar"
    }, {}, values(this.els));
  }
  updateDom_() {
    const tech = this.player_.tech_;
    const techEl = tech && tech.el_;
    const techAriaAttrs = {
      title: "aria-labelledby",
      description: "aria-describedby"
    };
    ["title", "description"].forEach((k) => {
      const value = this.state[k];
      const el = this.els[k];
      const techAriaAttr = techAriaAttrs[k];
      emptyEl(el);
      if (value) {
        textContent(el, value);
      }
      if (techEl) {
        techEl.removeAttribute(techAriaAttr);
        if (value) {
          techEl.setAttribute(techAriaAttr, el.id);
        }
      }
    });
    if (this.state.title || this.state.description) {
      this.show();
    } else {
      this.hide();
    }
  }
  update(options) {
    this.setState(options);
  }
  dispose() {
    const tech = this.player_.tech_;
    const techEl = tech && tech.el_;
    if (techEl) {
      techEl.removeAttribute("aria-labelledby");
      techEl.removeAttribute("aria-describedby");
    }
    super.dispose();
    this.els = null;
  }
}
Component$1.registerComponent("TitleBar", TitleBar);
const defaults = {
  initialDisplay: 4e3,
  position: [],
  takeFocus: false
};
class TransientButton extends Button {
  constructor(player, options) {
    options = merge$1(defaults, options);
    super(player, options);
    this.controlText(options.controlText);
    this.hide();
    this.on(this.player_, ["useractive", "userinactive"], (e) => {
      this.removeClass("force-display");
    });
  }
  buildCSSClass() {
    return `vjs-transient-button focus-visible ${this.options_.position.map((c) => `vjs-${c}`).join(" ")}`;
  }
  createEl() {
    const el = createEl("button", {}, {
      type: "button",
      class: this.buildCSSClass()
    }, createEl("span"));
    this.controlTextEl_ = el.querySelector("span");
    return el;
  }
  show() {
    super.show();
    this.addClass("force-display");
    if (this.options_.takeFocus) {
      this.el().focus({
        preventScroll: true
      });
    }
    this.forceDisplayTimeout = this.player_.setTimeout(() => {
      this.removeClass("force-display");
    }, this.options_.initialDisplay);
  }
  hide() {
    this.removeClass("force-display");
    super.hide();
  }
  dispose() {
    this.player_.clearTimeout(this.forceDisplayTimeout);
    super.dispose();
  }
}
Component$1.registerComponent("TransientButton", TransientButton);
const sourcesetLoad = (tech) => {
  const el = tech.el();
  if (el.hasAttribute("src")) {
    tech.triggerSourceset(el.src);
    return true;
  }
  const sources = tech.$$("source");
  const srcUrls = [];
  let src = "";
  if (!sources.length) {
    return false;
  }
  for (let i = 0; i < sources.length; i++) {
    const url = sources[i].src;
    if (url && srcUrls.indexOf(url) === -1) {
      srcUrls.push(url);
    }
  }
  if (!srcUrls.length) {
    return false;
  }
  if (srcUrls.length === 1) {
    src = srcUrls[0];
  }
  tech.triggerSourceset(src);
  return true;
};
const innerHTMLDescriptorPolyfill = Object.defineProperty({}, "innerHTML", {
  get() {
    return this.cloneNode(true).innerHTML;
  },
  set(v) {
    const dummy = document_1.createElement(this.nodeName.toLowerCase());
    dummy.innerHTML = v;
    const docFrag = document_1.createDocumentFragment();
    while (dummy.childNodes.length) {
      docFrag.appendChild(dummy.childNodes[0]);
    }
    this.innerText = "";
    window_1.Element.prototype.appendChild.call(this, docFrag);
    return this.innerHTML;
  }
});
const getDescriptor = (priority, prop) => {
  let descriptor = {};
  for (let i = 0; i < priority.length; i++) {
    descriptor = Object.getOwnPropertyDescriptor(priority[i], prop);
    if (descriptor && descriptor.set && descriptor.get) {
      break;
    }
  }
  descriptor.enumerable = true;
  descriptor.configurable = true;
  return descriptor;
};
const getInnerHTMLDescriptor = (tech) => getDescriptor([tech.el(), window_1.HTMLMediaElement.prototype, window_1.Element.prototype, innerHTMLDescriptorPolyfill], "innerHTML");
const firstSourceWatch = function(tech) {
  const el = tech.el();
  if (el.resetSourceWatch_) {
    return;
  }
  const old = {};
  const innerDescriptor = getInnerHTMLDescriptor(tech);
  const appendWrapper = (appendFn) => (...args) => {
    const retval = appendFn.apply(el, args);
    sourcesetLoad(tech);
    return retval;
  };
  ["append", "appendChild", "insertAdjacentHTML"].forEach((k) => {
    if (!el[k]) {
      return;
    }
    old[k] = el[k];
    el[k] = appendWrapper(old[k]);
  });
  Object.defineProperty(el, "innerHTML", merge$1(innerDescriptor, {
    set: appendWrapper(innerDescriptor.set)
  }));
  el.resetSourceWatch_ = () => {
    el.resetSourceWatch_ = null;
    Object.keys(old).forEach((k) => {
      el[k] = old[k];
    });
    Object.defineProperty(el, "innerHTML", innerDescriptor);
  };
  tech.one("sourceset", el.resetSourceWatch_);
};
const srcDescriptorPolyfill = Object.defineProperty({}, "src", {
  get() {
    if (this.hasAttribute("src")) {
      return getAbsoluteURL(window_1.Element.prototype.getAttribute.call(this, "src"));
    }
    return "";
  },
  set(v) {
    window_1.Element.prototype.setAttribute.call(this, "src", v);
    return v;
  }
});
const getSrcDescriptor = (tech) => getDescriptor([tech.el(), window_1.HTMLMediaElement.prototype, srcDescriptorPolyfill], "src");
const setupSourceset = function(tech) {
  if (!tech.featuresSourceset) {
    return;
  }
  const el = tech.el();
  if (el.resetSourceset_) {
    return;
  }
  const srcDescriptor = getSrcDescriptor(tech);
  const oldSetAttribute = el.setAttribute;
  const oldLoad = el.load;
  Object.defineProperty(el, "src", merge$1(srcDescriptor, {
    set: (v) => {
      const retval = srcDescriptor.set.call(el, v);
      tech.triggerSourceset(el.src);
      return retval;
    }
  }));
  el.setAttribute = (n, v) => {
    const retval = oldSetAttribute.call(el, n, v);
    if (/src/i.test(n)) {
      tech.triggerSourceset(el.src);
    }
    return retval;
  };
  el.load = () => {
    const retval = oldLoad.call(el);
    if (!sourcesetLoad(tech)) {
      tech.triggerSourceset("");
      firstSourceWatch(tech);
    }
    return retval;
  };
  if (el.currentSrc) {
    tech.triggerSourceset(el.currentSrc);
  } else if (!sourcesetLoad(tech)) {
    firstSourceWatch(tech);
  }
  el.resetSourceset_ = () => {
    el.resetSourceset_ = null;
    el.load = oldLoad;
    el.setAttribute = oldSetAttribute;
    Object.defineProperty(el, "src", srcDescriptor);
    if (el.resetSourceWatch_) {
      el.resetSourceWatch_();
    }
  };
};
class Html5 extends Tech {
  constructor(options, ready) {
    super(options, ready);
    const source = options.source;
    let crossoriginTracks = false;
    this.featuresVideoFrameCallback = this.featuresVideoFrameCallback && this.el_.tagName === "VIDEO";
    if (source && (this.el_.currentSrc !== source.src || options.tag && options.tag.initNetworkState_ === 3)) {
      this.setSource(source);
    } else {
      this.handleLateInit_(this.el_);
    }
    if (options.enableSourceset) {
      this.setupSourcesetHandling_();
    }
    this.isScrubbing_ = false;
    if (this.el_.hasChildNodes()) {
      const nodes = this.el_.childNodes;
      let nodesLength = nodes.length;
      const removeNodes = [];
      while (nodesLength--) {
        const node = nodes[nodesLength];
        const nodeName = node.nodeName.toLowerCase();
        if (nodeName === "track") {
          if (!this.featuresNativeTextTracks) {
            removeNodes.push(node);
          } else {
            this.remoteTextTrackEls().addTrackElement_(node);
            this.remoteTextTracks().addTrack(node.track);
            this.textTracks().addTrack(node.track);
            if (!crossoriginTracks && !this.el_.hasAttribute("crossorigin") && isCrossOrigin(node.src)) {
              crossoriginTracks = true;
            }
          }
        }
      }
      for (let i = 0; i < removeNodes.length; i++) {
        this.el_.removeChild(removeNodes[i]);
      }
    }
    this.proxyNativeTracks_();
    if (this.featuresNativeTextTracks && crossoriginTracks) {
      log$1.warn("Text Tracks are being loaded from another origin but the crossorigin attribute isn't used.\nThis may prevent text tracks from loading.");
    }
    this.restoreMetadataTracksInIOSNativePlayer_();
    if ((TOUCH_ENABLED || IS_IPHONE) && options.nativeControlsForTouch === true) {
      this.setControls(true);
    }
    this.proxyWebkitFullscreen_();
    this.triggerReady();
  }
  dispose() {
    if (this.el_ && this.el_.resetSourceset_) {
      this.el_.resetSourceset_();
    }
    Html5.disposeMediaElement(this.el_);
    this.options_ = null;
    super.dispose();
  }
  setupSourcesetHandling_() {
    setupSourceset(this);
  }
  restoreMetadataTracksInIOSNativePlayer_() {
    const textTracks = this.textTracks();
    let metadataTracksPreFullscreenState;
    const takeMetadataTrackSnapshot = () => {
      metadataTracksPreFullscreenState = [];
      for (let i = 0; i < textTracks.length; i++) {
        const track = textTracks[i];
        if (track.kind === "metadata") {
          metadataTracksPreFullscreenState.push({
            track,
            storedMode: track.mode
          });
        }
      }
    };
    takeMetadataTrackSnapshot();
    textTracks.addEventListener("change", takeMetadataTrackSnapshot);
    this.on("dispose", () => textTracks.removeEventListener("change", takeMetadataTrackSnapshot));
    const restoreTrackMode = () => {
      for (let i = 0; i < metadataTracksPreFullscreenState.length; i++) {
        const storedTrack = metadataTracksPreFullscreenState[i];
        if (storedTrack.track.mode === "disabled" && storedTrack.track.mode !== storedTrack.storedMode) {
          storedTrack.track.mode = storedTrack.storedMode;
        }
      }
      textTracks.removeEventListener("change", restoreTrackMode);
    };
    this.on("webkitbeginfullscreen", () => {
      textTracks.removeEventListener("change", takeMetadataTrackSnapshot);
      textTracks.removeEventListener("change", restoreTrackMode);
      textTracks.addEventListener("change", restoreTrackMode);
    });
    this.on("webkitendfullscreen", () => {
      textTracks.removeEventListener("change", takeMetadataTrackSnapshot);
      textTracks.addEventListener("change", takeMetadataTrackSnapshot);
      textTracks.removeEventListener("change", restoreTrackMode);
    });
  }
  overrideNative_(type, override) {
    if (override !== this[`featuresNative${type}Tracks`]) {
      return;
    }
    const lowerCaseType = type.toLowerCase();
    if (this[`${lowerCaseType}TracksListeners_`]) {
      Object.keys(this[`${lowerCaseType}TracksListeners_`]).forEach((eventName) => {
        const elTracks = this.el()[`${lowerCaseType}Tracks`];
        elTracks.removeEventListener(eventName, this[`${lowerCaseType}TracksListeners_`][eventName]);
      });
    }
    this[`featuresNative${type}Tracks`] = !override;
    this[`${lowerCaseType}TracksListeners_`] = null;
    this.proxyNativeTracksForType_(lowerCaseType);
  }
  overrideNativeAudioTracks(override) {
    this.overrideNative_("Audio", override);
  }
  overrideNativeVideoTracks(override) {
    this.overrideNative_("Video", override);
  }
  proxyNativeTracksForType_(name) {
    const props = NORMAL[name];
    const elTracks = this.el()[props.getterName];
    const techTracks = this[props.getterName]();
    if (!this[`featuresNative${props.capitalName}Tracks`] || !elTracks || !elTracks.addEventListener) {
      return;
    }
    const listeners = {
      change: (e) => {
        const event = {
          type: "change",
          target: techTracks,
          currentTarget: techTracks,
          srcElement: techTracks
        };
        techTracks.trigger(event);
        if (name === "text") {
          this[REMOTE.remoteText.getterName]().trigger(event);
        }
      },
      addtrack(e) {
        techTracks.addTrack(e.track);
      },
      removetrack(e) {
        techTracks.removeTrack(e.track);
      }
    };
    const removeOldTracks = function() {
      const removeTracks = [];
      for (let i = 0; i < techTracks.length; i++) {
        let found = false;
        for (let j = 0; j < elTracks.length; j++) {
          if (elTracks[j] === techTracks[i]) {
            found = true;
            break;
          }
        }
        if (!found) {
          removeTracks.push(techTracks[i]);
        }
      }
      while (removeTracks.length) {
        techTracks.removeTrack(removeTracks.shift());
      }
    };
    this[props.getterName + "Listeners_"] = listeners;
    Object.keys(listeners).forEach((eventName) => {
      const listener = listeners[eventName];
      elTracks.addEventListener(eventName, listener);
      this.on("dispose", (e) => elTracks.removeEventListener(eventName, listener));
    });
    this.on("loadstart", removeOldTracks);
    this.on("dispose", (e) => this.off("loadstart", removeOldTracks));
  }
  proxyNativeTracks_() {
    NORMAL.names.forEach((name) => {
      this.proxyNativeTracksForType_(name);
    });
  }
  createEl() {
    let el = this.options_.tag;
    if (!el || !(this.options_.playerElIngest || this.movingMediaElementInDOM)) {
      if (el) {
        const clone = el.cloneNode(true);
        if (el.parentNode) {
          el.parentNode.insertBefore(clone, el);
        }
        Html5.disposeMediaElement(el);
        el = clone;
      } else {
        el = document_1.createElement("video");
        const tagAttributes = this.options_.tag && getAttributes(this.options_.tag);
        const attributes = merge$1({}, tagAttributes);
        if (!TOUCH_ENABLED || this.options_.nativeControlsForTouch !== true) {
          delete attributes.controls;
        }
        setAttributes(el, Object.assign(attributes, {
          id: this.options_.techId,
          class: "vjs-tech"
        }));
      }
      el.playerId = this.options_.playerId;
    }
    if (typeof this.options_.preload !== "undefined") {
      setAttribute(el, "preload", this.options_.preload);
    }
    if (this.options_.disablePictureInPicture !== void 0) {
      el.disablePictureInPicture = this.options_.disablePictureInPicture;
    }
    const settingsAttrs = ["loop", "muted", "playsinline", "autoplay"];
    for (let i = 0; i < settingsAttrs.length; i++) {
      const attr = settingsAttrs[i];
      const value = this.options_[attr];
      if (typeof value !== "undefined") {
        if (value) {
          setAttribute(el, attr, attr);
        } else {
          removeAttribute(el, attr);
        }
        el[attr] = value;
      }
    }
    return el;
  }
  handleLateInit_(el) {
    if (el.networkState === 0 || el.networkState === 3) {
      return;
    }
    if (el.readyState === 0) {
      let loadstartFired = false;
      const setLoadstartFired = function() {
        loadstartFired = true;
      };
      this.on("loadstart", setLoadstartFired);
      const triggerLoadstart = function() {
        if (!loadstartFired) {
          this.trigger("loadstart");
        }
      };
      this.on("loadedmetadata", triggerLoadstart);
      this.ready(function() {
        this.off("loadstart", setLoadstartFired);
        this.off("loadedmetadata", triggerLoadstart);
        if (!loadstartFired) {
          this.trigger("loadstart");
        }
      });
      return;
    }
    const eventsToTrigger = ["loadstart"];
    eventsToTrigger.push("loadedmetadata");
    if (el.readyState >= 2) {
      eventsToTrigger.push("loadeddata");
    }
    if (el.readyState >= 3) {
      eventsToTrigger.push("canplay");
    }
    if (el.readyState >= 4) {
      eventsToTrigger.push("canplaythrough");
    }
    this.ready(function() {
      eventsToTrigger.forEach(function(type) {
        this.trigger(type);
      }, this);
    });
  }
  setScrubbing(isScrubbing) {
    this.isScrubbing_ = isScrubbing;
  }
  scrubbing() {
    return this.isScrubbing_;
  }
  setCurrentTime(seconds) {
    try {
      if (this.isScrubbing_ && this.el_.fastSeek && IS_ANY_SAFARI) {
        this.el_.fastSeek(seconds);
      } else {
        this.el_.currentTime = seconds;
      }
    } catch (e) {
      log$1(e, "Video is not ready. (Video.js)");
    }
  }
  duration() {
    if (this.el_.duration === Infinity && IS_ANDROID && IS_CHROME && this.el_.currentTime === 0) {
      const checkProgress = () => {
        if (this.el_.currentTime > 0) {
          if (this.el_.duration === Infinity) {
            this.trigger("durationchange");
          }
          this.off("timeupdate", checkProgress);
        }
      };
      this.on("timeupdate", checkProgress);
      return NaN;
    }
    return this.el_.duration || NaN;
  }
  width() {
    return this.el_.offsetWidth;
  }
  height() {
    return this.el_.offsetHeight;
  }
  proxyWebkitFullscreen_() {
    if (!("webkitDisplayingFullscreen" in this.el_)) {
      return;
    }
    const endFn = function() {
      this.trigger("fullscreenchange", {
        isFullscreen: false
      });
      if (this.el_.controls && !this.options_.nativeControlsForTouch && this.controls()) {
        this.el_.controls = false;
      }
    };
    const beginFn = function() {
      if ("webkitPresentationMode" in this.el_ && this.el_.webkitPresentationMode !== "picture-in-picture") {
        this.one("webkitendfullscreen", endFn);
        this.trigger("fullscreenchange", {
          isFullscreen: true,
          nativeIOSFullscreen: true
        });
      }
    };
    this.on("webkitbeginfullscreen", beginFn);
    this.on("dispose", () => {
      this.off("webkitbeginfullscreen", beginFn);
      this.off("webkitendfullscreen", endFn);
    });
  }
  supportsFullScreen() {
    return typeof this.el_.webkitEnterFullScreen === "function";
  }
  enterFullScreen() {
    const video = this.el_;
    if (video.paused && video.networkState <= video.HAVE_METADATA) {
      silencePromise(this.el_.play());
      this.setTimeout(function() {
        video.pause();
        try {
          video.webkitEnterFullScreen();
        } catch (e) {
          this.trigger("fullscreenerror", e);
        }
      }, 0);
    } else {
      try {
        video.webkitEnterFullScreen();
      } catch (e) {
        this.trigger("fullscreenerror", e);
      }
    }
  }
  exitFullScreen() {
    if (!this.el_.webkitDisplayingFullscreen) {
      this.trigger("fullscreenerror", new Error("The video is not fullscreen"));
      return;
    }
    this.el_.webkitExitFullScreen();
  }
  requestPictureInPicture() {
    return this.el_.requestPictureInPicture();
  }
  requestVideoFrameCallback(cb) {
    if (this.featuresVideoFrameCallback && !this.el_.webkitKeys) {
      return this.el_.requestVideoFrameCallback(cb);
    }
    return super.requestVideoFrameCallback(cb);
  }
  cancelVideoFrameCallback(id) {
    if (this.featuresVideoFrameCallback && !this.el_.webkitKeys) {
      this.el_.cancelVideoFrameCallback(id);
    } else {
      super.cancelVideoFrameCallback(id);
    }
  }
  src(src) {
    if (src === void 0) {
      return this.el_.src;
    }
    this.setSrc(src);
  }
  addSourceElement(srcUrl, mimeType) {
    if (!srcUrl) {
      log$1.error("Invalid source URL.");
      return false;
    }
    const sourceAttributes = {
      src: srcUrl
    };
    if (mimeType) {
      sourceAttributes.type = mimeType;
    }
    const sourceElement = createEl("source", {}, sourceAttributes);
    this.el_.appendChild(sourceElement);
    return true;
  }
  removeSourceElement(srcUrl) {
    if (!srcUrl) {
      log$1.error("Source URL is required to remove the source element.");
      return false;
    }
    const sourceElements = this.el_.querySelectorAll("source");
    for (const sourceElement of sourceElements) {
      if (sourceElement.src === srcUrl) {
        this.el_.removeChild(sourceElement);
        return true;
      }
    }
    log$1.warn(`No matching source element found with src: ${srcUrl}`);
    return false;
  }
  reset() {
    Html5.resetMediaElement(this.el_);
  }
  currentSrc() {
    if (this.currentSource_) {
      return this.currentSource_.src;
    }
    return this.el_.currentSrc;
  }
  setControls(val) {
    this.el_.controls = !!val;
  }
  addTextTrack(kind, label, language) {
    if (!this.featuresNativeTextTracks) {
      return super.addTextTrack(kind, label, language);
    }
    return this.el_.addTextTrack(kind, label, language);
  }
  createRemoteTextTrack(options) {
    if (!this.featuresNativeTextTracks) {
      return super.createRemoteTextTrack(options);
    }
    const htmlTrackElement = document_1.createElement("track");
    if (options.kind) {
      htmlTrackElement.kind = options.kind;
    }
    if (options.label) {
      htmlTrackElement.label = options.label;
    }
    if (options.language || options.srclang) {
      htmlTrackElement.srclang = options.language || options.srclang;
    }
    if (options.default) {
      htmlTrackElement.default = options.default;
    }
    if (options.id) {
      htmlTrackElement.id = options.id;
    }
    if (options.src) {
      htmlTrackElement.src = options.src;
    }
    return htmlTrackElement;
  }
  addRemoteTextTrack(options, manualCleanup) {
    const htmlTrackElement = super.addRemoteTextTrack(options, manualCleanup);
    if (this.featuresNativeTextTracks) {
      this.el().appendChild(htmlTrackElement);
    }
    return htmlTrackElement;
  }
  removeRemoteTextTrack(track) {
    super.removeRemoteTextTrack(track);
    if (this.featuresNativeTextTracks) {
      const tracks = this.$$("track");
      let i = tracks.length;
      while (i--) {
        if (track === tracks[i] || track === tracks[i].track) {
          this.el().removeChild(tracks[i]);
        }
      }
    }
  }
  getVideoPlaybackQuality() {
    if (typeof this.el().getVideoPlaybackQuality === "function") {
      return this.el().getVideoPlaybackQuality();
    }
    const videoPlaybackQuality = {};
    if (typeof this.el().webkitDroppedFrameCount !== "undefined" && typeof this.el().webkitDecodedFrameCount !== "undefined") {
      videoPlaybackQuality.droppedVideoFrames = this.el().webkitDroppedFrameCount;
      videoPlaybackQuality.totalVideoFrames = this.el().webkitDecodedFrameCount;
    }
    if (window_1.performance) {
      videoPlaybackQuality.creationTime = window_1.performance.now();
    }
    return videoPlaybackQuality;
  }
}
defineLazyProperty(Html5, "TEST_VID", function() {
  if (!isReal()) {
    return;
  }
  const video = document_1.createElement("video");
  const track = document_1.createElement("track");
  track.kind = "captions";
  track.srclang = "en";
  track.label = "English";
  video.appendChild(track);
  return video;
});
Html5.isSupported = function() {
  try {
    Html5.TEST_VID.volume = 0.5;
  } catch (e) {
    return false;
  }
  return !!(Html5.TEST_VID && Html5.TEST_VID.canPlayType);
};
Html5.canPlayType = function(type) {
  return Html5.TEST_VID.canPlayType(type);
};
Html5.canPlaySource = function(srcObj, options) {
  return Html5.canPlayType(srcObj.type);
};
Html5.canControlVolume = function() {
  try {
    const volume = Html5.TEST_VID.volume;
    Html5.TEST_VID.volume = volume / 2 + 0.1;
    const canControl = volume !== Html5.TEST_VID.volume;
    if (canControl && IS_IOS) {
      window_1.setTimeout(() => {
        if (Html5 && Html5.prototype) {
          Html5.prototype.featuresVolumeControl = volume !== Html5.TEST_VID.volume;
        }
      });
      return false;
    }
    return canControl;
  } catch (e) {
    return false;
  }
};
Html5.canMuteVolume = function() {
  try {
    const muted = Html5.TEST_VID.muted;
    Html5.TEST_VID.muted = !muted;
    if (Html5.TEST_VID.muted) {
      setAttribute(Html5.TEST_VID, "muted", "muted");
    } else {
      removeAttribute(Html5.TEST_VID, "muted", "muted");
    }
    return muted !== Html5.TEST_VID.muted;
  } catch (e) {
    return false;
  }
};
Html5.canControlPlaybackRate = function() {
  if (IS_ANDROID && IS_CHROME && CHROME_VERSION < 58) {
    return false;
  }
  try {
    const playbackRate = Html5.TEST_VID.playbackRate;
    Html5.TEST_VID.playbackRate = playbackRate / 2 + 0.1;
    return playbackRate !== Html5.TEST_VID.playbackRate;
  } catch (e) {
    return false;
  }
};
Html5.canOverrideAttributes = function() {
  try {
    const noop2 = () => {
    };
    Object.defineProperty(document_1.createElement("video"), "src", {
      get: noop2,
      set: noop2
    });
    Object.defineProperty(document_1.createElement("audio"), "src", {
      get: noop2,
      set: noop2
    });
    Object.defineProperty(document_1.createElement("video"), "innerHTML", {
      get: noop2,
      set: noop2
    });
    Object.defineProperty(document_1.createElement("audio"), "innerHTML", {
      get: noop2,
      set: noop2
    });
  } catch (e) {
    return false;
  }
  return true;
};
Html5.supportsNativeTextTracks = function() {
  return IS_ANY_SAFARI || IS_IOS && IS_CHROME;
};
Html5.supportsNativeVideoTracks = function() {
  return !!(Html5.TEST_VID && Html5.TEST_VID.videoTracks);
};
Html5.supportsNativeAudioTracks = function() {
  return !!(Html5.TEST_VID && Html5.TEST_VID.audioTracks);
};
Html5.Events = ["loadstart", "suspend", "abort", "error", "emptied", "stalled", "loadedmetadata", "loadeddata", "canplay", "canplaythrough", "playing", "waiting", "seeking", "seeked", "ended", "durationchange", "timeupdate", "progress", "play", "pause", "ratechange", "resize", "volumechange"];
[["featuresMuteControl", "canMuteVolume"], ["featuresPlaybackRate", "canControlPlaybackRate"], ["featuresSourceset", "canOverrideAttributes"], ["featuresNativeTextTracks", "supportsNativeTextTracks"], ["featuresNativeVideoTracks", "supportsNativeVideoTracks"], ["featuresNativeAudioTracks", "supportsNativeAudioTracks"]].forEach(function([key, fn]) {
  defineLazyProperty(Html5.prototype, key, () => Html5[fn](), true);
});
Html5.prototype.featuresVolumeControl = Html5.canControlVolume();
Html5.prototype.movingMediaElementInDOM = !IS_IOS;
Html5.prototype.featuresFullscreenResize = true;
Html5.prototype.featuresProgressEvents = true;
Html5.prototype.featuresTimeupdateEvents = true;
Html5.prototype.featuresVideoFrameCallback = !!(Html5.TEST_VID && Html5.TEST_VID.requestVideoFrameCallback);
Html5.disposeMediaElement = function(el) {
  if (!el) {
    return;
  }
  if (el.parentNode) {
    el.parentNode.removeChild(el);
  }
  while (el.hasChildNodes()) {
    el.removeChild(el.firstChild);
  }
  el.removeAttribute("src");
  if (typeof el.load === "function") {
    (function() {
      try {
        el.load();
      } catch (e) {
      }
    })();
  }
};
Html5.resetMediaElement = function(el) {
  if (!el) {
    return;
  }
  const sources = el.querySelectorAll("source");
  let i = sources.length;
  while (i--) {
    el.removeChild(sources[i]);
  }
  el.removeAttribute("src");
  if (typeof el.load === "function") {
    (function() {
      try {
        el.load();
      } catch (e) {
      }
    })();
  }
};
[
  "muted",
  "defaultMuted",
  "autoplay",
  "controls",
  "loop",
  "playsinline"
].forEach(function(prop) {
  Html5.prototype[prop] = function() {
    return this.el_[prop] || this.el_.hasAttribute(prop);
  };
});
[
  "muted",
  "defaultMuted",
  "autoplay",
  "loop",
  "playsinline"
].forEach(function(prop) {
  Html5.prototype["set" + toTitleCase$1(prop)] = function(v) {
    this.el_[prop] = v;
    if (v) {
      this.el_.setAttribute(prop, prop);
    } else {
      this.el_.removeAttribute(prop);
    }
  };
});
[
  "paused",
  "currentTime",
  "buffered",
  "volume",
  "poster",
  "preload",
  "error",
  "seeking",
  "seekable",
  "ended",
  "playbackRate",
  "defaultPlaybackRate",
  "disablePictureInPicture",
  "played",
  "networkState",
  "readyState",
  "videoWidth",
  "videoHeight",
  "crossOrigin"
].forEach(function(prop) {
  Html5.prototype[prop] = function() {
    return this.el_[prop];
  };
});
[
  "volume",
  "src",
  "poster",
  "preload",
  "playbackRate",
  "defaultPlaybackRate",
  "disablePictureInPicture",
  "crossOrigin"
].forEach(function(prop) {
  Html5.prototype["set" + toTitleCase$1(prop)] = function(v) {
    this.el_[prop] = v;
  };
});
[
  "pause",
  "load",
  "play"
].forEach(function(prop) {
  Html5.prototype[prop] = function() {
    return this.el_[prop]();
  };
});
Tech.withSourceHandlers(Html5);
Html5.nativeSourceHandler = {};
Html5.nativeSourceHandler.canPlayType = function(type) {
  try {
    return Html5.TEST_VID.canPlayType(type);
  } catch (e) {
    return "";
  }
};
Html5.nativeSourceHandler.canHandleSource = function(source, options) {
  if (source.type) {
    return Html5.nativeSourceHandler.canPlayType(source.type);
  } else if (source.src) {
    const ext = getFileExtension(source.src);
    return Html5.nativeSourceHandler.canPlayType(`video/${ext}`);
  }
  return "";
};
Html5.nativeSourceHandler.handleSource = function(source, tech, options) {
  tech.setSrc(source.src);
};
Html5.nativeSourceHandler.dispose = function() {
};
Html5.registerSourceHandler(Html5.nativeSourceHandler);
Tech.registerTech("Html5", Html5);
const TECH_EVENTS_RETRIGGER = [
  "progress",
  "abort",
  "suspend",
  "emptied",
  "stalled",
  "loadedmetadata",
  "loadeddata",
  "timeupdate",
  "resize",
  "volumechange",
  "texttrackchange"
];
const TECH_EVENTS_QUEUE = {
  canplay: "CanPlay",
  canplaythrough: "CanPlayThrough",
  playing: "Playing",
  seeked: "Seeked"
};
const BREAKPOINT_ORDER = ["tiny", "xsmall", "small", "medium", "large", "xlarge", "huge"];
const BREAKPOINT_CLASSES = {};
BREAKPOINT_ORDER.forEach((k) => {
  const v = k.charAt(0) === "x" ? `x-${k.substring(1)}` : k;
  BREAKPOINT_CLASSES[k] = `vjs-layout-${v}`;
});
const DEFAULT_BREAKPOINTS = {
  tiny: 210,
  xsmall: 320,
  small: 425,
  medium: 768,
  large: 1440,
  xlarge: 2560,
  huge: Infinity
};
class Player extends Component$1 {
  constructor(tag, options, ready) {
    tag.id = tag.id || options.id || `vjs_video_${newGUID()}`;
    options = Object.assign(Player.getTagSettings(tag), options);
    options.initChildren = false;
    options.createEl = false;
    options.evented = false;
    options.reportTouchActivity = false;
    if (!options.language) {
      const closest = tag.closest("[lang]");
      if (closest) {
        options.language = closest.getAttribute("lang");
      }
    }
    super(null, options, ready);
    this.boundDocumentFullscreenChange_ = (e) => this.documentFullscreenChange_(e);
    this.boundFullWindowOnEscKey_ = (e) => this.fullWindowOnEscKey(e);
    this.boundUpdateStyleEl_ = (e) => this.updateStyleEl_(e);
    this.boundApplyInitTime_ = (e) => this.applyInitTime_(e);
    this.boundUpdateCurrentBreakpoint_ = (e) => this.updateCurrentBreakpoint_(e);
    this.boundHandleTechClick_ = (e) => this.handleTechClick_(e);
    this.boundHandleTechDoubleClick_ = (e) => this.handleTechDoubleClick_(e);
    this.boundHandleTechTouchStart_ = (e) => this.handleTechTouchStart_(e);
    this.boundHandleTechTouchMove_ = (e) => this.handleTechTouchMove_(e);
    this.boundHandleTechTouchEnd_ = (e) => this.handleTechTouchEnd_(e);
    this.boundHandleTechTap_ = (e) => this.handleTechTap_(e);
    this.boundUpdatePlayerHeightOnAudioOnlyMode_ = (e) => this.updatePlayerHeightOnAudioOnlyMode_(e);
    this.isFullscreen_ = false;
    this.log = createLogger(this.id_);
    this.fsApi_ = FullscreenApi;
    this.isPosterFromTech_ = false;
    this.queuedCallbacks_ = [];
    this.isReady_ = false;
    this.hasStarted_ = false;
    this.userActive_ = false;
    this.debugEnabled_ = false;
    this.audioOnlyMode_ = false;
    this.audioPosterMode_ = false;
    this.audioOnlyCache_ = {
      controlBarHeight: null,
      playerHeight: null,
      hiddenChildren: []
    };
    if (!this.options_ || !this.options_.techOrder || !this.options_.techOrder.length) {
      throw new Error("No techOrder specified. Did you overwrite videojs.options instead of just changing the properties you want to override?");
    }
    this.tag = tag;
    this.tagAttributes = tag && getAttributes(tag);
    this.language(this.options_.language);
    if (options.languages) {
      const languagesToLower = {};
      Object.getOwnPropertyNames(options.languages).forEach(function(name) {
        languagesToLower[name.toLowerCase()] = options.languages[name];
      });
      this.languages_ = languagesToLower;
    } else {
      this.languages_ = Player.prototype.options_.languages;
    }
    this.resetCache_();
    this.poster_ = options.poster || "";
    this.controls_ = !!options.controls;
    tag.controls = false;
    tag.removeAttribute("controls");
    this.changingSrc_ = false;
    this.playCallbacks_ = [];
    this.playTerminatedQueue_ = [];
    if (tag.hasAttribute("autoplay")) {
      this.autoplay(true);
    } else {
      this.autoplay(this.options_.autoplay);
    }
    if (options.plugins) {
      Object.keys(options.plugins).forEach((name) => {
        if (typeof this[name] !== "function") {
          throw new Error(`plugin "${name}" does not exist`);
        }
      });
    }
    this.scrubbing_ = false;
    this.el_ = this.createEl();
    evented(this, {
      eventBusKey: "el_"
    });
    if (this.fsApi_.requestFullscreen) {
      on(document_1, this.fsApi_.fullscreenchange, this.boundDocumentFullscreenChange_);
      this.on(this.fsApi_.fullscreenchange, this.boundDocumentFullscreenChange_);
    }
    if (this.fluid_) {
      this.on(["playerreset", "resize"], this.boundUpdateStyleEl_);
    }
    const playerOptionsCopy = merge$1(this.options_);
    if (options.plugins) {
      Object.keys(options.plugins).forEach((name) => {
        this[name](options.plugins[name]);
      });
    }
    if (options.debug) {
      this.debug(true);
    }
    this.options_.playerOptions = playerOptionsCopy;
    this.middleware_ = [];
    this.playbackRates(options.playbackRates);
    if (options.experimentalSvgIcons) {
      const parser = new window_1.DOMParser();
      const parsedSVG = parser.parseFromString(icons, "image/svg+xml");
      const errorNode = parsedSVG.querySelector("parsererror");
      if (errorNode) {
        log$1.warn("Failed to load SVG Icons. Falling back to Font Icons.");
        this.options_.experimentalSvgIcons = null;
      } else {
        const sprite = parsedSVG.documentElement;
        sprite.style.display = "none";
        this.el_.appendChild(sprite);
        this.addClass("vjs-svg-icons-enabled");
      }
    }
    this.initChildren();
    this.isAudio(tag.nodeName.toLowerCase() === "audio");
    if (this.controls()) {
      this.addClass("vjs-controls-enabled");
    } else {
      this.addClass("vjs-controls-disabled");
    }
    this.el_.setAttribute("role", "region");
    if (this.isAudio()) {
      this.el_.setAttribute("aria-label", this.localize("Audio Player"));
    } else {
      this.el_.setAttribute("aria-label", this.localize("Video Player"));
    }
    if (this.isAudio()) {
      this.addClass("vjs-audio");
    }
    if (options.spatialNavigation && options.spatialNavigation.enabled) {
      this.spatialNavigation = new SpatialNavigation(this);
      this.addClass("vjs-spatial-navigation-enabled");
    }
    if (TOUCH_ENABLED) {
      this.addClass("vjs-touch-enabled");
    }
    if (!IS_IOS) {
      this.addClass("vjs-workinghover");
    }
    Player.players[this.id_] = this;
    const majorVersion = version$6.split(".")[0];
    this.addClass(`vjs-v${majorVersion}`);
    this.userActive(true);
    this.reportUserActivity();
    this.one("play", (e) => this.listenForUserActivity_(e));
    this.on("keydown", (e) => this.handleKeyDown(e));
    this.on("languagechange", (e) => this.handleLanguagechange(e));
    this.breakpoints(this.options_.breakpoints);
    this.responsive(this.options_.responsive);
    this.on("ready", () => {
      this.audioPosterMode(this.options_.audioPosterMode);
      this.audioOnlyMode(this.options_.audioOnlyMode);
    });
  }
  dispose() {
    this.trigger("dispose");
    this.off("dispose");
    off(document_1, this.fsApi_.fullscreenchange, this.boundDocumentFullscreenChange_);
    off(document_1, "keydown", this.boundFullWindowOnEscKey_);
    if (this.styleEl_ && this.styleEl_.parentNode) {
      this.styleEl_.parentNode.removeChild(this.styleEl_);
      this.styleEl_ = null;
    }
    Player.players[this.id_] = null;
    if (this.tag && this.tag.player) {
      this.tag.player = null;
    }
    if (this.el_ && this.el_.player) {
      this.el_.player = null;
    }
    if (this.tech_) {
      this.tech_.dispose();
      this.isPosterFromTech_ = false;
      this.poster_ = "";
    }
    if (this.playerElIngest_) {
      this.playerElIngest_ = null;
    }
    if (this.tag) {
      this.tag = null;
    }
    clearCacheForPlayer(this);
    ALL.names.forEach((name) => {
      const props = ALL[name];
      const list = this[props.getterName]();
      if (list && list.off) {
        list.off();
      }
    });
    super.dispose({
      restoreEl: this.options_.restoreEl
    });
  }
  createEl() {
    let tag = this.tag;
    let el;
    let playerElIngest = this.playerElIngest_ = tag.parentNode && tag.parentNode.hasAttribute && tag.parentNode.hasAttribute("data-vjs-player");
    const divEmbed = this.tag.tagName.toLowerCase() === "video-js";
    if (playerElIngest) {
      el = this.el_ = tag.parentNode;
    } else if (!divEmbed) {
      el = this.el_ = super.createEl("div");
    }
    const attrs = getAttributes(tag);
    if (divEmbed) {
      el = this.el_ = tag;
      tag = this.tag = document_1.createElement("video");
      while (el.children.length) {
        tag.appendChild(el.firstChild);
      }
      if (!hasClass(el, "video-js")) {
        addClass(el, "video-js");
      }
      el.appendChild(tag);
      playerElIngest = this.playerElIngest_ = el;
      Object.keys(el).forEach((k) => {
        try {
          tag[k] = el[k];
        } catch (e) {
        }
      });
    }
    tag.setAttribute("tabindex", "-1");
    attrs.tabindex = "-1";
    if (IS_CHROME && IS_WINDOWS) {
      tag.setAttribute("role", "application");
      attrs.role = "application";
    }
    tag.removeAttribute("width");
    tag.removeAttribute("height");
    if ("width" in attrs) {
      delete attrs.width;
    }
    if ("height" in attrs) {
      delete attrs.height;
    }
    Object.getOwnPropertyNames(attrs).forEach(function(attr) {
      if (!(divEmbed && attr === "class")) {
        el.setAttribute(attr, attrs[attr]);
      }
      if (divEmbed) {
        tag.setAttribute(attr, attrs[attr]);
      }
    });
    tag.playerId = tag.id;
    tag.id += "_html5_api";
    tag.className = "vjs-tech";
    tag.player = el.player = this;
    this.addClass("vjs-paused");
    const deviceClassNames = ["IS_SMART_TV", "IS_TIZEN", "IS_WEBOS", "IS_ANDROID", "IS_IPAD", "IS_IPHONE", "IS_CHROMECAST_RECEIVER"].filter((key) => browser[key]).map((key) => {
      return "vjs-device-" + key.substring(3).toLowerCase().replace(/\_/g, "-");
    });
    this.addClass(...deviceClassNames);
    if (window_1.VIDEOJS_NO_DYNAMIC_STYLE !== true) {
      this.styleEl_ = createStyleElement("vjs-styles-dimensions");
      const defaultsStyleEl = $(".vjs-styles-defaults");
      const head = $("head");
      head.insertBefore(this.styleEl_, defaultsStyleEl ? defaultsStyleEl.nextSibling : head.firstChild);
    }
    this.fill_ = false;
    this.fluid_ = false;
    this.width(this.options_.width);
    this.height(this.options_.height);
    this.fill(this.options_.fill);
    this.fluid(this.options_.fluid);
    this.aspectRatio(this.options_.aspectRatio);
    this.crossOrigin(this.options_.crossOrigin || this.options_.crossorigin);
    const links = tag.getElementsByTagName("a");
    for (let i = 0; i < links.length; i++) {
      const linkEl = links.item(i);
      addClass(linkEl, "vjs-hidden");
      linkEl.setAttribute("hidden", "hidden");
    }
    tag.initNetworkState_ = tag.networkState;
    if (tag.parentNode && !playerElIngest) {
      tag.parentNode.insertBefore(el, tag);
    }
    prependTo(tag, el);
    this.children_.unshift(tag);
    this.el_.setAttribute("lang", this.language_);
    this.el_.setAttribute("translate", "no");
    this.el_ = el;
    return el;
  }
  crossOrigin(value) {
    if (typeof value === "undefined") {
      return this.techGet_("crossOrigin");
    }
    if (value !== null && value !== "anonymous" && value !== "use-credentials") {
      log$1.warn(`crossOrigin must be null,  "anonymous" or "use-credentials", given "${value}"`);
      return;
    }
    this.techCall_("setCrossOrigin", value);
    if (this.posterImage) {
      this.posterImage.crossOrigin(value);
    }
    return;
  }
  width(value) {
    return this.dimension("width", value);
  }
  height(value) {
    return this.dimension("height", value);
  }
  dimension(dimension, value) {
    const privDimension = dimension + "_";
    if (value === void 0) {
      return this[privDimension] || 0;
    }
    if (value === "" || value === "auto") {
      this[privDimension] = void 0;
      this.updateStyleEl_();
      return;
    }
    const parsedVal = parseFloat(value);
    if (isNaN(parsedVal)) {
      log$1.error(`Improper value "${value}" supplied for for ${dimension}`);
      return;
    }
    this[privDimension] = parsedVal;
    this.updateStyleEl_();
  }
  fluid(bool) {
    if (bool === void 0) {
      return !!this.fluid_;
    }
    this.fluid_ = !!bool;
    if (isEvented(this)) {
      this.off(["playerreset", "resize"], this.boundUpdateStyleEl_);
    }
    if (bool) {
      this.addClass("vjs-fluid");
      this.fill(false);
      addEventedCallback(this, () => {
        this.on(["playerreset", "resize"], this.boundUpdateStyleEl_);
      });
    } else {
      this.removeClass("vjs-fluid");
    }
    this.updateStyleEl_();
  }
  fill(bool) {
    if (bool === void 0) {
      return !!this.fill_;
    }
    this.fill_ = !!bool;
    if (bool) {
      this.addClass("vjs-fill");
      this.fluid(false);
    } else {
      this.removeClass("vjs-fill");
    }
  }
  aspectRatio(ratio) {
    if (ratio === void 0) {
      return this.aspectRatio_;
    }
    if (!/^\d+\:\d+$/.test(ratio)) {
      throw new Error("Improper value supplied for aspect ratio. The format should be width:height, for example 16:9.");
    }
    this.aspectRatio_ = ratio;
    this.fluid(true);
    this.updateStyleEl_();
  }
  updateStyleEl_() {
    if (window_1.VIDEOJS_NO_DYNAMIC_STYLE === true) {
      const width2 = typeof this.width_ === "number" ? this.width_ : this.options_.width;
      const height2 = typeof this.height_ === "number" ? this.height_ : this.options_.height;
      const techEl = this.tech_ && this.tech_.el();
      if (techEl) {
        if (width2 >= 0) {
          techEl.width = width2;
        }
        if (height2 >= 0) {
          techEl.height = height2;
        }
      }
      return;
    }
    let width;
    let height;
    let aspectRatio;
    let idClass;
    if (this.aspectRatio_ !== void 0 && this.aspectRatio_ !== "auto") {
      aspectRatio = this.aspectRatio_;
    } else if (this.videoWidth() > 0) {
      aspectRatio = this.videoWidth() + ":" + this.videoHeight();
    } else {
      aspectRatio = "16:9";
    }
    const ratioParts = aspectRatio.split(":");
    const ratioMultiplier = ratioParts[1] / ratioParts[0];
    if (this.width_ !== void 0) {
      width = this.width_;
    } else if (this.height_ !== void 0) {
      width = this.height_ / ratioMultiplier;
    } else {
      width = this.videoWidth() || 300;
    }
    if (this.height_ !== void 0) {
      height = this.height_;
    } else {
      height = width * ratioMultiplier;
    }
    if (/^[^a-zA-Z]/.test(this.id())) {
      idClass = "dimensions-" + this.id();
    } else {
      idClass = this.id() + "-dimensions";
    }
    this.addClass(idClass);
    setTextContent(this.styleEl_, `
      .${idClass} {
        width: ${width}px;
        height: ${height}px;
      }

      .${idClass}.vjs-fluid:not(.vjs-audio-only-mode) {
        padding-top: ${ratioMultiplier * 100}%;
      }
    `);
  }
  loadTech_(techName, source) {
    if (this.tech_) {
      this.unloadTech_();
    }
    const titleTechName = toTitleCase$1(techName);
    const camelTechName = techName.charAt(0).toLowerCase() + techName.slice(1);
    if (titleTechName !== "Html5" && this.tag) {
      Tech.getTech("Html5").disposeMediaElement(this.tag);
      this.tag.player = null;
      this.tag = null;
    }
    this.techName_ = titleTechName;
    this.isReady_ = false;
    let autoplay = this.autoplay();
    if (typeof this.autoplay() === "string" || this.autoplay() === true && this.options_.normalizeAutoplay) {
      autoplay = false;
    }
    const techOptions = {
      source,
      autoplay,
      "nativeControlsForTouch": this.options_.nativeControlsForTouch,
      "playerId": this.id(),
      "techId": `${this.id()}_${camelTechName}_api`,
      "playsinline": this.options_.playsinline,
      "preload": this.options_.preload,
      "loop": this.options_.loop,
      "disablePictureInPicture": this.options_.disablePictureInPicture,
      "muted": this.options_.muted,
      "poster": this.poster(),
      "language": this.language(),
      "playerElIngest": this.playerElIngest_ || false,
      "vtt.js": this.options_["vtt.js"],
      "canOverridePoster": !!this.options_.techCanOverridePoster,
      "enableSourceset": this.options_.enableSourceset
    };
    ALL.names.forEach((name) => {
      const props = ALL[name];
      techOptions[props.getterName] = this[props.privateName];
    });
    Object.assign(techOptions, this.options_[titleTechName]);
    Object.assign(techOptions, this.options_[camelTechName]);
    Object.assign(techOptions, this.options_[techName.toLowerCase()]);
    if (this.tag) {
      techOptions.tag = this.tag;
    }
    if (source && source.src === this.cache_.src && this.cache_.currentTime > 0) {
      techOptions.startTime = this.cache_.currentTime;
    }
    const TechClass = Tech.getTech(techName);
    if (!TechClass) {
      throw new Error(`No Tech named '${titleTechName}' exists! '${titleTechName}' should be registered using videojs.registerTech()'`);
    }
    this.tech_ = new TechClass(techOptions);
    this.tech_.ready(bind_(this, this.handleTechReady_), true);
    textTrackConverter.jsonToTextTracks(this.textTracksJson_ || [], this.tech_);
    TECH_EVENTS_RETRIGGER.forEach((event) => {
      this.on(this.tech_, event, (e) => this[`handleTech${toTitleCase$1(event)}_`](e));
    });
    Object.keys(TECH_EVENTS_QUEUE).forEach((event) => {
      this.on(this.tech_, event, (eventObj) => {
        if (this.tech_.playbackRate() === 0 && this.tech_.seeking()) {
          this.queuedCallbacks_.push({
            callback: this[`handleTech${TECH_EVENTS_QUEUE[event]}_`].bind(this),
            event: eventObj
          });
          return;
        }
        this[`handleTech${TECH_EVENTS_QUEUE[event]}_`](eventObj);
      });
    });
    this.on(this.tech_, "loadstart", (e) => this.handleTechLoadStart_(e));
    this.on(this.tech_, "sourceset", (e) => this.handleTechSourceset_(e));
    this.on(this.tech_, "waiting", (e) => this.handleTechWaiting_(e));
    this.on(this.tech_, "ended", (e) => this.handleTechEnded_(e));
    this.on(this.tech_, "seeking", (e) => this.handleTechSeeking_(e));
    this.on(this.tech_, "play", (e) => this.handleTechPlay_(e));
    this.on(this.tech_, "pause", (e) => this.handleTechPause_(e));
    this.on(this.tech_, "durationchange", (e) => this.handleTechDurationChange_(e));
    this.on(this.tech_, "fullscreenchange", (e, data) => this.handleTechFullscreenChange_(e, data));
    this.on(this.tech_, "fullscreenerror", (e, err) => this.handleTechFullscreenError_(e, err));
    this.on(this.tech_, "enterpictureinpicture", (e) => this.handleTechEnterPictureInPicture_(e));
    this.on(this.tech_, "leavepictureinpicture", (e) => this.handleTechLeavePictureInPicture_(e));
    this.on(this.tech_, "error", (e) => this.handleTechError_(e));
    this.on(this.tech_, "posterchange", (e) => this.handleTechPosterChange_(e));
    this.on(this.tech_, "textdata", (e) => this.handleTechTextData_(e));
    this.on(this.tech_, "ratechange", (e) => this.handleTechRateChange_(e));
    this.on(this.tech_, "loadedmetadata", this.boundUpdateStyleEl_);
    this.usingNativeControls(this.techGet_("controls"));
    if (this.controls() && !this.usingNativeControls()) {
      this.addTechControlsListeners_();
    }
    if (this.tech_.el().parentNode !== this.el() && (titleTechName !== "Html5" || !this.tag)) {
      prependTo(this.tech_.el(), this.el());
    }
    if (this.tag) {
      this.tag.player = null;
      this.tag = null;
    }
  }
  unloadTech_() {
    ALL.names.forEach((name) => {
      const props = ALL[name];
      this[props.privateName] = this[props.getterName]();
    });
    this.textTracksJson_ = textTrackConverter.textTracksToJson(this.tech_);
    this.isReady_ = false;
    this.tech_.dispose();
    this.tech_ = false;
    if (this.isPosterFromTech_) {
      this.poster_ = "";
      this.trigger("posterchange");
    }
    this.isPosterFromTech_ = false;
  }
  tech(safety) {
    if (safety === void 0) {
      log$1.warn("Using the tech directly can be dangerous. I hope you know what you're doing.\nSee https://github.com/videojs/video.js/issues/2617 for more info.\n");
    }
    return this.tech_;
  }
  version() {
    return {
      "video.js": version$6
    };
  }
  addTechControlsListeners_() {
    this.removeTechControlsListeners_();
    this.on(this.tech_, "click", this.boundHandleTechClick_);
    this.on(this.tech_, "dblclick", this.boundHandleTechDoubleClick_);
    this.on(this.tech_, "touchstart", this.boundHandleTechTouchStart_);
    this.on(this.tech_, "touchmove", this.boundHandleTechTouchMove_);
    this.on(this.tech_, "touchend", this.boundHandleTechTouchEnd_);
    this.on(this.tech_, "tap", this.boundHandleTechTap_);
  }
  removeTechControlsListeners_() {
    this.off(this.tech_, "tap", this.boundHandleTechTap_);
    this.off(this.tech_, "touchstart", this.boundHandleTechTouchStart_);
    this.off(this.tech_, "touchmove", this.boundHandleTechTouchMove_);
    this.off(this.tech_, "touchend", this.boundHandleTechTouchEnd_);
    this.off(this.tech_, "click", this.boundHandleTechClick_);
    this.off(this.tech_, "dblclick", this.boundHandleTechDoubleClick_);
  }
  handleTechReady_() {
    this.triggerReady();
    if (this.cache_.volume) {
      this.techCall_("setVolume", this.cache_.volume);
    }
    this.handleTechPosterChange_();
    this.handleTechDurationChange_();
  }
  handleTechLoadStart_() {
    this.removeClass("vjs-ended", "vjs-seeking");
    this.error(null);
    this.handleTechDurationChange_();
    if (!this.paused()) {
      this.trigger("loadstart");
    } else {
      this.hasStarted(false);
      this.trigger("loadstart");
    }
    this.manualAutoplay_(this.autoplay() === true && this.options_.normalizeAutoplay ? "play" : this.autoplay());
  }
  manualAutoplay_(type) {
    if (!this.tech_ || typeof type !== "string") {
      return;
    }
    const resolveMuted = () => {
      const previouslyMuted = this.muted();
      this.muted(true);
      const restoreMuted = () => {
        this.muted(previouslyMuted);
      };
      this.playTerminatedQueue_.push(restoreMuted);
      const mutedPromise = this.play();
      if (!isPromise(mutedPromise)) {
        return;
      }
      return mutedPromise.catch((err) => {
        restoreMuted();
        throw new Error(`Rejection at manualAutoplay. Restoring muted value. ${err ? err : ""}`);
      });
    };
    let promise;
    if (type === "any" && !this.muted()) {
      promise = this.play();
      if (isPromise(promise)) {
        promise = promise.catch(resolveMuted);
      }
    } else if (type === "muted" && !this.muted()) {
      promise = resolveMuted();
    } else {
      promise = this.play();
    }
    if (!isPromise(promise)) {
      return;
    }
    return promise.then(() => {
      this.trigger({
        type: "autoplay-success",
        autoplay: type
      });
    }).catch(() => {
      this.trigger({
        type: "autoplay-failure",
        autoplay: type
      });
    });
  }
  updateSourceCaches_(srcObj = "") {
    let src = srcObj;
    let type = "";
    if (typeof src !== "string") {
      src = srcObj.src;
      type = srcObj.type;
    }
    this.cache_.source = this.cache_.source || {};
    this.cache_.sources = this.cache_.sources || [];
    if (src && !type) {
      type = findMimetype(this, src);
    }
    this.cache_.source = merge$1({}, srcObj, {
      src,
      type
    });
    const matchingSources = this.cache_.sources.filter((s) => s.src && s.src === src);
    const sourceElSources = [];
    const sourceEls = this.$$("source");
    const matchingSourceEls = [];
    for (let i = 0; i < sourceEls.length; i++) {
      const sourceObj = getAttributes(sourceEls[i]);
      sourceElSources.push(sourceObj);
      if (sourceObj.src && sourceObj.src === src) {
        matchingSourceEls.push(sourceObj.src);
      }
    }
    if (matchingSourceEls.length && !matchingSources.length) {
      this.cache_.sources = sourceElSources;
    } else if (!matchingSources.length) {
      this.cache_.sources = [this.cache_.source];
    }
    this.cache_.src = src;
  }
  handleTechSourceset_(event) {
    if (!this.changingSrc_) {
      let updateSourceCaches = (src) => this.updateSourceCaches_(src);
      const playerSrc = this.currentSource().src;
      const eventSrc = event.src;
      if (playerSrc && !/^blob:/.test(playerSrc) && /^blob:/.test(eventSrc)) {
        if (!this.lastSource_ || this.lastSource_.tech !== eventSrc && this.lastSource_.player !== playerSrc) {
          updateSourceCaches = () => {
          };
        }
      }
      updateSourceCaches(eventSrc);
      if (!event.src) {
        this.tech_.any(["sourceset", "loadstart"], (e) => {
          if (e.type === "sourceset") {
            return;
          }
          const techSrc = this.techGet_("currentSrc");
          this.lastSource_.tech = techSrc;
          this.updateSourceCaches_(techSrc);
        });
      }
    }
    this.lastSource_ = {
      player: this.currentSource().src,
      tech: event.src
    };
    this.trigger({
      src: event.src,
      type: "sourceset"
    });
  }
  hasStarted(request) {
    if (request === void 0) {
      return this.hasStarted_;
    }
    if (request === this.hasStarted_) {
      return;
    }
    this.hasStarted_ = request;
    if (this.hasStarted_) {
      this.addClass("vjs-has-started");
    } else {
      this.removeClass("vjs-has-started");
    }
  }
  handleTechPlay_() {
    this.removeClass("vjs-ended", "vjs-paused");
    this.addClass("vjs-playing");
    this.hasStarted(true);
    this.trigger("play");
  }
  handleTechRateChange_() {
    if (this.tech_.playbackRate() > 0 && this.cache_.lastPlaybackRate === 0) {
      this.queuedCallbacks_.forEach((queued) => queued.callback(queued.event));
      this.queuedCallbacks_ = [];
    }
    this.cache_.lastPlaybackRate = this.tech_.playbackRate();
    this.trigger("ratechange");
  }
  handleTechWaiting_() {
    this.addClass("vjs-waiting");
    this.trigger("waiting");
    const timeWhenWaiting = this.currentTime();
    const timeUpdateListener = () => {
      if (timeWhenWaiting !== this.currentTime()) {
        this.removeClass("vjs-waiting");
        this.off("timeupdate", timeUpdateListener);
      }
    };
    this.on("timeupdate", timeUpdateListener);
  }
  handleTechCanPlay_() {
    this.removeClass("vjs-waiting");
    this.trigger("canplay");
  }
  handleTechCanPlayThrough_() {
    this.removeClass("vjs-waiting");
    this.trigger("canplaythrough");
  }
  handleTechPlaying_() {
    this.removeClass("vjs-waiting");
    this.trigger("playing");
  }
  handleTechSeeking_() {
    this.addClass("vjs-seeking");
    this.trigger("seeking");
  }
  handleTechSeeked_() {
    this.removeClass("vjs-seeking", "vjs-ended");
    this.trigger("seeked");
  }
  handleTechPause_() {
    this.removeClass("vjs-playing");
    this.addClass("vjs-paused");
    this.trigger("pause");
  }
  handleTechEnded_() {
    this.addClass("vjs-ended");
    this.removeClass("vjs-waiting");
    if (this.options_.loop) {
      this.currentTime(0);
      this.play();
    } else if (!this.paused()) {
      this.pause();
    }
    this.trigger("ended");
  }
  handleTechDurationChange_() {
    this.duration(this.techGet_("duration"));
  }
  handleTechClick_(event) {
    if (!this.controls_) {
      return;
    }
    if (this.options_ === void 0 || this.options_.userActions === void 0 || this.options_.userActions.click === void 0 || this.options_.userActions.click !== false) {
      if (this.options_ !== void 0 && this.options_.userActions !== void 0 && typeof this.options_.userActions.click === "function") {
        this.options_.userActions.click.call(this, event);
      } else if (this.paused()) {
        silencePromise(this.play());
      } else {
        this.pause();
      }
    }
  }
  handleTechDoubleClick_(event) {
    if (!this.controls_) {
      return;
    }
    const inAllowedEls = Array.prototype.some.call(this.$$(".vjs-control-bar, .vjs-modal-dialog"), (el) => el.contains(event.target));
    if (!inAllowedEls) {
      if (this.options_ === void 0 || this.options_.userActions === void 0 || this.options_.userActions.doubleClick === void 0 || this.options_.userActions.doubleClick !== false) {
        if (this.options_ !== void 0 && this.options_.userActions !== void 0 && typeof this.options_.userActions.doubleClick === "function") {
          this.options_.userActions.doubleClick.call(this, event);
        } else if (this.isInPictureInPicture() && !document_1.pictureInPictureElement) {
          this.exitPictureInPicture();
        } else if (this.isFullscreen()) {
          this.exitFullscreen();
        } else {
          this.requestFullscreen();
        }
      }
    }
  }
  handleTechTap_() {
    this.userActive(!this.userActive());
  }
  handleTechTouchStart_() {
    this.userWasActive = this.userActive();
  }
  handleTechTouchMove_() {
    if (this.userWasActive) {
      this.reportUserActivity();
    }
  }
  handleTechTouchEnd_(event) {
    if (event.cancelable) {
      event.preventDefault();
    }
  }
  toggleFullscreenClass_() {
    if (this.isFullscreen()) {
      this.addClass("vjs-fullscreen");
    } else {
      this.removeClass("vjs-fullscreen");
    }
  }
  documentFullscreenChange_(e) {
    const targetPlayer = e.target.player;
    if (targetPlayer && targetPlayer !== this) {
      return;
    }
    const el = this.el();
    let isFs = document_1[this.fsApi_.fullscreenElement] === el;
    if (!isFs && el.matches) {
      isFs = el.matches(":" + this.fsApi_.fullscreen);
    }
    this.isFullscreen(isFs);
  }
  handleTechFullscreenChange_(event, data) {
    if (data) {
      if (data.nativeIOSFullscreen) {
        this.addClass("vjs-ios-native-fs");
        this.tech_.one("webkitendfullscreen", () => {
          this.removeClass("vjs-ios-native-fs");
        });
      }
      this.isFullscreen(data.isFullscreen);
    }
  }
  handleTechFullscreenError_(event, err) {
    this.trigger("fullscreenerror", err);
  }
  togglePictureInPictureClass_() {
    if (this.isInPictureInPicture()) {
      this.addClass("vjs-picture-in-picture");
    } else {
      this.removeClass("vjs-picture-in-picture");
    }
  }
  handleTechEnterPictureInPicture_(event) {
    this.isInPictureInPicture(true);
  }
  handleTechLeavePictureInPicture_(event) {
    this.isInPictureInPicture(false);
  }
  handleTechError_() {
    const error = this.tech_.error();
    if (error) {
      this.error(error);
    }
  }
  handleTechTextData_() {
    let data = null;
    if (arguments.length > 1) {
      data = arguments[1];
    }
    this.trigger("textdata", data);
  }
  getCache() {
    return this.cache_;
  }
  resetCache_() {
    this.cache_ = {
      currentTime: 0,
      initTime: 0,
      inactivityTimeout: this.options_.inactivityTimeout,
      duration: NaN,
      lastVolume: 1,
      lastPlaybackRate: this.defaultPlaybackRate(),
      media: null,
      src: "",
      source: {},
      sources: [],
      playbackRates: [],
      volume: 1
    };
  }
  techCall_(method, arg) {
    this.ready(function() {
      if (method in allowedSetters) {
        return set(this.middleware_, this.tech_, method, arg);
      } else if (method in allowedMediators) {
        return mediate(this.middleware_, this.tech_, method, arg);
      }
      try {
        if (this.tech_) {
          this.tech_[method](arg);
        }
      } catch (e) {
        log$1(e);
        throw e;
      }
    }, true);
  }
  techGet_(method) {
    if (!this.tech_ || !this.tech_.isReady_) {
      return;
    }
    if (method in allowedGetters) {
      return get(this.middleware_, this.tech_, method);
    } else if (method in allowedMediators) {
      return mediate(this.middleware_, this.tech_, method);
    }
    try {
      return this.tech_[method]();
    } catch (e) {
      if (this.tech_[method] === void 0) {
        log$1(`Video.js: ${method} method not defined for ${this.techName_} playback technology.`, e);
        throw e;
      }
      if (e.name === "TypeError") {
        log$1(`Video.js: ${method} unavailable on ${this.techName_} playback technology element.`, e);
        this.tech_.isReady_ = false;
        throw e;
      }
      log$1(e);
      throw e;
    }
  }
  play() {
    return new Promise((resolve) => {
      this.play_(resolve);
    });
  }
  play_(callback = silencePromise) {
    this.playCallbacks_.push(callback);
    const isSrcReady = Boolean(!this.changingSrc_ && (this.src() || this.currentSrc()));
    const isSafariOrIOS = Boolean(IS_ANY_SAFARI || IS_IOS);
    if (this.waitToPlay_) {
      this.off(["ready", "loadstart"], this.waitToPlay_);
      this.waitToPlay_ = null;
    }
    if (!this.isReady_ || !isSrcReady) {
      this.waitToPlay_ = (e) => {
        this.play_();
      };
      this.one(["ready", "loadstart"], this.waitToPlay_);
      if (!isSrcReady && isSafariOrIOS) {
        this.load();
      }
      return;
    }
    const val = this.techGet_("play");
    const isNativeReplay = isSafariOrIOS && this.hasClass("vjs-ended");
    if (isNativeReplay) {
      this.resetProgressBar_();
    }
    if (val === null) {
      this.runPlayTerminatedQueue_();
    } else {
      this.runPlayCallbacks_(val);
    }
  }
  runPlayTerminatedQueue_() {
    const queue = this.playTerminatedQueue_.slice(0);
    this.playTerminatedQueue_ = [];
    queue.forEach(function(q) {
      q();
    });
  }
  runPlayCallbacks_(val) {
    const callbacks = this.playCallbacks_.slice(0);
    this.playCallbacks_ = [];
    this.playTerminatedQueue_ = [];
    callbacks.forEach(function(cb) {
      cb(val);
    });
  }
  pause() {
    this.techCall_("pause");
  }
  paused() {
    return this.techGet_("paused") === false ? false : true;
  }
  played() {
    return this.techGet_("played") || createTimeRanges$1(0, 0);
  }
  scrubbing(isScrubbing) {
    if (typeof isScrubbing === "undefined") {
      return this.scrubbing_;
    }
    this.scrubbing_ = !!isScrubbing;
    this.techCall_("setScrubbing", this.scrubbing_);
    if (isScrubbing) {
      this.addClass("vjs-scrubbing");
    } else {
      this.removeClass("vjs-scrubbing");
    }
  }
  currentTime(seconds) {
    if (seconds === void 0) {
      this.cache_.currentTime = this.techGet_("currentTime") || 0;
      return this.cache_.currentTime;
    }
    if (seconds < 0) {
      seconds = 0;
    }
    if (!this.isReady_ || this.changingSrc_ || !this.tech_ || !this.tech_.isReady_) {
      this.cache_.initTime = seconds;
      this.off("canplay", this.boundApplyInitTime_);
      this.one("canplay", this.boundApplyInitTime_);
      return;
    }
    this.techCall_("setCurrentTime", seconds);
    this.cache_.initTime = 0;
    if (isFinite(seconds)) {
      this.cache_.currentTime = Number(seconds);
    }
  }
  applyInitTime_() {
    this.currentTime(this.cache_.initTime);
  }
  duration(seconds) {
    if (seconds === void 0) {
      return this.cache_.duration !== void 0 ? this.cache_.duration : NaN;
    }
    seconds = parseFloat(seconds);
    if (seconds < 0) {
      seconds = Infinity;
    }
    if (seconds !== this.cache_.duration) {
      this.cache_.duration = seconds;
      if (seconds === Infinity) {
        this.addClass("vjs-live");
      } else {
        this.removeClass("vjs-live");
      }
      if (!isNaN(seconds)) {
        this.trigger("durationchange");
      }
    }
  }
  remainingTime() {
    return this.duration() - this.currentTime();
  }
  remainingTimeDisplay() {
    return Math.floor(this.duration()) - Math.floor(this.currentTime());
  }
  buffered() {
    let buffered = this.techGet_("buffered");
    if (!buffered || !buffered.length) {
      buffered = createTimeRanges$1(0, 0);
    }
    return buffered;
  }
  seekable() {
    let seekable2 = this.techGet_("seekable");
    if (!seekable2 || !seekable2.length) {
      seekable2 = createTimeRanges$1(0, 0);
    }
    return seekable2;
  }
  seeking() {
    return this.techGet_("seeking");
  }
  ended() {
    return this.techGet_("ended");
  }
  networkState() {
    return this.techGet_("networkState");
  }
  readyState() {
    return this.techGet_("readyState");
  }
  bufferedPercent() {
    return bufferedPercent(this.buffered(), this.duration());
  }
  bufferedEnd() {
    const buffered = this.buffered();
    const duration2 = this.duration();
    let end = buffered.end(buffered.length - 1);
    if (end > duration2) {
      end = duration2;
    }
    return end;
  }
  volume(percentAsDecimal) {
    let vol;
    if (percentAsDecimal !== void 0) {
      vol = Math.max(0, Math.min(1, percentAsDecimal));
      this.cache_.volume = vol;
      this.techCall_("setVolume", vol);
      if (vol > 0) {
        this.lastVolume_(vol);
      }
      return;
    }
    vol = parseFloat(this.techGet_("volume"));
    return isNaN(vol) ? 1 : vol;
  }
  muted(muted) {
    if (muted !== void 0) {
      this.techCall_("setMuted", muted);
      return;
    }
    return this.techGet_("muted") || false;
  }
  defaultMuted(defaultMuted) {
    if (defaultMuted !== void 0) {
      this.techCall_("setDefaultMuted", defaultMuted);
    }
    return this.techGet_("defaultMuted") || false;
  }
  lastVolume_(percentAsDecimal) {
    if (percentAsDecimal !== void 0 && percentAsDecimal !== 0) {
      this.cache_.lastVolume = percentAsDecimal;
      return;
    }
    return this.cache_.lastVolume;
  }
  supportsFullScreen() {
    return this.techGet_("supportsFullScreen") || false;
  }
  isFullscreen(isFS) {
    if (isFS !== void 0) {
      const oldValue = this.isFullscreen_;
      this.isFullscreen_ = Boolean(isFS);
      if (this.isFullscreen_ !== oldValue && this.fsApi_.prefixed) {
        this.trigger("fullscreenchange");
      }
      this.toggleFullscreenClass_();
      return;
    }
    return this.isFullscreen_;
  }
  requestFullscreen(fullscreenOptions) {
    if (this.isInPictureInPicture()) {
      this.exitPictureInPicture();
    }
    const self2 = this;
    return new Promise((resolve, reject) => {
      function offHandler() {
        self2.off("fullscreenerror", errorHandler);
        self2.off("fullscreenchange", changeHandler);
      }
      function changeHandler() {
        offHandler();
        resolve();
      }
      function errorHandler(e, err) {
        offHandler();
        reject(err);
      }
      self2.one("fullscreenchange", changeHandler);
      self2.one("fullscreenerror", errorHandler);
      const promise = self2.requestFullscreenHelper_(fullscreenOptions);
      if (promise) {
        promise.then(offHandler, offHandler);
        promise.then(resolve, reject);
      }
    });
  }
  requestFullscreenHelper_(fullscreenOptions) {
    let fsOptions;
    if (!this.fsApi_.prefixed) {
      fsOptions = this.options_.fullscreen && this.options_.fullscreen.options || {};
      if (fullscreenOptions !== void 0) {
        fsOptions = fullscreenOptions;
      }
    }
    if (this.fsApi_.requestFullscreen) {
      const promise = this.el_[this.fsApi_.requestFullscreen](fsOptions);
      if (promise) {
        promise.then(() => this.isFullscreen(true), () => this.isFullscreen(false));
      }
      return promise;
    } else if (this.tech_.supportsFullScreen() && !this.options_.preferFullWindow === true) {
      this.techCall_("enterFullScreen");
    } else {
      this.enterFullWindow();
    }
  }
  exitFullscreen() {
    const self2 = this;
    return new Promise((resolve, reject) => {
      function offHandler() {
        self2.off("fullscreenerror", errorHandler);
        self2.off("fullscreenchange", changeHandler);
      }
      function changeHandler() {
        offHandler();
        resolve();
      }
      function errorHandler(e, err) {
        offHandler();
        reject(err);
      }
      self2.one("fullscreenchange", changeHandler);
      self2.one("fullscreenerror", errorHandler);
      const promise = self2.exitFullscreenHelper_();
      if (promise) {
        promise.then(offHandler, offHandler);
        promise.then(resolve, reject);
      }
    });
  }
  exitFullscreenHelper_() {
    if (this.fsApi_.requestFullscreen) {
      const promise = document_1[this.fsApi_.exitFullscreen]();
      if (promise) {
        silencePromise(promise.then(() => this.isFullscreen(false)));
      }
      return promise;
    } else if (this.tech_.supportsFullScreen() && !this.options_.preferFullWindow === true) {
      this.techCall_("exitFullScreen");
    } else {
      this.exitFullWindow();
    }
  }
  enterFullWindow() {
    this.isFullscreen(true);
    this.isFullWindow = true;
    this.docOrigOverflow = document_1.documentElement.style.overflow;
    on(document_1, "keydown", this.boundFullWindowOnEscKey_);
    document_1.documentElement.style.overflow = "hidden";
    addClass(document_1.body, "vjs-full-window");
    this.trigger("enterFullWindow");
  }
  fullWindowOnEscKey(event) {
    if (event.key === "Escape") {
      if (this.isFullscreen() === true) {
        if (!this.isFullWindow) {
          this.exitFullscreen();
        } else {
          this.exitFullWindow();
        }
      }
    }
  }
  exitFullWindow() {
    this.isFullscreen(false);
    this.isFullWindow = false;
    off(document_1, "keydown", this.boundFullWindowOnEscKey_);
    document_1.documentElement.style.overflow = this.docOrigOverflow;
    removeClass(document_1.body, "vjs-full-window");
    this.trigger("exitFullWindow");
  }
  disablePictureInPicture(value) {
    if (value === void 0) {
      return this.techGet_("disablePictureInPicture");
    }
    this.techCall_("setDisablePictureInPicture", value);
    this.options_.disablePictureInPicture = value;
    this.trigger("disablepictureinpicturechanged");
  }
  isInPictureInPicture(isPiP) {
    if (isPiP !== void 0) {
      this.isInPictureInPicture_ = !!isPiP;
      this.togglePictureInPictureClass_();
      return;
    }
    return !!this.isInPictureInPicture_;
  }
  requestPictureInPicture() {
    if (this.options_.enableDocumentPictureInPicture && window_1.documentPictureInPicture) {
      const pipContainer = document_1.createElement(this.el().tagName);
      pipContainer.classList = this.el().classList;
      pipContainer.classList.add("vjs-pip-container");
      if (this.posterImage) {
        pipContainer.appendChild(this.posterImage.el().cloneNode(true));
      }
      if (this.titleBar) {
        pipContainer.appendChild(this.titleBar.el().cloneNode(true));
      }
      pipContainer.appendChild(createEl("p", {
        className: "vjs-pip-text"
      }, {}, this.localize("Playing in picture-in-picture")));
      return window_1.documentPictureInPicture.requestWindow({
        width: this.videoWidth(),
        height: this.videoHeight()
      }).then((pipWindow) => {
        copyStyleSheetsToWindow(pipWindow);
        this.el_.parentNode.insertBefore(pipContainer, this.el_);
        pipWindow.document.body.appendChild(this.el_);
        pipWindow.document.body.classList.add("vjs-pip-window");
        this.player_.isInPictureInPicture(true);
        this.player_.trigger({
          type: "enterpictureinpicture",
          pipWindow
        });
        pipWindow.addEventListener("pagehide", (event) => {
          const pipVideo = event.target.querySelector(".video-js");
          pipContainer.parentNode.replaceChild(pipVideo, pipContainer);
          this.player_.isInPictureInPicture(false);
          this.player_.trigger("leavepictureinpicture");
        });
        return pipWindow;
      });
    }
    if ("pictureInPictureEnabled" in document_1 && this.disablePictureInPicture() === false) {
      return this.techGet_("requestPictureInPicture");
    }
    return Promise.reject("No PiP mode is available");
  }
  exitPictureInPicture() {
    if (window_1.documentPictureInPicture && window_1.documentPictureInPicture.window) {
      window_1.documentPictureInPicture.window.close();
      return Promise.resolve();
    }
    if ("pictureInPictureEnabled" in document_1) {
      return document_1.exitPictureInPicture();
    }
  }
  handleKeyDown(event) {
    const {
      userActions
    } = this.options_;
    if (!userActions || !userActions.hotkeys) {
      return;
    }
    const excludeElement = (el) => {
      const tagName = el.tagName.toLowerCase();
      if (el.isContentEditable) {
        return true;
      }
      const allowedInputTypes = ["button", "checkbox", "hidden", "radio", "reset", "submit"];
      if (tagName === "input") {
        return allowedInputTypes.indexOf(el.type) === -1;
      }
      const excludedTags = ["textarea"];
      return excludedTags.indexOf(tagName) !== -1;
    };
    if (excludeElement(this.el_.ownerDocument.activeElement)) {
      return;
    }
    if (typeof userActions.hotkeys === "function") {
      userActions.hotkeys.call(this, event);
    } else {
      this.handleHotkeys(event);
    }
  }
  handleHotkeys(event) {
    const hotkeys = this.options_.userActions ? this.options_.userActions.hotkeys : {};
    const {
      fullscreenKey = (keydownEvent) => event.key.toLowerCase() === "f",
      muteKey = (keydownEvent) => event.key.toLowerCase() === "m",
      playPauseKey = (keydownEvent) => event.key.toLowerCase() === "k" || event.key.toLowerCase() === " "
    } = hotkeys;
    if (fullscreenKey.call(this, event)) {
      event.preventDefault();
      event.stopPropagation();
      const FSToggle = Component$1.getComponent("FullscreenToggle");
      if (document_1[this.fsApi_.fullscreenEnabled] !== false) {
        FSToggle.prototype.handleClick.call(this, event);
      }
    } else if (muteKey.call(this, event)) {
      event.preventDefault();
      event.stopPropagation();
      const MuteToggle2 = Component$1.getComponent("MuteToggle");
      MuteToggle2.prototype.handleClick.call(this, event);
    } else if (playPauseKey.call(this, event)) {
      event.preventDefault();
      event.stopPropagation();
      const PlayToggle2 = Component$1.getComponent("PlayToggle");
      PlayToggle2.prototype.handleClick.call(this, event);
    }
  }
  canPlayType(type) {
    let can;
    for (let i = 0, j = this.options_.techOrder; i < j.length; i++) {
      const techName = j[i];
      let tech = Tech.getTech(techName);
      if (!tech) {
        tech = Component$1.getComponent(techName);
      }
      if (!tech) {
        log$1.error(`The "${techName}" tech is undefined. Skipped browser support check for that tech.`);
        continue;
      }
      if (tech.isSupported()) {
        can = tech.canPlayType(type);
        if (can) {
          return can;
        }
      }
    }
    return "";
  }
  selectSource(sources) {
    const techs = this.options_.techOrder.map((techName) => {
      return [techName, Tech.getTech(techName)];
    }).filter(([techName, tech]) => {
      if (tech) {
        return tech.isSupported();
      }
      log$1.error(`The "${techName}" tech is undefined. Skipped browser support check for that tech.`);
      return false;
    });
    const findFirstPassingTechSourcePair = function(outerArray, innerArray, tester) {
      let found;
      outerArray.some((outerChoice) => {
        return innerArray.some((innerChoice) => {
          found = tester(outerChoice, innerChoice);
          if (found) {
            return true;
          }
        });
      });
      return found;
    };
    let foundSourceAndTech;
    const flip = (fn) => (a, b) => fn(b, a);
    const finder = ([techName, tech], source) => {
      if (tech.canPlaySource(source, this.options_[techName.toLowerCase()])) {
        return {
          source,
          tech: techName
        };
      }
    };
    if (this.options_.sourceOrder) {
      foundSourceAndTech = findFirstPassingTechSourcePair(sources, techs, flip(finder));
    } else {
      foundSourceAndTech = findFirstPassingTechSourcePair(techs, sources, finder);
    }
    return foundSourceAndTech || false;
  }
  handleSrc_(source, isRetry) {
    if (typeof source === "undefined") {
      return this.cache_.src || "";
    }
    if (this.resetRetryOnError_) {
      this.resetRetryOnError_();
    }
    const sources = filterSource(source);
    if (!sources.length) {
      this.setTimeout(function() {
        this.error({
          code: 4,
          message: this.options_.notSupportedMessage
        });
      }, 0);
      return;
    }
    this.changingSrc_ = true;
    if (!isRetry) {
      this.cache_.sources = sources;
    }
    this.updateSourceCaches_(sources[0]);
    setSource(this, sources[0], (middlewareSource, mws) => {
      this.middleware_ = mws;
      if (!isRetry) {
        this.cache_.sources = sources;
      }
      this.updateSourceCaches_(middlewareSource);
      const err = this.src_(middlewareSource);
      if (err) {
        if (sources.length > 1) {
          return this.handleSrc_(sources.slice(1));
        }
        this.changingSrc_ = false;
        this.setTimeout(function() {
          this.error({
            code: 4,
            message: this.options_.notSupportedMessage
          });
        }, 0);
        this.triggerReady();
        return;
      }
      setTech(mws, this.tech_);
    });
    if (sources.length > 1) {
      const retry = () => {
        this.error(null);
        this.handleSrc_(sources.slice(1), true);
      };
      const stopListeningForErrors = () => {
        this.off("error", retry);
      };
      this.one("error", retry);
      this.one("playing", stopListeningForErrors);
      this.resetRetryOnError_ = () => {
        this.off("error", retry);
        this.off("playing", stopListeningForErrors);
      };
    }
  }
  src(source) {
    return this.handleSrc_(source, false);
  }
  src_(source) {
    const sourceTech = this.selectSource([source]);
    if (!sourceTech) {
      return true;
    }
    if (!titleCaseEquals(sourceTech.tech, this.techName_)) {
      this.changingSrc_ = true;
      this.loadTech_(sourceTech.tech, sourceTech.source);
      this.tech_.ready(() => {
        this.changingSrc_ = false;
      });
      return false;
    }
    this.ready(function() {
      if (this.tech_.constructor.prototype.hasOwnProperty("setSource")) {
        this.techCall_("setSource", source);
      } else {
        this.techCall_("src", source.src);
      }
      this.changingSrc_ = false;
    }, true);
    return false;
  }
  addSourceElement(srcUrl, mimeType) {
    if (!this.tech_) {
      return false;
    }
    return this.tech_.addSourceElement(srcUrl, mimeType);
  }
  removeSourceElement(srcUrl) {
    if (!this.tech_) {
      return false;
    }
    return this.tech_.removeSourceElement(srcUrl);
  }
  load() {
    if (this.tech_ && this.tech_.vhs) {
      this.src(this.currentSource());
      return;
    }
    this.techCall_("load");
  }
  reset() {
    if (this.paused()) {
      this.doReset_();
    } else {
      const playPromise = this.play();
      silencePromise(playPromise.then(() => this.doReset_()));
    }
  }
  doReset_() {
    if (this.tech_) {
      this.tech_.clearTracks("text");
    }
    this.removeClass("vjs-playing");
    this.addClass("vjs-paused");
    this.resetCache_();
    this.poster("");
    this.loadTech_(this.options_.techOrder[0], null);
    this.techCall_("reset");
    this.resetControlBarUI_();
    this.error(null);
    if (this.titleBar) {
      this.titleBar.update({
        title: void 0,
        description: void 0
      });
    }
    if (isEvented(this)) {
      this.trigger("playerreset");
    }
  }
  resetControlBarUI_() {
    this.resetProgressBar_();
    this.resetPlaybackRate_();
    this.resetVolumeBar_();
  }
  resetProgressBar_() {
    this.currentTime(0);
    const {
      currentTimeDisplay,
      durationDisplay,
      progressControl,
      remainingTimeDisplay
    } = this.controlBar || {};
    const {
      seekBar
    } = progressControl || {};
    if (currentTimeDisplay) {
      currentTimeDisplay.updateContent();
    }
    if (durationDisplay) {
      durationDisplay.updateContent();
    }
    if (remainingTimeDisplay) {
      remainingTimeDisplay.updateContent();
    }
    if (seekBar) {
      seekBar.update();
      if (seekBar.loadProgressBar) {
        seekBar.loadProgressBar.update();
      }
    }
  }
  resetPlaybackRate_() {
    this.playbackRate(this.defaultPlaybackRate());
    this.handleTechRateChange_();
  }
  resetVolumeBar_() {
    this.volume(1);
    this.trigger("volumechange");
  }
  currentSources() {
    const source = this.currentSource();
    const sources = [];
    if (Object.keys(source).length !== 0) {
      sources.push(source);
    }
    return this.cache_.sources || sources;
  }
  currentSource() {
    return this.cache_.source || {};
  }
  currentSrc() {
    return this.currentSource() && this.currentSource().src || "";
  }
  currentType() {
    return this.currentSource() && this.currentSource().type || "";
  }
  preload(value) {
    if (value !== void 0) {
      this.techCall_("setPreload", value);
      this.options_.preload = value;
      return;
    }
    return this.techGet_("preload");
  }
  autoplay(value) {
    if (value === void 0) {
      return this.options_.autoplay || false;
    }
    let techAutoplay;
    if (typeof value === "string" && /(any|play|muted)/.test(value) || value === true && this.options_.normalizeAutoplay) {
      this.options_.autoplay = value;
      this.manualAutoplay_(typeof value === "string" ? value : "play");
      techAutoplay = false;
    } else if (!value) {
      this.options_.autoplay = false;
    } else {
      this.options_.autoplay = true;
    }
    techAutoplay = typeof techAutoplay === "undefined" ? this.options_.autoplay : techAutoplay;
    if (this.tech_) {
      this.techCall_("setAutoplay", techAutoplay);
    }
  }
  playsinline(value) {
    if (value !== void 0) {
      this.techCall_("setPlaysinline", value);
      this.options_.playsinline = value;
    }
    return this.techGet_("playsinline");
  }
  loop(value) {
    if (value !== void 0) {
      this.techCall_("setLoop", value);
      this.options_.loop = value;
      return;
    }
    return this.techGet_("loop");
  }
  poster(src) {
    if (src === void 0) {
      return this.poster_;
    }
    if (!src) {
      src = "";
    }
    if (src === this.poster_) {
      return;
    }
    this.poster_ = src;
    this.techCall_("setPoster", src);
    this.isPosterFromTech_ = false;
    this.trigger("posterchange");
  }
  handleTechPosterChange_() {
    if ((!this.poster_ || this.options_.techCanOverridePoster) && this.tech_ && this.tech_.poster) {
      const newPoster = this.tech_.poster() || "";
      if (newPoster !== this.poster_) {
        this.poster_ = newPoster;
        this.isPosterFromTech_ = true;
        this.trigger("posterchange");
      }
    }
  }
  controls(bool) {
    if (bool === void 0) {
      return !!this.controls_;
    }
    bool = !!bool;
    if (this.controls_ === bool) {
      return;
    }
    this.controls_ = bool;
    if (this.usingNativeControls()) {
      this.techCall_("setControls", bool);
    }
    if (this.controls_) {
      this.removeClass("vjs-controls-disabled");
      this.addClass("vjs-controls-enabled");
      this.trigger("controlsenabled");
      if (!this.usingNativeControls()) {
        this.addTechControlsListeners_();
      }
    } else {
      this.removeClass("vjs-controls-enabled");
      this.addClass("vjs-controls-disabled");
      this.trigger("controlsdisabled");
      if (!this.usingNativeControls()) {
        this.removeTechControlsListeners_();
      }
    }
  }
  usingNativeControls(bool) {
    if (bool === void 0) {
      return !!this.usingNativeControls_;
    }
    bool = !!bool;
    if (this.usingNativeControls_ === bool) {
      return;
    }
    this.usingNativeControls_ = bool;
    if (this.usingNativeControls_) {
      this.addClass("vjs-using-native-controls");
      this.trigger("usingnativecontrols");
    } else {
      this.removeClass("vjs-using-native-controls");
      this.trigger("usingcustomcontrols");
    }
  }
  error(err) {
    if (err === void 0) {
      return this.error_ || null;
    }
    hooks("beforeerror").forEach((hookFunction) => {
      const newErr = hookFunction(this, err);
      if (!(isObject(newErr) && !Array.isArray(newErr) || typeof newErr === "string" || typeof newErr === "number" || newErr === null)) {
        this.log.error("please return a value that MediaError expects in beforeerror hooks");
        return;
      }
      err = newErr;
    });
    if (this.options_.suppressNotSupportedError && err && err.code === 4) {
      const triggerSuppressedError = function() {
        this.error(err);
      };
      this.options_.suppressNotSupportedError = false;
      this.any(["click", "touchstart"], triggerSuppressedError);
      this.one("loadstart", function() {
        this.off(["click", "touchstart"], triggerSuppressedError);
      });
      return;
    }
    if (err === null) {
      this.error_ = null;
      this.removeClass("vjs-error");
      if (this.errorDisplay) {
        this.errorDisplay.close();
      }
      return;
    }
    this.error_ = new MediaError(err);
    this.addClass("vjs-error");
    log$1.error(`(CODE:${this.error_.code} ${MediaError.errorTypes[this.error_.code]})`, this.error_.message, this.error_);
    this.trigger("error");
    hooks("error").forEach((hookFunction) => hookFunction(this, this.error_));
    return;
  }
  reportUserActivity(event) {
    this.userActivity_ = true;
  }
  userActive(bool) {
    if (bool === void 0) {
      return this.userActive_;
    }
    bool = !!bool;
    if (bool === this.userActive_) {
      return;
    }
    this.userActive_ = bool;
    if (this.userActive_) {
      this.userActivity_ = true;
      this.removeClass("vjs-user-inactive");
      this.addClass("vjs-user-active");
      this.trigger("useractive");
      return;
    }
    if (this.tech_) {
      this.tech_.one("mousemove", function(e) {
        e.stopPropagation();
        e.preventDefault();
      });
    }
    this.userActivity_ = false;
    this.removeClass("vjs-user-active");
    this.addClass("vjs-user-inactive");
    this.trigger("userinactive");
  }
  listenForUserActivity_() {
    let mouseInProgress;
    let lastMoveX;
    let lastMoveY;
    const handleActivity = bind_(this, this.reportUserActivity);
    const handleMouseMove = function(e) {
      if (e.screenX !== lastMoveX || e.screenY !== lastMoveY) {
        lastMoveX = e.screenX;
        lastMoveY = e.screenY;
        handleActivity();
      }
    };
    const handleMouseDown = function() {
      handleActivity();
      this.clearInterval(mouseInProgress);
      mouseInProgress = this.setInterval(handleActivity, 250);
    };
    const handleMouseUpAndMouseLeave = function(event) {
      handleActivity();
      this.clearInterval(mouseInProgress);
    };
    this.on("mousedown", handleMouseDown);
    this.on("mousemove", handleMouseMove);
    this.on("mouseup", handleMouseUpAndMouseLeave);
    this.on("mouseleave", handleMouseUpAndMouseLeave);
    const controlBar = this.getChild("controlBar");
    if (controlBar && !IS_IOS && !IS_ANDROID) {
      controlBar.on("mouseenter", function(event) {
        if (this.player().options_.inactivityTimeout !== 0) {
          this.player().cache_.inactivityTimeout = this.player().options_.inactivityTimeout;
        }
        this.player().options_.inactivityTimeout = 0;
      });
      controlBar.on("mouseleave", function(event) {
        this.player().options_.inactivityTimeout = this.player().cache_.inactivityTimeout;
      });
    }
    this.on("keydown", handleActivity);
    this.on("keyup", handleActivity);
    let inactivityTimeout;
    const activityCheck = function() {
      if (!this.userActivity_) {
        return;
      }
      this.userActivity_ = false;
      this.userActive(true);
      this.clearTimeout(inactivityTimeout);
      const timeout = this.options_.inactivityTimeout;
      if (timeout <= 0) {
        return;
      }
      inactivityTimeout = this.setTimeout(function() {
        if (!this.userActivity_) {
          this.userActive(false);
        }
      }, timeout);
    };
    this.setInterval(activityCheck, 250);
  }
  playbackRate(rate) {
    if (rate !== void 0) {
      this.techCall_("setPlaybackRate", rate);
      return;
    }
    if (this.tech_ && this.tech_.featuresPlaybackRate) {
      return this.cache_.lastPlaybackRate || this.techGet_("playbackRate");
    }
    return 1;
  }
  defaultPlaybackRate(rate) {
    if (rate !== void 0) {
      return this.techCall_("setDefaultPlaybackRate", rate);
    }
    if (this.tech_ && this.tech_.featuresPlaybackRate) {
      return this.techGet_("defaultPlaybackRate");
    }
    return 1;
  }
  isAudio(bool) {
    if (bool !== void 0) {
      this.isAudio_ = !!bool;
      return;
    }
    return !!this.isAudio_;
  }
  updatePlayerHeightOnAudioOnlyMode_() {
    const controlBar = this.getChild("ControlBar");
    if (!controlBar || this.audioOnlyCache_.controlBarHeight === controlBar.currentHeight()) {
      return;
    }
    this.audioOnlyCache_.controlBarHeight = controlBar.currentHeight();
    this.height(this.audioOnlyCache_.controlBarHeight);
  }
  enableAudioOnlyUI_() {
    this.addClass("vjs-audio-only-mode");
    const playerChildren = this.children();
    const controlBar = this.getChild("ControlBar");
    const controlBarHeight = controlBar && controlBar.currentHeight();
    playerChildren.forEach((child) => {
      if (child === controlBar) {
        return;
      }
      if (child.el_ && !child.hasClass("vjs-hidden")) {
        child.hide();
        this.audioOnlyCache_.hiddenChildren.push(child);
      }
    });
    this.audioOnlyCache_.playerHeight = this.currentHeight();
    this.audioOnlyCache_.controlBarHeight = controlBarHeight;
    this.on("playerresize", this.boundUpdatePlayerHeightOnAudioOnlyMode_);
    this.height(controlBarHeight);
    this.trigger("audioonlymodechange");
  }
  disableAudioOnlyUI_() {
    this.removeClass("vjs-audio-only-mode");
    this.off("playerresize", this.boundUpdatePlayerHeightOnAudioOnlyMode_);
    this.audioOnlyCache_.hiddenChildren.forEach((child) => child.show());
    this.height(this.audioOnlyCache_.playerHeight);
    this.trigger("audioonlymodechange");
  }
  audioOnlyMode(value) {
    if (typeof value !== "boolean" || value === this.audioOnlyMode_) {
      return this.audioOnlyMode_;
    }
    this.audioOnlyMode_ = value;
    if (value) {
      const exitPromises = [];
      if (this.isInPictureInPicture()) {
        exitPromises.push(this.exitPictureInPicture());
      }
      if (this.isFullscreen()) {
        exitPromises.push(this.exitFullscreen());
      }
      if (this.audioPosterMode()) {
        exitPromises.push(this.audioPosterMode(false));
      }
      return Promise.all(exitPromises).then(() => this.enableAudioOnlyUI_());
    }
    return Promise.resolve().then(() => this.disableAudioOnlyUI_());
  }
  enablePosterModeUI_() {
    const tech = this.tech_ && this.tech_;
    tech.hide();
    this.addClass("vjs-audio-poster-mode");
    this.trigger("audiopostermodechange");
  }
  disablePosterModeUI_() {
    const tech = this.tech_ && this.tech_;
    tech.show();
    this.removeClass("vjs-audio-poster-mode");
    this.trigger("audiopostermodechange");
  }
  audioPosterMode(value) {
    if (typeof value !== "boolean" || value === this.audioPosterMode_) {
      return this.audioPosterMode_;
    }
    this.audioPosterMode_ = value;
    if (value) {
      if (this.audioOnlyMode()) {
        const audioOnlyModePromise = this.audioOnlyMode(false);
        return audioOnlyModePromise.then(() => {
          this.enablePosterModeUI_();
        });
      }
      return Promise.resolve().then(() => {
        this.enablePosterModeUI_();
      });
    }
    return Promise.resolve().then(() => {
      this.disablePosterModeUI_();
    });
  }
  addTextTrack(kind, label, language) {
    if (this.tech_) {
      return this.tech_.addTextTrack(kind, label, language);
    }
  }
  addRemoteTextTrack(options, manualCleanup) {
    if (this.tech_) {
      return this.tech_.addRemoteTextTrack(options, manualCleanup);
    }
  }
  removeRemoteTextTrack(obj = {}) {
    let {
      track
    } = obj;
    if (!track) {
      track = obj;
    }
    if (this.tech_) {
      return this.tech_.removeRemoteTextTrack(track);
    }
  }
  getVideoPlaybackQuality() {
    return this.techGet_("getVideoPlaybackQuality");
  }
  videoWidth() {
    return this.tech_ && this.tech_.videoWidth && this.tech_.videoWidth() || 0;
  }
  videoHeight() {
    return this.tech_ && this.tech_.videoHeight && this.tech_.videoHeight() || 0;
  }
  language(code) {
    if (code === void 0) {
      return this.language_;
    }
    if (this.language_ !== String(code).toLowerCase()) {
      this.language_ = String(code).toLowerCase();
      if (isEvented(this)) {
        this.trigger("languagechange");
      }
    }
  }
  languages() {
    return merge$1(Player.prototype.options_.languages, this.languages_);
  }
  toJSON() {
    const options = merge$1(this.options_);
    const tracks = options.tracks;
    options.tracks = [];
    for (let i = 0; i < tracks.length; i++) {
      let track = tracks[i];
      track = merge$1(track);
      track.player = void 0;
      options.tracks[i] = track;
    }
    return options;
  }
  createModal(content, options) {
    options = options || {};
    options.content = content || "";
    const modal = new ModalDialog(this, options);
    this.addChild(modal);
    modal.on("dispose", () => {
      this.removeChild(modal);
    });
    modal.open();
    return modal;
  }
  updateCurrentBreakpoint_() {
    if (!this.responsive()) {
      return;
    }
    const currentBreakpoint = this.currentBreakpoint();
    const currentWidth = this.currentWidth();
    for (let i = 0; i < BREAKPOINT_ORDER.length; i++) {
      const candidateBreakpoint = BREAKPOINT_ORDER[i];
      const maxWidth = this.breakpoints_[candidateBreakpoint];
      if (currentWidth <= maxWidth) {
        if (currentBreakpoint === candidateBreakpoint) {
          return;
        }
        if (currentBreakpoint) {
          this.removeClass(BREAKPOINT_CLASSES[currentBreakpoint]);
        }
        this.addClass(BREAKPOINT_CLASSES[candidateBreakpoint]);
        this.breakpoint_ = candidateBreakpoint;
        break;
      }
    }
  }
  removeCurrentBreakpoint_() {
    const className = this.currentBreakpointClass();
    this.breakpoint_ = "";
    if (className) {
      this.removeClass(className);
    }
  }
  breakpoints(breakpoints) {
    if (breakpoints === void 0) {
      return Object.assign(this.breakpoints_);
    }
    this.breakpoint_ = "";
    this.breakpoints_ = Object.assign({}, DEFAULT_BREAKPOINTS, breakpoints);
    this.updateCurrentBreakpoint_();
    return Object.assign(this.breakpoints_);
  }
  responsive(value) {
    if (value === void 0) {
      return this.responsive_;
    }
    value = Boolean(value);
    const current = this.responsive_;
    if (value === current) {
      return;
    }
    this.responsive_ = value;
    if (value) {
      this.on("playerresize", this.boundUpdateCurrentBreakpoint_);
      this.updateCurrentBreakpoint_();
    } else {
      this.off("playerresize", this.boundUpdateCurrentBreakpoint_);
      this.removeCurrentBreakpoint_();
    }
    return value;
  }
  currentBreakpoint() {
    return this.breakpoint_;
  }
  currentBreakpointClass() {
    return BREAKPOINT_CLASSES[this.breakpoint_] || "";
  }
  loadMedia(media, ready) {
    if (!media || typeof media !== "object") {
      return;
    }
    const crossOrigin = this.crossOrigin();
    this.reset();
    this.cache_.media = merge$1(media);
    const {
      artist,
      artwork,
      description,
      poster,
      src,
      textTracks,
      title
    } = this.cache_.media;
    if (!artwork && poster) {
      this.cache_.media.artwork = [{
        src: poster,
        type: getMimetype(poster)
      }];
    }
    if (crossOrigin) {
      this.crossOrigin(crossOrigin);
    }
    if (src) {
      this.src(src);
    }
    if (poster) {
      this.poster(poster);
    }
    if (Array.isArray(textTracks)) {
      textTracks.forEach((tt) => this.addRemoteTextTrack(tt, false));
    }
    if (this.titleBar) {
      this.titleBar.update({
        title,
        description: description || artist || ""
      });
    }
    this.ready(ready);
  }
  getMedia() {
    if (!this.cache_.media) {
      const poster = this.poster();
      const src = this.currentSources();
      const textTracks = Array.prototype.map.call(this.remoteTextTracks(), (tt) => ({
        kind: tt.kind,
        label: tt.label,
        language: tt.language,
        src: tt.src
      }));
      const media = {
        src,
        textTracks
      };
      if (poster) {
        media.poster = poster;
        media.artwork = [{
          src: media.poster,
          type: getMimetype(media.poster)
        }];
      }
      return media;
    }
    return merge$1(this.cache_.media);
  }
  static getTagSettings(tag) {
    const baseOptions = {
      sources: [],
      tracks: []
    };
    const tagOptions = getAttributes(tag);
    const dataSetup = tagOptions["data-setup"];
    if (hasClass(tag, "vjs-fill")) {
      tagOptions.fill = true;
    }
    if (hasClass(tag, "vjs-fluid")) {
      tagOptions.fluid = true;
    }
    if (dataSetup !== null) {
      try {
        Object.assign(tagOptions, JSON.parse(dataSetup || "{}"));
      } catch (e) {
        log$1.error("data-setup", e);
      }
    }
    Object.assign(baseOptions, tagOptions);
    if (tag.hasChildNodes()) {
      const children = tag.childNodes;
      for (let i = 0, j = children.length; i < j; i++) {
        const child = children[i];
        const childName = child.nodeName.toLowerCase();
        if (childName === "source") {
          baseOptions.sources.push(getAttributes(child));
        } else if (childName === "track") {
          baseOptions.tracks.push(getAttributes(child));
        }
      }
    }
    return baseOptions;
  }
  debug(enabled) {
    if (enabled === void 0) {
      return this.debugEnabled_;
    }
    if (enabled) {
      this.trigger("debugon");
      this.previousLogLevel_ = this.log.level;
      this.log.level("debug");
      this.debugEnabled_ = true;
    } else {
      this.trigger("debugoff");
      this.log.level(this.previousLogLevel_);
      this.previousLogLevel_ = void 0;
      this.debugEnabled_ = false;
    }
  }
  playbackRates(newRates) {
    if (newRates === void 0) {
      return this.cache_.playbackRates;
    }
    if (!Array.isArray(newRates)) {
      return;
    }
    if (!newRates.every((rate) => typeof rate === "number")) {
      return;
    }
    this.cache_.playbackRates = newRates;
    this.trigger("playbackrateschange");
  }
}
Player.prototype.videoTracks = () => {
};
Player.prototype.audioTracks = () => {
};
Player.prototype.textTracks = () => {
};
Player.prototype.remoteTextTracks = () => {
};
Player.prototype.remoteTextTrackEls = () => {
};
ALL.names.forEach(function(name) {
  const props = ALL[name];
  Player.prototype[props.getterName] = function() {
    if (this.tech_) {
      return this.tech_[props.getterName]();
    }
    this[props.privateName] = this[props.privateName] || new props.ListClass();
    return this[props.privateName];
  };
});
Player.prototype.crossorigin = Player.prototype.crossOrigin;
Player.players = {};
const navigator = window_1.navigator;
Player.prototype.options_ = {
  techOrder: Tech.defaultTechOrder_,
  html5: {},
  enableSourceset: true,
  inactivityTimeout: 2e3,
  playbackRates: [],
  liveui: false,
  children: ["mediaLoader", "posterImage", "titleBar", "textTrackDisplay", "loadingSpinner", "bigPlayButton", "liveTracker", "controlBar", "errorDisplay", "textTrackSettings", "resizeManager"],
  language: navigator && (navigator.languages && navigator.languages[0] || navigator.userLanguage || navigator.language) || "en",
  languages: {},
  notSupportedMessage: "No compatible source was found for this media.",
  normalizeAutoplay: false,
  fullscreen: {
    options: {
      navigationUI: "hide"
    }
  },
  breakpoints: {},
  responsive: false,
  audioOnlyMode: false,
  audioPosterMode: false,
  spatialNavigation: {
    enabled: false,
    horizontalSeek: false
  },
  enableSmoothSeeking: false,
  disableSeekWhileScrubbingOnMobile: false,
  disableSeekWhileScrubbingOnSTV: false
};
TECH_EVENTS_RETRIGGER.forEach(function(event) {
  Player.prototype[`handleTech${toTitleCase$1(event)}_`] = function() {
    return this.trigger(event);
  };
});
Component$1.registerComponent("Player", Player);
const BASE_PLUGIN_NAME = "plugin";
const PLUGIN_CACHE_KEY = "activePlugins_";
const pluginStorage = {};
const pluginExists = (name) => pluginStorage.hasOwnProperty(name);
const getPlugin = (name) => pluginExists(name) ? pluginStorage[name] : void 0;
const markPluginAsActive = (player, name) => {
  player[PLUGIN_CACHE_KEY] = player[PLUGIN_CACHE_KEY] || {};
  player[PLUGIN_CACHE_KEY][name] = true;
};
const triggerSetupEvent = (player, hash, before) => {
  const eventName = (before ? "before" : "") + "pluginsetup";
  player.trigger(eventName, hash);
  player.trigger(eventName + ":" + hash.name, hash);
};
const createBasicPlugin = function(name, plugin) {
  const basicPluginWrapper = function() {
    triggerSetupEvent(this, {
      name,
      plugin,
      instance: null
    }, true);
    const instance = plugin.apply(this, arguments);
    markPluginAsActive(this, name);
    triggerSetupEvent(this, {
      name,
      plugin,
      instance
    });
    return instance;
  };
  Object.keys(plugin).forEach(function(prop) {
    basicPluginWrapper[prop] = plugin[prop];
  });
  return basicPluginWrapper;
};
const createPluginFactory = (name, PluginSubClass) => {
  PluginSubClass.prototype.name = name;
  return function(...args) {
    triggerSetupEvent(this, {
      name,
      plugin: PluginSubClass,
      instance: null
    }, true);
    const instance = new PluginSubClass(...[this, ...args]);
    this[name] = () => instance;
    triggerSetupEvent(this, instance.getEventHash());
    return instance;
  };
};
class Plugin {
  constructor(player) {
    if (this.constructor === Plugin) {
      throw new Error("Plugin must be sub-classed; not directly instantiated.");
    }
    this.player = player;
    if (!this.log) {
      this.log = this.player.log.createLogger(this.name);
    }
    evented(this);
    delete this.trigger;
    stateful(this, this.constructor.defaultState);
    markPluginAsActive(player, this.name);
    this.dispose = this.dispose.bind(this);
    player.on("dispose", this.dispose);
  }
  version() {
    return this.constructor.VERSION;
  }
  getEventHash(hash = {}) {
    hash.name = this.name;
    hash.plugin = this.constructor;
    hash.instance = this;
    return hash;
  }
  trigger(event, hash = {}) {
    return trigger(this.eventBusEl_, event, this.getEventHash(hash));
  }
  handleStateChanged(e) {
  }
  dispose() {
    const {
      name,
      player
    } = this;
    this.trigger("dispose");
    this.off();
    player.off("dispose", this.dispose);
    player[PLUGIN_CACHE_KEY][name] = false;
    this.player = this.state = null;
    player[name] = createPluginFactory(name, pluginStorage[name]);
  }
  static isBasic(plugin) {
    const p = typeof plugin === "string" ? getPlugin(plugin) : plugin;
    return typeof p === "function" && !Plugin.prototype.isPrototypeOf(p.prototype);
  }
  static registerPlugin(name, plugin) {
    if (typeof name !== "string") {
      throw new Error(`Illegal plugin name, "${name}", must be a string, was ${typeof name}.`);
    }
    if (pluginExists(name)) {
      log$1.warn(`A plugin named "${name}" already exists. You may want to avoid re-registering plugins!`);
    } else if (Player.prototype.hasOwnProperty(name)) {
      throw new Error(`Illegal plugin name, "${name}", cannot share a name with an existing player method!`);
    }
    if (typeof plugin !== "function") {
      throw new Error(`Illegal plugin for "${name}", must be a function, was ${typeof plugin}.`);
    }
    pluginStorage[name] = plugin;
    if (name !== BASE_PLUGIN_NAME) {
      if (Plugin.isBasic(plugin)) {
        Player.prototype[name] = createBasicPlugin(name, plugin);
      } else {
        Player.prototype[name] = createPluginFactory(name, plugin);
      }
    }
    return plugin;
  }
  static deregisterPlugin(name) {
    if (name === BASE_PLUGIN_NAME) {
      throw new Error("Cannot de-register base plugin.");
    }
    if (pluginExists(name)) {
      delete pluginStorage[name];
      delete Player.prototype[name];
    }
  }
  static getPlugins(names = Object.keys(pluginStorage)) {
    let result;
    names.forEach((name) => {
      const plugin = getPlugin(name);
      if (plugin) {
        result = result || {};
        result[name] = plugin;
      }
    });
    return result;
  }
  static getPluginVersion(name) {
    const plugin = getPlugin(name);
    return plugin && plugin.VERSION || "";
  }
}
Plugin.getPlugin = getPlugin;
Plugin.BASE_PLUGIN_NAME = BASE_PLUGIN_NAME;
Plugin.registerPlugin(BASE_PLUGIN_NAME, Plugin);
Player.prototype.usingPlugin = function(name) {
  return !!this[PLUGIN_CACHE_KEY] && this[PLUGIN_CACHE_KEY][name] === true;
};
Player.prototype.hasPlugin = function(name) {
  return !!pluginExists(name);
};
function deprecate(message, fn) {
  let warned = false;
  return function(...args) {
    if (!warned) {
      log$1.warn(message);
    }
    warned = true;
    return fn.apply(this, args);
  };
}
function deprecateForMajor(major, oldName, newName, fn) {
  return deprecate(`${oldName} is deprecated and will be removed in ${major}.0; please use ${newName} instead.`, fn);
}
var VjsErrors = {
  NetworkBadStatus: "networkbadstatus",
  NetworkRequestFailed: "networkrequestfailed",
  NetworkRequestAborted: "networkrequestaborted",
  NetworkRequestTimeout: "networkrequesttimeout",
  NetworkBodyParserFailed: "networkbodyparserfailed",
  StreamingHlsPlaylistParserError: "streaminghlsplaylistparsererror",
  StreamingDashManifestParserError: "streamingdashmanifestparsererror",
  StreamingContentSteeringParserError: "streamingcontentsteeringparsererror",
  StreamingVttParserError: "streamingvttparsererror",
  StreamingFailedToSelectNextSegment: "streamingfailedtoselectnextsegment",
  StreamingFailedToDecryptSegment: "streamingfailedtodecryptsegment",
  StreamingFailedToTransmuxSegment: "streamingfailedtotransmuxsegment",
  StreamingFailedToAppendSegment: "streamingfailedtoappendsegment",
  StreamingCodecsChangeError: "streamingcodecschangeerror"
};
const normalizeId = (id) => id.indexOf("#") === 0 ? id.slice(1) : id;
function videojs(id, options, ready) {
  let player = videojs.getPlayer(id);
  if (player) {
    if (options) {
      log$1.warn(`Player "${id}" is already initialised. Options will not be applied.`);
    }
    if (ready) {
      player.ready(ready);
    }
    return player;
  }
  const el = typeof id === "string" ? $("#" + normalizeId(id)) : id;
  if (!isEl(el)) {
    throw new TypeError("The element or ID supplied is not valid. (videojs)");
  }
  const inShadowDom = "getRootNode" in el ? el.getRootNode() instanceof window_1.ShadowRoot : false;
  const rootNode = inShadowDom ? el.getRootNode() : el.ownerDocument.body;
  if (!el.ownerDocument.defaultView || !rootNode.contains(el)) {
    log$1.warn("The element supplied is not included in the DOM");
  }
  options = options || {};
  if (options.restoreEl === true) {
    options.restoreEl = (el.parentNode && el.parentNode.hasAttribute && el.parentNode.hasAttribute("data-vjs-player") ? el.parentNode : el).cloneNode(true);
  }
  hooks("beforesetup").forEach((hookFunction) => {
    const opts = hookFunction(el, merge$1(options));
    if (!isObject(opts) || Array.isArray(opts)) {
      log$1.error("please return an object in beforesetup hooks");
      return;
    }
    options = merge$1(options, opts);
  });
  const PlayerComponent = Component$1.getComponent("Player");
  player = new PlayerComponent(el, options, ready);
  hooks("setup").forEach((hookFunction) => hookFunction(player));
  return player;
}
videojs.hooks_ = hooks_;
videojs.hooks = hooks;
videojs.hook = hook;
videojs.hookOnce = hookOnce;
videojs.removeHook = removeHook;
if (window_1.VIDEOJS_NO_DYNAMIC_STYLE !== true && isReal()) {
  let style = $(".vjs-styles-defaults");
  if (!style) {
    style = createStyleElement("vjs-styles-defaults");
    const head = $("head");
    if (head) {
      head.insertBefore(style, head.firstChild);
    }
    setTextContent(style, `
      .video-js {
        width: 300px;
        height: 150px;
      }

      .vjs-fluid:not(.vjs-audio-only-mode) {
        padding-top: 56.25%
      }
    `);
  }
}
autoSetupTimeout(1, videojs);
videojs.VERSION = version$6;
videojs.options = Player.prototype.options_;
videojs.getPlayers = () => Player.players;
videojs.getPlayer = (id) => {
  const players = Player.players;
  let tag;
  if (typeof id === "string") {
    const nId = normalizeId(id);
    const player = players[nId];
    if (player) {
      return player;
    }
    tag = $("#" + nId);
  } else {
    tag = id;
  }
  if (isEl(tag)) {
    const {
      player,
      playerId
    } = tag;
    if (player || players[playerId]) {
      return player || players[playerId];
    }
  }
};
videojs.getAllPlayers = () => Object.keys(Player.players).map((k) => Player.players[k]).filter(Boolean);
videojs.players = Player.players;
videojs.getComponent = Component$1.getComponent;
videojs.registerComponent = (name, comp) => {
  if (Tech.isTech(comp)) {
    log$1.warn(`The ${name} tech was registered as a component. It should instead be registered using videojs.registerTech(name, tech)`);
  }
  return Component$1.registerComponent.call(Component$1, name, comp);
};
videojs.getTech = Tech.getTech;
videojs.registerTech = Tech.registerTech;
videojs.use = use;
Object.defineProperty(videojs, "middleware", {
  value: {},
  writeable: false,
  enumerable: true
});
Object.defineProperty(videojs.middleware, "TERMINATOR", {
  value: TERMINATOR,
  writeable: false,
  enumerable: true
});
videojs.browser = browser;
videojs.obj = Obj;
videojs.mergeOptions = deprecateForMajor(9, "videojs.mergeOptions", "videojs.obj.merge", merge$1);
videojs.defineLazyProperty = deprecateForMajor(9, "videojs.defineLazyProperty", "videojs.obj.defineLazyProperty", defineLazyProperty);
videojs.bind = deprecateForMajor(9, "videojs.bind", "native Function.prototype.bind", bind_);
videojs.registerPlugin = Plugin.registerPlugin;
videojs.deregisterPlugin = Plugin.deregisterPlugin;
videojs.plugin = (name, plugin) => {
  log$1.warn("videojs.plugin() is deprecated; use videojs.registerPlugin() instead");
  return Plugin.registerPlugin(name, plugin);
};
videojs.getPlugins = Plugin.getPlugins;
videojs.getPlugin = Plugin.getPlugin;
videojs.getPluginVersion = Plugin.getPluginVersion;
videojs.addLanguage = function(code, data) {
  code = ("" + code).toLowerCase();
  videojs.options.languages = merge$1(videojs.options.languages, {
    [code]: data
  });
  return videojs.options.languages[code];
};
videojs.log = log$1;
videojs.createLogger = createLogger;
videojs.time = Time;
videojs.createTimeRange = deprecateForMajor(9, "videojs.createTimeRange", "videojs.time.createTimeRanges", createTimeRanges$1);
videojs.createTimeRanges = deprecateForMajor(9, "videojs.createTimeRanges", "videojs.time.createTimeRanges", createTimeRanges$1);
videojs.formatTime = deprecateForMajor(9, "videojs.formatTime", "videojs.time.formatTime", formatTime);
videojs.setFormatTime = deprecateForMajor(9, "videojs.setFormatTime", "videojs.time.setFormatTime", setFormatTime);
videojs.resetFormatTime = deprecateForMajor(9, "videojs.resetFormatTime", "videojs.time.resetFormatTime", resetFormatTime);
videojs.parseUrl = deprecateForMajor(9, "videojs.parseUrl", "videojs.url.parseUrl", parseUrl);
videojs.isCrossOrigin = deprecateForMajor(9, "videojs.isCrossOrigin", "videojs.url.isCrossOrigin", isCrossOrigin);
videojs.EventTarget = EventTarget$2;
videojs.any = any;
videojs.on = on;
videojs.one = one;
videojs.off = off;
videojs.trigger = trigger;
videojs.xhr = lib.exports;
videojs.TrackList = TrackList;
videojs.TextTrack = TextTrack;
videojs.TextTrackList = TextTrackList;
videojs.AudioTrack = AudioTrack;
videojs.AudioTrackList = AudioTrackList;
videojs.VideoTrack = VideoTrack;
videojs.VideoTrackList = VideoTrackList;
["isEl", "isTextNode", "createEl", "hasClass", "addClass", "removeClass", "toggleClass", "setAttributes", "getAttributes", "emptyEl", "appendContent", "insertContent"].forEach((k) => {
  videojs[k] = function() {
    log$1.warn(`videojs.${k}() is deprecated; use videojs.dom.${k}() instead`);
    return Dom[k].apply(null, arguments);
  };
});
videojs.computedStyle = deprecateForMajor(9, "videojs.computedStyle", "videojs.dom.computedStyle", computedStyle);
videojs.dom = Dom;
videojs.fn = Fn;
videojs.num = Num;
videojs.str = Str;
videojs.url = Url;
videojs.Error = VjsErrors;
/*! @name videojs-contrib-quality-levels @version 4.1.0 @license Apache-2.0 */
class QualityLevel {
  constructor(representation) {
    let level = this;
    level.id = representation.id;
    level.label = level.id;
    level.width = representation.width;
    level.height = representation.height;
    level.bitrate = representation.bandwidth;
    level.frameRate = representation.frameRate;
    level.enabled_ = representation.enabled;
    Object.defineProperty(level, "enabled", {
      get() {
        return level.enabled_();
      },
      set(enable) {
        level.enabled_(enable);
      }
    });
    return level;
  }
}
class QualityLevelList extends videojs.EventTarget {
  constructor() {
    super();
    let list = this;
    list.levels_ = [];
    list.selectedIndex_ = -1;
    Object.defineProperty(list, "selectedIndex", {
      get() {
        return list.selectedIndex_;
      }
    });
    Object.defineProperty(list, "length", {
      get() {
        return list.levels_.length;
      }
    });
    list[Symbol.iterator] = () => list.levels_.values();
    return list;
  }
  addQualityLevel(representation) {
    let qualityLevel = this.getQualityLevelById(representation.id);
    if (qualityLevel) {
      return qualityLevel;
    }
    const index = this.levels_.length;
    qualityLevel = new QualityLevel(representation);
    if (!("" + index in this)) {
      Object.defineProperty(this, index, {
        get() {
          return this.levels_[index];
        }
      });
    }
    this.levels_.push(qualityLevel);
    this.trigger({
      qualityLevel,
      type: "addqualitylevel"
    });
    return qualityLevel;
  }
  removeQualityLevel(qualityLevel) {
    let removed = null;
    for (let i = 0, l = this.length; i < l; i++) {
      if (this[i] === qualityLevel) {
        removed = this.levels_.splice(i, 1)[0];
        if (this.selectedIndex_ === i) {
          this.selectedIndex_ = -1;
        } else if (this.selectedIndex_ > i) {
          this.selectedIndex_--;
        }
        break;
      }
    }
    if (removed) {
      this.trigger({
        qualityLevel,
        type: "removequalitylevel"
      });
    }
    return removed;
  }
  getQualityLevelById(id) {
    for (let i = 0, l = this.length; i < l; i++) {
      const level = this[i];
      if (level.id === id) {
        return level;
      }
    }
    return null;
  }
  dispose() {
    this.selectedIndex_ = -1;
    this.levels_.length = 0;
  }
}
QualityLevelList.prototype.allowedEvents_ = {
  change: "change",
  addqualitylevel: "addqualitylevel",
  removequalitylevel: "removequalitylevel"
};
for (const event in QualityLevelList.prototype.allowedEvents_) {
  QualityLevelList.prototype["on" + event] = null;
}
var version$5 = "4.1.0";
const initPlugin$1 = function(player, options) {
  const originalPluginFn = player.qualityLevels;
  const qualityLevelList = new QualityLevelList();
  const disposeHandler = function() {
    qualityLevelList.dispose();
    player.qualityLevels = originalPluginFn;
    player.off("dispose", disposeHandler);
  };
  player.on("dispose", disposeHandler);
  player.qualityLevels = () => qualityLevelList;
  player.qualityLevels.VERSION = version$5;
  return qualityLevelList;
};
const qualityLevels = function(options) {
  return initPlugin$1(this, videojs.obj.merge({}, options));
};
videojs.registerPlugin("qualityLevels", qualityLevels);
qualityLevels.VERSION = version$5;
/*! @name @videojs/http-streaming @version 3.17.2 @license Apache-2.0 */
const resolveUrl = resolveUrl$1;
const resolveManifestRedirect = (url, req) => {
  if (req && req.responseURL && url !== req.responseURL) {
    return req.responseURL;
  }
  return url;
};
const logger = (source) => {
  if (videojs.log.debug) {
    return videojs.log.debug.bind(videojs, "VHS:", `${source} >`);
  }
  return function() {
  };
};
function merge(...args) {
  const context = videojs.obj || videojs;
  const fn = context.merge || context.mergeOptions;
  return fn.apply(context, args);
}
function createTimeRanges(...args) {
  const context = videojs.time || videojs;
  const fn = context.createTimeRanges || context.createTimeRanges;
  return fn.apply(context, args);
}
function bufferedRangesToString(buffered) {
  if (buffered.length === 0) {
    return "Buffered Ranges are empty";
  }
  let bufferedRangesStr = "Buffered Ranges: \n";
  for (let i = 0; i < buffered.length; i++) {
    const start = buffered.start(i);
    const end = buffered.end(i);
    bufferedRangesStr += `${start} --> ${end}. Duration (${end - start})
`;
  }
  return bufferedRangesStr;
}
const TIME_FUDGE_FACTOR = 1 / 30;
const SAFE_TIME_DELTA = TIME_FUDGE_FACTOR * 3;
const filterRanges = function(timeRanges, predicate) {
  const results = [];
  let i;
  if (timeRanges && timeRanges.length) {
    for (i = 0; i < timeRanges.length; i++) {
      if (predicate(timeRanges.start(i), timeRanges.end(i))) {
        results.push([timeRanges.start(i), timeRanges.end(i)]);
      }
    }
  }
  return createTimeRanges(results);
};
const findRange = function(buffered, time) {
  return filterRanges(buffered, function(start, end) {
    return start - SAFE_TIME_DELTA <= time && end + SAFE_TIME_DELTA >= time;
  });
};
const findNextRange = function(timeRanges, time) {
  return filterRanges(timeRanges, function(start) {
    return start - TIME_FUDGE_FACTOR >= time;
  });
};
const findGaps = function(buffered) {
  if (buffered.length < 2) {
    return createTimeRanges();
  }
  const ranges = [];
  for (let i = 1; i < buffered.length; i++) {
    const start = buffered.end(i - 1);
    const end = buffered.start(i);
    ranges.push([start, end]);
  }
  return createTimeRanges(ranges);
};
const bufferIntersection = function(bufferA, bufferB) {
  let start = null;
  let end = null;
  let arity = 0;
  const extents = [];
  const ranges = [];
  if (!bufferA || !bufferA.length || !bufferB || !bufferB.length) {
    return createTimeRanges();
  }
  let count = bufferA.length;
  while (count--) {
    extents.push({
      time: bufferA.start(count),
      type: "start"
    });
    extents.push({
      time: bufferA.end(count),
      type: "end"
    });
  }
  count = bufferB.length;
  while (count--) {
    extents.push({
      time: bufferB.start(count),
      type: "start"
    });
    extents.push({
      time: bufferB.end(count),
      type: "end"
    });
  }
  extents.sort(function(a, b) {
    return a.time - b.time;
  });
  for (count = 0; count < extents.length; count++) {
    if (extents[count].type === "start") {
      arity++;
      if (arity === 2) {
        start = extents[count].time;
      }
    } else if (extents[count].type === "end") {
      arity--;
      if (arity === 1) {
        end = extents[count].time;
      }
    }
    if (start !== null && end !== null) {
      ranges.push([start, end]);
      start = null;
      end = null;
    }
  }
  return createTimeRanges(ranges);
};
const printableRange = (range) => {
  const strArr = [];
  if (!range || !range.length) {
    return "";
  }
  for (let i = 0; i < range.length; i++) {
    strArr.push(range.start(i) + " => " + range.end(i));
  }
  return strArr.join(", ");
};
const timeUntilRebuffer = function(buffered, currentTime, playbackRate = 1) {
  const bufferedEnd = buffered.length ? buffered.end(buffered.length - 1) : 0;
  return (bufferedEnd - currentTime) / playbackRate;
};
const timeRangesToArray = (timeRanges) => {
  const timeRangesList = [];
  for (let i = 0; i < timeRanges.length; i++) {
    timeRangesList.push({
      start: timeRanges.start(i),
      end: timeRanges.end(i)
    });
  }
  return timeRangesList;
};
const isRangeDifferent = function(a, b) {
  if (a === b) {
    return false;
  }
  if (!a && b || !b && a) {
    return true;
  }
  if (a.length !== b.length) {
    return true;
  }
  for (let i = 0; i < a.length; i++) {
    if (a.start(i) !== b.start(i) || a.end(i) !== b.end(i)) {
      return true;
    }
  }
  return false;
};
const lastBufferedEnd = function(a) {
  if (!a || !a.length || !a.end) {
    return;
  }
  return a.end(a.length - 1);
};
const timeAheadOf = function(range, startTime) {
  let time = 0;
  if (!range || !range.length) {
    return time;
  }
  for (let i = 0; i < range.length; i++) {
    const start = range.start(i);
    const end = range.end(i);
    if (startTime > end) {
      continue;
    }
    if (startTime > start && startTime <= end) {
      time += end - startTime;
      continue;
    }
    time += end - start;
  }
  return time;
};
const segmentDurationWithParts = (playlist, segment) => {
  if (!segment.preload) {
    return segment.duration;
  }
  let result = 0;
  (segment.parts || []).forEach(function(p) {
    result += p.duration;
  });
  (segment.preloadHints || []).forEach(function(p) {
    if (p.type === "PART") {
      result += playlist.partTargetDuration;
    }
  });
  return result;
};
const getPartsAndSegments = (playlist) => (playlist.segments || []).reduce((acc, segment, si) => {
  if (segment.parts) {
    segment.parts.forEach(function(part, pi) {
      acc.push({
        duration: part.duration,
        segmentIndex: si,
        partIndex: pi,
        part,
        segment
      });
    });
  } else {
    acc.push({
      duration: segment.duration,
      segmentIndex: si,
      partIndex: null,
      segment,
      part: null
    });
  }
  return acc;
}, []);
const getLastParts = (media) => {
  const lastSegment = media.segments && media.segments.length && media.segments[media.segments.length - 1];
  return lastSegment && lastSegment.parts || [];
};
const getKnownPartCount = ({
  preloadSegment
}) => {
  if (!preloadSegment) {
    return;
  }
  const {
    parts,
    preloadHints
  } = preloadSegment;
  let partCount = (preloadHints || []).reduce((count, hint) => count + (hint.type === "PART" ? 1 : 0), 0);
  partCount += parts && parts.length ? parts.length : 0;
  return partCount;
};
const liveEdgeDelay = (main, media) => {
  if (media.endList) {
    return 0;
  }
  if (main && main.suggestedPresentationDelay) {
    return main.suggestedPresentationDelay;
  }
  const hasParts = getLastParts(media).length > 0;
  if (hasParts && media.serverControl && media.serverControl.partHoldBack) {
    return media.serverControl.partHoldBack;
  } else if (hasParts && media.partTargetDuration) {
    return media.partTargetDuration * 3;
  } else if (media.serverControl && media.serverControl.holdBack) {
    return media.serverControl.holdBack;
  } else if (media.targetDuration) {
    return media.targetDuration * 3;
  }
  return 0;
};
const backwardDuration = function(playlist, endSequence) {
  let result = 0;
  let i = endSequence - playlist.mediaSequence;
  let segment = playlist.segments[i];
  if (segment) {
    if (typeof segment.start !== "undefined") {
      return {
        result: segment.start,
        precise: true
      };
    }
    if (typeof segment.end !== "undefined") {
      return {
        result: segment.end - segment.duration,
        precise: true
      };
    }
  }
  while (i--) {
    segment = playlist.segments[i];
    if (typeof segment.end !== "undefined") {
      return {
        result: result + segment.end,
        precise: true
      };
    }
    result += segmentDurationWithParts(playlist, segment);
    if (typeof segment.start !== "undefined") {
      return {
        result: result + segment.start,
        precise: true
      };
    }
  }
  return {
    result,
    precise: false
  };
};
const forwardDuration = function(playlist, endSequence) {
  let result = 0;
  let segment;
  let i = endSequence - playlist.mediaSequence;
  for (; i < playlist.segments.length; i++) {
    segment = playlist.segments[i];
    if (typeof segment.start !== "undefined") {
      return {
        result: segment.start - result,
        precise: true
      };
    }
    result += segmentDurationWithParts(playlist, segment);
    if (typeof segment.end !== "undefined") {
      return {
        result: segment.end - result,
        precise: true
      };
    }
  }
  return {
    result: -1,
    precise: false
  };
};
const intervalDuration = function(playlist, endSequence, expired) {
  if (typeof endSequence === "undefined") {
    endSequence = playlist.mediaSequence + playlist.segments.length;
  }
  if (endSequence < playlist.mediaSequence) {
    return 0;
  }
  const backward = backwardDuration(playlist, endSequence);
  if (backward.precise) {
    return backward.result;
  }
  const forward = forwardDuration(playlist, endSequence);
  if (forward.precise) {
    return forward.result;
  }
  return backward.result + expired;
};
const duration = function(playlist, endSequence, expired) {
  if (!playlist) {
    return 0;
  }
  if (typeof expired !== "number") {
    expired = 0;
  }
  if (typeof endSequence === "undefined") {
    if (playlist.totalDuration) {
      return playlist.totalDuration;
    }
    if (!playlist.endList) {
      return window_1.Infinity;
    }
  }
  return intervalDuration(playlist, endSequence, expired);
};
const sumDurations = function({
  defaultDuration,
  durationList,
  startIndex,
  endIndex
}) {
  let durations = 0;
  if (startIndex > endIndex) {
    [startIndex, endIndex] = [endIndex, startIndex];
  }
  if (startIndex < 0) {
    for (let i = startIndex; i < Math.min(0, endIndex); i++) {
      durations += defaultDuration;
    }
    startIndex = 0;
  }
  for (let i = startIndex; i < endIndex; i++) {
    durations += durationList[i].duration;
  }
  return durations;
};
const playlistEnd = function(playlist, expired, useSafeLiveEnd, liveEdgePadding) {
  if (!playlist || !playlist.segments) {
    return null;
  }
  if (playlist.endList) {
    return duration(playlist);
  }
  if (expired === null) {
    return null;
  }
  expired = expired || 0;
  let lastSegmentEndTime = intervalDuration(playlist, playlist.mediaSequence + playlist.segments.length, expired);
  if (useSafeLiveEnd) {
    liveEdgePadding = typeof liveEdgePadding === "number" ? liveEdgePadding : liveEdgeDelay(null, playlist);
    lastSegmentEndTime -= liveEdgePadding;
  }
  return Math.max(0, lastSegmentEndTime);
};
const seekable = function(playlist, expired, liveEdgePadding) {
  const useSafeLiveEnd = true;
  const seekableStart = expired || 0;
  let seekableEnd = playlistEnd(playlist, expired, useSafeLiveEnd, liveEdgePadding);
  if (seekableEnd === null) {
    return createTimeRanges();
  }
  if (seekableEnd < seekableStart) {
    seekableEnd = seekableStart;
  }
  return createTimeRanges(seekableStart, seekableEnd);
};
const getMediaInfoForTime = function({
  playlist,
  currentTime,
  startingSegmentIndex,
  startingPartIndex,
  startTime,
  exactManifestTimings
}) {
  let time = currentTime - startTime;
  const partsAndSegments = getPartsAndSegments(playlist);
  let startIndex = 0;
  for (let i = 0; i < partsAndSegments.length; i++) {
    const partAndSegment = partsAndSegments[i];
    if (startingSegmentIndex !== partAndSegment.segmentIndex) {
      continue;
    }
    if (typeof startingPartIndex === "number" && typeof partAndSegment.partIndex === "number" && startingPartIndex !== partAndSegment.partIndex) {
      continue;
    }
    startIndex = i;
    break;
  }
  if (time < 0) {
    if (startIndex > 0) {
      for (let i = startIndex - 1; i >= 0; i--) {
        const partAndSegment = partsAndSegments[i];
        time += partAndSegment.duration;
        if (exactManifestTimings) {
          if (time < 0) {
            continue;
          }
        } else if (time + TIME_FUDGE_FACTOR <= 0) {
          continue;
        }
        return {
          partIndex: partAndSegment.partIndex,
          segmentIndex: partAndSegment.segmentIndex,
          startTime: startTime - sumDurations({
            defaultDuration: playlist.targetDuration,
            durationList: partsAndSegments,
            startIndex,
            endIndex: i
          })
        };
      }
    }
    return {
      partIndex: partsAndSegments[0] && partsAndSegments[0].partIndex || null,
      segmentIndex: partsAndSegments[0] && partsAndSegments[0].segmentIndex || 0,
      startTime: currentTime
    };
  }
  if (startIndex < 0) {
    for (let i = startIndex; i < 0; i++) {
      time -= playlist.targetDuration;
      if (time < 0) {
        return {
          partIndex: partsAndSegments[0] && partsAndSegments[0].partIndex || null,
          segmentIndex: partsAndSegments[0] && partsAndSegments[0].segmentIndex || 0,
          startTime: currentTime
        };
      }
    }
    startIndex = 0;
  }
  for (let i = startIndex; i < partsAndSegments.length; i++) {
    const partAndSegment = partsAndSegments[i];
    time -= partAndSegment.duration;
    const canUseFudgeFactor = partAndSegment.duration > TIME_FUDGE_FACTOR;
    const isExactlyAtTheEnd = time === 0;
    const isExtremelyCloseToTheEnd = canUseFudgeFactor && time + TIME_FUDGE_FACTOR >= 0;
    if (isExactlyAtTheEnd || isExtremelyCloseToTheEnd) {
      if (i !== partsAndSegments.length - 1) {
        continue;
      }
    }
    if (exactManifestTimings) {
      if (time > 0) {
        continue;
      }
    } else if (time - TIME_FUDGE_FACTOR >= 0) {
      continue;
    }
    return {
      partIndex: partAndSegment.partIndex,
      segmentIndex: partAndSegment.segmentIndex,
      startTime: startTime + sumDurations({
        defaultDuration: playlist.targetDuration,
        durationList: partsAndSegments,
        startIndex,
        endIndex: i
      })
    };
  }
  return {
    segmentIndex: partsAndSegments[partsAndSegments.length - 1].segmentIndex,
    partIndex: partsAndSegments[partsAndSegments.length - 1].partIndex,
    startTime: currentTime
  };
};
const isExcluded = function(playlist) {
  return playlist.excludeUntil && playlist.excludeUntil > Date.now();
};
const isIncompatible = function(playlist) {
  return playlist.excludeUntil && playlist.excludeUntil === Infinity;
};
const isEnabled = function(playlist) {
  const excluded = isExcluded(playlist);
  return !playlist.disabled && !excluded;
};
const isDisabled = function(playlist) {
  return playlist.disabled;
};
const isAes = function(media) {
  for (let i = 0; i < media.segments.length; i++) {
    if (media.segments[i].key) {
      return true;
    }
  }
  return false;
};
const hasAttribute = function(attr, playlist) {
  return playlist.attributes && playlist.attributes[attr];
};
const estimateSegmentRequestTime = function(segmentDuration, bandwidth, playlist, bytesReceived = 0) {
  if (!hasAttribute("BANDWIDTH", playlist)) {
    return NaN;
  }
  const size = segmentDuration * playlist.attributes.BANDWIDTH;
  return (size - bytesReceived * 8) / bandwidth;
};
const isLowestEnabledRendition = (main, media) => {
  if (main.playlists.length === 1) {
    return true;
  }
  const currentBandwidth = media.attributes.BANDWIDTH || Number.MAX_VALUE;
  return main.playlists.filter((playlist) => {
    if (!isEnabled(playlist)) {
      return false;
    }
    return (playlist.attributes.BANDWIDTH || 0) < currentBandwidth;
  }).length === 0;
};
const playlistMatch = (a, b) => {
  if (!a && !b || !a && b || a && !b) {
    return false;
  }
  if (a === b) {
    return true;
  }
  if (a.id && b.id && a.id === b.id) {
    return true;
  }
  if (a.resolvedUri && b.resolvedUri && a.resolvedUri === b.resolvedUri) {
    return true;
  }
  if (a.uri && b.uri && a.uri === b.uri) {
    return true;
  }
  return false;
};
const someAudioVariant = function(main, callback) {
  const AUDIO = main && main.mediaGroups && main.mediaGroups.AUDIO || {};
  let found = false;
  for (const groupName in AUDIO) {
    for (const label in AUDIO[groupName]) {
      found = callback(AUDIO[groupName][label]);
      if (found) {
        break;
      }
    }
    if (found) {
      break;
    }
  }
  return !!found;
};
const isAudioOnly = (main) => {
  if (!main || !main.playlists || !main.playlists.length) {
    const found = someAudioVariant(main, (variant) => variant.playlists && variant.playlists.length || variant.uri);
    return found;
  }
  for (let i = 0; i < main.playlists.length; i++) {
    const playlist = main.playlists[i];
    const CODECS = playlist.attributes && playlist.attributes.CODECS;
    if (CODECS && CODECS.split(",").every((c) => isAudioCodec(c))) {
      continue;
    }
    const found = someAudioVariant(main, (variant) => playlistMatch(playlist, variant));
    if (found) {
      continue;
    }
    return false;
  }
  return true;
};
var Playlist = {
  liveEdgeDelay,
  duration,
  seekable,
  getMediaInfoForTime,
  isEnabled,
  isDisabled,
  isExcluded,
  isIncompatible,
  playlistEnd,
  isAes,
  hasAttribute,
  estimateSegmentRequestTime,
  isLowestEnabledRendition,
  isAudioOnly,
  playlistMatch,
  segmentDurationWithParts
};
const {
  log
} = videojs;
const createPlaylistID = (index, uri) => {
  return `${index}-${uri}`;
};
const groupID = (type, group, label) => {
  return `placeholder-uri-${type}-${group}-${label}`;
};
const parseManifest = ({
  onwarn,
  oninfo,
  manifestString,
  customTagParsers = [],
  customTagMappers = [],
  llhls
}) => {
  const parser = new Parser();
  if (onwarn) {
    parser.on("warn", onwarn);
  }
  if (oninfo) {
    parser.on("info", oninfo);
  }
  customTagParsers.forEach((customParser) => parser.addParser(customParser));
  customTagMappers.forEach((mapper) => parser.addTagMapper(mapper));
  parser.push(manifestString);
  parser.end();
  const manifest = parser.manifest;
  if (!llhls) {
    ["preloadSegment", "skip", "serverControl", "renditionReports", "partInf", "partTargetDuration"].forEach(function(k) {
      if (manifest.hasOwnProperty(k)) {
        delete manifest[k];
      }
    });
    if (manifest.segments) {
      manifest.segments.forEach(function(segment) {
        ["parts", "preloadHints"].forEach(function(k) {
          if (segment.hasOwnProperty(k)) {
            delete segment[k];
          }
        });
      });
    }
  }
  if (!manifest.targetDuration) {
    let targetDuration = 10;
    if (manifest.segments && manifest.segments.length) {
      targetDuration = manifest.segments.reduce((acc, s) => Math.max(acc, s.duration), 0);
    }
    if (onwarn) {
      onwarn({
        message: `manifest has no targetDuration defaulting to ${targetDuration}`
      });
    }
    manifest.targetDuration = targetDuration;
  }
  const parts = getLastParts(manifest);
  if (parts.length && !manifest.partTargetDuration) {
    const partTargetDuration = parts.reduce((acc, p) => Math.max(acc, p.duration), 0);
    if (onwarn) {
      onwarn({
        message: `manifest has no partTargetDuration defaulting to ${partTargetDuration}`
      });
      log.error("LL-HLS manifest has parts but lacks required #EXT-X-PART-INF:PART-TARGET value. See https://datatracker.ietf.org/doc/html/draft-pantos-hls-rfc8216bis-09#section-4.4.3.7. Playback is not guaranteed.");
    }
    manifest.partTargetDuration = partTargetDuration;
  }
  return manifest;
};
const forEachMediaGroup = (main, callback) => {
  if (!main.mediaGroups) {
    return;
  }
  ["AUDIO", "SUBTITLES"].forEach((mediaType) => {
    if (!main.mediaGroups[mediaType]) {
      return;
    }
    for (const groupKey in main.mediaGroups[mediaType]) {
      for (const labelKey in main.mediaGroups[mediaType][groupKey]) {
        const mediaProperties = main.mediaGroups[mediaType][groupKey][labelKey];
        callback(mediaProperties, mediaType, groupKey, labelKey);
      }
    }
  });
};
const setupMediaPlaylist = ({
  playlist,
  uri,
  id
}) => {
  playlist.id = id;
  playlist.playlistErrors_ = 0;
  if (uri) {
    playlist.uri = uri;
  }
  playlist.attributes = playlist.attributes || {};
};
const setupMediaPlaylists = (main) => {
  let i = main.playlists.length;
  while (i--) {
    const playlist = main.playlists[i];
    setupMediaPlaylist({
      playlist,
      id: createPlaylistID(i, playlist.uri)
    });
    playlist.resolvedUri = resolveUrl(main.uri, playlist.uri);
    main.playlists[playlist.id] = playlist;
    main.playlists[playlist.uri] = playlist;
    if (!playlist.attributes.BANDWIDTH) {
      log.warn("Invalid playlist STREAM-INF detected. Missing BANDWIDTH attribute.");
    }
  }
};
const resolveMediaGroupUris = (main) => {
  forEachMediaGroup(main, (properties) => {
    if (properties.uri) {
      properties.resolvedUri = resolveUrl(main.uri, properties.uri);
    }
  });
};
const mainForMedia = (media, uri) => {
  const id = createPlaylistID(0, uri);
  const main = {
    mediaGroups: {
      "AUDIO": {},
      "VIDEO": {},
      "CLOSED-CAPTIONS": {},
      "SUBTITLES": {}
    },
    uri: window_1.location.href,
    resolvedUri: window_1.location.href,
    playlists: [{
      uri,
      id,
      resolvedUri: uri,
      attributes: {}
    }]
  };
  main.playlists[id] = main.playlists[0];
  main.playlists[uri] = main.playlists[0];
  return main;
};
const addPropertiesToMain = (main, uri, createGroupID = groupID) => {
  main.uri = uri;
  for (let i = 0; i < main.playlists.length; i++) {
    if (!main.playlists[i].uri) {
      const phonyUri = `placeholder-uri-${i}`;
      main.playlists[i].uri = phonyUri;
    }
  }
  const audioOnlyMain = isAudioOnly(main);
  forEachMediaGroup(main, (properties, mediaType, groupKey, labelKey) => {
    if (!properties.playlists || !properties.playlists.length) {
      if (audioOnlyMain && mediaType === "AUDIO" && !properties.uri) {
        for (let i = 0; i < main.playlists.length; i++) {
          const p = main.playlists[i];
          if (p.attributes && p.attributes.AUDIO && p.attributes.AUDIO === groupKey) {
            return;
          }
        }
      }
      properties.playlists = [_extends({}, properties)];
    }
    properties.playlists.forEach(function(p, i) {
      const groupId = createGroupID(mediaType, groupKey, labelKey, p);
      const id = createPlaylistID(i, groupId);
      if (p.uri) {
        p.resolvedUri = p.resolvedUri || resolveUrl(main.uri, p.uri);
      } else {
        p.uri = i === 0 ? groupId : id;
        p.resolvedUri = p.uri;
      }
      p.id = p.id || id;
      p.attributes = p.attributes || {};
      main.playlists[p.id] = p;
      main.playlists[p.uri] = p;
    });
  });
  setupMediaPlaylists(main);
  resolveMediaGroupUris(main);
};
class DateRangesStorage {
  constructor() {
    this.offset_ = null;
    this.pendingDateRanges_ = /* @__PURE__ */ new Map();
    this.processedDateRanges_ = /* @__PURE__ */ new Map();
  }
  setOffset(segments = []) {
    if (this.offset_ !== null) {
      return;
    }
    if (!segments.length) {
      return;
    }
    const [firstSegment] = segments;
    if (firstSegment.programDateTime === void 0) {
      return;
    }
    this.offset_ = firstSegment.programDateTime / 1e3;
  }
  setPendingDateRanges(dateRanges = []) {
    if (!dateRanges.length) {
      return;
    }
    const [dateRange] = dateRanges;
    const startTime = dateRange.startDate.getTime();
    this.trimProcessedDateRanges_(startTime);
    this.pendingDateRanges_ = dateRanges.reduce((map, pendingDateRange) => {
      map.set(pendingDateRange.id, pendingDateRange);
      return map;
    }, /* @__PURE__ */ new Map());
  }
  processDateRange(dateRange) {
    this.pendingDateRanges_.delete(dateRange.id);
    this.processedDateRanges_.set(dateRange.id, dateRange);
  }
  getDateRangesToProcess() {
    if (this.offset_ === null) {
      return [];
    }
    const dateRangeClasses = {};
    const dateRangesToProcess = [];
    this.pendingDateRanges_.forEach((dateRange, id) => {
      if (this.processedDateRanges_.has(id)) {
        return;
      }
      dateRange.startTime = dateRange.startDate.getTime() / 1e3 - this.offset_;
      dateRange.processDateRange = () => this.processDateRange(dateRange);
      dateRangesToProcess.push(dateRange);
      if (!dateRange.class) {
        return;
      }
      if (dateRangeClasses[dateRange.class]) {
        const length = dateRangeClasses[dateRange.class].push(dateRange);
        dateRange.classListIndex = length - 1;
      } else {
        dateRangeClasses[dateRange.class] = [dateRange];
        dateRange.classListIndex = 0;
      }
    });
    for (const dateRange of dateRangesToProcess) {
      const classList = dateRangeClasses[dateRange.class] || [];
      if (dateRange.endDate) {
        dateRange.endTime = dateRange.endDate.getTime() / 1e3 - this.offset_;
      } else if (dateRange.endOnNext && classList[dateRange.classListIndex + 1]) {
        dateRange.endTime = classList[dateRange.classListIndex + 1].startTime;
      } else if (dateRange.duration) {
        dateRange.endTime = dateRange.startTime + dateRange.duration;
      } else if (dateRange.plannedDuration) {
        dateRange.endTime = dateRange.startTime + dateRange.plannedDuration;
      } else {
        dateRange.endTime = dateRange.startTime;
      }
    }
    return dateRangesToProcess;
  }
  trimProcessedDateRanges_(startTime) {
    const copy = new Map(this.processedDateRanges_);
    copy.forEach((dateRange, id) => {
      if (dateRange.startDate.getTime() < startTime) {
        this.processedDateRanges_.delete(id);
      }
    });
  }
}
const QUOTA_EXCEEDED_ERR = 22;
const getStreamingNetworkErrorMetadata = ({
  requestType,
  request,
  error,
  parseFailure
}) => {
  const isBadStatus = request.status < 200 || request.status > 299;
  const isFailure = request.status >= 400 && request.status <= 499;
  const errorMetadata = {
    uri: request.uri,
    requestType
  };
  const isBadStatusOrParseFailure = isBadStatus && !isFailure || parseFailure;
  if (error && isFailure) {
    errorMetadata.error = _extends({}, error);
    errorMetadata.errorType = videojs.Error.NetworkRequestFailed;
  } else if (request.aborted) {
    errorMetadata.errorType = videojs.Error.NetworkRequestAborted;
  } else if (request.timedout) {
    errorMetadata.errorType = videojs.Error.NetworkRequestTimeout;
  } else if (isBadStatusOrParseFailure) {
    const errorType = parseFailure ? videojs.Error.NetworkBodyParserFailed : videojs.Error.NetworkBadStatus;
    errorMetadata.errorType = errorType;
    errorMetadata.status = request.status;
    errorMetadata.headers = request.headers;
  }
  return errorMetadata;
};
const logFn$1 = logger("CodecUtils");
const getCodecs = function(media) {
  const mediaAttributes = media.attributes || {};
  if (mediaAttributes.CODECS) {
    return parseCodecs(mediaAttributes.CODECS);
  }
};
const isMaat = (main, media) => {
  const mediaAttributes = media.attributes || {};
  return main && main.mediaGroups && main.mediaGroups.AUDIO && mediaAttributes.AUDIO && main.mediaGroups.AUDIO[mediaAttributes.AUDIO];
};
const isMuxed = (main, media) => {
  if (!isMaat(main, media)) {
    return true;
  }
  const mediaAttributes = media.attributes || {};
  const audioGroup = main.mediaGroups.AUDIO[mediaAttributes.AUDIO];
  for (const groupId in audioGroup) {
    if (!audioGroup[groupId].uri && !audioGroup[groupId].playlists) {
      return true;
    }
  }
  return false;
};
const unwrapCodecList = function(codecList) {
  const codecs = {};
  codecList.forEach(({
    mediaType,
    type,
    details
  }) => {
    codecs[mediaType] = codecs[mediaType] || [];
    codecs[mediaType].push(translateLegacyCodec(`${type}${details}`));
  });
  Object.keys(codecs).forEach(function(mediaType) {
    if (codecs[mediaType].length > 1) {
      logFn$1(`multiple ${mediaType} codecs found as attributes: ${codecs[mediaType].join(", ")}. Setting playlist codecs to null so that we wait for mux.js to probe segments for real codecs.`);
      codecs[mediaType] = null;
      return;
    }
    codecs[mediaType] = codecs[mediaType][0];
  });
  return codecs;
};
const codecCount = function(codecObj) {
  let count = 0;
  if (codecObj.audio) {
    count++;
  }
  if (codecObj.video) {
    count++;
  }
  return count;
};
const codecsForPlaylist = function(main, media) {
  const mediaAttributes = media.attributes || {};
  const codecInfo = unwrapCodecList(getCodecs(media) || []);
  if (isMaat(main, media) && !codecInfo.audio) {
    if (!isMuxed(main, media)) {
      const defaultCodecs = unwrapCodecList(codecsFromDefault(main, mediaAttributes.AUDIO) || []);
      if (defaultCodecs.audio) {
        codecInfo.audio = defaultCodecs.audio;
      }
    }
  }
  return codecInfo;
};
const {
  EventTarget: EventTarget$1
} = videojs;
const addLLHLSQueryDirectives = (uri, media) => {
  if (media.endList || !media.serverControl) {
    return uri;
  }
  const parameters = {};
  if (media.serverControl.canBlockReload) {
    const {
      preloadSegment
    } = media;
    let nextMSN = media.mediaSequence + media.segments.length;
    if (preloadSegment) {
      const parts = preloadSegment.parts || [];
      const nextPart = getKnownPartCount(media) - 1;
      if (nextPart > -1 && nextPart !== parts.length - 1) {
        parameters._HLS_part = nextPart;
      }
      if (nextPart > -1 || parts.length) {
        nextMSN--;
      }
    }
    parameters._HLS_msn = nextMSN;
  }
  if (media.serverControl && media.serverControl.canSkipUntil) {
    parameters._HLS_skip = media.serverControl.canSkipDateranges ? "v2" : "YES";
  }
  if (Object.keys(parameters).length) {
    const parsedUri = new window_1.URL(uri);
    ["_HLS_skip", "_HLS_msn", "_HLS_part"].forEach(function(name) {
      if (!parameters.hasOwnProperty(name)) {
        return;
      }
      parsedUri.searchParams.set(name, parameters[name]);
    });
    uri = parsedUri.toString();
  }
  return uri;
};
const updateSegment = (a, b) => {
  if (!a) {
    return b;
  }
  const result = merge(a, b);
  if (a.preloadHints && !b.preloadHints) {
    delete result.preloadHints;
  }
  if (a.parts && !b.parts) {
    delete result.parts;
  } else if (a.parts && b.parts) {
    for (let i = 0; i < b.parts.length; i++) {
      if (a.parts && a.parts[i]) {
        result.parts[i] = merge(a.parts[i], b.parts[i]);
      }
    }
  }
  if (!a.skipped && b.skipped) {
    result.skipped = false;
  }
  if (a.preload && !b.preload) {
    result.preload = false;
  }
  return result;
};
const updateSegments = (original, update, offset) => {
  const oldSegments = original.slice();
  const newSegments = update.slice();
  offset = offset || 0;
  const result = [];
  let currentMap;
  for (let newIndex = 0; newIndex < newSegments.length; newIndex++) {
    const oldSegment = oldSegments[newIndex + offset];
    const newSegment = newSegments[newIndex];
    if (oldSegment) {
      currentMap = oldSegment.map || currentMap;
      result.push(updateSegment(oldSegment, newSegment));
    } else {
      if (currentMap && !newSegment.map) {
        newSegment.map = currentMap;
      }
      result.push(newSegment);
    }
  }
  return result;
};
const resolveSegmentUris = (segment, baseUri) => {
  if (!segment.resolvedUri && segment.uri) {
    segment.resolvedUri = resolveUrl(baseUri, segment.uri);
  }
  if (segment.key && !segment.key.resolvedUri) {
    segment.key.resolvedUri = resolveUrl(baseUri, segment.key.uri);
  }
  if (segment.map && !segment.map.resolvedUri) {
    segment.map.resolvedUri = resolveUrl(baseUri, segment.map.uri);
  }
  if (segment.map && segment.map.key && !segment.map.key.resolvedUri) {
    segment.map.key.resolvedUri = resolveUrl(baseUri, segment.map.key.uri);
  }
  if (segment.parts && segment.parts.length) {
    segment.parts.forEach((p) => {
      if (p.resolvedUri) {
        return;
      }
      p.resolvedUri = resolveUrl(baseUri, p.uri);
    });
  }
  if (segment.preloadHints && segment.preloadHints.length) {
    segment.preloadHints.forEach((p) => {
      if (p.resolvedUri) {
        return;
      }
      p.resolvedUri = resolveUrl(baseUri, p.uri);
    });
  }
};
const getAllSegments = function(media) {
  const segments = media.segments || [];
  const preloadSegment = media.preloadSegment;
  if (preloadSegment && preloadSegment.parts && preloadSegment.parts.length) {
    if (preloadSegment.preloadHints) {
      for (let i = 0; i < preloadSegment.preloadHints.length; i++) {
        if (preloadSegment.preloadHints[i].type === "MAP") {
          return segments;
        }
      }
    }
    preloadSegment.duration = media.targetDuration;
    preloadSegment.preload = true;
    segments.push(preloadSegment);
  }
  return segments;
};
const isPlaylistUnchanged = (a, b) => a === b || a.segments && b.segments && a.segments.length === b.segments.length && a.endList === b.endList && a.mediaSequence === b.mediaSequence && a.preloadSegment === b.preloadSegment;
const updateMain$1 = (main, newMedia, unchangedCheck = isPlaylistUnchanged) => {
  const result = merge(main, {});
  const oldMedia = result.playlists[newMedia.id];
  if (!oldMedia) {
    return null;
  }
  if (unchangedCheck(oldMedia, newMedia)) {
    return null;
  }
  newMedia.segments = getAllSegments(newMedia);
  const mergedPlaylist = merge(oldMedia, newMedia);
  if (mergedPlaylist.preloadSegment && !newMedia.preloadSegment) {
    delete mergedPlaylist.preloadSegment;
  }
  if (oldMedia.segments) {
    if (newMedia.skip) {
      newMedia.segments = newMedia.segments || [];
      for (let i = 0; i < newMedia.skip.skippedSegments; i++) {
        newMedia.segments.unshift({
          skipped: true
        });
      }
    }
    mergedPlaylist.segments = updateSegments(oldMedia.segments, newMedia.segments, newMedia.mediaSequence - oldMedia.mediaSequence);
  }
  mergedPlaylist.segments.forEach((segment) => {
    resolveSegmentUris(segment, mergedPlaylist.resolvedUri);
  });
  for (let i = 0; i < result.playlists.length; i++) {
    if (result.playlists[i].id === newMedia.id) {
      result.playlists[i] = mergedPlaylist;
    }
  }
  result.playlists[newMedia.id] = mergedPlaylist;
  result.playlists[newMedia.uri] = mergedPlaylist;
  forEachMediaGroup(main, (properties, mediaType, groupKey, labelKey) => {
    if (!properties.playlists) {
      return;
    }
    for (let i = 0; i < properties.playlists.length; i++) {
      if (newMedia.id === properties.playlists[i].id) {
        properties.playlists[i] = mergedPlaylist;
      }
    }
  });
  return result;
};
const refreshDelay = (media, update) => {
  const segments = media.segments || [];
  const lastSegment = segments[segments.length - 1];
  const lastPart = lastSegment && lastSegment.parts && lastSegment.parts[lastSegment.parts.length - 1];
  const lastDuration = lastPart && lastPart.duration || lastSegment && lastSegment.duration;
  if (update && lastDuration) {
    return lastDuration * 1e3;
  }
  return (media.partTargetDuration || media.targetDuration || 10) * 500;
};
const playlistMetadataPayload = (playlists, type, isLive) => {
  if (!playlists) {
    return;
  }
  const renditions = [];
  playlists.forEach((playlist) => {
    if (!playlist.attributes) {
      return;
    }
    const {
      BANDWIDTH,
      RESOLUTION,
      CODECS
    } = playlist.attributes;
    renditions.push({
      id: playlist.id,
      bandwidth: BANDWIDTH,
      resolution: RESOLUTION,
      codecs: CODECS
    });
  });
  return {
    type,
    isLive,
    renditions
  };
};
class PlaylistLoader extends EventTarget$1 {
  constructor(src, vhs, options = {}) {
    super();
    if (!src) {
      throw new Error("A non-empty playlist URL or object is required");
    }
    this.logger_ = logger("PlaylistLoader");
    const {
      withCredentials = false
    } = options;
    this.src = src;
    this.vhs_ = vhs;
    this.withCredentials = withCredentials;
    this.addDateRangesToTextTrack_ = options.addDateRangesToTextTrack;
    const vhsOptions = vhs.options_;
    this.customTagParsers = vhsOptions && vhsOptions.customTagParsers || [];
    this.customTagMappers = vhsOptions && vhsOptions.customTagMappers || [];
    this.llhls = vhsOptions && vhsOptions.llhls;
    this.dateRangesStorage_ = new DateRangesStorage();
    this.state = "HAVE_NOTHING";
    this.handleMediaupdatetimeout_ = this.handleMediaupdatetimeout_.bind(this);
    this.on("mediaupdatetimeout", this.handleMediaupdatetimeout_);
    this.on("loadedplaylist", this.handleLoadedPlaylist_.bind(this));
  }
  handleLoadedPlaylist_() {
    const mediaPlaylist = this.media();
    if (!mediaPlaylist) {
      return;
    }
    this.dateRangesStorage_.setOffset(mediaPlaylist.segments);
    this.dateRangesStorage_.setPendingDateRanges(mediaPlaylist.dateRanges);
    const availableDateRanges = this.dateRangesStorage_.getDateRangesToProcess();
    if (!availableDateRanges.length || !this.addDateRangesToTextTrack_) {
      return;
    }
    this.addDateRangesToTextTrack_(availableDateRanges);
  }
  handleMediaupdatetimeout_() {
    if (this.state !== "HAVE_METADATA") {
      return;
    }
    const media = this.media();
    let uri = resolveUrl(this.main.uri, media.uri);
    if (this.llhls) {
      uri = addLLHLSQueryDirectives(uri, media);
    }
    this.state = "HAVE_CURRENT_METADATA";
    this.request = this.vhs_.xhr({
      uri,
      withCredentials: this.withCredentials,
      requestType: "hls-playlist"
    }, (error, req) => {
      if (!this.request) {
        return;
      }
      if (error) {
        return this.playlistRequestError(this.request, this.media(), "HAVE_METADATA");
      }
      this.haveMetadata({
        playlistString: this.request.responseText,
        url: this.media().uri,
        id: this.media().id
      });
    });
  }
  playlistRequestError(xhr, playlist, startingState) {
    const {
      uri,
      id
    } = playlist;
    this.request = null;
    if (startingState) {
      this.state = startingState;
    }
    this.error = {
      playlist: this.main.playlists[id],
      status: xhr.status,
      message: `HLS playlist request error at URL: ${uri}.`,
      responseText: xhr.responseText,
      code: xhr.status >= 500 ? 4 : 2,
      metadata: getStreamingNetworkErrorMetadata({
        requestType: xhr.requestType,
        request: xhr,
        error: xhr.error
      })
    };
    this.trigger("error");
  }
  parseManifest_({
    url,
    manifestString
  }) {
    try {
      const parsed = parseManifest({
        onwarn: ({
          message
        }) => this.logger_(`m3u8-parser warn for ${url}: ${message}`),
        oninfo: ({
          message
        }) => this.logger_(`m3u8-parser info for ${url}: ${message}`),
        manifestString,
        customTagParsers: this.customTagParsers,
        customTagMappers: this.customTagMappers,
        llhls: this.llhls
      });
      if (!parsed.playlists || !parsed.playlists.length) {
        return parsed;
      }
      this.excludeAudioOnlyVariants(parsed.playlists);
      return parsed;
    } catch (error) {
      this.error = error;
      this.error.metadata = {
        errorType: videojs.Error.StreamingHlsPlaylistParserError,
        error
      };
    }
  }
  excludeAudioOnlyVariants(playlists) {
    const hasVideo = (playlist) => {
      const attributes = playlist.attributes || {};
      const {
        width,
        height
      } = attributes.RESOLUTION || {};
      if (width && height) {
        return true;
      }
      const codecsList = getCodecs(playlist) || [];
      const codecsInfo = unwrapCodecList(codecsList);
      return Boolean(codecsInfo.video);
    };
    if (playlists.some(hasVideo)) {
      playlists.forEach((playlist) => {
        if (!hasVideo(playlist)) {
          playlist.excludeUntil = Infinity;
        }
      });
    }
  }
  haveMetadata({
    playlistString,
    playlistObject,
    url,
    id
  }) {
    this.request = null;
    this.state = "HAVE_METADATA";
    const metadata = {
      playlistInfo: {
        type: "media",
        uri: url
      }
    };
    this.trigger({
      type: "playlistparsestart",
      metadata
    });
    const playlist = playlistObject || this.parseManifest_({
      url,
      manifestString: playlistString
    });
    playlist.lastRequest = Date.now();
    setupMediaPlaylist({
      playlist,
      uri: url,
      id
    });
    const update = updateMain$1(this.main, playlist);
    this.targetDuration = playlist.partTargetDuration || playlist.targetDuration;
    this.pendingMedia_ = null;
    if (update) {
      this.main = update;
      this.media_ = this.main.playlists[id];
    } else {
      this.trigger("playlistunchanged");
    }
    this.updateMediaUpdateTimeout_(refreshDelay(this.media(), !!update));
    metadata.parsedPlaylist = playlistMetadataPayload(this.main.playlists, metadata.playlistInfo.type, !this.media_.endList);
    this.trigger({
      type: "playlistparsecomplete",
      metadata
    });
    this.trigger("loadedplaylist");
  }
  dispose() {
    this.trigger("dispose");
    this.stopRequest();
    window_1.clearTimeout(this.mediaUpdateTimeout);
    window_1.clearTimeout(this.finalRenditionTimeout);
    this.dateRangesStorage_ = new DateRangesStorage();
    this.off();
  }
  stopRequest() {
    if (this.request) {
      const oldRequest = this.request;
      this.request = null;
      oldRequest.onreadystatechange = null;
      oldRequest.abort();
    }
  }
  media(playlist, shouldDelay) {
    if (!playlist) {
      return this.media_;
    }
    if (this.state === "HAVE_NOTHING") {
      throw new Error("Cannot switch media playlist from " + this.state);
    }
    if (typeof playlist === "string") {
      if (!this.main.playlists[playlist]) {
        throw new Error("Unknown playlist URI: " + playlist);
      }
      playlist = this.main.playlists[playlist];
    }
    window_1.clearTimeout(this.finalRenditionTimeout);
    if (shouldDelay) {
      const delay = (playlist.partTargetDuration || playlist.targetDuration) / 2 * 1e3 || 5 * 1e3;
      this.finalRenditionTimeout = window_1.setTimeout(this.media.bind(this, playlist, false), delay);
      return;
    }
    const startingState = this.state;
    const mediaChange = !this.media_ || playlist.id !== this.media_.id;
    const mainPlaylistRef = this.main.playlists[playlist.id];
    if (mainPlaylistRef && mainPlaylistRef.endList || playlist.endList && playlist.segments.length) {
      if (this.request) {
        this.request.onreadystatechange = null;
        this.request.abort();
        this.request = null;
      }
      this.state = "HAVE_METADATA";
      this.media_ = playlist;
      if (mediaChange) {
        this.trigger("mediachanging");
        if (startingState === "HAVE_MAIN_MANIFEST") {
          this.trigger("loadedmetadata");
        } else {
          this.trigger("mediachange");
        }
      }
      return;
    }
    this.updateMediaUpdateTimeout_(refreshDelay(playlist, true));
    if (!mediaChange) {
      return;
    }
    this.state = "SWITCHING_MEDIA";
    if (this.request) {
      if (playlist.resolvedUri === this.request.url) {
        return;
      }
      this.request.onreadystatechange = null;
      this.request.abort();
      this.request = null;
    }
    if (this.media_) {
      this.trigger("mediachanging");
    }
    this.pendingMedia_ = playlist;
    const metadata = {
      playlistInfo: {
        type: "media",
        uri: playlist.uri
      }
    };
    this.trigger({
      type: "playlistrequeststart",
      metadata
    });
    this.request = this.vhs_.xhr({
      uri: playlist.resolvedUri,
      withCredentials: this.withCredentials,
      requestType: "hls-playlist"
    }, (error, req) => {
      if (!this.request) {
        return;
      }
      playlist.lastRequest = Date.now();
      playlist.resolvedUri = resolveManifestRedirect(playlist.resolvedUri, req);
      if (error) {
        return this.playlistRequestError(this.request, playlist, startingState);
      }
      this.trigger({
        type: "playlistrequestcomplete",
        metadata
      });
      this.haveMetadata({
        playlistString: req.responseText,
        url: playlist.uri,
        id: playlist.id
      });
      if (startingState === "HAVE_MAIN_MANIFEST") {
        this.trigger("loadedmetadata");
      } else {
        this.trigger("mediachange");
      }
    });
  }
  pause() {
    if (this.mediaUpdateTimeout) {
      window_1.clearTimeout(this.mediaUpdateTimeout);
      this.mediaUpdateTimeout = null;
    }
    this.stopRequest();
    if (this.state === "HAVE_NOTHING") {
      this.started = false;
    }
    if (this.state === "SWITCHING_MEDIA") {
      if (this.media_) {
        this.state = "HAVE_METADATA";
      } else {
        this.state = "HAVE_MAIN_MANIFEST";
      }
    } else if (this.state === "HAVE_CURRENT_METADATA") {
      this.state = "HAVE_METADATA";
    }
  }
  load(shouldDelay) {
    if (this.mediaUpdateTimeout) {
      window_1.clearTimeout(this.mediaUpdateTimeout);
      this.mediaUpdateTimeout = null;
    }
    const media = this.media();
    if (shouldDelay) {
      const delay = media ? (media.partTargetDuration || media.targetDuration) / 2 * 1e3 : 5 * 1e3;
      this.mediaUpdateTimeout = window_1.setTimeout(() => {
        this.mediaUpdateTimeout = null;
        this.load();
      }, delay);
      return;
    }
    if (!this.started) {
      this.start();
      return;
    }
    if (media && !media.endList) {
      this.trigger("mediaupdatetimeout");
    } else {
      this.trigger("loadedplaylist");
    }
  }
  updateMediaUpdateTimeout_(delay) {
    if (this.mediaUpdateTimeout) {
      window_1.clearTimeout(this.mediaUpdateTimeout);
      this.mediaUpdateTimeout = null;
    }
    if (!this.media() || this.media().endList) {
      return;
    }
    this.mediaUpdateTimeout = window_1.setTimeout(() => {
      this.mediaUpdateTimeout = null;
      this.trigger("mediaupdatetimeout");
      this.updateMediaUpdateTimeout_(delay);
    }, delay);
  }
  start() {
    this.started = true;
    if (typeof this.src === "object") {
      if (!this.src.uri) {
        this.src.uri = window_1.location.href;
      }
      this.src.resolvedUri = this.src.uri;
      setTimeout(() => {
        this.setupInitialPlaylist(this.src);
      }, 0);
      return;
    }
    const metadata = {
      playlistInfo: {
        type: "multivariant",
        uri: this.src
      }
    };
    this.trigger({
      type: "playlistrequeststart",
      metadata
    });
    this.request = this.vhs_.xhr({
      uri: this.src,
      withCredentials: this.withCredentials,
      requestType: "hls-playlist"
    }, (error, req) => {
      if (!this.request) {
        return;
      }
      this.request = null;
      if (error) {
        this.error = {
          status: req.status,
          message: `HLS playlist request error at URL: ${this.src}.`,
          responseText: req.responseText,
          code: 2,
          metadata: getStreamingNetworkErrorMetadata({
            requestType: req.requestType,
            request: req,
            error
          })
        };
        if (this.state === "HAVE_NOTHING") {
          this.started = false;
        }
        return this.trigger("error");
      }
      this.trigger({
        type: "playlistrequestcomplete",
        metadata
      });
      this.src = resolveManifestRedirect(this.src, req);
      this.trigger({
        type: "playlistparsestart",
        metadata
      });
      const manifest = this.parseManifest_({
        manifestString: req.responseText,
        url: this.src
      });
      metadata.parsedPlaylist = playlistMetadataPayload(manifest.playlists, metadata.playlistInfo.type, false);
      this.trigger({
        type: "playlistparsecomplete",
        metadata
      });
      this.setupInitialPlaylist(manifest);
    });
  }
  srcUri() {
    return typeof this.src === "string" ? this.src : this.src.uri;
  }
  setupInitialPlaylist(manifest) {
    this.state = "HAVE_MAIN_MANIFEST";
    if (manifest.playlists) {
      this.main = manifest;
      addPropertiesToMain(this.main, this.srcUri());
      manifest.playlists.forEach((playlist) => {
        playlist.segments = getAllSegments(playlist);
        playlist.segments.forEach((segment) => {
          resolveSegmentUris(segment, playlist.resolvedUri);
        });
      });
      this.trigger("loadedplaylist");
      if (!this.request) {
        this.media(this.main.playlists[0]);
      }
      return;
    }
    const uri = this.srcUri() || window_1.location.href;
    this.main = mainForMedia(manifest, uri);
    this.haveMetadata({
      playlistObject: manifest,
      url: uri,
      id: this.main.playlists[0].id
    });
    this.trigger("loadedmetadata");
  }
  updateOrDeleteClone(clone, isUpdate) {
    const main = this.main;
    const pathway = clone.ID;
    let i = main.playlists.length;
    while (i--) {
      const p = main.playlists[i];
      if (p.attributes["PATHWAY-ID"] === pathway) {
        const oldPlaylistUri = p.resolvedUri;
        const oldPlaylistId = p.id;
        if (isUpdate) {
          const newPlaylistUri = this.createCloneURI_(p.resolvedUri, clone);
          const newPlaylistId = createPlaylistID(pathway, newPlaylistUri);
          const attributes = this.createCloneAttributes_(pathway, p.attributes);
          const updatedPlaylist = this.createClonePlaylist_(p, newPlaylistId, clone, attributes);
          main.playlists[i] = updatedPlaylist;
          main.playlists[newPlaylistId] = updatedPlaylist;
          main.playlists[newPlaylistUri] = updatedPlaylist;
        } else {
          main.playlists.splice(i, 1);
        }
        delete main.playlists[oldPlaylistId];
        delete main.playlists[oldPlaylistUri];
      }
    }
    this.updateOrDeleteCloneMedia(clone, isUpdate);
  }
  updateOrDeleteCloneMedia(clone, isUpdate) {
    const main = this.main;
    const id = clone.ID;
    ["AUDIO", "SUBTITLES", "CLOSED-CAPTIONS"].forEach((mediaType) => {
      if (!main.mediaGroups[mediaType] || !main.mediaGroups[mediaType][id]) {
        return;
      }
      for (const groupKey in main.mediaGroups[mediaType]) {
        if (groupKey === id) {
          for (const labelKey in main.mediaGroups[mediaType][groupKey]) {
            const oldMedia = main.mediaGroups[mediaType][groupKey][labelKey];
            oldMedia.playlists.forEach((p, i) => {
              const oldMediaPlaylist = main.playlists[p.id];
              const oldPlaylistId = oldMediaPlaylist.id;
              const oldPlaylistUri = oldMediaPlaylist.resolvedUri;
              delete main.playlists[oldPlaylistId];
              delete main.playlists[oldPlaylistUri];
            });
          }
          delete main.mediaGroups[mediaType][groupKey];
        }
      }
    });
    if (isUpdate) {
      this.createClonedMediaGroups_(clone);
    }
  }
  addClonePathway(clone, basePlaylist = {}) {
    const main = this.main;
    const index = main.playlists.length;
    const uri = this.createCloneURI_(basePlaylist.resolvedUri, clone);
    const playlistId = createPlaylistID(clone.ID, uri);
    const attributes = this.createCloneAttributes_(clone.ID, basePlaylist.attributes);
    const playlist = this.createClonePlaylist_(basePlaylist, playlistId, clone, attributes);
    main.playlists[index] = playlist;
    main.playlists[playlistId] = playlist;
    main.playlists[uri] = playlist;
    this.createClonedMediaGroups_(clone);
  }
  createClonedMediaGroups_(clone) {
    const id = clone.ID;
    const baseID = clone["BASE-ID"];
    const main = this.main;
    ["AUDIO", "SUBTITLES", "CLOSED-CAPTIONS"].forEach((mediaType) => {
      if (!main.mediaGroups[mediaType] || main.mediaGroups[mediaType][id]) {
        return;
      }
      for (const groupKey in main.mediaGroups[mediaType]) {
        if (groupKey === baseID) {
          main.mediaGroups[mediaType][id] = {};
        } else {
          continue;
        }
        for (const labelKey in main.mediaGroups[mediaType][groupKey]) {
          const oldMedia = main.mediaGroups[mediaType][groupKey][labelKey];
          main.mediaGroups[mediaType][id][labelKey] = _extends({}, oldMedia);
          const newMedia = main.mediaGroups[mediaType][id][labelKey];
          const newUri = this.createCloneURI_(oldMedia.resolvedUri, clone);
          newMedia.resolvedUri = newUri;
          newMedia.uri = newUri;
          newMedia.playlists = [];
          oldMedia.playlists.forEach((p, i) => {
            const oldMediaPlaylist = main.playlists[p.id];
            const group = groupID(mediaType, id, labelKey);
            const newPlaylistID = createPlaylistID(id, group);
            if (oldMediaPlaylist && !main.playlists[newPlaylistID]) {
              const newMediaPlaylist = this.createClonePlaylist_(oldMediaPlaylist, newPlaylistID, clone);
              const newPlaylistUri = newMediaPlaylist.resolvedUri;
              main.playlists[newPlaylistID] = newMediaPlaylist;
              main.playlists[newPlaylistUri] = newMediaPlaylist;
            }
            newMedia.playlists[i] = this.createClonePlaylist_(p, newPlaylistID, clone);
          });
        }
      }
    });
  }
  createClonePlaylist_(basePlaylist, id, clone, attributes) {
    const uri = this.createCloneURI_(basePlaylist.resolvedUri, clone);
    const newProps = {
      resolvedUri: uri,
      uri,
      id
    };
    if (basePlaylist.segments) {
      newProps.segments = [];
    }
    if (attributes) {
      newProps.attributes = attributes;
    }
    return merge(basePlaylist, newProps);
  }
  createCloneURI_(baseURI, clone) {
    const uri = new URL(baseURI);
    uri.hostname = clone["URI-REPLACEMENT"].HOST;
    const params = clone["URI-REPLACEMENT"].PARAMS;
    for (const key of Object.keys(params)) {
      uri.searchParams.set(key, params[key]);
    }
    return uri.href;
  }
  createCloneAttributes_(id, oldAttributes) {
    const attributes = {
      ["PATHWAY-ID"]: id
    };
    ["AUDIO", "SUBTITLES", "CLOSED-CAPTIONS"].forEach((mediaType) => {
      if (oldAttributes[mediaType]) {
        attributes[mediaType] = id;
      }
    });
    return attributes;
  }
  getKeyIdSet(playlist) {
    const keyIds = /* @__PURE__ */ new Set();
    if (!playlist || !playlist.contentProtection) {
      return keyIds;
    }
    for (const keysystem in playlist.contentProtection) {
      if (playlist.contentProtection[keysystem] && playlist.contentProtection[keysystem].attributes && playlist.contentProtection[keysystem].attributes.keyId) {
        const keyId = playlist.contentProtection[keysystem].attributes.keyId;
        keyIds.add(keyId.toLowerCase());
      }
    }
    return keyIds;
  }
}
const callbackWrapper = function(request, error, response, callback) {
  const reqResponse = request.responseType === "arraybuffer" ? request.response : request.responseText;
  if (!error && reqResponse) {
    request.responseTime = Date.now();
    request.roundTripTime = request.responseTime - request.requestTime;
    request.bytesReceived = reqResponse.byteLength || reqResponse.length;
    if (!request.bandwidth) {
      request.bandwidth = Math.floor(request.bytesReceived / request.roundTripTime * 8 * 1e3);
    }
  }
  if (response.headers) {
    request.responseHeaders = response.headers;
  }
  if (error && error.code === "ETIMEDOUT") {
    request.timedout = true;
  }
  if (!error && !request.aborted && response.statusCode !== 200 && response.statusCode !== 206 && response.statusCode !== 0) {
    error = new Error("XHR Failed with a response of: " + (request && (reqResponse || request.responseText)));
  }
  callback(error, request);
};
const callAllRequestHooks = (requestSet, options) => {
  if (!requestSet || !requestSet.size) {
    return;
  }
  let newOptions = options;
  requestSet.forEach((requestCallback) => {
    newOptions = requestCallback(newOptions);
  });
  return newOptions;
};
const callAllResponseHooks = (responseSet, request, error, response) => {
  if (!responseSet || !responseSet.size) {
    return;
  }
  responseSet.forEach((responseCallback) => {
    responseCallback(request, error, response);
  });
};
const xhrFactory = function() {
  const xhr = function XhrFunction(options, callback) {
    options = merge({
      timeout: 45e3
    }, options);
    const beforeRequest = XhrFunction.beforeRequest || videojs.Vhs.xhr.beforeRequest;
    const _requestCallbackSet = XhrFunction._requestCallbackSet || videojs.Vhs.xhr._requestCallbackSet || /* @__PURE__ */ new Set();
    const _responseCallbackSet = XhrFunction._responseCallbackSet || videojs.Vhs.xhr._responseCallbackSet;
    if (beforeRequest && typeof beforeRequest === "function") {
      videojs.log.warn("beforeRequest is deprecated, use onRequest instead.");
      _requestCallbackSet.add(beforeRequest);
    }
    const xhrMethod = videojs.Vhs.xhr.original === true ? videojs.xhr : videojs.Vhs.xhr;
    const beforeRequestOptions = callAllRequestHooks(_requestCallbackSet, options);
    _requestCallbackSet.delete(beforeRequest);
    const request = xhrMethod(beforeRequestOptions || options, function(error, response) {
      callAllResponseHooks(_responseCallbackSet, request, error, response);
      return callbackWrapper(request, error, response, callback);
    });
    const originalAbort = request.abort;
    request.abort = function() {
      request.aborted = true;
      return originalAbort.apply(request, arguments);
    };
    request.uri = options.uri;
    request.requestType = options.requestType;
    request.requestTime = Date.now();
    return request;
  };
  xhr.original = true;
  return xhr;
};
const byterangeStr = function(byterange) {
  let byterangeEnd;
  const byterangeStart = byterange.offset;
  if (typeof byterange.offset === "bigint" || typeof byterange.length === "bigint") {
    byterangeEnd = window_1.BigInt(byterange.offset) + window_1.BigInt(byterange.length) - window_1.BigInt(1);
  } else {
    byterangeEnd = byterange.offset + byterange.length - 1;
  }
  return "bytes=" + byterangeStart + "-" + byterangeEnd;
};
const segmentXhrHeaders = function(segment) {
  const headers = {};
  if (segment.byterange) {
    headers.Range = byterangeStr(segment.byterange);
  }
  return headers;
};
const textRange = function(range, i) {
  return range.start(i) + "-" + range.end(i);
};
const formatHexString = function(e, i) {
  const value = e.toString(16);
  return "00".substring(0, 2 - value.length) + value + (i % 2 ? " " : "");
};
const formatAsciiString = function(e) {
  if (e >= 32 && e < 126) {
    return String.fromCharCode(e);
  }
  return ".";
};
const createTransferableMessage = function(message) {
  const transferable = {};
  Object.keys(message).forEach((key) => {
    const value = message[key];
    if (isArrayBufferView(value)) {
      transferable[key] = {
        bytes: value.buffer,
        byteOffset: value.byteOffset,
        byteLength: value.byteLength
      };
    } else {
      transferable[key] = value;
    }
  });
  return transferable;
};
const initSegmentId = function(initSegment) {
  const byterange = initSegment.byterange || {
    length: Infinity,
    offset: 0
  };
  return [byterange.length, byterange.offset, initSegment.resolvedUri].join(",");
};
const segmentKeyId = function(key) {
  return key.resolvedUri;
};
const hexDump = (data) => {
  const bytes = Array.prototype.slice.call(data);
  const step = 16;
  let result = "";
  let hex;
  let ascii;
  for (let j = 0; j < bytes.length / step; j++) {
    hex = bytes.slice(j * step, j * step + step).map(formatHexString).join("");
    ascii = bytes.slice(j * step, j * step + step).map(formatAsciiString).join("");
    result += hex + " " + ascii + "\n";
  }
  return result;
};
const tagDump = ({
  bytes
}) => hexDump(bytes);
const textRanges = (ranges) => {
  let result = "";
  let i;
  for (i = 0; i < ranges.length; i++) {
    result += textRange(ranges, i) + " ";
  }
  return result;
};
var utils = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  createTransferableMessage,
  initSegmentId,
  segmentKeyId,
  hexDump,
  tagDump,
  textRanges
});
const SEGMENT_END_FUDGE_PERCENT = 0.25;
const playerTimeToProgramTime = (playerTime, segment) => {
  if (!segment.dateTimeObject) {
    return null;
  }
  const transmuxerPrependedSeconds = segment.videoTimingInfo.transmuxerPrependedSeconds;
  const transmuxedStart = segment.videoTimingInfo.transmuxedPresentationStart;
  const startOfSegment = transmuxedStart + transmuxerPrependedSeconds;
  const offsetFromSegmentStart = playerTime - startOfSegment;
  return new Date(segment.dateTimeObject.getTime() + offsetFromSegmentStart * 1e3);
};
const originalSegmentVideoDuration = (videoTimingInfo) => {
  return videoTimingInfo.transmuxedPresentationEnd - videoTimingInfo.transmuxedPresentationStart - videoTimingInfo.transmuxerPrependedSeconds;
};
const findSegmentForProgramTime = (programTime, playlist) => {
  let dateTimeObject;
  try {
    dateTimeObject = new Date(programTime);
  } catch (e) {
    return null;
  }
  if (!playlist || !playlist.segments || playlist.segments.length === 0) {
    return null;
  }
  let segment = playlist.segments[0];
  if (dateTimeObject < new Date(segment.dateTimeObject)) {
    return null;
  }
  for (let i = 0; i < playlist.segments.length - 1; i++) {
    segment = playlist.segments[i];
    const nextSegmentStart = new Date(playlist.segments[i + 1].dateTimeObject);
    if (dateTimeObject < nextSegmentStart) {
      break;
    }
  }
  const lastSegment = playlist.segments[playlist.segments.length - 1];
  const lastSegmentStart = lastSegment.dateTimeObject;
  const lastSegmentDuration = lastSegment.videoTimingInfo ? originalSegmentVideoDuration(lastSegment.videoTimingInfo) : lastSegment.duration + lastSegment.duration * SEGMENT_END_FUDGE_PERCENT;
  const lastSegmentEnd = new Date(lastSegmentStart.getTime() + lastSegmentDuration * 1e3);
  if (dateTimeObject > lastSegmentEnd) {
    return null;
  }
  if (dateTimeObject > new Date(lastSegmentStart)) {
    segment = lastSegment;
  }
  return {
    segment,
    estimatedStart: segment.videoTimingInfo ? segment.videoTimingInfo.transmuxedPresentationStart : Playlist.duration(playlist, playlist.mediaSequence + playlist.segments.indexOf(segment)),
    type: segment.videoTimingInfo ? "accurate" : "estimate"
  };
};
const findSegmentForPlayerTime = (time, playlist) => {
  if (!playlist || !playlist.segments || playlist.segments.length === 0) {
    return null;
  }
  let segmentEnd = 0;
  let segment;
  for (let i = 0; i < playlist.segments.length; i++) {
    segment = playlist.segments[i];
    segmentEnd = segment.videoTimingInfo ? segment.videoTimingInfo.transmuxedPresentationEnd : segmentEnd + segment.duration;
    if (time <= segmentEnd) {
      break;
    }
  }
  const lastSegment = playlist.segments[playlist.segments.length - 1];
  if (lastSegment.videoTimingInfo && lastSegment.videoTimingInfo.transmuxedPresentationEnd < time) {
    return null;
  }
  if (time > segmentEnd) {
    if (time > segmentEnd + lastSegment.duration * SEGMENT_END_FUDGE_PERCENT) {
      return null;
    }
    segment = lastSegment;
  }
  return {
    segment,
    estimatedStart: segment.videoTimingInfo ? segment.videoTimingInfo.transmuxedPresentationStart : segmentEnd - segment.duration,
    type: segment.videoTimingInfo ? "accurate" : "estimate"
  };
};
const getOffsetFromTimestamp = (comparisonTimeStamp, programTime) => {
  let segmentDateTime;
  let programDateTime;
  try {
    segmentDateTime = new Date(comparisonTimeStamp);
    programDateTime = new Date(programTime);
  } catch (e) {
  }
  const segmentTimeEpoch = segmentDateTime.getTime();
  const programTimeEpoch = programDateTime.getTime();
  return (programTimeEpoch - segmentTimeEpoch) / 1e3;
};
const verifyProgramDateTimeTags = (playlist) => {
  if (!playlist.segments || playlist.segments.length === 0) {
    return false;
  }
  for (let i = 0; i < playlist.segments.length; i++) {
    const segment = playlist.segments[i];
    if (!segment.dateTimeObject) {
      return false;
    }
  }
  return true;
};
const getProgramTime = ({
  playlist,
  time = void 0,
  callback
}) => {
  if (!callback) {
    throw new Error("getProgramTime: callback must be provided");
  }
  if (!playlist || time === void 0) {
    return callback({
      message: "getProgramTime: playlist and time must be provided"
    });
  }
  const matchedSegment = findSegmentForPlayerTime(time, playlist);
  if (!matchedSegment) {
    return callback({
      message: "valid programTime was not found"
    });
  }
  if (matchedSegment.type === "estimate") {
    return callback({
      message: "Accurate programTime could not be determined. Please seek to e.seekTime and try again",
      seekTime: matchedSegment.estimatedStart
    });
  }
  const programTimeObject = {
    mediaSeconds: time
  };
  const programTime = playerTimeToProgramTime(time, matchedSegment.segment);
  if (programTime) {
    programTimeObject.programDateTime = programTime.toISOString();
  }
  return callback(null, programTimeObject);
};
const seekToProgramTime = ({
  programTime,
  playlist,
  retryCount = 2,
  seekTo,
  pauseAfterSeek = true,
  tech,
  callback
}) => {
  if (!callback) {
    throw new Error("seekToProgramTime: callback must be provided");
  }
  if (typeof programTime === "undefined" || !playlist || !seekTo) {
    return callback({
      message: "seekToProgramTime: programTime, seekTo and playlist must be provided"
    });
  }
  if (!playlist.endList && !tech.hasStarted_) {
    return callback({
      message: "player must be playing a live stream to start buffering"
    });
  }
  if (!verifyProgramDateTimeTags(playlist)) {
    return callback({
      message: "programDateTime tags must be provided in the manifest " + playlist.resolvedUri
    });
  }
  const matchedSegment = findSegmentForProgramTime(programTime, playlist);
  if (!matchedSegment) {
    return callback({
      message: `${programTime} was not found in the stream`
    });
  }
  const segment = matchedSegment.segment;
  const mediaOffset = getOffsetFromTimestamp(segment.dateTimeObject, programTime);
  if (matchedSegment.type === "estimate") {
    if (retryCount === 0) {
      return callback({
        message: `${programTime} is not buffered yet. Try again`
      });
    }
    seekTo(matchedSegment.estimatedStart + mediaOffset);
    tech.one("seeked", () => {
      seekToProgramTime({
        programTime,
        playlist,
        retryCount: retryCount - 1,
        seekTo,
        pauseAfterSeek,
        tech,
        callback
      });
    });
    return;
  }
  const seekToTime = segment.start + mediaOffset;
  const seekedCallback = () => {
    return callback(null, tech.currentTime());
  };
  tech.one("seeked", seekedCallback);
  if (pauseAfterSeek) {
    tech.pause();
  }
  seekTo(seekToTime);
};
const callbackOnCompleted = (request, cb) => {
  if (request.readyState === 4) {
    return cb();
  }
  return;
};
const containerRequest = (uri, xhr, cb, requestType) => {
  let bytes = [];
  let id3Offset;
  let finished = false;
  const endRequestAndCallback = function(err, req, type, _bytes) {
    req.abort();
    finished = true;
    return cb(err, req, type, _bytes);
  };
  const progressListener = function(error, request2) {
    if (finished) {
      return;
    }
    if (error) {
      error.metadata = getStreamingNetworkErrorMetadata({
        requestType,
        request: request2,
        error
      });
      return endRequestAndCallback(error, request2, "", bytes);
    }
    const newPart = request2.responseText.substring(bytes && bytes.byteLength || 0, request2.responseText.length);
    bytes = concatTypedArrays(bytes, stringToBytes(newPart, true));
    id3Offset = id3Offset || getId3Offset(bytes);
    if (bytes.length < 10 || id3Offset && bytes.length < id3Offset + 2) {
      return callbackOnCompleted(request2, () => endRequestAndCallback(error, request2, "", bytes));
    }
    const type = detectContainerForBytes(bytes);
    if (type === "ts" && bytes.length < 188) {
      return callbackOnCompleted(request2, () => endRequestAndCallback(error, request2, "", bytes));
    }
    if (!type && bytes.length < 376) {
      return callbackOnCompleted(request2, () => endRequestAndCallback(error, request2, "", bytes));
    }
    return endRequestAndCallback(null, request2, type, bytes);
  };
  const options = {
    uri,
    beforeSend(request2) {
      request2.overrideMimeType("text/plain; charset=x-user-defined");
      request2.addEventListener("progress", function({
        total,
        loaded
      }) {
        return callbackWrapper(request2, null, {
          statusCode: request2.status
        }, progressListener);
      });
    }
  };
  const request = xhr(options, function(error, response) {
    return callbackWrapper(request, error, response, progressListener);
  });
  return request;
};
const {
  EventTarget
} = videojs;
const dashPlaylistUnchanged = function(a, b) {
  if (!isPlaylistUnchanged(a, b)) {
    return false;
  }
  if (a.sidx && b.sidx && (a.sidx.offset !== b.sidx.offset || a.sidx.length !== b.sidx.length)) {
    return false;
  } else if (!a.sidx && b.sidx || a.sidx && !b.sidx) {
    return false;
  }
  if (a.segments && !b.segments || !a.segments && b.segments) {
    return false;
  }
  if (!a.segments && !b.segments) {
    return true;
  }
  for (let i = 0; i < a.segments.length; i++) {
    const aSegment = a.segments[i];
    const bSegment = b.segments[i];
    if (aSegment.uri !== bSegment.uri) {
      return false;
    }
    if (!aSegment.byterange && !bSegment.byterange) {
      continue;
    }
    const aByterange = aSegment.byterange;
    const bByterange = bSegment.byterange;
    if (aByterange && !bByterange || !aByterange && bByterange) {
      return false;
    }
    if (aByterange.offset !== bByterange.offset || aByterange.length !== bByterange.length) {
      return false;
    }
  }
  return true;
};
const dashGroupId = (type, group, label, playlist) => {
  const playlistId = playlist.attributes.NAME || label;
  return `placeholder-uri-${type}-${group}-${playlistId}`;
};
const parseMainXml = ({
  mainXml,
  srcUrl,
  clientOffset,
  sidxMapping,
  previousManifest
}) => {
  const manifest = parse(mainXml, {
    manifestUri: srcUrl,
    clientOffset,
    sidxMapping,
    previousManifest
  });
  addPropertiesToMain(manifest, srcUrl, dashGroupId);
  return manifest;
};
const removeOldMediaGroupLabels = (update, newMain) => {
  forEachMediaGroup(update, (properties, type, group, label) => {
    if (!newMain.mediaGroups[type][group] || !(label in newMain.mediaGroups[type][group])) {
      delete update.mediaGroups[type][group][label];
    }
  });
};
const updateMain = (oldMain, newMain, sidxMapping) => {
  let noChanges = true;
  let update = merge(oldMain, {
    duration: newMain.duration,
    minimumUpdatePeriod: newMain.minimumUpdatePeriod,
    timelineStarts: newMain.timelineStarts
  });
  for (let i = 0; i < newMain.playlists.length; i++) {
    const playlist = newMain.playlists[i];
    if (playlist.sidx) {
      const sidxKey = generateSidxKey(playlist.sidx);
      if (sidxMapping && sidxMapping[sidxKey] && sidxMapping[sidxKey].sidx) {
        addSidxSegmentsToPlaylist$1(playlist, sidxMapping[sidxKey].sidx, playlist.sidx.resolvedUri);
      }
    }
    const playlistUpdate = updateMain$1(update, playlist, dashPlaylistUnchanged);
    if (playlistUpdate) {
      update = playlistUpdate;
      noChanges = false;
    }
  }
  forEachMediaGroup(newMain, (properties, type, group, label) => {
    if (properties.playlists && properties.playlists.length) {
      const id = properties.playlists[0].id;
      const playlistUpdate = updateMain$1(update, properties.playlists[0], dashPlaylistUnchanged);
      if (playlistUpdate) {
        update = playlistUpdate;
        if (!(label in update.mediaGroups[type][group])) {
          update.mediaGroups[type][group][label] = properties;
        }
        update.mediaGroups[type][group][label].playlists[0] = update.playlists[id];
        noChanges = false;
      }
    }
  });
  removeOldMediaGroupLabels(update, newMain);
  if (newMain.minimumUpdatePeriod !== oldMain.minimumUpdatePeriod) {
    noChanges = false;
  }
  if (noChanges) {
    return null;
  }
  return update;
};
const equivalentSidx = (a, b) => {
  const neitherMap = Boolean(!a.map && !b.map);
  const equivalentMap = neitherMap || Boolean(a.map && b.map && a.map.byterange.offset === b.map.byterange.offset && a.map.byterange.length === b.map.byterange.length);
  return equivalentMap && a.uri === b.uri && a.byterange.offset === b.byterange.offset && a.byterange.length === b.byterange.length;
};
const compareSidxEntry = (playlists, oldSidxMapping) => {
  const newSidxMapping = {};
  for (const id in playlists) {
    const playlist = playlists[id];
    const currentSidxInfo = playlist.sidx;
    if (currentSidxInfo) {
      const key = generateSidxKey(currentSidxInfo);
      if (!oldSidxMapping[key]) {
        break;
      }
      const savedSidxInfo = oldSidxMapping[key].sidxInfo;
      if (equivalentSidx(savedSidxInfo, currentSidxInfo)) {
        newSidxMapping[key] = oldSidxMapping[key];
      }
    }
  }
  return newSidxMapping;
};
const filterChangedSidxMappings = (main, oldSidxMapping) => {
  const videoSidx = compareSidxEntry(main.playlists, oldSidxMapping);
  let mediaGroupSidx = videoSidx;
  forEachMediaGroup(main, (properties, mediaType, groupKey, labelKey) => {
    if (properties.playlists && properties.playlists.length) {
      const playlists = properties.playlists;
      mediaGroupSidx = merge(mediaGroupSidx, compareSidxEntry(playlists, oldSidxMapping));
    }
  });
  return mediaGroupSidx;
};
class DashPlaylistLoader extends EventTarget {
  constructor(srcUrlOrPlaylist, vhs, options = {}, mainPlaylistLoader) {
    super();
    this.isPaused_ = true;
    this.mainPlaylistLoader_ = mainPlaylistLoader || this;
    if (!mainPlaylistLoader) {
      this.isMain_ = true;
    }
    const {
      withCredentials = false
    } = options;
    this.vhs_ = vhs;
    this.withCredentials = withCredentials;
    this.addMetadataToTextTrack = options.addMetadataToTextTrack;
    if (!srcUrlOrPlaylist) {
      throw new Error("A non-empty playlist URL or object is required");
    }
    this.on("minimumUpdatePeriod", () => {
      this.refreshXml_();
    });
    this.on("mediaupdatetimeout", () => {
      this.refreshMedia_(this.media().id);
    });
    this.state = "HAVE_NOTHING";
    this.loadedPlaylists_ = {};
    this.logger_ = logger("DashPlaylistLoader");
    if (this.isMain_) {
      this.mainPlaylistLoader_.srcUrl = srcUrlOrPlaylist;
      this.mainPlaylistLoader_.sidxMapping_ = {};
    } else {
      this.childPlaylist_ = srcUrlOrPlaylist;
    }
  }
  get isPaused() {
    return this.isPaused_;
  }
  requestErrored_(err, request, startingState) {
    if (!this.request) {
      return true;
    }
    this.request = null;
    if (err) {
      this.error = typeof err === "object" && !(err instanceof Error) ? err : {
        status: request.status,
        message: "DASH request error at URL: " + request.uri,
        response: request.response,
        code: 2,
        metadata: err.metadata
      };
      if (startingState) {
        this.state = startingState;
      }
      this.trigger("error");
      return true;
    }
  }
  addSidxSegments_(playlist, startingState, cb) {
    const sidxKey = playlist.sidx && generateSidxKey(playlist.sidx);
    if (!playlist.sidx || !sidxKey || this.mainPlaylistLoader_.sidxMapping_[sidxKey]) {
      window_1.clearTimeout(this.mediaRequest_);
      this.mediaRequest_ = window_1.setTimeout(() => cb(false), 0);
      return;
    }
    const uri = resolveManifestRedirect(playlist.sidx.resolvedUri);
    const fin = (err, request) => {
      if (this.requestErrored_(err, request, startingState)) {
        return;
      }
      const sidxMapping = this.mainPlaylistLoader_.sidxMapping_;
      const {
        requestType
      } = request;
      let sidx;
      try {
        sidx = parseSidx_1(toUint8(request.response).subarray(8));
      } catch (e) {
        e.metadata = getStreamingNetworkErrorMetadata({
          requestType,
          request,
          parseFailure: true
        });
        this.requestErrored_(e, request, startingState);
        return;
      }
      sidxMapping[sidxKey] = {
        sidxInfo: playlist.sidx,
        sidx
      };
      addSidxSegmentsToPlaylist$1(playlist, sidx, playlist.sidx.resolvedUri);
      return cb(true);
    };
    const REQUEST_TYPE = "dash-sidx";
    this.request = containerRequest(uri, this.vhs_.xhr, (err, request, container, bytes) => {
      if (err) {
        return fin(err, request);
      }
      if (!container || container !== "mp4") {
        const sidxContainer = container || "unknown";
        return fin({
          status: request.status,
          message: `Unsupported ${sidxContainer} container type for sidx segment at URL: ${uri}`,
          response: "",
          playlist,
          internal: true,
          playlistExclusionDuration: Infinity,
          code: 2
        }, request);
      }
      const {
        offset,
        length
      } = playlist.sidx.byterange;
      if (bytes.length >= length + offset) {
        return fin(err, {
          response: bytes.subarray(offset, offset + length),
          status: request.status,
          uri: request.uri
        });
      }
      this.request = this.vhs_.xhr({
        uri,
        responseType: "arraybuffer",
        requestType: "dash-sidx",
        headers: segmentXhrHeaders({
          byterange: playlist.sidx.byterange
        })
      }, fin);
    }, REQUEST_TYPE);
  }
  dispose() {
    this.isPaused_ = true;
    this.trigger("dispose");
    this.stopRequest();
    this.loadedPlaylists_ = {};
    window_1.clearTimeout(this.minimumUpdatePeriodTimeout_);
    window_1.clearTimeout(this.mediaRequest_);
    window_1.clearTimeout(this.mediaUpdateTimeout);
    this.mediaUpdateTimeout = null;
    this.mediaRequest_ = null;
    this.minimumUpdatePeriodTimeout_ = null;
    if (this.mainPlaylistLoader_.createMupOnMedia_) {
      this.off("loadedmetadata", this.mainPlaylistLoader_.createMupOnMedia_);
      this.mainPlaylistLoader_.createMupOnMedia_ = null;
    }
    this.off();
  }
  hasPendingRequest() {
    return this.request || this.mediaRequest_;
  }
  stopRequest() {
    if (this.request) {
      const oldRequest = this.request;
      this.request = null;
      oldRequest.onreadystatechange = null;
      oldRequest.abort();
    }
  }
  media(playlist) {
    if (!playlist) {
      return this.media_;
    }
    if (this.state === "HAVE_NOTHING") {
      throw new Error("Cannot switch media playlist from " + this.state);
    }
    const startingState = this.state;
    if (typeof playlist === "string") {
      if (!this.mainPlaylistLoader_.main.playlists[playlist]) {
        throw new Error("Unknown playlist URI: " + playlist);
      }
      playlist = this.mainPlaylistLoader_.main.playlists[playlist];
    }
    const mediaChange = !this.media_ || playlist.id !== this.media_.id;
    if (mediaChange && this.loadedPlaylists_[playlist.id] && this.loadedPlaylists_[playlist.id].endList) {
      this.state = "HAVE_METADATA";
      this.media_ = playlist;
      if (mediaChange) {
        this.trigger("mediachanging");
        this.trigger("mediachange");
      }
      return;
    }
    if (!mediaChange) {
      return;
    }
    if (this.media_) {
      this.trigger("mediachanging");
    }
    this.addSidxSegments_(playlist, startingState, (sidxChanged) => {
      this.haveMetadata({
        startingState,
        playlist
      });
    });
  }
  haveMetadata({
    startingState,
    playlist
  }) {
    this.state = "HAVE_METADATA";
    this.loadedPlaylists_[playlist.id] = playlist;
    window_1.clearTimeout(this.mediaRequest_);
    this.mediaRequest_ = null;
    this.refreshMedia_(playlist.id);
    if (startingState === "HAVE_MAIN_MANIFEST") {
      this.trigger("loadedmetadata");
    } else {
      this.trigger("mediachange");
    }
  }
  pause() {
    this.isPaused_ = true;
    if (this.mainPlaylistLoader_.createMupOnMedia_) {
      this.off("loadedmetadata", this.mainPlaylistLoader_.createMupOnMedia_);
      this.mainPlaylistLoader_.createMupOnMedia_ = null;
    }
    this.stopRequest();
    window_1.clearTimeout(this.mediaUpdateTimeout);
    this.mediaUpdateTimeout = null;
    if (this.isMain_) {
      window_1.clearTimeout(this.mainPlaylistLoader_.minimumUpdatePeriodTimeout_);
      this.mainPlaylistLoader_.minimumUpdatePeriodTimeout_ = null;
    }
    if (this.state === "HAVE_NOTHING") {
      this.started = false;
    }
  }
  load(isFinalRendition) {
    this.isPaused_ = false;
    window_1.clearTimeout(this.mediaUpdateTimeout);
    this.mediaUpdateTimeout = null;
    const media = this.media();
    if (isFinalRendition) {
      const delay = media ? media.targetDuration / 2 * 1e3 : 5 * 1e3;
      this.mediaUpdateTimeout = window_1.setTimeout(() => this.load(), delay);
      return;
    }
    if (!this.started) {
      this.start();
      return;
    }
    if (media && !media.endList) {
      if (this.isMain_ && !this.minimumUpdatePeriodTimeout_) {
        this.trigger("minimumUpdatePeriod");
        this.updateMinimumUpdatePeriodTimeout_();
      }
      this.trigger("mediaupdatetimeout");
    } else {
      this.trigger("loadedplaylist");
    }
  }
  start() {
    this.started = true;
    if (!this.isMain_) {
      window_1.clearTimeout(this.mediaRequest_);
      this.mediaRequest_ = window_1.setTimeout(() => this.haveMain_(), 0);
      return;
    }
    this.requestMain_((req, mainChanged) => {
      this.haveMain_();
      if (!this.hasPendingRequest() && !this.media_) {
        this.media(this.mainPlaylistLoader_.main.playlists[0]);
      }
    });
  }
  requestMain_(cb) {
    const metadata = {
      manifestInfo: {
        uri: this.mainPlaylistLoader_.srcUrl
      }
    };
    this.trigger({
      type: "manifestrequeststart",
      metadata
    });
    this.request = this.vhs_.xhr({
      uri: this.mainPlaylistLoader_.srcUrl,
      withCredentials: this.withCredentials,
      requestType: "dash-manifest"
    }, (error, req) => {
      if (error) {
        const {
          requestType
        } = req;
        error.metadata = getStreamingNetworkErrorMetadata({
          requestType,
          request: req,
          error
        });
      }
      if (this.requestErrored_(error, req)) {
        if (this.state === "HAVE_NOTHING") {
          this.started = false;
        }
        return;
      }
      this.trigger({
        type: "manifestrequestcomplete",
        metadata
      });
      const mainChanged = req.responseText !== this.mainPlaylistLoader_.mainXml_;
      this.mainPlaylistLoader_.mainXml_ = req.responseText;
      if (req.responseHeaders && req.responseHeaders.date) {
        this.mainLoaded_ = Date.parse(req.responseHeaders.date);
      } else {
        this.mainLoaded_ = Date.now();
      }
      this.mainPlaylistLoader_.srcUrl = resolveManifestRedirect(this.mainPlaylistLoader_.srcUrl, req);
      if (mainChanged) {
        this.handleMain_();
        this.syncClientServerClock_(() => {
          return cb(req, mainChanged);
        });
        return;
      }
      return cb(req, mainChanged);
    });
  }
  syncClientServerClock_(done) {
    const utcTiming = parseUTCTiming(this.mainPlaylistLoader_.mainXml_);
    if (utcTiming === null) {
      this.mainPlaylistLoader_.clientOffset_ = this.mainLoaded_ - Date.now();
      return done();
    }
    if (utcTiming.method === "DIRECT") {
      this.mainPlaylistLoader_.clientOffset_ = utcTiming.value - Date.now();
      return done();
    }
    this.request = this.vhs_.xhr({
      uri: resolveUrl(this.mainPlaylistLoader_.srcUrl, utcTiming.value),
      method: utcTiming.method,
      withCredentials: this.withCredentials,
      requestType: "dash-clock-sync"
    }, (error, req) => {
      if (!this.request) {
        return;
      }
      if (error) {
        const {
          requestType
        } = req;
        this.error.metadata = getStreamingNetworkErrorMetadata({
          requestType,
          request: req,
          error
        });
        this.mainPlaylistLoader_.clientOffset_ = this.mainLoaded_ - Date.now();
        return done();
      }
      let serverTime;
      if (utcTiming.method === "HEAD") {
        if (!req.responseHeaders || !req.responseHeaders.date) {
          serverTime = this.mainLoaded_;
        } else {
          serverTime = Date.parse(req.responseHeaders.date);
        }
      } else {
        serverTime = Date.parse(req.responseText);
      }
      this.mainPlaylistLoader_.clientOffset_ = serverTime - Date.now();
      done();
    });
  }
  haveMain_() {
    this.state = "HAVE_MAIN_MANIFEST";
    if (this.isMain_) {
      this.trigger("loadedplaylist");
    } else if (!this.media_) {
      this.media(this.childPlaylist_);
    }
  }
  handleMain_() {
    window_1.clearTimeout(this.mediaRequest_);
    this.mediaRequest_ = null;
    const oldMain = this.mainPlaylistLoader_.main;
    const metadata = {
      manifestInfo: {
        uri: this.mainPlaylistLoader_.srcUrl
      }
    };
    this.trigger({
      type: "manifestparsestart",
      metadata
    });
    let newMain;
    try {
      newMain = parseMainXml({
        mainXml: this.mainPlaylistLoader_.mainXml_,
        srcUrl: this.mainPlaylistLoader_.srcUrl,
        clientOffset: this.mainPlaylistLoader_.clientOffset_,
        sidxMapping: this.mainPlaylistLoader_.sidxMapping_,
        previousManifest: oldMain
      });
    } catch (error) {
      this.error = error;
      this.error.metadata = {
        errorType: videojs.Error.StreamingDashManifestParserError,
        error
      };
      this.trigger("error");
    }
    if (oldMain) {
      newMain = updateMain(oldMain, newMain, this.mainPlaylistLoader_.sidxMapping_);
    }
    this.mainPlaylistLoader_.main = newMain ? newMain : oldMain;
    const location = this.mainPlaylistLoader_.main.locations && this.mainPlaylistLoader_.main.locations[0];
    if (location && location !== this.mainPlaylistLoader_.srcUrl) {
      this.mainPlaylistLoader_.srcUrl = location;
    }
    if (!oldMain || newMain && newMain.minimumUpdatePeriod !== oldMain.minimumUpdatePeriod) {
      this.updateMinimumUpdatePeriodTimeout_();
    }
    this.addEventStreamToMetadataTrack_(newMain);
    if (newMain) {
      const {
        duration: duration2,
        endList
      } = newMain;
      const renditions = [];
      newMain.playlists.forEach((playlist) => {
        renditions.push({
          id: playlist.id,
          bandwidth: playlist.attributes.BANDWIDTH,
          resolution: playlist.attributes.RESOLUTION,
          codecs: playlist.attributes.CODECS
        });
      });
      const parsedManifest = {
        duration: duration2,
        isLive: !endList,
        renditions
      };
      metadata.parsedManifest = parsedManifest;
      this.trigger({
        type: "manifestparsecomplete",
        metadata
      });
    }
    return Boolean(newMain);
  }
  updateMinimumUpdatePeriodTimeout_() {
    const mpl = this.mainPlaylistLoader_;
    if (mpl.createMupOnMedia_) {
      mpl.off("loadedmetadata", mpl.createMupOnMedia_);
      mpl.createMupOnMedia_ = null;
    }
    if (mpl.minimumUpdatePeriodTimeout_) {
      window_1.clearTimeout(mpl.minimumUpdatePeriodTimeout_);
      mpl.minimumUpdatePeriodTimeout_ = null;
    }
    let mup = mpl.main && mpl.main.minimumUpdatePeriod;
    if (mup === 0) {
      if (mpl.media()) {
        mup = mpl.media().targetDuration * 1e3;
      } else {
        mpl.createMupOnMedia_ = mpl.updateMinimumUpdatePeriodTimeout_;
        mpl.one("loadedmetadata", mpl.createMupOnMedia_);
      }
    }
    if (typeof mup !== "number" || mup <= 0) {
      if (mup < 0) {
        this.logger_(`found invalid minimumUpdatePeriod of ${mup}, not setting a timeout`);
      }
      return;
    }
    this.createMUPTimeout_(mup);
  }
  createMUPTimeout_(mup) {
    const mpl = this.mainPlaylistLoader_;
    mpl.minimumUpdatePeriodTimeout_ = window_1.setTimeout(() => {
      mpl.minimumUpdatePeriodTimeout_ = null;
      mpl.trigger("minimumUpdatePeriod");
      mpl.createMUPTimeout_(mup);
    }, mup);
  }
  refreshXml_() {
    this.requestMain_((req, mainChanged) => {
      if (!mainChanged) {
        return;
      }
      if (this.media_) {
        this.media_ = this.mainPlaylistLoader_.main.playlists[this.media_.id];
      }
      this.mainPlaylistLoader_.sidxMapping_ = filterChangedSidxMappings(this.mainPlaylistLoader_.main, this.mainPlaylistLoader_.sidxMapping_);
      this.addSidxSegments_(this.media(), this.state, (sidxChanged) => {
        this.refreshMedia_(this.media().id);
      });
    });
  }
  refreshMedia_(mediaID) {
    if (!mediaID) {
      throw new Error("refreshMedia_ must take a media id");
    }
    if (this.media_ && this.isMain_) {
      this.handleMain_();
    }
    const playlists = this.mainPlaylistLoader_.main.playlists;
    const mediaChanged = !this.media_ || this.media_ !== playlists[mediaID];
    if (mediaChanged) {
      this.media_ = playlists[mediaID];
    } else {
      this.trigger("playlistunchanged");
    }
    if (!this.mediaUpdateTimeout) {
      const createMediaUpdateTimeout = () => {
        if (this.media().endList) {
          return;
        }
        this.mediaUpdateTimeout = window_1.setTimeout(() => {
          this.trigger("mediaupdatetimeout");
          createMediaUpdateTimeout();
        }, refreshDelay(this.media(), Boolean(mediaChanged)));
      };
      createMediaUpdateTimeout();
    }
    this.trigger("loadedplaylist");
  }
  addEventStreamToMetadataTrack_(newMain) {
    if (newMain && this.mainPlaylistLoader_.main.eventStream) {
      const metadataArray = this.mainPlaylistLoader_.main.eventStream.map((eventStreamNode) => {
        return {
          cueTime: eventStreamNode.start,
          frames: [{
            data: eventStreamNode.messageData
          }]
        };
      });
      this.addMetadataToTextTrack("EventStream", metadataArray, this.mainPlaylistLoader_.main.duration);
    }
  }
  getKeyIdSet(playlist) {
    if (playlist.contentProtection) {
      const keyIds = /* @__PURE__ */ new Set();
      for (const keysystem in playlist.contentProtection) {
        const defaultKID = playlist.contentProtection[keysystem].attributes["cenc:default_KID"];
        if (defaultKID) {
          keyIds.add(defaultKID.replace(/-/g, "").toLowerCase());
        }
      }
      return keyIds;
    }
  }
}
var Config = {
  GOAL_BUFFER_LENGTH: 30,
  MAX_GOAL_BUFFER_LENGTH: 60,
  BACK_BUFFER_LENGTH: 30,
  GOAL_BUFFER_LENGTH_RATE: 1,
  INITIAL_BANDWIDTH: 4194304,
  BANDWIDTH_VARIANCE: 1.2,
  BUFFER_LOW_WATER_LINE: 0,
  MAX_BUFFER_LOW_WATER_LINE: 30,
  EXPERIMENTAL_MAX_BUFFER_LOW_WATER_LINE: 16,
  BUFFER_LOW_WATER_LINE_RATE: 1,
  BUFFER_HIGH_WATER_LINE: 30
};
const stringToArrayBuffer = (string) => {
  const view = new Uint8Array(new ArrayBuffer(string.length));
  for (let i = 0; i < string.length; i++) {
    view[i] = string.charCodeAt(i);
  }
  return view.buffer;
};
const browserWorkerPolyFill = function(workerObj) {
  workerObj.on = workerObj.addEventListener;
  workerObj.off = workerObj.removeEventListener;
  return workerObj;
};
const createObjectURL = function(str) {
  try {
    return URL.createObjectURL(new Blob([str], {
      type: "application/javascript"
    }));
  } catch (e) {
    const blob = new BlobBuilder();
    blob.append(str);
    return URL.createObjectURL(blob.getBlob());
  }
};
const factory = function(code) {
  return function() {
    const objectUrl = createObjectURL(code);
    const worker = browserWorkerPolyFill(new Worker(objectUrl));
    worker.objURL = objectUrl;
    const terminate = worker.terminate;
    worker.on = worker.addEventListener;
    worker.off = worker.removeEventListener;
    worker.terminate = function() {
      URL.revokeObjectURL(objectUrl);
      return terminate.call(this);
    };
    return worker;
  };
};
const transform = function(code) {
  return `var browserWorkerPolyFill = ${browserWorkerPolyFill.toString()};
browserWorkerPolyFill(self);
` + code;
};
const getWorkerString = function(fn) {
  return fn.toString().replace(/^function.+?{/, "").slice(0, -1);
};
const workerCode$1 = transform(getWorkerString(function() {
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  var Stream$8 = function() {
    this.init = function() {
      var listeners = {};
      this.on = function(type2, listener) {
        if (!listeners[type2]) {
          listeners[type2] = [];
        }
        listeners[type2] = listeners[type2].concat(listener);
      };
      this.off = function(type2, listener) {
        var index;
        if (!listeners[type2]) {
          return false;
        }
        index = listeners[type2].indexOf(listener);
        listeners[type2] = listeners[type2].slice();
        listeners[type2].splice(index, 1);
        return index > -1;
      };
      this.trigger = function(type2) {
        var callbacks, i, length, args;
        callbacks = listeners[type2];
        if (!callbacks) {
          return;
        }
        if (arguments.length === 2) {
          length = callbacks.length;
          for (i = 0; i < length; ++i) {
            callbacks[i].call(this, arguments[1]);
          }
        } else {
          args = [];
          i = arguments.length;
          for (i = 1; i < arguments.length; ++i) {
            args.push(arguments[i]);
          }
          length = callbacks.length;
          for (i = 0; i < length; ++i) {
            callbacks[i].apply(this, args);
          }
        }
      };
      this.dispose = function() {
        listeners = {};
      };
    };
  };
  Stream$8.prototype.pipe = function(destination) {
    this.on("data", function(data) {
      destination.push(data);
    });
    this.on("done", function(flushSource) {
      destination.flush(flushSource);
    });
    this.on("partialdone", function(flushSource) {
      destination.partialFlush(flushSource);
    });
    this.on("endedtimeline", function(flushSource) {
      destination.endTimeline(flushSource);
    });
    this.on("reset", function(flushSource) {
      destination.reset(flushSource);
    });
    return destination;
  };
  Stream$8.prototype.push = function(data) {
    this.trigger("data", data);
  };
  Stream$8.prototype.flush = function(flushSource) {
    this.trigger("done", flushSource);
  };
  Stream$8.prototype.partialFlush = function(flushSource) {
    this.trigger("partialdone", flushSource);
  };
  Stream$8.prototype.endTimeline = function(flushSource) {
    this.trigger("endedtimeline", flushSource);
  };
  Stream$8.prototype.reset = function(flushSource) {
    this.trigger("reset", flushSource);
  };
  var stream = Stream$8;
  var MAX_UINT32$1 = Math.pow(2, 32);
  var getUint64$5 = function(uint8) {
    var dv = new DataView(uint8.buffer, uint8.byteOffset, uint8.byteLength);
    var value;
    if (dv.getBigUint64) {
      value = dv.getBigUint64(0);
      if (value < Number.MAX_SAFE_INTEGER) {
        return Number(value);
      }
      return value;
    }
    return dv.getUint32(0) * MAX_UINT32$1 + dv.getUint32(4);
  };
  var numbers = {
    getUint64: getUint64$5,
    MAX_UINT32: MAX_UINT32$1
  };
  var MAX_UINT32 = numbers.MAX_UINT32;
  var box, dinf, esds, ftyp, mdat, mfhd, minf, moof, moov, mvex, mvhd, trak, tkhd, mdia, mdhd, hdlr, sdtp, stbl, stsd, traf, trex, trun$1, types, MAJOR_BRAND, MINOR_VERSION, AVC1_BRAND, VIDEO_HDLR, AUDIO_HDLR, HDLR_TYPES, VMHD, SMHD, DREF, STCO, STSC, STSZ, STTS;
  (function() {
    var i;
    types = {
      avc1: [],
      avcC: [],
      btrt: [],
      dinf: [],
      dref: [],
      esds: [],
      ftyp: [],
      hdlr: [],
      mdat: [],
      mdhd: [],
      mdia: [],
      mfhd: [],
      minf: [],
      moof: [],
      moov: [],
      mp4a: [],
      mvex: [],
      mvhd: [],
      pasp: [],
      sdtp: [],
      smhd: [],
      stbl: [],
      stco: [],
      stsc: [],
      stsd: [],
      stsz: [],
      stts: [],
      styp: [],
      tfdt: [],
      tfhd: [],
      traf: [],
      trak: [],
      trun: [],
      trex: [],
      tkhd: [],
      vmhd: []
    };
    if (typeof Uint8Array === "undefined") {
      return;
    }
    for (i in types) {
      if (types.hasOwnProperty(i)) {
        types[i] = [i.charCodeAt(0), i.charCodeAt(1), i.charCodeAt(2), i.charCodeAt(3)];
      }
    }
    MAJOR_BRAND = new Uint8Array(["i".charCodeAt(0), "s".charCodeAt(0), "o".charCodeAt(0), "m".charCodeAt(0)]);
    AVC1_BRAND = new Uint8Array(["a".charCodeAt(0), "v".charCodeAt(0), "c".charCodeAt(0), "1".charCodeAt(0)]);
    MINOR_VERSION = new Uint8Array([0, 0, 0, 1]);
    VIDEO_HDLR = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      118,
      105,
      100,
      101,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      86,
      105,
      100,
      101,
      111,
      72,
      97,
      110,
      100,
      108,
      101,
      114,
      0
    ]);
    AUDIO_HDLR = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      115,
      111,
      117,
      110,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      83,
      111,
      117,
      110,
      100,
      72,
      97,
      110,
      100,
      108,
      101,
      114,
      0
    ]);
    HDLR_TYPES = {
      video: VIDEO_HDLR,
      audio: AUDIO_HDLR
    };
    DREF = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      12,
      117,
      114,
      108,
      32,
      0,
      0,
      0,
      1
    ]);
    SMHD = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    ]);
    STCO = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    ]);
    STSC = STCO;
    STSZ = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    ]);
    STTS = STCO;
    VMHD = new Uint8Array([
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    ]);
  })();
  box = function(type2) {
    var payload = [], size = 0, i, result, view;
    for (i = 1; i < arguments.length; i++) {
      payload.push(arguments[i]);
    }
    i = payload.length;
    while (i--) {
      size += payload[i].byteLength;
    }
    result = new Uint8Array(size + 8);
    view = new DataView(result.buffer, result.byteOffset, result.byteLength);
    view.setUint32(0, result.byteLength);
    result.set(type2, 4);
    for (i = 0, size = 8; i < payload.length; i++) {
      result.set(payload[i], size);
      size += payload[i].byteLength;
    }
    return result;
  };
  dinf = function() {
    return box(types.dinf, box(types.dref, DREF));
  };
  esds = function(track) {
    return box(types.esds, new Uint8Array([
      0,
      0,
      0,
      0,
      3,
      25,
      0,
      0,
      0,
      4,
      17,
      64,
      21,
      0,
      6,
      0,
      0,
      0,
      218,
      192,
      0,
      0,
      218,
      192,
      5,
      2,
      track.audioobjecttype << 3 | track.samplingfrequencyindex >>> 1,
      track.samplingfrequencyindex << 7 | track.channelcount << 3,
      6,
      1,
      2
    ]));
  };
  ftyp = function() {
    return box(types.ftyp, MAJOR_BRAND, MINOR_VERSION, MAJOR_BRAND, AVC1_BRAND);
  };
  hdlr = function(type2) {
    return box(types.hdlr, HDLR_TYPES[type2]);
  };
  mdat = function(data) {
    return box(types.mdat, data);
  };
  mdhd = function(track) {
    var result = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      2,
      0,
      0,
      0,
      3,
      0,
      1,
      95,
      144,
      track.duration >>> 24 & 255,
      track.duration >>> 16 & 255,
      track.duration >>> 8 & 255,
      track.duration & 255,
      85,
      196,
      0,
      0
    ]);
    if (track.samplerate) {
      result[12] = track.samplerate >>> 24 & 255;
      result[13] = track.samplerate >>> 16 & 255;
      result[14] = track.samplerate >>> 8 & 255;
      result[15] = track.samplerate & 255;
    }
    return box(types.mdhd, result);
  };
  mdia = function(track) {
    return box(types.mdia, mdhd(track), hdlr(track.type), minf(track));
  };
  mfhd = function(sequenceNumber) {
    return box(types.mfhd, new Uint8Array([
      0,
      0,
      0,
      0,
      (sequenceNumber & 4278190080) >> 24,
      (sequenceNumber & 16711680) >> 16,
      (sequenceNumber & 65280) >> 8,
      sequenceNumber & 255
    ]));
  };
  minf = function(track) {
    return box(types.minf, track.type === "video" ? box(types.vmhd, VMHD) : box(types.smhd, SMHD), dinf(), stbl(track));
  };
  moof = function(sequenceNumber, tracks) {
    var trackFragments = [], i = tracks.length;
    while (i--) {
      trackFragments[i] = traf(tracks[i]);
    }
    return box.apply(null, [types.moof, mfhd(sequenceNumber)].concat(trackFragments));
  };
  moov = function(tracks) {
    var i = tracks.length, boxes = [];
    while (i--) {
      boxes[i] = trak(tracks[i]);
    }
    return box.apply(null, [types.moov, mvhd(4294967295)].concat(boxes).concat(mvex(tracks)));
  };
  mvex = function(tracks) {
    var i = tracks.length, boxes = [];
    while (i--) {
      boxes[i] = trex(tracks[i]);
    }
    return box.apply(null, [types.mvex].concat(boxes));
  };
  mvhd = function(duration2) {
    var bytes = new Uint8Array([
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      2,
      0,
      1,
      95,
      144,
      (duration2 & 4278190080) >> 24,
      (duration2 & 16711680) >> 16,
      (duration2 & 65280) >> 8,
      duration2 & 255,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      64,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      255,
      255,
      255,
      255
    ]);
    return box(types.mvhd, bytes);
  };
  sdtp = function(track) {
    var samples2 = track.samples || [], bytes = new Uint8Array(4 + samples2.length), flags, i;
    for (i = 0; i < samples2.length; i++) {
      flags = samples2[i].flags;
      bytes[i + 4] = flags.dependsOn << 4 | flags.isDependedOn << 2 | flags.hasRedundancy;
    }
    return box(types.sdtp, bytes);
  };
  stbl = function(track) {
    return box(types.stbl, stsd(track), box(types.stts, STTS), box(types.stsc, STSC), box(types.stsz, STSZ), box(types.stco, STCO));
  };
  (function() {
    var videoSample, audioSample;
    stsd = function(track) {
      return box(types.stsd, new Uint8Array([
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        1
      ]), track.type === "video" ? videoSample(track) : audioSample(track));
    };
    videoSample = function(track) {
      var sps = track.sps || [], pps = track.pps || [], sequenceParameterSets = [], pictureParameterSets = [], i, avc1Box;
      for (i = 0; i < sps.length; i++) {
        sequenceParameterSets.push((sps[i].byteLength & 65280) >>> 8);
        sequenceParameterSets.push(sps[i].byteLength & 255);
        sequenceParameterSets = sequenceParameterSets.concat(Array.prototype.slice.call(sps[i]));
      }
      for (i = 0; i < pps.length; i++) {
        pictureParameterSets.push((pps[i].byteLength & 65280) >>> 8);
        pictureParameterSets.push(pps[i].byteLength & 255);
        pictureParameterSets = pictureParameterSets.concat(Array.prototype.slice.call(pps[i]));
      }
      avc1Box = [types.avc1, new Uint8Array([
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        (track.width & 65280) >> 8,
        track.width & 255,
        (track.height & 65280) >> 8,
        track.height & 255,
        0,
        72,
        0,
        0,
        0,
        72,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        1,
        19,
        118,
        105,
        100,
        101,
        111,
        106,
        115,
        45,
        99,
        111,
        110,
        116,
        114,
        105,
        98,
        45,
        104,
        108,
        115,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        24,
        17,
        17
      ]), box(types.avcC, new Uint8Array([
        1,
        track.profileIdc,
        track.profileCompatibility,
        track.levelIdc,
        255
      ].concat(
        [sps.length],
        sequenceParameterSets,
        [pps.length],
        pictureParameterSets
      ))), box(types.btrt, new Uint8Array([
        0,
        28,
        156,
        128,
        0,
        45,
        198,
        192,
        0,
        45,
        198,
        192
      ]))];
      if (track.sarRatio) {
        var hSpacing = track.sarRatio[0], vSpacing = track.sarRatio[1];
        avc1Box.push(box(types.pasp, new Uint8Array([(hSpacing & 4278190080) >> 24, (hSpacing & 16711680) >> 16, (hSpacing & 65280) >> 8, hSpacing & 255, (vSpacing & 4278190080) >> 24, (vSpacing & 16711680) >> 16, (vSpacing & 65280) >> 8, vSpacing & 255])));
      }
      return box.apply(null, avc1Box);
    };
    audioSample = function(track) {
      return box(types.mp4a, new Uint8Array([
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        (track.channelcount & 65280) >> 8,
        track.channelcount & 255,
        (track.samplesize & 65280) >> 8,
        track.samplesize & 255,
        0,
        0,
        0,
        0,
        (track.samplerate & 65280) >> 8,
        track.samplerate & 255,
        0,
        0
      ]), esds(track));
    };
  })();
  tkhd = function(track) {
    var result = new Uint8Array([
      0,
      0,
      0,
      7,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      (track.id & 4278190080) >> 24,
      (track.id & 16711680) >> 16,
      (track.id & 65280) >> 8,
      track.id & 255,
      0,
      0,
      0,
      0,
      (track.duration & 4278190080) >> 24,
      (track.duration & 16711680) >> 16,
      (track.duration & 65280) >> 8,
      track.duration & 255,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      64,
      0,
      0,
      0,
      (track.width & 65280) >> 8,
      track.width & 255,
      0,
      0,
      (track.height & 65280) >> 8,
      track.height & 255,
      0,
      0
    ]);
    return box(types.tkhd, result);
  };
  traf = function(track) {
    var trackFragmentHeader, trackFragmentDecodeTime, trackFragmentRun, sampleDependencyTable, dataOffset, upperWordBaseMediaDecodeTime, lowerWordBaseMediaDecodeTime;
    trackFragmentHeader = box(types.tfhd, new Uint8Array([
      0,
      0,
      0,
      58,
      (track.id & 4278190080) >> 24,
      (track.id & 16711680) >> 16,
      (track.id & 65280) >> 8,
      track.id & 255,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    ]));
    upperWordBaseMediaDecodeTime = Math.floor(track.baseMediaDecodeTime / MAX_UINT32);
    lowerWordBaseMediaDecodeTime = Math.floor(track.baseMediaDecodeTime % MAX_UINT32);
    trackFragmentDecodeTime = box(types.tfdt, new Uint8Array([
      1,
      0,
      0,
      0,
      upperWordBaseMediaDecodeTime >>> 24 & 255,
      upperWordBaseMediaDecodeTime >>> 16 & 255,
      upperWordBaseMediaDecodeTime >>> 8 & 255,
      upperWordBaseMediaDecodeTime & 255,
      lowerWordBaseMediaDecodeTime >>> 24 & 255,
      lowerWordBaseMediaDecodeTime >>> 16 & 255,
      lowerWordBaseMediaDecodeTime >>> 8 & 255,
      lowerWordBaseMediaDecodeTime & 255
    ]));
    dataOffset = 32 + 20 + 8 + 16 + 8 + 8;
    if (track.type === "audio") {
      trackFragmentRun = trun$1(track, dataOffset);
      return box(types.traf, trackFragmentHeader, trackFragmentDecodeTime, trackFragmentRun);
    }
    sampleDependencyTable = sdtp(track);
    trackFragmentRun = trun$1(track, sampleDependencyTable.length + dataOffset);
    return box(types.traf, trackFragmentHeader, trackFragmentDecodeTime, trackFragmentRun, sampleDependencyTable);
  };
  trak = function(track) {
    track.duration = track.duration || 4294967295;
    return box(types.trak, tkhd(track), mdia(track));
  };
  trex = function(track) {
    var result = new Uint8Array([
      0,
      0,
      0,
      0,
      (track.id & 4278190080) >> 24,
      (track.id & 16711680) >> 16,
      (track.id & 65280) >> 8,
      track.id & 255,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1
    ]);
    if (track.type !== "video") {
      result[result.length - 1] = 0;
    }
    return box(types.trex, result);
  };
  (function() {
    var audioTrun, videoTrun, trunHeader;
    trunHeader = function(samples2, offset) {
      var durationPresent = 0, sizePresent = 0, flagsPresent = 0, compositionTimeOffset = 0;
      if (samples2.length) {
        if (samples2[0].duration !== void 0) {
          durationPresent = 1;
        }
        if (samples2[0].size !== void 0) {
          sizePresent = 2;
        }
        if (samples2[0].flags !== void 0) {
          flagsPresent = 4;
        }
        if (samples2[0].compositionTimeOffset !== void 0) {
          compositionTimeOffset = 8;
        }
      }
      return [
        0,
        0,
        durationPresent | sizePresent | flagsPresent | compositionTimeOffset,
        1,
        (samples2.length & 4278190080) >>> 24,
        (samples2.length & 16711680) >>> 16,
        (samples2.length & 65280) >>> 8,
        samples2.length & 255,
        (offset & 4278190080) >>> 24,
        (offset & 16711680) >>> 16,
        (offset & 65280) >>> 8,
        offset & 255
      ];
    };
    videoTrun = function(track, offset) {
      var bytesOffest, bytes, header, samples2, sample, i;
      samples2 = track.samples || [];
      offset += 8 + 12 + 16 * samples2.length;
      header = trunHeader(samples2, offset);
      bytes = new Uint8Array(header.length + samples2.length * 16);
      bytes.set(header);
      bytesOffest = header.length;
      for (i = 0; i < samples2.length; i++) {
        sample = samples2[i];
        bytes[bytesOffest++] = (sample.duration & 4278190080) >>> 24;
        bytes[bytesOffest++] = (sample.duration & 16711680) >>> 16;
        bytes[bytesOffest++] = (sample.duration & 65280) >>> 8;
        bytes[bytesOffest++] = sample.duration & 255;
        bytes[bytesOffest++] = (sample.size & 4278190080) >>> 24;
        bytes[bytesOffest++] = (sample.size & 16711680) >>> 16;
        bytes[bytesOffest++] = (sample.size & 65280) >>> 8;
        bytes[bytesOffest++] = sample.size & 255;
        bytes[bytesOffest++] = sample.flags.isLeading << 2 | sample.flags.dependsOn;
        bytes[bytesOffest++] = sample.flags.isDependedOn << 6 | sample.flags.hasRedundancy << 4 | sample.flags.paddingValue << 1 | sample.flags.isNonSyncSample;
        bytes[bytesOffest++] = sample.flags.degradationPriority & 240 << 8;
        bytes[bytesOffest++] = sample.flags.degradationPriority & 15;
        bytes[bytesOffest++] = (sample.compositionTimeOffset & 4278190080) >>> 24;
        bytes[bytesOffest++] = (sample.compositionTimeOffset & 16711680) >>> 16;
        bytes[bytesOffest++] = (sample.compositionTimeOffset & 65280) >>> 8;
        bytes[bytesOffest++] = sample.compositionTimeOffset & 255;
      }
      return box(types.trun, bytes);
    };
    audioTrun = function(track, offset) {
      var bytes, bytesOffest, header, samples2, sample, i;
      samples2 = track.samples || [];
      offset += 8 + 12 + 8 * samples2.length;
      header = trunHeader(samples2, offset);
      bytes = new Uint8Array(header.length + samples2.length * 8);
      bytes.set(header);
      bytesOffest = header.length;
      for (i = 0; i < samples2.length; i++) {
        sample = samples2[i];
        bytes[bytesOffest++] = (sample.duration & 4278190080) >>> 24;
        bytes[bytesOffest++] = (sample.duration & 16711680) >>> 16;
        bytes[bytesOffest++] = (sample.duration & 65280) >>> 8;
        bytes[bytesOffest++] = sample.duration & 255;
        bytes[bytesOffest++] = (sample.size & 4278190080) >>> 24;
        bytes[bytesOffest++] = (sample.size & 16711680) >>> 16;
        bytes[bytesOffest++] = (sample.size & 65280) >>> 8;
        bytes[bytesOffest++] = sample.size & 255;
      }
      return box(types.trun, bytes);
    };
    trun$1 = function(track, offset) {
      if (track.type === "audio") {
        return audioTrun(track, offset);
      }
      return videoTrun(track, offset);
    };
  })();
  var mp4Generator = {
    ftyp,
    mdat,
    moof,
    moov,
    initSegment: function(tracks) {
      var fileType = ftyp(), movie = moov(tracks), result;
      result = new Uint8Array(fileType.byteLength + movie.byteLength);
      result.set(fileType);
      result.set(movie, fileType.byteLength);
      return result;
    }
  };
  var groupNalsIntoFrames = function(nalUnits) {
    var i, currentNal, currentFrame = [], frames = [];
    frames.byteLength = 0;
    frames.nalCount = 0;
    frames.duration = 0;
    currentFrame.byteLength = 0;
    for (i = 0; i < nalUnits.length; i++) {
      currentNal = nalUnits[i];
      if (currentNal.nalUnitType === "access_unit_delimiter_rbsp") {
        if (currentFrame.length) {
          currentFrame.duration = currentNal.dts - currentFrame.dts;
          frames.byteLength += currentFrame.byteLength;
          frames.nalCount += currentFrame.length;
          frames.duration += currentFrame.duration;
          frames.push(currentFrame);
        }
        currentFrame = [currentNal];
        currentFrame.byteLength = currentNal.data.byteLength;
        currentFrame.pts = currentNal.pts;
        currentFrame.dts = currentNal.dts;
      } else {
        if (currentNal.nalUnitType === "slice_layer_without_partitioning_rbsp_idr") {
          currentFrame.keyFrame = true;
        }
        currentFrame.duration = currentNal.dts - currentFrame.dts;
        currentFrame.byteLength += currentNal.data.byteLength;
        currentFrame.push(currentNal);
      }
    }
    if (frames.length && (!currentFrame.duration || currentFrame.duration <= 0)) {
      currentFrame.duration = frames[frames.length - 1].duration;
    }
    frames.byteLength += currentFrame.byteLength;
    frames.nalCount += currentFrame.length;
    frames.duration += currentFrame.duration;
    frames.push(currentFrame);
    return frames;
  };
  var groupFramesIntoGops = function(frames) {
    var i, currentFrame, currentGop = [], gops = [];
    currentGop.byteLength = 0;
    currentGop.nalCount = 0;
    currentGop.duration = 0;
    currentGop.pts = frames[0].pts;
    currentGop.dts = frames[0].dts;
    gops.byteLength = 0;
    gops.nalCount = 0;
    gops.duration = 0;
    gops.pts = frames[0].pts;
    gops.dts = frames[0].dts;
    for (i = 0; i < frames.length; i++) {
      currentFrame = frames[i];
      if (currentFrame.keyFrame) {
        if (currentGop.length) {
          gops.push(currentGop);
          gops.byteLength += currentGop.byteLength;
          gops.nalCount += currentGop.nalCount;
          gops.duration += currentGop.duration;
        }
        currentGop = [currentFrame];
        currentGop.nalCount = currentFrame.length;
        currentGop.byteLength = currentFrame.byteLength;
        currentGop.pts = currentFrame.pts;
        currentGop.dts = currentFrame.dts;
        currentGop.duration = currentFrame.duration;
      } else {
        currentGop.duration += currentFrame.duration;
        currentGop.nalCount += currentFrame.length;
        currentGop.byteLength += currentFrame.byteLength;
        currentGop.push(currentFrame);
      }
    }
    if (gops.length && currentGop.duration <= 0) {
      currentGop.duration = gops[gops.length - 1].duration;
    }
    gops.byteLength += currentGop.byteLength;
    gops.nalCount += currentGop.nalCount;
    gops.duration += currentGop.duration;
    gops.push(currentGop);
    return gops;
  };
  var extendFirstKeyFrame = function(gops) {
    var currentGop;
    if (!gops[0][0].keyFrame && gops.length > 1) {
      currentGop = gops.shift();
      gops.byteLength -= currentGop.byteLength;
      gops.nalCount -= currentGop.nalCount;
      gops[0][0].dts = currentGop.dts;
      gops[0][0].pts = currentGop.pts;
      gops[0][0].duration += currentGop.duration;
    }
    return gops;
  };
  var createDefaultSample = function() {
    return {
      size: 0,
      flags: {
        isLeading: 0,
        dependsOn: 1,
        isDependedOn: 0,
        hasRedundancy: 0,
        degradationPriority: 0,
        isNonSyncSample: 1
      }
    };
  };
  var sampleForFrame = function(frame, dataOffset) {
    var sample = createDefaultSample();
    sample.dataOffset = dataOffset;
    sample.compositionTimeOffset = frame.pts - frame.dts;
    sample.duration = frame.duration;
    sample.size = 4 * frame.length;
    sample.size += frame.byteLength;
    if (frame.keyFrame) {
      sample.flags.dependsOn = 2;
      sample.flags.isNonSyncSample = 0;
    }
    return sample;
  };
  var generateSampleTable$1 = function(gops, baseDataOffset) {
    var h, i, sample, currentGop, currentFrame, dataOffset = baseDataOffset || 0, samples2 = [];
    for (h = 0; h < gops.length; h++) {
      currentGop = gops[h];
      for (i = 0; i < currentGop.length; i++) {
        currentFrame = currentGop[i];
        sample = sampleForFrame(currentFrame, dataOffset);
        dataOffset += sample.size;
        samples2.push(sample);
      }
    }
    return samples2;
  };
  var concatenateNalData = function(gops) {
    var h, i, j, currentGop, currentFrame, currentNal, dataOffset = 0, nalsByteLength = gops.byteLength, numberOfNals = gops.nalCount, totalByteLength = nalsByteLength + 4 * numberOfNals, data = new Uint8Array(totalByteLength), view = new DataView(data.buffer);
    for (h = 0; h < gops.length; h++) {
      currentGop = gops[h];
      for (i = 0; i < currentGop.length; i++) {
        currentFrame = currentGop[i];
        for (j = 0; j < currentFrame.length; j++) {
          currentNal = currentFrame[j];
          view.setUint32(dataOffset, currentNal.data.byteLength);
          dataOffset += 4;
          data.set(currentNal.data, dataOffset);
          dataOffset += currentNal.data.byteLength;
        }
      }
    }
    return data;
  };
  var generateSampleTableForFrame = function(frame, baseDataOffset) {
    var sample, dataOffset = baseDataOffset || 0, samples2 = [];
    sample = sampleForFrame(frame, dataOffset);
    samples2.push(sample);
    return samples2;
  };
  var concatenateNalDataForFrame = function(frame) {
    var i, currentNal, dataOffset = 0, nalsByteLength = frame.byteLength, numberOfNals = frame.length, totalByteLength = nalsByteLength + 4 * numberOfNals, data = new Uint8Array(totalByteLength), view = new DataView(data.buffer);
    for (i = 0; i < frame.length; i++) {
      currentNal = frame[i];
      view.setUint32(dataOffset, currentNal.data.byteLength);
      dataOffset += 4;
      data.set(currentNal.data, dataOffset);
      dataOffset += currentNal.data.byteLength;
    }
    return data;
  };
  var frameUtils$1 = {
    groupNalsIntoFrames,
    groupFramesIntoGops,
    extendFirstKeyFrame,
    generateSampleTable: generateSampleTable$1,
    concatenateNalData,
    generateSampleTableForFrame,
    concatenateNalDataForFrame
  };
  var highPrefix = [33, 16, 5, 32, 164, 27];
  var lowPrefix = [33, 65, 108, 84, 1, 2, 4, 8, 168, 2, 4, 8, 17, 191, 252];
  var zeroFill = function(count) {
    var a = [];
    while (count--) {
      a.push(0);
    }
    return a;
  };
  var makeTable = function(metaTable) {
    return Object.keys(metaTable).reduce(function(obj, key) {
      obj[key] = new Uint8Array(metaTable[key].reduce(function(arr, part) {
        return arr.concat(part);
      }, []));
      return obj;
    }, {});
  };
  var silence;
  var silence_1 = function() {
    if (!silence) {
      var coneOfSilence2 = {
        96e3: [highPrefix, [227, 64], zeroFill(154), [56]],
        88200: [highPrefix, [231], zeroFill(170), [56]],
        64e3: [highPrefix, [248, 192], zeroFill(240), [56]],
        48e3: [highPrefix, [255, 192], zeroFill(268), [55, 148, 128], zeroFill(54), [112]],
        44100: [highPrefix, [255, 192], zeroFill(268), [55, 163, 128], zeroFill(84), [112]],
        32e3: [highPrefix, [255, 192], zeroFill(268), [55, 234], zeroFill(226), [112]],
        24e3: [highPrefix, [255, 192], zeroFill(268), [55, 255, 128], zeroFill(268), [111, 112], zeroFill(126), [224]],
        16e3: [highPrefix, [255, 192], zeroFill(268), [55, 255, 128], zeroFill(268), [111, 255], zeroFill(269), [223, 108], zeroFill(195), [1, 192]],
        12e3: [lowPrefix, zeroFill(268), [3, 127, 248], zeroFill(268), [6, 255, 240], zeroFill(268), [13, 255, 224], zeroFill(268), [27, 253, 128], zeroFill(259), [56]],
        11025: [lowPrefix, zeroFill(268), [3, 127, 248], zeroFill(268), [6, 255, 240], zeroFill(268), [13, 255, 224], zeroFill(268), [27, 255, 192], zeroFill(268), [55, 175, 128], zeroFill(108), [112]],
        8e3: [lowPrefix, zeroFill(268), [3, 121, 16], zeroFill(47), [7]]
      };
      silence = makeTable(coneOfSilence2);
    }
    return silence;
  };
  var ONE_SECOND_IN_TS$4 = 9e4, secondsToVideoTs, secondsToAudioTs, videoTsToSeconds, audioTsToSeconds, audioTsToVideoTs, videoTsToAudioTs, metadataTsToSeconds;
  secondsToVideoTs = function(seconds) {
    return seconds * ONE_SECOND_IN_TS$4;
  };
  secondsToAudioTs = function(seconds, sampleRate) {
    return seconds * sampleRate;
  };
  videoTsToSeconds = function(timestamp) {
    return timestamp / ONE_SECOND_IN_TS$4;
  };
  audioTsToSeconds = function(timestamp, sampleRate) {
    return timestamp / sampleRate;
  };
  audioTsToVideoTs = function(timestamp, sampleRate) {
    return secondsToVideoTs(audioTsToSeconds(timestamp, sampleRate));
  };
  videoTsToAudioTs = function(timestamp, sampleRate) {
    return secondsToAudioTs(videoTsToSeconds(timestamp), sampleRate);
  };
  metadataTsToSeconds = function(timestamp, timelineStartPts, keepOriginalTimestamps) {
    return videoTsToSeconds(keepOriginalTimestamps ? timestamp : timestamp - timelineStartPts);
  };
  var clock$2 = {
    ONE_SECOND_IN_TS: ONE_SECOND_IN_TS$4,
    secondsToVideoTs,
    secondsToAudioTs,
    videoTsToSeconds,
    audioTsToSeconds,
    audioTsToVideoTs,
    videoTsToAudioTs,
    metadataTsToSeconds
  };
  var coneOfSilence = silence_1;
  var clock$1 = clock$2;
  var sumFrameByteLengths = function(array) {
    var i, currentObj, sum = 0;
    for (i = 0; i < array.length; i++) {
      currentObj = array[i];
      sum += currentObj.data.byteLength;
    }
    return sum;
  };
  var prefixWithSilence = function(track, frames, audioAppendStartTs, videoBaseMediaDecodeTime) {
    var baseMediaDecodeTimeTs, frameDuration = 0, audioGapDuration = 0, audioFillFrameCount = 0, audioFillDuration = 0, silentFrame, i, firstFrame;
    if (!frames.length) {
      return;
    }
    baseMediaDecodeTimeTs = clock$1.audioTsToVideoTs(track.baseMediaDecodeTime, track.samplerate);
    frameDuration = Math.ceil(clock$1.ONE_SECOND_IN_TS / (track.samplerate / 1024));
    if (audioAppendStartTs && videoBaseMediaDecodeTime) {
      audioGapDuration = baseMediaDecodeTimeTs - Math.max(audioAppendStartTs, videoBaseMediaDecodeTime);
      audioFillFrameCount = Math.floor(audioGapDuration / frameDuration);
      audioFillDuration = audioFillFrameCount * frameDuration;
    }
    if (audioFillFrameCount < 1 || audioFillDuration > clock$1.ONE_SECOND_IN_TS / 2) {
      return;
    }
    silentFrame = coneOfSilence()[track.samplerate];
    if (!silentFrame) {
      silentFrame = frames[0].data;
    }
    for (i = 0; i < audioFillFrameCount; i++) {
      firstFrame = frames[0];
      frames.splice(0, 0, {
        data: silentFrame,
        dts: firstFrame.dts - frameDuration,
        pts: firstFrame.pts - frameDuration
      });
    }
    track.baseMediaDecodeTime -= Math.floor(clock$1.videoTsToAudioTs(audioFillDuration, track.samplerate));
    return audioFillDuration;
  };
  var trimAdtsFramesByEarliestDts = function(adtsFrames, track, earliestAllowedDts) {
    if (track.minSegmentDts >= earliestAllowedDts) {
      return adtsFrames;
    }
    track.minSegmentDts = Infinity;
    return adtsFrames.filter(function(currentFrame) {
      if (currentFrame.dts >= earliestAllowedDts) {
        track.minSegmentDts = Math.min(track.minSegmentDts, currentFrame.dts);
        track.minSegmentPts = track.minSegmentDts;
        return true;
      }
      return false;
    });
  };
  var generateSampleTable = function(frames) {
    var i, currentFrame, samples2 = [];
    for (i = 0; i < frames.length; i++) {
      currentFrame = frames[i];
      samples2.push({
        size: currentFrame.data.byteLength,
        duration: 1024
      });
    }
    return samples2;
  };
  var concatenateFrameData = function(frames) {
    var i, currentFrame, dataOffset = 0, data = new Uint8Array(sumFrameByteLengths(frames));
    for (i = 0; i < frames.length; i++) {
      currentFrame = frames[i];
      data.set(currentFrame.data, dataOffset);
      dataOffset += currentFrame.data.byteLength;
    }
    return data;
  };
  var audioFrameUtils$1 = {
    prefixWithSilence,
    trimAdtsFramesByEarliestDts,
    generateSampleTable,
    concatenateFrameData
  };
  var ONE_SECOND_IN_TS$3 = clock$2.ONE_SECOND_IN_TS;
  var collectDtsInfo = function(track, data) {
    if (typeof data.pts === "number") {
      if (track.timelineStartInfo.pts === void 0) {
        track.timelineStartInfo.pts = data.pts;
      }
      if (track.minSegmentPts === void 0) {
        track.minSegmentPts = data.pts;
      } else {
        track.minSegmentPts = Math.min(track.minSegmentPts, data.pts);
      }
      if (track.maxSegmentPts === void 0) {
        track.maxSegmentPts = data.pts;
      } else {
        track.maxSegmentPts = Math.max(track.maxSegmentPts, data.pts);
      }
    }
    if (typeof data.dts === "number") {
      if (track.timelineStartInfo.dts === void 0) {
        track.timelineStartInfo.dts = data.dts;
      }
      if (track.minSegmentDts === void 0) {
        track.minSegmentDts = data.dts;
      } else {
        track.minSegmentDts = Math.min(track.minSegmentDts, data.dts);
      }
      if (track.maxSegmentDts === void 0) {
        track.maxSegmentDts = data.dts;
      } else {
        track.maxSegmentDts = Math.max(track.maxSegmentDts, data.dts);
      }
    }
  };
  var clearDtsInfo = function(track) {
    delete track.minSegmentDts;
    delete track.maxSegmentDts;
    delete track.minSegmentPts;
    delete track.maxSegmentPts;
  };
  var calculateTrackBaseMediaDecodeTime = function(track, keepOriginalTimestamps) {
    var baseMediaDecodeTime, scale, minSegmentDts = track.minSegmentDts;
    if (!keepOriginalTimestamps) {
      minSegmentDts -= track.timelineStartInfo.dts;
    }
    baseMediaDecodeTime = track.timelineStartInfo.baseMediaDecodeTime;
    baseMediaDecodeTime += minSegmentDts;
    baseMediaDecodeTime = Math.max(0, baseMediaDecodeTime);
    if (track.type === "audio") {
      scale = track.samplerate / ONE_SECOND_IN_TS$3;
      baseMediaDecodeTime *= scale;
      baseMediaDecodeTime = Math.floor(baseMediaDecodeTime);
    }
    return baseMediaDecodeTime;
  };
  var trackDecodeInfo$1 = {
    clearDtsInfo,
    calculateTrackBaseMediaDecodeTime,
    collectDtsInfo
  };
  var USER_DATA_REGISTERED_ITU_T_T35 = 4, RBSP_TRAILING_BITS = 128;
  var parseSei = function(bytes) {
    var i = 0, result = {
      payloadType: -1,
      payloadSize: 0
    }, payloadType = 0, payloadSize = 0;
    while (i < bytes.byteLength) {
      if (bytes[i] === RBSP_TRAILING_BITS) {
        break;
      }
      while (bytes[i] === 255) {
        payloadType += 255;
        i++;
      }
      payloadType += bytes[i++];
      while (bytes[i] === 255) {
        payloadSize += 255;
        i++;
      }
      payloadSize += bytes[i++];
      if (!result.payload && payloadType === USER_DATA_REGISTERED_ITU_T_T35) {
        var userIdentifier = String.fromCharCode(bytes[i + 3], bytes[i + 4], bytes[i + 5], bytes[i + 6]);
        if (userIdentifier === "GA94") {
          result.payloadType = payloadType;
          result.payloadSize = payloadSize;
          result.payload = bytes.subarray(i, i + payloadSize);
          break;
        } else {
          result.payload = void 0;
        }
      }
      i += payloadSize;
      payloadType = 0;
      payloadSize = 0;
    }
    return result;
  };
  var parseUserData = function(sei) {
    if (sei.payload[0] !== 181) {
      return null;
    }
    if ((sei.payload[1] << 8 | sei.payload[2]) !== 49) {
      return null;
    }
    if (String.fromCharCode(sei.payload[3], sei.payload[4], sei.payload[5], sei.payload[6]) !== "GA94") {
      return null;
    }
    if (sei.payload[7] !== 3) {
      return null;
    }
    return sei.payload.subarray(8, sei.payload.length - 1);
  };
  var parseCaptionPackets = function(pts, userData) {
    var results = [], i, count, offset, data;
    if (!(userData[0] & 64)) {
      return results;
    }
    count = userData[0] & 31;
    for (i = 0; i < count; i++) {
      offset = i * 3;
      data = {
        type: userData[offset + 2] & 3,
        pts
      };
      if (userData[offset + 2] & 4) {
        data.ccData = userData[offset + 3] << 8 | userData[offset + 4];
        results.push(data);
      }
    }
    return results;
  };
  var discardEmulationPreventionBytes$1 = function(data) {
    var length = data.byteLength, emulationPreventionBytesPositions = [], i = 1, newLength, newData;
    while (i < length - 2) {
      if (data[i] === 0 && data[i + 1] === 0 && data[i + 2] === 3) {
        emulationPreventionBytesPositions.push(i + 2);
        i += 2;
      } else {
        i++;
      }
    }
    if (emulationPreventionBytesPositions.length === 0) {
      return data;
    }
    newLength = length - emulationPreventionBytesPositions.length;
    newData = new Uint8Array(newLength);
    var sourceIndex = 0;
    for (i = 0; i < newLength; sourceIndex++, i++) {
      if (sourceIndex === emulationPreventionBytesPositions[0]) {
        sourceIndex++;
        emulationPreventionBytesPositions.shift();
      }
      newData[i] = data[sourceIndex];
    }
    return newData;
  };
  var captionPacketParser = {
    parseSei,
    parseUserData,
    parseCaptionPackets,
    discardEmulationPreventionBytes: discardEmulationPreventionBytes$1,
    USER_DATA_REGISTERED_ITU_T_T35
  };
  var Stream$7 = stream;
  var cea708Parser = captionPacketParser;
  var CaptionStream$2 = function(options) {
    options = options || {};
    CaptionStream$2.prototype.init.call(this);
    this.parse708captions_ = typeof options.parse708captions === "boolean" ? options.parse708captions : true;
    this.captionPackets_ = [];
    this.ccStreams_ = [
      new Cea608Stream(0, 0),
      new Cea608Stream(0, 1),
      new Cea608Stream(1, 0),
      new Cea608Stream(1, 1)
    ];
    if (this.parse708captions_) {
      this.cc708Stream_ = new Cea708Stream({
        captionServices: options.captionServices
      });
    }
    this.reset();
    this.ccStreams_.forEach(function(cc) {
      cc.on("data", this.trigger.bind(this, "data"));
      cc.on("partialdone", this.trigger.bind(this, "partialdone"));
      cc.on("done", this.trigger.bind(this, "done"));
    }, this);
    if (this.parse708captions_) {
      this.cc708Stream_.on("data", this.trigger.bind(this, "data"));
      this.cc708Stream_.on("partialdone", this.trigger.bind(this, "partialdone"));
      this.cc708Stream_.on("done", this.trigger.bind(this, "done"));
    }
  };
  CaptionStream$2.prototype = new Stream$7();
  CaptionStream$2.prototype.push = function(event) {
    var sei, userData, newCaptionPackets;
    if (event.nalUnitType !== "sei_rbsp") {
      return;
    }
    sei = cea708Parser.parseSei(event.escapedRBSP);
    if (!sei.payload) {
      return;
    }
    if (sei.payloadType !== cea708Parser.USER_DATA_REGISTERED_ITU_T_T35) {
      return;
    }
    userData = cea708Parser.parseUserData(sei);
    if (!userData) {
      return;
    }
    if (event.dts < this.latestDts_) {
      this.ignoreNextEqualDts_ = true;
      return;
    } else if (event.dts === this.latestDts_ && this.ignoreNextEqualDts_) {
      this.numSameDts_--;
      if (!this.numSameDts_) {
        this.ignoreNextEqualDts_ = false;
      }
      return;
    }
    newCaptionPackets = cea708Parser.parseCaptionPackets(event.pts, userData);
    this.captionPackets_ = this.captionPackets_.concat(newCaptionPackets);
    if (this.latestDts_ !== event.dts) {
      this.numSameDts_ = 0;
    }
    this.numSameDts_++;
    this.latestDts_ = event.dts;
  };
  CaptionStream$2.prototype.flushCCStreams = function(flushType) {
    this.ccStreams_.forEach(function(cc) {
      return flushType === "flush" ? cc.flush() : cc.partialFlush();
    }, this);
  };
  CaptionStream$2.prototype.flushStream = function(flushType) {
    if (!this.captionPackets_.length) {
      this.flushCCStreams(flushType);
      return;
    }
    this.captionPackets_.forEach(function(elem, idx) {
      elem.presortIndex = idx;
    });
    this.captionPackets_.sort(function(a, b) {
      if (a.pts === b.pts) {
        return a.presortIndex - b.presortIndex;
      }
      return a.pts - b.pts;
    });
    this.captionPackets_.forEach(function(packet) {
      if (packet.type < 2) {
        this.dispatchCea608Packet(packet);
      } else {
        this.dispatchCea708Packet(packet);
      }
    }, this);
    this.captionPackets_.length = 0;
    this.flushCCStreams(flushType);
  };
  CaptionStream$2.prototype.flush = function() {
    return this.flushStream("flush");
  };
  CaptionStream$2.prototype.partialFlush = function() {
    return this.flushStream("partialFlush");
  };
  CaptionStream$2.prototype.reset = function() {
    this.latestDts_ = null;
    this.ignoreNextEqualDts_ = false;
    this.numSameDts_ = 0;
    this.activeCea608Channel_ = [null, null];
    this.ccStreams_.forEach(function(ccStream) {
      ccStream.reset();
    });
  };
  CaptionStream$2.prototype.dispatchCea608Packet = function(packet) {
    if (this.setsTextOrXDSActive(packet)) {
      this.activeCea608Channel_[packet.type] = null;
    } else if (this.setsChannel1Active(packet)) {
      this.activeCea608Channel_[packet.type] = 0;
    } else if (this.setsChannel2Active(packet)) {
      this.activeCea608Channel_[packet.type] = 1;
    }
    if (this.activeCea608Channel_[packet.type] === null) {
      return;
    }
    this.ccStreams_[(packet.type << 1) + this.activeCea608Channel_[packet.type]].push(packet);
  };
  CaptionStream$2.prototype.setsChannel1Active = function(packet) {
    return (packet.ccData & 30720) === 4096;
  };
  CaptionStream$2.prototype.setsChannel2Active = function(packet) {
    return (packet.ccData & 30720) === 6144;
  };
  CaptionStream$2.prototype.setsTextOrXDSActive = function(packet) {
    return (packet.ccData & 28928) === 256 || (packet.ccData & 30974) === 4138 || (packet.ccData & 30974) === 6186;
  };
  CaptionStream$2.prototype.dispatchCea708Packet = function(packet) {
    if (this.parse708captions_) {
      this.cc708Stream_.push(packet);
    }
  };
  var CHARACTER_TRANSLATION_708 = {
    127: 9834,
    4128: 32,
    4129: 160,
    4133: 8230,
    4138: 352,
    4140: 338,
    4144: 9608,
    4145: 8216,
    4146: 8217,
    4147: 8220,
    4148: 8221,
    4149: 8226,
    4153: 8482,
    4154: 353,
    4156: 339,
    4157: 8480,
    4159: 376,
    4214: 8539,
    4215: 8540,
    4216: 8541,
    4217: 8542,
    4218: 9168,
    4219: 9124,
    4220: 9123,
    4221: 9135,
    4222: 9126,
    4223: 9121,
    4256: 12600
  };
  var get708CharFromCode = function(code) {
    var newCode = CHARACTER_TRANSLATION_708[code] || code;
    if (code & 4096 && code === newCode) {
      return "";
    }
    return String.fromCharCode(newCode);
  };
  var within708TextBlock = function(b) {
    return 32 <= b && b <= 127 || 160 <= b && b <= 255;
  };
  var Cea708Window = function(windowNum) {
    this.windowNum = windowNum;
    this.reset();
  };
  Cea708Window.prototype.reset = function() {
    this.clearText();
    this.pendingNewLine = false;
    this.winAttr = {};
    this.penAttr = {};
    this.penLoc = {};
    this.penColor = {};
    this.visible = 0;
    this.rowLock = 0;
    this.columnLock = 0;
    this.priority = 0;
    this.relativePositioning = 0;
    this.anchorVertical = 0;
    this.anchorHorizontal = 0;
    this.anchorPoint = 0;
    this.rowCount = 1;
    this.virtualRowCount = this.rowCount + 1;
    this.columnCount = 41;
    this.windowStyle = 0;
    this.penStyle = 0;
  };
  Cea708Window.prototype.getText = function() {
    return this.rows.join("\n");
  };
  Cea708Window.prototype.clearText = function() {
    this.rows = [""];
    this.rowIdx = 0;
  };
  Cea708Window.prototype.newLine = function(pts) {
    if (this.rows.length >= this.virtualRowCount && typeof this.beforeRowOverflow === "function") {
      this.beforeRowOverflow(pts);
    }
    if (this.rows.length > 0) {
      this.rows.push("");
      this.rowIdx++;
    }
    while (this.rows.length > this.virtualRowCount) {
      this.rows.shift();
      this.rowIdx--;
    }
  };
  Cea708Window.prototype.isEmpty = function() {
    if (this.rows.length === 0) {
      return true;
    } else if (this.rows.length === 1) {
      return this.rows[0] === "";
    }
    return false;
  };
  Cea708Window.prototype.addText = function(text) {
    this.rows[this.rowIdx] += text;
  };
  Cea708Window.prototype.backspace = function() {
    if (!this.isEmpty()) {
      var row = this.rows[this.rowIdx];
      this.rows[this.rowIdx] = row.substr(0, row.length - 1);
    }
  };
  var Cea708Service = function(serviceNum, encoding, stream2) {
    this.serviceNum = serviceNum;
    this.text = "";
    this.currentWindow = new Cea708Window(-1);
    this.windows = [];
    this.stream = stream2;
    if (typeof encoding === "string") {
      this.createTextDecoder(encoding);
    }
  };
  Cea708Service.prototype.init = function(pts, beforeRowOverflow) {
    this.startPts = pts;
    for (var win2 = 0; win2 < 8; win2++) {
      this.windows[win2] = new Cea708Window(win2);
      if (typeof beforeRowOverflow === "function") {
        this.windows[win2].beforeRowOverflow = beforeRowOverflow;
      }
    }
  };
  Cea708Service.prototype.setCurrentWindow = function(windowNum) {
    this.currentWindow = this.windows[windowNum];
  };
  Cea708Service.prototype.createTextDecoder = function(encoding) {
    if (typeof TextDecoder === "undefined") {
      this.stream.trigger("log", {
        level: "warn",
        message: "The `encoding` option is unsupported without TextDecoder support"
      });
    } else {
      try {
        this.textDecoder_ = new TextDecoder(encoding);
      } catch (error) {
        this.stream.trigger("log", {
          level: "warn",
          message: "TextDecoder could not be created with " + encoding + " encoding. " + error
        });
      }
    }
  };
  var Cea708Stream = function(options) {
    options = options || {};
    Cea708Stream.prototype.init.call(this);
    var self2 = this;
    var captionServices = options.captionServices || {};
    var captionServiceEncodings = {};
    var serviceProps;
    Object.keys(captionServices).forEach((serviceName) => {
      serviceProps = captionServices[serviceName];
      if (/^SERVICE/.test(serviceName)) {
        captionServiceEncodings[serviceName] = serviceProps.encoding;
      }
    });
    this.serviceEncodings = captionServiceEncodings;
    this.current708Packet = null;
    this.services = {};
    this.push = function(packet) {
      if (packet.type === 3) {
        self2.new708Packet();
        self2.add708Bytes(packet);
      } else {
        if (self2.current708Packet === null) {
          self2.new708Packet();
        }
        self2.add708Bytes(packet);
      }
    };
  };
  Cea708Stream.prototype = new Stream$7();
  Cea708Stream.prototype.new708Packet = function() {
    if (this.current708Packet !== null) {
      this.push708Packet();
    }
    this.current708Packet = {
      data: [],
      ptsVals: []
    };
  };
  Cea708Stream.prototype.add708Bytes = function(packet) {
    var data = packet.ccData;
    var byte0 = data >>> 8;
    var byte1 = data & 255;
    this.current708Packet.ptsVals.push(packet.pts);
    this.current708Packet.data.push(byte0);
    this.current708Packet.data.push(byte1);
  };
  Cea708Stream.prototype.push708Packet = function() {
    var packet708 = this.current708Packet;
    var packetData = packet708.data;
    var serviceNum = null;
    var blockSize = null;
    var i = 0;
    var b = packetData[i++];
    packet708.seq = b >> 6;
    packet708.sizeCode = b & 63;
    for (; i < packetData.length; i++) {
      b = packetData[i++];
      serviceNum = b >> 5;
      blockSize = b & 31;
      if (serviceNum === 7 && blockSize > 0) {
        b = packetData[i++];
        serviceNum = b;
      }
      this.pushServiceBlock(serviceNum, i, blockSize);
      if (blockSize > 0) {
        i += blockSize - 1;
      }
    }
  };
  Cea708Stream.prototype.pushServiceBlock = function(serviceNum, start, size) {
    var b;
    var i = start;
    var packetData = this.current708Packet.data;
    var service = this.services[serviceNum];
    if (!service) {
      service = this.initService(serviceNum, i);
    }
    for (; i < start + size && i < packetData.length; i++) {
      b = packetData[i];
      if (within708TextBlock(b)) {
        i = this.handleText(i, service);
      } else if (b === 24) {
        i = this.multiByteCharacter(i, service);
      } else if (b === 16) {
        i = this.extendedCommands(i, service);
      } else if (128 <= b && b <= 135) {
        i = this.setCurrentWindow(i, service);
      } else if (152 <= b && b <= 159) {
        i = this.defineWindow(i, service);
      } else if (b === 136) {
        i = this.clearWindows(i, service);
      } else if (b === 140) {
        i = this.deleteWindows(i, service);
      } else if (b === 137) {
        i = this.displayWindows(i, service);
      } else if (b === 138) {
        i = this.hideWindows(i, service);
      } else if (b === 139) {
        i = this.toggleWindows(i, service);
      } else if (b === 151) {
        i = this.setWindowAttributes(i, service);
      } else if (b === 144) {
        i = this.setPenAttributes(i, service);
      } else if (b === 145) {
        i = this.setPenColor(i, service);
      } else if (b === 146) {
        i = this.setPenLocation(i, service);
      } else if (b === 143) {
        service = this.reset(i, service);
      } else if (b === 8) {
        service.currentWindow.backspace();
      } else if (b === 12) {
        service.currentWindow.clearText();
      } else if (b === 13) {
        service.currentWindow.pendingNewLine = true;
      } else if (b === 14) {
        service.currentWindow.clearText();
      } else if (b === 141) {
        i++;
      } else
        ;
    }
  };
  Cea708Stream.prototype.extendedCommands = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[++i];
    if (within708TextBlock(b)) {
      i = this.handleText(i, service, {
        isExtended: true
      });
    }
    return i;
  };
  Cea708Stream.prototype.getPts = function(byteIndex) {
    return this.current708Packet.ptsVals[Math.floor(byteIndex / 2)];
  };
  Cea708Stream.prototype.initService = function(serviceNum, i) {
    var serviceName = "SERVICE" + serviceNum;
    var self2 = this;
    var serviceName;
    var encoding;
    if (serviceName in this.serviceEncodings) {
      encoding = this.serviceEncodings[serviceName];
    }
    this.services[serviceNum] = new Cea708Service(serviceNum, encoding, self2);
    this.services[serviceNum].init(this.getPts(i), function(pts) {
      self2.flushDisplayed(pts, self2.services[serviceNum]);
    });
    return this.services[serviceNum];
  };
  Cea708Stream.prototype.handleText = function(i, service, options) {
    var isExtended = options && options.isExtended;
    var isMultiByte = options && options.isMultiByte;
    var packetData = this.current708Packet.data;
    var extended = isExtended ? 4096 : 0;
    var currentByte = packetData[i];
    var nextByte = packetData[i + 1];
    var win2 = service.currentWindow;
    var char;
    var charCodeArray;
    function toHexString2(byteArray) {
      return byteArray.map((byte) => {
        return ("0" + (byte & 255).toString(16)).slice(-2);
      }).join("");
    }
    if (isMultiByte) {
      charCodeArray = [currentByte, nextByte];
      i++;
    } else {
      charCodeArray = [currentByte];
    }
    if (service.textDecoder_ && !isExtended) {
      char = service.textDecoder_.decode(new Uint8Array(charCodeArray));
    } else {
      if (isMultiByte) {
        const unicode = toHexString2(charCodeArray);
        char = String.fromCharCode(parseInt(unicode, 16));
      } else {
        char = get708CharFromCode(extended | currentByte);
      }
    }
    if (win2.pendingNewLine && !win2.isEmpty()) {
      win2.newLine(this.getPts(i));
    }
    win2.pendingNewLine = false;
    win2.addText(char);
    return i;
  };
  Cea708Stream.prototype.multiByteCharacter = function(i, service) {
    var packetData = this.current708Packet.data;
    var firstByte = packetData[i + 1];
    var secondByte = packetData[i + 2];
    if (within708TextBlock(firstByte) && within708TextBlock(secondByte)) {
      i = this.handleText(++i, service, {
        isMultiByte: true
      });
    }
    return i;
  };
  Cea708Stream.prototype.setCurrentWindow = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[i];
    var windowNum = b & 7;
    service.setCurrentWindow(windowNum);
    return i;
  };
  Cea708Stream.prototype.defineWindow = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[i];
    var windowNum = b & 7;
    service.setCurrentWindow(windowNum);
    var win2 = service.currentWindow;
    b = packetData[++i];
    win2.visible = (b & 32) >> 5;
    win2.rowLock = (b & 16) >> 4;
    win2.columnLock = (b & 8) >> 3;
    win2.priority = b & 7;
    b = packetData[++i];
    win2.relativePositioning = (b & 128) >> 7;
    win2.anchorVertical = b & 127;
    b = packetData[++i];
    win2.anchorHorizontal = b;
    b = packetData[++i];
    win2.anchorPoint = (b & 240) >> 4;
    win2.rowCount = b & 15;
    b = packetData[++i];
    win2.columnCount = b & 63;
    b = packetData[++i];
    win2.windowStyle = (b & 56) >> 3;
    win2.penStyle = b & 7;
    win2.virtualRowCount = win2.rowCount + 1;
    return i;
  };
  Cea708Stream.prototype.setWindowAttributes = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[i];
    var winAttr = service.currentWindow.winAttr;
    b = packetData[++i];
    winAttr.fillOpacity = (b & 192) >> 6;
    winAttr.fillRed = (b & 48) >> 4;
    winAttr.fillGreen = (b & 12) >> 2;
    winAttr.fillBlue = b & 3;
    b = packetData[++i];
    winAttr.borderType = (b & 192) >> 6;
    winAttr.borderRed = (b & 48) >> 4;
    winAttr.borderGreen = (b & 12) >> 2;
    winAttr.borderBlue = b & 3;
    b = packetData[++i];
    winAttr.borderType += (b & 128) >> 5;
    winAttr.wordWrap = (b & 64) >> 6;
    winAttr.printDirection = (b & 48) >> 4;
    winAttr.scrollDirection = (b & 12) >> 2;
    winAttr.justify = b & 3;
    b = packetData[++i];
    winAttr.effectSpeed = (b & 240) >> 4;
    winAttr.effectDirection = (b & 12) >> 2;
    winAttr.displayEffect = b & 3;
    return i;
  };
  Cea708Stream.prototype.flushDisplayed = function(pts, service) {
    var displayedText = [];
    for (var winId = 0; winId < 8; winId++) {
      if (service.windows[winId].visible && !service.windows[winId].isEmpty()) {
        displayedText.push(service.windows[winId].getText());
      }
    }
    service.endPts = pts;
    service.text = displayedText.join("\n\n");
    this.pushCaption(service);
    service.startPts = pts;
  };
  Cea708Stream.prototype.pushCaption = function(service) {
    if (service.text !== "") {
      this.trigger("data", {
        startPts: service.startPts,
        endPts: service.endPts,
        text: service.text,
        stream: "cc708_" + service.serviceNum
      });
      service.text = "";
      service.startPts = service.endPts;
    }
  };
  Cea708Stream.prototype.displayWindows = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[++i];
    var pts = this.getPts(i);
    this.flushDisplayed(pts, service);
    for (var winId = 0; winId < 8; winId++) {
      if (b & 1 << winId) {
        service.windows[winId].visible = 1;
      }
    }
    return i;
  };
  Cea708Stream.prototype.hideWindows = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[++i];
    var pts = this.getPts(i);
    this.flushDisplayed(pts, service);
    for (var winId = 0; winId < 8; winId++) {
      if (b & 1 << winId) {
        service.windows[winId].visible = 0;
      }
    }
    return i;
  };
  Cea708Stream.prototype.toggleWindows = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[++i];
    var pts = this.getPts(i);
    this.flushDisplayed(pts, service);
    for (var winId = 0; winId < 8; winId++) {
      if (b & 1 << winId) {
        service.windows[winId].visible ^= 1;
      }
    }
    return i;
  };
  Cea708Stream.prototype.clearWindows = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[++i];
    var pts = this.getPts(i);
    this.flushDisplayed(pts, service);
    for (var winId = 0; winId < 8; winId++) {
      if (b & 1 << winId) {
        service.windows[winId].clearText();
      }
    }
    return i;
  };
  Cea708Stream.prototype.deleteWindows = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[++i];
    var pts = this.getPts(i);
    this.flushDisplayed(pts, service);
    for (var winId = 0; winId < 8; winId++) {
      if (b & 1 << winId) {
        service.windows[winId].reset();
      }
    }
    return i;
  };
  Cea708Stream.prototype.setPenAttributes = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[i];
    var penAttr = service.currentWindow.penAttr;
    b = packetData[++i];
    penAttr.textTag = (b & 240) >> 4;
    penAttr.offset = (b & 12) >> 2;
    penAttr.penSize = b & 3;
    b = packetData[++i];
    penAttr.italics = (b & 128) >> 7;
    penAttr.underline = (b & 64) >> 6;
    penAttr.edgeType = (b & 56) >> 3;
    penAttr.fontStyle = b & 7;
    return i;
  };
  Cea708Stream.prototype.setPenColor = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[i];
    var penColor = service.currentWindow.penColor;
    b = packetData[++i];
    penColor.fgOpacity = (b & 192) >> 6;
    penColor.fgRed = (b & 48) >> 4;
    penColor.fgGreen = (b & 12) >> 2;
    penColor.fgBlue = b & 3;
    b = packetData[++i];
    penColor.bgOpacity = (b & 192) >> 6;
    penColor.bgRed = (b & 48) >> 4;
    penColor.bgGreen = (b & 12) >> 2;
    penColor.bgBlue = b & 3;
    b = packetData[++i];
    penColor.edgeRed = (b & 48) >> 4;
    penColor.edgeGreen = (b & 12) >> 2;
    penColor.edgeBlue = b & 3;
    return i;
  };
  Cea708Stream.prototype.setPenLocation = function(i, service) {
    var packetData = this.current708Packet.data;
    var b = packetData[i];
    var penLoc = service.currentWindow.penLoc;
    service.currentWindow.pendingNewLine = true;
    b = packetData[++i];
    penLoc.row = b & 15;
    b = packetData[++i];
    penLoc.column = b & 63;
    return i;
  };
  Cea708Stream.prototype.reset = function(i, service) {
    var pts = this.getPts(i);
    this.flushDisplayed(pts, service);
    return this.initService(service.serviceNum, i);
  };
  var CHARACTER_TRANSLATION = {
    42: 225,
    92: 233,
    94: 237,
    95: 243,
    96: 250,
    123: 231,
    124: 247,
    125: 209,
    126: 241,
    127: 9608,
    304: 174,
    305: 176,
    306: 189,
    307: 191,
    308: 8482,
    309: 162,
    310: 163,
    311: 9834,
    312: 224,
    313: 160,
    314: 232,
    315: 226,
    316: 234,
    317: 238,
    318: 244,
    319: 251,
    544: 193,
    545: 201,
    546: 211,
    547: 218,
    548: 220,
    549: 252,
    550: 8216,
    551: 161,
    552: 42,
    553: 39,
    554: 8212,
    555: 169,
    556: 8480,
    557: 8226,
    558: 8220,
    559: 8221,
    560: 192,
    561: 194,
    562: 199,
    563: 200,
    564: 202,
    565: 203,
    566: 235,
    567: 206,
    568: 207,
    569: 239,
    570: 212,
    571: 217,
    572: 249,
    573: 219,
    574: 171,
    575: 187,
    800: 195,
    801: 227,
    802: 205,
    803: 204,
    804: 236,
    805: 210,
    806: 242,
    807: 213,
    808: 245,
    809: 123,
    810: 125,
    811: 92,
    812: 94,
    813: 95,
    814: 124,
    815: 126,
    816: 196,
    817: 228,
    818: 214,
    819: 246,
    820: 223,
    821: 165,
    822: 164,
    823: 9474,
    824: 197,
    825: 229,
    826: 216,
    827: 248,
    828: 9484,
    829: 9488,
    830: 9492,
    831: 9496
  };
  var getCharFromCode = function(code) {
    if (code === null) {
      return "";
    }
    code = CHARACTER_TRANSLATION[code] || code;
    return String.fromCharCode(code);
  };
  var BOTTOM_ROW = 14;
  var ROWS = [4352, 4384, 4608, 4640, 5376, 5408, 5632, 5664, 5888, 5920, 4096, 4864, 4896, 5120, 5152];
  var createDisplayBuffer = function() {
    var result = [], i = BOTTOM_ROW + 1;
    while (i--) {
      result.push({
        text: "",
        indent: 0,
        offset: 0
      });
    }
    return result;
  };
  var Cea608Stream = function(field, dataChannel) {
    Cea608Stream.prototype.init.call(this);
    this.field_ = field || 0;
    this.dataChannel_ = dataChannel || 0;
    this.name_ = "CC" + ((this.field_ << 1 | this.dataChannel_) + 1);
    this.setConstants();
    this.reset();
    this.push = function(packet) {
      var data, swap, char0, char1, text;
      data = packet.ccData & 32639;
      if (data === this.lastControlCode_) {
        this.lastControlCode_ = null;
        return;
      }
      if ((data & 61440) === 4096) {
        this.lastControlCode_ = data;
      } else if (data !== this.PADDING_) {
        this.lastControlCode_ = null;
      }
      char0 = data >>> 8;
      char1 = data & 255;
      if (data === this.PADDING_) {
        return;
      } else if (data === this.RESUME_CAPTION_LOADING_) {
        this.mode_ = "popOn";
      } else if (data === this.END_OF_CAPTION_) {
        this.mode_ = "popOn";
        this.clearFormatting(packet.pts);
        this.flushDisplayed(packet.pts);
        swap = this.displayed_;
        this.displayed_ = this.nonDisplayed_;
        this.nonDisplayed_ = swap;
        this.startPts_ = packet.pts;
      } else if (data === this.ROLL_UP_2_ROWS_) {
        this.rollUpRows_ = 2;
        this.setRollUp(packet.pts);
      } else if (data === this.ROLL_UP_3_ROWS_) {
        this.rollUpRows_ = 3;
        this.setRollUp(packet.pts);
      } else if (data === this.ROLL_UP_4_ROWS_) {
        this.rollUpRows_ = 4;
        this.setRollUp(packet.pts);
      } else if (data === this.CARRIAGE_RETURN_) {
        this.clearFormatting(packet.pts);
        this.flushDisplayed(packet.pts);
        this.shiftRowsUp_();
        this.startPts_ = packet.pts;
      } else if (data === this.BACKSPACE_) {
        if (this.mode_ === "popOn") {
          this.nonDisplayed_[this.row_].text = this.nonDisplayed_[this.row_].text.slice(0, -1);
        } else {
          this.displayed_[this.row_].text = this.displayed_[this.row_].text.slice(0, -1);
        }
      } else if (data === this.ERASE_DISPLAYED_MEMORY_) {
        this.flushDisplayed(packet.pts);
        this.displayed_ = createDisplayBuffer();
      } else if (data === this.ERASE_NON_DISPLAYED_MEMORY_) {
        this.nonDisplayed_ = createDisplayBuffer();
      } else if (data === this.RESUME_DIRECT_CAPTIONING_) {
        if (this.mode_ !== "paintOn") {
          this.flushDisplayed(packet.pts);
          this.displayed_ = createDisplayBuffer();
        }
        this.mode_ = "paintOn";
        this.startPts_ = packet.pts;
      } else if (this.isSpecialCharacter(char0, char1)) {
        char0 = (char0 & 3) << 8;
        text = getCharFromCode(char0 | char1);
        this[this.mode_](packet.pts, text);
        this.column_++;
      } else if (this.isExtCharacter(char0, char1)) {
        if (this.mode_ === "popOn") {
          this.nonDisplayed_[this.row_].text = this.nonDisplayed_[this.row_].text.slice(0, -1);
        } else {
          this.displayed_[this.row_].text = this.displayed_[this.row_].text.slice(0, -1);
        }
        char0 = (char0 & 3) << 8;
        text = getCharFromCode(char0 | char1);
        this[this.mode_](packet.pts, text);
        this.column_++;
      } else if (this.isMidRowCode(char0, char1)) {
        this.clearFormatting(packet.pts);
        this[this.mode_](packet.pts, " ");
        this.column_++;
        if ((char1 & 14) === 14) {
          this.addFormatting(packet.pts, ["i"]);
        }
        if ((char1 & 1) === 1) {
          this.addFormatting(packet.pts, ["u"]);
        }
      } else if (this.isOffsetControlCode(char0, char1)) {
        const offset = char1 & 3;
        this.nonDisplayed_[this.row_].offset = offset;
        this.column_ += offset;
      } else if (this.isPAC(char0, char1)) {
        var row = ROWS.indexOf(data & 7968);
        if (this.mode_ === "rollUp") {
          if (row - this.rollUpRows_ + 1 < 0) {
            row = this.rollUpRows_ - 1;
          }
          this.setRollUp(packet.pts, row);
        }
        if (row !== this.row_ && row >= 0 && row <= 14) {
          this.clearFormatting(packet.pts);
          this.row_ = row;
        }
        if (char1 & 1 && this.formatting_.indexOf("u") === -1) {
          this.addFormatting(packet.pts, ["u"]);
        }
        if ((data & 16) === 16) {
          const indentations = (data & 14) >> 1;
          this.column_ = indentations * 4;
          this.nonDisplayed_[this.row_].indent += indentations;
        }
        if (this.isColorPAC(char1)) {
          if ((char1 & 14) === 14) {
            this.addFormatting(packet.pts, ["i"]);
          }
        }
      } else if (this.isNormalChar(char0)) {
        if (char1 === 0) {
          char1 = null;
        }
        text = getCharFromCode(char0);
        text += getCharFromCode(char1);
        this[this.mode_](packet.pts, text);
        this.column_ += text.length;
      }
    };
  };
  Cea608Stream.prototype = new Stream$7();
  Cea608Stream.prototype.flushDisplayed = function(pts) {
    const logWarning = (index) => {
      this.trigger("log", {
        level: "warn",
        message: "Skipping a malformed 608 caption at index " + index + "."
      });
    };
    const content = [];
    this.displayed_.forEach((row, i) => {
      if (row && row.text && row.text.length) {
        try {
          row.text = row.text.trim();
        } catch (e) {
          logWarning(i);
        }
        if (row.text.length) {
          content.push({
            text: row.text,
            line: i + 1,
            position: 10 + Math.min(70, row.indent * 10) + row.offset * 2.5
          });
        }
      } else if (row === void 0 || row === null) {
        logWarning(i);
      }
    });
    if (content.length) {
      this.trigger("data", {
        startPts: this.startPts_,
        endPts: pts,
        content,
        stream: this.name_
      });
    }
  };
  Cea608Stream.prototype.reset = function() {
    this.mode_ = "popOn";
    this.topRow_ = 0;
    this.startPts_ = 0;
    this.displayed_ = createDisplayBuffer();
    this.nonDisplayed_ = createDisplayBuffer();
    this.lastControlCode_ = null;
    this.column_ = 0;
    this.row_ = BOTTOM_ROW;
    this.rollUpRows_ = 2;
    this.formatting_ = [];
  };
  Cea608Stream.prototype.setConstants = function() {
    if (this.dataChannel_ === 0) {
      this.BASE_ = 16;
      this.EXT_ = 17;
      this.CONTROL_ = (20 | this.field_) << 8;
      this.OFFSET_ = 23;
    } else if (this.dataChannel_ === 1) {
      this.BASE_ = 24;
      this.EXT_ = 25;
      this.CONTROL_ = (28 | this.field_) << 8;
      this.OFFSET_ = 31;
    }
    this.PADDING_ = 0;
    this.RESUME_CAPTION_LOADING_ = this.CONTROL_ | 32;
    this.END_OF_CAPTION_ = this.CONTROL_ | 47;
    this.ROLL_UP_2_ROWS_ = this.CONTROL_ | 37;
    this.ROLL_UP_3_ROWS_ = this.CONTROL_ | 38;
    this.ROLL_UP_4_ROWS_ = this.CONTROL_ | 39;
    this.CARRIAGE_RETURN_ = this.CONTROL_ | 45;
    this.RESUME_DIRECT_CAPTIONING_ = this.CONTROL_ | 41;
    this.BACKSPACE_ = this.CONTROL_ | 33;
    this.ERASE_DISPLAYED_MEMORY_ = this.CONTROL_ | 44;
    this.ERASE_NON_DISPLAYED_MEMORY_ = this.CONTROL_ | 46;
  };
  Cea608Stream.prototype.isSpecialCharacter = function(char0, char1) {
    return char0 === this.EXT_ && char1 >= 48 && char1 <= 63;
  };
  Cea608Stream.prototype.isExtCharacter = function(char0, char1) {
    return (char0 === this.EXT_ + 1 || char0 === this.EXT_ + 2) && char1 >= 32 && char1 <= 63;
  };
  Cea608Stream.prototype.isMidRowCode = function(char0, char1) {
    return char0 === this.EXT_ && char1 >= 32 && char1 <= 47;
  };
  Cea608Stream.prototype.isOffsetControlCode = function(char0, char1) {
    return char0 === this.OFFSET_ && char1 >= 33 && char1 <= 35;
  };
  Cea608Stream.prototype.isPAC = function(char0, char1) {
    return char0 >= this.BASE_ && char0 < this.BASE_ + 8 && char1 >= 64 && char1 <= 127;
  };
  Cea608Stream.prototype.isColorPAC = function(char1) {
    return char1 >= 64 && char1 <= 79 || char1 >= 96 && char1 <= 127;
  };
  Cea608Stream.prototype.isNormalChar = function(char) {
    return char >= 32 && char <= 127;
  };
  Cea608Stream.prototype.setRollUp = function(pts, newBaseRow) {
    if (this.mode_ !== "rollUp") {
      this.row_ = BOTTOM_ROW;
      this.mode_ = "rollUp";
      this.flushDisplayed(pts);
      this.nonDisplayed_ = createDisplayBuffer();
      this.displayed_ = createDisplayBuffer();
    }
    if (newBaseRow !== void 0 && newBaseRow !== this.row_) {
      for (var i = 0; i < this.rollUpRows_; i++) {
        this.displayed_[newBaseRow - i] = this.displayed_[this.row_ - i];
        this.displayed_[this.row_ - i] = {
          text: "",
          indent: 0,
          offset: 0
        };
      }
    }
    if (newBaseRow === void 0) {
      newBaseRow = this.row_;
    }
    this.topRow_ = newBaseRow - this.rollUpRows_ + 1;
  };
  Cea608Stream.prototype.addFormatting = function(pts, format) {
    this.formatting_ = this.formatting_.concat(format);
    var text = format.reduce(function(text2, format2) {
      return text2 + "<" + format2 + ">";
    }, "");
    this[this.mode_](pts, text);
  };
  Cea608Stream.prototype.clearFormatting = function(pts) {
    if (!this.formatting_.length) {
      return;
    }
    var text = this.formatting_.reverse().reduce(function(text2, format) {
      return text2 + "</" + format + ">";
    }, "");
    this.formatting_ = [];
    this[this.mode_](pts, text);
  };
  Cea608Stream.prototype.popOn = function(pts, text) {
    var baseRow = this.nonDisplayed_[this.row_].text;
    baseRow += text;
    this.nonDisplayed_[this.row_].text = baseRow;
  };
  Cea608Stream.prototype.rollUp = function(pts, text) {
    var baseRow = this.displayed_[this.row_].text;
    baseRow += text;
    this.displayed_[this.row_].text = baseRow;
  };
  Cea608Stream.prototype.shiftRowsUp_ = function() {
    var i;
    for (i = 0; i < this.topRow_; i++) {
      this.displayed_[i] = {
        text: "",
        indent: 0,
        offset: 0
      };
    }
    for (i = this.row_ + 1; i < BOTTOM_ROW + 1; i++) {
      this.displayed_[i] = {
        text: "",
        indent: 0,
        offset: 0
      };
    }
    for (i = this.topRow_; i < this.row_; i++) {
      this.displayed_[i] = this.displayed_[i + 1];
    }
    this.displayed_[this.row_] = {
      text: "",
      indent: 0,
      offset: 0
    };
  };
  Cea608Stream.prototype.paintOn = function(pts, text) {
    var baseRow = this.displayed_[this.row_].text;
    baseRow += text;
    this.displayed_[this.row_].text = baseRow;
  };
  var captionStream = {
    CaptionStream: CaptionStream$2,
    Cea608Stream,
    Cea708Stream
  };
  var streamTypes = {
    H264_STREAM_TYPE: 27,
    ADTS_STREAM_TYPE: 15,
    METADATA_STREAM_TYPE: 21
  };
  var Stream$6 = stream;
  var MAX_TS = 8589934592;
  var RO_THRESH = 4294967296;
  var TYPE_SHARED = "shared";
  var handleRollover$1 = function(value, reference) {
    var direction = 1;
    if (value > reference) {
      direction = -1;
    }
    while (Math.abs(reference - value) > RO_THRESH) {
      value += direction * MAX_TS;
    }
    return value;
  };
  var TimestampRolloverStream$1 = function(type2) {
    var lastDTS, referenceDTS;
    TimestampRolloverStream$1.prototype.init.call(this);
    this.type_ = type2 || TYPE_SHARED;
    this.push = function(data) {
      if (data.type === "metadata") {
        this.trigger("data", data);
        return;
      }
      if (this.type_ !== TYPE_SHARED && data.type !== this.type_) {
        return;
      }
      if (referenceDTS === void 0) {
        referenceDTS = data.dts;
      }
      data.dts = handleRollover$1(data.dts, referenceDTS);
      data.pts = handleRollover$1(data.pts, referenceDTS);
      lastDTS = data.dts;
      this.trigger("data", data);
    };
    this.flush = function() {
      referenceDTS = lastDTS;
      this.trigger("done");
    };
    this.endTimeline = function() {
      this.flush();
      this.trigger("endedtimeline");
    };
    this.discontinuity = function() {
      referenceDTS = void 0;
      lastDTS = void 0;
    };
    this.reset = function() {
      this.discontinuity();
      this.trigger("reset");
    };
  };
  TimestampRolloverStream$1.prototype = new Stream$6();
  var timestampRolloverStream = {
    TimestampRolloverStream: TimestampRolloverStream$1,
    handleRollover: handleRollover$1
  };
  var typedArrayIndexOf$1 = (typedArray2, element, fromIndex) => {
    if (!typedArray2) {
      return -1;
    }
    var currentIndex = fromIndex;
    for (; currentIndex < typedArray2.length; currentIndex++) {
      if (typedArray2[currentIndex] === element) {
        return currentIndex;
      }
    }
    return -1;
  };
  var typedArray = {
    typedArrayIndexOf: typedArrayIndexOf$1
  };
  var typedArrayIndexOf = typedArray.typedArrayIndexOf, textEncodingDescriptionByte = {
    Iso88591: 0,
    Utf16: 1,
    Utf16be: 2,
    Utf8: 3
  }, percentEncode$1 = function(bytes, start, end) {
    var i, result = "";
    for (i = start; i < end; i++) {
      result += "%" + ("00" + bytes[i].toString(16)).slice(-2);
    }
    return result;
  }, parseUtf8 = function(bytes, start, end) {
    return decodeURIComponent(percentEncode$1(bytes, start, end));
  }, parseIso88591$1 = function(bytes, start, end) {
    return unescape(percentEncode$1(bytes, start, end));
  }, parseSyncSafeInteger$1 = function(data) {
    return data[0] << 21 | data[1] << 14 | data[2] << 7 | data[3];
  }, frameParsers = {
    "APIC": function(frame) {
      var i = 1, mimeTypeEndIndex, descriptionEndIndex, LINK_MIME_TYPE = "-->";
      if (frame.data[0] !== textEncodingDescriptionByte.Utf8) {
        return;
      }
      mimeTypeEndIndex = typedArrayIndexOf(frame.data, 0, i);
      if (mimeTypeEndIndex < 0) {
        return;
      }
      frame.mimeType = parseIso88591$1(frame.data, i, mimeTypeEndIndex);
      i = mimeTypeEndIndex + 1;
      frame.pictureType = frame.data[i];
      i++;
      descriptionEndIndex = typedArrayIndexOf(frame.data, 0, i);
      if (descriptionEndIndex < 0) {
        return;
      }
      frame.description = parseUtf8(frame.data, i, descriptionEndIndex);
      i = descriptionEndIndex + 1;
      if (frame.mimeType === LINK_MIME_TYPE) {
        frame.url = parseIso88591$1(frame.data, i, frame.data.length);
      } else {
        frame.pictureData = frame.data.subarray(i, frame.data.length);
      }
    },
    "T*": function(frame) {
      if (frame.data[0] !== textEncodingDescriptionByte.Utf8) {
        return;
      }
      frame.value = parseUtf8(frame.data, 1, frame.data.length).replace(/\0*$/, "");
      frame.values = frame.value.split("\0");
    },
    "TXXX": function(frame) {
      var descriptionEndIndex;
      if (frame.data[0] !== textEncodingDescriptionByte.Utf8) {
        return;
      }
      descriptionEndIndex = typedArrayIndexOf(frame.data, 0, 1);
      if (descriptionEndIndex === -1) {
        return;
      }
      frame.description = parseUtf8(frame.data, 1, descriptionEndIndex);
      frame.value = parseUtf8(frame.data, descriptionEndIndex + 1, frame.data.length).replace(/\0*$/, "");
      frame.data = frame.value;
    },
    "W*": function(frame) {
      frame.url = parseIso88591$1(frame.data, 0, frame.data.length).replace(/\0.*$/, "");
    },
    "WXXX": function(frame) {
      var descriptionEndIndex;
      if (frame.data[0] !== textEncodingDescriptionByte.Utf8) {
        return;
      }
      descriptionEndIndex = typedArrayIndexOf(frame.data, 0, 1);
      if (descriptionEndIndex === -1) {
        return;
      }
      frame.description = parseUtf8(frame.data, 1, descriptionEndIndex);
      frame.url = parseIso88591$1(frame.data, descriptionEndIndex + 1, frame.data.length).replace(/\0.*$/, "");
    },
    "PRIV": function(frame) {
      var i;
      for (i = 0; i < frame.data.length; i++) {
        if (frame.data[i] === 0) {
          frame.owner = parseIso88591$1(frame.data, 0, i);
          break;
        }
      }
      frame.privateData = frame.data.subarray(i + 1);
      frame.data = frame.privateData;
    }
  };
  var parseId3Frames$1 = function(data) {
    var frameSize, frameHeader, frameStart = 10, tagSize = 0, frames = [];
    if (data.length < 10 || data[0] !== "I".charCodeAt(0) || data[1] !== "D".charCodeAt(0) || data[2] !== "3".charCodeAt(0)) {
      return;
    }
    tagSize = parseSyncSafeInteger$1(data.subarray(6, 10));
    tagSize += 10;
    var hasExtendedHeader = data[5] & 64;
    if (hasExtendedHeader) {
      frameStart += 4;
      frameStart += parseSyncSafeInteger$1(data.subarray(10, 14));
      tagSize -= parseSyncSafeInteger$1(data.subarray(16, 20));
    }
    do {
      frameSize = parseSyncSafeInteger$1(data.subarray(frameStart + 4, frameStart + 8));
      if (frameSize < 1) {
        break;
      }
      frameHeader = String.fromCharCode(data[frameStart], data[frameStart + 1], data[frameStart + 2], data[frameStart + 3]);
      var frame = {
        id: frameHeader,
        data: data.subarray(frameStart + 10, frameStart + frameSize + 10)
      };
      frame.key = frame.id;
      if (frameParsers[frame.id]) {
        frameParsers[frame.id](frame);
      } else if (frame.id[0] === "T") {
        frameParsers["T*"](frame);
      } else if (frame.id[0] === "W") {
        frameParsers["W*"](frame);
      }
      frames.push(frame);
      frameStart += 10;
      frameStart += frameSize;
    } while (frameStart < tagSize);
    return frames;
  };
  var parseId3 = {
    parseId3Frames: parseId3Frames$1,
    parseSyncSafeInteger: parseSyncSafeInteger$1,
    frameParsers
  };
  var Stream$5 = stream, StreamTypes$3 = streamTypes, id3 = parseId3, MetadataStream;
  MetadataStream = function(options) {
    var settings = {
      descriptor: options && options.descriptor
    }, tagSize = 0, buffer = [], bufferSize = 0, i;
    MetadataStream.prototype.init.call(this);
    this.dispatchType = StreamTypes$3.METADATA_STREAM_TYPE.toString(16);
    if (settings.descriptor) {
      for (i = 0; i < settings.descriptor.length; i++) {
        this.dispatchType += ("00" + settings.descriptor[i].toString(16)).slice(-2);
      }
    }
    this.push = function(chunk) {
      var tag, frameStart, frameSize, frame, i2, frameHeader;
      if (chunk.type !== "timed-metadata") {
        return;
      }
      if (chunk.dataAlignmentIndicator) {
        bufferSize = 0;
        buffer.length = 0;
      }
      if (buffer.length === 0 && (chunk.data.length < 10 || chunk.data[0] !== "I".charCodeAt(0) || chunk.data[1] !== "D".charCodeAt(0) || chunk.data[2] !== "3".charCodeAt(0))) {
        this.trigger("log", {
          level: "warn",
          message: "Skipping unrecognized metadata packet"
        });
        return;
      }
      buffer.push(chunk);
      bufferSize += chunk.data.byteLength;
      if (buffer.length === 1) {
        tagSize = id3.parseSyncSafeInteger(chunk.data.subarray(6, 10));
        tagSize += 10;
      }
      if (bufferSize < tagSize) {
        return;
      }
      tag = {
        data: new Uint8Array(tagSize),
        frames: [],
        pts: buffer[0].pts,
        dts: buffer[0].dts
      };
      for (i2 = 0; i2 < tagSize; ) {
        tag.data.set(buffer[0].data.subarray(0, tagSize - i2), i2);
        i2 += buffer[0].data.byteLength;
        bufferSize -= buffer[0].data.byteLength;
        buffer.shift();
      }
      frameStart = 10;
      if (tag.data[5] & 64) {
        frameStart += 4;
        frameStart += id3.parseSyncSafeInteger(tag.data.subarray(10, 14));
        tagSize -= id3.parseSyncSafeInteger(tag.data.subarray(16, 20));
      }
      do {
        frameSize = id3.parseSyncSafeInteger(tag.data.subarray(frameStart + 4, frameStart + 8));
        if (frameSize < 1) {
          this.trigger("log", {
            level: "warn",
            message: "Malformed ID3 frame encountered. Skipping remaining metadata parsing."
          });
          break;
        }
        frameHeader = String.fromCharCode(tag.data[frameStart], tag.data[frameStart + 1], tag.data[frameStart + 2], tag.data[frameStart + 3]);
        frame = {
          id: frameHeader,
          data: tag.data.subarray(frameStart + 10, frameStart + frameSize + 10)
        };
        frame.key = frame.id;
        if (id3.frameParsers[frame.id]) {
          id3.frameParsers[frame.id](frame);
        } else if (frame.id[0] === "T") {
          id3.frameParsers["T*"](frame);
        } else if (frame.id[0] === "W") {
          id3.frameParsers["W*"](frame);
        }
        if (frame.owner === "com.apple.streaming.transportStreamTimestamp") {
          var d = frame.data, size = (d[3] & 1) << 30 | d[4] << 22 | d[5] << 14 | d[6] << 6 | d[7] >>> 2;
          size *= 4;
          size += d[7] & 3;
          frame.timeStamp = size;
          if (tag.pts === void 0 && tag.dts === void 0) {
            tag.pts = frame.timeStamp;
            tag.dts = frame.timeStamp;
          }
          this.trigger("timestamp", frame);
        }
        tag.frames.push(frame);
        frameStart += 10;
        frameStart += frameSize;
      } while (frameStart < tagSize);
      this.trigger("data", tag);
    };
  };
  MetadataStream.prototype = new Stream$5();
  var metadataStream = MetadataStream;
  var Stream$4 = stream, CaptionStream$1 = captionStream, StreamTypes$2 = streamTypes, TimestampRolloverStream = timestampRolloverStream.TimestampRolloverStream;
  var TransportPacketStream, TransportParseStream, ElementaryStream;
  var MP2T_PACKET_LENGTH$1 = 188, SYNC_BYTE$1 = 71;
  TransportPacketStream = function() {
    var buffer = new Uint8Array(MP2T_PACKET_LENGTH$1), bytesInBuffer = 0;
    TransportPacketStream.prototype.init.call(this);
    this.push = function(bytes) {
      var startIndex = 0, endIndex = MP2T_PACKET_LENGTH$1, everything;
      if (bytesInBuffer) {
        everything = new Uint8Array(bytes.byteLength + bytesInBuffer);
        everything.set(buffer.subarray(0, bytesInBuffer));
        everything.set(bytes, bytesInBuffer);
        bytesInBuffer = 0;
      } else {
        everything = bytes;
      }
      while (endIndex < everything.byteLength) {
        if (everything[startIndex] === SYNC_BYTE$1 && everything[endIndex] === SYNC_BYTE$1) {
          this.trigger("data", everything.subarray(startIndex, endIndex));
          startIndex += MP2T_PACKET_LENGTH$1;
          endIndex += MP2T_PACKET_LENGTH$1;
          continue;
        }
        startIndex++;
        endIndex++;
      }
      if (startIndex < everything.byteLength) {
        buffer.set(everything.subarray(startIndex), 0);
        bytesInBuffer = everything.byteLength - startIndex;
      }
    };
    this.flush = function() {
      if (bytesInBuffer === MP2T_PACKET_LENGTH$1 && buffer[0] === SYNC_BYTE$1) {
        this.trigger("data", buffer);
        bytesInBuffer = 0;
      }
      this.trigger("done");
    };
    this.endTimeline = function() {
      this.flush();
      this.trigger("endedtimeline");
    };
    this.reset = function() {
      bytesInBuffer = 0;
      this.trigger("reset");
    };
  };
  TransportPacketStream.prototype = new Stream$4();
  TransportParseStream = function() {
    var parsePsi, parsePat2, parsePmt2, self2;
    TransportParseStream.prototype.init.call(this);
    self2 = this;
    this.packetsWaitingForPmt = [];
    this.programMapTable = void 0;
    parsePsi = function(payload, psi) {
      var offset = 0;
      if (psi.payloadUnitStartIndicator) {
        offset += payload[offset] + 1;
      }
      if (psi.type === "pat") {
        parsePat2(payload.subarray(offset), psi);
      } else {
        parsePmt2(payload.subarray(offset), psi);
      }
    };
    parsePat2 = function(payload, pat) {
      pat.section_number = payload[7];
      pat.last_section_number = payload[8];
      self2.pmtPid = (payload[10] & 31) << 8 | payload[11];
      pat.pmtPid = self2.pmtPid;
    };
    parsePmt2 = function(payload, pmt) {
      var sectionLength, tableEnd, programInfoLength, offset;
      if (!(payload[5] & 1)) {
        return;
      }
      self2.programMapTable = {
        video: null,
        audio: null,
        "timed-metadata": {}
      };
      sectionLength = (payload[1] & 15) << 8 | payload[2];
      tableEnd = 3 + sectionLength - 4;
      programInfoLength = (payload[10] & 15) << 8 | payload[11];
      offset = 12 + programInfoLength;
      while (offset < tableEnd) {
        var streamType = payload[offset];
        var pid = (payload[offset + 1] & 31) << 8 | payload[offset + 2];
        if (streamType === StreamTypes$2.H264_STREAM_TYPE && self2.programMapTable.video === null) {
          self2.programMapTable.video = pid;
        } else if (streamType === StreamTypes$2.ADTS_STREAM_TYPE && self2.programMapTable.audio === null) {
          self2.programMapTable.audio = pid;
        } else if (streamType === StreamTypes$2.METADATA_STREAM_TYPE) {
          self2.programMapTable["timed-metadata"][pid] = streamType;
        }
        offset += ((payload[offset + 3] & 15) << 8 | payload[offset + 4]) + 5;
      }
      pmt.programMapTable = self2.programMapTable;
    };
    this.push = function(packet) {
      var result = {}, offset = 4;
      result.payloadUnitStartIndicator = !!(packet[1] & 64);
      result.pid = packet[1] & 31;
      result.pid <<= 8;
      result.pid |= packet[2];
      if ((packet[3] & 48) >>> 4 > 1) {
        offset += packet[offset] + 1;
      }
      if (result.pid === 0) {
        result.type = "pat";
        parsePsi(packet.subarray(offset), result);
        this.trigger("data", result);
      } else if (result.pid === this.pmtPid) {
        result.type = "pmt";
        parsePsi(packet.subarray(offset), result);
        this.trigger("data", result);
        while (this.packetsWaitingForPmt.length) {
          this.processPes_.apply(this, this.packetsWaitingForPmt.shift());
        }
      } else if (this.programMapTable === void 0) {
        this.packetsWaitingForPmt.push([packet, offset, result]);
      } else {
        this.processPes_(packet, offset, result);
      }
    };
    this.processPes_ = function(packet, offset, result) {
      if (result.pid === this.programMapTable.video) {
        result.streamType = StreamTypes$2.H264_STREAM_TYPE;
      } else if (result.pid === this.programMapTable.audio) {
        result.streamType = StreamTypes$2.ADTS_STREAM_TYPE;
      } else {
        result.streamType = this.programMapTable["timed-metadata"][result.pid];
      }
      result.type = "pes";
      result.data = packet.subarray(offset);
      this.trigger("data", result);
    };
  };
  TransportParseStream.prototype = new Stream$4();
  TransportParseStream.STREAM_TYPES = {
    h264: 27,
    adts: 15
  };
  ElementaryStream = function() {
    var self2 = this, segmentHadPmt = false, video = {
      data: [],
      size: 0
    }, audio = {
      data: [],
      size: 0
    }, timedMetadata = {
      data: [],
      size: 0
    }, programMapTable, parsePes = function(payload, pes) {
      var ptsDtsFlags;
      const startPrefix = payload[0] << 16 | payload[1] << 8 | payload[2];
      pes.data = new Uint8Array();
      if (startPrefix !== 1) {
        return;
      }
      pes.packetLength = 6 + (payload[4] << 8 | payload[5]);
      pes.dataAlignmentIndicator = (payload[6] & 4) !== 0;
      ptsDtsFlags = payload[7];
      if (ptsDtsFlags & 192) {
        pes.pts = (payload[9] & 14) << 27 | (payload[10] & 255) << 20 | (payload[11] & 254) << 12 | (payload[12] & 255) << 5 | (payload[13] & 254) >>> 3;
        pes.pts *= 4;
        pes.pts += (payload[13] & 6) >>> 1;
        pes.dts = pes.pts;
        if (ptsDtsFlags & 64) {
          pes.dts = (payload[14] & 14) << 27 | (payload[15] & 255) << 20 | (payload[16] & 254) << 12 | (payload[17] & 255) << 5 | (payload[18] & 254) >>> 3;
          pes.dts *= 4;
          pes.dts += (payload[18] & 6) >>> 1;
        }
      }
      pes.data = payload.subarray(9 + payload[8]);
    }, flushStream = function(stream2, type2, forceFlush) {
      var packetData = new Uint8Array(stream2.size), event = {
        type: type2
      }, i = 0, offset = 0, packetFlushable = false, fragment;
      if (!stream2.data.length || stream2.size < 9) {
        return;
      }
      event.trackId = stream2.data[0].pid;
      for (i = 0; i < stream2.data.length; i++) {
        fragment = stream2.data[i];
        packetData.set(fragment.data, offset);
        offset += fragment.data.byteLength;
      }
      parsePes(packetData, event);
      packetFlushable = type2 === "video" || event.packetLength <= stream2.size;
      if (forceFlush || packetFlushable) {
        stream2.size = 0;
        stream2.data.length = 0;
      }
      if (packetFlushable) {
        self2.trigger("data", event);
      }
    };
    ElementaryStream.prototype.init.call(this);
    this.push = function(data) {
      ({
        pat: function() {
        },
        pes: function() {
          var stream2, streamType;
          switch (data.streamType) {
            case StreamTypes$2.H264_STREAM_TYPE:
              stream2 = video;
              streamType = "video";
              break;
            case StreamTypes$2.ADTS_STREAM_TYPE:
              stream2 = audio;
              streamType = "audio";
              break;
            case StreamTypes$2.METADATA_STREAM_TYPE:
              stream2 = timedMetadata;
              streamType = "timed-metadata";
              break;
            default:
              return;
          }
          if (data.payloadUnitStartIndicator) {
            flushStream(stream2, streamType, true);
          }
          stream2.data.push(data);
          stream2.size += data.data.byteLength;
        },
        pmt: function() {
          var event = {
            type: "metadata",
            tracks: []
          };
          programMapTable = data.programMapTable;
          if (programMapTable.video !== null) {
            event.tracks.push({
              timelineStartInfo: {
                baseMediaDecodeTime: 0
              },
              id: +programMapTable.video,
              codec: "avc",
              type: "video"
            });
          }
          if (programMapTable.audio !== null) {
            event.tracks.push({
              timelineStartInfo: {
                baseMediaDecodeTime: 0
              },
              id: +programMapTable.audio,
              codec: "adts",
              type: "audio"
            });
          }
          segmentHadPmt = true;
          self2.trigger("data", event);
        }
      })[data.type]();
    };
    this.reset = function() {
      video.size = 0;
      video.data.length = 0;
      audio.size = 0;
      audio.data.length = 0;
      this.trigger("reset");
    };
    this.flushStreams_ = function() {
      flushStream(video, "video");
      flushStream(audio, "audio");
      flushStream(timedMetadata, "timed-metadata");
    };
    this.flush = function() {
      if (!segmentHadPmt && programMapTable) {
        var pmt = {
          type: "metadata",
          tracks: []
        };
        if (programMapTable.video !== null) {
          pmt.tracks.push({
            timelineStartInfo: {
              baseMediaDecodeTime: 0
            },
            id: +programMapTable.video,
            codec: "avc",
            type: "video"
          });
        }
        if (programMapTable.audio !== null) {
          pmt.tracks.push({
            timelineStartInfo: {
              baseMediaDecodeTime: 0
            },
            id: +programMapTable.audio,
            codec: "adts",
            type: "audio"
          });
        }
        self2.trigger("data", pmt);
      }
      segmentHadPmt = false;
      this.flushStreams_();
      this.trigger("done");
    };
  };
  ElementaryStream.prototype = new Stream$4();
  var m2ts$1 = {
    PAT_PID: 0,
    MP2T_PACKET_LENGTH: MP2T_PACKET_LENGTH$1,
    TransportPacketStream,
    TransportParseStream,
    ElementaryStream,
    TimestampRolloverStream,
    CaptionStream: CaptionStream$1.CaptionStream,
    Cea608Stream: CaptionStream$1.Cea608Stream,
    Cea708Stream: CaptionStream$1.Cea708Stream,
    MetadataStream: metadataStream
  };
  for (var type in StreamTypes$2) {
    if (StreamTypes$2.hasOwnProperty(type)) {
      m2ts$1[type] = StreamTypes$2[type];
    }
  }
  var m2ts_1 = m2ts$1;
  var Stream$3 = stream;
  var ONE_SECOND_IN_TS$2 = clock$2.ONE_SECOND_IN_TS;
  var AdtsStream$1;
  var ADTS_SAMPLING_FREQUENCIES$1 = [96e3, 88200, 64e3, 48e3, 44100, 32e3, 24e3, 22050, 16e3, 12e3, 11025, 8e3, 7350];
  AdtsStream$1 = function(handlePartialSegments) {
    var buffer, frameNum = 0;
    AdtsStream$1.prototype.init.call(this);
    this.skipWarn_ = function(start, end) {
      this.trigger("log", {
        level: "warn",
        message: `adts skiping bytes ${start} to ${end} in frame ${frameNum} outside syncword`
      });
    };
    this.push = function(packet) {
      var i = 0, frameLength, protectionSkipBytes, oldBuffer, sampleCount, adtsFrameDuration;
      if (!handlePartialSegments) {
        frameNum = 0;
      }
      if (packet.type !== "audio") {
        return;
      }
      if (buffer && buffer.length) {
        oldBuffer = buffer;
        buffer = new Uint8Array(oldBuffer.byteLength + packet.data.byteLength);
        buffer.set(oldBuffer);
        buffer.set(packet.data, oldBuffer.byteLength);
      } else {
        buffer = packet.data;
      }
      var skip;
      while (i + 7 < buffer.length) {
        if (buffer[i] !== 255 || (buffer[i + 1] & 246) !== 240) {
          if (typeof skip !== "number") {
            skip = i;
          }
          i++;
          continue;
        }
        if (typeof skip === "number") {
          this.skipWarn_(skip, i);
          skip = null;
        }
        protectionSkipBytes = (~buffer[i + 1] & 1) * 2;
        frameLength = (buffer[i + 3] & 3) << 11 | buffer[i + 4] << 3 | (buffer[i + 5] & 224) >> 5;
        sampleCount = ((buffer[i + 6] & 3) + 1) * 1024;
        adtsFrameDuration = sampleCount * ONE_SECOND_IN_TS$2 / ADTS_SAMPLING_FREQUENCIES$1[(buffer[i + 2] & 60) >>> 2];
        if (buffer.byteLength - i < frameLength) {
          break;
        }
        this.trigger("data", {
          pts: packet.pts + frameNum * adtsFrameDuration,
          dts: packet.dts + frameNum * adtsFrameDuration,
          sampleCount,
          audioobjecttype: (buffer[i + 2] >>> 6 & 3) + 1,
          channelcount: (buffer[i + 2] & 1) << 2 | (buffer[i + 3] & 192) >>> 6,
          samplerate: ADTS_SAMPLING_FREQUENCIES$1[(buffer[i + 2] & 60) >>> 2],
          samplingfrequencyindex: (buffer[i + 2] & 60) >>> 2,
          samplesize: 16,
          data: buffer.subarray(i + 7 + protectionSkipBytes, i + frameLength)
        });
        frameNum++;
        i += frameLength;
      }
      if (typeof skip === "number") {
        this.skipWarn_(skip, i);
        skip = null;
      }
      buffer = buffer.subarray(i);
    };
    this.flush = function() {
      frameNum = 0;
      this.trigger("done");
    };
    this.reset = function() {
      buffer = void 0;
      this.trigger("reset");
    };
    this.endTimeline = function() {
      buffer = void 0;
      this.trigger("endedtimeline");
    };
  };
  AdtsStream$1.prototype = new Stream$3();
  var adts = AdtsStream$1;
  var ExpGolomb$1;
  ExpGolomb$1 = function(workingData) {
    var workingBytesAvailable = workingData.byteLength, workingWord = 0, workingBitsAvailable = 0;
    this.length = function() {
      return 8 * workingBytesAvailable;
    };
    this.bitsAvailable = function() {
      return 8 * workingBytesAvailable + workingBitsAvailable;
    };
    this.loadWord = function() {
      var position = workingData.byteLength - workingBytesAvailable, workingBytes = new Uint8Array(4), availableBytes = Math.min(4, workingBytesAvailable);
      if (availableBytes === 0) {
        throw new Error("no bytes available");
      }
      workingBytes.set(workingData.subarray(position, position + availableBytes));
      workingWord = new DataView(workingBytes.buffer).getUint32(0);
      workingBitsAvailable = availableBytes * 8;
      workingBytesAvailable -= availableBytes;
    };
    this.skipBits = function(count) {
      var skipBytes;
      if (workingBitsAvailable > count) {
        workingWord <<= count;
        workingBitsAvailable -= count;
      } else {
        count -= workingBitsAvailable;
        skipBytes = Math.floor(count / 8);
        count -= skipBytes * 8;
        workingBytesAvailable -= skipBytes;
        this.loadWord();
        workingWord <<= count;
        workingBitsAvailable -= count;
      }
    };
    this.readBits = function(size) {
      var bits = Math.min(workingBitsAvailable, size), valu = workingWord >>> 32 - bits;
      workingBitsAvailable -= bits;
      if (workingBitsAvailable > 0) {
        workingWord <<= bits;
      } else if (workingBytesAvailable > 0) {
        this.loadWord();
      }
      bits = size - bits;
      if (bits > 0) {
        return valu << bits | this.readBits(bits);
      }
      return valu;
    };
    this.skipLeadingZeros = function() {
      var leadingZeroCount;
      for (leadingZeroCount = 0; leadingZeroCount < workingBitsAvailable; ++leadingZeroCount) {
        if ((workingWord & 2147483648 >>> leadingZeroCount) !== 0) {
          workingWord <<= leadingZeroCount;
          workingBitsAvailable -= leadingZeroCount;
          return leadingZeroCount;
        }
      }
      this.loadWord();
      return leadingZeroCount + this.skipLeadingZeros();
    };
    this.skipUnsignedExpGolomb = function() {
      this.skipBits(1 + this.skipLeadingZeros());
    };
    this.skipExpGolomb = function() {
      this.skipBits(1 + this.skipLeadingZeros());
    };
    this.readUnsignedExpGolomb = function() {
      var clz = this.skipLeadingZeros();
      return this.readBits(clz + 1) - 1;
    };
    this.readExpGolomb = function() {
      var valu = this.readUnsignedExpGolomb();
      if (1 & valu) {
        return 1 + valu >>> 1;
      }
      return -1 * (valu >>> 1);
    };
    this.readBoolean = function() {
      return this.readBits(1) === 1;
    };
    this.readUnsignedByte = function() {
      return this.readBits(8);
    };
    this.loadWord();
  };
  var expGolomb = ExpGolomb$1;
  var Stream$2 = stream;
  var ExpGolomb = expGolomb;
  var H264Stream$1, NalByteStream;
  var PROFILES_WITH_OPTIONAL_SPS_DATA;
  NalByteStream = function() {
    var syncPoint = 0, i, buffer;
    NalByteStream.prototype.init.call(this);
    this.push = function(data) {
      var swapBuffer;
      if (!buffer) {
        buffer = data.data;
      } else {
        swapBuffer = new Uint8Array(buffer.byteLength + data.data.byteLength);
        swapBuffer.set(buffer);
        swapBuffer.set(data.data, buffer.byteLength);
        buffer = swapBuffer;
      }
      var len = buffer.byteLength;
      for (; syncPoint < len - 3; syncPoint++) {
        if (buffer[syncPoint + 2] === 1) {
          i = syncPoint + 5;
          break;
        }
      }
      while (i < len) {
        switch (buffer[i]) {
          case 0:
            if (buffer[i - 1] !== 0) {
              i += 2;
              break;
            } else if (buffer[i - 2] !== 0) {
              i++;
              break;
            }
            if (syncPoint + 3 !== i - 2) {
              this.trigger("data", buffer.subarray(syncPoint + 3, i - 2));
            }
            do {
              i++;
            } while (buffer[i] !== 1 && i < len);
            syncPoint = i - 2;
            i += 3;
            break;
          case 1:
            if (buffer[i - 1] !== 0 || buffer[i - 2] !== 0) {
              i += 3;
              break;
            }
            this.trigger("data", buffer.subarray(syncPoint + 3, i - 2));
            syncPoint = i - 2;
            i += 3;
            break;
          default:
            i += 3;
            break;
        }
      }
      buffer = buffer.subarray(syncPoint);
      i -= syncPoint;
      syncPoint = 0;
    };
    this.reset = function() {
      buffer = null;
      syncPoint = 0;
      this.trigger("reset");
    };
    this.flush = function() {
      if (buffer && buffer.byteLength > 3) {
        this.trigger("data", buffer.subarray(syncPoint + 3));
      }
      buffer = null;
      syncPoint = 0;
      this.trigger("done");
    };
    this.endTimeline = function() {
      this.flush();
      this.trigger("endedtimeline");
    };
  };
  NalByteStream.prototype = new Stream$2();
  PROFILES_WITH_OPTIONAL_SPS_DATA = {
    100: true,
    110: true,
    122: true,
    244: true,
    44: true,
    83: true,
    86: true,
    118: true,
    128: true,
    138: true,
    139: true,
    134: true
  };
  H264Stream$1 = function() {
    var nalByteStream = new NalByteStream(), self2, trackId, currentPts, currentDts, discardEmulationPreventionBytes2, readSequenceParameterSet, skipScalingList;
    H264Stream$1.prototype.init.call(this);
    self2 = this;
    this.push = function(packet) {
      if (packet.type !== "video") {
        return;
      }
      trackId = packet.trackId;
      currentPts = packet.pts;
      currentDts = packet.dts;
      nalByteStream.push(packet);
    };
    nalByteStream.on("data", function(data) {
      var event = {
        trackId,
        pts: currentPts,
        dts: currentDts,
        data,
        nalUnitTypeCode: data[0] & 31
      };
      switch (event.nalUnitTypeCode) {
        case 5:
          event.nalUnitType = "slice_layer_without_partitioning_rbsp_idr";
          break;
        case 6:
          event.nalUnitType = "sei_rbsp";
          event.escapedRBSP = discardEmulationPreventionBytes2(data.subarray(1));
          break;
        case 7:
          event.nalUnitType = "seq_parameter_set_rbsp";
          event.escapedRBSP = discardEmulationPreventionBytes2(data.subarray(1));
          event.config = readSequenceParameterSet(event.escapedRBSP);
          break;
        case 8:
          event.nalUnitType = "pic_parameter_set_rbsp";
          break;
        case 9:
          event.nalUnitType = "access_unit_delimiter_rbsp";
          break;
      }
      self2.trigger("data", event);
    });
    nalByteStream.on("done", function() {
      self2.trigger("done");
    });
    nalByteStream.on("partialdone", function() {
      self2.trigger("partialdone");
    });
    nalByteStream.on("reset", function() {
      self2.trigger("reset");
    });
    nalByteStream.on("endedtimeline", function() {
      self2.trigger("endedtimeline");
    });
    this.flush = function() {
      nalByteStream.flush();
    };
    this.partialFlush = function() {
      nalByteStream.partialFlush();
    };
    this.reset = function() {
      nalByteStream.reset();
    };
    this.endTimeline = function() {
      nalByteStream.endTimeline();
    };
    skipScalingList = function(count, expGolombDecoder) {
      var lastScale = 8, nextScale = 8, j, deltaScale;
      for (j = 0; j < count; j++) {
        if (nextScale !== 0) {
          deltaScale = expGolombDecoder.readExpGolomb();
          nextScale = (lastScale + deltaScale + 256) % 256;
        }
        lastScale = nextScale === 0 ? lastScale : nextScale;
      }
    };
    discardEmulationPreventionBytes2 = function(data) {
      var length = data.byteLength, emulationPreventionBytesPositions = [], i = 1, newLength, newData;
      while (i < length - 2) {
        if (data[i] === 0 && data[i + 1] === 0 && data[i + 2] === 3) {
          emulationPreventionBytesPositions.push(i + 2);
          i += 2;
        } else {
          i++;
        }
      }
      if (emulationPreventionBytesPositions.length === 0) {
        return data;
      }
      newLength = length - emulationPreventionBytesPositions.length;
      newData = new Uint8Array(newLength);
      var sourceIndex = 0;
      for (i = 0; i < newLength; sourceIndex++, i++) {
        if (sourceIndex === emulationPreventionBytesPositions[0]) {
          sourceIndex++;
          emulationPreventionBytesPositions.shift();
        }
        newData[i] = data[sourceIndex];
      }
      return newData;
    };
    readSequenceParameterSet = function(data) {
      var frameCropLeftOffset = 0, frameCropRightOffset = 0, frameCropTopOffset = 0, frameCropBottomOffset = 0, expGolombDecoder, profileIdc, levelIdc, profileCompatibility, chromaFormatIdc, picOrderCntType, numRefFramesInPicOrderCntCycle, picWidthInMbsMinus1, picHeightInMapUnitsMinus1, frameMbsOnlyFlag, scalingListCount, sarRatio = [1, 1], aspectRatioIdc, i;
      expGolombDecoder = new ExpGolomb(data);
      profileIdc = expGolombDecoder.readUnsignedByte();
      profileCompatibility = expGolombDecoder.readUnsignedByte();
      levelIdc = expGolombDecoder.readUnsignedByte();
      expGolombDecoder.skipUnsignedExpGolomb();
      if (PROFILES_WITH_OPTIONAL_SPS_DATA[profileIdc]) {
        chromaFormatIdc = expGolombDecoder.readUnsignedExpGolomb();
        if (chromaFormatIdc === 3) {
          expGolombDecoder.skipBits(1);
        }
        expGolombDecoder.skipUnsignedExpGolomb();
        expGolombDecoder.skipUnsignedExpGolomb();
        expGolombDecoder.skipBits(1);
        if (expGolombDecoder.readBoolean()) {
          scalingListCount = chromaFormatIdc !== 3 ? 8 : 12;
          for (i = 0; i < scalingListCount; i++) {
            if (expGolombDecoder.readBoolean()) {
              if (i < 6) {
                skipScalingList(16, expGolombDecoder);
              } else {
                skipScalingList(64, expGolombDecoder);
              }
            }
          }
        }
      }
      expGolombDecoder.skipUnsignedExpGolomb();
      picOrderCntType = expGolombDecoder.readUnsignedExpGolomb();
      if (picOrderCntType === 0) {
        expGolombDecoder.readUnsignedExpGolomb();
      } else if (picOrderCntType === 1) {
        expGolombDecoder.skipBits(1);
        expGolombDecoder.skipExpGolomb();
        expGolombDecoder.skipExpGolomb();
        numRefFramesInPicOrderCntCycle = expGolombDecoder.readUnsignedExpGolomb();
        for (i = 0; i < numRefFramesInPicOrderCntCycle; i++) {
          expGolombDecoder.skipExpGolomb();
        }
      }
      expGolombDecoder.skipUnsignedExpGolomb();
      expGolombDecoder.skipBits(1);
      picWidthInMbsMinus1 = expGolombDecoder.readUnsignedExpGolomb();
      picHeightInMapUnitsMinus1 = expGolombDecoder.readUnsignedExpGolomb();
      frameMbsOnlyFlag = expGolombDecoder.readBits(1);
      if (frameMbsOnlyFlag === 0) {
        expGolombDecoder.skipBits(1);
      }
      expGolombDecoder.skipBits(1);
      if (expGolombDecoder.readBoolean()) {
        frameCropLeftOffset = expGolombDecoder.readUnsignedExpGolomb();
        frameCropRightOffset = expGolombDecoder.readUnsignedExpGolomb();
        frameCropTopOffset = expGolombDecoder.readUnsignedExpGolomb();
        frameCropBottomOffset = expGolombDecoder.readUnsignedExpGolomb();
      }
      if (expGolombDecoder.readBoolean()) {
        if (expGolombDecoder.readBoolean()) {
          aspectRatioIdc = expGolombDecoder.readUnsignedByte();
          switch (aspectRatioIdc) {
            case 1:
              sarRatio = [1, 1];
              break;
            case 2:
              sarRatio = [12, 11];
              break;
            case 3:
              sarRatio = [10, 11];
              break;
            case 4:
              sarRatio = [16, 11];
              break;
            case 5:
              sarRatio = [40, 33];
              break;
            case 6:
              sarRatio = [24, 11];
              break;
            case 7:
              sarRatio = [20, 11];
              break;
            case 8:
              sarRatio = [32, 11];
              break;
            case 9:
              sarRatio = [80, 33];
              break;
            case 10:
              sarRatio = [18, 11];
              break;
            case 11:
              sarRatio = [15, 11];
              break;
            case 12:
              sarRatio = [64, 33];
              break;
            case 13:
              sarRatio = [160, 99];
              break;
            case 14:
              sarRatio = [4, 3];
              break;
            case 15:
              sarRatio = [3, 2];
              break;
            case 16:
              sarRatio = [2, 1];
              break;
            case 255: {
              sarRatio = [expGolombDecoder.readUnsignedByte() << 8 | expGolombDecoder.readUnsignedByte(), expGolombDecoder.readUnsignedByte() << 8 | expGolombDecoder.readUnsignedByte()];
              break;
            }
          }
          if (sarRatio) {
            sarRatio[0] / sarRatio[1];
          }
        }
      }
      return {
        profileIdc,
        levelIdc,
        profileCompatibility,
        width: (picWidthInMbsMinus1 + 1) * 16 - frameCropLeftOffset * 2 - frameCropRightOffset * 2,
        height: (2 - frameMbsOnlyFlag) * (picHeightInMapUnitsMinus1 + 1) * 16 - frameCropTopOffset * 2 - frameCropBottomOffset * 2,
        sarRatio
      };
    };
  };
  H264Stream$1.prototype = new Stream$2();
  var h264 = {
    H264Stream: H264Stream$1,
    NalByteStream
  };
  var ADTS_SAMPLING_FREQUENCIES = [96e3, 88200, 64e3, 48e3, 44100, 32e3, 24e3, 22050, 16e3, 12e3, 11025, 8e3, 7350];
  var parseId3TagSize = function(header, byteIndex) {
    var returnSize = header[byteIndex + 6] << 21 | header[byteIndex + 7] << 14 | header[byteIndex + 8] << 7 | header[byteIndex + 9], flags = header[byteIndex + 5], footerPresent = (flags & 16) >> 4;
    returnSize = returnSize >= 0 ? returnSize : 0;
    if (footerPresent) {
      return returnSize + 20;
    }
    return returnSize + 10;
  };
  var getId3Offset2 = function(data, offset) {
    if (data.length - offset < 10 || data[offset] !== "I".charCodeAt(0) || data[offset + 1] !== "D".charCodeAt(0) || data[offset + 2] !== "3".charCodeAt(0)) {
      return offset;
    }
    offset += parseId3TagSize(data, offset);
    return getId3Offset2(data, offset);
  };
  var isLikelyAacData$1 = function(data) {
    var offset = getId3Offset2(data, 0);
    return data.length >= offset + 2 && (data[offset] & 255) === 255 && (data[offset + 1] & 240) === 240 && (data[offset + 1] & 22) === 16;
  };
  var parseSyncSafeInteger = function(data) {
    return data[0] << 21 | data[1] << 14 | data[2] << 7 | data[3];
  };
  var percentEncode = function(bytes, start, end) {
    var i, result = "";
    for (i = start; i < end; i++) {
      result += "%" + ("00" + bytes[i].toString(16)).slice(-2);
    }
    return result;
  };
  var parseIso88591 = function(bytes, start, end) {
    return unescape(percentEncode(bytes, start, end));
  };
  var parseAdtsSize = function(header, byteIndex) {
    var lowThree = (header[byteIndex + 5] & 224) >> 5, middle = header[byteIndex + 4] << 3, highTwo = header[byteIndex + 3] & 3 << 11;
    return highTwo | middle | lowThree;
  };
  var parseType$5 = function(header, byteIndex) {
    if (header[byteIndex] === "I".charCodeAt(0) && header[byteIndex + 1] === "D".charCodeAt(0) && header[byteIndex + 2] === "3".charCodeAt(0)) {
      return "timed-metadata";
    } else if (header[byteIndex] & true && (header[byteIndex + 1] & 240) === 240) {
      return "audio";
    }
    return null;
  };
  var parseSampleRate = function(packet) {
    var i = 0;
    while (i + 5 < packet.length) {
      if (packet[i] !== 255 || (packet[i + 1] & 246) !== 240) {
        i++;
        continue;
      }
      return ADTS_SAMPLING_FREQUENCIES[(packet[i + 2] & 60) >>> 2];
    }
    return null;
  };
  var parseAacTimestamp = function(packet) {
    var frameStart, frameSize, frame, frameHeader;
    frameStart = 10;
    if (packet[5] & 64) {
      frameStart += 4;
      frameStart += parseSyncSafeInteger(packet.subarray(10, 14));
    }
    do {
      frameSize = parseSyncSafeInteger(packet.subarray(frameStart + 4, frameStart + 8));
      if (frameSize < 1) {
        return null;
      }
      frameHeader = String.fromCharCode(packet[frameStart], packet[frameStart + 1], packet[frameStart + 2], packet[frameStart + 3]);
      if (frameHeader === "PRIV") {
        frame = packet.subarray(frameStart + 10, frameStart + frameSize + 10);
        for (var i = 0; i < frame.byteLength; i++) {
          if (frame[i] === 0) {
            var owner = parseIso88591(frame, 0, i);
            if (owner === "com.apple.streaming.transportStreamTimestamp") {
              var d = frame.subarray(i + 1);
              var size = (d[3] & 1) << 30 | d[4] << 22 | d[5] << 14 | d[6] << 6 | d[7] >>> 2;
              size *= 4;
              size += d[7] & 3;
              return size;
            }
            break;
          }
        }
      }
      frameStart += 10;
      frameStart += frameSize;
    } while (frameStart < packet.byteLength);
    return null;
  };
  var utils2 = {
    isLikelyAacData: isLikelyAacData$1,
    parseId3TagSize,
    parseAdtsSize,
    parseType: parseType$5,
    parseSampleRate,
    parseAacTimestamp
  };
  var Stream$1 = stream;
  var aacUtils = utils2;
  var AacStream$1;
  AacStream$1 = function() {
    var everything = new Uint8Array(), timeStamp = 0;
    AacStream$1.prototype.init.call(this);
    this.setTimestamp = function(timestamp) {
      timeStamp = timestamp;
    };
    this.push = function(bytes) {
      var frameSize = 0, byteIndex = 0, bytesLeft, chunk, packet, tempLength;
      if (everything.length) {
        tempLength = everything.length;
        everything = new Uint8Array(bytes.byteLength + tempLength);
        everything.set(everything.subarray(0, tempLength));
        everything.set(bytes, tempLength);
      } else {
        everything = bytes;
      }
      while (everything.length - byteIndex >= 3) {
        if (everything[byteIndex] === "I".charCodeAt(0) && everything[byteIndex + 1] === "D".charCodeAt(0) && everything[byteIndex + 2] === "3".charCodeAt(0)) {
          if (everything.length - byteIndex < 10) {
            break;
          }
          frameSize = aacUtils.parseId3TagSize(everything, byteIndex);
          if (byteIndex + frameSize > everything.length) {
            break;
          }
          chunk = {
            type: "timed-metadata",
            data: everything.subarray(byteIndex, byteIndex + frameSize)
          };
          this.trigger("data", chunk);
          byteIndex += frameSize;
          continue;
        } else if ((everything[byteIndex] & 255) === 255 && (everything[byteIndex + 1] & 240) === 240) {
          if (everything.length - byteIndex < 7) {
            break;
          }
          frameSize = aacUtils.parseAdtsSize(everything, byteIndex);
          if (byteIndex + frameSize > everything.length) {
            break;
          }
          packet = {
            type: "audio",
            data: everything.subarray(byteIndex, byteIndex + frameSize),
            pts: timeStamp,
            dts: timeStamp
          };
          this.trigger("data", packet);
          byteIndex += frameSize;
          continue;
        }
        byteIndex++;
      }
      bytesLeft = everything.length - byteIndex;
      if (bytesLeft > 0) {
        everything = everything.subarray(byteIndex);
      } else {
        everything = new Uint8Array();
      }
    };
    this.reset = function() {
      everything = new Uint8Array();
      this.trigger("reset");
    };
    this.endTimeline = function() {
      everything = new Uint8Array();
      this.trigger("endedtimeline");
    };
  };
  AacStream$1.prototype = new Stream$1();
  var aac = AacStream$1;
  var AUDIO_PROPERTIES$1 = ["audioobjecttype", "channelcount", "samplerate", "samplingfrequencyindex", "samplesize"];
  var audioProperties = AUDIO_PROPERTIES$1;
  var VIDEO_PROPERTIES$1 = ["width", "height", "profileIdc", "levelIdc", "profileCompatibility", "sarRatio"];
  var videoProperties = VIDEO_PROPERTIES$1;
  var Stream = stream;
  var mp4 = mp4Generator;
  var frameUtils = frameUtils$1;
  var audioFrameUtils = audioFrameUtils$1;
  var trackDecodeInfo = trackDecodeInfo$1;
  var m2ts = m2ts_1;
  var clock2 = clock$2;
  var AdtsStream = adts;
  var H264Stream = h264.H264Stream;
  var AacStream = aac;
  var isLikelyAacData = utils2.isLikelyAacData;
  var ONE_SECOND_IN_TS$1 = clock$2.ONE_SECOND_IN_TS;
  var AUDIO_PROPERTIES = audioProperties;
  var VIDEO_PROPERTIES = videoProperties;
  var VideoSegmentStream, AudioSegmentStream, Transmuxer, CoalesceStream;
  var retriggerForStream = function(key, event) {
    event.stream = key;
    this.trigger("log", event);
  };
  var addPipelineLogRetriggers = function(transmuxer2, pipeline) {
    var keys2 = Object.keys(pipeline);
    for (var i = 0; i < keys2.length; i++) {
      var key = keys2[i];
      if (key === "headOfPipeline" || !pipeline[key].on) {
        continue;
      }
      pipeline[key].on("log", retriggerForStream.bind(transmuxer2, key));
    }
  };
  var arrayEquals = function(a, b) {
    var i;
    if (a.length !== b.length) {
      return false;
    }
    for (i = 0; i < a.length; i++) {
      if (a[i] !== b[i]) {
        return false;
      }
    }
    return true;
  };
  var generateSegmentTimingInfo = function(baseMediaDecodeTime, startDts, startPts, endDts, endPts, prependedContentDuration) {
    var ptsOffsetFromDts = startPts - startDts, decodeDuration = endDts - startDts, presentationDuration = endPts - startPts;
    return {
      start: {
        dts: baseMediaDecodeTime,
        pts: baseMediaDecodeTime + ptsOffsetFromDts
      },
      end: {
        dts: baseMediaDecodeTime + decodeDuration,
        pts: baseMediaDecodeTime + presentationDuration
      },
      prependedContentDuration,
      baseMediaDecodeTime
    };
  };
  AudioSegmentStream = function(track, options) {
    var adtsFrames = [], sequenceNumber, earliestAllowedDts = 0, audioAppendStartTs = 0, videoBaseMediaDecodeTime = Infinity;
    options = options || {};
    sequenceNumber = options.firstSequenceNumber || 0;
    AudioSegmentStream.prototype.init.call(this);
    this.push = function(data) {
      trackDecodeInfo.collectDtsInfo(track, data);
      if (track) {
        AUDIO_PROPERTIES.forEach(function(prop) {
          track[prop] = data[prop];
        });
      }
      adtsFrames.push(data);
    };
    this.setEarliestDts = function(earliestDts) {
      earliestAllowedDts = earliestDts;
    };
    this.setVideoBaseMediaDecodeTime = function(baseMediaDecodeTime) {
      videoBaseMediaDecodeTime = baseMediaDecodeTime;
    };
    this.setAudioAppendStart = function(timestamp) {
      audioAppendStartTs = timestamp;
    };
    this.flush = function() {
      var frames, moof2, mdat2, boxes, frameDuration, segmentDuration, videoClockCyclesOfSilencePrefixed;
      if (adtsFrames.length === 0) {
        this.trigger("done", "AudioSegmentStream");
        return;
      }
      frames = audioFrameUtils.trimAdtsFramesByEarliestDts(adtsFrames, track, earliestAllowedDts);
      track.baseMediaDecodeTime = trackDecodeInfo.calculateTrackBaseMediaDecodeTime(track, options.keepOriginalTimestamps);
      videoClockCyclesOfSilencePrefixed = audioFrameUtils.prefixWithSilence(track, frames, audioAppendStartTs, videoBaseMediaDecodeTime);
      track.samples = audioFrameUtils.generateSampleTable(frames);
      mdat2 = mp4.mdat(audioFrameUtils.concatenateFrameData(frames));
      adtsFrames = [];
      moof2 = mp4.moof(sequenceNumber, [track]);
      boxes = new Uint8Array(moof2.byteLength + mdat2.byteLength);
      sequenceNumber++;
      boxes.set(moof2);
      boxes.set(mdat2, moof2.byteLength);
      trackDecodeInfo.clearDtsInfo(track);
      frameDuration = Math.ceil(ONE_SECOND_IN_TS$1 * 1024 / track.samplerate);
      if (frames.length) {
        segmentDuration = frames.length * frameDuration;
        this.trigger("segmentTimingInfo", generateSegmentTimingInfo(
          clock2.audioTsToVideoTs(track.baseMediaDecodeTime, track.samplerate),
          frames[0].dts,
          frames[0].pts,
          frames[0].dts + segmentDuration,
          frames[0].pts + segmentDuration,
          videoClockCyclesOfSilencePrefixed || 0
        ));
        this.trigger("timingInfo", {
          start: frames[0].pts,
          end: frames[0].pts + segmentDuration
        });
      }
      this.trigger("data", {
        track,
        boxes
      });
      this.trigger("done", "AudioSegmentStream");
    };
    this.reset = function() {
      trackDecodeInfo.clearDtsInfo(track);
      adtsFrames = [];
      this.trigger("reset");
    };
  };
  AudioSegmentStream.prototype = new Stream();
  VideoSegmentStream = function(track, options) {
    var sequenceNumber, nalUnits = [], gopsToAlignWith = [], config, pps;
    options = options || {};
    sequenceNumber = options.firstSequenceNumber || 0;
    VideoSegmentStream.prototype.init.call(this);
    delete track.minPTS;
    this.gopCache_ = [];
    this.push = function(nalUnit) {
      trackDecodeInfo.collectDtsInfo(track, nalUnit);
      if (nalUnit.nalUnitType === "seq_parameter_set_rbsp" && !config) {
        config = nalUnit.config;
        track.sps = [nalUnit.data];
        VIDEO_PROPERTIES.forEach(function(prop) {
          track[prop] = config[prop];
        }, this);
      }
      if (nalUnit.nalUnitType === "pic_parameter_set_rbsp" && !pps) {
        pps = nalUnit.data;
        track.pps = [nalUnit.data];
      }
      nalUnits.push(nalUnit);
    };
    this.flush = function() {
      var frames, gopForFusion, gops, moof2, mdat2, boxes, prependedContentDuration = 0, firstGop, lastGop;
      while (nalUnits.length) {
        if (nalUnits[0].nalUnitType === "access_unit_delimiter_rbsp") {
          break;
        }
        nalUnits.shift();
      }
      if (nalUnits.length === 0) {
        this.resetStream_();
        this.trigger("done", "VideoSegmentStream");
        return;
      }
      frames = frameUtils.groupNalsIntoFrames(nalUnits);
      gops = frameUtils.groupFramesIntoGops(frames);
      if (!gops[0][0].keyFrame) {
        gopForFusion = this.getGopForFusion_(nalUnits[0], track);
        if (gopForFusion) {
          prependedContentDuration = gopForFusion.duration;
          gops.unshift(gopForFusion);
          gops.byteLength += gopForFusion.byteLength;
          gops.nalCount += gopForFusion.nalCount;
          gops.pts = gopForFusion.pts;
          gops.dts = gopForFusion.dts;
          gops.duration += gopForFusion.duration;
        } else {
          gops = frameUtils.extendFirstKeyFrame(gops);
        }
      }
      if (gopsToAlignWith.length) {
        var alignedGops;
        if (options.alignGopsAtEnd) {
          alignedGops = this.alignGopsAtEnd_(gops);
        } else {
          alignedGops = this.alignGopsAtStart_(gops);
        }
        if (!alignedGops) {
          this.gopCache_.unshift({
            gop: gops.pop(),
            pps: track.pps,
            sps: track.sps
          });
          this.gopCache_.length = Math.min(6, this.gopCache_.length);
          nalUnits = [];
          this.resetStream_();
          this.trigger("done", "VideoSegmentStream");
          return;
        }
        trackDecodeInfo.clearDtsInfo(track);
        gops = alignedGops;
      }
      trackDecodeInfo.collectDtsInfo(track, gops);
      track.samples = frameUtils.generateSampleTable(gops);
      mdat2 = mp4.mdat(frameUtils.concatenateNalData(gops));
      track.baseMediaDecodeTime = trackDecodeInfo.calculateTrackBaseMediaDecodeTime(track, options.keepOriginalTimestamps);
      this.trigger("processedGopsInfo", gops.map(function(gop) {
        return {
          pts: gop.pts,
          dts: gop.dts,
          byteLength: gop.byteLength
        };
      }));
      firstGop = gops[0];
      lastGop = gops[gops.length - 1];
      this.trigger("segmentTimingInfo", generateSegmentTimingInfo(track.baseMediaDecodeTime, firstGop.dts, firstGop.pts, lastGop.dts + lastGop.duration, lastGop.pts + lastGop.duration, prependedContentDuration));
      this.trigger("timingInfo", {
        start: gops[0].pts,
        end: gops[gops.length - 1].pts + gops[gops.length - 1].duration
      });
      this.gopCache_.unshift({
        gop: gops.pop(),
        pps: track.pps,
        sps: track.sps
      });
      this.gopCache_.length = Math.min(6, this.gopCache_.length);
      nalUnits = [];
      this.trigger("baseMediaDecodeTime", track.baseMediaDecodeTime);
      this.trigger("timelineStartInfo", track.timelineStartInfo);
      moof2 = mp4.moof(sequenceNumber, [track]);
      boxes = new Uint8Array(moof2.byteLength + mdat2.byteLength);
      sequenceNumber++;
      boxes.set(moof2);
      boxes.set(mdat2, moof2.byteLength);
      this.trigger("data", {
        track,
        boxes
      });
      this.resetStream_();
      this.trigger("done", "VideoSegmentStream");
    };
    this.reset = function() {
      this.resetStream_();
      nalUnits = [];
      this.gopCache_.length = 0;
      gopsToAlignWith.length = 0;
      this.trigger("reset");
    };
    this.resetStream_ = function() {
      trackDecodeInfo.clearDtsInfo(track);
      config = void 0;
      pps = void 0;
    };
    this.getGopForFusion_ = function(nalUnit) {
      var halfSecond = 45e3, allowableOverlap = 1e4, nearestDistance = Infinity, dtsDistance, nearestGopObj, currentGop, currentGopObj, i;
      for (i = 0; i < this.gopCache_.length; i++) {
        currentGopObj = this.gopCache_[i];
        currentGop = currentGopObj.gop;
        if (!(track.pps && arrayEquals(track.pps[0], currentGopObj.pps[0])) || !(track.sps && arrayEquals(track.sps[0], currentGopObj.sps[0]))) {
          continue;
        }
        if (currentGop.dts < track.timelineStartInfo.dts) {
          continue;
        }
        dtsDistance = nalUnit.dts - currentGop.dts - currentGop.duration;
        if (dtsDistance >= -allowableOverlap && dtsDistance <= halfSecond) {
          if (!nearestGopObj || nearestDistance > dtsDistance) {
            nearestGopObj = currentGopObj;
            nearestDistance = dtsDistance;
          }
        }
      }
      if (nearestGopObj) {
        return nearestGopObj.gop;
      }
      return null;
    };
    this.alignGopsAtStart_ = function(gops) {
      var alignIndex, gopIndex, align, gop, byteLength, nalCount, duration2, alignedGops;
      byteLength = gops.byteLength;
      nalCount = gops.nalCount;
      duration2 = gops.duration;
      alignIndex = gopIndex = 0;
      while (alignIndex < gopsToAlignWith.length && gopIndex < gops.length) {
        align = gopsToAlignWith[alignIndex];
        gop = gops[gopIndex];
        if (align.pts === gop.pts) {
          break;
        }
        if (gop.pts > align.pts) {
          alignIndex++;
          continue;
        }
        gopIndex++;
        byteLength -= gop.byteLength;
        nalCount -= gop.nalCount;
        duration2 -= gop.duration;
      }
      if (gopIndex === 0) {
        return gops;
      }
      if (gopIndex === gops.length) {
        return null;
      }
      alignedGops = gops.slice(gopIndex);
      alignedGops.byteLength = byteLength;
      alignedGops.duration = duration2;
      alignedGops.nalCount = nalCount;
      alignedGops.pts = alignedGops[0].pts;
      alignedGops.dts = alignedGops[0].dts;
      return alignedGops;
    };
    this.alignGopsAtEnd_ = function(gops) {
      var alignIndex, gopIndex, align, gop, alignEndIndex, matchFound;
      alignIndex = gopsToAlignWith.length - 1;
      gopIndex = gops.length - 1;
      alignEndIndex = null;
      matchFound = false;
      while (alignIndex >= 0 && gopIndex >= 0) {
        align = gopsToAlignWith[alignIndex];
        gop = gops[gopIndex];
        if (align.pts === gop.pts) {
          matchFound = true;
          break;
        }
        if (align.pts > gop.pts) {
          alignIndex--;
          continue;
        }
        if (alignIndex === gopsToAlignWith.length - 1) {
          alignEndIndex = gopIndex;
        }
        gopIndex--;
      }
      if (!matchFound && alignEndIndex === null) {
        return null;
      }
      var trimIndex;
      if (matchFound) {
        trimIndex = gopIndex;
      } else {
        trimIndex = alignEndIndex;
      }
      if (trimIndex === 0) {
        return gops;
      }
      var alignedGops = gops.slice(trimIndex);
      var metadata = alignedGops.reduce(function(total, gop2) {
        total.byteLength += gop2.byteLength;
        total.duration += gop2.duration;
        total.nalCount += gop2.nalCount;
        return total;
      }, {
        byteLength: 0,
        duration: 0,
        nalCount: 0
      });
      alignedGops.byteLength = metadata.byteLength;
      alignedGops.duration = metadata.duration;
      alignedGops.nalCount = metadata.nalCount;
      alignedGops.pts = alignedGops[0].pts;
      alignedGops.dts = alignedGops[0].dts;
      return alignedGops;
    };
    this.alignGopsWith = function(newGopsToAlignWith) {
      gopsToAlignWith = newGopsToAlignWith;
    };
  };
  VideoSegmentStream.prototype = new Stream();
  CoalesceStream = function(options, metadataStream2) {
    this.numberOfTracks = 0;
    this.metadataStream = metadataStream2;
    options = options || {};
    if (typeof options.remux !== "undefined") {
      this.remuxTracks = !!options.remux;
    } else {
      this.remuxTracks = true;
    }
    if (typeof options.keepOriginalTimestamps === "boolean") {
      this.keepOriginalTimestamps = options.keepOriginalTimestamps;
    } else {
      this.keepOriginalTimestamps = false;
    }
    this.pendingTracks = [];
    this.videoTrack = null;
    this.pendingBoxes = [];
    this.pendingCaptions = [];
    this.pendingMetadata = [];
    this.pendingBytes = 0;
    this.emittedTracks = 0;
    CoalesceStream.prototype.init.call(this);
    this.push = function(output) {
      if (output.content || output.text) {
        return this.pendingCaptions.push(output);
      }
      if (output.frames) {
        return this.pendingMetadata.push(output);
      }
      this.pendingTracks.push(output.track);
      this.pendingBytes += output.boxes.byteLength;
      if (output.track.type === "video") {
        this.videoTrack = output.track;
        this.pendingBoxes.push(output.boxes);
      }
      if (output.track.type === "audio") {
        this.audioTrack = output.track;
        this.pendingBoxes.unshift(output.boxes);
      }
    };
  };
  CoalesceStream.prototype = new Stream();
  CoalesceStream.prototype.flush = function(flushSource) {
    var offset = 0, event = {
      captions: [],
      captionStreams: {},
      metadata: [],
      info: {}
    }, caption, id32, initSegment, timelineStartPts = 0, i;
    if (this.pendingTracks.length < this.numberOfTracks) {
      if (flushSource !== "VideoSegmentStream" && flushSource !== "AudioSegmentStream") {
        return;
      } else if (this.remuxTracks) {
        return;
      } else if (this.pendingTracks.length === 0) {
        this.emittedTracks++;
        if (this.emittedTracks >= this.numberOfTracks) {
          this.trigger("done");
          this.emittedTracks = 0;
        }
        return;
      }
    }
    if (this.videoTrack) {
      timelineStartPts = this.videoTrack.timelineStartInfo.pts;
      VIDEO_PROPERTIES.forEach(function(prop) {
        event.info[prop] = this.videoTrack[prop];
      }, this);
    } else if (this.audioTrack) {
      timelineStartPts = this.audioTrack.timelineStartInfo.pts;
      AUDIO_PROPERTIES.forEach(function(prop) {
        event.info[prop] = this.audioTrack[prop];
      }, this);
    }
    if (this.videoTrack || this.audioTrack) {
      if (this.pendingTracks.length === 1) {
        event.type = this.pendingTracks[0].type;
      } else {
        event.type = "combined";
      }
      this.emittedTracks += this.pendingTracks.length;
      initSegment = mp4.initSegment(this.pendingTracks);
      event.initSegment = new Uint8Array(initSegment.byteLength);
      event.initSegment.set(initSegment);
      event.data = new Uint8Array(this.pendingBytes);
      for (i = 0; i < this.pendingBoxes.length; i++) {
        event.data.set(this.pendingBoxes[i], offset);
        offset += this.pendingBoxes[i].byteLength;
      }
      for (i = 0; i < this.pendingCaptions.length; i++) {
        caption = this.pendingCaptions[i];
        caption.startTime = clock2.metadataTsToSeconds(caption.startPts, timelineStartPts, this.keepOriginalTimestamps);
        caption.endTime = clock2.metadataTsToSeconds(caption.endPts, timelineStartPts, this.keepOriginalTimestamps);
        event.captionStreams[caption.stream] = true;
        event.captions.push(caption);
      }
      for (i = 0; i < this.pendingMetadata.length; i++) {
        id32 = this.pendingMetadata[i];
        id32.cueTime = clock2.metadataTsToSeconds(id32.pts, timelineStartPts, this.keepOriginalTimestamps);
        event.metadata.push(id32);
      }
      event.metadata.dispatchType = this.metadataStream.dispatchType;
      this.pendingTracks.length = 0;
      this.videoTrack = null;
      this.pendingBoxes.length = 0;
      this.pendingCaptions.length = 0;
      this.pendingBytes = 0;
      this.pendingMetadata.length = 0;
      this.trigger("data", event);
      for (i = 0; i < event.captions.length; i++) {
        caption = event.captions[i];
        this.trigger("caption", caption);
      }
      for (i = 0; i < event.metadata.length; i++) {
        id32 = event.metadata[i];
        this.trigger("id3Frame", id32);
      }
    }
    if (this.emittedTracks >= this.numberOfTracks) {
      this.trigger("done");
      this.emittedTracks = 0;
    }
  };
  CoalesceStream.prototype.setRemux = function(val) {
    this.remuxTracks = val;
  };
  Transmuxer = function(options) {
    var self2 = this, hasFlushed = true, videoTrack, audioTrack;
    Transmuxer.prototype.init.call(this);
    options = options || {};
    this.baseMediaDecodeTime = options.baseMediaDecodeTime || 0;
    this.transmuxPipeline_ = {};
    this.setupAacPipeline = function() {
      var pipeline = {};
      this.transmuxPipeline_ = pipeline;
      pipeline.type = "aac";
      pipeline.metadataStream = new m2ts.MetadataStream();
      pipeline.aacStream = new AacStream();
      pipeline.audioTimestampRolloverStream = new m2ts.TimestampRolloverStream("audio");
      pipeline.timedMetadataTimestampRolloverStream = new m2ts.TimestampRolloverStream("timed-metadata");
      pipeline.adtsStream = new AdtsStream();
      pipeline.coalesceStream = new CoalesceStream(options, pipeline.metadataStream);
      pipeline.headOfPipeline = pipeline.aacStream;
      pipeline.aacStream.pipe(pipeline.audioTimestampRolloverStream).pipe(pipeline.adtsStream);
      pipeline.aacStream.pipe(pipeline.timedMetadataTimestampRolloverStream).pipe(pipeline.metadataStream).pipe(pipeline.coalesceStream);
      pipeline.metadataStream.on("timestamp", function(frame) {
        pipeline.aacStream.setTimestamp(frame.timeStamp);
      });
      pipeline.aacStream.on("data", function(data) {
        if (data.type !== "timed-metadata" && data.type !== "audio" || pipeline.audioSegmentStream) {
          return;
        }
        audioTrack = audioTrack || {
          timelineStartInfo: {
            baseMediaDecodeTime: self2.baseMediaDecodeTime
          },
          codec: "adts",
          type: "audio"
        };
        pipeline.coalesceStream.numberOfTracks++;
        pipeline.audioSegmentStream = new AudioSegmentStream(audioTrack, options);
        pipeline.audioSegmentStream.on("log", self2.getLogTrigger_("audioSegmentStream"));
        pipeline.audioSegmentStream.on("timingInfo", self2.trigger.bind(self2, "audioTimingInfo"));
        pipeline.adtsStream.pipe(pipeline.audioSegmentStream).pipe(pipeline.coalesceStream);
        self2.trigger("trackinfo", {
          hasAudio: !!audioTrack,
          hasVideo: !!videoTrack
        });
      });
      pipeline.coalesceStream.on("data", this.trigger.bind(this, "data"));
      pipeline.coalesceStream.on("done", this.trigger.bind(this, "done"));
      addPipelineLogRetriggers(this, pipeline);
    };
    this.setupTsPipeline = function() {
      var pipeline = {};
      this.transmuxPipeline_ = pipeline;
      pipeline.type = "ts";
      pipeline.metadataStream = new m2ts.MetadataStream();
      pipeline.packetStream = new m2ts.TransportPacketStream();
      pipeline.parseStream = new m2ts.TransportParseStream();
      pipeline.elementaryStream = new m2ts.ElementaryStream();
      pipeline.timestampRolloverStream = new m2ts.TimestampRolloverStream();
      pipeline.adtsStream = new AdtsStream();
      pipeline.h264Stream = new H264Stream();
      pipeline.captionStream = new m2ts.CaptionStream(options);
      pipeline.coalesceStream = new CoalesceStream(options, pipeline.metadataStream);
      pipeline.headOfPipeline = pipeline.packetStream;
      pipeline.packetStream.pipe(pipeline.parseStream).pipe(pipeline.elementaryStream).pipe(pipeline.timestampRolloverStream);
      pipeline.timestampRolloverStream.pipe(pipeline.h264Stream);
      pipeline.timestampRolloverStream.pipe(pipeline.adtsStream);
      pipeline.timestampRolloverStream.pipe(pipeline.metadataStream).pipe(pipeline.coalesceStream);
      pipeline.h264Stream.pipe(pipeline.captionStream).pipe(pipeline.coalesceStream);
      pipeline.elementaryStream.on("data", function(data) {
        var i;
        if (data.type === "metadata") {
          i = data.tracks.length;
          while (i--) {
            if (!videoTrack && data.tracks[i].type === "video") {
              videoTrack = data.tracks[i];
              videoTrack.timelineStartInfo.baseMediaDecodeTime = self2.baseMediaDecodeTime;
            } else if (!audioTrack && data.tracks[i].type === "audio") {
              audioTrack = data.tracks[i];
              audioTrack.timelineStartInfo.baseMediaDecodeTime = self2.baseMediaDecodeTime;
            }
          }
          if (videoTrack && !pipeline.videoSegmentStream) {
            pipeline.coalesceStream.numberOfTracks++;
            pipeline.videoSegmentStream = new VideoSegmentStream(videoTrack, options);
            pipeline.videoSegmentStream.on("log", self2.getLogTrigger_("videoSegmentStream"));
            pipeline.videoSegmentStream.on("timelineStartInfo", function(timelineStartInfo) {
              if (audioTrack && !options.keepOriginalTimestamps) {
                audioTrack.timelineStartInfo = timelineStartInfo;
                pipeline.audioSegmentStream.setEarliestDts(timelineStartInfo.dts - self2.baseMediaDecodeTime);
              }
            });
            pipeline.videoSegmentStream.on("processedGopsInfo", self2.trigger.bind(self2, "gopInfo"));
            pipeline.videoSegmentStream.on("segmentTimingInfo", self2.trigger.bind(self2, "videoSegmentTimingInfo"));
            pipeline.videoSegmentStream.on("baseMediaDecodeTime", function(baseMediaDecodeTime) {
              if (audioTrack) {
                pipeline.audioSegmentStream.setVideoBaseMediaDecodeTime(baseMediaDecodeTime);
              }
            });
            pipeline.videoSegmentStream.on("timingInfo", self2.trigger.bind(self2, "videoTimingInfo"));
            pipeline.h264Stream.pipe(pipeline.videoSegmentStream).pipe(pipeline.coalesceStream);
          }
          if (audioTrack && !pipeline.audioSegmentStream) {
            pipeline.coalesceStream.numberOfTracks++;
            pipeline.audioSegmentStream = new AudioSegmentStream(audioTrack, options);
            pipeline.audioSegmentStream.on("log", self2.getLogTrigger_("audioSegmentStream"));
            pipeline.audioSegmentStream.on("timingInfo", self2.trigger.bind(self2, "audioTimingInfo"));
            pipeline.audioSegmentStream.on("segmentTimingInfo", self2.trigger.bind(self2, "audioSegmentTimingInfo"));
            pipeline.adtsStream.pipe(pipeline.audioSegmentStream).pipe(pipeline.coalesceStream);
          }
          self2.trigger("trackinfo", {
            hasAudio: !!audioTrack,
            hasVideo: !!videoTrack
          });
        }
      });
      pipeline.coalesceStream.on("data", this.trigger.bind(this, "data"));
      pipeline.coalesceStream.on("id3Frame", function(id3Frame) {
        id3Frame.dispatchType = pipeline.metadataStream.dispatchType;
        self2.trigger("id3Frame", id3Frame);
      });
      pipeline.coalesceStream.on("caption", this.trigger.bind(this, "caption"));
      pipeline.coalesceStream.on("done", this.trigger.bind(this, "done"));
      addPipelineLogRetriggers(this, pipeline);
    };
    this.setBaseMediaDecodeTime = function(baseMediaDecodeTime) {
      var pipeline = this.transmuxPipeline_;
      if (!options.keepOriginalTimestamps) {
        this.baseMediaDecodeTime = baseMediaDecodeTime;
      }
      if (audioTrack) {
        audioTrack.timelineStartInfo.dts = void 0;
        audioTrack.timelineStartInfo.pts = void 0;
        trackDecodeInfo.clearDtsInfo(audioTrack);
        if (pipeline.audioTimestampRolloverStream) {
          pipeline.audioTimestampRolloverStream.discontinuity();
        }
      }
      if (videoTrack) {
        if (pipeline.videoSegmentStream) {
          pipeline.videoSegmentStream.gopCache_ = [];
        }
        videoTrack.timelineStartInfo.dts = void 0;
        videoTrack.timelineStartInfo.pts = void 0;
        trackDecodeInfo.clearDtsInfo(videoTrack);
        pipeline.captionStream.reset();
      }
      if (pipeline.timestampRolloverStream) {
        pipeline.timestampRolloverStream.discontinuity();
      }
    };
    this.setAudioAppendStart = function(timestamp) {
      if (audioTrack) {
        this.transmuxPipeline_.audioSegmentStream.setAudioAppendStart(timestamp);
      }
    };
    this.setRemux = function(val) {
      var pipeline = this.transmuxPipeline_;
      options.remux = val;
      if (pipeline && pipeline.coalesceStream) {
        pipeline.coalesceStream.setRemux(val);
      }
    };
    this.alignGopsWith = function(gopsToAlignWith) {
      if (videoTrack && this.transmuxPipeline_.videoSegmentStream) {
        this.transmuxPipeline_.videoSegmentStream.alignGopsWith(gopsToAlignWith);
      }
    };
    this.getLogTrigger_ = function(key) {
      var self3 = this;
      return function(event) {
        event.stream = key;
        self3.trigger("log", event);
      };
    };
    this.push = function(data) {
      if (hasFlushed) {
        var isAac = isLikelyAacData(data);
        if (isAac && this.transmuxPipeline_.type !== "aac") {
          this.setupAacPipeline();
        } else if (!isAac && this.transmuxPipeline_.type !== "ts") {
          this.setupTsPipeline();
        }
        hasFlushed = false;
      }
      this.transmuxPipeline_.headOfPipeline.push(data);
    };
    this.flush = function() {
      hasFlushed = true;
      this.transmuxPipeline_.headOfPipeline.flush();
    };
    this.endTimeline = function() {
      this.transmuxPipeline_.headOfPipeline.endTimeline();
    };
    this.reset = function() {
      if (this.transmuxPipeline_.headOfPipeline) {
        this.transmuxPipeline_.headOfPipeline.reset();
      }
    };
    this.resetCaptions = function() {
      if (this.transmuxPipeline_.captionStream) {
        this.transmuxPipeline_.captionStream.reset();
      }
    };
  };
  Transmuxer.prototype = new Stream();
  var transmuxer = {
    Transmuxer,
    VideoSegmentStream,
    AudioSegmentStream,
    AUDIO_PROPERTIES,
    VIDEO_PROPERTIES,
    generateSegmentTimingInfo
  };
  var toUnsigned$3 = function(value) {
    return value >>> 0;
  };
  var toHexString$1 = function(value) {
    return ("00" + value.toString(16)).slice(-2);
  };
  var bin = {
    toUnsigned: toUnsigned$3,
    toHexString: toHexString$1
  };
  var parseType$4 = function(buffer) {
    var result = "";
    result += String.fromCharCode(buffer[0]);
    result += String.fromCharCode(buffer[1]);
    result += String.fromCharCode(buffer[2]);
    result += String.fromCharCode(buffer[3]);
    return result;
  };
  var parseType_1 = parseType$4;
  var toUnsigned$2 = bin.toUnsigned;
  var parseType$3 = parseType_1;
  var findBox$5 = function(data, path) {
    var results = [], i, size, type2, end, subresults;
    if (!path.length) {
      return null;
    }
    for (i = 0; i < data.byteLength; ) {
      size = toUnsigned$2(data[i] << 24 | data[i + 1] << 16 | data[i + 2] << 8 | data[i + 3]);
      type2 = parseType$3(data.subarray(i + 4, i + 8));
      end = size > 1 ? i + size : data.byteLength;
      if (type2 === path[0]) {
        if (path.length === 1) {
          results.push(data.subarray(i + 8, end));
        } else {
          subresults = findBox$5(data.subarray(i + 8, end), path.slice(1));
          if (subresults.length) {
            results = results.concat(subresults);
          }
        }
      }
      i = end;
    }
    return results;
  };
  var findBox_1 = findBox$5;
  var toUnsigned$1 = bin.toUnsigned;
  var getUint64$4 = numbers.getUint64;
  var tfdt = function(data) {
    var result = {
      version: data[0],
      flags: new Uint8Array(data.subarray(1, 4))
    };
    if (result.version === 1) {
      result.baseMediaDecodeTime = getUint64$4(data.subarray(4));
    } else {
      result.baseMediaDecodeTime = toUnsigned$1(data[4] << 24 | data[5] << 16 | data[6] << 8 | data[7]);
    }
    return result;
  };
  var parseTfdt$3 = tfdt;
  var tfhd = function(data) {
    var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
      version: data[0],
      flags: new Uint8Array(data.subarray(1, 4)),
      trackId: view.getUint32(4)
    }, baseDataOffsetPresent = result.flags[2] & 1, sampleDescriptionIndexPresent = result.flags[2] & 2, defaultSampleDurationPresent = result.flags[2] & 8, defaultSampleSizePresent = result.flags[2] & 16, defaultSampleFlagsPresent = result.flags[2] & 32, durationIsEmpty = result.flags[0] & 65536, defaultBaseIsMoof = result.flags[0] & 131072, i;
    i = 8;
    if (baseDataOffsetPresent) {
      i += 4;
      result.baseDataOffset = view.getUint32(12);
      i += 4;
    }
    if (sampleDescriptionIndexPresent) {
      result.sampleDescriptionIndex = view.getUint32(i);
      i += 4;
    }
    if (defaultSampleDurationPresent) {
      result.defaultSampleDuration = view.getUint32(i);
      i += 4;
    }
    if (defaultSampleSizePresent) {
      result.defaultSampleSize = view.getUint32(i);
      i += 4;
    }
    if (defaultSampleFlagsPresent) {
      result.defaultSampleFlags = view.getUint32(i);
    }
    if (durationIsEmpty) {
      result.durationIsEmpty = true;
    }
    if (!baseDataOffsetPresent && defaultBaseIsMoof) {
      result.baseDataOffsetIsMoof = true;
    }
    return result;
  };
  var parseTfhd$2 = tfhd;
  var getUint64$3 = numbers.getUint64;
  var parseSidx = function(data) {
    var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
      version: data[0],
      flags: new Uint8Array(data.subarray(1, 4)),
      references: [],
      referenceId: view.getUint32(4),
      timescale: view.getUint32(8)
    }, i = 12;
    if (result.version === 0) {
      result.earliestPresentationTime = view.getUint32(i);
      result.firstOffset = view.getUint32(i + 4);
      i += 8;
    } else {
      result.earliestPresentationTime = getUint64$3(data.subarray(i));
      result.firstOffset = getUint64$3(data.subarray(i + 8));
      i += 16;
    }
    i += 2;
    var referenceCount = view.getUint16(i);
    i += 2;
    for (; referenceCount > 0; i += 12, referenceCount--) {
      result.references.push({
        referenceType: (data[i] & 128) >>> 7,
        referencedSize: view.getUint32(i) & 2147483647,
        subsegmentDuration: view.getUint32(i + 4),
        startsWithSap: !!(data[i + 8] & 128),
        sapType: (data[i + 8] & 112) >>> 4,
        sapDeltaTime: view.getUint32(i + 8) & 268435455
      });
    }
    return result;
  };
  var parseSidx_12 = parseSidx;
  var parseSampleFlags$1 = function(flags) {
    return {
      isLeading: (flags[0] & 12) >>> 2,
      dependsOn: flags[0] & 3,
      isDependedOn: (flags[1] & 192) >>> 6,
      hasRedundancy: (flags[1] & 48) >>> 4,
      paddingValue: (flags[1] & 14) >>> 1,
      isNonSyncSample: flags[1] & 1,
      degradationPriority: flags[2] << 8 | flags[3]
    };
  };
  var parseSampleFlags_1 = parseSampleFlags$1;
  var parseSampleFlags = parseSampleFlags_1;
  var trun = function(data) {
    var result = {
      version: data[0],
      flags: new Uint8Array(data.subarray(1, 4)),
      samples: []
    }, view = new DataView(data.buffer, data.byteOffset, data.byteLength), dataOffsetPresent = result.flags[2] & 1, firstSampleFlagsPresent = result.flags[2] & 4, sampleDurationPresent = result.flags[1] & 1, sampleSizePresent = result.flags[1] & 2, sampleFlagsPresent = result.flags[1] & 4, sampleCompositionTimeOffsetPresent = result.flags[1] & 8, sampleCount = view.getUint32(4), offset = 8, sample;
    if (dataOffsetPresent) {
      result.dataOffset = view.getInt32(offset);
      offset += 4;
    }
    if (firstSampleFlagsPresent && sampleCount) {
      sample = {
        flags: parseSampleFlags(data.subarray(offset, offset + 4))
      };
      offset += 4;
      if (sampleDurationPresent) {
        sample.duration = view.getUint32(offset);
        offset += 4;
      }
      if (sampleSizePresent) {
        sample.size = view.getUint32(offset);
        offset += 4;
      }
      if (sampleCompositionTimeOffsetPresent) {
        if (result.version === 1) {
          sample.compositionTimeOffset = view.getInt32(offset);
        } else {
          sample.compositionTimeOffset = view.getUint32(offset);
        }
        offset += 4;
      }
      result.samples.push(sample);
      sampleCount--;
    }
    while (sampleCount--) {
      sample = {};
      if (sampleDurationPresent) {
        sample.duration = view.getUint32(offset);
        offset += 4;
      }
      if (sampleSizePresent) {
        sample.size = view.getUint32(offset);
        offset += 4;
      }
      if (sampleFlagsPresent) {
        sample.flags = parseSampleFlags(data.subarray(offset, offset + 4));
        offset += 4;
      }
      if (sampleCompositionTimeOffsetPresent) {
        if (result.version === 1) {
          sample.compositionTimeOffset = view.getInt32(offset);
        } else {
          sample.compositionTimeOffset = view.getUint32(offset);
        }
        offset += 4;
      }
      result.samples.push(sample);
    }
    return result;
  };
  var parseTrun$2 = trun;
  var numberHelpers = numbers;
  var getUint64$2 = numberHelpers.getUint64;
  var inspectMp4, textifyMp4, parseMp4Date = function(seconds) {
    return new Date(seconds * 1e3 - 20828448e5);
  }, parseType$2 = parseType_1, findBox$4 = findBox_1, nalParse = function(avcStream) {
    var avcView = new DataView(avcStream.buffer, avcStream.byteOffset, avcStream.byteLength), result = [], i, length;
    for (i = 0; i + 4 < avcStream.length; i += length) {
      length = avcView.getUint32(i);
      i += 4;
      if (length <= 0) {
        result.push("<span style='color:red;'>MALFORMED DATA</span>");
        continue;
      }
      switch (avcStream[i] & 31) {
        case 1:
          result.push("slice_layer_without_partitioning_rbsp");
          break;
        case 5:
          result.push("slice_layer_without_partitioning_rbsp_idr");
          break;
        case 6:
          result.push("sei_rbsp");
          break;
        case 7:
          result.push("seq_parameter_set_rbsp");
          break;
        case 8:
          result.push("pic_parameter_set_rbsp");
          break;
        case 9:
          result.push("access_unit_delimiter_rbsp");
          break;
        default:
          result.push("UNKNOWN NAL - " + avcStream[i] & 31);
          break;
      }
    }
    return result;
  }, parse2 = {
    avc1: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength);
      return {
        dataReferenceIndex: view.getUint16(6),
        width: view.getUint16(24),
        height: view.getUint16(26),
        horizresolution: view.getUint16(28) + view.getUint16(30) / 16,
        vertresolution: view.getUint16(32) + view.getUint16(34) / 16,
        frameCount: view.getUint16(40),
        depth: view.getUint16(74),
        config: inspectMp4(data.subarray(78, data.byteLength))
      };
    },
    avcC: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        configurationVersion: data[0],
        avcProfileIndication: data[1],
        profileCompatibility: data[2],
        avcLevelIndication: data[3],
        lengthSizeMinusOne: data[4] & 3,
        sps: [],
        pps: []
      }, numOfSequenceParameterSets = data[5] & 31, numOfPictureParameterSets, nalSize, offset, i;
      offset = 6;
      for (i = 0; i < numOfSequenceParameterSets; i++) {
        nalSize = view.getUint16(offset);
        offset += 2;
        result.sps.push(new Uint8Array(data.subarray(offset, offset + nalSize)));
        offset += nalSize;
      }
      numOfPictureParameterSets = data[offset];
      offset++;
      for (i = 0; i < numOfPictureParameterSets; i++) {
        nalSize = view.getUint16(offset);
        offset += 2;
        result.pps.push(new Uint8Array(data.subarray(offset, offset + nalSize)));
        offset += nalSize;
      }
      return result;
    },
    btrt: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength);
      return {
        bufferSizeDB: view.getUint32(0),
        maxBitrate: view.getUint32(4),
        avgBitrate: view.getUint32(8)
      };
    },
    edts: function edts(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    elst: function elst(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4)),
        edits: []
      }, entryCount = view.getUint32(4), i;
      for (i = 8; entryCount; entryCount--) {
        if (result.version === 0) {
          result.edits.push({
            segmentDuration: view.getUint32(i),
            mediaTime: view.getInt32(i + 4),
            mediaRate: view.getUint16(i + 8) + view.getUint16(i + 10) / (256 * 256)
          });
          i += 12;
        } else {
          result.edits.push({
            segmentDuration: getUint64$2(data.subarray(i)),
            mediaTime: getUint64$2(data.subarray(i + 8)),
            mediaRate: view.getUint16(i + 16) + view.getUint16(i + 18) / (256 * 256)
          });
          i += 20;
        }
      }
      return result;
    },
    esds: function(data) {
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        esId: data[6] << 8 | data[7],
        streamPriority: data[8] & 31,
        decoderConfig: {
          objectProfileIndication: data[11],
          streamType: data[12] >>> 2 & 63,
          bufferSize: data[13] << 16 | data[14] << 8 | data[15],
          maxBitrate: data[16] << 24 | data[17] << 16 | data[18] << 8 | data[19],
          avgBitrate: data[20] << 24 | data[21] << 16 | data[22] << 8 | data[23],
          decoderConfigDescriptor: {
            tag: data[24],
            length: data[25],
            audioObjectType: data[26] >>> 3 & 31,
            samplingFrequencyIndex: (data[26] & 7) << 1 | data[27] >>> 7 & 1,
            channelConfiguration: data[27] >>> 3 & 15
          }
        }
      };
    },
    ftyp: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        majorBrand: parseType$2(data.subarray(0, 4)),
        minorVersion: view.getUint32(4),
        compatibleBrands: []
      }, i = 8;
      while (i < data.byteLength) {
        result.compatibleBrands.push(parseType$2(data.subarray(i, i + 4)));
        i += 4;
      }
      return result;
    },
    dinf: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    dref: function(data) {
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        dataReferences: inspectMp4(data.subarray(8))
      };
    },
    hdlr: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4)),
        handlerType: parseType$2(data.subarray(8, 12)),
        name: ""
      }, i = 8;
      for (i = 24; i < data.byteLength; i++) {
        if (data[i] === 0) {
          i++;
          break;
        }
        result.name += String.fromCharCode(data[i]);
      }
      result.name = decodeURIComponent(escape(result.name));
      return result;
    },
    mdat: function(data) {
      return {
        byteLength: data.byteLength,
        nals: nalParse(data)
      };
    },
    mdhd: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), i = 4, language, result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4)),
        language: ""
      };
      if (result.version === 1) {
        i += 4;
        result.creationTime = parseMp4Date(view.getUint32(i));
        i += 8;
        result.modificationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.timescale = view.getUint32(i);
        i += 8;
        result.duration = view.getUint32(i);
      } else {
        result.creationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.modificationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.timescale = view.getUint32(i);
        i += 4;
        result.duration = view.getUint32(i);
      }
      i += 4;
      language = view.getUint16(i);
      result.language += String.fromCharCode((language >> 10) + 96);
      result.language += String.fromCharCode(((language & 992) >> 5) + 96);
      result.language += String.fromCharCode((language & 31) + 96);
      return result;
    },
    mdia: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    mfhd: function(data) {
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        sequenceNumber: data[4] << 24 | data[5] << 16 | data[6] << 8 | data[7]
      };
    },
    minf: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    mp4a: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        dataReferenceIndex: view.getUint16(6),
        channelcount: view.getUint16(16),
        samplesize: view.getUint16(18),
        samplerate: view.getUint16(24) + view.getUint16(26) / 65536
      };
      if (data.byteLength > 28) {
        result.streamDescriptor = inspectMp4(data.subarray(28))[0];
      }
      return result;
    },
    moof: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    moov: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    mvex: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    mvhd: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), i = 4, result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4))
      };
      if (result.version === 1) {
        i += 4;
        result.creationTime = parseMp4Date(view.getUint32(i));
        i += 8;
        result.modificationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.timescale = view.getUint32(i);
        i += 8;
        result.duration = view.getUint32(i);
      } else {
        result.creationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.modificationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.timescale = view.getUint32(i);
        i += 4;
        result.duration = view.getUint32(i);
      }
      i += 4;
      result.rate = view.getUint16(i) + view.getUint16(i + 2) / 16;
      i += 4;
      result.volume = view.getUint8(i) + view.getUint8(i + 1) / 8;
      i += 2;
      i += 2;
      i += 2 * 4;
      result.matrix = new Uint32Array(data.subarray(i, i + 9 * 4));
      i += 9 * 4;
      i += 6 * 4;
      result.nextTrackId = view.getUint32(i);
      return result;
    },
    pdin: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength);
      return {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4)),
        rate: view.getUint32(4),
        initialDelay: view.getUint32(8)
      };
    },
    sdtp: function(data) {
      var result = {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        samples: []
      }, i;
      for (i = 4; i < data.byteLength; i++) {
        result.samples.push({
          dependsOn: (data[i] & 48) >> 4,
          isDependedOn: (data[i] & 12) >> 2,
          hasRedundancy: data[i] & 3
        });
      }
      return result;
    },
    sidx: parseSidx_12,
    smhd: function(data) {
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        balance: data[4] + data[5] / 256
      };
    },
    stbl: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    ctts: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4)),
        compositionOffsets: []
      }, entryCount = view.getUint32(4), i;
      for (i = 8; entryCount; i += 8, entryCount--) {
        result.compositionOffsets.push({
          sampleCount: view.getUint32(i),
          sampleOffset: view[result.version === 0 ? "getUint32" : "getInt32"](i + 4)
        });
      }
      return result;
    },
    stss: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4)),
        syncSamples: []
      }, entryCount = view.getUint32(4), i;
      for (i = 8; entryCount; i += 4, entryCount--) {
        result.syncSamples.push(view.getUint32(i));
      }
      return result;
    },
    stco: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        chunkOffsets: []
      }, entryCount = view.getUint32(4), i;
      for (i = 8; entryCount; i += 4, entryCount--) {
        result.chunkOffsets.push(view.getUint32(i));
      }
      return result;
    },
    stsc: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), entryCount = view.getUint32(4), result = {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        sampleToChunks: []
      }, i;
      for (i = 8; entryCount; i += 12, entryCount--) {
        result.sampleToChunks.push({
          firstChunk: view.getUint32(i),
          samplesPerChunk: view.getUint32(i + 4),
          sampleDescriptionIndex: view.getUint32(i + 8)
        });
      }
      return result;
    },
    stsd: function(data) {
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        sampleDescriptions: inspectMp4(data.subarray(8))
      };
    },
    stsz: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        sampleSize: view.getUint32(4),
        entries: []
      }, i;
      for (i = 12; i < data.byteLength; i += 4) {
        result.entries.push(view.getUint32(i));
      }
      return result;
    },
    stts: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), result = {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        timeToSamples: []
      }, entryCount = view.getUint32(4), i;
      for (i = 8; entryCount; i += 8, entryCount--) {
        result.timeToSamples.push({
          sampleCount: view.getUint32(i),
          sampleDelta: view.getUint32(i + 4)
        });
      }
      return result;
    },
    styp: function(data) {
      return parse2.ftyp(data);
    },
    tfdt: parseTfdt$3,
    tfhd: parseTfhd$2,
    tkhd: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength), i = 4, result = {
        version: view.getUint8(0),
        flags: new Uint8Array(data.subarray(1, 4))
      };
      if (result.version === 1) {
        i += 4;
        result.creationTime = parseMp4Date(view.getUint32(i));
        i += 8;
        result.modificationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.trackId = view.getUint32(i);
        i += 4;
        i += 8;
        result.duration = view.getUint32(i);
      } else {
        result.creationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.modificationTime = parseMp4Date(view.getUint32(i));
        i += 4;
        result.trackId = view.getUint32(i);
        i += 4;
        i += 4;
        result.duration = view.getUint32(i);
      }
      i += 4;
      i += 2 * 4;
      result.layer = view.getUint16(i);
      i += 2;
      result.alternateGroup = view.getUint16(i);
      i += 2;
      result.volume = view.getUint8(i) + view.getUint8(i + 1) / 8;
      i += 2;
      i += 2;
      result.matrix = new Uint32Array(data.subarray(i, i + 9 * 4));
      i += 9 * 4;
      result.width = view.getUint16(i) + view.getUint16(i + 2) / 65536;
      i += 4;
      result.height = view.getUint16(i) + view.getUint16(i + 2) / 65536;
      return result;
    },
    traf: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    trak: function(data) {
      return {
        boxes: inspectMp4(data)
      };
    },
    trex: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength);
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        trackId: view.getUint32(4),
        defaultSampleDescriptionIndex: view.getUint32(8),
        defaultSampleDuration: view.getUint32(12),
        defaultSampleSize: view.getUint32(16),
        sampleDependsOn: data[20] & 3,
        sampleIsDependedOn: (data[21] & 192) >> 6,
        sampleHasRedundancy: (data[21] & 48) >> 4,
        samplePaddingValue: (data[21] & 14) >> 1,
        sampleIsDifferenceSample: !!(data[21] & 1),
        sampleDegradationPriority: view.getUint16(22)
      };
    },
    trun: parseTrun$2,
    "url ": function(data) {
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4))
      };
    },
    vmhd: function(data) {
      var view = new DataView(data.buffer, data.byteOffset, data.byteLength);
      return {
        version: data[0],
        flags: new Uint8Array(data.subarray(1, 4)),
        graphicsmode: view.getUint16(4),
        opcolor: new Uint16Array([view.getUint16(6), view.getUint16(8), view.getUint16(10)])
      };
    }
  };
  inspectMp4 = function(data) {
    var i = 0, result = [], view, size, type2, end, box2;
    var ab = new ArrayBuffer(data.length);
    var v = new Uint8Array(ab);
    for (var z = 0; z < data.length; ++z) {
      v[z] = data[z];
    }
    view = new DataView(ab);
    while (i < data.byteLength) {
      size = view.getUint32(i);
      type2 = parseType$2(data.subarray(i + 4, i + 8));
      end = size > 1 ? i + size : data.byteLength;
      box2 = (parse2[type2] || function(data2) {
        return {
          data: data2
        };
      })(data.subarray(i + 8, end));
      box2.size = size;
      box2.type = type2;
      result.push(box2);
      i = end;
    }
    return result;
  };
  textifyMp4 = function(inspectedMp4, depth) {
    var indent;
    depth = depth || 0;
    indent = new Array(depth * 2 + 1).join(" ");
    return inspectedMp4.map(function(box2, index) {
      return indent + box2.type + "\n" + Object.keys(box2).filter(function(key) {
        return key !== "type" && key !== "boxes";
      }).map(function(key) {
        var prefix = indent + "  " + key + ": ", value = box2[key];
        if (value instanceof Uint8Array || value instanceof Uint32Array) {
          var bytes = Array.prototype.slice.call(new Uint8Array(value.buffer, value.byteOffset, value.byteLength)).map(function(byte) {
            return " " + ("00" + byte.toString(16)).slice(-2);
          }).join("").match(/.{1,24}/g);
          if (!bytes) {
            return prefix + "<>";
          }
          if (bytes.length === 1) {
            return prefix + "<" + bytes.join("").slice(1) + ">";
          }
          return prefix + "<\n" + bytes.map(function(line) {
            return indent + "  " + line;
          }).join("\n") + "\n" + indent + "  >";
        }
        return prefix + JSON.stringify(value, null, 2).split("\n").map(function(line, index2) {
          if (index2 === 0) {
            return line;
          }
          return indent + "  " + line;
        }).join("\n");
      }).join("\n") + (box2.boxes ? "\n" + textifyMp4(box2.boxes, depth + 1) : "");
    }).join("\n");
  };
  var mp4Inspector = {
    inspect: inspectMp4,
    textify: textifyMp4,
    parseType: parseType$2,
    findBox: findBox$4,
    parseTraf: parse2.traf,
    parseTfdt: parse2.tfdt,
    parseHdlr: parse2.hdlr,
    parseTfhd: parse2.tfhd,
    parseTrun: parse2.trun,
    parseSidx: parse2.sidx
  };
  var uint8ToCString$1 = function(data) {
    var index = 0;
    var curChar = String.fromCharCode(data[index]);
    var retString = "";
    while (curChar !== "\0") {
      retString += curChar;
      index++;
      curChar = String.fromCharCode(data[index]);
    }
    retString += curChar;
    return retString;
  };
  var string = {
    uint8ToCString: uint8ToCString$1
  };
  var uint8ToCString = string.uint8ToCString;
  var getUint64$1 = numbers.getUint64;
  var parseEmsgBox = function(boxData) {
    var offset = 4;
    var version2 = boxData[0];
    var scheme_id_uri, value, timescale2, presentation_time, presentation_time_delta, event_duration, id, message_data;
    if (version2 === 0) {
      scheme_id_uri = uint8ToCString(boxData.subarray(offset));
      offset += scheme_id_uri.length;
      value = uint8ToCString(boxData.subarray(offset));
      offset += value.length;
      var dv = new DataView(boxData.buffer);
      timescale2 = dv.getUint32(offset);
      offset += 4;
      presentation_time_delta = dv.getUint32(offset);
      offset += 4;
      event_duration = dv.getUint32(offset);
      offset += 4;
      id = dv.getUint32(offset);
      offset += 4;
    } else if (version2 === 1) {
      var dv = new DataView(boxData.buffer);
      timescale2 = dv.getUint32(offset);
      offset += 4;
      presentation_time = getUint64$1(boxData.subarray(offset));
      offset += 8;
      event_duration = dv.getUint32(offset);
      offset += 4;
      id = dv.getUint32(offset);
      offset += 4;
      scheme_id_uri = uint8ToCString(boxData.subarray(offset));
      offset += scheme_id_uri.length;
      value = uint8ToCString(boxData.subarray(offset));
      offset += value.length;
    }
    message_data = new Uint8Array(boxData.subarray(offset, boxData.byteLength));
    var emsgBox = {
      scheme_id_uri,
      value,
      timescale: timescale2 ? timescale2 : 1,
      presentation_time,
      presentation_time_delta,
      event_duration,
      id,
      message_data
    };
    return isValidEmsgBox(version2, emsgBox) ? emsgBox : void 0;
  };
  var scaleTime = function(presentationTime, timescale2, timeDelta, offset) {
    return presentationTime || presentationTime === 0 ? presentationTime / timescale2 : offset + timeDelta / timescale2;
  };
  var isValidEmsgBox = function(version2, emsg2) {
    var hasScheme = emsg2.scheme_id_uri !== "\0";
    var isValidV0Box = version2 === 0 && isDefined(emsg2.presentation_time_delta) && hasScheme;
    var isValidV1Box = version2 === 1 && isDefined(emsg2.presentation_time) && hasScheme;
    return !(version2 > 1) && isValidV0Box || isValidV1Box;
  };
  var isDefined = function(data) {
    return data !== void 0 || data !== null;
  };
  var emsg$1 = {
    parseEmsgBox,
    scaleTime
  };
  var win;
  if (typeof window !== "undefined") {
    win = window;
  } else if (typeof commonjsGlobal !== "undefined") {
    win = commonjsGlobal;
  } else if (typeof self !== "undefined") {
    win = self;
  } else {
    win = {};
  }
  var window_12 = win;
  var toUnsigned = bin.toUnsigned;
  var toHexString = bin.toHexString;
  var findBox$3 = findBox_1;
  var parseType$1 = parseType_1;
  var emsg = emsg$1;
  var parseTfhd$1 = parseTfhd$2;
  var parseTrun$1 = parseTrun$2;
  var parseTfdt$2 = parseTfdt$3;
  var getUint64 = numbers.getUint64;
  var timescale, startTime, compositionStartTime, getVideoTrackIds, getTracks, getTimescaleFromMediaHeader$1, getEmsgID3;
  var window$2 = window_12;
  var parseId3Frames = parseId3.parseId3Frames;
  timescale = function(init) {
    var result = {}, traks = findBox$3(init, ["moov", "trak"]);
    return traks.reduce(function(result2, trak2) {
      var tkhd2, version2, index, id, mdhd2;
      tkhd2 = findBox$3(trak2, ["tkhd"])[0];
      if (!tkhd2) {
        return null;
      }
      version2 = tkhd2[0];
      index = version2 === 0 ? 12 : 20;
      id = toUnsigned(tkhd2[index] << 24 | tkhd2[index + 1] << 16 | tkhd2[index + 2] << 8 | tkhd2[index + 3]);
      mdhd2 = findBox$3(trak2, ["mdia", "mdhd"])[0];
      if (!mdhd2) {
        return null;
      }
      version2 = mdhd2[0];
      index = version2 === 0 ? 12 : 20;
      result2[id] = toUnsigned(mdhd2[index] << 24 | mdhd2[index + 1] << 16 | mdhd2[index + 2] << 8 | mdhd2[index + 3]);
      return result2;
    }, result);
  };
  startTime = function(timescale2, fragment) {
    var trafs;
    trafs = findBox$3(fragment, ["moof", "traf"]);
    var lowestTime = trafs.reduce(function(acc, traf2) {
      var tfhd2 = findBox$3(traf2, ["tfhd"])[0];
      var id = toUnsigned(tfhd2[4] << 24 | tfhd2[5] << 16 | tfhd2[6] << 8 | tfhd2[7]);
      var scale = timescale2[id] || 9e4;
      var tfdt2 = findBox$3(traf2, ["tfdt"])[0];
      var dv = new DataView(tfdt2.buffer, tfdt2.byteOffset, tfdt2.byteLength);
      var baseTime;
      if (tfdt2[0] === 1) {
        baseTime = getUint64(tfdt2.subarray(4, 12));
      } else {
        baseTime = dv.getUint32(4);
      }
      let seconds;
      if (typeof baseTime === "bigint") {
        seconds = baseTime / window$2.BigInt(scale);
      } else if (typeof baseTime === "number" && !isNaN(baseTime)) {
        seconds = baseTime / scale;
      }
      if (seconds < Number.MAX_SAFE_INTEGER) {
        seconds = Number(seconds);
      }
      if (seconds < acc) {
        acc = seconds;
      }
      return acc;
    }, Infinity);
    return typeof lowestTime === "bigint" || isFinite(lowestTime) ? lowestTime : 0;
  };
  compositionStartTime = function(timescales, fragment) {
    var trafBoxes = findBox$3(fragment, ["moof", "traf"]);
    var baseMediaDecodeTime = 0;
    var compositionTimeOffset = 0;
    var trackId;
    if (trafBoxes && trafBoxes.length) {
      var tfhd2 = findBox$3(trafBoxes[0], ["tfhd"])[0];
      var trun2 = findBox$3(trafBoxes[0], ["trun"])[0];
      var tfdt2 = findBox$3(trafBoxes[0], ["tfdt"])[0];
      if (tfhd2) {
        var parsedTfhd = parseTfhd$1(tfhd2);
        trackId = parsedTfhd.trackId;
      }
      if (tfdt2) {
        var parsedTfdt = parseTfdt$2(tfdt2);
        baseMediaDecodeTime = parsedTfdt.baseMediaDecodeTime;
      }
      if (trun2) {
        var parsedTrun = parseTrun$1(trun2);
        if (parsedTrun.samples && parsedTrun.samples.length) {
          compositionTimeOffset = parsedTrun.samples[0].compositionTimeOffset || 0;
        }
      }
    }
    var timescale2 = timescales[trackId] || 9e4;
    if (typeof baseMediaDecodeTime === "bigint") {
      compositionTimeOffset = window$2.BigInt(compositionTimeOffset);
      timescale2 = window$2.BigInt(timescale2);
    }
    var result = (baseMediaDecodeTime + compositionTimeOffset) / timescale2;
    if (typeof result === "bigint" && result < Number.MAX_SAFE_INTEGER) {
      result = Number(result);
    }
    return result;
  };
  getVideoTrackIds = function(init) {
    var traks = findBox$3(init, ["moov", "trak"]);
    var videoTrackIds = [];
    traks.forEach(function(trak2) {
      var hdlrs = findBox$3(trak2, ["mdia", "hdlr"]);
      var tkhds = findBox$3(trak2, ["tkhd"]);
      hdlrs.forEach(function(hdlr2, index) {
        var handlerType = parseType$1(hdlr2.subarray(8, 12));
        var tkhd2 = tkhds[index];
        var view;
        var version2;
        var trackId;
        if (handlerType === "vide") {
          view = new DataView(tkhd2.buffer, tkhd2.byteOffset, tkhd2.byteLength);
          version2 = view.getUint8(0);
          trackId = version2 === 0 ? view.getUint32(12) : view.getUint32(20);
          videoTrackIds.push(trackId);
        }
      });
    });
    return videoTrackIds;
  };
  getTimescaleFromMediaHeader$1 = function(mdhd2) {
    var version2 = mdhd2[0];
    var index = version2 === 0 ? 12 : 20;
    return toUnsigned(mdhd2[index] << 24 | mdhd2[index + 1] << 16 | mdhd2[index + 2] << 8 | mdhd2[index + 3]);
  };
  getTracks = function(init) {
    var traks = findBox$3(init, ["moov", "trak"]);
    var tracks = [];
    traks.forEach(function(trak2) {
      var track = {};
      var tkhd2 = findBox$3(trak2, ["tkhd"])[0];
      var view, tkhdVersion;
      if (tkhd2) {
        view = new DataView(tkhd2.buffer, tkhd2.byteOffset, tkhd2.byteLength);
        tkhdVersion = view.getUint8(0);
        track.id = tkhdVersion === 0 ? view.getUint32(12) : view.getUint32(20);
      }
      var hdlr2 = findBox$3(trak2, ["mdia", "hdlr"])[0];
      if (hdlr2) {
        var type2 = parseType$1(hdlr2.subarray(8, 12));
        if (type2 === "vide") {
          track.type = "video";
        } else if (type2 === "soun") {
          track.type = "audio";
        } else {
          track.type = type2;
        }
      }
      var stsd2 = findBox$3(trak2, ["mdia", "minf", "stbl", "stsd"])[0];
      if (stsd2) {
        var sampleDescriptions = stsd2.subarray(8);
        track.codec = parseType$1(sampleDescriptions.subarray(4, 8));
        var codecBox = findBox$3(sampleDescriptions, [track.codec])[0];
        var codecConfig, codecConfigType;
        if (codecBox) {
          if (/^[asm]vc[1-9]$/i.test(track.codec)) {
            codecConfig = codecBox.subarray(78);
            codecConfigType = parseType$1(codecConfig.subarray(4, 8));
            if (codecConfigType === "avcC" && codecConfig.length > 11) {
              track.codec += ".";
              track.codec += toHexString(codecConfig[9]);
              track.codec += toHexString(codecConfig[10]);
              track.codec += toHexString(codecConfig[11]);
            } else {
              track.codec = "avc1.4d400d";
            }
          } else if (/^mp4[a,v]$/i.test(track.codec)) {
            codecConfig = codecBox.subarray(28);
            codecConfigType = parseType$1(codecConfig.subarray(4, 8));
            if (codecConfigType === "esds" && codecConfig.length > 20 && codecConfig[19] !== 0) {
              track.codec += "." + toHexString(codecConfig[19]);
              track.codec += "." + toHexString(codecConfig[20] >>> 2 & 63).replace(/^0/, "");
            } else {
              track.codec = "mp4a.40.2";
            }
          } else {
            track.codec = track.codec.toLowerCase();
          }
        }
      }
      var mdhd2 = findBox$3(trak2, ["mdia", "mdhd"])[0];
      if (mdhd2) {
        track.timescale = getTimescaleFromMediaHeader$1(mdhd2);
      }
      tracks.push(track);
    });
    return tracks;
  };
  getEmsgID3 = function(segmentData, offset = 0) {
    var emsgBoxes = findBox$3(segmentData, ["emsg"]);
    return emsgBoxes.map((data) => {
      var parsedBox = emsg.parseEmsgBox(new Uint8Array(data));
      var parsedId3Frames = parseId3Frames(parsedBox.message_data);
      return {
        cueTime: emsg.scaleTime(parsedBox.presentation_time, parsedBox.timescale, parsedBox.presentation_time_delta, offset),
        duration: emsg.scaleTime(parsedBox.event_duration, parsedBox.timescale),
        frames: parsedId3Frames
      };
    });
  };
  var probe$2 = {
    findBox: findBox$3,
    parseType: parseType$1,
    timescale,
    startTime,
    compositionStartTime,
    videoTrackIds: getVideoTrackIds,
    tracks: getTracks,
    getTimescaleFromMediaHeader: getTimescaleFromMediaHeader$1,
    getEmsgID3
  };
  const {
    parseTrun
  } = mp4Inspector;
  const {
    findBox: findBox$2
  } = probe$2;
  var window$1 = window_12;
  var getMdatTrafPairs$2 = function(segment) {
    var trafs = findBox$2(segment, ["moof", "traf"]);
    var mdats = findBox$2(segment, ["mdat"]);
    var mdatTrafPairs = [];
    mdats.forEach(function(mdat2, index) {
      var matchingTraf = trafs[index];
      mdatTrafPairs.push({
        mdat: mdat2,
        traf: matchingTraf
      });
    });
    return mdatTrafPairs;
  };
  var parseSamples$2 = function(truns, baseMediaDecodeTime, tfhd2) {
    var currentDts = baseMediaDecodeTime;
    var defaultSampleDuration = tfhd2.defaultSampleDuration || 0;
    var defaultSampleSize = tfhd2.defaultSampleSize || 0;
    var trackId = tfhd2.trackId;
    var allSamples = [];
    truns.forEach(function(trun2) {
      var trackRun = parseTrun(trun2);
      var samples2 = trackRun.samples;
      samples2.forEach(function(sample) {
        if (sample.duration === void 0) {
          sample.duration = defaultSampleDuration;
        }
        if (sample.size === void 0) {
          sample.size = defaultSampleSize;
        }
        sample.trackId = trackId;
        sample.dts = currentDts;
        if (sample.compositionTimeOffset === void 0) {
          sample.compositionTimeOffset = 0;
        }
        if (typeof currentDts === "bigint") {
          sample.pts = currentDts + window$1.BigInt(sample.compositionTimeOffset);
          currentDts += window$1.BigInt(sample.duration);
        } else {
          sample.pts = currentDts + sample.compositionTimeOffset;
          currentDts += sample.duration;
        }
      });
      allSamples = allSamples.concat(samples2);
    });
    return allSamples;
  };
  var samples = {
    getMdatTrafPairs: getMdatTrafPairs$2,
    parseSamples: parseSamples$2
  };
  var discardEmulationPreventionBytes = captionPacketParser.discardEmulationPreventionBytes;
  var CaptionStream = captionStream.CaptionStream;
  var findBox$1 = findBox_1;
  var parseTfdt$1 = parseTfdt$3;
  var parseTfhd = parseTfhd$2;
  var {
    getMdatTrafPairs: getMdatTrafPairs$1,
    parseSamples: parseSamples$1
  } = samples;
  var mapToSample = function(offset, samples2) {
    var approximateOffset = offset;
    for (var i = 0; i < samples2.length; i++) {
      var sample = samples2[i];
      if (approximateOffset < sample.size) {
        return sample;
      }
      approximateOffset -= sample.size;
    }
    return null;
  };
  var findSeiNals = function(avcStream, samples2, trackId) {
    var avcView = new DataView(avcStream.buffer, avcStream.byteOffset, avcStream.byteLength), result = {
      logs: [],
      seiNals: []
    }, seiNal, i, length, lastMatchedSample;
    for (i = 0; i + 4 < avcStream.length; i += length) {
      length = avcView.getUint32(i);
      i += 4;
      if (length <= 0) {
        continue;
      }
      switch (avcStream[i] & 31) {
        case 6:
          var data = avcStream.subarray(i + 1, i + 1 + length);
          var matchingSample = mapToSample(i, samples2);
          seiNal = {
            nalUnitType: "sei_rbsp",
            size: length,
            data,
            escapedRBSP: discardEmulationPreventionBytes(data),
            trackId
          };
          if (matchingSample) {
            seiNal.pts = matchingSample.pts;
            seiNal.dts = matchingSample.dts;
            lastMatchedSample = matchingSample;
          } else if (lastMatchedSample) {
            seiNal.pts = lastMatchedSample.pts;
            seiNal.dts = lastMatchedSample.dts;
          } else {
            result.logs.push({
              level: "warn",
              message: "We've encountered a nal unit without data at " + i + " for trackId " + trackId + ". See mux.js#223."
            });
            break;
          }
          result.seiNals.push(seiNal);
          break;
      }
    }
    return result;
  };
  var parseCaptionNals = function(segment, videoTrackId) {
    var captionNals = {};
    var mdatTrafPairs = getMdatTrafPairs$1(segment);
    mdatTrafPairs.forEach(function(pair) {
      var mdat2 = pair.mdat;
      var traf2 = pair.traf;
      var tfhd2 = findBox$1(traf2, ["tfhd"]);
      var headerInfo = parseTfhd(tfhd2[0]);
      var trackId = headerInfo.trackId;
      var tfdt2 = findBox$1(traf2, ["tfdt"]);
      var baseMediaDecodeTime = tfdt2.length > 0 ? parseTfdt$1(tfdt2[0]).baseMediaDecodeTime : 0;
      var truns = findBox$1(traf2, ["trun"]);
      var samples2;
      var result;
      if (videoTrackId === trackId && truns.length > 0) {
        samples2 = parseSamples$1(truns, baseMediaDecodeTime, headerInfo);
        result = findSeiNals(mdat2, samples2, trackId);
        if (!captionNals[trackId]) {
          captionNals[trackId] = {
            seiNals: [],
            logs: []
          };
        }
        captionNals[trackId].seiNals = captionNals[trackId].seiNals.concat(result.seiNals);
        captionNals[trackId].logs = captionNals[trackId].logs.concat(result.logs);
      }
    });
    return captionNals;
  };
  var parseEmbeddedCaptions = function(segment, trackId, timescale2) {
    var captionNals;
    if (trackId === null) {
      return null;
    }
    captionNals = parseCaptionNals(segment, trackId);
    var trackNals = captionNals[trackId] || {};
    return {
      seiNals: trackNals.seiNals,
      logs: trackNals.logs,
      timescale: timescale2
    };
  };
  var CaptionParser = function() {
    var isInitialized = false;
    var captionStream2;
    var segmentCache;
    var trackId;
    var timescale2;
    var parsedCaptions;
    var parsingPartial;
    this.isInitialized = function() {
      return isInitialized;
    };
    this.init = function(options) {
      captionStream2 = new CaptionStream();
      isInitialized = true;
      parsingPartial = options ? options.isPartial : false;
      captionStream2.on("data", function(event) {
        event.startTime = event.startPts / timescale2;
        event.endTime = event.endPts / timescale2;
        parsedCaptions.captions.push(event);
        parsedCaptions.captionStreams[event.stream] = true;
      });
      captionStream2.on("log", function(log2) {
        parsedCaptions.logs.push(log2);
      });
    };
    this.isNewInit = function(videoTrackIds, timescales) {
      if (videoTrackIds && videoTrackIds.length === 0 || timescales && typeof timescales === "object" && Object.keys(timescales).length === 0) {
        return false;
      }
      return trackId !== videoTrackIds[0] || timescale2 !== timescales[trackId];
    };
    this.parse = function(segment, videoTrackIds, timescales) {
      var parsedData;
      if (!this.isInitialized()) {
        return null;
      } else if (!videoTrackIds || !timescales) {
        return null;
      } else if (this.isNewInit(videoTrackIds, timescales)) {
        trackId = videoTrackIds[0];
        timescale2 = timescales[trackId];
      } else if (trackId === null || !timescale2) {
        segmentCache.push(segment);
        return null;
      }
      while (segmentCache.length > 0) {
        var cachedSegment = segmentCache.shift();
        this.parse(cachedSegment, videoTrackIds, timescales);
      }
      parsedData = parseEmbeddedCaptions(segment, trackId, timescale2);
      if (parsedData && parsedData.logs) {
        parsedCaptions.logs = parsedCaptions.logs.concat(parsedData.logs);
      }
      if (parsedData === null || !parsedData.seiNals) {
        if (parsedCaptions.logs.length) {
          return {
            logs: parsedCaptions.logs,
            captions: [],
            captionStreams: []
          };
        }
        return null;
      }
      this.pushNals(parsedData.seiNals);
      this.flushStream();
      return parsedCaptions;
    };
    this.pushNals = function(nals) {
      if (!this.isInitialized() || !nals || nals.length === 0) {
        return null;
      }
      nals.forEach(function(nal) {
        captionStream2.push(nal);
      });
    };
    this.flushStream = function() {
      if (!this.isInitialized()) {
        return null;
      }
      if (!parsingPartial) {
        captionStream2.flush();
      } else {
        captionStream2.partialFlush();
      }
    };
    this.clearParsedCaptions = function() {
      parsedCaptions.captions = [];
      parsedCaptions.captionStreams = {};
      parsedCaptions.logs = [];
    };
    this.resetCaptionStream = function() {
      if (!this.isInitialized()) {
        return null;
      }
      captionStream2.reset();
    };
    this.clearAllCaptions = function() {
      this.clearParsedCaptions();
      this.resetCaptionStream();
    };
    this.reset = function() {
      segmentCache = [];
      trackId = null;
      timescale2 = null;
      if (!parsedCaptions) {
        parsedCaptions = {
          captions: [],
          captionStreams: {},
          logs: []
        };
      } else {
        this.clearParsedCaptions();
      }
      this.resetCaptionStream();
    };
    this.reset();
  };
  var captionParser = CaptionParser;
  const {
    parseTfdt
  } = mp4Inspector;
  const findBox = findBox_1;
  const {
    getTimescaleFromMediaHeader
  } = probe$2;
  const {
    parseSamples,
    getMdatTrafPairs
  } = samples;
  const WebVttParser = function() {
    let timescale2 = 9e4;
    this.init = function(segment) {
      const mdhd2 = findBox(segment, ["moov", "trak", "mdia", "mdhd"])[0];
      if (mdhd2) {
        timescale2 = getTimescaleFromMediaHeader(mdhd2);
      }
    };
    this.parseSegment = function(segment) {
      const vttCues = [];
      const mdatTrafPairs = getMdatTrafPairs(segment);
      let baseMediaDecodeTime = 0;
      mdatTrafPairs.forEach(function(pair) {
        const mdatBox = pair.mdat;
        const trafBox = pair.traf;
        const tfdtBox = findBox(trafBox, ["tfdt"])[0];
        const tfhdBox = findBox(trafBox, ["tfhd"])[0];
        const trunBoxes = findBox(trafBox, ["trun"]);
        if (tfdtBox) {
          const tfdt2 = parseTfdt(tfdtBox);
          baseMediaDecodeTime = tfdt2.baseMediaDecodeTime;
        }
        if (trunBoxes.length && tfhdBox) {
          const samples2 = parseSamples(trunBoxes, baseMediaDecodeTime, tfhdBox);
          let mdatOffset = 0;
          samples2.forEach(function(sample) {
            const UTF_8 = "utf-8";
            const textDecoder = new TextDecoder(UTF_8);
            const sampleData = mdatBox.slice(mdatOffset, mdatOffset + sample.size);
            const vtteBox = findBox(sampleData, ["vtte"])[0];
            if (vtteBox) {
              mdatOffset += sample.size;
              return;
            }
            const vttcBoxes = findBox(sampleData, ["vttc"]);
            vttcBoxes.forEach(function(vttcBox) {
              const paylBox = findBox(vttcBox, ["payl"])[0];
              const sttgBox = findBox(vttcBox, ["sttg"])[0];
              const start = sample.pts / timescale2;
              const end = (sample.pts + sample.duration) / timescale2;
              let cueText, settings;
              if (paylBox) {
                try {
                  cueText = textDecoder.decode(paylBox);
                } catch (e) {
                  console.error(e);
                }
              }
              if (sttgBox) {
                try {
                  settings = textDecoder.decode(sttgBox);
                } catch (e) {
                  console.error(e);
                }
              }
              if (sample.duration && cueText) {
                vttCues.push({
                  cueText,
                  start,
                  end,
                  settings
                });
              }
            });
            mdatOffset += sample.size;
          });
        }
      });
      return vttCues;
    };
  };
  var webvttParser = WebVttParser;
  var StreamTypes$1 = streamTypes;
  var parsePid = function(packet) {
    var pid = packet[1] & 31;
    pid <<= 8;
    pid |= packet[2];
    return pid;
  };
  var parsePayloadUnitStartIndicator = function(packet) {
    return !!(packet[1] & 64);
  };
  var parseAdaptionField = function(packet) {
    var offset = 0;
    if ((packet[3] & 48) >>> 4 > 1) {
      offset += packet[4] + 1;
    }
    return offset;
  };
  var parseType = function(packet, pmtPid) {
    var pid = parsePid(packet);
    if (pid === 0) {
      return "pat";
    } else if (pid === pmtPid) {
      return "pmt";
    } else if (pmtPid) {
      return "pes";
    }
    return null;
  };
  var parsePat = function(packet) {
    var pusi = parsePayloadUnitStartIndicator(packet);
    var offset = 4 + parseAdaptionField(packet);
    if (pusi) {
      offset += packet[offset] + 1;
    }
    return (packet[offset + 10] & 31) << 8 | packet[offset + 11];
  };
  var parsePmt = function(packet) {
    var programMapTable = {};
    var pusi = parsePayloadUnitStartIndicator(packet);
    var payloadOffset = 4 + parseAdaptionField(packet);
    if (pusi) {
      payloadOffset += packet[payloadOffset] + 1;
    }
    if (!(packet[payloadOffset + 5] & 1)) {
      return;
    }
    var sectionLength, tableEnd, programInfoLength;
    sectionLength = (packet[payloadOffset + 1] & 15) << 8 | packet[payloadOffset + 2];
    tableEnd = 3 + sectionLength - 4;
    programInfoLength = (packet[payloadOffset + 10] & 15) << 8 | packet[payloadOffset + 11];
    var offset = 12 + programInfoLength;
    while (offset < tableEnd) {
      var i = payloadOffset + offset;
      programMapTable[(packet[i + 1] & 31) << 8 | packet[i + 2]] = packet[i];
      offset += ((packet[i + 3] & 15) << 8 | packet[i + 4]) + 5;
    }
    return programMapTable;
  };
  var parsePesType = function(packet, programMapTable) {
    var pid = parsePid(packet);
    var type2 = programMapTable[pid];
    switch (type2) {
      case StreamTypes$1.H264_STREAM_TYPE:
        return "video";
      case StreamTypes$1.ADTS_STREAM_TYPE:
        return "audio";
      case StreamTypes$1.METADATA_STREAM_TYPE:
        return "timed-metadata";
      default:
        return null;
    }
  };
  var parsePesTime = function(packet) {
    var pusi = parsePayloadUnitStartIndicator(packet);
    if (!pusi) {
      return null;
    }
    var offset = 4 + parseAdaptionField(packet);
    if (offset >= packet.byteLength) {
      return null;
    }
    var pes = null;
    var ptsDtsFlags;
    ptsDtsFlags = packet[offset + 7];
    if (ptsDtsFlags & 192) {
      pes = {};
      pes.pts = (packet[offset + 9] & 14) << 27 | (packet[offset + 10] & 255) << 20 | (packet[offset + 11] & 254) << 12 | (packet[offset + 12] & 255) << 5 | (packet[offset + 13] & 254) >>> 3;
      pes.pts *= 4;
      pes.pts += (packet[offset + 13] & 6) >>> 1;
      pes.dts = pes.pts;
      if (ptsDtsFlags & 64) {
        pes.dts = (packet[offset + 14] & 14) << 27 | (packet[offset + 15] & 255) << 20 | (packet[offset + 16] & 254) << 12 | (packet[offset + 17] & 255) << 5 | (packet[offset + 18] & 254) >>> 3;
        pes.dts *= 4;
        pes.dts += (packet[offset + 18] & 6) >>> 1;
      }
    }
    return pes;
  };
  var parseNalUnitType = function(type2) {
    switch (type2) {
      case 5:
        return "slice_layer_without_partitioning_rbsp_idr";
      case 6:
        return "sei_rbsp";
      case 7:
        return "seq_parameter_set_rbsp";
      case 8:
        return "pic_parameter_set_rbsp";
      case 9:
        return "access_unit_delimiter_rbsp";
      default:
        return null;
    }
  };
  var videoPacketContainsKeyFrame = function(packet) {
    var offset = 4 + parseAdaptionField(packet);
    var frameBuffer = packet.subarray(offset);
    var frameI = 0;
    var frameSyncPoint = 0;
    var foundKeyFrame = false;
    var nalType;
    for (; frameSyncPoint < frameBuffer.byteLength - 3; frameSyncPoint++) {
      if (frameBuffer[frameSyncPoint + 2] === 1) {
        frameI = frameSyncPoint + 5;
        break;
      }
    }
    while (frameI < frameBuffer.byteLength) {
      switch (frameBuffer[frameI]) {
        case 0:
          if (frameBuffer[frameI - 1] !== 0) {
            frameI += 2;
            break;
          } else if (frameBuffer[frameI - 2] !== 0) {
            frameI++;
            break;
          }
          if (frameSyncPoint + 3 !== frameI - 2) {
            nalType = parseNalUnitType(frameBuffer[frameSyncPoint + 3] & 31);
            if (nalType === "slice_layer_without_partitioning_rbsp_idr") {
              foundKeyFrame = true;
            }
          }
          do {
            frameI++;
          } while (frameBuffer[frameI] !== 1 && frameI < frameBuffer.length);
          frameSyncPoint = frameI - 2;
          frameI += 3;
          break;
        case 1:
          if (frameBuffer[frameI - 1] !== 0 || frameBuffer[frameI - 2] !== 0) {
            frameI += 3;
            break;
          }
          nalType = parseNalUnitType(frameBuffer[frameSyncPoint + 3] & 31);
          if (nalType === "slice_layer_without_partitioning_rbsp_idr") {
            foundKeyFrame = true;
          }
          frameSyncPoint = frameI - 2;
          frameI += 3;
          break;
        default:
          frameI += 3;
          break;
      }
    }
    frameBuffer = frameBuffer.subarray(frameSyncPoint);
    frameI -= frameSyncPoint;
    frameSyncPoint = 0;
    if (frameBuffer && frameBuffer.byteLength > 3) {
      nalType = parseNalUnitType(frameBuffer[frameSyncPoint + 3] & 31);
      if (nalType === "slice_layer_without_partitioning_rbsp_idr") {
        foundKeyFrame = true;
      }
    }
    return foundKeyFrame;
  };
  var probe$1 = {
    parseType,
    parsePat,
    parsePmt,
    parsePayloadUnitStartIndicator,
    parsePesType,
    parsePesTime,
    videoPacketContainsKeyFrame
  };
  var StreamTypes = streamTypes;
  var handleRollover = timestampRolloverStream.handleRollover;
  var probe = {};
  probe.ts = probe$1;
  probe.aac = utils2;
  var ONE_SECOND_IN_TS = clock$2.ONE_SECOND_IN_TS;
  var MP2T_PACKET_LENGTH = 188, SYNC_BYTE = 71;
  var parsePsi_ = function(bytes, pmt) {
    var startIndex = 0, endIndex = MP2T_PACKET_LENGTH, packet, type2;
    while (endIndex < bytes.byteLength) {
      if (bytes[startIndex] === SYNC_BYTE && bytes[endIndex] === SYNC_BYTE) {
        packet = bytes.subarray(startIndex, endIndex);
        type2 = probe.ts.parseType(packet, pmt.pid);
        switch (type2) {
          case "pat":
            pmt.pid = probe.ts.parsePat(packet);
            break;
          case "pmt":
            var table = probe.ts.parsePmt(packet);
            pmt.table = pmt.table || {};
            Object.keys(table).forEach(function(key) {
              pmt.table[key] = table[key];
            });
            break;
        }
        startIndex += MP2T_PACKET_LENGTH;
        endIndex += MP2T_PACKET_LENGTH;
        continue;
      }
      startIndex++;
      endIndex++;
    }
  };
  var parseAudioPes_ = function(bytes, pmt, result) {
    var startIndex = 0, endIndex = MP2T_PACKET_LENGTH, packet, type2, pesType, pusi, parsed;
    var endLoop = false;
    while (endIndex <= bytes.byteLength) {
      if (bytes[startIndex] === SYNC_BYTE && (bytes[endIndex] === SYNC_BYTE || endIndex === bytes.byteLength)) {
        packet = bytes.subarray(startIndex, endIndex);
        type2 = probe.ts.parseType(packet, pmt.pid);
        switch (type2) {
          case "pes":
            pesType = probe.ts.parsePesType(packet, pmt.table);
            pusi = probe.ts.parsePayloadUnitStartIndicator(packet);
            if (pesType === "audio" && pusi) {
              parsed = probe.ts.parsePesTime(packet);
              if (parsed) {
                parsed.type = "audio";
                result.audio.push(parsed);
                endLoop = true;
              }
            }
            break;
        }
        if (endLoop) {
          break;
        }
        startIndex += MP2T_PACKET_LENGTH;
        endIndex += MP2T_PACKET_LENGTH;
        continue;
      }
      startIndex++;
      endIndex++;
    }
    endIndex = bytes.byteLength;
    startIndex = endIndex - MP2T_PACKET_LENGTH;
    endLoop = false;
    while (startIndex >= 0) {
      if (bytes[startIndex] === SYNC_BYTE && (bytes[endIndex] === SYNC_BYTE || endIndex === bytes.byteLength)) {
        packet = bytes.subarray(startIndex, endIndex);
        type2 = probe.ts.parseType(packet, pmt.pid);
        switch (type2) {
          case "pes":
            pesType = probe.ts.parsePesType(packet, pmt.table);
            pusi = probe.ts.parsePayloadUnitStartIndicator(packet);
            if (pesType === "audio" && pusi) {
              parsed = probe.ts.parsePesTime(packet);
              if (parsed) {
                parsed.type = "audio";
                result.audio.push(parsed);
                endLoop = true;
              }
            }
            break;
        }
        if (endLoop) {
          break;
        }
        startIndex -= MP2T_PACKET_LENGTH;
        endIndex -= MP2T_PACKET_LENGTH;
        continue;
      }
      startIndex--;
      endIndex--;
    }
  };
  var parseVideoPes_ = function(bytes, pmt, result) {
    var startIndex = 0, endIndex = MP2T_PACKET_LENGTH, packet, type2, pesType, pusi, parsed, frame, i, pes;
    var endLoop = false;
    var currentFrame = {
      data: [],
      size: 0
    };
    while (endIndex < bytes.byteLength) {
      if (bytes[startIndex] === SYNC_BYTE && bytes[endIndex] === SYNC_BYTE) {
        packet = bytes.subarray(startIndex, endIndex);
        type2 = probe.ts.parseType(packet, pmt.pid);
        switch (type2) {
          case "pes":
            pesType = probe.ts.parsePesType(packet, pmt.table);
            pusi = probe.ts.parsePayloadUnitStartIndicator(packet);
            if (pesType === "video") {
              if (pusi && !endLoop) {
                parsed = probe.ts.parsePesTime(packet);
                if (parsed) {
                  parsed.type = "video";
                  result.video.push(parsed);
                  endLoop = true;
                }
              }
              if (!result.firstKeyFrame) {
                if (pusi) {
                  if (currentFrame.size !== 0) {
                    frame = new Uint8Array(currentFrame.size);
                    i = 0;
                    while (currentFrame.data.length) {
                      pes = currentFrame.data.shift();
                      frame.set(pes, i);
                      i += pes.byteLength;
                    }
                    if (probe.ts.videoPacketContainsKeyFrame(frame)) {
                      var firstKeyFrame = probe.ts.parsePesTime(frame);
                      if (firstKeyFrame) {
                        result.firstKeyFrame = firstKeyFrame;
                        result.firstKeyFrame.type = "video";
                      } else {
                        console.warn("Failed to extract PTS/DTS from PES at first keyframe. This could be an unusual TS segment, or else mux.js did not parse your TS segment correctly. If you know your TS segments do contain PTS/DTS on keyframes please file a bug report! You can try ffprobe to double check for yourself.");
                      }
                    }
                    currentFrame.size = 0;
                  }
                }
                currentFrame.data.push(packet);
                currentFrame.size += packet.byteLength;
              }
            }
            break;
        }
        if (endLoop && result.firstKeyFrame) {
          break;
        }
        startIndex += MP2T_PACKET_LENGTH;
        endIndex += MP2T_PACKET_LENGTH;
        continue;
      }
      startIndex++;
      endIndex++;
    }
    endIndex = bytes.byteLength;
    startIndex = endIndex - MP2T_PACKET_LENGTH;
    endLoop = false;
    while (startIndex >= 0) {
      if (bytes[startIndex] === SYNC_BYTE && bytes[endIndex] === SYNC_BYTE) {
        packet = bytes.subarray(startIndex, endIndex);
        type2 = probe.ts.parseType(packet, pmt.pid);
        switch (type2) {
          case "pes":
            pesType = probe.ts.parsePesType(packet, pmt.table);
            pusi = probe.ts.parsePayloadUnitStartIndicator(packet);
            if (pesType === "video" && pusi) {
              parsed = probe.ts.parsePesTime(packet);
              if (parsed) {
                parsed.type = "video";
                result.video.push(parsed);
                endLoop = true;
              }
            }
            break;
        }
        if (endLoop) {
          break;
        }
        startIndex -= MP2T_PACKET_LENGTH;
        endIndex -= MP2T_PACKET_LENGTH;
        continue;
      }
      startIndex--;
      endIndex--;
    }
  };
  var adjustTimestamp_ = function(segmentInfo, baseTimestamp) {
    if (segmentInfo.audio && segmentInfo.audio.length) {
      var audioBaseTimestamp = baseTimestamp;
      if (typeof audioBaseTimestamp === "undefined" || isNaN(audioBaseTimestamp)) {
        audioBaseTimestamp = segmentInfo.audio[0].dts;
      }
      segmentInfo.audio.forEach(function(info) {
        info.dts = handleRollover(info.dts, audioBaseTimestamp);
        info.pts = handleRollover(info.pts, audioBaseTimestamp);
        info.dtsTime = info.dts / ONE_SECOND_IN_TS;
        info.ptsTime = info.pts / ONE_SECOND_IN_TS;
      });
    }
    if (segmentInfo.video && segmentInfo.video.length) {
      var videoBaseTimestamp = baseTimestamp;
      if (typeof videoBaseTimestamp === "undefined" || isNaN(videoBaseTimestamp)) {
        videoBaseTimestamp = segmentInfo.video[0].dts;
      }
      segmentInfo.video.forEach(function(info) {
        info.dts = handleRollover(info.dts, videoBaseTimestamp);
        info.pts = handleRollover(info.pts, videoBaseTimestamp);
        info.dtsTime = info.dts / ONE_SECOND_IN_TS;
        info.ptsTime = info.pts / ONE_SECOND_IN_TS;
      });
      if (segmentInfo.firstKeyFrame) {
        var frame = segmentInfo.firstKeyFrame;
        frame.dts = handleRollover(frame.dts, videoBaseTimestamp);
        frame.pts = handleRollover(frame.pts, videoBaseTimestamp);
        frame.dtsTime = frame.dts / ONE_SECOND_IN_TS;
        frame.ptsTime = frame.pts / ONE_SECOND_IN_TS;
      }
    }
  };
  var inspectAac_ = function(bytes) {
    var endLoop = false, audioCount = 0, sampleRate = null, timestamp = null, frameSize = 0, byteIndex = 0, packet;
    while (bytes.length - byteIndex >= 3) {
      var type2 = probe.aac.parseType(bytes, byteIndex);
      switch (type2) {
        case "timed-metadata":
          if (bytes.length - byteIndex < 10) {
            endLoop = true;
            break;
          }
          frameSize = probe.aac.parseId3TagSize(bytes, byteIndex);
          if (frameSize > bytes.length) {
            endLoop = true;
            break;
          }
          if (timestamp === null) {
            packet = bytes.subarray(byteIndex, byteIndex + frameSize);
            timestamp = probe.aac.parseAacTimestamp(packet);
          }
          byteIndex += frameSize;
          break;
        case "audio":
          if (bytes.length - byteIndex < 7) {
            endLoop = true;
            break;
          }
          frameSize = probe.aac.parseAdtsSize(bytes, byteIndex);
          if (frameSize > bytes.length) {
            endLoop = true;
            break;
          }
          if (sampleRate === null) {
            packet = bytes.subarray(byteIndex, byteIndex + frameSize);
            sampleRate = probe.aac.parseSampleRate(packet);
          }
          audioCount++;
          byteIndex += frameSize;
          break;
        default:
          byteIndex++;
          break;
      }
      if (endLoop) {
        return null;
      }
    }
    if (sampleRate === null || timestamp === null) {
      return null;
    }
    var audioTimescale = ONE_SECOND_IN_TS / sampleRate;
    var result = {
      audio: [{
        type: "audio",
        dts: timestamp,
        pts: timestamp
      }, {
        type: "audio",
        dts: timestamp + audioCount * 1024 * audioTimescale,
        pts: timestamp + audioCount * 1024 * audioTimescale
      }]
    };
    return result;
  };
  var inspectTs_ = function(bytes) {
    var pmt = {
      pid: null,
      table: null
    };
    var result = {};
    parsePsi_(bytes, pmt);
    for (var pid in pmt.table) {
      if (pmt.table.hasOwnProperty(pid)) {
        var type2 = pmt.table[pid];
        switch (type2) {
          case StreamTypes.H264_STREAM_TYPE:
            result.video = [];
            parseVideoPes_(bytes, pmt, result);
            if (result.video.length === 0) {
              delete result.video;
            }
            break;
          case StreamTypes.ADTS_STREAM_TYPE:
            result.audio = [];
            parseAudioPes_(bytes, pmt, result);
            if (result.audio.length === 0) {
              delete result.audio;
            }
            break;
        }
      }
    }
    return result;
  };
  var inspect = function(bytes, baseTimestamp) {
    var isAacData = probe.aac.isLikelyAacData(bytes);
    var result;
    if (isAacData) {
      result = inspectAac_(bytes);
    } else {
      result = inspectTs_(bytes);
    }
    if (!result || !result.audio && !result.video) {
      return null;
    }
    adjustTimestamp_(result, baseTimestamp);
    return result;
  };
  var tsInspector = {
    inspect,
    parseAudioPes_
  };
  const wireTransmuxerEvents = function(self2, transmuxer2) {
    transmuxer2.on("data", function(segment) {
      const initArray = segment.initSegment;
      segment.initSegment = {
        data: initArray.buffer,
        byteOffset: initArray.byteOffset,
        byteLength: initArray.byteLength
      };
      const typedArray2 = segment.data;
      segment.data = typedArray2.buffer;
      self2.postMessage({
        action: "data",
        segment,
        byteOffset: typedArray2.byteOffset,
        byteLength: typedArray2.byteLength
      }, [segment.data]);
    });
    transmuxer2.on("done", function(data) {
      self2.postMessage({
        action: "done"
      });
    });
    transmuxer2.on("gopInfo", function(gopInfo) {
      self2.postMessage({
        action: "gopInfo",
        gopInfo
      });
    });
    transmuxer2.on("videoSegmentTimingInfo", function(timingInfo) {
      const videoSegmentTimingInfo = {
        start: {
          decode: clock$2.videoTsToSeconds(timingInfo.start.dts),
          presentation: clock$2.videoTsToSeconds(timingInfo.start.pts)
        },
        end: {
          decode: clock$2.videoTsToSeconds(timingInfo.end.dts),
          presentation: clock$2.videoTsToSeconds(timingInfo.end.pts)
        },
        baseMediaDecodeTime: clock$2.videoTsToSeconds(timingInfo.baseMediaDecodeTime)
      };
      if (timingInfo.prependedContentDuration) {
        videoSegmentTimingInfo.prependedContentDuration = clock$2.videoTsToSeconds(timingInfo.prependedContentDuration);
      }
      self2.postMessage({
        action: "videoSegmentTimingInfo",
        videoSegmentTimingInfo
      });
    });
    transmuxer2.on("audioSegmentTimingInfo", function(timingInfo) {
      const audioSegmentTimingInfo = {
        start: {
          decode: clock$2.videoTsToSeconds(timingInfo.start.dts),
          presentation: clock$2.videoTsToSeconds(timingInfo.start.pts)
        },
        end: {
          decode: clock$2.videoTsToSeconds(timingInfo.end.dts),
          presentation: clock$2.videoTsToSeconds(timingInfo.end.pts)
        },
        baseMediaDecodeTime: clock$2.videoTsToSeconds(timingInfo.baseMediaDecodeTime)
      };
      if (timingInfo.prependedContentDuration) {
        audioSegmentTimingInfo.prependedContentDuration = clock$2.videoTsToSeconds(timingInfo.prependedContentDuration);
      }
      self2.postMessage({
        action: "audioSegmentTimingInfo",
        audioSegmentTimingInfo
      });
    });
    transmuxer2.on("id3Frame", function(id3Frame) {
      self2.postMessage({
        action: "id3Frame",
        id3Frame
      });
    });
    transmuxer2.on("caption", function(caption) {
      self2.postMessage({
        action: "caption",
        caption
      });
    });
    transmuxer2.on("trackinfo", function(trackInfo) {
      self2.postMessage({
        action: "trackinfo",
        trackInfo
      });
    });
    transmuxer2.on("audioTimingInfo", function(audioTimingInfo) {
      self2.postMessage({
        action: "audioTimingInfo",
        audioTimingInfo: {
          start: clock$2.videoTsToSeconds(audioTimingInfo.start),
          end: clock$2.videoTsToSeconds(audioTimingInfo.end)
        }
      });
    });
    transmuxer2.on("videoTimingInfo", function(videoTimingInfo) {
      self2.postMessage({
        action: "videoTimingInfo",
        videoTimingInfo: {
          start: clock$2.videoTsToSeconds(videoTimingInfo.start),
          end: clock$2.videoTsToSeconds(videoTimingInfo.end)
        }
      });
    });
    transmuxer2.on("log", function(log2) {
      self2.postMessage({
        action: "log",
        log: log2
      });
    });
  };
  class MessageHandlers {
    constructor(self2, options) {
      this.options = options || {};
      this.self = self2;
      this.init();
    }
    init() {
      if (this.transmuxer) {
        this.transmuxer.dispose();
      }
      this.transmuxer = new transmuxer.Transmuxer(this.options);
      wireTransmuxerEvents(this.self, this.transmuxer);
    }
    pushMp4Captions(data) {
      if (!this.captionParser) {
        this.captionParser = new captionParser();
        this.captionParser.init();
      }
      const segment = new Uint8Array(data.data, data.byteOffset, data.byteLength);
      const parsed = this.captionParser.parse(segment, data.trackIds, data.timescales);
      this.self.postMessage({
        action: "mp4Captions",
        captions: parsed && parsed.captions || [],
        logs: parsed && parsed.logs || [],
        data: segment.buffer
      }, [segment.buffer]);
    }
    initMp4WebVttParser(data) {
      if (!this.webVttParser) {
        this.webVttParser = new webvttParser();
      }
      const segment = new Uint8Array(data.data, data.byteOffset, data.byteLength);
      this.webVttParser.init(segment);
    }
    getMp4WebVttText(data) {
      if (!this.webVttParser) {
        this.webVttParser = new webvttParser();
      }
      const segment = new Uint8Array(data.data, data.byteOffset, data.byteLength);
      const parsed = this.webVttParser.parseSegment(segment);
      this.self.postMessage({
        action: "getMp4WebVttText",
        mp4VttCues: parsed || [],
        data: segment.buffer
      }, [segment.buffer]);
    }
    probeMp4StartTime({
      timescales,
      data
    }) {
      const startTime2 = probe$2.startTime(timescales, data);
      this.self.postMessage({
        action: "probeMp4StartTime",
        startTime: startTime2,
        data
      }, [data.buffer]);
    }
    probeMp4Tracks({
      data
    }) {
      const tracks = probe$2.tracks(data);
      this.self.postMessage({
        action: "probeMp4Tracks",
        tracks,
        data
      }, [data.buffer]);
    }
    probeEmsgID3({
      data,
      offset
    }) {
      const id3Frames = probe$2.getEmsgID3(data, offset);
      this.self.postMessage({
        action: "probeEmsgID3",
        id3Frames,
        emsgData: data
      }, [data.buffer]);
    }
    probeTs({
      data,
      baseStartTime
    }) {
      const tsStartTime = typeof baseStartTime === "number" && !isNaN(baseStartTime) ? baseStartTime * clock$2.ONE_SECOND_IN_TS : void 0;
      const timeInfo = tsInspector.inspect(data, tsStartTime);
      let result = null;
      if (timeInfo) {
        result = {
          hasVideo: timeInfo.video && timeInfo.video.length === 2 || false,
          hasAudio: timeInfo.audio && timeInfo.audio.length === 2 || false
        };
        if (result.hasVideo) {
          result.videoStart = timeInfo.video[0].ptsTime;
        }
        if (result.hasAudio) {
          result.audioStart = timeInfo.audio[0].ptsTime;
        }
      }
      this.self.postMessage({
        action: "probeTs",
        result,
        data
      }, [data.buffer]);
    }
    clearAllMp4Captions() {
      if (this.captionParser) {
        this.captionParser.clearAllCaptions();
      }
    }
    clearParsedMp4Captions() {
      if (this.captionParser) {
        this.captionParser.clearParsedCaptions();
      }
    }
    push(data) {
      const segment = new Uint8Array(data.data, data.byteOffset, data.byteLength);
      this.transmuxer.push(segment);
    }
    reset() {
      this.transmuxer.reset();
    }
    setTimestampOffset(data) {
      const timestampOffset = data.timestampOffset || 0;
      this.transmuxer.setBaseMediaDecodeTime(Math.round(clock$2.secondsToVideoTs(timestampOffset)));
    }
    setAudioAppendStart(data) {
      this.transmuxer.setAudioAppendStart(Math.ceil(clock$2.secondsToVideoTs(data.appendStart)));
    }
    setRemux(data) {
      this.transmuxer.setRemux(data.remux);
    }
    flush(data) {
      this.transmuxer.flush();
      self.postMessage({
        action: "done",
        type: "transmuxed"
      });
    }
    endTimeline() {
      this.transmuxer.endTimeline();
      self.postMessage({
        action: "endedtimeline",
        type: "transmuxed"
      });
    }
    alignGopsWith(data) {
      this.transmuxer.alignGopsWith(data.gopsToAlignWith.slice());
    }
  }
  self.onmessage = function(event) {
    if (event.data.action === "init" && event.data.options) {
      this.messageHandlers = new MessageHandlers(self, event.data.options);
      return;
    }
    if (!this.messageHandlers) {
      this.messageHandlers = new MessageHandlers(self);
    }
    if (event.data && event.data.action && event.data.action !== "init") {
      if (this.messageHandlers[event.data.action]) {
        this.messageHandlers[event.data.action](event.data);
      }
    }
  };
}));
var TransmuxWorker = factory(workerCode$1);
const handleData_ = (event, transmuxedData, callback) => {
  const {
    type,
    initSegment,
    captions,
    captionStreams,
    metadata,
    videoFrameDtsTime,
    videoFramePtsTime
  } = event.data.segment;
  transmuxedData.buffer.push({
    captions,
    captionStreams,
    metadata
  });
  const boxes = event.data.segment.boxes || {
    data: event.data.segment.data
  };
  const result = {
    type,
    data: new Uint8Array(boxes.data, boxes.data.byteOffset, boxes.data.byteLength),
    initSegment: new Uint8Array(initSegment.data, initSegment.byteOffset, initSegment.byteLength)
  };
  if (typeof videoFrameDtsTime !== "undefined") {
    result.videoFrameDtsTime = videoFrameDtsTime;
  }
  if (typeof videoFramePtsTime !== "undefined") {
    result.videoFramePtsTime = videoFramePtsTime;
  }
  callback(result);
};
const handleDone_ = ({
  transmuxedData,
  callback
}) => {
  transmuxedData.buffer = [];
  callback(transmuxedData);
};
const handleGopInfo_ = (event, transmuxedData) => {
  transmuxedData.gopInfo = event.data.gopInfo;
};
const processTransmux = (options) => {
  const {
    transmuxer,
    bytes,
    audioAppendStart,
    gopsToAlignWith,
    remux,
    onData,
    onTrackInfo,
    onAudioTimingInfo,
    onVideoTimingInfo,
    onVideoSegmentTimingInfo,
    onAudioSegmentTimingInfo,
    onId3,
    onCaptions,
    onDone,
    onEndedTimeline,
    onTransmuxerLog,
    isEndOfTimeline,
    segment,
    triggerSegmentEventFn
  } = options;
  const transmuxedData = {
    buffer: []
  };
  let waitForEndedTimelineEvent = isEndOfTimeline;
  const handleMessage = (event) => {
    if (transmuxer.currentTransmux !== options) {
      return;
    }
    if (event.data.action === "data") {
      handleData_(event, transmuxedData, onData);
    }
    if (event.data.action === "trackinfo") {
      onTrackInfo(event.data.trackInfo);
    }
    if (event.data.action === "gopInfo") {
      handleGopInfo_(event, transmuxedData);
    }
    if (event.data.action === "audioTimingInfo") {
      onAudioTimingInfo(event.data.audioTimingInfo);
    }
    if (event.data.action === "videoTimingInfo") {
      onVideoTimingInfo(event.data.videoTimingInfo);
    }
    if (event.data.action === "videoSegmentTimingInfo") {
      onVideoSegmentTimingInfo(event.data.videoSegmentTimingInfo);
    }
    if (event.data.action === "audioSegmentTimingInfo") {
      onAudioSegmentTimingInfo(event.data.audioSegmentTimingInfo);
    }
    if (event.data.action === "id3Frame") {
      onId3([event.data.id3Frame], event.data.id3Frame.dispatchType);
    }
    if (event.data.action === "caption") {
      onCaptions(event.data.caption);
    }
    if (event.data.action === "endedtimeline") {
      waitForEndedTimelineEvent = false;
      onEndedTimeline();
    }
    if (event.data.action === "log") {
      onTransmuxerLog(event.data.log);
    }
    if (event.data.type !== "transmuxed") {
      return;
    }
    if (waitForEndedTimelineEvent) {
      return;
    }
    transmuxer.onmessage = null;
    handleDone_({
      transmuxedData,
      callback: onDone
    });
    dequeue(transmuxer);
  };
  const handleError = () => {
    const error = {
      message: "Received an error message from the transmuxer worker",
      metadata: {
        errorType: videojs.Error.StreamingFailedToTransmuxSegment,
        segmentInfo: segmentInfoPayload({
          segment
        })
      }
    };
    onDone(null, error);
  };
  transmuxer.onmessage = handleMessage;
  transmuxer.onerror = handleError;
  if (audioAppendStart) {
    transmuxer.postMessage({
      action: "setAudioAppendStart",
      appendStart: audioAppendStart
    });
  }
  if (Array.isArray(gopsToAlignWith)) {
    transmuxer.postMessage({
      action: "alignGopsWith",
      gopsToAlignWith
    });
  }
  if (typeof remux !== "undefined") {
    transmuxer.postMessage({
      action: "setRemux",
      remux
    });
  }
  if (bytes.byteLength) {
    const buffer = bytes instanceof ArrayBuffer ? bytes : bytes.buffer;
    const byteOffset = bytes instanceof ArrayBuffer ? 0 : bytes.byteOffset;
    triggerSegmentEventFn({
      type: "segmenttransmuxingstart",
      segment
    });
    transmuxer.postMessage({
      action: "push",
      data: buffer,
      byteOffset,
      byteLength: bytes.byteLength
    }, [buffer]);
  }
  if (isEndOfTimeline) {
    transmuxer.postMessage({
      action: "endTimeline"
    });
  }
  transmuxer.postMessage({
    action: "flush"
  });
};
const dequeue = (transmuxer) => {
  transmuxer.currentTransmux = null;
  if (transmuxer.transmuxQueue.length) {
    transmuxer.currentTransmux = transmuxer.transmuxQueue.shift();
    if (typeof transmuxer.currentTransmux === "function") {
      transmuxer.currentTransmux();
    } else {
      processTransmux(transmuxer.currentTransmux);
    }
  }
};
const processAction = (transmuxer, action) => {
  transmuxer.postMessage({
    action
  });
  dequeue(transmuxer);
};
const enqueueAction = (action, transmuxer) => {
  if (!transmuxer.currentTransmux) {
    transmuxer.currentTransmux = action;
    processAction(transmuxer, action);
    return;
  }
  transmuxer.transmuxQueue.push(processAction.bind(null, transmuxer, action));
};
const reset = (transmuxer) => {
  enqueueAction("reset", transmuxer);
};
const endTimeline = (transmuxer) => {
  enqueueAction("endTimeline", transmuxer);
};
const transmux = (options) => {
  if (!options.transmuxer.currentTransmux) {
    options.transmuxer.currentTransmux = options;
    processTransmux(options);
    return;
  }
  options.transmuxer.transmuxQueue.push(options);
};
const createTransmuxer = (options) => {
  const transmuxer = new TransmuxWorker();
  transmuxer.currentTransmux = null;
  transmuxer.transmuxQueue = [];
  const term = transmuxer.terminate;
  transmuxer.terminate = () => {
    transmuxer.currentTransmux = null;
    transmuxer.transmuxQueue.length = 0;
    return term.call(transmuxer);
  };
  transmuxer.postMessage({
    action: "init",
    options
  });
  return transmuxer;
};
var segmentTransmuxer = {
  reset,
  endTimeline,
  transmux,
  createTransmuxer
};
const workerCallback = function(options) {
  const transmuxer = options.transmuxer;
  const endAction = options.endAction || options.action;
  const callback = options.callback;
  const message = _extends({}, options, {
    endAction: null,
    transmuxer: null,
    callback: null
  });
  const listenForEndEvent = (event) => {
    if (event.data.action !== endAction) {
      return;
    }
    transmuxer.removeEventListener("message", listenForEndEvent);
    if (event.data.data) {
      event.data.data = new Uint8Array(event.data.data, options.byteOffset || 0, options.byteLength || event.data.data.byteLength);
      if (options.data) {
        options.data = event.data.data;
      }
    }
    callback(event.data);
  };
  transmuxer.addEventListener("message", listenForEndEvent);
  if (options.data) {
    const isArrayBuffer = options.data instanceof ArrayBuffer;
    message.byteOffset = isArrayBuffer ? 0 : options.data.byteOffset;
    message.byteLength = options.data.byteLength;
    const transfers = [isArrayBuffer ? options.data : options.data.buffer];
    transmuxer.postMessage(message, transfers);
  } else {
    transmuxer.postMessage(message);
  }
};
const REQUEST_ERRORS = {
  FAILURE: 2,
  TIMEOUT: -101,
  ABORTED: -102
};
const WEB_VTT_CODEC = "wvtt";
const abortAll = (activeXhrs) => {
  activeXhrs.forEach((xhr) => {
    xhr.abort();
  });
};
const getRequestStats = (request) => {
  return {
    bandwidth: request.bandwidth,
    bytesReceived: request.bytesReceived || 0,
    roundTripTime: request.roundTripTime || 0
  };
};
const getProgressStats = (progressEvent) => {
  const request = progressEvent.target;
  const roundTripTime = Date.now() - request.requestTime;
  const stats = {
    bandwidth: Infinity,
    bytesReceived: 0,
    roundTripTime: roundTripTime || 0
  };
  stats.bytesReceived = progressEvent.loaded;
  stats.bandwidth = Math.floor(stats.bytesReceived / stats.roundTripTime * 8 * 1e3);
  return stats;
};
const handleErrors = (error, request) => {
  const {
    requestType
  } = request;
  const metadata = getStreamingNetworkErrorMetadata({
    requestType,
    request,
    error
  });
  if (request.timedout) {
    return {
      status: request.status,
      message: "HLS request timed-out at URL: " + request.uri,
      code: REQUEST_ERRORS.TIMEOUT,
      xhr: request,
      metadata
    };
  }
  if (request.aborted) {
    return {
      status: request.status,
      message: "HLS request aborted at URL: " + request.uri,
      code: REQUEST_ERRORS.ABORTED,
      xhr: request,
      metadata
    };
  }
  if (error) {
    return {
      status: request.status,
      message: "HLS request errored at URL: " + request.uri,
      code: REQUEST_ERRORS.FAILURE,
      xhr: request,
      metadata
    };
  }
  if (request.responseType === "arraybuffer" && request.response.byteLength === 0) {
    return {
      status: request.status,
      message: "Empty HLS response at URL: " + request.uri,
      code: REQUEST_ERRORS.FAILURE,
      xhr: request,
      metadata
    };
  }
  return null;
};
const handleKeyResponse = (segment, objects, finishProcessingFn, triggerSegmentEventFn) => (error, request) => {
  const response = request.response;
  const errorObj = handleErrors(error, request);
  if (errorObj) {
    return finishProcessingFn(errorObj, segment);
  }
  if (response.byteLength !== 16) {
    return finishProcessingFn({
      status: request.status,
      message: "Invalid HLS key at URL: " + request.uri,
      code: REQUEST_ERRORS.FAILURE,
      xhr: request
    }, segment);
  }
  const view = new DataView(response);
  const bytes = new Uint32Array([view.getUint32(0), view.getUint32(4), view.getUint32(8), view.getUint32(12)]);
  for (let i = 0; i < objects.length; i++) {
    objects[i].bytes = bytes;
  }
  const keyInfo = {
    uri: request.uri
  };
  triggerSegmentEventFn({
    type: "segmentkeyloadcomplete",
    segment,
    keyInfo
  });
  return finishProcessingFn(null, segment);
};
const initMp4Text = (segment, codec) => {
  if (codec === WEB_VTT_CODEC) {
    segment.transmuxer.postMessage({
      action: "initMp4WebVttParser",
      data: segment.map.bytes
    });
  }
};
const parseMp4TextSegment = (segment, codec, doneFn) => {
  if (codec === WEB_VTT_CODEC) {
    workerCallback({
      action: "getMp4WebVttText",
      data: segment.bytes,
      transmuxer: segment.transmuxer,
      callback: ({
        data,
        mp4VttCues
      }) => {
        segment.bytes = data;
        doneFn(null, segment, {
          mp4VttCues
        });
      }
    });
  }
};
const parseInitSegment = (segment, callback) => {
  const type = detectContainerForBytes(segment.map.bytes);
  if (type !== "mp4") {
    const uri = segment.map.resolvedUri || segment.map.uri;
    const mediaType = type || "unknown";
    return callback({
      internal: true,
      message: `Found unsupported ${mediaType} container for initialization segment at URL: ${uri}`,
      code: REQUEST_ERRORS.FAILURE,
      metadata: {
        mediaType
      }
    });
  }
  workerCallback({
    action: "probeMp4Tracks",
    data: segment.map.bytes,
    transmuxer: segment.transmuxer,
    callback: ({
      tracks,
      data
    }) => {
      segment.map.bytes = data;
      tracks.forEach(function(track) {
        segment.map.tracks = segment.map.tracks || {};
        if (segment.map.tracks[track.type]) {
          return;
        }
        segment.map.tracks[track.type] = track;
        if (typeof track.id === "number" && track.timescale) {
          segment.map.timescales = segment.map.timescales || {};
          segment.map.timescales[track.id] = track.timescale;
        }
        if (track.type === "text") {
          initMp4Text(segment, track.codec);
        }
      });
      return callback(null);
    }
  });
};
const handleInitSegmentResponse = ({
  segment,
  finishProcessingFn,
  triggerSegmentEventFn
}) => (error, request) => {
  const errorObj = handleErrors(error, request);
  if (errorObj) {
    return finishProcessingFn(errorObj, segment);
  }
  const bytes = new Uint8Array(request.response);
  triggerSegmentEventFn({
    type: "segmentloaded",
    segment
  });
  if (segment.map.key) {
    segment.map.encryptedBytes = bytes;
    return finishProcessingFn(null, segment);
  }
  segment.map.bytes = bytes;
  parseInitSegment(segment, function(parseError) {
    if (parseError) {
      parseError.xhr = request;
      parseError.status = request.status;
      return finishProcessingFn(parseError, segment);
    }
    finishProcessingFn(null, segment);
  });
};
const handleSegmentResponse = ({
  segment,
  finishProcessingFn,
  responseType,
  triggerSegmentEventFn
}) => (error, request) => {
  const errorObj = handleErrors(error, request);
  if (errorObj) {
    return finishProcessingFn(errorObj, segment);
  }
  triggerSegmentEventFn({
    type: "segmentloaded",
    segment
  });
  const newBytes = responseType === "arraybuffer" || !request.responseText ? request.response : stringToArrayBuffer(request.responseText.substring(segment.lastReachedChar || 0));
  segment.stats = getRequestStats(request);
  if (segment.key) {
    segment.encryptedBytes = new Uint8Array(newBytes);
  } else {
    segment.bytes = new Uint8Array(newBytes);
  }
  return finishProcessingFn(null, segment);
};
const transmuxAndNotify = ({
  segment,
  bytes,
  trackInfoFn,
  timingInfoFn,
  videoSegmentTimingInfoFn,
  audioSegmentTimingInfoFn,
  id3Fn,
  captionsFn,
  isEndOfTimeline,
  endedTimelineFn,
  dataFn,
  doneFn,
  onTransmuxerLog,
  triggerSegmentEventFn
}) => {
  const fmp4Tracks = segment.map && segment.map.tracks || {};
  const isMuxed2 = Boolean(fmp4Tracks.audio && fmp4Tracks.video);
  let audioStartFn = timingInfoFn.bind(null, segment, "audio", "start");
  const audioEndFn = timingInfoFn.bind(null, segment, "audio", "end");
  let videoStartFn = timingInfoFn.bind(null, segment, "video", "start");
  const videoEndFn = timingInfoFn.bind(null, segment, "video", "end");
  const finish = () => transmux({
    bytes,
    transmuxer: segment.transmuxer,
    audioAppendStart: segment.audioAppendStart,
    gopsToAlignWith: segment.gopsToAlignWith,
    remux: isMuxed2,
    onData: (result) => {
      result.type = result.type === "combined" ? "video" : result.type;
      dataFn(segment, result);
    },
    onTrackInfo: (trackInfo) => {
      if (trackInfoFn) {
        if (isMuxed2) {
          trackInfo.isMuxed = true;
        }
        trackInfoFn(segment, trackInfo);
      }
    },
    onAudioTimingInfo: (audioTimingInfo) => {
      if (audioStartFn && typeof audioTimingInfo.start !== "undefined") {
        audioStartFn(audioTimingInfo.start);
        audioStartFn = null;
      }
      if (audioEndFn && typeof audioTimingInfo.end !== "undefined") {
        audioEndFn(audioTimingInfo.end);
      }
    },
    onVideoTimingInfo: (videoTimingInfo) => {
      if (videoStartFn && typeof videoTimingInfo.start !== "undefined") {
        videoStartFn(videoTimingInfo.start);
        videoStartFn = null;
      }
      if (videoEndFn && typeof videoTimingInfo.end !== "undefined") {
        videoEndFn(videoTimingInfo.end);
      }
    },
    onVideoSegmentTimingInfo: (videoSegmentTimingInfo) => {
      const timingInfo = {
        pts: {
          start: videoSegmentTimingInfo.start.presentation,
          end: videoSegmentTimingInfo.end.presentation
        },
        dts: {
          start: videoSegmentTimingInfo.start.decode,
          end: videoSegmentTimingInfo.end.decode
        }
      };
      triggerSegmentEventFn({
        type: "segmenttransmuxingtiminginfoavailable",
        segment,
        timingInfo
      });
      videoSegmentTimingInfoFn(videoSegmentTimingInfo);
    },
    onAudioSegmentTimingInfo: (audioSegmentTimingInfo) => {
      const timingInfo = {
        pts: {
          start: audioSegmentTimingInfo.start.pts,
          end: audioSegmentTimingInfo.end.pts
        },
        dts: {
          start: audioSegmentTimingInfo.start.dts,
          end: audioSegmentTimingInfo.end.dts
        }
      };
      triggerSegmentEventFn({
        type: "segmenttransmuxingtiminginfoavailable",
        segment,
        timingInfo
      });
      audioSegmentTimingInfoFn(audioSegmentTimingInfo);
    },
    onId3: (id3Frames, dispatchType) => {
      id3Fn(segment, id3Frames, dispatchType);
    },
    onCaptions: (captions) => {
      captionsFn(segment, [captions]);
    },
    isEndOfTimeline,
    onEndedTimeline: () => {
      endedTimelineFn();
    },
    onTransmuxerLog,
    onDone: (result, error) => {
      if (!doneFn) {
        return;
      }
      result.type = result.type === "combined" ? "video" : result.type;
      triggerSegmentEventFn({
        type: "segmenttransmuxingcomplete",
        segment
      });
      doneFn(error, segment, result);
    },
    segment,
    triggerSegmentEventFn
  });
  workerCallback({
    action: "probeTs",
    transmuxer: segment.transmuxer,
    data: bytes,
    baseStartTime: segment.baseStartTime,
    callback: (data) => {
      segment.bytes = bytes = data.data;
      const probeResult = data.result;
      if (probeResult) {
        trackInfoFn(segment, {
          hasAudio: probeResult.hasAudio,
          hasVideo: probeResult.hasVideo,
          isMuxed: isMuxed2
        });
        trackInfoFn = null;
      }
      finish();
    }
  });
};
const handleSegmentBytes = ({
  segment,
  bytes,
  trackInfoFn,
  timingInfoFn,
  videoSegmentTimingInfoFn,
  audioSegmentTimingInfoFn,
  id3Fn,
  captionsFn,
  isEndOfTimeline,
  endedTimelineFn,
  dataFn,
  doneFn,
  onTransmuxerLog,
  triggerSegmentEventFn
}) => {
  let bytesAsUint8Array = new Uint8Array(bytes);
  if (isLikelyFmp4MediaSegment(bytesAsUint8Array)) {
    segment.isFmp4 = true;
    const {
      tracks
    } = segment.map;
    const isMp4TextSegment = tracks.text && (!tracks.audio || !tracks.video);
    if (isMp4TextSegment) {
      dataFn(segment, {
        data: bytesAsUint8Array,
        type: "text"
      });
      parseMp4TextSegment(segment, tracks.text.codec, doneFn);
      return;
    }
    const trackInfo = {
      isFmp4: true,
      hasVideo: !!tracks.video,
      hasAudio: !!tracks.audio
    };
    if (tracks.audio && tracks.audio.codec && tracks.audio.codec !== "enca") {
      trackInfo.audioCodec = tracks.audio.codec;
    }
    if (tracks.video && tracks.video.codec && tracks.video.codec !== "encv") {
      trackInfo.videoCodec = tracks.video.codec;
    }
    if (tracks.video && tracks.audio) {
      trackInfo.isMuxed = true;
    }
    trackInfoFn(segment, trackInfo);
    const finishLoading = (captions, id3Frames) => {
      dataFn(segment, {
        data: bytesAsUint8Array,
        type: trackInfo.hasAudio && !trackInfo.isMuxed ? "audio" : "video"
      });
      if (id3Frames && id3Frames.length) {
        id3Fn(segment, id3Frames);
      }
      if (captions && captions.length) {
        captionsFn(segment, captions);
      }
      doneFn(null, segment, {});
    };
    workerCallback({
      action: "probeMp4StartTime",
      timescales: segment.map.timescales,
      data: bytesAsUint8Array,
      transmuxer: segment.transmuxer,
      callback: ({
        data,
        startTime
      }) => {
        bytes = data.buffer;
        segment.bytes = bytesAsUint8Array = data;
        if (trackInfo.hasAudio && !trackInfo.isMuxed) {
          timingInfoFn(segment, "audio", "start", startTime);
        }
        if (trackInfo.hasVideo) {
          timingInfoFn(segment, "video", "start", startTime);
        }
        workerCallback({
          action: "probeEmsgID3",
          data: bytesAsUint8Array,
          transmuxer: segment.transmuxer,
          offset: startTime,
          callback: ({
            emsgData,
            id3Frames
          }) => {
            bytes = emsgData.buffer;
            segment.bytes = bytesAsUint8Array = emsgData;
            if (!tracks.video || !emsgData.byteLength || !segment.transmuxer) {
              finishLoading(void 0, id3Frames);
              return;
            }
            workerCallback({
              action: "pushMp4Captions",
              endAction: "mp4Captions",
              transmuxer: segment.transmuxer,
              data: bytesAsUint8Array,
              timescales: segment.map.timescales,
              trackIds: [tracks.video.id],
              callback: (message) => {
                bytes = message.data.buffer;
                segment.bytes = bytesAsUint8Array = message.data;
                message.logs.forEach(function(log2) {
                  onTransmuxerLog(merge(log2, {
                    stream: "mp4CaptionParser"
                  }));
                });
                finishLoading(message.captions, id3Frames);
              }
            });
          }
        });
      }
    });
    return;
  }
  if (!segment.transmuxer) {
    doneFn(null, segment, {});
    return;
  }
  if (typeof segment.container === "undefined") {
    segment.container = detectContainerForBytes(bytesAsUint8Array);
  }
  if (segment.container !== "ts" && segment.container !== "aac") {
    trackInfoFn(segment, {
      hasAudio: false,
      hasVideo: false
    });
    doneFn(null, segment, {});
    return;
  }
  transmuxAndNotify({
    segment,
    bytes,
    trackInfoFn,
    timingInfoFn,
    videoSegmentTimingInfoFn,
    audioSegmentTimingInfoFn,
    id3Fn,
    captionsFn,
    isEndOfTimeline,
    endedTimelineFn,
    dataFn,
    doneFn,
    onTransmuxerLog,
    triggerSegmentEventFn
  });
};
const decrypt = function({
  id,
  key,
  encryptedBytes,
  decryptionWorker,
  segment,
  doneFn
}, callback) {
  const decryptionHandler = (event) => {
    if (event.data.source === id) {
      decryptionWorker.removeEventListener("message", decryptionHandler);
      const decrypted = event.data.decrypted;
      callback(new Uint8Array(decrypted.bytes, decrypted.byteOffset, decrypted.byteLength));
    }
  };
  decryptionWorker.onerror = () => {
    const message = "An error occurred in the decryption worker";
    const segmentInfo = segmentInfoPayload({
      segment
    });
    const decryptError = {
      message,
      metadata: {
        error: new Error(message),
        errorType: videojs.Error.StreamingFailedToDecryptSegment,
        segmentInfo,
        keyInfo: {
          uri: segment.key.resolvedUri || segment.map.key.resolvedUri
        }
      }
    };
    doneFn(decryptError, segment);
  };
  decryptionWorker.addEventListener("message", decryptionHandler);
  let keyBytes;
  if (key.bytes.slice) {
    keyBytes = key.bytes.slice();
  } else {
    keyBytes = new Uint32Array(Array.prototype.slice.call(key.bytes));
  }
  decryptionWorker.postMessage(createTransferableMessage({
    source: id,
    encrypted: encryptedBytes,
    key: keyBytes,
    iv: key.iv
  }), [encryptedBytes.buffer, keyBytes.buffer]);
};
const decryptSegment = ({
  decryptionWorker,
  segment,
  trackInfoFn,
  timingInfoFn,
  videoSegmentTimingInfoFn,
  audioSegmentTimingInfoFn,
  id3Fn,
  captionsFn,
  isEndOfTimeline,
  endedTimelineFn,
  dataFn,
  doneFn,
  onTransmuxerLog,
  triggerSegmentEventFn
}) => {
  triggerSegmentEventFn({
    type: "segmentdecryptionstart"
  });
  decrypt({
    id: segment.requestId,
    key: segment.key,
    encryptedBytes: segment.encryptedBytes,
    decryptionWorker,
    segment,
    doneFn
  }, (decryptedBytes) => {
    segment.bytes = decryptedBytes;
    triggerSegmentEventFn({
      type: "segmentdecryptioncomplete",
      segment
    });
    handleSegmentBytes({
      segment,
      bytes: segment.bytes,
      trackInfoFn,
      timingInfoFn,
      videoSegmentTimingInfoFn,
      audioSegmentTimingInfoFn,
      id3Fn,
      captionsFn,
      isEndOfTimeline,
      endedTimelineFn,
      dataFn,
      doneFn,
      onTransmuxerLog,
      triggerSegmentEventFn
    });
  });
};
const waitForCompletion = ({
  activeXhrs,
  decryptionWorker,
  trackInfoFn,
  timingInfoFn,
  videoSegmentTimingInfoFn,
  audioSegmentTimingInfoFn,
  id3Fn,
  captionsFn,
  isEndOfTimeline,
  endedTimelineFn,
  dataFn,
  doneFn,
  onTransmuxerLog,
  triggerSegmentEventFn
}) => {
  let count = 0;
  let didError = false;
  return (error, segment) => {
    if (didError) {
      return;
    }
    if (error) {
      didError = true;
      abortAll(activeXhrs);
      return doneFn(error, segment);
    }
    count += 1;
    if (count === activeXhrs.length) {
      const segmentFinish = function() {
        if (segment.encryptedBytes) {
          return decryptSegment({
            decryptionWorker,
            segment,
            trackInfoFn,
            timingInfoFn,
            videoSegmentTimingInfoFn,
            audioSegmentTimingInfoFn,
            id3Fn,
            captionsFn,
            isEndOfTimeline,
            endedTimelineFn,
            dataFn,
            doneFn,
            onTransmuxerLog,
            triggerSegmentEventFn
          });
        }
        handleSegmentBytes({
          segment,
          bytes: segment.bytes,
          trackInfoFn,
          timingInfoFn,
          videoSegmentTimingInfoFn,
          audioSegmentTimingInfoFn,
          id3Fn,
          captionsFn,
          isEndOfTimeline,
          endedTimelineFn,
          dataFn,
          doneFn,
          onTransmuxerLog,
          triggerSegmentEventFn
        });
      };
      segment.endOfAllRequests = Date.now();
      if (segment.map && segment.map.encryptedBytes && !segment.map.bytes) {
        triggerSegmentEventFn({
          type: "segmentdecryptionstart",
          segment
        });
        return decrypt({
          decryptionWorker,
          id: segment.requestId + "-init",
          encryptedBytes: segment.map.encryptedBytes,
          key: segment.map.key,
          segment,
          doneFn
        }, (decryptedBytes) => {
          segment.map.bytes = decryptedBytes;
          triggerSegmentEventFn({
            type: "segmentdecryptioncomplete",
            segment
          });
          parseInitSegment(segment, (parseError) => {
            if (parseError) {
              abortAll(activeXhrs);
              return doneFn(parseError, segment);
            }
            segmentFinish();
          });
        });
      }
      segmentFinish();
    }
  };
};
const handleLoadEnd = ({
  loadendState,
  abortFn
}) => (event) => {
  const request = event.target;
  if (request.aborted && abortFn && !loadendState.calledAbortFn) {
    abortFn();
    loadendState.calledAbortFn = true;
  }
};
const handleProgress = ({
  segment,
  progressFn,
  trackInfoFn,
  timingInfoFn,
  videoSegmentTimingInfoFn,
  audioSegmentTimingInfoFn,
  id3Fn,
  captionsFn,
  isEndOfTimeline,
  endedTimelineFn,
  dataFn
}) => (event) => {
  const request = event.target;
  if (request.aborted) {
    return;
  }
  segment.stats = merge(segment.stats, getProgressStats(event));
  if (!segment.stats.firstBytesReceivedAt && segment.stats.bytesReceived) {
    segment.stats.firstBytesReceivedAt = Date.now();
  }
  return progressFn(event, segment);
};
const mediaSegmentRequest = ({
  xhr,
  xhrOptions,
  decryptionWorker,
  segment,
  abortFn,
  progressFn,
  trackInfoFn,
  timingInfoFn,
  videoSegmentTimingInfoFn,
  audioSegmentTimingInfoFn,
  id3Fn,
  captionsFn,
  isEndOfTimeline,
  endedTimelineFn,
  dataFn,
  doneFn,
  onTransmuxerLog,
  triggerSegmentEventFn
}) => {
  const activeXhrs = [];
  const finishProcessingFn = waitForCompletion({
    activeXhrs,
    decryptionWorker,
    trackInfoFn,
    timingInfoFn,
    videoSegmentTimingInfoFn,
    audioSegmentTimingInfoFn,
    id3Fn,
    captionsFn,
    isEndOfTimeline,
    endedTimelineFn,
    dataFn,
    doneFn,
    onTransmuxerLog,
    triggerSegmentEventFn
  });
  if (segment.key && !segment.key.bytes) {
    const objects = [segment.key];
    if (segment.map && !segment.map.bytes && segment.map.key && segment.map.key.resolvedUri === segment.key.resolvedUri) {
      objects.push(segment.map.key);
    }
    const keyRequestOptions = merge(xhrOptions, {
      uri: segment.key.resolvedUri,
      responseType: "arraybuffer",
      requestType: "segment-key"
    });
    const keyRequestCallback = handleKeyResponse(segment, objects, finishProcessingFn, triggerSegmentEventFn);
    const keyInfo = {
      uri: segment.key.resolvedUri
    };
    triggerSegmentEventFn({
      type: "segmentkeyloadstart",
      segment,
      keyInfo
    });
    const keyXhr = xhr(keyRequestOptions, keyRequestCallback);
    activeXhrs.push(keyXhr);
  }
  if (segment.map && !segment.map.bytes) {
    const differentMapKey = segment.map.key && (!segment.key || segment.key.resolvedUri !== segment.map.key.resolvedUri);
    if (differentMapKey) {
      const mapKeyRequestOptions = merge(xhrOptions, {
        uri: segment.map.key.resolvedUri,
        responseType: "arraybuffer",
        requestType: "segment-key"
      });
      const mapKeyRequestCallback = handleKeyResponse(segment, [segment.map.key], finishProcessingFn, triggerSegmentEventFn);
      const keyInfo = {
        uri: segment.map.key.resolvedUri
      };
      triggerSegmentEventFn({
        type: "segmentkeyloadstart",
        segment,
        keyInfo
      });
      const mapKeyXhr = xhr(mapKeyRequestOptions, mapKeyRequestCallback);
      activeXhrs.push(mapKeyXhr);
    }
    const initSegmentOptions = merge(xhrOptions, {
      uri: segment.map.resolvedUri,
      responseType: "arraybuffer",
      headers: segmentXhrHeaders(segment.map),
      requestType: "segment-media-initialization"
    });
    const initSegmentRequestCallback = handleInitSegmentResponse({
      segment,
      finishProcessingFn,
      triggerSegmentEventFn
    });
    triggerSegmentEventFn({
      type: "segmentloadstart",
      segment
    });
    const initSegmentXhr = xhr(initSegmentOptions, initSegmentRequestCallback);
    activeXhrs.push(initSegmentXhr);
  }
  const segmentRequestOptions = merge(xhrOptions, {
    uri: segment.part && segment.part.resolvedUri || segment.resolvedUri,
    responseType: "arraybuffer",
    headers: segmentXhrHeaders(segment),
    requestType: "segment"
  });
  const segmentRequestCallback = handleSegmentResponse({
    segment,
    finishProcessingFn,
    responseType: segmentRequestOptions.responseType,
    triggerSegmentEventFn
  });
  triggerSegmentEventFn({
    type: "segmentloadstart",
    segment
  });
  const segmentXhr = xhr(segmentRequestOptions, segmentRequestCallback);
  segmentXhr.addEventListener("progress", handleProgress({
    segment,
    progressFn,
    trackInfoFn,
    timingInfoFn,
    videoSegmentTimingInfoFn,
    audioSegmentTimingInfoFn,
    id3Fn,
    captionsFn,
    isEndOfTimeline,
    endedTimelineFn,
    dataFn
  }));
  activeXhrs.push(segmentXhr);
  const loadendState = {};
  activeXhrs.forEach((activeXhr) => {
    activeXhr.addEventListener("loadend", handleLoadEnd({
      loadendState,
      abortFn
    }));
  });
  return () => abortAll(activeXhrs);
};
const logFn = logger("PlaylistSelector");
const representationToString = function(representation) {
  if (!representation || !representation.playlist) {
    return;
  }
  const playlist = representation.playlist;
  return JSON.stringify({
    id: playlist.id,
    bandwidth: representation.bandwidth,
    width: representation.width,
    height: representation.height,
    codecs: playlist.attributes && playlist.attributes.CODECS || ""
  });
};
const safeGetComputedStyle = function(el, property) {
  if (!el) {
    return "";
  }
  const result = window_1.getComputedStyle(el);
  if (!result) {
    return "";
  }
  return result[property];
};
const stableSort = function(array, sortFn) {
  const newArray = array.slice();
  array.sort(function(left, right) {
    const cmp = sortFn(left, right);
    if (cmp === 0) {
      return newArray.indexOf(left) - newArray.indexOf(right);
    }
    return cmp;
  });
};
const comparePlaylistBandwidth = function(left, right) {
  let leftBandwidth;
  let rightBandwidth;
  if (left.attributes.BANDWIDTH) {
    leftBandwidth = left.attributes.BANDWIDTH;
  }
  leftBandwidth = leftBandwidth || window_1.Number.MAX_VALUE;
  if (right.attributes.BANDWIDTH) {
    rightBandwidth = right.attributes.BANDWIDTH;
  }
  rightBandwidth = rightBandwidth || window_1.Number.MAX_VALUE;
  return leftBandwidth - rightBandwidth;
};
const comparePlaylistResolution = function(left, right) {
  let leftWidth;
  let rightWidth;
  if (left.attributes.RESOLUTION && left.attributes.RESOLUTION.width) {
    leftWidth = left.attributes.RESOLUTION.width;
  }
  leftWidth = leftWidth || window_1.Number.MAX_VALUE;
  if (right.attributes.RESOLUTION && right.attributes.RESOLUTION.width) {
    rightWidth = right.attributes.RESOLUTION.width;
  }
  rightWidth = rightWidth || window_1.Number.MAX_VALUE;
  if (leftWidth === rightWidth && left.attributes.BANDWIDTH && right.attributes.BANDWIDTH) {
    return left.attributes.BANDWIDTH - right.attributes.BANDWIDTH;
  }
  return leftWidth - rightWidth;
};
let simpleSelector = function(settings) {
  const {
    main,
    bandwidth: playerBandwidth,
    playerWidth,
    playerHeight,
    playerObjectFit,
    limitRenditionByPlayerDimensions,
    playlistController
  } = settings;
  if (!main) {
    return;
  }
  const options = {
    bandwidth: playerBandwidth,
    width: playerWidth,
    height: playerHeight,
    limitRenditionByPlayerDimensions
  };
  let playlists = main.playlists;
  if (Playlist.isAudioOnly(main)) {
    playlists = playlistController.getAudioTrackPlaylists_();
    options.audioOnly = true;
  }
  let sortedPlaylistReps = playlists.map((playlist) => {
    let bandwidth;
    const width = playlist.attributes && playlist.attributes.RESOLUTION && playlist.attributes.RESOLUTION.width;
    const height = playlist.attributes && playlist.attributes.RESOLUTION && playlist.attributes.RESOLUTION.height;
    bandwidth = playlist.attributes && playlist.attributes.BANDWIDTH;
    bandwidth = bandwidth || window_1.Number.MAX_VALUE;
    return {
      bandwidth,
      width,
      height,
      playlist
    };
  });
  stableSort(sortedPlaylistReps, (left, right) => left.bandwidth - right.bandwidth);
  sortedPlaylistReps = sortedPlaylistReps.filter((rep) => !Playlist.isIncompatible(rep.playlist));
  let enabledPlaylistReps = sortedPlaylistReps.filter((rep) => Playlist.isEnabled(rep.playlist));
  if (!enabledPlaylistReps.length) {
    enabledPlaylistReps = sortedPlaylistReps.filter((rep) => !Playlist.isDisabled(rep.playlist));
  }
  const bandwidthPlaylistReps = enabledPlaylistReps.filter((rep) => rep.bandwidth * Config.BANDWIDTH_VARIANCE < playerBandwidth);
  let highestRemainingBandwidthRep = bandwidthPlaylistReps[bandwidthPlaylistReps.length - 1];
  const bandwidthBestRep = bandwidthPlaylistReps.filter((rep) => rep.bandwidth === highestRemainingBandwidthRep.bandwidth)[0];
  if (limitRenditionByPlayerDimensions === false) {
    const chosenRep2 = bandwidthBestRep || enabledPlaylistReps[0] || sortedPlaylistReps[0];
    if (chosenRep2 && chosenRep2.playlist) {
      let type = "sortedPlaylistReps";
      if (bandwidthBestRep) {
        type = "bandwidthBestRep";
      }
      if (enabledPlaylistReps[0]) {
        type = "enabledPlaylistReps";
      }
      logFn(`choosing ${representationToString(chosenRep2)} using ${type} with options`, options);
      return chosenRep2.playlist;
    }
    logFn("could not choose a playlist with options", options);
    return null;
  }
  const haveResolution = bandwidthPlaylistReps.filter((rep) => rep.width && rep.height);
  stableSort(haveResolution, (left, right) => left.width - right.width);
  const resolutionBestRepList = haveResolution.filter((rep) => rep.width === playerWidth && rep.height === playerHeight);
  highestRemainingBandwidthRep = resolutionBestRepList[resolutionBestRepList.length - 1];
  const resolutionBestRep = resolutionBestRepList.filter((rep) => rep.bandwidth === highestRemainingBandwidthRep.bandwidth)[0];
  let resolutionPlusOneList;
  let resolutionPlusOneSmallest;
  let resolutionPlusOneRep;
  if (!resolutionBestRep) {
    resolutionPlusOneList = haveResolution.filter((rep) => {
      if (playerObjectFit === "cover") {
        return rep.width > playerWidth && rep.height > playerHeight;
      }
      return rep.width > playerWidth || rep.height > playerHeight;
    });
    resolutionPlusOneSmallest = resolutionPlusOneList.filter((rep) => rep.width === resolutionPlusOneList[0].width && rep.height === resolutionPlusOneList[0].height);
    highestRemainingBandwidthRep = resolutionPlusOneSmallest[resolutionPlusOneSmallest.length - 1];
    resolutionPlusOneRep = resolutionPlusOneSmallest.filter((rep) => rep.bandwidth === highestRemainingBandwidthRep.bandwidth)[0];
  }
  let leastPixelDiffRep;
  if (playlistController.leastPixelDiffSelector) {
    const leastPixelDiffList = haveResolution.map((rep) => {
      rep.pixelDiff = Math.abs(rep.width - playerWidth) + Math.abs(rep.height - playerHeight);
      return rep;
    });
    stableSort(leastPixelDiffList, (left, right) => {
      if (left.pixelDiff === right.pixelDiff) {
        return right.bandwidth - left.bandwidth;
      }
      return left.pixelDiff - right.pixelDiff;
    });
    leastPixelDiffRep = leastPixelDiffList[0];
  }
  const chosenRep = leastPixelDiffRep || resolutionPlusOneRep || resolutionBestRep || bandwidthBestRep || enabledPlaylistReps[0] || sortedPlaylistReps[0];
  if (chosenRep && chosenRep.playlist) {
    let type = "sortedPlaylistReps";
    if (leastPixelDiffRep) {
      type = "leastPixelDiffRep";
    } else if (resolutionPlusOneRep) {
      type = "resolutionPlusOneRep";
    } else if (resolutionBestRep) {
      type = "resolutionBestRep";
    } else if (bandwidthBestRep) {
      type = "bandwidthBestRep";
    } else if (enabledPlaylistReps[0]) {
      type = "enabledPlaylistReps";
    }
    logFn(`choosing ${representationToString(chosenRep)} using ${type} with options`, options);
    return chosenRep.playlist;
  }
  logFn("could not choose a playlist with options", options);
  return null;
};
const lastBandwidthSelector = function() {
  let pixelRatio = this.useDevicePixelRatio ? window_1.devicePixelRatio || 1 : 1;
  if (!isNaN(this.customPixelRatio)) {
    pixelRatio = this.customPixelRatio;
  }
  return simpleSelector({
    main: this.playlists.main,
    bandwidth: this.systemBandwidth,
    playerWidth: parseInt(safeGetComputedStyle(this.tech_.el(), "width"), 10) * pixelRatio,
    playerHeight: parseInt(safeGetComputedStyle(this.tech_.el(), "height"), 10) * pixelRatio,
    playerObjectFit: this.usePlayerObjectFit ? safeGetComputedStyle(this.tech_.el(), "objectFit") : "",
    limitRenditionByPlayerDimensions: this.limitRenditionByPlayerDimensions,
    playlistController: this.playlistController_
  });
};
const movingAverageBandwidthSelector = function(decay) {
  let average = -1;
  let lastSystemBandwidth = -1;
  if (decay < 0 || decay > 1) {
    throw new Error("Moving average bandwidth decay must be between 0 and 1.");
  }
  return function() {
    let pixelRatio = this.useDevicePixelRatio ? window_1.devicePixelRatio || 1 : 1;
    if (!isNaN(this.customPixelRatio)) {
      pixelRatio = this.customPixelRatio;
    }
    if (average < 0) {
      average = this.systemBandwidth;
      lastSystemBandwidth = this.systemBandwidth;
    }
    if (this.systemBandwidth > 0 && this.systemBandwidth !== lastSystemBandwidth) {
      average = decay * this.systemBandwidth + (1 - decay) * average;
      lastSystemBandwidth = this.systemBandwidth;
    }
    return simpleSelector({
      main: this.playlists.main,
      bandwidth: average,
      playerWidth: parseInt(safeGetComputedStyle(this.tech_.el(), "width"), 10) * pixelRatio,
      playerHeight: parseInt(safeGetComputedStyle(this.tech_.el(), "height"), 10) * pixelRatio,
      playerObjectFit: this.usePlayerObjectFit ? safeGetComputedStyle(this.tech_.el(), "objectFit") : "",
      limitRenditionByPlayerDimensions: this.limitRenditionByPlayerDimensions,
      playlistController: this.playlistController_
    });
  };
};
const minRebufferMaxBandwidthSelector = function(settings) {
  const {
    main,
    currentTime,
    bandwidth,
    duration: duration2,
    segmentDuration,
    timeUntilRebuffer: timeUntilRebuffer2,
    currentTimeline,
    syncController
  } = settings;
  const compatiblePlaylists = main.playlists.filter((playlist) => !Playlist.isIncompatible(playlist));
  let enabledPlaylists = compatiblePlaylists.filter(Playlist.isEnabled);
  if (!enabledPlaylists.length) {
    enabledPlaylists = compatiblePlaylists.filter((playlist) => !Playlist.isDisabled(playlist));
  }
  const bandwidthPlaylists = enabledPlaylists.filter(Playlist.hasAttribute.bind(null, "BANDWIDTH"));
  const rebufferingEstimates = bandwidthPlaylists.map((playlist) => {
    const syncPoint = syncController.getSyncPoint(playlist, duration2, currentTimeline, currentTime);
    const numRequests = syncPoint ? 1 : 2;
    const requestTimeEstimate = Playlist.estimateSegmentRequestTime(segmentDuration, bandwidth, playlist);
    const rebufferingImpact = requestTimeEstimate * numRequests - timeUntilRebuffer2;
    return {
      playlist,
      rebufferingImpact
    };
  });
  const noRebufferingPlaylists = rebufferingEstimates.filter((estimate) => estimate.rebufferingImpact <= 0);
  stableSort(noRebufferingPlaylists, (a, b) => comparePlaylistBandwidth(b.playlist, a.playlist));
  if (noRebufferingPlaylists.length) {
    return noRebufferingPlaylists[0];
  }
  stableSort(rebufferingEstimates, (a, b) => a.rebufferingImpact - b.rebufferingImpact);
  return rebufferingEstimates[0] || null;
};
const lowestBitrateCompatibleVariantSelector = function() {
  const playlists = this.playlists.main.playlists.filter(Playlist.isEnabled);
  stableSort(playlists, (a, b) => comparePlaylistBandwidth(a, b));
  const playlistsWithVideo = playlists.filter((playlist) => !!codecsForPlaylist(this.playlists.main, playlist).video);
  return playlistsWithVideo[0] || null;
};
const concatSegments = (segmentObj) => {
  let offset = 0;
  let tempBuffer;
  if (segmentObj.bytes) {
    tempBuffer = new Uint8Array(segmentObj.bytes);
    segmentObj.segments.forEach((segment) => {
      tempBuffer.set(segment, offset);
      offset += segment.byteLength;
    });
  }
  return tempBuffer;
};
function compactSegmentUrlDescription(resolvedUri) {
  try {
    return new URL(resolvedUri).pathname.split("/").slice(-2).join("/");
  } catch (e) {
    return "";
  }
}
const createCaptionsTrackIfNotExists = function(inbandTextTracks, tech, captionStream) {
  if (!inbandTextTracks[captionStream]) {
    tech.trigger({
      type: "usage",
      name: "vhs-608"
    });
    let instreamId = captionStream;
    if (/^cc708_/.test(captionStream)) {
      instreamId = "SERVICE" + captionStream.split("_")[1];
    }
    const track = tech.textTracks().getTrackById(instreamId);
    if (track) {
      inbandTextTracks[captionStream] = track;
    } else {
      const captionServices = tech.options_.vhs && tech.options_.vhs.captionServices || {};
      let label = captionStream;
      let language = captionStream;
      let def = false;
      const captionService = captionServices[instreamId];
      if (captionService) {
        label = captionService.label;
        language = captionService.language;
        def = captionService.default;
      }
      inbandTextTracks[captionStream] = tech.addRemoteTextTrack({
        kind: "captions",
        id: instreamId,
        default: def,
        label,
        language
      }, false).track;
    }
  }
};
const addCaptionData = function({
  inbandTextTracks,
  captionArray,
  timestampOffset
}) {
  if (!captionArray) {
    return;
  }
  const Cue = window_1.WebKitDataCue || window_1.VTTCue;
  captionArray.forEach((caption) => {
    const track = caption.stream;
    if (caption.content) {
      caption.content.forEach((value) => {
        const cue = new Cue(caption.startTime + timestampOffset, caption.endTime + timestampOffset, value.text);
        cue.line = value.line;
        cue.align = "left";
        cue.position = value.position;
        cue.positionAlign = "line-left";
        inbandTextTracks[track].addCue(cue);
      });
    } else {
      inbandTextTracks[track].addCue(new Cue(caption.startTime + timestampOffset, caption.endTime + timestampOffset, caption.text));
    }
  });
};
const deprecateOldCue = function(cue) {
  Object.defineProperties(cue.frame, {
    id: {
      get() {
        videojs.log.warn("cue.frame.id is deprecated. Use cue.value.key instead.");
        return cue.value.key;
      }
    },
    value: {
      get() {
        videojs.log.warn("cue.frame.value is deprecated. Use cue.value.data instead.");
        return cue.value.data;
      }
    },
    privateData: {
      get() {
        videojs.log.warn("cue.frame.privateData is deprecated. Use cue.value.data instead.");
        return cue.value.data;
      }
    }
  });
};
const addMetadata = ({
  inbandTextTracks,
  metadataArray,
  timestampOffset,
  videoDuration
}) => {
  if (!metadataArray) {
    return;
  }
  const Cue = window_1.WebKitDataCue || window_1.VTTCue;
  const metadataTrack = inbandTextTracks.metadataTrack_;
  if (!metadataTrack) {
    return;
  }
  metadataArray.forEach((metadata) => {
    const time = metadata.cueTime + timestampOffset;
    if (typeof time !== "number" || window_1.isNaN(time) || time < 0 || !(time < Infinity)) {
      return;
    }
    if (!metadata.frames || !metadata.frames.length) {
      return;
    }
    metadata.frames.forEach((frame) => {
      const cue = new Cue(time, time, frame.value || frame.url || frame.data || "");
      cue.frame = frame;
      cue.value = frame;
      deprecateOldCue(cue);
      metadataTrack.addCue(cue);
    });
  });
  if (!metadataTrack.cues || !metadataTrack.cues.length) {
    return;
  }
  const cues = metadataTrack.cues;
  const cuesArray = [];
  for (let i = 0; i < cues.length; i++) {
    if (cues[i]) {
      cuesArray.push(cues[i]);
    }
  }
  const cuesGroupedByStartTime = cuesArray.reduce((obj, cue) => {
    const timeSlot = obj[cue.startTime] || [];
    timeSlot.push(cue);
    obj[cue.startTime] = timeSlot;
    return obj;
  }, {});
  const sortedStartTimes = Object.keys(cuesGroupedByStartTime).sort((a, b) => Number(a) - Number(b));
  sortedStartTimes.forEach((startTime, idx) => {
    const cueGroup = cuesGroupedByStartTime[startTime];
    const finiteDuration = isFinite(videoDuration) ? videoDuration : startTime;
    const nextTime = Number(sortedStartTimes[idx + 1]) || finiteDuration;
    cueGroup.forEach((cue) => {
      cue.endTime = nextTime;
    });
  });
};
const dateRangeAttr = {
  id: "ID",
  class: "CLASS",
  startDate: "START-DATE",
  duration: "DURATION",
  endDate: "END-DATE",
  endOnNext: "END-ON-NEXT",
  plannedDuration: "PLANNED-DURATION",
  scte35Out: "SCTE35-OUT",
  scte35In: "SCTE35-IN"
};
const dateRangeKeysToOmit = /* @__PURE__ */ new Set(["id", "class", "startDate", "duration", "endDate", "endOnNext", "startTime", "endTime", "processDateRange"]);
const addDateRangeMetadata = ({
  inbandTextTracks,
  dateRanges
}) => {
  const metadataTrack = inbandTextTracks.metadataTrack_;
  if (!metadataTrack) {
    return;
  }
  const Cue = window_1.WebKitDataCue || window_1.VTTCue;
  dateRanges.forEach((dateRange) => {
    for (const key of Object.keys(dateRange)) {
      if (dateRangeKeysToOmit.has(key)) {
        continue;
      }
      const cue = new Cue(dateRange.startTime, dateRange.endTime, "");
      cue.id = dateRange.id;
      cue.type = "com.apple.quicktime.HLS";
      cue.value = {
        key: dateRangeAttr[key],
        data: dateRange[key]
      };
      if (key === "scte35Out" || key === "scte35In") {
        cue.value.data = new Uint8Array(cue.value.data.match(/[\da-f]{2}/gi)).buffer;
      }
      metadataTrack.addCue(cue);
    }
    dateRange.processDateRange();
  });
};
const createMetadataTrackIfNotExists = (inbandTextTracks, dispatchType, tech) => {
  if (inbandTextTracks.metadataTrack_) {
    return;
  }
  inbandTextTracks.metadataTrack_ = tech.addRemoteTextTrack({
    kind: "metadata",
    label: "Timed Metadata"
  }, false).track;
  if (!videojs.browser.IS_ANY_SAFARI) {
    inbandTextTracks.metadataTrack_.inBandMetadataTrackDispatchType = dispatchType;
  }
};
const removeCuesFromTrack = function(start, end, track) {
  let i;
  let cue;
  if (!track) {
    return;
  }
  if (!track.cues) {
    return;
  }
  i = track.cues.length;
  while (i--) {
    cue = track.cues[i];
    if (cue.startTime >= start && cue.endTime <= end) {
      track.removeCue(cue);
    }
  }
};
const removeDuplicateCuesFromTrack = function(track) {
  const cues = track.cues;
  if (!cues) {
    return;
  }
  const uniqueCues = {};
  for (let i = cues.length - 1; i >= 0; i--) {
    const cue = cues[i];
    const cueKey = `${cue.startTime}-${cue.endTime}-${cue.text}`;
    if (uniqueCues[cueKey]) {
      track.removeCue(cue);
    } else {
      uniqueCues[cueKey] = cue;
    }
  }
};
const gopsSafeToAlignWith = (buffer, currentTime, mapping) => {
  if (typeof currentTime === "undefined" || currentTime === null || !buffer.length) {
    return [];
  }
  const currentTimePts = Math.ceil((currentTime - mapping + 3) * clock.ONE_SECOND_IN_TS);
  let i;
  for (i = 0; i < buffer.length; i++) {
    if (buffer[i].pts > currentTimePts) {
      break;
    }
  }
  return buffer.slice(i);
};
const updateGopBuffer = (buffer, gops, replace) => {
  if (!gops.length) {
    return buffer;
  }
  if (replace) {
    return gops.slice();
  }
  const start = gops[0].pts;
  let i = 0;
  for (i; i < buffer.length; i++) {
    if (buffer[i].pts >= start) {
      break;
    }
  }
  return buffer.slice(0, i).concat(gops);
};
const removeGopBuffer = (buffer, start, end, mapping) => {
  const startPts = Math.ceil((start - mapping) * clock.ONE_SECOND_IN_TS);
  const endPts = Math.ceil((end - mapping) * clock.ONE_SECOND_IN_TS);
  const updatedBuffer = buffer.slice();
  let i = buffer.length;
  while (i--) {
    if (buffer[i].pts <= endPts) {
      break;
    }
  }
  if (i === -1) {
    return updatedBuffer;
  }
  let j = i + 1;
  while (j--) {
    if (buffer[j].pts <= startPts) {
      break;
    }
  }
  j = Math.max(j, 0);
  updatedBuffer.splice(j, i - j + 1);
  return updatedBuffer;
};
const shallowEqual = function(a, b) {
  if (!a && !b || !a && b || a && !b) {
    return false;
  }
  if (a === b) {
    return true;
  }
  const akeys = Object.keys(a).sort();
  const bkeys = Object.keys(b).sort();
  if (akeys.length !== bkeys.length) {
    return false;
  }
  for (let i = 0; i < akeys.length; i++) {
    const key = akeys[i];
    if (key !== bkeys[i]) {
      return false;
    }
    if (a[key] !== b[key]) {
      return false;
    }
  }
  return true;
};
const getSyncSegmentCandidate = function(currentTimeline, segments, targetTime) {
  segments = segments || [];
  const timelineSegments = [];
  let time = 0;
  for (let i = 0; i < segments.length; i++) {
    const segment = segments[i];
    if (currentTimeline === segment.timeline) {
      timelineSegments.push(i);
      time += segment.duration;
      if (time > targetTime) {
        return i;
      }
    }
  }
  if (timelineSegments.length === 0) {
    return 0;
  }
  return timelineSegments[timelineSegments.length - 1];
};
const MIN_BACK_BUFFER = 1;
const CHECK_BUFFER_DELAY = 500;
const finite = (num) => typeof num === "number" && isFinite(num);
const MIN_SEGMENT_DURATION_TO_SAVE_STATS = 1 / 60;
const illegalMediaSwitch = (loaderType, startingMedia, trackInfo) => {
  if (loaderType !== "main" || !startingMedia || !trackInfo) {
    return null;
  }
  if (!trackInfo.hasAudio && !trackInfo.hasVideo) {
    return "Neither audio nor video found in segment.";
  }
  if (startingMedia.hasVideo && !trackInfo.hasVideo) {
    return "Only audio found in segment when we expected video. We can't switch to audio only from a stream that had video. To get rid of this message, please add codec information to the manifest.";
  }
  if (!startingMedia.hasVideo && trackInfo.hasVideo) {
    return "Video found in segment when we expected only audio. We can't switch to a stream with video from an audio only stream. To get rid of this message, please add codec information to the manifest.";
  }
  return null;
};
const safeBackBufferTrimTime = (seekable2, currentTime, targetDuration) => {
  let trimTime = currentTime - Config.BACK_BUFFER_LENGTH;
  if (seekable2.length) {
    trimTime = Math.max(trimTime, seekable2.start(0));
  }
  const maxTrimTime = currentTime - targetDuration;
  return Math.min(maxTrimTime, trimTime);
};
const segmentInfoString = (segmentInfo) => {
  const {
    startOfSegment,
    duration: duration2,
    segment,
    part,
    playlist: {
      mediaSequence: seq,
      id,
      segments = []
    },
    mediaIndex: index,
    partIndex,
    timeline
  } = segmentInfo;
  const segmentLen = segments.length - 1;
  let selection = "mediaIndex/partIndex increment";
  if (segmentInfo.getMediaInfoForTime) {
    selection = `getMediaInfoForTime (${segmentInfo.getMediaInfoForTime})`;
  } else if (segmentInfo.isSyncRequest) {
    selection = "getSyncSegmentCandidate (isSyncRequest)";
  }
  if (segmentInfo.independent) {
    selection += ` with independent ${segmentInfo.independent}`;
  }
  const hasPartIndex = typeof partIndex === "number";
  const name = segmentInfo.segment.uri ? "segment" : "pre-segment";
  const zeroBasedPartCount = hasPartIndex ? getKnownPartCount({
    preloadSegment: segment
  }) - 1 : 0;
  return `${name} [${seq + index}/${seq + segmentLen}]` + (hasPartIndex ? ` part [${partIndex}/${zeroBasedPartCount}]` : "") + ` segment start/end [${segment.start} => ${segment.end}]` + (hasPartIndex ? ` part start/end [${part.start} => ${part.end}]` : "") + ` startOfSegment [${startOfSegment}] duration [${duration2}] timeline [${timeline}] selected by [${selection}] playlist [${id}]`;
};
const timingInfoPropertyForMedia = (mediaType) => `${mediaType}TimingInfo`;
const timestampOffsetForSegment = ({
  segmentTimeline,
  currentTimeline,
  startOfSegment,
  buffered,
  overrideCheck
}) => {
  if (!overrideCheck && segmentTimeline === currentTimeline) {
    return null;
  }
  if (segmentTimeline < currentTimeline) {
    return startOfSegment;
  }
  return buffered.length ? buffered.end(buffered.length - 1) : startOfSegment;
};
const shouldWaitForTimelineChange = ({
  timelineChangeController,
  currentTimeline,
  segmentTimeline,
  loaderType,
  audioDisabled
}) => {
  if (currentTimeline === segmentTimeline) {
    return false;
  }
  if (loaderType === "audio") {
    const lastMainTimelineChange = timelineChangeController.lastTimelineChange({
      type: "main"
    });
    return !lastMainTimelineChange || lastMainTimelineChange.to !== segmentTimeline;
  }
  if (loaderType === "main" && audioDisabled) {
    const pendingAudioTimelineChange = timelineChangeController.pendingTimelineChange({
      type: "audio"
    });
    if (pendingAudioTimelineChange && pendingAudioTimelineChange.to === segmentTimeline) {
      return false;
    }
    return true;
  }
  return false;
};
const shouldFixBadTimelineChanges = (timelineChangeController) => {
  if (!timelineChangeController) {
    return false;
  }
  const pendingAudioTimelineChange = timelineChangeController.pendingTimelineChange({
    type: "audio"
  });
  const pendingMainTimelineChange = timelineChangeController.pendingTimelineChange({
    type: "main"
  });
  const hasPendingTimelineChanges = pendingAudioTimelineChange && pendingMainTimelineChange;
  const differentPendingChanges = hasPendingTimelineChanges && pendingAudioTimelineChange.to !== pendingMainTimelineChange.to;
  const isNotInitialPendingTimelineChange = hasPendingTimelineChanges && pendingAudioTimelineChange.from !== -1 && pendingMainTimelineChange.from !== -1;
  if (isNotInitialPendingTimelineChange && differentPendingChanges) {
    return true;
  }
  return false;
};
const isAudioTimelineBehind = (segmentLoader) => {
  const pendingAudioTimelineChange = segmentLoader.timelineChangeController_.pendingTimelineChange({
    type: "audio"
  });
  const pendingMainTimelineChange = segmentLoader.timelineChangeController_.pendingTimelineChange({
    type: "main"
  });
  const hasPendingTimelineChanges = pendingAudioTimelineChange && pendingMainTimelineChange;
  return hasPendingTimelineChanges && pendingAudioTimelineChange.to < pendingMainTimelineChange.to;
};
const checkAndFixTimelines = (segmentLoader) => {
  const segmentInfo = segmentLoader.pendingSegment_;
  if (!segmentInfo) {
    return;
  }
  const waitingForTimelineChange = shouldWaitForTimelineChange({
    timelineChangeController: segmentLoader.timelineChangeController_,
    currentTimeline: segmentLoader.currentTimeline_,
    segmentTimeline: segmentInfo.timeline,
    loaderType: segmentLoader.loaderType_,
    audioDisabled: segmentLoader.audioDisabled_
  });
  if (waitingForTimelineChange && shouldFixBadTimelineChanges(segmentLoader.timelineChangeController_)) {
    if (isAudioTimelineBehind(segmentLoader)) {
      segmentLoader.timelineChangeController_.trigger("audioTimelineBehind");
      return;
    }
    segmentLoader.timelineChangeController_.trigger("fixBadTimelineChange");
  }
};
const mediaDuration = (timingInfos) => {
  let maxDuration = 0;
  ["video", "audio"].forEach(function(type) {
    const typeTimingInfo = timingInfos[`${type}TimingInfo`];
    if (!typeTimingInfo) {
      return;
    }
    const {
      start,
      end
    } = typeTimingInfo;
    let duration2;
    if (typeof start === "bigint" || typeof end === "bigint") {
      duration2 = window_1.BigInt(end) - window_1.BigInt(start);
    } else if (typeof start === "number" && typeof end === "number") {
      duration2 = end - start;
    }
    if (typeof duration2 !== "undefined" && duration2 > maxDuration) {
      maxDuration = duration2;
    }
  });
  if (typeof maxDuration === "bigint" && maxDuration < Number.MAX_SAFE_INTEGER) {
    maxDuration = Number(maxDuration);
  }
  return maxDuration;
};
const segmentTooLong = ({
  segmentDuration,
  maxDuration
}) => {
  if (!segmentDuration) {
    return false;
  }
  return Math.round(segmentDuration) > maxDuration + TIME_FUDGE_FACTOR;
};
const getTroublesomeSegmentDurationMessage = (segmentInfo, sourceType) => {
  if (sourceType !== "hls") {
    return null;
  }
  const segmentDuration = mediaDuration({
    audioTimingInfo: segmentInfo.audioTimingInfo,
    videoTimingInfo: segmentInfo.videoTimingInfo
  });
  if (!segmentDuration) {
    return null;
  }
  const targetDuration = segmentInfo.playlist.targetDuration;
  const isSegmentWayTooLong = segmentTooLong({
    segmentDuration,
    maxDuration: targetDuration * 2
  });
  const isSegmentSlightlyTooLong = segmentTooLong({
    segmentDuration,
    maxDuration: targetDuration
  });
  const segmentTooLongMessage = `Segment with index ${segmentInfo.mediaIndex} from playlist ${segmentInfo.playlist.id} has a duration of ${segmentDuration} when the reported duration is ${segmentInfo.duration} and the target duration is ${targetDuration}. For HLS content, a duration in excess of the target duration may result in playback issues. See the HLS specification section on EXT-X-TARGETDURATION for more details: https://tools.ietf.org/html/draft-pantos-http-live-streaming-23#section-4.3.3.1`;
  if (isSegmentWayTooLong || isSegmentSlightlyTooLong) {
    return {
      severity: isSegmentWayTooLong ? "warn" : "info",
      message: segmentTooLongMessage
    };
  }
  return null;
};
const segmentInfoPayload = ({
  type,
  segment
}) => {
  if (!segment) {
    return;
  }
  const isEncrypted = Boolean(segment.key || segment.map && segment.map.ke);
  const isMediaInitialization = Boolean(segment.map && !segment.map.bytes);
  const start = segment.startOfSegment === void 0 ? segment.start : segment.startOfSegment;
  return {
    type: type || segment.type,
    uri: segment.resolvedUri || segment.uri,
    start,
    duration: segment.duration,
    isEncrypted,
    isMediaInitialization
  };
};
class SegmentLoader extends videojs.EventTarget {
  constructor(settings, options = {}) {
    super();
    if (!settings) {
      throw new TypeError("Initialization settings are required");
    }
    if (typeof settings.currentTime !== "function") {
      throw new TypeError("No currentTime getter specified");
    }
    if (!settings.mediaSource) {
      throw new TypeError("No MediaSource specified");
    }
    this.bandwidth = settings.bandwidth;
    this.throughput = {
      rate: 0,
      count: 0
    };
    this.roundTrip = NaN;
    this.resetStats_();
    this.mediaIndex = null;
    this.partIndex = null;
    this.hasPlayed_ = settings.hasPlayed;
    this.currentTime_ = settings.currentTime;
    this.seekable_ = settings.seekable;
    this.seeking_ = settings.seeking;
    this.duration_ = settings.duration;
    this.mediaSource_ = settings.mediaSource;
    this.vhs_ = settings.vhs;
    this.loaderType_ = settings.loaderType;
    this.currentMediaInfo_ = void 0;
    this.startingMediaInfo_ = void 0;
    this.segmentMetadataTrack_ = settings.segmentMetadataTrack;
    this.goalBufferLength_ = settings.goalBufferLength;
    this.sourceType_ = settings.sourceType;
    this.sourceUpdater_ = settings.sourceUpdater;
    this.inbandTextTracks_ = settings.inbandTextTracks;
    this.state_ = "INIT";
    this.timelineChangeController_ = settings.timelineChangeController;
    this.shouldSaveSegmentTimingInfo_ = true;
    this.parse708captions_ = settings.parse708captions;
    this.useDtsForTimestampOffset_ = settings.useDtsForTimestampOffset;
    this.captionServices_ = settings.captionServices;
    this.exactManifestTimings = settings.exactManifestTimings;
    this.addMetadataToTextTrack = settings.addMetadataToTextTrack;
    this.checkBufferTimeout_ = null;
    this.error_ = void 0;
    this.currentTimeline_ = -1;
    this.shouldForceTimestampOffsetAfterResync_ = false;
    this.pendingSegment_ = null;
    this.xhrOptions_ = null;
    this.pendingSegments_ = [];
    this.audioDisabled_ = false;
    this.isPendingTimestampOffset_ = false;
    this.gopBuffer_ = [];
    this.timeMapping_ = 0;
    this.safeAppend_ = false;
    this.appendInitSegment_ = {
      audio: true,
      video: true
    };
    this.playlistOfLastInitSegment_ = {
      audio: null,
      video: null
    };
    this.callQueue_ = [];
    this.loadQueue_ = [];
    this.metadataQueue_ = {
      id3: [],
      caption: []
    };
    this.waitingOnRemove_ = false;
    this.quotaExceededErrorRetryTimeout_ = null;
    this.activeInitSegmentId_ = null;
    this.initSegments_ = {};
    this.cacheEncryptionKeys_ = settings.cacheEncryptionKeys;
    this.keyCache_ = {};
    this.decrypter_ = settings.decrypter;
    this.syncController_ = settings.syncController;
    this.syncPoint_ = {
      segmentIndex: 0,
      time: 0
    };
    this.transmuxer_ = this.createTransmuxer_();
    this.triggerSyncInfoUpdate_ = () => this.trigger("syncinfoupdate");
    this.syncController_.on("syncinfoupdate", this.triggerSyncInfoUpdate_);
    this.mediaSource_.addEventListener("sourceopen", () => {
      if (!this.isEndOfStream_()) {
        this.ended_ = false;
      }
    });
    this.fetchAtBuffer_ = false;
    this.logger_ = logger(`SegmentLoader[${this.loaderType_}]`);
    Object.defineProperty(this, "state", {
      get() {
        return this.state_;
      },
      set(newState) {
        if (newState !== this.state_) {
          this.logger_(`${this.state_} -> ${newState}`);
          this.state_ = newState;
          this.trigger("statechange");
        }
      }
    });
    this.sourceUpdater_.on("ready", () => {
      if (this.hasEnoughInfoToAppend_()) {
        this.processCallQueue_();
      } else {
        checkAndFixTimelines(this);
      }
    });
    this.sourceUpdater_.on("codecschange", (metadata) => {
      this.trigger(_extends({
        type: "codecschange"
      }, metadata));
    });
    if (this.loaderType_ === "main") {
      this.timelineChangeController_.on("pendingtimelinechange", () => {
        if (this.hasEnoughInfoToAppend_()) {
          this.processCallQueue_();
        } else {
          checkAndFixTimelines(this);
        }
      });
    }
    if (this.loaderType_ === "audio") {
      this.timelineChangeController_.on("timelinechange", (metadata) => {
        this.trigger(_extends({
          type: "timelinechange"
        }, metadata));
        if (this.hasEnoughInfoToLoad_()) {
          this.processLoadQueue_();
        } else {
          checkAndFixTimelines(this);
        }
        if (this.hasEnoughInfoToAppend_()) {
          this.processCallQueue_();
        } else {
          checkAndFixTimelines(this);
        }
      });
    }
  }
  get mediaSequenceSync_() {
    return this.syncController_.getMediaSequenceSync(this.loaderType_);
  }
  createTransmuxer_() {
    return segmentTransmuxer.createTransmuxer({
      remux: false,
      alignGopsAtEnd: this.safeAppend_,
      keepOriginalTimestamps: true,
      parse708captions: this.parse708captions_,
      captionServices: this.captionServices_
    });
  }
  resetStats_() {
    this.mediaBytesTransferred = 0;
    this.mediaRequests = 0;
    this.mediaRequestsAborted = 0;
    this.mediaRequestsTimedout = 0;
    this.mediaRequestsErrored = 0;
    this.mediaTransferDuration = 0;
    this.mediaSecondsLoaded = 0;
    this.mediaAppends = 0;
  }
  dispose() {
    this.trigger("dispose");
    this.state = "DISPOSED";
    this.pause();
    this.abort_();
    if (this.transmuxer_) {
      this.transmuxer_.terminate();
    }
    this.resetStats_();
    if (this.checkBufferTimeout_) {
      window_1.clearTimeout(this.checkBufferTimeout_);
    }
    if (this.syncController_ && this.triggerSyncInfoUpdate_) {
      this.syncController_.off("syncinfoupdate", this.triggerSyncInfoUpdate_);
    }
    this.off();
  }
  setAudio(enable) {
    this.audioDisabled_ = !enable;
    if (enable) {
      this.appendInitSegment_.audio = true;
    } else {
      this.sourceUpdater_.removeAudio(0, this.duration_());
    }
  }
  abort() {
    if (this.state !== "WAITING") {
      if (this.pendingSegment_) {
        this.pendingSegment_ = null;
      }
      this.timelineChangeController_.clearPendingTimelineChange(this.loaderType_);
      return;
    }
    this.abort_();
    this.state = "READY";
    if (!this.paused()) {
      this.monitorBuffer_();
    }
  }
  abort_() {
    if (this.pendingSegment_ && this.pendingSegment_.abortRequests) {
      this.pendingSegment_.abortRequests();
    }
    this.pendingSegment_ = null;
    this.callQueue_ = [];
    this.loadQueue_ = [];
    this.metadataQueue_.id3 = [];
    this.metadataQueue_.caption = [];
    this.timelineChangeController_.clearPendingTimelineChange(this.loaderType_);
    this.waitingOnRemove_ = false;
    window_1.clearTimeout(this.quotaExceededErrorRetryTimeout_);
    this.quotaExceededErrorRetryTimeout_ = null;
  }
  checkForAbort_(requestId) {
    if (this.state === "APPENDING" && !this.pendingSegment_) {
      this.state = "READY";
      return true;
    }
    if (!this.pendingSegment_ || this.pendingSegment_.requestId !== requestId) {
      return true;
    }
    return false;
  }
  error(error) {
    if (typeof error !== "undefined") {
      this.logger_("error occurred:", error);
      this.error_ = error;
    }
    this.pendingSegment_ = null;
    return this.error_;
  }
  endOfStream() {
    this.ended_ = true;
    if (this.transmuxer_) {
      segmentTransmuxer.reset(this.transmuxer_);
    }
    this.gopBuffer_.length = 0;
    this.pause();
    this.trigger("ended");
  }
  buffered_() {
    const trackInfo = this.getMediaInfo_();
    if (!this.sourceUpdater_ || !trackInfo) {
      return createTimeRanges();
    }
    if (this.loaderType_ === "main") {
      const {
        hasAudio,
        hasVideo,
        isMuxed: isMuxed2
      } = trackInfo;
      if (hasVideo && hasAudio && !this.audioDisabled_ && !isMuxed2) {
        return this.sourceUpdater_.buffered();
      }
      if (hasVideo) {
        return this.sourceUpdater_.videoBuffered();
      }
    }
    return this.sourceUpdater_.audioBuffered();
  }
  initSegmentForMap(map, set2 = false) {
    if (!map) {
      return null;
    }
    const id = initSegmentId(map);
    let storedMap = this.initSegments_[id];
    if (set2 && !storedMap && map.bytes) {
      this.initSegments_[id] = storedMap = {
        resolvedUri: map.resolvedUri,
        byterange: map.byterange,
        bytes: map.bytes,
        tracks: map.tracks,
        timescales: map.timescales
      };
    }
    return storedMap || map;
  }
  segmentKey(key, set2 = false) {
    if (!key) {
      return null;
    }
    const id = segmentKeyId(key);
    let storedKey = this.keyCache_[id];
    if (this.cacheEncryptionKeys_ && set2 && !storedKey && key.bytes) {
      this.keyCache_[id] = storedKey = {
        resolvedUri: key.resolvedUri,
        bytes: key.bytes
      };
    }
    const result = {
      resolvedUri: (storedKey || key).resolvedUri
    };
    if (storedKey) {
      result.bytes = storedKey.bytes;
    }
    return result;
  }
  couldBeginLoading_() {
    return this.playlist_ && !this.paused();
  }
  load() {
    this.monitorBuffer_();
    if (!this.playlist_) {
      return;
    }
    if (this.state === "INIT" && this.couldBeginLoading_()) {
      return this.init_();
    }
    if (!this.couldBeginLoading_() || this.state !== "READY" && this.state !== "INIT") {
      return;
    }
    this.state = "READY";
  }
  init_() {
    this.state = "READY";
    this.resetEverything();
    return this.monitorBuffer_();
  }
  playlist(newPlaylist, options = {}) {
    if (!newPlaylist) {
      return;
    }
    if (this.playlist_ && this.playlist_.endList && newPlaylist.endList && this.playlist_.uri === newPlaylist.uri) {
      return;
    }
    const oldPlaylist = this.playlist_;
    const segmentInfo = this.pendingSegment_;
    this.playlist_ = newPlaylist;
    this.xhrOptions_ = options;
    if (this.state === "INIT") {
      newPlaylist.syncInfo = {
        mediaSequence: newPlaylist.mediaSequence,
        time: 0
      };
      if (this.loaderType_ === "main") {
        this.syncController_.setDateTimeMappingForStart(newPlaylist);
      }
    }
    let oldId = null;
    if (oldPlaylist) {
      if (oldPlaylist.id) {
        oldId = oldPlaylist.id;
      } else if (oldPlaylist.uri) {
        oldId = oldPlaylist.uri;
      }
    }
    this.logger_(`playlist update [${oldId} => ${newPlaylist.id || newPlaylist.uri}]`);
    if (this.mediaSequenceSync_) {
      this.mediaSequenceSync_.update(newPlaylist, this.currentTime_());
      this.logger_(`Playlist update:
currentTime: ${this.currentTime_()}
bufferedEnd: ${lastBufferedEnd(this.buffered_())}
`, this.mediaSequenceSync_.diagnostics);
    }
    this.trigger("syncinfoupdate");
    if (this.state === "INIT" && this.couldBeginLoading_()) {
      return this.init_();
    }
    if (!oldPlaylist || oldPlaylist.uri !== newPlaylist.uri) {
      if (this.mediaIndex !== null) {
        const isLLHLS = !newPlaylist.endList && typeof newPlaylist.partTargetDuration === "number";
        if (isLLHLS) {
          this.resetLoader();
        } else {
          this.resyncLoader();
        }
      }
      this.currentMediaInfo_ = void 0;
      this.trigger("playlistupdate");
      return;
    }
    const mediaSequenceDiff = newPlaylist.mediaSequence - oldPlaylist.mediaSequence;
    this.logger_(`live window shift [${mediaSequenceDiff}]`);
    if (this.mediaIndex !== null) {
      this.mediaIndex -= mediaSequenceDiff;
      if (this.mediaIndex < 0) {
        this.mediaIndex = null;
        this.partIndex = null;
      } else {
        const segment = this.playlist_.segments[this.mediaIndex];
        if (this.partIndex && (!segment.parts || !segment.parts.length || !segment.parts[this.partIndex])) {
          const mediaIndex = this.mediaIndex;
          this.logger_(`currently processing part (index ${this.partIndex}) no longer exists.`);
          this.resetLoader();
          this.mediaIndex = mediaIndex;
        }
      }
    }
    if (segmentInfo) {
      segmentInfo.mediaIndex -= mediaSequenceDiff;
      if (segmentInfo.mediaIndex < 0) {
        segmentInfo.mediaIndex = null;
        segmentInfo.partIndex = null;
      } else {
        if (segmentInfo.mediaIndex >= 0) {
          segmentInfo.segment = newPlaylist.segments[segmentInfo.mediaIndex];
        }
        if (segmentInfo.partIndex >= 0 && segmentInfo.segment.parts) {
          segmentInfo.part = segmentInfo.segment.parts[segmentInfo.partIndex];
        }
      }
    }
    this.syncController_.saveExpiredSegmentInfo(oldPlaylist, newPlaylist);
  }
  pause() {
    if (this.checkBufferTimeout_) {
      window_1.clearTimeout(this.checkBufferTimeout_);
      this.checkBufferTimeout_ = null;
    }
  }
  paused() {
    return this.checkBufferTimeout_ === null;
  }
  resetEverything(done) {
    this.ended_ = false;
    this.activeInitSegmentId_ = null;
    this.appendInitSegment_ = {
      audio: true,
      video: true
    };
    this.resetLoader();
    this.remove(0, Infinity, done);
    if (this.transmuxer_) {
      this.transmuxer_.postMessage({
        action: "clearAllMp4Captions"
      });
      this.transmuxer_.postMessage({
        action: "reset"
      });
    }
  }
  resetLoader() {
    this.fetchAtBuffer_ = false;
    if (this.mediaSequenceSync_) {
      this.mediaSequenceSync_.resetAppendedStatus();
    }
    this.resyncLoader();
  }
  resyncLoader() {
    if (this.transmuxer_) {
      segmentTransmuxer.reset(this.transmuxer_);
    }
    this.mediaIndex = null;
    this.partIndex = null;
    this.syncPoint_ = null;
    this.isPendingTimestampOffset_ = false;
    const isFmp4 = this.currentMediaInfo_ && this.currentMediaInfo_.isFmp4;
    const isHlsTs = this.sourceType_ === "hls" && !isFmp4;
    if (isHlsTs) {
      this.shouldForceTimestampOffsetAfterResync_ = true;
    }
    this.callQueue_ = [];
    this.loadQueue_ = [];
    this.metadataQueue_.id3 = [];
    this.metadataQueue_.caption = [];
    this.abort();
    if (this.transmuxer_) {
      this.transmuxer_.postMessage({
        action: "clearParsedMp4Captions"
      });
    }
  }
  remove(start, end, done = () => {
  }, force = false) {
    if (end === Infinity) {
      end = this.duration_();
    }
    if (end <= start) {
      this.logger_("skipping remove because end ${end} is <= start ${start}");
      return;
    }
    if (!this.sourceUpdater_ || !this.getMediaInfo_()) {
      this.logger_("skipping remove because no source updater or starting media info");
      return;
    }
    let removesRemaining = 1;
    const removeFinished = () => {
      removesRemaining--;
      if (removesRemaining === 0) {
        done();
      }
    };
    if (force || !this.audioDisabled_) {
      removesRemaining++;
      this.sourceUpdater_.removeAudio(start, end, removeFinished);
    }
    if (force || this.loaderType_ === "main") {
      this.gopBuffer_ = removeGopBuffer(this.gopBuffer_, start, end, this.timeMapping_);
      removesRemaining++;
      this.sourceUpdater_.removeVideo(start, end, removeFinished);
    }
    for (const track in this.inbandTextTracks_) {
      removeCuesFromTrack(start, end, this.inbandTextTracks_[track]);
    }
    removeCuesFromTrack(start, end, this.segmentMetadataTrack_);
    removeFinished();
  }
  monitorBuffer_() {
    if (this.checkBufferTimeout_) {
      window_1.clearTimeout(this.checkBufferTimeout_);
    }
    this.checkBufferTimeout_ = window_1.setTimeout(this.monitorBufferTick_.bind(this), 1);
  }
  monitorBufferTick_() {
    if (this.state === "READY") {
      this.fillBuffer_();
    }
    if (this.checkBufferTimeout_) {
      window_1.clearTimeout(this.checkBufferTimeout_);
    }
    this.checkBufferTimeout_ = window_1.setTimeout(this.monitorBufferTick_.bind(this), CHECK_BUFFER_DELAY);
  }
  fillBuffer_() {
    if (this.sourceUpdater_.updating()) {
      return;
    }
    const segmentInfo = this.chooseNextRequest_();
    if (!segmentInfo) {
      return;
    }
    const metadata = {
      segmentInfo: segmentInfoPayload({
        type: this.loaderType_,
        segment: segmentInfo
      })
    };
    this.trigger({
      type: "segmentselected",
      metadata
    });
    if (typeof segmentInfo.timestampOffset === "number") {
      this.isPendingTimestampOffset_ = false;
      this.timelineChangeController_.pendingTimelineChange({
        type: this.loaderType_,
        from: this.currentTimeline_,
        to: segmentInfo.timeline
      });
    }
    this.loadSegment_(segmentInfo);
  }
  isEndOfStream_(mediaIndex = this.mediaIndex, playlist = this.playlist_, partIndex = this.partIndex) {
    if (!playlist || !this.mediaSource_) {
      return false;
    }
    const segment = typeof mediaIndex === "number" && playlist.segments[mediaIndex];
    const appendedLastSegment = mediaIndex + 1 === playlist.segments.length;
    const appendedLastPart = !segment || !segment.parts || partIndex + 1 === segment.parts.length;
    return playlist.endList && this.mediaSource_.readyState === "open" && appendedLastSegment && appendedLastPart;
  }
  chooseNextRequest_() {
    const buffered = this.buffered_();
    const bufferedEnd = lastBufferedEnd(buffered) || 0;
    const bufferedTime = timeAheadOf(buffered, this.currentTime_());
    const preloaded = !this.hasPlayed_() && bufferedTime >= 1;
    const haveEnoughBuffer = bufferedTime >= this.goalBufferLength_();
    const segments = this.playlist_.segments;
    if (!segments.length || preloaded || haveEnoughBuffer) {
      return null;
    }
    this.syncPoint_ = this.syncPoint_ || this.syncController_.getSyncPoint(this.playlist_, this.duration_(), this.currentTimeline_, this.currentTime_(), this.loaderType_);
    const next = {
      partIndex: null,
      mediaIndex: null,
      startOfSegment: null,
      playlist: this.playlist_,
      isSyncRequest: Boolean(!this.syncPoint_)
    };
    if (next.isSyncRequest) {
      next.mediaIndex = getSyncSegmentCandidate(this.currentTimeline_, segments, bufferedEnd);
      this.logger_(`choose next request. Can not find sync point. Fallback to media Index: ${next.mediaIndex}`);
    } else if (this.mediaIndex !== null) {
      const segment = segments[this.mediaIndex];
      const partIndex = typeof this.partIndex === "number" ? this.partIndex : -1;
      next.startOfSegment = segment.end ? segment.end : bufferedEnd;
      if (segment.parts && segment.parts[partIndex + 1]) {
        next.mediaIndex = this.mediaIndex;
        next.partIndex = partIndex + 1;
      } else {
        next.mediaIndex = this.mediaIndex + 1;
      }
    } else {
      let segmentIndex;
      let partIndex;
      let startTime;
      const targetTime = this.fetchAtBuffer_ ? bufferedEnd : this.currentTime_();
      if (this.mediaSequenceSync_) {
        this.logger_(`chooseNextRequest_ request after Quality Switch:
For TargetTime: ${targetTime}.
CurrentTime: ${this.currentTime_()}
BufferedEnd: ${bufferedEnd}
Fetch At Buffer: ${this.fetchAtBuffer_}
`, this.mediaSequenceSync_.diagnostics);
      }
      if (this.mediaSequenceSync_ && this.mediaSequenceSync_.isReliable) {
        const syncInfo = this.getSyncInfoFromMediaSequenceSync_(targetTime);
        if (!syncInfo) {
          const message = "No sync info found while using media sequence sync";
          this.error({
            message,
            metadata: {
              errorType: videojs.Error.StreamingFailedToSelectNextSegment,
              error: new Error(message)
            }
          });
          this.logger_("chooseNextRequest_ - no sync info found using media sequence sync");
          return null;
        }
        this.logger_(`chooseNextRequest_ mediaSequence syncInfo (${syncInfo.start} --> ${syncInfo.end})`);
        segmentIndex = syncInfo.segmentIndex;
        partIndex = syncInfo.partIndex;
        startTime = syncInfo.start;
      } else {
        this.logger_("chooseNextRequest_ - fallback to a regular segment selection algorithm, based on a syncPoint.");
        const mediaInfoForTime = Playlist.getMediaInfoForTime({
          exactManifestTimings: this.exactManifestTimings,
          playlist: this.playlist_,
          currentTime: targetTime,
          startingPartIndex: this.syncPoint_.partIndex,
          startingSegmentIndex: this.syncPoint_.segmentIndex,
          startTime: this.syncPoint_.time
        });
        segmentIndex = mediaInfoForTime.segmentIndex;
        partIndex = mediaInfoForTime.partIndex;
        startTime = mediaInfoForTime.startTime;
      }
      next.getMediaInfoForTime = this.fetchAtBuffer_ ? `bufferedEnd ${targetTime}` : `currentTime ${targetTime}`;
      next.mediaIndex = segmentIndex;
      next.startOfSegment = startTime;
      next.partIndex = partIndex;
      this.logger_(`choose next request. Playlist switched and we have a sync point. Media Index: ${next.mediaIndex} `);
    }
    const nextSegment = segments[next.mediaIndex];
    let nextPart = nextSegment && typeof next.partIndex === "number" && nextSegment.parts && nextSegment.parts[next.partIndex];
    if (!nextSegment || typeof next.partIndex === "number" && !nextPart) {
      return null;
    }
    if (typeof next.partIndex !== "number" && nextSegment.parts) {
      next.partIndex = 0;
      nextPart = nextSegment.parts[0];
    }
    const hasIndependentSegments = this.vhs_.playlists && this.vhs_.playlists.main && this.vhs_.playlists.main.independentSegments || this.playlist_.independentSegments;
    if (!bufferedTime && nextPart && !hasIndependentSegments && !nextPart.independent) {
      if (next.partIndex === 0) {
        const lastSegment = segments[next.mediaIndex - 1];
        const lastSegmentLastPart = lastSegment.parts && lastSegment.parts.length && lastSegment.parts[lastSegment.parts.length - 1];
        if (lastSegmentLastPart && lastSegmentLastPart.independent) {
          next.mediaIndex -= 1;
          next.partIndex = lastSegment.parts.length - 1;
          next.independent = "previous segment";
        }
      } else if (nextSegment.parts[next.partIndex - 1].independent) {
        next.partIndex -= 1;
        next.independent = "previous part";
      }
    }
    const ended = this.mediaSource_ && this.mediaSource_.readyState === "ended";
    if (next.mediaIndex >= segments.length - 1 && ended && !this.seeking_()) {
      return null;
    }
    if (this.shouldForceTimestampOffsetAfterResync_) {
      this.shouldForceTimestampOffsetAfterResync_ = false;
      next.forceTimestampOffset = true;
      this.logger_("choose next request. Force timestamp offset after loader resync");
    }
    return this.generateSegmentInfo_(next);
  }
  getSyncInfoFromMediaSequenceSync_(targetTime) {
    if (!this.mediaSequenceSync_) {
      return null;
    }
    const finalTargetTime = Math.max(targetTime, this.mediaSequenceSync_.start);
    if (targetTime !== finalTargetTime) {
      this.logger_(`getSyncInfoFromMediaSequenceSync_. Pulled target time from ${targetTime} to ${finalTargetTime}`);
    }
    const mediaSequenceSyncInfo = this.mediaSequenceSync_.getSyncInfoForTime(finalTargetTime);
    if (!mediaSequenceSyncInfo) {
      return null;
    }
    if (!mediaSequenceSyncInfo.isAppended) {
      return mediaSequenceSyncInfo;
    }
    const nextMediaSequenceSyncInfo = this.mediaSequenceSync_.getSyncInfoForTime(mediaSequenceSyncInfo.end);
    if (!nextMediaSequenceSyncInfo) {
      return null;
    }
    if (nextMediaSequenceSyncInfo.isAppended) {
      this.logger_("getSyncInfoFromMediaSequenceSync_: We encounter unexpected scenario where next media sequence sync info is also appended!");
    }
    return nextMediaSequenceSyncInfo;
  }
  generateSegmentInfo_(options) {
    const {
      independent,
      playlist,
      mediaIndex,
      startOfSegment,
      isSyncRequest,
      partIndex,
      forceTimestampOffset,
      getMediaInfoForTime: getMediaInfoForTime2
    } = options;
    const segment = playlist.segments[mediaIndex];
    const part = typeof partIndex === "number" && segment.parts[partIndex];
    const segmentInfo = {
      requestId: "segment-loader-" + Math.random(),
      uri: part && part.resolvedUri || segment.resolvedUri,
      mediaIndex,
      partIndex: part ? partIndex : null,
      isSyncRequest,
      startOfSegment,
      playlist,
      bytes: null,
      encryptedBytes: null,
      timestampOffset: null,
      timeline: segment.timeline,
      duration: part && part.duration || segment.duration,
      segment,
      part,
      byteLength: 0,
      transmuxer: this.transmuxer_,
      getMediaInfoForTime: getMediaInfoForTime2,
      independent
    };
    const overrideCheck = typeof forceTimestampOffset !== "undefined" ? forceTimestampOffset : this.isPendingTimestampOffset_;
    segmentInfo.timestampOffset = this.timestampOffsetForSegment_({
      segmentTimeline: segment.timeline,
      currentTimeline: this.currentTimeline_,
      startOfSegment,
      buffered: this.buffered_(),
      overrideCheck
    });
    const audioBufferedEnd = lastBufferedEnd(this.sourceUpdater_.audioBuffered());
    if (typeof audioBufferedEnd === "number") {
      segmentInfo.audioAppendStart = audioBufferedEnd - this.sourceUpdater_.audioTimestampOffset();
    }
    if (this.sourceUpdater_.videoBuffered().length) {
      segmentInfo.gopsToAlignWith = gopsSafeToAlignWith(
        this.gopBuffer_,
        this.currentTime_() - this.sourceUpdater_.videoTimestampOffset(),
        this.timeMapping_
      );
    }
    return segmentInfo;
  }
  timestampOffsetForSegment_(options) {
    return timestampOffsetForSegment(options);
  }
  earlyAbortWhenNeeded_(stats) {
    if (this.vhs_.tech_.paused() || !this.xhrOptions_.timeout || !this.playlist_.attributes.BANDWIDTH) {
      return;
    }
    if (Date.now() - (stats.firstBytesReceivedAt || Date.now()) < 1e3) {
      return;
    }
    const currentTime = this.currentTime_();
    const measuredBandwidth = stats.bandwidth;
    const segmentDuration = this.pendingSegment_.duration;
    const requestTimeRemaining = Playlist.estimateSegmentRequestTime(segmentDuration, measuredBandwidth, this.playlist_, stats.bytesReceived);
    const timeUntilRebuffer$1 = timeUntilRebuffer(this.buffered_(), currentTime, this.vhs_.tech_.playbackRate()) - 1;
    if (requestTimeRemaining <= timeUntilRebuffer$1) {
      return;
    }
    const switchCandidate = minRebufferMaxBandwidthSelector({
      main: this.vhs_.playlists.main,
      currentTime,
      bandwidth: measuredBandwidth,
      duration: this.duration_(),
      segmentDuration,
      timeUntilRebuffer: timeUntilRebuffer$1,
      currentTimeline: this.currentTimeline_,
      syncController: this.syncController_
    });
    if (!switchCandidate) {
      return;
    }
    const rebufferingImpact = requestTimeRemaining - timeUntilRebuffer$1;
    const timeSavedBySwitching = rebufferingImpact - switchCandidate.rebufferingImpact;
    let minimumTimeSaving = 0.5;
    if (timeUntilRebuffer$1 <= TIME_FUDGE_FACTOR) {
      minimumTimeSaving = 1;
    }
    if (!switchCandidate.playlist || switchCandidate.playlist.uri === this.playlist_.uri || timeSavedBySwitching < minimumTimeSaving) {
      return;
    }
    this.bandwidth = switchCandidate.playlist.attributes.BANDWIDTH * Config.BANDWIDTH_VARIANCE + 1;
    this.trigger("earlyabort");
  }
  handleAbort_(segmentInfo) {
    this.logger_(`Aborting ${segmentInfoString(segmentInfo)}`);
    this.mediaRequestsAborted += 1;
  }
  handleProgress_(event, simpleSegment) {
    this.earlyAbortWhenNeeded_(simpleSegment.stats);
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    this.trigger("progress");
  }
  handleTrackInfo_(simpleSegment, trackInfo) {
    const {
      hasAudio,
      hasVideo
    } = trackInfo;
    const metadata = {
      segmentInfo: segmentInfoPayload({
        type: this.loaderType_,
        segment: simpleSegment
      }),
      trackInfo: {
        hasAudio,
        hasVideo
      }
    };
    this.trigger({
      type: "segmenttransmuxingtrackinfoavailable",
      metadata
    });
    this.earlyAbortWhenNeeded_(simpleSegment.stats);
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    if (this.checkForIllegalMediaSwitch(trackInfo)) {
      return;
    }
    trackInfo = trackInfo || {};
    if (!shallowEqual(this.currentMediaInfo_, trackInfo)) {
      this.appendInitSegment_ = {
        audio: true,
        video: true
      };
      this.startingMediaInfo_ = trackInfo;
      this.currentMediaInfo_ = trackInfo;
      this.logger_("trackinfo update", trackInfo);
      this.trigger("trackinfo");
    }
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    this.pendingSegment_.trackInfo = trackInfo;
    if (this.hasEnoughInfoToAppend_()) {
      this.processCallQueue_();
    } else {
      checkAndFixTimelines(this);
    }
  }
  handleTimingInfo_(simpleSegment, mediaType, timeType, time) {
    this.earlyAbortWhenNeeded_(simpleSegment.stats);
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    const segmentInfo = this.pendingSegment_;
    const timingInfoProperty = timingInfoPropertyForMedia(mediaType);
    segmentInfo[timingInfoProperty] = segmentInfo[timingInfoProperty] || {};
    segmentInfo[timingInfoProperty][timeType] = time;
    this.logger_(`timinginfo: ${mediaType} - ${timeType} - ${time}`);
    if (this.hasEnoughInfoToAppend_()) {
      this.processCallQueue_();
    } else {
      checkAndFixTimelines(this);
    }
  }
  handleCaptions_(simpleSegment, captionData) {
    this.earlyAbortWhenNeeded_(simpleSegment.stats);
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    if (captionData.length === 0) {
      this.logger_("SegmentLoader received no captions from a caption event");
      return;
    }
    const segmentInfo = this.pendingSegment_;
    if (!segmentInfo.hasAppendedData_) {
      this.metadataQueue_.caption.push(this.handleCaptions_.bind(this, simpleSegment, captionData));
      return;
    }
    const timestampOffset = this.sourceUpdater_.videoTimestampOffset() === null ? this.sourceUpdater_.audioTimestampOffset() : this.sourceUpdater_.videoTimestampOffset();
    const captionTracks = {};
    captionData.forEach((caption) => {
      captionTracks[caption.stream] = captionTracks[caption.stream] || {
        startTime: Infinity,
        captions: [],
        endTime: 0
      };
      const captionTrack = captionTracks[caption.stream];
      captionTrack.startTime = Math.min(captionTrack.startTime, caption.startTime + timestampOffset);
      captionTrack.endTime = Math.max(captionTrack.endTime, caption.endTime + timestampOffset);
      captionTrack.captions.push(caption);
    });
    Object.keys(captionTracks).forEach((trackName) => {
      const {
        startTime,
        endTime,
        captions
      } = captionTracks[trackName];
      const inbandTextTracks = this.inbandTextTracks_;
      this.logger_(`adding cues from ${startTime} -> ${endTime} for ${trackName}`);
      createCaptionsTrackIfNotExists(inbandTextTracks, this.vhs_.tech_, trackName);
      removeCuesFromTrack(startTime, endTime, inbandTextTracks[trackName]);
      addCaptionData({
        captionArray: captions,
        inbandTextTracks,
        timestampOffset
      });
    });
    if (this.transmuxer_) {
      this.transmuxer_.postMessage({
        action: "clearParsedMp4Captions"
      });
    }
  }
  handleId3_(simpleSegment, id3Frames, dispatchType) {
    this.earlyAbortWhenNeeded_(simpleSegment.stats);
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    const segmentInfo = this.pendingSegment_;
    if (!segmentInfo.hasAppendedData_) {
      this.metadataQueue_.id3.push(this.handleId3_.bind(this, simpleSegment, id3Frames, dispatchType));
      return;
    }
    this.addMetadataToTextTrack(dispatchType, id3Frames, this.duration_());
  }
  processMetadataQueue_() {
    this.metadataQueue_.id3.forEach((fn) => fn());
    this.metadataQueue_.caption.forEach((fn) => fn());
    this.metadataQueue_.id3 = [];
    this.metadataQueue_.caption = [];
  }
  processCallQueue_() {
    const callQueue = this.callQueue_;
    this.callQueue_ = [];
    callQueue.forEach((fun) => fun());
  }
  processLoadQueue_() {
    const loadQueue = this.loadQueue_;
    this.loadQueue_ = [];
    loadQueue.forEach((fun) => fun());
  }
  hasEnoughInfoToLoad_() {
    if (this.loaderType_ !== "audio") {
      return true;
    }
    const segmentInfo = this.pendingSegment_;
    if (!segmentInfo) {
      return false;
    }
    if (!this.getCurrentMediaInfo_()) {
      return true;
    }
    if (shouldWaitForTimelineChange({
      timelineChangeController: this.timelineChangeController_,
      currentTimeline: this.currentTimeline_,
      segmentTimeline: segmentInfo.timeline,
      loaderType: this.loaderType_,
      audioDisabled: this.audioDisabled_
    })) {
      return false;
    }
    return true;
  }
  getCurrentMediaInfo_(segmentInfo = this.pendingSegment_) {
    return segmentInfo && segmentInfo.trackInfo || this.currentMediaInfo_;
  }
  getMediaInfo_(segmentInfo = this.pendingSegment_) {
    return this.getCurrentMediaInfo_(segmentInfo) || this.startingMediaInfo_;
  }
  getPendingSegmentPlaylist() {
    return this.pendingSegment_ ? this.pendingSegment_.playlist : null;
  }
  hasEnoughInfoToAppend_() {
    if (!this.sourceUpdater_.ready()) {
      return false;
    }
    if (this.waitingOnRemove_ || this.quotaExceededErrorRetryTimeout_) {
      return false;
    }
    const segmentInfo = this.pendingSegment_;
    const trackInfo = this.getCurrentMediaInfo_();
    if (!segmentInfo || !trackInfo) {
      return false;
    }
    const {
      hasAudio,
      hasVideo,
      isMuxed: isMuxed2
    } = trackInfo;
    if (hasVideo && !segmentInfo.videoTimingInfo) {
      return false;
    }
    if (hasAudio && !this.audioDisabled_ && !isMuxed2 && !segmentInfo.audioTimingInfo) {
      return false;
    }
    if (shouldWaitForTimelineChange({
      timelineChangeController: this.timelineChangeController_,
      currentTimeline: this.currentTimeline_,
      segmentTimeline: segmentInfo.timeline,
      loaderType: this.loaderType_,
      audioDisabled: this.audioDisabled_
    })) {
      return false;
    }
    return true;
  }
  handleData_(simpleSegment, result) {
    this.earlyAbortWhenNeeded_(simpleSegment.stats);
    if (this.checkForAbort_(simpleSegment.requestId)) {
      return;
    }
    if (this.callQueue_.length || !this.hasEnoughInfoToAppend_()) {
      checkAndFixTimelines(this);
      this.callQueue_.push(this.handleData_.bind(this, simpleSegment, result));
      return;
    }
    const segmentInfo = this.pendingSegment_;
    this.setTimeMapping_(segmentInfo.timeline);
    this.updateMediaSecondsLoaded_(segmentInfo.part || segmentInfo.segment);
    if (this.mediaSource_.readyState === "closed") {
      return;
    }
    if (simpleSegment.map) {
      simpleSegment.map = this.initSegmentForMap(simpleSegment.map, true);
      segmentInfo.segment.map = simpleSegment.map;
    }
    if (simpleSegment.key) {
      this.segmentKey(simpleSegment.key, true);
    }
    segmentInfo.isFmp4 = simpleSegment.isFmp4;
    segmentInfo.timingInfo = segmentInfo.timingInfo || {};
    if (segmentInfo.isFmp4) {
      this.trigger("fmp4");
      segmentInfo.timingInfo.start = segmentInfo[timingInfoPropertyForMedia(result.type)].start;
    } else {
      const trackInfo = this.getCurrentMediaInfo_();
      const useVideoTimingInfo = this.loaderType_ === "main" && trackInfo && trackInfo.hasVideo;
      let firstVideoFrameTimeForData;
      if (useVideoTimingInfo) {
        firstVideoFrameTimeForData = segmentInfo.videoTimingInfo.start;
      }
      segmentInfo.timingInfo.start = this.trueSegmentStart_({
        currentStart: segmentInfo.timingInfo.start,
        playlist: segmentInfo.playlist,
        mediaIndex: segmentInfo.mediaIndex,
        currentVideoTimestampOffset: this.sourceUpdater_.videoTimestampOffset(),
        useVideoTimingInfo,
        firstVideoFrameTimeForData,
        videoTimingInfo: segmentInfo.videoTimingInfo,
        audioTimingInfo: segmentInfo.audioTimingInfo
      });
    }
    this.updateAppendInitSegmentStatus(segmentInfo, result.type);
    this.updateSourceBufferTimestampOffset_(segmentInfo);
    if (segmentInfo.isSyncRequest) {
      this.updateTimingInfoEnd_(segmentInfo);
      this.syncController_.saveSegmentTimingInfo({
        segmentInfo,
        shouldSaveTimelineMapping: this.loaderType_ === "main"
      });
      const next = this.chooseNextRequest_();
      if (next.mediaIndex !== segmentInfo.mediaIndex || next.partIndex !== segmentInfo.partIndex) {
        this.logger_("sync segment was incorrect, not appending");
        return;
      }
      this.logger_("sync segment was correct, appending");
    }
    segmentInfo.hasAppendedData_ = true;
    this.processMetadataQueue_();
    this.appendData_(segmentInfo, result);
  }
  updateAppendInitSegmentStatus(segmentInfo, type) {
    if (this.loaderType_ === "main" && typeof segmentInfo.timestampOffset === "number" && !segmentInfo.changedTimestampOffset) {
      this.appendInitSegment_ = {
        audio: true,
        video: true
      };
    }
    if (this.playlistOfLastInitSegment_[type] !== segmentInfo.playlist) {
      this.appendInitSegment_[type] = true;
    }
  }
  getInitSegmentAndUpdateState_({
    type,
    initSegment,
    map,
    playlist
  }) {
    if (map) {
      const id = initSegmentId(map);
      if (this.activeInitSegmentId_ === id) {
        return null;
      }
      initSegment = this.initSegmentForMap(map, true).bytes;
      this.activeInitSegmentId_ = id;
    }
    if (initSegment && this.appendInitSegment_[type]) {
      this.playlistOfLastInitSegment_[type] = playlist;
      this.appendInitSegment_[type] = false;
      this.activeInitSegmentId_ = null;
      return initSegment;
    }
    return null;
  }
  handleQuotaExceededError_({
    segmentInfo,
    type,
    bytes
  }, error) {
    const audioBuffered = this.sourceUpdater_.audioBuffered();
    const videoBuffered = this.sourceUpdater_.videoBuffered();
    if (audioBuffered.length > 1) {
      this.logger_("On QUOTA_EXCEEDED_ERR, found gaps in the audio buffer: " + timeRangesToArray(audioBuffered).join(", "));
    }
    if (videoBuffered.length > 1) {
      this.logger_("On QUOTA_EXCEEDED_ERR, found gaps in the video buffer: " + timeRangesToArray(videoBuffered).join(", "));
    }
    const audioBufferStart = audioBuffered.length ? audioBuffered.start(0) : 0;
    const audioBufferEnd = audioBuffered.length ? audioBuffered.end(audioBuffered.length - 1) : 0;
    const videoBufferStart = videoBuffered.length ? videoBuffered.start(0) : 0;
    const videoBufferEnd = videoBuffered.length ? videoBuffered.end(videoBuffered.length - 1) : 0;
    if (audioBufferEnd - audioBufferStart <= MIN_BACK_BUFFER && videoBufferEnd - videoBufferStart <= MIN_BACK_BUFFER) {
      this.logger_(`On QUOTA_EXCEEDED_ERR, single segment too large to append to buffer, triggering an error. Appended byte length: ${bytes.byteLength}, audio buffer: ${timeRangesToArray(audioBuffered).join(", ")}, video buffer: ${timeRangesToArray(videoBuffered).join(", ")}, `);
      this.error({
        message: "Quota exceeded error with append of a single segment of content",
        excludeUntil: Infinity
      });
      this.trigger("error");
      return;
    }
    this.waitingOnRemove_ = true;
    this.callQueue_.push(this.appendToSourceBuffer_.bind(this, {
      segmentInfo,
      type,
      bytes
    }));
    const currentTime = this.currentTime_();
    const timeToRemoveUntil = currentTime - MIN_BACK_BUFFER;
    this.logger_(`On QUOTA_EXCEEDED_ERR, removing audio/video from 0 to ${timeToRemoveUntil}`);
    this.remove(0, timeToRemoveUntil, () => {
      this.logger_(`On QUOTA_EXCEEDED_ERR, retrying append in ${MIN_BACK_BUFFER}s`);
      this.waitingOnRemove_ = false;
      this.quotaExceededErrorRetryTimeout_ = window_1.setTimeout(() => {
        this.logger_("On QUOTA_EXCEEDED_ERR, re-processing call queue");
        this.quotaExceededErrorRetryTimeout_ = null;
        this.processCallQueue_();
      }, MIN_BACK_BUFFER * 1e3);
    }, true);
  }
  handleAppendError_({
    segmentInfo,
    type,
    bytes
  }, error) {
    if (!error) {
      return;
    }
    if (error.code === QUOTA_EXCEEDED_ERR) {
      this.handleQuotaExceededError_({
        segmentInfo,
        type,
        bytes
      });
      return;
    }
    this.logger_("Received non QUOTA_EXCEEDED_ERR on append", error);
    this.error({
      message: `${type} append of ${bytes.length}b failed for segment #${segmentInfo.mediaIndex} in playlist ${segmentInfo.playlist.id}`,
      metadata: {
        errorType: videojs.Error.StreamingFailedToAppendSegment
      }
    });
    this.trigger("appenderror");
  }
  appendToSourceBuffer_({
    segmentInfo,
    type,
    initSegment,
    data,
    bytes
  }) {
    if (!bytes) {
      const segments = [data];
      let byteLength = data.byteLength;
      if (initSegment) {
        segments.unshift(initSegment);
        byteLength += initSegment.byteLength;
      }
      bytes = concatSegments({
        bytes: byteLength,
        segments
      });
    }
    const metadata = {
      segmentInfo: segmentInfoPayload({
        type: this.loaderType_,
        segment: segmentInfo
      })
    };
    this.trigger({
      type: "segmentappendstart",
      metadata
    });
    this.sourceUpdater_.appendBuffer({
      segmentInfo,
      type,
      bytes
    }, this.handleAppendError_.bind(this, {
      segmentInfo,
      type,
      bytes
    }));
  }
  handleSegmentTimingInfo_(type, requestId, segmentTimingInfo) {
    if (!this.pendingSegment_ || requestId !== this.pendingSegment_.requestId) {
      return;
    }
    const segment = this.pendingSegment_.segment;
    const timingInfoProperty = `${type}TimingInfo`;
    if (!segment[timingInfoProperty]) {
      segment[timingInfoProperty] = {};
    }
    segment[timingInfoProperty].transmuxerPrependedSeconds = segmentTimingInfo.prependedContentDuration || 0;
    segment[timingInfoProperty].transmuxedPresentationStart = segmentTimingInfo.start.presentation;
    segment[timingInfoProperty].transmuxedDecodeStart = segmentTimingInfo.start.decode;
    segment[timingInfoProperty].transmuxedPresentationEnd = segmentTimingInfo.end.presentation;
    segment[timingInfoProperty].transmuxedDecodeEnd = segmentTimingInfo.end.decode;
    segment[timingInfoProperty].baseMediaDecodeTime = segmentTimingInfo.baseMediaDecodeTime;
  }
  appendData_(segmentInfo, result) {
    const {
      type,
      data
    } = result;
    if (!data || !data.byteLength) {
      return;
    }
    if (type === "audio" && this.audioDisabled_) {
      return;
    }
    const initSegment = this.getInitSegmentAndUpdateState_({
      type,
      initSegment: result.initSegment,
      playlist: segmentInfo.playlist,
      map: segmentInfo.isFmp4 ? segmentInfo.segment.map : null
    });
    this.appendToSourceBuffer_({
      segmentInfo,
      type,
      initSegment,
      data
    });
  }
  loadSegment_(segmentInfo) {
    this.state = "WAITING";
    this.pendingSegment_ = segmentInfo;
    this.trimBackBuffer_(segmentInfo);
    if (typeof segmentInfo.timestampOffset === "number") {
      if (this.transmuxer_) {
        this.transmuxer_.postMessage({
          action: "clearAllMp4Captions"
        });
      }
    }
    if (!this.hasEnoughInfoToLoad_()) {
      checkAndFixTimelines(this);
      this.loadQueue_.push(() => {
        const options = _extends({}, segmentInfo, {
          forceTimestampOffset: true
        });
        _extends(segmentInfo, this.generateSegmentInfo_(options));
        this.isPendingTimestampOffset_ = false;
        this.updateTransmuxerAndRequestSegment_(segmentInfo);
      });
      return;
    }
    this.updateTransmuxerAndRequestSegment_(segmentInfo);
  }
  updateTransmuxerAndRequestSegment_(segmentInfo) {
    if (this.shouldUpdateTransmuxerTimestampOffset_(segmentInfo.timestampOffset)) {
      this.gopBuffer_.length = 0;
      segmentInfo.gopsToAlignWith = [];
      this.timeMapping_ = 0;
      this.transmuxer_.postMessage({
        action: "reset"
      });
      this.transmuxer_.postMessage({
        action: "setTimestampOffset",
        timestampOffset: segmentInfo.timestampOffset
      });
    }
    const simpleSegment = this.createSimplifiedSegmentObj_(segmentInfo);
    const isEndOfStream = this.isEndOfStream_(segmentInfo.mediaIndex, segmentInfo.playlist, segmentInfo.partIndex);
    const isWalkingForward = this.mediaIndex !== null;
    const isDiscontinuity = segmentInfo.timeline !== this.currentTimeline_ && segmentInfo.timeline > 0;
    const isEndOfTimeline = isEndOfStream || isWalkingForward && isDiscontinuity;
    this.logger_(`Requesting
${compactSegmentUrlDescription(segmentInfo.uri)}
${segmentInfoString(segmentInfo)}`);
    if (simpleSegment.map && !simpleSegment.map.bytes) {
      this.logger_("going to request init segment.");
      this.appendInitSegment_ = {
        video: true,
        audio: true
      };
    }
    segmentInfo.abortRequests = mediaSegmentRequest({
      xhr: this.vhs_.xhr,
      xhrOptions: this.xhrOptions_,
      decryptionWorker: this.decrypter_,
      segment: simpleSegment,
      abortFn: this.handleAbort_.bind(this, segmentInfo),
      progressFn: this.handleProgress_.bind(this),
      trackInfoFn: this.handleTrackInfo_.bind(this),
      timingInfoFn: this.handleTimingInfo_.bind(this),
      videoSegmentTimingInfoFn: this.handleSegmentTimingInfo_.bind(this, "video", segmentInfo.requestId),
      audioSegmentTimingInfoFn: this.handleSegmentTimingInfo_.bind(this, "audio", segmentInfo.requestId),
      captionsFn: this.handleCaptions_.bind(this),
      isEndOfTimeline,
      endedTimelineFn: () => {
        this.logger_("received endedtimeline callback");
      },
      id3Fn: this.handleId3_.bind(this),
      dataFn: this.handleData_.bind(this),
      doneFn: this.segmentRequestFinished_.bind(this),
      onTransmuxerLog: ({
        message,
        level,
        stream
      }) => {
        this.logger_(`${segmentInfoString(segmentInfo)} logged from transmuxer stream ${stream} as a ${level}: ${message}`);
      },
      triggerSegmentEventFn: ({
        type,
        segment,
        keyInfo,
        trackInfo,
        timingInfo
      }) => {
        const segInfo = segmentInfoPayload({
          segment
        });
        const metadata = {
          segmentInfo: segInfo
        };
        if (keyInfo) {
          metadata.keyInfo = keyInfo;
        }
        if (trackInfo) {
          metadata.trackInfo = trackInfo;
        }
        if (timingInfo) {
          metadata.timingInfo = timingInfo;
        }
        this.trigger({
          type,
          metadata
        });
      }
    });
  }
  trimBackBuffer_(segmentInfo) {
    const removeToTime = safeBackBufferTrimTime(this.seekable_(), this.currentTime_(), this.playlist_.targetDuration || 10);
    if (removeToTime > 0) {
      this.remove(0, removeToTime);
    }
  }
  createSimplifiedSegmentObj_(segmentInfo) {
    const segment = segmentInfo.segment;
    const part = segmentInfo.part;
    const isEncrypted = segmentInfo.segment.key || segmentInfo.segment.map && segmentInfo.segment.map.key;
    const isMediaInitialization = segmentInfo.segment.map && !segmentInfo.segment.map.bytes;
    const simpleSegment = {
      resolvedUri: part ? part.resolvedUri : segment.resolvedUri,
      byterange: part ? part.byterange : segment.byterange,
      requestId: segmentInfo.requestId,
      transmuxer: segmentInfo.transmuxer,
      audioAppendStart: segmentInfo.audioAppendStart,
      gopsToAlignWith: segmentInfo.gopsToAlignWith,
      part: segmentInfo.part,
      type: this.loaderType_,
      start: segmentInfo.startOfSegment,
      duration: segmentInfo.duration,
      isEncrypted,
      isMediaInitialization
    };
    const previousSegment = segmentInfo.playlist.segments[segmentInfo.mediaIndex - 1];
    if (previousSegment && previousSegment.timeline === segment.timeline) {
      if (previousSegment.videoTimingInfo) {
        simpleSegment.baseStartTime = previousSegment.videoTimingInfo.transmuxedDecodeEnd;
      } else if (previousSegment.audioTimingInfo) {
        simpleSegment.baseStartTime = previousSegment.audioTimingInfo.transmuxedDecodeEnd;
      }
    }
    if (segment.key) {
      const iv = segment.key.iv || new Uint32Array([0, 0, 0, segmentInfo.mediaIndex + segmentInfo.playlist.mediaSequence]);
      simpleSegment.key = this.segmentKey(segment.key);
      simpleSegment.key.iv = iv;
    }
    if (segment.map) {
      simpleSegment.map = this.initSegmentForMap(segment.map);
    }
    return simpleSegment;
  }
  saveTransferStats_(stats) {
    this.mediaRequests += 1;
    if (stats) {
      this.mediaBytesTransferred += stats.bytesReceived;
      this.mediaTransferDuration += stats.roundTripTime;
    }
  }
  saveBandwidthRelatedStats_(duration2, stats) {
    this.pendingSegment_.byteLength = stats.bytesReceived;
    if (duration2 < MIN_SEGMENT_DURATION_TO_SAVE_STATS) {
      this.logger_(`Ignoring segment's bandwidth because its duration of ${duration2} is less than the min to record ${MIN_SEGMENT_DURATION_TO_SAVE_STATS}`);
      return;
    }
    const metadata = {
      bandwidthInfo: {
        from: this.bandwidth,
        to: stats.bandwidth
      }
    };
    this.trigger({
      type: "bandwidthupdated",
      metadata
    });
    this.bandwidth = stats.bandwidth;
    this.roundTrip = stats.roundTripTime;
  }
  handleTimeout_() {
    this.mediaRequestsTimedout += 1;
    this.bandwidth = 1;
    this.roundTrip = NaN;
    this.trigger("bandwidthupdate");
    this.trigger("timeout");
  }
  segmentRequestFinished_(error, simpleSegment, result) {
    if (this.callQueue_.length) {
      this.callQueue_.push(this.segmentRequestFinished_.bind(this, error, simpleSegment, result));
      return;
    }
    this.saveTransferStats_(simpleSegment.stats);
    if (!this.pendingSegment_) {
      return;
    }
    if (simpleSegment.requestId !== this.pendingSegment_.requestId) {
      return;
    }
    if (error) {
      this.pendingSegment_ = null;
      this.state = "READY";
      if (error.code === REQUEST_ERRORS.ABORTED) {
        return;
      }
      this.pause();
      if (error.code === REQUEST_ERRORS.TIMEOUT) {
        this.handleTimeout_();
        return;
      }
      this.mediaRequestsErrored += 1;
      this.error(error);
      this.trigger("error");
      return;
    }
    const segmentInfo = this.pendingSegment_;
    this.saveBandwidthRelatedStats_(segmentInfo.duration, simpleSegment.stats);
    segmentInfo.endOfAllRequests = simpleSegment.endOfAllRequests;
    if (result.gopInfo) {
      this.gopBuffer_ = updateGopBuffer(this.gopBuffer_, result.gopInfo, this.safeAppend_);
    }
    this.state = "APPENDING";
    this.trigger("appending");
    this.waitForAppendsToComplete_(segmentInfo);
  }
  setTimeMapping_(timeline) {
    const timelineMapping = this.syncController_.mappingForTimeline(timeline);
    if (timelineMapping !== null) {
      this.timeMapping_ = timelineMapping;
    }
  }
  updateMediaSecondsLoaded_(segment) {
    if (typeof segment.start === "number" && typeof segment.end === "number") {
      this.mediaSecondsLoaded += segment.end - segment.start;
    } else {
      this.mediaSecondsLoaded += segment.duration;
    }
  }
  shouldUpdateTransmuxerTimestampOffset_(timestampOffset) {
    if (timestampOffset === null) {
      return false;
    }
    if (this.loaderType_ === "main" && timestampOffset !== this.sourceUpdater_.videoTimestampOffset()) {
      return true;
    }
    if (!this.audioDisabled_ && timestampOffset !== this.sourceUpdater_.audioTimestampOffset()) {
      return true;
    }
    return false;
  }
  trueSegmentStart_({
    currentStart,
    playlist,
    mediaIndex,
    firstVideoFrameTimeForData,
    currentVideoTimestampOffset,
    useVideoTimingInfo,
    videoTimingInfo,
    audioTimingInfo
  }) {
    if (typeof currentStart !== "undefined") {
      return currentStart;
    }
    if (!useVideoTimingInfo) {
      return audioTimingInfo.start;
    }
    const previousSegment = playlist.segments[mediaIndex - 1];
    if (mediaIndex === 0 || !previousSegment || typeof previousSegment.start === "undefined" || previousSegment.end !== firstVideoFrameTimeForData + currentVideoTimestampOffset) {
      return firstVideoFrameTimeForData;
    }
    return videoTimingInfo.start;
  }
  waitForAppendsToComplete_(segmentInfo) {
    const trackInfo = this.getCurrentMediaInfo_(segmentInfo);
    if (!trackInfo) {
      this.error({
        message: "No starting media returned, likely due to an unsupported media format.",
        playlistExclusionDuration: Infinity
      });
      this.trigger("error");
      return;
    }
    const {
      hasAudio,
      hasVideo,
      isMuxed: isMuxed2
    } = trackInfo;
    const waitForVideo = this.loaderType_ === "main" && hasVideo;
    const waitForAudio = !this.audioDisabled_ && hasAudio && !isMuxed2;
    segmentInfo.waitingOnAppends = 0;
    if (!segmentInfo.hasAppendedData_) {
      if (!segmentInfo.timingInfo && typeof segmentInfo.timestampOffset === "number") {
        this.isPendingTimestampOffset_ = true;
      }
      segmentInfo.timingInfo = {
        start: 0
      };
      segmentInfo.waitingOnAppends++;
      if (!this.isPendingTimestampOffset_) {
        this.updateSourceBufferTimestampOffset_(segmentInfo);
        this.processMetadataQueue_();
      }
      this.checkAppendsDone_(segmentInfo);
      return;
    }
    if (waitForVideo) {
      segmentInfo.waitingOnAppends++;
    }
    if (waitForAudio) {
      segmentInfo.waitingOnAppends++;
    }
    if (waitForVideo) {
      this.sourceUpdater_.videoQueueCallback(this.checkAppendsDone_.bind(this, segmentInfo));
    }
    if (waitForAudio) {
      this.sourceUpdater_.audioQueueCallback(this.checkAppendsDone_.bind(this, segmentInfo));
    }
  }
  checkAppendsDone_(segmentInfo) {
    if (this.checkForAbort_(segmentInfo.requestId)) {
      return;
    }
    segmentInfo.waitingOnAppends--;
    if (segmentInfo.waitingOnAppends === 0) {
      this.handleAppendsDone_();
    }
  }
  checkForIllegalMediaSwitch(trackInfo) {
    const illegalMediaSwitchError = illegalMediaSwitch(this.loaderType_, this.getCurrentMediaInfo_(), trackInfo);
    if (illegalMediaSwitchError) {
      this.error({
        message: illegalMediaSwitchError,
        playlistExclusionDuration: Infinity
      });
      this.trigger("error");
      return true;
    }
    return false;
  }
  updateSourceBufferTimestampOffset_(segmentInfo) {
    if (segmentInfo.timestampOffset === null || typeof segmentInfo.timingInfo.start !== "number" || segmentInfo.changedTimestampOffset || this.loaderType_ !== "main") {
      return;
    }
    let didChange = false;
    segmentInfo.timestampOffset -= this.getSegmentStartTimeForTimestampOffsetCalculation_({
      videoTimingInfo: segmentInfo.segment.videoTimingInfo,
      audioTimingInfo: segmentInfo.segment.audioTimingInfo,
      timingInfo: segmentInfo.timingInfo
    });
    segmentInfo.changedTimestampOffset = true;
    if (segmentInfo.timestampOffset !== this.sourceUpdater_.videoTimestampOffset()) {
      this.sourceUpdater_.videoTimestampOffset(segmentInfo.timestampOffset);
      didChange = true;
    }
    if (segmentInfo.timestampOffset !== this.sourceUpdater_.audioTimestampOffset()) {
      this.sourceUpdater_.audioTimestampOffset(segmentInfo.timestampOffset);
      didChange = true;
    }
    if (didChange) {
      this.trigger("timestampoffset");
    }
  }
  getSegmentStartTimeForTimestampOffsetCalculation_({
    videoTimingInfo,
    audioTimingInfo,
    timingInfo
  }) {
    if (!this.useDtsForTimestampOffset_) {
      return timingInfo.start;
    }
    if (videoTimingInfo && typeof videoTimingInfo.transmuxedDecodeStart === "number") {
      return videoTimingInfo.transmuxedDecodeStart;
    }
    if (audioTimingInfo && typeof audioTimingInfo.transmuxedDecodeStart === "number") {
      return audioTimingInfo.transmuxedDecodeStart;
    }
    return timingInfo.start;
  }
  updateTimingInfoEnd_(segmentInfo) {
    segmentInfo.timingInfo = segmentInfo.timingInfo || {};
    const trackInfo = this.getMediaInfo_();
    const useVideoTimingInfo = this.loaderType_ === "main" && trackInfo && trackInfo.hasVideo;
    const prioritizedTimingInfo = useVideoTimingInfo && segmentInfo.videoTimingInfo ? segmentInfo.videoTimingInfo : segmentInfo.audioTimingInfo;
    if (!prioritizedTimingInfo) {
      return;
    }
    segmentInfo.timingInfo.end = typeof prioritizedTimingInfo.end === "number" ? prioritizedTimingInfo.end : prioritizedTimingInfo.start + segmentInfo.duration;
  }
  handleAppendsDone_() {
    if (this.pendingSegment_) {
      const metadata = {
        segmentInfo: segmentInfoPayload({
          type: this.loaderType_,
          segment: this.pendingSegment_
        })
      };
      this.trigger({
        type: "appendsdone",
        metadata
      });
    }
    if (!this.pendingSegment_) {
      this.state = "READY";
      if (!this.paused()) {
        this.monitorBuffer_();
      }
      return;
    }
    const segmentInfo = this.pendingSegment_;
    if (segmentInfo.part && segmentInfo.part.syncInfo) {
      segmentInfo.part.syncInfo.markAppended();
    } else if (segmentInfo.segment.syncInfo) {
      segmentInfo.segment.syncInfo.markAppended();
    }
    this.updateTimingInfoEnd_(segmentInfo);
    if (this.shouldSaveSegmentTimingInfo_) {
      this.syncController_.saveSegmentTimingInfo({
        segmentInfo,
        shouldSaveTimelineMapping: this.loaderType_ === "main"
      });
    }
    const segmentDurationMessage = getTroublesomeSegmentDurationMessage(segmentInfo, this.sourceType_);
    if (segmentDurationMessage) {
      if (segmentDurationMessage.severity === "warn") {
        videojs.log.warn(segmentDurationMessage.message);
      } else {
        this.logger_(segmentDurationMessage.message);
      }
    }
    this.recordThroughput_(segmentInfo);
    this.pendingSegment_ = null;
    this.state = "READY";
    if (segmentInfo.isSyncRequest) {
      this.trigger("syncinfoupdate");
      if (!segmentInfo.hasAppendedData_) {
        this.logger_(`Throwing away un-appended sync request ${segmentInfoString(segmentInfo)}`);
        return;
      }
    }
    this.logger_(`Appended ${segmentInfoString(segmentInfo)}`);
    this.addSegmentMetadataCue_(segmentInfo);
    this.fetchAtBuffer_ = true;
    if (this.currentTimeline_ !== segmentInfo.timeline) {
      this.timelineChangeController_.lastTimelineChange({
        type: this.loaderType_,
        from: this.currentTimeline_,
        to: segmentInfo.timeline
      });
      if (this.loaderType_ === "main" && !this.audioDisabled_) {
        this.timelineChangeController_.lastTimelineChange({
          type: "audio",
          from: this.currentTimeline_,
          to: segmentInfo.timeline
        });
      }
    }
    this.currentTimeline_ = segmentInfo.timeline;
    this.trigger("syncinfoupdate");
    const segment = segmentInfo.segment;
    const part = segmentInfo.part;
    const badSegmentGuess = segment.end && this.currentTime_() - segment.end > segmentInfo.playlist.targetDuration * 3;
    const badPartGuess = part && part.end && this.currentTime_() - part.end > segmentInfo.playlist.partTargetDuration * 3;
    if (badSegmentGuess || badPartGuess) {
      this.logger_(`bad ${badSegmentGuess ? "segment" : "part"} ${segmentInfoString(segmentInfo)}`);
      this.resetEverything();
      return;
    }
    const isWalkingForward = this.mediaIndex !== null;
    if (isWalkingForward) {
      this.trigger("bandwidthupdate");
    }
    this.trigger("progress");
    this.mediaIndex = segmentInfo.mediaIndex;
    this.partIndex = segmentInfo.partIndex;
    if (this.isEndOfStream_(segmentInfo.mediaIndex, segmentInfo.playlist, segmentInfo.partIndex)) {
      this.endOfStream();
    }
    this.trigger("appended");
    if (segmentInfo.hasAppendedData_) {
      this.mediaAppends++;
    }
    if (!this.paused()) {
      this.monitorBuffer_();
    }
  }
  recordThroughput_(segmentInfo) {
    if (segmentInfo.duration < MIN_SEGMENT_DURATION_TO_SAVE_STATS) {
      this.logger_(`Ignoring segment's throughput because its duration of ${segmentInfo.duration} is less than the min to record ${MIN_SEGMENT_DURATION_TO_SAVE_STATS}`);
      return;
    }
    const rate = this.throughput.rate;
    const segmentProcessingTime = Date.now() - segmentInfo.endOfAllRequests + 1;
    const segmentProcessingThroughput = Math.floor(segmentInfo.byteLength / segmentProcessingTime * 8 * 1e3);
    this.throughput.rate += (segmentProcessingThroughput - rate) / ++this.throughput.count;
  }
  addSegmentMetadataCue_(segmentInfo) {
    if (!this.segmentMetadataTrack_) {
      return;
    }
    const segment = segmentInfo.segment;
    const start = segment.start;
    const end = segment.end;
    if (!finite(start) || !finite(end)) {
      return;
    }
    removeCuesFromTrack(start, end, this.segmentMetadataTrack_);
    const Cue = window_1.WebKitDataCue || window_1.VTTCue;
    const value = {
      custom: segment.custom,
      dateTimeObject: segment.dateTimeObject,
      dateTimeString: segment.dateTimeString,
      programDateTime: segment.programDateTime,
      bandwidth: segmentInfo.playlist.attributes.BANDWIDTH,
      resolution: segmentInfo.playlist.attributes.RESOLUTION,
      codecs: segmentInfo.playlist.attributes.CODECS,
      byteLength: segmentInfo.byteLength,
      uri: segmentInfo.uri,
      timeline: segmentInfo.timeline,
      playlist: segmentInfo.playlist.id,
      start,
      end
    };
    const data = JSON.stringify(value);
    const cue = new Cue(start, end, data);
    cue.value = value;
    this.segmentMetadataTrack_.addCue(cue);
  }
}
function noop() {
}
const toTitleCase = function(string) {
  if (typeof string !== "string") {
    return string;
  }
  return string.replace(/./, (w) => w.toUpperCase());
};
const bufferTypes = ["video", "audio"];
const updating = (type, sourceUpdater) => {
  const sourceBuffer = sourceUpdater[`${type}Buffer`];
  return sourceBuffer && sourceBuffer.updating || sourceUpdater.queuePending[type];
};
const nextQueueIndexOfType = (type, queue) => {
  for (let i = 0; i < queue.length; i++) {
    const queueEntry = queue[i];
    if (queueEntry.type === "mediaSource") {
      return null;
    }
    if (queueEntry.type === type) {
      return i;
    }
  }
  return null;
};
const shiftQueue = (type, sourceUpdater) => {
  if (sourceUpdater.queue.length === 0) {
    return;
  }
  let queueIndex = 0;
  let queueEntry = sourceUpdater.queue[queueIndex];
  if (queueEntry.type === "mediaSource") {
    if (!sourceUpdater.updating() && sourceUpdater.mediaSource.readyState !== "closed") {
      sourceUpdater.queue.shift();
      queueEntry.action(sourceUpdater);
      if (queueEntry.doneFn) {
        queueEntry.doneFn();
      }
      shiftQueue("audio", sourceUpdater);
      shiftQueue("video", sourceUpdater);
    }
    return;
  }
  if (type === "mediaSource") {
    return;
  }
  if (!sourceUpdater.ready() || sourceUpdater.mediaSource.readyState === "closed" || updating(type, sourceUpdater)) {
    return;
  }
  if (queueEntry.type !== type) {
    queueIndex = nextQueueIndexOfType(type, sourceUpdater.queue);
    if (queueIndex === null) {
      return;
    }
    queueEntry = sourceUpdater.queue[queueIndex];
  }
  sourceUpdater.queue.splice(queueIndex, 1);
  sourceUpdater.queuePending[type] = queueEntry;
  queueEntry.action(type, sourceUpdater);
  if (!queueEntry.doneFn) {
    sourceUpdater.queuePending[type] = null;
    shiftQueue(type, sourceUpdater);
    return;
  }
};
const cleanupBuffer = (type, sourceUpdater) => {
  const buffer = sourceUpdater[`${type}Buffer`];
  const titleType = toTitleCase(type);
  if (!buffer) {
    return;
  }
  buffer.removeEventListener("updateend", sourceUpdater[`on${titleType}UpdateEnd_`]);
  buffer.removeEventListener("error", sourceUpdater[`on${titleType}Error_`]);
  sourceUpdater.codecs[type] = null;
  sourceUpdater[`${type}Buffer`] = null;
};
const inSourceBuffers = (mediaSource, sourceBuffer) => mediaSource && sourceBuffer && Array.prototype.indexOf.call(mediaSource.sourceBuffers, sourceBuffer) !== -1;
const actions = {
  appendBuffer: (bytes, segmentInfo, onError2) => (type, sourceUpdater) => {
    const sourceBuffer = sourceUpdater[`${type}Buffer`];
    if (!inSourceBuffers(sourceUpdater.mediaSource, sourceBuffer)) {
      return;
    }
    sourceUpdater.logger_(`Appending segment ${segmentInfo.mediaIndex}'s ${bytes.length} bytes to ${type}Buffer`);
    try {
      sourceBuffer.appendBuffer(bytes);
    } catch (e) {
      sourceUpdater.logger_(`Error with code ${e.code} ` + (e.code === QUOTA_EXCEEDED_ERR ? "(QUOTA_EXCEEDED_ERR) " : "") + `when appending segment ${segmentInfo.mediaIndex} to ${type}Buffer`);
      sourceUpdater.queuePending[type] = null;
      onError2(e);
    }
  },
  remove: (start, end) => (type, sourceUpdater) => {
    const sourceBuffer = sourceUpdater[`${type}Buffer`];
    if (!inSourceBuffers(sourceUpdater.mediaSource, sourceBuffer)) {
      return;
    }
    sourceUpdater.logger_(`Removing ${start} to ${end} from ${type}Buffer`);
    try {
      sourceBuffer.remove(start, end);
    } catch (e) {
      sourceUpdater.logger_(`Remove ${start} to ${end} from ${type}Buffer failed`);
    }
  },
  timestampOffset: (offset) => (type, sourceUpdater) => {
    const sourceBuffer = sourceUpdater[`${type}Buffer`];
    if (!inSourceBuffers(sourceUpdater.mediaSource, sourceBuffer)) {
      return;
    }
    sourceUpdater.logger_(`Setting ${type}timestampOffset to ${offset}`);
    sourceBuffer.timestampOffset = offset;
  },
  callback: (callback) => (type, sourceUpdater) => {
    callback();
  },
  endOfStream: (error) => (sourceUpdater) => {
    if (sourceUpdater.mediaSource.readyState !== "open") {
      return;
    }
    sourceUpdater.logger_(`Calling mediaSource endOfStream(${error || ""})`);
    try {
      sourceUpdater.mediaSource.endOfStream(error);
    } catch (e) {
      videojs.log.warn("Failed to call media source endOfStream", e);
    }
  },
  duration: (duration2) => (sourceUpdater) => {
    sourceUpdater.logger_(`Setting mediaSource duration to ${duration2}`);
    try {
      sourceUpdater.mediaSource.duration = duration2;
    } catch (e) {
      videojs.log.warn("Failed to set media source duration", e);
    }
  },
  abort: () => (type, sourceUpdater) => {
    if (sourceUpdater.mediaSource.readyState !== "open") {
      return;
    }
    const sourceBuffer = sourceUpdater[`${type}Buffer`];
    if (!inSourceBuffers(sourceUpdater.mediaSource, sourceBuffer)) {
      return;
    }
    sourceUpdater.logger_(`calling abort on ${type}Buffer`);
    try {
      sourceBuffer.abort();
    } catch (e) {
      videojs.log.warn(`Failed to abort on ${type}Buffer`, e);
    }
  },
  addSourceBuffer: (type, codec) => (sourceUpdater) => {
    const titleType = toTitleCase(type);
    const mime = getMimeForCodec(codec);
    sourceUpdater.logger_(`Adding ${type}Buffer with codec ${codec} to mediaSource`);
    const sourceBuffer = sourceUpdater.mediaSource.addSourceBuffer(mime);
    sourceBuffer.addEventListener("updateend", sourceUpdater[`on${titleType}UpdateEnd_`]);
    sourceBuffer.addEventListener("error", sourceUpdater[`on${titleType}Error_`]);
    sourceUpdater.codecs[type] = codec;
    sourceUpdater[`${type}Buffer`] = sourceBuffer;
  },
  removeSourceBuffer: (type) => (sourceUpdater) => {
    const sourceBuffer = sourceUpdater[`${type}Buffer`];
    cleanupBuffer(type, sourceUpdater);
    if (!inSourceBuffers(sourceUpdater.mediaSource, sourceBuffer)) {
      return;
    }
    sourceUpdater.logger_(`Removing ${type}Buffer with codec ${sourceUpdater.codecs[type]} from mediaSource`);
    try {
      sourceUpdater.mediaSource.removeSourceBuffer(sourceBuffer);
    } catch (e) {
      videojs.log.warn(`Failed to removeSourceBuffer ${type}Buffer`, e);
    }
  },
  changeType: (codec) => (type, sourceUpdater) => {
    const sourceBuffer = sourceUpdater[`${type}Buffer`];
    const mime = getMimeForCodec(codec);
    if (!inSourceBuffers(sourceUpdater.mediaSource, sourceBuffer)) {
      return;
    }
    const newCodecBase = codec.substring(0, codec.indexOf("."));
    const oldCodec = sourceUpdater.codecs[type];
    const oldCodecBase = oldCodec.substring(0, oldCodec.indexOf("."));
    if (oldCodecBase === newCodecBase) {
      return;
    }
    const metadata = {
      codecsChangeInfo: {
        from: oldCodec,
        to: codec
      }
    };
    sourceUpdater.trigger({
      type: "codecschange",
      metadata
    });
    sourceUpdater.logger_(`changing ${type}Buffer codec from ${oldCodec} to ${codec}`);
    try {
      sourceBuffer.changeType(mime);
      sourceUpdater.codecs[type] = codec;
    } catch (e) {
      metadata.errorType = videojs.Error.StreamingCodecsChangeError;
      metadata.error = e;
      e.metadata = metadata;
      sourceUpdater.error_ = e;
      sourceUpdater.trigger("error");
      videojs.log.warn(`Failed to changeType on ${type}Buffer`, e);
    }
  }
};
const pushQueue = ({
  type,
  sourceUpdater,
  action,
  doneFn,
  name
}) => {
  sourceUpdater.queue.push({
    type,
    action,
    doneFn,
    name
  });
  shiftQueue(type, sourceUpdater);
};
const onUpdateend = (type, sourceUpdater) => (e) => {
  const bufferedRangesForType = sourceUpdater[`${type}Buffered`]();
  const descriptiveString = bufferedRangesToString(bufferedRangesForType);
  sourceUpdater.logger_(`received "updateend" event for ${type} Source Buffer: `, descriptiveString);
  if (sourceUpdater.queuePending[type]) {
    const doneFn = sourceUpdater.queuePending[type].doneFn;
    sourceUpdater.queuePending[type] = null;
    if (doneFn) {
      doneFn(sourceUpdater[`${type}Error_`]);
    }
  }
  shiftQueue(type, sourceUpdater);
};
class SourceUpdater extends videojs.EventTarget {
  constructor(mediaSource) {
    super();
    this.mediaSource = mediaSource;
    this.sourceopenListener_ = () => shiftQueue("mediaSource", this);
    this.mediaSource.addEventListener("sourceopen", this.sourceopenListener_);
    this.logger_ = logger("SourceUpdater");
    this.audioTimestampOffset_ = 0;
    this.videoTimestampOffset_ = 0;
    this.queue = [];
    this.queuePending = {
      audio: null,
      video: null
    };
    this.delayedAudioAppendQueue_ = [];
    this.videoAppendQueued_ = false;
    this.codecs = {};
    this.onVideoUpdateEnd_ = onUpdateend("video", this);
    this.onAudioUpdateEnd_ = onUpdateend("audio", this);
    this.onVideoError_ = (e) => {
      this.videoError_ = e;
    };
    this.onAudioError_ = (e) => {
      this.audioError_ = e;
    };
    this.createdSourceBuffers_ = false;
    this.initializedEme_ = false;
    this.triggeredReady_ = false;
  }
  initializedEme() {
    this.initializedEme_ = true;
    this.triggerReady();
  }
  hasCreatedSourceBuffers() {
    return this.createdSourceBuffers_;
  }
  hasInitializedAnyEme() {
    return this.initializedEme_;
  }
  ready() {
    return this.hasCreatedSourceBuffers() && this.hasInitializedAnyEme();
  }
  createSourceBuffers(codecs) {
    if (this.hasCreatedSourceBuffers()) {
      return;
    }
    this.addOrChangeSourceBuffers(codecs);
    this.createdSourceBuffers_ = true;
    this.trigger("createdsourcebuffers");
    this.triggerReady();
  }
  triggerReady() {
    if (this.ready() && !this.triggeredReady_) {
      this.triggeredReady_ = true;
      this.trigger("ready");
    }
  }
  addSourceBuffer(type, codec) {
    pushQueue({
      type: "mediaSource",
      sourceUpdater: this,
      action: actions.addSourceBuffer(type, codec),
      name: "addSourceBuffer"
    });
  }
  abort(type) {
    pushQueue({
      type,
      sourceUpdater: this,
      action: actions.abort(type),
      name: "abort"
    });
  }
  removeSourceBuffer(type) {
    if (!this.canRemoveSourceBuffer()) {
      videojs.log.error("removeSourceBuffer is not supported!");
      return;
    }
    pushQueue({
      type: "mediaSource",
      sourceUpdater: this,
      action: actions.removeSourceBuffer(type),
      name: "removeSourceBuffer"
    });
  }
  canRemoveSourceBuffer() {
    return !videojs.browser.IS_FIREFOX && window_1.MediaSource && window_1.MediaSource.prototype && typeof window_1.MediaSource.prototype.removeSourceBuffer === "function";
  }
  static canChangeType() {
    return window_1.SourceBuffer && window_1.SourceBuffer.prototype && typeof window_1.SourceBuffer.prototype.changeType === "function";
  }
  canChangeType() {
    return this.constructor.canChangeType();
  }
  changeType(type, codec) {
    if (!this.canChangeType()) {
      videojs.log.error("changeType is not supported!");
      return;
    }
    pushQueue({
      type,
      sourceUpdater: this,
      action: actions.changeType(codec),
      name: "changeType"
    });
  }
  addOrChangeSourceBuffers(codecs) {
    if (!codecs || typeof codecs !== "object" || Object.keys(codecs).length === 0) {
      throw new Error("Cannot addOrChangeSourceBuffers to undefined codecs");
    }
    Object.keys(codecs).forEach((type) => {
      const codec = codecs[type];
      if (!this.hasCreatedSourceBuffers()) {
        return this.addSourceBuffer(type, codec);
      }
      if (this.canChangeType()) {
        this.changeType(type, codec);
      }
    });
  }
  appendBuffer(options, doneFn) {
    const {
      segmentInfo,
      type,
      bytes
    } = options;
    this.processedAppend_ = true;
    if (type === "audio" && this.videoBuffer && !this.videoAppendQueued_) {
      this.delayedAudioAppendQueue_.push([options, doneFn]);
      this.logger_(`delayed audio append of ${bytes.length} until video append`);
      return;
    }
    const onError2 = doneFn;
    pushQueue({
      type,
      sourceUpdater: this,
      action: actions.appendBuffer(bytes, segmentInfo || {
        mediaIndex: -1
      }, onError2),
      doneFn,
      name: "appendBuffer"
    });
    if (type === "video") {
      this.videoAppendQueued_ = true;
      if (!this.delayedAudioAppendQueue_.length) {
        return;
      }
      const queue = this.delayedAudioAppendQueue_.slice();
      this.logger_(`queuing delayed audio ${queue.length} appendBuffers`);
      this.delayedAudioAppendQueue_.length = 0;
      queue.forEach((que) => {
        this.appendBuffer.apply(this, que);
      });
    }
  }
  audioBuffered() {
    if (!inSourceBuffers(this.mediaSource, this.audioBuffer)) {
      return createTimeRanges();
    }
    return this.audioBuffer.buffered ? this.audioBuffer.buffered : createTimeRanges();
  }
  videoBuffered() {
    if (!inSourceBuffers(this.mediaSource, this.videoBuffer)) {
      return createTimeRanges();
    }
    return this.videoBuffer.buffered ? this.videoBuffer.buffered : createTimeRanges();
  }
  buffered() {
    const video = inSourceBuffers(this.mediaSource, this.videoBuffer) ? this.videoBuffer : null;
    const audio = inSourceBuffers(this.mediaSource, this.audioBuffer) ? this.audioBuffer : null;
    if (audio && !video) {
      return this.audioBuffered();
    }
    if (video && !audio) {
      return this.videoBuffered();
    }
    return bufferIntersection(this.audioBuffered(), this.videoBuffered());
  }
  setDuration(duration2, doneFn = noop) {
    pushQueue({
      type: "mediaSource",
      sourceUpdater: this,
      action: actions.duration(duration2),
      name: "duration",
      doneFn
    });
  }
  endOfStream(error = null, doneFn = noop) {
    if (typeof error !== "string") {
      error = void 0;
    }
    pushQueue({
      type: "mediaSource",
      sourceUpdater: this,
      action: actions.endOfStream(error),
      name: "endOfStream",
      doneFn
    });
  }
  removeAudio(start, end, done = noop) {
    if (!this.audioBuffered().length || this.audioBuffered().end(0) === 0) {
      done();
      return;
    }
    pushQueue({
      type: "audio",
      sourceUpdater: this,
      action: actions.remove(start, end),
      doneFn: done,
      name: "remove"
    });
  }
  removeVideo(start, end, done = noop) {
    if (!this.videoBuffered().length || this.videoBuffered().end(0) === 0) {
      done();
      return;
    }
    pushQueue({
      type: "video",
      sourceUpdater: this,
      action: actions.remove(start, end),
      doneFn: done,
      name: "remove"
    });
  }
  updating() {
    if (updating("audio", this) || updating("video", this)) {
      return true;
    }
    return false;
  }
  audioTimestampOffset(offset) {
    if (typeof offset !== "undefined" && this.audioBuffer && this.audioTimestampOffset_ !== offset) {
      pushQueue({
        type: "audio",
        sourceUpdater: this,
        action: actions.timestampOffset(offset),
        name: "timestampOffset"
      });
      this.audioTimestampOffset_ = offset;
    }
    return this.audioTimestampOffset_;
  }
  videoTimestampOffset(offset) {
    if (typeof offset !== "undefined" && this.videoBuffer && this.videoTimestampOffset_ !== offset) {
      pushQueue({
        type: "video",
        sourceUpdater: this,
        action: actions.timestampOffset(offset),
        name: "timestampOffset"
      });
      this.videoTimestampOffset_ = offset;
    }
    return this.videoTimestampOffset_;
  }
  audioQueueCallback(callback) {
    if (!this.audioBuffer) {
      return;
    }
    pushQueue({
      type: "audio",
      sourceUpdater: this,
      action: actions.callback(callback),
      name: "callback"
    });
  }
  videoQueueCallback(callback) {
    if (!this.videoBuffer) {
      return;
    }
    pushQueue({
      type: "video",
      sourceUpdater: this,
      action: actions.callback(callback),
      name: "callback"
    });
  }
  dispose() {
    this.trigger("dispose");
    bufferTypes.forEach((type) => {
      this.abort(type);
      if (this.canRemoveSourceBuffer()) {
        this.removeSourceBuffer(type);
      } else {
        this[`${type}QueueCallback`](() => cleanupBuffer(type, this));
      }
    });
    this.videoAppendQueued_ = false;
    this.delayedAudioAppendQueue_.length = 0;
    if (this.sourceopenListener_) {
      this.mediaSource.removeEventListener("sourceopen", this.sourceopenListener_);
    }
    this.off();
  }
}
const uint8ToUtf8 = (uintArray) => decodeURIComponent(escape(String.fromCharCode.apply(null, uintArray)));
const bufferToHexString = (buffer) => {
  const uInt8Buffer = new Uint8Array(buffer);
  return Array.from(uInt8Buffer).map((byte) => byte.toString(16).padStart(2, "0")).join("");
};
const VTT_LINE_TERMINATORS = new Uint8Array("\n\n".split("").map((char) => char.charCodeAt(0)));
class NoVttJsError extends Error {
  constructor() {
    super("Trying to parse received VTT cues, but there is no WebVTT. Make sure vtt.js is loaded.");
  }
}
class VTTSegmentLoader extends SegmentLoader {
  constructor(settings, options = {}) {
    super(settings, options);
    this.mediaSource_ = null;
    this.subtitlesTrack_ = null;
    this.featuresNativeTextTracks_ = settings.featuresNativeTextTracks;
    this.loadVttJs = settings.loadVttJs;
    this.shouldSaveSegmentTimingInfo_ = false;
  }
  buffered_() {
    if (!this.subtitlesTrack_ || !this.subtitlesTrack_.cues || !this.subtitlesTrack_.cues.length) {
      return createTimeRanges();
    }
    const cues = this.subtitlesTrack_.cues;
    const start = cues[0].startTime;
    const end = cues[cues.length - 1].startTime;
    return createTimeRanges([[start, end]]);
  }
  initSegmentForMap(map, set2 = false) {
    if (!map) {
      return null;
    }
    const id = initSegmentId(map);
    let storedMap = this.initSegments_[id];
    if (set2 && !storedMap && map.bytes) {
      const combinedByteLength = VTT_LINE_TERMINATORS.byteLength + map.bytes.byteLength;
      const combinedSegment = new Uint8Array(combinedByteLength);
      combinedSegment.set(map.bytes);
      combinedSegment.set(VTT_LINE_TERMINATORS, map.bytes.byteLength);
      this.initSegments_[id] = storedMap = {
        resolvedUri: map.resolvedUri,
        byterange: map.byterange,
        bytes: combinedSegment
      };
    }
    return storedMap || map;
  }
  couldBeginLoading_() {
    return this.playlist_ && this.subtitlesTrack_ && !this.paused();
  }
  init_() {
    this.state = "READY";
    this.resetEverything();
    return this.monitorBuffer_();
  }
  track(track) {
    if (typeof track === "undefined") {
      return this.subtitlesTrack_;
    }
    this.subtitlesTrack_ = track;
    if (this.state === "INIT" && this.couldBeginLoading_()) {
      this.init_();
    }
    return this.subtitlesTrack_;
  }
  remove(start, end) {
    removeCuesFromTrack(start, end, this.subtitlesTrack_);
  }
  fillBuffer_() {
    const segmentInfo = this.chooseNextRequest_();
    if (!segmentInfo) {
      return;
    }
    if (this.syncController_.timestampOffsetForTimeline(segmentInfo.timeline) === null) {
      const checkTimestampOffset = () => {
        this.state = "READY";
        if (!this.paused()) {
          this.monitorBuffer_();
        }
      };
      this.syncController_.one("timestampoffset", checkTimestampOffset);
      this.state = "WAITING_ON_TIMELINE";
      return;
    }
    this.loadSegment_(segmentInfo);
  }
  timestampOffsetForSegment_() {
    return null;
  }
  chooseNextRequest_() {
    return this.skipEmptySegments_(super.chooseNextRequest_());
  }
  skipEmptySegments_(segmentInfo) {
    while (segmentInfo && segmentInfo.segment.empty) {
      if (segmentInfo.mediaIndex + 1 >= segmentInfo.playlist.segments.length) {
        segmentInfo = null;
        break;
      }
      segmentInfo = this.generateSegmentInfo_({
        playlist: segmentInfo.playlist,
        mediaIndex: segmentInfo.mediaIndex + 1,
        startOfSegment: segmentInfo.startOfSegment + segmentInfo.duration,
        isSyncRequest: segmentInfo.isSyncRequest
      });
    }
    return segmentInfo;
  }
  stopForError(error) {
    this.error(error);
    this.state = "READY";
    this.pause();
    this.trigger("error");
  }
  segmentRequestFinished_(error, simpleSegment, result) {
    if (!this.subtitlesTrack_) {
      this.state = "READY";
      return;
    }
    this.saveTransferStats_(simpleSegment.stats);
    if (!this.pendingSegment_) {
      this.state = "READY";
      this.mediaRequestsAborted += 1;
      return;
    }
    if (error) {
      if (error.code === REQUEST_ERRORS.TIMEOUT) {
        this.handleTimeout_();
      }
      if (error.code === REQUEST_ERRORS.ABORTED) {
        this.mediaRequestsAborted += 1;
      } else {
        this.mediaRequestsErrored += 1;
      }
      this.stopForError(error);
      return;
    }
    const segmentInfo = this.pendingSegment_;
    const isMp4WebVttSegmentWithCues = result.mp4VttCues && result.mp4VttCues.length;
    if (isMp4WebVttSegmentWithCues) {
      segmentInfo.mp4VttCues = result.mp4VttCues;
    }
    this.saveBandwidthRelatedStats_(segmentInfo.duration, simpleSegment.stats);
    if (simpleSegment.key) {
      this.segmentKey(simpleSegment.key, true);
    }
    this.state = "APPENDING";
    this.trigger("appending");
    const segment = segmentInfo.segment;
    if (segment.map) {
      segment.map.bytes = simpleSegment.map.bytes;
    }
    segmentInfo.bytes = simpleSegment.bytes;
    if (typeof window_1.WebVTT !== "function" && typeof this.loadVttJs === "function") {
      this.state = "WAITING_ON_VTTJS";
      this.loadVttJs().then(() => this.segmentRequestFinished_(error, simpleSegment, result), () => this.stopForError({
        message: "Error loading vtt.js"
      }));
      return;
    }
    segment.requested = true;
    try {
      this.parseVTTCues_(segmentInfo);
    } catch (e) {
      this.stopForError({
        message: e.message,
        metadata: {
          errorType: videojs.Error.StreamingVttParserError,
          error: e
        }
      });
      return;
    }
    if (!isMp4WebVttSegmentWithCues) {
      this.updateTimeMapping_(segmentInfo, this.syncController_.timelines[segmentInfo.timeline], this.playlist_);
    }
    if (segmentInfo.cues.length) {
      segmentInfo.timingInfo = {
        start: segmentInfo.cues[0].startTime,
        end: segmentInfo.cues[segmentInfo.cues.length - 1].endTime
      };
    } else {
      segmentInfo.timingInfo = {
        start: segmentInfo.startOfSegment,
        end: segmentInfo.startOfSegment + segmentInfo.duration
      };
    }
    if (segmentInfo.isSyncRequest) {
      this.trigger("syncinfoupdate");
      this.pendingSegment_ = null;
      this.state = "READY";
      return;
    }
    segmentInfo.byteLength = segmentInfo.bytes.byteLength;
    this.mediaSecondsLoaded += segment.duration;
    segmentInfo.cues.forEach((cue) => {
      this.subtitlesTrack_.addCue(this.featuresNativeTextTracks_ ? new window_1.VTTCue(cue.startTime, cue.endTime, cue.text) : cue);
    });
    removeDuplicateCuesFromTrack(this.subtitlesTrack_);
    this.handleAppendsDone_();
  }
  handleData_(simpleSegment, result) {
    const isVttType = simpleSegment && simpleSegment.type === "vtt";
    const isTextResult = result && result.type === "text";
    const isFmp4VttSegment = isVttType && isTextResult;
    if (isFmp4VttSegment) {
      super.handleData_(simpleSegment, result);
    }
  }
  updateTimingInfoEnd_() {
  }
  parseMp4VttCues_(segmentInfo) {
    const timestampOffset = this.sourceUpdater_.videoTimestampOffset() === null ? this.sourceUpdater_.audioTimestampOffset() : this.sourceUpdater_.videoTimestampOffset();
    segmentInfo.mp4VttCues.forEach((cue) => {
      const start = cue.start + timestampOffset;
      const end = cue.end + timestampOffset;
      const vttCue = new window_1.VTTCue(start, end, cue.cueText);
      if (cue.settings) {
        cue.settings.split(" ").forEach((cueSetting) => {
          const keyValString = cueSetting.split(":");
          const key = keyValString[0];
          const value = keyValString[1];
          vttCue[key] = isNaN(value) ? value : Number(value);
        });
      }
      segmentInfo.cues.push(vttCue);
    });
  }
  parseVTTCues_(segmentInfo) {
    let decoder;
    let decodeBytesToString = false;
    if (typeof window_1.WebVTT !== "function") {
      throw new NoVttJsError();
    }
    segmentInfo.cues = [];
    segmentInfo.timestampmap = {
      MPEGTS: 0,
      LOCAL: 0
    };
    if (segmentInfo.mp4VttCues) {
      this.parseMp4VttCues_(segmentInfo);
      return;
    }
    if (typeof window_1.TextDecoder === "function") {
      decoder = new window_1.TextDecoder("utf8");
    } else {
      decoder = window_1.WebVTT.StringDecoder();
      decodeBytesToString = true;
    }
    const parser = new window_1.WebVTT.Parser(window_1, window_1.vttjs, decoder);
    parser.oncue = segmentInfo.cues.push.bind(segmentInfo.cues);
    parser.ontimestampmap = (map) => {
      segmentInfo.timestampmap = map;
    };
    parser.onparsingerror = (error) => {
      videojs.log.warn("Error encountered when parsing cues: " + error.message);
    };
    if (segmentInfo.segment.map) {
      let mapData = segmentInfo.segment.map.bytes;
      if (decodeBytesToString) {
        mapData = uint8ToUtf8(mapData);
      }
      parser.parse(mapData);
    }
    let segmentData = segmentInfo.bytes;
    if (decodeBytesToString) {
      segmentData = uint8ToUtf8(segmentData);
    }
    parser.parse(segmentData);
    parser.flush();
  }
  updateTimeMapping_(segmentInfo, mappingObj, playlist) {
    const segment = segmentInfo.segment;
    if (!mappingObj) {
      return;
    }
    if (!segmentInfo.cues.length) {
      segment.empty = true;
      return;
    }
    const {
      MPEGTS,
      LOCAL
    } = segmentInfo.timestampmap;
    const mpegTsInSeconds = MPEGTS / clock.ONE_SECOND_IN_TS;
    const diff = mpegTsInSeconds - LOCAL + mappingObj.mapping;
    segmentInfo.cues.forEach((cue) => {
      const duration2 = cue.endTime - cue.startTime;
      const startTime = this.handleRollover_(cue.startTime + diff, mappingObj.time);
      cue.startTime = Math.max(startTime, 0);
      cue.endTime = Math.max(startTime + duration2, 0);
    });
    if (!playlist.syncInfo) {
      const firstStart = segmentInfo.cues[0].startTime;
      const lastStart = segmentInfo.cues[segmentInfo.cues.length - 1].startTime;
      playlist.syncInfo = {
        mediaSequence: playlist.mediaSequence + segmentInfo.mediaIndex,
        time: Math.min(firstStart, lastStart - segment.duration)
      };
    }
  }
  handleRollover_(value, reference) {
    if (reference === null) {
      return value;
    }
    let valueIn90khz = value * clock.ONE_SECOND_IN_TS;
    const referenceIn90khz = reference * clock.ONE_SECOND_IN_TS;
    let offset;
    if (referenceIn90khz < valueIn90khz) {
      offset = -8589934592;
    } else {
      offset = 8589934592;
    }
    while (Math.abs(valueIn90khz - referenceIn90khz) > 4294967296) {
      valueIn90khz += offset;
    }
    return valueIn90khz / clock.ONE_SECOND_IN_TS;
  }
}
const findAdCue = function(track, mediaTime) {
  const cues = track.cues;
  for (let i = 0; i < cues.length; i++) {
    const cue = cues[i];
    if (mediaTime >= cue.adStartTime && mediaTime <= cue.adEndTime) {
      return cue;
    }
  }
  return null;
};
const updateAdCues = function(media, track, offset = 0) {
  if (!media.segments) {
    return;
  }
  let mediaTime = offset;
  let cue;
  for (let i = 0; i < media.segments.length; i++) {
    const segment = media.segments[i];
    if (!cue) {
      cue = findAdCue(track, mediaTime + segment.duration / 2);
    }
    if (cue) {
      if ("cueIn" in segment) {
        cue.endTime = mediaTime;
        cue.adEndTime = mediaTime;
        mediaTime += segment.duration;
        cue = null;
        continue;
      }
      if (mediaTime < cue.endTime) {
        mediaTime += segment.duration;
        continue;
      }
      cue.endTime += segment.duration;
    } else {
      if ("cueOut" in segment) {
        cue = new window_1.VTTCue(mediaTime, mediaTime + segment.duration, segment.cueOut);
        cue.adStartTime = mediaTime;
        cue.adEndTime = mediaTime + parseFloat(segment.cueOut);
        track.addCue(cue);
      }
      if ("cueOutCont" in segment) {
        const [adOffset, adTotal] = segment.cueOutCont.split("/").map(parseFloat);
        cue = new window_1.VTTCue(mediaTime, mediaTime + segment.duration, "");
        cue.adStartTime = mediaTime - adOffset;
        cue.adEndTime = cue.adStartTime + adTotal;
        track.addCue(cue);
      }
    }
    mediaTime += segment.duration;
  }
};
class SyncInfo {
  constructor({
    start,
    end,
    segmentIndex,
    partIndex = null,
    appended = false
  }) {
    this.start_ = start;
    this.end_ = end;
    this.segmentIndex_ = segmentIndex;
    this.partIndex_ = partIndex;
    this.appended_ = appended;
  }
  isInRange(targetTime) {
    return targetTime >= this.start && targetTime < this.end;
  }
  markAppended() {
    this.appended_ = true;
  }
  resetAppendedStatus() {
    this.appended_ = false;
  }
  get isAppended() {
    return this.appended_;
  }
  get start() {
    return this.start_;
  }
  get end() {
    return this.end_;
  }
  get segmentIndex() {
    return this.segmentIndex_;
  }
  get partIndex() {
    return this.partIndex_;
  }
}
class SyncInfoData {
  constructor(segmentSyncInfo, partsSyncInfo = []) {
    this.segmentSyncInfo_ = segmentSyncInfo;
    this.partsSyncInfo_ = partsSyncInfo;
  }
  get segmentSyncInfo() {
    return this.segmentSyncInfo_;
  }
  get partsSyncInfo() {
    return this.partsSyncInfo_;
  }
  get hasPartsSyncInfo() {
    return this.partsSyncInfo_.length > 0;
  }
  resetAppendStatus() {
    this.segmentSyncInfo_.resetAppendedStatus();
    this.partsSyncInfo_.forEach((partSyncInfo) => partSyncInfo.resetAppendedStatus());
  }
}
class MediaSequenceSync {
  constructor() {
    this.storage_ = /* @__PURE__ */ new Map();
    this.diagnostics_ = "";
    this.isReliable_ = false;
    this.start_ = -Infinity;
    this.end_ = Infinity;
  }
  get start() {
    return this.start_;
  }
  get end() {
    return this.end_;
  }
  get diagnostics() {
    return this.diagnostics_;
  }
  get isReliable() {
    return this.isReliable_;
  }
  resetAppendedStatus() {
    this.storage_.forEach((syncInfoData) => syncInfoData.resetAppendStatus());
  }
  update(playlist, currentTime) {
    const {
      mediaSequence,
      segments
    } = playlist;
    this.isReliable_ = this.isReliablePlaylist_(mediaSequence, segments);
    if (!this.isReliable_) {
      return;
    }
    return this.updateStorage_(segments, mediaSequence, this.calculateBaseTime_(mediaSequence, segments, currentTime));
  }
  getSyncInfoForTime(targetTime) {
    for (const {
      segmentSyncInfo,
      partsSyncInfo
    } of this.storage_.values()) {
      if (!partsSyncInfo.length) {
        if (segmentSyncInfo.isInRange(targetTime)) {
          return segmentSyncInfo;
        }
      } else {
        for (const partSyncInfo of partsSyncInfo) {
          if (partSyncInfo.isInRange(targetTime)) {
            return partSyncInfo;
          }
        }
      }
    }
    return null;
  }
  getSyncInfoForMediaSequence(mediaSequence) {
    return this.storage_.get(mediaSequence);
  }
  updateStorage_(segments, startingMediaSequence, startingTime) {
    const newStorage = /* @__PURE__ */ new Map();
    let newDiagnostics = "\n";
    let currentStart = startingTime;
    let currentMediaSequence = startingMediaSequence;
    this.start_ = currentStart;
    segments.forEach((segment, segmentIndex) => {
      const prevSyncInfoData = this.storage_.get(currentMediaSequence);
      const segmentStart = currentStart;
      const segmentEnd = segmentStart + segment.duration;
      const segmentIsAppended = Boolean(prevSyncInfoData && prevSyncInfoData.segmentSyncInfo && prevSyncInfoData.segmentSyncInfo.isAppended);
      const segmentSyncInfo = new SyncInfo({
        start: segmentStart,
        end: segmentEnd,
        appended: segmentIsAppended,
        segmentIndex
      });
      segment.syncInfo = segmentSyncInfo;
      let currentPartStart = currentStart;
      const partsSyncInfo = (segment.parts || []).map((part, partIndex) => {
        const partStart = currentPartStart;
        const partEnd = currentPartStart + part.duration;
        const partIsAppended = Boolean(prevSyncInfoData && prevSyncInfoData.partsSyncInfo && prevSyncInfoData.partsSyncInfo[partIndex] && prevSyncInfoData.partsSyncInfo[partIndex].isAppended);
        const partSyncInfo = new SyncInfo({
          start: partStart,
          end: partEnd,
          appended: partIsAppended,
          segmentIndex,
          partIndex
        });
        currentPartStart = partEnd;
        newDiagnostics += `Media Sequence: ${currentMediaSequence}.${partIndex} | Range: ${partStart} --> ${partEnd} | Appended: ${partIsAppended}
`;
        part.syncInfo = partSyncInfo;
        return partSyncInfo;
      });
      newStorage.set(currentMediaSequence, new SyncInfoData(segmentSyncInfo, partsSyncInfo));
      newDiagnostics += `${compactSegmentUrlDescription(segment.resolvedUri)} | Media Sequence: ${currentMediaSequence} | Range: ${segmentStart} --> ${segmentEnd} | Appended: ${segmentIsAppended}
`;
      currentMediaSequence++;
      currentStart = segmentEnd;
    });
    this.end_ = currentStart;
    this.storage_ = newStorage;
    this.diagnostics_ = newDiagnostics;
  }
  calculateBaseTime_(mediaSequence, segments, fallback) {
    if (!this.storage_.size) {
      return 0;
    }
    if (this.storage_.has(mediaSequence)) {
      return this.storage_.get(mediaSequence).segmentSyncInfo.start;
    }
    const minMediaSequenceFromStorage = Math.min(...this.storage_.keys());
    if (mediaSequence < minMediaSequenceFromStorage) {
      const mediaSequenceDiff = minMediaSequenceFromStorage - mediaSequence;
      let baseTime = this.storage_.get(minMediaSequenceFromStorage).segmentSyncInfo.start;
      for (let i = 0; i < mediaSequenceDiff; i++) {
        const segment = segments[i];
        baseTime -= segment.duration;
      }
      return baseTime;
    }
    return fallback;
  }
  isReliablePlaylist_(mediaSequence, segments) {
    return mediaSequence !== void 0 && mediaSequence !== null && Array.isArray(segments) && segments.length;
  }
}
class DependantMediaSequenceSync extends MediaSequenceSync {
  constructor(parent) {
    super();
    this.parent_ = parent;
  }
  calculateBaseTime_(mediaSequence, segments, fallback) {
    if (!this.storage_.size) {
      const info = this.parent_.getSyncInfoForMediaSequence(mediaSequence);
      if (info) {
        return info.segmentSyncInfo.start;
      }
      return 0;
    }
    return super.calculateBaseTime_(mediaSequence, segments, fallback);
  }
}
const MAX_MEDIA_SEQUENCE_DIFF_FOR_SYNC = 86400;
const syncPointStrategies = [
  {
    name: "VOD",
    run: (syncController, playlist, duration2, currentTimeline, currentTime) => {
      if (duration2 !== Infinity) {
        const syncPoint = {
          time: 0,
          segmentIndex: 0,
          partIndex: null
        };
        return syncPoint;
      }
      return null;
    }
  },
  {
    name: "MediaSequence",
    run: (syncController, playlist, duration2, currentTimeline, currentTime, type) => {
      const mediaSequenceSync = syncController.getMediaSequenceSync(type);
      if (!mediaSequenceSync) {
        return null;
      }
      if (!mediaSequenceSync.isReliable) {
        return null;
      }
      const syncInfo = mediaSequenceSync.getSyncInfoForTime(currentTime);
      if (!syncInfo) {
        return null;
      }
      return {
        time: syncInfo.start,
        partIndex: syncInfo.partIndex,
        segmentIndex: syncInfo.segmentIndex
      };
    }
  },
  {
    name: "ProgramDateTime",
    run: (syncController, playlist, duration2, currentTimeline, currentTime) => {
      if (!Object.keys(syncController.timelineToDatetimeMappings).length) {
        return null;
      }
      let syncPoint = null;
      let lastDistance = null;
      const partsAndSegments = getPartsAndSegments(playlist);
      currentTime = currentTime || 0;
      for (let i = 0; i < partsAndSegments.length; i++) {
        const index = playlist.endList || currentTime === 0 ? i : partsAndSegments.length - (i + 1);
        const partAndSegment = partsAndSegments[index];
        const segment = partAndSegment.segment;
        const datetimeMapping = syncController.timelineToDatetimeMappings[segment.timeline];
        if (!datetimeMapping || !segment.dateTimeObject) {
          continue;
        }
        const segmentTime = segment.dateTimeObject.getTime() / 1e3;
        let start = segmentTime + datetimeMapping;
        if (segment.parts && typeof partAndSegment.partIndex === "number") {
          for (let z = 0; z < partAndSegment.partIndex; z++) {
            start += segment.parts[z].duration;
          }
        }
        const distance = Math.abs(currentTime - start);
        if (lastDistance !== null && (distance === 0 || lastDistance < distance)) {
          break;
        }
        lastDistance = distance;
        syncPoint = {
          time: start,
          segmentIndex: partAndSegment.segmentIndex,
          partIndex: partAndSegment.partIndex
        };
      }
      return syncPoint;
    }
  },
  {
    name: "Segment",
    run: (syncController, playlist, duration2, currentTimeline, currentTime) => {
      let syncPoint = null;
      let lastDistance = null;
      currentTime = currentTime || 0;
      const partsAndSegments = getPartsAndSegments(playlist);
      for (let i = 0; i < partsAndSegments.length; i++) {
        const index = playlist.endList || currentTime === 0 ? i : partsAndSegments.length - (i + 1);
        const partAndSegment = partsAndSegments[index];
        const segment = partAndSegment.segment;
        const start = partAndSegment.part && partAndSegment.part.start || segment && segment.start;
        if (segment.timeline === currentTimeline && typeof start !== "undefined") {
          const distance = Math.abs(currentTime - start);
          if (lastDistance !== null && lastDistance < distance) {
            break;
          }
          if (!syncPoint || lastDistance === null || lastDistance >= distance) {
            lastDistance = distance;
            syncPoint = {
              time: start,
              segmentIndex: partAndSegment.segmentIndex,
              partIndex: partAndSegment.partIndex
            };
          }
        }
      }
      return syncPoint;
    }
  },
  {
    name: "Discontinuity",
    run: (syncController, playlist, duration2, currentTimeline, currentTime) => {
      let syncPoint = null;
      currentTime = currentTime || 0;
      if (playlist.discontinuityStarts && playlist.discontinuityStarts.length) {
        let lastDistance = null;
        for (let i = 0; i < playlist.discontinuityStarts.length; i++) {
          const segmentIndex = playlist.discontinuityStarts[i];
          const discontinuity = playlist.discontinuitySequence + i + 1;
          const discontinuitySync = syncController.discontinuities[discontinuity];
          if (discontinuitySync) {
            const distance = Math.abs(currentTime - discontinuitySync.time);
            if (lastDistance !== null && lastDistance < distance) {
              break;
            }
            if (!syncPoint || lastDistance === null || lastDistance >= distance) {
              lastDistance = distance;
              syncPoint = {
                time: discontinuitySync.time,
                segmentIndex,
                partIndex: null
              };
            }
          }
        }
      }
      return syncPoint;
    }
  },
  {
    name: "Playlist",
    run: (syncController, playlist, duration2, currentTimeline, currentTime) => {
      if (playlist.syncInfo) {
        const syncPoint = {
          time: playlist.syncInfo.time,
          segmentIndex: playlist.syncInfo.mediaSequence - playlist.mediaSequence,
          partIndex: null
        };
        return syncPoint;
      }
      return null;
    }
  }
];
class SyncController extends videojs.EventTarget {
  constructor(options = {}) {
    super();
    this.timelines = [];
    this.discontinuities = [];
    this.timelineToDatetimeMappings = {};
    const main = new MediaSequenceSync();
    const audio = new DependantMediaSequenceSync(main);
    const vtt = new DependantMediaSequenceSync(main);
    this.mediaSequenceStorage_ = {
      main,
      audio,
      vtt
    };
    this.logger_ = logger("SyncController");
  }
  getMediaSequenceSync(loaderType) {
    return this.mediaSequenceStorage_[loaderType] || null;
  }
  getSyncPoint(playlist, duration2, currentTimeline, currentTime, type) {
    if (duration2 !== Infinity) {
      const vodSyncPointStrategy = syncPointStrategies.find(({
        name
      }) => name === "VOD");
      return vodSyncPointStrategy.run(this, playlist, duration2);
    }
    const syncPoints = this.runStrategies_(playlist, duration2, currentTimeline, currentTime, type);
    if (!syncPoints.length) {
      return null;
    }
    for (const syncPointInfo of syncPoints) {
      const {
        syncPoint,
        strategy
      } = syncPointInfo;
      const {
        segmentIndex,
        time
      } = syncPoint;
      if (segmentIndex < 0) {
        continue;
      }
      const selectedSegment = playlist.segments[segmentIndex];
      const start = time;
      const end = start + selectedSegment.duration;
      this.logger_(`Strategy: ${strategy}. Current time: ${currentTime}. selected segment: ${segmentIndex}. Time: [${start} -> ${end}]}`);
      if (currentTime >= start && currentTime < end) {
        this.logger_("Found sync point with exact match: ", syncPoint);
        return syncPoint;
      }
    }
    return this.selectSyncPoint_(syncPoints, {
      key: "time",
      value: currentTime
    });
  }
  getExpiredTime(playlist, duration2) {
    if (!playlist || !playlist.segments) {
      return null;
    }
    const syncPoints = this.runStrategies_(playlist, duration2, playlist.discontinuitySequence, 0);
    if (!syncPoints.length) {
      return null;
    }
    const syncPoint = this.selectSyncPoint_(syncPoints, {
      key: "segmentIndex",
      value: 0
    });
    if (syncPoint.segmentIndex > 0) {
      syncPoint.time *= -1;
    }
    return Math.abs(syncPoint.time + sumDurations({
      defaultDuration: playlist.targetDuration,
      durationList: playlist.segments,
      startIndex: syncPoint.segmentIndex,
      endIndex: 0
    }));
  }
  runStrategies_(playlist, duration2, currentTimeline, currentTime, type) {
    const syncPoints = [];
    for (let i = 0; i < syncPointStrategies.length; i++) {
      const strategy = syncPointStrategies[i];
      const syncPoint = strategy.run(this, playlist, duration2, currentTimeline, currentTime, type);
      if (syncPoint) {
        syncPoint.strategy = strategy.name;
        syncPoints.push({
          strategy: strategy.name,
          syncPoint
        });
      }
    }
    return syncPoints;
  }
  selectSyncPoint_(syncPoints, target) {
    let bestSyncPoint = syncPoints[0].syncPoint;
    let bestDistance = Math.abs(syncPoints[0].syncPoint[target.key] - target.value);
    let bestStrategy = syncPoints[0].strategy;
    for (let i = 1; i < syncPoints.length; i++) {
      const newDistance = Math.abs(syncPoints[i].syncPoint[target.key] - target.value);
      if (newDistance < bestDistance) {
        bestDistance = newDistance;
        bestSyncPoint = syncPoints[i].syncPoint;
        bestStrategy = syncPoints[i].strategy;
      }
    }
    this.logger_(`syncPoint for [${target.key}: ${target.value}] chosen with strategy [${bestStrategy}]: [time:${bestSyncPoint.time}, segmentIndex:${bestSyncPoint.segmentIndex}` + (typeof bestSyncPoint.partIndex === "number" ? `,partIndex:${bestSyncPoint.partIndex}` : "") + "]");
    return bestSyncPoint;
  }
  saveExpiredSegmentInfo(oldPlaylist, newPlaylist) {
    const mediaSequenceDiff = newPlaylist.mediaSequence - oldPlaylist.mediaSequence;
    if (mediaSequenceDiff > MAX_MEDIA_SEQUENCE_DIFF_FOR_SYNC) {
      videojs.log.warn(`Not saving expired segment info. Media sequence gap ${mediaSequenceDiff} is too large.`);
      return;
    }
    for (let i = mediaSequenceDiff - 1; i >= 0; i--) {
      const lastRemovedSegment = oldPlaylist.segments[i];
      if (lastRemovedSegment && typeof lastRemovedSegment.start !== "undefined") {
        newPlaylist.syncInfo = {
          mediaSequence: oldPlaylist.mediaSequence + i,
          time: lastRemovedSegment.start
        };
        this.logger_(`playlist refresh sync: [time:${newPlaylist.syncInfo.time}, mediaSequence: ${newPlaylist.syncInfo.mediaSequence}]`);
        this.trigger("syncinfoupdate");
        break;
      }
    }
  }
  setDateTimeMappingForStart(playlist) {
    this.timelineToDatetimeMappings = {};
    if (playlist.segments && playlist.segments.length && playlist.segments[0].dateTimeObject) {
      const firstSegment = playlist.segments[0];
      const playlistTimestamp = firstSegment.dateTimeObject.getTime() / 1e3;
      this.timelineToDatetimeMappings[firstSegment.timeline] = -playlistTimestamp;
    }
  }
  saveSegmentTimingInfo({
    segmentInfo,
    shouldSaveTimelineMapping
  }) {
    const didCalculateSegmentTimeMapping = this.calculateSegmentTimeMapping_(segmentInfo, segmentInfo.timingInfo, shouldSaveTimelineMapping);
    const segment = segmentInfo.segment;
    if (didCalculateSegmentTimeMapping) {
      this.saveDiscontinuitySyncInfo_(segmentInfo);
      if (!segmentInfo.playlist.syncInfo) {
        segmentInfo.playlist.syncInfo = {
          mediaSequence: segmentInfo.playlist.mediaSequence + segmentInfo.mediaIndex,
          time: segment.start
        };
      }
    }
    const dateTime = segment.dateTimeObject;
    if (segment.discontinuity && shouldSaveTimelineMapping && dateTime) {
      this.timelineToDatetimeMappings[segment.timeline] = -(dateTime.getTime() / 1e3);
    }
  }
  timestampOffsetForTimeline(timeline) {
    if (typeof this.timelines[timeline] === "undefined") {
      return null;
    }
    return this.timelines[timeline].time;
  }
  mappingForTimeline(timeline) {
    if (typeof this.timelines[timeline] === "undefined") {
      return null;
    }
    return this.timelines[timeline].mapping;
  }
  calculateSegmentTimeMapping_(segmentInfo, timingInfo, shouldSaveTimelineMapping) {
    const segment = segmentInfo.segment;
    const part = segmentInfo.part;
    let mappingObj = this.timelines[segmentInfo.timeline];
    let start;
    let end;
    if (typeof segmentInfo.timestampOffset === "number") {
      mappingObj = {
        time: segmentInfo.startOfSegment,
        mapping: segmentInfo.startOfSegment - timingInfo.start
      };
      if (shouldSaveTimelineMapping) {
        this.timelines[segmentInfo.timeline] = mappingObj;
        this.trigger("timestampoffset");
        this.logger_(`time mapping for timeline ${segmentInfo.timeline}: [time: ${mappingObj.time}] [mapping: ${mappingObj.mapping}]`);
      }
      start = segmentInfo.startOfSegment;
      end = timingInfo.end + mappingObj.mapping;
    } else if (mappingObj) {
      start = timingInfo.start + mappingObj.mapping;
      end = timingInfo.end + mappingObj.mapping;
    } else {
      return false;
    }
    if (part) {
      part.start = start;
      part.end = end;
    }
    if (!segment.start || start < segment.start) {
      segment.start = start;
    }
    segment.end = end;
    return true;
  }
  saveDiscontinuitySyncInfo_(segmentInfo) {
    const playlist = segmentInfo.playlist;
    const segment = segmentInfo.segment;
    if (segment.discontinuity) {
      this.discontinuities[segment.timeline] = {
        time: segment.start,
        accuracy: 0
      };
    } else if (playlist.discontinuityStarts && playlist.discontinuityStarts.length) {
      for (let i = 0; i < playlist.discontinuityStarts.length; i++) {
        const segmentIndex = playlist.discontinuityStarts[i];
        const discontinuity = playlist.discontinuitySequence + i + 1;
        const mediaIndexDiff = segmentIndex - segmentInfo.mediaIndex;
        const accuracy = Math.abs(mediaIndexDiff);
        if (!this.discontinuities[discontinuity] || this.discontinuities[discontinuity].accuracy > accuracy) {
          let time;
          if (mediaIndexDiff < 0) {
            time = segment.start - sumDurations({
              defaultDuration: playlist.targetDuration,
              durationList: playlist.segments,
              startIndex: segmentInfo.mediaIndex,
              endIndex: segmentIndex
            });
          } else {
            time = segment.end + sumDurations({
              defaultDuration: playlist.targetDuration,
              durationList: playlist.segments,
              startIndex: segmentInfo.mediaIndex + 1,
              endIndex: segmentIndex
            });
          }
          this.discontinuities[discontinuity] = {
            time,
            accuracy
          };
        }
      }
    }
  }
  dispose() {
    this.trigger("dispose");
    this.off();
  }
}
class TimelineChangeController extends videojs.EventTarget {
  constructor() {
    super();
    this.pendingTimelineChanges_ = {};
    this.lastTimelineChanges_ = {};
  }
  clearPendingTimelineChange(type) {
    this.pendingTimelineChanges_[type] = null;
    this.trigger("pendingtimelinechange");
  }
  pendingTimelineChange({
    type,
    from,
    to
  }) {
    if (typeof from === "number" && typeof to === "number") {
      this.pendingTimelineChanges_[type] = {
        type,
        from,
        to
      };
      this.trigger("pendingtimelinechange");
    }
    return this.pendingTimelineChanges_[type];
  }
  lastTimelineChange({
    type,
    from,
    to
  }) {
    if (typeof from === "number" && typeof to === "number") {
      this.lastTimelineChanges_[type] = {
        type,
        from,
        to
      };
      delete this.pendingTimelineChanges_[type];
      const metadata = {
        timelineChangeInfo: {
          from,
          to
        }
      };
      this.trigger({
        type: "timelinechange",
        metadata
      });
    }
    return this.lastTimelineChanges_[type];
  }
  dispose() {
    this.trigger("dispose");
    this.pendingTimelineChanges_ = {};
    this.lastTimelineChanges_ = {};
    this.off();
  }
}
const workerCode = transform(getWorkerString(function() {
  var Stream = /* @__PURE__ */ function() {
    function Stream2() {
      this.listeners = {};
    }
    var _proto = Stream2.prototype;
    _proto.on = function on2(type, listener) {
      if (!this.listeners[type]) {
        this.listeners[type] = [];
      }
      this.listeners[type].push(listener);
    };
    _proto.off = function off2(type, listener) {
      if (!this.listeners[type]) {
        return false;
      }
      var index = this.listeners[type].indexOf(listener);
      this.listeners[type] = this.listeners[type].slice(0);
      this.listeners[type].splice(index, 1);
      return index > -1;
    };
    _proto.trigger = function trigger2(type) {
      var callbacks = this.listeners[type];
      if (!callbacks) {
        return;
      }
      if (arguments.length === 2) {
        var length = callbacks.length;
        for (var i = 0; i < length; ++i) {
          callbacks[i].call(this, arguments[1]);
        }
      } else {
        var args = Array.prototype.slice.call(arguments, 1);
        var _length = callbacks.length;
        for (var _i = 0; _i < _length; ++_i) {
          callbacks[_i].apply(this, args);
        }
      }
    };
    _proto.dispose = function dispose() {
      this.listeners = {};
    };
    _proto.pipe = function pipe(destination) {
      this.on("data", function(data) {
        destination.push(data);
      });
    };
    return Stream2;
  }();
  /*! @name pkcs7 @version 1.0.4 @license Apache-2.0 */
  function unpad(padded) {
    return padded.subarray(0, padded.byteLength - padded[padded.byteLength - 1]);
  }
  /*! @name aes-decrypter @version 4.0.2 @license Apache-2.0 */
  const precompute = function() {
    const tables = [[[], [], [], [], []], [[], [], [], [], []]];
    const encTable = tables[0];
    const decTable = tables[1];
    const sbox = encTable[4];
    const sboxInv = decTable[4];
    let i;
    let x;
    let xInv;
    const d = [];
    const th = [];
    let x2;
    let x4;
    let x8;
    let s;
    let tEnc;
    let tDec;
    for (i = 0; i < 256; i++) {
      th[(d[i] = i << 1 ^ (i >> 7) * 283) ^ i] = i;
    }
    for (x = xInv = 0; !sbox[x]; x ^= x2 || 1, xInv = th[xInv] || 1) {
      s = xInv ^ xInv << 1 ^ xInv << 2 ^ xInv << 3 ^ xInv << 4;
      s = s >> 8 ^ s & 255 ^ 99;
      sbox[x] = s;
      sboxInv[s] = x;
      x8 = d[x4 = d[x2 = d[x]]];
      tDec = x8 * 16843009 ^ x4 * 65537 ^ x2 * 257 ^ x * 16843008;
      tEnc = d[s] * 257 ^ s * 16843008;
      for (i = 0; i < 4; i++) {
        encTable[i][x] = tEnc = tEnc << 24 ^ tEnc >>> 8;
        decTable[i][s] = tDec = tDec << 24 ^ tDec >>> 8;
      }
    }
    for (i = 0; i < 5; i++) {
      encTable[i] = encTable[i].slice(0);
      decTable[i] = decTable[i].slice(0);
    }
    return tables;
  };
  let aesTables = null;
  class AES {
    constructor(key) {
      if (!aesTables) {
        aesTables = precompute();
      }
      this._tables = [[aesTables[0][0].slice(), aesTables[0][1].slice(), aesTables[0][2].slice(), aesTables[0][3].slice(), aesTables[0][4].slice()], [aesTables[1][0].slice(), aesTables[1][1].slice(), aesTables[1][2].slice(), aesTables[1][3].slice(), aesTables[1][4].slice()]];
      let i;
      let j;
      let tmp;
      const sbox = this._tables[0][4];
      const decTable = this._tables[1];
      const keyLen = key.length;
      let rcon = 1;
      if (keyLen !== 4 && keyLen !== 6 && keyLen !== 8) {
        throw new Error("Invalid aes key size");
      }
      const encKey = key.slice(0);
      const decKey = [];
      this._key = [encKey, decKey];
      for (i = keyLen; i < 4 * keyLen + 28; i++) {
        tmp = encKey[i - 1];
        if (i % keyLen === 0 || keyLen === 8 && i % keyLen === 4) {
          tmp = sbox[tmp >>> 24] << 24 ^ sbox[tmp >> 16 & 255] << 16 ^ sbox[tmp >> 8 & 255] << 8 ^ sbox[tmp & 255];
          if (i % keyLen === 0) {
            tmp = tmp << 8 ^ tmp >>> 24 ^ rcon << 24;
            rcon = rcon << 1 ^ (rcon >> 7) * 283;
          }
        }
        encKey[i] = encKey[i - keyLen] ^ tmp;
      }
      for (j = 0; i; j++, i--) {
        tmp = encKey[j & 3 ? i : i - 4];
        if (i <= 4 || j < 4) {
          decKey[j] = tmp;
        } else {
          decKey[j] = decTable[0][sbox[tmp >>> 24]] ^ decTable[1][sbox[tmp >> 16 & 255]] ^ decTable[2][sbox[tmp >> 8 & 255]] ^ decTable[3][sbox[tmp & 255]];
        }
      }
    }
    decrypt(encrypted0, encrypted1, encrypted2, encrypted3, out, offset) {
      const key = this._key[1];
      let a = encrypted0 ^ key[0];
      let b = encrypted3 ^ key[1];
      let c = encrypted2 ^ key[2];
      let d = encrypted1 ^ key[3];
      let a2;
      let b2;
      let c2;
      const nInnerRounds = key.length / 4 - 2;
      let i;
      let kIndex = 4;
      const table = this._tables[1];
      const table0 = table[0];
      const table1 = table[1];
      const table2 = table[2];
      const table3 = table[3];
      const sbox = table[4];
      for (i = 0; i < nInnerRounds; i++) {
        a2 = table0[a >>> 24] ^ table1[b >> 16 & 255] ^ table2[c >> 8 & 255] ^ table3[d & 255] ^ key[kIndex];
        b2 = table0[b >>> 24] ^ table1[c >> 16 & 255] ^ table2[d >> 8 & 255] ^ table3[a & 255] ^ key[kIndex + 1];
        c2 = table0[c >>> 24] ^ table1[d >> 16 & 255] ^ table2[a >> 8 & 255] ^ table3[b & 255] ^ key[kIndex + 2];
        d = table0[d >>> 24] ^ table1[a >> 16 & 255] ^ table2[b >> 8 & 255] ^ table3[c & 255] ^ key[kIndex + 3];
        kIndex += 4;
        a = a2;
        b = b2;
        c = c2;
      }
      for (i = 0; i < 4; i++) {
        out[(3 & -i) + offset] = sbox[a >>> 24] << 24 ^ sbox[b >> 16 & 255] << 16 ^ sbox[c >> 8 & 255] << 8 ^ sbox[d & 255] ^ key[kIndex++];
        a2 = a;
        a = b;
        b = c;
        c = d;
        d = a2;
      }
    }
  }
  class AsyncStream extends Stream {
    constructor() {
      super(Stream);
      this.jobs = [];
      this.delay = 1;
      this.timeout_ = null;
    }
    processJob_() {
      this.jobs.shift()();
      if (this.jobs.length) {
        this.timeout_ = setTimeout(this.processJob_.bind(this), this.delay);
      } else {
        this.timeout_ = null;
      }
    }
    push(job) {
      this.jobs.push(job);
      if (!this.timeout_) {
        this.timeout_ = setTimeout(this.processJob_.bind(this), this.delay);
      }
    }
  }
  const ntoh = function(word) {
    return word << 24 | (word & 65280) << 8 | (word & 16711680) >> 8 | word >>> 24;
  };
  const decrypt2 = function(encrypted, key, initVector) {
    const encrypted32 = new Int32Array(encrypted.buffer, encrypted.byteOffset, encrypted.byteLength >> 2);
    const decipher = new AES(Array.prototype.slice.call(key));
    const decrypted = new Uint8Array(encrypted.byteLength);
    const decrypted32 = new Int32Array(decrypted.buffer);
    let init0;
    let init1;
    let init2;
    let init3;
    let encrypted0;
    let encrypted1;
    let encrypted2;
    let encrypted3;
    let wordIx;
    init0 = initVector[0];
    init1 = initVector[1];
    init2 = initVector[2];
    init3 = initVector[3];
    for (wordIx = 0; wordIx < encrypted32.length; wordIx += 4) {
      encrypted0 = ntoh(encrypted32[wordIx]);
      encrypted1 = ntoh(encrypted32[wordIx + 1]);
      encrypted2 = ntoh(encrypted32[wordIx + 2]);
      encrypted3 = ntoh(encrypted32[wordIx + 3]);
      decipher.decrypt(encrypted0, encrypted1, encrypted2, encrypted3, decrypted32, wordIx);
      decrypted32[wordIx] = ntoh(decrypted32[wordIx] ^ init0);
      decrypted32[wordIx + 1] = ntoh(decrypted32[wordIx + 1] ^ init1);
      decrypted32[wordIx + 2] = ntoh(decrypted32[wordIx + 2] ^ init2);
      decrypted32[wordIx + 3] = ntoh(decrypted32[wordIx + 3] ^ init3);
      init0 = encrypted0;
      init1 = encrypted1;
      init2 = encrypted2;
      init3 = encrypted3;
    }
    return decrypted;
  };
  class Decrypter2 {
    constructor(encrypted, key, initVector, done) {
      const step = Decrypter2.STEP;
      const encrypted32 = new Int32Array(encrypted.buffer);
      const decrypted = new Uint8Array(encrypted.byteLength);
      let i = 0;
      this.asyncStream_ = new AsyncStream();
      this.asyncStream_.push(this.decryptChunk_(encrypted32.subarray(i, i + step), key, initVector, decrypted));
      for (i = step; i < encrypted32.length; i += step) {
        initVector = new Uint32Array([ntoh(encrypted32[i - 4]), ntoh(encrypted32[i - 3]), ntoh(encrypted32[i - 2]), ntoh(encrypted32[i - 1])]);
        this.asyncStream_.push(this.decryptChunk_(encrypted32.subarray(i, i + step), key, initVector, decrypted));
      }
      this.asyncStream_.push(function() {
        done(null, unpad(decrypted));
      });
    }
    static get STEP() {
      return 32e3;
    }
    decryptChunk_(encrypted, key, initVector, decrypted) {
      return function() {
        const bytes = decrypt2(encrypted, key, initVector);
        decrypted.set(bytes, encrypted.byteOffset);
      };
    }
  }
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  var win;
  if (typeof window !== "undefined") {
    win = window;
  } else if (typeof commonjsGlobal !== "undefined") {
    win = commonjsGlobal;
  } else if (typeof self !== "undefined") {
    win = self;
  } else {
    win = {};
  }
  var window_12 = win;
  var isArrayBufferView2 = function isArrayBufferView3(obj) {
    if (ArrayBuffer.isView === "function") {
      return ArrayBuffer.isView(obj);
    }
    return obj && obj.buffer instanceof ArrayBuffer;
  };
  var BigInt = window_12.BigInt || Number;
  [BigInt("0x1"), BigInt("0x100"), BigInt("0x10000"), BigInt("0x1000000"), BigInt("0x100000000"), BigInt("0x10000000000"), BigInt("0x1000000000000"), BigInt("0x100000000000000"), BigInt("0x10000000000000000")];
  (function() {
    var a = new Uint16Array([65484]);
    var b = new Uint8Array(a.buffer, a.byteOffset, a.byteLength);
    if (b[0] === 255) {
      return "big";
    }
    if (b[0] === 204) {
      return "little";
    }
    return "unknown";
  })();
  const createTransferableMessage2 = function(message) {
    const transferable = {};
    Object.keys(message).forEach((key) => {
      const value = message[key];
      if (isArrayBufferView2(value)) {
        transferable[key] = {
          bytes: value.buffer,
          byteOffset: value.byteOffset,
          byteLength: value.byteLength
        };
      } else {
        transferable[key] = value;
      }
    });
    return transferable;
  };
  self.onmessage = function(event) {
    const data = event.data;
    const encrypted = new Uint8Array(data.encrypted.bytes, data.encrypted.byteOffset, data.encrypted.byteLength);
    const key = new Uint32Array(data.key.bytes, data.key.byteOffset, data.key.byteLength / 4);
    const iv = new Uint32Array(data.iv.bytes, data.iv.byteOffset, data.iv.byteLength / 4);
    new Decrypter2(encrypted, key, iv, function(err, bytes) {
      self.postMessage(createTransferableMessage2({
        source: data.source,
        decrypted: bytes
      }), [bytes.buffer]);
    });
  };
}));
var Decrypter = factory(workerCode);
const audioTrackKind_ = (properties) => {
  let kind = properties.default ? "main" : "alternative";
  if (properties.characteristics && properties.characteristics.indexOf("public.accessibility.describes-video") >= 0) {
    kind = "main-desc";
  }
  return kind;
};
const stopLoaders = (segmentLoader, mediaType) => {
  segmentLoader.abort();
  segmentLoader.pause();
  if (mediaType && mediaType.activePlaylistLoader) {
    mediaType.activePlaylistLoader.pause();
    mediaType.activePlaylistLoader = null;
  }
};
const startLoaders = (playlistLoader, mediaType) => {
  mediaType.activePlaylistLoader = playlistLoader;
  playlistLoader.load();
};
const onGroupChanged = (type, settings) => () => {
  const {
    segmentLoaders: {
      [type]: segmentLoader,
      main: mainSegmentLoader
    },
    mediaTypes: {
      [type]: mediaType
    }
  } = settings;
  const activeTrack2 = mediaType.activeTrack();
  const activeGroup2 = mediaType.getActiveGroup();
  const previousActiveLoader = mediaType.activePlaylistLoader;
  const lastGroup = mediaType.lastGroup_;
  if (activeGroup2 && lastGroup && activeGroup2.id === lastGroup.id) {
    return;
  }
  mediaType.lastGroup_ = activeGroup2;
  mediaType.lastTrack_ = activeTrack2;
  stopLoaders(segmentLoader, mediaType);
  if (!activeGroup2 || activeGroup2.isMainPlaylist) {
    return;
  }
  if (!activeGroup2.playlistLoader) {
    if (previousActiveLoader) {
      mainSegmentLoader.resetEverything();
    }
    return;
  }
  segmentLoader.resyncLoader();
  startLoaders(activeGroup2.playlistLoader, mediaType);
};
const onGroupChanging = (type, settings) => () => {
  const {
    segmentLoaders: {
      [type]: segmentLoader
    },
    mediaTypes: {
      [type]: mediaType
    }
  } = settings;
  mediaType.lastGroup_ = null;
  segmentLoader.abort();
  segmentLoader.pause();
};
const onTrackChanged = (type, settings) => () => {
  const {
    mainPlaylistLoader,
    segmentLoaders: {
      [type]: segmentLoader,
      main: mainSegmentLoader
    },
    mediaTypes: {
      [type]: mediaType
    }
  } = settings;
  const activeTrack2 = mediaType.activeTrack();
  const activeGroup2 = mediaType.getActiveGroup();
  const previousActiveLoader = mediaType.activePlaylistLoader;
  const lastTrack = mediaType.lastTrack_;
  if (lastTrack && activeTrack2 && lastTrack.id === activeTrack2.id) {
    return;
  }
  mediaType.lastGroup_ = activeGroup2;
  mediaType.lastTrack_ = activeTrack2;
  stopLoaders(segmentLoader, mediaType);
  if (!activeGroup2) {
    return;
  }
  if (activeGroup2.isMainPlaylist) {
    if (!activeTrack2 || !lastTrack || activeTrack2.id === lastTrack.id) {
      return;
    }
    const pc = settings.vhs.playlistController_;
    const newPlaylist = pc.selectPlaylist();
    if (pc.media() === newPlaylist) {
      return;
    }
    mediaType.logger_(`track change. Switching main audio from ${lastTrack.id} to ${activeTrack2.id}`);
    mainPlaylistLoader.pause();
    mainSegmentLoader.resetEverything();
    pc.fastQualityChange_(newPlaylist);
    return;
  }
  if (type === "AUDIO") {
    if (!activeGroup2.playlistLoader) {
      mainSegmentLoader.setAudio(true);
      mainSegmentLoader.resetEverything();
      return;
    }
    segmentLoader.setAudio(true);
    mainSegmentLoader.setAudio(false);
  }
  if (previousActiveLoader === activeGroup2.playlistLoader) {
    startLoaders(activeGroup2.playlistLoader, mediaType);
    return;
  }
  if (segmentLoader.track) {
    segmentLoader.track(activeTrack2);
  }
  segmentLoader.resetEverything();
  startLoaders(activeGroup2.playlistLoader, mediaType);
};
const onError = {
  AUDIO: (type, settings) => () => {
    const {
      mediaTypes: {
        [type]: mediaType
      },
      excludePlaylist
    } = settings;
    const activeTrack2 = mediaType.activeTrack();
    const activeGroup2 = mediaType.activeGroup();
    const id = (activeGroup2.filter((group) => group.default)[0] || activeGroup2[0]).id;
    const defaultTrack = mediaType.tracks[id];
    if (activeTrack2 === defaultTrack) {
      excludePlaylist({
        error: {
          message: "Problem encountered loading the default audio track."
        }
      });
      return;
    }
    videojs.log.warn("Problem encountered loading the alternate audio track.Switching back to default.");
    for (const trackId in mediaType.tracks) {
      mediaType.tracks[trackId].enabled = mediaType.tracks[trackId] === defaultTrack;
    }
    mediaType.onTrackChanged();
  },
  SUBTITLES: (type, settings) => () => {
    const {
      mediaTypes: {
        [type]: mediaType
      }
    } = settings;
    videojs.log.warn("Problem encountered loading the subtitle track.Disabling subtitle track.");
    const track = mediaType.activeTrack();
    if (track) {
      track.mode = "disabled";
    }
    mediaType.onTrackChanged();
  }
};
const setupListeners = {
  AUDIO: (type, playlistLoader, settings) => {
    if (!playlistLoader) {
      return;
    }
    const {
      tech,
      requestOptions,
      segmentLoaders: {
        [type]: segmentLoader
      }
    } = settings;
    playlistLoader.on("loadedmetadata", () => {
      const media = playlistLoader.media();
      segmentLoader.playlist(media, requestOptions);
      if (!tech.paused() || media.endList && tech.preload() !== "none") {
        segmentLoader.load();
      }
    });
    playlistLoader.on("loadedplaylist", () => {
      segmentLoader.playlist(playlistLoader.media(), requestOptions);
      if (!tech.paused()) {
        segmentLoader.load();
      }
    });
    playlistLoader.on("error", onError[type](type, settings));
  },
  SUBTITLES: (type, playlistLoader, settings) => {
    const {
      tech,
      requestOptions,
      segmentLoaders: {
        [type]: segmentLoader
      },
      mediaTypes: {
        [type]: mediaType
      }
    } = settings;
    playlistLoader.on("loadedmetadata", () => {
      const media = playlistLoader.media();
      segmentLoader.playlist(media, requestOptions);
      segmentLoader.track(mediaType.activeTrack());
      if (!tech.paused() || media.endList && tech.preload() !== "none") {
        segmentLoader.load();
      }
    });
    playlistLoader.on("loadedplaylist", () => {
      segmentLoader.playlist(playlistLoader.media(), requestOptions);
      if (!tech.paused()) {
        segmentLoader.load();
      }
    });
    playlistLoader.on("error", onError[type](type, settings));
  }
};
const initialize = {
  "AUDIO": (type, settings) => {
    const {
      vhs,
      sourceType,
      segmentLoaders: {
        [type]: segmentLoader
      },
      requestOptions,
      main: {
        mediaGroups
      },
      mediaTypes: {
        [type]: {
          groups,
          tracks,
          logger_
        }
      },
      mainPlaylistLoader
    } = settings;
    const audioOnlyMain = isAudioOnly(mainPlaylistLoader.main);
    if (!mediaGroups[type] || Object.keys(mediaGroups[type]).length === 0) {
      mediaGroups[type] = {
        main: {
          default: {
            default: true
          }
        }
      };
      if (audioOnlyMain) {
        mediaGroups[type].main.default.playlists = mainPlaylistLoader.main.playlists;
      }
    }
    for (const groupId in mediaGroups[type]) {
      if (!groups[groupId]) {
        groups[groupId] = [];
      }
      for (const variantLabel in mediaGroups[type][groupId]) {
        let properties = mediaGroups[type][groupId][variantLabel];
        let playlistLoader;
        if (audioOnlyMain) {
          logger_(`AUDIO group '${groupId}' label '${variantLabel}' is a main playlist`);
          properties.isMainPlaylist = true;
          playlistLoader = null;
        } else if (sourceType === "vhs-json" && properties.playlists) {
          playlistLoader = new PlaylistLoader(properties.playlists[0], vhs, requestOptions);
        } else if (properties.resolvedUri) {
          playlistLoader = new PlaylistLoader(properties.resolvedUri, vhs, requestOptions);
        } else if (properties.playlists && sourceType === "dash") {
          playlistLoader = new DashPlaylistLoader(properties.playlists[0], vhs, requestOptions, mainPlaylistLoader);
        } else {
          playlistLoader = null;
        }
        properties = merge({
          id: variantLabel,
          playlistLoader
        }, properties);
        setupListeners[type](type, properties.playlistLoader, settings);
        groups[groupId].push(properties);
        if (typeof tracks[variantLabel] === "undefined") {
          const track = new videojs.AudioTrack({
            id: variantLabel,
            kind: audioTrackKind_(properties),
            enabled: false,
            language: properties.language,
            default: properties.default,
            label: variantLabel
          });
          tracks[variantLabel] = track;
        }
      }
    }
    segmentLoader.on("error", onError[type](type, settings));
  },
  "SUBTITLES": (type, settings) => {
    const {
      tech,
      vhs,
      sourceType,
      segmentLoaders: {
        [type]: segmentLoader
      },
      requestOptions,
      main: {
        mediaGroups
      },
      mediaTypes: {
        [type]: {
          groups,
          tracks
        }
      },
      mainPlaylistLoader
    } = settings;
    for (const groupId in mediaGroups[type]) {
      if (!groups[groupId]) {
        groups[groupId] = [];
      }
      for (const variantLabel in mediaGroups[type][groupId]) {
        if (!vhs.options_.useForcedSubtitles && mediaGroups[type][groupId][variantLabel].forced) {
          continue;
        }
        let properties = mediaGroups[type][groupId][variantLabel];
        let playlistLoader;
        if (sourceType === "hls") {
          playlistLoader = new PlaylistLoader(properties.resolvedUri, vhs, requestOptions);
        } else if (sourceType === "dash") {
          const playlists = properties.playlists.filter((p) => p.excludeUntil !== Infinity);
          if (!playlists.length) {
            return;
          }
          playlistLoader = new DashPlaylistLoader(properties.playlists[0], vhs, requestOptions, mainPlaylistLoader);
        } else if (sourceType === "vhs-json") {
          playlistLoader = new PlaylistLoader(
            properties.playlists ? properties.playlists[0] : properties.resolvedUri,
            vhs,
            requestOptions
          );
        }
        properties = merge({
          id: variantLabel,
          playlistLoader
        }, properties);
        setupListeners[type](type, properties.playlistLoader, settings);
        groups[groupId].push(properties);
        if (typeof tracks[variantLabel] === "undefined") {
          const track = tech.addRemoteTextTrack({
            id: variantLabel,
            kind: "subtitles",
            default: properties.default && properties.autoselect,
            language: properties.language,
            label: variantLabel
          }, false).track;
          tracks[variantLabel] = track;
        }
      }
    }
    segmentLoader.on("error", onError[type](type, settings));
  },
  "CLOSED-CAPTIONS": (type, settings) => {
    const {
      tech,
      main: {
        mediaGroups
      },
      mediaTypes: {
        [type]: {
          groups,
          tracks
        }
      }
    } = settings;
    for (const groupId in mediaGroups[type]) {
      if (!groups[groupId]) {
        groups[groupId] = [];
      }
      for (const variantLabel in mediaGroups[type][groupId]) {
        const properties = mediaGroups[type][groupId][variantLabel];
        if (!/^(?:CC|SERVICE)/.test(properties.instreamId)) {
          continue;
        }
        const captionServices = tech.options_.vhs && tech.options_.vhs.captionServices || {};
        let newProps = {
          label: variantLabel,
          language: properties.language,
          instreamId: properties.instreamId,
          default: properties.default && properties.autoselect
        };
        if (captionServices[newProps.instreamId]) {
          newProps = merge(newProps, captionServices[newProps.instreamId]);
        }
        if (newProps.default === void 0) {
          delete newProps.default;
        }
        groups[groupId].push(merge({
          id: variantLabel
        }, properties));
        if (typeof tracks[variantLabel] === "undefined") {
          const track = tech.addRemoteTextTrack({
            id: newProps.instreamId,
            kind: "captions",
            default: newProps.default,
            language: newProps.language,
            label: newProps.label
          }, false).track;
          tracks[variantLabel] = track;
        }
      }
    }
  }
};
const groupMatch = (list, media) => {
  for (let i = 0; i < list.length; i++) {
    if (playlistMatch(media, list[i])) {
      return true;
    }
    if (list[i].playlists && groupMatch(list[i].playlists, media)) {
      return true;
    }
  }
  return false;
};
const activeGroup = (type, settings) => (track) => {
  const {
    mainPlaylistLoader,
    mediaTypes: {
      [type]: {
        groups
      }
    }
  } = settings;
  const media = mainPlaylistLoader.media();
  if (!media) {
    return null;
  }
  let variants = null;
  if (media.attributes[type]) {
    variants = groups[media.attributes[type]];
  }
  const groupKeys = Object.keys(groups);
  if (!variants) {
    if (type === "AUDIO" && groupKeys.length > 1 && isAudioOnly(settings.main)) {
      for (let i = 0; i < groupKeys.length; i++) {
        const groupPropertyList = groups[groupKeys[i]];
        if (groupMatch(groupPropertyList, media)) {
          variants = groupPropertyList;
          break;
        }
      }
    } else if (groups.main) {
      variants = groups.main;
    } else if (groupKeys.length === 1) {
      variants = groups[groupKeys[0]];
    }
  }
  if (typeof track === "undefined") {
    return variants;
  }
  if (track === null || !variants) {
    return null;
  }
  return variants.filter((props) => props.id === track.id)[0] || null;
};
const activeTrack = {
  AUDIO: (type, settings) => () => {
    const {
      mediaTypes: {
        [type]: {
          tracks
        }
      }
    } = settings;
    for (const id in tracks) {
      if (tracks[id].enabled) {
        return tracks[id];
      }
    }
    return null;
  },
  SUBTITLES: (type, settings) => () => {
    const {
      mediaTypes: {
        [type]: {
          tracks
        }
      }
    } = settings;
    for (const id in tracks) {
      if (tracks[id].mode === "showing" || tracks[id].mode === "hidden") {
        return tracks[id];
      }
    }
    return null;
  }
};
const getActiveGroup = (type, {
  mediaTypes
}) => () => {
  const activeTrack_ = mediaTypes[type].activeTrack();
  if (!activeTrack_) {
    return null;
  }
  return mediaTypes[type].activeGroup(activeTrack_);
};
const setupMediaGroups = (settings) => {
  ["AUDIO", "SUBTITLES", "CLOSED-CAPTIONS"].forEach((type) => {
    initialize[type](type, settings);
  });
  const {
    mediaTypes,
    mainPlaylistLoader,
    tech,
    vhs,
    segmentLoaders: {
      ["AUDIO"]: audioSegmentLoader,
      main: mainSegmentLoader
    }
  } = settings;
  ["AUDIO", "SUBTITLES"].forEach((type) => {
    mediaTypes[type].activeGroup = activeGroup(type, settings);
    mediaTypes[type].activeTrack = activeTrack[type](type, settings);
    mediaTypes[type].onGroupChanged = onGroupChanged(type, settings);
    mediaTypes[type].onGroupChanging = onGroupChanging(type, settings);
    mediaTypes[type].onTrackChanged = onTrackChanged(type, settings);
    mediaTypes[type].getActiveGroup = getActiveGroup(type, settings);
  });
  const audioGroup = mediaTypes.AUDIO.activeGroup();
  if (audioGroup) {
    const groupId = (audioGroup.filter((group) => group.default)[0] || audioGroup[0]).id;
    mediaTypes.AUDIO.tracks[groupId].enabled = true;
    mediaTypes.AUDIO.onGroupChanged();
    mediaTypes.AUDIO.onTrackChanged();
    const activeAudioGroup = mediaTypes.AUDIO.getActiveGroup();
    if (!activeAudioGroup.playlistLoader) {
      mainSegmentLoader.setAudio(true);
    } else {
      mainSegmentLoader.setAudio(false);
      audioSegmentLoader.setAudio(true);
    }
  }
  mainPlaylistLoader.on("mediachange", () => {
    ["AUDIO", "SUBTITLES"].forEach((type) => mediaTypes[type].onGroupChanged());
  });
  mainPlaylistLoader.on("mediachanging", () => {
    ["AUDIO", "SUBTITLES"].forEach((type) => mediaTypes[type].onGroupChanging());
  });
  const onAudioTrackChanged = () => {
    mediaTypes.AUDIO.onTrackChanged();
    tech.trigger({
      type: "usage",
      name: "vhs-audio-change"
    });
  };
  tech.audioTracks().addEventListener("change", onAudioTrackChanged);
  tech.remoteTextTracks().addEventListener("change", mediaTypes.SUBTITLES.onTrackChanged);
  vhs.on("dispose", () => {
    tech.audioTracks().removeEventListener("change", onAudioTrackChanged);
    tech.remoteTextTracks().removeEventListener("change", mediaTypes.SUBTITLES.onTrackChanged);
  });
  tech.clearTracks("audio");
  for (const id in mediaTypes.AUDIO.tracks) {
    tech.audioTracks().addTrack(mediaTypes.AUDIO.tracks[id]);
  }
};
const createMediaTypes = () => {
  const mediaTypes = {};
  ["AUDIO", "SUBTITLES", "CLOSED-CAPTIONS"].forEach((type) => {
    mediaTypes[type] = {
      groups: {},
      tracks: {},
      activePlaylistLoader: null,
      activeGroup: noop,
      activeTrack: noop,
      getActiveGroup: noop,
      onGroupChanged: noop,
      onTrackChanged: noop,
      lastTrack_: null,
      logger_: logger(`MediaGroups[${type}]`)
    };
  });
  return mediaTypes;
};
class SteeringManifest {
  constructor() {
    this.priority_ = [];
    this.pathwayClones_ = /* @__PURE__ */ new Map();
  }
  set version(number) {
    if (number === 1) {
      this.version_ = number;
    }
  }
  set ttl(seconds) {
    this.ttl_ = seconds || 300;
  }
  set reloadUri(uri) {
    if (uri) {
      this.reloadUri_ = resolveUrl(this.reloadUri_, uri);
    }
  }
  set priority(array) {
    if (array && array.length) {
      this.priority_ = array;
    }
  }
  set pathwayClones(array) {
    if (array && array.length) {
      this.pathwayClones_ = new Map(array.map((clone) => [clone.ID, clone]));
    }
  }
  get version() {
    return this.version_;
  }
  get ttl() {
    return this.ttl_;
  }
  get reloadUri() {
    return this.reloadUri_;
  }
  get priority() {
    return this.priority_;
  }
  get pathwayClones() {
    return this.pathwayClones_;
  }
}
class ContentSteeringController extends videojs.EventTarget {
  constructor(xhr, bandwidth) {
    super();
    this.currentPathway = null;
    this.defaultPathway = null;
    this.queryBeforeStart = false;
    this.availablePathways_ = /* @__PURE__ */ new Set();
    this.steeringManifest = new SteeringManifest();
    this.proxyServerUrl_ = null;
    this.manifestType_ = null;
    this.ttlTimeout_ = null;
    this.request_ = null;
    this.currentPathwayClones = /* @__PURE__ */ new Map();
    this.nextPathwayClones = /* @__PURE__ */ new Map();
    this.excludedSteeringManifestURLs = /* @__PURE__ */ new Set();
    this.logger_ = logger("Content Steering");
    this.xhr_ = xhr;
    this.getBandwidth_ = bandwidth;
  }
  assignTagProperties(baseUrl, steeringTag) {
    this.manifestType_ = steeringTag.serverUri ? "HLS" : "DASH";
    const steeringUri = steeringTag.serverUri || steeringTag.serverURL;
    if (!steeringUri) {
      this.logger_(`steering manifest URL is ${steeringUri}, cannot request steering manifest.`);
      this.trigger("error");
      return;
    }
    if (steeringUri.startsWith("data:")) {
      this.decodeDataUriManifest_(steeringUri.substring(steeringUri.indexOf(",") + 1));
      return;
    }
    this.steeringManifest.reloadUri = resolveUrl(baseUrl, steeringUri);
    this.defaultPathway = steeringTag.pathwayId || steeringTag.defaultServiceLocation;
    this.queryBeforeStart = steeringTag.queryBeforeStart;
    this.proxyServerUrl_ = steeringTag.proxyServerURL;
    if (this.defaultPathway && !this.queryBeforeStart) {
      this.trigger("content-steering");
    }
  }
  requestSteeringManifest(initial) {
    const reloadUri = this.steeringManifest.reloadUri;
    if (!reloadUri) {
      return;
    }
    const uri = initial ? reloadUri : this.getRequestURI(reloadUri);
    if (!uri) {
      this.logger_("No valid content steering manifest URIs. Stopping content steering.");
      this.trigger("error");
      this.dispose();
      return;
    }
    const metadata = {
      contentSteeringInfo: {
        uri
      }
    };
    this.trigger({
      type: "contentsteeringloadstart",
      metadata
    });
    this.request_ = this.xhr_({
      uri,
      requestType: "content-steering-manifest"
    }, (error, errorInfo) => {
      if (error) {
        if (errorInfo.status === 410) {
          this.logger_(`manifest request 410 ${error}.`);
          this.logger_(`There will be no more content steering requests to ${uri} this session.`);
          this.excludedSteeringManifestURLs.add(uri);
          return;
        }
        if (errorInfo.status === 429) {
          const retrySeconds = errorInfo.responseHeaders["retry-after"];
          this.logger_(`manifest request 429 ${error}.`);
          this.logger_(`content steering will retry in ${retrySeconds} seconds.`);
          this.startTTLTimeout_(parseInt(retrySeconds, 10));
          return;
        }
        this.logger_(`manifest failed to load ${error}.`);
        this.startTTLTimeout_();
        return;
      }
      this.trigger({
        type: "contentsteeringloadcomplete",
        metadata
      });
      let steeringManifestJson;
      try {
        steeringManifestJson = JSON.parse(this.request_.responseText);
      } catch (parseError) {
        const errorMetadata = {
          errorType: videojs.Error.StreamingContentSteeringParserError,
          error: parseError
        };
        this.trigger({
          type: "error",
          metadata: errorMetadata
        });
      }
      this.assignSteeringProperties_(steeringManifestJson);
      const parsedMetadata = {
        contentSteeringInfo: metadata.contentSteeringInfo,
        contentSteeringManifest: {
          version: this.steeringManifest.version,
          reloadUri: this.steeringManifest.reloadUri,
          priority: this.steeringManifest.priority
        }
      };
      this.trigger({
        type: "contentsteeringparsed",
        metadata: parsedMetadata
      });
      this.startTTLTimeout_();
    });
  }
  setProxyServerUrl_(steeringUrl) {
    const steeringUrlObject = new window_1.URL(steeringUrl);
    const proxyServerUrlObject = new window_1.URL(this.proxyServerUrl_);
    proxyServerUrlObject.searchParams.set("url", encodeURI(steeringUrlObject.toString()));
    return this.setSteeringParams_(proxyServerUrlObject.toString());
  }
  decodeDataUriManifest_(dataUri) {
    const steeringManifestJson = JSON.parse(window_1.atob(dataUri));
    this.assignSteeringProperties_(steeringManifestJson);
  }
  setSteeringParams_(url) {
    const urlObject = new window_1.URL(url);
    const path = this.getPathway();
    const networkThroughput = this.getBandwidth_();
    if (path) {
      const pathwayKey = `_${this.manifestType_}_pathway`;
      urlObject.searchParams.set(pathwayKey, path);
    }
    if (networkThroughput) {
      const throughputKey = `_${this.manifestType_}_throughput`;
      urlObject.searchParams.set(throughputKey, networkThroughput);
    }
    return urlObject.toString();
  }
  assignSteeringProperties_(steeringJson) {
    this.steeringManifest.version = steeringJson.VERSION;
    if (!this.steeringManifest.version) {
      this.logger_(`manifest version is ${steeringJson.VERSION}, which is not supported.`);
      this.trigger("error");
      return;
    }
    this.steeringManifest.ttl = steeringJson.TTL;
    this.steeringManifest.reloadUri = steeringJson["RELOAD-URI"];
    this.steeringManifest.priority = steeringJson["PATHWAY-PRIORITY"] || steeringJson["SERVICE-LOCATION-PRIORITY"];
    this.steeringManifest.pathwayClones = steeringJson["PATHWAY-CLONES"];
    this.nextPathwayClones = this.steeringManifest.pathwayClones;
    if (!this.availablePathways_.size) {
      this.logger_("There are no available pathways for content steering. Ending content steering.");
      this.trigger("error");
      this.dispose();
    }
    const chooseNextPathway = (pathwaysByPriority) => {
      for (const path of pathwaysByPriority) {
        if (this.availablePathways_.has(path)) {
          return path;
        }
      }
      return [...this.availablePathways_][0];
    };
    const nextPathway = chooseNextPathway(this.steeringManifest.priority);
    if (this.currentPathway !== nextPathway) {
      this.currentPathway = nextPathway;
      this.trigger("content-steering");
    }
  }
  getPathway() {
    return this.currentPathway || this.defaultPathway;
  }
  getRequestURI(reloadUri) {
    if (!reloadUri) {
      return null;
    }
    const isExcluded2 = (uri) => this.excludedSteeringManifestURLs.has(uri);
    if (this.proxyServerUrl_) {
      const proxyURI = this.setProxyServerUrl_(reloadUri);
      if (!isExcluded2(proxyURI)) {
        return proxyURI;
      }
    }
    const steeringURI = this.setSteeringParams_(reloadUri);
    if (!isExcluded2(steeringURI)) {
      return steeringURI;
    }
    return null;
  }
  startTTLTimeout_(ttl = this.steeringManifest.ttl) {
    const ttlMS = ttl * 1e3;
    this.ttlTimeout_ = window_1.setTimeout(() => {
      this.requestSteeringManifest();
    }, ttlMS);
  }
  clearTTLTimeout_() {
    window_1.clearTimeout(this.ttlTimeout_);
    this.ttlTimeout_ = null;
  }
  abort() {
    if (this.request_) {
      this.request_.abort();
    }
    this.request_ = null;
  }
  dispose() {
    this.off("content-steering");
    this.off("error");
    this.abort();
    this.clearTTLTimeout_();
    this.currentPathway = null;
    this.defaultPathway = null;
    this.queryBeforeStart = null;
    this.proxyServerUrl_ = null;
    this.manifestType_ = null;
    this.ttlTimeout_ = null;
    this.request_ = null;
    this.excludedSteeringManifestURLs = /* @__PURE__ */ new Set();
    this.availablePathways_ = /* @__PURE__ */ new Set();
    this.steeringManifest = new SteeringManifest();
  }
  addAvailablePathway(pathway) {
    if (pathway) {
      this.availablePathways_.add(pathway);
    }
  }
  clearAvailablePathways() {
    this.availablePathways_.clear();
  }
  excludePathway(pathway) {
    return this.availablePathways_.delete(pathway);
  }
  didDASHTagChange(baseURL, newTag) {
    return !newTag && this.steeringManifest.reloadUri || newTag && (resolveUrl(baseURL, newTag.serverURL) !== this.steeringManifest.reloadUri || newTag.defaultServiceLocation !== this.defaultPathway || newTag.queryBeforeStart !== this.queryBeforeStart || newTag.proxyServerURL !== this.proxyServerUrl_);
  }
  getAvailablePathways() {
    return this.availablePathways_;
  }
}
const debounce = (callback, wait) => {
  let timeoutId = null;
  return (...args) => {
    clearTimeout(timeoutId);
    timeoutId = setTimeout(() => {
      callback.apply(null, args);
    }, wait);
  };
};
const ABORT_EARLY_EXCLUSION_SECONDS = 10;
let Vhs$1;
const loaderStats = ["mediaRequests", "mediaRequestsAborted", "mediaRequestsTimedout", "mediaRequestsErrored", "mediaTransferDuration", "mediaBytesTransferred", "mediaAppends"];
const sumLoaderStat = function(stat) {
  return this.audioSegmentLoader_[stat] + this.mainSegmentLoader_[stat];
};
const shouldSwitchToMedia = function({
  currentPlaylist,
  buffered,
  currentTime,
  nextPlaylist,
  bufferLowWaterLine,
  bufferHighWaterLine,
  duration: duration2,
  bufferBasedABR,
  log: log2
}) {
  if (!nextPlaylist) {
    videojs.log.warn("We received no playlist to switch to. Please check your stream.");
    return false;
  }
  const sharedLogLine = `allowing switch ${currentPlaylist && currentPlaylist.id || "null"} -> ${nextPlaylist.id}`;
  if (!currentPlaylist) {
    log2(`${sharedLogLine} as current playlist is not set`);
    return true;
  }
  if (nextPlaylist.id === currentPlaylist.id) {
    return false;
  }
  const isBuffered = Boolean(findRange(buffered, currentTime).length);
  if (!currentPlaylist.endList) {
    if (!isBuffered && typeof currentPlaylist.partTargetDuration === "number") {
      log2(`not ${sharedLogLine} as current playlist is live llhls, but currentTime isn't in buffered.`);
      return false;
    }
    log2(`${sharedLogLine} as current playlist is live`);
    return true;
  }
  const forwardBuffer = timeAheadOf(buffered, currentTime);
  const maxBufferLowWaterLine = bufferBasedABR ? Config.EXPERIMENTAL_MAX_BUFFER_LOW_WATER_LINE : Config.MAX_BUFFER_LOW_WATER_LINE;
  if (duration2 < maxBufferLowWaterLine) {
    log2(`${sharedLogLine} as duration < max low water line (${duration2} < ${maxBufferLowWaterLine})`);
    return true;
  }
  const nextBandwidth = nextPlaylist.attributes.BANDWIDTH;
  const currBandwidth = currentPlaylist.attributes.BANDWIDTH;
  if (nextBandwidth < currBandwidth && (!bufferBasedABR || forwardBuffer < bufferHighWaterLine)) {
    let logLine = `${sharedLogLine} as next bandwidth < current bandwidth (${nextBandwidth} < ${currBandwidth})`;
    if (bufferBasedABR) {
      logLine += ` and forwardBuffer < bufferHighWaterLine (${forwardBuffer} < ${bufferHighWaterLine})`;
    }
    log2(logLine);
    return true;
  }
  if ((!bufferBasedABR || nextBandwidth > currBandwidth) && forwardBuffer >= bufferLowWaterLine) {
    let logLine = `${sharedLogLine} as forwardBuffer >= bufferLowWaterLine (${forwardBuffer} >= ${bufferLowWaterLine})`;
    if (bufferBasedABR) {
      logLine += ` and next bandwidth > current bandwidth (${nextBandwidth} > ${currBandwidth})`;
    }
    log2(logLine);
    return true;
  }
  log2(`not ${sharedLogLine} as no switching criteria met`);
  return false;
};
class PlaylistController extends videojs.EventTarget {
  constructor(options) {
    super();
    this.fastQualityChange_ = debounce(this.fastQualityChange_.bind(this), 100);
    const {
      src,
      withCredentials,
      tech,
      bandwidth,
      externVhs,
      useCueTags,
      playlistExclusionDuration,
      enableLowInitialPlaylist,
      sourceType,
      cacheEncryptionKeys,
      bufferBasedABR,
      leastPixelDiffSelector,
      captionServices,
      experimentalUseMMS
    } = options;
    if (!src) {
      throw new Error("A non-empty playlist URL or JSON manifest string is required");
    }
    let {
      maxPlaylistRetries
    } = options;
    if (maxPlaylistRetries === null || typeof maxPlaylistRetries === "undefined") {
      maxPlaylistRetries = Infinity;
    }
    Vhs$1 = externVhs;
    this.bufferBasedABR = Boolean(bufferBasedABR);
    this.leastPixelDiffSelector = Boolean(leastPixelDiffSelector);
    this.withCredentials = withCredentials;
    this.tech_ = tech;
    this.vhs_ = tech.vhs;
    this.player_ = options.player_;
    this.sourceType_ = sourceType;
    this.useCueTags_ = useCueTags;
    this.playlistExclusionDuration = playlistExclusionDuration;
    this.maxPlaylistRetries = maxPlaylistRetries;
    this.enableLowInitialPlaylist = enableLowInitialPlaylist;
    this.usingManagedMediaSource_ = false;
    if (this.useCueTags_) {
      this.cueTagsTrack_ = this.tech_.addTextTrack("metadata", "ad-cues");
      this.cueTagsTrack_.inBandMetadataTrackDispatchType = "";
    }
    this.requestOptions_ = {
      withCredentials,
      maxPlaylistRetries,
      timeout: null
    };
    this.on("error", this.pauseLoading);
    this.mediaTypes_ = createMediaTypes();
    if (experimentalUseMMS && window_1.ManagedMediaSource) {
      this.tech_.el_.disableRemotePlayback = true;
      this.mediaSource = new window_1.ManagedMediaSource();
      this.usingManagedMediaSource_ = true;
      videojs.log("Using ManagedMediaSource");
    } else if (window_1.MediaSource) {
      this.mediaSource = new window_1.MediaSource();
    }
    this.handleDurationChange_ = this.handleDurationChange_.bind(this);
    this.handleSourceOpen_ = this.handleSourceOpen_.bind(this);
    this.handleSourceEnded_ = this.handleSourceEnded_.bind(this);
    this.load = this.load.bind(this);
    this.pause = this.pause.bind(this);
    this.mediaSource.addEventListener("durationchange", this.handleDurationChange_);
    this.mediaSource.addEventListener("sourceopen", this.handleSourceOpen_);
    this.mediaSource.addEventListener("sourceended", this.handleSourceEnded_);
    this.mediaSource.addEventListener("startstreaming", this.load);
    this.mediaSource.addEventListener("endstreaming", this.pause);
    this.seekable_ = createTimeRanges();
    this.hasPlayed_ = false;
    this.syncController_ = new SyncController(options);
    this.segmentMetadataTrack_ = tech.addRemoteTextTrack({
      kind: "metadata",
      label: "segment-metadata"
    }, false).track;
    this.segmentMetadataTrack_.mode = "hidden";
    this.decrypter_ = new Decrypter();
    this.sourceUpdater_ = new SourceUpdater(this.mediaSource);
    this.inbandTextTracks_ = {};
    this.timelineChangeController_ = new TimelineChangeController();
    this.keyStatusMap_ = /* @__PURE__ */ new Map();
    const segmentLoaderSettings = {
      vhs: this.vhs_,
      parse708captions: options.parse708captions,
      useDtsForTimestampOffset: options.useDtsForTimestampOffset,
      captionServices,
      mediaSource: this.mediaSource,
      currentTime: this.tech_.currentTime.bind(this.tech_),
      seekable: () => this.seekable(),
      seeking: () => this.tech_.seeking(),
      duration: () => this.duration(),
      hasPlayed: () => this.hasPlayed_,
      goalBufferLength: () => this.goalBufferLength(),
      bandwidth,
      syncController: this.syncController_,
      decrypter: this.decrypter_,
      sourceType: this.sourceType_,
      inbandTextTracks: this.inbandTextTracks_,
      cacheEncryptionKeys,
      sourceUpdater: this.sourceUpdater_,
      timelineChangeController: this.timelineChangeController_,
      exactManifestTimings: options.exactManifestTimings,
      addMetadataToTextTrack: this.addMetadataToTextTrack.bind(this)
    };
    this.mainPlaylistLoader_ = this.sourceType_ === "dash" ? new DashPlaylistLoader(src, this.vhs_, merge(this.requestOptions_, {
      addMetadataToTextTrack: this.addMetadataToTextTrack.bind(this)
    })) : new PlaylistLoader(src, this.vhs_, merge(this.requestOptions_, {
      addDateRangesToTextTrack: this.addDateRangesToTextTrack_.bind(this)
    }));
    this.setupMainPlaylistLoaderListeners_();
    this.mainSegmentLoader_ = new SegmentLoader(merge(segmentLoaderSettings, {
      segmentMetadataTrack: this.segmentMetadataTrack_,
      loaderType: "main"
    }), options);
    this.audioSegmentLoader_ = new SegmentLoader(merge(segmentLoaderSettings, {
      loaderType: "audio"
    }), options);
    this.subtitleSegmentLoader_ = new VTTSegmentLoader(merge(segmentLoaderSettings, {
      loaderType: "vtt",
      featuresNativeTextTracks: this.tech_.featuresNativeTextTracks,
      loadVttJs: () => new Promise((resolve, reject) => {
        function onLoad() {
          tech.off("vttjserror", onError2);
          resolve();
        }
        function onError2() {
          tech.off("vttjsloaded", onLoad);
          reject();
        }
        tech.one("vttjsloaded", onLoad);
        tech.one("vttjserror", onError2);
        tech.addWebVttScript_();
      })
    }), options);
    const getBandwidth = () => {
      return this.mainSegmentLoader_.bandwidth;
    };
    this.contentSteeringController_ = new ContentSteeringController(this.vhs_.xhr, getBandwidth);
    this.setupSegmentLoaderListeners_();
    if (this.bufferBasedABR) {
      this.mainPlaylistLoader_.one("loadedplaylist", () => this.startABRTimer_());
      this.tech_.on("pause", () => this.stopABRTimer_());
      this.tech_.on("play", () => this.startABRTimer_());
    }
    loaderStats.forEach((stat) => {
      this[stat + "_"] = sumLoaderStat.bind(this, stat);
    });
    this.logger_ = logger("pc");
    this.triggeredFmp4Usage = false;
    if (this.tech_.preload() === "none") {
      this.loadOnPlay_ = () => {
        this.loadOnPlay_ = null;
        this.mainPlaylistLoader_.load();
      };
      this.tech_.one("play", this.loadOnPlay_);
    } else {
      this.mainPlaylistLoader_.load();
    }
    this.timeToLoadedData__ = -1;
    this.mainAppendsToLoadedData__ = -1;
    this.audioAppendsToLoadedData__ = -1;
    const event = this.tech_.preload() === "none" ? "play" : "loadstart";
    this.tech_.one(event, () => {
      const timeToLoadedDataStart = Date.now();
      this.tech_.one("loadeddata", () => {
        this.timeToLoadedData__ = Date.now() - timeToLoadedDataStart;
        this.mainAppendsToLoadedData__ = this.mainSegmentLoader_.mediaAppends;
        this.audioAppendsToLoadedData__ = this.audioSegmentLoader_.mediaAppends;
      });
    });
  }
  mainAppendsToLoadedData_() {
    return this.mainAppendsToLoadedData__;
  }
  audioAppendsToLoadedData_() {
    return this.audioAppendsToLoadedData__;
  }
  appendsToLoadedData_() {
    const main = this.mainAppendsToLoadedData_();
    const audio = this.audioAppendsToLoadedData_();
    if (main === -1 || audio === -1) {
      return -1;
    }
    return main + audio;
  }
  timeToLoadedData_() {
    return this.timeToLoadedData__;
  }
  checkABR_(reason = "abr") {
    const nextPlaylist = this.selectPlaylist();
    if (nextPlaylist && this.shouldSwitchToMedia_(nextPlaylist)) {
      this.switchMedia_(nextPlaylist, reason);
    }
  }
  switchMedia_(playlist, cause, delay) {
    const oldMedia = this.media();
    const oldId = oldMedia && (oldMedia.id || oldMedia.uri);
    const newId = playlist && (playlist.id || playlist.uri);
    if (oldId && oldId !== newId) {
      this.logger_(`switch media ${oldId} -> ${newId} from ${cause}`);
      const metadata = {
        renditionInfo: {
          id: newId,
          bandwidth: playlist.attributes.BANDWIDTH,
          resolution: playlist.attributes.RESOLUTION,
          codecs: playlist.attributes.CODECS
        },
        cause
      };
      this.trigger({
        type: "renditionselected",
        metadata
      });
      this.tech_.trigger({
        type: "usage",
        name: `vhs-rendition-change-${cause}`
      });
    }
    this.mainPlaylistLoader_.media(playlist, delay);
  }
  switchMediaForDASHContentSteering_() {
    ["AUDIO", "SUBTITLES", "CLOSED-CAPTIONS"].forEach((type) => {
      const mediaType = this.mediaTypes_[type];
      const activeGroup2 = mediaType ? mediaType.activeGroup() : null;
      const pathway = this.contentSteeringController_.getPathway();
      if (activeGroup2 && pathway) {
        const mediaPlaylists = activeGroup2.length ? activeGroup2[0].playlists : activeGroup2.playlists;
        const dashMediaPlaylists = mediaPlaylists.filter((p) => p.attributes.serviceLocation === pathway);
        if (dashMediaPlaylists.length) {
          this.mediaTypes_[type].activePlaylistLoader.media(dashMediaPlaylists[0]);
        }
      }
    });
  }
  startABRTimer_() {
    this.stopABRTimer_();
    this.abrTimer_ = window_1.setInterval(() => this.checkABR_(), 250);
  }
  stopABRTimer_() {
    if (this.tech_.scrubbing && this.tech_.scrubbing()) {
      return;
    }
    window_1.clearInterval(this.abrTimer_);
    this.abrTimer_ = null;
  }
  getAudioTrackPlaylists_() {
    const main = this.main();
    const defaultPlaylists = main && main.playlists || [];
    if (!main || !main.mediaGroups || !main.mediaGroups.AUDIO) {
      return defaultPlaylists;
    }
    const AUDIO = main.mediaGroups.AUDIO;
    const groupKeys = Object.keys(AUDIO);
    let track;
    if (Object.keys(this.mediaTypes_.AUDIO.groups).length) {
      track = this.mediaTypes_.AUDIO.activeTrack();
    } else {
      const defaultGroup = AUDIO.main || groupKeys.length && AUDIO[groupKeys[0]];
      for (const label in defaultGroup) {
        if (defaultGroup[label].default) {
          track = {
            label
          };
          break;
        }
      }
    }
    if (!track) {
      return defaultPlaylists;
    }
    const playlists = [];
    for (const group in AUDIO) {
      if (AUDIO[group][track.label]) {
        const properties = AUDIO[group][track.label];
        if (properties.playlists && properties.playlists.length) {
          playlists.push.apply(playlists, properties.playlists);
        } else if (properties.uri) {
          playlists.push(properties);
        } else if (main.playlists.length) {
          for (let i = 0; i < main.playlists.length; i++) {
            const playlist = main.playlists[i];
            if (playlist.attributes && playlist.attributes.AUDIO && playlist.attributes.AUDIO === group) {
              playlists.push(playlist);
            }
          }
        }
      }
    }
    if (!playlists.length) {
      return defaultPlaylists;
    }
    return playlists;
  }
  setupMainPlaylistLoaderListeners_() {
    this.mainPlaylistLoader_.on("loadedmetadata", () => {
      const media = this.mainPlaylistLoader_.media();
      const requestTimeout = media.targetDuration * 1.5 * 1e3;
      if (isLowestEnabledRendition(this.mainPlaylistLoader_.main, this.mainPlaylistLoader_.media())) {
        this.requestOptions_.timeout = 0;
      } else {
        this.requestOptions_.timeout = requestTimeout;
      }
      if (media.endList && this.tech_.preload() !== "none") {
        this.mainSegmentLoader_.playlist(media, this.requestOptions_);
        this.mainSegmentLoader_.load();
      }
      setupMediaGroups({
        sourceType: this.sourceType_,
        segmentLoaders: {
          AUDIO: this.audioSegmentLoader_,
          SUBTITLES: this.subtitleSegmentLoader_,
          main: this.mainSegmentLoader_
        },
        tech: this.tech_,
        requestOptions: this.requestOptions_,
        mainPlaylistLoader: this.mainPlaylistLoader_,
        vhs: this.vhs_,
        main: this.main(),
        mediaTypes: this.mediaTypes_,
        excludePlaylist: this.excludePlaylist.bind(this)
      });
      this.triggerPresenceUsage_(this.main(), media);
      this.setupFirstPlay();
      if (!this.mediaTypes_.AUDIO.activePlaylistLoader || this.mediaTypes_.AUDIO.activePlaylistLoader.media()) {
        this.trigger("selectedinitialmedia");
      } else {
        this.mediaTypes_.AUDIO.activePlaylistLoader.one("loadedmetadata", () => {
          this.trigger("selectedinitialmedia");
        });
      }
    });
    this.mainPlaylistLoader_.on("loadedplaylist", () => {
      if (this.loadOnPlay_) {
        this.tech_.off("play", this.loadOnPlay_);
      }
      let updatedPlaylist = this.mainPlaylistLoader_.media();
      if (!updatedPlaylist) {
        this.attachContentSteeringListeners_();
        this.initContentSteeringController_();
        this.excludeUnsupportedVariants_();
        let selectedMedia;
        if (this.enableLowInitialPlaylist) {
          selectedMedia = this.selectInitialPlaylist();
        }
        if (!selectedMedia) {
          selectedMedia = this.selectPlaylist();
        }
        if (!selectedMedia || !this.shouldSwitchToMedia_(selectedMedia)) {
          return;
        }
        this.initialMedia_ = selectedMedia;
        this.switchMedia_(this.initialMedia_, "initial");
        const haveJsonSource = this.sourceType_ === "vhs-json" && this.initialMedia_.segments;
        if (!haveJsonSource) {
          return;
        }
        updatedPlaylist = this.initialMedia_;
      }
      this.handleUpdatedMediaPlaylist(updatedPlaylist);
    });
    this.mainPlaylistLoader_.on("error", () => {
      const error = this.mainPlaylistLoader_.error;
      this.excludePlaylist({
        playlistToExclude: error.playlist,
        error
      });
    });
    this.mainPlaylistLoader_.on("mediachanging", () => {
      this.mainSegmentLoader_.abort();
      this.mainSegmentLoader_.pause();
    });
    this.mainPlaylistLoader_.on("mediachange", () => {
      const media = this.mainPlaylistLoader_.media();
      const requestTimeout = media.targetDuration * 1.5 * 1e3;
      if (isLowestEnabledRendition(this.mainPlaylistLoader_.main, this.mainPlaylistLoader_.media())) {
        this.requestOptions_.timeout = 0;
      } else {
        this.requestOptions_.timeout = requestTimeout;
      }
      if (this.sourceType_ === "dash") {
        if (this.mainPlaylistLoader_.isPaused) {
          this.mainPlaylistLoader_.load();
        }
      }
      this.mainSegmentLoader_.pause();
      this.mainSegmentLoader_.playlist(media, this.requestOptions_);
      if (this.waitingForFastQualityPlaylistReceived_) {
        this.runFastQualitySwitch_();
      } else {
        this.mainSegmentLoader_.load();
      }
      this.tech_.trigger({
        type: "mediachange",
        bubbles: true
      });
    });
    this.mainPlaylistLoader_.on("playlistunchanged", () => {
      const updatedPlaylist = this.mainPlaylistLoader_.media();
      if (updatedPlaylist.lastExcludeReason_ === "playlist-unchanged") {
        return;
      }
      const playlistOutdated = this.stuckAtPlaylistEnd_(updatedPlaylist);
      if (playlistOutdated) {
        this.excludePlaylist({
          error: {
            message: "Playlist no longer updating.",
            reason: "playlist-unchanged"
          }
        });
        this.tech_.trigger("playliststuck");
      }
    });
    this.mainPlaylistLoader_.on("renditiondisabled", () => {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-rendition-disabled"
      });
    });
    this.mainPlaylistLoader_.on("renditionenabled", () => {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-rendition-enabled"
      });
    });
    const playlistLoaderEvents = ["manifestrequeststart", "manifestrequestcomplete", "manifestparsestart", "manifestparsecomplete", "playlistrequeststart", "playlistrequestcomplete", "playlistparsestart", "playlistparsecomplete", "renditiondisabled", "renditionenabled"];
    playlistLoaderEvents.forEach((eventName) => {
      this.mainPlaylistLoader_.on(eventName, (metadata) => {
        this.player_.trigger(_extends({}, metadata));
      });
    });
  }
  handleUpdatedMediaPlaylist(updatedPlaylist) {
    if (this.useCueTags_) {
      this.updateAdCues_(updatedPlaylist);
    }
    this.mainSegmentLoader_.pause();
    this.mainSegmentLoader_.playlist(updatedPlaylist, this.requestOptions_);
    if (this.waitingForFastQualityPlaylistReceived_) {
      this.runFastQualitySwitch_();
    }
    this.updateDuration(!updatedPlaylist.endList);
    if (!this.tech_.paused()) {
      this.mainSegmentLoader_.load();
      if (this.audioSegmentLoader_) {
        this.audioSegmentLoader_.load();
      }
    }
  }
  triggerPresenceUsage_(main, media) {
    const mediaGroups = main.mediaGroups || {};
    let defaultDemuxed = true;
    const audioGroupKeys = Object.keys(mediaGroups.AUDIO);
    for (const mediaGroup in mediaGroups.AUDIO) {
      for (const label in mediaGroups.AUDIO[mediaGroup]) {
        const properties = mediaGroups.AUDIO[mediaGroup][label];
        if (!properties.uri) {
          defaultDemuxed = false;
        }
      }
    }
    if (defaultDemuxed) {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-demuxed"
      });
    }
    if (Object.keys(mediaGroups.SUBTITLES).length) {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-webvtt"
      });
    }
    if (Vhs$1.Playlist.isAes(media)) {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-aes"
      });
    }
    if (audioGroupKeys.length && Object.keys(mediaGroups.AUDIO[audioGroupKeys[0]]).length > 1) {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-alternate-audio"
      });
    }
    if (this.useCueTags_) {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-playlist-cue-tags"
      });
    }
  }
  shouldSwitchToMedia_(nextPlaylist) {
    const currentPlaylist = this.mainPlaylistLoader_.media() || this.mainPlaylistLoader_.pendingMedia_;
    const currentTime = this.tech_.currentTime();
    const bufferLowWaterLine = this.bufferLowWaterLine();
    const bufferHighWaterLine = this.bufferHighWaterLine();
    const buffered = this.tech_.buffered();
    return shouldSwitchToMedia({
      buffered,
      currentTime,
      currentPlaylist,
      nextPlaylist,
      bufferLowWaterLine,
      bufferHighWaterLine,
      duration: this.duration(),
      bufferBasedABR: this.bufferBasedABR,
      log: this.logger_
    });
  }
  setupSegmentLoaderListeners_() {
    this.mainSegmentLoader_.on("bandwidthupdate", () => {
      this.checkABR_("bandwidthupdate");
      this.tech_.trigger("bandwidthupdate");
    });
    this.mainSegmentLoader_.on("timeout", () => {
      if (this.bufferBasedABR) {
        this.mainSegmentLoader_.load();
      }
    });
    if (!this.bufferBasedABR) {
      this.mainSegmentLoader_.on("progress", () => {
        this.trigger("progress");
      });
    }
    this.mainSegmentLoader_.on("error", () => {
      const error = this.mainSegmentLoader_.error();
      this.excludePlaylist({
        playlistToExclude: error.playlist,
        error
      });
    });
    this.mainSegmentLoader_.on("appenderror", () => {
      this.error = this.mainSegmentLoader_.error_;
      this.trigger("error");
    });
    this.mainSegmentLoader_.on("syncinfoupdate", () => {
      this.onSyncInfoUpdate_();
    });
    this.mainSegmentLoader_.on("timestampoffset", () => {
      this.tech_.trigger({
        type: "usage",
        name: "vhs-timestamp-offset"
      });
    });
    this.audioSegmentLoader_.on("syncinfoupdate", () => {
      this.onSyncInfoUpdate_();
    });
    this.audioSegmentLoader_.on("appenderror", () => {
      this.error = this.audioSegmentLoader_.error_;
      this.trigger("error");
    });
    this.mainSegmentLoader_.on("ended", () => {
      this.logger_("main segment loader ended");
      this.onEndOfStream();
    });
    this.timelineChangeController_.on("audioTimelineBehind", () => {
      const segmentInfo = this.audioSegmentLoader_.pendingSegment_;
      if (!segmentInfo || !segmentInfo.segment || !segmentInfo.segment.syncInfo) {
        return;
      }
      const newTime = segmentInfo.segment.syncInfo.end + 0.01;
      this.tech_.setCurrentTime(newTime);
    });
    this.timelineChangeController_.on("fixBadTimelineChange", () => {
      this.logger_("Fix bad timeline change. Restarting al segment loaders...");
      this.mainSegmentLoader_.pause();
      this.mainSegmentLoader_.resetEverything();
      if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
        this.audioSegmentLoader_.pause();
        this.audioSegmentLoader_.resetEverything();
      }
      if (this.mediaTypes_.SUBTITLES.activePlaylistLoader) {
        this.subtitleSegmentLoader_.pause();
        this.subtitleSegmentLoader_.resetEverything();
      }
      this.load();
    });
    this.mainSegmentLoader_.on("earlyabort", (event) => {
      if (this.bufferBasedABR) {
        return;
      }
      this.delegateLoaders_("all", ["abort"]);
      this.excludePlaylist({
        error: {
          message: "Aborted early because there isn't enough bandwidth to complete the request without rebuffering."
        },
        playlistExclusionDuration: ABORT_EARLY_EXCLUSION_SECONDS
      });
    });
    const updateCodecs = () => {
      if (!this.sourceUpdater_.hasCreatedSourceBuffers()) {
        return this.tryToCreateSourceBuffers_();
      }
      const codecs = this.getCodecsOrExclude_();
      if (!codecs) {
        return;
      }
      this.sourceUpdater_.addOrChangeSourceBuffers(codecs);
    };
    this.mainSegmentLoader_.on("trackinfo", updateCodecs);
    this.audioSegmentLoader_.on("trackinfo", updateCodecs);
    this.mainSegmentLoader_.on("fmp4", () => {
      if (!this.triggeredFmp4Usage) {
        this.tech_.trigger({
          type: "usage",
          name: "vhs-fmp4"
        });
        this.triggeredFmp4Usage = true;
      }
    });
    this.audioSegmentLoader_.on("fmp4", () => {
      if (!this.triggeredFmp4Usage) {
        this.tech_.trigger({
          type: "usage",
          name: "vhs-fmp4"
        });
        this.triggeredFmp4Usage = true;
      }
    });
    this.audioSegmentLoader_.on("ended", () => {
      this.logger_("audioSegmentLoader ended");
      this.onEndOfStream();
    });
    const segmentLoaderEvents = ["segmentselected", "segmentloadstart", "segmentloaded", "segmentkeyloadstart", "segmentkeyloadcomplete", "segmentdecryptionstart", "segmentdecryptioncomplete", "segmenttransmuxingstart", "segmenttransmuxingcomplete", "segmenttransmuxingtrackinfoavailable", "segmenttransmuxingtiminginfoavailable", "segmentappendstart", "appendsdone", "bandwidthupdated", "timelinechange", "codecschange"];
    segmentLoaderEvents.forEach((eventName) => {
      this.mainSegmentLoader_.on(eventName, (metadata) => {
        this.player_.trigger(_extends({}, metadata));
      });
      this.audioSegmentLoader_.on(eventName, (metadata) => {
        this.player_.trigger(_extends({}, metadata));
      });
      this.subtitleSegmentLoader_.on(eventName, (metadata) => {
        this.player_.trigger(_extends({}, metadata));
      });
    });
  }
  mediaSecondsLoaded_() {
    return Math.max(this.audioSegmentLoader_.mediaSecondsLoaded + this.mainSegmentLoader_.mediaSecondsLoaded);
  }
  load() {
    this.mainSegmentLoader_.load();
    if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
      this.audioSegmentLoader_.load();
    }
    if (this.mediaTypes_.SUBTITLES.activePlaylistLoader) {
      this.subtitleSegmentLoader_.load();
    }
  }
  pause() {
    this.mainSegmentLoader_.pause();
    if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
      this.audioSegmentLoader_.pause();
    }
    if (this.mediaTypes_.SUBTITLES.activePlaylistLoader) {
      this.subtitleSegmentLoader_.pause();
    }
  }
  fastQualityChange_(media = this.selectPlaylist()) {
    if (media && media === this.mainPlaylistLoader_.media()) {
      this.logger_("skipping fastQualityChange because new media is same as old");
      return;
    }
    this.switchMedia_(media, "fast-quality");
    this.waitingForFastQualityPlaylistReceived_ = true;
  }
  runFastQualitySwitch_() {
    this.waitingForFastQualityPlaylistReceived_ = false;
    this.mainSegmentLoader_.pause();
    this.mainSegmentLoader_.resetEverything();
    if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
      this.audioSegmentLoader_.pause();
      this.audioSegmentLoader_.resetEverything();
    }
    if (this.mediaTypes_.SUBTITLES.activePlaylistLoader) {
      this.subtitleSegmentLoader_.pause();
      this.subtitleSegmentLoader_.resetEverything();
    }
    this.load();
  }
  play() {
    if (this.setupFirstPlay()) {
      return;
    }
    if (this.tech_.ended()) {
      this.tech_.setCurrentTime(0);
    }
    if (this.hasPlayed_) {
      this.load();
    }
    const seekable2 = this.tech_.seekable();
    if (this.tech_.duration() === Infinity) {
      if (this.tech_.currentTime() < seekable2.start(0)) {
        return this.tech_.setCurrentTime(seekable2.end(seekable2.length - 1));
      }
    }
  }
  setupFirstPlay() {
    const media = this.mainPlaylistLoader_.media();
    if (!media || this.tech_.paused() || this.hasPlayed_) {
      return false;
    }
    if (!media.endList || media.start) {
      const seekable2 = this.seekable();
      if (!seekable2.length) {
        return false;
      }
      const seekableEnd = seekable2.end(0);
      let startPoint = seekableEnd;
      if (media.start) {
        const offset = media.start.timeOffset;
        if (offset < 0) {
          startPoint = Math.max(seekableEnd + offset, seekable2.start(0));
        } else {
          startPoint = Math.min(seekableEnd, offset);
        }
      }
      this.trigger("firstplay");
      this.tech_.setCurrentTime(startPoint);
    }
    this.hasPlayed_ = true;
    this.load();
    return true;
  }
  handleSourceOpen_() {
    this.tryToCreateSourceBuffers_();
    if (this.tech_.autoplay()) {
      const playPromise = this.tech_.play();
      if (typeof playPromise !== "undefined" && typeof playPromise.then === "function") {
        playPromise.then(null, (e) => {
        });
      }
    }
    this.trigger("sourceopen");
  }
  handleSourceEnded_() {
    if (!this.inbandTextTracks_.metadataTrack_) {
      return;
    }
    const cues = this.inbandTextTracks_.metadataTrack_.cues;
    if (!cues || !cues.length) {
      return;
    }
    const duration2 = this.duration();
    cues[cues.length - 1].endTime = isNaN(duration2) || Math.abs(duration2) === Infinity ? Number.MAX_VALUE : duration2;
  }
  handleDurationChange_() {
    this.tech_.trigger("durationchange");
  }
  onEndOfStream() {
    let isEndOfStream = this.mainSegmentLoader_.ended_;
    if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
      const mainMediaInfo = this.mainSegmentLoader_.getCurrentMediaInfo_();
      if (!mainMediaInfo || mainMediaInfo.hasVideo) {
        isEndOfStream = isEndOfStream && this.audioSegmentLoader_.ended_;
      } else {
        isEndOfStream = this.audioSegmentLoader_.ended_;
      }
    }
    if (!isEndOfStream) {
      return;
    }
    this.stopABRTimer_();
    this.sourceUpdater_.endOfStream();
  }
  stuckAtPlaylistEnd_(playlist) {
    const seekable2 = this.seekable();
    if (!seekable2.length) {
      return false;
    }
    const expired = this.syncController_.getExpiredTime(playlist, this.duration());
    if (expired === null) {
      return false;
    }
    const absolutePlaylistEnd = Vhs$1.Playlist.playlistEnd(playlist, expired);
    const currentTime = this.tech_.currentTime();
    const buffered = this.tech_.buffered();
    if (!buffered.length) {
      return absolutePlaylistEnd - currentTime <= SAFE_TIME_DELTA;
    }
    const bufferedEnd = buffered.end(buffered.length - 1);
    return bufferedEnd - currentTime <= SAFE_TIME_DELTA && absolutePlaylistEnd - bufferedEnd <= SAFE_TIME_DELTA;
  }
  excludePlaylist({
    playlistToExclude = this.mainPlaylistLoader_.media(),
    error = {},
    playlistExclusionDuration
  }) {
    playlistToExclude = playlistToExclude || this.mainPlaylistLoader_.media();
    playlistExclusionDuration = playlistExclusionDuration || error.playlistExclusionDuration || this.playlistExclusionDuration;
    if (!playlistToExclude) {
      this.error = error;
      if (this.mediaSource.readyState !== "open") {
        this.trigger("error");
      } else {
        this.sourceUpdater_.endOfStream("network");
      }
      return;
    }
    playlistToExclude.playlistErrors_++;
    const playlists = this.mainPlaylistLoader_.main.playlists;
    const enabledPlaylists = playlists.filter(isEnabled);
    const isFinalRendition = enabledPlaylists.length === 1 && enabledPlaylists[0] === playlistToExclude;
    if (playlists.length === 1 && playlistExclusionDuration !== Infinity) {
      videojs.log.warn(`Problem encountered with playlist ${playlistToExclude.id}. Trying again since it is the only playlist.`);
      this.tech_.trigger("retryplaylist");
      return this.mainPlaylistLoader_.load(isFinalRendition);
    }
    if (isFinalRendition) {
      if (this.main().contentSteering) {
        const pathway = this.pathwayAttribute_(playlistToExclude);
        const reIncludeDelay = this.contentSteeringController_.steeringManifest.ttl * 1e3;
        this.contentSteeringController_.excludePathway(pathway);
        this.excludeThenChangePathway_();
        setTimeout(() => {
          this.contentSteeringController_.addAvailablePathway(pathway);
        }, reIncludeDelay);
        return;
      }
      let reincluded = false;
      playlists.forEach((playlist) => {
        if (playlist === playlistToExclude) {
          return;
        }
        const excludeUntil2 = playlist.excludeUntil;
        if (typeof excludeUntil2 !== "undefined" && excludeUntil2 !== Infinity) {
          reincluded = true;
          delete playlist.excludeUntil;
        }
      });
      if (reincluded) {
        videojs.log.warn("Removing other playlists from the exclusion list because the last rendition is about to be excluded.");
        this.tech_.trigger("retryplaylist");
      }
    }
    let excludeUntil;
    if (playlistToExclude.playlistErrors_ > this.maxPlaylistRetries) {
      excludeUntil = Infinity;
    } else {
      excludeUntil = Date.now() + playlistExclusionDuration * 1e3;
    }
    playlistToExclude.excludeUntil = excludeUntil;
    if (error.reason) {
      playlistToExclude.lastExcludeReason_ = error.reason;
    }
    this.tech_.trigger("excludeplaylist");
    this.tech_.trigger({
      type: "usage",
      name: "vhs-rendition-excluded"
    });
    const nextPlaylist = this.selectPlaylist();
    if (!nextPlaylist) {
      this.error = "Playback cannot continue. No available working or supported playlists.";
      this.trigger("error");
      return;
    }
    const logFn2 = error.internal ? this.logger_ : videojs.log.warn;
    const errorMessage = error.message ? " " + error.message : "";
    logFn2(`${error.internal ? "Internal problem" : "Problem"} encountered with playlist ${playlistToExclude.id}.${errorMessage} Switching to playlist ${nextPlaylist.id}.`);
    if (nextPlaylist.attributes.AUDIO !== playlistToExclude.attributes.AUDIO) {
      this.delegateLoaders_("audio", ["abort", "pause"]);
    }
    if (nextPlaylist.attributes.SUBTITLES !== playlistToExclude.attributes.SUBTITLES) {
      this.delegateLoaders_("subtitle", ["abort", "pause"]);
    }
    this.delegateLoaders_("main", ["abort", "pause"]);
    const delayDuration = nextPlaylist.targetDuration / 2 * 1e3 || 5 * 1e3;
    const shouldDelay = typeof nextPlaylist.lastRequest === "number" && Date.now() - nextPlaylist.lastRequest <= delayDuration;
    return this.switchMedia_(nextPlaylist, "exclude", isFinalRendition || shouldDelay);
  }
  pauseLoading() {
    this.delegateLoaders_("all", ["abort", "pause"]);
    this.stopABRTimer_();
  }
  delegateLoaders_(filter, fnNames) {
    const loaders = [];
    const dontFilterPlaylist = filter === "all";
    if (dontFilterPlaylist || filter === "main") {
      loaders.push(this.mainPlaylistLoader_);
    }
    const mediaTypes = [];
    if (dontFilterPlaylist || filter === "audio") {
      mediaTypes.push("AUDIO");
    }
    if (dontFilterPlaylist || filter === "subtitle") {
      mediaTypes.push("CLOSED-CAPTIONS");
      mediaTypes.push("SUBTITLES");
    }
    mediaTypes.forEach((mediaType) => {
      const loader = this.mediaTypes_[mediaType] && this.mediaTypes_[mediaType].activePlaylistLoader;
      if (loader) {
        loaders.push(loader);
      }
    });
    ["main", "audio", "subtitle"].forEach((name) => {
      const loader = this[`${name}SegmentLoader_`];
      if (loader && (filter === name || filter === "all")) {
        loaders.push(loader);
      }
    });
    loaders.forEach((loader) => fnNames.forEach((fnName) => {
      if (typeof loader[fnName] === "function") {
        loader[fnName]();
      }
    }));
  }
  setCurrentTime(currentTime) {
    const buffered = findRange(this.tech_.buffered(), currentTime);
    if (!(this.mainPlaylistLoader_ && this.mainPlaylistLoader_.media())) {
      return 0;
    }
    if (!this.mainPlaylistLoader_.media().segments) {
      return 0;
    }
    if (buffered && buffered.length) {
      return currentTime;
    }
    this.mainSegmentLoader_.pause();
    this.mainSegmentLoader_.resetEverything();
    if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
      this.audioSegmentLoader_.pause();
      this.audioSegmentLoader_.resetEverything();
    }
    if (this.mediaTypes_.SUBTITLES.activePlaylistLoader) {
      this.subtitleSegmentLoader_.pause();
      this.subtitleSegmentLoader_.resetEverything();
    }
    this.load();
  }
  duration() {
    if (!this.mainPlaylistLoader_) {
      return 0;
    }
    const media = this.mainPlaylistLoader_.media();
    if (!media) {
      return 0;
    }
    if (!media.endList) {
      return Infinity;
    }
    if (this.mediaSource) {
      return this.mediaSource.duration;
    }
    return Vhs$1.Playlist.duration(media);
  }
  seekable() {
    return this.seekable_;
  }
  getSeekableRange_(playlistLoader, mediaType) {
    const media = playlistLoader.media();
    if (!media) {
      return null;
    }
    const mediaSequenceSync = this.syncController_.getMediaSequenceSync(mediaType);
    if (mediaSequenceSync && mediaSequenceSync.isReliable) {
      const start = mediaSequenceSync.start;
      const end = mediaSequenceSync.end;
      if (!isFinite(start) || !isFinite(end)) {
        return null;
      }
      const liveEdgeDelay2 = Vhs$1.Playlist.liveEdgeDelay(this.mainPlaylistLoader_.main, media);
      const calculatedEnd = Math.max(start, end - liveEdgeDelay2);
      return createTimeRanges([[start, calculatedEnd]]);
    }
    const expired = this.syncController_.getExpiredTime(media, this.duration());
    if (expired === null) {
      return null;
    }
    const seekable2 = Vhs$1.Playlist.seekable(media, expired, Vhs$1.Playlist.liveEdgeDelay(this.mainPlaylistLoader_.main, media));
    return seekable2.length ? seekable2 : null;
  }
  computeFinalSeekable_(mainSeekable, audioSeekable) {
    if (!audioSeekable) {
      return mainSeekable;
    }
    const mainStart = mainSeekable.start(0);
    const mainEnd = mainSeekable.end(0);
    const audioStart = audioSeekable.start(0);
    const audioEnd = audioSeekable.end(0);
    if (audioStart > mainEnd || mainStart > audioEnd) {
      return mainSeekable;
    }
    return createTimeRanges([[Math.max(mainStart, audioStart), Math.min(mainEnd, audioEnd)]]);
  }
  onSyncInfoUpdate_() {
    if (!this.mainPlaylistLoader_) {
      return;
    }
    const mainSeekable = this.getSeekableRange_(this.mainPlaylistLoader_, "main");
    if (!mainSeekable) {
      return;
    }
    let audioSeekable;
    if (this.mediaTypes_.AUDIO.activePlaylistLoader) {
      audioSeekable = this.getSeekableRange_(this.mediaTypes_.AUDIO.activePlaylistLoader, "audio");
      if (!audioSeekable) {
        return;
      }
    }
    const oldSeekable = this.seekable_;
    this.seekable_ = this.computeFinalSeekable_(mainSeekable, audioSeekable);
    if (!this.seekable_) {
      return;
    }
    if (oldSeekable && oldSeekable.length && this.seekable_.length) {
      if (oldSeekable.start(0) === this.seekable_.start(0) && oldSeekable.end(0) === this.seekable_.end(0)) {
        return;
      }
    }
    this.logger_(`seekable updated [${printableRange(this.seekable_)}]`);
    const metadata = {
      seekableRanges: this.seekable_
    };
    this.trigger({
      type: "seekablerangeschanged",
      metadata
    });
    this.tech_.trigger("seekablechanged");
  }
  updateDuration(isLive) {
    if (this.updateDuration_) {
      this.mediaSource.removeEventListener("sourceopen", this.updateDuration_);
      this.updateDuration_ = null;
    }
    if (this.mediaSource.readyState !== "open") {
      this.updateDuration_ = this.updateDuration.bind(this, isLive);
      this.mediaSource.addEventListener("sourceopen", this.updateDuration_);
      return;
    }
    if (isLive) {
      const seekable2 = this.seekable();
      if (!seekable2.length) {
        return;
      }
      if (isNaN(this.mediaSource.duration) || this.mediaSource.duration < seekable2.end(seekable2.length - 1)) {
        this.sourceUpdater_.setDuration(seekable2.end(seekable2.length - 1));
      }
      return;
    }
    const buffered = this.tech_.buffered();
    let duration2 = Vhs$1.Playlist.duration(this.mainPlaylistLoader_.media());
    if (buffered.length > 0) {
      duration2 = Math.max(duration2, buffered.end(buffered.length - 1));
    }
    if (this.mediaSource.duration !== duration2) {
      this.sourceUpdater_.setDuration(duration2);
    }
  }
  dispose() {
    this.trigger("dispose");
    this.decrypter_.terminate();
    this.mainPlaylistLoader_.dispose();
    this.mainSegmentLoader_.dispose();
    this.contentSteeringController_.dispose();
    this.keyStatusMap_.clear();
    if (this.loadOnPlay_) {
      this.tech_.off("play", this.loadOnPlay_);
    }
    ["AUDIO", "SUBTITLES"].forEach((type) => {
      const groups = this.mediaTypes_[type].groups;
      for (const id in groups) {
        groups[id].forEach((group) => {
          if (group.playlistLoader) {
            group.playlistLoader.dispose();
          }
        });
      }
    });
    this.audioSegmentLoader_.dispose();
    this.subtitleSegmentLoader_.dispose();
    this.sourceUpdater_.dispose();
    this.timelineChangeController_.dispose();
    this.stopABRTimer_();
    if (this.updateDuration_) {
      this.mediaSource.removeEventListener("sourceopen", this.updateDuration_);
    }
    this.mediaSource.removeEventListener("durationchange", this.handleDurationChange_);
    this.mediaSource.removeEventListener("sourceopen", this.handleSourceOpen_);
    this.mediaSource.removeEventListener("sourceended", this.handleSourceEnded_);
    this.off();
  }
  main() {
    return this.mainPlaylistLoader_.main;
  }
  media() {
    return this.mainPlaylistLoader_.media() || this.initialMedia_;
  }
  areMediaTypesKnown_() {
    const usingAudioLoader = !!this.mediaTypes_.AUDIO.activePlaylistLoader;
    const hasMainMediaInfo = !!this.mainSegmentLoader_.getCurrentMediaInfo_();
    const hasAudioMediaInfo = !usingAudioLoader ? true : !!this.audioSegmentLoader_.getCurrentMediaInfo_();
    if (!hasMainMediaInfo || !hasAudioMediaInfo) {
      return false;
    }
    return true;
  }
  getCodecsOrExclude_() {
    const media = {
      main: this.mainSegmentLoader_.getCurrentMediaInfo_() || {},
      audio: this.audioSegmentLoader_.getCurrentMediaInfo_() || {}
    };
    const playlist = this.mainSegmentLoader_.getPendingSegmentPlaylist() || this.media();
    media.video = media.main;
    const playlistCodecs = codecsForPlaylist(this.main(), playlist);
    const codecs = {};
    const usingAudioLoader = !!this.mediaTypes_.AUDIO.activePlaylistLoader;
    if (media.main.hasVideo) {
      codecs.video = playlistCodecs.video || media.main.videoCodec || DEFAULT_VIDEO_CODEC;
    }
    if (media.main.isMuxed) {
      codecs.video += `,${playlistCodecs.audio || media.main.audioCodec || DEFAULT_AUDIO_CODEC}`;
    }
    if (media.main.hasAudio && !media.main.isMuxed || media.audio.hasAudio || usingAudioLoader) {
      codecs.audio = playlistCodecs.audio || media.main.audioCodec || media.audio.audioCodec || DEFAULT_AUDIO_CODEC;
      media.audio.isFmp4 = media.main.hasAudio && !media.main.isMuxed ? media.main.isFmp4 : media.audio.isFmp4;
    }
    if (!codecs.audio && !codecs.video) {
      this.excludePlaylist({
        playlistToExclude: playlist,
        error: {
          message: "Could not determine codecs for playlist."
        },
        playlistExclusionDuration: Infinity
      });
      return;
    }
    const supportFunction = (isFmp4, codec) => isFmp4 ? browserSupportsCodec(codec, this.usingManagedMediaSource_) : muxerSupportsCodec(codec);
    const unsupportedCodecs = {};
    let unsupportedAudio;
    ["video", "audio"].forEach(function(type) {
      if (codecs.hasOwnProperty(type) && !supportFunction(media[type].isFmp4, codecs[type])) {
        const supporter = media[type].isFmp4 ? "browser" : "muxer";
        unsupportedCodecs[supporter] = unsupportedCodecs[supporter] || [];
        unsupportedCodecs[supporter].push(codecs[type]);
        if (type === "audio") {
          unsupportedAudio = supporter;
        }
      }
    });
    if (usingAudioLoader && unsupportedAudio && playlist.attributes.AUDIO) {
      const audioGroup = playlist.attributes.AUDIO;
      this.main().playlists.forEach((variant) => {
        const variantAudioGroup = variant.attributes && variant.attributes.AUDIO;
        if (variantAudioGroup === audioGroup && variant !== playlist) {
          variant.excludeUntil = Infinity;
        }
      });
      this.logger_(`excluding audio group ${audioGroup} as ${unsupportedAudio} does not support codec(s): "${codecs.audio}"`);
    }
    if (Object.keys(unsupportedCodecs).length) {
      const message = Object.keys(unsupportedCodecs).reduce((acc, supporter) => {
        if (acc) {
          acc += ", ";
        }
        acc += `${supporter} does not support codec(s): "${unsupportedCodecs[supporter].join(",")}"`;
        return acc;
      }, "") + ".";
      this.excludePlaylist({
        playlistToExclude: playlist,
        error: {
          internal: true,
          message
        },
        playlistExclusionDuration: Infinity
      });
      return;
    }
    if (this.sourceUpdater_.hasCreatedSourceBuffers() && !this.sourceUpdater_.canChangeType()) {
      const switchMessages = [];
      ["video", "audio"].forEach((type) => {
        const newCodec = (parseCodecs(this.sourceUpdater_.codecs[type] || "")[0] || {}).type;
        const oldCodec = (parseCodecs(codecs[type] || "")[0] || {}).type;
        if (newCodec && oldCodec && newCodec.toLowerCase() !== oldCodec.toLowerCase()) {
          switchMessages.push(`"${this.sourceUpdater_.codecs[type]}" -> "${codecs[type]}"`);
        }
      });
      if (switchMessages.length) {
        this.excludePlaylist({
          playlistToExclude: playlist,
          error: {
            message: `Codec switching not supported: ${switchMessages.join(", ")}.`,
            internal: true
          },
          playlistExclusionDuration: Infinity
        });
        return;
      }
    }
    return codecs;
  }
  tryToCreateSourceBuffers_() {
    if (this.mediaSource.readyState !== "open" || this.sourceUpdater_.hasCreatedSourceBuffers()) {
      return;
    }
    if (!this.areMediaTypesKnown_()) {
      return;
    }
    const codecs = this.getCodecsOrExclude_();
    if (!codecs) {
      return;
    }
    this.sourceUpdater_.createSourceBuffers(codecs);
    const codecString = [codecs.video, codecs.audio].filter(Boolean).join(",");
    this.excludeIncompatibleVariants_(codecString);
  }
  excludeUnsupportedVariants_() {
    const playlists = this.main().playlists;
    const ids = [];
    Object.keys(playlists).forEach((key) => {
      const variant = playlists[key];
      if (ids.indexOf(variant.id) !== -1) {
        return;
      }
      ids.push(variant.id);
      const codecs = codecsForPlaylist(this.main, variant);
      const unsupported = [];
      if (codecs.audio && !muxerSupportsCodec(codecs.audio) && !browserSupportsCodec(codecs.audio, this.usingManagedMediaSource_)) {
        unsupported.push(`audio codec ${codecs.audio}`);
      }
      if (codecs.video && !muxerSupportsCodec(codecs.video) && !browserSupportsCodec(codecs.video, this.usingManagedMediaSource_)) {
        unsupported.push(`video codec ${codecs.video}`);
      }
      if (codecs.text && codecs.text === "stpp.ttml.im1t") {
        unsupported.push(`text codec ${codecs.text}`);
      }
      if (unsupported.length) {
        variant.excludeUntil = Infinity;
        this.logger_(`excluding ${variant.id} for unsupported: ${unsupported.join(", ")}`);
      }
    });
  }
  excludeIncompatibleVariants_(codecString) {
    const ids = [];
    const playlists = this.main().playlists;
    const codecs = unwrapCodecList(parseCodecs(codecString));
    const codecCount_ = codecCount(codecs);
    const videoDetails = codecs.video && parseCodecs(codecs.video)[0] || null;
    const audioDetails = codecs.audio && parseCodecs(codecs.audio)[0] || null;
    Object.keys(playlists).forEach((key) => {
      const variant = playlists[key];
      if (ids.indexOf(variant.id) !== -1 || variant.excludeUntil === Infinity) {
        return;
      }
      ids.push(variant.id);
      const exclusionReasons = [];
      const variantCodecs = codecsForPlaylist(this.mainPlaylistLoader_.main, variant);
      const variantCodecCount = codecCount(variantCodecs);
      if (!variantCodecs.audio && !variantCodecs.video) {
        return;
      }
      if (variantCodecCount !== codecCount_) {
        exclusionReasons.push(`codec count "${variantCodecCount}" !== "${codecCount_}"`);
      }
      if (!this.sourceUpdater_.canChangeType()) {
        const variantVideoDetails = variantCodecs.video && parseCodecs(variantCodecs.video)[0] || null;
        const variantAudioDetails = variantCodecs.audio && parseCodecs(variantCodecs.audio)[0] || null;
        if (variantVideoDetails && videoDetails && variantVideoDetails.type.toLowerCase() !== videoDetails.type.toLowerCase()) {
          exclusionReasons.push(`video codec "${variantVideoDetails.type}" !== "${videoDetails.type}"`);
        }
        if (variantAudioDetails && audioDetails && variantAudioDetails.type.toLowerCase() !== audioDetails.type.toLowerCase()) {
          exclusionReasons.push(`audio codec "${variantAudioDetails.type}" !== "${audioDetails.type}"`);
        }
      }
      if (exclusionReasons.length) {
        variant.excludeUntil = Infinity;
        this.logger_(`excluding ${variant.id}: ${exclusionReasons.join(" && ")}`);
      }
    });
  }
  updateAdCues_(media) {
    let offset = 0;
    const seekable2 = this.seekable();
    if (seekable2.length) {
      offset = seekable2.start(0);
    }
    updateAdCues(media, this.cueTagsTrack_, offset);
  }
  goalBufferLength() {
    const currentTime = this.tech_.currentTime();
    const initial = Config.GOAL_BUFFER_LENGTH;
    const rate = Config.GOAL_BUFFER_LENGTH_RATE;
    const max = Math.max(initial, Config.MAX_GOAL_BUFFER_LENGTH);
    return Math.min(initial + currentTime * rate, max);
  }
  bufferLowWaterLine() {
    const currentTime = this.tech_.currentTime();
    const initial = Config.BUFFER_LOW_WATER_LINE;
    const rate = Config.BUFFER_LOW_WATER_LINE_RATE;
    const max = Math.max(initial, Config.MAX_BUFFER_LOW_WATER_LINE);
    const newMax = Math.max(initial, Config.EXPERIMENTAL_MAX_BUFFER_LOW_WATER_LINE);
    return Math.min(initial + currentTime * rate, this.bufferBasedABR ? newMax : max);
  }
  bufferHighWaterLine() {
    return Config.BUFFER_HIGH_WATER_LINE;
  }
  addDateRangesToTextTrack_(dateRanges) {
    createMetadataTrackIfNotExists(this.inbandTextTracks_, "com.apple.streaming", this.tech_);
    addDateRangeMetadata({
      inbandTextTracks: this.inbandTextTracks_,
      dateRanges
    });
  }
  addMetadataToTextTrack(dispatchType, metadataArray, videoDuration) {
    const timestampOffset = this.sourceUpdater_.videoBuffer ? this.sourceUpdater_.videoTimestampOffset() : this.sourceUpdater_.audioTimestampOffset();
    createMetadataTrackIfNotExists(this.inbandTextTracks_, dispatchType, this.tech_);
    addMetadata({
      inbandTextTracks: this.inbandTextTracks_,
      metadataArray,
      timestampOffset,
      videoDuration
    });
  }
  pathwayAttribute_(playlist) {
    return playlist.attributes["PATHWAY-ID"] || playlist.attributes.serviceLocation;
  }
  initContentSteeringController_() {
    const main = this.main();
    if (!main.contentSteering) {
      return;
    }
    for (const playlist of main.playlists) {
      this.contentSteeringController_.addAvailablePathway(this.pathwayAttribute_(playlist));
    }
    this.contentSteeringController_.assignTagProperties(main.uri, main.contentSteering);
    if (this.contentSteeringController_.queryBeforeStart) {
      this.contentSteeringController_.requestSteeringManifest(true);
      return;
    }
    this.tech_.one("canplay", () => {
      this.contentSteeringController_.requestSteeringManifest();
    });
  }
  resetContentSteeringController_() {
    this.contentSteeringController_.clearAvailablePathways();
    this.contentSteeringController_.dispose();
    this.initContentSteeringController_();
  }
  attachContentSteeringListeners_() {
    this.contentSteeringController_.on("content-steering", this.excludeThenChangePathway_.bind(this));
    const contentSteeringEvents = ["contentsteeringloadstart", "contentsteeringloadcomplete", "contentsteeringparsed"];
    contentSteeringEvents.forEach((eventName) => {
      this.contentSteeringController_.on(eventName, (metadata) => {
        this.trigger(_extends({}, metadata));
      });
    });
    if (this.sourceType_ === "dash") {
      this.mainPlaylistLoader_.on("loadedplaylist", () => {
        const main = this.main();
        const didDashTagChange = this.contentSteeringController_.didDASHTagChange(main.uri, main.contentSteering);
        const didPathwaysChange = () => {
          const availablePathways = this.contentSteeringController_.getAvailablePathways();
          const newPathways = [];
          for (const playlist of main.playlists) {
            const serviceLocation = playlist.attributes.serviceLocation;
            if (serviceLocation) {
              newPathways.push(serviceLocation);
              if (!availablePathways.has(serviceLocation)) {
                return true;
              }
            }
          }
          if (!newPathways.length && availablePathways.size) {
            return true;
          }
          return false;
        };
        if (didDashTagChange || didPathwaysChange()) {
          this.resetContentSteeringController_();
        }
      });
    }
  }
  excludeThenChangePathway_() {
    const currentPathway = this.contentSteeringController_.getPathway();
    if (!currentPathway) {
      return;
    }
    this.handlePathwayClones_();
    const main = this.main();
    const playlists = main.playlists;
    const ids = /* @__PURE__ */ new Set();
    let didEnablePlaylists = false;
    Object.keys(playlists).forEach((key) => {
      const variant = playlists[key];
      const pathwayId = this.pathwayAttribute_(variant);
      const differentPathwayId = pathwayId && currentPathway !== pathwayId;
      const steeringExclusion = variant.excludeUntil === Infinity && variant.lastExcludeReason_ === "content-steering";
      if (steeringExclusion && !differentPathwayId) {
        delete variant.excludeUntil;
        delete variant.lastExcludeReason_;
        didEnablePlaylists = true;
      }
      const noExcludeUntil = !variant.excludeUntil && variant.excludeUntil !== Infinity;
      const shouldExclude = !ids.has(variant.id) && differentPathwayId && noExcludeUntil;
      if (!shouldExclude) {
        return;
      }
      ids.add(variant.id);
      variant.excludeUntil = Infinity;
      variant.lastExcludeReason_ = "content-steering";
      this.logger_(`excluding ${variant.id} for ${variant.lastExcludeReason_}`);
    });
    if (this.contentSteeringController_.manifestType_ === "DASH") {
      Object.keys(this.mediaTypes_).forEach((key) => {
        const type = this.mediaTypes_[key];
        if (type.activePlaylistLoader) {
          const currentPlaylist = type.activePlaylistLoader.media_;
          if (currentPlaylist && currentPlaylist.attributes.serviceLocation !== currentPathway) {
            didEnablePlaylists = true;
          }
        }
      });
    }
    if (didEnablePlaylists) {
      this.changeSegmentPathway_();
    }
  }
  handlePathwayClones_() {
    const main = this.main();
    const playlists = main.playlists;
    const currentPathwayClones = this.contentSteeringController_.currentPathwayClones;
    const nextPathwayClones = this.contentSteeringController_.nextPathwayClones;
    const hasClones = currentPathwayClones && currentPathwayClones.size || nextPathwayClones && nextPathwayClones.size;
    if (!hasClones) {
      return;
    }
    for (const [id, clone] of currentPathwayClones.entries()) {
      const newClone = nextPathwayClones.get(id);
      if (!newClone) {
        this.mainPlaylistLoader_.updateOrDeleteClone(clone);
        this.contentSteeringController_.excludePathway(id);
      }
    }
    for (const [id, clone] of nextPathwayClones.entries()) {
      const oldClone = currentPathwayClones.get(id);
      if (!oldClone) {
        const playlistsToClone = playlists.filter((p) => {
          return p.attributes["PATHWAY-ID"] === clone["BASE-ID"];
        });
        playlistsToClone.forEach((p) => {
          this.mainPlaylistLoader_.addClonePathway(clone, p);
        });
        this.contentSteeringController_.addAvailablePathway(id);
        continue;
      }
      if (this.equalPathwayClones_(oldClone, clone)) {
        continue;
      }
      this.mainPlaylistLoader_.updateOrDeleteClone(clone, true);
      this.contentSteeringController_.addAvailablePathway(id);
    }
    this.contentSteeringController_.currentPathwayClones = new Map(JSON.parse(JSON.stringify([...nextPathwayClones])));
  }
  equalPathwayClones_(a, b) {
    if (a["BASE-ID"] !== b["BASE-ID"] || a.ID !== b.ID || a["URI-REPLACEMENT"].HOST !== b["URI-REPLACEMENT"].HOST) {
      return false;
    }
    const aParams = a["URI-REPLACEMENT"].PARAMS;
    const bParams = b["URI-REPLACEMENT"].PARAMS;
    for (const p in aParams) {
      if (aParams[p] !== bParams[p]) {
        return false;
      }
    }
    for (const p in bParams) {
      if (aParams[p] !== bParams[p]) {
        return false;
      }
    }
    return true;
  }
  changeSegmentPathway_() {
    const nextPlaylist = this.selectPlaylist();
    this.pauseLoading();
    if (this.contentSteeringController_.manifestType_ === "DASH") {
      this.switchMediaForDASHContentSteering_();
    }
    this.switchMedia_(nextPlaylist, "content-steering");
  }
  excludeNonUsablePlaylistsByKeyId_() {
    if (!this.mainPlaylistLoader_ || !this.mainPlaylistLoader_.main) {
      return;
    }
    let nonUsableKeyStatusCount = 0;
    const NON_USABLE = "non-usable";
    this.mainPlaylistLoader_.main.playlists.forEach((playlist) => {
      const keyIdSet = this.mainPlaylistLoader_.getKeyIdSet(playlist);
      if (!keyIdSet || !keyIdSet.size) {
        return;
      }
      keyIdSet.forEach((key) => {
        const USABLE = "usable";
        const hasUsableKeyStatus = this.keyStatusMap_.has(key) && this.keyStatusMap_.get(key) === USABLE;
        const nonUsableExclusion = playlist.lastExcludeReason_ === NON_USABLE && playlist.excludeUntil === Infinity;
        if (!hasUsableKeyStatus) {
          if (playlist.excludeUntil !== Infinity && playlist.lastExcludeReason_ !== NON_USABLE) {
            playlist.excludeUntil = Infinity;
            playlist.lastExcludeReason_ = NON_USABLE;
            this.logger_(`excluding playlist ${playlist.id} because the key ID ${key} doesn't exist in the keyStatusMap or is not ${USABLE}`);
          }
          nonUsableKeyStatusCount++;
        } else if (hasUsableKeyStatus && nonUsableExclusion) {
          delete playlist.excludeUntil;
          delete playlist.lastExcludeReason_;
          this.logger_(`enabling playlist ${playlist.id} because key ID ${key} is ${USABLE}`);
        }
      });
    });
    if (nonUsableKeyStatusCount >= this.mainPlaylistLoader_.main.playlists.length) {
      this.mainPlaylistLoader_.main.playlists.forEach((playlist) => {
        const isNonHD = playlist && playlist.attributes && playlist.attributes.RESOLUTION && playlist.attributes.RESOLUTION.height < 720;
        const excludedForNonUsableKey = playlist.excludeUntil === Infinity && playlist.lastExcludeReason_ === NON_USABLE;
        if (isNonHD && excludedForNonUsableKey) {
          delete playlist.excludeUntil;
          videojs.log.warn(`enabling non-HD playlist ${playlist.id} because all playlists were excluded due to ${NON_USABLE} key IDs`);
        }
      });
    }
  }
  addKeyStatus_(keyId, status) {
    const isString = typeof keyId === "string";
    const keyIdHexString = isString ? keyId : bufferToHexString(keyId);
    const formattedKeyIdString = keyIdHexString.slice(0, 32).toLowerCase();
    this.logger_(`KeyStatus '${status}' with key ID ${formattedKeyIdString} added to the keyStatusMap`);
    this.keyStatusMap_.set(formattedKeyIdString, status);
  }
  updatePlaylistByKeyStatus(keyId, status) {
    this.addKeyStatus_(keyId, status);
    if (!this.waitingForFastQualityPlaylistReceived_) {
      this.excludeNonUsableThenChangePlaylist_();
    }
    this.mainPlaylistLoader_.off("loadedplaylist", this.excludeNonUsableThenChangePlaylist_.bind(this));
    this.mainPlaylistLoader_.on("loadedplaylist", this.excludeNonUsableThenChangePlaylist_.bind(this));
  }
  excludeNonUsableThenChangePlaylist_() {
    this.excludeNonUsablePlaylistsByKeyId_();
    this.fastQualityChange_();
  }
}
const enableFunction = (loader, playlistID, changePlaylistFn) => (enable) => {
  const playlist = loader.main.playlists[playlistID];
  const incompatible = isIncompatible(playlist);
  const currentlyEnabled = isEnabled(playlist);
  if (typeof enable === "undefined") {
    return currentlyEnabled;
  }
  if (enable) {
    delete playlist.disabled;
  } else {
    playlist.disabled = true;
  }
  const metadata = {
    renditionInfo: {
      id: playlistID,
      bandwidth: playlist.attributes.BANDWIDTH,
      resolution: playlist.attributes.RESOLUTION,
      codecs: playlist.attributes.CODECS
    },
    cause: "fast-quality"
  };
  if (enable !== currentlyEnabled && !incompatible) {
    if (enable) {
      changePlaylistFn(playlist);
      loader.trigger({
        type: "renditionenabled",
        metadata
      });
    } else {
      loader.trigger({
        type: "renditiondisabled",
        metadata
      });
    }
  }
  return enable;
};
class Representation {
  constructor(vhsHandler, playlist, id) {
    const {
      playlistController_: pc
    } = vhsHandler;
    const qualityChangeFunction = pc.fastQualityChange_.bind(pc);
    if (playlist.attributes) {
      const resolution = playlist.attributes.RESOLUTION;
      this.width = resolution && resolution.width;
      this.height = resolution && resolution.height;
      this.bandwidth = playlist.attributes.BANDWIDTH;
      this.frameRate = playlist.attributes["FRAME-RATE"];
    }
    this.codecs = codecsForPlaylist(pc.main(), playlist);
    this.playlist = playlist;
    this.id = id;
    this.enabled = enableFunction(vhsHandler.playlists, playlist.id, qualityChangeFunction);
  }
}
const renditionSelectionMixin = function(vhsHandler) {
  vhsHandler.representations = () => {
    const main = vhsHandler.playlistController_.main();
    const playlists = isAudioOnly(main) ? vhsHandler.playlistController_.getAudioTrackPlaylists_() : main.playlists;
    if (!playlists) {
      return [];
    }
    return playlists.filter((media) => !isIncompatible(media)).map((e, i) => new Representation(vhsHandler, e, e.id));
  };
};
const timerCancelEvents = ["seeking", "seeked", "pause", "playing", "error"];
class PlaybackWatcher extends videojs.EventTarget {
  constructor(options) {
    super();
    this.playlistController_ = options.playlistController;
    this.tech_ = options.tech;
    this.seekable = options.seekable;
    this.allowSeeksWithinUnsafeLiveWindow = options.allowSeeksWithinUnsafeLiveWindow;
    this.liveRangeSafeTimeDelta = options.liveRangeSafeTimeDelta;
    this.media = options.media;
    this.playedRanges_ = [];
    this.consecutiveUpdates = 0;
    this.lastRecordedTime = null;
    this.checkCurrentTimeTimeout_ = null;
    this.logger_ = logger("PlaybackWatcher");
    this.logger_("initialize");
    const playHandler = () => this.monitorCurrentTime_();
    const canPlayHandler = () => this.monitorCurrentTime_();
    const waitingHandler = () => this.techWaiting_();
    const cancelTimerHandler = () => this.resetTimeUpdate_();
    const pc = this.playlistController_;
    const loaderTypes = ["main", "subtitle", "audio"];
    const loaderChecks = {};
    loaderTypes.forEach((type) => {
      loaderChecks[type] = {
        reset: () => this.resetSegmentDownloads_(type),
        updateend: () => this.checkSegmentDownloads_(type)
      };
      pc[`${type}SegmentLoader_`].on("appendsdone", loaderChecks[type].updateend);
      pc[`${type}SegmentLoader_`].on("playlistupdate", loaderChecks[type].reset);
      this.tech_.on(["seeked", "seeking"], loaderChecks[type].reset);
    });
    const setSeekingHandlers = (fn) => {
      ["main", "audio"].forEach((type) => {
        pc[`${type}SegmentLoader_`][fn]("appended", this.seekingAppendCheck_);
      });
    };
    this.seekingAppendCheck_ = () => {
      if (this.fixesBadSeeks_()) {
        this.consecutiveUpdates = 0;
        this.lastRecordedTime = this.tech_.currentTime();
        setSeekingHandlers("off");
      }
    };
    this.clearSeekingAppendCheck_ = () => setSeekingHandlers("off");
    this.watchForBadSeeking_ = () => {
      this.clearSeekingAppendCheck_();
      setSeekingHandlers("on");
    };
    this.tech_.on("seeked", this.clearSeekingAppendCheck_);
    this.tech_.on("seeking", this.watchForBadSeeking_);
    this.tech_.on("waiting", waitingHandler);
    this.tech_.on(timerCancelEvents, cancelTimerHandler);
    this.tech_.on("canplay", canPlayHandler);
    this.tech_.one("play", playHandler);
    this.dispose = () => {
      this.clearSeekingAppendCheck_();
      this.logger_("dispose");
      this.tech_.off("waiting", waitingHandler);
      this.tech_.off(timerCancelEvents, cancelTimerHandler);
      this.tech_.off("canplay", canPlayHandler);
      this.tech_.off("play", playHandler);
      this.tech_.off("seeking", this.watchForBadSeeking_);
      this.tech_.off("seeked", this.clearSeekingAppendCheck_);
      loaderTypes.forEach((type) => {
        pc[`${type}SegmentLoader_`].off("appendsdone", loaderChecks[type].updateend);
        pc[`${type}SegmentLoader_`].off("playlistupdate", loaderChecks[type].reset);
        this.tech_.off(["seeked", "seeking"], loaderChecks[type].reset);
      });
      if (this.checkCurrentTimeTimeout_) {
        window_1.clearTimeout(this.checkCurrentTimeTimeout_);
      }
      this.resetTimeUpdate_();
    };
  }
  monitorCurrentTime_() {
    this.checkCurrentTime_();
    if (this.checkCurrentTimeTimeout_) {
      window_1.clearTimeout(this.checkCurrentTimeTimeout_);
    }
    this.checkCurrentTimeTimeout_ = window_1.setTimeout(this.monitorCurrentTime_.bind(this), 250);
  }
  resetSegmentDownloads_(type) {
    const loader = this.playlistController_[`${type}SegmentLoader_`];
    if (this[`${type}StalledDownloads_`] > 0) {
      this.logger_(`resetting possible stalled download count for ${type} loader`);
    }
    this[`${type}StalledDownloads_`] = 0;
    this[`${type}Buffered_`] = loader.buffered_();
  }
  checkSegmentDownloads_(type) {
    const pc = this.playlistController_;
    const loader = pc[`${type}SegmentLoader_`];
    const buffered = loader.buffered_();
    const isBufferedDifferent = isRangeDifferent(this[`${type}Buffered_`], buffered);
    this[`${type}Buffered_`] = buffered;
    if (isBufferedDifferent) {
      const metadata = {
        bufferedRanges: buffered
      };
      pc.trigger({
        type: "bufferedrangeschanged",
        metadata
      });
      this.resetSegmentDownloads_(type);
      return;
    }
    this[`${type}StalledDownloads_`]++;
    this.logger_(`found #${this[`${type}StalledDownloads_`]} ${type} appends that did not increase buffer (possible stalled download)`, {
      playlistId: loader.playlist_ && loader.playlist_.id,
      buffered: timeRangesToArray(buffered)
    });
    if (this[`${type}StalledDownloads_`] < 10) {
      return;
    }
    this.logger_(`${type} loader stalled download exclusion`);
    this.resetSegmentDownloads_(type);
    this.tech_.trigger({
      type: "usage",
      name: `vhs-${type}-download-exclusion`
    });
    if (type === "subtitle") {
      return;
    }
    pc.excludePlaylist({
      error: {
        message: `Excessive ${type} segment downloading detected.`
      },
      playlistExclusionDuration: Infinity
    });
  }
  checkCurrentTime_() {
    if (this.tech_.paused() || this.tech_.seeking()) {
      return;
    }
    const currentTime = this.tech_.currentTime();
    const buffered = this.tech_.buffered();
    if (this.lastRecordedTime === currentTime && (!buffered.length || currentTime + SAFE_TIME_DELTA >= buffered.end(buffered.length - 1))) {
      return this.techWaiting_();
    }
    if (this.consecutiveUpdates >= 5 && currentTime === this.lastRecordedTime) {
      this.consecutiveUpdates++;
      this.waiting_();
    } else if (currentTime === this.lastRecordedTime) {
      this.consecutiveUpdates++;
    } else {
      this.playedRanges_.push(createTimeRanges([this.lastRecordedTime, currentTime]));
      const metadata = {
        playedRanges: this.playedRanges_
      };
      this.playlistController_.trigger({
        type: "playedrangeschanged",
        metadata
      });
      this.consecutiveUpdates = 0;
      this.lastRecordedTime = currentTime;
    }
  }
  resetTimeUpdate_() {
    this.consecutiveUpdates = 0;
  }
  fixesBadSeeks_() {
    const seeking = this.tech_.seeking();
    if (!seeking) {
      return false;
    }
    const seekable2 = this.seekable();
    const currentTime = this.tech_.currentTime();
    const isAfterSeekableRange = this.afterSeekableWindow_(seekable2, currentTime, this.media(), this.allowSeeksWithinUnsafeLiveWindow);
    let seekTo;
    if (isAfterSeekableRange) {
      const seekableEnd = seekable2.end(seekable2.length - 1);
      seekTo = seekableEnd;
    }
    if (this.beforeSeekableWindow_(seekable2, currentTime)) {
      const seekableStart = seekable2.start(0);
      seekTo = seekableStart + (seekableStart === seekable2.end(0) ? 0 : SAFE_TIME_DELTA);
    }
    if (typeof seekTo !== "undefined") {
      this.logger_(`Trying to seek outside of seekable at time ${currentTime} with seekable range ${printableRange(seekable2)}. Seeking to ${seekTo}.`);
      this.tech_.setCurrentTime(seekTo);
      return true;
    }
    const sourceUpdater = this.playlistController_.sourceUpdater_;
    const buffered = this.tech_.buffered();
    const audioBuffered = sourceUpdater.audioBuffer ? sourceUpdater.audioBuffered() : null;
    const videoBuffered = sourceUpdater.videoBuffer ? sourceUpdater.videoBuffered() : null;
    const media = this.media();
    const minAppendedDuration = media.partTargetDuration ? media.partTargetDuration : (media.targetDuration - TIME_FUDGE_FACTOR) * 2;
    const bufferedToCheck = [audioBuffered, videoBuffered];
    for (let i = 0; i < bufferedToCheck.length; i++) {
      if (!bufferedToCheck[i]) {
        continue;
      }
      const timeAhead = timeAheadOf(bufferedToCheck[i], currentTime);
      if (timeAhead < minAppendedDuration) {
        return false;
      }
    }
    const nextRange = findNextRange(buffered, currentTime);
    if (nextRange.length === 0) {
      return false;
    }
    seekTo = nextRange.start(0) + SAFE_TIME_DELTA;
    this.logger_(`Buffered region starts (${nextRange.start(0)})  just beyond seek point (${currentTime}). Seeking to ${seekTo}.`);
    this.tech_.setCurrentTime(seekTo);
    return true;
  }
  waiting_() {
    if (this.techWaiting_()) {
      return;
    }
    const currentTime = this.tech_.currentTime();
    const buffered = this.tech_.buffered();
    const currentRange = findRange(buffered, currentTime);
    if (currentRange.length && currentTime + 3 <= currentRange.end(0)) {
      this.resetTimeUpdate_();
      this.tech_.setCurrentTime(currentTime);
      this.logger_(`Stopped at ${currentTime} while inside a buffered region [${currentRange.start(0)} -> ${currentRange.end(0)}]. Attempting to resume playback by seeking to the current time.`);
      this.tech_.trigger({
        type: "usage",
        name: "vhs-unknown-waiting"
      });
      return;
    }
  }
  techWaiting_() {
    const seekable2 = this.seekable();
    const currentTime = this.tech_.currentTime();
    if (this.tech_.seeking()) {
      return true;
    }
    if (this.beforeSeekableWindow_(seekable2, currentTime)) {
      const livePoint = seekable2.end(seekable2.length - 1);
      this.logger_(`Fell out of live window at time ${currentTime}. Seeking to live point (seekable end) ${livePoint}`);
      this.resetTimeUpdate_();
      this.tech_.setCurrentTime(livePoint);
      this.tech_.trigger({
        type: "usage",
        name: "vhs-live-resync"
      });
      return true;
    }
    const sourceUpdater = this.tech_.vhs.playlistController_.sourceUpdater_;
    const buffered = this.tech_.buffered();
    const videoUnderflow = this.videoUnderflow_({
      audioBuffered: sourceUpdater.audioBuffered(),
      videoBuffered: sourceUpdater.videoBuffered(),
      currentTime
    });
    if (videoUnderflow) {
      this.resetTimeUpdate_();
      this.tech_.setCurrentTime(currentTime);
      this.tech_.trigger({
        type: "usage",
        name: "vhs-video-underflow"
      });
      return true;
    }
    const nextRange = findNextRange(buffered, currentTime);
    if (nextRange.length > 0) {
      this.logger_(`Stopped at ${currentTime} and seeking to ${nextRange.start(0)}`);
      this.resetTimeUpdate_();
      this.skipTheGap_(currentTime);
      return true;
    }
    return false;
  }
  afterSeekableWindow_(seekable2, currentTime, playlist, allowSeeksWithinUnsafeLiveWindow = false) {
    if (!seekable2.length) {
      return false;
    }
    let allowedEnd = seekable2.end(seekable2.length - 1) + SAFE_TIME_DELTA;
    const isLive = !playlist.endList;
    const isLLHLS = typeof playlist.partTargetDuration === "number";
    if (isLive && (isLLHLS || allowSeeksWithinUnsafeLiveWindow)) {
      allowedEnd = seekable2.end(seekable2.length - 1) + playlist.targetDuration * 3;
    }
    if (currentTime > allowedEnd) {
      return true;
    }
    return false;
  }
  beforeSeekableWindow_(seekable2, currentTime) {
    if (seekable2.length && seekable2.start(0) > 0 && currentTime < seekable2.start(0) - this.liveRangeSafeTimeDelta) {
      return true;
    }
    return false;
  }
  videoUnderflow_({
    videoBuffered,
    audioBuffered,
    currentTime
  }) {
    if (!videoBuffered) {
      return;
    }
    let gap;
    if (videoBuffered.length && audioBuffered.length) {
      const lastVideoRange = findRange(videoBuffered, currentTime - 3);
      const videoRange = findRange(videoBuffered, currentTime);
      const audioRange = findRange(audioBuffered, currentTime);
      if (audioRange.length && !videoRange.length && lastVideoRange.length) {
        gap = {
          start: lastVideoRange.end(0),
          end: audioRange.end(0)
        };
      }
    } else {
      const nextRange = findNextRange(videoBuffered, currentTime);
      if (!nextRange.length) {
        gap = this.gapFromVideoUnderflow_(videoBuffered, currentTime);
      }
    }
    if (gap) {
      this.logger_(`Encountered a gap in video from ${gap.start} to ${gap.end}. Seeking to current time ${currentTime}`);
      return true;
    }
    return false;
  }
  skipTheGap_(scheduledCurrentTime) {
    const buffered = this.tech_.buffered();
    const currentTime = this.tech_.currentTime();
    const nextRange = findNextRange(buffered, currentTime);
    this.resetTimeUpdate_();
    if (nextRange.length === 0 || currentTime !== scheduledCurrentTime) {
      return;
    }
    this.logger_("skipTheGap_:", "currentTime:", currentTime, "scheduled currentTime:", scheduledCurrentTime, "nextRange start:", nextRange.start(0));
    this.tech_.setCurrentTime(nextRange.start(0) + TIME_FUDGE_FACTOR);
    const metadata = {
      gapInfo: {
        from: currentTime,
        to: nextRange.start(0)
      }
    };
    this.playlistController_.trigger({
      type: "gapjumped",
      metadata
    });
    this.tech_.trigger({
      type: "usage",
      name: "vhs-gap-skip"
    });
  }
  gapFromVideoUnderflow_(buffered, currentTime) {
    const gaps = findGaps(buffered);
    for (let i = 0; i < gaps.length; i++) {
      const start = gaps.start(i);
      const end = gaps.end(i);
      if (currentTime - start < 4 && currentTime - start > 2) {
        return {
          start,
          end
        };
      }
    }
    return null;
  }
}
const defaultOptions = {
  errorInterval: 30,
  getSource(next) {
    const tech = this.tech({
      IWillNotUseThisInPlugins: true
    });
    const sourceObj = tech.currentSource_ || this.currentSource();
    return next(sourceObj);
  }
};
const initPlugin = function(player, options) {
  let lastCalled = 0;
  let seekTo = 0;
  const localOptions = merge(defaultOptions, options);
  player.ready(() => {
    player.trigger({
      type: "usage",
      name: "vhs-error-reload-initialized"
    });
  });
  const loadedMetadataHandler = function() {
    if (seekTo) {
      player.currentTime(seekTo);
    }
  };
  const setSource2 = function(sourceObj) {
    if (sourceObj === null || sourceObj === void 0) {
      return;
    }
    seekTo = player.duration() !== Infinity && player.currentTime() || 0;
    player.one("loadedmetadata", loadedMetadataHandler);
    player.src(sourceObj);
    player.trigger({
      type: "usage",
      name: "vhs-error-reload"
    });
    player.play();
  };
  const errorHandler = function() {
    if (Date.now() - lastCalled < localOptions.errorInterval * 1e3) {
      player.trigger({
        type: "usage",
        name: "vhs-error-reload-canceled"
      });
      return;
    }
    if (!localOptions.getSource || typeof localOptions.getSource !== "function") {
      videojs.log.error("ERROR: reloadSourceOnError - The option getSource must be a function!");
      return;
    }
    lastCalled = Date.now();
    return localOptions.getSource.call(player, setSource2);
  };
  const cleanupEvents = function() {
    player.off("loadedmetadata", loadedMetadataHandler);
    player.off("error", errorHandler);
    player.off("dispose", cleanupEvents);
  };
  const reinitPlugin = function(newOptions) {
    cleanupEvents();
    initPlugin(player, newOptions);
  };
  player.on("error", errorHandler);
  player.on("dispose", cleanupEvents);
  player.reloadSourceOnError = reinitPlugin;
};
const reloadSourceOnError = function(options) {
  initPlugin(this, options);
};
var version$4 = "3.17.2";
var version$3 = "7.1.0";
var version$2 = "1.3.1";
var version$1 = "7.2.0";
var version = "4.0.2";
const Vhs = {
  PlaylistLoader,
  Playlist,
  utils,
  STANDARD_PLAYLIST_SELECTOR: lastBandwidthSelector,
  INITIAL_PLAYLIST_SELECTOR: lowestBitrateCompatibleVariantSelector,
  lastBandwidthSelector,
  movingAverageBandwidthSelector,
  comparePlaylistBandwidth,
  comparePlaylistResolution,
  xhr: xhrFactory()
};
Object.keys(Config).forEach((prop) => {
  Object.defineProperty(Vhs, prop, {
    get() {
      videojs.log.warn(`using Vhs.${prop} is UNSAFE be sure you know what you are doing`);
      return Config[prop];
    },
    set(value) {
      videojs.log.warn(`using Vhs.${prop} is UNSAFE be sure you know what you are doing`);
      if (typeof value !== "number" || value < 0) {